import{s as ua,o as pa,n as Kt}from"../chunks/scheduler.25b97de1.js";import{S as ga,i as ha,g as r,s,r as m,A as fa,h as l,f as n,c as a,j as x,u,x as d,k as $,y as i,a as o,v as p,d as g,t as h,w as f}from"../chunks/index.d9030fc9.js";import{T as as}from"../chunks/Tip.baa67368.js";import{D as z}from"../chunks/Docstring.ffac8efa.js";import{C}from"../chunks/CodeBlock.e6cd0d95.js";import{E as rs}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as J,E as Ma}from"../chunks/EditOnGithub.91d95064.js";function ya(G){let c,b="Example:",y,_,v;return _=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTXVzaWNnZW5NZWxvZHlQcm9jZXNzb3IlMEElMEFtb2RlbCUyMCUzRCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLW1lbG9keSUyMiklMEElMEElMjMlMjBnZXQlMjB0aGUlMjB1bmNvbmRpdGlvbmFsJTIwKG9yJTIwJ251bGwnKSUyMGlucHV0cyUyMGZvciUyMHRoZSUyMG1vZGVsJTBBcHJvY2Vzc29yJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQXVuY29uZGl0aW9uYWxfaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF91bmNvbmRpdGlvbmFsX2lucHV0cyhudW1fc2FtcGxlcyUzRDEpJTBBJTBBYXVkaW9fc2FtcGxlcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqdW5jb25kaXRpb25hbF9pbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenMelodyForConditionalGeneration, MusicgenMelodyProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get the unconditional (or &#x27;null&#x27;) inputs for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MusicgenMelodyProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unconditional_inputs = processor.get_unconditional_inputs(num_samples=<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_samples = model.generate(**unconditional_inputs, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){c=r("p"),c.textContent=b,y=s(),m(_.$$.fragment)},l(M){c=l(M,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=b),y=a(M),u(_.$$.fragment,M)},m(M,T){o(M,c,T),o(M,y,T),p(_,M,T),v=!0},p:Kt,i(M){v||(g(_.$$.fragment,M),v=!0)},o(M){h(_.$$.fragment,M),v=!1},d(M){M&&(n(c),n(y)),f(_,M)}}}function _a(G){let c,b="Example:",y,_,v;return _=new C({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    MusicgenMelodyConfig,
<span class="hljs-meta">... </span>    MusicgenMelodyDecoderConfig,
<span class="hljs-meta">... </span>    T5Config,
<span class="hljs-meta">... </span>    EncodecConfig,
<span class="hljs-meta">... </span>    MusicgenMelodyForConditionalGeneration,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing text encoder, audio encoder, and decoder model configurations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder_config = T5Config()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_encoder_config = EncodecConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_config = MusicgenMelodyDecoderConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MusicgenMelodyConfig.from_sub_models_config(
<span class="hljs-meta">... </span>    text_encoder_config, audio_encoder_config, decoder_config
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MusicgenMelodyForConditionalGeneration (with random weights) from the facebook/musicgen-melody style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text_encoder = model.config.text_encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_audio_encoder = model.config.audio_encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_decoder = model.config.decoder

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Saving the model, including its configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;musicgen_melody-model&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># loading model and config from pretrained folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>musicgen_melody_config = MusicgenMelodyConfig.from_pretrained(<span class="hljs-string">&quot;musicgen_melody-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;musicgen_melody-model&quot;</span>, config=musicgen_melody_config)`,wrap:!1}}),{c(){c=r("p"),c.textContent=b,y=s(),m(_.$$.fragment)},l(M){c=l(M,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=b),y=a(M),u(_.$$.fragment,M)},m(M,T){o(M,c,T),o(M,y,T),p(_,M,T),v=!0},p:Kt,i(M){v||(g(_.$$.fragment,M),v=!0)},o(M){h(_.$$.fragment,M),v=!1},d(M){M&&(n(c),n(y)),f(_,M)}}}function ba(G){let c,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=r("p"),c.innerHTML=b},l(y){c=l(y,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=b)},m(y,_){o(y,c,_)},p:Kt,d(y){y&&n(c)}}}function va(G){let c,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=r("p"),c.innerHTML=b},l(y){c=l(y,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=b)},m(y,_){o(y,c,_)},p:Kt,d(y){y&&n(c)}}}function Ta(G){let c,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=r("p"),c.innerHTML=b},l(y){c=l(y,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=b)},m(y,_){o(y,c,_)},p:Kt,d(y){y&&n(c)}}}function wa(G){let c,b="Examples:",y,_,v;return _=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1tZWxvZHklMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1tZWxvZHklMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlMjI4MHMlMjBwb3AlMjB0cmFjayUyMHdpdGglMjBiYXNzeSUyMGRydW1zJTIwYW5kJTIwc3ludGglMjIlMkMlMjAlMjI5MHMlMjByb2NrJTIwc29uZyUyMHdpdGglMjBsb3VkJTIwZ3VpdGFycyUyMGFuZCUyMGhlYXZ5JTIwZHJ1bXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMEEpJTBBJTBBcGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcucGFkX3Rva2VuX2lkJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwdG9yY2gub25lcygoaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjAlNUQlMjAqJTIwbW9kZWwuZGVjb2Rlci5udW1fY29kZWJvb2tzJTJDJTIwMSklMkMlMjBkdHlwZSUzRHRvcmNoLmxvbmcpJTBBJTIwJTIwJTIwJTIwKiUyMHBhZF90b2tlbl9pZCUwQSklMEElMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGRlY29kZXJfaW5wdXRfaWRzJTNEZGVjb2Rlcl9pbnB1dF9pZHMpLmxvZ2l0cyUwQWxvZ2l0cy5zaGFwZSUyMCUyMCUyMyUyMChic3olMjAqJTIwbnVtX2NvZGVib29rcyUyQyUyMGVuY29kZXJfbGVuJTIwJTJCJTIwdGd0X2xlbiUyQyUyMHZvY2FiX3NpemUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pad_token_id = model.generation_config.pad_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = (
<span class="hljs-meta">... </span>    torch.ones((inputs.input_ids.shape[<span class="hljs-number">0</span>] * model.decoder.num_codebooks, <span class="hljs-number">1</span>), dtype=torch.long)
<span class="hljs-meta">... </span>    * pad_token_id
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs, decoder_input_ids=decoder_input_ids).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits.shape  <span class="hljs-comment"># (bsz * num_codebooks, encoder_len + tgt_len, vocab_size)</span>
torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">249</span>, <span class="hljs-number">2048</span>])`,wrap:!1}}),{c(){c=r("p"),c.textContent=b,y=s(),m(_.$$.fragment)},l(M){c=l(M,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=b),y=a(M),u(_.$$.fragment,M)},m(M,T){o(M,c,T),o(M,y,T),p(_,M,T),v=!0},p:Kt,i(M){v||(g(_.$$.fragment,M),v=!0)},o(M){h(_.$$.fragment,M),v=!1},d(M){M&&(n(c),n(y)),f(_,M)}}}function ka(G){let c,b,y,_,v,M,T,tn,oe,ls='The MusicGen Melody model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi and Alexandre Défossez.',nn,se,is="MusicGen Melody is a single stage auto-regressive Transformer model capable of generating high-quality music samples conditioned on text descriptions or audio prompts. The text descriptions are passed through a frozen text encoder model to obtain a sequence of hidden-state representations. MusicGen is then trained to predict discrete audio tokens, or <em>audio codes</em>, conditioned on these hidden-states. These audio tokens are then decoded using an audio compression model, such as EnCodec, to recover the audio waveform.",on,ae,ds="Through an efficient token interleaving pattern, MusicGen does not require a self-supervised semantic representation of the text/audio prompts, thus eliminating the need to cascade multiple models to predict a set of codebooks (e.g. hierarchically or upsampling). Instead, it is able to generate all the codebooks in a single forward pass.",sn,re,cs="The abstract from the paper is the following:",an,le,ms="<em>We tackle the task of conditional music generation. We introduce MusicGen, a single Language Model (LM) that operates over several streams of compressed discrete music representation, i.e., tokens. Unlike prior work, MusicGen is comprised of a single-stage transformer LM together with efficient token interleaving patterns, which eliminates the need for cascading several models, e.g., hierarchically or upsampling. Following this approach, we demonstrate how MusicGen can generate high-quality samples, while being conditioned on textual description or melodic features, allowing better controls over the generated output. We conduct extensive empirical evaluation, considering both automatic and human studies, showing the proposed approach is superior to the evaluated baselines on a standard text-to-music benchmark. Through ablation studies, we shed light over the importance of each of the components comprising MusicGen.</em>",rn,ie,us='This model was contributed by <a href="https://huggingface.co/ylacombe" rel="nofollow">ylacombe</a>. The original code can be found <a href="https://github.com/facebookresearch/audiocraft" rel="nofollow">here</a>. The pre-trained checkpoints can be found on the <a href="https://huggingface.co/models?sort=downloads&amp;search=facebook%2Fmusicgen" rel="nofollow">Hugging Face Hub</a>.',ln,de,dn,ce,ps="There are two key differences with MusicGen:",cn,me,gs='<li>The audio prompt is used here as a conditional signal for the generated audio sample, whereas it’s used for audio continuation in <a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>.</li> <li>Conditional text and audio signals are concatenated to the decoder’s hidden states instead of being used as a cross-attention signal, as in MusicGen.</li>',mn,ue,un,pe,hs="MusicGen Melody is compatible with two generation modes: greedy and sampling. In practice, sampling leads to significantly better results than greedy, thus we encourage sampling mode to be used where possible. Sampling is enabled by default, and can be explicitly specified by setting <code>do_sample=True</code> in the call to <code>MusicgenMelodyForConditionalGeneration.generate()</code>, or by overriding the model’s generation config (see below).",pn,ge,fs="Transformers supports both mono (1-channel) and stereo (2-channel) variants of MusicGen Melody. The mono channel versions generate a single set of codebooks. The stereo versions generate 2 sets of codebooks, 1 for each channel (left/right), and each set of codebooks is decoded independently through the audio compression model. The audio streams for each channel are combined to give the final stereo output.",gn,he,hn,fe,Ms='The model can generate an audio sample conditioned on a text and an audio prompt through use of the <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyProcessor">MusicgenMelodyProcessor</a> to pre-process the inputs.',fn,Me,ys="In the following examples, we load an audio file using the 🤗 Datasets library, which can be pip installed through the command below:",Mn,ye,yn,_e,_s="The audio file we are about to use is loaded as follows:",_n,be,bn,ve,bs='The audio prompt should ideally be free of the low-frequency signals usually produced by instruments such as drums and bass. The <a href="https://github.com/adefossez/demucs/tree/main" rel="nofollow">Demucs</a> model can be used to separate vocals and other signals from the drums and bass components.',vn,Te,vs='If you wish to use Demucs, you first need to follow the installation steps <a href="https://github.com/adefossez/demucs/tree/main?tab=readme-ov-file#for-musicians" rel="nofollow">here</a> before using the following snippet:',Tn,we,wn,ke,Ts="You can then use the following snippet to generate music:",kn,je,jn,Je,ws="You can also pass the audio signal directly without using Demucs, although the quality of the generation will probably be degraded:",Jn,Ce,Cn,Ze,ks="The audio outputs are a three-dimensional Torch tensor of shape <code>(batch_size, num_channels, sequence_length)</code>. To listen to the generated audio samples, you can either play them in an ipynb notebook:",Zn,Ue,Un,xe,js="Or save them as a <code>.wav</code> file using a third-party library, e.g. <code>soundfile</code>:",xn,$e,$n,Ge,Gn,We,Js='The same <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyProcessor">MusicgenMelodyProcessor</a> can be used to pre-process a text-only prompt.',Wn,Fe,Fn,Ve,Cs="The <code>guidance_scale</code> is used in classifier free guidance (CFG), setting the weighting between the conditional logits (which are predicted from the text prompts) and the unconditional logits (which are predicted from an unconditional or ‘null’ prompt). Higher guidance scale encourages the model to generate samples that are more closely linked to the input prompt, usually at the expense of poorer audio quality. CFG is enabled by setting <code>guidance_scale &gt; 1</code>. For best results, use <code>guidance_scale=3</code> (default).",Vn,ze,Zs="You can also generate in batch:",zn,Ne,Nn,Ie,In,Re,Us='The inputs for unconditional (or ‘null’) generation can be obtained through the method <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyProcessor.get_unconditional_inputs">MusicgenMelodyProcessor.get_unconditional_inputs()</a>:',Rn,Be,Bn,Xe,Xn,He,xs="The default parameters that control the generation process, such as sampling, guidance scale and number of generated tokens, can be found in the model’s generation config, and updated as desired:",Hn,Ee,En,qe,$s="Note that any arguments passed to the generate method will <strong>supersede</strong> those in the generation config, so setting <code>do_sample=False</code> in the call to generate will supersede the setting of <code>model.generation_config.do_sample</code> in the generation config.",qn,Ye,Yn,Le,Gs="The MusicGen model can be de-composed into three distinct stages:",Ln,Qe,Ws="<li>Text encoder: maps the text inputs to a sequence of hidden-state representations. The pre-trained MusicGen models use a frozen text encoder from either T5 or Flan-T5.</li> <li>MusicGen Melody decoder: a language model (LM) that auto-regressively generates audio tokens (or codes) conditional on the encoder hidden-state representations</li> <li>Audio decoder: used to recover the audio waveform from the audio tokens predicted by the decoder.</li>",Qn,Se,Fs='Thus, the MusicGen model can either be used as a standalone decoder model, corresponding to the class <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForCausalLM">MusicgenMelodyForCausalLM</a>, or as a composite model that includes the text encoder and audio encoder, corresponding to the class <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForConditionalGeneration">MusicgenMelodyForConditionalGeneration</a>. If only the decoder needs to be loaded from the pre-trained checkpoint, it can be loaded by first specifying the correct config, or be accessed through the <code>.decoder</code> attribute of the composite model:',Sn,Pe,Pn,De,Vs='Since the text encoder and audio encoder models are frozen during training, the MusicGen decoder <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForCausalLM">MusicgenMelodyForCausalLM</a> can be trained standalone on a dataset of encoder hidden-states and audio codes. For inference, the trained decoder can be combined with the frozen text encoder and audio encoder to recover the composite <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForConditionalGeneration">MusicgenMelodyForConditionalGeneration</a> model.',Dn,Ae,An,Oe,zs='<li>After downloading the original checkpoints from <a href="https://github.com/facebookresearch/audiocraft/blob/main/docs/MUSICGEN.md#importing--exporting-models" rel="nofollow">here</a>, you can convert them using the <strong>conversion script</strong> available at <code>src/transformers/models/musicgen_melody/convert_musicgen_melody_transformers.py</code> with the following command:</li>',On,Ke,Kn,et,Ns="Tips:",eo,tt,Is="<li>MusicGen is trained on the 32kHz checkpoint of Encodec. You should ensure you use a compatible version of the Encodec model.</li> <li>Sampling mode tends to deliver better results than greedy - you can toggle sampling with the variable <code>do_sample</code> in the call to <code>MusicgenMelodyForConditionalGeneration.generate()</code></li>",to,nt,no,X,ot,bo,kt,Rs=`This is the configuration class to store the configuration of an <code>MusicgenMelodyDecoder</code>. It is used to instantiate a
Musicgen Melody decoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Musicgen Melody
<a href="https://huggingface.co/facebook/musicgen-melody" rel="nofollow">facebook/musicgen-melody</a> architecture.`,vo,jt,Bs=`Configuration objects inherit from <a href="/docs/transformers/v4.42.4/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.42.4/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,oo,st,so,W,at,To,Jt,Xs=`Constructs a MusicGen Melody processor which wraps a Wav2Vec2 feature extractor - for raw audio waveform processing - and a T5 tokenizer into a single processor
class.`,wo,Ct,Hs=`<a href="/docs/transformers/v4.42.4/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> offers all the functionalities of <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyFeatureExtractor">MusicgenMelodyFeatureExtractor</a> and <a href="/docs/transformers/v4.42.4/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a>. See
<code>__call__()</code> and <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen#transformers.MusicgenProcessor.decode">decode()</a> for more information.`,ko,E,rt,jo,Zt,Es=`Helper function to get null inputs for unconditional generation, enabling the model to be used without the
feature extractor or tokenizer.`,Jo,S,ao,lt,ro,Z,it,Co,Ut,qs="Constructs a MusicgenMelody feature extractor.",Zo,xt,Ys=`This feature extractor inherits from <a href="/docs/transformers/v4.42.4/en/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a> which contains
most of the main methods. Users should refer to this superclass for more information regarding those methods.`,Uo,$t,Ls=`This class extracts chroma features from audio processed by <a href="https://github.com/adefossez/demucs/tree/main" rel="nofollow">Demucs</a> or
directly from raw audio waveform.`,xo,P,dt,$o,Gt,Qs=`Extracts stems from the output of the <a href="https://github.com/adefossez/demucs/tree/main" rel="nofollow">Demucs</a> audio separation model,
then converts to mono-channel and resample to the feature extractor sampling rate.`,lo,ct,io,U,mt,Go,Wt,Ss=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyModel">MusicgenMelodyModel</a>. It is used to instantiate a
Musicgen Melody model according to the specified arguments, defining the text encoder, audio encoder and Musicgen Melody decoder
configs. Instantiating a configuration with the defaults will yield a similar configuration to that of the Musicgen Melody
<a href="https://huggingface.co/facebook/musicgen-melody" rel="nofollow">facebook/musicgen-melody</a> architecture.`,Wo,Ft,Ps=`Configuration objects inherit from <a href="/docs/transformers/v4.42.4/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.42.4/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Fo,D,Vo,A,ut,zo,Vt,Ds=`Instantiate a <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig">MusicgenMelodyConfig</a> (or a derived class) from text encoder, audio encoder and decoder
configurations.`,co,pt,mo,w,gt,No,zt,As="The bare MusicgenMelody decoder model outputting raw hidden-states without any specific head on top.",Io,Nt,Os=`The Musicgen Melody model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is a
decoder-only transformer trained on the task of conditional music generation.`,Ro,It,Ks=`This model inherits from <a href="/docs/transformers/v4.42.4/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Bo,Rt,ea=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Xo,q,ht,Ho,Bt,ta='The <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyModel">MusicgenMelodyModel</a> forward method, overrides the <code>__call__</code> special method.',Eo,O,uo,ft,po,k,Mt,qo,Xt,na="The Musicgen Melody decoder model with a language modelling head on top.",Yo,Ht,oa=`The Musicgen Melody model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is a
decoder-only transformer trained on the task of conditional music generation.`,Lo,Et,sa=`This model inherits from <a href="/docs/transformers/v4.42.4/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Qo,qt,aa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,So,Y,yt,Po,Yt,ra='The <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForCausalLM">MusicgenMelodyForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Do,K,go,_t,ho,j,bt,Ao,Lt,la="The composite Musicgen Melody model with a text and audio conditional models, a MusicgenMelody decoder and an audio encoder, for music generation tasks with one or both of text and audio prompts.",Oo,Qt,ia=`The Musicgen Melody model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is a
decoder-only transformer trained on the task of conditional music generation.`,Ko,St,da=`This model inherits from <a href="/docs/transformers/v4.42.4/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,es,Pt,ca=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ts,N,vt,ns,Dt,ma='The <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForConditionalGeneration">MusicgenMelodyForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',os,ee,ss,te,fo,Tt,Mo,en,yo;return v=new J({props:{title:"MusicGen Melody",local:"musicgen-melody",headingTag:"h1"}}),T=new J({props:{title:"Overview",local:"overview",headingTag:"h2"}}),de=new J({props:{title:"Difference with MusicGen",local:"difference-with-musicgen",headingTag:"h2"}}),ue=new J({props:{title:"Generation",local:"generation",headingTag:"h2"}}),he=new J({props:{title:"Audio Conditional Generation",local:"audio-conditional-generation",headingTag:"h4"}}),ye=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHBpcCUwQXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyU1QmF1ZGlvJTVE",highlighted:`pip <span class="hljs-keyword">install</span> --upgrade pip
pip <span class="hljs-keyword">install</span> datasets[audio]`,wrap:!1}}),be=new C({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzYW5jaGl0LWdhbmRoaSUyRmd0emFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBc2FtcGxlJTIwJTNEJTIwbmV4dChpdGVyKGRhdGFzZXQpKSU1QiUyMmF1ZGlvJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;sanchit-gandhi/gtzan&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>]`,wrap:!1}}),we=new C({props:{code:"ZnJvbSUyMGRlbXVjcyUyMGltcG9ydCUyMHByZXRyYWluZWQlMEFmcm9tJTIwZGVtdWNzLmFwcGx5JTIwaW1wb3J0JTIwYXBwbHlfbW9kZWwlMEFmcm9tJTIwZGVtdWNzLmF1ZGlvJTIwaW1wb3J0JTIwY29udmVydF9hdWRpbyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBJTBBd2F2JTIwJTNEJTIwdG9yY2gudGVuc29yKHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEKS50byh0b3JjaC5mbG9hdDMyKSUwQSUwQWRlbXVjcyUyMCUzRCUyMHByZXRyYWluZWQuZ2V0X21vZGVsKCdodGRlbXVjcycpJTBBJTBBd2F2JTIwJTNEJTIwY29udmVydF9hdWRpbyh3YXYlNUJOb25lJTVEJTJDJTIwc2FtcGxlJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUyMGRlbXVjcy5zYW1wbGVyYXRlJTJDJTIwZGVtdWNzLmF1ZGlvX2NoYW5uZWxzKSUwQXdhdiUyMCUzRCUyMGFwcGx5X21vZGVsKGRlbXVjcyUyQyUyMHdhdiU1Qk5vbmUlNUQp",highlighted:`<span class="hljs-keyword">from</span> demucs <span class="hljs-keyword">import</span> pretrained
<span class="hljs-keyword">from</span> demucs.apply <span class="hljs-keyword">import</span> apply_model
<span class="hljs-keyword">from</span> demucs.audio <span class="hljs-keyword">import</span> convert_audio
<span class="hljs-keyword">import</span> torch


wav = torch.tensor(sample[<span class="hljs-string">&quot;array&quot;</span>]).to(torch.float32)

demucs = pretrained.get_model(<span class="hljs-string">&#x27;htdemucs&#x27;</span>)

wav = convert_audio(wav[<span class="hljs-literal">None</span>], sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>], demucs.samplerate, demucs.audio_channels)
wav = apply_model(demucs, wav[<span class="hljs-literal">None</span>])`,wrap:!1}}),je=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBhdWRpbyUzRHdhdiUyQyUwQSUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RkZW11Y3Muc2FtcGxlcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlMjI4MHMlMjBibHVlcyUyMHRyYWNrJTIwd2l0aCUyMGdyb292eSUyMHNheG9waG9uZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=wav,
<span class="hljs-meta">... </span>    sampling_rate=demucs.samplerate,
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Ce=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBhdWRpbyUzRHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsZSU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwYmx1ZXMlMjB0cmFjayUyMHdpdGglMjBncm9vdnklMjBzYXhvcGhvbmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMEEpJTBBYXVkaW9fdmFsdWVzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=sample[<span class="hljs-string">&quot;array&quot;</span>],
<span class="hljs-meta">... </span>    sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Ue=new C({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5hdWRpb19lbmNvZGVyLnNhbXBsaW5nX3JhdGUlMEFBdWRpbyhhdWRpb192YWx1ZXMlNUIwJTVELm51bXB5KCklMkMlMjByYXRlJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sampling_rate = model.config.audio_encoder.sampling_rate
Audio(audio_values[<span class="hljs-number">0</span>].numpy(), rate=sampling_rate)`,wrap:!1}}),$e=new C({props:{code:"aW1wb3J0JTIwc291bmRmaWxlJTIwYXMlMjBzZiUwQSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBtb2RlbC5jb25maWcuYXVkaW9fZW5jb2Rlci5zYW1wbGluZ19yYXRlJTBBc2Yud3JpdGUoJTIybXVzaWNnZW5fb3V0LndhdiUyMiUyQyUyMGF1ZGlvX3ZhbHVlcyU1QjAlNUQuVC5udW1weSgpJTJDJTIwc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = model.config.audio_encoder.sampling_rate
<span class="hljs-meta">&gt;&gt;&gt; </span>sf.write(<span class="hljs-string">&quot;musicgen_out.wav&quot;</span>, audio_values[<span class="hljs-number">0</span>].T.numpy(), sampling_rate)`,wrap:!1}}),Ge=new J({props:{title:"Text-only Conditional Generation",local:"text-only-conditional-generation",headingTag:"h3"}}),Fe=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwcG9wJTIwdHJhY2slMjB3aXRoJTIwYmFzc3klMjBkcnVtcyUyMGFuZCUyMHN5bnRoJTIyJTJDJTIwJTIyOTBzJTIwcm9jayUyMHNvbmclMjB3aXRoJTIwbG91ZCUyMGd1aXRhcnMlMjBhbmQlMjBoZWF2eSUyMGRydW1zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQWF1ZGlvX3ZhbHVlcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Ne=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQSUwQSUyMyUyMHRha2UlMjB0aGUlMjBmaXJzdCUyMHF1YXJ0ZXIlMjBvZiUyMHRoZSUyMGF1ZGlvJTIwc2FtcGxlJTBBc2FtcGxlXzElMjAlM0QlMjBzYW1wbGUlNUIlMjJhcnJheSUyMiU1RCU1QiUzQSUyMGxlbihzYW1wbGUlNUIlMjJhcnJheSUyMiU1RCklMjAlMkYlMkYlMjA0JTVEJTBBJTBBJTIzJTIwdGFrZSUyMHRoZSUyMGZpcnN0JTIwaGFsZiUyMG9mJTIwdGhlJTIwYXVkaW8lMjBzYW1wbGUlMEFzYW1wbGVfMiUyMCUzRCUyMHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTVCJTNBJTIwbGVuKHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEKSUyMCUyRiUyRiUyMDIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwYXVkaW8lM0QlNUJzYW1wbGVfMSUyQyUyMHNhbXBsZV8yJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsZSU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwYmx1ZXMlMjB0cmFjayUyMHdpdGglMjBncm9vdnklMjBzYXhvcGhvbmUlMjIlMkMlMjAlMjI5MHMlMjByb2NrJTIwc29uZyUyMHdpdGglMjBsb3VkJTIwZ3VpdGFycyUyMGFuZCUyMGhlYXZ5JTIwZHJ1bXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMEEpJTBBYXVkaW9fdmFsdWVzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first quarter of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_1 = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">4</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first half of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_2 = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=[sample_1, sample_2],
<span class="hljs-meta">... </span>    sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Ie=new J({props:{title:"Unconditional Generation",local:"unconditional-generation",headingTag:"h3"}}),Be=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTXVzaWNnZW5NZWxvZHlQcm9jZXNzb3IlMEElMEFtb2RlbCUyMCUzRCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLW1lbG9keSUyMiklMEF1bmNvbmRpdGlvbmFsX2lucHV0cyUyMCUzRCUyME11c2ljZ2VuTWVsb2R5UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLW1lbG9keSUyMikuZ2V0X3VuY29uZGl0aW9uYWxfaW5wdXRzKG51bV9zYW1wbGVzJTNEMSklMEElMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKnVuY29uZGl0aW9uYWxfaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenMelodyForConditionalGeneration, MusicgenMelodyProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unconditional_inputs = MusicgenMelodyProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>).get_unconditional_inputs(num_samples=<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**unconditional_inputs, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Xe=new J({props:{title:"Generation Configuration",local:"generation-configuration",headingTag:"h3"}}),Ee=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1tZWxvZHklMjIpJTBBJTBBJTIzJTIwaW5zcGVjdCUyMHRoZSUyMGRlZmF1bHQlMjBnZW5lcmF0aW9uJTIwY29uZmlnJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWclMEElMEElMjMlMjBpbmNyZWFzZSUyMHRoZSUyMGd1aWRhbmNlJTIwc2NhbGUlMjB0byUyMDQuMCUwQW1vZGVsLmdlbmVyYXRpb25fY29uZmlnLmd1aWRhbmNlX3NjYWxlJTIwJTNEJTIwNC4wJTBBJTBBJTIzJTIwZGVjcmVhc2UlMjB0aGUlMjBtYXglMjBsZW5ndGglMjB0byUyMDI1NiUyMHRva2VucyUwQW1vZGVsLmdlbmVyYXRpb25fY29uZmlnLm1heF9sZW5ndGglMjAlM0QlMjAyNTY=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inspect the default generation config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># increase the guidance scale to 4.0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.guidance_scale = <span class="hljs-number">4.0</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># decrease the max length to 256 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.max_length = <span class="hljs-number">256</span>`,wrap:!1}}),Ye=new J({props:{title:"Model Structure",local:"model-structure",headingTag:"h2"}}),Pe=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBNdXNpY2dlbk1lbG9keUZvckNhdXNhbExNJTJDJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEElMjMlMjBPcHRpb24lMjAxJTNBJTIwZ2V0JTIwZGVjb2RlciUyMGNvbmZpZyUyMGFuZCUyMHBhc3MlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQlNjAlMEFkZWNvZGVyX2NvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKS5kZWNvZGVyJTBBZGVjb2RlciUyMCUzRCUyME11c2ljZ2VuTWVsb2R5Rm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyJTJDJTIwKipkZWNvZGVyX2NvbmZpZy50b19kaWN0KCkpJTBBJTBBJTIzJTIwT3B0aW9uJTIwMiUzQSUyMGxvYWQlMjB0aGUlMjBlbnRpcmUlMjBjb21wb3NpdGUlMjBtb2RlbCUyQyUyMGJ1dCUyMG9ubHklMjByZXR1cm4lMjB0aGUlMjBkZWNvZGVyJTBBZGVjb2RlciUyMCUzRCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLW1lbG9keSUyMikuZGVjb2Rlcg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, MusicgenMelodyForCausalLM, MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Option 1: get decoder config and pass to \`.from_pretrained\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>).decoder
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = MusicgenMelodyForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>, **decoder_config.to_dict())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Option 2: load the entire composite model, but only return the decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>).decoder`,wrap:!1}}),Ae=new J({props:{title:"Checkpoint Conversion",local:"checkpoint-conversion",headingTag:"h2"}}),Ke=new C({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbXVzaWNnZW5fbWVsb2R5JTJGY29udmVydF9tdXNpY2dlbl9tZWxvZHlfdHJhbnNmb3JtZXJzLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jaGVja3BvaW50JTNEJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1tZWxvZHklMjIlMjAtLXB5dG9yY2hfZHVtcF9mb2xkZXIlMjAlMkZvdXRwdXQlMkZwYXRoJTIw",highlighted:`python src/transformers/models/musicgen_melody/convert_musicgen_melody_transformers.py \\
    --checkpoint=<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span> --pytorch_dump_folder /output/path `,wrap:!1}}),nt=new J({props:{title:"MusicgenMelodyDecoderConfig",local:"transformers.MusicgenMelodyDecoderConfig",headingTag:"h2"}}),ot=new z({props:{name:"class transformers.MusicgenMelodyDecoderConfig",anchor:"transformers.MusicgenMelodyDecoderConfig",parameters:[{name:"vocab_size",val:" = 2048"},{name:"max_position_embeddings",val:" = 2048"},{name:"num_hidden_layers",val:" = 24"},{name:"ffn_dim",val:" = 4096"},{name:"num_attention_heads",val:" = 16"},{name:"layerdrop",val:" = 0.0"},{name:"use_cache",val:" = True"},{name:"activation_function",val:" = 'gelu'"},{name:"hidden_size",val:" = 1024"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"initializer_factor",val:" = 0.02"},{name:"scale_embedding",val:" = False"},{name:"num_codebooks",val:" = 4"},{name:"audio_channels",val:" = 1"},{name:"pad_token_id",val:" = 2048"},{name:"bos_token_id",val:" = 2048"},{name:"eos_token_id",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyDecoderConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Vocabulary size of the MusicgenMelodyDecoder model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <code>MusicgenMelodyDecoder</code>.`,name:"vocab_size"},{anchor:"transformers.MusicgenMelodyDecoderConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with. Typically, set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MusicgenMelodyDecoderConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of decoder layers.`,name:"num_hidden_layers"},{anchor:"transformers.MusicgenMelodyDecoderConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer block.`,name:"ffn_dim"},{anchor:"transformers.MusicgenMelodyDecoderConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer block.`,name:"num_attention_heads"},{anchor:"transformers.MusicgenMelodyDecoderConfig.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"layerdrop"},{anchor:"transformers.MusicgenMelodyDecoderConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model should return the last key/values attentions (not used by all models)`,name:"use_cache"},{anchor:"transformers.MusicgenMelodyDecoderConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.MusicgenMelodyDecoderConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.MusicgenMelodyDecoderConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, text_encoder, and pooler.`,name:"dropout"},{anchor:"transformers.MusicgenMelodyDecoderConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MusicgenMelodyDecoderConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.MusicgenMelodyDecoderConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_factor"},{anchor:"transformers.MusicgenMelodyDecoderConfig.scale_embedding",description:`<strong>scale_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Scale embeddings by diving by sqrt(hidden_size).`,name:"scale_embedding"},{anchor:"transformers.MusicgenMelodyDecoderConfig.num_codebooks",description:`<strong>num_codebooks</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of parallel codebooks forwarded to the model.`,name:"num_codebooks"},{anchor:"transformers.MusicgenMelodyDecoderConfig.audio_channels",description:`<strong>audio_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of audio channels used by the model (either mono or stereo). Stereo models generate a separate
audio stream for the left/right output channels. Mono models generate a single audio stream output.`,name:"audio_channels"},{anchor:"transformers.MusicgenMelodyDecoderConfig.pad_token_id",description:"<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014; The id of the <em>padding</em> token.",name:"pad_token_id"},{anchor:"transformers.MusicgenMelodyDecoderConfig.bos_token_id",description:"<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014; The id of the <em>beginning-of-sequence</em> token.",name:"bos_token_id"},{anchor:"transformers.MusicgenMelodyDecoderConfig.eos_token_id",description:"<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>end-of-sequence</em> token.",name:"eos_token_id"},{anchor:"transformers.MusicgenMelodyDecoderConfig.tie_word_embeddings",description:"<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to tie word embeddings with the text encoder.",name:"tie_word_embeddings"}],source:"https://github.com/huggingface/transformers/blob/v4.42.4/src/transformers/models/musicgen_melody/configuration_musicgen_melody.py#L25"}}),st=new J({props:{title:"MusicgenMelodyProcessor",local:"transformers.MusicgenMelodyProcessor",headingTag:"h2"}}),at=new z({props:{name:"class transformers.MusicgenMelodyProcessor",anchor:"transformers.MusicgenMelodyProcessor",parameters:[{name:"feature_extractor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyProcessor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>MusicgenMelodyFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyFeatureExtractor">MusicgenMelodyFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.MusicgenMelodyProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.42.4/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/v4.42.4/src/transformers/models/musicgen_melody/processing_musicgen_melody.py#L27"}}),rt=new z({props:{name:"get_unconditional_inputs",anchor:"transformers.MusicgenMelodyProcessor.get_unconditional_inputs",parameters:[{name:"num_samples",val:" = 1"},{name:"return_tensors",val:" = 'pt'"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyProcessor.get_unconditional_inputs.num_samples",description:`<strong>num_samples</strong> (int, <em>optional</em>) &#x2014;
Number of audio samples to unconditionally generate.`,name:"num_samples"}],source:"https://github.com/huggingface/transformers/blob/v4.42.4/src/transformers/models/musicgen_melody/processing_musicgen_melody.py#L151"}}),S=new rs({props:{anchor:"transformers.MusicgenMelodyProcessor.get_unconditional_inputs.example",$$slots:{default:[ya]},$$scope:{ctx:G}}}),lt=new J({props:{title:"MusicgenMelodyFeatureExtractor",local:"transformers.MusicgenMelodyFeatureExtractor",headingTag:"h2"}}),it=new z({props:{name:"class transformers.MusicgenMelodyFeatureExtractor",anchor:"transformers.MusicgenMelodyFeatureExtractor",parameters:[{name:"feature_size",val:" = 12"},{name:"sampling_rate",val:" = 32000"},{name:"hop_length",val:" = 4096"},{name:"chunk_length",val:" = 30"},{name:"n_fft",val:" = 16384"},{name:"num_chroma",val:" = 12"},{name:"padding_value",val:" = 0.0"},{name:"return_attention_mask",val:" = False"},{name:"stem_indices",val:" = [3, 2]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyFeatureExtractor.feature_size",description:`<strong>feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
The feature dimension of the extracted features.`,name:"feature_size"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The sampling rate at which the audio files should be digitalized expressed in hertz (Hz).`,name:"sampling_rate"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.hop_length",description:`<strong>hop_length</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Length of the overlaping windows for the STFT used to obtain the Mel Frequency coefficients.`,name:"hop_length"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.chunk_length",description:`<strong>chunk_length</strong> (<code>int</code>, <em>optional</em>, defaults to 30) &#x2014;
The maximum number of chunks of <code>sampling_rate</code> samples used to trim and pad longer or shorter audio
sequences.`,name:"chunk_length"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.n_fft",description:`<strong>n_fft</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
Size of the Fourier transform.`,name:"n_fft"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.num_chroma",description:`<strong>num_chroma</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of chroma bins to use.`,name:"num_chroma"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.padding_value",description:`<strong>padding_value</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Padding value used to pad the audio.`,name:"padding_value"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return the attention mask. Can be overwritten when calling the feature extractor.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>For Whisper models, <code>attention_mask</code> should always be passed for batched inference, to avoid subtle
bugs.</p>

					</div>`,name:"return_attention_mask"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.stem_indices",description:`<strong>stem_indices</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 2]</code>) &#x2014;
Stem channels to extract if demucs outputs are passed.`,name:"stem_indices"}],source:"https://github.com/huggingface/transformers/blob/v4.42.4/src/transformers/models/musicgen_melody/feature_extraction_musicgen_melody.py#L39"}}),dt=new z({props:{name:"_extract_stem_indices",anchor:"transformers.MusicgenMelodyFeatureExtractor._extract_stem_indices",parameters:[{name:"audio",val:""},{name:"sampling_rate",val:" = None"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyFeatureExtractor._extract_stem_indices.audio",description:`<strong>audio</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_stems, channel_size, audio_length)</code>) &#x2014;
The output of the Demucs model to be processed.`,name:"audio"},{anchor:"transformers.MusicgenMelodyFeatureExtractor._extract_stem_indices.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Demucs sampling rate. If not specified, defaults to <code>44000</code>.`,name:"sampling_rate"}],source:"https://github.com/huggingface/transformers/blob/v4.42.4/src/transformers/models/musicgen_melody/feature_extraction_musicgen_melody.py#L146"}}),ct=new J({props:{title:"MusicgenMelodyConfig",local:"transformers.MusicgenMelodyConfig",headingTag:"h2"}}),mt=new z({props:{name:"class transformers.MusicgenMelodyConfig",anchor:"transformers.MusicgenMelodyConfig",parameters:[{name:"num_chroma",val:" = 12"},{name:"chroma_length",val:" = 235"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyConfig.num_chroma",description:"<strong>num_chroma</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014; Number of chroma bins to use.",name:"num_chroma"},{anchor:"transformers.MusicgenMelodyConfig.chroma_length",description:`<strong>chroma_length</strong> (<code>int</code>, <em>optional</em>, defaults to 235) &#x2014;
Maximum chroma duration if audio is used to condition the model. Corresponds to the maximum duration used during training.`,name:"chroma_length"},{anchor:"transformers.MusicgenMelodyConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments. Notably:</p>
<ul>
<li><strong>text_encoder</strong> (<a href="/docs/transformers/v4.42.4/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the text encoder config.</li>
<li><strong>audio_encoder</strong> (<a href="/docs/transformers/v4.42.4/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the audio encoder config.</li>
<li><strong>decoder</strong> (<a href="/docs/transformers/v4.42.4/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that defines
the decoder config.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.42.4/src/transformers/models/musicgen_melody/configuration_musicgen_melody.py#L136"}}),D=new rs({props:{anchor:"transformers.MusicgenMelodyConfig.example",$$slots:{default:[_a]},$$scope:{ctx:G}}}),ut=new z({props:{name:"from_sub_models_config",anchor:"transformers.MusicgenMelodyConfig.from_sub_models_config",parameters:[{name:"text_encoder_config",val:": PretrainedConfig"},{name:"audio_encoder_config",val:": PretrainedConfig"},{name:"decoder_config",val:": MusicgenMelodyDecoderConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.42.4/src/transformers/models/musicgen_melody/configuration_musicgen_melody.py#L226",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig"
>MusicgenMelodyConfig</a></p>
`}}),pt=new J({props:{title:"MusicgenMelodyModel",local:"transformers.MusicgenMelodyModel",headingTag:"h2"}}),gt=new z({props:{name:"class transformers.MusicgenMelodyModel",anchor:"transformers.MusicgenMelodyModel",parameters:[{name:"config",val:": MusicgenMelodyDecoderConfig"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig">MusicgenMelodyConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.42.4/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.42.4/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L1151"}}),ht=new z({props:{name:"forward",anchor:"transformers.MusicgenMelodyModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/v4.42.4/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/v4.42.4/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/v4.42.4/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>input_ids</code>.</p>

					</div>`,name:"input_ids"},{anchor:"transformers.MusicgenMelodyModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenMelodyModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states representing the concatenation of the text encoder output and the processed audio encoder output.
Used as a conditional signal and will thus be concatenated to the projeted <code>decoder_input_ids</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenMelodyModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, encoder_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on conditional hidden states. Mask values
selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.MusicgenMelodyModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenMelodyModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)\`.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenMelodyModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenMelodyModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenMelodyModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenMelodyModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.42.4/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.42.4/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L1172"}}),O=new as({props:{$$slots:{default:[ba]},$$scope:{ctx:G}}}),ft=new J({props:{title:"MusicgenMelodyForCausalLM",local:"transformers.MusicgenMelodyForCausalLM",headingTag:"h2"}}),Mt=new z({props:{name:"class transformers.MusicgenMelodyForCausalLM",anchor:"transformers.MusicgenMelodyForCausalLM",parameters:[{name:"config",val:": MusicgenMelodyDecoderConfig"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig">MusicgenMelodyConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.42.4/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.42.4/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L1221"}}),yt=new z({props:{name:"forward",anchor:"transformers.MusicgenMelodyForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"labels",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/v4.42.4/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/v4.42.4/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/v4.42.4/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>input_ids</code>.</p>

					</div>`,name:"input_ids"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states representing the concatenation of the text encoder output and the processed audio encoder output.
Used as a conditional signal and will thus be concatenated to the projeted <code>decoder_input_ids</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, encoder_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on conditional hidden states. Mask values
selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)\`.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.42.4/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, num_codebooks)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.42.4/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L1258",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig"
>MusicgenMelodyConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of conditional hidden-states representing the concatenation of the projeted text encoder output and the projeted audio encoder output.
Used as a conditional signal.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),K=new as({props:{$$slots:{default:[va]},$$scope:{ctx:G}}}),_t=new J({props:{title:"MusicgenMelodyForConditionalGeneration",local:"transformers.MusicgenMelodyForConditionalGeneration",headingTag:"h2"}}),bt=new z({props:{name:"class transformers.MusicgenMelodyForConditionalGeneration",anchor:"transformers.MusicgenMelodyForConditionalGeneration",parameters:[{name:"config",val:": MusicgenMelodyConfig = None"},{name:"text_encoder",val:": Optional = None"},{name:"audio_encoder",val:": Optional = None"},{name:"decoder",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig">MusicgenMelodyConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.42.4/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.text_encoder",description:"<strong>text_encoder</strong> (<code>Optional[PreTrainedModel]</code>, <em>optional</em>) &#x2014; Text encoder.",name:"text_encoder"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.audio_encoder",description:"<strong>audio_encoder</strong> (<code>Optional[PreTrainedModel]</code>, <em>optional</em>) &#x2014; Audio code decoder.",name:"audio_encoder"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.decoder",description:"<strong>decoder</strong> (<code>Optional[MusicgenMelodyForCausalLM]</code>, <em>optional</em>) &#x2014; MusicGen Melody decoder used to generate audio codes.",name:"decoder"}],source:"https://github.com/huggingface/transformers/blob/v4.42.4/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L1746"}}),vt=new z({props:{name:"forward",anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"input_features",val:": Optional = None"},{name:"decoder_input_ids",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"past_key_values",val:": Tuple = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.42.4/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.42.4/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.42.4/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, audio_sequence_length, num_chroma)</code>) &#x2014;
Input audio features.
This should be returned by the <a href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyFeatureExtractor">MusicgenMelodyFeatureExtractor</a> class that you can also
retrieve from <a href="/docs/transformers/v4.42.4/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a>. See <code>MusicgenMelodyFeatureExtractor.__call__()</code> for details.`,name:"input_features"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/v4.42.4/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/v4.42.4/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>decoder_input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/v4.42.4/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>decoder_input_ids</code>.</p>

					</div>`,name:"decoder_input_ids"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length + sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of conditional hidden-states representing the concatenation of the projeted text encoder output and the projeted audio encoder output.
Used as a conditional signal and will thus be concatenated to the projeted <code>decoder_input_ids</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, num_codebooks)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.42.4/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.42.4/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L2064",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.42.4/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig"
>MusicgenMelodyConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of conditional hidden-states representing the concatenation of the projeted text encoder output and the projeted audio encoder output.
Used as a conditional signal.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ee=new as({props:{$$slots:{default:[Ta]},$$scope:{ctx:G}}}),te=new rs({props:{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.example",$$slots:{default:[wa]},$$scope:{ctx:G}}}),Tt=new Ma({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/musicgen_melody.md"}}),{c(){c=r("meta"),b=s(),y=r("p"),_=s(),m(v.$$.fragment),M=s(),m(T.$$.fragment),tn=s(),oe=r("p"),oe.innerHTML=ls,nn=s(),se=r("p"),se.innerHTML=is,on=s(),ae=r("p"),ae.textContent=ds,sn=s(),re=r("p"),re.textContent=cs,an=s(),le=r("p"),le.innerHTML=ms,rn=s(),ie=r("p"),ie.innerHTML=us,ln=s(),m(de.$$.fragment),dn=s(),ce=r("p"),ce.textContent=ps,cn=s(),me=r("ol"),me.innerHTML=gs,mn=s(),m(ue.$$.fragment),un=s(),pe=r("p"),pe.innerHTML=hs,pn=s(),ge=r("p"),ge.textContent=fs,gn=s(),m(he.$$.fragment),hn=s(),fe=r("p"),fe.innerHTML=Ms,fn=s(),Me=r("p"),Me.textContent=ys,Mn=s(),m(ye.$$.fragment),yn=s(),_e=r("p"),_e.textContent=_s,_n=s(),m(be.$$.fragment),bn=s(),ve=r("p"),ve.innerHTML=bs,vn=s(),Te=r("p"),Te.innerHTML=vs,Tn=s(),m(we.$$.fragment),wn=s(),ke=r("p"),ke.textContent=Ts,kn=s(),m(je.$$.fragment),jn=s(),Je=r("p"),Je.textContent=ws,Jn=s(),m(Ce.$$.fragment),Cn=s(),Ze=r("p"),Ze.innerHTML=ks,Zn=s(),m(Ue.$$.fragment),Un=s(),xe=r("p"),xe.innerHTML=js,xn=s(),m($e.$$.fragment),$n=s(),m(Ge.$$.fragment),Gn=s(),We=r("p"),We.innerHTML=Js,Wn=s(),m(Fe.$$.fragment),Fn=s(),Ve=r("p"),Ve.innerHTML=Cs,Vn=s(),ze=r("p"),ze.textContent=Zs,zn=s(),m(Ne.$$.fragment),Nn=s(),m(Ie.$$.fragment),In=s(),Re=r("p"),Re.innerHTML=Us,Rn=s(),m(Be.$$.fragment),Bn=s(),m(Xe.$$.fragment),Xn=s(),He=r("p"),He.textContent=xs,Hn=s(),m(Ee.$$.fragment),En=s(),qe=r("p"),qe.innerHTML=$s,qn=s(),m(Ye.$$.fragment),Yn=s(),Le=r("p"),Le.textContent=Gs,Ln=s(),Qe=r("ol"),Qe.innerHTML=Ws,Qn=s(),Se=r("p"),Se.innerHTML=Fs,Sn=s(),m(Pe.$$.fragment),Pn=s(),De=r("p"),De.innerHTML=Vs,Dn=s(),m(Ae.$$.fragment),An=s(),Oe=r("ul"),Oe.innerHTML=zs,On=s(),m(Ke.$$.fragment),Kn=s(),et=r("p"),et.textContent=Ns,eo=s(),tt=r("ul"),tt.innerHTML=Is,to=s(),m(nt.$$.fragment),no=s(),X=r("div"),m(ot.$$.fragment),bo=s(),kt=r("p"),kt.innerHTML=Rs,vo=s(),jt=r("p"),jt.innerHTML=Bs,oo=s(),m(st.$$.fragment),so=s(),W=r("div"),m(at.$$.fragment),To=s(),Jt=r("p"),Jt.textContent=Xs,wo=s(),Ct=r("p"),Ct.innerHTML=Hs,ko=s(),E=r("div"),m(rt.$$.fragment),jo=s(),Zt=r("p"),Zt.textContent=Es,Jo=s(),m(S.$$.fragment),ao=s(),m(lt.$$.fragment),ro=s(),Z=r("div"),m(it.$$.fragment),Co=s(),Ut=r("p"),Ut.textContent=qs,Zo=s(),xt=r("p"),xt.innerHTML=Ys,Uo=s(),$t=r("p"),$t.innerHTML=Ls,xo=s(),P=r("div"),m(dt.$$.fragment),$o=s(),Gt=r("p"),Gt.innerHTML=Qs,lo=s(),m(ct.$$.fragment),io=s(),U=r("div"),m(mt.$$.fragment),Go=s(),Wt=r("p"),Wt.innerHTML=Ss,Wo=s(),Ft=r("p"),Ft.innerHTML=Ps,Fo=s(),m(D.$$.fragment),Vo=s(),A=r("div"),m(ut.$$.fragment),zo=s(),Vt=r("p"),Vt.innerHTML=Ds,co=s(),m(pt.$$.fragment),mo=s(),w=r("div"),m(gt.$$.fragment),No=s(),zt=r("p"),zt.textContent=As,Io=s(),Nt=r("p"),Nt.innerHTML=Os,Ro=s(),It=r("p"),It.innerHTML=Ks,Bo=s(),Rt=r("p"),Rt.innerHTML=ea,Xo=s(),q=r("div"),m(ht.$$.fragment),Ho=s(),Bt=r("p"),Bt.innerHTML=ta,Eo=s(),m(O.$$.fragment),uo=s(),m(ft.$$.fragment),po=s(),k=r("div"),m(Mt.$$.fragment),qo=s(),Xt=r("p"),Xt.textContent=na,Yo=s(),Ht=r("p"),Ht.innerHTML=oa,Lo=s(),Et=r("p"),Et.innerHTML=sa,Qo=s(),qt=r("p"),qt.innerHTML=aa,So=s(),Y=r("div"),m(yt.$$.fragment),Po=s(),Yt=r("p"),Yt.innerHTML=ra,Do=s(),m(K.$$.fragment),go=s(),m(_t.$$.fragment),ho=s(),j=r("div"),m(bt.$$.fragment),Ao=s(),Lt=r("p"),Lt.textContent=la,Oo=s(),Qt=r("p"),Qt.innerHTML=ia,Ko=s(),St=r("p"),St.innerHTML=da,es=s(),Pt=r("p"),Pt.innerHTML=ca,ts=s(),N=r("div"),m(vt.$$.fragment),ns=s(),Dt=r("p"),Dt.innerHTML=ma,os=s(),m(ee.$$.fragment),ss=s(),m(te.$$.fragment),fo=s(),m(Tt.$$.fragment),Mo=s(),en=r("p"),this.h()},l(e){const t=fa("svelte-u9bgzb",document.head);c=l(t,"META",{name:!0,content:!0}),t.forEach(n),b=a(e),y=l(e,"P",{}),x(y).forEach(n),_=a(e),u(v.$$.fragment,e),M=a(e),u(T.$$.fragment,e),tn=a(e),oe=l(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-78c2gt"&&(oe.innerHTML=ls),nn=a(e),se=l(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-12yjb0l"&&(se.innerHTML=is),on=a(e),ae=l(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-fd8as4"&&(ae.textContent=ds),sn=a(e),re=l(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-vfdo9a"&&(re.textContent=cs),an=a(e),le=l(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1ivrrzt"&&(le.innerHTML=ms),rn=a(e),ie=l(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1hq1neg"&&(ie.innerHTML=us),ln=a(e),u(de.$$.fragment,e),dn=a(e),ce=l(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1uncox0"&&(ce.textContent=ps),cn=a(e),me=l(e,"OL",{"data-svelte-h":!0}),d(me)!=="svelte-18htd4w"&&(me.innerHTML=gs),mn=a(e),u(ue.$$.fragment,e),un=a(e),pe=l(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1ftnanv"&&(pe.innerHTML=hs),pn=a(e),ge=l(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1csutn1"&&(ge.textContent=fs),gn=a(e),u(he.$$.fragment,e),hn=a(e),fe=l(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-7x48of"&&(fe.innerHTML=Ms),fn=a(e),Me=l(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-13qa4g8"&&(Me.textContent=ys),Mn=a(e),u(ye.$$.fragment,e),yn=a(e),_e=l(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-z5hgod"&&(_e.textContent=_s),_n=a(e),u(be.$$.fragment,e),bn=a(e),ve=l(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-1qlcazm"&&(ve.innerHTML=bs),vn=a(e),Te=l(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-3ul8a2"&&(Te.innerHTML=vs),Tn=a(e),u(we.$$.fragment,e),wn=a(e),ke=l(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-j9yyu1"&&(ke.textContent=Ts),kn=a(e),u(je.$$.fragment,e),jn=a(e),Je=l(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1ogs8cb"&&(Je.textContent=ws),Jn=a(e),u(Ce.$$.fragment,e),Cn=a(e),Ze=l(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-1i3bavh"&&(Ze.innerHTML=ks),Zn=a(e),u(Ue.$$.fragment,e),Un=a(e),xe=l(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1so91jo"&&(xe.innerHTML=js),xn=a(e),u($e.$$.fragment,e),$n=a(e),u(Ge.$$.fragment,e),Gn=a(e),We=l(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-v20w8u"&&(We.innerHTML=Js),Wn=a(e),u(Fe.$$.fragment,e),Fn=a(e),Ve=l(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1hk6jop"&&(Ve.innerHTML=Cs),Vn=a(e),ze=l(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-nxh1r8"&&(ze.textContent=Zs),zn=a(e),u(Ne.$$.fragment,e),Nn=a(e),u(Ie.$$.fragment,e),In=a(e),Re=l(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-ydla47"&&(Re.innerHTML=Us),Rn=a(e),u(Be.$$.fragment,e),Bn=a(e),u(Xe.$$.fragment,e),Xn=a(e),He=l(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1osihnc"&&(He.textContent=xs),Hn=a(e),u(Ee.$$.fragment,e),En=a(e),qe=l(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-j9qxmb"&&(qe.innerHTML=$s),qn=a(e),u(Ye.$$.fragment,e),Yn=a(e),Le=l(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-52mell"&&(Le.textContent=Gs),Ln=a(e),Qe=l(e,"OL",{"data-svelte-h":!0}),d(Qe)!=="svelte-1cudh7l"&&(Qe.innerHTML=Ws),Qn=a(e),Se=l(e,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-tazym6"&&(Se.innerHTML=Fs),Sn=a(e),u(Pe.$$.fragment,e),Pn=a(e),De=l(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-1483bi1"&&(De.innerHTML=Vs),Dn=a(e),u(Ae.$$.fragment,e),An=a(e),Oe=l(e,"UL",{"data-svelte-h":!0}),d(Oe)!=="svelte-111jn6u"&&(Oe.innerHTML=zs),On=a(e),u(Ke.$$.fragment,e),Kn=a(e),et=l(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-axv494"&&(et.textContent=Ns),eo=a(e),tt=l(e,"UL",{"data-svelte-h":!0}),d(tt)!=="svelte-43b5cf"&&(tt.innerHTML=Is),to=a(e),u(nt.$$.fragment,e),no=a(e),X=l(e,"DIV",{class:!0});var L=x(X);u(ot.$$.fragment,L),bo=a(L),kt=l(L,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1is1y2l"&&(kt.innerHTML=Rs),vo=a(L),jt=l(L,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-q5f6v7"&&(jt.innerHTML=Bs),L.forEach(n),oo=a(e),u(st.$$.fragment,e),so=a(e),W=l(e,"DIV",{class:!0});var H=x(W);u(at.$$.fragment,H),To=a(H),Jt=l(H,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-1eghntb"&&(Jt.textContent=Xs),wo=a(H),Ct=l(H,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-1wjpylw"&&(Ct.innerHTML=Hs),ko=a(H),E=l(H,"DIV",{class:!0});var Q=x(E);u(rt.$$.fragment,Q),jo=a(Q),Zt=l(Q,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-99wdq5"&&(Zt.textContent=Es),Jo=a(Q),u(S.$$.fragment,Q),Q.forEach(n),H.forEach(n),ao=a(e),u(lt.$$.fragment,e),ro=a(e),Z=l(e,"DIV",{class:!0});var F=x(Z);u(it.$$.fragment,F),Co=a(F),Ut=l(F,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-avkweo"&&(Ut.textContent=qs),Zo=a(F),xt=l(F,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-1g9gnn2"&&(xt.innerHTML=Ys),Uo=a(F),$t=l(F,"P",{"data-svelte-h":!0}),d($t)!=="svelte-ffxp6h"&&($t.innerHTML=Ls),xo=a(F),P=l(F,"DIV",{class:!0});var wt=x(P);u(dt.$$.fragment,wt),$o=a(wt),Gt=l(wt,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-mmrsak"&&(Gt.innerHTML=Qs),wt.forEach(n),F.forEach(n),lo=a(e),u(ct.$$.fragment,e),io=a(e),U=l(e,"DIV",{class:!0});var V=x(U);u(mt.$$.fragment,V),Go=a(V),Wt=l(V,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-1psysw6"&&(Wt.innerHTML=Ss),Wo=a(V),Ft=l(V,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-q5f6v7"&&(Ft.innerHTML=Ps),Fo=a(V),u(D.$$.fragment,V),Vo=a(V),A=l(V,"DIV",{class:!0});var _o=x(A);u(ut.$$.fragment,_o),zo=a(_o),Vt=l(_o,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-e82kjs"&&(Vt.innerHTML=Ds),_o.forEach(n),V.forEach(n),co=a(e),u(pt.$$.fragment,e),mo=a(e),w=l(e,"DIV",{class:!0});var I=x(w);u(gt.$$.fragment,I),No=a(I),zt=l(I,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-wdu1ev"&&(zt.textContent=As),Io=a(I),Nt=l(I,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-1ju8fyw"&&(Nt.innerHTML=Os),Ro=a(I),It=l(I,"P",{"data-svelte-h":!0}),d(It)!=="svelte-mhvelr"&&(It.innerHTML=Ks),Bo=a(I),Rt=l(I,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-hswkmf"&&(Rt.innerHTML=ea),Xo=a(I),q=l(I,"DIV",{class:!0});var At=x(q);u(ht.$$.fragment,At),Ho=a(At),Bt=l(At,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-1rslhqk"&&(Bt.innerHTML=ta),Eo=a(At),u(O.$$.fragment,At),At.forEach(n),I.forEach(n),uo=a(e),u(ft.$$.fragment,e),po=a(e),k=l(e,"DIV",{class:!0});var R=x(k);u(Mt.$$.fragment,R),qo=a(R),Xt=l(R,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-1m1my0b"&&(Xt.textContent=na),Yo=a(R),Ht=l(R,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-1ju8fyw"&&(Ht.innerHTML=oa),Lo=a(R),Et=l(R,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-mhvelr"&&(Et.innerHTML=sa),Qo=a(R),qt=l(R,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-hswkmf"&&(qt.innerHTML=aa),So=a(R),Y=l(R,"DIV",{class:!0});var Ot=x(Y);u(yt.$$.fragment,Ot),Po=a(Ot),Yt=l(Ot,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-mxn5as"&&(Yt.innerHTML=ra),Do=a(Ot),u(K.$$.fragment,Ot),Ot.forEach(n),R.forEach(n),go=a(e),u(_t.$$.fragment,e),ho=a(e),j=l(e,"DIV",{class:!0});var B=x(j);u(bt.$$.fragment,B),Ao=a(B),Lt=l(B,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1c6yw0h"&&(Lt.textContent=la),Oo=a(B),Qt=l(B,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-1ju8fyw"&&(Qt.innerHTML=ia),Ko=a(B),St=l(B,"P",{"data-svelte-h":!0}),d(St)!=="svelte-mhvelr"&&(St.innerHTML=da),es=a(B),Pt=l(B,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-hswkmf"&&(Pt.innerHTML=ca),ts=a(B),N=l(B,"DIV",{class:!0});var ne=x(N);u(vt.$$.fragment,ne),ns=a(ne),Dt=l(ne,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-fucj7w"&&(Dt.innerHTML=ma),os=a(ne),u(ee.$$.fragment,ne),ss=a(ne),u(te.$$.fragment,ne),ne.forEach(n),B.forEach(n),fo=a(e),u(Tt.$$.fragment,e),Mo=a(e),en=l(e,"P",{}),x(en).forEach(n),this.h()},h(){$(c,"name","hf:doc:metadata"),$(c,"content",ja),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,c),o(e,b,t),o(e,y,t),o(e,_,t),p(v,e,t),o(e,M,t),p(T,e,t),o(e,tn,t),o(e,oe,t),o(e,nn,t),o(e,se,t),o(e,on,t),o(e,ae,t),o(e,sn,t),o(e,re,t),o(e,an,t),o(e,le,t),o(e,rn,t),o(e,ie,t),o(e,ln,t),p(de,e,t),o(e,dn,t),o(e,ce,t),o(e,cn,t),o(e,me,t),o(e,mn,t),p(ue,e,t),o(e,un,t),o(e,pe,t),o(e,pn,t),o(e,ge,t),o(e,gn,t),p(he,e,t),o(e,hn,t),o(e,fe,t),o(e,fn,t),o(e,Me,t),o(e,Mn,t),p(ye,e,t),o(e,yn,t),o(e,_e,t),o(e,_n,t),p(be,e,t),o(e,bn,t),o(e,ve,t),o(e,vn,t),o(e,Te,t),o(e,Tn,t),p(we,e,t),o(e,wn,t),o(e,ke,t),o(e,kn,t),p(je,e,t),o(e,jn,t),o(e,Je,t),o(e,Jn,t),p(Ce,e,t),o(e,Cn,t),o(e,Ze,t),o(e,Zn,t),p(Ue,e,t),o(e,Un,t),o(e,xe,t),o(e,xn,t),p($e,e,t),o(e,$n,t),p(Ge,e,t),o(e,Gn,t),o(e,We,t),o(e,Wn,t),p(Fe,e,t),o(e,Fn,t),o(e,Ve,t),o(e,Vn,t),o(e,ze,t),o(e,zn,t),p(Ne,e,t),o(e,Nn,t),p(Ie,e,t),o(e,In,t),o(e,Re,t),o(e,Rn,t),p(Be,e,t),o(e,Bn,t),p(Xe,e,t),o(e,Xn,t),o(e,He,t),o(e,Hn,t),p(Ee,e,t),o(e,En,t),o(e,qe,t),o(e,qn,t),p(Ye,e,t),o(e,Yn,t),o(e,Le,t),o(e,Ln,t),o(e,Qe,t),o(e,Qn,t),o(e,Se,t),o(e,Sn,t),p(Pe,e,t),o(e,Pn,t),o(e,De,t),o(e,Dn,t),p(Ae,e,t),o(e,An,t),o(e,Oe,t),o(e,On,t),p(Ke,e,t),o(e,Kn,t),o(e,et,t),o(e,eo,t),o(e,tt,t),o(e,to,t),p(nt,e,t),o(e,no,t),o(e,X,t),p(ot,X,null),i(X,bo),i(X,kt),i(X,vo),i(X,jt),o(e,oo,t),p(st,e,t),o(e,so,t),o(e,W,t),p(at,W,null),i(W,To),i(W,Jt),i(W,wo),i(W,Ct),i(W,ko),i(W,E),p(rt,E,null),i(E,jo),i(E,Zt),i(E,Jo),p(S,E,null),o(e,ao,t),p(lt,e,t),o(e,ro,t),o(e,Z,t),p(it,Z,null),i(Z,Co),i(Z,Ut),i(Z,Zo),i(Z,xt),i(Z,Uo),i(Z,$t),i(Z,xo),i(Z,P),p(dt,P,null),i(P,$o),i(P,Gt),o(e,lo,t),p(ct,e,t),o(e,io,t),o(e,U,t),p(mt,U,null),i(U,Go),i(U,Wt),i(U,Wo),i(U,Ft),i(U,Fo),p(D,U,null),i(U,Vo),i(U,A),p(ut,A,null),i(A,zo),i(A,Vt),o(e,co,t),p(pt,e,t),o(e,mo,t),o(e,w,t),p(gt,w,null),i(w,No),i(w,zt),i(w,Io),i(w,Nt),i(w,Ro),i(w,It),i(w,Bo),i(w,Rt),i(w,Xo),i(w,q),p(ht,q,null),i(q,Ho),i(q,Bt),i(q,Eo),p(O,q,null),o(e,uo,t),p(ft,e,t),o(e,po,t),o(e,k,t),p(Mt,k,null),i(k,qo),i(k,Xt),i(k,Yo),i(k,Ht),i(k,Lo),i(k,Et),i(k,Qo),i(k,qt),i(k,So),i(k,Y),p(yt,Y,null),i(Y,Po),i(Y,Yt),i(Y,Do),p(K,Y,null),o(e,go,t),p(_t,e,t),o(e,ho,t),o(e,j,t),p(bt,j,null),i(j,Ao),i(j,Lt),i(j,Oo),i(j,Qt),i(j,Ko),i(j,St),i(j,es),i(j,Pt),i(j,ts),i(j,N),p(vt,N,null),i(N,ns),i(N,Dt),i(N,os),p(ee,N,null),i(N,ss),p(te,N,null),o(e,fo,t),p(Tt,e,t),o(e,Mo,t),o(e,en,t),yo=!0},p(e,[t]){const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),S.$set(L);const H={};t&2&&(H.$$scope={dirty:t,ctx:e}),D.$set(H);const Q={};t&2&&(Q.$$scope={dirty:t,ctx:e}),O.$set(Q);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),K.$set(F);const wt={};t&2&&(wt.$$scope={dirty:t,ctx:e}),ee.$set(wt);const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),te.$set(V)},i(e){yo||(g(v.$$.fragment,e),g(T.$$.fragment,e),g(de.$$.fragment,e),g(ue.$$.fragment,e),g(he.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(we.$$.fragment,e),g(je.$$.fragment,e),g(Ce.$$.fragment,e),g(Ue.$$.fragment,e),g($e.$$.fragment,e),g(Ge.$$.fragment,e),g(Fe.$$.fragment,e),g(Ne.$$.fragment,e),g(Ie.$$.fragment,e),g(Be.$$.fragment,e),g(Xe.$$.fragment,e),g(Ee.$$.fragment,e),g(Ye.$$.fragment,e),g(Pe.$$.fragment,e),g(Ae.$$.fragment,e),g(Ke.$$.fragment,e),g(nt.$$.fragment,e),g(ot.$$.fragment,e),g(st.$$.fragment,e),g(at.$$.fragment,e),g(rt.$$.fragment,e),g(S.$$.fragment,e),g(lt.$$.fragment,e),g(it.$$.fragment,e),g(dt.$$.fragment,e),g(ct.$$.fragment,e),g(mt.$$.fragment,e),g(D.$$.fragment,e),g(ut.$$.fragment,e),g(pt.$$.fragment,e),g(gt.$$.fragment,e),g(ht.$$.fragment,e),g(O.$$.fragment,e),g(ft.$$.fragment,e),g(Mt.$$.fragment,e),g(yt.$$.fragment,e),g(K.$$.fragment,e),g(_t.$$.fragment,e),g(bt.$$.fragment,e),g(vt.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(Tt.$$.fragment,e),yo=!0)},o(e){h(v.$$.fragment,e),h(T.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(ye.$$.fragment,e),h(be.$$.fragment,e),h(we.$$.fragment,e),h(je.$$.fragment,e),h(Ce.$$.fragment,e),h(Ue.$$.fragment,e),h($e.$$.fragment,e),h(Ge.$$.fragment,e),h(Fe.$$.fragment,e),h(Ne.$$.fragment,e),h(Ie.$$.fragment,e),h(Be.$$.fragment,e),h(Xe.$$.fragment,e),h(Ee.$$.fragment,e),h(Ye.$$.fragment,e),h(Pe.$$.fragment,e),h(Ae.$$.fragment,e),h(Ke.$$.fragment,e),h(nt.$$.fragment,e),h(ot.$$.fragment,e),h(st.$$.fragment,e),h(at.$$.fragment,e),h(rt.$$.fragment,e),h(S.$$.fragment,e),h(lt.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),h(ct.$$.fragment,e),h(mt.$$.fragment,e),h(D.$$.fragment,e),h(ut.$$.fragment,e),h(pt.$$.fragment,e),h(gt.$$.fragment,e),h(ht.$$.fragment,e),h(O.$$.fragment,e),h(ft.$$.fragment,e),h(Mt.$$.fragment,e),h(yt.$$.fragment,e),h(K.$$.fragment,e),h(_t.$$.fragment,e),h(bt.$$.fragment,e),h(vt.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(Tt.$$.fragment,e),yo=!1},d(e){e&&(n(b),n(y),n(_),n(M),n(tn),n(oe),n(nn),n(se),n(on),n(ae),n(sn),n(re),n(an),n(le),n(rn),n(ie),n(ln),n(dn),n(ce),n(cn),n(me),n(mn),n(un),n(pe),n(pn),n(ge),n(gn),n(hn),n(fe),n(fn),n(Me),n(Mn),n(yn),n(_e),n(_n),n(bn),n(ve),n(vn),n(Te),n(Tn),n(wn),n(ke),n(kn),n(jn),n(Je),n(Jn),n(Cn),n(Ze),n(Zn),n(Un),n(xe),n(xn),n($n),n(Gn),n(We),n(Wn),n(Fn),n(Ve),n(Vn),n(ze),n(zn),n(Nn),n(In),n(Re),n(Rn),n(Bn),n(Xn),n(He),n(Hn),n(En),n(qe),n(qn),n(Yn),n(Le),n(Ln),n(Qe),n(Qn),n(Se),n(Sn),n(Pn),n(De),n(Dn),n(An),n(Oe),n(On),n(Kn),n(et),n(eo),n(tt),n(to),n(no),n(X),n(oo),n(so),n(W),n(ao),n(ro),n(Z),n(lo),n(io),n(U),n(co),n(mo),n(w),n(uo),n(po),n(k),n(go),n(ho),n(j),n(fo),n(Mo),n(en)),n(c),f(v,e),f(T,e),f(de,e),f(ue,e),f(he,e),f(ye,e),f(be,e),f(we,e),f(je,e),f(Ce,e),f(Ue,e),f($e,e),f(Ge,e),f(Fe,e),f(Ne,e),f(Ie,e),f(Be,e),f(Xe,e),f(Ee,e),f(Ye,e),f(Pe,e),f(Ae,e),f(Ke,e),f(nt,e),f(ot),f(st,e),f(at),f(rt),f(S),f(lt,e),f(it),f(dt),f(ct,e),f(mt),f(D),f(ut),f(pt,e),f(gt),f(ht),f(O),f(ft,e),f(Mt),f(yt),f(K),f(_t,e),f(bt),f(vt),f(ee),f(te),f(Tt,e)}}}const ja='{"title":"MusicGen Melody","local":"musicgen-melody","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Difference with MusicGen","local":"difference-with-musicgen","sections":[],"depth":2},{"title":"Generation","local":"generation","sections":[{"title":"Audio Conditional Generation","local":"audio-conditional-generation","sections":[],"depth":4},{"title":"Text-only Conditional Generation","local":"text-only-conditional-generation","sections":[],"depth":3},{"title":"Unconditional Generation","local":"unconditional-generation","sections":[],"depth":3},{"title":"Generation Configuration","local":"generation-configuration","sections":[],"depth":3}],"depth":2},{"title":"Model Structure","local":"model-structure","sections":[],"depth":2},{"title":"Checkpoint Conversion","local":"checkpoint-conversion","sections":[],"depth":2},{"title":"MusicgenMelodyDecoderConfig","local":"transformers.MusicgenMelodyDecoderConfig","sections":[],"depth":2},{"title":"MusicgenMelodyProcessor","local":"transformers.MusicgenMelodyProcessor","sections":[],"depth":2},{"title":"MusicgenMelodyFeatureExtractor","local":"transformers.MusicgenMelodyFeatureExtractor","sections":[],"depth":2},{"title":"MusicgenMelodyConfig","local":"transformers.MusicgenMelodyConfig","sections":[],"depth":2},{"title":"MusicgenMelodyModel","local":"transformers.MusicgenMelodyModel","sections":[],"depth":2},{"title":"MusicgenMelodyForCausalLM","local":"transformers.MusicgenMelodyForCausalLM","sections":[],"depth":2},{"title":"MusicgenMelodyForConditionalGeneration","local":"transformers.MusicgenMelodyForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Ja(G){return pa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fa extends ga{constructor(c){super(),ha(this,c,Ja,ka,ua,{})}}export{Fa as component};
