import{s as At,n as Wt,o as Yt}from"../chunks/scheduler.9f522b10.js";import{S as Ft,i as Ht,g as i,s as a,r as p,A as Qt,h as r,f as l,c as n,j as _t,u as M,x as o,k as Vt,y as qt,a as s,v as y,d as m,t as h,w as c}from"../chunks/index.192f26f8.js";import{C as F}from"../chunks/CodeBlock.ac496002.js";import{H as jt}from"../chunks/Heading.1a5b64b4.js";function St(Jt){let u,q,H,S,d,E,w,bt=`In the <a href="quicktour">Quicktour</a>, we saw how to build and train a
tokenizer using text files, but we can actually use any Python Iterator.
In this section we’ll see a few different ways of training our
tokenizer.`,L,U,Tt=`For all the examples listed below, we’ll use the same <a href="/docs/tokenizers/main/en/api/tokenizer#tokenizers.Tokenizer">Tokenizer</a> and
<code>Trainer</code>, built as
following:`,N,f,P,j,Ct=`This tokenizer is based on the <a href="/docs/tokenizers/main/en/api/models#tokenizers.models.Unigram">Unigram</a> model. It
takes care of normalizing the input using the NFKC Unicode normalization
method, and uses a <a href="/docs/tokenizers/main/en/api/pre-tokenizers#tokenizers.pre_tokenizers.ByteLevel">ByteLevel</a> pre-tokenizer with the corresponding decoder.`,K,J,kt=`For more information on the components used here, you can check
<a href="components">here</a>.`,D,b,O,T,gt=`As you probably guessed already, the easiest way to train our tokenizer
is by using a <code>List</code>{.interpreted-text role=“obj”}:`,tt,C,et,k,It=`Easy, right? You can use anything working as an iterator here, be it a
<code>List</code>{.interpreted-text role=“obj”}, <code>Tuple</code>{.interpreted-text
role=“obj”}, or a <code>np.Array</code>{.interpreted-text role=“obj”}. Anything
works as long as it provides strings.`,lt,g,st,I,$t=`An awesome way to access one of the many datasets that exist out there
is by using the 🤗 Datasets library. For more information about it, you
should check <a href="https://huggingface.co/docs/datasets/" rel="nofollow">the official documentation
here</a>.`,at,$,zt="Let’s start by loading our dataset:",nt,z,it,G,Gt=`The next step is to build an iterator over this dataset. The easiest way
to do this is probably by using a generator:`,rt,X,ot,Z,Xt=`As you can see here, for improved efficiency we can actually provide a
batch of examples used to train, instead of iterating over them one by
one. By doing so, we can expect performances very similar to those we
got while training directly from files.`,pt,v,Zt=`With our iterator ready, we just need to launch the training. In order
to improve the look of our progress bars, we can specify the total
length of the dataset:`,Mt,B,yt,R,vt="And that’s it!",mt,x,ht,_,Bt=`Since gzip files in Python can be used as iterators, it is extremely
simple to train on such files:`,ct,V,ut,A,Rt=`Now if we wanted to train from multiple gzip files, it wouldn’t be much
harder:`,dt,W,wt,Y,xt="And voilà!",Ut,Q,ft;return d=new jt({props:{title:"Training from memory",local:"training-from-memory",headingTag:"h1"}}),f=new F({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBUb2tlbml6ZXIlMkMlMjBkZWNvZGVycyUyQyUyMG1vZGVscyUyQyUyMG5vcm1hbGl6ZXJzJTJDJTIwcHJlX3Rva2VuaXplcnMlMkMlMjB0cmFpbmVycyUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuVW5pZ3JhbSgpKSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuTkZLQygpJTBBdG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoKSUwQXRva2VuaXplci5kZWNvZGVyJTIwJTNEJTIwZGVjb2RlcnMuQnl0ZUxldmVsKCklMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDIwMDAwJTJDJTBBJTIwJTIwJTIwJTIwaW5pdGlhbF9hbHBoYWJldCUzRHByZV90b2tlbml6ZXJzLkJ5dGVMZXZlbC5hbHBoYWJldCgpJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0NQQUQlM0UlMjIlMkMlMjAlMjIlM0NCT1MlM0UlMjIlMkMlMjAlMjIlM0NFT1MlM0UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Tokenizer, decoders, models, normalizers, pre_tokenizers, trainers
tokenizer = Tokenizer(models.Unigram())
tokenizer.normalizer = normalizers.NFKC()
tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel()
tokenizer.decoder = decoders.ByteLevel()
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">20000</span>,
    initial_alphabet=pre_tokenizers.ByteLevel.alphabet(),
    special_tokens=[<span class="hljs-string">&quot;&lt;PAD&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;BOS&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;EOS&gt;&quot;</span>],
)`,wrap:!1}}),b=new jt({props:{title:"The most basic way",local:"the-most-basic-way",headingTag:"h2"}}),C=new F({props:{code:"JTIzJTIwRmlyc3QlMjBmZXclMjBsaW5lcyUyMG9mJTIwdGhlJTIwJTIyWmVuJTIwb2YlMjBQeXRob24lMjIlMjBodHRwcyUzQSUyRiUyRnd3dy5weXRob24ub3JnJTJGZGV2JTJGcGVwcyUyRnBlcC0wMDIwJTJGJTBBZGF0YSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkJlYXV0aWZ1bCUyMGlzJTIwYmV0dGVyJTIwdGhhbiUyMHVnbHkuJTIyJTBBJTIwJTIwJTIwJTIwJTIyRXhwbGljaXQlMjBpcyUyMGJldHRlciUyMHRoYW4lMjBpbXBsaWNpdC4lMjIlMEElMjAlMjAlMjAlMjAlMjJTaW1wbGUlMjBpcyUyMGJldHRlciUyMHRoYW4lMjBjb21wbGV4LiUyMiUwQSUyMCUyMCUyMCUyMCUyMkNvbXBsZXglMjBpcyUyMGJldHRlciUyMHRoYW4lMjBjb21wbGljYXRlZC4lMjIlMEElMjAlMjAlMjAlMjAlMjJGbGF0JTIwaXMlMjBiZXR0ZXIlMjB0aGFuJTIwbmVzdGVkLiUyMiUwQSUyMCUyMCUyMCUyMCUyMlNwYXJzZSUyMGlzJTIwYmV0dGVyJTIwdGhhbiUyMGRlbnNlLiUyMiUwQSUyMCUyMCUyMCUyMCUyMlJlYWRhYmlsaXR5JTIwY291bnRzLiUyMiUwQSU1RCUwQXRva2VuaXplci50cmFpbl9mcm9tX2l0ZXJhdG9yKGRhdGElMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`<span class="hljs-comment"># First few lines of the &quot;Zen of Python&quot; https://www.python.org/dev/peps/pep-0020/</span>
data = [
    <span class="hljs-string">&quot;Beautiful is better than ugly.&quot;</span>
    <span class="hljs-string">&quot;Explicit is better than implicit.&quot;</span>
    <span class="hljs-string">&quot;Simple is better than complex.&quot;</span>
    <span class="hljs-string">&quot;Complex is better than complicated.&quot;</span>
    <span class="hljs-string">&quot;Flat is better than nested.&quot;</span>
    <span class="hljs-string">&quot;Sparse is better than dense.&quot;</span>
    <span class="hljs-string">&quot;Readability counts.&quot;</span>
]
tokenizer.train_from_iterator(data, trainer=trainer)`,wrap:!1}}),g=new jt({props:{title:"Using the 🤗 Datasets library",local:"using-the--datasets-library",headingTag:"h2"}}),z=new F({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMndpa2l0ZXh0JTIyJTJDJTIwJTIyd2lraXRleHQtMTAzLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMkJ0ZXN0JTJCdmFsaWRhdGlvbiUyMik=",highlighted:`<span class="hljs-keyword">import</span> datasets
dataset = datasets.load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, <span class="hljs-string">&quot;wikitext-103-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train+test+validation&quot;</span>)`,wrap:!1}}),X=new F({props:{code:"ZGVmJTIwYmF0Y2hfaXRlcmF0b3IoYmF0Y2hfc2l6ZSUzRDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwT25seSUyMGtlZXAlMjB0aGUlMjB0ZXh0JTIwY29sdW1uJTIwdG8lMjBhdm9pZCUyMGRlY29kaW5nJTIwdGhlJTIwcmVzdCUyMG9mJTIwdGhlJTIwY29sdW1ucyUyMHVubmVjZXNzYXJpbHklMEElMjAlMjAlMjAlMjB0b2tfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc2VsZWN0X2NvbHVtbnMoJTIydGV4dCUyMiklMEElMjAlMjAlMjAlMjBmb3IlMjBiYXRjaCUyMGluJTIwdG9rX2RhdGFzZXQuaXRlcihiYXRjaF9zaXplKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHlpZWxkJTIwYmF0Y2glNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">batch_iterator</span>(<span class="hljs-params">batch_size=<span class="hljs-number">1000</span></span>):
    <span class="hljs-comment"># Only keep the text column to avoid decoding the rest of the columns unnecessarily</span>
    tok_dataset = dataset.select_columns(<span class="hljs-string">&quot;text&quot;</span>)
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> tok_dataset.<span class="hljs-built_in">iter</span>(batch_size):
        <span class="hljs-keyword">yield</span> batch[<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),B=new F({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoYmF0Y2hfaXRlcmF0b3IoKSUyQyUyMHRyYWluZXIlM0R0cmFpbmVyJTJDJTIwbGVuZ3RoJTNEbGVuKGRhdGFzZXQpKQ==",highlighted:'tokenizer.train_from_iterator(batch_iterator(), trainer=trainer, length=<span class="hljs-built_in">len</span>(dataset))',wrap:!1}}),x=new jt({props:{title:"Using gzip files",local:"using-gzip-files",headingTag:"h2"}}),V=new F({props:{code:"aW1wb3J0JTIwZ3ppcCUwQXdpdGglMjBnemlwLm9wZW4oJTIyZGF0YSUyRm15LWZpbGUuMC5neiUyMiUyQyUyMCUyMnJ0JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplci50cmFpbl9mcm9tX2l0ZXJhdG9yKGYlMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`<span class="hljs-keyword">import</span> gzip
<span class="hljs-keyword">with</span> gzip.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;data/my-file.0.gz&quot;</span>, <span class="hljs-string">&quot;rt&quot;</span>) <span class="hljs-keyword">as</span> f:
    tokenizer.train_from_iterator(f, trainer=trainer)`,wrap:!1}}),W=new F({props:{code:"ZmlsZXMlMjAlM0QlMjAlNUIlMjJkYXRhJTJGbXktZmlsZS4wLmd6JTIyJTJDJTIwJTIyZGF0YSUyRm15LWZpbGUuMS5neiUyMiUyQyUyMCUyMmRhdGElMkZteS1maWxlLjIuZ3olMjIlNUQlMEFkZWYlMjBnemlwX2l0ZXJhdG9yKCklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBwYXRoJTIwaW4lMjBmaWxlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBnemlwLm9wZW4ocGF0aCUyQyUyMCUyMnJ0JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGxpbmUlMjBpbiUyMGYlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMGxpbmUlMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnemlwX2l0ZXJhdG9yKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`files = [<span class="hljs-string">&quot;data/my-file.0.gz&quot;</span>, <span class="hljs-string">&quot;data/my-file.1.gz&quot;</span>, <span class="hljs-string">&quot;data/my-file.2.gz&quot;</span>]
<span class="hljs-keyword">def</span> <span class="hljs-title function_">gzip_iterator</span>():
    <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> files:
        <span class="hljs-keyword">with</span> gzip.<span class="hljs-built_in">open</span>(path, <span class="hljs-string">&quot;rt&quot;</span>) <span class="hljs-keyword">as</span> f:
            <span class="hljs-keyword">for</span> line <span class="hljs-keyword">in</span> f:
                <span class="hljs-keyword">yield</span> line
tokenizer.train_from_iterator(gzip_iterator(), trainer=trainer)`,wrap:!1}}),{c(){u=i("meta"),q=a(),H=i("p"),S=a(),p(d.$$.fragment),E=a(),w=i("p"),w.innerHTML=bt,L=a(),U=i("p"),U.innerHTML=Tt,N=a(),p(f.$$.fragment),P=a(),j=i("p"),j.innerHTML=Ct,K=a(),J=i("p"),J.innerHTML=kt,D=a(),p(b.$$.fragment),O=a(),T=i("p"),T.innerHTML=gt,tt=a(),p(C.$$.fragment),et=a(),k=i("p"),k.innerHTML=It,lt=a(),p(g.$$.fragment),st=a(),I=i("p"),I.innerHTML=$t,at=a(),$=i("p"),$.textContent=zt,nt=a(),p(z.$$.fragment),it=a(),G=i("p"),G.textContent=Gt,rt=a(),p(X.$$.fragment),ot=a(),Z=i("p"),Z.textContent=Xt,pt=a(),v=i("p"),v.textContent=Zt,Mt=a(),p(B.$$.fragment),yt=a(),R=i("p"),R.textContent=vt,mt=a(),p(x.$$.fragment),ht=a(),_=i("p"),_.textContent=Bt,ct=a(),p(V.$$.fragment),ut=a(),A=i("p"),A.textContent=Rt,dt=a(),p(W.$$.fragment),wt=a(),Y=i("p"),Y.textContent=xt,Ut=a(),Q=i("p"),this.h()},l(t){const e=Qt("svelte-u9bgzb",document.head);u=r(e,"META",{name:!0,content:!0}),e.forEach(l),q=n(t),H=r(t,"P",{}),_t(H).forEach(l),S=n(t),M(d.$$.fragment,t),E=n(t),w=r(t,"P",{"data-svelte-h":!0}),o(w)!=="svelte-zs4zcn"&&(w.innerHTML=bt),L=n(t),U=r(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-19ksku3"&&(U.innerHTML=Tt),N=n(t),M(f.$$.fragment,t),P=n(t),j=r(t,"P",{"data-svelte-h":!0}),o(j)!=="svelte-187kexu"&&(j.innerHTML=Ct),K=n(t),J=r(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1cm91fx"&&(J.innerHTML=kt),D=n(t),M(b.$$.fragment,t),O=n(t),T=r(t,"P",{"data-svelte-h":!0}),o(T)!=="svelte-800zef"&&(T.innerHTML=gt),tt=n(t),M(C.$$.fragment,t),et=n(t),k=r(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-2k2g93"&&(k.innerHTML=It),lt=n(t),M(g.$$.fragment,t),st=n(t),I=r(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-tt7so"&&(I.innerHTML=$t),at=n(t),$=r(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-8j5br2"&&($.textContent=zt),nt=n(t),M(z.$$.fragment,t),it=n(t),G=r(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-134xe8u"&&(G.textContent=Gt),rt=n(t),M(X.$$.fragment,t),ot=n(t),Z=r(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-18jpyth"&&(Z.textContent=Xt),pt=n(t),v=r(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1ha2c1s"&&(v.textContent=Zt),Mt=n(t),M(B.$$.fragment,t),yt=n(t),R=r(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-9wooxy"&&(R.textContent=vt),mt=n(t),M(x.$$.fragment,t),ht=n(t),_=r(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-rvsukz"&&(_.textContent=Bt),ct=n(t),M(V.$$.fragment,t),ut=n(t),A=r(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1g7s20h"&&(A.textContent=Rt),dt=n(t),M(W.$$.fragment,t),wt=n(t),Y=r(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-15ag4ju"&&(Y.textContent=xt),Ut=n(t),Q=r(t,"P",{}),_t(Q).forEach(l),this.h()},h(){Vt(u,"name","hf:doc:metadata"),Vt(u,"content",Et)},m(t,e){qt(document.head,u),s(t,q,e),s(t,H,e),s(t,S,e),y(d,t,e),s(t,E,e),s(t,w,e),s(t,L,e),s(t,U,e),s(t,N,e),y(f,t,e),s(t,P,e),s(t,j,e),s(t,K,e),s(t,J,e),s(t,D,e),y(b,t,e),s(t,O,e),s(t,T,e),s(t,tt,e),y(C,t,e),s(t,et,e),s(t,k,e),s(t,lt,e),y(g,t,e),s(t,st,e),s(t,I,e),s(t,at,e),s(t,$,e),s(t,nt,e),y(z,t,e),s(t,it,e),s(t,G,e),s(t,rt,e),y(X,t,e),s(t,ot,e),s(t,Z,e),s(t,pt,e),s(t,v,e),s(t,Mt,e),y(B,t,e),s(t,yt,e),s(t,R,e),s(t,mt,e),y(x,t,e),s(t,ht,e),s(t,_,e),s(t,ct,e),y(V,t,e),s(t,ut,e),s(t,A,e),s(t,dt,e),y(W,t,e),s(t,wt,e),s(t,Y,e),s(t,Ut,e),s(t,Q,e),ft=!0},p:Wt,i(t){ft||(m(d.$$.fragment,t),m(f.$$.fragment,t),m(b.$$.fragment,t),m(C.$$.fragment,t),m(g.$$.fragment,t),m(z.$$.fragment,t),m(X.$$.fragment,t),m(B.$$.fragment,t),m(x.$$.fragment,t),m(V.$$.fragment,t),m(W.$$.fragment,t),ft=!0)},o(t){h(d.$$.fragment,t),h(f.$$.fragment,t),h(b.$$.fragment,t),h(C.$$.fragment,t),h(g.$$.fragment,t),h(z.$$.fragment,t),h(X.$$.fragment,t),h(B.$$.fragment,t),h(x.$$.fragment,t),h(V.$$.fragment,t),h(W.$$.fragment,t),ft=!1},d(t){t&&(l(q),l(H),l(S),l(E),l(w),l(L),l(U),l(N),l(P),l(j),l(K),l(J),l(D),l(O),l(T),l(tt),l(et),l(k),l(lt),l(st),l(I),l(at),l($),l(nt),l(it),l(G),l(rt),l(ot),l(Z),l(pt),l(v),l(Mt),l(yt),l(R),l(mt),l(ht),l(_),l(ct),l(ut),l(A),l(dt),l(wt),l(Y),l(Ut),l(Q)),l(u),c(d,t),c(f,t),c(b,t),c(C,t),c(g,t),c(z,t),c(X,t),c(B,t),c(x,t),c(V,t),c(W,t)}}}const Et='{"title":"Training from memory","local":"training-from-memory","sections":[{"title":"The most basic way","local":"the-most-basic-way","sections":[],"depth":2},{"title":"Using the 🤗 Datasets library","local":"using-the--datasets-library","sections":[],"depth":2},{"title":"Using gzip files","local":"using-gzip-files","sections":[],"depth":2}],"depth":1}';function Lt(Jt){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ot extends Ft{constructor(u){super(),Ht(this,u,Lt,St,At,{})}}export{Ot as component};
