import{s as El,f as tl,n as Ll,o as Wl}from"../chunks/scheduler.37c15a92.js";import{S as Rl,i as Ql,g as i,s as a,r as y,A as Sl,h as p,f as t,c as n,j as re,u as m,x as o,k as r,y as Vl,a as s,v as d,d as w,t as T,w as j}from"../chunks/index.2bf4358c.js";import{C as sl}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Xl}from"../chunks/CourseFloatingBanner.06521e8b.js";import{H as ie}from"../chunks/Heading.8ada512a.js";function Nl(al){let J,ue,pe,Me,h,ce,f,ye,U,nl=`В этом разделе мы подробно рассмотрим класс <code>Interface</code> и разберем
основные параметры, используемые для его создания.`,me,b,de,I,il="Вы заметите, что класс <code>Interface</code> имеет 3 обязательных параметра:",we,C,pl="<code>Interface(fn, inputs, outputs, ...)</code>",Te,v,ol="Это параметры:",je,k,rl="<li><code>fn</code>: функция прогнозирования, обернутая интерфейсом Gradio. Эта функция может принимать один или несколько параметров и возвращать одно или несколько значений</li> <li><code>inputs</code>: тип(ы) компонента(ов) ввода. Gradio предоставляет множество готовых компонентов, таких как <code>&quot;image&quot;</code> или <code>&quot;mic&quot;</code>.</li> <li><code>outputs</code>: тип(ы) компонента(ов) вывода. Опять же, Gradio предоставляет множество предварительно созданных компонентов, например, <code>&quot; image&quot;</code> или <code>&quot;label&quot;</code>.</li>",Je,g,ul='Полный список компонентов <a href="https://gradio.app/docs" rel="nofollow">смотрите в документации Gradio</a>. Каждый предварительно созданный компонент можно настроить, инстанцировав соответствующий ему класс.',he,A,Ml=`Например, как мы видели в <a href="../chapter9/2">предыдущем разделе</a>,
вместо передачи <code>&quot;textbox&quot;</code> в параметр <code>inputs</code>, вы можете передать компонент <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> для создания текстового поля с 7 строками и меткой.`,fe,x,cl="Давайте рассмотрим еще один пример, на этот раз с компонентом <code>Audio</code>.",Ue,q,be,G,yl=`Как уже говорилось, Gradio предоставляет множество различных входов и выходов.
Поэтому давайте создадим <code>Interface</code>, работающий с аудио.`,Ie,B,ml=`В этом примере мы создадим функцию audio-to-audio, которая принимает
аудиофайл и просто переворачивает его.`,Ce,_,dl=`Для ввода мы будем использовать компонент <code>Audio</code>. При использовании компонента <code>Audio</code>,
вы можете указать, будет ли источником звука файл, который загружает пользователь
или микрофон, с помощью которого пользователь записывает свой голос. В данном случае давайте
зададим <code>&quot;microphone&quot;</code>. Просто ради интереса добавим к <code>Audio</code> метку, которая будет гласить
“Speak here…“.`,ve,$,wl=`Кроме того, мы хотели бы получать аудио в виде массива numpy, чтобы можно было легко
“перевернуть” его. Поэтому мы зададим <code>&quot;type&quot;</code> в значение <code>&quot;numpy&quot;</code>, которое передаст входные
данные в виде кортежа (<code>sample_rate</code>, <code>data</code>) в нашу функцию.`,ke,Z,Tl=`Мы также будем использовать компонент вывода <code>Audio</code>, который может автоматически
рендерить кортеж с частотой дискретизации и массивом данных numpy в воспроизводимый аудиофайл.
В этом случае нам не нужно делать никаких настроек, поэтому мы будем использовать строку
ярлык <code>&quot;audio&quot;</code>.`,ge,H,Ae,E,jl=`Код, приведенный выше, создаст интерфейс, подобный приведенному ниже (если ваш браузер не
не запрашивает разрешения на использование микрофона, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">откройте демо в отдельной вкладке</a>.)`,xe,u,Jl,qe,L,hl="Теперь вы сможете записать свой голос и услышать, как вы говорите в обратную сторону - жутковато 👻!",Ge,W,Be,R,fl=`Допустим, у нас есть более сложная функция, с несколькими входами и выходами.
В примере ниже у нас есть функция, которая принимает индекс выпадающего списка, значение слайдера и число,
и возвращает пример музыкального тона.`,_e,Q,Ul=`Посмотрите, как мы передаем список входных и выходных компонентов,
и посмотрите, сможете ли вы проследить за тем, что происходит.`,$e,S,bl="Ключевым моментом здесь является то, что когда вы передаете:",Ze,V,Il="<li>список входных компонентов, каждый компонент соответствует параметру по порядку.</li> <li>список выходных компонентов, каждый компонент соответствует возвращаемому значению.</li>",He,X,Cl="В приведенном ниже фрагменте кода показано, как три компонента ввода соответствуют трем аргументам функции <code>generate_tone()</code>:",Ee,N,Le,M,vl,We,Y,Re,P,kl=`До сих пор мы использовали метод <code>launch()</code> для запуска интерфейса, но мы
не обсуждали, что он делает.`,Qe,z,gl=`По умолчанию метод <code>launch()</code> запускает демо на веб-сервере, который
работает локально. Если вы выполняете свой код в блокноте Jupyter или Colab, то
Gradio встроит демо GUI в блокнот, чтобы вы могли легко им пользоваться.`,Se,F,Al="Вы можете настроить поведение <code>launch()</code> с помощью различных параметров:",Ve,D,xl="<li><code>inline</code> - отображать ли интерфейс в виде строки в блокнотах Python.</li> <li><code>inbrowser</code> - автоматически ли запускать интерфейс в новой вкладке браузера по умолчанию.</li> <li><code>share</code> - создавать ли для интерфейса общедоступную ссылку с вашего компьютера. Что-то вроде ссылки на Google Drive!</li>",Xe,K,ql="Мы рассмотрим параметр <code>share</code> более подробно в следующем разделе!",Ne,O,Ye,ee,Gl=`Давайте создадим интерфейс, который позволит вам продемонстрировать демо модели <strong>распознавания речи</strong>.
Чтобы было интереснее, мы будем принимать <em>либо</em> микрофонный вход, либо загруженный файл.`,Pe,le,Bl=`Как обычно, мы загрузим нашу модель распознавания речи с помощью функции <code>pipeline()</code> из 🤗 Transformers.
Если вам нужно быстро вспомнить, вы можете вернуться к <a href="../chapter1/3">этому разделу в Главе 1</a>. Далее мы реализуем функцию <code>transcribe_audio()</code>, которая обрабатывает аудио и возвращает транскрипцию. Наконец, мы обернем эту функцию в <code>Interface</code> с компонентами <code>Audio</code> на входе и просто текстом на выходе. В целом, код этого приложения выглядит следующим образом:`,ze,te,Fe,se,_l='Если ваш браузер не запрашивает разрешения на использование микрофона, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">откройте демо в отдельной вкладке</a>.',De,c,$l,Ke,ae,Zl=`Вот и все! Теперь вы можете использовать этот интерфейс для транскрибирования аудио. Обратите внимание, что
передавая параметр <code>optional</code> как <code>True</code>, мы позволяем пользователю предоставить
либо микрофон, либо аудиофайл (либо ни то, ни другое, но в этом случае будет выдано сообщение об ошибке).`,Oe,ne,Hl="Продолжайте, чтобы узнать, как поделиться своим интерфейсом с другими!",el,oe,ll;return h=new ie({props:{title:"Понимание класса Interface",local:"understanding-the-interface-class",headingTag:"h1"}}),f=new Xl({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"}]}}),b=new ie({props:{title:"Как создать Interface",local:"how-to-create-an-interface",headingTag:"h2"}}),q=new ie({props:{title:"Простой пример со звуком",local:"a-simple-example-with-audio",headingTag:"h2"}}),H=new sl({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),W=new ie({props:{title:"Обработка нескольких входов и выходов",local:"handling-multiple-inputs-and-outputs",headingTag:"h2"}}),N=new sl({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godHlwZSUzRCUyMm51bWJlciUyMiUyQyUyMHZhbHVlJTNEMSUyQyUyMGxhYmVsJTNEJTIyRHVyYXRpb24lMjBpbiUyMHNlY29uZHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8lMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;number&quot;</span>, value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),Y=new ie({props:{title:"Метод launch()",local:"the-launch-method",headingTag:"h3"}}),O=new ie({props:{title:"✏️ Давайте применим это!",local:"lets-apply-it",headingTag:"h2"}}),te=new sl({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyJTJDJTIwb3B0aW9uYWwlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiUyQyUyMG9wdGlvbmFsJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIydGV4dCUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
        gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),{c(){J=i("meta"),ue=a(),pe=i("p"),Me=a(),y(h.$$.fragment),ce=a(),y(f.$$.fragment),ye=a(),U=i("p"),U.innerHTML=nl,me=a(),y(b.$$.fragment),de=a(),I=i("p"),I.innerHTML=il,we=a(),C=i("p"),C.innerHTML=pl,Te=a(),v=i("p"),v.textContent=ol,je=a(),k=i("ul"),k.innerHTML=rl,Je=a(),g=i("p"),g.innerHTML=ul,he=a(),A=i("p"),A.innerHTML=Ml,fe=a(),x=i("p"),x.innerHTML=cl,Ue=a(),y(q.$$.fragment),be=a(),G=i("p"),G.innerHTML=yl,Ie=a(),B=i("p"),B.textContent=ml,Ce=a(),_=i("p"),_.innerHTML=dl,ve=a(),$=i("p"),$.innerHTML=wl,ke=a(),Z=i("p"),Z.innerHTML=Tl,ge=a(),y(H.$$.fragment),Ae=a(),E=i("p"),E.innerHTML=jl,xe=a(),u=i("iframe"),qe=a(),L=i("p"),L.textContent=hl,Ge=a(),y(W.$$.fragment),Be=a(),R=i("p"),R.textContent=fl,_e=a(),Q=i("p"),Q.textContent=Ul,$e=a(),S=i("p"),S.textContent=bl,Ze=a(),V=i("ul"),V.innerHTML=Il,He=a(),X=i("p"),X.innerHTML=Cl,Ee=a(),y(N.$$.fragment),Le=a(),M=i("iframe"),We=a(),y(Y.$$.fragment),Re=a(),P=i("p"),P.innerHTML=kl,Qe=a(),z=i("p"),z.innerHTML=gl,Se=a(),F=i("p"),F.innerHTML=Al,Ve=a(),D=i("ul"),D.innerHTML=xl,Xe=a(),K=i("p"),K.innerHTML=ql,Ne=a(),y(O.$$.fragment),Ye=a(),ee=i("p"),ee.innerHTML=Gl,Pe=a(),le=i("p"),le.innerHTML=Bl,ze=a(),y(te.$$.fragment),Fe=a(),se=i("p"),se.innerHTML=_l,De=a(),c=i("iframe"),Ke=a(),ae=i("p"),ae.innerHTML=Zl,Oe=a(),ne=i("p"),ne.textContent=Hl,el=a(),oe=i("p"),this.h()},l(e){const l=Sl("svelte-u9bgzb",document.head);J=p(l,"META",{name:!0,content:!0}),l.forEach(t),ue=n(e),pe=p(e,"P",{}),re(pe).forEach(t),Me=n(e),m(h.$$.fragment,e),ce=n(e),m(f.$$.fragment,e),ye=n(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-enud80"&&(U.innerHTML=nl),me=n(e),m(b.$$.fragment,e),de=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-o67r3h"&&(I.innerHTML=il),we=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-5xxju6"&&(C.innerHTML=pl),Te=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-8iucyy"&&(v.textContent=ol),je=n(e),k=p(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-1akaxuo"&&(k.innerHTML=rl),Je=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-mxtpfm"&&(g.innerHTML=ul),he=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1gornw1"&&(A.innerHTML=Ml),fe=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-4nkf1r"&&(x.innerHTML=cl),Ue=n(e),m(q.$$.fragment,e),be=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-rfepod"&&(G.innerHTML=yl),Ie=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-n97h54"&&(B.textContent=ml),Ce=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-ar1v2m"&&(_.innerHTML=dl),ve=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1uvsg1h"&&($.innerHTML=wl),ke=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-c9vyv"&&(Z.innerHTML=Tl),ge=n(e),m(H.$$.fragment,e),Ae=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1af1p3z"&&(E.innerHTML=jl),xe=n(e),u=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(u).forEach(t),qe=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-jmjdad"&&(L.textContent=hl),Ge=n(e),m(W.$$.fragment,e),Be=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-s5r27g"&&(R.textContent=fl),_e=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1hey8tu"&&(Q.textContent=Ul),$e=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1lht4t5"&&(S.textContent=bl),Ze=n(e),V=p(e,"UL",{"data-svelte-h":!0}),o(V)!=="svelte-1p7h9vd"&&(V.innerHTML=Il),He=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-17e54rp"&&(X.innerHTML=Cl),Ee=n(e),m(N.$$.fragment,e),Le=n(e),M=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(M).forEach(t),We=n(e),m(Y.$$.fragment,e),Re=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-14rvhw3"&&(P.innerHTML=kl),Qe=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1ssmino"&&(z.innerHTML=gl),Se=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1gc9s6c"&&(F.innerHTML=Al),Ve=n(e),D=p(e,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-8vsj85"&&(D.innerHTML=xl),Xe=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-15hrsz7"&&(K.innerHTML=ql),Ne=n(e),m(O.$$.fragment,e),Ye=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-kv7bmf"&&(ee.innerHTML=Gl),Pe=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-ifycgo"&&(le.innerHTML=Bl),ze=n(e),m(te.$$.fragment,e),Fe=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1riv6tk"&&(se.innerHTML=_l),De=n(e),c=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(c).forEach(t),Ke=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1gkr56k"&&(ae.innerHTML=Zl),Oe=n(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-o596jh"&&(ne.textContent=Hl),el=n(e),oe=p(e,"P",{}),re(oe).forEach(t),this.h()},h(){r(J,"name","hf:doc:metadata"),r(J,"content",Yl),tl(u.src,Jl="https://course-demos-audio-reverse.hf.space")||r(u,"src",Jl),r(u,"frameborder","0"),r(u,"height","250"),r(u,"title","Gradio app"),r(u,"class","container p-0 flex-grow space-iframe"),r(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),tl(M.src,vl="https://course-demos-generate-tone.hf.space")||r(M,"src",vl),r(M,"frameborder","0"),r(M,"height","450"),r(M,"title","Gradio app"),r(M,"class","container p-0 flex-grow space-iframe"),r(M,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(M,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),tl(c.src,$l="https://course-demos-asr.hf.space")||r(c,"src",$l),r(c,"frameborder","0"),r(c,"height","550"),r(c,"title","Gradio app"),r(c,"class","container p-0 flex-grow space-iframe"),r(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,l){Vl(document.head,J),s(e,ue,l),s(e,pe,l),s(e,Me,l),d(h,e,l),s(e,ce,l),d(f,e,l),s(e,ye,l),s(e,U,l),s(e,me,l),d(b,e,l),s(e,de,l),s(e,I,l),s(e,we,l),s(e,C,l),s(e,Te,l),s(e,v,l),s(e,je,l),s(e,k,l),s(e,Je,l),s(e,g,l),s(e,he,l),s(e,A,l),s(e,fe,l),s(e,x,l),s(e,Ue,l),d(q,e,l),s(e,be,l),s(e,G,l),s(e,Ie,l),s(e,B,l),s(e,Ce,l),s(e,_,l),s(e,ve,l),s(e,$,l),s(e,ke,l),s(e,Z,l),s(e,ge,l),d(H,e,l),s(e,Ae,l),s(e,E,l),s(e,xe,l),s(e,u,l),s(e,qe,l),s(e,L,l),s(e,Ge,l),d(W,e,l),s(e,Be,l),s(e,R,l),s(e,_e,l),s(e,Q,l),s(e,$e,l),s(e,S,l),s(e,Ze,l),s(e,V,l),s(e,He,l),s(e,X,l),s(e,Ee,l),d(N,e,l),s(e,Le,l),s(e,M,l),s(e,We,l),d(Y,e,l),s(e,Re,l),s(e,P,l),s(e,Qe,l),s(e,z,l),s(e,Se,l),s(e,F,l),s(e,Ve,l),s(e,D,l),s(e,Xe,l),s(e,K,l),s(e,Ne,l),d(O,e,l),s(e,Ye,l),s(e,ee,l),s(e,Pe,l),s(e,le,l),s(e,ze,l),d(te,e,l),s(e,Fe,l),s(e,se,l),s(e,De,l),s(e,c,l),s(e,Ke,l),s(e,ae,l),s(e,Oe,l),s(e,ne,l),s(e,el,l),s(e,oe,l),ll=!0},p:Ll,i(e){ll||(w(h.$$.fragment,e),w(f.$$.fragment,e),w(b.$$.fragment,e),w(q.$$.fragment,e),w(H.$$.fragment,e),w(W.$$.fragment,e),w(N.$$.fragment,e),w(Y.$$.fragment,e),w(O.$$.fragment,e),w(te.$$.fragment,e),ll=!0)},o(e){T(h.$$.fragment,e),T(f.$$.fragment,e),T(b.$$.fragment,e),T(q.$$.fragment,e),T(H.$$.fragment,e),T(W.$$.fragment,e),T(N.$$.fragment,e),T(Y.$$.fragment,e),T(O.$$.fragment,e),T(te.$$.fragment,e),ll=!1},d(e){e&&(t(ue),t(pe),t(Me),t(ce),t(ye),t(U),t(me),t(de),t(I),t(we),t(C),t(Te),t(v),t(je),t(k),t(Je),t(g),t(he),t(A),t(fe),t(x),t(Ue),t(be),t(G),t(Ie),t(B),t(Ce),t(_),t(ve),t($),t(ke),t(Z),t(ge),t(Ae),t(E),t(xe),t(u),t(qe),t(L),t(Ge),t(Be),t(R),t(_e),t(Q),t($e),t(S),t(Ze),t(V),t(He),t(X),t(Ee),t(Le),t(M),t(We),t(Re),t(P),t(Qe),t(z),t(Se),t(F),t(Ve),t(D),t(Xe),t(K),t(Ne),t(Ye),t(ee),t(Pe),t(le),t(ze),t(Fe),t(se),t(De),t(c),t(Ke),t(ae),t(Oe),t(ne),t(el),t(oe)),t(J),j(h,e),j(f,e),j(b,e),j(q,e),j(H,e),j(W,e),j(N,e),j(Y,e),j(O,e),j(te,e)}}}const Yl='{"title":"Понимание класса Interface","local":"understanding-the-interface-class","sections":[{"title":"Как создать Interface","local":"how-to-create-an-interface","sections":[],"depth":2},{"title":"Простой пример со звуком","local":"a-simple-example-with-audio","sections":[],"depth":2},{"title":"Обработка нескольких входов и выходов","local":"handling-multiple-inputs-and-outputs","sections":[{"title":"Метод launch()","local":"the-launch-method","sections":[],"depth":3}],"depth":2},{"title":"✏️ Давайте применим это!","local":"lets-apply-it","sections":[],"depth":2}],"depth":1}';function Pl(al){return Wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class et extends Rl{constructor(J){super(),Ql(this,J,Pl,Nl,El,{})}}export{et as component};
