import{s as $t,n as Zt,o as Ct}from"../chunks/scheduler.85c25b89.js";import{S as Wt,i as Bt,g as p,s as l,r as m,A as kt,h as i,f as e,c as n,j as Ut,u as o,x as g,k as It,y as Nt,a,v as r,d as h,t as c,w as M}from"../chunks/index.c9837788.js";import{C as R}from"../chunks/CodeBlock.52fa569e.js";import{H as _,E as xt}from"../chunks/EditOnGithub.b65eee75.js";function Gt(Mt){let d,X,V,H,J,z,w,gt='<strong>ResNet-D</strong> is a modification on the <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> architecture that utilises an <a href="https://paperswithcode.com/method/average-pooling" rel="nofollow">average pooling</a> tweak for downsampling. The motivation is that in the unmodified ResNet, the <a href="https://paperswithcode.com/method/1x1-convolution" rel="nofollow">1×1 convolution</a> for the downsampling block ignores 3/4 of input feature maps, so this is modified so no information will be ignored',F,y,S,j,dt="To load a pretrained model:",A,T,L,u,Jt="To load and preprocess the image:",D,f,q,b,wt="To get the model predictions:",P,U,K,I,yt="To get the top-5 predictions class names:",O,$,tt,Z,jt="Replace the model name with the variant you want to use, e.g. <code>resnet101d</code>. You can find the IDs in the model summaries at the top of this page.",st,C,Tt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',et,W,at,B,ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",lt,k,nt,N,ft=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,pt,x,it,G,bt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',mt,E,ot,v,rt,Q,ht,Y,ct;return J=new _({props:{title:"ResNet-D",local:"resnet-d",headingTag:"h1"}}),y=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldDEwMWQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),k=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmV0MTAxZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),v=new R({props:{code:"JTQwbWlzYyU3QmhlMjAxOGJhZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCQmFnJTIwb2YlMjBUcmlja3MlMjBmb3IlMjBJbWFnZSUyMENsYXNzaWZpY2F0aW9uJTIwd2l0aCUyMENvbnZvbHV0aW9uYWwlMjBOZXVyYWwlMjBOZXR3b3JrcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QlRvbmclMjBIZSUyMGFuZCUyMFpoaSUyMFpoYW5nJTIwYW5kJTIwSGFuZyUyMFpoYW5nJTIwYW5kJTIwWmhvbmd5dWUlMjBaaGFuZyUyMGFuZCUyMEp1bnl1YW4lMjBYaWUlMjBhbmQlMjBNdSUyMExpJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTglN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxODEyLjAxMTg3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{he<span class="hljs-symbol">2018b</span>ag,
      title={<span class="hljs-keyword">Bag </span>of Tricks for Image Classification with Convolutional Neural Networks}, 
      author={Tong He <span class="hljs-keyword">and </span>Zhi Zhang <span class="hljs-keyword">and </span>Hang Zhang <span class="hljs-keyword">and </span>Zhongyue Zhang <span class="hljs-keyword">and </span><span class="hljs-keyword">Junyuan </span>Xie <span class="hljs-keyword">and </span>Mu Li},
      year={<span class="hljs-number">2018</span>},
      eprint={<span class="hljs-number">1812</span>.<span class="hljs-number">01187</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),Q=new xt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/resnet-d.mdx"}}),{c(){d=p("meta"),X=l(),V=p("p"),H=l(),m(J.$$.fragment),z=l(),w=p("p"),w.innerHTML=gt,F=l(),m(y.$$.fragment),S=l(),j=p("p"),j.textContent=dt,A=l(),m(T.$$.fragment),L=l(),u=p("p"),u.textContent=Jt,D=l(),m(f.$$.fragment),q=l(),b=p("p"),b.textContent=wt,P=l(),m(U.$$.fragment),K=l(),I=p("p"),I.textContent=yt,O=l(),m($.$$.fragment),tt=l(),Z=p("p"),Z.innerHTML=jt,st=l(),C=p("p"),C.innerHTML=Tt,et=l(),m(W.$$.fragment),at=l(),B=p("p"),B.textContent=ut,lt=l(),m(k.$$.fragment),nt=l(),N=p("p"),N.innerHTML=ft,pt=l(),m(x.$$.fragment),it=l(),G=p("p"),G.innerHTML=bt,mt=l(),m(E.$$.fragment),ot=l(),m(v.$$.fragment),rt=l(),m(Q.$$.fragment),ht=l(),Y=p("p"),this.h()},l(t){const s=kt("svelte-u9bgzb",document.head);d=i(s,"META",{name:!0,content:!0}),s.forEach(e),X=n(t),V=i(t,"P",{}),Ut(V).forEach(e),H=n(t),o(J.$$.fragment,t),z=n(t),w=i(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-8lziuy"&&(w.innerHTML=gt),F=n(t),o(y.$$.fragment,t),S=n(t),j=i(t,"P",{"data-svelte-h":!0}),g(j)!=="svelte-18ywhxh"&&(j.textContent=dt),A=n(t),o(T.$$.fragment,t),L=n(t),u=i(t,"P",{"data-svelte-h":!0}),g(u)!=="svelte-1c2ipa8"&&(u.textContent=Jt),D=n(t),o(f.$$.fragment,t),q=n(t),b=i(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1n9qsq1"&&(b.textContent=wt),P=n(t),o(U.$$.fragment,t),K=n(t),I=i(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-19cnvx1"&&(I.textContent=yt),O=n(t),o($.$$.fragment,t),tt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1iogwu7"&&(Z.innerHTML=jt),st=n(t),C=i(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-1wmi3ea"&&(C.innerHTML=Tt),et=n(t),o(W.$$.fragment,t),at=n(t),B=i(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-9sr7nh"&&(B.textContent=ut),lt=n(t),o(k.$$.fragment,t),nt=n(t),N=i(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1kguc51"&&(N.innerHTML=ft),pt=n(t),o(x.$$.fragment,t),it=n(t),G=i(t,"P",{"data-svelte-h":!0}),g(G)!=="svelte-xtxxu6"&&(G.innerHTML=bt),mt=n(t),o(E.$$.fragment,t),ot=n(t),o(v.$$.fragment,t),rt=n(t),o(Q.$$.fragment,t),ht=n(t),Y=i(t,"P",{}),Ut(Y).forEach(e),this.h()},h(){It(d,"name","hf:doc:metadata"),It(d,"content",Et)},m(t,s){Nt(document.head,d),a(t,X,s),a(t,V,s),a(t,H,s),r(J,t,s),a(t,z,s),a(t,w,s),a(t,F,s),r(y,t,s),a(t,S,s),a(t,j,s),a(t,A,s),r(T,t,s),a(t,L,s),a(t,u,s),a(t,D,s),r(f,t,s),a(t,q,s),a(t,b,s),a(t,P,s),r(U,t,s),a(t,K,s),a(t,I,s),a(t,O,s),r($,t,s),a(t,tt,s),a(t,Z,s),a(t,st,s),a(t,C,s),a(t,et,s),r(W,t,s),a(t,at,s),a(t,B,s),a(t,lt,s),r(k,t,s),a(t,nt,s),a(t,N,s),a(t,pt,s),r(x,t,s),a(t,it,s),a(t,G,s),a(t,mt,s),r(E,t,s),a(t,ot,s),r(v,t,s),a(t,rt,s),r(Q,t,s),a(t,ht,s),a(t,Y,s),ct=!0},p:Zt,i(t){ct||(h(J.$$.fragment,t),h(y.$$.fragment,t),h(T.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h($.$$.fragment,t),h(W.$$.fragment,t),h(k.$$.fragment,t),h(x.$$.fragment,t),h(E.$$.fragment,t),h(v.$$.fragment,t),h(Q.$$.fragment,t),ct=!0)},o(t){c(J.$$.fragment,t),c(y.$$.fragment,t),c(T.$$.fragment,t),c(f.$$.fragment,t),c(U.$$.fragment,t),c($.$$.fragment,t),c(W.$$.fragment,t),c(k.$$.fragment,t),c(x.$$.fragment,t),c(E.$$.fragment,t),c(v.$$.fragment,t),c(Q.$$.fragment,t),ct=!1},d(t){t&&(e(X),e(V),e(H),e(z),e(w),e(F),e(S),e(j),e(A),e(L),e(u),e(D),e(q),e(b),e(P),e(K),e(I),e(O),e(tt),e(Z),e(st),e(C),e(et),e(at),e(B),e(lt),e(nt),e(N),e(pt),e(it),e(G),e(mt),e(ot),e(rt),e(ht),e(Y)),e(d),M(J,t),M(y,t),M(T,t),M(f,t),M(U,t),M($,t),M(W,t),M(k,t),M(x,t),M(E,t),M(v,t),M(Q,t)}}}const Et='{"title":"ResNet-D","local":"resnet-d","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function vt(Mt){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends Wt{constructor(d){super(),Bt(this,d,vt,Gt,$t,{})}}export{_t as component};
