import{s as Ms,n as rs,o as cs}from"../chunks/scheduler.65852ee5.js";import{S as us,i as ys,g as i,s as a,r as m,A as ds,h as p,f as l,c as n,j as ms,u as o,x as M,k as os,y as hs,a as s,v as r,d as c,t as u,w as y}from"../chunks/index.65a1b999.js";import{D as Js,C as d}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as h,E as Ts}from"../chunks/getInferenceSnippets.aa1f4ff5.js";function bs(jl){let J,Yt,Et,Lt,T,Ht,b,qt,w,Ul='<em>Authored by: <a href="https://huggingface.co/AlanPonnachan" rel="nofollow">Alan Ponnachan</a></em>',Dt,j,fl="This notebook demonstrates a practical approach to building a domain-specific Question & Answering chatbot. We’ll focus on creating a chatbot that can answer questions about a specific piece of documentation – in this case, LangChain’s documentation on Chat Models.",Pt,U,gl="<strong>Goal:</strong> To fine-tune a small, efficient Language Model (LLM) to understand and answer questions about the LangChain Chat Models documentation.",Kt,f,Il="<strong>Approach:</strong>",Ot,g,Cl="<li><strong>Data Acquisition:</strong> Obtain the text content from the target LangChain documentation page.</li> <li><strong>Synthetic Data Generation:</strong> Use Meta’s <code>synthetic-data-kit</code> to automatically generate Question/Answer pairs from this documentation.</li> <li><strong>Efficient Fine-tuning:</strong> Employ Unsloth and <code>Hugging Face&#39;s TRL SFTTrainer</code> to efficiently fine-tune a Llama-3.2-3B model on the generated synthetic data.</li> <li><strong>Evaluation:</strong> Test the fine-tuned model with specific questions about the documentation.</li>",te,I,Zl="This method allows us to adapt an LLM to a niche domain without requiring a large, manually curated dataset.",ee,C,Gl="<strong>Hardware Used:</strong>",le,Z,Bl="This notebook was run on Google Colab (Free Tier) with an NVIDIA T4 GPU",se,G,ae,B,$l="First, we need to install the necessary libraries. We’ll use <code>unsloth</code> for efficient model handling and training, and <code>synthetic-data-kit</code> for generating our training data.",ne,$,ie,v,pe,W,me,k,vl="We’ll use <code>SyntheticDataKit</code> from Unsloth (which wraps Meta’s <code>synthetic-data-kit</code>) to create Question/Answer pairs from our chosen documentation.",oe,_,Me,R,Wl=`🦥 Unsloth: Will patch your computer to enable 2x faster free finetuning.
🦥 Unsloth Zoo will now patch everything to make training faster!
INFO 05-05 15:14:48 [__init__.py:239] Automatically detected platform cuda.
`,re,X,ce,F,ue,A,kl=`\x1B[?25l\x1B[32m VLLM server is running at \x1B[0m\x1B[4;94mhttp://localhost:8000/v1\x1B[0m
\x1B[32m⠋\x1B[0m\x1B[32m Checking VLLM server at http://localhost:8000/v1...\x1B[0m
\x1B[2KAvailable models: \x1B[1m&#123;\x1B[0m\x1B[32m'object'\x1B[0m: \x1B[32m'list'\x1B[0m, \x1B[32m'data'\x1B[0m: \x1B[1m[\x1B[0m\x1B[1m&#123;\x1B[0m\x1B[32m'id'\x1B[0m: 
\x1B[32m'unsloth/Llama-3.2-3B-Instruct'\x1B[0m, \x1B[32m'object'\x1B[0m: \x1B[32m'model'\x1B[0m, \x1B[32m'created'\x1B[0m: \x1B[1;36m1746459182\x1B[0m, 
\x1B[32m'owned_by'\x1B[0m: \x1B[32m'vllm'\x1B[0m, \x1B[32m'root'\x1B[0m: \x1B[32m'unsloth/Llama-3.2-3B-Instruct'\x1B[0m, \x1B[32m'parent'\x1B[0m: \x1B[3;35mNone\x1B[0m, 
\x1B[32m'max_model_len'\x1B[0m: \x1B[1;36m2048\x1B[0m, \x1B[32m'permission'\x1B[0m: \x1B[1m[\x1B[0m\x1B[1m&#123;\x1B[0m\x1B[32m'id'\x1B[0m: 
\x1B[32m'modelperm-5296f16bbd3c425a82af4d2f84f0cbfe'\x1B[0m, \x1B[32m'object'\x1B[0m: \x1B[32m'model_permission'\x1B[0m, 
\x1B[32m'created'\x1B[0m: \x1B[1;36m1746459182\x1B[0m, \x1B[32m'allow_create_engine'\x1B[0m: \x1B[3;91mFalse\x1B[0m, \x1B[32m'allow_sampling'\x1B[0m: \x1B[3;92mTrue\x1B[0m, 
\x1B[32m'allow_logprobs'\x1B[0m: \x1B[3;92mTrue\x1B[0m, \x1B[32m'allow_search_indices'\x1B[0m: \x1B[3;91mFalse\x1B[0m, \x1B[32m'allow_view'\x1B[0m: \x1B[3;92mTrue\x1B[0m, 
\x1B[32m'allow_fine_tuning'\x1B[0m: \x1B[3;91mFalse\x1B[0m, \x1B[32m'organization'\x1B[0m: \x1B[32m'*'\x1B[0m, \x1B[32m'group'\x1B[0m: \x1B[3;35mNone\x1B[0m, \x1B[32m'is_blocking'\x1B[0m: 
\x1B[3;91mFalse\x1B[0m\x1B[1m}\x1B[0m\x1B[1m]\x1B[0m\x1B[1m}\x1B[0m\x1B[1m]\x1B[0m\x1B[1m}\x1B[0m
\x1B[32m⠋\x1B[0m Checking VLLM server at http://localhost:8000/v1...
\x1B[2K\x1B[32m⠋\x1B[0m Checking VLLM server at http://localhost:8000/v1...
\x1B[?25h
\x1B[1A\x1B[2K
`,ye,x,de,z,_l='For this example, we’ll use the LangChain documentation page on <a href="https://github.com/langchain-ai/langchain/blob/master/docs/docs/concepts/chat_models.mdx" rel="nofollow">Chat Models</a>.',he,V,Rl="<strong>To get the text:</strong>",Je,N,Xl="<li>Go to the raw version of the MDX file (e.g., by clicking “Raw” on GitHub).</li> <li>Copy the entire text content.</li> <li>Save it locally as a <code>.txt</code> file. For this notebook, we assume you’ve saved it as <code>/content/langchain-ai-langchain.txt</code>. You can use a tool like <code>gitingest</code> or manual copy-paste.</li>",Te,Q,Fl="<strong>Note:</strong> Ensure the text file is uploaded to your Colab environment at <code>/content/langchain-ai-langchain.txt</code> if you’re running this in Colab.",be,E,we,S,Al=`\x1B[?25l\x1B[32m⠋\x1B[0m Processing /content/langchain-ai-langchain.txt...
\x1B[?25h
\x1B[1A\x1B[2K\x1B[32m Text successfully extracted to \x1B[0m\x1B[1;32mdata/output/langchain-ai-langchain.txt\x1B[0m
`,je,Y,Ue,L,xl="The ingested document will be split into smaller chunks, and then QA pairs will be generated for each chunk.",fe,H,ge,q,zl=`Created 3 chunks.
`,Ie,D,Ce,P,Ze,K,Vl="The generated QA pairs are then converted into a format suitable for fine-tuning.",Ge,O,Be,tt,Nl=`\x1B[?25l\x1B[32m⠋\x1B[0m Converting data/generated/langchain-ai-langchain_0_qa_pairs.json to ft format 
with json storage...
\x1B[?25h
\x1B[1A\x1B[2K\x1B[1A\x1B[2K\x1B[32m Converted to ft format and saved to \x1B[0m
\x1B[1;32mdata/final/langchain-ai-langchain_0_qa_pairs_ft.json\x1B[0m
\x1B[?25l\x1B[32m⠋\x1B[0m Converting data/generated/langchain-ai-langchain_1_qa_pairs.json to ft format 
with json storage...
\x1B[1A\x1B[2K\x1B[1A\x1B[2K\x1B[32m Converted to ft format and saved to \x1B[0m
\x1B[1;32mdata/final/langchain-ai-langchain_1_qa_pairs_ft.json\x1B[0m
`,$e,et,ve,lt,Ql=`Attempting to terminate the VLLM server gracefully...
Server did not terminate gracefully after 10 seconds. Forcing kill...
Server killed forcefully.
`,We,st,ke,at,El="Now, let’s load the generated and formatted data.",_e,nt,Re,it,Xe,pt,Fe,mt,Ae,ot,Sl="If you encounter CUDA Out-of-Memory (OOM) errors when trying to load the Llama model for fine-tuning in the next steps (even after <code>generator.cleanup()</code>), it means the GPU memory wasn’t fully released. This is common in environments like Google Colab’s free tier.",xe,Mt,Yl="<strong>Workaround Strategy:</strong>",ze,rt,Ll="<li><strong>Archive the generated data:</strong> After the <code>generator.cleanup()</code> cell, zip the entire <code>/content/data</code> folder and download to local.</li> <li><strong>Restart the Colab Runtime:</strong> Go to “Runtime” -&gt; “Restart runtime…“. This completely clears GPU memory.</li> <li><strong>Re-run Installations &amp; Imports:</strong> Execute the initial installation cells and necessary import cells again.</li> <li><strong>Restore Data:</strong> Upload the zip data folder and Unzip your data.</li> <li><strong>Load Dataset from Restored Files:</strong> Use a script to load from the unzipped <code>/content/data/final/</code> directory.</li> <li><strong>Proceed to model loading and fine-tuning.</strong></li>",Ve,ct,Hl="The cells below include commands for zipping. If you restart, you’d manually run the unzip and data loading code from the “Optional: Restart and Reload Data” section.",Ne,ut,Qe,yt,Ee,dt,ql="Now, we’ll load our base model using Unsloth for 4-bit quantization and then fine-tune it on our synthetically generated dataset.",Se,ht,Ye,Jt,Dl="We’ll use <code>Llama-3.2-3B-Instruct</code> in 4-bit precision. Unsloth makes this very memory-efficient.",Le,Tt,He,bt,Pl=`🦥 Unsloth: Will patch your computer to enable 2x faster free finetuning.
🦥 Unsloth Zoo will now patch everything to make training faster!
INFO 05-05 15:54:31 [__init__.py:239] Automatically detected platform cuda.
==((====))==  Unsloth 2025.4.7: Fast Llama patching. Transformers: 4.51.3. vLLM: 0.8.2.
   \\\\   /|    Tesla T4. Num GPUs = 1. Max memory: 14.741 GB. Platform: Linux.
O^O/ \\_/ \\    Torch: 2.6.0+cu124. CUDA: 7.5. CUDA Toolkit: 12.4. Triton: 3.2.0
\\        /    Bfloat16 = FALSE. FA [Xformers = 0.0.29.post3. FA2 = False]
 "-____-"     Free license: http://github.com/unslothai/unsloth
Unsloth: Fast downloading is enabled - ignore downloading bars which are red colored!
`,qe,wt,De,jt,Kl="We use LoRA (Low-Rank Adaptation) for parameter-efficient fine-tuning.",Pe,Ut,Ke,ft,Oe,gt,Ol="We need to format our dataset into the chat template expected by the Llama-3.2 model.",tl,It,el,Ct,ll,Zt,sl,Gt,al,Bt,ts="We’ll use Hugging Face TRL’s <code>SFTTrainer</code> to fine-tune the model with the SFTTrainer class—designed specifically for supervised fine-tuning (SFT). We configure the training parameters using SFTConfig, specifying the dataset, model, training steps, and optimization settings. This setup allows us to efficiently fine-tune models with gradient accumulation and mixed-precision optimizers like adamw_8bit, onlimited hardware environment.",nl,$t,il,vt,pl,Wt,ml,kt,es="Let’s test our fine-tuned model with some questions related to the LangChain Chat Models documentation.",ol,_t,Ml,Rt,ls=`Standard [tool calling API](/docs/concepts/tool_calling): standard interface for binding tools to models.<|eot_id|>
`,rl,Xt,cl,Ft,ss="We have successfully:",ul,At,as='<li>Acquired documentation text for <a href="https://github.com/langchain-ai/langchain/blob/master/docs/docs/concepts/chat_models.mdx" rel="nofollow">LangChain Chat Models</a>..</li> <li>Generated synthetic Question/Answer pairs using <a href="https://github.com/meta-llama/synthetic-data-kit" rel="nofollow"><code>synthetic-data-kit</code></a>.</li> <li>Fine-tuned a Llama-3.2-3B model efficiently using Unsloth and <a href="https://huggingface.co/docs/trl/en/sft_trainer" rel="nofollow">Hugging Face’s TRL SFTTrainer</a>.</li> <li>Tested the model’s ability to answer questions specific to the documentation.</li>',yl,xt,ns="This notebook provides a template for creating specialized chatbots for various documentation or domain-specific texts. The use of synthetic data generation and efficient fine-tuning techniques makes this approach accessible even with limited resources.",dl,zt,is="<strong>Further improvements could include:</strong>",hl,Vt,ps="<li>Using a larger portion of the documentation or multiple related pages.</li> <li>More sophisticated curation of synthetic QA pairs.</li> <li>Experimenting with different base models or hyperparameter tuning.</li> <li>Implementing a more robust evaluation framework (e.g., comparing against a held-out set of questions or using metrics like ROUGE, BLEU if applicable, or LLM-as-a-judge).</li>",Jl,Nt,Tl,Qt,bl,St,wl;return T=new Js({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/fine_tune_chatbot_docs_synthetic.ipynb"}]}}),b=new h({props:{title:"Documentation Chatbot with Meta Synthetic Data Kit",local:"documentation-chatbot-with-meta-synthetic-data-kit",headingTag:"h1"}}),G=new h({props:{title:"1. Setup and Installation",local:"1-setup-and-installation",headingTag:"h2"}}),$=new d({props:{code:"JTI1JTI1Y2FwdHVyZSUwQSUyMyUyMEluJTIwQ29sYWIlMkMlMjB3ZSUyMHNraXAlMjBkZXBlbmRlbmN5JTIwaW5zdGFsbGF0aW9uJTIwdG8lMjBhdm9pZCUyMGNvbmZsaWN0cyUyMHdpdGglMjBwcmVpbnN0YWxsZWQlMjBwYWNrYWdlcy4lMEElMjMlMjBPbiUyMGxvY2FsJTIwbWFjaGluZXMlMkMlMjB3ZSUyMGluY2x1ZGUlMjBkZXBlbmRlbmNpZXMlMjBmb3IlMjBjb21wbGV0ZW5lc3MuJTBBJTBBaW1wb3J0JTIwb3MlMEFpZiUyMCUyMkNPTEFCXyUyMiUyMG5vdCUyMGluJTIwJTIyJTIyLmpvaW4ob3MuZW52aXJvbi5rZXlzKCkpJTNBJTBBJTIwJTIwJTIwJTIwIXBpcCUyMGluc3RhbGwlMjB1bnNsb3RoJTIwdmxsbSUzRCUzRDAuOC4yJTBBZWxzZSUzQSUwQSUwQSUyMCUyMCUyMCUyMCFwaXAlMjBpbnN0YWxsJTIwLS1uby1kZXBzJTIwdW5zbG90aCUyMHZsbG0lM0QlM0QwLjguMiUwQSUwQSUyMyUyMEdldCUyMGh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRm1ldGEtbGxhbWElMkZzeW50aGV0aWMtZGF0YS1raXQlMEEhcGlwJTIwaW5zdGFsbCUyMHN5bnRoZXRpYy1kYXRhLWtpdA==",highlighted:`%%capture
<span class="hljs-comment"># In Colab, we skip dependency installation to avoid conflicts with preinstalled packages.</span>
<span class="hljs-comment"># On local machines, we include dependencies for completeness.</span>

<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">if</span> <span class="hljs-string">&quot;COLAB_&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-string">&quot;&quot;</span>.join(os.environ.keys()):
    !pip install unsloth vllm==<span class="hljs-number">0.8</span><span class="hljs-number">.2</span>
<span class="hljs-keyword">else</span>:

    !pip install --no-deps unsloth vllm==<span class="hljs-number">0.8</span><span class="hljs-number">.2</span>

<span class="hljs-comment"># Get https://github.com/meta-llama/synthetic-data-kit</span>
!pip install synthetic-data-kit`,wrap:!1}}),v=new d({props:{code:"JTI1JTI1Y2FwdHVyZSUwQWltcG9ydCUyMG9zJTBBaWYlMjAlMjJDT0xBQl8lMjIlMjBpbiUyMCUyMiUyMi5qb2luKG9zLmVudmlyb24ua2V5cygpKSUzQSUwQSUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMHN5cyUyQyUyMHJlJTJDJTIwcmVxdWVzdHMlM0IlMjBtb2R1bGVzJTIwJTNEJTIwbGlzdChzeXMubW9kdWxlcy5rZXlzKCkpJTBBJTIwJTIwJTIwJTIwZm9yJTIweCUyMGluJTIwbW9kdWxlcyUzQSUyMHN5cy5tb2R1bGVzLnBvcCh4KSUyMGlmJTIwJTIyUElMJTIyJTIwaW4lMjB4JTIwb3IlMjAlMjJnb29nbGUlMjIlMjBpbiUyMHglMjBlbHNlJTIwTm9uZSUwQSUyMCUyMCUyMCUyMCFwaXAlMjBpbnN0YWxsJTIwLS1uby1kZXBzJTIwYml0c2FuZGJ5dGVzJTIwYWNjZWxlcmF0ZSUyMHhmb3JtZXJzJTNEJTNEMC4wLjI5LnBvc3QzJTIwcGVmdCUyMCUyMnRybCUzRCUzRDAuMTUuMiUyMiUyMHRyaXRvbiUyMGN1dF9jcm9zc19lbnRyb3B5JTIwdW5zbG90aF96b28lMEElMjAlMjAlMjAlMjAhcGlwJTIwaW5zdGFsbCUyMHNlbnRlbmNlcGllY2UlMjBwcm90b2J1ZiUyMGRhdGFzZXRzJTIwaHVnZ2luZ2ZhY2VfaHViJTVCaGZfeGV0JTVEJTIwaGZfdHJhbnNmZXIlMEElMEElMjAlMjAlMjAlMjAlMjMlMjB2TExNJTIwcmVxdWlyZW1lbnRzJTIwLSUyMHZMTE0lMjBicmVha3MlMjBDb2xhYiUyMGR1ZSUyMHRvJTIwcmVpbnN0YWxsaW5nJTIwbnVtcHklMEElMjAlMjAlMjAlMjBmJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRnZsbG0tcHJvamVjdCUyRnZsbG0lMkZyZWZzJTJGaGVhZHMlMkZtYWluJTJGcmVxdWlyZW1lbnRzJTJGY29tbW9uLnR4dCUyMikuY29udGVudCUwQSUyMCUyMCUyMCUyMHdpdGglMjBvcGVuKCUyMnZsbG1fcmVxdWlyZW1lbnRzLnR4dCUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZmlsZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbGUud3JpdGUocmUuc3ViKHJiJTIyKHRyYW5zZm9ybWVycyU3Q251bXB5JTdDeGZvcm1lcnMlN0NpbXBvcnRsaWJfbWV0YWRhdGEpJTVCJTVFJTVDbiU1RCU3QjAlMkMlN0QlNUNuJTIyJTJDJTIwYiUyMiUyMiUyQyUyMGYpKSUwQSUyMCUyMCUyMCUyMCFwaXAlMjBpbnN0YWxsJTIwLXIlMjB2bGxtX3JlcXVpcmVtZW50cy50eHQ=",highlighted:`%%capture
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">if</span> <span class="hljs-string">&quot;COLAB_&quot;</span> <span class="hljs-keyword">in</span> <span class="hljs-string">&quot;&quot;</span>.join(os.environ.keys()):

    <span class="hljs-keyword">import</span> sys, re, requests; modules = <span class="hljs-built_in">list</span>(sys.modules.keys())
    <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> modules: sys.modules.pop(x) <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;PIL&quot;</span> <span class="hljs-keyword">in</span> x <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;google&quot;</span> <span class="hljs-keyword">in</span> x <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    !pip install --no-deps bitsandbytes accelerate xformers==<span class="hljs-number">0.0</span><span class="hljs-number">.29</span>.post3 peft <span class="hljs-string">&quot;trl==0.15.2&quot;</span> triton cut_cross_entropy unsloth_zoo
    !pip install sentencepiece protobuf datasets huggingface_hub[hf_xet] hf_transfer

    <span class="hljs-comment"># vLLM requirements - vLLM breaks Colab due to reinstalling numpy</span>
    f = requests.get(<span class="hljs-string">&quot;https://raw.githubusercontent.com/vllm-project/vllm/refs/heads/main/requirements/common.txt&quot;</span>).content
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;vllm_requirements.txt&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> file:
        file.write(re.sub(<span class="hljs-string">rb&quot;(transformers|numpy|xformers|importlib_metadata)[^\\n]{0,}\\n&quot;</span>, <span class="hljs-string">b&quot;&quot;</span>, f))
    !pip install -r vllm_requirements.txt`,wrap:!1}}),W=new h({props:{title:"2. Synthetic Data Generation",local:"2-synthetic-data-generation",headingTag:"h2"}}),_=new d({props:{code:"ZnJvbSUyMHVuc2xvdGguZGF0YXByZXAlMjBpbXBvcnQlMjBTeW50aGV0aWNEYXRhS2l0JTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwU3ludGhldGljRGF0YUtpdC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfbmFtZSUzRCUyMnVuc2xvdGglMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDIwNDglMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> unsloth.dataprep <span class="hljs-keyword">import</span> SyntheticDataKit

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = SyntheticDataKit.from_pretrained(
<span class="hljs-meta">... </span>    model_name=<span class="hljs-string">&quot;unsloth/Llama-3.2-3B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    max_seq_length=<span class="hljs-number">2048</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),X=new d({props:{code:"Z2VuZXJhdG9yLnByZXBhcmVfcWFfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRfZm9sZGVyJTNEJTIyZGF0YSUyMiUyQyUyMCUyMCUyMyUyME91dHB1dCUyMGxvY2F0aW9uJTIwb2YlMjBzeW50aGV0aWMlMjBkYXRhJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjclMkMlMjAlMjAlMjMlMjBIaWdoZXIlMjB0ZW1wJTIwbWFrZXMlMjBtb3JlJTIwZGl2ZXJzZSUyMGRhdGElMEElMjAlMjAlMjAlMjB0b3BfcCUzRDAuOTUlMkMlMEElMjAlMjAlMjAlMjBvdmVybGFwJTNENjQlMkMlMjAlMjAlMjMlMjBPdmVybGFwJTIwcG9ydGlvbiUyMGR1cmluZyUyMGNodW5raW5nJTBBJTIwJTIwJTIwJTIwbWF4X2dlbmVyYXRpb25fdG9rZW5zJTNENTEyJTJDJTIwJTIwJTIzJTIwQ2FuJTIwaW5jcmVhc2UlMjBmb3IlMjBsb25nZXIlMjBRQSUyMHBhaXJzJTBBKQ==",highlighted:`generator.prepare_qa_generation(
    output_folder=<span class="hljs-string">&quot;data&quot;</span>,  <span class="hljs-comment"># Output location of synthetic data</span>
    temperature=<span class="hljs-number">0.7</span>,  <span class="hljs-comment"># Higher temp makes more diverse data</span>
    top_p=<span class="hljs-number">0.95</span>,
    overlap=<span class="hljs-number">64</span>,  <span class="hljs-comment"># Overlap portion during chunking</span>
    max_generation_tokens=<span class="hljs-number">512</span>,  <span class="hljs-comment"># Can increase for longer QA pairs</span>
)`,wrap:!1}}),F=new d({props:{code:"IXN5bnRoZXRpYy1kYXRhLWtpdCUyMHN5c3RlbS1jaGVjaw==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!synthetic-data-kit system-check',wrap:!1}}),x=new h({props:{title:"2.1. Acquire and Ingest Documentation",local:"21-acquire-and-ingest-documentation",headingTag:"h3"}}),E=new d({props:{code:"JTIzJTIwTWFrZSUyMHN1cmUlMjBzeW50aGV0aWNfZGF0YV9raXRfY29uZmlnLnlhbWwlMjBwb2ludHMlMjB0byUyMHRoZSUyMCdkYXRhX2RvY3MnJTIwZm9sZGVyJTBBIXN5bnRoZXRpYy1kYXRhLWtpdCUyMC1jJTIwc3ludGhldGljX2RhdGFfa2l0X2NvbmZpZy55YW1sJTIwaW5nZXN0JTIwJTJGY29udGVudCUyRmxhbmdjaGFpbi1haS1sYW5nY2hhaW4udHh0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Make sure synthetic_data_kit_config.yaml points to the &#x27;data_docs&#x27; folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>!synthetic-data-kit -c synthetic_data_kit_config.yaml ingest /content/langchain-ai-langchain.txt`,wrap:!1}}),Y=new h({props:{title:"2.2. Chunk Data and Generate QA Pairs",local:"22-chunk-data-and-generate-qa-pairs",headingTag:"h3"}}),H=new d({props:{code:"ZmlsZW5hbWVzJTIwJTNEJTIwZ2VuZXJhdG9yLmNodW5rX2RhdGEoJTIyZGF0YSUyRm91dHB1dCUyRmxhbmdjaGFpbi1haS1sYW5nY2hhaW4udHh0JTIyKSUwQXByaW50KGYlMjJDcmVhdGVkJTIwJTdCbGVuKGZpbGVuYW1lcyklN0QlMjBjaHVua3MuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>filenames = generator.chunk_data(<span class="hljs-string">&quot;data/output/langchain-ai-langchain.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Created <span class="hljs-subst">{<span class="hljs-built_in">len</span>(filenames)}</span> chunks.&quot;</span>)`,wrap:!1}}),D=new d({props:{code:"aW1wb3J0JTIwdGltZSUwQSUyMyUyMFByb2Nlc3MlMjAyJTIwY2h1bmtzJTIwZm9yJTIwbm93JTIwLSUzRSUyMGNhbiUyMGluY3JlYXNlJTIwYnV0JTIwc2xvd2VyISUwQWZvciUyMGZpbGVuYW1lJTIwaW4lMjBmaWxlbmFtZXMlNUIlM0EyJTVEJTNBJTBBJTIwJTIwJTIwJTIwIXN5bnRoZXRpYy1kYXRhLWtpdCUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC1jJTIwc3ludGhldGljX2RhdGFfa2l0X2NvbmZpZy55YW1sJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3JlYXRlJTIwJTdCZmlsZW5hbWUlN0QlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtLW51bS1wYWlycyUyMDI1JTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLS10eXBlJTIwJTIycWElMjIlMEElMjAlMjAlMjAlMjB0aW1lLnNsZWVwKDIpJTIwJTIzJTIwU2xlZXAlMjBzb21lJTIwdGltZSUyMHRvJTIwbGVhdmUlMjBzb21lJTIwcm9vbSUyMGZvciUyMHByb2Nlc3Npbmc=",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-comment"># Process 2 chunks for now -&gt; can increase but slower!</span>
<span class="hljs-keyword">for</span> filename <span class="hljs-keyword">in</span> filenames[:<span class="hljs-number">2</span>]:
    !synthetic-data-kit \\
        -c synthetic_data_kit_config.yaml \\
        create {filename} \\
        --num-pairs <span class="hljs-number">25</span> \\
        --<span class="hljs-built_in">type</span> <span class="hljs-string">&quot;qa&quot;</span>
    time.sleep(<span class="hljs-number">2</span>) <span class="hljs-comment"># Sleep some time to leave some room for processing</span>`,wrap:!1}}),P=new h({props:{title:"2.3. Format and Save QA Pairs",local:"23-format-and-save-qa-pairs",headingTag:"h3"}}),O=new d({props:{code:"cWFfcGFpcnNfZmlsZW5hbWVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwZiUyMmRhdGElMkZnZW5lcmF0ZWQlMkZsYW5nY2hhaW4tYWktbGFuZ2NoYWluXyU3QmklN0RfcWFfcGFpcnMuanNvbiUyMiUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihmaWxlbmFtZXMlNUIlM0EyJTVEKSklMEElNUQlMEFmb3IlMjBmaWxlbmFtZSUyMGluJTIwcWFfcGFpcnNfZmlsZW5hbWVzJTNBJTBBJTIwJTIwJTIwJTIwIXN5bnRoZXRpYy1kYXRhLWtpdCUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC1jJTIwc3ludGhldGljX2RhdGFfa2l0X2NvbmZpZy55YW1sJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2F2ZS1hcyUyMCU3QmZpbGVuYW1lJTdEJTIwLWYlMjBmdA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>qa_pairs_filenames = [
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;data/generated/langchain-ai-langchain_<span class="hljs-subst">{i}</span>_qa_pairs.json&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(filenames[:<span class="hljs-number">2</span>]))
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> filename <span class="hljs-keyword">in</span> qa_pairs_filenames:
<span class="hljs-meta">... </span>    !synthetic-data-kit \\
<span class="hljs-meta">... </span>        -c synthetic_data_kit_config.yaml \\
<span class="hljs-meta">... </span>        save-<span class="hljs-keyword">as</span> {filename} -f ft`,wrap:!1}}),et=new d({props:{code:"Z2VuZXJhdG9yLmNsZWFudXAoKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>generator.cleanup()',wrap:!1}}),st=new h({props:{title:"2.4. Load the Formatted Dataset",local:"24-load-the-formatted-dataset",headingTag:"h3"}}),nt=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEFmaW5hbF9maWxlbmFtZXMlMjAlM0QlMjAlNUJmJTIyZGF0YSUyRmZpbmFsJTJGbGFuZ2NoYWluLWFpLWxhbmdjaGFpbl8lN0JpJTdEX3FhX3BhaXJzX2Z0Lmpzb24lMjIlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZmlsZW5hbWVzJTVCJTNBMiU1RCkpJTVEJTBBY29udmVyc2F0aW9ucyUyMCUzRCUyMHBkLmNvbmNhdCglNUJwZC5yZWFkX2pzb24obmFtZSklMjBmb3IlMjBuYW1lJTIwaW4lMjBmaW5hbF9maWxlbmFtZXMlNUQpLnJlc2V0X2luZGV4KGRyb3AlM0RUcnVlKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fcGFuZGFzKGNvbnZlcnNhdGlvbnMp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

final_filenames = [<span class="hljs-string">f&quot;data/final/langchain-ai-langchain_<span class="hljs-subst">{i}</span>_qa_pairs_ft.json&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(filenames[:<span class="hljs-number">2</span>]))]
conversations = pd.concat([pd.read_json(name) <span class="hljs-keyword">for</span> name <span class="hljs-keyword">in</span> final_filenames]).reset_index(drop=<span class="hljs-literal">True</span>)

dataset = Dataset.from_pandas(conversations)`,wrap:!1}}),it=new d({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]',wrap:!1}}),pt=new d({props:{code:"ZGF0YXNldCU1Qi0xJTVE",highlighted:'dataset[-<span class="hljs-number">1</span>]',wrap:!1}}),mt=new h({props:{title:"Memory Management Note (Critical for Resource-Constrained Environments)",local:"memory-management-note-critical-for-resource-constrained-environments",headingTag:"h3"}}),ut=new d({props:{code:"JTIzJTIwIXppcCUyMC1yJTIwZGF0YS56aXAlMjAlMkZjb250ZW50JTJGJTBBJTIzJTIwIXVuemlwJTIwZGF0YS56aXAlMEElMEElMjMlMjBpbXBvcnQlMjBvcyUwQSUyMyUyMGltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMjMlMjBmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBJTIzJTIwJTIzJTIwUGF0aCUyMHRvJTIweW91ciUyMGZvbGRlciUyMGNvbnRhaW5pbmclMjBKU09OJTIwZmlsZXMlMEElMjMlMjBmb2xkZXJfcGF0aCUyMCUzRCUyMCdjb250ZW50JTJGZGF0YSUyRmZpbmFsJTJGJyUwQSUwQSUyMyUyMCUyMyUyMExpc3QlMjBhbGwlMjAuanNvbiUyMGZpbGVzJTIwaW4lMjB0aGUlMjBmb2xkZXIlMEElMjMlMjBmaW5hbF9maWxlbmFtZXMlMjAlM0QlMjAlNUJvcy5wYXRoLmpvaW4oZm9sZGVyX3BhdGglMkMlMjBmKSUyMGZvciUyMGYlMjBpbiUyMG9zLmxpc3RkaXIoZm9sZGVyX3BhdGgpJTIwaWYlMjBmLmVuZHN3aXRoKCcuanNvbicpJTVEJTBBJTBBJTIzJTIwJTIzJTIwUmVhZCUyMGFuZCUyMGNvbWJpbmUlMjB0aGUlMjBKU09OJTIwZmlsZXMlMEElMjMlMjBjb252ZXJzYXRpb25zJTIwJTNEJTIwcGQuY29uY2F0KCU1QiUwQSUyMyUyMCUyMCUyMCUyMCUyMHBkLnJlYWRfanNvbihuYW1lKSUyMGZvciUyMG5hbWUlMjBpbiUyMGZpbmFsX2ZpbGVuYW1lcyUwQSUyMyUyMCU1RCkucmVzZXRfaW5kZXgoZHJvcCUzRFRydWUpJTBBJTBBJTIzJTIwJTIzJTIwQ29udmVydCUyMHRvJTIwSHVnZ2luZyUyMEZhY2UlMjBEYXRhc2V0JTBBJTIzJTIwZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9wYW5kYXMoY29udmVyc2F0aW9ucyk=",highlighted:`<span class="hljs-comment"># !zip -r data.zip /content/</span>
<span class="hljs-comment"># !unzip data.zip</span>

<span class="hljs-comment"># import os</span>
<span class="hljs-comment"># import pandas as pd</span>
<span class="hljs-comment"># from datasets import Dataset</span>

<span class="hljs-comment"># # Path to your folder containing JSON files</span>
<span class="hljs-comment"># folder_path = &#x27;content/data/final/&#x27;</span>

<span class="hljs-comment"># # List all .json files in the folder</span>
<span class="hljs-comment"># final_filenames = [os.path.join(folder_path, f) for f in os.listdir(folder_path) if f.endswith(&#x27;.json&#x27;)]</span>

<span class="hljs-comment"># # Read and combine the JSON files</span>
<span class="hljs-comment"># conversations = pd.concat([</span>
<span class="hljs-comment">#     pd.read_json(name) for name in final_filenames</span>
<span class="hljs-comment"># ]).reset_index(drop=True)</span>

<span class="hljs-comment"># # Convert to Hugging Face Dataset</span>
<span class="hljs-comment"># dataset = Dataset.from_pandas(conversations)</span>`,wrap:!1}}),yt=new h({props:{title:"3. Fine-tuning the LLM with Unsloth",local:"3-fine-tuning-the-llm-with-unsloth",headingTag:"h2"}}),ht=new h({props:{title:"3.1. Load Base Model and Tokenizer",local:"31-load-base-model-and-tokenizer",headingTag:"h3"}}),Tt=new d({props:{code:"ZnJvbSUyMHVuc2xvdGglMjBpbXBvcnQlMjBGYXN0TGFuZ3VhZ2VNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBJTBBbW9kZWwlMkMlMjB0b2tlbml6ZXIlMjAlM0QlMjBGYXN0TGFuZ3VhZ2VNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfbmFtZSUzRCUyMnVuc2xvdGglMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDEwMjQlMkMlMjAlMjAlMjMlMjBDaG9vc2UlMjBhbnklMjBmb3IlMjBsb25nJTIwY29udGV4dCElMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwJTIwJTIzJTIwNCUyMGJpdCUyMHF1YW50aXphdGlvbiUyMHRvJTIwcmVkdWNlJTIwbWVtb3J5JTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNERmFsc2UlMkMlMjAlMjAlMjMlMjAlNUJORVchJTVEJTIwQSUyMGJpdCUyMG1vcmUlMjBhY2N1cmF0ZSUyQyUyMHVzZXMlMjAyeCUyMG1lbW9yeSUwQSUyMCUyMCUyMCUyMGZ1bGxfZmluZXR1bmluZyUzREZhbHNlJTJDJTIwJTIwJTIzJTIwJTVCTkVXISU1RCUyMFdlJTIwaGF2ZSUyMGZ1bGwlMjBmaW5ldHVuaW5nJTIwbm93ISUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch


<span class="hljs-meta">&gt;&gt;&gt; </span>model, tokenizer = FastLanguageModel.from_pretrained(
<span class="hljs-meta">... </span>    model_name=<span class="hljs-string">&quot;unsloth/Llama-3.2-3B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    max_seq_length=<span class="hljs-number">1024</span>,  <span class="hljs-comment"># Choose any for long context!</span>
<span class="hljs-meta">... </span>    load_in_4bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># 4 bit quantization to reduce memory</span>
<span class="hljs-meta">... </span>    load_in_8bit=<span class="hljs-literal">False</span>,  <span class="hljs-comment"># [NEW!] A bit more accurate, uses 2x memory</span>
<span class="hljs-meta">... </span>    full_finetuning=<span class="hljs-literal">False</span>,  <span class="hljs-comment"># [NEW!] We have full finetuning now!</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),wt=new h({props:{title:"3.2. Add LoRA Adapters",local:"32-add-lora-adapters",headingTag:"h3"}}),Ut=new d({props:{code:"bW9kZWwlMjAlM0QlMjBGYXN0TGFuZ3VhZ2VNb2RlbC5nZXRfcGVmdF9tb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUyMCUyMCUyMyUyMENob29zZSUyMGFueSUyMG51bWJlciUyMCUzRSUyMDAlMjAhJTIwU3VnZ2VzdGVkJTIwOCUyQyUyMDE2JTJDJTIwMzIlMkMlMjA2NCUyQyUyMDEyOCUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycV9wcm9qJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIya19wcm9qJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydl9wcm9qJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb19wcm9qJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZ2F0ZV9wcm9qJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydXBfcHJvaiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRvd25fcHJvaiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAlMkMlMjAlMjAlMjMlMjBTdXBwb3J0cyUyMGFueSUyQyUyMGJ1dCUyMCUzRCUyMDAlMjBpcyUyMG9wdGltaXplZCUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTIwJTIwJTIzJTIwU3VwcG9ydHMlMjBhbnklMkMlMjBidXQlMjAlM0QlMjAlMjJub25lJTIyJTIwaXMlMjBvcHRpbWl6ZWQlMEElMjAlMjAlMjAlMjAlMjMlMjAlNUJORVclNUQlMjAlMjJ1bnNsb3RoJTIyJTIwdXNlcyUyMDMwJTI1JTIwbGVzcyUyMFZSQU0lMkMlMjBmaXRzJTIwMnglMjBsYXJnZXIlMjBiYXRjaCUyMHNpemVzISUwQSUyMCUyMCUyMCUyMHVzZV9ncmFkaWVudF9jaGVja3BvaW50aW5nJTNEJTIydW5zbG90aCUyMiUyQyUyMCUyMCUyMyUyMFRydWUlMjBvciUyMCUyMnVuc2xvdGglMjIlMjBmb3IlMjB2ZXJ5JTIwbG9uZyUyMGNvbnRleHQlMEElMjAlMjAlMjAlMjByYW5kb21fc3RhdGUlM0QzNDA3JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3JzbG9yYSUzREZhbHNlJTJDJTIwJTIwJTIzJTIwV2UlMjBzdXBwb3J0JTIwcmFuayUyMHN0YWJpbGl6ZWQlMjBMb1JBJTBBJTIwJTIwJTIwJTIwbG9mdHFfY29uZmlnJTNETm9uZSUyQyUyMCUyMCUyMyUyMEFuZCUyMExvZnRRJTBBKQ==",highlighted:`model = FastLanguageModel.get_peft_model(
    model,
    r=<span class="hljs-number">16</span>,  <span class="hljs-comment"># Choose any number &gt; 0 ! Suggested 8, 16, 32, 64, 128</span>
    target_modules=[
        <span class="hljs-string">&quot;q_proj&quot;</span>,
        <span class="hljs-string">&quot;k_proj&quot;</span>,
        <span class="hljs-string">&quot;v_proj&quot;</span>,
        <span class="hljs-string">&quot;o_proj&quot;</span>,
        <span class="hljs-string">&quot;gate_proj&quot;</span>,
        <span class="hljs-string">&quot;up_proj&quot;</span>,
        <span class="hljs-string">&quot;down_proj&quot;</span>,
    ],
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0</span>,  <span class="hljs-comment"># Supports any, but = 0 is optimized</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,  <span class="hljs-comment"># Supports any, but = &quot;none&quot; is optimized</span>
    <span class="hljs-comment"># [NEW] &quot;unsloth&quot; uses 30% less VRAM, fits 2x larger batch sizes!</span>
    use_gradient_checkpointing=<span class="hljs-string">&quot;unsloth&quot;</span>,  <span class="hljs-comment"># True or &quot;unsloth&quot; for very long context</span>
    random_state=<span class="hljs-number">3407</span>,
    use_rslora=<span class="hljs-literal">False</span>,  <span class="hljs-comment"># We support rank stabilized LoRA</span>
    loftq_config=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># And LoftQ</span>
)`,wrap:!1}}),ft=new h({props:{title:"3.3. Data Preparation for Chat Format",local:"33-data-preparation-for-chat-format",headingTag:"h3"}}),It=new d({props:{code:"JTNDJTdDYmVnaW5fb2ZfdGV4dCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXN5c3RlbSUzQyU3Q2VuZF9oZWFkZXJfaWQlN0MlM0UlMEElMEFDdXR0aW5nJTIwS25vd2xlZGdlJTIwRGF0ZSUzQSUyMERlY2VtYmVyJTIwMjAyMyUwQVRvZGF5JTIwRGF0ZSUzQSUyMDAxJTIwTWF5JTIwMjAyNSUwQSUwQVlvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBJTBBV2hhdCUyMGlzJTIwMSUyQjElM0YlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBJTBBMiUzQyU3Q2VvdF9pZCU3QyUzRQ==",highlighted:`&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;

<span class="hljs-type">Cutting</span> <span class="hljs-type">Knowledge</span> <span class="hljs-type">Date</span>: <span class="hljs-type">December</span> <span class="hljs-number">2023</span>
<span class="hljs-type">Today</span> <span class="hljs-type">Date</span>: <span class="hljs-number">01</span> <span class="hljs-type">May</span> <span class="hljs-number">2025</span>

<span class="hljs-type">You</span> are a helpful assistant.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;

<span class="hljs-type">What</span> is <span class="hljs-number">1</span>+<span class="hljs-number">1</span>?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;

<span class="hljs-number">2</span>&lt;|eot_id|&gt;`,wrap:!1}}),Ct=new d({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19wcm9tcHRzX2Z1bmMoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwY29udm9zJTIwJTNEJTIwZXhhbXBsZXMlNUIlMjJtZXNzYWdlcyUyMiU1RCUwQSUyMCUyMCUyMCUyMHRleHRzJTIwJTNEJTIwJTVCdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY29udm8lMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTIwZm9yJTIwY29udm8lMjBpbiUyMGNvbnZvcyU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjB0ZXh0cyUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQSUwQXBhc3MlMEElMEElMjMlMjBHZXQlMjBvdXIlMjBwcmV2aW91cyUyMGRhdGFzZXQlMjBhbmQlMjBmb3JtYXQlMjBpdCUzQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcCglMEElMjAlMjAlMjAlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoZWQlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">examples</span>):
    convos = examples[<span class="hljs-string">&quot;messages&quot;</span>]
    texts = [tokenizer.apply_chat_template(convo, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>) <span class="hljs-keyword">for</span> convo <span class="hljs-keyword">in</span> convos]
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;text&quot;</span>: texts,
    }


<span class="hljs-keyword">pass</span>

<span class="hljs-comment"># Get our previous dataset and format it:</span>
dataset = dataset.<span class="hljs-built_in">map</span>(
    formatting_prompts_func,
    batched=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),Zt=new d({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]',wrap:!1}}),Gt=new h({props:{title:"3.4. Train the Model",local:"34-train-the-model",headingTag:"h3"}}),$t=new d({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMkMlMjBTRlRDb25maWclMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0ROb25lJTJDJTIwJTIwJTIzJTIwQ2FuJTIwc2V0JTIwdXAlMjBldmFsdWF0aW9uISUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RTRlRDb25maWcoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTIwJTIwJTIzJTIwVXNlJTIwR0ElMjB0byUyMG1pbWljJTIwYmF0Y2glMjBzaXplISUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdhcm11cF9zdGVwcyUzRDUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q2MCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QyZS00JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbSUzRCUyMmFkYW13XzhiaXQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3ZWlnaHRfZGVjYXklM0QwLjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyX3R5cGUlM0QlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWVkJTNEMzQwNyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9ydF90byUzRCUyMm5vbmUlMjIlMkMlMjAlMjAlMjMlMjBVc2UlMjB0aGlzJTIwZm9yJTIwV2FuZEIlMjBldGMlMEElMjAlMjAlMjAlMjApJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, SFTConfig

trainer = SFTTrainer(
    model=model,
    tokenizer=tokenizer,
    train_dataset=dataset,
    eval_dataset=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># Can set up evaluation!</span>
    args=SFTConfig(
        dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
        per_device_train_batch_size=<span class="hljs-number">2</span>,
        gradient_accumulation_steps=<span class="hljs-number">4</span>,  <span class="hljs-comment"># Use GA to mimic batch size!</span>
        warmup_steps=<span class="hljs-number">5</span>,
        max_steps=<span class="hljs-number">60</span>,
        learning_rate=<span class="hljs-number">2e-4</span>,
        logging_steps=<span class="hljs-number">1</span>,
        optim=<span class="hljs-string">&quot;adamw_8bit&quot;</span>,
        weight_decay=<span class="hljs-number">0.01</span>,
        lr_scheduler_type=<span class="hljs-string">&quot;linear&quot;</span>,
        seed=<span class="hljs-number">3407</span>,
        report_to=<span class="hljs-string">&quot;none&quot;</span>,  <span class="hljs-comment"># Use this for WandB etc</span>
    ),
)`,wrap:!1}}),vt=new d({props:{code:"dHJhaW5lcl9zdGF0cyUyMCUzRCUyMHRyYWluZXIudHJhaW4oKQ==",highlighted:"trainer_stats = trainer.train()",wrap:!1}}),Wt=new h({props:{title:"4. Inference and Testing",local:"4-inference-and-testing",headingTag:"h2"}}),_t=new d({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBzdGFuZGFyZCUyMGludGVyZmFjZSUyMGZvciUyMGJpbmRpbmclMjB0b29scyUyMHRvJTIwbW9kZWxzJTNGJTIyJTdEJTJDJTBBJTVEJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwJTIwJTIzJTIwTXVzdCUyMGFkZCUyMGZvciUyMGdlbmVyYXRpb24lMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUZXh0U3RyZWFtZXIlMEElMEF0ZXh0X3N0cmVhbWVyJTIwJTNEJTIwVGV4dFN0cmVhbWVyKHRva2VuaXplciUyQyUyMHNraXBfcHJvbXB0JTNEVHJ1ZSklMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTNEaW5wdXRzJTJDJTIwc3RyZWFtZXIlM0R0ZXh0X3N0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMjB0ZW1wZXJhdHVyZSUzRDAuMSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the standard interface for binding tools to models?&quot;</span>},
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer.apply_chat_template(
<span class="hljs-meta">... </span>    messages,
<span class="hljs-meta">... </span>    tokenize=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    add_generation_prompt=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Must add for generation</span>
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>text_streamer = TextStreamer(tokenizer, skip_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(input_ids=inputs, streamer=text_streamer, max_new_tokens=<span class="hljs-number">256</span>, temperature=<span class="hljs-number">0.1</span>)`,wrap:!1}}),Xt=new h({props:{title:"5. Conclusion",local:"5-conclusion",headingTag:"h2"}}),Nt=new d({props:{code:"",highlighted:"",wrap:!1}}),Qt=new Ts({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/fine_tune_chatbot_docs_synthetic.md"}}),{c(){J=i("meta"),Yt=a(),Et=i("p"),Lt=a(),m(T.$$.fragment),Ht=a(),m(b.$$.fragment),qt=a(),w=i("p"),w.innerHTML=Ul,Dt=a(),j=i("p"),j.textContent=fl,Pt=a(),U=i("p"),U.innerHTML=gl,Kt=a(),f=i("p"),f.innerHTML=Il,Ot=a(),g=i("ol"),g.innerHTML=Cl,te=a(),I=i("p"),I.textContent=Zl,ee=a(),C=i("p"),C.innerHTML=Gl,le=a(),Z=i("p"),Z.textContent=Bl,se=a(),m(G.$$.fragment),ae=a(),B=i("p"),B.innerHTML=$l,ne=a(),m($.$$.fragment),ie=a(),m(v.$$.fragment),pe=a(),m(W.$$.fragment),me=a(),k=i("p"),k.innerHTML=vl,oe=a(),m(_.$$.fragment),Me=a(),R=i("pre"),R.textContent=Wl,re=a(),m(X.$$.fragment),ce=a(),m(F.$$.fragment),ue=a(),A=i("pre"),A.textContent=kl,ye=a(),m(x.$$.fragment),de=a(),z=i("p"),z.innerHTML=_l,he=a(),V=i("p"),V.innerHTML=Rl,Je=a(),N=i("ol"),N.innerHTML=Xl,Te=a(),Q=i("p"),Q.innerHTML=Fl,be=a(),m(E.$$.fragment),we=a(),S=i("pre"),S.textContent=Al,je=a(),m(Y.$$.fragment),Ue=a(),L=i("p"),L.textContent=xl,fe=a(),m(H.$$.fragment),ge=a(),q=i("pre"),q.textContent=zl,Ie=a(),m(D.$$.fragment),Ce=a(),m(P.$$.fragment),Ze=a(),K=i("p"),K.textContent=Vl,Ge=a(),m(O.$$.fragment),Be=a(),tt=i("pre"),tt.textContent=Nl,$e=a(),m(et.$$.fragment),ve=a(),lt=i("pre"),lt.textContent=Ql,We=a(),m(st.$$.fragment),ke=a(),at=i("p"),at.textContent=El,_e=a(),m(nt.$$.fragment),Re=a(),m(it.$$.fragment),Xe=a(),m(pt.$$.fragment),Fe=a(),m(mt.$$.fragment),Ae=a(),ot=i("p"),ot.innerHTML=Sl,xe=a(),Mt=i("p"),Mt.innerHTML=Yl,ze=a(),rt=i("ol"),rt.innerHTML=Ll,Ve=a(),ct=i("p"),ct.textContent=Hl,Ne=a(),m(ut.$$.fragment),Qe=a(),m(yt.$$.fragment),Ee=a(),dt=i("p"),dt.textContent=ql,Se=a(),m(ht.$$.fragment),Ye=a(),Jt=i("p"),Jt.innerHTML=Dl,Le=a(),m(Tt.$$.fragment),He=a(),bt=i("pre"),bt.textContent=Pl,qe=a(),m(wt.$$.fragment),De=a(),jt=i("p"),jt.textContent=Kl,Pe=a(),m(Ut.$$.fragment),Ke=a(),m(ft.$$.fragment),Oe=a(),gt=i("p"),gt.textContent=Ol,tl=a(),m(It.$$.fragment),el=a(),m(Ct.$$.fragment),ll=a(),m(Zt.$$.fragment),sl=a(),m(Gt.$$.fragment),al=a(),Bt=i("p"),Bt.innerHTML=ts,nl=a(),m($t.$$.fragment),il=a(),m(vt.$$.fragment),pl=a(),m(Wt.$$.fragment),ml=a(),kt=i("p"),kt.textContent=es,ol=a(),m(_t.$$.fragment),Ml=a(),Rt=i("pre"),Rt.textContent=ls,rl=a(),m(Xt.$$.fragment),cl=a(),Ft=i("p"),Ft.textContent=ss,ul=a(),At=i("ol"),At.innerHTML=as,yl=a(),xt=i("p"),xt.textContent=ns,dl=a(),zt=i("p"),zt.innerHTML=is,hl=a(),Vt=i("ul"),Vt.innerHTML=ps,Jl=a(),m(Nt.$$.fragment),Tl=a(),m(Qt.$$.fragment),bl=a(),St=i("p"),this.h()},l(t){const e=ds("svelte-u9bgzb",document.head);J=p(e,"META",{name:!0,content:!0}),e.forEach(l),Yt=n(t),Et=p(t,"P",{}),ms(Et).forEach(l),Lt=n(t),o(T.$$.fragment,t),Ht=n(t),o(b.$$.fragment,t),qt=n(t),w=p(t,"P",{"data-svelte-h":!0}),M(w)!=="svelte-c06g5p"&&(w.innerHTML=Ul),Dt=n(t),j=p(t,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1cnaxkg"&&(j.textContent=fl),Pt=n(t),U=p(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-73dzvq"&&(U.innerHTML=gl),Kt=n(t),f=p(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-i4nscf"&&(f.innerHTML=Il),Ot=n(t),g=p(t,"OL",{"data-svelte-h":!0}),M(g)!=="svelte-1le0kfw"&&(g.innerHTML=Cl),te=n(t),I=p(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1rs47kw"&&(I.textContent=Zl),ee=n(t),C=p(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1orajwa"&&(C.innerHTML=Gl),le=n(t),Z=p(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-y9jr31"&&(Z.textContent=Bl),se=n(t),o(G.$$.fragment,t),ae=n(t),B=p(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-17owk8i"&&(B.innerHTML=$l),ne=n(t),o($.$$.fragment,t),ie=n(t),o(v.$$.fragment,t),pe=n(t),o(W.$$.fragment,t),me=n(t),k=p(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-9jqzic"&&(k.innerHTML=vl),oe=n(t),o(_.$$.fragment,t),Me=n(t),R=p(t,"PRE",{"data-svelte-h":!0}),M(R)!=="svelte-1hlm4ai"&&(R.textContent=Wl),re=n(t),o(X.$$.fragment,t),ce=n(t),o(F.$$.fragment,t),ue=n(t),A=p(t,"PRE",{"data-svelte-h":!0}),M(A)!=="svelte-1vvuct2"&&(A.textContent=kl),ye=n(t),o(x.$$.fragment,t),de=n(t),z=p(t,"P",{"data-svelte-h":!0}),M(z)!=="svelte-fvf5ac"&&(z.innerHTML=_l),he=n(t),V=p(t,"P",{"data-svelte-h":!0}),M(V)!=="svelte-18woua2"&&(V.innerHTML=Rl),Je=n(t),N=p(t,"OL",{"data-svelte-h":!0}),M(N)!=="svelte-1hhu8ba"&&(N.innerHTML=Xl),Te=n(t),Q=p(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-12vz8vx"&&(Q.innerHTML=Fl),be=n(t),o(E.$$.fragment,t),we=n(t),S=p(t,"PRE",{"data-svelte-h":!0}),M(S)!=="svelte-1c1fim5"&&(S.textContent=Al),je=n(t),o(Y.$$.fragment,t),Ue=n(t),L=p(t,"P",{"data-svelte-h":!0}),M(L)!=="svelte-174504e"&&(L.textContent=xl),fe=n(t),o(H.$$.fragment,t),ge=n(t),q=p(t,"PRE",{"data-svelte-h":!0}),M(q)!=="svelte-1jnwt9n"&&(q.textContent=zl),Ie=n(t),o(D.$$.fragment,t),Ce=n(t),o(P.$$.fragment,t),Ze=n(t),K=p(t,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1qd6zzu"&&(K.textContent=Vl),Ge=n(t),o(O.$$.fragment,t),Be=n(t),tt=p(t,"PRE",{"data-svelte-h":!0}),M(tt)!=="svelte-xkwqfq"&&(tt.textContent=Nl),$e=n(t),o(et.$$.fragment,t),ve=n(t),lt=p(t,"PRE",{"data-svelte-h":!0}),M(lt)!=="svelte-7imcon"&&(lt.textContent=Ql),We=n(t),o(st.$$.fragment,t),ke=n(t),at=p(t,"P",{"data-svelte-h":!0}),M(at)!=="svelte-2zxtoy"&&(at.textContent=El),_e=n(t),o(nt.$$.fragment,t),Re=n(t),o(it.$$.fragment,t),Xe=n(t),o(pt.$$.fragment,t),Fe=n(t),o(mt.$$.fragment,t),Ae=n(t),ot=p(t,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-ra054m"&&(ot.innerHTML=Sl),xe=n(t),Mt=p(t,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-w67mbi"&&(Mt.innerHTML=Yl),ze=n(t),rt=p(t,"OL",{"data-svelte-h":!0}),M(rt)!=="svelte-zckd8z"&&(rt.innerHTML=Ll),Ve=n(t),ct=p(t,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-idkzl3"&&(ct.textContent=Hl),Ne=n(t),o(ut.$$.fragment,t),Qe=n(t),o(yt.$$.fragment,t),Ee=n(t),dt=p(t,"P",{"data-svelte-h":!0}),M(dt)!=="svelte-142vbq7"&&(dt.textContent=ql),Se=n(t),o(ht.$$.fragment,t),Ye=n(t),Jt=p(t,"P",{"data-svelte-h":!0}),M(Jt)!=="svelte-48hl85"&&(Jt.innerHTML=Dl),Le=n(t),o(Tt.$$.fragment,t),He=n(t),bt=p(t,"PRE",{"data-svelte-h":!0}),M(bt)!=="svelte-15aiiyo"&&(bt.textContent=Pl),qe=n(t),o(wt.$$.fragment,t),De=n(t),jt=p(t,"P",{"data-svelte-h":!0}),M(jt)!=="svelte-1c2y3vw"&&(jt.textContent=Kl),Pe=n(t),o(Ut.$$.fragment,t),Ke=n(t),o(ft.$$.fragment,t),Oe=n(t),gt=p(t,"P",{"data-svelte-h":!0}),M(gt)!=="svelte-4dekm1"&&(gt.textContent=Ol),tl=n(t),o(It.$$.fragment,t),el=n(t),o(Ct.$$.fragment,t),ll=n(t),o(Zt.$$.fragment,t),sl=n(t),o(Gt.$$.fragment,t),al=n(t),Bt=p(t,"P",{"data-svelte-h":!0}),M(Bt)!=="svelte-1lapb9t"&&(Bt.innerHTML=ts),nl=n(t),o($t.$$.fragment,t),il=n(t),o(vt.$$.fragment,t),pl=n(t),o(Wt.$$.fragment,t),ml=n(t),kt=p(t,"P",{"data-svelte-h":!0}),M(kt)!=="svelte-1x9d7gm"&&(kt.textContent=es),ol=n(t),o(_t.$$.fragment,t),Ml=n(t),Rt=p(t,"PRE",{"data-svelte-h":!0}),M(Rt)!=="svelte-obtvzv"&&(Rt.textContent=ls),rl=n(t),o(Xt.$$.fragment,t),cl=n(t),Ft=p(t,"P",{"data-svelte-h":!0}),M(Ft)!=="svelte-x5xn5v"&&(Ft.textContent=ss),ul=n(t),At=p(t,"OL",{"data-svelte-h":!0}),M(At)!=="svelte-1o9abay"&&(At.innerHTML=as),yl=n(t),xt=p(t,"P",{"data-svelte-h":!0}),M(xt)!=="svelte-1i9u9tk"&&(xt.textContent=ns),dl=n(t),zt=p(t,"P",{"data-svelte-h":!0}),M(zt)!=="svelte-1tazzm1"&&(zt.innerHTML=is),hl=n(t),Vt=p(t,"UL",{"data-svelte-h":!0}),M(Vt)!=="svelte-157e32j"&&(Vt.innerHTML=ps),Jl=n(t),o(Nt.$$.fragment,t),Tl=n(t),o(Qt.$$.fragment,t),bl=n(t),St=p(t,"P",{}),ms(St).forEach(l),this.h()},h(){os(J,"name","hf:doc:metadata"),os(J,"content",ws)},m(t,e){hs(document.head,J),s(t,Yt,e),s(t,Et,e),s(t,Lt,e),r(T,t,e),s(t,Ht,e),r(b,t,e),s(t,qt,e),s(t,w,e),s(t,Dt,e),s(t,j,e),s(t,Pt,e),s(t,U,e),s(t,Kt,e),s(t,f,e),s(t,Ot,e),s(t,g,e),s(t,te,e),s(t,I,e),s(t,ee,e),s(t,C,e),s(t,le,e),s(t,Z,e),s(t,se,e),r(G,t,e),s(t,ae,e),s(t,B,e),s(t,ne,e),r($,t,e),s(t,ie,e),r(v,t,e),s(t,pe,e),r(W,t,e),s(t,me,e),s(t,k,e),s(t,oe,e),r(_,t,e),s(t,Me,e),s(t,R,e),s(t,re,e),r(X,t,e),s(t,ce,e),r(F,t,e),s(t,ue,e),s(t,A,e),s(t,ye,e),r(x,t,e),s(t,de,e),s(t,z,e),s(t,he,e),s(t,V,e),s(t,Je,e),s(t,N,e),s(t,Te,e),s(t,Q,e),s(t,be,e),r(E,t,e),s(t,we,e),s(t,S,e),s(t,je,e),r(Y,t,e),s(t,Ue,e),s(t,L,e),s(t,fe,e),r(H,t,e),s(t,ge,e),s(t,q,e),s(t,Ie,e),r(D,t,e),s(t,Ce,e),r(P,t,e),s(t,Ze,e),s(t,K,e),s(t,Ge,e),r(O,t,e),s(t,Be,e),s(t,tt,e),s(t,$e,e),r(et,t,e),s(t,ve,e),s(t,lt,e),s(t,We,e),r(st,t,e),s(t,ke,e),s(t,at,e),s(t,_e,e),r(nt,t,e),s(t,Re,e),r(it,t,e),s(t,Xe,e),r(pt,t,e),s(t,Fe,e),r(mt,t,e),s(t,Ae,e),s(t,ot,e),s(t,xe,e),s(t,Mt,e),s(t,ze,e),s(t,rt,e),s(t,Ve,e),s(t,ct,e),s(t,Ne,e),r(ut,t,e),s(t,Qe,e),r(yt,t,e),s(t,Ee,e),s(t,dt,e),s(t,Se,e),r(ht,t,e),s(t,Ye,e),s(t,Jt,e),s(t,Le,e),r(Tt,t,e),s(t,He,e),s(t,bt,e),s(t,qe,e),r(wt,t,e),s(t,De,e),s(t,jt,e),s(t,Pe,e),r(Ut,t,e),s(t,Ke,e),r(ft,t,e),s(t,Oe,e),s(t,gt,e),s(t,tl,e),r(It,t,e),s(t,el,e),r(Ct,t,e),s(t,ll,e),r(Zt,t,e),s(t,sl,e),r(Gt,t,e),s(t,al,e),s(t,Bt,e),s(t,nl,e),r($t,t,e),s(t,il,e),r(vt,t,e),s(t,pl,e),r(Wt,t,e),s(t,ml,e),s(t,kt,e),s(t,ol,e),r(_t,t,e),s(t,Ml,e),s(t,Rt,e),s(t,rl,e),r(Xt,t,e),s(t,cl,e),s(t,Ft,e),s(t,ul,e),s(t,At,e),s(t,yl,e),s(t,xt,e),s(t,dl,e),s(t,zt,e),s(t,hl,e),s(t,Vt,e),s(t,Jl,e),r(Nt,t,e),s(t,Tl,e),r(Qt,t,e),s(t,bl,e),s(t,St,e),wl=!0},p:rs,i(t){wl||(c(T.$$.fragment,t),c(b.$$.fragment,t),c(G.$$.fragment,t),c($.$$.fragment,t),c(v.$$.fragment,t),c(W.$$.fragment,t),c(_.$$.fragment,t),c(X.$$.fragment,t),c(F.$$.fragment,t),c(x.$$.fragment,t),c(E.$$.fragment,t),c(Y.$$.fragment,t),c(H.$$.fragment,t),c(D.$$.fragment,t),c(P.$$.fragment,t),c(O.$$.fragment,t),c(et.$$.fragment,t),c(st.$$.fragment,t),c(nt.$$.fragment,t),c(it.$$.fragment,t),c(pt.$$.fragment,t),c(mt.$$.fragment,t),c(ut.$$.fragment,t),c(yt.$$.fragment,t),c(ht.$$.fragment,t),c(Tt.$$.fragment,t),c(wt.$$.fragment,t),c(Ut.$$.fragment,t),c(ft.$$.fragment,t),c(It.$$.fragment,t),c(Ct.$$.fragment,t),c(Zt.$$.fragment,t),c(Gt.$$.fragment,t),c($t.$$.fragment,t),c(vt.$$.fragment,t),c(Wt.$$.fragment,t),c(_t.$$.fragment,t),c(Xt.$$.fragment,t),c(Nt.$$.fragment,t),c(Qt.$$.fragment,t),wl=!0)},o(t){u(T.$$.fragment,t),u(b.$$.fragment,t),u(G.$$.fragment,t),u($.$$.fragment,t),u(v.$$.fragment,t),u(W.$$.fragment,t),u(_.$$.fragment,t),u(X.$$.fragment,t),u(F.$$.fragment,t),u(x.$$.fragment,t),u(E.$$.fragment,t),u(Y.$$.fragment,t),u(H.$$.fragment,t),u(D.$$.fragment,t),u(P.$$.fragment,t),u(O.$$.fragment,t),u(et.$$.fragment,t),u(st.$$.fragment,t),u(nt.$$.fragment,t),u(it.$$.fragment,t),u(pt.$$.fragment,t),u(mt.$$.fragment,t),u(ut.$$.fragment,t),u(yt.$$.fragment,t),u(ht.$$.fragment,t),u(Tt.$$.fragment,t),u(wt.$$.fragment,t),u(Ut.$$.fragment,t),u(ft.$$.fragment,t),u(It.$$.fragment,t),u(Ct.$$.fragment,t),u(Zt.$$.fragment,t),u(Gt.$$.fragment,t),u($t.$$.fragment,t),u(vt.$$.fragment,t),u(Wt.$$.fragment,t),u(_t.$$.fragment,t),u(Xt.$$.fragment,t),u(Nt.$$.fragment,t),u(Qt.$$.fragment,t),wl=!1},d(t){t&&(l(Yt),l(Et),l(Lt),l(Ht),l(qt),l(w),l(Dt),l(j),l(Pt),l(U),l(Kt),l(f),l(Ot),l(g),l(te),l(I),l(ee),l(C),l(le),l(Z),l(se),l(ae),l(B),l(ne),l(ie),l(pe),l(me),l(k),l(oe),l(Me),l(R),l(re),l(ce),l(ue),l(A),l(ye),l(de),l(z),l(he),l(V),l(Je),l(N),l(Te),l(Q),l(be),l(we),l(S),l(je),l(Ue),l(L),l(fe),l(ge),l(q),l(Ie),l(Ce),l(Ze),l(K),l(Ge),l(Be),l(tt),l($e),l(ve),l(lt),l(We),l(ke),l(at),l(_e),l(Re),l(Xe),l(Fe),l(Ae),l(ot),l(xe),l(Mt),l(ze),l(rt),l(Ve),l(ct),l(Ne),l(Qe),l(Ee),l(dt),l(Se),l(Ye),l(Jt),l(Le),l(He),l(bt),l(qe),l(De),l(jt),l(Pe),l(Ke),l(Oe),l(gt),l(tl),l(el),l(ll),l(sl),l(al),l(Bt),l(nl),l(il),l(pl),l(ml),l(kt),l(ol),l(Ml),l(Rt),l(rl),l(cl),l(Ft),l(ul),l(At),l(yl),l(xt),l(dl),l(zt),l(hl),l(Vt),l(Jl),l(Tl),l(bl),l(St)),l(J),y(T,t),y(b,t),y(G,t),y($,t),y(v,t),y(W,t),y(_,t),y(X,t),y(F,t),y(x,t),y(E,t),y(Y,t),y(H,t),y(D,t),y(P,t),y(O,t),y(et,t),y(st,t),y(nt,t),y(it,t),y(pt,t),y(mt,t),y(ut,t),y(yt,t),y(ht,t),y(Tt,t),y(wt,t),y(Ut,t),y(ft,t),y(It,t),y(Ct,t),y(Zt,t),y(Gt,t),y($t,t),y(vt,t),y(Wt,t),y(_t,t),y(Xt,t),y(Nt,t),y(Qt,t)}}}const ws='{"title":"Documentation Chatbot with Meta Synthetic Data Kit","local":"documentation-chatbot-with-meta-synthetic-data-kit","sections":[{"title":"1. Setup and Installation","local":"1-setup-and-installation","sections":[],"depth":2},{"title":"2. Synthetic Data Generation","local":"2-synthetic-data-generation","sections":[{"title":"2.1. Acquire and Ingest Documentation","local":"21-acquire-and-ingest-documentation","sections":[],"depth":3},{"title":"2.2. Chunk Data and Generate QA Pairs","local":"22-chunk-data-and-generate-qa-pairs","sections":[],"depth":3},{"title":"2.3. Format and Save QA Pairs","local":"23-format-and-save-qa-pairs","sections":[],"depth":3},{"title":"2.4. Load the Formatted Dataset","local":"24-load-the-formatted-dataset","sections":[],"depth":3},{"title":"Memory Management Note (Critical for Resource-Constrained Environments)","local":"memory-management-note-critical-for-resource-constrained-environments","sections":[],"depth":3}],"depth":2},{"title":"3. Fine-tuning the LLM with Unsloth","local":"3-fine-tuning-the-llm-with-unsloth","sections":[{"title":"3.1. Load Base Model and Tokenizer","local":"31-load-base-model-and-tokenizer","sections":[],"depth":3},{"title":"3.2. Add LoRA Adapters","local":"32-add-lora-adapters","sections":[],"depth":3},{"title":"3.3. Data Preparation for Chat Format","local":"33-data-preparation-for-chat-format","sections":[],"depth":3},{"title":"3.4. Train the Model","local":"34-train-the-model","sections":[],"depth":3}],"depth":2},{"title":"4. Inference and Testing","local":"4-inference-and-testing","sections":[],"depth":2},{"title":"5. Conclusion","local":"5-conclusion","sections":[],"depth":2}],"depth":1}';function js(jl){return cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cs extends us{constructor(J){super(),ys(this,J,js,bs,Ms,{})}}export{Cs as component};
