import{s as ao,f as ga,n as to,o as lo}from"../chunks/scheduler.65852ee5.js";import{S as so,i as oo,g as F,s,r as U,A as Uo,h as r,f as t,c as o,j as Ao,u as i,x as j,k as w,y as io,a as l,v as e,d as n,t as K,w as p}from"../chunks/index.65a1b999.js";import{D as eo,C as M}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as R,E as no}from"../chunks/getInferenceSnippets.aa1f4ff5.js";function Ko($l){let c,za,Ha,ha,T,Ia,u,Wa,m,As='<em>Authored by: <a href="https://github.com/sergiopaniego" rel="nofollow">Sergio Paniego</a></em>',ka,B,as='In this notebook, we will fine-tune an <a href="https://huggingface.co/docs/transformers/tasks/object_detection" rel="nofollow">object detection</a> model—specifically, <a href="https://huggingface.co/docs/transformers/model_doc/detr" rel="nofollow">DETR</a>—using a custom dataset. We will leverage the <a href="https://huggingface.co/docs" rel="nofollow">Hugging Face ecosystem</a> to accomplish this task.',Na,b,ts='Our approach involves starting with a pretrained DETR model and fine-tuning it on a custom dataset of annotated fashion images, namely <a href="https://huggingface.co/datasets/detection-datasets/fashionpedia" rel="nofollow">Fashionpedia</a>. By doing so, we’ll adapt the model to better recognize and detect objects within the fashion domain.',Qa,d,ls="After successfully fine-tuning the model, we will deploy it as a Gradio Space on Hugging Face. Additionally, we’ll explore how to interact with the deployed model using the Gradio API, enabling seamless communication with the hosted Space and unlocking new possibilities for real-world applications.",qa,P,ss='<img src="https://github.com/facebookresearch/detr/raw/main/.github/DETR.png" alt="DETR architecture"/>',va,g,Sa,C,os="Let’s start by installing the necessary libraries for fine-tuning our object detection model.",Da,V,Za,X,Oa,y,Us,Ya,x,is='📁 The dataset we will use is <a href="https://huggingface.co/datasets/detection-datasets/fashionpedia" rel="nofollow">Fashionpedia</a>, which comes from the paper <a href="https://arxiv.org/abs/2004.12276" rel="nofollow">Fashionpedia: Ontology, Segmentation, and an Attribute Localization Dataset</a>. The authors describe it as follows:',La,H,Ea,G,es="The dataset includes:",_a,z,ns="<li><strong>46,781 images</strong> 🖼</li> <li><strong>342,182 bounding boxes</strong> 📦</li>",$a,h,Ks='It is available on Hugging Face: <a href="https://huggingface.co/datasets/detection-datasets/fashionpedia" rel="nofollow">Fashionpedia Dataset</a>',At,I,at,W,tt,k,ps="Review the internal structure of one of the examples",lt,N,st,Q,ot,q,Fs="The dataset comes with two splits: <strong>train</strong> and <strong>test</strong>. We will use the training split to fine-tune the model and the test split for validation.",Ut,v,it,S,rs="<strong>Optional</strong>",et,D,js="In the next commented cell, we randomly sample 1% of the original dataset for both the training and test splits. This approach is used to speed up the training process, as the dataset contains a large number of examples.",nt,Z,Ms="For the best results, we recommend skipping these two cells and using the full dataset. However, you can uncomment them if needed.",Kt,O,pt,Y,Ft,L,Rs="Now that we’ve loaded the dataset, let’s visualize an example along with its annotated objects.",rt,E,jt,_,ws="These variables contain the mappings between object IDs and their corresponding labels. <code>id2label</code> maps from IDs to labels, while <code>label2id</code> maps from labels to IDs.",Mt,$,Rt,AA,wt,aA,cs="Now, let’s visualize one image from the dataset to better understand what it looks like.",ct,tA,yt,lA,ys=`&#123;'bbox_id': [158977, 158978, 158979, 158980, 158981, 158982, 158983], 'category': [1, 23, 23, 6, 31, 31, 33], 'bbox': [[210.0, 225.0, 536.0, 784.0], [290.0, 897.0, 350.0, 1015.0], [464.0, 950.0, 534.0, 1021.0], [313.0, 407.0, 524.0, 954.0], [268.0, 229.0, 333.0, 563.0], [489.0, 247.0, 528.0, 591.0], [387.0, 225.0, 450.0, 253.0]], 'area': [69960, 2449, 1788, 75418, 15149, 5998, 479]}
`,Jt,sA,ft,oA,Js="Now, let’s take a look at a few more images from the dataset to get a broader view of the data.",Tt,UA,ut,iA,fs=`&#123;'bbox_id': [150311, 150312, 150313, 150314], 'category': [23, 23, 33, 10], 'bbox': [[445.0, 910.0, 505.0, 983.0], [239.0, 940.0, 284.0, 994.0], [298.0, 282.0, 386.0, 352.0], [210.0, 282.0, 448.0, 665.0]], 'area': [1422, 843, 373, 56375]}
&#123;'bbox_id': [158953, 158954, 158955, 158956, 158957, 158958, 158959, 158960, 158961, 158962], 'category': [2, 33, 31, 31, 13, 7, 22, 22, 23, 23], 'bbox': [[182.0, 220.0, 472.0, 647.0], [294.0, 221.0, 407.0, 257.0], [405.0, 297.0, 472.0, 647.0], [182.0, 264.0, 266.0, 621.0], [284.0, 135.0, 372.0, 169.0], [238.0, 537.0, 414.0, 606.0], [351.0, 732.0, 417.0, 922.0], [202.0, 749.0, 270.0, 930.0], [200.0, 921.0, 256.0, 979.0], [373.0, 903.0, 455.0, 966.0]], 'area': [87267, 1220, 16895, 18541, 1468, 9360, 8629, 8270, 2717, 3121]}
&#123;'bbox_id': [169196, 169197, 169198, 169199, 169200, 169201, 169202, 169203, 169204, 169205, 169206, 169207, 169208, 169209, 169210], 'category': [13, 29, 28, 32, 32, 31, 31, 0, 31, 31, 18, 4, 6, 23, 23], 'bbox': [[441.0, 132.0, 499.0, 150.0], [412.0, 164.0, 494.0, 295.0], [427.0, 164.0, 476.0, 207.0], [406.0, 326.0, 448.0, 335.0], [484.0, 327.0, 508.0, 334.0], [366.0, 323.0, 395.0, 372.0], [496.0, 271.0, 523.0, 302.0], [366.0, 164.0, 523.0, 372.0], [360.0, 186.0, 406.0, 332.0], [502.0, 201.0, 534.0, 321.0], [496.0, 259.0, 515.0, 278.0], [360.0, 164.0, 534.0, 411.0], [403.0, 384.0, 510.0, 638.0], [393.0, 584.0, 430.0, 663.0], [449.0, 638.0, 518.0, 681.0]], 'area': [587, 2922, 931, 262, 111, 1171, 540, 3981, 4457, 1724, 188, 26621, 16954, 2167, 1773]}
&#123;'bbox_id': [167967, 167968, 167969, 167970, 167971, 167972, 167973, 167974, 167975, 167976, 167977, 167978, 167979, 167980, 167981, 167982, 167983, 167984, 167985, 167986, 167987, 167988, 167989, 167990, 167991, 167992, 167993, 167994, 167995, 167996, 167997, 167998, 167999, 168000, 168001, 168002, 168003, 168004, 168005, 168006, 168007, 168008, 168009, 168010, 168011, 168012, 168013, 168014, 168015, 168016, 168017, 168018, 168019, 168020, 168021, 168022, 168023, 168024, 168025, 168026, 168027, 168028, 168029, 168030, 168031, 168032, 168033, 168034, 168035, 168036, 168037, 168038, 168039, 168040], 'category': [6, 23, 23, 31, 31, 4, 1, 35, 32, 35, 35, 35, 35, 28, 35, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 33], 'bbox': [[300.0, 421.0, 460.0, 846.0], [383.0, 841.0, 432.0, 899.0], [304.0, 740.0, 347.0, 831.0], [246.0, 222.0, 295.0, 505.0], [456.0, 229.0, 492.0, 517.0], [246.0, 169.0, 492.0, 517.0], [355.0, 213.0, 450.0, 433.0], [289.0, 353.0, 303.0, 427.0], [442.0, 288.0, 460.0, 340.0], [451.0, 290.0, 458.0, 304.0], [407.0, 238.0, 473.0, 486.0], [487.0, 501.0, 491.0, 517.0], [246.0, 455.0, 252.0, 505.0], [340.0, 169.0, 442.0, 238.0], [348.0, 230.0, 372.0, 476.0], [411.0, 179.0, 414.0, 182.0], [414.0, 183.0, 418.0, 186.0], [418.0, 187.0, 421.0, 190.0], [421.0, 192.0, 425.0, 195.0], [424.0, 196.0, 428.0, 199.0], [426.0, 200.0, 430.0, 204.0], [429.0, 204.0, 433.0, 208.0], [431.0, 209.0, 435.0, 213.0], [433.0, 214.0, 437.0, 218.0], [434.0, 218.0, 438.0, 222.0], [436.0, 223.0, 440.0, 226.0], [437.0, 227.0, 441.0, 231.0], [438.0, 232.0, 442.0, 235.0], [433.0, 232.0, 437.0, 236.0], [429.0, 233.0, 432.0, 237.0], [423.0, 233.0, 426.0, 237.0], [417.0, 233.0, 421.0, 237.0], [353.0, 172.0, 355.0, 174.0], [353.0, 175.0, 354.0, 177.0], [351.0, 178.0, 353.0, 181.0], [350.0, 182.0, 351.0, 184.0], [347.0, 187.0, 350.0, 189.0], [346.0, 190.0, 349.0, 193.0], [345.0, 194.0, 348.0, 197.0], [344.0, 199.0, 347.0, 202.0], [342.0, 204.0, 346.0, 207.0], [342.0, 208.0, 345.0, 211.0], [342.0, 212.0, 344.0, 215.0], [342.0, 217.0, 345.0, 220.0], [344.0, 221.0, 346.0, 224.0], [348.0, 222.0, 350.0, 225.0], [353.0, 223.0, 356.0, 226.0], [359.0, 223.0, 361.0, 226.0], [364.0, 223.0, 366.0, 226.0], [247.0, 448.0, 253.0, 454.0], [251.0, 454.0, 254.0, 456.0], [252.0, 460.0, 255.0, 463.0], [252.0, 466.0, 255.0, 469.0], [253.0, 471.0, 255.0, 475.0], [253.0, 478.0, 255.0, 481.0], [253.0, 483.0, 256.0, 486.0], [254.0, 489.0, 256.0, 492.0], [254.0, 495.0, 256.0, 497.0], [247.0, 457.0, 249.0, 460.0], [247.0, 463.0, 249.0, 466.0], [248.0, 469.0, 249.0, 471.0], [248.0, 476.0, 250.0, 478.0], [248.0, 481.0, 250.0, 483.0], [249.0, 486.0, 250.0, 488.0], [487.0, 459.0, 490.0, 461.0], [487.0, 465.0, 490.0, 467.0], [487.0, 471.0, 490.0, 472.0], [487.0, 476.0, 489.0, 478.0], [486.0, 482.0, 489.0, 484.0], [486.0, 488.0, 489.0, 490.0], [486.0, 494.0, 488.0, 496.0], [486.0, 500.0, 488.0, 501.0], [485.0, 505.0, 487.0, 507.0], [365.0, 213.0, 409.0, 226.0]], 'area': [44062, 2140, 2633, 9206, 5905, 44791, 12948, 211, 335, 43, 691, 62, 104, 2169, 439, 9, 10, 9, 8, 9, 14, 10, 13, 13, 11, 11, 10, 10, 12, 10, 10, 14, 4, 2, 4, 2, 5, 6, 7, 7, 8, 7, 6, 7, 5, 5, 7, 6, 5, 12, 5, 7, 8, 6, 6, 6, 4, 4, 6, 5, 2, 4, 4, 2, 6, 6, 3, 4, 6, 6, 4, 2, 4, 94]}
&#123;'bbox_id': [168041, 168042, 168043, 168044, 168045, 168046, 168047], 'category': [10, 32, 35, 31, 4, 29, 33], 'bbox': [[238.0, 309.0, 471.0, 1022.0], [234.0, 572.0, 331.0, 602.0], [235.0, 580.0, 324.0, 599.0], [119.0, 318.0, 343.0, 856.0], [111.0, 262.0, 518.0, 1022.0], [166.0, 262.0, 393.0, 492.0], [238.0, 309.0, 278.0, 324.0]], 'area': [12132, 1548, 755, 43926, 178328, 9316, 136]}
&#123;'bbox_id': [160050, 160051, 160052, 160053, 160054, 160055], 'category': [10, 31, 31, 23, 23, 33], 'bbox': [[290.0, 364.0, 429.0, 665.0], [304.0, 369.0, 397.0, 508.0], [290.0, 468.0, 310.0, 522.0], [213.0, 842.0, 294.0, 905.0], [446.0, 840.0, 536.0, 896.0], [311.0, 364.0, 354.0, 379.0]], 'area': [26873, 5301, 747, 1438, 1677, 71]}
&#123;'bbox_id': [160056, 160057, 160058, 160059, 160060, 160061, 160062, 160063, 160064, 160065, 160066], 'category': [10, 36, 42, 42, 42, 42, 42, 42, 42, 23, 33], 'bbox': [[127.0, 198.0, 451.0, 949.0], [277.0, 336.0, 319.0, 402.0], [340.0, 343.0, 344.0, 347.0], [321.0, 338.0, 327.0, 343.0], [336.0, 361.0, 342.0, 365.0], [329.0, 321.0, 333.0, 326.0], [313.0, 294.0, 319.0, 300.0], [330.0, 299.0, 334.0, 304.0], [295.0, 330.0, 300.0, 334.0], [332.0, 926.0, 376.0, 946.0], [284.0, 198.0, 412.0, 270.0]], 'area': [137575, 1915, 14, 24, 18, 15, 25, 16, 16, 740, 586]}
&#123;'bbox_id': [158963, 158964, 158965, 158966, 158967, 158968, 158969, 158970, 158971], 'category': [1, 31, 31, 7, 22, 22, 23, 23, 33], 'bbox': [[262.0, 449.0, 435.0, 686.0], [399.0, 471.0, 435.0, 686.0], [262.0, 451.0, 294.0, 662.0], [276.0, 603.0, 423.0, 726.0], [291.0, 759.0, 343.0, 934.0], [341.0, 749.0, 401.0, 947.0], [302.0, 919.0, 337.0, 994.0], [323.0, 925.0, 374.0, 1005.0], [343.0, 456.0, 366.0, 467.0]], 'area': [22330, 4422, 4846, 14000, 6190, 6997, 1547, 2107, 49]}
&#123;'bbox_id': [158972, 158973, 158974, 158975, 158976], 'category': [23, 23, 28, 10, 5], 'bbox': [[412.0, 588.0, 451.0, 631.0], [333.0, 585.0, 357.0, 627.0], [361.0, 243.0, 396.0, 257.0], [303.0, 243.0, 447.0, 517.0], [330.0, 259.0, 425.0, 324.0]], 'area': [949, 737, 133, 17839, 2916]}
`,mt,eA,Bt,nA,Ts="As the first step in preprocessing the dataset, we will filter out some invalid bounding boxes. After reviewing the dataset, we found that some bounding boxes did not have a valid structure. Therefore, we will discard these invalid entries.",bt,KA,dt,pA,us=`Image with invalid bbox: 8396 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 139952 - category: 42
Image with invalid bbox: 19725 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 23298 - category: 42
Image with invalid bbox: 19725 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 23299 - category: 42
Image with invalid bbox: 21696 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 277148 - category: 42
Image with invalid bbox: 23055 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 287029 - category: 33
Image with invalid bbox: 23671 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 290142 - category: 42
Image with invalid bbox: 26549 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 311943 - category: 37
Image with invalid bbox: 26834 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 309141 - category: 37
Image with invalid bbox: 31748 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 262063 - category: 42
Image with invalid bbox: 34253 Invalid bbox detected and discarded: [0.0, 0.0, 0.0, 0.0] - bbox_id: 315750 - category: 19
`,Pt,FA,gt,rA,ms=`Dataset(&#123;
    features: ['image_id', 'image', 'width', 'height', 'objects'],
    num_rows: 45623
})
Dataset(&#123;
    features: ['image_id', 'image', 'width', 'height', 'objects'],
    num_rows: 1158
})
`,Ct,jA,Vt,MA,Bs="Let’s explore the dataset further by plotting the occurrences of each class. This will help us understand the distribution of classes and identify any potential biases.",Xt,RA,xt,wA,Ht,Ca,bs,Gt,cA,ds="We can observe that some classes, such as “shoe” or “sleeve,” are overrepresented in the dataset. This indicates that the dataset may have an imbalance, with certain classes appearing more frequently than others. Identifying these imbalances is crucial for addressing potential biases in model training.",zt,yA,ht,JA,Ps='Data augmentation 🪄 is crucial for enhancing performance in object detection tasks. In this section, we will leverage the capabilities of <a href="https://albumentations.ai/" rel="nofollow">Albumentations</a> to augment our dataset effectively.',It,fA,gs="Albumentations provides a range of powerful augmentation techniques tailored for object detection. It allows for various transformations, all while ensuring that bounding boxes are accurately adjusted. These capabilities help in generating a more diverse dataset, improving the model’s robustness and generalization.",Wt,J,Cs,kt,TA,Nt,uA,Qt,mA,Vs='We will instantiate the image processor using a pretrained model checkpoint. In this case, we are using the <a href="https://huggingface.co/facebook/detr-resnet-50-dc5" rel="nofollow">facebook/detr-resnet-50-dc5</a> model.',qt,BA,vt,bA,St,dA,Xs="We will now add methods to process the dataset. These methods will handle tasks such as transforming images and annotations to ensure they are compatible with the model.",Dt,PA,Zt,gA,Ot,CA,xs="We are nearing the model training phase! Before proceeding, let’s visualize some samples after augmentation. This will allow us to double-check that the augmentations are suitable and effective for the training process.",Yt,VA,Lt,Va,Hs,Et,XA,_t,xA,Gs="We will initialize the model using the same checkpoint as the image processor. This involves loading a pretrained model that we will fine-tune for our specific dataset.",$t,HA,Al,GA,al,zA,tl,hA,zs="We will connect to the Hugging Face Hub to upload our fine-tuned model. This allows us to share and deploy the model for others to use or for further evaluation.",ll,IA,sl,WA,ol,kA,hs='Next, we will set up the training arguments, connect to <a href="https://wandb.ai/" rel="nofollow">Weights &amp; Biases (W&amp;B)</a>, and start the training process. W&amp;B will help us track experiments, visualize metrics, and manage our model training workflow.',Ul,NA,il,QA,el,qA,nl,vA,Kl,SA,Is="Now it’s time to start training the model. Let’s run the training process and watch how our fine-tuned model learns from the data!",pl,DA,Ws="First, we declare the <code>compute_metrics</code> method for calculating the metrics on evaluation.",Fl,ZA,rl,OA,jl,YA,Ml,LA,Rl,EA,wl,_A,cl,$A,ks="Now that the model is trained, we can evaluate its performance on a test image. Since the model is available as a Hugging Face model, making predictions is straightforward. In the following cell, we will demonstrate how to run inference on a new image and assess the model’s capabilities.",yl,Aa,Jl,aa,fl,ta,Ns="We’ll display the results of the model’s predictions on the test image. This will give us insight into how well the model performs and highlight its strengths and areas for improvement.",Tl,la,ul,sa,ml,Xa,Qs,Bl,oa,bl,Ua,qs="After training and visualizing the results for a test image, we will evaluate the model on the entire test dataset. This step involves generating metrics to assess the overall performance and effectiveness of the model across the full range of test samples.",dl,ia,Pl,ea,gl,f,vs,Cl,na,Ss="Now that our model is available on Hugging Face, we can deploy it in a HF Space. Hugging Face provides free Spaces for small applications, allowing us to create an interactive web application where users can upload test images and evaluate the model’s capabilities.",Vl,Ka,Ds='I’ve created an example application here: <a href="https://huggingface.co/spaces/sergiopaniego/DETR_object_detection_fashionpedia-finetuned" rel="nofollow">DETR Object Detection Fashionpedia - Fine-Tuned</a>',Xl,pa,xl,Fa,Hl,ra,Zs="You can create a new application by copying and pasting the following code into a file named <code>app.py</code>.",Gl,ja,zl,Ma,hl,Ra,Os="Don’t forget to create a <code>requirements.txt</code> file to specify the dependencies for the application.",Il,wa,Wl,ca,kl,ya,Ys="One of the great features of Hugging Face Spaces is that they provide an API that can be accessed from outside applications. This makes it easy to integrate the model into various applications, whether they’re built with JavaScript, Python, or another language. Imagine the possibilities for expanding and utilizing your model’s capabilities!",Nl,Ja,Ls='You can find more information on how to use the API here: <a href="https://huggingface.co/learn/cookbook/enterprise_cookbook_gradio" rel="nofollow">Hugging Face Enterprise Cookbook: Gradio</a>',Ql,fa,ql,Ta,vl,ua,Sl,ma,Dl,xa,Es,Zl,Ba,Ol,ba,_s="In this cookbook, we successfully fine-tuned an object detection model on a custom dataset and deployed it as a Gradio Space. We also demonstrated how to call the Space using the Gradio API, showcasing the ease of integrating it into various applications.",Yl,da,$s="I hope this guide helps you in fine-tuning and deploying your own models with confidence! 🚀",Ll,Pa,El,Ga,_l;return T=new eo({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/fine_tuning_detr_custom_dataset.ipynb"}]}}),u=new R({props:{title:"Fine-Tuning Object Detection Model on a Custom Dataset 🖼, Deployment in Spaces, and Gradio API Integration",local:"fine-tuning-object-detection-model-on-a-custom-dataset--deployment-in-spaces-and-gradio-api-integration",headingTag:"h1"}}),g=new R({props:{title:"1. Install Dependencies",local:"1-install-dependencies",headingTag:"h2"}}),V=new M({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtVSUyMC1xJTIwZGF0YXNldHMlMjB0cmFuc2Zvcm1lcnMlNUJ0b3JjaCU1RCUyMHRpbW0lMjB3YW5kYiUyMHRvcmNobWV0cmljcyUyMG1hdHBsb3RsaWIlMjBhbGJ1bWVudGF0aW9ucyUwQSUyMyUyMFRlc3RlZCUyMHdpdGglMjBkYXRhc2V0cyUzRCUzRDIuMjEuMCUyQyUyMHRyYW5zZm9ybWVycyUzRCUzRDQuNDQuMiUyMHRpbW0lM0QlM0QxLjAuOSUyQyUyMHdhbmRiJTNEJTNEMC4xNy45JTIwdG9yY2htZXRyaWNzJTNEJTNEMS40LjE=",highlighted:`!pip install -U -q datasets transformers[torch] timm wandb torchmetrics matplotlib albumentations
<span class="hljs-comment"># Tested with datasets==2.21.0, transformers==4.44.2 timm==1.0.9, wandb==0.17.9 torchmetrics==1.4.1</span>`,wrap:!1}}),X=new R({props:{title:"2. Load Dataset 📁",local:"2-load-dataset-",headingTag:"h2"}}),H=new M({props:{code:"RmFzaGlvbnBlZGlhJTIwaXMlMjBhJTIwZGF0YXNldCUyMHdoaWNoJTIwY29uc2lzdHMlMjBvZiUyMHR3byUyMHBhcnRzJTNBJTIwKDEpJTIwYW4lMjBvbnRvbG9neSUyMGJ1aWx0JTIwYnklMjBmYXNoaW9uJTIwZXhwZXJ0cyUyMGNvbnRhaW5pbmclMjAyNyUyMG1haW4lMjBhcHBhcmVsJTIwY2F0ZWdvcmllcyUyQyUyMDE5JTIwYXBwYXJlbCUyMHBhcnRzJTJDJTIwMjk0JTIwZmluZS1ncmFpbmVkJTIwYXR0cmlidXRlcyUyMGFuZCUyMHRoZWlyJTIwcmVsYXRpb25zaGlwcyUzQiUyMCgyKSUyMGElMjBkYXRhc2V0JTIwd2l0aCUyMDQ4ayUyMGV2ZXJ5ZGF5JTIwYW5kJTIwY2VsZWJyaXR5JTIwZXZlbnQlMjBmYXNoaW9uJTIwaW1hZ2VzJTIwYW5ub3RhdGVkJTIwd2l0aCUyMHNlZ21lbnRhdGlvbiUyMG1hc2tzJTIwYW5kJTIwdGhlaXIlMjBhc3NvY2lhdGVkJTIwcGVyLW1hc2slMjBmaW5lLWdyYWluZWQlMjBhdHRyaWJ1dGVzJTJDJTIwYnVpbHQlMjB1cG9uJTIwdGhlJTIwRmFzaGlvbnBlZGlhJTIwb250b2xvZ3ku",highlighted:'Fashionpedia is a dataset which consists of two parts: (<span class="hljs-number">1</span>) an ontology <span class="hljs-keyword">built </span><span class="hljs-keyword">by </span>fashion experts containing <span class="hljs-number">27</span> main apparel categories, <span class="hljs-number">19</span> apparel parts, <span class="hljs-number">294</span> fine-grained attributes <span class="hljs-keyword">and </span>their relationships<span class="hljs-comment">; (2) a dataset with 48k everyday and celebrity event fashion images annotated with segmentation masks and their associated per-mask fine-grained attributes, built upon the Fashionpedia ontology.</span>',wrap:!1}}),I=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJkZXRlY3Rpb24tZGF0YXNldHMlMkZmYXNoaW9ucGVkaWElMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;detection-datasets/fashionpedia&quot;</span>)`,wrap:!1}}),W=new M({props:{code:"ZGF0YXNldA==",highlighted:"dataset",wrap:!1}}),N=new M({props:{code:"ZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RA==",highlighted:'dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]',wrap:!1}}),Q=new R({props:{title:"3. Get Splits of the Dataset for Training and Testing ➗",local:"3-get-splits-of-the-dataset-for-training-and-testing-",headingTag:"h2"}}),v=new M({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCUwQXRlc3RfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ2YWwlMjIlNUQ=",highlighted:`train_dataset = dataset[<span class="hljs-string">&quot;train&quot;</span>]
test_dataset = dataset[<span class="hljs-string">&quot;val&quot;</span>]`,wrap:!1}}),O=new M({props:{code:"JTIyJTIyJTIyJTBBZGVmJTIwY3JlYXRlX3NhbXBsZShkYXRhc2V0JTJDJTIwc2FtcGxlX2ZyYWN0aW9uJTNEMC4wMSUyQyUyMHNlZWQlM0Q0MiklM0ElMEElMjAlMjAlMjAlMjBzYW1wbGVfc2l6ZSUyMCUzRCUyMGludChzYW1wbGVfZnJhY3Rpb24lMjAqJTIwbGVuKGRhdGFzZXQpKSUwQSUyMCUyMCUyMCUyMHNhbXBsZWRfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc2h1ZmZsZShzZWVkJTNEc2VlZCkuc2VsZWN0KHJhbmdlKHNhbXBsZV9zaXplKSklMEElMjAlMjAlMjAlMjBwcmludChmJTIyT3JpZ2luYWwlMjBzaXplJTNBJTIwJTdCbGVuKGRhdGFzZXQpJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJTYW1wbGUlMjBzaXplJTNBJTIwJTdCbGVuKHNhbXBsZWRfZGF0YXNldCklN0QlMjIpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2FtcGxlZF9kYXRhc2V0JTBBJTBBJTIzJTIwQXBwbHklMjBmdW5jdGlvbiUyMHRvJTIwYm90aCUyMHNwbGl0cyUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBjcmVhdGVfc2FtcGxlKHRyYWluX2RhdGFzZXQpJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwY3JlYXRlX3NhbXBsZSh0ZXN0X2RhdGFzZXQpJTBBJTIyJTIyJTIy",highlighted:`<span class="hljs-string">&quot;&quot;&quot;
def create_sample(dataset, sample_fraction=0.01, seed=42):
    sample_size = int(sample_fraction * len(dataset))
    sampled_dataset = dataset.shuffle(seed=seed).select(range(sample_size))
    print(f&quot;Original size: {len(dataset)}&quot;)
    print(f&quot;Sample size: {len(sampled_dataset)}&quot;)
    return sampled_dataset

# Apply function to both splits
train_dataset = create_sample(train_dataset)
test_dataset = create_sample(test_dataset)
&quot;&quot;&quot;</span>`,wrap:!1}}),Y=new R({props:{title:"4. Visualize One Example from the Dataset with Its Objects 👀",local:"4-visualize-one-example-from-the-dataset-with-its-objects-",headingTag:"h2"}}),E=new R({props:{title:"Generate id2label and label2id",local:"generate-id2label-and-label2id",headingTag:"h3"}}),$=new M({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image, ImageDraw


id2label = {
    <span class="hljs-number">0</span>: <span class="hljs-string">&quot;shirt, blouse&quot;</span>,
    <span class="hljs-number">1</span>: <span class="hljs-string">&quot;top, t-shirt, sweatshirt&quot;</span>,
    <span class="hljs-number">2</span>: <span class="hljs-string">&quot;sweater&quot;</span>,
    <span class="hljs-number">3</span>: <span class="hljs-string">&quot;cardigan&quot;</span>,
    <span class="hljs-number">4</span>: <span class="hljs-string">&quot;jacket&quot;</span>,
    <span class="hljs-number">5</span>: <span class="hljs-string">&quot;vest&quot;</span>,
    <span class="hljs-number">6</span>: <span class="hljs-string">&quot;pants&quot;</span>,
    <span class="hljs-number">7</span>: <span class="hljs-string">&quot;shorts&quot;</span>,
    <span class="hljs-number">8</span>: <span class="hljs-string">&quot;skirt&quot;</span>,
    <span class="hljs-number">9</span>: <span class="hljs-string">&quot;coat&quot;</span>,
    <span class="hljs-number">10</span>: <span class="hljs-string">&quot;dress&quot;</span>,
    <span class="hljs-number">11</span>: <span class="hljs-string">&quot;jumpsuit&quot;</span>,
    <span class="hljs-number">12</span>: <span class="hljs-string">&quot;cape&quot;</span>,
    <span class="hljs-number">13</span>: <span class="hljs-string">&quot;glasses&quot;</span>,
    <span class="hljs-number">14</span>: <span class="hljs-string">&quot;hat&quot;</span>,
    <span class="hljs-number">15</span>: <span class="hljs-string">&quot;headband, head covering, hair accessory&quot;</span>,
    <span class="hljs-number">16</span>: <span class="hljs-string">&quot;tie&quot;</span>,
    <span class="hljs-number">17</span>: <span class="hljs-string">&quot;glove&quot;</span>,
    <span class="hljs-number">18</span>: <span class="hljs-string">&quot;watch&quot;</span>,
    <span class="hljs-number">19</span>: <span class="hljs-string">&quot;belt&quot;</span>,
    <span class="hljs-number">20</span>: <span class="hljs-string">&quot;leg warmer&quot;</span>,
    <span class="hljs-number">21</span>: <span class="hljs-string">&quot;tights, stockings&quot;</span>,
    <span class="hljs-number">22</span>: <span class="hljs-string">&quot;sock&quot;</span>,
    <span class="hljs-number">23</span>: <span class="hljs-string">&quot;shoe&quot;</span>,
    <span class="hljs-number">24</span>: <span class="hljs-string">&quot;bag, wallet&quot;</span>,
    <span class="hljs-number">25</span>: <span class="hljs-string">&quot;scarf&quot;</span>,
    <span class="hljs-number">26</span>: <span class="hljs-string">&quot;umbrella&quot;</span>,
    <span class="hljs-number">27</span>: <span class="hljs-string">&quot;hood&quot;</span>,
    <span class="hljs-number">28</span>: <span class="hljs-string">&quot;collar&quot;</span>,
    <span class="hljs-number">29</span>: <span class="hljs-string">&quot;lapel&quot;</span>,
    <span class="hljs-number">30</span>: <span class="hljs-string">&quot;epaulette&quot;</span>,
    <span class="hljs-number">31</span>: <span class="hljs-string">&quot;sleeve&quot;</span>,
    <span class="hljs-number">32</span>: <span class="hljs-string">&quot;pocket&quot;</span>,
    <span class="hljs-number">33</span>: <span class="hljs-string">&quot;neckline&quot;</span>,
    <span class="hljs-number">34</span>: <span class="hljs-string">&quot;buckle&quot;</span>,
    <span class="hljs-number">35</span>: <span class="hljs-string">&quot;zipper&quot;</span>,
    <span class="hljs-number">36</span>: <span class="hljs-string">&quot;applique&quot;</span>,
    <span class="hljs-number">37</span>: <span class="hljs-string">&quot;bead&quot;</span>,
    <span class="hljs-number">38</span>: <span class="hljs-string">&quot;bow&quot;</span>,
    <span class="hljs-number">39</span>: <span class="hljs-string">&quot;flower&quot;</span>,
    <span class="hljs-number">40</span>: <span class="hljs-string">&quot;fringe&quot;</span>,
    <span class="hljs-number">41</span>: <span class="hljs-string">&quot;ribbon&quot;</span>,
    <span class="hljs-number">42</span>: <span class="hljs-string">&quot;rivet&quot;</span>,
    <span class="hljs-number">43</span>: <span class="hljs-string">&quot;ruffle&quot;</span>,
    <span class="hljs-number">44</span>: <span class="hljs-string">&quot;sequin&quot;</span>,
    <span class="hljs-number">45</span>: <span class="hljs-string">&quot;tassel&quot;</span>,
}


label2id = {v: k <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}`,wrap:!1}}),AA=new R({props:{title:"Let’s Draw One Image! 🎨",local:"lets-draw-one-image-",headingTag:"h3"}}),tA=new M({props:{code:"ZGVmJTIwZHJhd19pbWFnZV9mcm9tX2lkeChkYXRhc2V0JTJDJTIwaWR4KSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUJpZHglNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHNhbXBsZSU1QiUyMmltYWdlJTIyJTVEJTBBJTIwJTIwJTIwJTIwYW5ub3RhdGlvbnMlMjAlM0QlMjBzYW1wbGUlNUIlMjJvYmplY3RzJTIyJTVEJTBBJTIwJTIwJTIwJTIwZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlKSUwQSUyMCUyMCUyMCUyMHdpZHRoJTJDJTIwaGVpZ2h0JTIwJTNEJTIwc2FtcGxlJTVCJTIyd2lkdGglMjIlNUQlMkMlMjBzYW1wbGUlNUIlMjJoZWlnaHQlMjIlNUQlMEElMEElMjAlMjAlMjAlMjBwcmludChhbm5vdGF0aW9ucyklMEElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oYW5ub3RhdGlvbnMlNUIlMjJiYm94X2lkJTIyJTVEKSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBib3glMjAlM0QlMjBhbm5vdGF0aW9ucyU1QiUyMmJib3glMjIlNUQlNUJpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweDElMkMlMjB5MSUyQyUyMHgyJTJDJTIweTIlMjAlM0QlMjB0dXBsZShib3gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHJhdy5yZWN0YW5nbGUoKHgxJTJDJTIweTElMkMlMjB4MiUyQyUyMHkyKSUyQyUyMG91dGxpbmUlM0QlMjJyZWQlMjIlMkMlMjB3aWR0aCUzRDMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHJhdy50ZXh0KCh4MSUyQyUyMHkxKSUyQyUyMGlkMmxhYmVsJTVCYW5ub3RhdGlvbnMlNUIlMjJjYXRlZ29yeSUyMiU1RCU1QmklNUQlNUQlMkMlMjBmaWxsJTNEJTIyZ3JlZW4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2UlMEElMEElMEFkcmF3X2ltYWdlX2Zyb21faWR4KGRhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTIwaWR4JTNEMTApJTIwJTIwJTIzJTIwWW91JTIwY2FuJTIwdGVzdCUyMGNoYW5naW5nJTIwdGhpcyUyMGlk",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">draw_image_from_idx</span>(<span class="hljs-params">dataset, idx</span>):
<span class="hljs-meta">... </span>    sample = dataset[idx]
<span class="hljs-meta">... </span>    image = sample[<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">... </span>    annotations = sample[<span class="hljs-string">&quot;objects&quot;</span>]
<span class="hljs-meta">... </span>    draw = ImageDraw.Draw(image)
<span class="hljs-meta">... </span>    width, height = sample[<span class="hljs-string">&quot;width&quot;</span>], sample[<span class="hljs-string">&quot;height&quot;</span>]

<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(annotations)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(annotations[<span class="hljs-string">&quot;bbox_id&quot;</span>])):
<span class="hljs-meta">... </span>        box = annotations[<span class="hljs-string">&quot;bbox&quot;</span>][i]
<span class="hljs-meta">... </span>        x1, y1, x2, y2 = <span class="hljs-built_in">tuple</span>(box)
<span class="hljs-meta">... </span>        draw.rectangle((x1, y1, x2, y2), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">3</span>)
<span class="hljs-meta">... </span>        draw.text((x1, y1), id2label[annotations[<span class="hljs-string">&quot;category&quot;</span>][i]], fill=<span class="hljs-string">&quot;green&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span>draw_image_from_idx(dataset=train_dataset, idx=<span class="hljs-number">10</span>)  <span class="hljs-comment"># You can test changing this id</span>`,wrap:!1}}),sA=new R({props:{title:"Let’s Visualize Some More Images 📸",local:"lets-visualize-some-more-images-",headingTag:"h3"}}),UA=new M({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQSUwQWRlZiUyMHBsb3RfaW1hZ2VzKGRhdGFzZXQlMkMlMjBpbmRpY2VzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMFBsb3QlMjBpbWFnZXMlMjBhbmQlMjB0aGVpciUyMGFubm90YXRpb25zLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMG51bV9jb2xzJTIwJTNEJTIwMyUwQSUyMCUyMCUyMCUyMG51bV9yb3dzJTIwJTNEJTIwaW50KG5wLmNlaWwobGVuKGluZGljZXMpJTIwJTJGJTIwbnVtX2NvbHMpKSUwQSUyMCUyMCUyMCUyMGZpZyUyQyUyMGF4ZXMlMjAlM0QlMjBwbHQuc3VicGxvdHMobnVtX3Jvd3MlMkMlMjBudW1fY29scyUyQyUyMGZpZ3NpemUlM0QoMTUlMkMlMjAxMCkpJTBBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMGlkeCUyMGluJTIwZW51bWVyYXRlKGluZGljZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93JTIwJTNEJTIwaSUyMCUyRiUyRiUyMG51bV9jb2xzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29sJTIwJTNEJTIwaSUyMCUyNSUyMG51bV9jb2xzJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBkcmF3X2ltYWdlX2Zyb21faWR4KGRhdGFzZXQlMkMlMjBpZHgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXhlcyU1QnJvdyUyQyUyMGNvbCU1RC5pbXNob3coaW1hZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXhlcyU1QnJvdyUyQyUyMGNvbCU1RC5heGlzKCUyMm9mZiUyMiklMEElMEElMjAlMjAlMjAlMjBmb3IlMjBqJTIwaW4lMjByYW5nZShpJTIwJTJCJTIwMSUyQyUyMG51bV9yb3dzJTIwKiUyMG51bV9jb2xzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpZy5kZWxheGVzKGF4ZXMuZmxhdHRlbigpJTVCaiU1RCklMEElMEElMjAlMjAlMjAlMjBwbHQudGlnaHRfbGF5b3V0KCklMEElMjAlMjAlMjAlMjBwbHQuc2hvdygpJTBBJTBBJTBBcGxvdF9pbWFnZXModHJhaW5fZGF0YXNldCUyQyUyMHJhbmdlKDkpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_images</span>(<span class="hljs-params">dataset, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Plot images and their annotations.
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    num_cols = <span class="hljs-number">3</span>
<span class="hljs-meta">... </span>    num_rows = <span class="hljs-built_in">int</span>(np.ceil(<span class="hljs-built_in">len</span>(indices) / num_cols))
<span class="hljs-meta">... </span>    fig, axes = plt.subplots(num_rows, num_cols, figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">10</span>))

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(indices):
<span class="hljs-meta">... </span>        row = i // num_cols
<span class="hljs-meta">... </span>        col = i % num_cols

<span class="hljs-meta">... </span>        image = draw_image_from_idx(dataset, idx)

<span class="hljs-meta">... </span>        axes[row, col].imshow(image)
<span class="hljs-meta">... </span>        axes[row, col].axis(<span class="hljs-string">&quot;off&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> j <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(i + <span class="hljs-number">1</span>, num_rows * num_cols):
<span class="hljs-meta">... </span>        fig.delaxes(axes.flatten()[j])

<span class="hljs-meta">... </span>    plt.tight_layout()
<span class="hljs-meta">... </span>    plt.show()


<span class="hljs-meta">&gt;&gt;&gt; </span>plot_images(train_dataset, <span class="hljs-built_in">range</span>(<span class="hljs-number">9</span>))`,wrap:!1}}),eA=new R({props:{title:"5. Filter Invalid Bboxes ❌",local:"5-filter-invalid-bboxes-",headingTag:"h2"}}),KA=new M({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">filter_invalid_bboxes</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    valid_bboxes = []
<span class="hljs-meta">... </span>    valid_bbox_ids = []
<span class="hljs-meta">... </span>    valid_categories = []
<span class="hljs-meta">... </span>    valid_areas = []

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, bbox <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;bbox&quot;</span>]):
<span class="hljs-meta">... </span>        x_min, y_min, x_max, y_max = bbox[:<span class="hljs-number">4</span>]
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> x_min &lt; x_max <span class="hljs-keyword">and</span> y_min &lt; y_max:
<span class="hljs-meta">... </span>            valid_bboxes.append(bbox)
<span class="hljs-meta">... </span>            valid_bbox_ids.append(example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;bbox_id&quot;</span>][i])
<span class="hljs-meta">... </span>            valid_categories.append(example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;category&quot;</span>][i])
<span class="hljs-meta">... </span>            valid_areas.append(example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;area&quot;</span>][i])
<span class="hljs-meta">... </span>        <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>            <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>                <span class="hljs-string">f&quot;Image with invalid bbox: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;image_id&#x27;</span>]}</span> Invalid bbox detected and discarded: <span class="hljs-subst">{bbox}</span> - bbox_id: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;objects&#x27;</span>][<span class="hljs-string">&#x27;bbox_id&#x27;</span>][i]}</span> - category: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;objects&#x27;</span>][<span class="hljs-string">&#x27;category&#x27;</span>][i]}</span>&quot;</span>
<span class="hljs-meta">... </span>            )

<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;bbox&quot;</span>] = valid_bboxes
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;bbox_id&quot;</span>] = valid_bbox_ids
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;category&quot;</span>] = valid_categories
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;area&quot;</span>] = valid_areas

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example


<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = train_dataset.<span class="hljs-built_in">map</span>(filter_invalid_bboxes)
<span class="hljs-meta">&gt;&gt;&gt; </span>test_dataset = test_dataset.<span class="hljs-built_in">map</span>(filter_invalid_bboxes)`,wrap:!1}}),FA=new M({props:{code:"cHJpbnQodHJhaW5fZGF0YXNldCklMEFwcmludCh0ZXN0X2RhdGFzZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(train_dataset)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(test_dataset)`,wrap:!1}}),jA=new R({props:{title:"6. Visualize Class Occurrences 👀",local:"6-visualize-class-occurrences-",headingTag:"h2"}}),RA=new M({props:{code:"aWRfbGlzdCUyMCUzRCUyMCU1QiU1RCUwQWNhdGVnb3J5X2V4YW1wbGVzJTIwJTNEJTIwJTdCJTdEJTBBZm9yJTIwZXhhbXBsZSUyMGluJTIwdHJhaW5fZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMGlkX2xpc3QlMjAlMkIlM0QlMjBleGFtcGxlJTVCJTIyb2JqZWN0cyUyMiU1RCU1QiUyMmJib3hfaWQlMjIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBjYXRlZ29yeSUyMGluJTIwZXhhbXBsZSU1QiUyMm9iamVjdHMlMjIlNUQlNUIlMjJjYXRlZ29yeSUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaWQybGFiZWwlNUJjYXRlZ29yeSU1RCUyMG5vdCUyMGluJTIwY2F0ZWdvcnlfZXhhbXBsZXMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYXRlZ29yeV9leGFtcGxlcyU1QmlkMmxhYmVsJTVCY2F0ZWdvcnklNUQlNUQlMjAlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhdGVnb3J5X2V4YW1wbGVzJTVCaWQybGFiZWwlNUJjYXRlZ29yeSU1RCU1RCUyMCUyQiUzRCUyMDElMEElMEFpZF9saXN0LnNvcnQoKQ==",highlighted:`id_list = []
category_examples = {}
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> train_dataset:
    id_list += example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;bbox_id&quot;</span>]
    <span class="hljs-keyword">for</span> category <span class="hljs-keyword">in</span> example[<span class="hljs-string">&quot;objects&quot;</span>][<span class="hljs-string">&quot;category&quot;</span>]:
        <span class="hljs-keyword">if</span> id2label[category] <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> category_examples:
            category_examples[id2label[category]] = <span class="hljs-number">1</span>
        <span class="hljs-keyword">else</span>:
            category_examples[id2label[category]] += <span class="hljs-number">1</span>

id_list.sort()`,wrap:!1}}),wA=new M({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWNhdGVnb3JpZXMlMjAlM0QlMjBsaXN0KGNhdGVnb3J5X2V4YW1wbGVzLmtleXMoKSklMEF2YWx1ZXMlMjAlM0QlMjBsaXN0KGNhdGVnb3J5X2V4YW1wbGVzLnZhbHVlcygpKSUwQSUwQWZpZyUyQyUyMGF4JTIwJTNEJTIwcGx0LnN1YnBsb3RzKGZpZ3NpemUlM0QoMTIlMkMlMjA4KSklMEElMEFiYXJzJTIwJTNEJTIwYXguYmFyKGNhdGVnb3JpZXMlMkMlMjB2YWx1ZXMlMkMlMjBjb2xvciUzRCUyMnNreWJsdWUlMjIpJTBBJTBBYXguc2V0X3hsYWJlbCglMjJDYXRlZ29yaWVzJTIyJTJDJTIwZm9udHNpemUlM0QxNCklMEFheC5zZXRfeWxhYmVsKCUyMk51bWJlciUyMG9mJTIwT2NjdXJyZW5jZXMlMjIlMkMlMjBmb250c2l6ZSUzRDE0KSUwQWF4LnNldF90aXRsZSglMjJOdW1iZXIlMjBvZiUyME9jY3VycmVuY2VzJTIwYnklMjBDYXRlZ29yeSUyMiUyQyUyMGZvbnRzaXplJTNEMTYpJTBBJTBBYXguc2V0X3h0aWNrbGFiZWxzKGNhdGVnb3JpZXMlMkMlMjByb3RhdGlvbiUzRDkwJTJDJTIwaGElM0QlMjJyaWdodCUyMiklMEFheC5ncmlkKGF4aXMlM0QlMjJ5JTIyJTJDJTIwbGluZXN0eWxlJTNEJTIyLS0lMjIlMkMlMjBhbHBoYSUzRDAuNyklMEElMEFmb3IlMjBiYXIlMjBpbiUyMGJhcnMlM0ElMEElMjAlMjAlMjAlMjBoZWlnaHQlMjAlM0QlMjBiYXIuZ2V0X2hlaWdodCgpJTBBJTIwJTIwJTIwJTIwYXgudGV4dChiYXIuZ2V0X3goKSUyMCUyQiUyMGJhci5nZXRfd2lkdGgoKSUyMCUyRiUyMDIuMCUyQyUyMGhlaWdodCUyQyUyMGYlMjIlN0JoZWlnaHQlN0QlMjIlMkMlMjBoYSUzRCUyMmNlbnRlciUyMiUyQyUyMHZhJTNEJTIyYm90dG9tJTIyJTJDJTIwZm9udHNpemUlM0QxMCklMEElMEFwbHQudGlnaHRfbGF5b3V0KCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>categories = <span class="hljs-built_in">list</span>(category_examples.keys())
<span class="hljs-meta">&gt;&gt;&gt; </span>values = <span class="hljs-built_in">list</span>(category_examples.values())

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, ax = plt.subplots(figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">8</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>bars = ax.bar(categories, values, color=<span class="hljs-string">&quot;skyblue&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ax.set_xlabel(<span class="hljs-string">&quot;Categories&quot;</span>, fontsize=<span class="hljs-number">14</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax.set_ylabel(<span class="hljs-string">&quot;Number of Occurrences&quot;</span>, fontsize=<span class="hljs-number">14</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax.set_title(<span class="hljs-string">&quot;Number of Occurrences by Category&quot;</span>, fontsize=<span class="hljs-number">16</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ax.set_xticklabels(categories, rotation=<span class="hljs-number">90</span>, ha=<span class="hljs-string">&quot;right&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax.grid(axis=<span class="hljs-string">&quot;y&quot;</span>, linestyle=<span class="hljs-string">&quot;--&quot;</span>, alpha=<span class="hljs-number">0.7</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> bar <span class="hljs-keyword">in</span> bars:
<span class="hljs-meta">... </span>    height = bar.get_height()
<span class="hljs-meta">... </span>    ax.text(bar.get_x() + bar.get_width() / <span class="hljs-number">2.0</span>, height, <span class="hljs-string">f&quot;<span class="hljs-subst">{height}</span>&quot;</span>, ha=<span class="hljs-string">&quot;center&quot;</span>, va=<span class="hljs-string">&quot;bottom&quot;</span>, fontsize=<span class="hljs-number">10</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.tight_layout()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),yA=new R({props:{title:"7. Add Data Augmentation to the Dataset",local:"7-add-data-augmentation-to-the-dataset",headingTag:"h2"}}),TA=new M({props:{code:"aW1wb3J0JTIwYWxidW1lbnRhdGlvbnMlMjBhcyUyMEElMEElMEF0cmFpbl90cmFuc2Zvcm0lMjAlM0QlMjBBLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQS5Mb25nZXN0TWF4U2l6ZSg1MDApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQS5QYWRJZk5lZWRlZCg1MDAlMkMlMjA1MDAlMkMlMjBib3JkZXJfbW9kZSUzRDAlMkMlMjB2YWx1ZSUzRCgwJTJDJTIwMCUyQyUyMDApKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEEuSG9yaXpvbnRhbEZsaXAocCUzRDAuNSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBLlJhbmRvbUJyaWdodG5lc3NDb250cmFzdChwJTNEMC41KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEEuSHVlU2F0dXJhdGlvblZhbHVlKHAlM0QwLjUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQS5Sb3RhdGUobGltaXQlM0QxMCUyQyUyMHAlM0QwLjUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQS5SYW5kb21TY2FsZShzY2FsZV9saW1pdCUzRDAuMiUyQyUyMHAlM0QwLjUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQS5HYXVzc2lhbkJsdXIocCUzRDAuNSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBLkdhdXNzTm9pc2UocCUzRDAuNSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBiYm94X3BhcmFtcyUzREEuQmJveFBhcmFtcyhmb3JtYXQlM0QlMjJwYXNjYWxfdm9jJTIyJTJDJTIwbGFiZWxfZmllbGRzJTNEJTVCJTIyY2F0ZWdvcnklMjIlNUQpJTJDJTBBKSUwQSUwQXZhbF90cmFuc2Zvcm0lMjAlM0QlMjBBLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQS5Mb25nZXN0TWF4U2l6ZSg1MDApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQS5QYWRJZk5lZWRlZCg1MDAlMkMlMjA1MDAlMkMlMjBib3JkZXJfbW9kZSUzRDAlMkMlMjB2YWx1ZSUzRCgwJTJDJTIwMCUyQyUyMDApKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMGJib3hfcGFyYW1zJTNEQS5CYm94UGFyYW1zKGZvcm1hdCUzRCUyMnBhc2NhbF92b2MlMjIlMkMlMjBsYWJlbF9maWVsZHMlM0QlNUIlMjJjYXRlZ29yeSUyMiU1RCklMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> albumentations <span class="hljs-keyword">as</span> A

train_transform = A.Compose(
    [
        A.LongestMaxSize(<span class="hljs-number">500</span>),
        A.PadIfNeeded(<span class="hljs-number">500</span>, <span class="hljs-number">500</span>, border_mode=<span class="hljs-number">0</span>, value=(<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>)),
        A.HorizontalFlip(p=<span class="hljs-number">0.5</span>),
        A.RandomBrightnessContrast(p=<span class="hljs-number">0.5</span>),
        A.HueSaturationValue(p=<span class="hljs-number">0.5</span>),
        A.Rotate(limit=<span class="hljs-number">10</span>, p=<span class="hljs-number">0.5</span>),
        A.RandomScale(scale_limit=<span class="hljs-number">0.2</span>, p=<span class="hljs-number">0.5</span>),
        A.GaussianBlur(p=<span class="hljs-number">0.5</span>),
        A.GaussNoise(p=<span class="hljs-number">0.5</span>),
    ],
    bbox_params=A.BboxParams(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;pascal_voc&quot;</span>, label_fields=[<span class="hljs-string">&quot;category&quot;</span>]),
)

val_transform = A.Compose(
    [
        A.LongestMaxSize(<span class="hljs-number">500</span>),
        A.PadIfNeeded(<span class="hljs-number">500</span>, <span class="hljs-number">500</span>, border_mode=<span class="hljs-number">0</span>, value=(<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>)),
    ],
    bbox_params=A.BboxParams(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;pascal_voc&quot;</span>, label_fields=[<span class="hljs-string">&quot;category&quot;</span>]),
)`,wrap:!1}}),uA=new R({props:{title:"8. Initialize Image Processor from Model Checkpoint 🎆",local:"8-initialize-image-processor-from-model-checkpoint-",headingTag:"h2"}}),BA=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwLWRjNSUyMiUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

checkpoint = <span class="hljs-string">&quot;facebook/detr-resnet-50-dc5&quot;</span>
image_processor = AutoImageProcessor.from_pretrained(checkpoint)`,wrap:!1}}),bA=new R({props:{title:"Adding Methods to Process the Dataset",local:"adding-methods-to-process-the-dataset",headingTag:"h3"}}),PA=new M({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatted_anns</span>(<span class="hljs-params">image_id, category, area, bbox</span>):
    annotations = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(category)):
        new_ann = {
            <span class="hljs-string">&quot;image_id&quot;</span>: image_id,
            <span class="hljs-string">&quot;category_id&quot;</span>: category[i],
            <span class="hljs-string">&quot;isCrowd&quot;</span>: <span class="hljs-number">0</span>,
            <span class="hljs-string">&quot;area&quot;</span>: area[i],
            <span class="hljs-string">&quot;bbox&quot;</span>: <span class="hljs-built_in">list</span>(bbox[i]),
        }
        annotations.append(new_ann)

    <span class="hljs-keyword">return</span> annotations


<span class="hljs-keyword">def</span> <span class="hljs-title function_">convert_voc_to_coco</span>(<span class="hljs-params">bbox</span>):
    xmin, ymin, xmax, ymax = bbox
    width = xmax - xmin
    height = ymax - ymin
    <span class="hljs-keyword">return</span> [xmin, ymin, width, height]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_aug_ann</span>(<span class="hljs-params">examples, transform</span>):
    image_ids = examples[<span class="hljs-string">&quot;image_id&quot;</span>]
    images, bboxes, area, categories = [], [], [], []
    <span class="hljs-keyword">for</span> image, objects <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;image&quot;</span>], examples[<span class="hljs-string">&quot;objects&quot;</span>]):
        image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>))[:, :, ::-<span class="hljs-number">1</span>]
        out = transform(image=image, bboxes=objects[<span class="hljs-string">&quot;bbox&quot;</span>], category=objects[<span class="hljs-string">&quot;category&quot;</span>])

        area.append(objects[<span class="hljs-string">&quot;area&quot;</span>])
        images.append(out[<span class="hljs-string">&quot;image&quot;</span>])

        <span class="hljs-comment"># Convert to COCO format</span>
        converted_bboxes = [convert_voc_to_coco(bbox) <span class="hljs-keyword">for</span> bbox <span class="hljs-keyword">in</span> out[<span class="hljs-string">&quot;bboxes&quot;</span>]]
        bboxes.append(converted_bboxes)

        categories.append(out[<span class="hljs-string">&quot;category&quot;</span>])

    targets = [
        {<span class="hljs-string">&quot;image_id&quot;</span>: id_, <span class="hljs-string">&quot;annotations&quot;</span>: formatted_anns(id_, cat_, ar_, box_)}
        <span class="hljs-keyword">for</span> id_, cat_, ar_, box_ <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(image_ids, categories, area, bboxes)
    ]

    <span class="hljs-keyword">return</span> image_processor(images=images, annotations=targets, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_train</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> transform_aug_ann(examples, transform=train_transform)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_val</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> transform_aug_ann(examples, transform=val_transform)


train_dataset_transformed = train_dataset.with_transform(transform_train)
test_dataset_transformed = test_dataset.with_transform(transform_val)`,wrap:!1}}),gA=new R({props:{title:"9. Plot Augmented Examples 🎆",local:"9-plot-augmented-examples-",headingTag:"h2"}}),VA=new M({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Updated draw function to accept an optional transform</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">draw_augmented_image_from_idx</span>(<span class="hljs-params">dataset, idx, transform=<span class="hljs-literal">None</span></span>):
<span class="hljs-meta">... </span>    sample = dataset[idx]
<span class="hljs-meta">... </span>    image = sample[<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">... </span>    annotations = sample[<span class="hljs-string">&quot;objects&quot;</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Convert image to RGB and NumPy array</span>
<span class="hljs-meta">... </span>    image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>))[:, :, ::-<span class="hljs-number">1</span>]

<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> transform:
<span class="hljs-meta">... </span>        augmented = transform(image=image, bboxes=annotations[<span class="hljs-string">&quot;bbox&quot;</span>], category=annotations[<span class="hljs-string">&quot;category&quot;</span>])
<span class="hljs-meta">... </span>        image = augmented[<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">... </span>        annotations[<span class="hljs-string">&quot;bbox&quot;</span>] = augmented[<span class="hljs-string">&quot;bboxes&quot;</span>]
<span class="hljs-meta">... </span>        annotations[<span class="hljs-string">&quot;category&quot;</span>] = augmented[<span class="hljs-string">&quot;category&quot;</span>]

<span class="hljs-meta">... </span>    image = Image.fromarray(image[:, :, ::-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Convert back to PIL Image</span>
<span class="hljs-meta">... </span>    draw = ImageDraw.Draw(image)
<span class="hljs-meta">... </span>    width, height = sample[<span class="hljs-string">&quot;width&quot;</span>], sample[<span class="hljs-string">&quot;height&quot;</span>]

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(annotations[<span class="hljs-string">&quot;bbox_id&quot;</span>])):
<span class="hljs-meta">... </span>        box = annotations[<span class="hljs-string">&quot;bbox&quot;</span>][i]
<span class="hljs-meta">... </span>        x1, y1, x2, y2 = <span class="hljs-built_in">tuple</span>(box)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Normalize coordinates if necessary</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> <span class="hljs-built_in">max</span>(box) &lt;= <span class="hljs-number">1.0</span>:
<span class="hljs-meta">... </span>            x1, y1 = <span class="hljs-built_in">int</span>(x1 * width), <span class="hljs-built_in">int</span>(y1 * height)
<span class="hljs-meta">... </span>            x2, y2 = <span class="hljs-built_in">int</span>(x2 * width), <span class="hljs-built_in">int</span>(y2 * height)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>            x1, y1 = <span class="hljs-built_in">int</span>(x1), <span class="hljs-built_in">int</span>(y1)
<span class="hljs-meta">... </span>            x2, y2 = <span class="hljs-built_in">int</span>(x2), <span class="hljs-built_in">int</span>(y2)

<span class="hljs-meta">... </span>        draw.rectangle((x1, y1, x2, y2), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">3</span>)
<span class="hljs-meta">... </span>        draw.text((x1, y1), id2label[annotations[<span class="hljs-string">&quot;category&quot;</span>][i]], fill=<span class="hljs-string">&quot;green&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Updated plot function to include augmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_augmented_images</span>(<span class="hljs-params">dataset, indices, transform=<span class="hljs-literal">None</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Plot images and their annotations with optional augmentation.
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    num_rows = <span class="hljs-built_in">len</span>(indices) // <span class="hljs-number">3</span>
<span class="hljs-meta">... </span>    num_cols = <span class="hljs-number">3</span>
<span class="hljs-meta">... </span>    fig, axes = plt.subplots(num_rows, num_cols, figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">10</span>))

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(indices):
<span class="hljs-meta">... </span>        row = i // num_cols
<span class="hljs-meta">... </span>        col = i % num_cols

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Draw augmented image</span>
<span class="hljs-meta">... </span>        image = draw_augmented_image_from_idx(dataset, idx, transform=transform)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Display image on the corresponding subplot</span>
<span class="hljs-meta">... </span>        axes[row, col].imshow(image)
<span class="hljs-meta">... </span>        axes[row, col].axis(<span class="hljs-string">&quot;off&quot;</span>)

<span class="hljs-meta">... </span>    plt.tight_layout()
<span class="hljs-meta">... </span>    plt.show()


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now use the function to plot augmented images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>plot_augmented_images(train_dataset, <span class="hljs-built_in">range</span>(<span class="hljs-number">9</span>), transform=train_transform)`,wrap:!1}}),XA=new R({props:{title:"10. Initialize Model from Checkpoint",local:"10-initialize-model-from-checkpoint",headingTag:"h2"}}),HA=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBjaGVja3BvaW50JTJDJTBBJTIwJTIwJTIwJTIwaWQybGFiZWwlM0RpZDJsYWJlbCUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsMmlkJTNEbGFiZWwyaWQlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForObjectDetection

model = AutoModelForObjectDetection.from_pretrained(
    checkpoint,
    id2label=id2label,
    label2id=label2id,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),GA=new M({props:{code:"b3V0cHV0X2RpciUyMCUzRCUyMCUyMmRldHItcmVzbmV0LTUwLWRjNS1mYXNoaW9ucGVkaWEtZmluZXR1bmVkJTIyJTIwJTIwJTIzJTIwY2hhbmdlJTIwdGhpcw==",highlighted:'output_dir = <span class="hljs-string">&quot;detr-resnet-50-dc5-fashionpedia-finetuned&quot;</span>  <span class="hljs-comment"># change this</span>',wrap:!1}}),zA=new R({props:{title:"10. Connect to HF Hub to Upload Fine-Tuned Model 🔌",local:"10-connect-to-hf-hub-to-upload-fine-tuned-model-",headingTag:"h2"}}),IA=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),WA=new R({props:{title:"11. Set Training Arguments, Connect to W&B, and Train!",local:"11-set-training-arguments-connect-to-wb-and-train",headingTag:"h2"}}),NA=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMERlZmluZSUyMHRoZSUyMHRyYWluaW5nJTIwYXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0RvdXRwdXRfZGlyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDEwMDAwJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMSUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEMWUtNCUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfdG90YWxfbGltaXQlM0QyJTJDJTBBJTIwJTIwJTIwJTIwcmVtb3ZlX3VudXNlZF9jb2x1bW5zJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlMjJ3YW5kYiUyMiUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoX2V2YWxfbWV0cmljcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># Define the training arguments</span>

training_args = TrainingArguments(
    output_dir=output_dir,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    per_device_eval_batch_size=<span class="hljs-number">4</span>,
    max_steps=<span class="hljs-number">10000</span>,
    fp16=<span class="hljs-literal">True</span>,
    save_steps=<span class="hljs-number">10</span>,
    logging_steps=<span class="hljs-number">1</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    weight_decay=<span class="hljs-number">1e-4</span>,
    save_total_limit=<span class="hljs-number">2</span>,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    eval_steps=<span class="hljs-number">50</span>,
    eval_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    report_to=<span class="hljs-string">&quot;wandb&quot;</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    batch_eval_metrics=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),QA=new R({props:{title:"Connect to W&B to Track Training",local:"connect-to-wb-to-track-training",headingTag:"h3"}}),qA=new M({props:{code:"aW1wb3J0JTIwd2FuZGIlMEElMEF3YW5kYi5pbml0KCUwQSUyMCUyMCUyMCUyMHByb2plY3QlM0QlMjJkZXRyLXJlc25ldC01MC1kYzUtZmFzaGlvbnBlZGlhLWZpbmV0dW5lZCUyMiUyQyUyMCUyMCUyMyUyMGNoYW5nZSUyMHRoaXMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyZGV0ci1yZXNuZXQtNTAtZGM1LWZhc2hpb25wZWRpYS1maW5ldHVuZWQlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2UlMjB0aGlzJTBBJTIwJTIwJTIwJTIwY29uZmlnJTNEdHJhaW5pbmdfYXJncyUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> wandb

wandb.init(
    project=<span class="hljs-string">&quot;detr-resnet-50-dc5-fashionpedia-finetuned&quot;</span>,  <span class="hljs-comment"># change this</span>
    name=<span class="hljs-string">&quot;detr-resnet-50-dc5-fashionpedia-finetuned&quot;</span>,  <span class="hljs-comment"># change this</span>
    config=training_args,
)`,wrap:!1}}),vA=new R({props:{title:"Let’s Train the Model! 🚀",local:"lets-train-the-model-",headingTag:"h3"}}),ZA=new M({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torchmetrics.detection.mean_ap <span class="hljs-keyword">import</span> MeanAveragePrecision
<span class="hljs-keyword">from</span> torch.nn.functional <span class="hljs-keyword">import</span> softmax


<span class="hljs-keyword">def</span> <span class="hljs-title function_">denormalize_boxes</span>(<span class="hljs-params">boxes, width, height</span>):
    boxes = boxes.clone()
    boxes[:, <span class="hljs-number">0</span>] *= width  <span class="hljs-comment"># xmin</span>
    boxes[:, <span class="hljs-number">1</span>] *= height  <span class="hljs-comment"># ymin</span>
    boxes[:, <span class="hljs-number">2</span>] *= width  <span class="hljs-comment"># xmax</span>
    boxes[:, <span class="hljs-number">3</span>] *= height  <span class="hljs-comment"># ymax</span>
    <span class="hljs-keyword">return</span> boxes


batch_metrics = []


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred, compute_result</span>):
    <span class="hljs-keyword">global</span> batch_metrics

    (loss_dict, scores, pred_boxes, last_hidden_state, encoder_last_hidden_state), labels = eval_pred

    image_sizes = []
    target = []
    <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> labels:

        image_sizes.append(label[<span class="hljs-string">&quot;orig_size&quot;</span>])
        width, height = label[<span class="hljs-string">&quot;orig_size&quot;</span>]
        denormalized_boxes = denormalize_boxes(label[<span class="hljs-string">&quot;boxes&quot;</span>], width, height)
        target.append(
            {
                <span class="hljs-string">&quot;boxes&quot;</span>: denormalized_boxes,
                <span class="hljs-string">&quot;labels&quot;</span>: label[<span class="hljs-string">&quot;class_labels&quot;</span>],
            }
        )
    predictions = []
    <span class="hljs-keyword">for</span> score, box, target_sizes <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(scores, pred_boxes, image_sizes):
        <span class="hljs-comment"># Extract the bounding boxes, labels, and scores from the model&#x27;s output</span>
        pred_scores = score[:, :-<span class="hljs-number">1</span>]  <span class="hljs-comment"># Exclude the no-object class</span>
        pred_scores = softmax(pred_scores, dim=-<span class="hljs-number">1</span>)
        width, height = target_sizes
        pred_boxes = denormalize_boxes(box, width, height)
        pred_labels = torch.argmax(pred_scores, dim=-<span class="hljs-number">1</span>)

        <span class="hljs-comment"># Get the scores corresponding to the predicted labels</span>
        pred_scores_for_labels = torch.gather(pred_scores, <span class="hljs-number">1</span>, pred_labels.unsqueeze(-<span class="hljs-number">1</span>)).squeeze(-<span class="hljs-number">1</span>)
        predictions.append(
            {
                <span class="hljs-string">&quot;boxes&quot;</span>: pred_boxes,
                <span class="hljs-string">&quot;scores&quot;</span>: pred_scores_for_labels,
                <span class="hljs-string">&quot;labels&quot;</span>: pred_labels,
            }
        )

    metric = MeanAveragePrecision(box_format=<span class="hljs-string">&quot;xywh&quot;</span>, class_metrics=<span class="hljs-literal">True</span>)

    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> compute_result:
        <span class="hljs-comment"># Accumulate batch-level metrics</span>
        batch_metrics.append({<span class="hljs-string">&quot;preds&quot;</span>: predictions, <span class="hljs-string">&quot;target&quot;</span>: target})
        <span class="hljs-keyword">return</span> {}
    <span class="hljs-keyword">else</span>:
        <span class="hljs-comment"># Compute final aggregated metrics</span>
        <span class="hljs-comment"># Aggregate batch-level metrics (this should be done based on your metric library&#x27;s needs)</span>
        all_preds = []
        all_targets = []
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> batch_metrics:
            all_preds.extend(batch[<span class="hljs-string">&quot;preds&quot;</span>])
            all_targets.extend(batch[<span class="hljs-string">&quot;target&quot;</span>])

        <span class="hljs-comment"># Update metric with all accumulated predictions and targets</span>
        metric.update(preds=all_preds, target=all_targets)
        metrics = metric.compute()

        <span class="hljs-comment"># Convert and format metrics as needed</span>
        classes = metrics.pop(<span class="hljs-string">&quot;classes&quot;</span>)
        map_per_class = metrics.pop(<span class="hljs-string">&quot;map_per_class&quot;</span>)
        mar_100_per_class = metrics.pop(<span class="hljs-string">&quot;mar_100_per_class&quot;</span>)

        <span class="hljs-keyword">for</span> class_id, class_map, class_mar <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(classes, map_per_class, mar_100_per_class):
            class_name = id2label[class_id.item()] <span class="hljs-keyword">if</span> id2label <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> class_id.item()
            metrics[<span class="hljs-string">f&quot;map_<span class="hljs-subst">{class_name}</span>&quot;</span>] = class_map
            metrics[<span class="hljs-string">f&quot;mar_100_<span class="hljs-subst">{class_name}</span>&quot;</span>] = class_mar

        <span class="hljs-comment"># Round metrics for cleaner output</span>
        metrics = {k: <span class="hljs-built_in">round</span>(v.item(), <span class="hljs-number">4</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> metrics.items()}

        <span class="hljs-comment"># Clear batch metrics for next evaluation</span>
        batch_metrics = []

        <span class="hljs-keyword">return</span> metrics`,wrap:!1}}),OA=new M({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihiYXRjaCklM0ElMEElMjAlMjAlMjAlMjBwaXhlbF92YWx1ZXMlMjAlM0QlMjAlNUJpdGVtJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMjAlMjAlMjAlMjBlbmNvZGluZyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wYWQocGl4ZWxfdmFsdWVzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjAlNUJpdGVtJTVCJTIybGFiZWxzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwZW5jb2RpbmclNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnBpeGVsX21hc2slMjIlNUQlMjAlM0QlMjBlbmNvZGluZyU1QiUyMnBpeGVsX21hc2slMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGxhYmVscyUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNo",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">batch</span>):
    pixel_values = [item[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]
    encoding = image_processor.pad(pixel_values, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    labels = [item[<span class="hljs-string">&quot;labels&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]

    batch = {}
    batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_values&quot;</span>]
    batch[<span class="hljs-string">&quot;pixel_mask&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_mask&quot;</span>]
    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),YA=new M({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGNvbGxhdGVfZm4lMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldF90cmFuc2Zvcm1lZCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHRlc3RfZGF0YXNldF90cmFuc2Zvcm1lZCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRGltYWdlX3Byb2Nlc3NvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSk=",highlighted:`trainer = Trainer(
    model=model,
    args=training_args,
    data_collator=collate_fn,
    train_dataset=train_dataset_transformed,
    eval_dataset=test_dataset_transformed,
    tokenizer=image_processor,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),LA=new M({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),EA=new M({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),_A=new R({props:{title:"12. Test How the Model Behaves on a Test Image 📝",local:"12-test-how-the-model-behaves-on-a-test-image-",headingTag:"h2"}}),Aa=new M({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMkMlMjBJbWFnZURyYXclMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmltYWdlcy51bnNwbGFzaC5jb20lMkZwaG90by0xNTM2MjQzMjk4NzQ3LWVhODg3NDEzNmQ2NCUzRnElM0Q4MCUyNnclM0Q2NDAlMjIlMEElMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFvYmpfZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjJvYmplY3QtZGV0ZWN0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJzZXJnaW9wYW5pZWdvJTJGZGV0ci1yZXNuZXQtNTAtZGM1LWZhc2hpb25wZWRpYS1maW5ldHVuZWQlMjIlMjAlMjAlMjMlMjBDaGFuZ2UlMjB3aXRoJTIweW91ciUyMG1vZGVsJTIwbmFtZSUwQSklMEElMEElMEFyZXN1bHRzJTIwJTNEJTIwb2JqX2RldGVjdG9yKGltYWdlKSUwQXByaW50KHJlc3VsdHMp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image, ImageDraw

url = <span class="hljs-string">&quot;https://images.unsplash.com/photo-1536243298747-ea8874136d64?q=80&amp;w=640&quot;</span>

image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

obj_detector = pipeline(
    <span class="hljs-string">&quot;object-detection&quot;</span>, model=<span class="hljs-string">&quot;sergiopaniego/detr-resnet-50-dc5-fashionpedia-finetuned&quot;</span>  <span class="hljs-comment"># Change with your model name</span>
)


results = obj_detector(image)
<span class="hljs-built_in">print</span>(results)`,wrap:!1}}),aa=new R({props:{title:"Now, Let’s Show the Results",local:"now-lets-show-the-results",headingTag:"h3"}}),la=new M({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTJDJTIwSW1hZ2VEcmF3JTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwcGxvdF9yZXN1bHRzKGltYWdlJTJDJTIwcmVzdWx0cyUyQyUyMHRocmVzaG9sZCUzRDAuNiklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShucC51aW50OChpbWFnZSkpJTBBJTIwJTIwJTIwJTIwZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlKSUwQSUyMCUyMCUyMCUyMHdpZHRoJTJDJTIwaGVpZ2h0JTIwJTNEJTIwaW1hZ2Uuc2l6ZSUwQSUwQSUyMCUyMCUyMCUyMGZvciUyMHJlc3VsdCUyMGluJTIwcmVzdWx0cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3JlJTIwJTNEJTIwcmVzdWx0JTVCJTIyc2NvcmUlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbCUyMCUzRCUyMHJlc3VsdCU1QiUyMmxhYmVsJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm94JTIwJTNEJTIwbGlzdChyZXN1bHQlNUIlMjJib3glMjIlNUQudmFsdWVzKCkpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzY29yZSUyMCUzRSUyMHRocmVzaG9sZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHgxJTJDJTIweTElMkMlMjB4MiUyQyUyMHkyJTIwJTNEJTIwdHVwbGUoYm94KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRyYXcucmVjdGFuZ2xlKCh4MSUyQyUyMHkxJTJDJTIweDIlMkMlMjB5MiklMkMlMjBvdXRsaW5lJTNEJTIycmVkJTIyJTJDJTIwd2lkdGglM0QzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRyYXcudGV4dCgoeDElMjAlMkIlMjA1JTJDJTIweTElMjAtJTIwMTApJTJDJTIwbGFiZWwlMkMlMjBmaWxsJTNEJTIyd2hpdGUlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHJhdy50ZXh0KCh4MSUyMCUyQiUyMDUlMkMlMjB5MSUyMCUyQiUyMDEwKSUyQyUyMGYlMjIlN0JzY29yZSUzQS4yZiU3RCUyMiUyQyUyMGZpbGwlM0QlMjJncmVlbiUyMiUyMGlmJTIwc2NvcmUlMjAlM0UlMjAwLjclMjBlbHNlJTIwJTIycmVkJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGltYWdl",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image, ImageDraw
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_results</span>(<span class="hljs-params">image, results, threshold=<span class="hljs-number">0.6</span></span>):
    image = Image.fromarray(np.uint8(image))
    draw = ImageDraw.Draw(image)
    width, height = image.size

    <span class="hljs-keyword">for</span> result <span class="hljs-keyword">in</span> results:
        score = result[<span class="hljs-string">&quot;score&quot;</span>]
        label = result[<span class="hljs-string">&quot;label&quot;</span>]
        box = <span class="hljs-built_in">list</span>(result[<span class="hljs-string">&quot;box&quot;</span>].values())

        <span class="hljs-keyword">if</span> score &gt; threshold:
            x1, y1, x2, y2 = <span class="hljs-built_in">tuple</span>(box)
            draw.rectangle((x1, y1, x2, y2), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">3</span>)
            draw.text((x1 + <span class="hljs-number">5</span>, y1 - <span class="hljs-number">10</span>), label, fill=<span class="hljs-string">&quot;white&quot;</span>)
            draw.text((x1 + <span class="hljs-number">5</span>, y1 + <span class="hljs-number">10</span>), <span class="hljs-string">f&quot;<span class="hljs-subst">{score:<span class="hljs-number">.2</span>f}</span>&quot;</span>, fill=<span class="hljs-string">&quot;green&quot;</span> <span class="hljs-keyword">if</span> score &gt; <span class="hljs-number">0.7</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;red&quot;</span>)

    <span class="hljs-keyword">return</span> image`,wrap:!1}}),sa=new M({props:{code:"cGxvdF9yZXN1bHRzKGltYWdlJTJDJTIwcmVzdWx0cyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>plot_results(image, results)',wrap:!1}}),oa=new R({props:{title:"13. Evaluation of the Model on the Test Set 📝",local:"13-evaluation-of-the-model-on-the-test-set-",headingTag:"h2"}}),ia=new M({props:{code:"bWV0cmljcyUyMCUzRCUyMHRyYWluZXIuZXZhbHVhdGUodGVzdF9kYXRhc2V0X3RyYW5zZm9ybWVkKSUwQXByaW50KG1ldHJpY3Mp",highlighted:`metrics = trainer.evaluate(test_dataset_transformed)
<span class="hljs-built_in">print</span>(metrics)`,wrap:!1}}),ea=new R({props:{title:"14. Deploy the Model in a HF Space",local:"14-deploy-the-model-in-a-hf-space",headingTag:"h2"}}),pa=new M({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMElGcmFtZSUwQSUwQUlGcmFtZShzcmMlM0QlMjJodHRwcyUzQSUyRiUyRnNlcmdpb3BhbmllZ28tZGV0ci1vYmplY3QtZGV0ZWN0aW9uLWZhc2hpb25wZWRpYS1mYTAwODFmLmhmLnNwYWNlJTIyJTJDJTIwd2lkdGglM0QxMDAwJTJDJTIwaGVpZ2h0JTNEODAwKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> IFrame

IFrame(src=<span class="hljs-string">&quot;https://sergiopaniego-detr-object-detection-fashionpedia-fa0081f.hf.space&quot;</span>, width=<span class="hljs-number">1000</span>, height=<span class="hljs-number">800</span>)`,wrap:!1}}),Fa=new R({props:{title:"Create the Application with the Following Code",local:"create-the-application-with-the-following-code",headingTag:"h3"}}),ja=new M({props:{code:"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",highlighted:`<span class="hljs-comment"># app.py</span>

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> spaces
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> io

model_pipeline = pipeline(<span class="hljs-string">&quot;object-detection&quot;</span>, model=<span class="hljs-string">&quot;sergiopaniego/detr-resnet-50-dc5-fashionpedia-finetuned&quot;</span>)


COLORS = [
    [<span class="hljs-number">0.000</span>, <span class="hljs-number">0.447</span>, <span class="hljs-number">0.741</span>],
    [<span class="hljs-number">0.850</span>, <span class="hljs-number">0.325</span>, <span class="hljs-number">0.098</span>],
    [<span class="hljs-number">0.929</span>, <span class="hljs-number">0.694</span>, <span class="hljs-number">0.125</span>],
    [<span class="hljs-number">0.494</span>, <span class="hljs-number">0.184</span>, <span class="hljs-number">0.556</span>],
    [<span class="hljs-number">0.466</span>, <span class="hljs-number">0.674</span>, <span class="hljs-number">0.188</span>],
    [<span class="hljs-number">0.301</span>, <span class="hljs-number">0.745</span>, <span class="hljs-number">0.933</span>],
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_output_figure</span>(<span class="hljs-params">pil_img, results, threshold</span>):
    plt.figure(figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">10</span>))
    plt.imshow(pil_img)
    ax = plt.gca()
    colors = COLORS * <span class="hljs-number">100</span>

    <span class="hljs-keyword">for</span> result <span class="hljs-keyword">in</span> results:
        score = result[<span class="hljs-string">&quot;score&quot;</span>]
        label = result[<span class="hljs-string">&quot;label&quot;</span>]
        box = <span class="hljs-built_in">list</span>(result[<span class="hljs-string">&quot;box&quot;</span>].values())
        <span class="hljs-keyword">if</span> score &gt; threshold:
            c = COLORS[<span class="hljs-built_in">hash</span>(label) % <span class="hljs-built_in">len</span>(COLORS)]
            ax.add_patch(
                plt.Rectangle((box[<span class="hljs-number">0</span>], box[<span class="hljs-number">1</span>]), box[<span class="hljs-number">2</span>] - box[<span class="hljs-number">0</span>], box[<span class="hljs-number">3</span>] - box[<span class="hljs-number">1</span>], fill=<span class="hljs-literal">False</span>, color=c, linewidth=<span class="hljs-number">3</span>)
            )
            text = <span class="hljs-string">f&quot;<span class="hljs-subst">{label}</span>: <span class="hljs-subst">{score:<span class="hljs-number">0.2</span>f}</span>&quot;</span>
            ax.text(box[<span class="hljs-number">0</span>], box[<span class="hljs-number">1</span>], text, fontsize=<span class="hljs-number">15</span>, bbox=<span class="hljs-built_in">dict</span>(facecolor=<span class="hljs-string">&quot;yellow&quot;</span>, alpha=<span class="hljs-number">0.5</span>))
    plt.axis(<span class="hljs-string">&quot;off&quot;</span>)

    <span class="hljs-keyword">return</span> plt.gcf()


<span class="hljs-meta">@spaces.GPU</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">detect</span>(<span class="hljs-params">image</span>):
    results = model_pipeline(image)
    <span class="hljs-built_in">print</span>(results)

    output_figure = get_output_figure(image, results, threshold=<span class="hljs-number">0.7</span>)

    buf = io.BytesIO()
    output_figure.savefig(buf, bbox_inches=<span class="hljs-string">&quot;tight&quot;</span>)
    buf.seek(<span class="hljs-number">0</span>)
    output_pil_img = Image.<span class="hljs-built_in">open</span>(buf)

    <span class="hljs-keyword">return</span> output_pil_img


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    gr.Markdown(<span class="hljs-string">&quot;# Object detection with DETR fine tuned on detection-datasets/fashionpedia&quot;</span>)
    gr.Markdown(
        <span class="hljs-string">&quot;&quot;&quot;
        This application uses a fine tuned DETR (DEtection TRansformers) to detect objects on images.
        This version was trained using detection-datasets/fashionpedia dataset.
        You can load an image and see the predictions for the objects detected.
        &quot;&quot;&quot;</span>
    )

    gr.Interface(
        fn=detect,
        inputs=gr.Image(label=<span class="hljs-string">&quot;Input image&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;pil&quot;</span>),
        outputs=[gr.Image(label=<span class="hljs-string">&quot;Output prediction&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;pil&quot;</span>)],
    )

demo.launch(show_error=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ma=new R({props:{title:"Remember to Set Up requirements.txt",local:"remember-to-set-up-requirementstxt",headingTag:"h3"}}),wa=new M({props:{code:"IXRvdWNoJTIwcmVxdWlyZW1lbnRzLnR4dCUwQSFlY2hvJTIwLWUlMjAlMjJ0cmFuc2Zvcm1lcnMlNUNudGltbSU1Q250b3JjaCU1Q25ncmFkaW8lNUNubWF0cGxvdGxpYiUyMiUyMCUzRSUyMHJlcXVpcmVtZW50cy50eHQ=",highlighted:`!touch requirements.txt
!echo -e <span class="hljs-string">&quot;transformers\\ntimm\\ntorch\\ngradio\\nmatplotlib&quot;</span> &gt; requirements.txt`,wrap:!1}}),ca=new R({props:{title:"15. Access the Space as an API 🧑‍💻️",local:"15-access-the-space-as-an-api-",headingTag:"h2"}}),fa=new M({props:{code:"IXBpcCUyMGluc3RhbGwlMjBncmFkaW9fY2xpZW50",highlighted:"!pip install gradio_client",wrap:!1}}),Ta=new M({props:{code:"ZnJvbSUyMGdyYWRpb19jbGllbnQlMjBpbXBvcnQlMjBDbGllbnQlMkMlMjBoYW5kbGVfZmlsZSUwQSUwQWNsaWVudCUyMCUzRCUyMENsaWVudCglMjJzZXJnaW9wYW5pZWdvJTJGREVUUl9vYmplY3RfZGV0ZWN0aW9uX2Zhc2hpb25wZWRpYS1maW5ldHVuZWQlMjIpJTIwJTIwJTIzJTIwY2hhbmdlJTIwdGhpcyUyMHdpdGglMjB5b3VyJTIwU3BhY2UlMEFyZXN1bHQlMjAlM0QlMjBjbGllbnQucHJlZGljdCglMEElMjAlMjAlMjAlMjBpbWFnZSUzRGhhbmRsZV9maWxlKCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE1MzYyNDMyOTg3NDctZWE4ODc0MTM2ZDY0JTNGcSUzRDgwJTI2dyUzRDY0MCUyMiklMkMlMjBhcGlfbmFtZSUzRCUyMiUyRnByZWRpY3QlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> gradio_client <span class="hljs-keyword">import</span> Client, handle_file

client = Client(<span class="hljs-string">&quot;sergiopaniego/DETR_object_detection_fashionpedia-finetuned&quot;</span>)  <span class="hljs-comment"># change this with your Space</span>
result = client.predict(
    image=handle_file(<span class="hljs-string">&quot;https://images.unsplash.com/photo-1536243298747-ea8874136d64?q=80&amp;w=640&quot;</span>), api_name=<span class="hljs-string">&quot;/predict&quot;</span>
)`,wrap:!1}}),ua=new M({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXN1bHQpLmNvbnZlcnQoJTIyUkdCJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

img = Image.<span class="hljs-built_in">open</span>(result).convert(<span class="hljs-string">&quot;RGB&quot;</span>)`,wrap:!1}}),ma=new M({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMGRpc3BsYXklMEElMEFkaXNwbGF5KGltZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> display

<span class="hljs-meta">&gt;&gt;&gt; </span>display(img)`,wrap:!1}}),Ba=new R({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Pa=new no({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/fine_tuning_detr_custom_dataset.md"}}),{c(){c=F("meta"),za=s(),Ha=F("p"),ha=s(),U(T.$$.fragment),Ia=s(),U(u.$$.fragment),Wa=s(),m=F("p"),m.innerHTML=As,ka=s(),B=F("p"),B.innerHTML=as,Na=s(),b=F("p"),b.innerHTML=ts,Qa=s(),d=F("p"),d.textContent=ls,qa=s(),P=F("p"),P.innerHTML=ss,va=s(),U(g.$$.fragment),Sa=s(),C=F("p"),C.textContent=os,Da=s(),U(V.$$.fragment),Za=s(),U(X.$$.fragment),Oa=s(),y=F("img"),Ya=s(),x=F("p"),x.innerHTML=is,La=s(),U(H.$$.fragment),Ea=s(),G=F("p"),G.textContent=es,_a=s(),z=F("ul"),z.innerHTML=ns,$a=s(),h=F("p"),h.innerHTML=Ks,At=s(),U(I.$$.fragment),at=s(),U(W.$$.fragment),tt=s(),k=F("p"),k.textContent=ps,lt=s(),U(N.$$.fragment),st=s(),U(Q.$$.fragment),ot=s(),q=F("p"),q.innerHTML=Fs,Ut=s(),U(v.$$.fragment),it=s(),S=F("p"),S.innerHTML=rs,et=s(),D=F("p"),D.textContent=js,nt=s(),Z=F("p"),Z.textContent=Ms,Kt=s(),U(O.$$.fragment),pt=s(),U(Y.$$.fragment),Ft=s(),L=F("p"),L.textContent=Rs,rt=s(),U(E.$$.fragment),jt=s(),_=F("p"),_.innerHTML=ws,Mt=s(),U($.$$.fragment),Rt=s(),U(AA.$$.fragment),wt=s(),aA=F("p"),aA.textContent=cs,ct=s(),U(tA.$$.fragment),yt=s(),lA=F("pre"),lA.textContent=ys,Jt=s(),U(sA.$$.fragment),ft=s(),oA=F("p"),oA.textContent=Js,Tt=s(),U(UA.$$.fragment),ut=s(),iA=F("pre"),iA.textContent=fs,mt=s(),U(eA.$$.fragment),Bt=s(),nA=F("p"),nA.textContent=Ts,bt=s(),U(KA.$$.fragment),dt=s(),pA=F("pre"),pA.textContent=us,Pt=s(),U(FA.$$.fragment),gt=s(),rA=F("pre"),rA.textContent=ms,Ct=s(),U(jA.$$.fragment),Vt=s(),MA=F("p"),MA.textContent=Bs,Xt=s(),U(RA.$$.fragment),xt=s(),U(wA.$$.fragment),Ht=s(),Ca=F("img"),Gt=s(),cA=F("p"),cA.textContent=ds,zt=s(),U(yA.$$.fragment),ht=s(),JA=F("p"),JA.innerHTML=Ps,It=s(),fA=F("p"),fA.textContent=gs,Wt=s(),J=F("img"),kt=s(),U(TA.$$.fragment),Nt=s(),U(uA.$$.fragment),Qt=s(),mA=F("p"),mA.innerHTML=Vs,qt=s(),U(BA.$$.fragment),vt=s(),U(bA.$$.fragment),St=s(),dA=F("p"),dA.textContent=Xs,Dt=s(),U(PA.$$.fragment),Zt=s(),U(gA.$$.fragment),Ot=s(),CA=F("p"),CA.textContent=xs,Yt=s(),U(VA.$$.fragment),Lt=s(),Va=F("img"),Et=s(),U(XA.$$.fragment),_t=s(),xA=F("p"),xA.textContent=Gs,$t=s(),U(HA.$$.fragment),Al=s(),U(GA.$$.fragment),al=s(),U(zA.$$.fragment),tl=s(),hA=F("p"),hA.textContent=zs,ll=s(),U(IA.$$.fragment),sl=s(),U(WA.$$.fragment),ol=s(),kA=F("p"),kA.innerHTML=hs,Ul=s(),U(NA.$$.fragment),il=s(),U(QA.$$.fragment),el=s(),U(qA.$$.fragment),nl=s(),U(vA.$$.fragment),Kl=s(),SA=F("p"),SA.textContent=Is,pl=s(),DA=F("p"),DA.innerHTML=Ws,Fl=s(),U(ZA.$$.fragment),rl=s(),U(OA.$$.fragment),jl=s(),U(YA.$$.fragment),Ml=s(),U(LA.$$.fragment),Rl=s(),U(EA.$$.fragment),wl=s(),U(_A.$$.fragment),cl=s(),$A=F("p"),$A.textContent=ks,yl=s(),U(Aa.$$.fragment),Jl=s(),U(aa.$$.fragment),fl=s(),ta=F("p"),ta.textContent=Ns,Tl=s(),U(la.$$.fragment),ul=s(),U(sa.$$.fragment),ml=s(),Xa=F("img"),Bl=s(),U(oa.$$.fragment),bl=s(),Ua=F("p"),Ua.textContent=qs,dl=s(),U(ia.$$.fragment),Pl=s(),U(ea.$$.fragment),gl=s(),f=F("img"),Cl=s(),na=F("p"),na.textContent=Ss,Vl=s(),Ka=F("p"),Ka.innerHTML=Ds,Xl=s(),U(pa.$$.fragment),xl=s(),U(Fa.$$.fragment),Hl=s(),ra=F("p"),ra.innerHTML=Zs,Gl=s(),U(ja.$$.fragment),zl=s(),U(Ma.$$.fragment),hl=s(),Ra=F("p"),Ra.innerHTML=Os,Il=s(),U(wa.$$.fragment),Wl=s(),U(ca.$$.fragment),kl=s(),ya=F("p"),ya.textContent=Ys,Nl=s(),Ja=F("p"),Ja.innerHTML=Ls,Ql=s(),U(fa.$$.fragment),ql=s(),U(Ta.$$.fragment),vl=s(),U(ua.$$.fragment),Sl=s(),U(ma.$$.fragment),Dl=s(),xa=F("img"),Zl=s(),U(Ba.$$.fragment),Ol=s(),ba=F("p"),ba.textContent=_s,Yl=s(),da=F("p"),da.textContent=$s,Ll=s(),U(Pa.$$.fragment),El=s(),Ga=F("p"),this.h()},l(A){const a=Uo("svelte-u9bgzb",document.head);c=r(a,"META",{name:!0,content:!0}),a.forEach(t),za=o(A),Ha=r(A,"P",{}),Ao(Ha).forEach(t),ha=o(A),i(T.$$.fragment,A),Ia=o(A),i(u.$$.fragment,A),Wa=o(A),m=r(A,"P",{"data-svelte-h":!0}),j(m)!=="svelte-1i2zwz9"&&(m.innerHTML=As),ka=o(A),B=r(A,"P",{"data-svelte-h":!0}),j(B)!=="svelte-e0ymej"&&(B.innerHTML=as),Na=o(A),b=r(A,"P",{"data-svelte-h":!0}),j(b)!=="svelte-bmmqde"&&(b.innerHTML=ts),Qa=o(A),d=r(A,"P",{"data-svelte-h":!0}),j(d)!=="svelte-mafiap"&&(d.textContent=ls),qa=o(A),P=r(A,"P",{"data-svelte-h":!0}),j(P)!=="svelte-1plkt6l"&&(P.innerHTML=ss),va=o(A),i(g.$$.fragment,A),Sa=o(A),C=r(A,"P",{"data-svelte-h":!0}),j(C)!=="svelte-1n2zq"&&(C.textContent=os),Da=o(A),i(V.$$.fragment,A),Za=o(A),i(X.$$.fragment,A),Oa=o(A),y=r(A,"IMG",{src:!0,alt:!0,width:!0}),Ya=o(A),x=r(A,"P",{"data-svelte-h":!0}),j(x)!=="svelte-1rj699s"&&(x.innerHTML=is),La=o(A),i(H.$$.fragment,A),Ea=o(A),G=r(A,"P",{"data-svelte-h":!0}),j(G)!=="svelte-1xq2oju"&&(G.textContent=es),_a=o(A),z=r(A,"UL",{"data-svelte-h":!0}),j(z)!=="svelte-vmvn1h"&&(z.innerHTML=ns),$a=o(A),h=r(A,"P",{"data-svelte-h":!0}),j(h)!=="svelte-kpjcts"&&(h.innerHTML=Ks),At=o(A),i(I.$$.fragment,A),at=o(A),i(W.$$.fragment,A),tt=o(A),k=r(A,"P",{"data-svelte-h":!0}),j(k)!=="svelte-1elgakt"&&(k.textContent=ps),lt=o(A),i(N.$$.fragment,A),st=o(A),i(Q.$$.fragment,A),ot=o(A),q=r(A,"P",{"data-svelte-h":!0}),j(q)!=="svelte-18yaj0m"&&(q.innerHTML=Fs),Ut=o(A),i(v.$$.fragment,A),it=o(A),S=r(A,"P",{"data-svelte-h":!0}),j(S)!=="svelte-3xczrd"&&(S.innerHTML=rs),et=o(A),D=r(A,"P",{"data-svelte-h":!0}),j(D)!=="svelte-1aro3n8"&&(D.textContent=js),nt=o(A),Z=r(A,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-alc1jz"&&(Z.textContent=Ms),Kt=o(A),i(O.$$.fragment,A),pt=o(A),i(Y.$$.fragment,A),Ft=o(A),L=r(A,"P",{"data-svelte-h":!0}),j(L)!=="svelte-tq3xmi"&&(L.textContent=Rs),rt=o(A),i(E.$$.fragment,A),jt=o(A),_=r(A,"P",{"data-svelte-h":!0}),j(_)!=="svelte-xv4p87"&&(_.innerHTML=ws),Mt=o(A),i($.$$.fragment,A),Rt=o(A),i(AA.$$.fragment,A),wt=o(A),aA=r(A,"P",{"data-svelte-h":!0}),j(aA)!=="svelte-23ym72"&&(aA.textContent=cs),ct=o(A),i(tA.$$.fragment,A),yt=o(A),lA=r(A,"PRE",{"data-svelte-h":!0}),j(lA)!=="svelte-iol3u7"&&(lA.textContent=ys),Jt=o(A),i(sA.$$.fragment,A),ft=o(A),oA=r(A,"P",{"data-svelte-h":!0}),j(oA)!=="svelte-ncu8hg"&&(oA.textContent=Js),Tt=o(A),i(UA.$$.fragment,A),ut=o(A),iA=r(A,"PRE",{"data-svelte-h":!0}),j(iA)!=="svelte-14awcgk"&&(iA.textContent=fs),mt=o(A),i(eA.$$.fragment,A),Bt=o(A),nA=r(A,"P",{"data-svelte-h":!0}),j(nA)!=="svelte-1pf0b6"&&(nA.textContent=Ts),bt=o(A),i(KA.$$.fragment,A),dt=o(A),pA=r(A,"PRE",{"data-svelte-h":!0}),j(pA)!=="svelte-18bl0b9"&&(pA.textContent=us),Pt=o(A),i(FA.$$.fragment,A),gt=o(A),rA=r(A,"PRE",{"data-svelte-h":!0}),j(rA)!=="svelte-1hw21wf"&&(rA.textContent=ms),Ct=o(A),i(jA.$$.fragment,A),Vt=o(A),MA=r(A,"P",{"data-svelte-h":!0}),j(MA)!=="svelte-d8u7sl"&&(MA.textContent=Bs),Xt=o(A),i(RA.$$.fragment,A),xt=o(A),i(wA.$$.fragment,A),Ht=o(A),Ca=r(A,"IMG",{src:!0}),Gt=o(A),cA=r(A,"P",{"data-svelte-h":!0}),j(cA)!=="svelte-m5j2f1"&&(cA.textContent=ds),zt=o(A),i(yA.$$.fragment,A),ht=o(A),JA=r(A,"P",{"data-svelte-h":!0}),j(JA)!=="svelte-1krarq"&&(JA.innerHTML=Ps),It=o(A),fA=r(A,"P",{"data-svelte-h":!0}),j(fA)!=="svelte-7k6eol"&&(fA.textContent=gs),Wt=o(A),J=r(A,"IMG",{src:!0,alt:!0,width:!0}),kt=o(A),i(TA.$$.fragment,A),Nt=o(A),i(uA.$$.fragment,A),Qt=o(A),mA=r(A,"P",{"data-svelte-h":!0}),j(mA)!=="svelte-1oh7fo2"&&(mA.innerHTML=Vs),qt=o(A),i(BA.$$.fragment,A),vt=o(A),i(bA.$$.fragment,A),St=o(A),dA=r(A,"P",{"data-svelte-h":!0}),j(dA)!=="svelte-otps2c"&&(dA.textContent=Xs),Dt=o(A),i(PA.$$.fragment,A),Zt=o(A),i(gA.$$.fragment,A),Ot=o(A),CA=r(A,"P",{"data-svelte-h":!0}),j(CA)!=="svelte-lp0r6w"&&(CA.textContent=xs),Yt=o(A),i(VA.$$.fragment,A),Lt=o(A),Va=r(A,"IMG",{src:!0}),Et=o(A),i(XA.$$.fragment,A),_t=o(A),xA=r(A,"P",{"data-svelte-h":!0}),j(xA)!=="svelte-1pyb1h2"&&(xA.textContent=Gs),$t=o(A),i(HA.$$.fragment,A),Al=o(A),i(GA.$$.fragment,A),al=o(A),i(zA.$$.fragment,A),tl=o(A),hA=r(A,"P",{"data-svelte-h":!0}),j(hA)!=="svelte-jvjrvx"&&(hA.textContent=zs),ll=o(A),i(IA.$$.fragment,A),sl=o(A),i(WA.$$.fragment,A),ol=o(A),kA=r(A,"P",{"data-svelte-h":!0}),j(kA)!=="svelte-c3j8c"&&(kA.innerHTML=hs),Ul=o(A),i(NA.$$.fragment,A),il=o(A),i(QA.$$.fragment,A),el=o(A),i(qA.$$.fragment,A),nl=o(A),i(vA.$$.fragment,A),Kl=o(A),SA=r(A,"P",{"data-svelte-h":!0}),j(SA)!=="svelte-1bboxwu"&&(SA.textContent=Is),pl=o(A),DA=r(A,"P",{"data-svelte-h":!0}),j(DA)!=="svelte-17mbuh1"&&(DA.innerHTML=Ws),Fl=o(A),i(ZA.$$.fragment,A),rl=o(A),i(OA.$$.fragment,A),jl=o(A),i(YA.$$.fragment,A),Ml=o(A),i(LA.$$.fragment,A),Rl=o(A),i(EA.$$.fragment,A),wl=o(A),i(_A.$$.fragment,A),cl=o(A),$A=r(A,"P",{"data-svelte-h":!0}),j($A)!=="svelte-zgrfcp"&&($A.textContent=ks),yl=o(A),i(Aa.$$.fragment,A),Jl=o(A),i(aa.$$.fragment,A),fl=o(A),ta=r(A,"P",{"data-svelte-h":!0}),j(ta)!=="svelte-9hkxlq"&&(ta.textContent=Ns),Tl=o(A),i(la.$$.fragment,A),ul=o(A),i(sa.$$.fragment,A),ml=o(A),Xa=r(A,"IMG",{src:!0}),Bl=o(A),i(oa.$$.fragment,A),bl=o(A),Ua=r(A,"P",{"data-svelte-h":!0}),j(Ua)!=="svelte-1gvfkqw"&&(Ua.textContent=qs),dl=o(A),i(ia.$$.fragment,A),Pl=o(A),i(ea.$$.fragment,A),gl=o(A),f=r(A,"IMG",{src:!0,alt:!0,width:!0}),Cl=o(A),na=r(A,"P",{"data-svelte-h":!0}),j(na)!=="svelte-16ut72j"&&(na.textContent=Ss),Vl=o(A),Ka=r(A,"P",{"data-svelte-h":!0}),j(Ka)!=="svelte-r7uhmi"&&(Ka.innerHTML=Ds),Xl=o(A),i(pa.$$.fragment,A),xl=o(A),i(Fa.$$.fragment,A),Hl=o(A),ra=r(A,"P",{"data-svelte-h":!0}),j(ra)!=="svelte-w12l5"&&(ra.innerHTML=Zs),Gl=o(A),i(ja.$$.fragment,A),zl=o(A),i(Ma.$$.fragment,A),hl=o(A),Ra=r(A,"P",{"data-svelte-h":!0}),j(Ra)!=="svelte-1608qf6"&&(Ra.innerHTML=Os),Il=o(A),i(wa.$$.fragment,A),Wl=o(A),i(ca.$$.fragment,A),kl=o(A),ya=r(A,"P",{"data-svelte-h":!0}),j(ya)!=="svelte-16tej72"&&(ya.textContent=Ys),Nl=o(A),Ja=r(A,"P",{"data-svelte-h":!0}),j(Ja)!=="svelte-1145wyl"&&(Ja.innerHTML=Ls),Ql=o(A),i(fa.$$.fragment,A),ql=o(A),i(Ta.$$.fragment,A),vl=o(A),i(ua.$$.fragment,A),Sl=o(A),i(ma.$$.fragment,A),Dl=o(A),xa=r(A,"IMG",{src:!0}),Zl=o(A),i(Ba.$$.fragment,A),Ol=o(A),ba=r(A,"P",{"data-svelte-h":!0}),j(ba)!=="svelte-1flsyep"&&(ba.textContent=_s),Yl=o(A),da=r(A,"P",{"data-svelte-h":!0}),j(da)!=="svelte-sr5bk8"&&(da.textContent=$s),Ll=o(A),i(Pa.$$.fragment,A),El=o(A),Ga=r(A,"P",{}),Ao(Ga).forEach(t),this.h()},h(){w(c,"name","hf:doc:metadata"),w(c,"content",po),ga(y.src,Us="https://fashionpedia.github.io/home/img/dataset/teaser.png")||w(y,"src",Us),w(y,"alt","Dataset sample"),w(y,"width","80%"),ga(Ca.src,bs="data:image/jpeg;base64,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")||w(Ca,"src",bs),ga(J.src,Cs="https://albumentations.ai/docs/images/introduction/dedicated_library/pixel_and_spatial_level_augmentations_for_object_detection.jpg")||w(J,"src",Cs),w(J,"alt","Albumentations image"),w(J,"width","90%"),ga(Va.src,Hs="data:image/jpeg;base64,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")||w(Va,"src",Hs),ga(Xa.src,Qs="data:image/jpeg;base64,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")||w(Xa,"src",Qs),ga(f.src,vs="https://huggingface.co/front/thumbnails/spaces.png")||w(f,"src",vs),w(f,"alt","HF Spaces logo"),w(f,"width","20%"),ga(xa.src,Es="data:image/jpeg;base64,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")||w(xa,"src",Es)},m(A,a){io(document.head,c),l(A,za,a),l(A,Ha,a),l(A,ha,a),e(T,A,a),l(A,Ia,a),e(u,A,a),l(A,Wa,a),l(A,m,a),l(A,ka,a),l(A,B,a),l(A,Na,a),l(A,b,a),l(A,Qa,a),l(A,d,a),l(A,qa,a),l(A,P,a),l(A,va,a),e(g,A,a),l(A,Sa,a),l(A,C,a),l(A,Da,a),e(V,A,a),l(A,Za,a),e(X,A,a),l(A,Oa,a),l(A,y,a),l(A,Ya,a),l(A,x,a),l(A,La,a),e(H,A,a),l(A,Ea,a),l(A,G,a),l(A,_a,a),l(A,z,a),l(A,$a,a),l(A,h,a),l(A,At,a),e(I,A,a),l(A,at,a),e(W,A,a),l(A,tt,a),l(A,k,a),l(A,lt,a),e(N,A,a),l(A,st,a),e(Q,A,a),l(A,ot,a),l(A,q,a),l(A,Ut,a),e(v,A,a),l(A,it,a),l(A,S,a),l(A,et,a),l(A,D,a),l(A,nt,a),l(A,Z,a),l(A,Kt,a),e(O,A,a),l(A,pt,a),e(Y,A,a),l(A,Ft,a),l(A,L,a),l(A,rt,a),e(E,A,a),l(A,jt,a),l(A,_,a),l(A,Mt,a),e($,A,a),l(A,Rt,a),e(AA,A,a),l(A,wt,a),l(A,aA,a),l(A,ct,a),e(tA,A,a),l(A,yt,a),l(A,lA,a),l(A,Jt,a),e(sA,A,a),l(A,ft,a),l(A,oA,a),l(A,Tt,a),e(UA,A,a),l(A,ut,a),l(A,iA,a),l(A,mt,a),e(eA,A,a),l(A,Bt,a),l(A,nA,a),l(A,bt,a),e(KA,A,a),l(A,dt,a),l(A,pA,a),l(A,Pt,a),e(FA,A,a),l(A,gt,a),l(A,rA,a),l(A,Ct,a),e(jA,A,a),l(A,Vt,a),l(A,MA,a),l(A,Xt,a),e(RA,A,a),l(A,xt,a),e(wA,A,a),l(A,Ht,a),l(A,Ca,a),l(A,Gt,a),l(A,cA,a),l(A,zt,a),e(yA,A,a),l(A,ht,a),l(A,JA,a),l(A,It,a),l(A,fA,a),l(A,Wt,a),l(A,J,a),l(A,kt,a),e(TA,A,a),l(A,Nt,a),e(uA,A,a),l(A,Qt,a),l(A,mA,a),l(A,qt,a),e(BA,A,a),l(A,vt,a),e(bA,A,a),l(A,St,a),l(A,dA,a),l(A,Dt,a),e(PA,A,a),l(A,Zt,a),e(gA,A,a),l(A,Ot,a),l(A,CA,a),l(A,Yt,a),e(VA,A,a),l(A,Lt,a),l(A,Va,a),l(A,Et,a),e(XA,A,a),l(A,_t,a),l(A,xA,a),l(A,$t,a),e(HA,A,a),l(A,Al,a),e(GA,A,a),l(A,al,a),e(zA,A,a),l(A,tl,a),l(A,hA,a),l(A,ll,a),e(IA,A,a),l(A,sl,a),e(WA,A,a),l(A,ol,a),l(A,kA,a),l(A,Ul,a),e(NA,A,a),l(A,il,a),e(QA,A,a),l(A,el,a),e(qA,A,a),l(A,nl,a),e(vA,A,a),l(A,Kl,a),l(A,SA,a),l(A,pl,a),l(A,DA,a),l(A,Fl,a),e(ZA,A,a),l(A,rl,a),e(OA,A,a),l(A,jl,a),e(YA,A,a),l(A,Ml,a),e(LA,A,a),l(A,Rl,a),e(EA,A,a),l(A,wl,a),e(_A,A,a),l(A,cl,a),l(A,$A,a),l(A,yl,a),e(Aa,A,a),l(A,Jl,a),e(aa,A,a),l(A,fl,a),l(A,ta,a),l(A,Tl,a),e(la,A,a),l(A,ul,a),e(sa,A,a),l(A,ml,a),l(A,Xa,a),l(A,Bl,a),e(oa,A,a),l(A,bl,a),l(A,Ua,a),l(A,dl,a),e(ia,A,a),l(A,Pl,a),e(ea,A,a),l(A,gl,a),l(A,f,a),l(A,Cl,a),l(A,na,a),l(A,Vl,a),l(A,Ka,a),l(A,Xl,a),e(pa,A,a),l(A,xl,a),e(Fa,A,a),l(A,Hl,a),l(A,ra,a),l(A,Gl,a),e(ja,A,a),l(A,zl,a),e(Ma,A,a),l(A,hl,a),l(A,Ra,a),l(A,Il,a),e(wa,A,a),l(A,Wl,a),e(ca,A,a),l(A,kl,a),l(A,ya,a),l(A,Nl,a),l(A,Ja,a),l(A,Ql,a),e(fa,A,a),l(A,ql,a),e(Ta,A,a),l(A,vl,a),e(ua,A,a),l(A,Sl,a),e(ma,A,a),l(A,Dl,a),l(A,xa,a),l(A,Zl,a),e(Ba,A,a),l(A,Ol,a),l(A,ba,a),l(A,Yl,a),l(A,da,a),l(A,Ll,a),e(Pa,A,a),l(A,El,a),l(A,Ga,a),_l=!0},p:to,i(A){_l||(n(T.$$.fragment,A),n(u.$$.fragment,A),n(g.$$.fragment,A),n(V.$$.fragment,A),n(X.$$.fragment,A),n(H.$$.fragment,A),n(I.$$.fragment,A),n(W.$$.fragment,A),n(N.$$.fragment,A),n(Q.$$.fragment,A),n(v.$$.fragment,A),n(O.$$.fragment,A),n(Y.$$.fragment,A),n(E.$$.fragment,A),n($.$$.fragment,A),n(AA.$$.fragment,A),n(tA.$$.fragment,A),n(sA.$$.fragment,A),n(UA.$$.fragment,A),n(eA.$$.fragment,A),n(KA.$$.fragment,A),n(FA.$$.fragment,A),n(jA.$$.fragment,A),n(RA.$$.fragment,A),n(wA.$$.fragment,A),n(yA.$$.fragment,A),n(TA.$$.fragment,A),n(uA.$$.fragment,A),n(BA.$$.fragment,A),n(bA.$$.fragment,A),n(PA.$$.fragment,A),n(gA.$$.fragment,A),n(VA.$$.fragment,A),n(XA.$$.fragment,A),n(HA.$$.fragment,A),n(GA.$$.fragment,A),n(zA.$$.fragment,A),n(IA.$$.fragment,A),n(WA.$$.fragment,A),n(NA.$$.fragment,A),n(QA.$$.fragment,A),n(qA.$$.fragment,A),n(vA.$$.fragment,A),n(ZA.$$.fragment,A),n(OA.$$.fragment,A),n(YA.$$.fragment,A),n(LA.$$.fragment,A),n(EA.$$.fragment,A),n(_A.$$.fragment,A),n(Aa.$$.fragment,A),n(aa.$$.fragment,A),n(la.$$.fragment,A),n(sa.$$.fragment,A),n(oa.$$.fragment,A),n(ia.$$.fragment,A),n(ea.$$.fragment,A),n(pa.$$.fragment,A),n(Fa.$$.fragment,A),n(ja.$$.fragment,A),n(Ma.$$.fragment,A),n(wa.$$.fragment,A),n(ca.$$.fragment,A),n(fa.$$.fragment,A),n(Ta.$$.fragment,A),n(ua.$$.fragment,A),n(ma.$$.fragment,A),n(Ba.$$.fragment,A),n(Pa.$$.fragment,A),_l=!0)},o(A){K(T.$$.fragment,A),K(u.$$.fragment,A),K(g.$$.fragment,A),K(V.$$.fragment,A),K(X.$$.fragment,A),K(H.$$.fragment,A),K(I.$$.fragment,A),K(W.$$.fragment,A),K(N.$$.fragment,A),K(Q.$$.fragment,A),K(v.$$.fragment,A),K(O.$$.fragment,A),K(Y.$$.fragment,A),K(E.$$.fragment,A),K($.$$.fragment,A),K(AA.$$.fragment,A),K(tA.$$.fragment,A),K(sA.$$.fragment,A),K(UA.$$.fragment,A),K(eA.$$.fragment,A),K(KA.$$.fragment,A),K(FA.$$.fragment,A),K(jA.$$.fragment,A),K(RA.$$.fragment,A),K(wA.$$.fragment,A),K(yA.$$.fragment,A),K(TA.$$.fragment,A),K(uA.$$.fragment,A),K(BA.$$.fragment,A),K(bA.$$.fragment,A),K(PA.$$.fragment,A),K(gA.$$.fragment,A),K(VA.$$.fragment,A),K(XA.$$.fragment,A),K(HA.$$.fragment,A),K(GA.$$.fragment,A),K(zA.$$.fragment,A),K(IA.$$.fragment,A),K(WA.$$.fragment,A),K(NA.$$.fragment,A),K(QA.$$.fragment,A),K(qA.$$.fragment,A),K(vA.$$.fragment,A),K(ZA.$$.fragment,A),K(OA.$$.fragment,A),K(YA.$$.fragment,A),K(LA.$$.fragment,A),K(EA.$$.fragment,A),K(_A.$$.fragment,A),K(Aa.$$.fragment,A),K(aa.$$.fragment,A),K(la.$$.fragment,A),K(sa.$$.fragment,A),K(oa.$$.fragment,A),K(ia.$$.fragment,A),K(ea.$$.fragment,A),K(pa.$$.fragment,A),K(Fa.$$.fragment,A),K(ja.$$.fragment,A),K(Ma.$$.fragment,A),K(wa.$$.fragment,A),K(ca.$$.fragment,A),K(fa.$$.fragment,A),K(Ta.$$.fragment,A),K(ua.$$.fragment,A),K(ma.$$.fragment,A),K(Ba.$$.fragment,A),K(Pa.$$.fragment,A),_l=!1},d(A){A&&(t(za),t(Ha),t(ha),t(Ia),t(Wa),t(m),t(ka),t(B),t(Na),t(b),t(Qa),t(d),t(qa),t(P),t(va),t(Sa),t(C),t(Da),t(Za),t(Oa),t(y),t(Ya),t(x),t(La),t(Ea),t(G),t(_a),t(z),t($a),t(h),t(At),t(at),t(tt),t(k),t(lt),t(st),t(ot),t(q),t(Ut),t(it),t(S),t(et),t(D),t(nt),t(Z),t(Kt),t(pt),t(Ft),t(L),t(rt),t(jt),t(_),t(Mt),t(Rt),t(wt),t(aA),t(ct),t(yt),t(lA),t(Jt),t(ft),t(oA),t(Tt),t(ut),t(iA),t(mt),t(Bt),t(nA),t(bt),t(dt),t(pA),t(Pt),t(gt),t(rA),t(Ct),t(Vt),t(MA),t(Xt),t(xt),t(Ht),t(Ca),t(Gt),t(cA),t(zt),t(ht),t(JA),t(It),t(fA),t(Wt),t(J),t(kt),t(Nt),t(Qt),t(mA),t(qt),t(vt),t(St),t(dA),t(Dt),t(Zt),t(Ot),t(CA),t(Yt),t(Lt),t(Va),t(Et),t(_t),t(xA),t($t),t(Al),t(al),t(tl),t(hA),t(ll),t(sl),t(ol),t(kA),t(Ul),t(il),t(el),t(nl),t(Kl),t(SA),t(pl),t(DA),t(Fl),t(rl),t(jl),t(Ml),t(Rl),t(wl),t(cl),t($A),t(yl),t(Jl),t(fl),t(ta),t(Tl),t(ul),t(ml),t(Xa),t(Bl),t(bl),t(Ua),t(dl),t(Pl),t(gl),t(f),t(Cl),t(na),t(Vl),t(Ka),t(Xl),t(xl),t(Hl),t(ra),t(Gl),t(zl),t(hl),t(Ra),t(Il),t(Wl),t(kl),t(ya),t(Nl),t(Ja),t(Ql),t(ql),t(vl),t(Sl),t(Dl),t(xa),t(Zl),t(Ol),t(ba),t(Yl),t(da),t(Ll),t(El),t(Ga)),t(c),p(T,A),p(u,A),p(g,A),p(V,A),p(X,A),p(H,A),p(I,A),p(W,A),p(N,A),p(Q,A),p(v,A),p(O,A),p(Y,A),p(E,A),p($,A),p(AA,A),p(tA,A),p(sA,A),p(UA,A),p(eA,A),p(KA,A),p(FA,A),p(jA,A),p(RA,A),p(wA,A),p(yA,A),p(TA,A),p(uA,A),p(BA,A),p(bA,A),p(PA,A),p(gA,A),p(VA,A),p(XA,A),p(HA,A),p(GA,A),p(zA,A),p(IA,A),p(WA,A),p(NA,A),p(QA,A),p(qA,A),p(vA,A),p(ZA,A),p(OA,A),p(YA,A),p(LA,A),p(EA,A),p(_A,A),p(Aa,A),p(aa,A),p(la,A),p(sa,A),p(oa,A),p(ia,A),p(ea,A),p(pa,A),p(Fa,A),p(ja,A),p(Ma,A),p(wa,A),p(ca,A),p(fa,A),p(Ta,A),p(ua,A),p(ma,A),p(Ba,A),p(Pa,A)}}}const po='{"title":"Fine-Tuning Object Detection Model on a Custom Dataset 🖼, Deployment in Spaces, and Gradio API Integration","local":"fine-tuning-object-detection-model-on-a-custom-dataset--deployment-in-spaces-and-gradio-api-integration","sections":[{"title":"1. Install Dependencies","local":"1-install-dependencies","sections":[],"depth":2},{"title":"2. Load Dataset 📁","local":"2-load-dataset-","sections":[],"depth":2},{"title":"3. Get Splits of the Dataset for Training and Testing ➗","local":"3-get-splits-of-the-dataset-for-training-and-testing-","sections":[],"depth":2},{"title":"4. Visualize One Example from the Dataset with Its Objects 👀","local":"4-visualize-one-example-from-the-dataset-with-its-objects-","sections":[{"title":"Generate id2label and label2id","local":"generate-id2label-and-label2id","sections":[],"depth":3},{"title":"Let’s Draw One Image! 🎨","local":"lets-draw-one-image-","sections":[],"depth":3},{"title":"Let’s Visualize Some More Images 📸","local":"lets-visualize-some-more-images-","sections":[],"depth":3}],"depth":2},{"title":"5. Filter Invalid Bboxes ❌","local":"5-filter-invalid-bboxes-","sections":[],"depth":2},{"title":"6. Visualize Class Occurrences 👀","local":"6-visualize-class-occurrences-","sections":[],"depth":2},{"title":"7. Add Data Augmentation to the Dataset","local":"7-add-data-augmentation-to-the-dataset","sections":[],"depth":2},{"title":"8. Initialize Image Processor from Model Checkpoint 🎆","local":"8-initialize-image-processor-from-model-checkpoint-","sections":[{"title":"Adding Methods to Process the Dataset","local":"adding-methods-to-process-the-dataset","sections":[],"depth":3}],"depth":2},{"title":"9. Plot Augmented Examples 🎆","local":"9-plot-augmented-examples-","sections":[],"depth":2},{"title":"10. Initialize Model from Checkpoint","local":"10-initialize-model-from-checkpoint","sections":[],"depth":2},{"title":"10. Connect to HF Hub to Upload Fine-Tuned Model 🔌","local":"10-connect-to-hf-hub-to-upload-fine-tuned-model-","sections":[],"depth":2},{"title":"11. Set Training Arguments, Connect to W&B, and Train!","local":"11-set-training-arguments-connect-to-wb-and-train","sections":[{"title":"Connect to W&B to Track Training","local":"connect-to-wb-to-track-training","sections":[],"depth":3},{"title":"Let’s Train the Model! 🚀","local":"lets-train-the-model-","sections":[],"depth":3}],"depth":2},{"title":"12. Test How the Model Behaves on a Test Image 📝","local":"12-test-how-the-model-behaves-on-a-test-image-","sections":[{"title":"Now, Let’s Show the Results","local":"now-lets-show-the-results","sections":[],"depth":3}],"depth":2},{"title":"13. Evaluation of the Model on the Test Set 📝","local":"13-evaluation-of-the-model-on-the-test-set-","sections":[],"depth":2},{"title":"14. Deploy the Model in a HF Space","local":"14-deploy-the-model-in-a-hf-space","sections":[{"title":"Create the Application with the Following Code","local":"create-the-application-with-the-following-code","sections":[],"depth":3},{"title":"Remember to Set Up requirements.txt","local":"remember-to-set-up-requirementstxt","sections":[],"depth":3}],"depth":2},{"title":"15. Access the Space as an API 🧑‍💻️","local":"15-access-the-space-as-an-api-","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Fo($l){return lo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wo extends so{constructor(c){super(),oo(this,c,Fo,Ko,ao,{})}}export{wo as component};
