import{s as yi,f as wi,n as fi,o as Ci}from"../chunks/scheduler.65852ee5.js";import{S as Ri,i as di,g as t,s as e,r as n,A as Ti,h as a,f as s,c as A,j as ji,u as K,x as F,k as Js,y as gi,a as i,v as U,d as p,t as M,w as r}from"../chunks/index.65a1b999.js";import{D as hi,C as w}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as j,E as mi}from"../chunks/getInferenceSnippets.aa1f4ff5.js";function Ji(cs){let y,Dl,Pl,Ll,f,Yl,C,Ol,R,us='<em>Authored by: <a href="https://huggingface.co/elischwartz" rel="nofollow">Eli Schwartz</a></em>',_l,d,bs='Adapted from <a href="https://github.com/sergiopaniego" rel="nofollow">Sergio Paniego</a>’s <a href="https://huggingface.co/learn/cookbook/en/fine_tuning_smol_vlm_sft_trl" rel="nofollow">Notebook</a>',$l,T,Is=`This recipe will enable you to fine-tune <a href="https://huggingface.co/ibm-granite/granite-vision-3.1-2b-preview" rel="nofollow">IBM’s Granite Vision 3.1 2B Model</a>.
It is a lightweight yet capable model trained by fine-tuning a <a href="https://huggingface.co/ibm-granite/granite-3.1-2b-instruct" rel="nofollow">Granite language model</a> with both image and text modalities.
We will be using the Hugging Face ecosystem, leveraging the powerful <a href="https://huggingface.co/docs/trl/index" rel="nofollow">Transformer Reinforcement Learning library (TRL)</a>. This step-by-step guide will enable you to Granite Vision for your specific tasks, even on consumer GPUs.`,lo,g,oo,h,Bs='In this notebook, we will fine-tune and evaluate the <strong><a href="https://huggingface.co/ibm-granite/granite-vision-3.1-2b-preview" rel="nofollow">Granite Vision</a></strong> model using the <strong><a href="https://huggingface.co/datasets/euclid-multimodal/Geoperception" rel="nofollow">Geometric Perception</a></strong> dataset, containing tasks that the model wasn’t intially trained for. Granite Vision is a highly performant and memory-efficient model, making it an ideal for fine tuning for new tasks. The <strong>Geometric Perception</strong> provides images of various geometric diagrams, compiled from high-school textbooks, paired with question-answer pairs.',so,m,Qs="This notebook is tested using a A100 GPU.",io,J,eo,c,vs="Let’s start by installing the essential libraries we’ll need for fine-tuning! 🚀",Ao,u,to,b,ao,I,Xs=`FlashAttention is not installed
`,no,B,Ko,Q,Vs='We’ll load the <strong><a href="https://huggingface.co/datasets/euclid-multimodal/Geoperception" rel="nofollow">Geometric Perception</a></strong> dataset, which provides images of various geometric diagrams, compiled from popular high-school textbooks, paired with question-answer pairs.',Uo,v,Ws="We’ll use the original system prompt used during the model training.",po,X,Mo,V,Zs="For educational purposes, we’ll only train and evaluate on the Line Length Comaprison task, specified in the “predicate” field of the dataset.",ro,W,Fo,Z,Ns="Let’s take a look at the dataset structure. It includes an image, a question, an answer, and “predicate” which we used to filter the dataset.",wo,N,jo,H,Hs="We’ll format the dataset into a chatbot structure, with the system message, image, user query, and answer for each interaction.",yo,G,Gs='💡For more tips on using this model for inference, check out the <a href="https://huggingface.co/ibm-granite/granite-vision-3.1-2b-preview" rel="nofollow">Model Card</a>.',fo,x,Co,k,xs="Now, let’s format the data using the chatbot structure. This will set up the interactions for the model.",Ro,E,To,z,go,S,ho,P,ks='Now that we’ve loaded the dataset, it’s time to load the <a href="https://huggingface.co/ibm-granite/granite-vision-3.1-2b-preview" rel="nofollow">IBM’s Granite Vision Model</a>, a 2B parameter Vision Language Model (VLM) built on that offers state-of-the-art (SOTA) performance while being efficient in terms of memory usage.',mo,q,Es='For a broader comparison of state-of-the-art VLMs, explore the <a href="https://huggingface.co/spaces/WildVision/vision-arena" rel="nofollow">WildVision Arena</a> and the <a href="https://huggingface.co/spaces/opencompass/open_vlm_leaderboard" rel="nofollow">OpenVLM Leaderboard</a>, where you can find the best-performing models across various benchmarks.',Jo,D,co,L,zs="Next, we’ll load the model and the tokenizer to prepare for inference.",uo,Y,bo,O,Ss="To evaluate the model’s performance, we’ll use a sample from the dataset. First, let’s inspect the internal structure of this sample to understand how the data is organized.",Io,_,Bo,$,Ps="Now, let’s take a look at the image corresponding to the sample. Can you answer the query based on the visual information?",Qo,ll,vo,zl,qs,Xo,ol,Ds="Let’s create a method that takes the model, processor, and sample as inputs to generate the model’s answer. This will allow us to streamline the inference process and easily evaluate the VLM’s performance.",Vo,sl,Wo,il,Zo,el,Ls="It seems like the model is unable to comapre the lines’ lengths which are not explicitly specified. To improve its performance, we can fine-tune the model with more relevant data to ensure it better understands the context and provides more accurate responses.",No,Al,Ys="<strong>Remove Model and Clean GPU</strong>",Ho,tl,Os="Before we proceed with training the model in the next section, let’s clear the current variables and clean the GPU to free up resources.",Go,al,xo,nl,_s=`GPU allocated memory: 0.01 GB
GPU reserved memory: 0.02 GB
`,ko,Kl,Eo,Ul,zo,pl,$s='Next, we’ll load the quantized model using <a href="https://huggingface.co/docs/bitsandbytes/main/en/index" rel="nofollow">bitsandbytes</a>. If you want to learn more about quantization, check out <a href="https://huggingface.co/blog/merve/quantization" rel="nofollow">this blog post</a> or <a href="https://www.maartengrootendorst.com/blog/quantization/" rel="nofollow">this one</a>.',So,Ml,Po,rl,qo,Fl,li='Next, we’ll configure <a href="https://github.com/artidoro/qlora" rel="nofollow">QLoRA</a> for our training setup. QLoRA allows efficient fine-tuning of large models by reducing the memory footprint. Unlike traditional LoRA, which uses low-rank approximation, QLoRA further quantizes the LoRA adapter weights, leading to even lower memory usage and faster training.',Do,wl,oi="To boost efficiency, we can also leverage a <strong>paged optimizer</strong> or <strong>8-bit optimizer</strong> during QLoRA implementation. This approach enhances memory efficiency and speeds up computations, making it ideal for optimizing our model without sacrificing performance.",Lo,jl,Yo,yl,si='We will use Supervised Fine-Tuning (SFT) to improve our model’s performance on the specific task. To achieve this, we’ll define the training arguments with the <a href="https://huggingface.co/docs/trl/sft_trainer" rel="nofollow">SFTConfig</a> class from the <a href="https://huggingface.co/docs/trl/index" rel="nofollow">TRL library</a>. SFT leverages labeled data to help the model generate more accurate responses, adapting it to the task. This approach enhances the model’s ability to understand and respond to visual queries more effectively.',Oo,fl,_o,Cl,$o,Rl,ii="To ensure that the data is correctly structured for the model during training, we need to define a collator function. This function will handle the formatting and batching of our dataset inputs, ensuring the data is properly aligned for training.",ls,dl,ei='👉 For more details, check out the official <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/sft_vlm_smol_vlm.py" rel="nofollow">TRL example scripts</a>.',os,Tl,ss,gl,Ai='Now, we will define the <a href="https://huggingface.co/docs/trl/sft_trainer" rel="nofollow">SFTTrainer</a>, which is a wrapper around the <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">transformers.Trainer</a> class and inherits its attributes and methods. This class simplifies the fine-tuning process by properly initializing the <a href="https://huggingface.co/docs/peft/v0.6.0/package_reference/peft_model" rel="nofollow">PeftModel</a> when a <a href="https://huggingface.co/docs/peft/v0.6.0/en/package_reference/config#peft.PeftConfig" rel="nofollow">PeftConfig</a> object is provided. By using <code>SFTTrainer</code>, we can efficiently manage the training workflow and ensure a smooth fine-tuning experience for our Vision Language Model.',is,hl,es,ml,ti="Time to Train the Model! 🎉",As,Jl,ts,cl,ai="Let’s save the results 💾",as,ul,ns,bl,Ks,Il,ni="Now that our Vision Language Model (VLM) is fine-tuned, it’s time to evaluate its performance! In this section, we’ll test the model using examples from the ChartQA dataset to assess how accurately it answers questions based on chart images. Let’s dive into the results and see how well it performs! 🚀",Us,Bl,Ki="Let’s clean up the GPU memory to ensure optimal performance 🧹",ps,Ql,Ms,vl,Ui=`GPU allocated memory: 0.02 GB
GPU reserved memory: 0.19 GB
`,rs,Xl,pi="We will reload the base model using the same pipeline as before.",Fs,Vl,ws,Wl,Mi="We will merge the LORA adapters in case we are using them.",js,Zl,ys,Nl,ri="Let’s evaluate the model on an unseen sample.",fs,Hl,Cs,Gl,Rs,Sl,Fi,ds,xl,Ts,kl,gs,El,hs,ql,ms;return f=new hi({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/fine_tuning_granite_vision_sft_trl.ipynb"}]}}),C=new j({props:{title:"Fine-tuning Granite Vision 3.1 2B with TRL",local:"fine-tuning-granite-vision-31-2b-with-trl",headingTag:"h1"}}),g=new j({props:{title:"🌟 Model & Dataset Overview",local:"-model--dataset-overview",headingTag:"h3"}}),J=new j({props:{title:"1. Install Dependencies",local:"1-install-dependencies",headingTag:"h2"}}),u=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzLmdpdCUwQSFwaXAlMjBpbnN0YWxsJTIwJTIwLVUlMjAtcSUyMHRybCUyMGRhdGFzZXRzJTIwYml0c2FuZGJ5dGVzJTIwcGVmdCUyMGFjY2VsZXJhdGUlMEElMjMlMjBUZXN0ZWQlMjB3aXRoJTIwdHJhbnNmb3JtZXJzJTNEJTNENC40OS4wLmRldjAlMkMlMjB0cmwlM0QlM0QwLjE0LjAlMkMlMjBkYXRhc2V0cyUzRCUzRDMuMi4wJTJDJTIwYml0c2FuZGJ5dGVzJTNEJTNEMC40NS4yJTJDJTIwcGVmdCUzRCUzRDAuMTQuMCUyQyUyMGFjY2VsZXJhdGUlM0QlM0QxLjMuMA==",highlighted:`!pip install -q git+https://github.com/huggingface/transformers.git
!pip install  -U -q trl datasets bitsandbytes peft accelerate
<span class="hljs-comment"># Tested with transformers==4.49.0.dev0, trl==0.14.0, datasets==3.2.0, bitsandbytes==0.45.2, peft==0.14.0, accelerate==1.3.0</span>`,wrap:!1}}),b=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGZsYXNoLWF0dG4lMjAtLW5vLWJ1aWxkLWlzb2xhdGlvbiUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMGZsYXNoX2F0dG4lMEElMjAlMjAlMjAlMjBwcmludCglMjJGbGFzaEF0dGVudGlvbiUyMGlzJTIwaW5zdGFsbGVkJTIyKSUwQSUyMCUyMCUyMCUyMFVTRV9GTEFTSF9BVFRFTlRJT04lMjAlM0QlMjBUcnVlJTBBZXhjZXB0JTIwSW1wb3J0RXJyb3IlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJGbGFzaEF0dGVudGlvbiUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIyKSUwQSUyMCUyMCUyMCUyMFVTRV9GTEFTSF9BVFRFTlRJT04lMjAlM0QlMjBGYWxzZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>!pip install -q flash-attn --no-build-isolation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">import</span> flash_attn
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;FlashAttention is installed&quot;</span>)
<span class="hljs-meta">... </span>    USE_FLASH_ATTENTION = <span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">except</span> ImportError:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;FlashAttention is not installed&quot;</span>)
<span class="hljs-meta">... </span>    USE_FLASH_ATTENTION = <span class="hljs-literal">False</span>`,wrap:!1}}),B=new j({props:{title:"2. Load Dataset 📁",local:"2-load-dataset-",headingTag:"h2"}}),X=new w({props:{code:"c3lzdGVtX21lc3NhZ2UlMjAlM0QlMjAlMjJBJTIwY2hhdCUyMGJldHdlZW4lMjBhJTIwY3VyaW91cyUyMHVzZXIlMjBhbmQlMjBhbiUyMGFydGlmaWNpYWwlMjBpbnRlbGxpZ2VuY2UlMjBhc3Npc3RhbnQuJTIwVGhlJTIwYXNzaXN0YW50JTIwZ2l2ZXMlMjBoZWxwZnVsJTJDJTIwZGV0YWlsZWQlMkMlMjBhbmQlMjBwb2xpdGUlMjBhbnN3ZXJzJTIwdG8lMjB0aGUlMjB1c2VyJ3MlMjBxdWVzdGlvbnMuJTIy",highlighted:'system_message = <span class="hljs-string">&quot;A chat between a curious user and an artificial intelligence assistant. The assistant gives helpful, detailed, and polite answers to the user&#x27;s questions.&quot;</span>',wrap:!1}}),W=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldF9pZCUyMCUzRCUyMCUyMmV1Y2xpZC1tdWx0aW1vZGFsJTJGR2VvcGVyY2VwdGlvbiUyMiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9pZCklMEFkYXRhc2V0X0xpbmVDb21wYXJpc29uJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELmZpbHRlcihsYW1iZGElMjB4JTNBJTIweCU1QiUyMnByZWRpY2F0ZSUyMiU1RCUyMCUzRCUzRCUyMCUyMkxpbmVDb21wYXJpc29uJTIyKSUwQXRyYWluX3Rlc3QlMjAlM0QlMjBkYXRhc2V0X0xpbmVDb21wYXJpc29uLnRyYWluX3Rlc3Rfc3BsaXQodGVzdF9zaXplJTNEMC41JTJDJTIwc2VlZCUzRDQyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset_id = <span class="hljs-string">&quot;euclid-multimodal/Geoperception&quot;</span>
dataset = load_dataset(dataset_id)
dataset_LineComparison = dataset[<span class="hljs-string">&quot;train&quot;</span>].<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;predicate&quot;</span>] == <span class="hljs-string">&quot;LineComparison&quot;</span>)
train_test = dataset_LineComparison.train_test_split(test_size=<span class="hljs-number">0.5</span>, seed=<span class="hljs-number">42</span>)`,wrap:!1}}),N=new w({props:{code:"dHJhaW5fdGVzdA==",highlighted:"train_test",wrap:!1}}),x=new w({props:{code:"ZGVmJTIwZm9ybWF0X2RhdGEoc2FtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwc3lzdGVtX21lc3NhZ2UlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbWFnZSUyMiUzQSUyMHNhbXBsZSU1QiUyMmltYWdlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0JTIyJTNBJTIwc2FtcGxlJTVCJTIycXVlc3Rpb24lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMHNhbXBsZSU1QiUyMmFuc3dlciUyMiU1RCU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_data</span>(<span class="hljs-params">sample</span>):
    <span class="hljs-keyword">return</span> [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: system_message}],
        },
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>,
                    <span class="hljs-string">&quot;image&quot;</span>: sample[<span class="hljs-string">&quot;image&quot;</span>],
                },
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                    <span class="hljs-string">&quot;text&quot;</span>: sample[<span class="hljs-string">&quot;question&quot;</span>],
                },
            ],
        },
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: sample[<span class="hljs-string">&quot;answer&quot;</span>]}],
        },
    ]`,wrap:!1}}),E=new w({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMCU1QmZvcm1hdF9kYXRhKHgpJTIwZm9yJTIweCUyMGluJTIwdHJhaW5fdGVzdCU1QiUyMnRyYWluJTIyJTVEJTVEJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwJTVCZm9ybWF0X2RhdGEoeCklMjBmb3IlMjB4JTIwaW4lMjB0cmFpbl90ZXN0JTVCJTIydGVzdCUyMiU1RCU1RA==",highlighted:`train_dataset = [format_data(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> train_test[<span class="hljs-string">&quot;train&quot;</span>]]
test_dataset = [format_data(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> train_test[<span class="hljs-string">&quot;test&quot;</span>]]`,wrap:!1}}),z=new w({props:{code:"dHJhaW5fZGF0YXNldCU1QjIwMCU1RA==",highlighted:'train_dataset[<span class="hljs-number">200</span>]',wrap:!1}}),S=new j({props:{title:"3. Load Model and Check Performance! 🤔",local:"3-load-model-and-check-performance-",headingTag:"h2"}}),D=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yVmlzaW9uMlNlcSUyQyUyMEF1dG9Qcm9jZXNzb3IlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmlibS1ncmFuaXRlJTJGZ3Jhbml0ZS12aXNpb24tMy4xLTJiLXByZXZpZXclMjI=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForVision2Seq, AutoProcessor

model_id = <span class="hljs-string">&quot;ibm-granite/granite-vision-3.1-2b-preview&quot;</span>`,wrap:!1}}),Y=new w({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMF9hdHRuX2ltcGxlbWVudGF0aW9uJTNEJTIyZmxhc2hfYXR0ZW50aW9uXzIlMjIlMjBpZiUyMFVTRV9GTEFTSF9BVFRFTlRJT04lMjBlbHNlJTIwTm9uZSUyQyUwQSklMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCk=",highlighted:`model = AutoModelForVision2Seq.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
    _attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span> <span class="hljs-keyword">if</span> USE_FLASH_ATTENTION <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
)

processor = AutoProcessor.from_pretrained(model_id)`,wrap:!1}}),_=new w({props:{code:"dGVzdF9pZHglMjAlM0QlMjAyMCUwQXNhbXBsZSUyMCUzRCUyMHRlc3RfZGF0YXNldCU1QnRlc3RfaWR4JTVEJTBBc2FtcGxl",highlighted:`test_idx = <span class="hljs-number">20</span>
sample = test_dataset[test_idx]
sample`,wrap:!1}}),ll=new w({props:{code:"c2FtcGxlJTVCMSU1RCU1QiUyMmNvbnRlbnQlMjIlNUQlNUIwJTVEJTVCJTIyaW1hZ2UlMjIlNUQ=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>sample[<span class="hljs-number">1</span>][<span class="hljs-string">&quot;content&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),sl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_text_from_sample</span>(<span class="hljs-params">model, processor, sample, max_new_tokens=<span class="hljs-number">100</span>, device=<span class="hljs-string">&quot;cuda&quot;</span></span>):
    <span class="hljs-comment"># Prepare the text input by applying the chat template</span>
    text_input = processor.apply_chat_template(
        sample[:<span class="hljs-number">2</span>], add_generation_prompt=<span class="hljs-literal">True</span>  <span class="hljs-comment"># Use the sample without the assistant response</span>
    )

    image_inputs = []
    image = sample[<span class="hljs-number">1</span>][<span class="hljs-string">&quot;content&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]
    <span class="hljs-keyword">if</span> image.mode != <span class="hljs-string">&quot;RGB&quot;</span>:
        image = image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)
    image_inputs.append([image])

    <span class="hljs-comment"># Prepare the inputs for the model</span>
    model_inputs = processor(
        <span class="hljs-comment"># text=[text_input],</span>
        text=text_input,
        images=image_inputs,
        return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    ).to(
        device
    )  <span class="hljs-comment"># Move inputs to the specified device</span>

    <span class="hljs-comment"># Generate text with the model</span>
    generated_ids = model.generate(**model_inputs, max_new_tokens=max_new_tokens)

    <span class="hljs-comment"># Trim the generated ids to remove the input ids</span>
    trimmed_generated_ids = [out_ids[<span class="hljs-built_in">len</span>(in_ids) :] <span class="hljs-keyword">for</span> in_ids, out_ids <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(model_inputs.input_ids, generated_ids)]

    <span class="hljs-comment"># Decode the output text</span>
    output_text = processor.batch_decode(
        trimmed_generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>
    )

    <span class="hljs-keyword">return</span> output_text[<span class="hljs-number">0</span>]  <span class="hljs-comment"># Return the first decoded output text</span>`,wrap:!1}}),il=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwZ2VuZXJhdGVfdGV4dF9mcm9tX3NhbXBsZShtb2RlbCUyQyUyMHByb2Nlc3NvciUyQyUyMHNhbXBsZSklMEFvdXRwdXQ=",highlighted:`output = generate_text_from_sample(model, processor, sample)
output`,wrap:!1}}),al=new w({props:{code:"aW1wb3J0JTIwZ2MlMEFpbXBvcnQlMjB0aW1lJTBBJTBBJTBBZGVmJTIwY2xlYXJfbWVtb3J5KCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBEZWxldGUlMjB2YXJpYWJsZXMlMjBpZiUyMHRoZXklMjBleGlzdCUyMGluJTIwdGhlJTIwY3VycmVudCUyMGdsb2JhbCUyMHNjb3BlJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJpbnB1dHMlMjIlMjBpbiUyMGdsb2JhbHMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlbCUyMGdsb2JhbHMoKSU1QiUyMmlucHV0cyUyMiU1RCUwQSUyMCUyMCUyMCUyMGlmJTIwJTIybW9kZWwlMjIlMjBpbiUyMGdsb2JhbHMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlbCUyMGdsb2JhbHMoKSU1QiUyMm1vZGVsJTIyJTVEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJwcm9jZXNzb3IlMjIlMjBpbiUyMGdsb2JhbHMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlbCUyMGdsb2JhbHMoKSU1QiUyMnByb2Nlc3NvciUyMiU1RCUwQSUyMCUyMCUyMCUyMGlmJTIwJTIydHJhaW5lciUyMiUyMGluJTIwZ2xvYmFscygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVsJTIwZ2xvYmFscygpJTVCJTIydHJhaW5lciUyMiU1RCUwQSUyMCUyMCUyMCUyMGlmJTIwJTIycGVmdF9tb2RlbCUyMiUyMGluJTIwZ2xvYmFscygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVsJTIwZ2xvYmFscygpJTVCJTIycGVmdF9tb2RlbCUyMiU1RCUwQSUyMCUyMCUyMCUyMGlmJTIwJTIyYm5iX2NvbmZpZyUyMiUyMGluJTIwZ2xvYmFscygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVsJTIwZ2xvYmFscygpJTVCJTIyYm5iX2NvbmZpZyUyMiU1RCUwQSUyMCUyMCUyMCUyMHRpbWUuc2xlZXAoMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBHYXJiYWdlJTIwY29sbGVjdGlvbiUyMGFuZCUyMGNsZWFyaW5nJTIwQ1VEQSUyMG1lbW9yeSUwQSUyMCUyMCUyMCUyMGdjLmNvbGxlY3QoKSUwQSUyMCUyMCUyMCUyMHRpbWUuc2xlZXAoMiklMEElMjAlMjAlMjAlMjB0b3JjaC5jdWRhLmVtcHR5X2NhY2hlKCklMEElMjAlMjAlMjAlMjB0b3JjaC5jdWRhLnN5bmNocm9uaXplKCklMEElMjAlMjAlMjAlMjB0aW1lLnNsZWVwKDIpJTBBJTIwJTIwJTIwJTIwZ2MuY29sbGVjdCgpJTBBJTIwJTIwJTIwJTIwdGltZS5zbGVlcCgyKSUwQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJHUFUlMjBhbGxvY2F0ZWQlMjBtZW1vcnklM0ElMjAlN0J0b3JjaC5jdWRhLm1lbW9yeV9hbGxvY2F0ZWQoKSUyMCUyRiUyMDEwMjQqKjMlM0EuMmYlN0QlMjBHQiUyMiklMEElMjAlMjAlMjAlMjBwcmludChmJTIyR1BVJTIwcmVzZXJ2ZWQlMjBtZW1vcnklM0ElMjAlN0J0b3JjaC5jdWRhLm1lbW9yeV9yZXNlcnZlZCgpJTIwJTJGJTIwMTAyNCoqMyUzQS4yZiU3RCUyMEdCJTIyKSUwQSUwQSUwQWNsZWFyX21lbW9yeSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> gc
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">clear_memory</span>():
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Delete variables if they exist in the current global scope</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;inputs&quot;</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">globals</span>():
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> <span class="hljs-built_in">globals</span>()[<span class="hljs-string">&quot;inputs&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;model&quot;</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">globals</span>():
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> <span class="hljs-built_in">globals</span>()[<span class="hljs-string">&quot;model&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;processor&quot;</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">globals</span>():
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> <span class="hljs-built_in">globals</span>()[<span class="hljs-string">&quot;processor&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;trainer&quot;</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">globals</span>():
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> <span class="hljs-built_in">globals</span>()[<span class="hljs-string">&quot;trainer&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;peft_model&quot;</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">globals</span>():
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> <span class="hljs-built_in">globals</span>()[<span class="hljs-string">&quot;peft_model&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;bnb_config&quot;</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">globals</span>():
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> <span class="hljs-built_in">globals</span>()[<span class="hljs-string">&quot;bnb_config&quot;</span>]
<span class="hljs-meta">... </span>    time.sleep(<span class="hljs-number">2</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Garbage collection and clearing CUDA memory</span>
<span class="hljs-meta">... </span>    gc.collect()
<span class="hljs-meta">... </span>    time.sleep(<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    torch.cuda.empty_cache()
<span class="hljs-meta">... </span>    torch.cuda.synchronize()
<span class="hljs-meta">... </span>    time.sleep(<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    gc.collect()
<span class="hljs-meta">... </span>    time.sleep(<span class="hljs-number">2</span>)

<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;GPU allocated memory: <span class="hljs-subst">{torch.cuda.memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;GPU reserved memory: <span class="hljs-subst">{torch.cuda.memory_reserved() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>clear_memory()`,wrap:!1}}),Kl=new j({props:{title:"4. Fine-Tune the Model using TRL",local:"4-fine-tune-the-model-using-trl",headingTag:"h2"}}),Ul=new j({props:{title:"4.1 Load the Quantized Model for Training ⚙️",local:"41-load-the-quantized-model-for-training-",headingTag:"h3"}}),Ml=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQVVTRV9RTE9SQSUyMCUzRCUyMFRydWUlMEFVU0VfTE9SQSUyMCUzRCUyMFRydWUlMEElMEFpZiUyMFVTRV9RTE9SQSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGludC00JTIwY29uZmlnJTBBJTIwJTIwJTIwJTIwYm5iX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGxtX2ludDhfc2tpcF9tb2R1bGVzJTNEJTVCJTIydmlzaW9uX3Rvd2VyJTIyJTJDJTIwJTIybG1faGVhZCUyMiU1RCUyQyUyMCUyMCUyMyUyMFNraXAlMjBwcm9ibGVtYXRpYyUyMG1vZHVsZXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsbG1faW50OF9lbmFibGVfZnAzMl9jcHVfb2ZmbG9hZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjApJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMGJuYl9jb25maWclMjAlM0QlMjBOb25lJTBBJTBBJTIzJTIwTG9hZCUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RibmJfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwX2F0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyMGlmJTIwVVNFX0ZMQVNIX0FUVEVOVElPTiUyMGVsc2UlMjBOb25lJTJDJTBBKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

USE_QLORA = <span class="hljs-literal">True</span>
USE_LORA = <span class="hljs-literal">True</span>

<span class="hljs-keyword">if</span> USE_QLORA:
    <span class="hljs-comment"># BitsAndBytesConfig int-4 config</span>
    bnb_config = BitsAndBytesConfig(
        load_in_4bit=<span class="hljs-literal">True</span>,
        bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
        bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
        bnb_4bit_compute_dtype=torch.bfloat16,
        llm_int8_skip_modules=[<span class="hljs-string">&quot;vision_tower&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>],  <span class="hljs-comment"># Skip problematic modules</span>
        llm_int8_enable_fp32_cpu_offload=<span class="hljs-literal">True</span>,
    )
<span class="hljs-keyword">else</span>:
    bnb_config = <span class="hljs-literal">None</span>

<span class="hljs-comment"># Load model and tokenizer</span>
model = AutoModelForVision2Seq.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
    quantization_config=bnb_config,
    _attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span> <span class="hljs-keyword">if</span> USE_FLASH_ATTENTION <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
)
processor = AutoProcessor.from_pretrained(model_id)`,wrap:!1}}),rl=new j({props:{title:"4.2 Set Up QLoRA and SFTConfig 🚀",local:"42-set-up-qlora-and-sftconfig-",headingTag:"h3"}}),jl=new w({props:{code:"aWYlMjBVU0VfTE9SQSUzQSUwQSUyMCUyMCUyMCUyMGZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwTG9yYUNvbmZpZyUyQyUyMGdldF9wZWZ0X21vZGVsJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ29uZmlndXJlJTIwTG9SQSUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByJTNEOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0Q4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0QlNUJuYW1lJTIwZm9yJTIwbmFtZSUyQyUyMF8lMjBpbiUyMG1vZGVsLm5hbWVkX21vZHVsZXMoKSUyMGlmJTIwJTIybGFuZ3VhZ2VfbW9kZWwlMjIlMjBpbiUyMG5hbWUlMjBhbmQlMjAlMjJfcHJvaiUyMiUyMGluJTIwbmFtZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHVzZV9kb3JhJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTNEJTIyZ2F1c3NpYW4lMjIlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQXBwbHklMjBQRUZUJTIwbW9kZWwlMjBhZGFwdGF0aW9uJTBBJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMHBlZnRfY29uZmlnKSUwQSUyMCUyMCUyMCUyMG1vZGVsLmFkZF9hZGFwdGVyKHBlZnRfY29uZmlnKSUwQSUyMCUyMCUyMCUyMG1vZGVsLmVuYWJsZV9hZGFwdGVycygpJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMHBlZnRfY29uZmlnKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFByaW50JTIwdHJhaW5hYmxlJTIwcGFyYW1ldGVycyUwQSUyMCUyMCUyMCUyMG1vZGVsLnByaW50X3RyYWluYWJsZV9wYXJhbWV0ZXJzKCklMEElMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclMjAlM0QlMjBOb25l",highlighted:`<span class="hljs-keyword">if</span> USE_LORA:
    <span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

    <span class="hljs-comment"># Configure LoRA</span>
    peft_config = LoraConfig(
        r=<span class="hljs-number">8</span>,
        lora_alpha=<span class="hljs-number">8</span>,
        lora_dropout=<span class="hljs-number">0.1</span>,
        target_modules=[name <span class="hljs-keyword">for</span> name, _ <span class="hljs-keyword">in</span> model.named_modules() <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;language_model&quot;</span> <span class="hljs-keyword">in</span> name <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;_proj&quot;</span> <span class="hljs-keyword">in</span> name],
        use_dora=<span class="hljs-literal">True</span>,
        init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>,
    )

    <span class="hljs-comment"># Apply PEFT model adaptation</span>
    <span class="hljs-comment"># model = get_peft_model(model, peft_config)</span>
    model.add_adapter(peft_config)
    model.enable_adapters()
    model = get_peft_model(model, peft_config)

    <span class="hljs-comment"># Print trainable parameters</span>
    model.print_trainable_parameters()

<span class="hljs-keyword">else</span>:
    peft_config = <span class="hljs-literal">None</span>`,wrap:!1}}),fl=new w({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUwQSUwQSUyMyUyMENvbmZpZ3VyZSUyMHRyYWluaW5nJTIwYXJndW1lbnRzJTIwdXNpbmclMjBTRlRDb25maWclMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwU0ZUQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGY2hlY2twb2ludHMlMkZnZW9wZXJjZXB0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDElMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBtYXhfc3RlcHMlM0QzMCUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDglMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0QyJTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3N0ZXBzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMWUtNCUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9kZWNheSUzRDAuMDElMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3RvdGFsX2xpbWl0JTNEMSUyQyUwQSUyMCUyMCUyMCUyMG9wdGltJTNEJTIyYWRhbXdfdG9yY2hfZnVzZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBiZjE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVtb3ZlX3VudXNlZF9jb2x1bW5zJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9jaGVja3BvaW50aW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfa3dhcmdzJTNEJTdCJTIyc2tpcF9wcmVwYXJlX2RhdGFzZXQlMjIlM0ElMjBUcnVlJTdEJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig

<span class="hljs-comment"># Configure training arguments using SFTConfig</span>
training_args = SFTConfig(
    output_dir=<span class="hljs-string">&quot;./checkpoints/geoperception&quot;</span>,
    num_train_epochs=<span class="hljs-number">1</span>,
    <span class="hljs-comment"># max_steps=30,</span>
    per_device_train_batch_size=<span class="hljs-number">8</span>,
    gradient_accumulation_steps=<span class="hljs-number">2</span>,
    warmup_steps=<span class="hljs-number">10</span>,
    learning_rate=<span class="hljs-number">1e-4</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
    logging_steps=<span class="hljs-number">10</span>,
    save_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    save_steps=<span class="hljs-number">20</span>,
    save_total_limit=<span class="hljs-number">1</span>,
    optim=<span class="hljs-string">&quot;adamw_torch_fused&quot;</span>,
    bf16=<span class="hljs-literal">True</span>,
    push_to_hub=<span class="hljs-literal">False</span>,
    report_to=<span class="hljs-string">&quot;none&quot;</span>,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    dataset_text_field=<span class="hljs-string">&quot;&quot;</span>,
    dataset_kwargs={<span class="hljs-string">&quot;skip_prepare_dataset&quot;</span>: <span class="hljs-literal">True</span>},
)`,wrap:!1}}),Cl=new j({props:{title:"4.3 Training the Model 🏃",local:"43-training-the-model-",headingTag:"h3"}}),Tl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    texts = [processor.apply_chat_template(example, tokenize=<span class="hljs-literal">False</span>) <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]

    image_inputs = []
    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples:
        image = example[<span class="hljs-number">1</span>][<span class="hljs-string">&quot;content&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]
        <span class="hljs-keyword">if</span> image.mode != <span class="hljs-string">&quot;RGB&quot;</span>:
            image = image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)
        image_inputs.append([image])

    batch = processor(text=texts, images=image_inputs, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

    labels = batch[<span class="hljs-string">&quot;input_ids&quot;</span>].clone()
    assistant_tokens = processor.tokenizer(<span class="hljs-string">&quot;&lt;|assistant|&gt;&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]
    eos_token = processor.tokenizer(<span class="hljs-string">&quot;&lt;|end_of_text|&gt;&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]

    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">0</span>]):
        apply_loss = <span class="hljs-literal">False</span>
        <span class="hljs-keyword">for</span> j <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]):
            <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> apply_loss:
                labels[i][j] = -<span class="hljs-number">100</span>
            <span class="hljs-keyword">if</span> (j &gt;= <span class="hljs-built_in">len</span>(assistant_tokens) + <span class="hljs-number">1</span>) <span class="hljs-keyword">and</span> torch.<span class="hljs-built_in">all</span>(
                batch[<span class="hljs-string">&quot;input_ids&quot;</span>][i][j + <span class="hljs-number">1</span> - <span class="hljs-built_in">len</span>(assistant_tokens) : j + <span class="hljs-number">1</span>] == assistant_tokens
            ):
                apply_loss = <span class="hljs-literal">True</span>
            <span class="hljs-keyword">if</span> batch[<span class="hljs-string">&quot;input_ids&quot;</span>][i][j] == eos_token:
                apply_loss = <span class="hljs-literal">False</span>

    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),hl=new w({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRlX2ZuJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0RwZWZ0X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

trainer = SFTTrainer(
    model=model,
    args=training_args,
    train_dataset=train_dataset,
    data_collator=collate_fn,
    peft_config=peft_config,
    tokenizer=processor.tokenizer,
)`,wrap:!1}}),Jl=new w({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),ul=new w({props:{code:"dHJhaW5lci5zYXZlX21vZGVsKHRyYWluaW5nX2FyZ3Mub3V0cHV0X2Rpcik=",highlighted:"trainer.save_model(training_args.output_dir)",wrap:!1}}),bl=new j({props:{title:"5. Testing the Fine-Tuned Model 🔍",local:"5-testing-the-fine-tuned-model-",headingTag:"h2"}}),Ql=new w({props:{code:"Y2xlYXJfbWVtb3J5KCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>clear_memory()',wrap:!1}}),Vl=new w({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjB0cmFpbmluZ19hcmdzLm91dHB1dF9kaXIlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBfYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTIwaWYlMjBVU0VfRkxBU0hfQVRURU5USU9OJTIwZWxzZSUyME5vbmUlMkMlMEEpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQp",highlighted:`model = AutoModelForVision2Seq.from_pretrained(
    training_args.output_dir,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
    _attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span> <span class="hljs-keyword">if</span> USE_FLASH_ATTENTION <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
)

processor = AutoProcessor.from_pretrained(model_id)`,wrap:!1}}),Zl=new w({props:{code:"aWYlMjBVU0VfTE9SQSUzQSUwQSUyMCUyMCUyMCUyMGZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwdHJhaW5pbmdfYXJncy5vdXRwdXRfZGlyKQ==",highlighted:`<span class="hljs-keyword">if</span> USE_LORA:
    <span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

    model = PeftModel.from_pretrained(model, training_args.output_dir)`,wrap:!1}}),Hl=new w({props:{code:"dGVzdF9pZHglMjAlM0QlMjAyMCUwQXNhbXBsZSUyMCUzRCUyMHRlc3RfZGF0YXNldCU1QnRlc3RfaWR4JTVEJTBBc2FtcGxlJTVCMSUzQSU1RA==",highlighted:`test_idx = <span class="hljs-number">20</span>
sample = test_dataset[test_idx]
sample[<span class="hljs-number">1</span>:]`,wrap:!1}}),Gl=new w({props:{code:"c2FtcGxlJTVCMSU1RCU1QiUyMmNvbnRlbnQlMjIlNUQlNUIwJTVEJTVCJTIyaW1hZ2UlMjIlNUQ=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>sample[<span class="hljs-number">1</span>][<span class="hljs-string">&quot;content&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),xl=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwZ2VuZXJhdGVfdGV4dF9mcm9tX3NhbXBsZShtb2RlbCUyQyUyMHByb2Nlc3NvciUyQyUyMHNhbXBsZSklMEFvdXRwdXQ=",highlighted:`output = generate_text_from_sample(model, processor, sample)
output`,wrap:!1}}),kl=new j({props:{title:"🎉✨ The model has successfully learned to respond to the queries as specified in the dataset. We’ve achieved our goal! 🎉✨",local:"-the-model-has-successfully-learned-to-respond-to-the-queries-as-specified-in-the-dataset-weve-achieved-our-goal-",headingTag:"h4"}}),El=new mi({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/fine_tuning_granite_vision_sft_trl.md"}}),{c(){y=t("meta"),Dl=e(),Pl=t("p"),Ll=e(),n(f.$$.fragment),Yl=e(),n(C.$$.fragment),Ol=e(),R=t("p"),R.innerHTML=us,_l=e(),d=t("p"),d.innerHTML=bs,$l=e(),T=t("p"),T.innerHTML=Is,lo=e(),n(g.$$.fragment),oo=e(),h=t("p"),h.innerHTML=Bs,so=e(),m=t("p"),m.textContent=Qs,io=e(),n(J.$$.fragment),eo=e(),c=t("p"),c.textContent=vs,Ao=e(),n(u.$$.fragment),to=e(),n(b.$$.fragment),ao=e(),I=t("pre"),I.textContent=Xs,no=e(),n(B.$$.fragment),Ko=e(),Q=t("p"),Q.innerHTML=Vs,Uo=e(),v=t("p"),v.textContent=Ws,po=e(),n(X.$$.fragment),Mo=e(),V=t("p"),V.textContent=Zs,ro=e(),n(W.$$.fragment),Fo=e(),Z=t("p"),Z.textContent=Ns,wo=e(),n(N.$$.fragment),jo=e(),H=t("p"),H.textContent=Hs,yo=e(),G=t("p"),G.innerHTML=Gs,fo=e(),n(x.$$.fragment),Co=e(),k=t("p"),k.textContent=xs,Ro=e(),n(E.$$.fragment),To=e(),n(z.$$.fragment),go=e(),n(S.$$.fragment),ho=e(),P=t("p"),P.innerHTML=ks,mo=e(),q=t("p"),q.innerHTML=Es,Jo=e(),n(D.$$.fragment),co=e(),L=t("p"),L.textContent=zs,uo=e(),n(Y.$$.fragment),bo=e(),O=t("p"),O.textContent=Ss,Io=e(),n(_.$$.fragment),Bo=e(),$=t("p"),$.textContent=Ps,Qo=e(),n(ll.$$.fragment),vo=e(),zl=t("img"),Xo=e(),ol=t("p"),ol.textContent=Ds,Vo=e(),n(sl.$$.fragment),Wo=e(),n(il.$$.fragment),Zo=e(),el=t("p"),el.textContent=Ls,No=e(),Al=t("p"),Al.innerHTML=Ys,Ho=e(),tl=t("p"),tl.textContent=Os,Go=e(),n(al.$$.fragment),xo=e(),nl=t("pre"),nl.textContent=_s,ko=e(),n(Kl.$$.fragment),Eo=e(),n(Ul.$$.fragment),zo=e(),pl=t("p"),pl.innerHTML=$s,So=e(),n(Ml.$$.fragment),Po=e(),n(rl.$$.fragment),qo=e(),Fl=t("p"),Fl.innerHTML=li,Do=e(),wl=t("p"),wl.innerHTML=oi,Lo=e(),n(jl.$$.fragment),Yo=e(),yl=t("p"),yl.innerHTML=si,Oo=e(),n(fl.$$.fragment),_o=e(),n(Cl.$$.fragment),$o=e(),Rl=t("p"),Rl.textContent=ii,ls=e(),dl=t("p"),dl.innerHTML=ei,os=e(),n(Tl.$$.fragment),ss=e(),gl=t("p"),gl.innerHTML=Ai,is=e(),n(hl.$$.fragment),es=e(),ml=t("p"),ml.textContent=ti,As=e(),n(Jl.$$.fragment),ts=e(),cl=t("p"),cl.textContent=ai,as=e(),n(ul.$$.fragment),ns=e(),n(bl.$$.fragment),Ks=e(),Il=t("p"),Il.textContent=ni,Us=e(),Bl=t("p"),Bl.textContent=Ki,ps=e(),n(Ql.$$.fragment),Ms=e(),vl=t("pre"),vl.textContent=Ui,rs=e(),Xl=t("p"),Xl.textContent=pi,Fs=e(),n(Vl.$$.fragment),ws=e(),Wl=t("p"),Wl.textContent=Mi,js=e(),n(Zl.$$.fragment),ys=e(),Nl=t("p"),Nl.textContent=ri,fs=e(),n(Hl.$$.fragment),Cs=e(),n(Gl.$$.fragment),Rs=e(),Sl=t("img"),ds=e(),n(xl.$$.fragment),Ts=e(),n(kl.$$.fragment),gs=e(),n(El.$$.fragment),hs=e(),ql=t("p"),this.h()},l(l){const o=Ti("svelte-u9bgzb",document.head);y=a(o,"META",{name:!0,content:!0}),o.forEach(s),Dl=A(l),Pl=a(l,"P",{}),ji(Pl).forEach(s),Ll=A(l),K(f.$$.fragment,l),Yl=A(l),K(C.$$.fragment,l),Ol=A(l),R=a(l,"P",{"data-svelte-h":!0}),F(R)!=="svelte-xuch6p"&&(R.innerHTML=us),_l=A(l),d=a(l,"P",{"data-svelte-h":!0}),F(d)!=="svelte-k0rrvc"&&(d.innerHTML=bs),$l=A(l),T=a(l,"P",{"data-svelte-h":!0}),F(T)!=="svelte-icfya5"&&(T.innerHTML=Is),lo=A(l),K(g.$$.fragment,l),oo=A(l),h=a(l,"P",{"data-svelte-h":!0}),F(h)!=="svelte-1mw38wk"&&(h.innerHTML=Bs),so=A(l),m=a(l,"P",{"data-svelte-h":!0}),F(m)!=="svelte-13xozd9"&&(m.textContent=Qs),io=A(l),K(J.$$.fragment,l),eo=A(l),c=a(l,"P",{"data-svelte-h":!0}),F(c)!=="svelte-u0wdz3"&&(c.textContent=vs),Ao=A(l),K(u.$$.fragment,l),to=A(l),K(b.$$.fragment,l),ao=A(l),I=a(l,"PRE",{"data-svelte-h":!0}),F(I)!=="svelte-13umvo9"&&(I.textContent=Xs),no=A(l),K(B.$$.fragment,l),Ko=A(l),Q=a(l,"P",{"data-svelte-h":!0}),F(Q)!=="svelte-z8oda5"&&(Q.innerHTML=Vs),Uo=A(l),v=a(l,"P",{"data-svelte-h":!0}),F(v)!=="svelte-1oxrg5"&&(v.textContent=Ws),po=A(l),K(X.$$.fragment,l),Mo=A(l),V=a(l,"P",{"data-svelte-h":!0}),F(V)!=="svelte-jlieek"&&(V.textContent=Zs),ro=A(l),K(W.$$.fragment,l),Fo=A(l),Z=a(l,"P",{"data-svelte-h":!0}),F(Z)!=="svelte-y3guwa"&&(Z.textContent=Ns),wo=A(l),K(N.$$.fragment,l),jo=A(l),H=a(l,"P",{"data-svelte-h":!0}),F(H)!=="svelte-cnqilk"&&(H.textContent=Hs),yo=A(l),G=a(l,"P",{"data-svelte-h":!0}),F(G)!=="svelte-bzx1f1"&&(G.innerHTML=Gs),fo=A(l),K(x.$$.fragment,l),Co=A(l),k=a(l,"P",{"data-svelte-h":!0}),F(k)!=="svelte-ximgze"&&(k.textContent=xs),Ro=A(l),K(E.$$.fragment,l),To=A(l),K(z.$$.fragment,l),go=A(l),K(S.$$.fragment,l),ho=A(l),P=a(l,"P",{"data-svelte-h":!0}),F(P)!=="svelte-1hzpc6a"&&(P.innerHTML=ks),mo=A(l),q=a(l,"P",{"data-svelte-h":!0}),F(q)!=="svelte-u8rjxv"&&(q.innerHTML=Es),Jo=A(l),K(D.$$.fragment,l),co=A(l),L=a(l,"P",{"data-svelte-h":!0}),F(L)!=="svelte-gfg5qv"&&(L.textContent=zs),uo=A(l),K(Y.$$.fragment,l),bo=A(l),O=a(l,"P",{"data-svelte-h":!0}),F(O)!=="svelte-1n66uty"&&(O.textContent=Ss),Io=A(l),K(_.$$.fragment,l),Bo=A(l),$=a(l,"P",{"data-svelte-h":!0}),F($)!=="svelte-1jyjnzi"&&($.textContent=Ps),Qo=A(l),K(ll.$$.fragment,l),vo=A(l),zl=a(l,"IMG",{src:!0}),Xo=A(l),ol=a(l,"P",{"data-svelte-h":!0}),F(ol)!=="svelte-qa5kaq"&&(ol.textContent=Ds),Vo=A(l),K(sl.$$.fragment,l),Wo=A(l),K(il.$$.fragment,l),Zo=A(l),el=a(l,"P",{"data-svelte-h":!0}),F(el)!=="svelte-1kf0meg"&&(el.textContent=Ls),No=A(l),Al=a(l,"P",{"data-svelte-h":!0}),F(Al)!=="svelte-yxqr18"&&(Al.innerHTML=Ys),Ho=A(l),tl=a(l,"P",{"data-svelte-h":!0}),F(tl)!=="svelte-qc5v9y"&&(tl.textContent=Os),Go=A(l),K(al.$$.fragment,l),xo=A(l),nl=a(l,"PRE",{"data-svelte-h":!0}),F(nl)!=="svelte-twyo58"&&(nl.textContent=_s),ko=A(l),K(Kl.$$.fragment,l),Eo=A(l),K(Ul.$$.fragment,l),zo=A(l),pl=a(l,"P",{"data-svelte-h":!0}),F(pl)!=="svelte-h9dodt"&&(pl.innerHTML=$s),So=A(l),K(Ml.$$.fragment,l),Po=A(l),K(rl.$$.fragment,l),qo=A(l),Fl=a(l,"P",{"data-svelte-h":!0}),F(Fl)!=="svelte-fki271"&&(Fl.innerHTML=li),Do=A(l),wl=a(l,"P",{"data-svelte-h":!0}),F(wl)!=="svelte-15a7ils"&&(wl.innerHTML=oi),Lo=A(l),K(jl.$$.fragment,l),Yo=A(l),yl=a(l,"P",{"data-svelte-h":!0}),F(yl)!=="svelte-1ee3q2c"&&(yl.innerHTML=si),Oo=A(l),K(fl.$$.fragment,l),_o=A(l),K(Cl.$$.fragment,l),$o=A(l),Rl=a(l,"P",{"data-svelte-h":!0}),F(Rl)!=="svelte-1ru7box"&&(Rl.textContent=ii),ls=A(l),dl=a(l,"P",{"data-svelte-h":!0}),F(dl)!=="svelte-sfsxda"&&(dl.innerHTML=ei),os=A(l),K(Tl.$$.fragment,l),ss=A(l),gl=a(l,"P",{"data-svelte-h":!0}),F(gl)!=="svelte-8n6d4q"&&(gl.innerHTML=Ai),is=A(l),K(hl.$$.fragment,l),es=A(l),ml=a(l,"P",{"data-svelte-h":!0}),F(ml)!=="svelte-6y32l4"&&(ml.textContent=ti),As=A(l),K(Jl.$$.fragment,l),ts=A(l),cl=a(l,"P",{"data-svelte-h":!0}),F(cl)!=="svelte-14ctv5m"&&(cl.textContent=ai),as=A(l),K(ul.$$.fragment,l),ns=A(l),K(bl.$$.fragment,l),Ks=A(l),Il=a(l,"P",{"data-svelte-h":!0}),F(Il)!=="svelte-1cias4r"&&(Il.textContent=ni),Us=A(l),Bl=a(l,"P",{"data-svelte-h":!0}),F(Bl)!=="svelte-of0465"&&(Bl.textContent=Ki),ps=A(l),K(Ql.$$.fragment,l),Ms=A(l),vl=a(l,"PRE",{"data-svelte-h":!0}),F(vl)!=="svelte-1qeropb"&&(vl.textContent=Ui),rs=A(l),Xl=a(l,"P",{"data-svelte-h":!0}),F(Xl)!=="svelte-1edq15s"&&(Xl.textContent=pi),Fs=A(l),K(Vl.$$.fragment,l),ws=A(l),Wl=a(l,"P",{"data-svelte-h":!0}),F(Wl)!=="svelte-kumrzc"&&(Wl.textContent=Mi),js=A(l),K(Zl.$$.fragment,l),ys=A(l),Nl=a(l,"P",{"data-svelte-h":!0}),F(Nl)!=="svelte-1htrz0e"&&(Nl.textContent=ri),fs=A(l),K(Hl.$$.fragment,l),Cs=A(l),K(Gl.$$.fragment,l),Rs=A(l),Sl=a(l,"IMG",{src:!0}),ds=A(l),K(xl.$$.fragment,l),Ts=A(l),K(kl.$$.fragment,l),gs=A(l),K(El.$$.fragment,l),hs=A(l),ql=a(l,"P",{}),ji(ql).forEach(s),this.h()},h(){Js(y,"name","hf:doc:metadata"),Js(y,"content",ci),wi(zl.src,qs="data:image/jpeg;base64,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")||Js(zl,"src",qs),wi(Sl.src,Fi="data:image/jpeg;base64,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")||Js(Sl,"src",Fi)},m(l,o){gi(document.head,y),i(l,Dl,o),i(l,Pl,o),i(l,Ll,o),U(f,l,o),i(l,Yl,o),U(C,l,o),i(l,Ol,o),i(l,R,o),i(l,_l,o),i(l,d,o),i(l,$l,o),i(l,T,o),i(l,lo,o),U(g,l,o),i(l,oo,o),i(l,h,o),i(l,so,o),i(l,m,o),i(l,io,o),U(J,l,o),i(l,eo,o),i(l,c,o),i(l,Ao,o),U(u,l,o),i(l,to,o),U(b,l,o),i(l,ao,o),i(l,I,o),i(l,no,o),U(B,l,o),i(l,Ko,o),i(l,Q,o),i(l,Uo,o),i(l,v,o),i(l,po,o),U(X,l,o),i(l,Mo,o),i(l,V,o),i(l,ro,o),U(W,l,o),i(l,Fo,o),i(l,Z,o),i(l,wo,o),U(N,l,o),i(l,jo,o),i(l,H,o),i(l,yo,o),i(l,G,o),i(l,fo,o),U(x,l,o),i(l,Co,o),i(l,k,o),i(l,Ro,o),U(E,l,o),i(l,To,o),U(z,l,o),i(l,go,o),U(S,l,o),i(l,ho,o),i(l,P,o),i(l,mo,o),i(l,q,o),i(l,Jo,o),U(D,l,o),i(l,co,o),i(l,L,o),i(l,uo,o),U(Y,l,o),i(l,bo,o),i(l,O,o),i(l,Io,o),U(_,l,o),i(l,Bo,o),i(l,$,o),i(l,Qo,o),U(ll,l,o),i(l,vo,o),i(l,zl,o),i(l,Xo,o),i(l,ol,o),i(l,Vo,o),U(sl,l,o),i(l,Wo,o),U(il,l,o),i(l,Zo,o),i(l,el,o),i(l,No,o),i(l,Al,o),i(l,Ho,o),i(l,tl,o),i(l,Go,o),U(al,l,o),i(l,xo,o),i(l,nl,o),i(l,ko,o),U(Kl,l,o),i(l,Eo,o),U(Ul,l,o),i(l,zo,o),i(l,pl,o),i(l,So,o),U(Ml,l,o),i(l,Po,o),U(rl,l,o),i(l,qo,o),i(l,Fl,o),i(l,Do,o),i(l,wl,o),i(l,Lo,o),U(jl,l,o),i(l,Yo,o),i(l,yl,o),i(l,Oo,o),U(fl,l,o),i(l,_o,o),U(Cl,l,o),i(l,$o,o),i(l,Rl,o),i(l,ls,o),i(l,dl,o),i(l,os,o),U(Tl,l,o),i(l,ss,o),i(l,gl,o),i(l,is,o),U(hl,l,o),i(l,es,o),i(l,ml,o),i(l,As,o),U(Jl,l,o),i(l,ts,o),i(l,cl,o),i(l,as,o),U(ul,l,o),i(l,ns,o),U(bl,l,o),i(l,Ks,o),i(l,Il,o),i(l,Us,o),i(l,Bl,o),i(l,ps,o),U(Ql,l,o),i(l,Ms,o),i(l,vl,o),i(l,rs,o),i(l,Xl,o),i(l,Fs,o),U(Vl,l,o),i(l,ws,o),i(l,Wl,o),i(l,js,o),U(Zl,l,o),i(l,ys,o),i(l,Nl,o),i(l,fs,o),U(Hl,l,o),i(l,Cs,o),U(Gl,l,o),i(l,Rs,o),i(l,Sl,o),i(l,ds,o),U(xl,l,o),i(l,Ts,o),U(kl,l,o),i(l,gs,o),U(El,l,o),i(l,hs,o),i(l,ql,o),ms=!0},p:fi,i(l){ms||(p(f.$$.fragment,l),p(C.$$.fragment,l),p(g.$$.fragment,l),p(J.$$.fragment,l),p(u.$$.fragment,l),p(b.$$.fragment,l),p(B.$$.fragment,l),p(X.$$.fragment,l),p(W.$$.fragment,l),p(N.$$.fragment,l),p(x.$$.fragment,l),p(E.$$.fragment,l),p(z.$$.fragment,l),p(S.$$.fragment,l),p(D.$$.fragment,l),p(Y.$$.fragment,l),p(_.$$.fragment,l),p(ll.$$.fragment,l),p(sl.$$.fragment,l),p(il.$$.fragment,l),p(al.$$.fragment,l),p(Kl.$$.fragment,l),p(Ul.$$.fragment,l),p(Ml.$$.fragment,l),p(rl.$$.fragment,l),p(jl.$$.fragment,l),p(fl.$$.fragment,l),p(Cl.$$.fragment,l),p(Tl.$$.fragment,l),p(hl.$$.fragment,l),p(Jl.$$.fragment,l),p(ul.$$.fragment,l),p(bl.$$.fragment,l),p(Ql.$$.fragment,l),p(Vl.$$.fragment,l),p(Zl.$$.fragment,l),p(Hl.$$.fragment,l),p(Gl.$$.fragment,l),p(xl.$$.fragment,l),p(kl.$$.fragment,l),p(El.$$.fragment,l),ms=!0)},o(l){M(f.$$.fragment,l),M(C.$$.fragment,l),M(g.$$.fragment,l),M(J.$$.fragment,l),M(u.$$.fragment,l),M(b.$$.fragment,l),M(B.$$.fragment,l),M(X.$$.fragment,l),M(W.$$.fragment,l),M(N.$$.fragment,l),M(x.$$.fragment,l),M(E.$$.fragment,l),M(z.$$.fragment,l),M(S.$$.fragment,l),M(D.$$.fragment,l),M(Y.$$.fragment,l),M(_.$$.fragment,l),M(ll.$$.fragment,l),M(sl.$$.fragment,l),M(il.$$.fragment,l),M(al.$$.fragment,l),M(Kl.$$.fragment,l),M(Ul.$$.fragment,l),M(Ml.$$.fragment,l),M(rl.$$.fragment,l),M(jl.$$.fragment,l),M(fl.$$.fragment,l),M(Cl.$$.fragment,l),M(Tl.$$.fragment,l),M(hl.$$.fragment,l),M(Jl.$$.fragment,l),M(ul.$$.fragment,l),M(bl.$$.fragment,l),M(Ql.$$.fragment,l),M(Vl.$$.fragment,l),M(Zl.$$.fragment,l),M(Hl.$$.fragment,l),M(Gl.$$.fragment,l),M(xl.$$.fragment,l),M(kl.$$.fragment,l),M(El.$$.fragment,l),ms=!1},d(l){l&&(s(Dl),s(Pl),s(Ll),s(Yl),s(Ol),s(R),s(_l),s(d),s($l),s(T),s(lo),s(oo),s(h),s(so),s(m),s(io),s(eo),s(c),s(Ao),s(to),s(ao),s(I),s(no),s(Ko),s(Q),s(Uo),s(v),s(po),s(Mo),s(V),s(ro),s(Fo),s(Z),s(wo),s(jo),s(H),s(yo),s(G),s(fo),s(Co),s(k),s(Ro),s(To),s(go),s(ho),s(P),s(mo),s(q),s(Jo),s(co),s(L),s(uo),s(bo),s(O),s(Io),s(Bo),s($),s(Qo),s(vo),s(zl),s(Xo),s(ol),s(Vo),s(Wo),s(Zo),s(el),s(No),s(Al),s(Ho),s(tl),s(Go),s(xo),s(nl),s(ko),s(Eo),s(zo),s(pl),s(So),s(Po),s(qo),s(Fl),s(Do),s(wl),s(Lo),s(Yo),s(yl),s(Oo),s(_o),s($o),s(Rl),s(ls),s(dl),s(os),s(ss),s(gl),s(is),s(es),s(ml),s(As),s(ts),s(cl),s(as),s(ns),s(Ks),s(Il),s(Us),s(Bl),s(ps),s(Ms),s(vl),s(rs),s(Xl),s(Fs),s(ws),s(Wl),s(js),s(ys),s(Nl),s(fs),s(Cs),s(Rs),s(Sl),s(ds),s(Ts),s(gs),s(hs),s(ql)),s(y),r(f,l),r(C,l),r(g,l),r(J,l),r(u,l),r(b,l),r(B,l),r(X,l),r(W,l),r(N,l),r(x,l),r(E,l),r(z,l),r(S,l),r(D,l),r(Y,l),r(_,l),r(ll,l),r(sl,l),r(il,l),r(al,l),r(Kl,l),r(Ul,l),r(Ml,l),r(rl,l),r(jl,l),r(fl,l),r(Cl,l),r(Tl,l),r(hl,l),r(Jl,l),r(ul,l),r(bl,l),r(Ql,l),r(Vl,l),r(Zl,l),r(Hl,l),r(Gl,l),r(xl,l),r(kl,l),r(El,l)}}}const ci='{"title":"Fine-tuning Granite Vision 3.1 2B with TRL","local":"fine-tuning-granite-vision-31-2b-with-trl","sections":[{"title":"🌟 Model & Dataset Overview","local":"-model--dataset-overview","sections":[],"depth":3},{"title":"1. Install Dependencies","local":"1-install-dependencies","sections":[],"depth":2},{"title":"2. Load Dataset 📁","local":"2-load-dataset-","sections":[],"depth":2},{"title":"3. Load Model and Check Performance! 🤔","local":"3-load-model-and-check-performance-","sections":[],"depth":2},{"title":"4. Fine-Tune the Model using TRL","local":"4-fine-tune-the-model-using-trl","sections":[{"title":"4.1 Load the Quantized Model for Training ⚙️","local":"41-load-the-quantized-model-for-training-","sections":[],"depth":3},{"title":"4.2 Set Up QLoRA and SFTConfig 🚀","local":"42-set-up-qlora-and-sftconfig-","sections":[],"depth":3},{"title":"4.3 Training the Model 🏃","local":"43-training-the-model-","sections":[],"depth":3}],"depth":2},{"title":"5. Testing the Fine-Tuned Model 🔍","local":"5-testing-the-fine-tuned-model-","sections":[{"title":"🎉✨ The model has successfully learned to respond to the queries as specified in the dataset. We’ve achieved our goal! 🎉✨","local":"-the-model-has-successfully-learned-to-respond-to-the-queries-as-specified-in-the-dataset-weve-achieved-our-goal-","sections":[],"depth":4}],"depth":2}],"depth":1}';function ui(cs){return Ci(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vi extends Ri{constructor(y){super(),di(this,y,ui,Ji,yi,{})}}export{vi as component};
