import{s as He,n as xe,o as qe}from"../chunks/scheduler.65852ee5.js";import{S as Le,i as De,g as d,s as a,r as p,A as Oe,h as u,f as t,c as n,j as ze,u as i,x as y,k as Se,y as Ke,a as s,v as o,d as r,t as M,w as c}from"../chunks/index.65a1b999.js";import{D as Pe,C as m}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as Jl,E as lt}from"../chunks/getInferenceSnippets.aa1f4ff5.js";function et(fe){let h,bl,Ul,Tl,J,jl,U,fl,w,ge='<em>Authored by: <a href="https://github.com/MrzEsma" rel="nofollow">Mohammadreza Esmaeiliyan</a></em>',gl,b,Ie='In this notebook, we have attempted to fine-tune a large language model with no added complexity. The model has been optimized for use on a customer-level GPU to generate Persian product catalogs and produce structured output in JSON format. It is particularly effective for creating structured outputs from the unstructured titles and descriptions of products on Iranian platforms with user-generated content, such as <a href="https://basalam.com" rel="nofollow">Basalam</a>, <a href="https://divar.ir/" rel="nofollow">Divar</a>, <a href="https://www.digikala.com/" rel="nofollow">Digikala</a>, and others.',Il,T,Ce='You can see a fine-tuned LLM with this code on <a href="https://huggingface.co/BaSalam/Llama2-7b-entity-attr-v1" rel="nofollow">our HF account</a>. Additionally, one of the fastest open-source inference engines, <a href="https://github.com/vllm-project/vllm" rel="nofollow">Vllm</a>, is employed for inference.',Cl,j,Re="Let’s get started!",Rl,f,_l,g,_e='The <code>peft</code> library, or parameter efficient fine tuning, has been created to fine-tune LLMs more efficiently. If we were to open and fine-tune the upper layers of the network traditionally like all neural networks, it would require a lot of processing and also a significant amount of VRAM. With the methods developed in recent papers, this library has been implemented for efficient fine-tuning of LLMs. Read more about peft here: <a href="https://huggingface.co/blog/peft" rel="nofollow">Hugging Face PEFT</a>.',Zl,I,Xl,C,Bl,R,Gl,_,Ze="LoRA (Low-Rank Adaptation) stores changes in weights by constructing and adding a low-rank matrix to each model layer. This method opens only these layers for fine-tuning, without changing the original model weights or requiring lengthy training. The resulting weights are lightweight and can be produced multiple times, allowing for the fine-tuning of multiple tasks with an LLM loaded into RAM.",Vl,Z,Xe='Read about LoRA <a href="https://lightning.ai/pages/community/tutorial/lora-llm/" rel="nofollow">here at Lightning AI</a>. For other efficient training methods, see <a href="https://huggingface.co/docs/transformers/perf_train_gpu_one" rel="nofollow">Hugging Face Docs on Performance Training</a> and <a href="https://huggingface.co/docs/trl/main/en/sft_trainer#enhance-models-performances-using-neftune" rel="nofollow">SFT Trainer Enhancement</a>.',Ql,X,Wl,B,Be="QLoRA (Quantized Low-Rank Adaptation) is an efficient fine-tuning approach that enables large language models to run on smaller GPUs by using 4-bit quantization. This method preserves the full performance of 16-bit fine-tuning while reducing memory usage, making it possible to fine-tune models with up to 65 billion parameters on a single 48GB GPU. QLoRA combines 4-bit NormalFloat data types, double quantization, and paged optimizers to manage memory efficiently. It allows fine-tuning of models with low-rank adapters, significantly enhancing accessibility for AI model development.",kl,G,Ge='Read about QLoRA <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">here at Hugging Face</a>.',Fl,V,El,Q,Nl,W,$l,k,Al,F,Ve="The LoraConfig object is used to configure the LoRA (Low-Rank Adaptation) settings for the model when using the Peft library. This can help to reduce the number of parameters that need to be fine-tuned, which can lead to faster training and lower memory usage. Here’s a breakdown of the parameters:",Yl,E,Qe="<li><code>r</code>: The rank of the low-rank matrices used in LoRA. This parameter controls the dimensionality of the low-rank adaptation and directly impacts the model’s capacity to adapt and the computational cost.</li> <li><code>lora_alpha</code>: This parameter controls the scaling factor for the low-rank adaptation matrices. A higher alpha value can increase the model’s capacity to learn new tasks.</li> <li><code>lora_dropout</code>: The dropout rate for LoRA. This can help to prevent overfitting during fine-tuning. In this case, it’s set to 0.1.</li> <li><code>bias</code>: Specifies whether to add a bias term to the low-rank matrices. In this case, it’s set to “none”, which means that no bias term will be added.</li> <li><code>task_type</code>: Defines the type of task for which the model is being fine-tuned. Here, “CAUSAL_LM” indicates that the task is a causal language modeling task, which predicts the next word in a sequence.</li> <li><code>target_modules</code>: Specifies the modules in the model to which LoRA will be applied. In this case, it’s set to <code>[&quot;q_proj&quot;, &quot;v_proj&quot;, &#39;k_proj&#39;]</code>, which are the query, value, and key projection layers in the model’s attention mechanism.</li>",vl,N,zl,$,We="This block configures the settings for using BitsAndBytes (bnb), a library that provides efficient memory management and compression techniques for PyTorch models. Specifically, it defines how the model weights will be loaded and quantized in 4-bit precision, which is useful for reducing memory usage and potentially speeding up inference.",Sl,A,ke="<li><code>load_in_4bit</code>: A boolean that determines whether to load the model in 4-bit precision.</li> <li><code>bnb_4bit_quant_type</code>: Specifies the type of 4-bit quantization to use. Here, it’s set to 4-bit NormalFloat (NF4) quantization type, which is a new data type introduced in QLoRA. This type is information-theoretically optimal for normally distributed weights, providing an efficient way to quantize the model for fine-tuning.</li> <li><code>bnb_4bit_compute_dtype</code>: Sets the data type used for computations involving the quantized model. In QLoRA, it’s set to “float16”, which is commonly used for mixed-precision training to balance performance and precision.</li> <li><code>bnb_4bit_use_double_quant</code>: This boolean parameter indicates whether to use double quantization. Setting it to False means that only single quantization will be used, which is typically faster but might be slightly less accurate.</li>",Hl,Y,Fe=`Why we have two data type (quant_type and compute_type)?
QLoRA employs two distinct data types: one for storing base model weights (in here 4-bit NormalFloat) and another for computational operations (16-bit). During the forward and backward passes, QLoRA dequantizes the weights from the storage format to the computational format. However, it only calculates gradients for the LoRA parameters, which utilize 16-bit bfloat. This approach ensures that weights are decompressed only when necessary, maintaining low memory usage throughout both training and inference phases.`,xl,v,ql,z,Ll,S,Dl,H,Ee='Regarding the chat template, we will briefly explain that to understand the structure of the conversation between the user and the model during model training, a series of reserved phrases are created to separate the user’s message and the model’s response. This ensures that the model precisely understands where each message comes from and maintains a sense of the conversational structure. Typically, adhering to a chat template helps increase accuracy in the intended task. However, when there is a distribution shift between the fine-tuning dataset and the model, using a specific chat template can be even more helpful. For further reading, visit <a href="https://huggingface.co/blog/chat-templates" rel="nofollow">Hugging Face Blog on Chat Templates</a>.',Ol,x,Kl,q,Pl,L,le,D,Ne=`The <code>SFTTrainer</code> is then instantiated to handle supervised fine-tuning (SFT) of the model. This trainer is specifically designed for SFT and includes additional parameters such as <code>formatting_func</code> and <code>packing</code> which are not typically found in standard trainers.
<code>formatting_func</code>: A custom function to format training examples by combining instruction and response templates.
<code>packing</code>: Disables packing multiple samples into one sequence, which is not a standard parameter in the typical Trainer class.`,ee,O,te,K,se,P,ae,ll,ne,el,pe,tl,ie,sl,oe,al,re,nl,Me,pl,$e="Here, we merged the adapter with the base model and push the merged model on the hub. You can just push the adapter in the hub and avoid pushing the heavy base model file in this way:",ce,il,me,ol,Ae="And then you load the model in this way:",de,rl,ue,Ml,ye,cl,Ye=`The <code>vllm</code> library is one of the fastest inference engines for LLMs. For a comparative overview of available options, you can use this blog: <a href="https://medium.com/@gsuresh957/7-frameworks-for-serving-llms-5044b533ee88" rel="nofollow">7 Frameworks for Serving LLMs</a>.
In this example, we are inferring version 1 of our fine-tuned model on this task.`,he,ml,Je,dl,Ue,ul,we,yl,ve='In this blog, you can read about the best practices for fine-tuning LLMs <a href="https://magazine.sebastianraschka.com/p/practical-tips-for-finetuning-llms?r=1h0eu9&amp;utm_campaign=post&amp;utm_medium=web" rel="nofollow">Sebastian Raschka’s Magazine</a>.',be,hl,Te,wl,je;return J=new Pe({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/fine_tuning_llm_to_generate_persian_product_catalogs_in_json_format.ipynb"}]}}),U=new Jl({props:{title:"Fine-tuning LLM to Generate Persian Product Catalogs in JSON Format",local:"fine-tuning-llm-to-generate-persian-product-catalogs-in-json-format",headingTag:"h1"}}),f=new m({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTBBJTIwJTIwJTIwJTIwQXV0b1Rva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTBBKSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwTG9yYUNvbmZpZyUyQyUyMFBlZnRNb2RlbCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoModelForCausalLM,
    AutoTokenizer,
    BitsAndBytesConfig,
    TrainingArguments,
)
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, PeftModel
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM`,wrap:!1}}),I=new Jl({props:{title:"Set hyperparameters",local:"set-hyperparameters",headingTag:"h2"}}),C=new m({props:{code:"JTIzJTIwR2VuZXJhbCUyMHBhcmFtZXRlcnMlMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIyTm91c1Jlc2VhcmNoJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTIwJTIwJTIzJTIwVGhlJTIwbW9kZWwlMjB0aGF0JTIweW91JTIwd2FudCUyMHRvJTIwdHJhaW4lMjBmcm9tJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBodWIlMEFkYXRhc2V0X25hbWUlMjAlM0QlMjAlMjJCYVNhbGFtJTJGZW50aXR5LWF0dHJpYnV0ZS1kYXRhc2V0LUdQVC0zLjUtZ2VuZXJhdGVkLXYxJTIyJTIwJTIwJTIzJTIwVGhlJTIwaW5zdHJ1Y3Rpb24lMjBkYXRhc2V0JTIwdG8lMjB1c2UlMEFuZXdfbW9kZWwlMjAlM0QlMjAlMjJsbGFtYS1wZXJzaWFuLWNhdGFsb2ctZ2VuZXJhdG9yJTIyJTIwJTIwJTIzJTIwVGhlJTIwbmFtZSUyMGZvciUyMGZpbmUtdHVuZWQlMjBMb1JBJTIwQWRhcHRvcg==",highlighted:`<span class="hljs-comment"># General parameters</span>
model_name = <span class="hljs-string">&quot;NousResearch/Llama-2-7b-chat-hf&quot;</span>  <span class="hljs-comment"># The model that you want to train from the Hugging Face hub</span>
dataset_name = <span class="hljs-string">&quot;BaSalam/entity-attribute-dataset-GPT-3.5-generated-v1&quot;</span>  <span class="hljs-comment"># The instruction dataset to use</span>
new_model = <span class="hljs-string">&quot;llama-persian-catalog-generator&quot;</span>  <span class="hljs-comment"># The name for fine-tuned LoRA Adaptor</span>`,wrap:!1}}),R=new m({props:{code:"JTIzJTIwTG9SQSUyMHBhcmFtZXRlcnMlMEFsb3JhX3IlMjAlM0QlMjA2NCUwQWxvcmFfYWxwaGElMjAlM0QlMjBsb3JhX3IlMjAqJTIwMiUwQWxvcmFfZHJvcG91dCUyMCUzRCUyMDAuMSUwQXRhcmdldF9tb2R1bGVzJTIwJTNEJTIwJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTVE",highlighted:`<span class="hljs-comment"># LoRA parameters</span>
lora_r = <span class="hljs-number">64</span>
lora_alpha = lora_r * <span class="hljs-number">2</span>
lora_dropout = <span class="hljs-number">0.1</span>
target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>]`,wrap:!1}}),X=new m({props:{code:"JTIzJTIwUUxvUkElMjBwYXJhbWV0ZXJzJTBBbG9hZF9pbl80Yml0JTIwJTNEJTIwVHJ1ZSUwQWJuYl80Yml0X2NvbXB1dGVfZHR5cGUlMjAlM0QlMjAlMjJmbG9hdDE2JTIyJTBBYm5iXzRiaXRfcXVhbnRfdHlwZSUyMCUzRCUyMCUyMm5mNCUyMiUwQWJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlMjAlM0QlMjBGYWxzZQ==",highlighted:`<span class="hljs-comment"># QLoRA parameters</span>
load_in_4bit = <span class="hljs-literal">True</span>
bnb_4bit_compute_dtype = <span class="hljs-string">&quot;float16&quot;</span>
bnb_4bit_quant_type = <span class="hljs-string">&quot;nf4&quot;</span>
bnb_4bit_use_double_quant = <span class="hljs-literal">False</span>`,wrap:!1}}),V=new m({props:{code:"JTIzJTIwVHJhaW5pbmdBcmd1bWVudHMlMjBwYXJhbWV0ZXJzJTBBbnVtX3RyYWluX2Vwb2NocyUyMCUzRCUyMDElMEFmcDE2JTIwJTNEJTIwRmFsc2UlMEFiZjE2JTIwJTNEJTIwRmFsc2UlMEFwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAlM0QlMjA0JTBBZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwJTNEJTIwMSUwQWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlM0QlMjBUcnVlJTBBbGVhcm5pbmdfcmF0ZSUyMCUzRCUyMDAuMDAwMTUlMEF3ZWlnaHRfZGVjYXklMjAlM0QlMjAwLjAxJTBBb3B0aW0lMjAlM0QlMjAlMjJwYWdlZF9hZGFtd18zMmJpdCUyMiUwQWxyX3NjaGVkdWxlcl90eXBlJTIwJTNEJTIwJTIyY29zaW5lJTIyJTBBbWF4X3N0ZXBzJTIwJTNEJTIwLTElMEF3YXJtdXBfcmF0aW8lMjAlM0QlMjAwLjAzJTBBZ3JvdXBfYnlfbGVuZ3RoJTIwJTNEJTIwVHJ1ZSUwQXNhdmVfc3RlcHMlMjAlM0QlMjAwJTBBbG9nZ2luZ19zdGVwcyUyMCUzRCUyMDI1JTBBJTBBJTIzJTIwU0ZUJTIwcGFyYW1ldGVycyUwQW1heF9zZXFfbGVuZ3RoJTIwJTNEJTIwTm9uZSUwQXBhY2tpbmclMjAlM0QlMjBGYWxzZSUwQWRldmljZV9tYXAlMjAlM0QlMjAlN0IlMjIlMjIlM0ElMjAwJTdEJTBBJTBBJTIzJTIwRGF0YXNldCUyMHBhcmFtZXRlcnMlMEF1c2Vfc3BlY2lhbF90ZW1wbGF0ZSUyMCUzRCUyMFRydWUlMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMiUwQWluc3RydWN0aW9uX3Byb21wdF90ZW1wbGF0ZSUyMCUzRCUyMCclMjIlMjMlMjMlMjMlMjBIdW1hbiUzQSUyMiclMEF1c2VfbGxhbWFfbGlrZV9tb2RlbCUyMCUzRCUyMFRydWU=",highlighted:`<span class="hljs-comment"># TrainingArguments parameters</span>
num_train_epochs = <span class="hljs-number">1</span>
fp16 = <span class="hljs-literal">False</span>
bf16 = <span class="hljs-literal">False</span>
per_device_train_batch_size = <span class="hljs-number">4</span>
gradient_accumulation_steps = <span class="hljs-number">1</span>
gradient_checkpointing = <span class="hljs-literal">True</span>
learning_rate = <span class="hljs-number">0.00015</span>
weight_decay = <span class="hljs-number">0.01</span>
optim = <span class="hljs-string">&quot;paged_adamw_32bit&quot;</span>
lr_scheduler_type = <span class="hljs-string">&quot;cosine&quot;</span>
max_steps = -<span class="hljs-number">1</span>
warmup_ratio = <span class="hljs-number">0.03</span>
group_by_length = <span class="hljs-literal">True</span>
save_steps = <span class="hljs-number">0</span>
logging_steps = <span class="hljs-number">25</span>

<span class="hljs-comment"># SFT parameters</span>
max_seq_length = <span class="hljs-literal">None</span>
packing = <span class="hljs-literal">False</span>
device_map = {<span class="hljs-string">&quot;&quot;</span>: <span class="hljs-number">0</span>}

<span class="hljs-comment"># Dataset parameters</span>
use_special_template = <span class="hljs-literal">True</span>
response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
instruction_prompt_template = <span class="hljs-string">&#x27;&quot;### Human:&quot;&#x27;</span>
use_llama_like_model = <span class="hljs-literal">True</span>`,wrap:!1}}),Q=new Jl({props:{title:"Model Training",local:"model-training",headingTag:"h2"}}),W=new m({props:{code:"JTIzJTIwTG9hZCUyMGRhdGFzZXQlMjAoeW91JTIwY2FuJTIwcHJvY2VzcyUyMGl0JTIwaGVyZSklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KGRhdGFzZXRfbmFtZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBcGVyY2VudF9vZl90cmFpbl9kYXRhc2V0JTIwJTNEJTIwMC45NSUwQW90aGVyX2NvbHVtbnMlMjAlM0QlMjAlNUJpJTIwZm9yJTIwaSUyMGluJTIwZGF0YXNldC5jb2x1bW5fbmFtZXMlMjBpZiUyMGklMjBub3QlMjBpbiUyMCU1QiUyMmluc3RydWN0aW9uJTIyJTJDJTIwJTIyb3V0cHV0JTIyJTVEJTVEJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVtb3ZlX2NvbHVtbnMob3RoZXJfY29sdW1ucyklMEFzcGxpdF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC50cmFpbl90ZXN0X3NwbGl0KCUwQSUyMCUyMCUyMCUyMHRyYWluX3NpemUlM0RpbnQoZGF0YXNldC5udW1fcm93cyUyMColMjBwZXJjZW50X29mX3RyYWluX2RhdGFzZXQpJTJDJTIwc2VlZCUzRDE5JTJDJTIwc2h1ZmZsZSUzREZhbHNlJTBBKSUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBzcGxpdF9kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMEFldmFsX2RhdGFzZXQlMjAlM0QlMjBzcGxpdF9kYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUwQXByaW50KGYlMjJTaXplJTIwb2YlMjB0aGUlMjB0cmFpbiUyMHNldCUzQSUyMCU3Qmxlbih0cmFpbl9kYXRhc2V0KSU3RC4lMjBTaXplJTIwb2YlMjB0aGUlMjB2YWxpZGF0aW9uJTIwc2V0JTNBJTIwJTdCbGVuKGV2YWxfZGF0YXNldCklN0QlMjIp",highlighted:`<span class="hljs-comment"># Load dataset (you can process it here)</span>
dataset = load_dataset(dataset_name, split=<span class="hljs-string">&quot;train&quot;</span>)
percent_of_train_dataset = <span class="hljs-number">0.95</span>
other_columns = [i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> dataset.column_names <span class="hljs-keyword">if</span> i <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;instruction&quot;</span>, <span class="hljs-string">&quot;output&quot;</span>]]
dataset = dataset.remove_columns(other_columns)
split_dataset = dataset.train_test_split(
    train_size=<span class="hljs-built_in">int</span>(dataset.num_rows * percent_of_train_dataset), seed=<span class="hljs-number">19</span>, shuffle=<span class="hljs-literal">False</span>
)
train_dataset = split_dataset[<span class="hljs-string">&quot;train&quot;</span>]
eval_dataset = split_dataset[<span class="hljs-string">&quot;test&quot;</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Size of the train set: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(train_dataset)}</span>. Size of the validation set: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(eval_dataset)}</span>&quot;</span>)`,wrap:!1}}),k=new m({props:{code:"JTIzJTIwTG9hZCUyMExvUkElMjBjb25maWd1cmF0aW9uJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0Rsb3JhX3IlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEbG9yYV9hbHBoYSUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRGxvcmFfZHJvcG91dCUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0R0YXJnZXRfbW9kdWxlcyUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Load LoRA configuration</span>
peft_config = LoraConfig(
    r=lora_r,
    lora_alpha=lora_alpha,
    lora_dropout=lora_dropout,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
    target_modules=target_modules,
)`,wrap:!1}}),N=new m({props:{code:"JTIzJTIwTG9hZCUyMFFMb1JBJTIwY29uZmlndXJhdGlvbiUwQWNvbXB1dGVfZHR5cGUlMjAlM0QlMjBnZXRhdHRyKHRvcmNoJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSklMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRGxvYWRfaW5fNGJpdCUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0RibmJfNGJpdF9xdWFudF90eXBlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRGNvbXB1dGVfZHR5cGUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Load QLoRA configuration</span>
compute_dtype = <span class="hljs-built_in">getattr</span>(torch, bnb_4bit_compute_dtype)

bnb_config = BitsAndBytesConfig(
    load_in_4bit=load_in_4bit,
    bnb_4bit_quant_type=bnb_4bit_quant_type,
    bnb_4bit_compute_dtype=compute_dtype,
    bnb_4bit_use_double_quant=bnb_4bit_use_double_quant,
)`,wrap:!1}}),v=new m({props:{code:"JTIzJTIwTG9hZCUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyUyQyUyMGRldmljZV9tYXAlM0RkZXZpY2VfbWFwKSUwQW1vZGVsLmNvbmZpZy51c2VfY2FjaGUlMjAlM0QlMjBGYWxzZQ==",highlighted:`<span class="hljs-comment"># Load base model</span>
model = AutoModelForCausalLM.from_pretrained(model_name, quantization_config=bnb_config, device_map=device_map)
model.config.use_cache = <span class="hljs-literal">False</span>`,wrap:!1}}),z=new m({props:{code:"JTIzJTIwU2V0JTIwdHJhaW5pbmclMjBwYXJhbWV0ZXJzJTBBdHJhaW5pbmdfYXJndW1lbnRzJTIwJTNEJTIwVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRG5ld19tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0RudW1fdHJhaW5fZXBvY2hzJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW0lM0RvcHRpbSUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0RzYXZlX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRGxvZ2dpbmdfc3RlcHMlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEbGVhcm5pbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9kZWNheSUzRHdlaWdodF9kZWNheSUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RmcDE2JTJDJTBBJTIwJTIwJTIwJTIwYmYxNiUzRGJmMTYlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0RtYXhfc3RlcHMlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfcmF0aW8lM0R3YXJtdXBfcmF0aW8lMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9jaGVja3BvaW50aW5nJTNEZ3JhZGllbnRfY2hlY2twb2ludGluZyUyQyUwQSUyMCUyMCUyMCUyMGdyb3VwX2J5X2xlbmd0aCUzRGdyb3VwX2J5X2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlcl90eXBlJTNEbHJfc2NoZWR1bGVyX3R5cGUlMkMlMEEp",highlighted:`<span class="hljs-comment"># Set training parameters</span>
training_arguments = TrainingArguments(
    output_dir=new_model,
    num_train_epochs=num_train_epochs,
    per_device_train_batch_size=per_device_train_batch_size,
    gradient_accumulation_steps=gradient_accumulation_steps,
    optim=optim,
    save_steps=save_steps,
    logging_steps=logging_steps,
    learning_rate=learning_rate,
    weight_decay=weight_decay,
    fp16=fp16,
    bf16=bf16,
    max_steps=max_steps,
    warmup_ratio=warmup_ratio,
    gradient_checkpointing=gradient_checkpointing,
    group_by_length=group_by_length,
    lr_scheduler_type=lr_scheduler_type,
)`,wrap:!1}}),S=new m({props:{code:"JTIzJTIwTG9hZCUyMHRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBdG9rZW5pemVyLnBhZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW4lMEF0b2tlbml6ZXIucGFkZGluZ19zaWRlJTIwJTNEJTIwJTIycmlnaHQlMjIlMjAlMjAlMjMlMjBGaXglMjB3ZWlyZCUyMG92ZXJmbG93JTIwaXNzdWUlMjB3aXRoJTIwZnAxNiUyMHRyYWluaW5nJTBBaWYlMjBub3QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplci5jaGF0X3RlbXBsYXRlJTIwJTNEJTIwJTIyJTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUyMg==",highlighted:`<span class="hljs-comment"># Load tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(model_name, trust_remote_code=<span class="hljs-literal">True</span>)
tokenizer.pad_token = tokenizer.eos_token
tokenizer.padding_side = <span class="hljs-string">&quot;right&quot;</span>  <span class="hljs-comment"># Fix weird overflow issue with fp16 training</span>
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> tokenizer.chat_template:
    tokenizer.chat_template = <span class="hljs-string">&quot;{% for message in messages %}{{&#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27;}}{% endfor %}&quot;</span>`,wrap:!1}}),x=new m({props:{code:"ZGVmJTIwc3BlY2lhbF9mb3JtYXR0aW5nX3Byb21wdHMoZXhhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRfdGV4dHMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZXhhbXBsZSU1QiUyMmluc3RydWN0aW9uJTIyJTVEKSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZXh0JTIwJTNEJTIwZiUyMiU3Qmluc3RydWN0aW9uX3Byb21wdF90ZW1wbGF0ZSU3RCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lN0JyZXNwb25zZV90ZW1wbGF0ZSU3RCUyMCU3QmV4YW1wbGUlNUInb3V0cHV0JyU1RCU1QmklNUQlN0QlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfdGV4dHMuYXBwZW5kKHRleHQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwb3V0cHV0X3RleHRzJTBBJTBBJTBBZGVmJTIwbm9ybWFsX2Zvcm1hdHRpbmdfcHJvbXB0cyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJTIyaW5zdHJ1Y3Rpb24lMjIlNUQpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNoYXRfdGVtcCUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwZXhhbXBsZSU1QiUyMmluc3RydWN0aW9uJTIyJTVEJTVCaSU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwZXhhbXBsZSU1QiUyMm91dHB1dCUyMiU1RCU1QmklNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdF90ZW1wJTJDJTIwdG9rZW5pemUlM0RGYWxzZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfdGV4dHMuYXBwZW5kKHRleHQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwb3V0cHV0X3RleHRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">special_formatting_prompts</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&quot;instruction&quot;</span>])):
        text = <span class="hljs-string">f&quot;<span class="hljs-subst">{instruction_prompt_template}</span><span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n<span class="hljs-subst">{response_template}</span> <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts


<span class="hljs-keyword">def</span> <span class="hljs-title function_">normal_formatting_prompts</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&quot;instruction&quot;</span>])):
        chat_temp = [
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: example[<span class="hljs-string">&quot;instruction&quot;</span>][i]},
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: example[<span class="hljs-string">&quot;output&quot;</span>][i]},
        ]
        text = tokenizer.apply_chat_template(chat_temp, tokenize=<span class="hljs-literal">False</span>)
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts`,wrap:!1}}),q=new m({props:{code:"aWYlMjB1c2Vfc3BlY2lhbF90ZW1wbGF0ZSUzQSUwQSUyMCUyMCUyMCUyMGZvcm1hdHRpbmdfZnVuYyUyMCUzRCUyMHNwZWNpYWxfZm9ybWF0dGluZ19wcm9tcHRzJTBBJTIwJTIwJTIwJTIwaWYlMjB1c2VfbGxhbWFfbGlrZV9tb2RlbCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGUlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklNUIyJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGVfaWRzJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0ocmVzcG9uc2VfdGVtcGxhdGUlM0RyZXNwb25zZV90ZW1wbGF0ZSUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGluZ19mdW5jJTIwJTNEJTIwbm9ybWFsX2Zvcm1hdHRpbmdfcHJvbXB0cw==",highlighted:`<span class="hljs-keyword">if</span> use_special_template:
    formatting_func = special_formatting_prompts
    <span class="hljs-keyword">if</span> use_llama_like_model:
        response_template_ids = tokenizer.encode(response_template, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]
        collator = DataCollatorForCompletionOnlyLM(response_template=response_template_ids, tokenizer=tokenizer)
    <span class="hljs-keyword">else</span>:
        collator = DataCollatorForCompletionOnlyLM(response_template=response_template, tokenizer=tokenizer)
<span class="hljs-keyword">else</span>:
    formatting_func = normal_formatting_prompts`,wrap:!1}}),L=new m({props:{code:"dHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0RwZWZ0X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGZvcm1hdHRpbmdfZnVuYyUzRGZvcm1hdHRpbmdfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJndW1lbnRzJTJDJTBBJTIwJTIwJTIwJTIwcGFja2luZyUzRHBhY2tpbmclMkMlMEEp",highlighted:`trainer = SFTTrainer(
    model=model,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    peft_config=peft_config,
    formatting_func=formatting_func,
    data_collator=collator,
    max_seq_length=max_seq_length,
    tokenizer=tokenizer,
    args=training_arguments,
    packing=packing,
)`,wrap:!1}}),O=new m({props:{code:"JTIzJTIwVHJhaW4lMjBtb2RlbCUwQXRyYWluZXIudHJhaW4oKSUwQSUwQSUyMyUyMFNhdmUlMjBmaW5lJTIwdHVuZWQlMjBMb3JhJTIwQWRhcHRvciUwQXRyYWluZXIubW9kZWwuc2F2ZV9wcmV0cmFpbmVkKG5ld19tb2RlbCk=",highlighted:`<span class="hljs-comment"># Train model</span>
trainer.train()

<span class="hljs-comment"># Save fine tuned Lora Adaptor</span>
trainer.model.save_pretrained(new_model)`,wrap:!1}}),K=new Jl({props:{title:"Inference",local:"inference",headingTag:"h2"}}),P=new m({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBnYyUwQSUwQSUwQWRlZiUyMGNsZWFyX2hhcmR3YXJlcygpJTNBJTBBJTIwJTIwJTIwJTIwdG9yY2guY2xlYXJfYXV0b2Nhc3RfY2FjaGUoKSUwQSUyMCUyMCUyMCUyMHRvcmNoLmN1ZGEuaXBjX2NvbGxlY3QoKSUwQSUyMCUyMCUyMCUyMHRvcmNoLmN1ZGEuZW1wdHlfY2FjaGUoKSUwQSUyMCUyMCUyMCUyMGdjLmNvbGxlY3QoKSUwQSUwQSUwQWNsZWFyX2hhcmR3YXJlcygpJTBBY2xlYXJfaGFyZHdhcmVzKCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> gc


<span class="hljs-keyword">def</span> <span class="hljs-title function_">clear_hardwares</span>():
    torch.clear_autocast_cache()
    torch.cuda.ipc_collect()
    torch.cuda.empty_cache()
    gc.collect()


clear_hardwares()
clear_hardwares()`,wrap:!1}}),ll=new m({props:{code:"ZGVmJTIwZ2VuZXJhdGUobW9kZWwlMkMlMjBwcm9tcHQlM0ElMjBzdHIlMkMlMjBrd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX3Byb21wdCUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2xlbmd0aCUyMCUzRCUyMGxlbih0b2tlbml6ZWRfcHJvbXB0LmdldCglMjJpbnB1dF9pZHMlMjIpJTVCMCU1RCklMEElMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2guY3VkYS5hbXAuYXV0b2Nhc3QoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKnRva2VuaXplZF9wcm9tcHQlMkMlMjAqKmt3YXJncyklMjBpZiUyMGt3YXJncyUyMGVsc2UlMjBtb2RlbC5nZW5lcmF0ZSgqKnRva2VuaXplZF9wcm9tcHQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShvdXRwdXRfdG9rZW5zJTVCMCU1RCU1QnByb21wdF9sZW5ndGglM0ElNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">model, prompt: <span class="hljs-built_in">str</span>, kwargs</span>):
    tokenized_prompt = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

    prompt_length = <span class="hljs-built_in">len</span>(tokenized_prompt.get(<span class="hljs-string">&quot;input_ids&quot;</span>)[<span class="hljs-number">0</span>])

    <span class="hljs-keyword">with</span> torch.cuda.amp.autocast():
        output_tokens = model.generate(**tokenized_prompt, **kwargs) <span class="hljs-keyword">if</span> kwargs <span class="hljs-keyword">else</span> model.generate(**tokenized_prompt)
        output = tokenizer.decode(output_tokens[<span class="hljs-number">0</span>][prompt_length:], skip_special_tokens=<span class="hljs-literal">True</span>)

    <span class="hljs-keyword">return</span> output`,wrap:!1}}),el=new m({props:{code:"YmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChuZXdfbW9kZWwlMkMlMjByZXR1cm5fZGljdCUzRFRydWUlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMHRva2VuJTNEJTIyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG5ld19tb2RlbCUyQyUyMG1heF9sZW5ndGglM0RtYXhfc2VxX2xlbmd0aCklMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmFzZV9tb2RlbCUyQyUyMG5ld19tb2RlbCklMEFkZWwlMjBiYXNlX21vZGVs",highlighted:`base_model = AutoModelForCausalLM.from_pretrained(new_model, return_dict=<span class="hljs-literal">True</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, token=<span class="hljs-string">&quot;&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(new_model, max_length=max_seq_length)
model = PeftModel.from_pretrained(base_model, new_model)
<span class="hljs-keyword">del</span> base_model`,wrap:!1}}),tl=new m({props:{code:"c2FtcGxlJTIwJTNEJTIwZXZhbF9kYXRhc2V0JTVCMCU1RCUwQWlmJTIwdXNlX3NwZWNpYWxfdGVtcGxhdGUlM0ElMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjBmJTIyJTdCaW5zdHJ1Y3Rpb25fcHJvbXB0X3RlbXBsYXRlJTdEJTdCc2FtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCU3RCU1Q24lN0JyZXNwb25zZV90ZW1wbGF0ZSU3RCUyMiUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBjaGF0X3RlbXAlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHNhbXBsZSU1QiUyMmluc3RydWN0aW9uJTIyJTVEJTdEJTVEJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdF90ZW1wJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUp",highlighted:`sample = eval_dataset[<span class="hljs-number">0</span>]
<span class="hljs-keyword">if</span> use_special_template:
    prompt = <span class="hljs-string">f&quot;<span class="hljs-subst">{instruction_prompt_template}</span><span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>\\n<span class="hljs-subst">{response_template}</span>&quot;</span>
<span class="hljs-keyword">else</span>:
    chat_temp = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: sample[<span class="hljs-string">&quot;instruction&quot;</span>]}]
    prompt = tokenizer.apply_chat_template(chat_temp, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)`,wrap:!1}}),sl=new m({props:{code:"Z2VuX2t3YXJncyUyMCUzRCUyMCU3QiUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwMTAyNCU3RCUwQWdlbmVyYXRlZF90ZXh0cyUyMCUzRCUyMGdlbmVyYXRlKG1vZGVsJTNEbW9kZWwlMkMlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMjBrd2FyZ3MlM0RnZW5fa3dhcmdzKSUwQXByaW50KGdlbmVyYXRlZF90ZXh0cyk=",highlighted:`gen_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">1024</span>}
generated_texts = generate(model=model, prompt=prompt, kwargs=gen_kwargs)
<span class="hljs-built_in">print</span>(generated_texts)`,wrap:!1}}),al=new Jl({props:{title:"Merge to base model",local:"merge-to-base-model",headingTag:"h2"}}),nl=new m({props:{code:"Y2xlYXJfaGFyZHdhcmVzKCklMEFtZXJnZWRfbW9kZWwlMjAlM0QlMjBtb2RlbC5tZXJnZV9hbmRfdW5sb2FkKCklMEFjbGVhcl9oYXJkd2FyZXMoKSUwQWRlbCUyMG1vZGVsJTBBYWRhcHRlcl9tb2RlbF9uYW1lJTIwJTNEJTIwJTIyeW91cl9oZl9hY2NvdW50JTJGeW91cl9kZXNpcmVkX25hbWUlMjIlMEFtZXJnZWRfbW9kZWwucHVzaF90b19odWIoYWRhcHRlcl9tb2RlbF9uYW1lKQ==",highlighted:`clear_hardwares()
merged_model = model.merge_and_unload()
clear_hardwares()
<span class="hljs-keyword">del</span> model
adapter_model_name = <span class="hljs-string">&quot;your_hf_account/your_desired_name&quot;</span>
merged_model.push_to_hub(adapter_model_name)`,wrap:!1}}),il=new m({props:{code:"bW9kZWwucHVzaF90b19odWIoYWRhcHRlcl9tb2RlbF9uYW1lKQ==",highlighted:'model.push<span class="hljs-constructor">_to_hub(<span class="hljs-params">adapter_model_name</span>)</span>',wrap:!1}}),rl=new m({props:{code:"Y29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQoYWRhcHRlcl9tb2RlbF9uYW1lKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNvbmZpZy5iYXNlX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUlMkMlMjBkZXZpY2VfbWFwJTNEJ2F1dG8nKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGNvbmZpZy5iYXNlX21vZGVsX25hbWVfb3JfcGF0aCklMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwTG9yYSUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwYWRhcHRlcl9tb2RlbF9uYW1lKQ==",highlighted:`config = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">PeftConfig</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-params">adapter_model_name</span>)</span>
model = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">AutoModelForCausalLM</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-params">config</span>.<span class="hljs-params">base_model_name_or_path</span>, <span class="hljs-params">return_dict</span>=True, <span class="hljs-params">load_in_8bit</span>=True, <span class="hljs-params">device_map</span>=&#x27;<span class="hljs-params">auto</span>&#x27;)</span>
tokenizer = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">AutoTokenizer</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-params">config</span>.<span class="hljs-params">base_model_name_or_path</span>)</span>

# Load the Lora model
model = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">PeftModel</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-params">model</span>, <span class="hljs-params">adapter_model_name</span>)</span>`,wrap:!1}}),Ml=new Jl({props:{title:"Fast Inference with Vllm",local:"fast-inference-with-vllm",headingTag:"h2"}}),ml=new m({props:{code:"ZnJvbSUyMHZsbG0lMjBpbXBvcnQlMjBMTE0lMkMlMjBTYW1wbGluZ1BhcmFtcyUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFF1ZXN0aW9uJTNBJTIwaGVyZSUyMGlzJTIwYSUyMHByb2R1Y3QlMjB0aXRsZSUyMGZyb20lMjBhJTIwSXJhbmlhbiUyMG1hcmtldHBsYWNlLiUyMCUyMCU1Q24lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnaXZlJTIwbWUlMjB0aGUlMjBQcm9kdWN0JTIwRW50aXR5JTIwYW5kJTIwQXR0cmlidXRlcyUyMG9mJTIwdGhpcyUyMHByb2R1Y3QlMjBpbiUyMFBlcnNpYW4lMjBsYW5ndWFnZS4lNUNuJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2l2ZSUyMHRoZSUyMG91dHB1dCUyMGluJTIwdGhpcyUyMGpzb24lMjBmb3JtYXQlM0ElMjAlN0InYXR0cmlidXRlcyclM0ElMjAlN0InYXR0cmlidXRlX25hbWUnJTIwJTNBJTIwJTNDYXR0cmlidXRlJTIwdmFsdWUlM0UlMkMlMjAuLi4lN0QlMkMlMjAncHJvZHVjdF9lbnRpdHknJTNBJTIwJyUzQ3Byb2R1Y3QlMjBlbnRpdHklM0UnJTdELiU1Q24lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEb24ndCUyMG1ha2UlMjBhc3N1bXB0aW9ucyUyMGFib3V0JTIwd2hhdCUyMHZhbHVlcyUyMHRvJTIwcGx1ZyUyMGludG8lMjBqc29uLiUyMEp1c3QlMjBnaXZlJTIwSnNvbiUyMG5vdCUyMGElMjBzaW5nbGUlMjB3b3JkJTIwbW9yZS4lNUNuJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVDbnByb2R1Y3QlMjB0aXRsZSUzQSUyMiUyMiUyMiUwQXVzZXJfcHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIzJTIzJTIzJTIwUXVlc3Rpb24lM0ElMjAlMjIlMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMiUwQSUwQWxsbSUyMCUzRCUyMExMTShtb2RlbCUzRCUyMkJhU2FsYW0lMkZMbGFtYTItN2ItZW50aXR5LWF0dHItdjElMjIlMkMlMjBncHVfbWVtb3J5X3V0aWxpemF0aW9uJTNEMC45JTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQSUwQXByb2R1Y3QlMjAlM0QlMjAlMjIlRDklODUlRDglQTclRDklODYlRDglQUElRDklODglMjAlRDglQTclRDglQjMlRDklQkUlRDglQjElRDglQUElMjAlRDklQkUlRDglQTclRDklODYlREIlOEMlRDglQjAlMjAlRDklODIlRDglQUYlMjAlRDglQUMlRDklODQlRDklODglREIlOEMlMjAlREElQTklRDglQTclRDglQjElMjAlRDglQUQlRDglQUYlRDklODglRDglQUYlRDglQTclMjA4NSUyMCVEOCVCMyVEOCVBNyVEOSU4NiVEOCVBQSVEQiU4QyUyMCVEOSU4NSVEOCVBQSVEOCVCMSUyMCVEOSU4MiVEOCVBRiUyMCVEOSVCRSVEOCVCNCVEOCVBQSUyMCVEQSVBOSVEOCVBNyVEOCVCMSUyMCVEOCVBRCVEOCVBRiVEOSU4OCVEOCVBRiVEOCVBNyUyMDg4JTIwJUQ4JUIzJUQ4JUE3JUQ5JTg2JUQ4JUFBJURCJThDJTIwJUQ5JTg1JUQ4JUFBJUQ4JUIxJTIyJTBBc2FtcGxpbmdfcGFyYW1zJTIwJTNEJTIwU2FtcGxpbmdQYXJhbXModGVtcGVyYXR1cmUlM0QwLjAlMkMlMjBtYXhfdG9rZW5zJTNENzUpJTBBcHJvbXB0JTIwJTNEJTIwZiUyMiU3QnVzZXJfcHJvbXB0X3RlbXBsYXRlJTdEJTIwJTdCcHJvbXB0JTdEJTdCcHJvZHVjdCU3RCU1Q24lMjAlN0JyZXNwb25zZV90ZW1wbGF0ZSU3RCUyMiUwQW91dHB1dHMlMjAlM0QlMjBsbG0uZ2VuZXJhdGUocHJvbXB0JTJDJTIwc2FtcGxpbmdfcGFyYW1zKSUwQSUwQXByaW50KG91dHB1dHMlNUIwJTVELm91dHB1dHMlNUIwJTVELnRleHQp",highlighted:`<span class="hljs-keyword">from</span> vllm <span class="hljs-keyword">import</span> LLM, SamplingParams

prompt = <span class="hljs-string">&quot;&quot;&quot;### Question: here is a product title from a Iranian marketplace.  \\n         give me the Product Entity and Attributes of this product in Persian language.\\n         give the output in this json format: {&#x27;attributes&#x27;: {&#x27;attribute_name&#x27; : &lt;attribute value&gt;, ...}, &#x27;product_entity&#x27;: &#x27;&lt;product entity&gt;&#x27;}.\\n         Don&#x27;t make assumptions about what values to plug into json. Just give Json not a single word more.\\n         \\nproduct title:&quot;&quot;&quot;</span>
user_prompt_template = <span class="hljs-string">&quot;### Question: &quot;</span>
response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>

llm = LLM(model=<span class="hljs-string">&quot;BaSalam/Llama2-7b-entity-attr-v1&quot;</span>, gpu_memory_utilization=<span class="hljs-number">0.9</span>, trust_remote_code=<span class="hljs-literal">True</span>)

product = <span class="hljs-string">&quot;مانتو اسپرت پانیذ قد جلوی کار حدودا 85 سانتی متر قد پشت کار حدودا 88 سانتی متر&quot;</span>
sampling_params = SamplingParams(temperature=<span class="hljs-number">0.0</span>, max_tokens=<span class="hljs-number">75</span>)
prompt = <span class="hljs-string">f&quot;<span class="hljs-subst">{user_prompt_template}</span> <span class="hljs-subst">{prompt}</span><span class="hljs-subst">{product}</span>\\n <span class="hljs-subst">{response_template}</span>&quot;</span>
outputs = llm.generate(prompt, sampling_params)

<span class="hljs-built_in">print</span>(outputs[<span class="hljs-number">0</span>].outputs[<span class="hljs-number">0</span>].text)`,wrap:!1}}),dl=new Jl({props:{title:"Example Output",local:"example-output",headingTag:"h3"}}),ul=new m({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYXR0cmlidXRlcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiVEOSU4MiVEOCVBRiUyMCVEOCVBQyVEOSU4NCVEOSU4OCVEQiU4QyUyMCVEQSVBOSVEOCVBNyVEOCVCMSUyMiUzQSUyMCUyMjg1JTIwJUQ4JUIzJUQ4JUE3JUQ5JTg2JUQ4JUFBJURCJThDJTIwJUQ5JTg1JUQ4JUFBJUQ4JUIxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJUQ5JTgyJUQ4JUFGJTIwJUQ5JUJFJUQ4JUI0JUQ4JUFBJTIwJURBJUE5JUQ4JUE3JUQ4JUIxJTIyJTNBJTIwJTIyODglMjAlRDglQjMlRDglQTclRDklODYlRDglQUElREIlOEMlMjAlRDklODUlRDglQUElRDglQjElMjIlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJwcm9kdWN0X2VudGl0eSUyMiUzQSUyMCUyMiVEOSU4NSVEOCVBNyVEOSU4NiVEOCVBQSVEOSU4OCUyMCVEOCVBNyVEOCVCMyVEOSVCRSVEOCVCMSVEOCVBQSUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;attributes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;قد جلوی کار&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;85 سانتی متر&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;قد پشت کار&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;88 سانتی متر&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;product_entity&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;مانتو اسپرت&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),hl=new lt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/fine_tuning_llm_to_generate_persian_product_catalogs_in_json_format.md"}}),{c(){h=d("meta"),bl=a(),Ul=d("p"),Tl=a(),p(J.$$.fragment),jl=a(),p(U.$$.fragment),fl=a(),w=d("p"),w.innerHTML=ge,gl=a(),b=d("p"),b.innerHTML=Ie,Il=a(),T=d("p"),T.innerHTML=Ce,Cl=a(),j=d("p"),j.textContent=Re,Rl=a(),p(f.$$.fragment),_l=a(),g=d("p"),g.innerHTML=_e,Zl=a(),p(I.$$.fragment),Xl=a(),p(C.$$.fragment),Bl=a(),p(R.$$.fragment),Gl=a(),_=d("p"),_.textContent=Ze,Vl=a(),Z=d("p"),Z.innerHTML=Xe,Ql=a(),p(X.$$.fragment),Wl=a(),B=d("p"),B.textContent=Be,kl=a(),G=d("p"),G.innerHTML=Ge,Fl=a(),p(V.$$.fragment),El=a(),p(Q.$$.fragment),Nl=a(),p(W.$$.fragment),$l=a(),p(k.$$.fragment),Al=a(),F=d("p"),F.textContent=Ve,Yl=a(),E=d("ul"),E.innerHTML=Qe,vl=a(),p(N.$$.fragment),zl=a(),$=d("p"),$.textContent=We,Sl=a(),A=d("ul"),A.innerHTML=ke,Hl=a(),Y=d("p"),Y.textContent=Fe,xl=a(),p(v.$$.fragment),ql=a(),p(z.$$.fragment),Ll=a(),p(S.$$.fragment),Dl=a(),H=d("p"),H.innerHTML=Ee,Ol=a(),p(x.$$.fragment),Kl=a(),p(q.$$.fragment),Pl=a(),p(L.$$.fragment),le=a(),D=d("p"),D.innerHTML=Ne,ee=a(),p(O.$$.fragment),te=a(),p(K.$$.fragment),se=a(),p(P.$$.fragment),ae=a(),p(ll.$$.fragment),ne=a(),p(el.$$.fragment),pe=a(),p(tl.$$.fragment),ie=a(),p(sl.$$.fragment),oe=a(),p(al.$$.fragment),re=a(),p(nl.$$.fragment),Me=a(),pl=d("p"),pl.textContent=$e,ce=a(),p(il.$$.fragment),me=a(),ol=d("p"),ol.textContent=Ae,de=a(),p(rl.$$.fragment),ue=a(),p(Ml.$$.fragment),ye=a(),cl=d("p"),cl.innerHTML=Ye,he=a(),p(ml.$$.fragment),Je=a(),p(dl.$$.fragment),Ue=a(),p(ul.$$.fragment),we=a(),yl=d("p"),yl.innerHTML=ve,be=a(),p(hl.$$.fragment),Te=a(),wl=d("p"),this.h()},l(l){const e=Oe("svelte-u9bgzb",document.head);h=u(e,"META",{name:!0,content:!0}),e.forEach(t),bl=n(l),Ul=u(l,"P",{}),ze(Ul).forEach(t),Tl=n(l),i(J.$$.fragment,l),jl=n(l),i(U.$$.fragment,l),fl=n(l),w=u(l,"P",{"data-svelte-h":!0}),y(w)!=="svelte-o7dign"&&(w.innerHTML=ge),gl=n(l),b=u(l,"P",{"data-svelte-h":!0}),y(b)!=="svelte-1g3gbfg"&&(b.innerHTML=Ie),Il=n(l),T=u(l,"P",{"data-svelte-h":!0}),y(T)!=="svelte-mfhn7k"&&(T.innerHTML=Ce),Cl=n(l),j=u(l,"P",{"data-svelte-h":!0}),y(j)!=="svelte-4b3xjd"&&(j.textContent=Re),Rl=n(l),i(f.$$.fragment,l),_l=n(l),g=u(l,"P",{"data-svelte-h":!0}),y(g)!=="svelte-19vh6bq"&&(g.innerHTML=_e),Zl=n(l),i(I.$$.fragment,l),Xl=n(l),i(C.$$.fragment,l),Bl=n(l),i(R.$$.fragment,l),Gl=n(l),_=u(l,"P",{"data-svelte-h":!0}),y(_)!=="svelte-yzu4o4"&&(_.textContent=Ze),Vl=n(l),Z=u(l,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-18s82z4"&&(Z.innerHTML=Xe),Ql=n(l),i(X.$$.fragment,l),Wl=n(l),B=u(l,"P",{"data-svelte-h":!0}),y(B)!=="svelte-di718e"&&(B.textContent=Be),kl=n(l),G=u(l,"P",{"data-svelte-h":!0}),y(G)!=="svelte-1dycqr8"&&(G.innerHTML=Ge),Fl=n(l),i(V.$$.fragment,l),El=n(l),i(Q.$$.fragment,l),Nl=n(l),i(W.$$.fragment,l),$l=n(l),i(k.$$.fragment,l),Al=n(l),F=u(l,"P",{"data-svelte-h":!0}),y(F)!=="svelte-1lg9t6r"&&(F.textContent=Ve),Yl=n(l),E=u(l,"UL",{"data-svelte-h":!0}),y(E)!=="svelte-k2o7br"&&(E.innerHTML=Qe),vl=n(l),i(N.$$.fragment,l),zl=n(l),$=u(l,"P",{"data-svelte-h":!0}),y($)!=="svelte-d6vihj"&&($.textContent=We),Sl=n(l),A=u(l,"UL",{"data-svelte-h":!0}),y(A)!=="svelte-14qvpe"&&(A.innerHTML=ke),Hl=n(l),Y=u(l,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-x1g2ni"&&(Y.textContent=Fe),xl=n(l),i(v.$$.fragment,l),ql=n(l),i(z.$$.fragment,l),Ll=n(l),i(S.$$.fragment,l),Dl=n(l),H=u(l,"P",{"data-svelte-h":!0}),y(H)!=="svelte-ozzu3c"&&(H.innerHTML=Ee),Ol=n(l),i(x.$$.fragment,l),Kl=n(l),i(q.$$.fragment,l),Pl=n(l),i(L.$$.fragment,l),le=n(l),D=u(l,"P",{"data-svelte-h":!0}),y(D)!=="svelte-eg8qz8"&&(D.innerHTML=Ne),ee=n(l),i(O.$$.fragment,l),te=n(l),i(K.$$.fragment,l),se=n(l),i(P.$$.fragment,l),ae=n(l),i(ll.$$.fragment,l),ne=n(l),i(el.$$.fragment,l),pe=n(l),i(tl.$$.fragment,l),ie=n(l),i(sl.$$.fragment,l),oe=n(l),i(al.$$.fragment,l),re=n(l),i(nl.$$.fragment,l),Me=n(l),pl=u(l,"P",{"data-svelte-h":!0}),y(pl)!=="svelte-qsgsjj"&&(pl.textContent=$e),ce=n(l),i(il.$$.fragment,l),me=n(l),ol=u(l,"P",{"data-svelte-h":!0}),y(ol)!=="svelte-suuhef"&&(ol.textContent=Ae),de=n(l),i(rl.$$.fragment,l),ue=n(l),i(Ml.$$.fragment,l),ye=n(l),cl=u(l,"P",{"data-svelte-h":!0}),y(cl)!=="svelte-1d85zth"&&(cl.innerHTML=Ye),he=n(l),i(ml.$$.fragment,l),Je=n(l),i(dl.$$.fragment,l),Ue=n(l),i(ul.$$.fragment,l),we=n(l),yl=u(l,"P",{"data-svelte-h":!0}),y(yl)!=="svelte-cd8kji"&&(yl.innerHTML=ve),be=n(l),i(hl.$$.fragment,l),Te=n(l),wl=u(l,"P",{}),ze(wl).forEach(t),this.h()},h(){Se(h,"name","hf:doc:metadata"),Se(h,"content",tt)},m(l,e){Ke(document.head,h),s(l,bl,e),s(l,Ul,e),s(l,Tl,e),o(J,l,e),s(l,jl,e),o(U,l,e),s(l,fl,e),s(l,w,e),s(l,gl,e),s(l,b,e),s(l,Il,e),s(l,T,e),s(l,Cl,e),s(l,j,e),s(l,Rl,e),o(f,l,e),s(l,_l,e),s(l,g,e),s(l,Zl,e),o(I,l,e),s(l,Xl,e),o(C,l,e),s(l,Bl,e),o(R,l,e),s(l,Gl,e),s(l,_,e),s(l,Vl,e),s(l,Z,e),s(l,Ql,e),o(X,l,e),s(l,Wl,e),s(l,B,e),s(l,kl,e),s(l,G,e),s(l,Fl,e),o(V,l,e),s(l,El,e),o(Q,l,e),s(l,Nl,e),o(W,l,e),s(l,$l,e),o(k,l,e),s(l,Al,e),s(l,F,e),s(l,Yl,e),s(l,E,e),s(l,vl,e),o(N,l,e),s(l,zl,e),s(l,$,e),s(l,Sl,e),s(l,A,e),s(l,Hl,e),s(l,Y,e),s(l,xl,e),o(v,l,e),s(l,ql,e),o(z,l,e),s(l,Ll,e),o(S,l,e),s(l,Dl,e),s(l,H,e),s(l,Ol,e),o(x,l,e),s(l,Kl,e),o(q,l,e),s(l,Pl,e),o(L,l,e),s(l,le,e),s(l,D,e),s(l,ee,e),o(O,l,e),s(l,te,e),o(K,l,e),s(l,se,e),o(P,l,e),s(l,ae,e),o(ll,l,e),s(l,ne,e),o(el,l,e),s(l,pe,e),o(tl,l,e),s(l,ie,e),o(sl,l,e),s(l,oe,e),o(al,l,e),s(l,re,e),o(nl,l,e),s(l,Me,e),s(l,pl,e),s(l,ce,e),o(il,l,e),s(l,me,e),s(l,ol,e),s(l,de,e),o(rl,l,e),s(l,ue,e),o(Ml,l,e),s(l,ye,e),s(l,cl,e),s(l,he,e),o(ml,l,e),s(l,Je,e),o(dl,l,e),s(l,Ue,e),o(ul,l,e),s(l,we,e),s(l,yl,e),s(l,be,e),o(hl,l,e),s(l,Te,e),s(l,wl,e),je=!0},p:xe,i(l){je||(r(J.$$.fragment,l),r(U.$$.fragment,l),r(f.$$.fragment,l),r(I.$$.fragment,l),r(C.$$.fragment,l),r(R.$$.fragment,l),r(X.$$.fragment,l),r(V.$$.fragment,l),r(Q.$$.fragment,l),r(W.$$.fragment,l),r(k.$$.fragment,l),r(N.$$.fragment,l),r(v.$$.fragment,l),r(z.$$.fragment,l),r(S.$$.fragment,l),r(x.$$.fragment,l),r(q.$$.fragment,l),r(L.$$.fragment,l),r(O.$$.fragment,l),r(K.$$.fragment,l),r(P.$$.fragment,l),r(ll.$$.fragment,l),r(el.$$.fragment,l),r(tl.$$.fragment,l),r(sl.$$.fragment,l),r(al.$$.fragment,l),r(nl.$$.fragment,l),r(il.$$.fragment,l),r(rl.$$.fragment,l),r(Ml.$$.fragment,l),r(ml.$$.fragment,l),r(dl.$$.fragment,l),r(ul.$$.fragment,l),r(hl.$$.fragment,l),je=!0)},o(l){M(J.$$.fragment,l),M(U.$$.fragment,l),M(f.$$.fragment,l),M(I.$$.fragment,l),M(C.$$.fragment,l),M(R.$$.fragment,l),M(X.$$.fragment,l),M(V.$$.fragment,l),M(Q.$$.fragment,l),M(W.$$.fragment,l),M(k.$$.fragment,l),M(N.$$.fragment,l),M(v.$$.fragment,l),M(z.$$.fragment,l),M(S.$$.fragment,l),M(x.$$.fragment,l),M(q.$$.fragment,l),M(L.$$.fragment,l),M(O.$$.fragment,l),M(K.$$.fragment,l),M(P.$$.fragment,l),M(ll.$$.fragment,l),M(el.$$.fragment,l),M(tl.$$.fragment,l),M(sl.$$.fragment,l),M(al.$$.fragment,l),M(nl.$$.fragment,l),M(il.$$.fragment,l),M(rl.$$.fragment,l),M(Ml.$$.fragment,l),M(ml.$$.fragment,l),M(dl.$$.fragment,l),M(ul.$$.fragment,l),M(hl.$$.fragment,l),je=!1},d(l){l&&(t(bl),t(Ul),t(Tl),t(jl),t(fl),t(w),t(gl),t(b),t(Il),t(T),t(Cl),t(j),t(Rl),t(_l),t(g),t(Zl),t(Xl),t(Bl),t(Gl),t(_),t(Vl),t(Z),t(Ql),t(Wl),t(B),t(kl),t(G),t(Fl),t(El),t(Nl),t($l),t(Al),t(F),t(Yl),t(E),t(vl),t(zl),t($),t(Sl),t(A),t(Hl),t(Y),t(xl),t(ql),t(Ll),t(Dl),t(H),t(Ol),t(Kl),t(Pl),t(le),t(D),t(ee),t(te),t(se),t(ae),t(ne),t(pe),t(ie),t(oe),t(re),t(Me),t(pl),t(ce),t(me),t(ol),t(de),t(ue),t(ye),t(cl),t(he),t(Je),t(Ue),t(we),t(yl),t(be),t(Te),t(wl)),t(h),c(J,l),c(U,l),c(f,l),c(I,l),c(C,l),c(R,l),c(X,l),c(V,l),c(Q,l),c(W,l),c(k,l),c(N,l),c(v,l),c(z,l),c(S,l),c(x,l),c(q,l),c(L,l),c(O,l),c(K,l),c(P,l),c(ll,l),c(el,l),c(tl,l),c(sl,l),c(al,l),c(nl,l),c(il,l),c(rl,l),c(Ml,l),c(ml,l),c(dl,l),c(ul,l),c(hl,l)}}}const tt='{"title":"Fine-tuning LLM to Generate Persian Product Catalogs in JSON Format","local":"fine-tuning-llm-to-generate-persian-product-catalogs-in-json-format","sections":[{"title":"Set hyperparameters","local":"set-hyperparameters","sections":[],"depth":2},{"title":"Model Training","local":"model-training","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"Merge to base model","local":"merge-to-base-model","sections":[],"depth":2},{"title":"Fast Inference with Vllm","local":"fast-inference-with-vllm","sections":[{"title":"Example Output","local":"example-output","sections":[],"depth":3}],"depth":2}],"depth":1}';function st(fe){return qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ot extends Le{constructor(h){super(),De(this,h,st,et,He,{})}}export{ot as component};
