import{s as qs,n as _s,o as $s}from"../chunks/scheduler.65852ee5.js";import{S as xs,i as Hs,g as M,s as n,r as o,A as Xs,h as i,f as s,c as a,j as Rs,u as p,x as y,k as Vs,y as zs,a as e,v as J,d as T,t as r,w as d}from"../chunks/index.65a1b999.js";import{D as Fs,C as w}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as j,E as Ds}from"../chunks/getInferenceSnippets.aa1f4ff5.js";function Ys(Dl){let U,Lt,vt,Et,c,Wt,u,Gt,I,Yl="This notebook implements a multi-agent system for managing product orders, inventory, and deliveries using:",Qt,m,Pl='<li><a href="https://github.com/huggingface/smolagents/tree/main" rel="nofollow">smolagents</a> for agent management</li> <li>MongoDB for data persistence</li> <li>DeepSeek Chat as the LLM model</li>',Nt,C,Rt,h,Ol='<li>Create a free MongoDB Atlas account at <a href="https://www.mongodb.com/cloud/atlas/register" rel="nofollow">https://www.mongodb.com/cloud/atlas/register</a></li> <li><a href="https://www.mongodb.com/docs/atlas/tutorial/create-new-cluster/" rel="nofollow">Create a new cluster</a> (free tier is sufficient)</li> <li>Configure network access by adding your IP address</li> <li>Create a database user with read/write permissions</li> <li>Get your connection string from Atlas UI (Click “Connect” &gt; “Connect your application”)</li> <li>Replace <code>&lt;password&gt;</code> in the connection string with your database user’s password</li> <li>Enable network access from your IP address in the Network Access settings</li>',Vt,A,qt,S,Kl="When working with MongoDB Atlas:",_t,g,ts="<li>Never commit connection strings with credentials to version control</li> <li>Use environment variables or secure secret management</li> <li>Restrict database user permissions to only what’s needed</li> <li>Enable IP allowlist in Atlas Network Access settings</li>",$t,b,xt,f,ls="First, let’s install required dependencies:",Ht,B,Xt,Z,zt,v,ss='Set in your secrets the <code>MONGODB_URI</code> and <code>DEEPSEEK_API_KEY</code> from <a href="https://www.deepseek.com/" rel="nofollow">https://www.deepseek.com/</a> (or any other LLM provider)',Ft,k,es="Import all required libraries and setup the LLM model:",Dt,L,Yt,E,Pt,W,ns="Create a MongoDB connection manager:",Ot,G,Kt,Q,tl,N,as="Our system implements three core tools for warehouse management:",ll,R,Ms="Workflow:",sl,V,el,q,is="Define tools for each agent type:",nl,_,al,$,Ml,x,il,H,yl,X,ys="This class implements a multi-agent architecture for order processing with the following components:",ol,z,os="<li>Inventory Agent: Handles stock checking and updates</li> <li>Order Agent: Manages order creation and documentation</li> <li>Delivery Agent: Controls order delivery status changes</li> <li>Manager Agent: Orchestrates workflow between other agents</li>",pl,F,ps="The system follows this process flow:",Jl,D,Js="<li>Create order documents for customer requests</li> <li>Verify and update product inventory levels</li> <li>Initialize delivery tracking status</li> <li>Coordinate agent interactions through the manager</li>",Tl,Y,Ts="Key Features:",rl,P,rs="<li>Asynchronous multi-agent coordination</li> <li>Automated inventory management</li> <li>Order status tracking</li> <li>Delivery pipeline integration</li>",dl,O,ds="Define the main system class that orchestrates all agents:",jl,K,wl,tt,Ul,lt,js="To test our order management system, we need to populate the MongoDB database with sample product data. The following section shows how to add test products with their prices and quantities. You can modify the product details or add more items by following the same structure. Each product has a unique ID, name, price, and initial stock quantity.",cl,st,ws="The sample data provides a representative mix of electronics products with varying price points and stock levels to demonstrate inventory tracking.",ul,et,Us="To test the system, you might want to add some sample products to MongoDB:",Il,nt,ml,at,cs=`Sample products added successfully!
`,Cl,Mt,hl,it,us="Here’s a markdown description of the test data approach:",Al,yt,Is="Testing Strategy Overview:",Sl,ot,ms="<li>We test with two different order scenarios:<ul><li>Multi-product order (laptop + smartphone)</li> <li>Single product order (headphones)</li></ul></li>",gl,pt,Cs="Test Data Design:",bl,Jt,hs="<li>Products represent common electronics at different price points</li> <li>Order quantities are intentionally small to avoid depleting stock</li> <li>Multiple delivery addresses to simulate real-world scenarios</li>",fl,Tt,As="Alternative Test Examples:",Bl,rt,Ss="<li>Bulk order: Multiple units of same product</li> <li>Mixed category order: Combination of high/low value items</li> <li>Edge cases: Orders near stock limits</li> <li>Invalid scenarios: Products with insufficient stock</li>",Zl,dt,gs="The test demonstrates:",vl,jt,bs="<li>Multi-product order processing</li> <li>Stock level management</li> <li>Delivery status updates</li> <li>Address handling for different locations</li>",kl,wt,fs="Let’s test our system with a sample order:",Ll,Ut,El,ct,Bs=`Orders processing result: Here’s the response to your request:

---

### **Processed Orders and Inventory Update**

1. **Orders Created**:
   - **Order 1**:
     - **Products**:
       - \`prod1\`: 2 units
       - \`prod2\`: 1 unit
     - **Delivery Address**: \`123 Main St\`
     - **Order ID**: \`677b8a9ff033af3a53c9a75a\`
   - **Order 2**:
     - **Products**:
       - \`prod3\`: 3 units
     - **Delivery Address**: \`456 Elm St\`
     - **Order ID**: \`677b8aa3f033af3a53c9a75c\`

2. **Inventory Updated**:
   - **\`prod1\` (Laptop)**:
     - Initial stock: 6 units
     - Subtracted: 2 units
     - New stock: 4 units
   - **\`prod2\` (Smartphone)**:
     - Initial stock: 13 units
     - Subtracted: 1 unit
     - New stock: 12 units
   - **\`prod3\` (Headphones)**:
     - Initial stock: 24 units
     - Subtracted: 3 units
     - New stock: 21 units

3. **Delivery Status**:
   - Both orders have been marked as **"in_transit"** and are ready for delivery.

---

### **Summary**:
- The orders have been successfully processed.
- The inventory has been updated to reflect the subtracted quantities.
- The delivery status for both orders is now **"in_transit"**.

Let me know if you need further assistance! 😊
`,Wl,ut,Gl,It,Zs="The system successfully completes these key actions:",Ql,mt,vs="<li><p>Order Creation:</p> <ul><li>Multiple orders processed in parallel</li> <li>Order IDs generated and stored in MongoDB</li> <li>Products and delivery addresses properly linked</li></ul></li> <li><p>Inventory Management:</p> <ul><li>Stock levels checked before order processing</li> <li>Quantities decremented after order confirmation</li> <li>Inventory updates reflected in MongoDB</li></ul></li> <li><p>Delivery Status:</p> <ul><li>Initial status set to “pending”</li> <li>Updated to “in_transit” after processing</li> <li>Status changes tracked in order documents</li></ul></li> <li><p>Data Consistency:</p> <ul><li>All MongoDB operations completed atomically</li> <li>Order details preserved accurately</li> <li>Stock levels maintained correctly</li></ul></li>",Nl,Ct,ks="When running the system, you might notice the agent attempting to interpret text output as Python code. This is an expected behavior of the CodeAgent as it tries to understand and process responses. After several attempts (max_iterations=10), it will stop if unsuccessful.",Rl,ht,Ls="Example agent behavior:",Vl,At,Es="<li>Receives text output from order creation</li> <li>Attempts to parse it as code</li> <li>Retries with different interpretations</li> <li>Eventually completes the workflow</li>",ql,St,Ws=`The multi-agent system demonstrates resilient operation through its error handling
and self-correction mechanisms. While initial attempts may produce error logs,
the agent successfully adapts through iterations. Most importantly, the final
state shows both successful order processing and accurate stock level updates,
maintaining data consistency despite any intermediate errors.`,_l,gt,Gs="This behavior is by design and doesn’t affect the system’s core functionality. The actual order processing, inventory updates, and delivery status changes are completed successfully through the MongoDB operations.",$l,bt,xl,ft,Qs="In this notebook, we have successfully implemented a multi-agent order management system using smolagents and MongoDB. We defined various tools for managing inventory, creating orders, and updating delivery statuses. We also created a main system class to orchestrate these agents and tested the system with sample data and orders.",Hl,Bt,Ns="This approach demonstrates the power of combining agent-based systems with robust data persistence solutions like MongoDB to create scalable and efficient order management systems.",Xl,Zt,zl,kt,Fl;return c=new Fs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/mongodb_smolagents_multi_micro_agents.ipynb"}]}}),u=new j({props:{title:"Multi-Agent Order Management System with MongoDB",local:"multi-agent-order-management-system-with-mongodb",headingTag:"h1"}}),C=new j({props:{title:"Setting Up MongoDB Atlas",local:"setting-up-mongodb-atlas",headingTag:"h2"}}),A=new j({props:{title:"Security Considerations",local:"security-considerations",headingTag:"h3"}}),b=new j({props:{title:"Setup",local:"setup",headingTag:"h2"}}),B=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIwcHltb25nbyUyMGxpdGVsbG0=",highlighted:"!pip install smolagents pymongo litellm",wrap:!1}}),Z=new j({props:{title:"Import Dependencies",local:"import-dependencies",headingTag:"h2"}}),L=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMuYWdlbnRzJTIwaW1wb3J0JTIwVG9vbENhbGxpbmdBZ2VudCUwQWZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwdG9vbCUyQyUyMExpdGVMTE1Nb2RlbCUyQyUyME1hbmFnZWRBZ2VudCUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBweW1vbmdvJTIwaW1wb3J0JTIwTW9uZ29DbGllbnQlMEFmcm9tJTIwZGF0ZXRpbWUlMjBpbXBvcnQlMjBkYXRldGltZSUwQWZyb20lMjBnb29nbGUuY29sYWIlMjBpbXBvcnQlMjB1c2VyZGF0YSUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBMaXN0JTJDJTIwRGljdCUyQyUyME9wdGlvbmFsJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMExMTSUyMG1vZGVsJTBBTU9ERUxfSUQlMjAlM0QlMjAlMjJkZWVwc2VlayUyRmRlZXBzZWVrLWNoYXQlMjIlMEFNT05HT0RCX1VSSSUyMCUzRCUyMHVzZXJkYXRhLmdldCglMjJNT05HT19VUkklMjIpJTBBREVFUFNFRUtfQVBJX0tFWSUyMCUzRCUyMHVzZXJkYXRhLmdldCglMjJERUVQU0VFS19BUElfS0VZJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents.agents <span class="hljs-keyword">import</span> ToolCallingAgent
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool, LiteLLMModel, ManagedAgent, CodeAgent
<span class="hljs-keyword">from</span> pymongo <span class="hljs-keyword">import</span> MongoClient
<span class="hljs-keyword">from</span> datetime <span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">from</span> google.colab <span class="hljs-keyword">import</span> userdata
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Optional</span>

<span class="hljs-comment"># Initialize LLM model</span>
MODEL_ID = <span class="hljs-string">&quot;deepseek/deepseek-chat&quot;</span>
MONGODB_URI = userdata.get(<span class="hljs-string">&quot;MONGO_URI&quot;</span>)
DEEPSEEK_API_KEY = userdata.get(<span class="hljs-string">&quot;DEEPSEEK_API_KEY&quot;</span>)`,wrap:!1}}),E=new j({props:{title:"Database Connection Class",local:"database-connection-class",headingTag:"h2"}}),G=new w({props:{code:"bW9uZ29jbGllbnQlMjAlM0QlMjBNb25nb0NsaWVudChNT05HT0RCX1VSSSUyQyUyMGFwcG5hbWUlM0QlMjJkZXZyZWwuc2hvd2Nhc2UubXVsdGktc21vbGFnZW50cyUyMiklMEFkYiUyMCUzRCUyMG1vbmdvY2xpZW50LndhcmVob3VzZQ==",highlighted:`mongoclient = MongoClient(MONGODB_URI, appname=<span class="hljs-string">&quot;devrel.showcase.multi-smolagents&quot;</span>)
db = mongoclient.warehouse`,wrap:!1}}),Q=new j({props:{title:"Agent Tools Defenitions",local:"agent-tools-defenitions",headingTag:"h2"}}),V=new w({props:{code:"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",highlighted:`<span class="hljs-section">Inventory Management Tools:
+-------------------+-------------------+</span>
<span class="hljs-section">| Tool              | Description       |
+-------------------+-------------------+</span>
| check<span class="hljs-emphasis">_stock       | Queries stock     |
|                   | levels            |
+-------------------+-------------------+
| update_</span>stock      | Adjusts inventory |
<span class="hljs-section">|                   | quantities        |
+-------------------+-------------------+</span>

<span class="hljs-section">Order Management Tools:
+-------------------+-------------------+</span>
<span class="hljs-section">| Tool              | Description       |
+-------------------+-------------------+</span>
| create_order      | Creates new order |
<span class="hljs-section">|                   | document          |
+-------------------+-------------------+</span>

<span class="hljs-section">Delivery Management Tools:
+-------------------+-------------------+</span>
<span class="hljs-section">| Tool              | Description       |
+-------------------+-------------------+</span>
| update<span class="hljs-emphasis">_delivery   | Updates delivery  |
| _</span>status           | status            |
<span class="hljs-code">+-------------------+</span>-------------------+

<span class="hljs-section">Decision Flow:
+-------------------+-------------------+</span>
<span class="hljs-section">| Step              | Action            |
+-------------------+-------------------+</span>
| 1. Create Order   | Uses <span class="hljs-code">\`create_order\`</span>|
|                   | tool to create    |
<span class="hljs-section">|                   | order document    |
+-------------------+-------------------+</span>
| 2. Update Stock   | Uses <span class="hljs-code">\`update_stock\`</span>|
|                   | tool to adjust    |
<span class="hljs-section">|                   | inventory         |
+-------------------+-------------------+</span>
| 3. Update Delivery| Uses <span class="hljs-code">\`update_delivery\`</span>|
| Status            | <span class="hljs-emphasis">_status tool to   |
|                   | set delivery      |
|                   | status to         |
|                   | \`in_</span>transit\`      |
<span class="hljs-code">+-------------------+</span>-------------------+`,wrap:!1}}),_=new w({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNoZWNrX3N0b2NrKHByb2R1Y3RfaWQlM0ElMjBzdHIpJTIwLSUzRSUyMERpY3QlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJRdWVyeSUyMHByb2R1Y3QlMjBzdG9jayUyMGxldmVsLiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9kdWN0X2lkJTNBJTIwUHJvZHVjdCUyMGlkZW50aWZpZXIlMEElMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGljdCUyMGNvbnRhaW5pbmclMjBwcm9kdWN0JTIwZGV0YWlscyUyMGFuZCUyMHF1YW50aXR5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGIucHJvZHVjdHMuZmluZF9vbmUoJTdCJTIyX2lkJTIyJTNBJTIwcHJvZHVjdF9pZCU3RCklMEElMEElMEElNDB0b29sJTBBZGVmJTIwdXBkYXRlX3N0b2NrKHByb2R1Y3RfaWQlM0ElMjBzdHIlMkMlMjBxdWFudGl0eSUzQSUyMGludCklMjAtJTNFJTIwYm9vbCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlVwZGF0ZSUyMHByb2R1Y3QlMjBzdG9jayUyMHF1YW50aXR5LiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9kdWN0X2lkJTNBJTIwUHJvZHVjdCUyMGlkZW50aWZpZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWFudGl0eSUzQSUyMEFtb3VudCUyMHRvJTIwZGVjcmVhc2UlMjBmcm9tJTIwc3RvY2slMEElMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm9vbCUzQSUyMFN1Y2Nlc3MlMjBzdGF0dXMlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBkYi5wcm9kdWN0cy51cGRhdGVfb25lKCU3QiUyMl9pZCUyMiUzQSUyMHByb2R1Y3RfaWQlN0QlMkMlMjAlN0IlMjIlMjRpbmMlMjIlM0ElMjAlN0IlMjJxdWFudGl0eSUyMiUzQSUyMC1xdWFudGl0eSU3RCU3RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXN1bHQubW9kaWZpZWRfY291bnQlMjAlM0UlMjAw",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_stock</span>(<span class="hljs-params">product_id: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>:
    <span class="hljs-string">&quot;&quot;&quot;Query product stock level.

    Args:
        product_id: Product identifier

    Returns:
        Dict containing product details and quantity
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> db.products.find_one({<span class="hljs-string">&quot;_id&quot;</span>: product_id})


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">update_stock</span>(<span class="hljs-params">product_id: <span class="hljs-built_in">str</span>, quantity: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">bool</span>:
    <span class="hljs-string">&quot;&quot;&quot;Update product stock quantity.

    Args:
        product_id: Product identifier
        quantity: Amount to decrease from stock

    Returns:
        bool: Success status
    &quot;&quot;&quot;</span>
    result = db.products.update_one({<span class="hljs-string">&quot;_id&quot;</span>: product_id}, {<span class="hljs-string">&quot;$inc&quot;</span>: {<span class="hljs-string">&quot;quantity&quot;</span>: -quantity}})
    <span class="hljs-keyword">return</span> result.modified_count &gt; <span class="hljs-number">0</span>`,wrap:!1}}),$=new w({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNyZWF0ZV9vcmRlcihwcm9kdWN0cyUzQSUyMGFueSUyQyUyMGFkZHJlc3MlM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkNyZWF0ZSUyMG5ldyUyMG9yZGVyJTIwZm9yJTIwYWxsJTIwcHJvdmlkZWQlMjBwcm9kdWN0cy4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvZHVjdHMlM0ElMjBMaXN0JTIwb2YlMjBwcm9kdWN0cyUyMHdpdGglMjBxdWFudGl0aWVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWRkcmVzcyUzQSUyMERlbGl2ZXJ5JTIwYWRkcmVzcyUwQSUwQSUyMCUyMCUyMCUyMFJldHVybnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHIlM0ElMjBPcmRlciUyMElEJTIwbWVzc2FnZSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMG9yZGVyJTIwJTNEJTIwJTdCJTIycHJvZHVjdHMlMjIlM0ElMjBwcm9kdWN0cyUyQyUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMnBlbmRpbmclMjIlMkMlMjAlMjJkZWxpdmVyeV9hZGRyZXNzJTIyJTNBJTIwYWRkcmVzcyUyQyUyMCUyMmNyZWF0ZWRfYXQlMjIlM0ElMjBkYXRldGltZS5ub3coKSU3RCUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGRiLm9yZGVycy5pbnNlcnRfb25lKG9yZGVyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJTdWNjZXNzZnVsbHklMjBvcmRlcmVkJTIwJTNBJTIwJTdCc3RyKHJlc3VsdC5pbnNlcnRlZF9pZCklN0QlMjI=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_order</span>(<span class="hljs-params">products: <span class="hljs-built_in">any</span>, address: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Create new order for all provided products.

    Args:
        products: List of products with quantities
        address: Delivery address

    Returns:
        str: Order ID message
    &quot;&quot;&quot;</span>
    order = {<span class="hljs-string">&quot;products&quot;</span>: products, <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;pending&quot;</span>, <span class="hljs-string">&quot;delivery_address&quot;</span>: address, <span class="hljs-string">&quot;created_at&quot;</span>: datetime.now()}
    result = db.orders.insert_one(order)
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Successfully ordered : <span class="hljs-subst">{<span class="hljs-built_in">str</span>(result.inserted_id)}</span>&quot;</span>`,wrap:!1}}),x=new w({props:{code:"ZnJvbSUyMGJzb24ub2JqZWN0aWQlMjBpbXBvcnQlMjBPYmplY3RJZCUwQSUwQSUwQSU0MHRvb2wlMEFkZWYlMjB1cGRhdGVfZGVsaXZlcnlfc3RhdHVzKG9yZGVyX2lkJTNBJTIwc3RyJTJDJTIwc3RhdHVzJTNBJTIwc3RyKSUyMC0lM0UlMjBib29sJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyVXBkYXRlJTIwb3JkZXIlMjBkZWxpdmVyeSUyMHN0YXR1cyUyMHRvJTIwaW5fdHJhbnNpdCUyMG9uY2UlMjBhJTIwcGVuZGluZyUyMG9yZGVyJTIwaXMlMjBwcm92aWRlZCUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcmRlcl9pZCUzQSUyME9yZGVyJTIwaWRlbnRpZmllciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXR1cyUzQSUyME5ldyUyMGRlbGl2ZXJ5JTIwc3RhdHVzJTIwaXMlMjBiZWluZyUyMHNldCUyMHRvJTIwaW5fdHJhbnNpdCUyMG9yJTIwZGVsaXZlcmVkJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJvb2wlM0ElMjBTdWNjZXNzJTIwc3RhdHVzJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBzdGF0dXMlMjBub3QlMjBpbiUyMCU1QiUyMnBlbmRpbmclMjIlMkMlMjAlMjJpbl90cmFuc2l0JTIyJTJDJTIwJTIyZGVsaXZlcmVkJTIyJTJDJTIwJTIyY2FuY2VsbGVkJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBWYWx1ZUVycm9yKCUyMkludmFsaWQlMjBkZWxpdmVyeSUyMHN0YXR1cyUyMiklMEElMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBkYi5vcmRlcnMudXBkYXRlX29uZSglN0IlMjJfaWQlMjIlM0ElMjBPYmplY3RJZChvcmRlcl9pZCklMkMlMjAlMjJzdGF0dXMlMjIlM0ElMjAlMjJwZW5kaW5nJTIyJTdEJTJDJTIwJTdCJTIyJTI0c2V0JTIyJTNBJTIwJTdCJTIyc3RhdHVzJTIyJTNBJTIwc3RhdHVzJTdEJTdEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3VsdC5tb2RpZmllZF9jb3VudCUyMCUzRSUyMDA=",highlighted:`<span class="hljs-keyword">from</span> bson.objectid <span class="hljs-keyword">import</span> ObjectId


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">update_delivery_status</span>(<span class="hljs-params">order_id: <span class="hljs-built_in">str</span>, status: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">bool</span>:
    <span class="hljs-string">&quot;&quot;&quot;Update order delivery status to in_transit once a pending order is provided

    Args:
        order_id: Order identifier
        status: New delivery status is being set to in_transit or delivered

    Returns:
        bool: Success status
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> status <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;pending&quot;</span>, <span class="hljs-string">&quot;in_transit&quot;</span>, <span class="hljs-string">&quot;delivered&quot;</span>, <span class="hljs-string">&quot;cancelled&quot;</span>]:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Invalid delivery status&quot;</span>)

    result = db.orders.update_one({<span class="hljs-string">&quot;_id&quot;</span>: ObjectId(order_id), <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;pending&quot;</span>}, {<span class="hljs-string">&quot;$set&quot;</span>: {<span class="hljs-string">&quot;status&quot;</span>: status}})
    <span class="hljs-keyword">return</span> result.modified_count &gt; <span class="hljs-number">0</span>`,wrap:!1}}),H=new j({props:{title:"Main Order Management System",local:"main-order-management-system",headingTag:"h2"}}),K=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">OrderManagementSystem</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multi-agent order management system&quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_id: <span class="hljs-built_in">str</span> = MODEL_ID</span>):
        self.model = LiteLLMModel(model_id=model_id, api_key=DEEPSEEK_API_KEY)

        <span class="hljs-comment"># Create agents</span>
        self.inventory_agent = ToolCallingAgent(tools=[check_stock, update_stock], model=self.model, max_iterations=<span class="hljs-number">10</span>)

        self.order_agent = ToolCallingAgent(tools=[create_order], model=self.model, max_iterations=<span class="hljs-number">10</span>)

        self.delivery_agent = ToolCallingAgent(tools=[update_delivery_status], model=self.model, max_iterations=<span class="hljs-number">10</span>)

        <span class="hljs-comment"># Create managed agents</span>
        self.managed_agents = [
            ManagedAgent(self.inventory_agent, <span class="hljs-string">&quot;inventory&quot;</span>, <span class="hljs-string">&quot;Manages product inventory&quot;</span>),
            ManagedAgent(self.order_agent, <span class="hljs-string">&quot;orders&quot;</span>, <span class="hljs-string">&quot;Handles order creation&quot;</span>),
            ManagedAgent(self.delivery_agent, <span class="hljs-string">&quot;delivery&quot;</span>, <span class="hljs-string">&quot;Manages delivery status&quot;</span>),
        ]

        <span class="hljs-comment"># Create manager agent</span>
        self.manager = CodeAgent(
            tools=[],
            system_prompt=<span class="hljs-string">&quot;&quot;&quot;For each order:
            1. Create the order document
            2. Update the inventory
            3. Set deliviery status to in_transit

            Use relevant agents:  {{managed_agents_descriptions}}  and you can use {{authorized_imports}}
            &quot;&quot;&quot;</span>,
            model=self.model,
            managed_agents=self.managed_agents,
            additional_authorized_imports=[<span class="hljs-string">&quot;time&quot;</span>, <span class="hljs-string">&quot;json&quot;</span>],
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">process_order</span>(<span class="hljs-params">self, orders: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>]</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Process a set of orders.

        Args:
            orders: List of orders each has address and products

        Returns:
            str: Processing result
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.manager.run(
            <span class="hljs-string">f&quot;Process the following  <span class="hljs-subst">{orders}</span> as well as substract the ordered items from inventory.&quot;</span>
            <span class="hljs-string">f&quot;to be delivered to relevant addresses&quot;</span>
        )`,wrap:!1}}),tt=new j({props:{title:"Adding Sample Data",local:"adding-sample-data",headingTag:"h2"}}),nt=new w({props:{code:"ZGVmJTIwYWRkX3NhbXBsZV9wcm9kdWN0cygpJTNBJTBBJTIwJTIwJTIwJTIwZGIucHJvZHVjdHMuZGVsZXRlX21hbnkoJTdCJTdEKSUwQSUyMCUyMCUyMCUyMHNhbXBsZV9wcm9kdWN0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMl9pZCUyMiUzQSUyMCUyMnByb2QxJTIyJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMkxhcHRvcCUyMiUyQyUyMCUyMnByaWNlJTIyJTNBJTIwOTk5Ljk5JTJDJTIwJTIycXVhbnRpdHklMjIlM0ElMjAxMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMl9pZCUyMiUzQSUyMCUyMnByb2QyJTIyJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMlNtYXJ0cGhvbmUlMjIlMkMlMjAlMjJwcmljZSUyMiUzQSUyMDU5OS45OSUyQyUyMCUyMnF1YW50aXR5JTIyJTNBJTIwMTUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJfaWQlMjIlM0ElMjAlMjJwcm9kMyUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJIZWFkcGhvbmVzJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjA5OS45OSUyQyUyMCUyMnF1YW50aXR5JTIyJTNBJTIwMzAlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjBkYi5wcm9kdWN0cy5pbnNlcnRfbWFueShzYW1wbGVfcHJvZHVjdHMpJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyU2FtcGxlJTIwcHJvZHVjdHMlMjBhZGRlZCUyMHN1Y2Nlc3NmdWxseSElMjIpJTBBJTBBJTBBJTIzJTIwVW5jb21tZW50JTIwdG8lMjBhZGQlMjBzYW1wbGUlMjBwcm9kdWN0cyUwQWFkZF9zYW1wbGVfcHJvZHVjdHMoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">add_sample_products</span>():
<span class="hljs-meta">... </span>    db.products.delete_many({})
<span class="hljs-meta">... </span>    sample_products = [
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;_id&quot;</span>: <span class="hljs-string">&quot;prod1&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Laptop&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">999.99</span>, <span class="hljs-string">&quot;quantity&quot;</span>: <span class="hljs-number">10</span>},
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;_id&quot;</span>: <span class="hljs-string">&quot;prod2&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Smartphone&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">599.99</span>, <span class="hljs-string">&quot;quantity&quot;</span>: <span class="hljs-number">15</span>},
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;_id&quot;</span>: <span class="hljs-string">&quot;prod3&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Headphones&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">99.99</span>, <span class="hljs-string">&quot;quantity&quot;</span>: <span class="hljs-number">30</span>},
<span class="hljs-meta">... </span>    ]

<span class="hljs-meta">... </span>    db.products.insert_many(sample_products)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample products added successfully!&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Uncomment to add sample products</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>add_sample_products()`,wrap:!1}}),Mt=new j({props:{title:"Testing the System",local:"testing-the-system",headingTag:"h2"}}),Ut=new w({props:{code:"JTIzJTIwSW5pdGlhbGl6ZSUyMHN5c3RlbSUwQXN5c3RlbSUyMCUzRCUyME9yZGVyTWFuYWdlbWVudFN5c3RlbSgpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGVzdCUyMG9yZGVycyUwQXRlc3Rfb3JkZXJzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvZHVjdHMlMjIlM0ElMjAlNUIlN0IlMjJwcm9kdWN0X2lkJTIyJTNBJTIwJTIycHJvZDElMjIlMkMlMjAlMjJxdWFudGl0eSUyMiUzQSUyMDIlN0QlMkMlMjAlN0IlMjJwcm9kdWN0X2lkJTIyJTNBJTIwJTIycHJvZDIlMjIlMkMlMjAlMjJxdWFudGl0eSUyMiUzQSUyMDElN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhZGRyZXNzJTIyJTNBJTIwJTIyMTIzJTIwTWFpbiUyMFN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycHJvZHVjdHMlMjIlM0ElMjAlNUIlN0IlMjJwcm9kdWN0X2lkJTIyJTNBJTIwJTIycHJvZDMlMjIlMkMlMjAlMjJxdWFudGl0eSUyMiUzQSUyMDMlN0QlNUQlMkMlMjAlMjJhZGRyZXNzJTIyJTNBJTIwJTIyNDU2JTIwRWxtJTIwU3QlMjIlN0QlMkMlMEElNUQlMEElMEElMjMlMjBQcm9jZXNzJTIwb3JkZXIlMEFyZXN1bHQlMjAlM0QlMjBzeXN0ZW0ucHJvY2Vzc19vcmRlcihvcmRlcnMlM0R0ZXN0X29yZGVycyklMEElMEFwcmludCglMjJPcmRlcnMlMjBwcm9jZXNzaW5nJTIwcmVzdWx0JTNBJTIyJTJDJTIwcmVzdWx0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>system = OrderManagementSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create test orders</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>test_orders = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;products&quot;</span>: [{<span class="hljs-string">&quot;product_id&quot;</span>: <span class="hljs-string">&quot;prod1&quot;</span>, <span class="hljs-string">&quot;quantity&quot;</span>: <span class="hljs-number">2</span>}, {<span class="hljs-string">&quot;product_id&quot;</span>: <span class="hljs-string">&quot;prod2&quot;</span>, <span class="hljs-string">&quot;quantity&quot;</span>: <span class="hljs-number">1</span>}],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;address&quot;</span>: <span class="hljs-string">&quot;123 Main St&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;products&quot;</span>: [{<span class="hljs-string">&quot;product_id&quot;</span>: <span class="hljs-string">&quot;prod3&quot;</span>, <span class="hljs-string">&quot;quantity&quot;</span>: <span class="hljs-number">3</span>}], <span class="hljs-string">&quot;address&quot;</span>: <span class="hljs-string">&quot;456 Elm St&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Process order</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = system.process_order(orders=test_orders)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Orders processing result:&quot;</span>, result)`,wrap:!1}}),ut=new j({props:{title:"System Output Analysis",local:"system-output-analysis",headingTag:"h2"}}),bt=new j({props:{title:"Conclusions",local:"conclusions",headingTag:"h2"}}),Zt=new Ds({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/mongodb_smolagents_multi_micro_agents.md"}}),{c(){U=M("meta"),Lt=n(),vt=M("p"),Et=n(),o(c.$$.fragment),Wt=n(),o(u.$$.fragment),Gt=n(),I=M("p"),I.textContent=Yl,Qt=n(),m=M("ul"),m.innerHTML=Pl,Nt=n(),o(C.$$.fragment),Rt=n(),h=M("ol"),h.innerHTML=Ol,Vt=n(),o(A.$$.fragment),qt=n(),S=M("p"),S.textContent=Kl,_t=n(),g=M("ul"),g.innerHTML=ts,$t=n(),o(b.$$.fragment),xt=n(),f=M("p"),f.textContent=ls,Ht=n(),o(B.$$.fragment),Xt=n(),o(Z.$$.fragment),zt=n(),v=M("p"),v.innerHTML=ss,Ft=n(),k=M("p"),k.textContent=es,Dt=n(),o(L.$$.fragment),Yt=n(),o(E.$$.fragment),Pt=n(),W=M("p"),W.textContent=ns,Ot=n(),o(G.$$.fragment),Kt=n(),o(Q.$$.fragment),tl=n(),N=M("p"),N.textContent=as,ll=n(),R=M("p"),R.textContent=Ms,sl=n(),o(V.$$.fragment),el=n(),q=M("p"),q.textContent=is,nl=n(),o(_.$$.fragment),al=n(),o($.$$.fragment),Ml=n(),o(x.$$.fragment),il=n(),o(H.$$.fragment),yl=n(),X=M("p"),X.textContent=ys,ol=n(),z=M("ul"),z.innerHTML=os,pl=n(),F=M("p"),F.textContent=ps,Jl=n(),D=M("ol"),D.innerHTML=Js,Tl=n(),Y=M("p"),Y.textContent=Ts,rl=n(),P=M("ul"),P.innerHTML=rs,dl=n(),O=M("p"),O.textContent=ds,jl=n(),o(K.$$.fragment),wl=n(),o(tt.$$.fragment),Ul=n(),lt=M("p"),lt.textContent=js,cl=n(),st=M("p"),st.textContent=ws,ul=n(),et=M("p"),et.textContent=Us,Il=n(),o(nt.$$.fragment),ml=n(),at=M("pre"),at.textContent=cs,Cl=n(),o(Mt.$$.fragment),hl=n(),it=M("p"),it.textContent=us,Al=n(),yt=M("p"),yt.textContent=Is,Sl=n(),ot=M("ol"),ot.innerHTML=ms,gl=n(),pt=M("p"),pt.textContent=Cs,bl=n(),Jt=M("ul"),Jt.innerHTML=hs,fl=n(),Tt=M("p"),Tt.textContent=As,Bl=n(),rt=M("ul"),rt.innerHTML=Ss,Zl=n(),dt=M("p"),dt.textContent=gs,vl=n(),jt=M("ul"),jt.innerHTML=bs,kl=n(),wt=M("p"),wt.textContent=fs,Ll=n(),o(Ut.$$.fragment),El=n(),ct=M("pre"),ct.textContent=Bs,Wl=n(),o(ut.$$.fragment),Gl=n(),It=M("p"),It.textContent=Zs,Ql=n(),mt=M("ol"),mt.innerHTML=vs,Nl=n(),Ct=M("p"),Ct.textContent=ks,Rl=n(),ht=M("p"),ht.textContent=Ls,Vl=n(),At=M("ol"),At.innerHTML=Es,ql=n(),St=M("p"),St.textContent=Ws,_l=n(),gt=M("p"),gt.textContent=Gs,$l=n(),o(bt.$$.fragment),xl=n(),ft=M("p"),ft.textContent=Qs,Hl=n(),Bt=M("p"),Bt.textContent=Ns,Xl=n(),o(Zt.$$.fragment),zl=n(),kt=M("p"),this.h()},l(t){const l=Xs("svelte-u9bgzb",document.head);U=i(l,"META",{name:!0,content:!0}),l.forEach(s),Lt=a(t),vt=i(t,"P",{}),Rs(vt).forEach(s),Et=a(t),p(c.$$.fragment,t),Wt=a(t),p(u.$$.fragment,t),Gt=a(t),I=i(t,"P",{"data-svelte-h":!0}),y(I)!=="svelte-pv9nv4"&&(I.textContent=Yl),Qt=a(t),m=i(t,"UL",{"data-svelte-h":!0}),y(m)!=="svelte-1108i8y"&&(m.innerHTML=Pl),Nt=a(t),p(C.$$.fragment,t),Rt=a(t),h=i(t,"OL",{"data-svelte-h":!0}),y(h)!=="svelte-1t9sx1r"&&(h.innerHTML=Ol),Vt=a(t),p(A.$$.fragment,t),qt=a(t),S=i(t,"P",{"data-svelte-h":!0}),y(S)!=="svelte-kw8y8a"&&(S.textContent=Kl),_t=a(t),g=i(t,"UL",{"data-svelte-h":!0}),y(g)!=="svelte-1xl8b3t"&&(g.innerHTML=ts),$t=a(t),p(b.$$.fragment,t),xt=a(t),f=i(t,"P",{"data-svelte-h":!0}),y(f)!=="svelte-nwwhg"&&(f.textContent=ls),Ht=a(t),p(B.$$.fragment,t),Xt=a(t),p(Z.$$.fragment,t),zt=a(t),v=i(t,"P",{"data-svelte-h":!0}),y(v)!=="svelte-1kg1686"&&(v.innerHTML=ss),Ft=a(t),k=i(t,"P",{"data-svelte-h":!0}),y(k)!=="svelte-nkgjxn"&&(k.textContent=es),Dt=a(t),p(L.$$.fragment,t),Yt=a(t),p(E.$$.fragment,t),Pt=a(t),W=i(t,"P",{"data-svelte-h":!0}),y(W)!=="svelte-13trwya"&&(W.textContent=ns),Ot=a(t),p(G.$$.fragment,t),Kt=a(t),p(Q.$$.fragment,t),tl=a(t),N=i(t,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1ksfafa"&&(N.textContent=as),ll=a(t),R=i(t,"P",{"data-svelte-h":!0}),y(R)!=="svelte-tpm4jt"&&(R.textContent=Ms),sl=a(t),p(V.$$.fragment,t),el=a(t),q=i(t,"P",{"data-svelte-h":!0}),y(q)!=="svelte-m415tj"&&(q.textContent=is),nl=a(t),p(_.$$.fragment,t),al=a(t),p($.$$.fragment,t),Ml=a(t),p(x.$$.fragment,t),il=a(t),p(H.$$.fragment,t),yl=a(t),X=i(t,"P",{"data-svelte-h":!0}),y(X)!=="svelte-1b4otdh"&&(X.textContent=ys),ol=a(t),z=i(t,"UL",{"data-svelte-h":!0}),y(z)!=="svelte-10ywi02"&&(z.innerHTML=os),pl=a(t),F=i(t,"P",{"data-svelte-h":!0}),y(F)!=="svelte-87kfe1"&&(F.textContent=ps),Jl=a(t),D=i(t,"OL",{"data-svelte-h":!0}),y(D)!=="svelte-bspmzg"&&(D.innerHTML=Js),Tl=a(t),Y=i(t,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-1adc5s0"&&(Y.textContent=Ts),rl=a(t),P=i(t,"UL",{"data-svelte-h":!0}),y(P)!=="svelte-pu7ouq"&&(P.innerHTML=rs),dl=a(t),O=i(t,"P",{"data-svelte-h":!0}),y(O)!=="svelte-gzjqwh"&&(O.textContent=ds),jl=a(t),p(K.$$.fragment,t),wl=a(t),p(tt.$$.fragment,t),Ul=a(t),lt=i(t,"P",{"data-svelte-h":!0}),y(lt)!=="svelte-skvvoh"&&(lt.textContent=js),cl=a(t),st=i(t,"P",{"data-svelte-h":!0}),y(st)!=="svelte-308bd7"&&(st.textContent=ws),ul=a(t),et=i(t,"P",{"data-svelte-h":!0}),y(et)!=="svelte-10gr0a8"&&(et.textContent=Us),Il=a(t),p(nt.$$.fragment,t),ml=a(t),at=i(t,"PRE",{"data-svelte-h":!0}),y(at)!=="svelte-reill2"&&(at.textContent=cs),Cl=a(t),p(Mt.$$.fragment,t),hl=a(t),it=i(t,"P",{"data-svelte-h":!0}),y(it)!=="svelte-kd1hkk"&&(it.textContent=us),Al=a(t),yt=i(t,"P",{"data-svelte-h":!0}),y(yt)!=="svelte-108fun2"&&(yt.textContent=Is),Sl=a(t),ot=i(t,"OL",{"data-svelte-h":!0}),y(ot)!=="svelte-9s5awp"&&(ot.innerHTML=ms),gl=a(t),pt=i(t,"P",{"data-svelte-h":!0}),y(pt)!=="svelte-1sxzyao"&&(pt.textContent=Cs),bl=a(t),Jt=i(t,"UL",{"data-svelte-h":!0}),y(Jt)!=="svelte-1ktquui"&&(Jt.innerHTML=hs),fl=a(t),Tt=i(t,"P",{"data-svelte-h":!0}),y(Tt)!=="svelte-ic4hd6"&&(Tt.textContent=As),Bl=a(t),rt=i(t,"UL",{"data-svelte-h":!0}),y(rt)!=="svelte-16hw8nq"&&(rt.innerHTML=Ss),Zl=a(t),dt=i(t,"P",{"data-svelte-h":!0}),y(dt)!=="svelte-1gjdgnm"&&(dt.textContent=gs),vl=a(t),jt=i(t,"UL",{"data-svelte-h":!0}),y(jt)!=="svelte-1vmat7s"&&(jt.innerHTML=bs),kl=a(t),wt=i(t,"P",{"data-svelte-h":!0}),y(wt)!=="svelte-dyhdx3"&&(wt.textContent=fs),Ll=a(t),p(Ut.$$.fragment,t),El=a(t),ct=i(t,"PRE",{"data-svelte-h":!0}),y(ct)!=="svelte-do4fzt"&&(ct.textContent=Bs),Wl=a(t),p(ut.$$.fragment,t),Gl=a(t),It=i(t,"P",{"data-svelte-h":!0}),y(It)!=="svelte-63ycws"&&(It.textContent=Zs),Ql=a(t),mt=i(t,"OL",{"data-svelte-h":!0}),y(mt)!=="svelte-bbxga9"&&(mt.innerHTML=vs),Nl=a(t),Ct=i(t,"P",{"data-svelte-h":!0}),y(Ct)!=="svelte-1isw8dg"&&(Ct.textContent=ks),Rl=a(t),ht=i(t,"P",{"data-svelte-h":!0}),y(ht)!=="svelte-1ym17yf"&&(ht.textContent=Ls),Vl=a(t),At=i(t,"OL",{"data-svelte-h":!0}),y(At)!=="svelte-pmcruk"&&(At.innerHTML=Es),ql=a(t),St=i(t,"P",{"data-svelte-h":!0}),y(St)!=="svelte-g047f8"&&(St.textContent=Ws),_l=a(t),gt=i(t,"P",{"data-svelte-h":!0}),y(gt)!=="svelte-29mbrr"&&(gt.textContent=Gs),$l=a(t),p(bt.$$.fragment,t),xl=a(t),ft=i(t,"P",{"data-svelte-h":!0}),y(ft)!=="svelte-lwihmm"&&(ft.textContent=Qs),Hl=a(t),Bt=i(t,"P",{"data-svelte-h":!0}),y(Bt)!=="svelte-lfcqpz"&&(Bt.textContent=Ns),Xl=a(t),p(Zt.$$.fragment,t),zl=a(t),kt=i(t,"P",{}),Rs(kt).forEach(s),this.h()},h(){Vs(U,"name","hf:doc:metadata"),Vs(U,"content",Ps)},m(t,l){zs(document.head,U),e(t,Lt,l),e(t,vt,l),e(t,Et,l),J(c,t,l),e(t,Wt,l),J(u,t,l),e(t,Gt,l),e(t,I,l),e(t,Qt,l),e(t,m,l),e(t,Nt,l),J(C,t,l),e(t,Rt,l),e(t,h,l),e(t,Vt,l),J(A,t,l),e(t,qt,l),e(t,S,l),e(t,_t,l),e(t,g,l),e(t,$t,l),J(b,t,l),e(t,xt,l),e(t,f,l),e(t,Ht,l),J(B,t,l),e(t,Xt,l),J(Z,t,l),e(t,zt,l),e(t,v,l),e(t,Ft,l),e(t,k,l),e(t,Dt,l),J(L,t,l),e(t,Yt,l),J(E,t,l),e(t,Pt,l),e(t,W,l),e(t,Ot,l),J(G,t,l),e(t,Kt,l),J(Q,t,l),e(t,tl,l),e(t,N,l),e(t,ll,l),e(t,R,l),e(t,sl,l),J(V,t,l),e(t,el,l),e(t,q,l),e(t,nl,l),J(_,t,l),e(t,al,l),J($,t,l),e(t,Ml,l),J(x,t,l),e(t,il,l),J(H,t,l),e(t,yl,l),e(t,X,l),e(t,ol,l),e(t,z,l),e(t,pl,l),e(t,F,l),e(t,Jl,l),e(t,D,l),e(t,Tl,l),e(t,Y,l),e(t,rl,l),e(t,P,l),e(t,dl,l),e(t,O,l),e(t,jl,l),J(K,t,l),e(t,wl,l),J(tt,t,l),e(t,Ul,l),e(t,lt,l),e(t,cl,l),e(t,st,l),e(t,ul,l),e(t,et,l),e(t,Il,l),J(nt,t,l),e(t,ml,l),e(t,at,l),e(t,Cl,l),J(Mt,t,l),e(t,hl,l),e(t,it,l),e(t,Al,l),e(t,yt,l),e(t,Sl,l),e(t,ot,l),e(t,gl,l),e(t,pt,l),e(t,bl,l),e(t,Jt,l),e(t,fl,l),e(t,Tt,l),e(t,Bl,l),e(t,rt,l),e(t,Zl,l),e(t,dt,l),e(t,vl,l),e(t,jt,l),e(t,kl,l),e(t,wt,l),e(t,Ll,l),J(Ut,t,l),e(t,El,l),e(t,ct,l),e(t,Wl,l),J(ut,t,l),e(t,Gl,l),e(t,It,l),e(t,Ql,l),e(t,mt,l),e(t,Nl,l),e(t,Ct,l),e(t,Rl,l),e(t,ht,l),e(t,Vl,l),e(t,At,l),e(t,ql,l),e(t,St,l),e(t,_l,l),e(t,gt,l),e(t,$l,l),J(bt,t,l),e(t,xl,l),e(t,ft,l),e(t,Hl,l),e(t,Bt,l),e(t,Xl,l),J(Zt,t,l),e(t,zl,l),e(t,kt,l),Fl=!0},p:_s,i(t){Fl||(T(c.$$.fragment,t),T(u.$$.fragment,t),T(C.$$.fragment,t),T(A.$$.fragment,t),T(b.$$.fragment,t),T(B.$$.fragment,t),T(Z.$$.fragment,t),T(L.$$.fragment,t),T(E.$$.fragment,t),T(G.$$.fragment,t),T(Q.$$.fragment,t),T(V.$$.fragment,t),T(_.$$.fragment,t),T($.$$.fragment,t),T(x.$$.fragment,t),T(H.$$.fragment,t),T(K.$$.fragment,t),T(tt.$$.fragment,t),T(nt.$$.fragment,t),T(Mt.$$.fragment,t),T(Ut.$$.fragment,t),T(ut.$$.fragment,t),T(bt.$$.fragment,t),T(Zt.$$.fragment,t),Fl=!0)},o(t){r(c.$$.fragment,t),r(u.$$.fragment,t),r(C.$$.fragment,t),r(A.$$.fragment,t),r(b.$$.fragment,t),r(B.$$.fragment,t),r(Z.$$.fragment,t),r(L.$$.fragment,t),r(E.$$.fragment,t),r(G.$$.fragment,t),r(Q.$$.fragment,t),r(V.$$.fragment,t),r(_.$$.fragment,t),r($.$$.fragment,t),r(x.$$.fragment,t),r(H.$$.fragment,t),r(K.$$.fragment,t),r(tt.$$.fragment,t),r(nt.$$.fragment,t),r(Mt.$$.fragment,t),r(Ut.$$.fragment,t),r(ut.$$.fragment,t),r(bt.$$.fragment,t),r(Zt.$$.fragment,t),Fl=!1},d(t){t&&(s(Lt),s(vt),s(Et),s(Wt),s(Gt),s(I),s(Qt),s(m),s(Nt),s(Rt),s(h),s(Vt),s(qt),s(S),s(_t),s(g),s($t),s(xt),s(f),s(Ht),s(Xt),s(zt),s(v),s(Ft),s(k),s(Dt),s(Yt),s(Pt),s(W),s(Ot),s(Kt),s(tl),s(N),s(ll),s(R),s(sl),s(el),s(q),s(nl),s(al),s(Ml),s(il),s(yl),s(X),s(ol),s(z),s(pl),s(F),s(Jl),s(D),s(Tl),s(Y),s(rl),s(P),s(dl),s(O),s(jl),s(wl),s(Ul),s(lt),s(cl),s(st),s(ul),s(et),s(Il),s(ml),s(at),s(Cl),s(hl),s(it),s(Al),s(yt),s(Sl),s(ot),s(gl),s(pt),s(bl),s(Jt),s(fl),s(Tt),s(Bl),s(rt),s(Zl),s(dt),s(vl),s(jt),s(kl),s(wt),s(Ll),s(El),s(ct),s(Wl),s(Gl),s(It),s(Ql),s(mt),s(Nl),s(Ct),s(Rl),s(ht),s(Vl),s(At),s(ql),s(St),s(_l),s(gt),s($l),s(xl),s(ft),s(Hl),s(Bt),s(Xl),s(zl),s(kt)),s(U),d(c,t),d(u,t),d(C,t),d(A,t),d(b,t),d(B,t),d(Z,t),d(L,t),d(E,t),d(G,t),d(Q,t),d(V,t),d(_,t),d($,t),d(x,t),d(H,t),d(K,t),d(tt,t),d(nt,t),d(Mt,t),d(Ut,t),d(ut,t),d(bt,t),d(Zt,t)}}}const Ps='{"title":"Multi-Agent Order Management System with MongoDB","local":"multi-agent-order-management-system-with-mongodb","sections":[{"title":"Setting Up MongoDB Atlas","local":"setting-up-mongodb-atlas","sections":[{"title":"Security Considerations","local":"security-considerations","sections":[],"depth":3}],"depth":2},{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Import Dependencies","local":"import-dependencies","sections":[],"depth":2},{"title":"Database Connection Class","local":"database-connection-class","sections":[],"depth":2},{"title":"Agent Tools Defenitions","local":"agent-tools-defenitions","sections":[],"depth":2},{"title":"Main Order Management System","local":"main-order-management-system","sections":[],"depth":2},{"title":"Adding Sample Data","local":"adding-sample-data","sections":[],"depth":2},{"title":"Testing the System","local":"testing-the-system","sections":[],"depth":2},{"title":"System Output Analysis","local":"system-output-analysis","sections":[],"depth":2},{"title":"Conclusions","local":"conclusions","sections":[],"depth":2}],"depth":1}';function Os(Dl){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ee extends xs{constructor(U){super(),Hs(this,U,Os,Ys,qs,{})}}export{ee as component};
