import{s as Kl,n as en,o as tn}from"../chunks/scheduler.65852ee5.js";import{S as ln,i as nn,g as i,s as a,r as o,A as an,h as r,f as l,c as s,j as Ol,u as h,x as p,k as rl,y as sn,a as n,v as m,d as c,t as d,w as u}from"../chunks/index.65a1b999.js";import{D as rn,C as y}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as M,E as pn}from"../chunks/getInferenceSnippets.aa1f4ff5.js";function on(pl){let T,_e,xe,He,g,We,b,Ve,f,ol='<em>Authored by: <a href="https://github.com/dcarpintero" rel="nofollow">Diego Carpintero</a></em>',Qe,J,hl="Knowledge Graphs provide a method for modeling and storing interlinked information in a format that is both human- and machine-understandable. These graphs consist of <em>nodes</em> and <em>edges</em>, representing entities and their relationships. Unlike traditional databases, the inherent expressiveness of graphs allows for richer semantic understanding, while providing the flexibility to accommodate new entity types and relationships without being constrained by a fixed schema.",Fe,U,ml="By combining knowledge graphs with embeddings (vector search), we can leverage <em>multi-hop connectivity</em> and <em>contextual understanding of information</em> to enhance reasoning and explainability in LLMs.",Le,j,cl="This notebook explores the practical implementation of this approach, demonstrating how to:",Ze,C,dl='<li>Build a knowledge graph in <a href="https://neo4j.com/docs/" rel="nofollow">Neo4j</a> related to research publications using a synthetic dataset,</li> <li>Project a subset of our data fields into a high-dimensional vector space using an <a href="https://python.langchain.com/v0.2/docs/integrations/text_embedding/" rel="nofollow">embedding model</a>,</li> <li>Construct a vector index on those embeddings to enable similarity search, and</li> <li>Extract insights from our graph using natural language by easily converting user queries into <a href="https://neo4j.com/docs/cypher-manual/current/introduction/" rel="nofollow">cypher</a> statements with <a href="https://python.langchain.com/v0.2/docs/introduction/" rel="nofollow">LangChain</a>:</li>',qe,w,ul='<img src="https://raw.githubusercontent.com/dcarpintero/generative-ai-101/main/static/knowledge-graphs.png"/>',Xe,I,Ye,v,ze,$,Pe,E,yl='We will create our Knowledge Graph using <a href="https://neo4j.com/docs/" rel="nofollow">Neo4j</a>, an open-source database management system that specializes in graph database technology.',De,R,Ml='For a quick and easy setup, you can start a free instance on <a href="https://neo4j.com/product/auradb/" rel="nofollow">Neo4j Aura</a>.',Oe,B,Tl="You might then set <code>NEO4J_URI</code>, <code>NEO4J_USERNAME</code>, and <code>NEO4J_PASSWORD</code> as environment variables using a <code>.env</code> file:",Ke,G,et,k,wl="Langchain provides the <code>Neo4jGraph</code> class to interact with Neo4j:",tt,N,lt,S,nt,x,gl='The below example creates a connection with our <code>Neo4j</code> database and populates it with <a href="https://github.com/dcarpintero/generative-ai-101/blob/main/dataset/synthetic_articles.csv" rel="nofollow">synthetic data</a> comprising research articles and their authors.',at,A,bl="The entities are:",st,_,fl="<li><em>Researcher</em></li> <li><em>Article</em></li> <li><em>Topic</em></li>",it,H,Jl="Whereas the relationships are:",rt,W,Ul="<li><em>Researcher</em> —[PUBLISHED]—&gt; <em>Article</em></li> <li><em>Article</em> —[IN_TOPIC]—&gt; <em>Topic</em></li>",pt,V,ot,Q,jl="Let’s check that the nodes and relationships have been initialized correctly:",ht,F,mt,L,Cl=`Node properties:
Article &#123;title: STRING, abstract: STRING, publication_date: DATE, embedding: LIST}
Researcher &#123;name: STRING}
Topic &#123;name: STRING}
Relationship properties:

The relationships:
(:Article)-[:IN_TOPIC]->(:Topic)
(:Researcher)-[:PUBLISHED]->(:Article)
`,ct,Z,Il="Our knowledge graph can be inspected in the Neo4j workspace:",dt,q,vl='<img src="https://raw.githubusercontent.com/dcarpintero/generative-ai-101/main/static/kg_sample_00.png"/>',ut,X,yt,Y,$l="Now we construct a vector index to efficiently search for relevant <em>articles</em> based on their <em>topic, title, and abstract</em>. This process involves calculating the embeddings for each article using these fields. At query time, the system finds the most similar articles to the user’s input by employing a similarity metric, such as cosine distance.",Mt,z,Tt,P,El='<strong>Note:</strong> To access OpenAI embedding models you will need to create an OpenAI account, get an API key, and set <code>OPENAI_API_KEY</code> as an environment variable. You might also find it useful to experiment with another <a href="https://python.langchain.com/v0.2/docs/integrations/text_embedding/" rel="nofollow">embedding model</a> integration.',wt,D,gt,O,Rl="<code>Langchain RetrievalQA</code> creates a question-answering (QA) chain using the above vector index as a retriever.",bt,K,ft,ee,Bl="Let’s ask ’<em>which articles discuss how AI might affect our daily life?</em>‘:",Jt,te,Ut,le,Gl=`The articles that discuss how AI might affect our daily life are:

1. **The Impact of AI on Employment: A Comprehensive Study**
   *Abstract:* This study analyzes the potential effects of AI on various job sectors and suggests policy recommendations to mitigate negative impacts.

2. **The Societal Implications of Advanced AI: A Multidisciplinary Analysis**
   *Abstract:* Our study brings together experts from various fields to analyze the potential long-term impacts of advanced AI on society, economy, and culture.

These two articles would provide insights into how AI could potentially impact our daily lives from different perspectives.
`,jt,ne,Ct,ae,kl="Knowledge graphs are excellent for making connections between entities, enabling the extraction of patterns and the discovery of new insights.",It,se,Nl="This section demonstrates how to implement this process and integrate the results into an LLM pipeline using natural language queries.",vt,ie,$t,re,Sl="To construct expressive and efficient queries <code>Neo4j</code> users <code>Cypher</code>, a declarative query language inspired by SQL. <code>LangChain</code> provides the wrapper <code>GraphCypherQAChain</code>, an abstraction layer that allows querying graph databases using natural language, making it easier to integrate graph-based data retrieval into LLM pipelines.",Et,pe,xl="In practice, <code>GraphCypherQAChain</code>:",Rt,oe,Al="<li>generates Cypher statements (queries for graph databases like Neo4j) from user input (natural language) applying in-context learning (prompt engineering),</li> <li>executes said statements against a graph database, and</li> <li>provides the results as context to ground the LLM responses on accurate, up-to-date information:</li>",Bt,he,_l="<strong>Note:</strong> This implementation involves executing model-generated graph queries, which carries inherent risks such as unintended access or modification of sensitive data in the database. To mitigate these risks, ensure that your database connection permissions are as restricted as possible to meet the specific needs of your chain/agent. While this approach reduces risk, it does not eliminate it entirely.",Gt,me,kt,ce,Nt,de,Hl="Note in the following examples how the results from the cypher query execution are provided as context to the LLM:",St,ue,xt,ye,Wl="In this example, our question ’<em>How many articles has published Emily Chen?</em>’ will be translated into the Cyper query:",At,Me,_t,Te,Vl=`which matches nodes labeled <code>Author</code> with the name ‘Emily Chen’ and traverses the <code>PUBLISHED</code> relationships to <code>Article</code> nodes.
It then counts the number of <code>Article</code> nodes connected to ‘Emily Chen’:`,Ht,we,Ql='<img src="https://raw.githubusercontent.com/dcarpintero/generative-ai-101/main/static/kg_sample_01.png" width="40%"/>',Wt,ge,Vt,be,Fl=`\x1B[1m> Entering new GraphCypherQAChain chain...\x1B[0m
Generated Cypher:
\x1B[32;1m\x1B[1;3mcypher
MATCH (r:Researcher &#123;name: "Emily Chen"})-[:PUBLISHED]->(a:Article)
RETURN COUNT(a) AS numberOfArticles
\x1B[0m
Full Context:
\x1B[32;1m\x1B[1;3m[&#123;'numberOfArticles': 7}]\x1B[0m

\x1B[1m> Finished chain.\x1B[0m
`,Qt,fe,Ft,Je,Ll="In this example, the query ’<em>are there any pair of researchers who have published more than three articles together?</em>’ results in the Cypher query:",Lt,Ue,Zt,je,Zl="which results in traversing from the <code>Researcher</code> nodes to the <code>PUBLISHED</code> relationship to find connected <code>Article</code> nodes, and then traversing back to find <code>Researchers</code> pairs.",qt,Ce,ql='<img src="https://raw.githubusercontent.com/dcarpintero/generative-ai-101/main/static/kg_sample_02.png"/>',Xt,Ie,Yt,ve,Xl=`\x1B[1m> Entering new GraphCypherQAChain chain...\x1B[0m
Generated Cypher:
\x1B[32;1m\x1B[1;3mcypher
MATCH (r1:Researcher)-[:PUBLISHED]->(a:Article)<-[:PUBLISHED]-(r2:Researcher)
WHERE r1 <> r2
WITH r1, r2, COUNT(a) AS sharedArticles
WHERE sharedArticles > 3
RETURN r1.name, r2.name, sharedArticles
\x1B[0m
Full Context:
\x1B[32;1m\x1B[1;3m[&#123;'r1.name': 'David Johnson', 'r2.name': 'Emily Chen', 'sharedArticles': 4}, &#123;'r1.name': 'Robert Taylor', 'r2.name': 'Emily Chen', 'sharedArticles': 4}, &#123;'r1.name': 'Emily Chen', 'r2.name': 'David Johnson', 'sharedArticles': 4}, &#123;'r1.name': 'Emily Chen', 'r2.name': 'Robert Taylor', 'sharedArticles': 4}]\x1B[0m

\x1B[1m> Finished chain.\x1B[0m
`,zt,$e,Pt,Ee,Yl=`Let’s find out who is the researcher with most peers collaborations.
Our query ’<em>which researcher has collaborated with the most peers?</em>’ results now in the Cyper:`,Dt,Re,Ot,Be,zl="Here, we need to start from all <code>Researcher</code> nodes and traverse their <code>PUBLISHED</code> relationships to find connected <code>Article</code> nodes. For each <code>Article</code> node, Neo4j then traverses back to find other <code>Researcher</code> nodes (peer) who have also published the same article.",Kt,Ge,Pl='<img src="https://raw.githubusercontent.com/dcarpintero/generative-ai-101/main/static/kg_sample_03.png"/>',el,ke,tl,Ne,Dl=`\x1B[1m> Entering new GraphCypherQAChain chain...\x1B[0m
Generated Cypher:
\x1B[32;1m\x1B[1;3mcypher
MATCH (r1:Researcher)-[:PUBLISHED]->(:Article)<-[:PUBLISHED]-(r2:Researcher)
WHERE r1 <> r2
WITH r1, COUNT(DISTINCT r2) AS collaborators
RETURN r1.name AS researcher, collaborators
ORDER BY collaborators DESC
LIMIT 1
\x1B[0m
Full Context:
\x1B[32;1m\x1B[1;3m[&#123;'researcher': 'David Johnson', 'collaborators': 6}]\x1B[0m

\x1B[1m> Finished chain.\x1B[0m
`,ll,nl,al,Se,sl,Ae,il;return g=new rn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_with_knowledge_graphs_neo4j.ipynb"}]}}),b=new M({props:{title:"Enhancing RAG Reasoning with Knowledge Graphs",local:"enhancing-rag-reasoning-with-knowledge-graphs",headingTag:"h1"}}),I=new M({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),v=new y({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMG5lbzRqJTIwbGFuZ2NoYWluJTIwbGFuZ2NoYWluX29wZW5haSUyMGxhbmdjaGFpbi1jb21tdW5pdHklMjBweXRob24tZG90ZW52JTIwLS1xdWlldA==",highlighted:"%pip install neo4j langchain langchain_openai langchain-community python-dotenv --quiet",wrap:!1}}),$=new M({props:{title:"Set up a Neo4j instance",local:"set-up-a-neo4j-instance",headingTag:"h3"}}),G=new y({props:{code:"aW1wb3J0JTIwZG90ZW52JTBBJTBBZG90ZW52LmxvYWRfZG90ZW52KCUyMi5lbnYlMjIlMkMlMjBvdmVycmlkZSUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> dotenv

dotenv.load_dotenv(<span class="hljs-string">&quot;.env&quot;</span>, override=<span class="hljs-literal">True</span>)`,wrap:!1}}),N=new y({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwbGFuZ2NoYWluX2NvbW11bml0eS5ncmFwaHMlMjBpbXBvcnQlMjBOZW80akdyYXBoJTBBJTBBZ3JhcGglMjAlM0QlMjBOZW80akdyYXBoKCUwQSUyMCUyMCUyMCUyMHVybCUzRG9zLmVudmlyb24lNUIlMjJORU80Sl9VUkklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB1c2VybmFtZSUzRG9zLmVudmlyb24lNUIlMjJORU80Sl9VU0VSTkFNRSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhc3N3b3JkJTNEb3MuZW52aXJvbiU1QiUyMk5FTzRKX1BBU1NXT1JEJTIyJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> langchain_community.graphs <span class="hljs-keyword">import</span> Neo4jGraph

graph = Neo4jGraph(
    url=os.environ[<span class="hljs-string">&quot;NEO4J_URI&quot;</span>],
    username=os.environ[<span class="hljs-string">&quot;NEO4J_USERNAME&quot;</span>],
    password=os.environ[<span class="hljs-string">&quot;NEO4J_PASSWORD&quot;</span>],
)`,wrap:!1}}),S=new M({props:{title:"Loading Dataset into a Graph",local:"loading-dataset-into-a-graph",headingTag:"h3"}}),V=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkuZ3JhcGhzJTIwaW1wb3J0JTIwTmVvNGpHcmFwaCUwQSUwQWdyYXBoJTIwJTNEJTIwTmVvNGpHcmFwaCgpJTBBJTBBcV9sb2FkX2FydGljbGVzJTIwJTNEJTIwJTIyJTIyJTIyJTBBTE9BRCUyMENTViUyMFdJVEglMjBIRUFERVJTJTBBRlJPTSUyMCdodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZkY2FycGludGVybyUyRmdlbmVyYXRpdmUtYWktMTAxJTJGbWFpbiUyRmRhdGFzZXQlMkZzeW50aGV0aWNfYXJ0aWNsZXMuY3N2JyUyMCUwQUFTJTIwcm93JTIwJTBBRklFTERURVJNSU5BVE9SJTIwJyUzQiclMEFNRVJHRSUyMChhJTNBQXJ0aWNsZSUyMCU3QnRpdGxlJTNBcm93LlRpdGxlJTdEKSUwQVNFVCUyMGEuYWJzdHJhY3QlMjAlM0QlMjByb3cuQWJzdHJhY3QlMkMlMEElMjAlMjAlMjAlMjBhLnB1YmxpY2F0aW9uX2RhdGUlMjAlM0QlMjBkYXRlKHJvdy5QdWJsaWNhdGlvbl9EYXRlKSUwQUZPUkVBQ0glMjAocmVzZWFyY2hlciUyMGluJTIwc3BsaXQocm93LkF1dGhvcnMlMkMlMjAnJTJDJyklMjAlN0MlMjAlMEElMjAlMjAlMjAlMjBNRVJHRSUyMChwJTNBUmVzZWFyY2hlciUyMCU3Qm5hbWUlM0F0cmltKHJlc2VhcmNoZXIpJTdEKSUwQSUyMCUyMCUyMCUyME1FUkdFJTIwKHApLSU1QiUzQVBVQkxJU0hFRCU1RC0lM0UoYSkpJTBBRk9SRUFDSCUyMCh0b3BpYyUyMGluJTIwJTVCcm93LlRvcGljJTVEJTIwJTdDJTIwJTBBJTIwJTIwJTIwJTIwTUVSR0UlMjAodCUzQVRvcGljJTIwJTdCbmFtZSUzQXRyaW0odG9waWMpJTdEKSUwQSUyMCUyMCUyMCUyME1FUkdFJTIwKGEpLSU1QiUzQUlOX1RPUElDJTVELSUzRSh0KSklMEElMjIlMjIlMjIlMEElMEFncmFwaC5xdWVyeShxX2xvYWRfYXJ0aWNsZXMp",highlighted:`<span class="hljs-keyword">from</span> langchain_community.graphs <span class="hljs-keyword">import</span> Neo4jGraph

graph = Neo4jGraph()

q_load_articles = <span class="hljs-string">&quot;&quot;&quot;
LOAD CSV WITH HEADERS
FROM &#x27;https://raw.githubusercontent.com/dcarpintero/generative-ai-101/main/dataset/synthetic_articles.csv&#x27; 
AS row 
FIELDTERMINATOR &#x27;;&#x27;
MERGE (a:Article {title:row.Title})
SET a.abstract = row.Abstract,
    a.publication_date = date(row.Publication_Date)
FOREACH (researcher in split(row.Authors, &#x27;,&#x27;) | 
    MERGE (p:Researcher {name:trim(researcher)})
    MERGE (p)-[:PUBLISHED]-&gt;(a))
FOREACH (topic in [row.Topic] | 
    MERGE (t:Topic {name:trim(topic)})
    MERGE (a)-[:IN_TOPIC]-&gt;(t))
&quot;&quot;&quot;</span>

graph.query(q_load_articles)`,wrap:!1}}),F=new y({props:{code:"Z3JhcGgucmVmcmVzaF9zY2hlbWEoKSUwQXByaW50KGdyYXBoLmdldF9zY2hlbWEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>graph.refresh_schema()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(graph.get_schema)`,wrap:!1}}),X=new M({props:{title:"Building a Vector Index",local:"building-a-vector-index",headingTag:"h3"}}),z=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkudmVjdG9yc3RvcmVzJTIwaW1wb3J0JTIwTmVvNGpWZWN0b3IlMEFmcm9tJTIwbGFuZ2NoYWluX29wZW5haSUyMGltcG9ydCUyME9wZW5BSUVtYmVkZGluZ3MlMEElMEF2ZWN0b3JfaW5kZXglMjAlM0QlMjBOZW80alZlY3Rvci5mcm9tX2V4aXN0aW5nX2dyYXBoKCUwQSUyMCUyMCUyMCUyME9wZW5BSUVtYmVkZGluZ3MoKSUyQyUwQSUyMCUyMCUyMCUyMHVybCUzRG9zLmVudmlyb24lNUIlMjJORU80Sl9VUkklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB1c2VybmFtZSUzRG9zLmVudmlyb24lNUIlMjJORU80Sl9VU0VSTkFNRSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhc3N3b3JkJTNEb3MuZW52aXJvbiU1QiUyMk5FTzRKX1BBU1NXT1JEJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwaW5kZXhfbmFtZSUzRCUyMmFydGljbGVzJTIyJTJDJTBBJTIwJTIwJTIwJTIwbm9kZV9sYWJlbCUzRCUyMkFydGljbGUlMjIlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X25vZGVfcHJvcGVydGllcyUzRCU1QiUyMnRvcGljJTIyJTJDJTIwJTIydGl0bGUlMjIlMkMlMjAlMjJhYnN0cmFjdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ19ub2RlX3Byb3BlcnR5JTNEJTIyZW1iZWRkaW5nJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain_community.vectorstores <span class="hljs-keyword">import</span> Neo4jVector
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> OpenAIEmbeddings

vector_index = Neo4jVector.from_existing_graph(
    OpenAIEmbeddings(),
    url=os.environ[<span class="hljs-string">&quot;NEO4J_URI&quot;</span>],
    username=os.environ[<span class="hljs-string">&quot;NEO4J_USERNAME&quot;</span>],
    password=os.environ[<span class="hljs-string">&quot;NEO4J_PASSWORD&quot;</span>],
    index_name=<span class="hljs-string">&quot;articles&quot;</span>,
    node_label=<span class="hljs-string">&quot;Article&quot;</span>,
    text_node_properties=[<span class="hljs-string">&quot;topic&quot;</span>, <span class="hljs-string">&quot;title&quot;</span>, <span class="hljs-string">&quot;abstract&quot;</span>],
    embedding_node_property=<span class="hljs-string">&quot;embedding&quot;</span>,
)`,wrap:!1}}),D=new M({props:{title:"Q&A on Similarity",local:"qa-on-similarity",headingTag:"h2"}}),K=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5jaGFpbnMlMjBpbXBvcnQlMjBSZXRyaWV2YWxRQSUwQWZyb20lMjBsYW5nY2hhaW5fb3BlbmFpJTIwaW1wb3J0JTIwQ2hhdE9wZW5BSSUwQSUwQXZlY3Rvcl9xYSUyMCUzRCUyMFJldHJpZXZhbFFBLmZyb21fY2hhaW5fdHlwZShsbG0lM0RDaGF0T3BlbkFJKCklMkMlMjBjaGFpbl90eXBlJTNEJTIyc3R1ZmYlMjIlMkMlMjByZXRyaWV2ZXIlM0R2ZWN0b3JfaW5kZXguYXNfcmV0cmlldmVyKCkp",highlighted:`<span class="hljs-keyword">from</span> langchain.chains <span class="hljs-keyword">import</span> RetrievalQA
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI

vector_qa = RetrievalQA.from_chain_type(llm=ChatOpenAI(), chain_type=<span class="hljs-string">&quot;stuff&quot;</span>, retriever=vector_index.as_retriever())`,wrap:!1}}),te=new y({props:{code:"ciUyMCUzRCUyMHZlY3Rvcl9xYS5pbnZva2UoJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycXVlcnklMjIlM0ElMjAlMjJ3aGljaCUyMGFydGljbGVzJTIwZGlzY3VzcyUyMGhvdyUyMEFJJTIwbWlnaHQlMjBhZmZlY3QlMjBvdXIlMjBkYWlseSUyMGxpZmUlM0YlMjBpbmNsdWRlJTIwdGhlJTIwYXJ0aWNsZSUyMHRpdGxlcyUyMGFuZCUyMGFic3RyYWN0cy4lMjIlMEElMjAlMjAlMjAlMjAlN0QlMEEpJTBBcHJpbnQociU1QiUyMnJlc3VsdCUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>r = vector_qa.invoke(
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;which articles discuss how AI might affect our daily life? include the article titles and abstracts.&quot;</span>
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(r[<span class="hljs-string">&quot;result&quot;</span>])`,wrap:!1}}),ne=new M({props:{title:"Traversing Knowledge Graphs for Inference",local:"traversing-knowledge-graphs-for-inference",headingTag:"h2"}}),ie=new M({props:{title:"Graph-Cypher-Chain w/ LangChain",local:"graph-cypher-chain-w-langchain",headingTag:"h3"}}),me=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5jaGFpbnMlMjBpbXBvcnQlMjBHcmFwaEN5cGhlclFBQ2hhaW4lMEFmcm9tJTIwbGFuZ2NoYWluX29wZW5haSUyMGltcG9ydCUyMENoYXRPcGVuQUklMEElMEFncmFwaC5yZWZyZXNoX3NjaGVtYSgpJTBBJTBBY3lwaGVyX2NoYWluJTIwJTNEJTIwR3JhcGhDeXBoZXJRQUNoYWluLmZyb21fbGxtKCUwQSUyMCUyMCUyMCUyMGN5cGhlcl9sbG0lM0RDaGF0T3BlbkFJKHRlbXBlcmF0dXJlJTNEMCUyQyUyMG1vZGVsX25hbWUlM0QlMjJncHQtNG8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwcWFfbGxtJTNEQ2hhdE9wZW5BSSh0ZW1wZXJhdHVyZSUzRDAlMkMlMjBtb2RlbF9uYW1lJTNEJTIyZ3B0LTRvJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGdyYXBoJTNEZ3JhcGglMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NlJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> langchain.chains <span class="hljs-keyword">import</span> GraphCypherQAChain
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI

graph.refresh_schema()

cypher_chain = GraphCypherQAChain.from_llm(
    cypher_llm=ChatOpenAI(temperature=<span class="hljs-number">0</span>, model_name=<span class="hljs-string">&quot;gpt-4o&quot;</span>),
    qa_llm=ChatOpenAI(temperature=<span class="hljs-number">0</span>, model_name=<span class="hljs-string">&quot;gpt-4o&quot;</span>),
    graph=graph,
    verbose=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),ce=new M({props:{title:"Query Samples using Natural Language",local:"query-samples-using-natural-language",headingTag:"h3"}}),ue=new M({props:{title:"” How many articles has published Emily Chen? ”",local:"-how-many-articles-has-published-emily-chen-",headingTag:"h4"}}),Me=new y({props:{code:"TUFUQ0glMjAociUzQVJlc2VhcmNoZXIlMjAlN0JuYW1lJTNBJTIwJTIyRW1pbHklMjBDaGVuJTIyJTdEKS0lNUIlM0FQVUJMSVNIRUQlNUQtJTNFKGElM0FBcnRpY2xlKSUwQVJFVFVSTiUyMENPVU5UKGEpJTIwQVMlMjBudW1iZXJPZkFydGljbGVz",highlighted:`MATCH (r:Researcher {name: <span class="hljs-string">&quot;Emily Chen&quot;</span>})-<span class="hljs-selector-attr">[:PUBLISHED]</span>-&gt;(<span class="hljs-selector-tag">a</span>:Article)
RETURN <span class="hljs-built_in">COUNT</span>(a) AS numberOfArticles`,wrap:!1}}),ge=new y({props:{code:"JTIzJTIwdGhlJTIwYW5zd2VyJTIwc2hvdWxkJTIwYmUlMjAnNyclMEFjeXBoZXJfY2hhaW4uaW52b2tlKCU3QiUyMnF1ZXJ5JTIyJTNBJTIwJTIySG93JTIwbWFueSUyMGFydGljbGVzJTIwaGFzJTIwcHVibGlzaGVkJTIwRW1pbHklMjBDaGVuJTNGJTIyJTdEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the answer should be &#x27;7&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cypher_chain.invoke({<span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;How many articles has published Emily Chen?&quot;</span>})`,wrap:!1}}),fe=new M({props:{title:"” Are there any pair of researchers who have published more than three articles together? ”",local:"-are-there-any-pair-of-researchers-who-have-published-more-than-three-articles-together-",headingTag:"h4"}}),Ue=new y({props:{code:"TUFUQ0glMjAocjElM0FSZXNlYXJjaGVyKS0lNUIlM0FQVUJMSVNIRUQlNUQtJTNFKGElM0FBcnRpY2xlKSUzQy0lNUIlM0FQVUJMSVNIRUQlNUQtKHIyJTNBUmVzZWFyY2hlciklMEFXSEVSRSUyMHIxJTIwJTNDJTNFJTIwcjIlMEFXSVRIJTIwcjElMkMlMjByMiUyQyUyMENPVU5UKGEpJTIwQVMlMjBzaGFyZWRBcnRpY2xlcyUwQVdIRVJFJTIwc2hhcmVkQXJ0aWNsZXMlMjAlM0UlMjAzJTBBUkVUVVJOJTIwcjEubmFtZSUyQyUyMHIyLm5hbWUlMkMlMjBzaGFyZWRBcnRpY2xlcw==",highlighted:`<span class="hljs-symbol">MATCH</span> (<span class="hljs-built_in">r1</span>:Researcher)-[:PUBLISHED]-&gt;(a:Article)&lt;-[:PUBLISHED]-(<span class="hljs-built_in">r2</span>:Researcher)
<span class="hljs-symbol">WHERE</span> <span class="hljs-built_in">r1</span> &lt;&gt; <span class="hljs-built_in">r2</span>
<span class="hljs-symbol">WITH</span> <span class="hljs-built_in">r1</span>, <span class="hljs-built_in">r2</span>, COUNT(a) AS sharedArticles
<span class="hljs-symbol">WHERE</span> sharedArticles &gt; <span class="hljs-number">3</span>
<span class="hljs-symbol">RETURN</span> <span class="hljs-built_in">r1</span>.name, <span class="hljs-built_in">r2</span>.name, sharedArticles`,wrap:!1}}),Ie=new y({props:{code:"JTIzJTIwdGhlJTIwYW5zd2VyJTIwc2hvdWxkJTIwYmUlMjBEYXZpZCUyMEpvaG5zb24lMjAlMjYlMjBFbWlseSUyMENoZW4lMkMlMjBSb2JlcnQlMjBUYXlsb3IlMjAlMjYlMjBFbWlseSUyMENoZW4lMEFjeXBoZXJfY2hhaW4uaW52b2tlKCUwQSUyMCUyMCUyMCUyMCU3QiUyMnF1ZXJ5JTIyJTNBJTIwJTIyYXJlJTIwdGhlcmUlMjBhbnklMjBwYWlyJTIwb2YlMjByZXNlYXJjaGVycyUyMHdobyUyMGhhdmUlMjBwdWJsaXNoZWQlMjBtb3JlJTIwdGhhbiUyMHRocmVlJTIwYXJ0aWNsZXMlMjB0b2dldGhlciUzRiUyMiU3RCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the answer should be David Johnson &amp; Emily Chen, Robert Taylor &amp; Emily Chen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cypher_chain.invoke(
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;are there any pair of researchers who have published more than three articles together?&quot;</span>}
<span class="hljs-meta">... </span>)`,wrap:!1}}),$e=new M({props:{title:"” which researcher has collaborated with the most peers? ”",local:"-which-researcher-has-collaborated-with-the-most-peers-",headingTag:"h4"}}),Re=new y({props:{code:"TUFUQ0glMjAociUzQVJlc2VhcmNoZXIpLSU1QiUzQVBVQkxJU0hFRCU1RC0lM0UoJTNBQXJ0aWNsZSklM0MtJTVCJTNBUFVCTElTSEVEJTVELShwZWVyJTNBUmVzZWFyY2hlciklMEFXSVRIJTIwciUyQyUyMENPVU5UKERJU1RJTkNUJTIwcGVlciklMjBBUyUyMHBlZXJDb3VudCUwQVJFVFVSTiUyMHIubmFtZSUyMEFTJTIwcmVzZWFyY2hlciUyQyUyMHBlZXJDb3VudCUwQU9SREVSJTIwQlklMjBwZWVyQ291bnQlMjBERVNDJTBBTElNSVQlMjAx",highlighted:`MATCH (r:Researcher)-[:PUBLISHED]-&gt;(:Article)&lt;-[:PUBLISHED]-(peer:Researcher)
<span class="hljs-keyword">WITH</span> r, COUNT(<span class="hljs-keyword">DISTINCT</span> peer) <span class="hljs-keyword">AS</span> peerCount
<span class="hljs-keyword">RETURN</span> r.name <span class="hljs-keyword">AS</span> researcher, peerCount
<span class="hljs-keyword">ORDER</span> <span class="hljs-keyword">BY</span> peerCount <span class="hljs-keyword">DESC</span>
<span class="hljs-keyword">LIMIT</span> <span class="hljs-number">1</span>`,wrap:!1}}),ke=new y({props:{code:"JTIzJTIwdGhlJTIwYW5zd2VyJTIwc2hvdWxkJTIwYmUlMjAnRGF2aWQlMjBKb2huc29uJyUwQWN5cGhlcl9jaGFpbi5pbnZva2UoJTdCJTIycXVlcnklMjIlM0ElMjAlMjJXaGljaCUyMHJlc2VhcmNoZXIlMjBoYXMlMjBjb2xsYWJvcmF0ZWQlMjB3aXRoJTIwdGhlJTIwbW9zdCUyMHBlZXJzJTNGJTIyJTdEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the answer should be &#x27;David Johnson&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cypher_chain.invoke({<span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;Which researcher has collaborated with the most peers?&quot;</span>})`,wrap:!1}}),Se=new pn({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_with_knowledge_graphs_neo4j.md"}}),{c(){T=i("meta"),_e=a(),xe=i("p"),He=a(),o(g.$$.fragment),We=a(),o(b.$$.fragment),Ve=a(),f=i("p"),f.innerHTML=ol,Qe=a(),J=i("p"),J.innerHTML=hl,Fe=a(),U=i("p"),U.innerHTML=ml,Le=a(),j=i("p"),j.textContent=cl,Ze=a(),C=i("ul"),C.innerHTML=dl,qe=a(),w=i("p"),w.innerHTML=ul,Xe=a(),o(I.$$.fragment),Ye=a(),o(v.$$.fragment),ze=a(),o($.$$.fragment),Pe=a(),E=i("p"),E.innerHTML=yl,De=a(),R=i("p"),R.innerHTML=Ml,Oe=a(),B=i("p"),B.innerHTML=Tl,Ke=a(),o(G.$$.fragment),et=a(),k=i("p"),k.innerHTML=wl,tt=a(),o(N.$$.fragment),lt=a(),o(S.$$.fragment),nt=a(),x=i("p"),x.innerHTML=gl,at=a(),A=i("p"),A.textContent=bl,st=a(),_=i("ul"),_.innerHTML=fl,it=a(),H=i("p"),H.textContent=Jl,rt=a(),W=i("ul"),W.innerHTML=Ul,pt=a(),o(V.$$.fragment),ot=a(),Q=i("p"),Q.textContent=jl,ht=a(),o(F.$$.fragment),mt=a(),L=i("pre"),L.textContent=Cl,ct=a(),Z=i("p"),Z.textContent=Il,dt=a(),q=i("p"),q.innerHTML=vl,ut=a(),o(X.$$.fragment),yt=a(),Y=i("p"),Y.innerHTML=$l,Mt=a(),o(z.$$.fragment),Tt=a(),P=i("p"),P.innerHTML=El,wt=a(),o(D.$$.fragment),gt=a(),O=i("p"),O.innerHTML=Rl,bt=a(),o(K.$$.fragment),ft=a(),ee=i("p"),ee.innerHTML=Bl,Jt=a(),o(te.$$.fragment),Ut=a(),le=i("pre"),le.textContent=Gl,jt=a(),o(ne.$$.fragment),Ct=a(),ae=i("p"),ae.textContent=kl,It=a(),se=i("p"),se.textContent=Nl,vt=a(),o(ie.$$.fragment),$t=a(),re=i("p"),re.innerHTML=Sl,Et=a(),pe=i("p"),pe.innerHTML=xl,Rt=a(),oe=i("ul"),oe.innerHTML=Al,Bt=a(),he=i("p"),he.innerHTML=_l,Gt=a(),o(me.$$.fragment),kt=a(),o(ce.$$.fragment),Nt=a(),de=i("p"),de.textContent=Hl,St=a(),o(ue.$$.fragment),xt=a(),ye=i("p"),ye.innerHTML=Wl,At=a(),o(Me.$$.fragment),_t=a(),Te=i("p"),Te.innerHTML=Vl,Ht=a(),we=i("p"),we.innerHTML=Ql,Wt=a(),o(ge.$$.fragment),Vt=a(),be=i("pre"),be.textContent=Fl,Qt=a(),o(fe.$$.fragment),Ft=a(),Je=i("p"),Je.innerHTML=Ll,Lt=a(),o(Ue.$$.fragment),Zt=a(),je=i("p"),je.innerHTML=Zl,qt=a(),Ce=i("p"),Ce.innerHTML=ql,Xt=a(),o(Ie.$$.fragment),Yt=a(),ve=i("pre"),ve.textContent=Xl,zt=a(),o($e.$$.fragment),Pt=a(),Ee=i("p"),Ee.innerHTML=Yl,Dt=a(),o(Re.$$.fragment),Ot=a(),Be=i("p"),Be.innerHTML=zl,Kt=a(),Ge=i("p"),Ge.innerHTML=Pl,el=a(),o(ke.$$.fragment),tl=a(),Ne=i("pre"),Ne.textContent=Dl,ll=a(),nl=i("hr"),al=a(),o(Se.$$.fragment),sl=a(),Ae=i("p"),this.h()},l(e){const t=an("svelte-u9bgzb",document.head);T=r(t,"META",{name:!0,content:!0}),t.forEach(l),_e=s(e),xe=r(e,"P",{}),Ol(xe).forEach(l),He=s(e),h(g.$$.fragment,e),We=s(e),h(b.$$.fragment,e),Ve=s(e),f=r(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-mvdklb"&&(f.innerHTML=ol),Qe=s(e),J=r(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-52elw8"&&(J.innerHTML=hl),Fe=s(e),U=r(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1g5432g"&&(U.innerHTML=ml),Le=s(e),j=r(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-6rsqn2"&&(j.textContent=cl),Ze=s(e),C=r(e,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-sdyeqq"&&(C.innerHTML=dl),qe=s(e),w=r(e,"P",{align:!0,"data-svelte-h":!0}),p(w)!=="svelte-xuaq4q"&&(w.innerHTML=ul),Xe=s(e),h(I.$$.fragment,e),Ye=s(e),h(v.$$.fragment,e),ze=s(e),h($.$$.fragment,e),Pe=s(e),E=r(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-18ea503"&&(E.innerHTML=yl),De=s(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1nrats8"&&(R.innerHTML=Ml),Oe=s(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-7n6nf8"&&(B.innerHTML=Tl),Ke=s(e),h(G.$$.fragment,e),et=s(e),k=r(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1wv0i54"&&(k.innerHTML=wl),tt=s(e),h(N.$$.fragment,e),lt=s(e),h(S.$$.fragment,e),nt=s(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-39i9km"&&(x.innerHTML=gl),at=s(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1qnoqa2"&&(A.textContent=bl),st=s(e),_=r(e,"UL",{"data-svelte-h":!0}),p(_)!=="svelte-1hn6thf"&&(_.innerHTML=fl),it=s(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-ocw9sv"&&(H.textContent=Jl),rt=s(e),W=r(e,"UL",{"data-svelte-h":!0}),p(W)!=="svelte-17z0hxs"&&(W.innerHTML=Ul),pt=s(e),h(V.$$.fragment,e),ot=s(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1n7uomx"&&(Q.textContent=jl),ht=s(e),h(F.$$.fragment,e),mt=s(e),L=r(e,"PRE",{"data-svelte-h":!0}),p(L)!=="svelte-rbst4l"&&(L.textContent=Cl),ct=s(e),Z=r(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-ftglnj"&&(Z.textContent=Il),dt=s(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-s0xiop"&&(q.innerHTML=vl),ut=s(e),h(X.$$.fragment,e),yt=s(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1meq4zf"&&(Y.innerHTML=$l),Mt=s(e),h(z.$$.fragment,e),Tt=s(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1uxbfv4"&&(P.innerHTML=El),wt=s(e),h(D.$$.fragment,e),gt=s(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-u0l32z"&&(O.innerHTML=Rl),bt=s(e),h(K.$$.fragment,e),ft=s(e),ee=r(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1t06psu"&&(ee.innerHTML=Bl),Jt=s(e),h(te.$$.fragment,e),Ut=s(e),le=r(e,"PRE",{"data-svelte-h":!0}),p(le)!=="svelte-10f2otb"&&(le.textContent=Gl),jt=s(e),h(ne.$$.fragment,e),Ct=s(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1ryalx9"&&(ae.textContent=kl),It=s(e),se=r(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-621mt"&&(se.textContent=Nl),vt=s(e),h(ie.$$.fragment,e),$t=s(e),re=r(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-t5mf75"&&(re.innerHTML=Sl),Et=s(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-u7o0ij"&&(pe.innerHTML=xl),Rt=s(e),oe=r(e,"UL",{"data-svelte-h":!0}),p(oe)!=="svelte-slh7db"&&(oe.innerHTML=Al),Bt=s(e),he=r(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-176eme2"&&(he.innerHTML=_l),Gt=s(e),h(me.$$.fragment,e),kt=s(e),h(ce.$$.fragment,e),Nt=s(e),de=r(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-v5ffe8"&&(de.textContent=Hl),St=s(e),h(ue.$$.fragment,e),xt=s(e),ye=r(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1yfazxa"&&(ye.innerHTML=Wl),At=s(e),h(Me.$$.fragment,e),_t=s(e),Te=r(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1plev05"&&(Te.innerHTML=Vl),Ht=s(e),we=r(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1y4zmei"&&(we.innerHTML=Ql),Wt=s(e),h(ge.$$.fragment,e),Vt=s(e),be=r(e,"PRE",{"data-svelte-h":!0}),p(be)!=="svelte-1i2j01w"&&(be.textContent=Fl),Qt=s(e),h(fe.$$.fragment,e),Ft=s(e),Je=r(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-10xfisa"&&(Je.innerHTML=Ll),Lt=s(e),h(Ue.$$.fragment,e),Zt=s(e),je=r(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-q3bs1d"&&(je.innerHTML=Zl),qt=s(e),Ce=r(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1yvj1cf"&&(Ce.innerHTML=ql),Xt=s(e),h(Ie.$$.fragment,e),Yt=s(e),ve=r(e,"PRE",{"data-svelte-h":!0}),p(ve)!=="svelte-1mq04bw"&&(ve.textContent=Xl),zt=s(e),h($e.$$.fragment,e),Pt=s(e),Ee=r(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-40ghdk"&&(Ee.innerHTML=Yl),Dt=s(e),h(Re.$$.fragment,e),Ot=s(e),Be=r(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1tiwi45"&&(Be.innerHTML=zl),Kt=s(e),Ge=r(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-18615mk"&&(Ge.innerHTML=Pl),el=s(e),h(ke.$$.fragment,e),tl=s(e),Ne=r(e,"PRE",{"data-svelte-h":!0}),p(Ne)!=="svelte-bo2yaw"&&(Ne.textContent=Dl),ll=s(e),nl=r(e,"HR",{}),al=s(e),h(Se.$$.fragment,e),sl=s(e),Ae=r(e,"P",{}),Ol(Ae).forEach(l),this.h()},h(){rl(T,"name","hf:doc:metadata"),rl(T,"content",hn),rl(w,"align","center")},m(e,t){sn(document.head,T),n(e,_e,t),n(e,xe,t),n(e,He,t),m(g,e,t),n(e,We,t),m(b,e,t),n(e,Ve,t),n(e,f,t),n(e,Qe,t),n(e,J,t),n(e,Fe,t),n(e,U,t),n(e,Le,t),n(e,j,t),n(e,Ze,t),n(e,C,t),n(e,qe,t),n(e,w,t),n(e,Xe,t),m(I,e,t),n(e,Ye,t),m(v,e,t),n(e,ze,t),m($,e,t),n(e,Pe,t),n(e,E,t),n(e,De,t),n(e,R,t),n(e,Oe,t),n(e,B,t),n(e,Ke,t),m(G,e,t),n(e,et,t),n(e,k,t),n(e,tt,t),m(N,e,t),n(e,lt,t),m(S,e,t),n(e,nt,t),n(e,x,t),n(e,at,t),n(e,A,t),n(e,st,t),n(e,_,t),n(e,it,t),n(e,H,t),n(e,rt,t),n(e,W,t),n(e,pt,t),m(V,e,t),n(e,ot,t),n(e,Q,t),n(e,ht,t),m(F,e,t),n(e,mt,t),n(e,L,t),n(e,ct,t),n(e,Z,t),n(e,dt,t),n(e,q,t),n(e,ut,t),m(X,e,t),n(e,yt,t),n(e,Y,t),n(e,Mt,t),m(z,e,t),n(e,Tt,t),n(e,P,t),n(e,wt,t),m(D,e,t),n(e,gt,t),n(e,O,t),n(e,bt,t),m(K,e,t),n(e,ft,t),n(e,ee,t),n(e,Jt,t),m(te,e,t),n(e,Ut,t),n(e,le,t),n(e,jt,t),m(ne,e,t),n(e,Ct,t),n(e,ae,t),n(e,It,t),n(e,se,t),n(e,vt,t),m(ie,e,t),n(e,$t,t),n(e,re,t),n(e,Et,t),n(e,pe,t),n(e,Rt,t),n(e,oe,t),n(e,Bt,t),n(e,he,t),n(e,Gt,t),m(me,e,t),n(e,kt,t),m(ce,e,t),n(e,Nt,t),n(e,de,t),n(e,St,t),m(ue,e,t),n(e,xt,t),n(e,ye,t),n(e,At,t),m(Me,e,t),n(e,_t,t),n(e,Te,t),n(e,Ht,t),n(e,we,t),n(e,Wt,t),m(ge,e,t),n(e,Vt,t),n(e,be,t),n(e,Qt,t),m(fe,e,t),n(e,Ft,t),n(e,Je,t),n(e,Lt,t),m(Ue,e,t),n(e,Zt,t),n(e,je,t),n(e,qt,t),n(e,Ce,t),n(e,Xt,t),m(Ie,e,t),n(e,Yt,t),n(e,ve,t),n(e,zt,t),m($e,e,t),n(e,Pt,t),n(e,Ee,t),n(e,Dt,t),m(Re,e,t),n(e,Ot,t),n(e,Be,t),n(e,Kt,t),n(e,Ge,t),n(e,el,t),m(ke,e,t),n(e,tl,t),n(e,Ne,t),n(e,ll,t),n(e,nl,t),n(e,al,t),m(Se,e,t),n(e,sl,t),n(e,Ae,t),il=!0},p:en,i(e){il||(c(g.$$.fragment,e),c(b.$$.fragment,e),c(I.$$.fragment,e),c(v.$$.fragment,e),c($.$$.fragment,e),c(G.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(V.$$.fragment,e),c(F.$$.fragment,e),c(X.$$.fragment,e),c(z.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(ue.$$.fragment,e),c(Me.$$.fragment,e),c(ge.$$.fragment,e),c(fe.$$.fragment,e),c(Ue.$$.fragment,e),c(Ie.$$.fragment,e),c($e.$$.fragment,e),c(Re.$$.fragment,e),c(ke.$$.fragment,e),c(Se.$$.fragment,e),il=!0)},o(e){d(g.$$.fragment,e),d(b.$$.fragment,e),d(I.$$.fragment,e),d(v.$$.fragment,e),d($.$$.fragment,e),d(G.$$.fragment,e),d(N.$$.fragment,e),d(S.$$.fragment,e),d(V.$$.fragment,e),d(F.$$.fragment,e),d(X.$$.fragment,e),d(z.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(me.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(Me.$$.fragment,e),d(ge.$$.fragment,e),d(fe.$$.fragment,e),d(Ue.$$.fragment,e),d(Ie.$$.fragment,e),d($e.$$.fragment,e),d(Re.$$.fragment,e),d(ke.$$.fragment,e),d(Se.$$.fragment,e),il=!1},d(e){e&&(l(_e),l(xe),l(He),l(We),l(Ve),l(f),l(Qe),l(J),l(Fe),l(U),l(Le),l(j),l(Ze),l(C),l(qe),l(w),l(Xe),l(Ye),l(ze),l(Pe),l(E),l(De),l(R),l(Oe),l(B),l(Ke),l(et),l(k),l(tt),l(lt),l(nt),l(x),l(at),l(A),l(st),l(_),l(it),l(H),l(rt),l(W),l(pt),l(ot),l(Q),l(ht),l(mt),l(L),l(ct),l(Z),l(dt),l(q),l(ut),l(yt),l(Y),l(Mt),l(Tt),l(P),l(wt),l(gt),l(O),l(bt),l(ft),l(ee),l(Jt),l(Ut),l(le),l(jt),l(Ct),l(ae),l(It),l(se),l(vt),l($t),l(re),l(Et),l(pe),l(Rt),l(oe),l(Bt),l(he),l(Gt),l(kt),l(Nt),l(de),l(St),l(xt),l(ye),l(At),l(_t),l(Te),l(Ht),l(we),l(Wt),l(Vt),l(be),l(Qt),l(Ft),l(Je),l(Lt),l(Zt),l(je),l(qt),l(Ce),l(Xt),l(Yt),l(ve),l(zt),l(Pt),l(Ee),l(Dt),l(Ot),l(Be),l(Kt),l(Ge),l(el),l(tl),l(Ne),l(ll),l(nl),l(al),l(sl),l(Ae)),l(T),u(g,e),u(b,e),u(I,e),u(v,e),u($,e),u(G,e),u(N,e),u(S,e),u(V,e),u(F,e),u(X,e),u(z,e),u(D,e),u(K,e),u(te,e),u(ne,e),u(ie,e),u(me,e),u(ce,e),u(ue,e),u(Me,e),u(ge,e),u(fe,e),u(Ue,e),u(Ie,e),u($e,e),u(Re,e),u(ke,e),u(Se,e)}}}const hn='{"title":"Enhancing RAG Reasoning with Knowledge Graphs","local":"enhancing-rag-reasoning-with-knowledge-graphs","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"Set up a Neo4j instance","local":"set-up-a-neo4j-instance","sections":[],"depth":3},{"title":"Loading Dataset into a Graph","local":"loading-dataset-into-a-graph","sections":[],"depth":3},{"title":"Building a Vector Index","local":"building-a-vector-index","sections":[],"depth":3}],"depth":2},{"title":"Q&A on Similarity","local":"qa-on-similarity","sections":[],"depth":2},{"title":"Traversing Knowledge Graphs for Inference","local":"traversing-knowledge-graphs-for-inference","sections":[{"title":"Graph-Cypher-Chain w/ LangChain","local":"graph-cypher-chain-w-langchain","sections":[],"depth":3},{"title":"Query Samples using Natural Language","local":"query-samples-using-natural-language","sections":[{"title":"” How many articles has published Emily Chen? ”","local":"-how-many-articles-has-published-emily-chen-","sections":[],"depth":4},{"title":"” Are there any pair of researchers who have published more than three articles together? ”","local":"-are-there-any-pair-of-researchers-who-have-published-more-than-three-articles-together-","sections":[],"depth":4},{"title":"” which researcher has collaborated with the most peers? ”","local":"-which-researcher-has-collaborated-with-the-most-peers-","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function mn(pl){return tn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mn extends ln{constructor(T){super(),nn(this,T,mn,on,Kl,{})}}export{Mn as component};
