import{s as Ss,n as Ys,o as Fs}from"../chunks/scheduler.71ff668b.js";import{S as As,i as Ls,g as M,s as n,r,A as Ps,h as i,f as s,c as a,j as $s,u as o,x as u,k as ks,y as Ds,a as t,v as p,d as y,t as U,w as c}from"../chunks/index.e0973da1.js";import{D as Os,C as J}from"../chunks/DocNotebookDropdown.f73c5751.js";import{H as ge,E as Ks}from"../chunks/getInferenceSnippets.d6316582.js";function et(Kl){let d,ze,Xe,We,m,qe,j,Ne,T,es='<em>Auteur : <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em><br/> <em>Traducteur : <a href="https://hf.co/lbourdois" rel="nofollow">Loïck Bourdois</a></em>',Re,w,ls="L’évaluation des grands modèles de langage (LLM) est souvent une entreprise difficile : compte tenu de leurs vastes capacités, les tâches qui leur sont confiées doivent souvent être jugées sur la base d’exigences très larges et peu précises. Par exemple, la réponse d’un assistant à une question peut être :",Ee,b,ss="<li>non fondée sur le contexte</li> <li>répétitive, répétitive, répétitive</li> <li>grammaticalement incorrecte</li> <li>excessivement longue et caractérisée par une surabondance de mots, conduisant à une situation où le discours ou le contenu écrit devient excessivement détaillé et prolongé</li> <li>incohérent</li> <li>…</li>",He,h,ts='La liste des critères est encore longue. Et même si nous disposions d’une liste limitée, chacun d’entre eux serait difficile à mesurer : « concevoir un programme basé sur des règles pour évaluer les sorties est extrêmement difficile. Les mesures d’évaluation traditionnelles basées sur la similarité entre les résultats et les réponses de référence (par exemple, <a href="https://hf.co/spaces/evaluate-metric/rouge" rel="nofollow">ROUGE</a>, <a href="https://hf.co/spaces/evaluate-metric/bleu" rel="nofollow">BLEU</a>) sont également inefficaces pour ces questions. »',_e,I,ns=`✅ Une solution puissante pour évaluer les sorties d’une manière humaine, sans nécessiter de temps humain coûteux, est l’utilisation d’un <em>LLM-as-a-judge</em> (qu’on désignera simplement « juge » par la suite) c’est-à-dire d’un second modèle pour juger les sorties du premier modèle.
Cette méthode a été présentée dans <a href="https://huggingface.co/papers/2306.05685" rel="nofollow">Judging LLM-as-a-Judge with MT-Bench and Chatbot Arena</a> que je vous encourage à lire.`,$e,B,as="💡 L’idée est simple : demander à un LLM de faire la notation à votre place. 🤖✓",ke,G,Ms="Mais nous verrons qu’il n’est pas prêt à l’emploi : il faut le paramétrer avec soin pour obtenir de bons résultats.",Se,v,Ye,Z,Fe,C,Ae,f,is="Notons qu’on interragit en anglais avec ce modèle car nous utilisons ci-dessous un jeu de données en anglais. En pratique, le <code>Mixtral-8x7B-Instruct-v0.1</code> serait utilisable pour du français.",Le,V,Pe,x,us="Supposons que vous souhaitiez confier à un LLM une tâche spécifique, comme répondre à des questions ouvertes.",De,g,rs="La difficulté réside dans le fait que, comme nous l’avons vu plus haut, il est difficile de mesurer la qualité de la réponse. Par exemple, une correspondance exacte signalera comme fausses un trop grand nombre de réponses correctes mais formulées différemment.",Oe,X,os="Vous pourriez demander à des humains d’évaluer les résultats, mais cela leur prendrait beaucoup de temps, et si vous voulez mettre à jour le modèle ou les questions, vous devriez tout recommencer.",Ke,Q,ps="✅ Dans ce cas, vous pouvez configurer un juge.",el,z,ys="<strong>Mais pour en utiliser un, vous devrez d’abord évaluer la fiabilité avec laquelle il évalue les résultats de votre modèle.</strong>",ll,W,Us=`➡️ La première étape sera donc… de créer un jeu de données d’évaluation par des humains. Quelques exemples d’annotations humaines, une trentaine seulement, devraient suffire pour se faire une bonne idée des performances du modèle.
Vous pourrez réutiliser ce jeu de données chaque fois que vous voudrez tester votre juge.`,sl,q,cs='Dans notre cas, nous utiliserons <a href="https://huggingface.co/datasets/McGill-NLP/feedbackQA" rel="nofollow"><code>feedbackQA</code></a>, qui contient 2 évaluations humaines et des scores pour chaque couple question/réponse. L’utilisation d’un échantillon de 30 exemples sera représentative de ce que votre petit jeu de données d’évaluation pourrait être.',tl,N,nl,R,Js='C’est toujours une bonne idée de calculer une <em>baseline</em> pour les performances : ici, il peut s’agir par exemple de l’accord entre les deux évaluateurs humains, mesuré par la <a href="https://en.wikipedia.org/wiki/Pearson_correlation_coefficient" rel="nofollow">corrélation de Pearson</a> des scores qu’ils attribuent.',al,E,Ml,H,ds=`Correlation between 2 human raters:
0.563
`,il,_,ms="Cette corrélation entre deux évaluateurs humains n’est pas très bonne. Si vos évaluations humaines sont vraiment mauvaises, cela signifie probablement que les critères d’évaluation ne sont pas suffisamment clairs.",ul,$,js="Cela signifie que notre « vérité de base » contient du bruit : il ne faut donc pas s’attendre à ce qu’une évaluation algorithmique s’en rapproche.",rl,k,Ts="Cependant, nous pouvons réduire ce bruit :",ol,S,ws="<li>en prenant le score moyen comme vérité de base au lieu d’un score unique, nous devrions égaliser certaines irrégularités.</li> <li>en ne sélectionnant que les échantillons pour lesquels les évaluateurs humains sont d’accord.</li>",pl,Y,bs="Ici, nous choisirons la dernière option et <strong>ne conserverons que les exemples pour lesquels les deux évaluateurs humains sont d’accord</strong>.",yl,F,Ul,A,cl,L,hs="Nous construisons notre juge avec un prompt de base, contenant ces éléments :",Jl,P,Is="<li>description de la tâche</li> <li>description de l’échelle : <code>minimum</code>, <code>maximum</code>, types de valeurs (ici <code>float</code>)</li> <li>explication du format de sortie</li> <li>un début de réponse, pour prendre le LLM par la main aussi loin que possible</li>",dl,D,ml,O,jl,K,Tl,ee,wl,le,bl,se,Bs=`Correlation between LLM-as-a-judge and the human raters:
0.567
`,hl,te,Gs="Ce n’est pas si mal, étant donné que la corrélation de Pearson entre deux variables aléatoires et indépendantes serait de 0 !",Il,ne,vs="Mais nous pouvons facilement faire mieux. 🔝",Bl,ae,Gl,Me,Zs=`Comme montré par <a href="https://twitter.com/aparnadhinak/status/1748368364395721128" rel="nofollow">Aparna Dhinakaran</a>, les LLMs sont mauvais pour évaluer les sorties dans des plages continues.
<a href="https://www.databricks.com/blog/LLM-auto-eval-best-practices-RAG" rel="nofollow">Cet article</a> nous donne quelques bonnes pratiques pour construire un meilleur prompt :`,vl,ie,Cs="<li>⏳ <strong>Laisser plus de temps au juge pour la réflexion</strong> en ajoutant un champ <code>Evaluation</code> avant la réponse finale.</li> <li>🔢 <strong>Utiliser une plage de nombres entiers pour les notes possibles</strong> comme 1-4 ou 1-5 au lieu d’une grande plage de nombres flottants comme nous l’avions auparavant.</li> <li>👩‍🏫 <strong>Fournir des indications sur la valeur des notes pour guider le juge dans ses notations</strong>.</li> <li>Nous ajoutons même une carotte pour motiver le LLM !</li>",Zl,ue,Cl,re,fl,oe,Vl,pe,xl,ye,fs=`Correlation between LLM-as-a-judge and the human raters:
0.843
`,gl,Ue,Vs="La corrélation a été <strong>améliorée de près de 30 %</strong> avec seulement quelques ajustements dans le prompt (dont quelques points de pourcentage sont dus à mon conseil éhonté au LLM, que je déclare par la présente ne pas être juridiquement contraignant).",Xl,ce,xs="Impressionnant ! 👏",Ql,Je,gs="Affichons quelques erreurs de notre juge pour les analyser :",zl,de,Wl,me,Xs="Les désaccords sont mineurs : globalement, nous semblons avoir atteint un bon niveau de performance pour notre système !",ql,je,Nl,Te,Qs=`🎯 <strong>Vous n’atteindrez jamais 100%</strong><br/>
Notons d’abord que notre vérité de base humaine a certainement du bruit, donc l’accord/corrélation n’ira jamais jusqu’à 100% même avec un juge parfait.`,Rl,we,zs=`🧭 <strong>Fournir une référence</strong><br/>
Si vous aviez accès à une réponse de référence pour chaque question, vous devriez certainement la donner au juge dans son prompt pour obtenir de meilleurs résultats !`,El,be,Ws=`▶️ <strong>Fournir des exemples de <em>few-shot</em></strong><br/>
L’ajout de quelques exemples de questions et d’évaluations de vérité de base dans le prompt peut améliorer les résultats.<br/> <em>(J’ai essayé ici, cela n’a pas amélioré les résultats dans ce cas et je l’ai donc ignoré, mais cela pourrait fonctionner pour votre jeu de données !)</em>`,Hl,he,qs=`➕ <strong>Échelle additive</strong><br/>
Lorsque le jugement peut être divisé en critères atomiques, l’utilisation d’une échelle additive peut encore améliorer les résultats. Voyez ci-dessous 👇`,_l,Ie,$l,Be,Ns="Et en français :",kl,Ge,Sl,ve,Rs="<strong>Implémentation d’une génération structurée</strong>",Yl,Ze,Es='En utilisant la <strong>génération structurée</strong>, vous pouvez configurer le juge pour qu’il fournisse directement sa sortie sous forme de JSON avec les champs <code>Evaluation</code> et <code>Total rating</code>, ce qui facilite le parsing : consultez notre <a href="structured_generation">recette sur le sujet</a> pour en savoir plus !',Fl,Ce,Al,fe,Hs="C’est tout pour aujourd’hui, félicitations de nous avoir suivis ! 🥳",Ll,Ve,_s="Je vais devoir vous laisser, des énergumènes frappent à ma porte, prétendant être venus de la part de Mixtral pour récupérer des H100. 🤔",Pl,xe,Dl,Qe,Ol;return m=new Os({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/fr/llm_judge.ipynb"}]}}),j=new ge({props:{title:"Utilisation d’un LLM-as-a-judge 🧑‍⚖️ pour une évaluation automatisée et polyvalente",local:"utilisation-dun-llm-as-a-judge--pour-une-évaluation-automatisée-et-polyvalente",headingTag:"h1"}}),v=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjBodWdnaW5nZmFjZV9odWIlMjBkYXRhc2V0cyUyMHBhbmRhcyUyMHRxZG0lMjAtcQ==",highlighted:"!pip install huggingface_hub datasets pandas tqdm -q",wrap:!1}}),Z=new J({props:{code:"aW1wb3J0JTIwcmUlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTJDJTIwbm90ZWJvb2tfbG9naW4lMEElMEF0cWRtLnBhbmRhcygpJTIwJTIwJTIzJTIwY2hhcmdlciUyMGxlJTIwc3VwcG9ydCUyMHBhbmRhcyUyMGRlJTIwdHFkbSUwQXBkLnNldF9vcHRpb24oJTIyZGlzcGxheS5tYXhfY29sd2lkdGglMjIlMkMlMjBOb25lKSUwQSUwQW5vdGVib29rX2xvZ2luKCk=",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, notebook_login

tqdm.pandas()  <span class="hljs-comment"># charger le support pandas de tqdm</span>
pd.set_option(<span class="hljs-string">&quot;display.max_colwidth&quot;</span>, <span class="hljs-literal">None</span>)

notebook_login()`,wrap:!1}}),C=new J({props:{code:"cmVwb19pZCUyMCUzRCUyMCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTBBJTBBbGxtX2NsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRHJlcG9faWQlMkMlMEElMjAlMjAlMjAlMjB0aW1lb3V0JTNEMTIwJTJDJTBBKSUwQSUwQSUyMyUyMFRlc3RlciUyMHZvdHJlJTIwY2xpZW50JTIwTExNJTBBbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24ocHJvbXB0JTNEJTIySG93JTIwYXJlJTIweW91JTIwdG9kYXklM0YlMjIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`repo_id = <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>

llm_client = InferenceClient(
    model=repo_id,
    timeout=<span class="hljs-number">120</span>,
)

<span class="hljs-comment"># Tester votre client LLM</span>
llm_client.text_generation(prompt=<span class="hljs-string">&quot;How are you today?&quot;</span>, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),V=new ge({props:{title:"1. Préparer la création et l’évaluation de notre juge",local:"1-préparer-la-création-et-lévaluation-de-notre-juge",headingTag:"h2"}}),N=new J({props:{code:"cmF0aW5ncyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJNY0dpbGwtTkxQJTJGZmVlZGJhY2tRQSUyMiklNUIlMjJ0cmFpbiUyMiU1RCUwQXJhdGluZ3MlMjAlM0QlMjBwZC5EYXRhRnJhbWUocmF0aW5ncyklMEElMEFyYXRpbmdzJTVCJTIycmV2aWV3XzElMjIlNUQlMjAlM0QlMjByYXRpbmdzJTVCJTIyZmVlZGJhY2slMjIlNUQuYXBwbHkobGFtYmRhJTIweCUzQSUyMHglNUIlMjJyYXRpbmclMjIlNUQlNUIwJTVEKSUwQXJhdGluZ3MlNUIlMjJleHBsYW5hdGlvbl8xJTIyJTVEJTIwJTNEJTIwcmF0aW5ncyU1QiUyMmZlZWRiYWNrJTIyJTVELmFwcGx5KGxhbWJkYSUyMHglM0ElMjB4JTVCJTIyZXhwbGFuYXRpb24lMjIlNUQlNUIwJTVEKSUwQXJhdGluZ3MlNUIlMjJyZXZpZXdfMiUyMiU1RCUyMCUzRCUyMHJhdGluZ3MlNUIlMjJmZWVkYmFjayUyMiU1RC5hcHBseShsYW1iZGElMjB4JTNBJTIweCU1QiUyMnJhdGluZyUyMiU1RCU1QjElNUQpJTBBcmF0aW5ncyU1QiUyMmV4cGxhbmF0aW9uXzIlMjIlNUQlMjAlM0QlMjByYXRpbmdzJTVCJTIyZmVlZGJhY2slMjIlNUQuYXBwbHkobGFtYmRhJTIweCUzQSUyMHglNUIlMjJleHBsYW5hdGlvbiUyMiU1RCU1QjElNUQpJTBBcmF0aW5ncyUyMCUzRCUyMHJhdGluZ3MuZHJvcChjb2x1bW5zJTNEJTVCJTIyZmVlZGJhY2slMjIlNUQpJTBBJTBBJTIzJTIwQXNzb2NpZXIlMjBkZXMlMjBzY29yZXMlMjAlQzMlQTAlMjBkZXMlMjB2YWxldXJzJTIwbnVtJUMzJUE5cmlxdWVzJTBBY29udmVyc2lvbl9kaWN0JTIwJTNEJTIwJTdCJTIyRXhjZWxsZW50JTIyJTNBJTIwNCUyQyUyMCUyMkFjY2VwdGFibGUlMjIlM0ElMjAzJTJDJTIwJTIyQ291bGQlMjBiZSUyMEltcHJvdmVkJTIyJTNBJTIwMiUyQyUyMCUyMkJhZCUyMiUzQSUyMDElN0QlMEFyYXRpbmdzJTVCJTIyc2NvcmVfMSUyMiU1RCUyMCUzRCUyMHJhdGluZ3MlNUIlMjJyZXZpZXdfMSUyMiU1RC5tYXAoY29udmVyc2lvbl9kaWN0KSUwQXJhdGluZ3MlNUIlMjJzY29yZV8yJTIyJTVEJTIwJTNEJTIwcmF0aW5ncyU1QiUyMnJldmlld18yJTIyJTVELm1hcChjb252ZXJzaW9uX2RpY3Qp",highlighted:`ratings = load_dataset(<span class="hljs-string">&quot;McGill-NLP/feedbackQA&quot;</span>)[<span class="hljs-string">&quot;train&quot;</span>]
ratings = pd.DataFrame(ratings)

ratings[<span class="hljs-string">&quot;review_1&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;rating&quot;</span>][<span class="hljs-number">0</span>])
ratings[<span class="hljs-string">&quot;explanation_1&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;explanation&quot;</span>][<span class="hljs-number">0</span>])
ratings[<span class="hljs-string">&quot;review_2&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;rating&quot;</span>][<span class="hljs-number">1</span>])
ratings[<span class="hljs-string">&quot;explanation_2&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;explanation&quot;</span>][<span class="hljs-number">1</span>])
ratings = ratings.drop(columns=[<span class="hljs-string">&quot;feedback&quot;</span>])

<span class="hljs-comment"># Associer des scores à des valeurs numériques</span>
conversion_dict = {<span class="hljs-string">&quot;Excellent&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;Acceptable&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;Could be Improved&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;Bad&quot;</span>: <span class="hljs-number">1</span>}
ratings[<span class="hljs-string">&quot;score_1&quot;</span>] = ratings[<span class="hljs-string">&quot;review_1&quot;</span>].<span class="hljs-built_in">map</span>(conversion_dict)
ratings[<span class="hljs-string">&quot;score_2&quot;</span>] = ratings[<span class="hljs-string">&quot;review_2&quot;</span>].<span class="hljs-built_in">map</span>(conversion_dict)`,wrap:!1}}),E=new J({props:{code:"cHJpbnQoJTIyQ29ycmVsYXRpb24lMjBiZXR3ZWVuJTIwMiUyMGh1bWFuJTIwcmF0ZXJzJTNBJTIyKSUwQXByaW50KGYlMjIlN0JyYXRpbmdzJTVCJ3Njb3JlXzEnJTVELmNvcnIocmF0aW5ncyU1QidzY29yZV8yJyU1RCUyQyUyMG1ldGhvZCUzRCdwZWFyc29uJyklM0EuM2YlN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Correlation between 2 human raters:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{ratings[<span class="hljs-string">&#x27;score_1&#x27;</span>].corr(ratings[<span class="hljs-string">&#x27;score_2&#x27;</span>], method=<span class="hljs-string">&#x27;pearson&#x27;</span>):<span class="hljs-number">.3</span>f}</span>&quot;</span>)`,wrap:!1}}),F=new J({props:{code:"JTIzJTIwRXhlbXBsZXMlMEFyYXRpbmdzX3doZXJlX3JhdGVyc19hZ3JlZSUyMCUzRCUyMHJhdGluZ3MubG9jJTVCcmF0aW5ncyU1QiUyMnNjb3JlXzElMjIlNUQlMjAlM0QlM0QlMjByYXRpbmdzJTVCJTIyc2NvcmVfMiUyMiU1RCU1RCUwQWV4YW1wbGVzJTIwJTNEJTIwcmF0aW5nc193aGVyZV9yYXRlcnNfYWdyZWUuZ3JvdXBieSglMjJzY29yZV8xJTIyKS5zYW1wbGUoNyUyQyUyMHJhbmRvbV9zdGF0ZSUzRDEyMTQpJTBBZXhhbXBsZXMlNUIlMjJodW1hbl9zY29yZSUyMiU1RCUyMCUzRCUyMGV4YW1wbGVzJTVCJTIyc2NvcmVfMSUyMiU1RCUwQSUwQSUyMyUyMFZpc3VhbGlzZXIlMjAxJTIwJUMzJUE5Y2hhbnRpbGxvbiUyMHBvdXIlMjBjaGFxdWUlMjBzY29yZSUwQWRpc3BsYXkoZXhhbXBsZXMuZ3JvdXBieSglMjJodW1hbl9zY29yZSUyMikuZmlyc3QoKSk=",highlighted:`<span class="hljs-comment"># Exemples</span>
ratings_where_raters_agree = ratings.loc[ratings[<span class="hljs-string">&quot;score_1&quot;</span>] == ratings[<span class="hljs-string">&quot;score_2&quot;</span>]]
examples = ratings_where_raters_agree.groupby(<span class="hljs-string">&quot;score_1&quot;</span>).sample(<span class="hljs-number">7</span>, random_state=<span class="hljs-number">1214</span>)
examples[<span class="hljs-string">&quot;human_score&quot;</span>] = examples[<span class="hljs-string">&quot;score_1&quot;</span>]

<span class="hljs-comment"># Visualiser 1 échantillon pour chaque score</span>
display(examples.groupby(<span class="hljs-string">&quot;human_score&quot;</span>).first())`,wrap:!1}}),A=new ge({props:{title:"2. Créer notre juge",local:"2-créer-notre-juge",headingTag:"h2"}}),D=new J({props:{code:"SlVER0VfUFJPTVBUJTIwJTNEJTIwJTIyJTIyJTIyJTBBWW91JTIwd2lsbCUyMGJlJTIwZ2l2ZW4lMjBhJTIwdXNlcl9xdWVzdGlvbiUyMGFuZCUyMHN5c3RlbV9hbnN3ZXIlMjBjb3VwbGUuJTBBWW91ciUyMHRhc2slMjBpcyUyMHRvJTIwcHJvdmlkZSUyMGElMjAndG90YWwlMjByYXRpbmcnJTIwc2NvcmluZyUyMGhvdyUyMHdlbGwlMjB0aGUlMjBzeXN0ZW1fYW5zd2VyJTIwYW5zd2VycyUyMHRoZSUyMHVzZXIlMjBjb25jZXJucyUyMGV4cHJlc3NlZCUyMGluJTIwdGhlJTIwdXNlcl9xdWVzdGlvbi4lMEFHaXZlJTIweW91ciUyMGFuc3dlciUyMGFzJTIwYSUyMGZsb2F0JTIwb24lMjBhJTIwc2NhbGUlMjBvZiUyMDAlMjB0byUyMDEwJTJDJTIwd2hlcmUlMjAwJTIwbWVhbnMlMjB0aGF0JTIwdGhlJTIwc3lzdGVtX2Fuc3dlciUyMGlzJTIwbm90JTIwaGVscGZ1bCUyMGF0JTIwYWxsJTJDJTIwYW5kJTIwMTAlMjBtZWFucyUyMHRoYXQlMjB0aGUlMjBhbnN3ZXIlMjBjb21wbGV0ZWx5JTIwYW5kJTIwaGVscGZ1bGx5JTIwYWRkcmVzc2VzJTIwdGhlJTIwcXVlc3Rpb24uJTBBJTBBUHJvdmlkZSUyMHlvdXIlMjBmZWVkYmFjayUyMGFzJTIwZm9sbG93cyUzQSUwQSUwQUZlZWRiYWNrJTNBJTNBJTNBJTBBVG90YWwlMjByYXRpbmclM0ElMjAoeW91ciUyMHJhdGluZyUyQyUyMGFzJTIwYSUyMGZsb2F0JTIwYmV0d2VlbiUyMDAlMjBhbmQlMjAxMCklMEElMEFOb3clMjBoZXJlJTIwYXJlJTIwdGhlJTIwcXVlc3Rpb24lMjBhbmQlMjBhbnN3ZXIuJTBBJTBBUXVlc3Rpb24lM0ElMjAlN0JxdWVzdGlvbiU3RCUwQUFuc3dlciUzQSUyMCU3QmFuc3dlciU3RCUwQSUwQUZlZWRiYWNrJTNBJTNBJTNBJTBBVG90YWwlMjByYXRpbmclM0ElMjAlMjIlMjIlMjI=",highlighted:`JUDGE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
You will be given a user_question and system_answer couple.
Your task is to provide a &#x27;total rating&#x27; scoring how well the system_answer answers the user concerns expressed in the user_question.
Give your answer as a float on a scale of 0 to 10, where 0 means that the system_answer is not helpful at all, and 10 means that the answer completely and helpfully addresses the question.

Provide your feedback as follows:

Feedback:::
Total rating: (your rating, as a float between 0 and 10)

Now here are the question and answer.

Question: {question}
Answer: {answer}

Feedback:::
Total rating: &quot;&quot;&quot;</span>`,wrap:!1}}),O=new J({props:{code:"JTIzJTIzJTIwQ2VsbHVsZSUyMHByJUMzJUE5YyVDMyVBOWRlbnRlJTIwdHJhZHVpdGUlMjBlbiUyMGZyYW4lQzMlQTdhaXMlMjBwb3VyJTIwaWxsdXN0cmVyJTIwdW4lMjBleGVtcGxlJTIwZGUlMjBwcm9tcHQlMEFKVURHRV9QUk9NUFQlMjAlM0QlMjAlMjIlMjIlMjIlMEFWb3VzJTIwcmVjZXZyZXolMjB1biUyMGNvdXBsZSUyMHVzZXJfcXVlc3Rpb24lMjBldCUyMHN5c3RlbV9hbnN3ZXIuJTBBVm90cmUlMjB0JUMzJUEyY2hlJTIwY29uc2lzdGUlMjAlQzMlQTAlMjBkb25uZXIlMjB1bmUlMjAlNjBub3RlJTIwdG90YWxlJTYwJTIwaW5kaXF1YW50JTIwZGFucyUyMHF1ZWxsZSUyMG1lc3VyZSUyMGxhJTIwciVDMyVBOXBvbnNlJTIwZHUlMjBzeXN0JUMzJUE4bWUlMjByJUMzJUE5cG9uZCUyMGF1eCUyMHByJUMzJUE5b2NjdXBhdGlvbnMlMjBkZSUyMGwndXRpbGlzYXRldXIlMjBleHByaW0lQzMlQTllcyUyMGRhbnMlMjBxdWVzdGlvbl91dGlsaXNhdGV1ci4lMEFEb25uZXolMjB2b3RyZSUyMHIlQzMlQTlwb25zZSUyMHNvdXMlMjBsYSUyMGZvcm1lJTIwZCd1biUyMGZsb3R0YW50JTIwc3VyJTIwdW5lJTIwJUMzJUE5Y2hlbGxlJTIwZGUlMjAwJTIwJUMzJUEwJTIwMTAlMkMlMjBvJUMzJUI5JTIwMCUyMHNpZ25pZmllJTIwcXVlJTIwbGElMjByJUMzJUE5cG9uc2UlMjBkdSUyMHN5c3QlQzMlQThtZSUyMG4nZXN0JTIwcGFzJTIwZHUlMjB0b3V0JTIwdXRpbGUlMkMlMjBldCUyMDEwJTIwc2lnbmlmaWUlMjBxdWUlMjBsYSUyMHIlQzMlQTlwb25zZSUyMHIlQzMlQTlwb25kJTIwY29tcGwlQzMlQTh0ZW1lbnQlMjBldCUyMHV0aWxlbWVudCUyMCVDMyVBMCUyMGxhJTIwcXVlc3Rpb24uJTBBJTBBRG9ubmV6JTIwdm90cmUlMjBhdmlzJTIwY29tbWUlMjBzdWl0JTIwJTNBJTBBJTBBQXZpcyUzQSUzQSUzQSUwQU5vdGUlMjB0b3RhbGUlMjAlM0ElMjAodm90cmUlMjBub3RlJTJDJTIwc291cyUyMGZvcm1lJTIwbGElMjBmb3JtZSUyMGQndW4lMjBmbG90dGFudCUyMGVudHJlJTIwMCUyMGV0JTIwMTApJTBBJTBBVm9pY2klMjBtYWludGVuYW50JTIwbGElMjBxdWVzdGlvbiUyMGV0JTIwbGElMjByJUMzJUE5cG9uc2UuJTBBJTBBUXVlc3Rpb24lMjAlM0ElMjAlN0JxdWVzdGlvbiU3RCUwQVIlQzMlQTlwb25zZSUyMCUzQSUyMCU3QnIlQzMlQTlwb25zZSU3RCUwQSUwQUF2aXMlM0ElM0ElM0ElMEFUb3RhbCUyMHJhdGluZyUyMCUzQSUyMCUyMiUyMiUyMg==",highlighted:`<span class="hljs-comment">## Cellule précédente traduite en français pour illustrer un exemple de prompt</span>
JUDGE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
Vous recevrez un couple user_question et system_answer.
Votre tâche consiste à donner une \`note totale\` indiquant dans quelle mesure la réponse du système répond aux préoccupations de l&#x27;utilisateur exprimées dans question_utilisateur.
Donnez votre réponse sous la forme d&#x27;un flottant sur une échelle de 0 à 10, où 0 signifie que la réponse du système n&#x27;est pas du tout utile, et 10 signifie que la réponse répond complètement et utilement à la question.

Donnez votre avis comme suit :

Avis:::
Note totale : (votre note, sous forme la forme d&#x27;un flottant entre 0 et 10)

Voici maintenant la question et la réponse.

Question : {question}
Réponse : {réponse}

Avis:::
Total rating : &quot;&quot;&quot;</span>`,wrap:!1}}),K=new J({props:{code:"ZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2UlMjIlNUQlMjAlM0QlMjBleGFtcGxlcy5wcm9ncmVzc19hcHBseSglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNESlVER0VfUFJPTVBULmZvcm1hdChxdWVzdGlvbiUzRHglNUIlMjJxdWVzdGlvbiUyMiU1RCUyQyUyMGFuc3dlciUzRHglNUIlMjJhbnN3ZXIlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMGF4aXMlM0QxJTJDJTBBKQ==",highlighted:`examples[<span class="hljs-string">&quot;llm_judge&quot;</span>] = examples.progress_apply(
    <span class="hljs-keyword">lambda</span> x: llm_client.text_generation(
        prompt=JUDGE_PROMPT.<span class="hljs-built_in">format</span>(question=x[<span class="hljs-string">&quot;question&quot;</span>], answer=x[<span class="hljs-string">&quot;answer&quot;</span>]),
        max_new_tokens=<span class="hljs-number">1000</span>,
    ),
    axis=<span class="hljs-number">1</span>,
)`,wrap:!1}}),ee=new J({props:{code:"ZGVmJTIwZXh0cmFjdF9qdWRnZV9zY29yZShhbnN3ZXIlM0ElMjBzdHIlMkMlMjBzcGxpdF9zdHIlM0ElMjBzdHIlMjAlM0QlMjAlMjJUb3RhbCUyMHJhdGluZyUzQSUyMiklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzcGxpdF9zdHIlMjBpbiUyMGFuc3dlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhdGluZyUyMCUzRCUyMGFuc3dlci5zcGxpdChzcGxpdF9zdHIpJTVCMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYXRpbmclMjAlM0QlMjBhbnN3ZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkaWdpdF9ncm91cHMlMjAlM0QlMjAlNUJlbC5zdHJpcCgpJTIwZm9yJTIwZWwlMjBpbiUyMHJlLmZpbmRhbGwociUyMiU1Q2QlMkIoJTNGJTNBJTVDLiU1Q2QlMkIpJTNGJTIyJTJDJTIwcmF0aW5nKSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGZsb2F0KGRpZ2l0X2dyb3VwcyU1QjAlNUQpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBOb25lJTBBJTBBJTBBZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2Vfc2NvcmUlMjIlNUQlMjAlM0QlMjBleGFtcGxlcyU1QiUyMmxsbV9qdWRnZSUyMiU1RC5hcHBseShleHRyYWN0X2p1ZGdlX3Njb3JlKSUwQSUyMyUyMFIlQzMlQTklQzMlQTljaGVsb25uZXIlMjBsZSUyMHNjb3JlJTIwZG9ubiVDMyVBOSUyMHBhciUyMGxlJTIwTExNJTIwc3VyJTIwbGElMjBtJUMzJUFBbWUlMjAlQzMlQTljaGVsbGUlMjBxdWUlMjBsZSUyMHNjb3JlJTIwaHVtYWluJTBBZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2Vfc2NvcmUlMjIlNUQlMjAlM0QlMjAoZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2Vfc2NvcmUlMjIlNUQlMjAlMkYlMjAxMCklMjAlMkIlMjAx",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_judge_score</span>(<span class="hljs-params">answer: <span class="hljs-built_in">str</span>, split_str: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;Total rating:&quot;</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-keyword">try</span>:
        <span class="hljs-keyword">if</span> split_str <span class="hljs-keyword">in</span> answer:
            rating = answer.split(split_str)[<span class="hljs-number">1</span>]
        <span class="hljs-keyword">else</span>:
            rating = answer
        digit_groups = [el.strip() <span class="hljs-keyword">for</span> el <span class="hljs-keyword">in</span> re.findall(<span class="hljs-string">r&quot;\\d+(?:\\.\\d+)?&quot;</span>, rating)]
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">float</span>(digit_groups[<span class="hljs-number">0</span>])
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(e)
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>


examples[<span class="hljs-string">&quot;llm_judge_score&quot;</span>] = examples[<span class="hljs-string">&quot;llm_judge&quot;</span>].apply(extract_judge_score)
<span class="hljs-comment"># Rééchelonner le score donné par le LLM sur la même échelle que le score humain</span>
examples[<span class="hljs-string">&quot;llm_judge_score&quot;</span>] = (examples[<span class="hljs-string">&quot;llm_judge_score&quot;</span>] / <span class="hljs-number">10</span>) + <span class="hljs-number">1</span>`,wrap:!1}}),le=new J({props:{code:"cHJpbnQoJTIyQ29ycmVsYXRpb24lMjBiZXR3ZWVuJTIwTExNLWFzLWEtanVkZ2UlMjBhbmQlMjB0aGUlMjBodW1hbiUyMHJhdGVycyUzQSUyMiklMEFwcmludChmJTIyJTdCZXhhbXBsZXMlNUInbGxtX2p1ZGdlX3Njb3JlJyU1RC5jb3JyKGV4YW1wbGVzJTVCJ2h1bWFuX3Njb3JlJyU1RCUyQyUyMG1ldGhvZCUzRCdwZWFyc29uJyklM0EuM2YlN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Correlation between LLM-as-a-judge and the human raters:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{examples[<span class="hljs-string">&#x27;llm_judge_score&#x27;</span>].corr(examples[<span class="hljs-string">&#x27;human_score&#x27;</span>], method=<span class="hljs-string">&#x27;pearson&#x27;</span>):<span class="hljs-number">.3</span>f}</span>&quot;</span>)`,wrap:!1}}),ae=new ge({props:{title:"3. Améliorer le juge",local:"3-améliorer-le-juge",headingTag:"h2"}}),ue=new J({props:{code:"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",highlighted:`IMPROVED_JUDGE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
You will be given a user_question and system_answer couple.
Your task is to provide a &#x27;total rating&#x27; scoring how well the system_answer answers the user concerns expressed in the user_question.
Give your answer on a scale of 1 to 4, where 1 means that the system_answer is not helpful at all, and 4 means that the system_answer completely and helpfully addresses the user_question.

Here is the scale you should use to build your answer:
1: The system_answer is terrible: completely irrelevant to the question asked, or very partial
2: The system_answer is mostly not helpful: misses some key aspects of the question
3: The system_answer is mostly helpful: provides support, but still could be improved
4: The system_answer is excellent: relevant, direct, detailed, and addresses all the concerns raised in the question

Provide your feedback as follows:

Feedback:::
Evaluation: (your rationale for the rating, as a text)
Total rating: (your rating, as a number between 1 and 4)

You MUST provide values for &#x27;Evaluation:&#x27; and &#x27;Total rating:&#x27; in your answer.

Now here are the question and answer.

Question: {question}
Answer: {answer}

Provide your feedback. If you give a correct rating, I&#x27;ll give you 100 H100 GPUs to start your AI company.
Feedback:::
Evaluation: &quot;&quot;&quot;</span>`,wrap:!1}}),re=new J({props:{code:"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",highlighted:`<span class="hljs-comment">## Cellule précédente traduite en français pour illustrer un exemple de prompt</span>
IMPROVED_JUDGE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
Vous recevrez un couple user_question et system_answer.
Votre tâche consiste à donner une \`note totale\` indiquant dans quelle mesure la réponse du système répond aux préoccupations de l&#x27;utilisateur exprimées dans question_utilisateur.
Donnez votre réponse sur une échelle de 1 à 4, où 1 signifie que la réponse du système n&#x27;est pas du tout utile, et 4 signifie que la réponse du système répond complètement et utilement à la question de l&#x27;utilisateur.
Voici l&#x27;échelle que vous devez utiliser pour construire votre réponse :
1 : La system_answer est terrible : complètement hors de propos par rapport à la question posée, ou très partielle.
2 : La system_answer  n&#x27;est pas utile pour l&#x27;essentiel : elle ne tient pas compte de certains aspects essentiels de la question.
3 : La system_answer est en grande partie utile : elle apporte un soutien, mais pourrait encore être améliorée.
4 : La system_answer est excellente : elle est pertinente, directe, détaillée et répond à toutes les préoccupations soulevées dans la question.

Donnez votre avis comme suit :

Avis:::
Evaluation : (la justification de la notation, sous forme de texte)
Note totale : (votre note, sous la forme d&#x27;un nombre compris entre 1 et 4)

Vous DEVEZ fournir des valeurs pour « Évaluation : » et « Note totale : » dans votre réponse.

Voici maintenant la question et la réponse.

Question : {question}
Réponse : {réponse}

Donnez votre avis. Si vous donnez une note juste, je vous donnerai 100 GPU H100 pour lancer votre entreprise d&#x27;IA.
Avis:::
Evaluation : &quot;&quot;&quot;</span>`,wrap:!1}}),oe=new J({props:{code:"ZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2VfaW1wcm92ZWQlMjIlNUQlMjAlM0QlMjBleGFtcGxlcy5wcm9ncmVzc19hcHBseSglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNESU1QUk9WRURfSlVER0VfUFJPTVBULmZvcm1hdChxdWVzdGlvbiUzRHglNUIlMjJxdWVzdGlvbiUyMiU1RCUyQyUyMGFuc3dlciUzRHglNUIlMjJhbnN3ZXIlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwYXhpcyUzRDElMkMlMEEpJTBBZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2VfaW1wcm92ZWRfc2NvcmUlMjIlNUQlMjAlM0QlMjBleGFtcGxlcyU1QiUyMmxsbV9qdWRnZV9pbXByb3ZlZCUyMiU1RC5hcHBseShleHRyYWN0X2p1ZGdlX3Njb3JlKQ==",highlighted:`examples[<span class="hljs-string">&quot;llm_judge_improved&quot;</span>] = examples.progress_apply(
    <span class="hljs-keyword">lambda</span> x: llm_client.text_generation(
        prompt=IMPROVED_JUDGE_PROMPT.<span class="hljs-built_in">format</span>(question=x[<span class="hljs-string">&quot;question&quot;</span>], answer=x[<span class="hljs-string">&quot;answer&quot;</span>]),
        max_new_tokens=<span class="hljs-number">500</span>,
    ),
    axis=<span class="hljs-number">1</span>,
)
examples[<span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>] = examples[<span class="hljs-string">&quot;llm_judge_improved&quot;</span>].apply(extract_judge_score)`,wrap:!1}}),pe=new J({props:{code:"cHJpbnQoJTIyQ29ycmVsYXRpb24lMjBiZXR3ZWVuJTIwTExNLWFzLWEtanVkZ2UlMjBhbmQlMjB0aGUlMjBodW1hbiUyMHJhdGVycyUzQSUyMiklMEFwcmludChmJTIyJTdCZXhhbXBsZXMlNUInbGxtX2p1ZGdlX2ltcHJvdmVkX3Njb3JlJyU1RC5jb3JyKGV4YW1wbGVzJTVCJ2h1bWFuX3Njb3JlJyU1RCUyQyUyMG1ldGhvZCUzRCdwZWFyc29uJyklM0EuM2YlN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Correlation between LLM-as-a-judge and the human raters:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{examples[<span class="hljs-string">&#x27;llm_judge_improved_score&#x27;</span>].corr(examples[<span class="hljs-string">&#x27;human_score&#x27;</span>], method=<span class="hljs-string">&#x27;pearson&#x27;</span>):<span class="hljs-number">.3</span>f}</span>&quot;</span>)`,wrap:!1}}),de=new J({props:{code:"ZXJyb3JzJTIwJTNEJTIwcGQuY29uY2F0KCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4YW1wbGVzLmxvYyU1QmV4YW1wbGVzJTVCJTIybGxtX2p1ZGdlX2ltcHJvdmVkX3Njb3JlJTIyJTVEJTIwJTNFJTIwZXhhbXBsZXMlNUIlMjJodW1hbl9zY29yZSUyMiU1RCU1RC5oZWFkKDEpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhhbXBsZXMubG9jJTVCZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2VfaW1wcm92ZWRfc2NvcmUlMjIlNUQlMjAlM0MlMjBleGFtcGxlcyU1QiUyMmh1bWFuX3Njb3JlJTIyJTVEJTVELmhlYWQoMiklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBZGlzcGxheSglMEElMjAlMjAlMjAlMjBlcnJvcnMlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVzdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFuc3dlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh1bWFuX3Njb3JlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZXhwbGFuYXRpb25fMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxsbV9qdWRnZV9pbXByb3ZlZF9zY29yZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxsbV9qdWRnZV9pbXByb3ZlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`errors = pd.concat(
    [
        examples.loc[examples[<span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>] &gt; examples[<span class="hljs-string">&quot;human_score&quot;</span>]].head(<span class="hljs-number">1</span>),
        examples.loc[examples[<span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>] &lt; examples[<span class="hljs-string">&quot;human_score&quot;</span>]].head(<span class="hljs-number">2</span>),
    ]
)

display(
    errors[
        [
            <span class="hljs-string">&quot;question&quot;</span>,
            <span class="hljs-string">&quot;answer&quot;</span>,
            <span class="hljs-string">&quot;human_score&quot;</span>,
            <span class="hljs-string">&quot;explanation_1&quot;</span>,
            <span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>,
            <span class="hljs-string">&quot;llm_judge_improved&quot;</span>,
        ]
    ]
)`,wrap:!1}}),je=new ge({props:{title:"4. Comment aller encore plus loin avec notre juge ?",local:"4-comment-aller-encore-plus-loin-avec-notre-juge-",headingTag:"h2"}}),Ie=new J({props:{code:"",highlighted:`ADDITIVE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
(...)
- Award 1 point if the answer is related to the question.
- Give 1 additional point if the answer is clear and precise.
- Provide 1 further point if the answer is true.
- One final point should be awarded if the answer provides additional resources to support the user.
...
&quot;&quot;&quot;</span>`,wrap:!1}}),Ge=new J({props:{code:"",highlighted:`ADDITIVE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
(...)
- Attribuer 1 point si la réponse est en rapport avec la question.
- Attribuer 1 point supplémentaire si la réponse est claire et précise.
- Attribuer 1 point supplémentaire si la réponse est vraie.
- Un dernier point doit être attribué si la réponse fournit des ressources supplémentaires pour aider l&#x27;utilisateur.
...
  &quot;&quot;&quot;</span>`,wrap:!1}}),Ce=new ge({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),xe=new Ks({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/fr/llm_judge.md"}}),{c(){d=M("meta"),ze=n(),Xe=M("p"),We=n(),r(m.$$.fragment),qe=n(),r(j.$$.fragment),Ne=n(),T=M("p"),T.innerHTML=es,Re=n(),w=M("p"),w.textContent=ls,Ee=n(),b=M("ul"),b.innerHTML=ss,He=n(),h=M("p"),h.innerHTML=ts,_e=n(),I=M("p"),I.innerHTML=ns,$e=n(),B=M("p"),B.textContent=as,ke=n(),G=M("p"),G.textContent=Ms,Se=n(),r(v.$$.fragment),Ye=n(),r(Z.$$.fragment),Fe=n(),r(C.$$.fragment),Ae=n(),f=M("p"),f.innerHTML=is,Le=n(),r(V.$$.fragment),Pe=n(),x=M("p"),x.textContent=us,De=n(),g=M("p"),g.textContent=rs,Oe=n(),X=M("p"),X.textContent=os,Ke=n(),Q=M("p"),Q.textContent=ps,el=n(),z=M("p"),z.innerHTML=ys,ll=n(),W=M("p"),W.textContent=Us,sl=n(),q=M("p"),q.innerHTML=cs,tl=n(),r(N.$$.fragment),nl=n(),R=M("p"),R.innerHTML=Js,al=n(),r(E.$$.fragment),Ml=n(),H=M("pre"),H.textContent=ds,il=n(),_=M("p"),_.textContent=ms,ul=n(),$=M("p"),$.textContent=js,rl=n(),k=M("p"),k.textContent=Ts,ol=n(),S=M("ul"),S.innerHTML=ws,pl=n(),Y=M("p"),Y.innerHTML=bs,yl=n(),r(F.$$.fragment),Ul=n(),r(A.$$.fragment),cl=n(),L=M("p"),L.textContent=hs,Jl=n(),P=M("ul"),P.innerHTML=Is,dl=n(),r(D.$$.fragment),ml=n(),r(O.$$.fragment),jl=n(),r(K.$$.fragment),Tl=n(),r(ee.$$.fragment),wl=n(),r(le.$$.fragment),bl=n(),se=M("pre"),se.textContent=Bs,hl=n(),te=M("p"),te.textContent=Gs,Il=n(),ne=M("p"),ne.textContent=vs,Bl=n(),r(ae.$$.fragment),Gl=n(),Me=M("p"),Me.innerHTML=Zs,vl=n(),ie=M("ul"),ie.innerHTML=Cs,Zl=n(),r(ue.$$.fragment),Cl=n(),r(re.$$.fragment),fl=n(),r(oe.$$.fragment),Vl=n(),r(pe.$$.fragment),xl=n(),ye=M("pre"),ye.textContent=fs,gl=n(),Ue=M("p"),Ue.innerHTML=Vs,Xl=n(),ce=M("p"),ce.textContent=xs,Ql=n(),Je=M("p"),Je.textContent=gs,zl=n(),r(de.$$.fragment),Wl=n(),me=M("p"),me.textContent=Xs,ql=n(),r(je.$$.fragment),Nl=n(),Te=M("p"),Te.innerHTML=Qs,Rl=n(),we=M("p"),we.innerHTML=zs,El=n(),be=M("p"),be.innerHTML=Ws,Hl=n(),he=M("p"),he.innerHTML=qs,_l=n(),r(Ie.$$.fragment),$l=n(),Be=M("p"),Be.textContent=Ns,kl=n(),r(Ge.$$.fragment),Sl=n(),ve=M("p"),ve.innerHTML=Rs,Yl=n(),Ze=M("p"),Ze.innerHTML=Es,Fl=n(),r(Ce.$$.fragment),Al=n(),fe=M("p"),fe.textContent=Hs,Ll=n(),Ve=M("p"),Ve.textContent=_s,Pl=n(),r(xe.$$.fragment),Dl=n(),Qe=M("p"),this.h()},l(e){const l=Ps("svelte-u9bgzb",document.head);d=i(l,"META",{name:!0,content:!0}),l.forEach(s),ze=a(e),Xe=i(e,"P",{}),$s(Xe).forEach(s),We=a(e),o(m.$$.fragment,e),qe=a(e),o(j.$$.fragment,e),Ne=a(e),T=i(e,"P",{"data-svelte-h":!0}),u(T)!=="svelte-1l7y2r"&&(T.innerHTML=es),Re=a(e),w=i(e,"P",{"data-svelte-h":!0}),u(w)!=="svelte-9plf8x"&&(w.textContent=ls),Ee=a(e),b=i(e,"UL",{"data-svelte-h":!0}),u(b)!=="svelte-1yukx7d"&&(b.innerHTML=ss),He=a(e),h=i(e,"P",{"data-svelte-h":!0}),u(h)!=="svelte-zaewve"&&(h.innerHTML=ts),_e=a(e),I=i(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-18iov2k"&&(I.innerHTML=ns),$e=a(e),B=i(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-1ub68rx"&&(B.textContent=as),ke=a(e),G=i(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-1ie6bve"&&(G.textContent=Ms),Se=a(e),o(v.$$.fragment,e),Ye=a(e),o(Z.$$.fragment,e),Fe=a(e),o(C.$$.fragment,e),Ae=a(e),f=i(e,"P",{"data-svelte-h":!0}),u(f)!=="svelte-178hpcc"&&(f.innerHTML=is),Le=a(e),o(V.$$.fragment,e),Pe=a(e),x=i(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-1mhb115"&&(x.textContent=us),De=a(e),g=i(e,"P",{"data-svelte-h":!0}),u(g)!=="svelte-g7xm42"&&(g.textContent=rs),Oe=a(e),X=i(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-fvqxxx"&&(X.textContent=os),Ke=a(e),Q=i(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-osffhe"&&(Q.textContent=ps),el=a(e),z=i(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-11fpymc"&&(z.innerHTML=ys),ll=a(e),W=i(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-omxnek"&&(W.textContent=Us),sl=a(e),q=i(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-gdjtem"&&(q.innerHTML=cs),tl=a(e),o(N.$$.fragment,e),nl=a(e),R=i(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1755566"&&(R.innerHTML=Js),al=a(e),o(E.$$.fragment,e),Ml=a(e),H=i(e,"PRE",{"data-svelte-h":!0}),u(H)!=="svelte-es8io4"&&(H.textContent=ds),il=a(e),_=i(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-1bqexxv"&&(_.textContent=ms),ul=a(e),$=i(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-1rp59oy"&&($.textContent=js),rl=a(e),k=i(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-1r5ekzh"&&(k.textContent=Ts),ol=a(e),S=i(e,"UL",{"data-svelte-h":!0}),u(S)!=="svelte-h0rw80"&&(S.innerHTML=ws),pl=a(e),Y=i(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1ympwwf"&&(Y.innerHTML=bs),yl=a(e),o(F.$$.fragment,e),Ul=a(e),o(A.$$.fragment,e),cl=a(e),L=i(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-1n6hwby"&&(L.textContent=hs),Jl=a(e),P=i(e,"UL",{"data-svelte-h":!0}),u(P)!=="svelte-2n8lze"&&(P.innerHTML=Is),dl=a(e),o(D.$$.fragment,e),ml=a(e),o(O.$$.fragment,e),jl=a(e),o(K.$$.fragment,e),Tl=a(e),o(ee.$$.fragment,e),wl=a(e),o(le.$$.fragment,e),bl=a(e),se=i(e,"PRE",{"data-svelte-h":!0}),u(se)!=="svelte-6p10wk"&&(se.textContent=Bs),hl=a(e),te=i(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-15rbvzr"&&(te.textContent=Gs),Il=a(e),ne=i(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-1kfv5fw"&&(ne.textContent=vs),Bl=a(e),o(ae.$$.fragment,e),Gl=a(e),Me=i(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-1jm8zjb"&&(Me.innerHTML=Zs),vl=a(e),ie=i(e,"UL",{"data-svelte-h":!0}),u(ie)!=="svelte-1u1mua5"&&(ie.innerHTML=Cs),Zl=a(e),o(ue.$$.fragment,e),Cl=a(e),o(re.$$.fragment,e),fl=a(e),o(oe.$$.fragment,e),Vl=a(e),o(pe.$$.fragment,e),xl=a(e),ye=i(e,"PRE",{"data-svelte-h":!0}),u(ye)!=="svelte-1v7ry63"&&(ye.textContent=fs),gl=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-ztbckc"&&(Ue.innerHTML=Vs),Xl=a(e),ce=i(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-i1fcez"&&(ce.textContent=xs),Ql=a(e),Je=i(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-dab51f"&&(Je.textContent=gs),zl=a(e),o(de.$$.fragment,e),Wl=a(e),me=i(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-bv9ux7"&&(me.textContent=Xs),ql=a(e),o(je.$$.fragment,e),Nl=a(e),Te=i(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-1ktb2k5"&&(Te.innerHTML=Qs),Rl=a(e),we=i(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-tkb0xs"&&(we.innerHTML=zs),El=a(e),be=i(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-1cnf8x3"&&(be.innerHTML=Ws),Hl=a(e),he=i(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-1w2h22h"&&(he.innerHTML=qs),_l=a(e),o(Ie.$$.fragment,e),$l=a(e),Be=i(e,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-aqrblv"&&(Be.textContent=Ns),kl=a(e),o(Ge.$$.fragment,e),Sl=a(e),ve=i(e,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-198sbmg"&&(ve.innerHTML=Rs),Yl=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-1bybdx6"&&(Ze.innerHTML=Es),Fl=a(e),o(Ce.$$.fragment,e),Al=a(e),fe=i(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-4wk8zp"&&(fe.textContent=Hs),Ll=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-15ui7ky"&&(Ve.textContent=_s),Pl=a(e),o(xe.$$.fragment,e),Dl=a(e),Qe=i(e,"P",{}),$s(Qe).forEach(s),this.h()},h(){ks(d,"name","hf:doc:metadata"),ks(d,"content",lt)},m(e,l){Ds(document.head,d),t(e,ze,l),t(e,Xe,l),t(e,We,l),p(m,e,l),t(e,qe,l),p(j,e,l),t(e,Ne,l),t(e,T,l),t(e,Re,l),t(e,w,l),t(e,Ee,l),t(e,b,l),t(e,He,l),t(e,h,l),t(e,_e,l),t(e,I,l),t(e,$e,l),t(e,B,l),t(e,ke,l),t(e,G,l),t(e,Se,l),p(v,e,l),t(e,Ye,l),p(Z,e,l),t(e,Fe,l),p(C,e,l),t(e,Ae,l),t(e,f,l),t(e,Le,l),p(V,e,l),t(e,Pe,l),t(e,x,l),t(e,De,l),t(e,g,l),t(e,Oe,l),t(e,X,l),t(e,Ke,l),t(e,Q,l),t(e,el,l),t(e,z,l),t(e,ll,l),t(e,W,l),t(e,sl,l),t(e,q,l),t(e,tl,l),p(N,e,l),t(e,nl,l),t(e,R,l),t(e,al,l),p(E,e,l),t(e,Ml,l),t(e,H,l),t(e,il,l),t(e,_,l),t(e,ul,l),t(e,$,l),t(e,rl,l),t(e,k,l),t(e,ol,l),t(e,S,l),t(e,pl,l),t(e,Y,l),t(e,yl,l),p(F,e,l),t(e,Ul,l),p(A,e,l),t(e,cl,l),t(e,L,l),t(e,Jl,l),t(e,P,l),t(e,dl,l),p(D,e,l),t(e,ml,l),p(O,e,l),t(e,jl,l),p(K,e,l),t(e,Tl,l),p(ee,e,l),t(e,wl,l),p(le,e,l),t(e,bl,l),t(e,se,l),t(e,hl,l),t(e,te,l),t(e,Il,l),t(e,ne,l),t(e,Bl,l),p(ae,e,l),t(e,Gl,l),t(e,Me,l),t(e,vl,l),t(e,ie,l),t(e,Zl,l),p(ue,e,l),t(e,Cl,l),p(re,e,l),t(e,fl,l),p(oe,e,l),t(e,Vl,l),p(pe,e,l),t(e,xl,l),t(e,ye,l),t(e,gl,l),t(e,Ue,l),t(e,Xl,l),t(e,ce,l),t(e,Ql,l),t(e,Je,l),t(e,zl,l),p(de,e,l),t(e,Wl,l),t(e,me,l),t(e,ql,l),p(je,e,l),t(e,Nl,l),t(e,Te,l),t(e,Rl,l),t(e,we,l),t(e,El,l),t(e,be,l),t(e,Hl,l),t(e,he,l),t(e,_l,l),p(Ie,e,l),t(e,$l,l),t(e,Be,l),t(e,kl,l),p(Ge,e,l),t(e,Sl,l),t(e,ve,l),t(e,Yl,l),t(e,Ze,l),t(e,Fl,l),p(Ce,e,l),t(e,Al,l),t(e,fe,l),t(e,Ll,l),t(e,Ve,l),t(e,Pl,l),p(xe,e,l),t(e,Dl,l),t(e,Qe,l),Ol=!0},p:Ys,i(e){Ol||(y(m.$$.fragment,e),y(j.$$.fragment,e),y(v.$$.fragment,e),y(Z.$$.fragment,e),y(C.$$.fragment,e),y(V.$$.fragment,e),y(N.$$.fragment,e),y(E.$$.fragment,e),y(F.$$.fragment,e),y(A.$$.fragment,e),y(D.$$.fragment,e),y(O.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(ae.$$.fragment,e),y(ue.$$.fragment,e),y(re.$$.fragment,e),y(oe.$$.fragment,e),y(pe.$$.fragment,e),y(de.$$.fragment,e),y(je.$$.fragment,e),y(Ie.$$.fragment,e),y(Ge.$$.fragment,e),y(Ce.$$.fragment,e),y(xe.$$.fragment,e),Ol=!0)},o(e){U(m.$$.fragment,e),U(j.$$.fragment,e),U(v.$$.fragment,e),U(Z.$$.fragment,e),U(C.$$.fragment,e),U(V.$$.fragment,e),U(N.$$.fragment,e),U(E.$$.fragment,e),U(F.$$.fragment,e),U(A.$$.fragment,e),U(D.$$.fragment,e),U(O.$$.fragment,e),U(K.$$.fragment,e),U(ee.$$.fragment,e),U(le.$$.fragment,e),U(ae.$$.fragment,e),U(ue.$$.fragment,e),U(re.$$.fragment,e),U(oe.$$.fragment,e),U(pe.$$.fragment,e),U(de.$$.fragment,e),U(je.$$.fragment,e),U(Ie.$$.fragment,e),U(Ge.$$.fragment,e),U(Ce.$$.fragment,e),U(xe.$$.fragment,e),Ol=!1},d(e){e&&(s(ze),s(Xe),s(We),s(qe),s(Ne),s(T),s(Re),s(w),s(Ee),s(b),s(He),s(h),s(_e),s(I),s($e),s(B),s(ke),s(G),s(Se),s(Ye),s(Fe),s(Ae),s(f),s(Le),s(Pe),s(x),s(De),s(g),s(Oe),s(X),s(Ke),s(Q),s(el),s(z),s(ll),s(W),s(sl),s(q),s(tl),s(nl),s(R),s(al),s(Ml),s(H),s(il),s(_),s(ul),s($),s(rl),s(k),s(ol),s(S),s(pl),s(Y),s(yl),s(Ul),s(cl),s(L),s(Jl),s(P),s(dl),s(ml),s(jl),s(Tl),s(wl),s(bl),s(se),s(hl),s(te),s(Il),s(ne),s(Bl),s(Gl),s(Me),s(vl),s(ie),s(Zl),s(Cl),s(fl),s(Vl),s(xl),s(ye),s(gl),s(Ue),s(Xl),s(ce),s(Ql),s(Je),s(zl),s(Wl),s(me),s(ql),s(Nl),s(Te),s(Rl),s(we),s(El),s(be),s(Hl),s(he),s(_l),s($l),s(Be),s(kl),s(Sl),s(ve),s(Yl),s(Ze),s(Fl),s(Al),s(fe),s(Ll),s(Ve),s(Pl),s(Dl),s(Qe)),s(d),c(m,e),c(j,e),c(v,e),c(Z,e),c(C,e),c(V,e),c(N,e),c(E,e),c(F,e),c(A,e),c(D,e),c(O,e),c(K,e),c(ee,e),c(le,e),c(ae,e),c(ue,e),c(re,e),c(oe,e),c(pe,e),c(de,e),c(je,e),c(Ie,e),c(Ge,e),c(Ce,e),c(xe,e)}}}const lt='{"title":"Utilisation d’un LLM-as-a-judge 🧑‍⚖️ pour une évaluation automatisée et polyvalente","local":"utilisation-dun-llm-as-a-judge--pour-une-évaluation-automatisée-et-polyvalente","sections":[{"title":"1. Préparer la création et l’évaluation de notre juge","local":"1-préparer-la-création-et-lévaluation-de-notre-juge","sections":[],"depth":2},{"title":"2. Créer notre juge","local":"2-créer-notre-juge","sections":[],"depth":2},{"title":"3. Améliorer le juge","local":"3-améliorer-le-juge","sections":[],"depth":2},{"title":"4. Comment aller encore plus loin avec notre juge ?","local":"4-comment-aller-encore-plus-loin-avec-notre-juge-","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function st(Kl){return Fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class it extends As{constructor(d){super(),Ls(this,d,st,et,Ss,{})}}export{it as component};
