import{s as zA,f as hA,n as PA,o as vA}from"../chunks/scheduler.39a43cde.js";import{S as xA,i as VA,g as s,s as i,r as o,A as GA,h as n,f as t,c as a,j as HA,u as r,x as f,k as It,y as IA,a as A,v as m,d as p,t as K,w as U}from"../chunks/index.23ec2204.js";import{D as QA,C as y}from"../chunks/DocNotebookDropdown.7c3158f8.js";import{H as w,E as XA}from"../chunks/getInferenceSnippets.aa68157d.js";function WA(Qt){let j,ll,_e,tl,g,Al,c,il,u,Xt='<em>Yazar: <a href="https://github.com/emre570" rel="nofollow">Emre Albayrak</a></em> <em>Çevirmen: <a href="https://github.com/onuralpszr" rel="nofollow">Onuralp Sezer</a></em>',al,M,Wt="Bu rehber, Vision Transformer (ViT) modelini özel bir biyomedikal verisetiyle fine-tune etmek için izlenmesi gereken adımları açıklamaktadır. Verisetini yükleme ve hazırlama, farklı veri bölümleri için görüntü dönüşümlerini ayarlama, ViT modelini yapılandırma ve başlatma, ayrıca eğitim sürecini değerlendirme ve görselleştirme araçlarıyla tanımlama adımlarını içermektedir.",sl,d,nl,F,Zt="Özel veriseti elle oluşturulmuş olup, 780 görüntü ve 3 sınıf içermektedir (iyi huylu, kötü huylu, normal).",ol,b,qt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/102d6c23e6cc24db857fbc60186461ded6cdfb75/datasetinfo.png" alt="attachment:datasetinfo.png"/>',rl,R,ml,B,Nt='Fine-tune edilecek model, Google’ın <a href="https://huggingface.co/google/vit-large-patch16-224" rel="nofollow"><code>&quot;vit-large-patch16-224&quot;</code></a> modelidir. Model, ImageNet-21k (14M görüntü, 21.843 sınıf) üzerinde eğitilmiş ve ImageNet 2012 (1M görüntü, 1.000 sınıf) üzerinde 224x224 çözünürlükte fine-tune edilmiştir. Google, farklı görüntü boyutları ve yama boyutlarına sahip çeşitli ViT modellerine sahiptir.',pl,C,Dt="Hadi başlayalım!",Kl,J,Ul,k,Yt="Öncelikle, gerekli python kütüphanelerini yükleyerek başlayalım.",fl,T,yl,h,St="<em>(İsteğe Bağlı)</em> Modelimizi Hugging Face Hub’a yükleyeceğimiz için giriş yapmamız gerekiyor.",wl,H,jl,z,gl,P,Ot='<em>Datasets</em> kütüphanesi, verisetinden görüntüleri ve sınıfları otomatik olarak çeker. Detaylı bilgi için <a href="https://huggingface.co/docs/datasets/image_load" rel="nofollow"><code>bu bağlantıyı</code></a> ziyaret edebilirsiniz.',cl,v,ul,x,Et="Verisetimizi aldık. Ancak elimizde bir doğrulama seti yok. Doğrulama setini oluşturmak için, test setinin boyutuna dayalı olarak eğitim setinin bir kısmını doğrulama seti olarak ayıracağız. Daha sonra, eğitim verisetini yeni eğitim ve doğrulama alt altsetlere böleceğiz.",Ml,V,dl,G,Lt="Ayrılmış test setimizi aldım. Şimdi test seti ile birleştirelim",Fl,I,bl,Q,$t="Harika, Verisetimiz hazır olduğuna göre şimdi alt setleri farklı değişkenlere tanımlayarak kolay şekilde kullanabiliriz.",Rl,X,Bl,W,_t="Şimdi verisetimizdeki resimlerin türünün <code>PIL.Image</code> olduğunu, ilk resme bakarak doğrulayabiliriz.",Cl,Z,Jl,q,eA="Eğitim setinin özelliklerini ayrıca görebiliriz.",kl,N,Tl,D,lA="Şimdi veriseti içindeki her sınıftan bir tane resim gösterelim.",hl,Y,Hl,Le,tA,zl,S,Pl,O,AA="Veriseti hazır, ancak fine-tuning için henüz hazır değiliz. Aşağıdaki adımları sırasıyla takip edeceğiz:",vl,E,iA="<li><p><strong>Etiket Eşleme:</strong> Model eğitimi ve değerlendirmesi sırasında faydalı olacak şekilde, etiket kimliklerini (ID) ve bunların karşılık gelen isimlerini dönüştüreceğiz.</p></li> <li><p><strong>Görüntü İşleme:</strong> Daha sonra, <code>ViTImageProcessor</code> kullanarak giriş görüntü boyutlarını standartlaştıracağız ve önceden eğitilmiş modele özgü normalizasyon uygulayacağız. Ayrıca, torchvision kullanarak eğitim, doğrulama ve test için farklı dönüşümler tanımlayarak model genellemesini geliştireceğiz.</p></li> <li><p><strong>Dönüşüm Fonksiyonları:</strong> ViT modeline uygun format ve boyutlara dönüştürerek verisetine bu dönüşümleri uygulayan fonksiyonlar implement edeceğiz.</p></li> <li><p><strong>Veri Yükleme:</strong> Görüntü ve etiketleri uygun şekilde gruplamak için özel bir collate fonksiyonu tanımlayacak ve model eğitimi sırasında verimli yükleme ve gruplama için bir DataLoader oluşturacağız.</p></li> <li><p><strong>Batch Hazırlığı:</strong> Örnek bir batch’in veri şekil bilgilerini alacak ve görüntüleyerek işlemenin doğru yapıldığını ve model girişine hazır olduğunu doğrulayacağız.</p></li>",xl,L,Vl,$,Gl,_,Il,ee,Ql,le,Xl,te,Wl,Ae,Zl,ie,ql,ae,Nl,se,Dl,ne,Yl,oe,aA="Bu işlem ile görüldüğü üzere piksel değerlerini tensorlara dönüştürmüş oluyoruz.",Sl,re,Ol,me,El,pe,Ll,Ke,$l,Ue,sA=`pixel_values torch.Size([4, 3, 224, 224])
labels torch.Size([4])
`,_l,fe,nA="Harika! Şimdi fine-tuning işlemi için hazırız.",et,ye,lt,we,oA="Şimdi modeli yapılandırıp fine-tune edeceğiz. İlk olarak, modeli belirli etiket eşlemeleri ve önceden eğitilmiş ayarlarla başlatarak boyut uyuşmazlıklarını ayarlıyoruz. Eğitim parametreleri, modelin öğrenme sürecini tanımlamak için ayarlandı; bu parametreler arasında kaydetme stratejisi, batch boyutları ve eğitim epoch’ları yer alıyor ve sonuçlar Weights & Biases aracılığıyla kaydediliyor. Ardından, Hugging Face Trainer, eğitim ve değerlendirme süreçlerini yönetmek için özel bir veri collator ve modelin dahili işlemcisini kullanarak başlatılacak. Son olarak, eğitim tamamlandıktan sonra modelin performansı bir test veriseti üzerinde değerlendirilecek ve doğruluk gibi metrikler yazdırılarak modelin başarısı değerlendirilecek.",tt,je,rA="İlk olarak, modelimizi çağırıyoruz.",At,ge,it,ce,mA="Burada önemli bir detay var: <code>ignore_mismatched_sizes</code> parametresi.",at,ue,pA="Önceden eğitilmiş bir modeli yeni bir veriseti üzerinde fine-tune ederken, bazen görüntülerin giriş boyutu veya model mimarisi özellikleri (örneğin, sınıflandırma katmanındaki etiket sayısı) modelin başlangıçta eğitildiği yapı ile tam olarak uyuşmayabilir. Bu durum, genellikle ImageNet gibi doğal görüntüler üzerinde eğitilmiş bir modeli, tıbbi görüntüler veya özel kamera görüntüleri gibi tamamen farklı bir görüntü verisetine uygularken ortaya çıkar.",st,Me,KA="<code>ignore_mismatched_sizes</code> parametresini <code>True</code> olarak ayarlamak, modelin boyut farklılıklarına uyum sağlamasına ve hata oluşturmadan katmanlarını ayarlamasına olanak tanır.",nt,de,UA="Örneğin, bu model 1000 sınıf üzerinde eğitilmiştir ve <code>torch.Size([1000])</code> boyutunda bir giriş bekler. Verisetimiz ise 3 sınıfa sahiptir ve bu <code>torch.Size([3])</code> boyutundadır. Eğer bunu doğrudan modele verirsek, sınıf sayıları eşleşmediği için bir hata alırız.",ot,Fe,fA="Sonrasında, bu model için Google tarafından sağlanan eğitim argümanlarını tanımlayacağız.",rt,be,yA="(Opsiyonel) <code>report_to</code> parametresini <code>wandb</code> olarak ayarladığımız için metrikler Weights &amp; Biases’te kaydedilecektir. W&amp;B sizden bir API anahtarı isteyecek, bu yüzden bir hesap oluşturmalı ve API anahtarı almalısınız. Eğer istemiyorsanız, <code>report_to</code> parametresini kaldırabilirsiniz.",mt,Re,pt,Be,wA="Artık <code>Trainer</code> ile fine-tuning sürecine başlayabiliriz.",Kt,Ce,Ut,Je,jA="<thead><tr><th>Epoch</th> <th>Eğitim Kaybı</th> <th>Doğrulama Kaybı</th> <th>Doğruluk</th></tr></thead> <tbody><tr><td>40</td> <td>0.174700</td> <td>0.596288</td> <td>0.903846</td></tr></tbody>",ft,ke,gA="Fine-tuning süreci tamamlandı. Şimdi, modeli test verisetinde değerlendirmeye devam edelim.",yt,Te,wt,he,cA=`&#123;'test_loss': 0.40843912959098816, 'test_runtime': 4.9934, 'test_samples_per_second': 31.242, 'test_steps_per_second': 7.81}
`,jt,He,uA="<code>{&#39;test_loss&#39;: 0.3219967782497406, &#39;test_accuracy&#39;: 0.9102564102564102, &#39;test_runtime&#39;: 4.0543, &#39;test_samples_per_second&#39;: 38.478, &#39;test_steps_per_second&#39;: 9.619}</code>",gt,ze,ct,Pe,MA="Modelimizi <code>push_to_hub</code> fonksiyonunu kullanarak Hugging Face Hub’a yükleyebiliriz.",ut,ve,Mt,xe,dt,Ve,dA="Fine-tuning işlemini tamamladık. Şimdi, modelimizin sınıfları nasıl tahmin ettiğini görelim. Bunun için scikit-learn’ün Confusion Matrix Display fonksiyonunu kullanarak Confusion Matrix’i görselleştirecek ve Recall Skoru göstereceğiz.",Ft,Ge,bt,Ie,FA="Confusion Matrix, bir algoritmanın, genellikle bir denetimli öğrenme modelinin, gerçek değerlerin bilindiği bir test veriseti üzerindeki performansını görselleştirmeye olanak tanıyan belirli bir tablo düzenidir. Özellikle bir sınıflandırma modelinin ne kadar iyi performans gösterdiğini kontrol etmek için kullanışlıdır, çünkü gerçek ve tahmin edilen etiketlerin sıklığını gösterir.",Rt,Qe,bA="Hadi, modelimizin Confusion Matrix’ini çizelim.",Bt,Xe,Ct,$e,RA,Jt,We,kt,Ze,BA="Recall skoru, sınıflandırma görevlerinde kullanılan bir performans metriğidir ve bir modelin bir veriseti içindeki tüm ilgili örnekleri doğru bir şekilde tanımlama yeteneğini ölçer. Özellikle recall, gerçek pozitiflerin model tarafından doğru bir şekilde pozitif olarak tahmin edilen oranını değerlendirir.",Tt,qe,CA="Hadi, scikit-learn kullanarak recall skorlarını yazdıralım.",ht,Ne,Ht,De,JA=`Recall for benign: 0.90
Recall for malignant: 0.86
Recall for normal: 0.78
`,zt,Ye,kA="<code>Recall for benign: 0.90, Recall for malignant: 0.86, Recall for normal: 0.78</code>",Pt,Se,vt,Oe,TA="Bu cookbook’ta, bir ViT modelini bir tıbbi verisetiyle nasıl eğiteceğimizi ele aldık. Veriseti hazırlığı, görüntü ön işleme, model yapılandırması, eğitim, değerlendirme ve sonuçların görselleştirilmesi gibi önemli adımları kapsadık. Hugging Face’in Transformers kütüphanesi, scikit-learn ve PyTorch Torchvision’u kullanarak, verimli model eğitimi ve değerlendirme süreçlerini kolaylaştırdık. Bu süreç, modelin performansı ve biyomedikal görüntüleri doğru şekilde sınıflandırma yeteneği hakkında değerli bilgiler sunmaktadır.",xt,Ee,Vt,el,Gt;return g=new QA({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/tr/fine_tuning_vit_custom_dataset.ipynb"}]}}),c=new w({props:{title:"Vision Transformer Modelini Özel Bir Biyomedikal Verisetiyle Fine-Tune Etmek",local:"vision-transformer-modelini-özel-bir-biyomedikal-verisetiyle-fine-tune-etmek",headingTag:"h1"}}),d=new w({props:{title:"Veriseti Bilgisi",local:"veriseti-bilgisi",headingTag:"h2"}}),R=new w({props:{title:"Model Bilgisi",local:"model-bilgisi",headingTag:"h2"}}),J=new w({props:{title:"Başlarken",local:"başlarken",headingTag:"h2"}}),T=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjB0b3JjaCUyMHRvcmNodmlzaW9uJTIwc2Npa2l0LWxlYXJuJTIwbWF0cGxvdGxpYiUyMHdhbmRiJTIwaHVnZ2luZ2ZhY2UtaHVi",highlighted:"!pip install datasets transformers accelerate torch torchvision scikit-learn matplotlib wandb huggingface-hub",wrap:!1}}),H=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),z=new w({props:{title:"Verisetini Hazırlamak",local:"verisetini-hazırlamak",headingTag:"h2"}}),v=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJlbXJlNTcwJTJGYnJlYXN0Y2FuY2VyLXVsdHJhc291bmQtaW1hZ2VzJTIyKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;emre570/breastcancer-ultrasound-images&quot;</span>)
dataset`,wrap:!1}}),V=new y({props:{code:"JTIzJTIwSGVyJTIwc2V0aW4lMjBzYXklQzQlQjFzJUM0JUIxbiVDNCVCMSUyMGFsYWwlQzQlQjFtJTBBdGVzdF9udW0lMjAlM0QlMjBsZW4oZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQpJTBBdHJhaW5fbnVtJTIwJTNEJTIwbGVuKGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCklMEElMEF2YWxfc2l6ZSUyMCUzRCUyMHRlc3RfbnVtJTIwJTJGJTIwdHJhaW5fbnVtJTBBJTBBdHJhaW5fdmFsX3NwbGl0JTIwJTNEJTIwZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELnRyYWluX3Rlc3Rfc3BsaXQodGVzdF9zaXplJTNEdmFsX3NpemUpJTBBdHJhaW5fdmFsX3NwbGl0",highlighted:`<span class="hljs-comment"># Her setin sayısını alalım</span>
test_num = <span class="hljs-built_in">len</span>(dataset[<span class="hljs-string">&quot;test&quot;</span>])
train_num = <span class="hljs-built_in">len</span>(dataset[<span class="hljs-string">&quot;train&quot;</span>])

val_size = test_num / train_num

train_val_split = dataset[<span class="hljs-string">&quot;train&quot;</span>].train_test_split(test_size=val_size)
train_val_split`,wrap:!1}}),I=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldERpY3QlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldERpY3QoJTBBJTIwJTIwJTIwJTIwJTdCJTIydHJhaW4lMjIlM0ElMjB0cmFpbl92YWxfc3BsaXQlNUIlMjJ0cmFpbiUyMiU1RCUyQyUyMCUyMnZhbGlkYXRpb24lMjIlM0ElMjB0cmFpbl92YWxfc3BsaXQlNUIlMjJ0ZXN0JTIyJTVEJTJDJTIwJTIydGVzdCUyMiUzQSUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTdEJTBBKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> DatasetDict

dataset = DatasetDict(
    {<span class="hljs-string">&quot;train&quot;</span>: train_val_split[<span class="hljs-string">&quot;train&quot;</span>], <span class="hljs-string">&quot;validation&quot;</span>: train_val_split[<span class="hljs-string">&quot;test&quot;</span>], <span class="hljs-string">&quot;test&quot;</span>: dataset[<span class="hljs-string">&quot;test&quot;</span>]}
)
dataset`,wrap:!1}}),X=new y({props:{code:"dHJhaW5fZHMlMjAlM0QlMjBkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMEF2YWxfZHMlMjAlM0QlMjBkYXRhc2V0JTVCJTIydmFsaWRhdGlvbiUyMiU1RCUwQXRlc3RfZHMlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RA==",highlighted:`train_ds = dataset[<span class="hljs-string">&quot;train&quot;</span>]
val_ds = dataset[<span class="hljs-string">&quot;validation&quot;</span>]
test_ds = dataset[<span class="hljs-string">&quot;test&quot;</span>]`,wrap:!1}}),Z=new y({props:{code:"dHJhaW5fZHMlNUIwJTVE",highlighted:'train_ds[<span class="hljs-number">0</span>]',wrap:!1}}),N=new y({props:{code:"dHJhaW5fZHMuZmVhdHVyZXM=",highlighted:"train_ds.features",wrap:!1}}),Y=new y({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjBhJTIwc2V0JTIwdG8lMjBrZWVwJTIwdHJhY2slMjBvZiUyMHNob3duJTIwbGFiZWxzJTBBc2hvd25fbGFiZWxzJTIwJTNEJTIwc2V0KCklMEElMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwZmlndXJlJTIwZm9yJTIwcGxvdHRpbmclMEFwbHQuZmlndXJlKGZpZ3NpemUlM0QoMTAlMkMlMjAxMCkpJTBBJTBBJTIzJTIwTG9vcCUyMHRocm91Z2glMjB0aGUlMjBkYXRhc2V0JTIwYW5kJTIwcGxvdCUyMHRoZSUyMGZpcnN0JTIwaW1hZ2UlMjBvZiUyMGVhY2glMjBsYWJlbCUwQWZvciUyMGklMkMlMjBzYW1wbGUlMjBpbiUyMGVudW1lcmF0ZSh0cmFpbl9kcyklM0ElMEElMjAlMjAlMjAlMjBsYWJlbCUyMCUzRCUyMHRyYWluX2RzLmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXMlNUJzYW1wbGUlNUIlMjJsYWJlbCUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlmJTIwbGFiZWwlMjBub3QlMjBpbiUyMHNob3duX2xhYmVscyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBsdC5zdWJwbG90KDElMkMlMjBsZW4odHJhaW5fZHMuZmVhdHVyZXMlNUIlMjJsYWJlbCUyMiU1RC5uYW1lcyklMkMlMjBsZW4oc2hvd25fbGFiZWxzKSUyMCUyQiUyMDEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGx0Lmltc2hvdyhzYW1wbGUlNUIlMjJpbWFnZSUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwbHQudGl0bGUobGFiZWwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGx0LmF4aXMoJTIyb2ZmJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNob3duX2xhYmVscy5hZGQobGFiZWwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc2hvd25fbGFiZWxzKSUyMCUzRCUzRCUyMGxlbih0cmFpbl9kcy5mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVELm5hbWVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBcGx0LnNob3coKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize a set to keep track of shown labels</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>shown_labels = <span class="hljs-built_in">set</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the figure for plotting</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure(figsize=(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loop through the dataset and plot the first image of each label</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, sample <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(train_ds):
<span class="hljs-meta">... </span>    label = train_ds.features[<span class="hljs-string">&quot;label&quot;</span>].names[sample[<span class="hljs-string">&quot;label&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> label <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> shown_labels:
<span class="hljs-meta">... </span>        plt.subplot(<span class="hljs-number">1</span>, <span class="hljs-built_in">len</span>(train_ds.features[<span class="hljs-string">&quot;label&quot;</span>].names), <span class="hljs-built_in">len</span>(shown_labels) + <span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>        plt.imshow(sample[<span class="hljs-string">&quot;image&quot;</span>])
<span class="hljs-meta">... </span>        plt.title(label)
<span class="hljs-meta">... </span>        plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
<span class="hljs-meta">... </span>        shown_labels.add(label)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(shown_labels) == <span class="hljs-built_in">len</span>(train_ds.features[<span class="hljs-string">&quot;label&quot;</span>].names):
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),S=new w({props:{title:"Veri İşleme",local:"veri-işleme",headingTag:"h2"}}),L=new w({props:{title:"Etiket Eşleme",local:"etiket-eşleme",headingTag:"h3"}}),$=new y({props:{code:"aWQybGFiZWwlMjAlM0QlMjAlN0JpZCUzQSUyMGxhYmVsJTIwZm9yJTIwaWQlMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKHRyYWluX2RzLmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXMpJTdEJTBBbGFiZWwyaWQlMjAlM0QlMjAlN0JsYWJlbCUzQSUyMGlkJTIwZm9yJTIwaWQlMkMlMjBsYWJlbCUyMGluJTIwaWQybGFiZWwuaXRlbXMoKSU3RCUwQWlkMmxhYmVsJTJDJTIwaWQybGFiZWwlNUJ0cmFpbl9kcyU1QjAlNUQlNUIlMjJsYWJlbCUyMiU1RCU1RA==",highlighted:`id2label = {<span class="hljs-built_in">id</span>: label <span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span>, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(train_ds.features[<span class="hljs-string">&quot;label&quot;</span>].names)}
label2id = {label: <span class="hljs-built_in">id</span> <span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span>, label <span class="hljs-keyword">in</span> id2label.items()}
id2label, id2label[train_ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;label&quot;</span>]]`,wrap:!1}}),_=new w({props:{title:"Görüntü İşleme",local:"görüntü-işleme",headingTag:"h3"}}),ee=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpVEltYWdlUHJvY2Vzc29yJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMmdvb2dsZSUyRnZpdC1sYXJnZS1wYXRjaDE2LTIyNCUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFZpVEltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViTImageProcessor

model_name = <span class="hljs-string">&quot;google/vit-large-patch16-224&quot;</span>
processor = ViTImageProcessor.from_pretrained(model_name)`,wrap:!1}}),le=new y({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ2VudGVyQ3JvcCUyQyUwQSUyMCUyMCUyMCUyMENvbXBvc2UlMkMlMEElMjAlMjAlMjAlMjBOb3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcCUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbVJlc2l6ZWRDcm9wJTJDJTBBJTIwJTIwJTIwJTIwVG9UZW5zb3IlMkMlMEElMjAlMjAlMjAlMjBSZXNpemUlMkMlMEEpJTBBJTBBaW1hZ2VfbWVhbiUyQyUyMGltYWdlX3N0ZCUyMCUzRCUyMHByb2Nlc3Nvci5pbWFnZV9tZWFuJTJDJTIwcHJvY2Vzc29yLmltYWdlX3N0ZCUwQXNpemUlMjAlM0QlMjBwcm9jZXNzb3Iuc2l6ZSU1QiUyMmhlaWdodCUyMiU1RCUwQSUwQW5vcm1hbGl6ZSUyMCUzRCUyME5vcm1hbGl6ZShtZWFuJTNEaW1hZ2VfbWVhbiUyQyUyMHN0ZCUzRGltYWdlX3N0ZCklMEElMEF0cmFpbl90cmFuc2Zvcm1zJTIwJTNEJTIwQ29tcG9zZSglMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSYW5kb21SZXNpemVkQ3JvcChzaXplKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJhbmRvbUhvcml6b250YWxGbGlwKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUb1RlbnNvcigpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQXZhbF90cmFuc2Zvcm1zJTIwJTNEJTIwQ29tcG9zZSglMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSZXNpemUoc2l6ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDZW50ZXJDcm9wKHNpemUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5vcm1hbGl6ZSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMEF0ZXN0X3RyYW5zZm9ybXMlMjAlM0QlMjBDb21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlc2l6ZShzaXplKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMENlbnRlckNyb3Aoc2l6ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUb1RlbnNvcigpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> (
    CenterCrop,
    Compose,
    Normalize,
    RandomHorizontalFlip,
    RandomResizedCrop,
    ToTensor,
    Resize,
)

image_mean, image_std = processor.image_mean, processor.image_std
size = processor.size[<span class="hljs-string">&quot;height&quot;</span>]

normalize = Normalize(mean=image_mean, std=image_std)

train_transforms = Compose(
    [
        RandomResizedCrop(size),
        RandomHorizontalFlip(),
        ToTensor(),
        normalize,
    ]
)
val_transforms = Compose(
    [
        Resize(size),
        CenterCrop(size),
        ToTensor(),
        normalize,
    ]
)
test_transforms = Compose(
    [
        Resize(size),
        CenterCrop(size),
        ToTensor(),
        normalize,
    ]
)`,wrap:!1}}),te=new w({props:{title:"Dönüşüm fonksiyonlarını oluşturma",local:"dönüşüm-fonksiyonlarını-oluşturma",headingTag:"h3"}}),Ae=new y({props:{code:"ZGVmJTIwYXBwbHlfdHJhaW5fdHJhbnNmb3JtcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnRyYWluX3RyYW5zZm9ybXMoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMGltYWdlJTIwaW4lMjBleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXMlMEElMEElMEFkZWYlMjBhcHBseV92YWxfdHJhbnNmb3JtcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnZhbF90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGVzJTBBJTBBJTBBZGVmJTIwYXBwbHlfdGVzdF90cmFuc2Zvcm1zKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwJTVCdmFsX3RyYW5zZm9ybXMoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMGltYWdlJTIwaW4lMjBleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">apply_train_transforms</span>(<span class="hljs-params">examples</span>):
    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [train_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> examples


<span class="hljs-keyword">def</span> <span class="hljs-title function_">apply_val_transforms</span>(<span class="hljs-params">examples</span>):
    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [val_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> examples


<span class="hljs-keyword">def</span> <span class="hljs-title function_">apply_test_transforms</span>(<span class="hljs-params">examples</span>):
    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [val_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),ie=new w({props:{title:"Dönüşüm fonksiyonlarını her bir sete uygulayalım",local:"dönüşüm-fonksiyonlarını-her-bir-sete-uygulayalım",headingTag:"h3"}}),ae=new y({props:{code:"dHJhaW5fZHMuc2V0X3RyYW5zZm9ybShhcHBseV90cmFpbl90cmFuc2Zvcm1zKSUwQXZhbF9kcy5zZXRfdHJhbnNmb3JtKGFwcGx5X3ZhbF90cmFuc2Zvcm1zKSUwQXRlc3RfZHMuc2V0X3RyYW5zZm9ybShhcHBseV90ZXN0X3RyYW5zZm9ybXMp",highlighted:`train_ds.set_transform(apply_train_transforms)
val_ds.set_transform(apply_val_transforms)
test_ds.set_transform(apply_test_transforms)`,wrap:!1}}),se=new y({props:{code:"dHJhaW5fZHMuZmVhdHVyZXM=",highlighted:"train_ds.features",wrap:!1}}),ne=new y({props:{code:"dHJhaW5fZHMlNUIwJTVE",highlighted:'train_ds[<span class="hljs-number">0</span>]',wrap:!1}}),re=new w({props:{title:"Veri Yükleme (DataLoader)",local:"veri-yükleme-dataloader",headingTag:"h3"}}),me=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMERhdGFMb2FkZXIlMEElMEElMEFkZWYlMjBjb2xsYXRlX2ZuKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QmV4YW1wbGUlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZXhhbXBsZSU1QiUyMmxhYmVsJTIyJTVEJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwcGl4ZWxfdmFsdWVzJTJDJTIwJTIybGFiZWxzJTIyJTNBJTIwbGFiZWxzJTdEJTBBJTBBJTBBdHJhaW5fZGwlMjAlM0QlMjBEYXRhTG9hZGVyKHRyYWluX2RzJTJDJTIwY29sbGF0ZV9mbiUzRGNvbGxhdGVfZm4lMkMlMjBiYXRjaF9zaXplJTNENCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader


<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    pixel_values = torch.stack([example[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}


train_dl = DataLoader(train_ds, collate_fn=collate_fn, batch_size=<span class="hljs-number">4</span>)`,wrap:!1}}),pe=new w({props:{title:"Batch Hazırlığı",local:"batch-hazırlığı",headingTag:"h3"}}),Ke=new y({props:{code:"YmF0Y2glMjAlM0QlMjBuZXh0KGl0ZXIodHJhaW5fZGwpKSUwQWZvciUyMGslMkMlMjB2JTIwaW4lMjBiYXRjaC5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBpc2luc3RhbmNlKHYlMkMlMjB0b3JjaC5UZW5zb3IpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoayUyQyUyMHYuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>batch = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(train_dl))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items():
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(v, torch.Tensor):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(k, v.shape)`,wrap:!1}}),ye=new w({props:{title:"Modeli Fine-Tune Etme",local:"modeli-fine-tune-etme",headingTag:"h2"}}),ge=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpVEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFZpVEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMkMlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUyMGlnbm9yZV9taXNtYXRjaGVkX3NpemVzJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViTForImageClassification

model = ViTForImageClassification.from_pretrained(
    model_name, id2label=id2label, label2id=label2id, ignore_mismatched_sizes=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Re=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQXRyYWluX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyb3V0cHV0LW1vZGVscyUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfdG90YWxfbGltaXQlM0QyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb3J0X3RvJTNEJTIyd2FuZGIlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMmUtNSUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDQwJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEMC4wMSUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19kaXIlM0QlMjJsb2dzJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVtb3ZlX3VudXNlZF9jb2x1bW5zJTNERmFsc2UlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

train_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;output-models&quot;</span>,
    save_total_limit=<span class="hljs-number">2</span>,
    report_to=<span class="hljs-string">&quot;wandb&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    per_device_train_batch_size=<span class="hljs-number">10</span>,
    per_device_eval_batch_size=<span class="hljs-number">4</span>,
    num_train_epochs=<span class="hljs-number">40</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    logging_dir=<span class="hljs-string">&quot;logs&quot;</span>,
    remove_unused_columns=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),Ce=new y({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RzJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdmFsX2RzJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGNvbGxhdGVfZm4lMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0Rwcm9jZXNzb3IlMkMlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`trainer = Trainer(
    model,
    train_args,
    train_dataset=train_ds,
    eval_dataset=val_ds,
    data_collator=collate_fn,
    tokenizer=processor,
)
trainer.train()`,wrap:!1}}),Te=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMHRyYWluZXIucHJlZGljdCh0ZXN0X2RzKSUwQXByaW50KG91dHB1dHMubWV0cmljcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = trainer.predict(test_ds)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.metrics)`,wrap:!1}}),ze=new w({props:{title:"(Opsiyonel) Modeli Hub’a Yükleme",local:"opsiyonel-modeli-huba-yükleme",headingTag:"h3"}}),ve=new y({props:{code:"bW9kZWwucHVzaF90b19odWIoJTIyeW91cl9tb2RlbF9uYW1lJTIyKQ==",highlighted:'model.push_to_hub(<span class="hljs-string">&quot;your_model_name&quot;</span>)',wrap:!1}}),xe=new w({props:{title:"Sonuçlar",local:"sonuçlar",headingTag:"h2"}}),Ge=new w({props:{title:"Confusion Matrix Nedir?",local:"confusion-matrix-nedir",headingTag:"h3"}}),Xe=new y({props:{code:"ZnJvbSUyMHNrbGVhcm4ubWV0cmljcyUyMGltcG9ydCUyMGNvbmZ1c2lvbl9tYXRyaXglMkMlMjBDb25mdXNpb25NYXRyaXhEaXNwbGF5JTBBJTBBeV90cnVlJTIwJTNEJTIwb3V0cHV0cy5sYWJlbF9pZHMlMEF5X3ByZWQlMjAlM0QlMjBvdXRwdXRzLnByZWRpY3Rpb25zLmFyZ21heCgxKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRyYWluX2RzLmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXMlMEFjbSUyMCUzRCUyMGNvbmZ1c2lvbl9tYXRyaXgoeV90cnVlJTJDJTIweV9wcmVkKSUwQWRpc3AlMjAlM0QlMjBDb25mdXNpb25NYXRyaXhEaXNwbGF5KGNvbmZ1c2lvbl9tYXRyaXglM0RjbSUyQyUyMGRpc3BsYXlfbGFiZWxzJTNEbGFiZWxzKSUwQWRpc3AucGxvdCh4dGlja3Nfcm90YXRpb24lM0Q0NSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> sklearn.metrics <span class="hljs-keyword">import</span> confusion_matrix, ConfusionMatrixDisplay

<span class="hljs-meta">&gt;&gt;&gt; </span>y_true = outputs.label_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>y_pred = outputs.predictions.argmax(<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = train_ds.features[<span class="hljs-string">&quot;label&quot;</span>].names
<span class="hljs-meta">&gt;&gt;&gt; </span>cm = confusion_matrix(y_true, y_pred)
<span class="hljs-meta">&gt;&gt;&gt; </span>disp = ConfusionMatrixDisplay(confusion_matrix=cm, display_labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>disp.plot(xticks_rotation=<span class="hljs-number">45</span>)`,wrap:!1}}),We=new w({props:{title:"Recall Skoru Nedir?",local:"recall-skoru-nedir",headingTag:"h3"}}),Ne=new y({props:{code:"ZnJvbSUyMHNrbGVhcm4ubWV0cmljcyUyMGltcG9ydCUyMHJlY2FsbF9zY29yZSUwQSUwQSUyMyUyMENhbGN1bGF0ZSUyMHRoZSUyMHJlY2FsbCUyMHNjb3JlcyUwQSUyMyUyMCdOb25lJyUyMGNhbGN1bGF0ZXMlMjByZWNhbGwlMjBmb3IlMjBlYWNoJTIwY2xhc3MlMjBzZXBhcmF0ZWx5JTBBcmVjYWxsJTIwJTNEJTIwcmVjYWxsX3Njb3JlKHlfdHJ1ZSUyQyUyMHlfcHJlZCUyQyUyMGF2ZXJhZ2UlM0ROb25lKSUwQSUwQSUyMyUyMFByaW50JTIwdGhlJTIwcmVjYWxsJTIwZm9yJTIwZWFjaCUyMGNsYXNzJTBBZm9yJTIwbGFiZWwlMkMlMjBzY29yZSUyMGluJTIwemlwKGxhYmVscyUyQyUyMHJlY2FsbCklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyUmVjYWxsJTIwZm9yJTIwJTdCbGFiZWwlN0QlM0ElMjAlN0JzY29yZSUzQS4yZiU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> sklearn.metrics <span class="hljs-keyword">import</span> recall_score

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Calculate the recall scores</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># &#x27;None&#x27; calculates recall for each class separately</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>recall = recall_score(y_true, y_pred, average=<span class="hljs-literal">None</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print the recall for each class</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> label, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(labels, recall):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Recall for <span class="hljs-subst">{label}</span>: <span class="hljs-subst">{score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),Se=new w({props:{title:"Sonuç",local:"sonuç",headingTag:"h2"}}),Ee=new XA({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/tr/fine_tuning_vit_custom_dataset.md"}}),{c(){j=s("meta"),ll=i(),_e=s("p"),tl=i(),o(g.$$.fragment),Al=i(),o(c.$$.fragment),il=i(),u=s("p"),u.innerHTML=Xt,al=i(),M=s("p"),M.textContent=Wt,sl=i(),o(d.$$.fragment),nl=i(),F=s("p"),F.textContent=Zt,ol=i(),b=s("p"),b.innerHTML=qt,rl=i(),o(R.$$.fragment),ml=i(),B=s("p"),B.innerHTML=Nt,pl=i(),C=s("p"),C.textContent=Dt,Kl=i(),o(J.$$.fragment),Ul=i(),k=s("p"),k.textContent=Yt,fl=i(),o(T.$$.fragment),yl=i(),h=s("p"),h.innerHTML=St,wl=i(),o(H.$$.fragment),jl=i(),o(z.$$.fragment),gl=i(),P=s("p"),P.innerHTML=Ot,cl=i(),o(v.$$.fragment),ul=i(),x=s("p"),x.textContent=Et,Ml=i(),o(V.$$.fragment),dl=i(),G=s("p"),G.textContent=Lt,Fl=i(),o(I.$$.fragment),bl=i(),Q=s("p"),Q.textContent=$t,Rl=i(),o(X.$$.fragment),Bl=i(),W=s("p"),W.innerHTML=_t,Cl=i(),o(Z.$$.fragment),Jl=i(),q=s("p"),q.textContent=eA,kl=i(),o(N.$$.fragment),Tl=i(),D=s("p"),D.textContent=lA,hl=i(),o(Y.$$.fragment),Hl=i(),Le=s("img"),zl=i(),o(S.$$.fragment),Pl=i(),O=s("p"),O.textContent=AA,vl=i(),E=s("ul"),E.innerHTML=iA,xl=i(),o(L.$$.fragment),Vl=i(),o($.$$.fragment),Gl=i(),o(_.$$.fragment),Il=i(),o(ee.$$.fragment),Ql=i(),o(le.$$.fragment),Xl=i(),o(te.$$.fragment),Wl=i(),o(Ae.$$.fragment),Zl=i(),o(ie.$$.fragment),ql=i(),o(ae.$$.fragment),Nl=i(),o(se.$$.fragment),Dl=i(),o(ne.$$.fragment),Yl=i(),oe=s("p"),oe.textContent=aA,Sl=i(),o(re.$$.fragment),Ol=i(),o(me.$$.fragment),El=i(),o(pe.$$.fragment),Ll=i(),o(Ke.$$.fragment),$l=i(),Ue=s("pre"),Ue.textContent=sA,_l=i(),fe=s("p"),fe.textContent=nA,et=i(),o(ye.$$.fragment),lt=i(),we=s("p"),we.textContent=oA,tt=i(),je=s("p"),je.textContent=rA,At=i(),o(ge.$$.fragment),it=i(),ce=s("p"),ce.innerHTML=mA,at=i(),ue=s("p"),ue.textContent=pA,st=i(),Me=s("p"),Me.innerHTML=KA,nt=i(),de=s("p"),de.innerHTML=UA,ot=i(),Fe=s("p"),Fe.textContent=fA,rt=i(),be=s("p"),be.innerHTML=yA,mt=i(),o(Re.$$.fragment),pt=i(),Be=s("p"),Be.innerHTML=wA,Kt=i(),o(Ce.$$.fragment),Ut=i(),Je=s("table"),Je.innerHTML=jA,ft=i(),ke=s("p"),ke.textContent=gA,yt=i(),o(Te.$$.fragment),wt=i(),he=s("pre"),he.textContent=cA,jt=i(),He=s("p"),He.innerHTML=uA,gt=i(),o(ze.$$.fragment),ct=i(),Pe=s("p"),Pe.innerHTML=MA,ut=i(),o(ve.$$.fragment),Mt=i(),o(xe.$$.fragment),dt=i(),Ve=s("p"),Ve.textContent=dA,Ft=i(),o(Ge.$$.fragment),bt=i(),Ie=s("p"),Ie.textContent=FA,Rt=i(),Qe=s("p"),Qe.textContent=bA,Bt=i(),o(Xe.$$.fragment),Ct=i(),$e=s("img"),Jt=i(),o(We.$$.fragment),kt=i(),Ze=s("p"),Ze.textContent=BA,Tt=i(),qe=s("p"),qe.textContent=CA,ht=i(),o(Ne.$$.fragment),Ht=i(),De=s("pre"),De.textContent=JA,zt=i(),Ye=s("p"),Ye.innerHTML=kA,Pt=i(),o(Se.$$.fragment),vt=i(),Oe=s("p"),Oe.textContent=TA,xt=i(),o(Ee.$$.fragment),Vt=i(),el=s("p"),this.h()},l(e){const l=GA("svelte-u9bgzb",document.head);j=n(l,"META",{name:!0,content:!0}),l.forEach(t),ll=a(e),_e=n(e,"P",{}),HA(_e).forEach(t),tl=a(e),r(g.$$.fragment,e),Al=a(e),r(c.$$.fragment,e),il=a(e),u=n(e,"P",{"data-svelte-h":!0}),f(u)!=="svelte-d1ownx"&&(u.innerHTML=Xt),al=a(e),M=n(e,"P",{"data-svelte-h":!0}),f(M)!=="svelte-v5n4f9"&&(M.textContent=Wt),sl=a(e),r(d.$$.fragment,e),nl=a(e),F=n(e,"P",{"data-svelte-h":!0}),f(F)!=="svelte-1fhvoyj"&&(F.textContent=Zt),ol=a(e),b=n(e,"P",{"data-svelte-h":!0}),f(b)!=="svelte-6ujxmm"&&(b.innerHTML=qt),rl=a(e),r(R.$$.fragment,e),ml=a(e),B=n(e,"P",{"data-svelte-h":!0}),f(B)!=="svelte-1nfs968"&&(B.innerHTML=Nt),pl=a(e),C=n(e,"P",{"data-svelte-h":!0}),f(C)!=="svelte-13jpv7m"&&(C.textContent=Dt),Kl=a(e),r(J.$$.fragment,e),Ul=a(e),k=n(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-12ibc62"&&(k.textContent=Yt),fl=a(e),r(T.$$.fragment,e),yl=a(e),h=n(e,"P",{"data-svelte-h":!0}),f(h)!=="svelte-1jr5f3a"&&(h.innerHTML=St),wl=a(e),r(H.$$.fragment,e),jl=a(e),r(z.$$.fragment,e),gl=a(e),P=n(e,"P",{"data-svelte-h":!0}),f(P)!=="svelte-1c240ty"&&(P.innerHTML=Ot),cl=a(e),r(v.$$.fragment,e),ul=a(e),x=n(e,"P",{"data-svelte-h":!0}),f(x)!=="svelte-1a2bisf"&&(x.textContent=Et),Ml=a(e),r(V.$$.fragment,e),dl=a(e),G=n(e,"P",{"data-svelte-h":!0}),f(G)!=="svelte-162175o"&&(G.textContent=Lt),Fl=a(e),r(I.$$.fragment,e),bl=a(e),Q=n(e,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-1iedjum"&&(Q.textContent=$t),Rl=a(e),r(X.$$.fragment,e),Bl=a(e),W=n(e,"P",{"data-svelte-h":!0}),f(W)!=="svelte-1gy7wvj"&&(W.innerHTML=_t),Cl=a(e),r(Z.$$.fragment,e),Jl=a(e),q=n(e,"P",{"data-svelte-h":!0}),f(q)!=="svelte-557rvb"&&(q.textContent=eA),kl=a(e),r(N.$$.fragment,e),Tl=a(e),D=n(e,"P",{"data-svelte-h":!0}),f(D)!=="svelte-1a81zfk"&&(D.textContent=lA),hl=a(e),r(Y.$$.fragment,e),Hl=a(e),Le=n(e,"IMG",{src:!0}),zl=a(e),r(S.$$.fragment,e),Pl=a(e),O=n(e,"P",{"data-svelte-h":!0}),f(O)!=="svelte-lrd7dk"&&(O.textContent=AA),vl=a(e),E=n(e,"UL",{"data-svelte-h":!0}),f(E)!=="svelte-1w1j1j5"&&(E.innerHTML=iA),xl=a(e),r(L.$$.fragment,e),Vl=a(e),r($.$$.fragment,e),Gl=a(e),r(_.$$.fragment,e),Il=a(e),r(ee.$$.fragment,e),Ql=a(e),r(le.$$.fragment,e),Xl=a(e),r(te.$$.fragment,e),Wl=a(e),r(Ae.$$.fragment,e),Zl=a(e),r(ie.$$.fragment,e),ql=a(e),r(ae.$$.fragment,e),Nl=a(e),r(se.$$.fragment,e),Dl=a(e),r(ne.$$.fragment,e),Yl=a(e),oe=n(e,"P",{"data-svelte-h":!0}),f(oe)!=="svelte-e556n4"&&(oe.textContent=aA),Sl=a(e),r(re.$$.fragment,e),Ol=a(e),r(me.$$.fragment,e),El=a(e),r(pe.$$.fragment,e),Ll=a(e),r(Ke.$$.fragment,e),$l=a(e),Ue=n(e,"PRE",{"data-svelte-h":!0}),f(Ue)!=="svelte-1er930r"&&(Ue.textContent=sA),_l=a(e),fe=n(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-m520wt"&&(fe.textContent=nA),et=a(e),r(ye.$$.fragment,e),lt=a(e),we=n(e,"P",{"data-svelte-h":!0}),f(we)!=="svelte-7apfff"&&(we.textContent=oA),tt=a(e),je=n(e,"P",{"data-svelte-h":!0}),f(je)!=="svelte-16a1vu8"&&(je.textContent=rA),At=a(e),r(ge.$$.fragment,e),it=a(e),ce=n(e,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-j1tluk"&&(ce.innerHTML=mA),at=a(e),ue=n(e,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-1o3gcjg"&&(ue.textContent=pA),st=a(e),Me=n(e,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-139cihe"&&(Me.innerHTML=KA),nt=a(e),de=n(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-yrltoi"&&(de.innerHTML=UA),ot=a(e),Fe=n(e,"P",{"data-svelte-h":!0}),f(Fe)!=="svelte-1mk9eoj"&&(Fe.textContent=fA),rt=a(e),be=n(e,"P",{"data-svelte-h":!0}),f(be)!=="svelte-q8nkda"&&(be.innerHTML=yA),mt=a(e),r(Re.$$.fragment,e),pt=a(e),Be=n(e,"P",{"data-svelte-h":!0}),f(Be)!=="svelte-1il5qvw"&&(Be.innerHTML=wA),Kt=a(e),r(Ce.$$.fragment,e),Ut=a(e),Je=n(e,"TABLE",{"data-svelte-h":!0}),f(Je)!=="svelte-11yqvrm"&&(Je.innerHTML=jA),ft=a(e),ke=n(e,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-19trhrn"&&(ke.textContent=gA),yt=a(e),r(Te.$$.fragment,e),wt=a(e),he=n(e,"PRE",{"data-svelte-h":!0}),f(he)!=="svelte-8qkmqm"&&(he.textContent=cA),jt=a(e),He=n(e,"P",{"data-svelte-h":!0}),f(He)!=="svelte-189m2kt"&&(He.innerHTML=uA),gt=a(e),r(ze.$$.fragment,e),ct=a(e),Pe=n(e,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-19xiemh"&&(Pe.innerHTML=MA),ut=a(e),r(ve.$$.fragment,e),Mt=a(e),r(xe.$$.fragment,e),dt=a(e),Ve=n(e,"P",{"data-svelte-h":!0}),f(Ve)!=="svelte-5mzl6j"&&(Ve.textContent=dA),Ft=a(e),r(Ge.$$.fragment,e),bt=a(e),Ie=n(e,"P",{"data-svelte-h":!0}),f(Ie)!=="svelte-190le6s"&&(Ie.textContent=FA),Rt=a(e),Qe=n(e,"P",{"data-svelte-h":!0}),f(Qe)!=="svelte-lcw9o8"&&(Qe.textContent=bA),Bt=a(e),r(Xe.$$.fragment,e),Ct=a(e),$e=n(e,"IMG",{src:!0}),Jt=a(e),r(We.$$.fragment,e),kt=a(e),Ze=n(e,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-xdbprl"&&(Ze.textContent=BA),Tt=a(e),qe=n(e,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-v9wdfh"&&(qe.textContent=CA),ht=a(e),r(Ne.$$.fragment,e),Ht=a(e),De=n(e,"PRE",{"data-svelte-h":!0}),f(De)!=="svelte-w7wxtb"&&(De.textContent=JA),zt=a(e),Ye=n(e,"P",{"data-svelte-h":!0}),f(Ye)!=="svelte-1yin7k0"&&(Ye.innerHTML=kA),Pt=a(e),r(Se.$$.fragment,e),vt=a(e),Oe=n(e,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-fta2lh"&&(Oe.textContent=TA),xt=a(e),r(Ee.$$.fragment,e),Vt=a(e),el=n(e,"P",{}),HA(el).forEach(t),this.h()},h(){It(j,"name","hf:doc:metadata"),It(j,"content",ZA),hA(Le.src,tA="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAD1AxoDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD3+iiigAooooAKKKKACiiigAooooAKKKKACioYLy2ummW3uIZmgkMUwjcMY3AB2tjocEHB9RU1ABRRQSACScAdSaACiorW6t721jurSeK4t5V3RyxOHRx6gjgipaACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAorF1jxboeg3qWepXwguZITNHF5TuzqGCnaFByckfKOe+MA1GPGfh0+H/wC3f7UiGnb/ACvNKsDvzjZsxu3Z/hxn2oA3qKxLHxfoOpaXfala34e2sFZ7rMTq8IC7jujIDDgE9Oe1U0+IfhV7WS6XVQbWMxhp/Ik8sF2CqN23GckA8/L3xQB09FcxF8Q/CsyXDJqy5gClkMMgdgxwpRSu6QHHBUGr0HivQ7nw82vRagjaah2tNsYFW3bdpXG4NkgYxnmgDZorG0TxVoviKWeLTLzzZoADLDJE8Uig9DtcA4PrjFVPAOq3uteCtP1DUJvOupvM3ybQucSMo4AA6AUAdJRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAHleiXHipNY8ajw/baayQ6xJKxvS5M7eVH+7TaRtOF+8c/eHHWpJPitHqbWUel3+h6V5ljHeTTa1OQql84iRQyliNpy2cDjjmr8XhvxnpOo+Ip9HvNH8rV7xp0FyZN1uCiqHGF+ZuD8p4+VeeSKZafD+/wDC8trN4abTbrFjFZ3cGpqyrKY87ZVZQxVvmbIwRzQBEfiRqF14T07UdNtLC5v5daTSJo0lLwOxJG6Nx/CflIJBwD0OK29K1zW4/Et3oGvxac832H7dbzWSuqMm7YyMrknIOORwQe1Nv/Dus6rpuirdHS4bqz1iG/mW1DrF5aE/KuQSzYI5OAfatCbQrqTx0NcEkP2YaS9lsJO/eZVcHGMbcD1z7UAcvpfizU5/DfhCw0PT9Lt9S1e1afYY2S1tYowCxCKc9WUAA9+tSjxp4htbXxsmo2mnJeeH7NJ4TCHMczNG75OTnadq8cEcjJ61B/wi+oeHNE8ITQ6npMGs6PC9ntu5WW3uldRvQNjdkbAwOOx4rP0XT9S8UH4kJ9tsbi41GCKyS4gLfZllELAorckhd6gnGc54HSgDfs/E/ia3vPD8+tWmmJputuIES2L+dbyNG0ibiTtYHaQQAMep793XMap4cvL218LRRyQBtJvobmfcxwypC6ELxycuOuOM109ABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAGB4u8Tf8IppMF99hkvfNu4bbyo32t+8bbkccn24z6isYeONZXWn0Kbwo6ay8IubaFb5WieHJDM8m35MEAEYblhjPWtLxtpN7q9jpUdjB5rwavaXMg3qu2NJAzNyRnAHTrQ+k3p+J8OsCD/QF0aS1Mu9eJTMjBcZz0BOcYoAisPFmpavoJu9O8PmXUYbySzurKS7WNbeRMhiZMHcOBggHO4cday9X8Rya34B8a2d5p50/UtP064S4t/OEq4aBmRlcAbgRnsDkHisa98H64zXTzaR/aNg3iG6vZtM+1JH9rheNRG+d207WBO1iKdpfg3VrbS/H8UXh+10tNY09YtPsraaMru8mVdpIIAbLLknAy3BIGaAOg027sIfEfh6KWyH2v/hH3lW9MxAjjBi3Js6HJIO7qNvvVC4+JmoQaCviBfCszaLPKiWty12odwzhVd02kopzkcntwM5rQTw5fS+I9IlntytnF4flsLiQOuUkYxfLjOTwrcjjiuN8Qx+J9K+Glt4YvtJgSG1ntLRdQW6VlulWZBGI4x8244XIIGAGOTQB3GoeMNSj8V3vh7SvDx1C5traK58xrsQx7XLAhiVODwMYznJ6Yq1Y+KLzWPCtvq+k6M9xdSyNFJZy3CxeS6syuGc54DKRwDnjik0/Sb2D4ia3qskG2yubK1ihl3qdzIZNwxnIxuHUd65O48Ja4fCltayaabuOLXLm7utM+1LH9rt3kkKDdnb/ABK21iAcYNAHS2fjOd7TXl1DSTZ6no1v9pltRciRJUKsylJABwdjA/LwR0qnp3j++uRod3e+HJLLStZaOKC6N0rssjruQNGBkKxBAbPpkDOKxNG8H6naz+L5YPDdrpFtqekrBZ2lvNGf3gWUEMQcbiWBz05AycGty88P6pL4Q8G2KWubnTrvT5LpPMX92sQG85zg4x2zntmgCDwxrvie88a+I7K40+GTT7e/WPzGvubZPKUgKnl/NnIY8jBYjnGT39cbpVnrOjeOdcb+yXudN1a5inW9jnjAhxEqMHRiG6r/AAg9a7KgAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigDiruJJPjTpbOgZo9DuGQkfdPnRjI/AkfjXGzFdP8V3Or3MTvpGm+K5ZbvYhYRF7NFWUgdlcgk9s17PRQB5Nf3lv4gvvG+vaQTJpI8NtaPdKpVLicCVsqT97apAz74q34ktYB8G/D1r5SeQW0tCmOCDJFkV6dRQBxOoQRP8ZtElaNS6aPdFWI5B8yMfyZvzNc8urX+h6P43utNIiZfEu2SfyTKLaN1gEkuwfe2glsfjXq9FAHk3ha/W++LUEsHiC61yFtFmX7ZLbxxISJoztQoihsZyeuM4z1rqfhb/yTjSf+23/o567CigAooooAKKKKACiiigAooooAKKKKACiiigArmb3xvp2n69JpFza3scqSLGsxjXy5CY/Myp3ZIA4PHX866avMPFOl2cni67u/s8f2k7Myhfm/1ajr9OKAOrPjjR8kAzkjtsH+NRv480lDgRXbf7qL/wDFVws2k7gDbuCx6LWdLZ3ttORIdpXqwPSgD01fHWlMwUR3IY9iqj/2ao38faUhI+z3hx1wi/8AxVed29g10T++jLdcs44qWLSrlnxHNblFHzAyYzQB3v8AwsHSe9ver6ZROf8Ax6l/4WDpGOIbw/SNT/7NXFLoMqxZaS2XPfOQKZfaLeQ2m+3kglT7xEUgJ/KgDuR4/wBJJwYLwfWNf/iqevjvSWcII7rce2xf/iq82gjluQ0E7Sx7Rk5G3/8AXUyaVpEjCQ6jcLJnkFxj8qAPRZPG1hEQDZ35J6YjX/4qon8faaknltZ34bpjy0/+KriW+yxQ4+0+dGvAO7pTJIrOVkEZV2bG4selAHeJ44sZCQtjfnHX5E/+Lp6+NLJ2Kixvs+6IP/Zq4tNPs9uVvFhUHBUN+tUmi0hmAOoSZyckOBQB38njexiba1lf56kBEOPyahfHGnMcC2vScZ+4v/xVcLbvoUDZMilu7yS5P4VZk1DQWVg10Ffthf64oA6q71/Qtbga2vtGkvYVO4xXFtHIoPrhiRmprTxHo2nWYt7TTpLW3i+7DDDGir9FBrz2S/iAXypEcZ7gfnVR9QMe8lUx13KTQB6hH4102Vtqw3e702L/APFU4eMbIkf6He8nH3E/+KryKHUpn3FYl3EcFs5PvVz7XLFCxlvEB4OxM80Aerr4ot33bbG+O0ZPyKP5tTD4stB/y6XmfTauf/Qq8Uu/Ed1GdsFw8YP90nP601fEeoxoS95Jk8ZbmgD29vFNsgy9neKPcJz/AOPU1fF1gxUCC63N0G1c/wDoVeHtq1zcuqzXLoOoDHFSrerBh2lZuc8NQB7l/wAJHad4p1+oX/GpDr9kFDMWUHucf414ZceIGlyql0A7B+KbDqtp5h+1wSS54yJKAPbn8V6UjFfOLEf3RmkHivT2GY1mf/dC/wCNeNR3Vi2QGuVhB+6mBj8TU01/YqFFrNfRgd5GDA/pQB7EviaxY42zA/Rf8as2+s2d1crbxv8AvWzhSR6Z9a8TGoCRfnlZh64xmuk8GahDN4qsolhAPz4YH/YagD1iiiigAooooAKyNd8UaP4ajSTVrs26yKWXETyEgMqnhQe7r+da9cV4+0q31CXTZZSyvCJQjpKyMN2zOCpB/hFAG7a+KdFvITNBfKyBihyjAgg4IwRmrH9uaZx/pac+oP8AhXnNhokFnZbYDJIhdndixYlmOSST35q3/ZkAydzfNyMmgDuT4g0oEg3i8f7J/wAKRvEOkqm83se31wf8K4J9PUfMrvntzkGqrQZwAueep6ZoA9EPibRgMm/jx64P+FIPFGikZF/GR7Kx/pXnZsN+XkIwBgAcU0WCKrFIicdwKAPRT4p0QNg38ef91v8ACmnxboQ/5iMf4Kx/pXnC2ke8Hbz79qupYRqoyoG7uAOaAO8/4SnRCARfpg/7Df4Uf8JTo3/P77f6t/8ACuJTTYX5Cjb04qz/AGcI0Lb16d+lAHW/8JTov/P70/6ZP/hS/wDCT6PjP2zj18t/8K4yDT0mkCMfvdDVk6SrMIwgbB6MaAOqHifRiQBejJ/6Zt/hXOQ6Z4Bs9XTUliH2uOUzRmRp3SNzyWVGJVTz1AFMOktEd2Y19BnOPeqklkqvk4Y5yCKAOw/4SnRcZ+2jH/XN/wDClHijRSuRfpj/AHW/wrj2s4gvOCSOARVcaei7UWNQRzmgDtj4r0QHm+Xrj/Vt/hSt4q0RQCb9AD/sN/hXGCwDhmEfQ5J61GdMRsFkBOM/NQB2w8WaGQCL9Dnp8jf4UDxXohOBfDP/AFzf/CuEk0+NFJAAPpio100NGuPlPoRjFAHoA8UaKel6D/2zb/CgeKdEJwL9PxVv8K8/OnogwS3XqKJdPt1CiJy5PLDbgg0AehnxJo4GTfIB7g/4UHxLo4GTfIPqrf4V5+tkoDF1HqCf6VGbSObkqxK9e1AHov8AwkekYz9tT/vlv8KT/hJdHzg30YPuCP6V52llEYzwODgr3o+yWyyAtz/vUAejf8JFpJGRepj1wf8ACnf29peP+P2P9a4KOBXJZsqB0wcZpTFF5oO3DY6k9aAPTaKKKACiiigArE8T3Mdtp0RllWNXmCZYcH5WOP0rbrkfiHC0+iWcaoWzernHUDY9AGelxazORFBb3BA6Jc7CfwIqbyUkHy+HXJ/vG6H+TXM2ulRLIJWMgJ7E963IIrWFfNlilk9CsmBQAycJB/x86NeQKT99TuH6VZtIvD0ybnuLiI/7TBcfnV6G80wx5Z3QDjDSjmoJLu0lyIHtyfUqDQAz+ztBlcrDqjqw/vOKR9HtTgxauGI7bv8A69ReUrMP9HhbjqI0NVJLOcufKt7bPfeirQBam0mCCMFtYWMd/mOT+VILexK7/wC1Qe2U3E1RfT5gpEr6bnHAaQ5pYbO5RVWCSzRm6kZbH6UAacFlZ3OQNRumPfEZx+dNlsNMtiUbUlz6MwH9ahbTyI9t5qsZHoN6/wBKgTStBTPmeVcn0S424/OgC5CmjLIfM1FAvT5ZR1/OrCjw4QA2sorD/poKxJNA0qViw06YR/3op1b9KqjwzphmO1NTVe37nIoA6k6do8wX7Nq0TepMoqF9H02PJfWLZD6GQH+tc43hi3YHy7t4/aSIipE8BJMMnVISfTkUAba22mRuANbg2HqQwFPntfD5H7zW14/2qzIvh7aJzLfmQ9cIAKtL4G0MRAvNchu53Aj+VABEdAD8a1JLj+FVyal+0aE4Kbb0kfxlT0rMm8D7ZWNjewkE/KJBzir0HgzUJLcpNcKnHXJoAjnufDcTBWv7kHHeMnFRLeeGWOH1abbnoVZahbwNc22WlvomzztAJzVS70ixt4ybiCN2H91ipP4UAbv2fw7PCGt9VQ+zTEH9age20tRj+1UHHG3muWZNAZSHtLuM9MpNkfkRVu18PaLeqHjvbpB/d2jNAHRLFpRXH9s27ADncxGKqO+i+cRJrMWP7q7v8KyH8MacjfLqFwfrGB+uagk0vQLNSf8ASrmUdcuAv6UAdZY6dplxloXNyAP+e2BSppNu0u0QKR2zdgVylpq1hbyhYtOgRe+cvn8TWwk9tfRZAhi91hwRQBqPoKkNtjJYdAJ1z+ZNVksSkgjGmzkg8t9qGAfwqs9giAH7dEzHoGXFVJbzXIT9niuogmc4idc/40AepWaeXY26EY2xqMZzjj1qeqmlMzaRZM7bnMEZZvU7RzVugAryjxldeV4rvNrgMuz5T3+Ra9Xrwzx6JpfH2pJHjGYuCev7pKAGXGsKYdyttkHXvWM+qxzylbtpPLY8kHOKrXVtfwcy2NwEP8SDINWbTT7aeFfmlgnJ6yjI/HigBLu2CReZazpcQnnKthh9RVBbl4z+7chu4zXVw6Dpdqym7vDMcdIeRSnUNP035bPT4m5yHdMtQBk2moazMf8AR4p5FUZIVCRSXGuai8w/cnzB94BcY/rW0PEVwUYuiJnvkjisS48Rxw3ZlVN8nds0AVbm51i8Yf6PdMewEZNVW0zVSxM1pcx/7yEZrok8dSIilYYSR/skH86Q+OLuYB3iDx7uRu6UAYcdlqaoY44ZgDz82cU+fS9QtYxLdKY0cZzurRuNa0fUXLyTXds/XAO5fyrLnijmZmt7hrlB2wRj86AKQuJELAFwD0OaieTjOQznrkkkVaCSq4SSJkjPcip4hYxzFJoXYH7pjK/1oAzojLMCUBJ9u9aNvpGoypukURgDO5jzWlDPpFun+j380UndZYA2PxFU5dRa5ypvSPc5ANAFMxSQth5nbBxlTS5+QsZSw+ozTZrkQOUaRJFPOY+9QG8GG2qwB4IBxuFAEhv5o2xGD+dH267kYrEhcsMEBOapyXmciOFV+pzS2z3byEIXGeMg4oA0o9LnmjHmo6nPzBhyKe2jOqqyzqeejDpVQ2s9u6tNLsU9TvOakupLJrcNbyzm4J5HRcUAWrmzeSEmScSzRj5VQZGKom2uJrfzU3OF4YY6Vc0yUQ/PMC49CcZ9q0rjWmWIQWlpHFH1YBBk0AYdvbXDsAIGJJqy1u1vLhgjEcnPIFWhc397mJElYN0WNeKksb2Kzdra6gWT+8FPNAFaO7fJA2t7AYAp8sM7xq21xk/L7/hV2RdIkcGJvIz1Mg71XmcLIFtbkyjHB24GaAK8ou/LCuPu9QRit34cT58d6ehBUnzeP+2b1zl5czxLtffz9a3fholxL4906byWES+blj/1yegD3+iiigAooooAK4P4kMu/SkMnllvNwc4/uV3leY/F8HGjkf8ATf8A9p0Acxb6he6fes0VxJtHUA5B/OrlxrsrqJIpvmP3lcYx+Vc9Y3s8EWDuZPfnFPmmtZmGC0b9yDQBvR+J2MISdHJPBKGmz6vGWVIborv+8WXBFYE8TkDy5Nwx1Pes5Ji3EgbIOMZoA7Cb7RB5byv5sJ5BWTIqGLWEt/NCzSPk5xnJFc79smjjKo77DwR6/lViFHNvlEYegx1oA1k1rzCx8p9x6NnpV1NZuAqqiDJ6s3audhJaULht393FaYjmT955Tgd8igDRXUbxfvA/QHIxWtHqMf2ZFMSsCOTnBzXPyX37nbhf94LyKqS6ntAV5RkjgDrQB1sd8p+eMlOc5DdKlF7MSrrKxbPQjgj61xcWqLuAzyTyQKvJfpG2cuVIxx2oA6Y6nLL+4Y4U8nmpWFyi/KF2YzuYha5iO+jZwFcnuM1s26Qvl5wZGA+Vc8fzoAcuozY/eGIRr6jP8qrXPiAxkBUUhe4qPVb6FItsaBMcHbWCkiyEBwMMcHmgDoI/E/LJKCEPqOtEevRSHoVAHGa5y5kSJgp2knjjkCo98ceDlWyfWgDql1qIrl4SxzzgU5NettwBhZR0BJzXLLcAHgkL1xTJbzy2UKTyM4I70AdRJrUAJMe31PWq8urI5B4Bzxz0rnjeqAN67SfSmC6y5C8g8jIoA6xtYtVBOJS+ONv/ANeq0muK0oOPLA5HHWsDzn54wf1pkk6IuXbLHtigDdPiALmNQHX/AGgKYuuQu21tob3WsOO+3kDaAc8cCobmYA5YZIP0oA69NQiMIle5wR2xk4pj6xGrbgZHQdM8Vy8GoK33XC4GKkkvlKBHbnPVaAPoWiiigAooooAK5P4gvcJodqbZir/a1BI9Nj11lcl8QU36LaDcQfti4wcfwPQBxJtLgSoZJ5WB64OKv/YrxYsW92wU84fJqnAkiRtsk3H1Paq13q0to20SsWHJ9P1oA044dhxcoZTjnjFOMFuwIjiK55yDjFY8XiOcja4/Uf4VZh16Rn8vYGY9MCgC273FmMq4aLsO9QvrJdfL81lI6A4xUs0015GyyJtXHGATWHc6VKp3Lz6YNAGm/iS8tU27bY4HDPCufzpsfitmXdORu7BQAKxrqwne2z8z4HOQa5sQzLNsaNh6UAeh23i23Q4lgzk8Grg8cRRjEdjEQP74H+FcZDp7Lbb3RXJ98/1qW3t3kbLI2z2oA7Ky8SW19ODJpgHPLRqK1pbvTGKhmukXuF4H6Vz1mTGoAiKAdAQK2rUQFN00W85/zxQBhatcwLKwtppQpP8AEST+tZv21gu0XDY/3uldDqUCTKQECDoDt4rIi0lWkw+xh7YoArwatexyfupGcdwTkVvw+JQ1uEuJTGcc5FVP7GUjEZxkdO1ZU+h3ILFOR2HagDpLhpHiWSGUFSM7gQaktdYmgTy2mkKkdC2a5jTobq1n2S5CDqMHFdBCttL8pjIbNAFqXXoUXIz07muV1XV1uXbndk9+1bGo6ahhLKAuD361gx2avNgxDr19aAKwiuWjEoiJSp01GaMBYYGcr6CtmTS/KiVjGACM43U2MrECBGo/WgDL/tS+nZo/sTPnggA5p9pp3mS+bcWwiX0Lf0q+16I9xJ8seoNYOoeICjN5WZOeoFAHU2jaVbgYjh3epXJqUzW4wIgBmuAs9Ulup8AOo7tnpW6nnohxITnpk8UAbMkKSIQGCn3NY89h5btKXbaTyRUL6hOp8vuOuOazdQu444sSzEsw7npQB7zoYA8P6aB0FrFjn/YFX6y/DRB8LaQR0+xQ/wDoArUoAK8P8duB491Jdm7/AFXf/pkle4V4R8Rgz+ONREbHePKyAR/zySgDLjlZZcrdzwj0ycVoNdW4tiZLjc2Mfe6n6VzEX2iSURszufTJNW47IhQZp0Q5yFx/OgCylwXdjDyB1zxVpLg7d6JHJ/eDf41XljYKixyFW9RjDflTbazmtZ/NkJVSOmMUANuLqzuE+a2MTjqA9YTqfMbyU3KT06mtzU1yFYREqf4hyKxpQYiCikHqNvFADCsiN86OnH8QPNLC6+eBIjBPUdqtDUDJDsnUyL9cmrUEOmX4WGKZoJ5DhfMGAPxoAZJBAw3QMkqkc5XaRTrXTixKxt87DIUHFS3+i3ulYS5AePPyyxOCD+RqGIySOF+ZcdCaAEnsb+KXbJCxHby+afHo2ozQs0GnyugP32TkfrSXMkizKI5pAw7bq0U1K+uYAn2qZETgheD+OKAI4fD+rSwhF0uZWP8AGdo/nTk8Fa9NJt8iJVHOZJkH9aoD+0Ly42RtdyjOFwrEVeg0HVnkBlSRB1zI23+dAEjeA9T8wBprJM9zMCB+VWG8DGCMmfV7BccsTuP9K2bXw3eNGrQSROW7ySjn9aqar4T1acfLJbMM44nFAGSPDeliPe2uWOVOMLCR/WnHQ9GCjf4gSPd/cjz/AFpJfBd3af8AH5c2yKeTtk3Gn/8ACNadEmZLkynsEI/xoAYnhrw0ZwJfEN3Oewjhx/OtpfDfhaOEMk10xHVpDkisjbaWMZ8qMbu5brQ2oqYMLbldxwXLcUAUdW1fTtN8y30+Esc4aR+v4VQsdbw4kEcZYdBIu4flTdTsLVojMgLuT/CelULGBUz5iFR2HrQBvXWsXt4myacRw944FCA/kKy2kmhkDQqqqT6ZOKvR2T3LILe1lweCSMVsLp9rpyh7uAEgcF2zzQBi2tnqGoybLaCSQnjdjAro9P8ABOoFw08ixgdccn86s2XidkRUtLYBP7sak81PdaxrN7KqotxAnTAQg0ASSeFYLWPMkM8hbuTxWn4Ugkh8WWKxwxxwqHBAPP3G96w7i2umjVp/Nd+p3ykk/T0rT8F2j/8ACWWUwj2qvmbiWLH/AFbCgD1qiiigAooooAK84+K0cUg0nzOo84g/98V6PXl3xiVidF2nHE+c/wDbOgDg5lmji3woWAHJAzxWBOS7llkOc5GDWlb3NxatlZz0+6BxVkrp99EWl/cz5wrIPlJ96AKtnrUi26wTQbyOAw4z+FSSGJm3gFSeoHQ02TTbm1fJCyqOQRyKdNJamEEb45P4u4oAz/MSO5BVSq55CtXQW96wRSqjHUdaxUi885hZWf6VpWysg2uw9CB/hQBpDUeSHijO71H9aincrht7KndV5qWIRPHgJ/wLtmq1yPJygYggde1AFO81GDy2VJHBPHPFZj3W4K3mLleuaoanJ/prBjluxUdazdTvhBZnacSHrkdRQB0Mmu2cJRSnUgNtOcfSugvtf0OLw/YSpPeESNMIy0CjcQVzuwxwPzrxaW8Y5YHBPap/ts7WFuvmfKruQpPA6Z/kKAPUI9RjuVEtvIuO/JyK1bDUVlQxyEhwOpNeUaPeyGdCCRuPPpXZRX379MqAQfm20AdHOjuw2NwKdGCq5KnI9uDVY3Ear8zjB596bHclm+UNz3JoASSTdMSVA9u1RvOGcLuCgdRUL3lzb3eBzjnimXCwSP5pEhdjzgjH60ATfaEDlR8x9c02V/OuVbcAo/g9fxpILuJFIkhDY4G0c/jWdJdtNOXVQqE8KDmgDpFuo44lFtZxJLjmWRt5/DNQvOz8NIN3tVGFvMiDFs+igc0yRZAN6hmyfTpQBo+c0QOFDAjkkZqgGM4PIAzj3/KmxzESiLnB6gdaZdO1vKGRH+b2oAnWVLeRSxLeqnIzV99SsUjO3TIMlcAsWY5rHDSTOMknPYjmtO1s/LjDuoGO5NAGPPPIkpIDb2P3FXir1sWdQ20bh6dqwb+edNRdXwAx429CK1dMmUERMxDk8YHFAH1DRRRQAUUUUAFcp4/hSbQrdXBIF0pAHrtaurrk/iDNHBoNu0sPmqbpRtDYx8j80Aefc2aMmWj7kE5zVK7kjvTu3xhhwctWkLzSZ7coY51cD+M7hXLarbDcXtCWXPAIwaANOzsLeRsy3Shc8KDya6vT9MtIFDbwGI65xXG6RY+ZGBNGcn+IZzXW2tp5MYRIpeO7d6ANbFunyl1bPSo7h7a2AYquCOtZ1wtwo+RVU+retVT9rKkPsbjsaAKGq67bq7FVcqvZTiqela/FPdYe3hIH98c1Jf20b4zGgbuRXPXD29lPkMAfagD0hNS0udAgtolc9Ttq3FHbhA6wxEH0xXntvfxSqCJ0cgemK17bUmACqxA9O1AHUzAP908jvis6S9kjJjXexXnIqP8AtWG3iZ55WXA42kHNZUvi22jkJWAP/vHrQBbuLm8lACoxFaVkjCNcltx65FZ2n+Ira+kC/Z2jB7qcitOSSVY2Nom9x3IzigC8GCp8/GeeKytRvLmCItBHkZ6iqstxrRG3yI8j+JhimpDqFwuJbq3ib0AOKAMw6jehzJIhCjk9qkg8SxIfnYj3PNNvtHuXVlkv7cjuFJ5rLHhmeQ7t8ZUd80AdhB4hhmiEYnhOecDrSm5iDBuAD6ViaX4cjspfNkcM/bBzitlYtzYKrweMigCWS4EijYxPHftWVd3nk/cXfz949K1pkCxY6j27VzWoKsjEbyV9AeBQBUv7qW5GEAHFZ0VjNI+ZGBz2Bq95MUaFxwvq1QLf2zuY7ZGkmHUjoKALkMKW6AyMqL2JNJPrNvEBHGzTHodtZ8+mT3eJbi6ZR6Y4qFooEXYm6Qr1KjmgCxNf3LofKiZWPIYjmsg291PKTMwZv9omtKKVJDtRjgdQTVgKsg55A5oA968LAjwhooYYYWEGR/2zWtaszw4c+F9JI6Gyh/8AQBWnQAV4t498MXN140v9RhYsHEZ2r94YjUcflXtNeT+MfEclh4q1CCOMExeWcrycGNTz+dAHCuht2McgkRjxuIwaqtYSOyyQz7+eVbiurt/EumamzR38Shm6s0fT8qsrY+Hbxh5d95LgcFDkfrQBzyCRSjNa7k6EHp+GKtTt5NuJbZ5VUD545MjH09q7C08ONcKsdj4iCuvKrsGKdfab4ytsKLuzvE7l0Uf0oA84dmuAfKdVyM4GKqR2lyzkOrEZ4OK6++0jVZD5txptgX6boSFP6U2PT7y2G97JivcBwRQBziWDrGQUHJ6dadDZC3nWVYyXU8DPH8q0dRMajKRGFj/CH5/lVNdU+y480CQf3e9AFlRLcRt5wC91GcVB9mkG3ByqnOT1FW7K+0i5dRdS3EJPO4EEVoNo9tOPMsb3ev4UAc/NbbpjI+JsckHqaltzPaqzQ2g56k8n9a1TYvARvmdfcLzUNwgJys0m4cbtvWgCmuq3cBKrcbPX5sYqrPd6jPLuleSU567jUt5mPCxqJHbqccVWjF8y/u4CQDyVXNAEqT3YyA84b0GaMaioDlbhUc5UnODRuu+DtaNj1I4rRim1Y24to5TIpHC5Bx9M0AZt3DdSANLjdjoXrPiWeMsgDNk52AmteXSdYJ2y28hPbLAnFPTTdQtlBa1lQN/E460AV7WW2hUi6gn3erHIq4ZrUofJCAjkkgUp0iaUAyyFR1OT1p66FA5xI7Mvopxn8aAMW51m2V9nl7u2QMVJaarHgKyqiDuq5NbLeHdLjA/0RUP952yTUlpbWVpJujtI5Wxxu4H6UALDcX+oEJaK/lYxl1Gf0FbS6WsVosl9LvwPu+Xzn8agjvr+JQEhgiQc7UcfyFZ+r6/NNGsVwz/LzsC7aAGnXxpt2RBAFiPAV15P5VrWviu2bJeIGVeSCc5rjJriS/kCLGcdh1xVu2tTEwZ1G4f3v8BQB0914ha7YiO0giQ/xY5q/wCD9WZ/FVlYtcZ3eZhBgZwjHkfhXPQ6Pq2phZLeynZT0bZgfhXU+EPB95p/iO31G7Aj8oNgORuYlCOB+NAHplFFFABRRRQAV5X8ZtRgsDogni3iTz8H0x5f+NeqV4t8f1dv+Ee2Pt/4+c/+QqAPOZdUhDEo3yZ6YxT47xZFLLGSvqK5oQmTtk+ua0YYPIg5Vldv4gKANoaqIVwm8Z6hjxVGbUDOxQYUVjT+d5xPmMV/KlhguZyvlvub+6WxmgDoLBizDbONw5wOCa24YvtB3DCt/t9/xrizBexMd0DjHpWlFfzLEqEyAjr82aAN6eaezARwAD0O7P8AKq9xqMrx4BABHfOawZL92kYsCpA4anw6pZhAbyKQns0b/wBDQBW1FlzncQ3Q5rHnxcqUmbEZ7jtVnUtRtpZCYy7Bem4ckVnRsJny23b/AHfagDHkj2Sny9xUHg4qSYlLe3BX7ysx477iPT2HrXT2ehxajdR21pEzySfwKfTk9TjoKv8AizwJNpb2cyA/Zmt497MycO2SRwc4z9frQByelShbqPIY+1db9pXzVktmAHcHisoabHYR5TDYHzHrUa3OxR84YDsDzQB2Md3A0PzOfMC59eai+1OoyMZxzWLbX0a53A5x19auPdIxR4xgd+aALLSu6MQWOOcA9KqpeNDLtKNxzzUUt20iDHyr0wOKrlzJJngYGOtAF9r+5kfAAIJ9OlLFmOc7+M+9UhIiAl3xj3py3UZIO4EfWgDoLfqCFOfX0q3ICC38Q9jisu01CIQY3LjoRVyO+s4xueU47DBoAhec20gkPbriorq9e5uAyjOABhap6nqCSPvHzDoMVm/bpkYlG2E9CKAOzsWxC5MsYbHK4ycflUxuzHCrScIDjpXL6RqDFi8shUKfQHNb188c9usjCfYw+UkbR+VAGTrTm8j3oV2L/B3qhaX0kSrtXBB/i5xWi4WSADy2JB7jA/8Ar1kz3zQFlXbuXp8tAH2HRRRQAUUUUAFcn8QXVNCt96lg10oAH+49dZXK+PpHj0KDy5BGxuVGT/uPQB53PYSIN4tXfA6qKoCKXhWi8tM9GHSrMzXQjLfbWGemBnNYt5cXeOJ8igDutF8hYwskyJ34xWrNf2/QSKcepArymzvHlkw8hBA6ZzWqpj/iLZx0GaAO5/tW2kG1DGe3JqncyA5Y4A9hXP291aRgBi3Har63sUnQkqR0oAjldSC2CQPQVy+ptp0z4a3I9WBxXR3SCSNts4j5z0rnriygMhEkqHvkHFAEVlaWLt8jOBntzzWx9ojgjARAT0zjmobKHSUQBXDEc1qC5s44CkcKyenFAGPJ9pvxgQMyegwKgOlqp/fRAY6gmr8t5PHgxMqAdsVhXmpzlyAdzfgaAOg0/wCz2xUfdA6YrciLzAmGRhn3rg7O7u3HzIGH1rWg1Ge3QiMyJnvQB0cq3kYbD5J6ZNUzpl1OyyTXcijqVB4rOfW515kuNx96g/4StY32OzEnj1oA310qKLndI7Y7LUMtzBbBjzlfWo49aldOI3xjO7pWbdXMUzN5oxnkigCw/ie3iXy0ClvbJpLfWbq6JMcWFHO4CsIT2UbkrGGIPBxVpdWiKcEgemP0oA3H1AeWTKkjsOSC3BrnL/XZ2z9ntFjzxkiiXW4kI+Y5rOuNZjkYqO/GAKAK3k31/cj7RckRHqCe1ayG1sIgiTquBk4PJrNjuDK3yA888rUrrFx5hGevC0AWJNXhlA3O0hA4J6UJeKVPlgZPXHesG8njXhJAo6VW/tKGKHBck9eOtAGxLqccE+PLYd+Kiu9eRIiiPh27Dg1yV1qTTy4XgepqSB1LD94W7kEc0AfYXhE7vBehMTknTrc/+Q1rZrF8H4/4QnQMdP7Ot8f9+1raoAK8A+JkZPjvUuq58r5h3/dJXv8AXz18SLwL8RdVhPQeT+P7pKAOUmnit8KNxbGMVLa31xEyuoO324q2ulwX0YaP/W9eT+lJDaymfZ0K8CJjjP40AbllqJhZZnWKUnqpyrD8QavDxGg3BZJ4R6B93865iQNExVwYnzyGGP1qCaUMQqZ3nsOhoA6c61NJnbOrgnHzEg1FqBu2ttwvY2U8lVfFcx5k8O3cu5R2IqtcStJJw7AHnb6UAXZ7rMiqG57saZndIRI/yHuKrQqbiQJnZgdW6GrsSbV8ssW+vSgB6ohjKoSW+natHSbv+zrkGVht9Bzim2VuqqXIJA7r0qeWGCZht8wyH2HFAHRHUbIIJJbhpM87Qgz+tZ83iQ+d/wAS+2gSNe8oDE1Hb6CsyAXKsPdiRxVqLQ9GikbzZJGCcny5MCgCSDxhIy+XPo2nlu7mLrWkutXuo2wgi021t4jwXjgyTWHdeIfDtidsVo0xXpukJAqtN8QpDgW1uiKOhXPFAGwmlXguCxQSBTz5i4B/Ct4G0061R7kJE7fwog215ndeLdRuGJMzoO+T1qjcazqN2gH2hmx070AejXniO23kxTfKvUhawNR8bW0TARRyXEoH3pTx+Fc1BHqV3CUwy5HLEY4rRt/DFm8Km5uSWHJCH/GgCF/FtxNkyxxgnpQPEMshCxhcnjkVrL4a0lVQxk5I6swasbVLUWA3LyvQHHSgCvLqd155+Yls4zmrK3d6RuUrxzjOKz7Gyu72bMY/dn+J+BWvFoUlxP5a3OzB5KruH86ALdnrU8Uo+0W7j/aVsVqPqFpefNI/J9RzVT/hHI4Yw0upN8vfbj+tZ+ofZ7aL/RpC5/ioA6fTrjT4ZCpiTB5JOOa2rbVdHguVdo4Wx1UKOa8glvZHlAGefwxV0bIY1Z7mIk/wq2TQB7LJ4ussKxu1hhH8KcEfgKraH4sg1LxlZ2VtC5STzMyuvXCMePyryA3HmTjbJjPdjiu4+HUqf8JdYxmFfM/efOB0/dtQB7bRRRQAUUUUAFeM/HtA/wDwj2SP+Xn/ANpV7NXjPx7kaM+HtoU5+09R/wBcqAPH4YFB5gD+5Yj+tajrvhVFd0A/hLZqlBd3vlDO0p2zEDUrXsnR7W2ORx8mD+lABJCcYAVm7ZpPs74LRhSR6dqgV083PllD6gmrUE0KP+8eQKx5KEH9DQBNAl1E/VlJHGG/pVjNyZAPLhmOOjKMmpR5JcmK9TGOBJGR/I05mEaIZDDKCf8Alm/I/MUAZGqWTxRh/sbpITyyn5T+FYUiEE/IQO+e1dfdhkXzI2cf7DlSB+tc5NNIxYOACT/d4oAwmGJGU8DPDdvyqWKAKchjn2qZn8t8Sop57rVm2giY5DIpPoeaANXwjq82l6ndLJcGO3ns54m3DO4mNto/7621S1K+uL17d57U74IEhBUcbVGBn3q3/Yxk2mKTcTyF2nJp7pPah45AfmGPu9KAMBriVw292AAwMdBVaNArhyGJ9B0rVuLVFcbWLKwyTjkVX2lHwoOB3JoAfaATDHlyDb3Hapx5rOV+bI7k4qkCPM4JU98HtV0D5F+ZmPQEmgBSkjDDBeDQVSNeZEVs8leakijWRyGmVfUkZomt7eI7l3yc4PGBQA6FLfG5mBJGMkVEtvGZCBIGOeh4qZJNg+VPmPTK0zfGs4M0ZyegXigC1b2ivnY5A7beamS3JcqZCAOtLZvbon7vdGD1J71pxy27xEK7Bj1ZjxQBlTW8aK3z8Y7jrWVPCM4WUbT1U9a2Lp2EjLExYDqSOKypY2J+7nHoKAIo1KkgSEYrYj1K6jWOBX875flVu1Y2CAAAv9angXAIX7xP0oAsXlzfNu8xBH67TkVn7hEcu3zN2rQa3IX94QFI49aoyxkcEED8s0AfaVFFFABRRRQAVw/xUuRa+GbVyODeqv8A449dxXCfFeQx+F7UryTeoP8Axx6APMBdLcwgksfT5ulV5VY7vkGCMDJqsdVSPORz3x0qu+pQscgYH1oAd5UkE24IME9q0oJPOGW3L6jNUkuFY8sTnngZq0ju/wAqJIRjnIxQAt3AJUzG7KcdAaqfZ7xeftMmPrRc3U0bbdm2k+2fuyCvOOpNACyNdLEwS4bPuTWQttfTTfvWLAck7u1Q3mrypKQW6cYApbXWQxwep4NAGxZRx2snmupx0xmtcyxvtMb9e+K543Mkq/IhYZ+uKrNdTwqSo2/SgDopY/MUkuprNeMrIAE5/QVjNq0wByx96gfVp3OASF9utAHUwSiLquMe1W21WyjXEk0gPXGOK4j7XI5P+lupHYjNPW1mkwXmBB9sUAdidRsrkbYtzD/aAqH7BAT5rqABzWfp6QW0AMUBmYjklScGiZL+5YqEdFPOACKALz61FaqY4snAwKyJ9SluJMMxRT60gsxGSJBIG9cUjWRL/IXYZ4yKAHIiLgmbI9xUgnQghSGb0UVWlsr/ADmOIDPAzio4tO1PflvKGDz84FACTuFJ8xWJPTFQwQxu+8/IPfrVmaxusjzHGc8Y5qhK9zb9QGwaANdZ1gj2xH2z1pPtEgUgNzjtWCNTk3DevA9KvwTNMMiFwo6nFAGffK7MCWyB0zWbM0saFQevet+5aRlwkJJ6cisqW0nZh8mD6YoAySzK6g8sfSt600+ERiSebBxnauM1BFpsivv2nd67a0bPSJJn3mMv7BaAPq3wjg+C9CIzj+zrfGf+ua1s1keFF2eD9ETG3bYQDHp+7WtegAr5j+K8mPihrAJxjyf/AETHX05Xyt8X5APirrKg4P7j/wBER0AU9KvpEYbZMnPeuws7iG/xHewjP8LgYI/EV5rayEKN/T1FdDpl5PG4jjl3LjJUntQB115ZXMduUhniuYeyTDLD6GsBrR3lw8DRn0Iq9Zau4kK+YA3v0/WrMk8sg3+Zx6baAMt9JuHGIg7t/s8/pVK40q4hf97G312kVpSTp5wxNsYd0J61Yi1zVLZw0V4XAHAl+agDEjtHk+VFZj6AGtS28P6nJD5yWkzJ0JC5p1x4m1OaRvOEKburKgqex1nWLUmS0vgqt1APB/CgBY9Mv7FRLLbziE8DCZBNXbdplC3EsOyNTy3Spx4m1RYEW4t4G5zuHU/gKp6hrcl5BJFJHGgbr+76UANvfFjB2jjw4HQY71g3V1qWoMwXzFDfwqMUltCyzAqRjP3tvNbkBjik3E5bryaAMuz8H313y+I88gtWrb+Dba2TdfXQyP4Vq6l9eO22PMfcZqJ4rqaXcZAT1OWFAEsdnpsA2JagqOhekea1iCskUakHPCiq8scqggKVXPJzUJ02WYg72WNu9ADbjVd0jKHOW6KoqTaJERpJlXd2K96kGj2sSgtclGHcHJz+NKunRyYzKXI6HcKAJUhitoWnaRnZRnHSsK/1RriRFWJ2JPChetdLFaMq4G1weik5qJ0niIUrGqg8EAZoAzILTUri1CygQRnkDgGpYNHiVyG1h4mPZBx+easzS7VIyxPfDcms5bKSVy8cOWboWJJoA2ToFqbYzSa4pIP3ZOSao3EERQpDNbycfwpiqrQ3Nu/lzwqG67elaNswhh3h1jx2A60AZS+H57hGww56gITWlpvgi3kVmu5Jjt5+RcfqajGvNAzGMI5B4YjOKhuvFV64KrcMmeNqqB+tAHW22haNpib4bFGfH35jvP8AhWr4burI+LLKKEIJG38KAP4GNeYvf3VwNr3cxPcF8D866f4ewRr4205jexO4EmI0Ysf9W3U0Ae40UUUAFFFFABXkPxyWNjoHmLnH2jHH/XOvXq8n+NUxiOhqNo3+eMt0H+roA8mi8qQADp6Dj9KsxWqOCqXUaZ7SDpRFYbwHF2hYf88xkVN5LRsQ5gdQPvfdNAFVtN1BcMq20yDnKkc0p0hm2tJbhB1OGq5HDlctE5AHWNs1P9k3LlLuRG7A5wKAM99Ot1jDNDdo3Xg5H8qgFjG0igyvGD/eQ1fmjvk4E4ZT1OaY0moHAMhVRxkCgDOn0tWRvKuUdc9GbFZMtiyr0UYOMh+9a8pjjmPmO4PrsrPunU8K7EdR8uMUAZk9oYRuc9BnGc060t7ad9zXBB9OBUudrEsokVvfmnrHpUjjc9xEcfd2Aj880AW47VFO2C/VvTcvT8c1DKtz8+WWQg8HNNeCCPJWRgpPAqKRgI2AuH9gwxQBHJBdkbmjbB68UxUZFACscc880jyIoIe5lOf7tMcxBco0wHqTQBbXzJWAa1O7pu21OFG1lMQBWqEJdjxK2PU5rQFvJtLeaOfegBrQqR91lPbAFMdCy45J/wBo0qxsh+edj7U5nDRsqLknjNACwmMKQ3J9Mnio5ljaQ7TjjjNEIZCeAeOc9qc8m5toKj1wOtAD7e3UkM7tlR/D0rShuUjA3lmU/Qf0qCCS3WMK5YOep7VPmxZcmVRjjigBWnswrtnrxtKE/jmsyWeMH90xbae/Srr3WmRvjy5pc/3F4FQNOs5ZbexUBu7HpQBSaXOeAR78UgfBAXP41P8AY5Qzbwq57CkkjjhQHBz6ZoAlW4gBGEy/0zVe6dHy6nP4YqJHCAjIz3XvUE7kZOcR/XGaAPteiiigAooooAK4r4nz2MHhy1a/RmiN6oXb2bY+D/Ou1rzP44xSy+C7JYVLN/aKEgHBx5clAHmN0NHuHbZI65+782f51kTWUcUhVJi8ftWK8M3XypQQfXNV/t0iO212XnkbqAOuj823MYMoA4ycZrYhnG3/AFgY+wxXEW+tTmVQ0gJHA3YxW7BrixgCWGNjnPB/woA1LtWdcxRKznuWrDuYNRJI2xgem6t5da0yaPBjWF8deaga7gk6YI7FTmgDmJLGVmzIuT34psdiUG7Y35V0LXcKsA0qjPrQ08DHAeM8ZyKAMSO4Ns3KHJHBqeS58/AMY9zitqOCJ1ypQ8Z6daqXTRrlQUAz04oAyxaxOCHDK3t0py6fApwCwz61I8yLliTx78VEb9FYuD/9egC3/Z0QG8qBxxkdasW/lLINqI2OSCKy/tscjZkmYDsBTjdRcHzm+goA7C01nZG0aMyAD7gGM/SoptYTyx+5kyeu6uZW6ikHySkHjOTUclzKWOLpWAPegDbmuoGG75Vz1zVJ7qFlABz39KzhfujfNsZepwKf/aETjm0Q5464oAmlkB4QnPpurOa4lUtl2X+dTGePOBbMD6hqA0Uvy7GJ6YagCsb98gedMfZm4pTdt/E8f/Aj1rTGgpNGX81B7A8ioB4VmeT5ArA8YNAFAarBCB8kZI54XrUcmu5kOYzyecmtSTw3Lb5DrEp6fePFZ0mgl3JeeNBntzQBB/wkWzcwiz6Cq58TX7PlViUdANoq8vh23LYe4lfHUKuKkOjadaxeY9q8pB6b/wCdAGYdc1GUBY0TfnOQvatATam1tulu5EyOFXC5/Gop5/LOLWwVPQZxj6moVXWLtgESJARwd2cUAfXPhDJ8FaCWzu/s63zk5P8Aq1rZrF8HpJH4I0BJf9YunW4b6+Wua2qACvlr4z6bfQ/EnVL97OQ2k3k7JgMg4hQH9Qa+pa8G+IXiS8034gana4imtf3WYpFzwYkzzQB4xBK6DAPHpmtTT7torhXjZgw9K7g6F4P8TrlHk0i+xkleUJrm9S8E61o0/wC7aG9hHKz2zZGPegCX7TJO5aXj3xk1esr+aIBTh0B45rAgnnXck8bjBxzWnZkhgyMD/skdaANG4FrckOpKO3J5xUKWzqN8VwuAcHLVpxR2dxGBNZBR1LxNg1HNpNh9+K9lQH+GRc4/EUAUBGDJh2YehPIq/Y2Bkm2xkM2MgcmqYuRYs0JWORc8NikF/JJP9w5Ix8vFAG8dPtWy13dwxS5wEVSDUdzb2ltsY3UcqnsWzXL3G4yHMh6dCeRUR3K42uzD6UAdas1tcKIk8tdvTNElgXBLSRMo564rBhjdcPG4k9eoxVt9RhjAQZZu47fnQBsRx4ILTMcDgLVhmwgzF0P3icZrGGp23DYYMOymov7XmZ8RQkDPHGT+tAGxNceX8yO2fTFUJtQnZyg4Ud+9Sw6lfCHeUKgA8lRWJfazNPLmRjJnpnigDWimthIDO7kZ7itOO9s1lBS88tfavPpbiSWQt823suelJEs0oGFOPdqAPTLvXtKgTD3M0z98cA1myeKo5VaOysyD03tXFlXU/PMigdSWz+FK2qSKhVH9uBigDobnxHPHlTOobsFA4rNXxHdFiWuZDjoS1c/JOqhsEZ7k80wyDgY980Ab39r3MkhcOZGPryatNqUqKqz+Xkj7oIJH1xXNhyMng+9SJIpOS34DrQBtG6kk5Rl2DoBUkLwLGZJCzSegOMVS07TtQ1JtttAdmcb24H510EOh6fphWXVr4TPn/j3jf+eKAKlsJtQcQW9rIx77f8a9B8CeH/sHiixuZBiUeZ8o5xmNh/WuWn8XWdnB5VjarGvYKMfme9aPw+8T3WqeP9Nt5CAjeblR04ic/wBKAPd6KKKACiiigArxj4+3klofD2xlG77TnPfHlV7PXif7QaRv/wAI4JCAf9Jxn/tlQB5JZ61cRTmQ28TrjHpj8qvRa7FI+JbfaOvBz/OsTyXjU7ZGZPVarLud/wB2G49fWgDtI9V0ghiy4LDGQCv8qla3ikgSSG7mWNzldzZrjo47mT5fJJCnqB0rQgvbuACGRCVB+61AGxLZXWHcyJJEvfPNV0SRxs894x6Emmxasqbt8LYx90NxTf7Qg37lUpkdKACSCVCxc716Ag8mqjTwxhgyyn24pbi8RgVEjg49sVn74icB9zDqBQBNJexkDCSKmezDFVXubKRuZZVY8HI4/Opw8AO9on2+opCbMx4E7c9Qw6UAA+xOdomUtjjLYomtjsym0H3cdKmgm0fbiUx5x120+SbThEPISF+eBjBNAGQVm+8SpXp9KelxOHQ4zzjjAp7qGnJVVQHqBjAqORtjFTgjsRQA97qcsyyPtHYCg3EqsPnLc8g0sU+5R5saEIONzcmrUE6z5zDGeO4zQBF5+QSkZJ7EnpTRLIJMNgE8ipgJoyoXkE8p6inPaSELklMnIGM4oARWYx/OUDdc9zTlKK24jOehIpvlxwt+/c47kDk1HNexRK2xflHALdaANS1kgiLtJFvPc7c4qU3UZnDQxIe4JH9K5k3oMYkLMRn1qWG8dlO35RjPHGaAOlfU5mjKyMsa91Bxn8qo/bUR2AI479q5+S6Lhs79x601bryo8EfkKANmfVN7gI2G9fWqr3S4Zmcux7elZ4nZl3hc/WoxK7cNhfWgC4XZ5PvKpHscmq08+6TyyRn0AqJi0RBjOM8nPNR/vJ2+5u56+tAH3jRRRQAUUUUAFcL8V7Y3XhSBBKsbC8VgWGcnY/Fd1XnPxpufsvg60kwP+P8AQc/9c5KAPG7lrmztQ0kYCZG51GawZxbXEwdQCx68YJq/DrzRph4wQegPSmx6hZGRybb5yeMGgDHlthngcD1HWmhXi27cnPYVrm6WSXKxHaOPerVteeW+TGSAOnFAGE9zJnCo3HrUTXrq3MRX3BrqZGspudpVyOnvVeTT7eRSQFOBQBzr3rtkfN165pYZpHbAc5PHpW/Dp1oXYEquPYmtGDT9NWUFvnyeQV60AYkMgCAGd3PTAGKSRRg8kE+orqf7HtpZAYrcJnqSMClm0mJI8GFevegDjZI2KnOTxUJVug3geoFdQ9tGrj5MRk87TzTPsVqxwd5HfFAHMOApI6HjkcUxnYgcgY6k10x0ewZzlZGGeAXxVu30bSVUmS2Le7OTQBxTXAChgrNnqfWmGd2Py/lXoMOnaPA4/wBHRtwyNxzirTnSbNT/AMS+B2bkEGgDzdWncgIrE/Q1eigvmXKwPweoBrrzfacyZMccJ9EFMlvbby8JcbSoyAQKAOZNpqD5zCc45J609bW7j+Zxg/Stf+0GXcUk3nHeqkmq3TnByw7gCgBYNSa2yk6BlA4PcVfXX3I2xOVzxgVn/bYGTE0S5Pdu1MMekTfMZDGSeq0AXrl5pVEjSKBnku39KzpLwKw2srOOhDUy5sbJowIruVmP97pWPJYFGBjnxk9zigC/Nq1zg4AZv723msS41S784lwSnTBHFakWgXs7/wDH2iqBknJNTf2UsQzPcRjHBL0AYS668THbbwyD/bWrI8TahKoEEEKEdkjzVzyrBDuESN/tbf1qRJbIOAbyaIdlhjHH40AfWPgyR5fAvh6ST/WPplszfUxLmtysbwht/wCEK0HYzMv9nW+GbqR5a8mtmgAr53+IxWT4mawhjRmUQ9ep/cpX0RXzN8VZlj+KGqjcAcw8Z5/1KUAZ/wC7SA+Zagkngjg1Yi1a6gj2ws6woOeazLfUJpcQNKcHoHPFNvj5aYlZcEcKDigBurSSXsqyQurHqccGsmC9vLSfaMj608SmNfXnp3FICJuTwo/DNAGxDqxCglPqQf6Vox3yTAIJQM/ga56O3RxlXwB2pJgFzsmTcPwoA3L2JmUeWN5HI9fwrMl80KvUN+tO0+/dT5cyl27YPT8K1zbG7OI4VBx/FgGgDCVpUP3z9QKRpZw2EBbnsK1ToN0rFlyoPrzioxpCB1Mt1jB52jpQBS8y6dcM0ie2aYXw53En6VpXdnbYXyJZnXuGUDP61nmO0kn2OksYXglOtAEgvhEAVTcPaoWvnkj3+YoOfujP86WaPTVAVbi4LejAcflVRls4gSJQx/umgCydTlEfEzdOzGqj3RbnGf8Aaqu5jbLKGP0qtIwUHAP50AXGuWYYJwPamG5YHqwFVRKSBu6Y7U7dEeC5X8M0AWfPZ16cd+aYZjjuPTijEYTaHJPuKYdoT7xz6GgADkjDLkH1FPTPQY+hot41c427m9DW/p0EdnGZZ47ZB1wRuNAGVBHluAH9s1rxXsUUORYQDb3IqDUfELsvlwW8UaeqoATWN5k0nJViDQB1b+KNWvLdbOGZLS2AxiFdufqahgigX5pphxzuJyTWPahguXVgB6U+abccxxlVHUtQBry3WnL0USY56ZrqfhldQy/EDTFSFVY+bggdP3T15uS7Djnnp3Nd98KLd08f6U7QOq/vcMR/0yegD6PooooAKKKKACvD/wBohiv/AAjeNv8Ay9df+2Ve4V4Z+0XKsX/CNlsci66/9sqAPEGmeH5kO3PcGkaRmUvIMg9wM1EbpXAVgMHvmponUDAGQe1ADo7lootybuD05HFON/MyZXgn1OTVcNuZ1OeOwPSmrMiE/KxJ4OKAJBeTZ2mRwT2JpDdMxAZycf7VRuYyAUQ59+KCu1BhVAPUd6AE+0vvAJbjrzmmNMCQVbB74OM1ISCwzwP9rpUckRZiGdRj7vOBQA5VlnU4Dkd+etPCtFG3G0EYOTTYEhRgz3AP+7Uj3lqGZMFsd8YFAD4FhSL5ss2eKmSBZD86EDtxxTBqscaDZDGBjAzUb61I+P3aqF7gUATgeXJkoT6kURGJZMyoxIORs71mTag8pJzzmq73MjgAtx7UAdEdStIVw1uGOepOani1i0C+XHbW+3uXzmuUVyp5zTt4IPHXpg0AdHLr26ciK2iTb0KjBqldalLNlgT1655rHy5YLuxn8KcS4UYAA9jQBakupHj+bdgHrnvUUsxkGQTyMHnpVdSdxAGT/KkJbpgE0AWROVUIANuORQjnILORntmqmalhi804DAH3oAnZ88Z49VHSnAxshJf5h0G3rTGtwqE+b+BHWmJC7LkITz0FAFkSnZncQRwcHrURmjUdN+eozTxp82wMyHB6Z7U17GQbeVOfegCEzYyEXCn3pDcy7du847ipXtgmcke9QBF7tgeuKAPvqiiigAooooAK8t+PM5t/A1kwAOdSjHPb91LXqVeS/tDPs8AWBz/zFI//AEVLQB4RBtuSGkYgHoSOKka1jXcWl2sv93modF1aW3lWQCM7R0kGQRXTL4mtkj3z6VZzu3cDBFAHNxmZCTC2/PT1q3b317bS7cbG6neoIro7S68N3kgkn0+eI9/IYZz7VeSz8H3E5kM2oOo6q+M/pQByg1Ri+144yzfxcCtCS5VLcO+nwsvdo5+v4V0Lad4O3cSSRK3TzIt2P1qUeGfDEmGTV4dpHaBsg/nQBzK3SZJjsHQY4Ipkt1CQGaKYHHZa6j/hGtGVCIPEsS842MpGKlTwn5nyw+J7DHT53H5dKAOQW/g24zdg5yMZqWS/LoCBOQemSa6WfwprEZCQarYShejRuMVRufBOuOCZtTtQCMnFwP8AGgDAS4OSVjbcOQTTHvmYA+Y3PcGtGfwhcQLmTVIDnssuf0qB/DCIoH9oIM9MUAZ76gVyoYk+pPSov7QlIwWB/GtceGrQITJq0LHH3cGqFzpOn24Y/wBoEkfwqKAIv7RnVdqsv4UNcXLnJYdMEk4rPKxh8qxA96U7SgwWY54wKALEkpSMEyDPp61Ue4PJVzn3NRSJufO7PfDVUdwshAz1oA0BfOigq/I70+LVfmO8g1lGfaPWozfAOdqgjHU0Abhvo5OFBP1o+0jcVKjmuekvC5x8q/QVPDfKJOV6e9AGle3JjjAQHOOfasV7uVzkPx2q5dSxzo2WxxxWOSTxQBp2urz26MEkIz15NI+ovIPmf/x6syigC6A9xN5cUowRn5zgVMthdhtgmizjgCSsypPOkxjcSPegD7d8EqU8BeHVYgsumWwJHc+Utbtc/wCBf+Se+Gv+wVa/+ilroKACvlv4ukf8LQ1gnaMeR1/64x19SV8o/GV2/wCFqa0Ow8jH/fiOgDn4r1IQu8A46HvUF3d+ZcBtzPnpk9KyjK2eT+tHnEsFDfhQBrlwYt+Tu9+KTfExBJIGKpCYquDzUiTgdR+FAFqOby3Ijdvxpm55H6n61GZo2zhWBoguFgPTn3oAm85opAeSQevNaC61MSDvYYGPvVnSOk/z7lWmoqsfkcE+mKANdtamKY8yQk/7VRnVNxwWbPsazmt53J2BSfqBTDbTRMS+1T65zQBbkvpGIzI5A6ZNNW6fqW49KqmOQdeR61LAu5iCy4PrQAryZ+dTj6Gqkoyd2ST35qWZGHCSKwHYVAqsW25O4dQDQA+GeSN8hsDHQVFLLvYkk804QyO3yBie/eoJYZFb5wwPv2oAUsGGM4x0pyIzNwefWq5cqOeR70+O6McnY+lAGjb2lxOcRoW9STV4aU8a7riSKMe7ZrNTVJdu1SR9KqvcyyNmQkjtk0AbI1G0swRbwCSUcbm6VRl1C5umO4/8BHSq8cjYJMcbexFSRSKrHbAC5oARNx+8c89Catw3EkYAVAffvUXlXDcGNVHX61YWO4ZQoVVx0IoAsol1KM7SAT1NSJAhm/fzBQOwHWiCyn3gyXBPsvJ/wqygsoJhJcSKv+1Nz+goA0bJ7GMfIqg54JHJrt/h5dRv4406IL8x83n/ALZvXll1qnm3gjslMwP3WCED8BXf/C2w1h/Hul3d1E6W6CXO7A6xOBx+NAH0RRRRQAUUUUAFeB/tKkL/AMIuSP8An6/9o175Xgf7SpAPhc5x/wAff/tGgDwz7OxhyI+OvzGrCBVUHgHpgdqpW5kaYBAMnoa04ykah5Dlh1BNAEO3jPPJ5NHlNgY6DrmpZb2Mjjp6Cq325Nx2L06E0AWFiAYByoU9DTz9niQ/MHA56c1RlugVJUKfb0qqbmQ9CB9KALVzeCQlYwSOxIqo825Nm0A+tMMj+ppvWgBdxIoB54pKBjPIoAkWR1Uc5APAPakeV3PzOTTMn8KKAFBw2acGTPK8fXFMooAkLR54U4+tTR3FurDdb8ezVVooAvS3sX3YrdAOmWHNV/NUn7oqGigCcz9gox9KPOUjO3Dg8HFQUUAXIZIGP75ASferCzWUbBVj4NZdFAHSJqVjGm0WyBuzHrSf2nEBkRoMjFc7nnNGTjFAG3Lqu4gBTgfhVSS/HIxWfuJGM0lAE0k7OMfzqIsTSUUAff1FFFABRRRQAV5B+0b/AMk9sP8AsKx/+ipa9fryD9o3/knun/8AYVj/APRUtAHzbazbEJJxV0TeYoKkEnjGayUIPynAq3E8at8u4g8HB70AacLHn96R/vHHNXYmkiAbzFJPIw1ZUEasM5xjpk1fj2IVLBSKANFJ2eQF1LHHVD/SpBcOh+TcPcmq8f2fduO4HvtqYfZ92RIwWgCb7TKo4VOeuRS/apDy0Ubr09KrnyT0kHHqadsRsAPtB5yaAJWvVZgoTaO200jXSKD1B+tMWNOADxnr61G1spJYtmgBRdj+EnJ6ZNOl1B1RS5wQe1UZ0Cy5JBWmMN8IIcnjpigCWW/cjqQB0xyTVKScH73BPrVZi5yGBGDxVWSVl4zzQBcEgzgE596m+3JEgVsn3NYkkh5OePemtISMdu1AGlPfI8ocDkelUnvGc4wB7nrVYnIptAE7Tt7VEWJ6mm0UAGaBRRQA8zOV2k8UyiigAooooAKKKKAPt7wJ/wAk98Nf9gq1/wDRS10Fc/4E/wCSe+Gv+wVa/wDopa6CgAr5M+Mwz8WNcz/0w/8AREdfWdfJnxnJ/wCFr62OcfuP/REdAHBZKn5TkU5S24Hv703djsT74pQx+9g0ASLOVbDrnPpU43A4PAP41AJAMev0qX94FyBkH3oAsKhRCVINP+Zk5iJH0qqZGX2HfmpEkZ3AyQT78UANdT5g+Xb7A9KlATPXt15p7QzEj5CcUpcgbWiwB3xg0ARAMAAGIz3zTOdzbpDke+alLKxKj8qaWAPIyR7UAM3nbgSEnNIZCDgk88U9wCmfLA9DUDpMF+bNACyMMFVYjHeod5ibliR7UqBm4PHrmo5Y8HLEce9AEhuX+6rFR6ikWZmJ3M2emc9ahHPy+vQ4pwUrlcZI7EUAOYZ4PJpoaMngHim/ODjgClJIHTJPWgCRGy37tcHvxU+w55wfY023gfZkAAGp/nRguxmP+yKAJrexedwcbVPbvWnb6SVO9jGMf337VmBLt5B5cTbh0rVtNKurvAmu44M9QxyaAGXNzBEdg2Er/Fmqkl3MyhYnHPZBk101v4S01CGlke6f3YKv5da2bI6bpsLKlpbxvjG49aAOKttG1S5j3LDIN38UjEVs6d4MiLq2pXLOvUpGMY+pq1c68uTHFlwP4j/SsifxBKCQJOO+KAOxifRNGX/R1ii2j7wwSfxrZ8A+JVv/AB7plpBGfLfzdzn2ic/0rxyS7eSYuST9a7f4R3Ty/E3R0Z+P33GP+mL0AfUFFFFABRRRQAV4H+0sAV8M5HP+lY/8g175XgP7TGP+KX5/5+//AGjQB4YJZFjWNZQp7AYzUJkfBBcn1BqPfxnjNJ/Fk/nQA7cBgg8ims2RgfjSGgDPegBMn1ooIwcZzRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAH39RRRQAUUUUAFeQftHf8AJPdP/wCwrH/6Klr1+vIP2jv+Se2H/YVj/wDRUtAHzB71LGXU5WmKNxHAxV6MQgLtDHtyOlADYJJEYkk7fQjiphdSNjnge1TxR2u/aOHPqaeYoEYkx71B5oASOeXacnIPTmpBPcL8m5eelOM9u3yrGAMcChZYcYMfHXOaAGtM4BBwT/I0JdyRH7vf+IU83EYUgIpPXOKZ5gmYcACgCzHqUu7O1TjnFI2oHzd2wDPXHaq4hDD5WHXGDUTW53hNwJbvmgCw17uY5AYnsKha7wM7ce/eo5Lcpkb1BHcVE8DFMh+RQAst1vLY+U+lUpJFkbO7B9KV4zu64Pc1Aw55PHr60AKx6D9aaW7A8UhpKAAk0UUUAFFFFABRRRQAd6txG1HLZ+lVKKANGf7AY9yNz/dxzVWREChgOvvUFPR2XAB4+lAB5eWxuHTPWm7Tz7VKlwVJJRXJ67hSl43Pzx7M/wB2gD7X8Cf8k98Nf9gq1/8ARS10FYHgbH/Cv/De3OP7KtcZ/wCuS1v0AFfJfxnz/wALZ1v0/cf+iI6+tK+TfjKAfixrfH/PD/0RHQBwIHYHrSsT0oPbBoBAHORQAbuMZBFLnIwBikXlsjFPAIG7mgBAW7flTvNyRu6juKuGzuBpA1N1H2cz/Z85+bdt3dPTFat/4bXT9Ih1Ca9sHimz5YguA7Pg4OB7HrQBiiZyu5XP0qQTMw+eTj3NX28OXcOg22sOESwuJfKRt/IOSMkdh8p59qt3ng7VbNjHMsAbynmAEmS0akDcPYk8etAGErgt1JPr0oJCZL9+mTVyTRLpLzUbWQJ5unK7T/N0CsFOPXkinWmgaheaDd6zCgNpaMFkLN83boO+MjP1oAqCYbQABgetTsIyhLHBNUlfPfP4daeWbI3JyPSgBrQ5bOcjPemtCA3P8qvWkMcz/vHKn2rT/sNJx+7uE3dg3egDn1HlncFU49qV5Wd8lB+ArffwrqiRh/JjZT0w4yaiXwtqpbi1we3IoAwhg5ynPvT1ZQ2NmfpW3L4aurc7rl4o/UFxUDwW1u2d4kA/u0AVkZ2wuwKMcE1ajG/ADHPbjApjXMY4jT6E9Khe7LfKGK/SgC3iSA8so/GrEF20j4JAx3Y4rJEu8hyScVIkoR2Z2IHYCgDVbVHQkR5yO4PFU2v3ZmZmJz3zVJp2PU9arzXGMq5AHsKALk12wyoY89cd6z2cFuSc+lRNIWOUY7fU0mfn6E0AT7yy5A6V3vwdYf8AC09GHP8Ay34P/XCSvPQ4xjkmu6+DRz8WNFwxOPPz/wB+JKAPrKiiigAooooAK8C/aYz/AMUuB/099/8ArjXvteB/tLYz4XB/6e//AGjQB8/dOcfWpGeMoAI/m9aUKGbtTuMehzxxQBX70u3PQipZN7HnB96YAO/FADKM8dacevNNoAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiijB60Aff1FFFABRRRQAV5B+0b/yT2w/7Csf/oqWvX68g/aN/wCSe6f/ANhWP/0VLQB8wgHucU8k7RjOPrTcn8KNuO1AEqzEYAyKcsrKWA43e+KgNSK+Tg9qAJ/MYDBI/nSrOwXBYEZ6YqFcMCD97qPQ0gOMg8UAWfNfaTncKEuCFI3YPpmq+SFxnjtRxwMY+lAFn7Q7AAk04Tru5PIHBqqADgDNKMDNAFh7ht33/c5pjT/Ick5qHPGTjJpjMQTkHnvQAFmPOSajbOeTmgtyetJg8UAGOaSnBQM5oxxnpQA2jrTjx+NAXuaAG0UvIPBpKADpRS0dTxQAlHGPelpBQAUtGD05oIxigBKX60vTjikx+dAH274E/wCSe+Gv+wVa/wDopa6CsDwL/wAk98Nf9gq1/wDRS1v0AFfJnxmH/F2NbPQfuP8A0RHX1nXyT8aCf+Fsa4M8fuP/AERHQBwu30NNdsEZ5z70hI25VskeopueOhJoAkTk4UYxQW2j5iSewqPjJ6ilBDHO7BFAHQ2Guacnh2TSdQ06efNwbiOSKcJtYpt5BU5H5VSvdUW70nTrDywn2ISjduzv3tu6dsVlbuQCOaXq2cDj86AO1PjuK40s6RcaVG2mfZYoFRCFlBQhtxkxzk7+MfxU668fR3rvLJpipOLd7SJo3wqwEgopGOSuCM981xYxjn88U5UT72TQB2U3i7RJdZv7waLdhdRjkS5T7YMks6tlTs4wQfXrUtp48gsLWPTbTSE/s3bMs0czh5H8zIOHwMcbe38NccqRlQd3U+tNYIDtzjmgC2k7DJGB6DHSmPcueWAb6Go/Mj5XH4mnZjYYUqQfWgBoYj7iHnqRk1JHcyxoSpkAHeo9kpfETgE+lPeG7EWG37aALia3qEQHlXMgGPWpR4h1OT5WvZAvoTWWLeQc84HqOKOgBdRQBYluJpjuklZ29zUbMSvXn0zUZmxwo4qNny3JBFAE3mMFCk/LSbhjkbvTNV93znbj2pw3H73H0NAFmNwykAnI7ZxTk+YEsdtQK8aLnGTUTykngke1AE00yoSq5J96qiTzc7gOKQvlvmz+Ipu8ZweRQBICFHXFHzY/hI+tMCn6CngKAcUAORd3LDaBXefBsj/hbOi47+f/AOiJK8+RiMjcOa9A+DJ/4uxon/bfj/thJQB9Z0UUUAFFFFABXgf7SvXwxxn/AI++/wD1xr3yvBP2lf8AmWP+3v8A9o0AeB5AODikYjr1+lG0ntz2xTdmKAGljjrRuPqc0pBJpvTtQAbiRSUUdTQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAHel4x70DuMCjGO3NAH37RRRQAUUUUAFeQ/tF/8AJPbDH/QVj/8ARUtevV5J+0QAfh/YAnH/ABNI/wD0VLQB8wENxz+FOHA9venj7u1RkjqaTZtIzjJ7UANwOmB+XWlRVOTipNoBJYfN2xR1POMUAMbOeBgUm3PfmpOOcZpMDAGDn1NACKCwxTe5HXHepCMEAH8BQV289u9ADOnTBFL1IxxzSgjkj0oAyCcj8aAE+bOeDTcZJzkZpyKWXjP40u3nAHT1oAj2g/SmgZOCMDrU5A3YAz9KYdq8AEn3oAjK4zyDQceh60/bkn+frSlGI4GcUAR7eKMDvT1j5O7ijBHuPSgBm1ie1GB0J5+lOAOe/tTihAyRzQBGV45xSFQBkZzUuzjH40BeaAGEDjrSY29utSbe3FG3PX9aAIiR1AoIX1P1PSpNgwCeRTtjZBAwOwPegCLb8pz1zSYzyBz61I45wOvuKfsCrk43dsUAfavgX/kn3hr/ALBVr/6KWt+sDwN/yT/w3n/oFWv/AKKWt+gAr53+Jvwy8Y+IfiJqmqaXpHn2M/leVKLmFd22JFPDOCOQR0r6IooA+ST8FvH+cf2CSPUXlv8A/F0f8KW+IGONB/8AJyD/AOLr62ooA+R/+FL/ABBByPDwP/b7B/8AF0L8FfiBkk6Bj/t8g/8Ai6+uKKAPkRvgr8Qs/L4f/wDJ2D/4unr8F/iEp/5F8f8AgZB/8XX1xRQB8kD4K+P+f+JD+H2yD/4ulHwZ+IQ/5gBP/b5b/wDxyvraigD5Kb4NfEI9NAx/2+W//wAXTR8F/iDnJ0D/AMnLf/4uvreigD5JHwZ+IPIOgcf9fkH/AMXSj4M/EDp/YGB6/bLf/wCLr61ooA+UofhB8QYAAuhZ573kH/xdWD8K/iGRj+wOB0/0yD/4uvqWigD5Wk+EvxCcY/sHH/b5B/8AF1Vb4O/EMt/yAeP+vyD/AOLr6zooA+ST8GviGf8AmAf+TkH/AMXSj4NfEDv4eH/gZb//ABdfWtFAHyb/AMKa8fcf8U+R9LyD/wCOUf8AClvHobP9hA/W8g/+Lr6yooA+TD8F/iBz/wASMY9Bdwf/ABdN/wCFL+Phz/YBP/b5B/8AF19a0UAfJH/ClviBnP8AYH0AvIP/AI5TD8FfiEf+Zf8Ax+2W/wD8cr66ooA+R1+C/wAQRwfD+R6i9g/+OUn/AApX4gHj/hH+P+v2D/4uvrmigD5IHwW8fg/8i+Pb/S7f/wCLrr/hh8MPF/h74haXquq6T9ns4PN8yX7TE+N0TqOFcnqR2r6IooAKKKKACiiigArzH4vfDrWPH50b+ybmyg+w+f5n2qR1zv8ALxjarf3D1x2r06igD5k/4Z08XHrqOh/9/pv/AI3R/wAM6+L8/wDIS0T/AL/zf/Gq+m6KAPmI/s5+Lz/zEND/AO/83/xqkH7OXjDvqWh/9/5v/jVfT1FAHzD/AMM5eL/+gjof/f8Al/8AjVH/AAzl4v8A+gjoX/f+b/41X09RQB8wf8M4+L/+glof/f8Am/8AjVH/AAzj4v8A+glof/f+b/41X0/RQB8wf8M4+MP+glof/f8Am/8AjVH/AAzj4w/6CWh/9/5f/jVfT9FAHzB/wzj4v/6CWh/9/wCX/wCNUf8ADOPi/wD6CWh/9/5v/jVfT9FAHzB/wzj4v/6CWh/9/wCb/wCNUf8ADOPi/wD6CWh/9/5v/jVfT9FAHzB/wzj4v/6CWh/9/wCb/wCNUf8ADOPi/wD6CWh/9/5v/jVfT9FAHzB/wzj4v/6CWh/9/wCX/wCNUf8ADOPi/wD6CWh/9/5v/jVfT9FAHzB/wzj4v/6CWh/9/wCb/wCNUf8ADOPi/wD6CWh/9/5v/jVfT9FAHzB/wzj4v/6CWh/9/wCX/wCNUf8ADOPi/wD6CWh/9/5v/jVfT9FAHzB/wzj4v/6CWh/9/wCX/wCNUf8ADOPjD/oJaH/3/l/+NV9P0UAfMH/DOPi//oJaH/3/AJf/AI1S/wDDOXi7/oI6H/3/AJf/AI1X09RQB8w/8M5eL8/8hHQ/+/8AL/8AGqX/AIZz8X/9BLQ/+/8AL/8AGq+naKACiiigAooooAK8j/aIGfh/Yf8AYUj/APRUteuVzvjPwZp3jjSIdM1Oa6hhiuBcK1syq24Ky4O5SMYY9vSgD4tGHzg845BpecgZ+lfTH/DPHhLn/iY63z/03i/+NUH9nfwieuoa3/3/AIv/AI3QB80YbqB04NKqkZzwBX0t/wAM8eEsYGo62B/13i/+N0H9nfwkeupa2f8AtvF/8aoA+aSpCnA6Gk+c8dfwr6ZH7PfhMf8AMR1s/wDbeL/43SN+zz4Sb/mI62PpPF/8boA+ZwOBk0mTnnOO3NfTH/DO/hL/AKCOt/8Af+L/AONUf8M7+Ev+gjref+u0X/xqgD5nJHY807+Gvpb/AIZ48I4I+361z386L/43Sj9njwkBj+0db/7/AMX/AMboA+Zwu7GcDJ/OjAznvmvpf/hnfwif+Yhrf/f6L/43R/wzv4S/6COt8f8ATeL/AONUAfM5680uzkdPwr6Y/wCGePCR/wCYhrf/AH+i/wDjdIP2ePCQGP7R1v8A7/xf/GqAPmgAAduO1Azmvpj/AIZ58Jcf8THWuP8AptF/8aoH7PPhIHP9o61n/rtF/wDG6APmdgTnP0pAAvPBr6Z/4Z58JHP/ABMdb5/6bRf/ABqk/wCGePCWMf2jrY/7bxf/ABqgD5mK+o70nU8/nX01/wAM8eEv+gjrZ/7bxf8Axqj/AIZ48JZz/aGt/wDf+L/43QB80YyOuKaF4JPHtX00f2ePCRx/xMdb/wC/0X/xuk/4Z38JYx/aOt/9/wCL/wCNUAfMwUZPoKft56jHpX0t/wAM7+Ev+gjrf/f+L/41Sj9njwl/0EdbP1mi/wDjdAHzLyRyAO1CgZAPOB96vpkfs7+ER01DWx/23i/+N0D9njwkD/yEtb/7/Q//ABqgD5oyGJwe3OKQJnoePevpk/s8eEv+gjrY+k0X/wAapD+zx4S5/wCJjrYz/wBNov8A41QB3vgf/kQPDf8A2C7b/wBFLW9VTStOh0fR7LTLdnaGzt47eNpCCxVFCgnAAzgelW6ACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooA//9k=")||It(Le,"src",tA),hA($e.src,RA="data:image/jpeg;base64,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")||It($e,"src",RA)},m(e,l){IA(document.head,j),A(e,ll,l),A(e,_e,l),A(e,tl,l),m(g,e,l),A(e,Al,l),m(c,e,l),A(e,il,l),A(e,u,l),A(e,al,l),A(e,M,l),A(e,sl,l),m(d,e,l),A(e,nl,l),A(e,F,l),A(e,ol,l),A(e,b,l),A(e,rl,l),m(R,e,l),A(e,ml,l),A(e,B,l),A(e,pl,l),A(e,C,l),A(e,Kl,l),m(J,e,l),A(e,Ul,l),A(e,k,l),A(e,fl,l),m(T,e,l),A(e,yl,l),A(e,h,l),A(e,wl,l),m(H,e,l),A(e,jl,l),m(z,e,l),A(e,gl,l),A(e,P,l),A(e,cl,l),m(v,e,l),A(e,ul,l),A(e,x,l),A(e,Ml,l),m(V,e,l),A(e,dl,l),A(e,G,l),A(e,Fl,l),m(I,e,l),A(e,bl,l),A(e,Q,l),A(e,Rl,l),m(X,e,l),A(e,Bl,l),A(e,W,l),A(e,Cl,l),m(Z,e,l),A(e,Jl,l),A(e,q,l),A(e,kl,l),m(N,e,l),A(e,Tl,l),A(e,D,l),A(e,hl,l),m(Y,e,l),A(e,Hl,l),A(e,Le,l),A(e,zl,l),m(S,e,l),A(e,Pl,l),A(e,O,l),A(e,vl,l),A(e,E,l),A(e,xl,l),m(L,e,l),A(e,Vl,l),m($,e,l),A(e,Gl,l),m(_,e,l),A(e,Il,l),m(ee,e,l),A(e,Ql,l),m(le,e,l),A(e,Xl,l),m(te,e,l),A(e,Wl,l),m(Ae,e,l),A(e,Zl,l),m(ie,e,l),A(e,ql,l),m(ae,e,l),A(e,Nl,l),m(se,e,l),A(e,Dl,l),m(ne,e,l),A(e,Yl,l),A(e,oe,l),A(e,Sl,l),m(re,e,l),A(e,Ol,l),m(me,e,l),A(e,El,l),m(pe,e,l),A(e,Ll,l),m(Ke,e,l),A(e,$l,l),A(e,Ue,l),A(e,_l,l),A(e,fe,l),A(e,et,l),m(ye,e,l),A(e,lt,l),A(e,we,l),A(e,tt,l),A(e,je,l),A(e,At,l),m(ge,e,l),A(e,it,l),A(e,ce,l),A(e,at,l),A(e,ue,l),A(e,st,l),A(e,Me,l),A(e,nt,l),A(e,de,l),A(e,ot,l),A(e,Fe,l),A(e,rt,l),A(e,be,l),A(e,mt,l),m(Re,e,l),A(e,pt,l),A(e,Be,l),A(e,Kt,l),m(Ce,e,l),A(e,Ut,l),A(e,Je,l),A(e,ft,l),A(e,ke,l),A(e,yt,l),m(Te,e,l),A(e,wt,l),A(e,he,l),A(e,jt,l),A(e,He,l),A(e,gt,l),m(ze,e,l),A(e,ct,l),A(e,Pe,l),A(e,ut,l),m(ve,e,l),A(e,Mt,l),m(xe,e,l),A(e,dt,l),A(e,Ve,l),A(e,Ft,l),m(Ge,e,l),A(e,bt,l),A(e,Ie,l),A(e,Rt,l),A(e,Qe,l),A(e,Bt,l),m(Xe,e,l),A(e,Ct,l),A(e,$e,l),A(e,Jt,l),m(We,e,l),A(e,kt,l),A(e,Ze,l),A(e,Tt,l),A(e,qe,l),A(e,ht,l),m(Ne,e,l),A(e,Ht,l),A(e,De,l),A(e,zt,l),A(e,Ye,l),A(e,Pt,l),m(Se,e,l),A(e,vt,l),A(e,Oe,l),A(e,xt,l),m(Ee,e,l),A(e,Vt,l),A(e,el,l),Gt=!0},p:PA,i(e){Gt||(p(g.$$.fragment,e),p(c.$$.fragment,e),p(d.$$.fragment,e),p(R.$$.fragment,e),p(J.$$.fragment,e),p(T.$$.fragment,e),p(H.$$.fragment,e),p(z.$$.fragment,e),p(v.$$.fragment,e),p(V.$$.fragment,e),p(I.$$.fragment,e),p(X.$$.fragment,e),p(Z.$$.fragment,e),p(N.$$.fragment,e),p(Y.$$.fragment,e),p(S.$$.fragment,e),p(L.$$.fragment,e),p($.$$.fragment,e),p(_.$$.fragment,e),p(ee.$$.fragment,e),p(le.$$.fragment,e),p(te.$$.fragment,e),p(Ae.$$.fragment,e),p(ie.$$.fragment,e),p(ae.$$.fragment,e),p(se.$$.fragment,e),p(ne.$$.fragment,e),p(re.$$.fragment,e),p(me.$$.fragment,e),p(pe.$$.fragment,e),p(Ke.$$.fragment,e),p(ye.$$.fragment,e),p(ge.$$.fragment,e),p(Re.$$.fragment,e),p(Ce.$$.fragment,e),p(Te.$$.fragment,e),p(ze.$$.fragment,e),p(ve.$$.fragment,e),p(xe.$$.fragment,e),p(Ge.$$.fragment,e),p(Xe.$$.fragment,e),p(We.$$.fragment,e),p(Ne.$$.fragment,e),p(Se.$$.fragment,e),p(Ee.$$.fragment,e),Gt=!0)},o(e){K(g.$$.fragment,e),K(c.$$.fragment,e),K(d.$$.fragment,e),K(R.$$.fragment,e),K(J.$$.fragment,e),K(T.$$.fragment,e),K(H.$$.fragment,e),K(z.$$.fragment,e),K(v.$$.fragment,e),K(V.$$.fragment,e),K(I.$$.fragment,e),K(X.$$.fragment,e),K(Z.$$.fragment,e),K(N.$$.fragment,e),K(Y.$$.fragment,e),K(S.$$.fragment,e),K(L.$$.fragment,e),K($.$$.fragment,e),K(_.$$.fragment,e),K(ee.$$.fragment,e),K(le.$$.fragment,e),K(te.$$.fragment,e),K(Ae.$$.fragment,e),K(ie.$$.fragment,e),K(ae.$$.fragment,e),K(se.$$.fragment,e),K(ne.$$.fragment,e),K(re.$$.fragment,e),K(me.$$.fragment,e),K(pe.$$.fragment,e),K(Ke.$$.fragment,e),K(ye.$$.fragment,e),K(ge.$$.fragment,e),K(Re.$$.fragment,e),K(Ce.$$.fragment,e),K(Te.$$.fragment,e),K(ze.$$.fragment,e),K(ve.$$.fragment,e),K(xe.$$.fragment,e),K(Ge.$$.fragment,e),K(Xe.$$.fragment,e),K(We.$$.fragment,e),K(Ne.$$.fragment,e),K(Se.$$.fragment,e),K(Ee.$$.fragment,e),Gt=!1},d(e){e&&(t(ll),t(_e),t(tl),t(Al),t(il),t(u),t(al),t(M),t(sl),t(nl),t(F),t(ol),t(b),t(rl),t(ml),t(B),t(pl),t(C),t(Kl),t(Ul),t(k),t(fl),t(yl),t(h),t(wl),t(jl),t(gl),t(P),t(cl),t(ul),t(x),t(Ml),t(dl),t(G),t(Fl),t(bl),t(Q),t(Rl),t(Bl),t(W),t(Cl),t(Jl),t(q),t(kl),t(Tl),t(D),t(hl),t(Hl),t(Le),t(zl),t(Pl),t(O),t(vl),t(E),t(xl),t(Vl),t(Gl),t(Il),t(Ql),t(Xl),t(Wl),t(Zl),t(ql),t(Nl),t(Dl),t(Yl),t(oe),t(Sl),t(Ol),t(El),t(Ll),t($l),t(Ue),t(_l),t(fe),t(et),t(lt),t(we),t(tt),t(je),t(At),t(it),t(ce),t(at),t(ue),t(st),t(Me),t(nt),t(de),t(ot),t(Fe),t(rt),t(be),t(mt),t(pt),t(Be),t(Kt),t(Ut),t(Je),t(ft),t(ke),t(yt),t(wt),t(he),t(jt),t(He),t(gt),t(ct),t(Pe),t(ut),t(Mt),t(dt),t(Ve),t(Ft),t(bt),t(Ie),t(Rt),t(Qe),t(Bt),t(Ct),t($e),t(Jt),t(kt),t(Ze),t(Tt),t(qe),t(ht),t(Ht),t(De),t(zt),t(Ye),t(Pt),t(vt),t(Oe),t(xt),t(Vt),t(el)),t(j),U(g,e),U(c,e),U(d,e),U(R,e),U(J,e),U(T,e),U(H,e),U(z,e),U(v,e),U(V,e),U(I,e),U(X,e),U(Z,e),U(N,e),U(Y,e),U(S,e),U(L,e),U($,e),U(_,e),U(ee,e),U(le,e),U(te,e),U(Ae,e),U(ie,e),U(ae,e),U(se,e),U(ne,e),U(re,e),U(me,e),U(pe,e),U(Ke,e),U(ye,e),U(ge,e),U(Re,e),U(Ce,e),U(Te,e),U(ze,e),U(ve,e),U(xe,e),U(Ge,e),U(Xe,e),U(We,e),U(Ne,e),U(Se,e),U(Ee,e)}}}const ZA='{"title":"Vision Transformer Modelini Özel Bir Biyomedikal Verisetiyle Fine-Tune Etmek","local":"vision-transformer-modelini-özel-bir-biyomedikal-verisetiyle-fine-tune-etmek","sections":[{"title":"Veriseti Bilgisi","local":"veriseti-bilgisi","sections":[],"depth":2},{"title":"Model Bilgisi","local":"model-bilgisi","sections":[],"depth":2},{"title":"Başlarken","local":"başlarken","sections":[],"depth":2},{"title":"Verisetini Hazırlamak","local":"verisetini-hazırlamak","sections":[],"depth":2},{"title":"Veri İşleme","local":"veri-işleme","sections":[{"title":"Etiket Eşleme","local":"etiket-eşleme","sections":[],"depth":3},{"title":"Görüntü İşleme","local":"görüntü-işleme","sections":[],"depth":3},{"title":"Dönüşüm fonksiyonlarını oluşturma","local":"dönüşüm-fonksiyonlarını-oluşturma","sections":[],"depth":3},{"title":"Dönüşüm fonksiyonlarını her bir sete uygulayalım","local":"dönüşüm-fonksiyonlarını-her-bir-sete-uygulayalım","sections":[],"depth":3},{"title":"Veri Yükleme (DataLoader)","local":"veri-yükleme-dataloader","sections":[],"depth":3},{"title":"Batch Hazırlığı","local":"batch-hazırlığı","sections":[],"depth":3}],"depth":2},{"title":"Modeli Fine-Tune Etme","local":"modeli-fine-tune-etme","sections":[{"title":"(Opsiyonel) Modeli Hub’a Yükleme","local":"opsiyonel-modeli-huba-yükleme","sections":[],"depth":3}],"depth":2},{"title":"Sonuçlar","local":"sonuçlar","sections":[{"title":"Confusion Matrix Nedir?","local":"confusion-matrix-nedir","sections":[],"depth":3},{"title":"Recall Skoru Nedir?","local":"recall-skoru-nedir","sections":[],"depth":3}],"depth":2},{"title":"Sonuç","local":"sonuç","sections":[],"depth":2}],"depth":1}';function qA(Qt){return vA(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class OA extends xA{constructor(j){super(),VA(this,j,qA,WA,zA,{})}}export{OA as component};
