import{s as Fs,n as Ls,o as Ds}from"../chunks/scheduler.65852ee5.js";import{S as Ps,i as Os,g as M,s as n,r as p,A as Ks,h as J,f as s,c as a,j as Ss,u as T,x as i,k as Ys,l as le,y as te,a as e,v as w,d as o,t as j,w as c}from"../chunks/index.aa74147d.js";import{D as se,C as d}from"../chunks/DocNotebookDropdown.1a7e6a42.js";import{H as I,E as ee}from"../chunks/getInferenceSnippets.796600e5.js";function ne(as){let y,Rl,Wl,El,u,Vl,m,Ql,U,Ms='<em>作者：<a href="https://qdrant.tech/" rel="nofollow">Qdrant 团队</a></em>',ql,b,Js="在这个 Notebook 中，我们演示了如何使用向量嵌入来导航代码库并找到相关的代码片段。我们将使用自然语义查询来搜索代码库，并根据相似的逻辑查找代码。",zl,h,is='你可以查看这个方法的<a href="https://code-search.qdrant.tech/" rel="nofollow">实时部署</a>，该部署通过一个网页界面提供 Qdrant 代码库的搜索功能。',Xl,f,Hl,C,ps="为了实现我们的目标，我们需要两个模型：",Sl,x,Ts='<li><p>用于自然语言处理（NLP）的通用神经编码器， 在我们的案例中使用的是 <a href="https://huggingface.co/sentence-transformers/all-MiniLM-L6-v2" rel="nofollow">sentence-transformers/all-MiniLM-L6-v2</a> 模型。我们将称之为 <strong>NLP 模型</strong>。</p></li> <li><p>用于代码间相似度搜索的专门嵌入模型。我们将使用 <a href="https://huggingface.co/jinaai/jina-embeddings-v2-base-code" rel="nofollow">jinaai/jina-embeddings-v2-base-code</a> 模型来完成此任务。它支持英语和 30 种广泛使用的编程语言，且具有 8192 的序列长度。我们将称之为 <strong>代码模型</strong>。</p></li>',Yl,B,ws="为了准备 NLP 模型所需的代码，我们需要将代码预处理成一种更接近自然语言的格式。由于代码模型已经支持多种标准编程语言，因此无需对代码片段进行预处理。我们可以直接使用原始代码。",Fl,Z,Ll,g,os="让我们安装将要使用的包。",Dl,A,js='<li><a href="https://pypi.org/project/inflection/" rel="nofollow">inflection</a> - 一个字符串转换库。它可以将英文单词的复数转为单数，单数转为复数，并将驼峰命名法（CamelCase）转换为下划线分隔的字符串。</li> <li><a href="https://pypi.org/project/fastembed/" rel="nofollow">fastembed</a> - 一个轻量级的库，用于生成向量嵌入，优先支持 CPU。<a href="https://github.com/qdrant/fastembed#%EF%B8%8F-fastembed-on-a-gpu" rel="nofollow">支持 GPU</a>。</li> <li><a href="https://pypi.org/project/qdrant-client/" rel="nofollow">qdrant-client</a> - 官方的 Python 库，用于与 Qdrant 服务器进行交互。</li>',Pl,G,Ol,_,Kl,N,cs="将应用程序源代码分割成更小的部分是一个复杂的任务。通常，函数、类方法、结构体、枚举以及所有其他语言特定的构造体都是很好的分块候选。它们足够大，能包含一些有意义的信息，但又足够小，适合被嵌入模型处理，因为这些模型有一个有限的上下文窗口。你还可以使用文档字符串（docstrings）、注释和其他元数据来丰富这些块，增加额外的信息。",lt,r,ds='<img src="https://huggingface.co/datasets/Anush008/cookbook-images/resolve/main/data-chunking.png"/>',tt,k,Is="基于文本的搜索通常是基于函数签名的，但代码搜索可能会返回更小的部分，比如循环。因此，如果我们从 NLP 模型收到一个特定的函数签名，并且从代码模型收到该函数部分实现的代码，我们将合并这些结果。",st,v,et,W,ys='我们将使用 <a href="https://github.com/qdrant/qdrant" rel="nofollow">Qdrant 代码库</a> 来进行演示。虽然该代码库使用的是 Rust，但你可以使用此方法处理任何其他编程语言。你可以使用 <a href="https://microsoft.github.io/language-server-protocol/" rel="nofollow">语言服务器协议（LSP）</a> 工具来构建代码库的图谱，然后提取代码块。我们使用了 <a href="https://rust-analyzer.github.io/" rel="nofollow">rust-analyzer</a> 完成这项工作。我们将解析后的代码库导出为 <a href="https://microsoft.github.io/language-server-protocol/specifications/lsif/0.4.0/specification/" rel="nofollow">LSIF</a> 格式，这是一个用于代码智能的数据标准。接下来，我们利用 LSIF 数据来导航代码库并提取代码块。',nt,$,rs='你可以对其他编程语言使用相同的方法。市面上有<a href="https://microsoft.github.io/language-server-protocol/implementors/servers/" rel="nofollow">大量的实现</a>可供选择。',at,R,us="接下来，我们将把代码块导出为 JSON 文档，文档中不仅包含代码本身，还会包括代码在项目中的位置信息（上下文）。",Mt,E,ms='你可以在我们的 Google Cloud Storage 存储桶中查看解析为 JSON 格式的 Qdrant 结构，文件名为 <a href="https://storage.googleapis.com/tutorial-attachments/code-search/structures.jsonl" rel="nofollow">structures.jsonl 文件</a>。下载该文件，并将其用作我们的代码搜索数据源。',Jt,V,it,Q,Us="接下来，加载文件并将每一行解析为字典列表：",pt,q,Tt,z,bs="我们来看一下一个条目的结构是怎样的",wt,X,ot,H,jt,S,ct,Y,hs="每种编程语言都有其特定的语法，而这些语法并不是自然语言的一部分。因此，一个通用模型可能无法直接理解代码。然而，我们可以通过去除代码特有的部分并加入额外的上下文（如模块、类、函数和文件名）来规范化数据。我们采取以下步骤：",dt,F,fs="<li>提取函数、方法或其他代码结构的签名。</li> <li>将驼峰命名法（CamelCase）和下划线命名法（snake_case）中的名称拆分为单独的单词。</li> <li>获取文档字符串（docstring）、注释和其他重要的元数据。</li> <li>使用预定义的模板根据提取的数据构建句子。</li> <li>移除特殊字符并用空格替代。</li>",It,L,Cs="我们现在可以定义 <code>textify</code> 函数，利用 <code>inflection</code> 库来执行我们的转换操作：",yt,D,rt,P,xs="现在我们可以使用 <code>textify</code> 函数将所有的代码块转换为文本表示",ut,O,mt,K,Bs="让我们看看其中一个转换后的自然语言表示是什么样子的：",Ut,ll,bt,tl,ht,sl,ft,el,Ct,nl,xt,al,Bt,Ml,Zt,Jl,Zs='Qdrant 支持多种部署模式，包括内存模式（用于原型开发）、Docker 和 Qdrant Cloud。你可以参考 <a href="https://qdrant.tech/documentation/guides/installation/" rel="nofollow">安装指南</a> 了解更多信息。',gt,il,gs="我们将在此教程中使用内存实例继续操作。",At,pl,As=`<p><strong>提示</strong><br/>
内存模式只能用于快速原型开发和测试。它是 Qdrant 服务器方法的 Python 实现。</p>`,Gt,Tl,Gs="现在，让我们创建一个集合来存储我们的向量。",_t,wl,Nt,ol,_s="我们新创建的集合已经准备好接受数据。接下来，让我们上传嵌入向量：",kt,jl,vt,cl,Ns="上传的点立即可以用于搜索。接下来，查询集合以找到相关的代码片段。",Wt,dl,$t,Il,ks='我们使用其中一个模型通过 Qdrant 的新 <a href="https://qdrant.tech/blog/qdrant-1.10.x/" rel="nofollow">查询 API</a> 搜索集合。首先使用文本嵌入。运行以下查询：“如何计算集合中的点数？”。然后查看查询结果。',Rt,yl,Et,rl,vs="现在，查看查询结果。以下表格列出了模块、文件名和得分。每一行都包含一个指向签名的链接。",Vt,ul,Ws='<thead><tr><th>模块</th> <th>文件名</th> <th>得分</th> <th>签名</th></tr></thead> <tbody><tr><td>operations</td> <td>types.rs</td> <td>0.5493385</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/collection/src/operations/types.rs#L794" rel="nofollow"><code>pub struct CountRequestInternal</code></a></td></tr> <tr><td>map_index</td> <td>types.rs</td> <td>0.49973965</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/map_index/mod.rs#L89" rel="nofollow"><code>fn get_points_with_value_count</code></a></td></tr> <tr><td>map_index</td> <td>mutable_map_index.rs</td> <td>0.49941066</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/map_index/mutable_map_index.rs#L143" rel="nofollow"><code>pub fn get_points_with_value_count</code></a></td></tr></tbody>',Qt,ml,$s="看起来我们已经能够找到一些相关的代码结构。接下来，让我们使用代码嵌入（code embeddings）再试一次。",qt,Ul,zt,bl,Rs="输出结果：",Xt,hl,Es='<thead><tr><th>模块</th> <th>文件名</th> <th>得分</th> <th>签名</th></tr></thead> <tbody><tr><td>field_index</td> <td>geo_index.rs</td> <td>0.7217579</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/geo_index/mod.rs#L319" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr> <tr><td>numeric_index</td> <td>mod.rs</td> <td>0.7113214</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/numeric_index/mod.rs#L317" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr> <tr><td>full_text_index</td> <td>text_index.rs</td> <td>0.6993165</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/full_text_index/text_index.rs#L179" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr></tbody>',Ht,fl,Vs="虽然不同模型得到的得分不可直接比较，但我们可以看到，结果是不同的。代码嵌入和文本嵌入能够捕捉到代码库的不同方面。我们可以使用这两种模型查询集合，然后将结果结合起来，以获取最相关的代码片段。",St,Cl,Yt,xl,Ft,Bl,Qs='|  operations  |  lib/collection/src/operations/types.rs  |  0.5  | ` # [doc = " Count Request"] # [doc = " Counts the number of points which satisfy the given filter."] # [doc = " If filter is not provided, the count of all points in the collection will be returned."] # [derive (Debug , Deserialize , Serialize , JsonSchema , Validate)] # [serde (rename_all = "snake_case")] pub struct CountRequestInternal &#123; # [doc = " Look only for points which satisfies this conditions"] # [validate] pub filter : Option < Filter > , # [doc = " If true, count exact number of points. If false, count approximate number of points faster."] # [doc = " Approximate count might be unreliable during the indexing process. Default: true"] # [serde (default = "default_exact_count")] pub exact : bool , } ` |\n|  field_index  |  lib/segment/src/index/field_index/geo_index.rs  |  0.5  | ` fn count_indexed_points (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.33333334  | ` fn get_points_with_value_count < Q > (& self , value : & Q) -> Option < usize > where Q : ? Sized , N : std :: borrow :: Borrow < Q > , Q : Hash + Eq , ` |\n|  numeric_index  |  lib/segment/src/index/field_index/numeric_index/mod.rs  |  0.33333334  | ` fn count_indexed_points (& self) -> usize ` |\n|  fixtures  |  lib/segment/src/fixtures/payload_context_fixture.rs  |  0.25  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mutable_map_index.rs  |  0.25  | ` fn get_points_with_value_count < Q > (& self , value : & Q) -> Option < usize > where Q : ? Sized , N : std :: borrow :: Borrow < Q > , Q : Hash + Eq , ` |\n|  id_tracker  |  lib/segment/src/id_tracker/simple_id_tracker.rs  |  0.2  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.2  | ` fn count_indexed_points (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.16666667  | ` fn count_indexed_points (& self) -> usize ` |\n|  field_index  |  lib/segment/src/index/field_index/stat_tools.rs  |  0.16666667  | ` fn number_of_selected_points (points : usize , values : usize) -> usize ` |\n',Lt,Zl,qs="这是一个如何融合不同模型结果的示例。在实际场景中，你可能会进行一些重新排序（reranking）和去重（deduplication），以及对结果进行额外的处理。",Dt,gl,Pt,Al,zs="你可以通过按负载属性对搜索结果进行分组，从而改进搜索结果。在我们的例子中，我们可以按模块对结果进行分组。如果我们使用代码嵌入，可能会看到来自 <code>map_index</code> 模块的多个结果。让我们对结果进行分组，并假设每个模块只显示一个结果：",Ot,Gl,Kt,_l,ls,Nl,Xs="|  field_index  |  geo_index.rs  |  0.7217579  | ` fn count_indexed_points (& self) -> usize ` |\n|  numeric_index  |  mod.rs  |  0.7113214  | ` fn count_indexed_points (& self) -> usize ` |\n|  fixtures  |  payload_context_fixture.rs  |  0.6993165  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  mod.rs  |  0.68385994  | ` fn count_indexed_points (& self) -> usize ` |\n|  full_text_index  |  text_index.rs  |  0.6660142  | ` fn count_indexed_points (& self) -> usize ` |\n",ts,kl,Hs='这就结束了我们的教程。感谢你花时间跟随我们完成这个过程。我们刚刚开始探索使用向量嵌入的可能性以及如何改进它。请随意进行实验，或许你能构建出非常酷的东西！如果你有任何创意，欢迎与我们分享 🙏 我们的联系方式在 <a href="https://qdrant.tech/contact-us/" rel="nofollow">这里</a>。',ss,vl,es,$l,ns;return u=new se({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/code_search.ipynb"}]}}),m=new I({props:{title:"使用向量嵌入和 Qdrant 进行代码搜索",local:"使用向量嵌入和-qdrant-进行代码搜索",headingTag:"h2"}}),f=new I({props:{title:"方法",local:"方法",headingTag:"h3"}}),Z=new I({props:{title:"安装依赖项",local:"安装依赖项",headingTag:"h2"}}),G=new d({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGluZmxlY3Rpb24lMjBxZHJhbnQtY2xpZW50JTIwZmFzdGVtYmVk",highlighted:"%pip install inflection qdrant-client fastembed",wrap:!1}}),_=new I({props:{title:"数据准备",local:"数据准备",headingTag:"h3"}}),v=new I({props:{title:"解析代码库",local:"解析代码库",headingTag:"h3"}}),V=new d({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRnN0b3JhZ2UuZ29vZ2xlYXBpcy5jb20lMkZ0dXRvcmlhbC1hdHRhY2htZW50cyUyRmNvZGUtc2VhcmNoJTJGc3RydWN0dXJlcy5qc29ubA==",highlighted:"!wget https://storage.googleapis.com/tutorial-attachments/code-search/structures.jsonl",wrap:!1}}),q=new d({props:{code:"aW1wb3J0JTIwanNvbiUwQSUwQXN0cnVjdHVyZXMlMjAlM0QlMjAlNUIlNUQlMEF3aXRoJTIwb3BlbiglMjJzdHJ1Y3R1cmVzLmpzb25sJTIyJTJDJTIwJTIyciUyMiklMjBhcyUyMGZwJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMHJvdyUyMGluJTIwZW51bWVyYXRlKGZwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudHJ5JTIwJTNEJTIwanNvbi5sb2Fkcyhyb3cpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RydWN0dXJlcy5hcHBlbmQoZW50cnkp",highlighted:`<span class="hljs-keyword">import</span> json

structures = []
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;structures.jsonl&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> fp:
    <span class="hljs-keyword">for</span> i, row <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(fp):
        entry = json.loads(row)
        structures.append(entry)`,wrap:!1}}),X=new d({props:{code:"c3RydWN0dXJlcyU1QjAlNUQ=",highlighted:'structures[<span class="hljs-number">0</span>]',wrap:!1}}),H=new d({props:{code:"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",highlighted:`{<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;InvertedIndexRam&#x27;</span>,
 <span class="hljs-string">&#x27;signature&#x27;</span>: <span class="hljs-string">&#x27;# [doc = &quot; Inverted flatten index from dimension id to posting list&quot;] # [derive (Debug , Clone , PartialEq)] pub struct InvertedIndexRam { # [doc = &quot; Posting lists for each dimension flattened (dimension id -&gt; posting list)&quot;] # [doc = &quot; Gaps are filled with empty posting lists&quot;] pub postings : Vec &lt; PostingList &gt; , # [doc = &quot; Number of unique indexed vectors&quot;] # [doc = &quot; pre-computed on build and upsert to avoid having to traverse the posting lists.&quot;] pub vector_count : usize , }&#x27;</span>,
 <span class="hljs-string">&#x27;code_type&#x27;</span>: <span class="hljs-string">&#x27;Struct&#x27;</span>,
 <span class="hljs-string">&#x27;docstring&#x27;</span>: <span class="hljs-string">&#x27;= &quot; Inverted flatten index from dimension id to posting list&quot;&#x27;</span>,
 <span class="hljs-string">&#x27;line&#x27;</span>: <span class="hljs-number">15</span>,
 <span class="hljs-string">&#x27;line_from&#x27;</span>: <span class="hljs-number">13</span>,
 <span class="hljs-string">&#x27;line_to&#x27;</span>: <span class="hljs-number">22</span>,
 <span class="hljs-string">&#x27;context&#x27;</span>: {<span class="hljs-string">&#x27;module&#x27;</span>: <span class="hljs-string">&#x27;inverted_index&#x27;</span>,
  <span class="hljs-string">&#x27;file_path&#x27;</span>: <span class="hljs-string">&#x27;lib/sparse/src/index/inverted_index/inverted_index_ram.rs&#x27;</span>,
  <span class="hljs-string">&#x27;file_name&#x27;</span>: <span class="hljs-string">&#x27;inverted_index_ram.rs&#x27;</span>,
  <span class="hljs-string">&#x27;struct_name&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;snippet&#x27;</span>: <span class="hljs-string">&#x27;/// Inverted flatten index from dimension id to posting list\\n#[derive(Debug, Clone, PartialEq)]\\npub struct InvertedIndexRam {\\n    /// Posting lists for each dimension flattened (dimension id -&gt; posting list)\\n    /// Gaps are filled with empty posting lists\\n    pub postings: Vec&lt;PostingList&gt;,\\n    /// Number of unique indexed vectors\\n    /// pre-computed on build and upsert to avoid having to traverse the posting lists.\\n    pub vector_count: usize,\\n}\\n&#x27;</span>}}`,wrap:!1}}),S=new I({props:{title:"代码到自然语言的转换",local:"代码到自然语言的转换",headingTag:"h3"}}),D=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> inflection
<span class="hljs-keyword">import</span> re

<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">textify</span>(<span class="hljs-params">chunk: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-comment"># Get rid of all the camel case / snake case</span>
    <span class="hljs-comment"># - inflection.underscore changes the camel case to snake case</span>
    <span class="hljs-comment"># - inflection.humanize converts the snake case to human readable form</span>
    name = inflection.humanize(inflection.underscore(chunk[<span class="hljs-string">&quot;name&quot;</span>]))
    signature = inflection.humanize(inflection.underscore(chunk[<span class="hljs-string">&quot;signature&quot;</span>]))

    <span class="hljs-comment"># Check if docstring is provided</span>
    docstring = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">if</span> chunk[<span class="hljs-string">&quot;docstring&quot;</span>]:
        docstring = <span class="hljs-string">f&quot;that does <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;docstring&#x27;</span>]}</span> &quot;</span>

    <span class="hljs-comment"># Extract the location of that snippet of code</span>
    context = <span class="hljs-string">f&quot;module <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;context&#x27;</span>][<span class="hljs-string">&#x27;module&#x27;</span>]}</span> &quot;</span> <span class="hljs-string">f&quot;file <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;context&#x27;</span>][<span class="hljs-string">&#x27;file_name&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">if</span> chunk[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;struct_name&quot;</span>]:
        struct_name = inflection.humanize(inflection.underscore(chunk[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;struct_name&quot;</span>]))
        context = <span class="hljs-string">f&quot;defined in struct <span class="hljs-subst">{struct_name}</span> <span class="hljs-subst">{context}</span>&quot;</span>

    <span class="hljs-comment"># Combine all the bits and pieces together</span>
    text_representation = <span class="hljs-string">f&quot;<span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;code_type&#x27;</span>]}</span> <span class="hljs-subst">{name}</span> &quot;</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{docstring}</span>&quot;</span> <span class="hljs-string">f&quot;defined as <span class="hljs-subst">{signature}</span> &quot;</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{context}</span>&quot;</span>

    <span class="hljs-comment"># Remove any special characters and concatenate the tokens</span>
    tokens = re.split(<span class="hljs-string">r&quot;\\W&quot;</span>, text_representation)
    tokens = <span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x, tokens)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot; &quot;</span>.join(tokens)`,wrap:!1}}),O=new d({props:{code:"dGV4dF9yZXByZXNlbnRhdGlvbnMlMjAlM0QlMjBsaXN0KG1hcCh0ZXh0aWZ5JTJDJTIwc3RydWN0dXJlcykp",highlighted:'text_representations = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">map</span>(textify, structures))',wrap:!1}}),ll=new d({props:{code:"dGV4dF9yZXByZXNlbnRhdGlvbnMlNUIxMDAwJTVE",highlighted:'text_representations[<span class="hljs-number">1000</span>]',wrap:!1}}),tl=new d({props:{code:"J0Z1bmN0aW9uJTIwSG5zdyUyMGRpc2NvdmVyJTIwcHJlY2lzaW9uJTIwdGhhdCUyMGRvZXMlMjBDaGVja3MlMjBkaXNjb3ZlcnklMjBzZWFyY2glMjBwcmVjaXNpb24lMjB3aGVuJTIwdXNpbmclMjBobnN3JTIwaW5kZXglMjB0aGlzJTIwaXMlMjBkaWZmZXJlbnQlMjBmcm9tJTIwdGhlJTIwdGVzdHMlMjBpbiUyMGRlZmluZWQlMjBhcyUyMEZuJTIwaG5zdyUyMGRpc2NvdmVyJTIwcHJlY2lzaW9uJTIwbW9kdWxlJTIwaW50ZWdyYXRpb24lMjBmaWxlJTIwaG5zd19kaXNjb3Zlcl90ZXN0JTIwcnMn",highlighted:'<span class="hljs-string">&#x27;Function Hnsw discover precision that does Checks discovery search precision when using hnsw index this is different from the tests in defined as Fn hnsw discover precision module integration file hnsw_discover_test rs&#x27;</span>',wrap:!1}}),sl=new I({props:{title:"自然语言嵌入",local:"自然语言嵌入",headingTag:"h3"}}),el=new d({props:{code:"ZnJvbSUyMGZhc3RlbWJlZCUyMGltcG9ydCUyMFRleHRFbWJlZGRpbmclMEElMEFiYXRjaF9zaXplJTIwJTNEJTIwNSUwQSUwQW5scF9tb2RlbCUyMCUzRCUyMFRleHRFbWJlZGRpbmcoJTIyc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGYWxsLU1pbmlMTS1MNi12MiUyMiUyQyUyMHRocmVhZHMlM0QwKSUwQW5scF9lbWJlZGRpbmdzJTIwJTNEJTIwbmxwX21vZGVsLmVtYmVkKHRleHRfcmVwcmVzZW50YXRpb25zJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUp",highlighted:`<span class="hljs-keyword">from</span> fastembed <span class="hljs-keyword">import</span> TextEmbedding

batch_size = <span class="hljs-number">5</span>

nlp_model = TextEmbedding(<span class="hljs-string">&quot;sentence-transformers/all-MiniLM-L6-v2&quot;</span>, threads=<span class="hljs-number">0</span>)
nlp_embeddings = nlp_model.embed(text_representations, batch_size=batch_size)`,wrap:!1}}),nl=new I({props:{title:"代码嵌入",local:"代码嵌入",headingTag:"h3"}}),al=new d({props:{code:"Y29kZV9zbmlwcGV0cyUyMCUzRCUyMCU1QnN0cnVjdHVyZSU1QiUyMmNvbnRleHQlMjIlNUQlNUIlMjJzbmlwcGV0JTIyJTVEJTIwZm9yJTIwc3RydWN0dXJlJTIwaW4lMjBzdHJ1Y3R1cmVzJTVEJTBBJTBBY29kZV9tb2RlbCUyMCUzRCUyMFRleHRFbWJlZGRpbmcoJTIyamluYWFpJTJGamluYS1lbWJlZGRpbmdzLXYyLWJhc2UtY29kZSUyMiklMEElMEFjb2RlX2VtYmVkZGluZ3MlMjAlM0QlMjBjb2RlX21vZGVsLmVtYmVkKGNvZGVfc25pcHBldHMlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSk=",highlighted:`code_snippets = [structure[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;snippet&quot;</span>] <span class="hljs-keyword">for</span> structure <span class="hljs-keyword">in</span> structures]

code_model = TextEmbedding(<span class="hljs-string">&quot;jinaai/jina-embeddings-v2-base-code&quot;</span>)

code_embeddings = code_model.embed(code_snippets, batch_size=batch_size)`,wrap:!1}}),Ml=new I({props:{title:"构建 Qdrant 集合",local:"构建-qdrant-集合",headingTag:"h3"}}),wl=new d({props:{code:"ZnJvbSUyMHFkcmFudF9jbGllbnQlMjBpbXBvcnQlMjBRZHJhbnRDbGllbnQlMkMlMjBtb2RlbHMlMEElMEFDT0xMRUNUSU9OX05BTUUlMjAlM0QlMjAlMjJxZHJhbnQtc291cmNlcyUyMiUwQSUwQWNsaWVudCUyMCUzRCUyMFFkcmFudENsaWVudCglMjIlM0FtZW1vcnklM0ElMjIpJTIwJTIwJTIzJTIwVXNlJTIwaW4tbWVtb3J5JTIwc3RvcmFnZSUwQSUyMyUyMGNsaWVudCUyMCUzRCUyMFFkcmFudENsaWVudCglMjJodHRwJTNBJTJGJTJGbG9jYWhvc3QlM0E2MzMzJTIyKSUyMCUyMCUyMyUyMEZvciUyMFFkcmFudCUyMHNlcnZlciUwQSUwQWNsaWVudC5jcmVhdGVfY29sbGVjdGlvbiglMEElMjAlMjAlMjAlMjBDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjB2ZWN0b3JzX2NvbmZpZyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjBtb2RlbHMuVmVjdG9yUGFyYW1zKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNpemUlM0QzODQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkaXN0YW5jZSUzRG1vZGVscy5EaXN0YW5jZS5DT1NJTkUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29kZSUyMiUzQSUyMG1vZGVscy5WZWN0b3JQYXJhbXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2l6ZSUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc3RhbmNlJTNEbW9kZWxzLkRpc3RhbmNlLkNPU0lORSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> qdrant_client <span class="hljs-keyword">import</span> QdrantClient, models

COLLECTION_NAME = <span class="hljs-string">&quot;qdrant-sources&quot;</span>

client = QdrantClient(<span class="hljs-string">&quot;:memory:&quot;</span>)  <span class="hljs-comment"># Use in-memory storage</span>
<span class="hljs-comment"># client = QdrantClient(&quot;http://locahost:6333&quot;)  # For Qdrant server</span>

client.create_collection(
    COLLECTION_NAME,
    vectors_config={
        <span class="hljs-string">&quot;text&quot;</span>: models.VectorParams(
            size=<span class="hljs-number">384</span>,
            distance=models.Distance.COSINE,
        ),
        <span class="hljs-string">&quot;code&quot;</span>: models.VectorParams(
            size=<span class="hljs-number">768</span>,
            distance=models.Distance.COSINE,
        ),
    },
)`,wrap:!1}}),jl=new d({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBcG9pbnRzJTIwJTNEJTIwJTVCJTVEJTBBdG90YWwlMjAlM0QlMjBsZW4oc3RydWN0dXJlcyklMEFwcmludCglMjJOdW1iZXIlMjBvZiUyMHBvaW50cyUyMHRvJTIwdXBsb2FkJTNBJTIwJTIyJTJDJTIwdG90YWwpJTBBJTBBZm9yJTIwaWQlMkMlMjAodGV4dF9lbWJlZGRpbmclMkMlMjBjb2RlX2VtYmVkZGluZyUyQyUyMHN0cnVjdHVyZSklMjBpbiUyMHRxZG0oJTBBJTIwJTIwJTIwJTIwZW51bWVyYXRlKHppcChubHBfZW1iZWRkaW5ncyUyQyUyMGNvZGVfZW1iZWRkaW5ncyUyQyUyMHN0cnVjdHVyZXMpKSUyQyUyMHRvdGFsJTNEdG90YWwlMEEpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRmFzdEVtYmVkJTIwcmV0dXJucyUyMGdlbmVyYXRvcnMuJTIwRW1iZWRkaW5ncyUyMGFyZSUyMGNvbXB1dGVkJTIwYXMlMjBjb25zdW1lZC4lMEElMjAlMjAlMjAlMjBwb2ludHMuYXBwZW5kKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVscy5Qb2ludFN0cnVjdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZCUzRGlkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmVjdG9yJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMHRleHRfZW1iZWRkaW5nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29kZSUyMiUzQSUyMGNvZGVfZW1iZWRkaW5nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF5bG9hZCUzRHN0cnVjdHVyZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXBsb2FkJTIwcG9pbnRzJTIwaW4lMjBiYXRjaGVzJTBBJTIwJTIwJTIwJTIwaWYlMjBsZW4ocG9pbnRzKSUyMCUzRSUzRCUyMGJhdGNoX3NpemUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjbGllbnQudXBsb2FkX3BvaW50cyhDT0xMRUNUSU9OX05BTUUlMkMlMjBwb2ludHMlM0Rwb2ludHMlMkMlMjB3YWl0JTNEVHJ1ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwb2ludHMlMjAlM0QlMjAlNUIlNUQlMEElMEElMjMlMjBFbnN1cmUlMjBhbnklMjByZW1haW5pbmclMjBwb2ludHMlMjBhcmUlMjB1cGxvYWRlZCUwQWlmJTIwcG9pbnRzJTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnVwbG9hZF9wb2ludHMoQ09MTEVDVElPTl9OQU1FJTJDJTIwcG9pbnRzJTNEcG9pbnRzKSUwQSUwQXByaW50KGYlMjJUb3RhbCUyMHBvaW50cyUyMGluJTIwY29sbGVjdGlvbiUzQSUyMCU3QmNsaWVudC5jb3VudChDT0xMRUNUSU9OX05BTUUpLmNvdW50JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

points = []
total = <span class="hljs-built_in">len</span>(structures)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Number of points to upload: &quot;</span>, total)

<span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span>, (text_embedding, code_embedding, structure) <span class="hljs-keyword">in</span> tqdm(
    <span class="hljs-built_in">enumerate</span>(<span class="hljs-built_in">zip</span>(nlp_embeddings, code_embeddings, structures)), total=total
):
    <span class="hljs-comment"># FastEmbed returns generators. Embeddings are computed as consumed.</span>
    points.append(
        models.PointStruct(
            <span class="hljs-built_in">id</span>=<span class="hljs-built_in">id</span>,
            vector={
                <span class="hljs-string">&quot;text&quot;</span>: text_embedding,
                <span class="hljs-string">&quot;code&quot;</span>: code_embedding,
            },
            payload=structure,
        )
    )

    <span class="hljs-comment"># Upload points in batches</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(points) &gt;= batch_size:
        client.upload_points(COLLECTION_NAME, points=points, wait=<span class="hljs-literal">True</span>)
        points = []

<span class="hljs-comment"># Ensure any remaining points are uploaded</span>
<span class="hljs-keyword">if</span> points:
    client.upload_points(COLLECTION_NAME, points=points)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Total points in collection: <span class="hljs-subst">{client.count(COLLECTION_NAME).count}</span>&quot;</span>)`,wrap:!1}}),dl=new I({props:{title:"查询代码库",local:"查询代码库",headingTag:"h3"}}),yl=new d({props:{code:"cXVlcnklMjAlM0QlMjAlMjJIb3clMjBkbyUyMEklMjBjb3VudCUyMHBvaW50cyUyMGluJTIwYSUyMGNvbGxlY3Rpb24lM0YlMjIlMEElMEFoaXRzJTIwJTNEJTIwY2xpZW50LnF1ZXJ5X3BvaW50cyglMEElMjAlMjAlMjAlMjBDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjBxdWVyeSUzRG5leHQobmxwX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjB1c2luZyUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBsaW1pdCUzRDMlMkMlMEEpLnBvaW50cw==",highlighted:`query = <span class="hljs-string">&quot;How do I count points in a collection?&quot;</span>

hits = client.query_points(
    COLLECTION_NAME,
    query=<span class="hljs-built_in">next</span>(nlp_model.query_embed(query)).tolist(),
    using=<span class="hljs-string">&quot;text&quot;</span>,
    limit=<span class="hljs-number">3</span>,
).points`,wrap:!1}}),Ul=new d({props:{code:"aGl0cyUyMCUzRCUyMGNsaWVudC5xdWVyeV9wb2ludHMoJTBBJTIwJTIwJTIwJTIwQ09MTEVDVElPTl9OQU1FJTJDJTBBJTIwJTIwJTIwJTIwcXVlcnklM0RuZXh0KGNvZGVfbW9kZWwucXVlcnlfZW1iZWQocXVlcnkpKS50b2xpc3QoKSUyQyUwQSUyMCUyMCUyMCUyMHVzaW5nJTNEJTIyY29kZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxpbWl0JTNEMyUyQyUwQSkucG9pbnRz",highlighted:`hits = client.query_points(
    COLLECTION_NAME,
    query=<span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
    using=<span class="hljs-string">&quot;code&quot;</span>,
    limit=<span class="hljs-number">3</span>,
).points`,wrap:!1}}),Cl=new d({props:{code:"ZnJvbSUyMHFkcmFudF9jbGllbnQlMjBpbXBvcnQlMjBtb2RlbHMlMEElMEFoaXRzJTIwJTNEJTIwY2xpZW50LnF1ZXJ5X3BvaW50cyglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uX25hbWUlM0RDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjBwcmVmZXRjaCUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVscy5QcmVmZXRjaCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeSUzRG5leHQobmxwX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2luZyUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaW1pdCUzRDUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxzLlByZWZldGNoKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNEbmV4dChjb2RlX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2luZyUzRCUyMmNvZGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaW1pdCUzRDUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcXVlcnklM0Rtb2RlbHMuRnVzaW9uUXVlcnkoZnVzaW9uJTNEbW9kZWxzLkZ1c2lvbi5SUkYpJTJDJTBBKS5wb2ludHM=",highlighted:`<span class="hljs-keyword">from</span> qdrant_client <span class="hljs-keyword">import</span> models

hits = client.query_points(
    collection_name=COLLECTION_NAME,
    prefetch=[
        models.Prefetch(
            query=<span class="hljs-built_in">next</span>(nlp_model.query_embed(query)).tolist(),
            using=<span class="hljs-string">&quot;text&quot;</span>,
            limit=<span class="hljs-number">5</span>,
        ),
        models.Prefetch(
            query=<span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
            using=<span class="hljs-string">&quot;code&quot;</span>,
            limit=<span class="hljs-number">5</span>,
        ),
    ],
    query=models.FusionQuery(fusion=models.Fusion.RRF),
).points`,wrap:!1}}),xl=new d({props:{code:"Zm9yJTIwaGl0JTIwaW4lMjBoaXRzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIybW9kdWxlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIyZmlsZV9wYXRoJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnNjb3JlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTYwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJzaWduYXR1cmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlNjAlMjAlN0MlMjIlMkMlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> hits:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;| &quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;module&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;file_path&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>        hit.score,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot; | \`&quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;signature&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\` |&quot;</span>,
<span class="hljs-meta">... </span>    )`,wrap:!1}}),gl=new I({props:{title:"对结果进行分组",local:"对结果进行分组",headingTag:"h3"}}),Gl=new d({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNsaWVudC5xdWVyeV9wb2ludHNfZ3JvdXBzKCUwQSUyMCUyMCUyMCUyMENPTExFQ1RJT05fTkFNRSUyQyUwQSUyMCUyMCUyMCUyMHF1ZXJ5JTNEbmV4dChjb2RlX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjB1c2luZyUzRCUyMmNvZGUlMjIlMkMlMEElMjAlMjAlMjAlMjBncm91cF9ieSUzRCUyMmNvbnRleHQubW9kdWxlJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGltaXQlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwZ3JvdXBfc2l6ZSUzRDElMkMlMEEp",highlighted:`results = client.query_points_groups(
    COLLECTION_NAME,
    query=<span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
    using=<span class="hljs-string">&quot;code&quot;</span>,
    group_by=<span class="hljs-string">&quot;context.module&quot;</span>,
    limit=<span class="hljs-number">5</span>,
    group_size=<span class="hljs-number">1</span>,
)`,wrap:!1}}),_l=new d({props:{code:"Zm9yJTIwZ3JvdXAlMjBpbiUyMHJlc3VsdHMuZ3JvdXBzJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaGl0JTIwaW4lMjBncm91cC5oaXRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIybW9kdWxlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIyZmlsZV9uYW1lJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnNjb3JlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTYwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJzaWduYXR1cmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlNjAlMjAlN0MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> group <span class="hljs-keyword">in</span> results.groups:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> group.hits:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;| &quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;module&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;file_name&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>            hit.score,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot; | \`&quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;signature&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;\` |&quot;</span>,
<span class="hljs-meta">... </span>        )`,wrap:!1}}),vl=new ee({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/code_search.md"}}),{c(){y=M("meta"),Rl=n(),Wl=M("p"),El=n(),p(u.$$.fragment),Vl=n(),p(m.$$.fragment),Ql=n(),U=M("p"),U.innerHTML=Ms,ql=n(),b=M("p"),b.textContent=Js,zl=n(),h=M("p"),h.innerHTML=is,Xl=n(),p(f.$$.fragment),Hl=n(),C=M("p"),C.textContent=ps,Sl=n(),x=M("ul"),x.innerHTML=Ts,Yl=n(),B=M("p"),B.textContent=ws,Fl=n(),p(Z.$$.fragment),Ll=n(),g=M("p"),g.textContent=os,Dl=n(),A=M("ul"),A.innerHTML=js,Pl=n(),p(G.$$.fragment),Ol=n(),p(_.$$.fragment),Kl=n(),N=M("p"),N.textContent=cs,lt=n(),r=M("div"),r.innerHTML=ds,tt=n(),k=M("p"),k.textContent=Is,st=n(),p(v.$$.fragment),et=n(),W=M("p"),W.innerHTML=ys,nt=n(),$=M("p"),$.innerHTML=rs,at=n(),R=M("p"),R.textContent=us,Mt=n(),E=M("p"),E.innerHTML=ms,Jt=n(),p(V.$$.fragment),it=n(),Q=M("p"),Q.textContent=Us,pt=n(),p(q.$$.fragment),Tt=n(),z=M("p"),z.textContent=bs,wt=n(),p(X.$$.fragment),ot=n(),p(H.$$.fragment),jt=n(),p(S.$$.fragment),ct=n(),Y=M("p"),Y.textContent=hs,dt=n(),F=M("ol"),F.innerHTML=fs,It=n(),L=M("p"),L.innerHTML=Cs,yt=n(),p(D.$$.fragment),rt=n(),P=M("p"),P.innerHTML=xs,ut=n(),p(O.$$.fragment),mt=n(),K=M("p"),K.textContent=Bs,Ut=n(),p(ll.$$.fragment),bt=n(),p(tl.$$.fragment),ht=n(),p(sl.$$.fragment),ft=n(),p(el.$$.fragment),Ct=n(),p(nl.$$.fragment),xt=n(),p(al.$$.fragment),Bt=n(),p(Ml.$$.fragment),Zt=n(),Jl=M("p"),Jl.innerHTML=Zs,gt=n(),il=M("p"),il.textContent=gs,At=n(),pl=M("blockquote"),pl.innerHTML=As,Gt=n(),Tl=M("p"),Tl.textContent=Gs,_t=n(),p(wl.$$.fragment),Nt=n(),ol=M("p"),ol.textContent=_s,kt=n(),p(jl.$$.fragment),vt=n(),cl=M("p"),cl.textContent=Ns,Wt=n(),p(dl.$$.fragment),$t=n(),Il=M("p"),Il.innerHTML=ks,Rt=n(),p(yl.$$.fragment),Et=n(),rl=M("p"),rl.textContent=vs,Vt=n(),ul=M("table"),ul.innerHTML=Ws,Qt=n(),ml=M("p"),ml.textContent=$s,qt=n(),p(Ul.$$.fragment),zt=n(),bl=M("p"),bl.textContent=Rs,Xt=n(),hl=M("table"),hl.innerHTML=Es,Ht=n(),fl=M("p"),fl.textContent=Vs,St=n(),p(Cl.$$.fragment),Yt=n(),p(xl.$$.fragment),Ft=n(),Bl=M("pre"),Bl.textContent=Qs,Lt=n(),Zl=M("p"),Zl.textContent=qs,Dt=n(),p(gl.$$.fragment),Pt=n(),Al=M("p"),Al.innerHTML=zs,Ot=n(),p(Gl.$$.fragment),Kt=n(),p(_l.$$.fragment),ls=n(),Nl=M("pre"),Nl.textContent=Xs,ts=n(),kl=M("p"),kl.innerHTML=Hs,ss=n(),p(vl.$$.fragment),es=n(),$l=M("p"),this.h()},l(l){const t=Ks("svelte-u9bgzb",document.head);y=J(t,"META",{name:!0,content:!0}),t.forEach(s),Rl=a(l),Wl=J(l,"P",{}),Ss(Wl).forEach(s),El=a(l),T(u.$$.fragment,l),Vl=a(l),T(m.$$.fragment,l),Ql=a(l),U=J(l,"P",{"data-svelte-h":!0}),i(U)!=="svelte-1td05ce"&&(U.innerHTML=Ms),ql=a(l),b=J(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-11bzeab"&&(b.textContent=Js),zl=a(l),h=J(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-9hlwem"&&(h.innerHTML=is),Xl=a(l),T(f.$$.fragment,l),Hl=a(l),C=J(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-4aaseo"&&(C.textContent=ps),Sl=a(l),x=J(l,"UL",{"data-svelte-h":!0}),i(x)!=="svelte-w92nd5"&&(x.innerHTML=Ts),Yl=a(l),B=J(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-103o1oh"&&(B.textContent=ws),Fl=a(l),T(Z.$$.fragment,l),Ll=a(l),g=J(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-17fzytb"&&(g.textContent=os),Dl=a(l),A=J(l,"UL",{"data-svelte-h":!0}),i(A)!=="svelte-1dkc4a6"&&(A.innerHTML=js),Pl=a(l),T(G.$$.fragment,l),Ol=a(l),T(_.$$.fragment,l),Kl=a(l),N=J(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-v0krcr"&&(N.textContent=cs),lt=a(l),r=J(l,"DIV",{style:!0,"data-svelte-h":!0}),i(r)!=="svelte-aiydin"&&(r.innerHTML=ds),tt=a(l),k=J(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-crg5tc"&&(k.textContent=Is),st=a(l),T(v.$$.fragment,l),et=a(l),W=J(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1pcwtli"&&(W.innerHTML=ys),nt=a(l),$=J(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-cs2gtg"&&($.innerHTML=rs),at=a(l),R=J(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1yypzz2"&&(R.textContent=us),Mt=a(l),E=J(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-5lk824"&&(E.innerHTML=ms),Jt=a(l),T(V.$$.fragment,l),it=a(l),Q=J(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1flz27j"&&(Q.textContent=Us),pt=a(l),T(q.$$.fragment,l),Tt=a(l),z=J(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-9rzh3y"&&(z.textContent=bs),wt=a(l),T(X.$$.fragment,l),ot=a(l),T(H.$$.fragment,l),jt=a(l),T(S.$$.fragment,l),ct=a(l),Y=J(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-aunxvs"&&(Y.textContent=hs),dt=a(l),F=J(l,"OL",{"data-svelte-h":!0}),i(F)!=="svelte-1ynrnw"&&(F.innerHTML=fs),It=a(l),L=J(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-11hiyrz"&&(L.innerHTML=Cs),yt=a(l),T(D.$$.fragment,l),rt=a(l),P=J(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-nm7vo"&&(P.innerHTML=xs),ut=a(l),T(O.$$.fragment,l),mt=a(l),K=J(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-ta8wws"&&(K.textContent=Bs),Ut=a(l),T(ll.$$.fragment,l),bt=a(l),T(tl.$$.fragment,l),ht=a(l),T(sl.$$.fragment,l),ft=a(l),T(el.$$.fragment,l),Ct=a(l),T(nl.$$.fragment,l),xt=a(l),T(al.$$.fragment,l),Bt=a(l),T(Ml.$$.fragment,l),Zt=a(l),Jl=J(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-p9ow4m"&&(Jl.innerHTML=Zs),gt=a(l),il=J(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-1v43g86"&&(il.textContent=gs),At=a(l),pl=J(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(pl)!=="svelte-1w1gegb"&&(pl.innerHTML=As),Gt=a(l),Tl=J(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-1hsowkl"&&(Tl.textContent=Gs),_t=a(l),T(wl.$$.fragment,l),Nt=a(l),ol=J(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1q0g869"&&(ol.textContent=_s),kt=a(l),T(jl.$$.fragment,l),vt=a(l),cl=J(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-duqnpd"&&(cl.textContent=Ns),Wt=a(l),T(dl.$$.fragment,l),$t=a(l),Il=J(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-viy5cg"&&(Il.innerHTML=ks),Rt=a(l),T(yl.$$.fragment,l),Et=a(l),rl=J(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-pogy0l"&&(rl.textContent=vs),Vt=a(l),ul=J(l,"TABLE",{"data-svelte-h":!0}),i(ul)!=="svelte-frpz50"&&(ul.innerHTML=Ws),Qt=a(l),ml=J(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-1kf4p6u"&&(ml.textContent=$s),qt=a(l),T(Ul.$$.fragment,l),zt=a(l),bl=J(l,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-1opc3j0"&&(bl.textContent=Rs),Xt=a(l),hl=J(l,"TABLE",{"data-svelte-h":!0}),i(hl)!=="svelte-k6s3hv"&&(hl.innerHTML=Es),Ht=a(l),fl=J(l,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-1wm345r"&&(fl.textContent=Vs),St=a(l),T(Cl.$$.fragment,l),Yt=a(l),T(xl.$$.fragment,l),Ft=a(l),Bl=J(l,"PRE",{"data-svelte-h":!0}),i(Bl)!=="svelte-k4pkfe"&&(Bl.textContent=Qs),Lt=a(l),Zl=J(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-1w5r01r"&&(Zl.textContent=qs),Dt=a(l),T(gl.$$.fragment,l),Pt=a(l),Al=J(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-1v7dk5h"&&(Al.innerHTML=zs),Ot=a(l),T(Gl.$$.fragment,l),Kt=a(l),T(_l.$$.fragment,l),ls=a(l),Nl=J(l,"PRE",{"data-svelte-h":!0}),i(Nl)!=="svelte-jxqdo"&&(Nl.textContent=Xs),ts=a(l),kl=J(l,"P",{"data-svelte-h":!0}),i(kl)!=="svelte-1yl520k"&&(kl.innerHTML=Hs),ss=a(l),T(vl.$$.fragment,l),es=a(l),$l=J(l,"P",{}),Ss($l).forEach(s),this.h()},h(){Ys(y,"name","hf:doc:metadata"),Ys(y,"content",ae),le(r,"text-align","center")},m(l,t){te(document.head,y),e(l,Rl,t),e(l,Wl,t),e(l,El,t),w(u,l,t),e(l,Vl,t),w(m,l,t),e(l,Ql,t),e(l,U,t),e(l,ql,t),e(l,b,t),e(l,zl,t),e(l,h,t),e(l,Xl,t),w(f,l,t),e(l,Hl,t),e(l,C,t),e(l,Sl,t),e(l,x,t),e(l,Yl,t),e(l,B,t),e(l,Fl,t),w(Z,l,t),e(l,Ll,t),e(l,g,t),e(l,Dl,t),e(l,A,t),e(l,Pl,t),w(G,l,t),e(l,Ol,t),w(_,l,t),e(l,Kl,t),e(l,N,t),e(l,lt,t),e(l,r,t),e(l,tt,t),e(l,k,t),e(l,st,t),w(v,l,t),e(l,et,t),e(l,W,t),e(l,nt,t),e(l,$,t),e(l,at,t),e(l,R,t),e(l,Mt,t),e(l,E,t),e(l,Jt,t),w(V,l,t),e(l,it,t),e(l,Q,t),e(l,pt,t),w(q,l,t),e(l,Tt,t),e(l,z,t),e(l,wt,t),w(X,l,t),e(l,ot,t),w(H,l,t),e(l,jt,t),w(S,l,t),e(l,ct,t),e(l,Y,t),e(l,dt,t),e(l,F,t),e(l,It,t),e(l,L,t),e(l,yt,t),w(D,l,t),e(l,rt,t),e(l,P,t),e(l,ut,t),w(O,l,t),e(l,mt,t),e(l,K,t),e(l,Ut,t),w(ll,l,t),e(l,bt,t),w(tl,l,t),e(l,ht,t),w(sl,l,t),e(l,ft,t),w(el,l,t),e(l,Ct,t),w(nl,l,t),e(l,xt,t),w(al,l,t),e(l,Bt,t),w(Ml,l,t),e(l,Zt,t),e(l,Jl,t),e(l,gt,t),e(l,il,t),e(l,At,t),e(l,pl,t),e(l,Gt,t),e(l,Tl,t),e(l,_t,t),w(wl,l,t),e(l,Nt,t),e(l,ol,t),e(l,kt,t),w(jl,l,t),e(l,vt,t),e(l,cl,t),e(l,Wt,t),w(dl,l,t),e(l,$t,t),e(l,Il,t),e(l,Rt,t),w(yl,l,t),e(l,Et,t),e(l,rl,t),e(l,Vt,t),e(l,ul,t),e(l,Qt,t),e(l,ml,t),e(l,qt,t),w(Ul,l,t),e(l,zt,t),e(l,bl,t),e(l,Xt,t),e(l,hl,t),e(l,Ht,t),e(l,fl,t),e(l,St,t),w(Cl,l,t),e(l,Yt,t),w(xl,l,t),e(l,Ft,t),e(l,Bl,t),e(l,Lt,t),e(l,Zl,t),e(l,Dt,t),w(gl,l,t),e(l,Pt,t),e(l,Al,t),e(l,Ot,t),w(Gl,l,t),e(l,Kt,t),w(_l,l,t),e(l,ls,t),e(l,Nl,t),e(l,ts,t),e(l,kl,t),e(l,ss,t),w(vl,l,t),e(l,es,t),e(l,$l,t),ns=!0},p:Ls,i(l){ns||(o(u.$$.fragment,l),o(m.$$.fragment,l),o(f.$$.fragment,l),o(Z.$$.fragment,l),o(G.$$.fragment,l),o(_.$$.fragment,l),o(v.$$.fragment,l),o(V.$$.fragment,l),o(q.$$.fragment,l),o(X.$$.fragment,l),o(H.$$.fragment,l),o(S.$$.fragment,l),o(D.$$.fragment,l),o(O.$$.fragment,l),o(ll.$$.fragment,l),o(tl.$$.fragment,l),o(sl.$$.fragment,l),o(el.$$.fragment,l),o(nl.$$.fragment,l),o(al.$$.fragment,l),o(Ml.$$.fragment,l),o(wl.$$.fragment,l),o(jl.$$.fragment,l),o(dl.$$.fragment,l),o(yl.$$.fragment,l),o(Ul.$$.fragment,l),o(Cl.$$.fragment,l),o(xl.$$.fragment,l),o(gl.$$.fragment,l),o(Gl.$$.fragment,l),o(_l.$$.fragment,l),o(vl.$$.fragment,l),ns=!0)},o(l){j(u.$$.fragment,l),j(m.$$.fragment,l),j(f.$$.fragment,l),j(Z.$$.fragment,l),j(G.$$.fragment,l),j(_.$$.fragment,l),j(v.$$.fragment,l),j(V.$$.fragment,l),j(q.$$.fragment,l),j(X.$$.fragment,l),j(H.$$.fragment,l),j(S.$$.fragment,l),j(D.$$.fragment,l),j(O.$$.fragment,l),j(ll.$$.fragment,l),j(tl.$$.fragment,l),j(sl.$$.fragment,l),j(el.$$.fragment,l),j(nl.$$.fragment,l),j(al.$$.fragment,l),j(Ml.$$.fragment,l),j(wl.$$.fragment,l),j(jl.$$.fragment,l),j(dl.$$.fragment,l),j(yl.$$.fragment,l),j(Ul.$$.fragment,l),j(Cl.$$.fragment,l),j(xl.$$.fragment,l),j(gl.$$.fragment,l),j(Gl.$$.fragment,l),j(_l.$$.fragment,l),j(vl.$$.fragment,l),ns=!1},d(l){l&&(s(Rl),s(Wl),s(El),s(Vl),s(Ql),s(U),s(ql),s(b),s(zl),s(h),s(Xl),s(Hl),s(C),s(Sl),s(x),s(Yl),s(B),s(Fl),s(Ll),s(g),s(Dl),s(A),s(Pl),s(Ol),s(Kl),s(N),s(lt),s(r),s(tt),s(k),s(st),s(et),s(W),s(nt),s($),s(at),s(R),s(Mt),s(E),s(Jt),s(it),s(Q),s(pt),s(Tt),s(z),s(wt),s(ot),s(jt),s(ct),s(Y),s(dt),s(F),s(It),s(L),s(yt),s(rt),s(P),s(ut),s(mt),s(K),s(Ut),s(bt),s(ht),s(ft),s(Ct),s(xt),s(Bt),s(Zt),s(Jl),s(gt),s(il),s(At),s(pl),s(Gt),s(Tl),s(_t),s(Nt),s(ol),s(kt),s(vt),s(cl),s(Wt),s($t),s(Il),s(Rt),s(Et),s(rl),s(Vt),s(ul),s(Qt),s(ml),s(qt),s(zt),s(bl),s(Xt),s(hl),s(Ht),s(fl),s(St),s(Yt),s(Ft),s(Bl),s(Lt),s(Zl),s(Dt),s(Pt),s(Al),s(Ot),s(Kt),s(ls),s(Nl),s(ts),s(kl),s(ss),s(es),s($l)),s(y),c(u,l),c(m,l),c(f,l),c(Z,l),c(G,l),c(_,l),c(v,l),c(V,l),c(q,l),c(X,l),c(H,l),c(S,l),c(D,l),c(O,l),c(ll,l),c(tl,l),c(sl,l),c(el,l),c(nl,l),c(al,l),c(Ml,l),c(wl,l),c(jl,l),c(dl,l),c(yl,l),c(Ul,l),c(Cl,l),c(xl,l),c(gl,l),c(Gl,l),c(_l,l),c(vl,l)}}}const ae='{"title":"使用向量嵌入和 Qdrant 进行代码搜索","local":"使用向量嵌入和-qdrant-进行代码搜索","sections":[{"title":"方法","local":"方法","sections":[],"depth":3}],"depth":2}';function Me(as){return Ds(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class we extends Ps{constructor(y){super(),Os(this,y,Me,ne,Fs,{})}}export{we as component};
