import{s as Xn,f as Fn,n as qn,o as Ln}from"../chunks/scheduler.65852ee5.js";import{S as Pn,i as Dn,g as i,s as n,r as o,A as Kn,h as p,f as l,c as a,j as Hn,u as r,x as M,k as $s,y as On,a as s,v as m,d as c,t as y,w}from"../chunks/index.aa74147d.js";import{D as ea,C as h}from"../chunks/DocNotebookDropdown.1a7e6a42.js";import{H as u,E as ta}from"../chunks/getInferenceSnippets.796600e5.js";function la(vs){let j,dt,Tt,Ct,J,bt,U,It,T,Gs='<em>作者:<a href="https://github.com/peremartra" rel="nofollow">Pere Martra</a></em>',gt,f,xs="在这个 notebook 中，我们将使用一个现成的模型和 Chroma 数据库来搭建一个常见的 RAG 系统。<strong>但我们会加入一个新功能，就是一个语义缓存系统，它会保存用户的各种问题，并决定是直接用数据库的信息来回答问题，还是用之前保存的问题答案。</strong>",$t,d,As="这个语义缓存系统的目的是找出用户提出的问题中哪些是相似的或者是一样的。如果找到了一个之前问过的问题，系统就会直接用缓存里的答案来回答，这样就不用再去数据库里找了。",vt,C,Bs="因为这个系统会考虑问题的实际意思，所以即使问题表达的方式不同，或者有些小错误，比如拼写或句子结构不对，系统也能识别出用户其实是在问同一个问题。",Gt,b,Zs="比如，像 <strong>法国的首都是什么？</strong>、<strong>告诉我法国的首都叫什么？</strong> 和 <strong>法国的首都是什么？</strong> 这样的问题，虽然问法不一样，但都是在问同一个事情。",xt,I,ks="虽然根据问题的不同，模型的回答可能会有点不一样，但基本上从数据库里拿到的信息应该是相同的。这就是为什么我们把缓存系统放在用户和数据库之间，而不是用户和语言模型之间。",At,Ut,_s,Bt,g,Ns="大多数教程指导你创建一个 RAG 系统，这些教程都是为单个用户设计的，用于在测试环境中运行。换句话说，就是在笔记本中与本地向量数据库交互，以及进行 API 调用或使用本地存储的模型。",Zt,$,Ws="当尝试将其中一种模型过渡到生产环境时，这种架构很快就显得不够用了，在生产环境中，它们可能会遇到从几十到成千上万次的重复请求。",kt,v,Rs="提高性能的一种方法是通过一个或多个语义缓存。这个缓存保留了以前请求的结果，并且在解决新请求之前，它会检查是否之前收到过类似的请求。如果是这样，它就不会重新执行过程，而是从缓存中检索信息。",_t,G,Ss="在 RAG 系统中，有两个耗时的点：",Nt,x,Vs="<li>检索用于构建丰富提示的信息：</li> <li>调用大型语言模型以获得响应。</li>",Wt,A,zs="在这两点上，都可以实现语义缓存系统，我们甚至可以有两个缓存，每个点一个。",Rt,B,Es="将缓存系统放在模型的响应点可能会导致对获得响应的影响减少。我们的缓存系统可能会将”用 10 个词解释法国大革命”和”用 100 个词解释法国大革命”视为相同的查询。如果我们的缓存系统存储模型响应，用户可能会认为他们的指令没有被准确地遵循。",St,Z,Qs="但是，两个请求都需要相同的信息来丰富提示。这就是我选择将语义缓存系统放置在用户请求和从向量数据库检索信息之间的主要原因。",Vt,k,Ys="然而，这是一个设计决策。根据响应类型和系统请求的不同，它可以被放置在一个点或另一个点。很明显，缓存模型响应会节省最多的时间，但正如我已经解释过的，这样做会牺牲用户对响应的影响。",zt,_,Et,N,Hs="首先，我们需要安装必要的 Python 包。",Qt,W,Xs='<li><strong><a href="http:/www.sbert.net/" rel="nofollow">sentence transformers</a></strong>。这个库用于将句子转换为固定长度的向量，也称为嵌入。</li> <li><strong><a href="https://github.com/facebookresearch/xformers" rel="nofollow">xformers</a></strong>。这是一个提供库和工具的包，以便与 transformers 模型一起使用。我们需要安装它，以避免在处理模型和嵌入时出现错误。</li> <li><strong><a href="https://www.trychroma.com/" rel="nofollow">chromadb</a></strong>。这是我们的向量数据库。ChromaDB 易于使用且开源，可能是用于存储嵌入的最常用的向量数据库。</li> <li><strong><a href="https://github.com/huggingface/accelerate" rel="nofollow">accelerate</a></strong>。在 GPU 上运行模型的必要条件。</li>',Yt,R,Ht,S,Xt,V,Ft,z,Fs="由于我们在一个免费且有限的空间中工作，并且只能使用几 GB 的内存，我通过变量 <code>MAX_ROWS</code> 限制了从数据集中使用的行数。",qt,E,Lt,Q,Pt,Y,qs="ChromaDB 要求数据具有唯一的标识符。我们可以使用这个语句来创建一个名为<strong>Id</strong>的新列。",Dt,H,Kt,X,Ot,F,el,q,tl,L,Ls="为了存储信息，我选择使用 ChromaDB，这是最知名且广泛使用的开源向量数据库之一。",ll,P,Ps="首先我们需要导入 ChromaDB。",sl,D,nl,K,Ds="现在我们只需要指定存储向量数据库的路径。",al,O,il,ee,pl,te,Ks=`ChromaDB 中的数据存储在集合中。如果集合已存在，我们需要删除它。
在接下来的行中，我们通过调用上面创建的 <code>chroma_client</code> 中的 <code>create_collection</code> 函数来创建集合。`,Ml,le,ol,se,Os="现在我们准备好使用 <code>add</code> 函数将数据添加到集合中。这个函数需要三个关键信息：",rl,ne,en="<li>在 <strong>文档</strong> 中，我们存储数据集中 <code>Answer</code> 列的内容。</li> <li>在 <strong>元数据</strong> 中，我们可以提供一个主题列表。我使用了 <code>qtype</code> 列中的值。</li> <li>在 <strong>id</strong> 中，我们需要为每一行提供一个唯一的标识符。我使用 <code>MAX_ROWS</code> 的范围来创建ID。</li>",ml,ae,cl,ie,tn="一旦我们在数据库中有了信息，我们就可以查询它，并请求符合我们需求的数据。搜索是在文档内容内部进行的，它不会查找确切的单词或短语。结果将基于搜索词与文档内容之间的相似性。",yl,pe,ln="元数据在初始搜索过程中并不直接参与，它可以在检索后用于过滤或细化结果，从而实现进一步的定制和精确性。",wl,Me,sn="让我们定义一个函数来查询 ChromaDB 数据库。",hl,oe,ul,re,jl,me,nn="为了实现缓存系统，我们将使用 Faiss 库，该库允许在内存中存储嵌入。这和 Chroma 做的事情很相似，但没有其持久性。",Jl,ce,an="为此，我们将创建一个名为 <code>semantic_cache</code> 的类，它将使用自己的编码器，并为用户提供执行查询所需的函数。",Ul,ye,pn=`在这个类中，我们首先查询使用 Faiss 实现的缓存，其中包含以前的请求，如果返回的结果超过了一个指定的阈值，它将返回缓存的内容。否则，它将从 Chroma 数据库获取结果。
缓存存储在一个 .json 文件中。`,Tl,we,fl,he,dl,ue,Mn="下面的 <code>init_cache()</code> 函数初始化了语义缓存。",Cl,je,on="它使用了 FlatLS 索引，这可能不是最快的，但对于小数据集来说是理想的。如果我们需要根据数据的具体内容和大小来选择缓存（临时存储）数据的方式，我们还可以考虑使用其他的索引方法，比如 HNSW 或 IVF。",bl,Je,rn="我选择这个索引是因为它与示例非常契合。它可以用于高维向量，消耗的内存最少，并且在小数据集上表现良好。",Il,Ue,mn="下面概述了 Faiss 可用的各种索引的关键特性。",gl,Te,cn="<li>FlatL2 或 FlatIP。非常适合小数据集，可能不是最快的，但其内存消耗并不过分。</li> <li>LSH。它在小数据集上工作效果很好，并且推荐用于最多 128 维的向量。</li> <li>HNSW。非常快，但需要大量的 RAM。</li> <li>IVF。在大数据集上工作良好，而且不会消耗太多内存或影响性能。</li>",$l,fe,yn='关于 Faiss 可用的不同索引的更多信息可以在以下链接中找到：<a href="https://github.com/facebookresearch/faiss/wiki/Guidelines-to-choose-an-index" rel="nofollow">https://github.com/facebookresearch/faiss/wiki/Guidelines-to-choose-an-index</a>',vl,de,Gl,Ce,wn="在 <code>retrieve_cache</code> 函数中，.json 文件从磁盘中被检索出来，以便在需要跨会话重用缓存时使用。",xl,be,Al,Ie,hn="<code>store_cache</code> 函数将包含缓存数据的文件保存到磁盘上。",Bl,ge,Zl,$e,un="这些函数将在 <code>SemanticCache</code> 类中使用，该类包括搜索函数及其初始化函数。",kl,ve,jn="尽管 <code>ask</code> 函数的代码量相当大，但它的目的非常直接。它在缓存中查找与用户刚刚提出的问题最接近的问题。",_l,Ge,Jn="然后，检查它是否在指定的阈值内。如果是肯定的，它直接从缓存中返回响应；否则，它调用 <code>query_database</code> 函数从 ChromaDB 检索数据。",Nl,xe,Un="我使用了欧几里得距离而不是广泛应用于向量比较的余弦距离。这个选择是基于欧几里得距离是 Faiss 默认使用的度量标准。尽管也可以计算余弦距离，但这样做会增加复杂性，可能不会显著有助于最终结果。",Wl,Ae,Rl,Be,Sl,Ze,Vl,ke,Tn=`Index trained
`,zl,_e,El,Ne,fn=`Answer recovered from ChromaDB. 
response_text: Summary : Shots may hurt a little, but the diseases they can prevent are a lot worse. Some are even life-threatening. Immunization shots, or vaccinations, are essential. They protect against things like measles, mumps, rubella, hepatitis B, polio, tetanus, diphtheria, and pertussis (whooping cough). Immunizations are important for adults as well as children.    Your immune system helps your body fight germs by producing substances to combat them. Once it does, the immune system "remembers" the germ and can fight it again. Vaccines contain germs that have been killed or weakened. When given to a healthy person, the vaccine triggers the immune system to respond and thus build immunity.     Before vaccines, people became immune only by actually getting a disease and surviving it. Immunizations are an easier and less risky way to become immune.     NIH: National Institute of Allergy and Infectious Diseases
Time taken: 0.057 seconds
`,Ql,We,dn="正如预期的那样，这个响应是从 ChromaDB 获取的。然后，该类将其存储在缓存中。",Yl,Re,Cn="现在，如果我们发送一个完全不同的问题，响应也应该从 ChromaDB 中检索。这是因为先前存储的问题与当前问题如此不同，以至于它在欧几里得距离方面会超过指定的阈值。",Hl,Se,Xl,Ve,bn=`Answer recovered from ChromaDB. 
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.082 seconds
`,Fl,ze,In="完美，语义缓存系统正如预期那样运行。",ql,Ee,gn="让我们继续用一个非常类似于我们刚才问的问题来测试它。",Ll,Qe,$n="在这种情况下，响应应该直接来自缓存，而不需要访问 ChromaDB 数据库。",Pl,Ye,Dl,He,vn=`Answer recovered from Cache. 
0.028 smaller than 0.35
Found cache in row: 1 with score 0.028
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.019 seconds
`,Kl,Xe,Gn="这两个问题非常相似，它们的欧几里得距离非常小，几乎就像它们是相同的。",Ol,Fe,xn="现在，让我们尝试另一个问题，这次稍微有些不同，观察系统的表现。",es,qe,ts,Le,An=`Answer recovered from Cache. 
0.228 smaller than 0.35
Found cache in row: 1 with score 0.228
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.016 seconds
`,ls,Pe,Bn="我们观察到欧几里得距离已经增加，但它仍然在指定的阈值范围内。因此，它继续直接从缓存中返回响应。",ss,De,ns,Ke,Zn='是时候使用 <strong>transformers</strong> 库了，这是<a href="https://huggingface.co/" rel="nofollow">hugging face </a>最著名的库，用于处理语言模型。',as,Oe,kn="我们将导入：",is,et,_n=`<li><strong>Autotokenizer</strong>：这是一个实用程序类，用于标记化与各种预训练语言模型兼容的文本输入。</li> <li><strong>AutoModelForCausalLM</strong>：它提供了一个接口，用于预训练的语言模型，特别适用于使用因果语言建模（例如，GPT 模型）的语言生成任务，或者是这个 Notebook 中使用的模型 <a href="https://huggingface.co/google/gemma-2b-it" rel="nofollow">Gemma-2b-it</a>。
请随意测试 <a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;sort=trending" rel="nofollow">不同的模型</a>，你需要搜索训练用于文本生成的 NLP 模型。</li>`,ps,tt,Ms,lt,os,st,rs,nt,ms,at,Nn="为了创建提示，我们使用从查询 ‘semantic_cache’ 类得到的结果以及用户提出的问题。",cs,it,Wn="提示有两部分，<strong>相关上下文</strong>是从数据库中恢复的信息，以及<strong>用户的问题</strong>。",ys,pt,Rn="我们只需要将这两部分放在一起来创建提示，然后将其发送给模型。",ws,Mt,hs,ot,us,rt,Sn="现在剩下的就是将提示发送给模型，等待它的响应！",js,mt,Js,ct,Vn=`<bos>Relevant context: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.

 The user&#39;s question: Write in 20 words what is a Sydenham chorea.

Sure, here is a 20-word answer:

Sydenham chorea is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS).<eos>
</eos></bos>`,Us,yt,Ts,wt,zn="在访问 ChromaDB 和直接访问缓存之间，数据检索时间减少了 50%。然而，在更大的项目中，这种差异会增加，导致性能提升达到 90-95%。",fs,ht,En="我们在 Chroma 中的数据非常少，只有一个缓存类的实例。通常，缓存系统背后的数据要大得多，可能不仅仅是对向量数据库的查询，而是来自各种来源。",ds,ut,Qn="通常会有多个缓存类的实例，通常基于用户类型，因为共享共同特征的用户之间的问题往往更容易重复。",Cs,jt,Yn="总之，我们创建了一个非常简单的 RAG 系统，并通过在用户的问题和获取创建丰富提示所需信息之间增加一个语义缓存层来增强它。",bs,Jt,Is,ft,gs;return J=new ea({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/semantic_cache_chroma_vector_database.ipynb"}]}}),U=new u({props:{title:"通过引入语义缓存到 FAISS 中以增强 RAG 系统的性能",local:"通过引入语义缓存到-faiss-中以增强-rag-系统的性能",headingTag:"h1"}}),_=new u({props:{title:"导入并加载库。",local:"导入并加载库",headingTag:"h1"}}),R=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRyYW5zZm9ybWVycyUzRCUzRDQuMzguMSUwQSFwaXAlMjBpbnN0YWxsJTIwLXElMjBhY2NlbGVyYXRlJTNEJTNEMC4yNy4yJTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUzRCUzRDIuNS4xJTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMHhmb3JtZXJzJTNEJTNEMC4wLjI0JTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMGNocm9tYWRiJTNEJTNEMC40LjI0JTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMGRhdGFzZXRzJTNEJTNEMi4xNy4x",highlighted:`!pip install -q transformers==<span class="hljs-number">4.38</span><span class="hljs-number">.1</span>
!pip install -q accelerate==<span class="hljs-number">0.27</span><span class="hljs-number">.2</span>
!pip install -q sentence-transformers==<span class="hljs-number">2.5</span><span class="hljs-number">.1</span>
!pip install -q xformers==<span class="hljs-number">0.0</span><span class="hljs-number">.24</span>
!pip install -q chromadb==<span class="hljs-number">0.4</span><span class="hljs-number">.24</span>
!pip install -q datasets==<span class="hljs-number">2.17</span><span class="hljs-number">.1</span>`,wrap:!1}}),S=new h({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZA==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd`,wrap:!1}}),V=new u({props:{title:"加载数据集",local:"加载数据集",headingTag:"h1"}}),E=new h({props:{code:"JTIzTG9naW4lMjB0byUyMEh1Z2dpbmclMjBGYWNlLiUyMEl0JTIwaXMlMjBtYW5kYXRvcnklMjB0byUyMHVzZSUyMHRoZSUyMEdlbW1hJTIwTW9kZWwlMkMlMEElMjNhbmQlMjByZWNvbW1lbmRlZCUyMHRvJTIwYWNjZXMlMjBwdWJsaWMlMjBtb2RlbHMlMjBhbmQlMjBEYXRhc2V0cy4lMEFmcm9tJTIwZ2V0cGFzcyUyMGltcG9ydCUyMGdldHBhc3MlMEFpZiUyMCdoZl9rZXknJTIwbm90JTIwaW4lMjBsb2NhbHMoKSUzQSUwQSUyMCUyMGhmX2tleSUyMCUzRCUyMGdldHBhc3MoJTIyWW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwQVBJJTIwS2V5JTNBJTIwJTIyKSUwQSFodWdnaW5nZmFjZS1jbGklMjBsb2dpbiUyMC0tdG9rZW4lMjAlMjRoZl9rZXk=",highlighted:`<span class="hljs-comment">#Login to Hugging Face. It is mandatory to use the Gemma Model,</span>
<span class="hljs-comment">#and recommended to acces public models and Datasets.</span>
<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
<span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;hf_key&#x27;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">locals</span>():
  hf_key = getpass(<span class="hljs-string">&quot;Your Hugging Face API Key: &quot;</span>)
!huggingface-cli login --token $hf_key`,wrap:!1}}),Q=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJrZWl2YWx5YSUyRk1lZFF1YWQtTWVkaWNhbFFuQURhdGFzZXQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

data = load_dataset(<span class="hljs-string">&quot;keivalya/MedQuad-MedicalQnADataset&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),H=new h({props:{code:"ZGF0YSUyMCUzRCUyMGRhdGEudG9fcGFuZGFzKCklMEFkYXRhJTVCJTIyaWQlMjIlNUQlMjAlM0QlMjBkYXRhLmluZGV4JTBBZGF0YS5oZWFkKDEwKQ==",highlighted:`data = data.to_pandas()
data[<span class="hljs-string">&quot;id&quot;</span>] = data.index
data.head(<span class="hljs-number">10</span>)`,wrap:!1}}),X=new h({props:{code:"TUFYX1JPV1MlMjAlM0QlMjAxNTAwMCUwQURPQ1VNRU5UJTIwJTNEJTIwJTIyQW5zd2VyJTIyJTBBVE9QSUMlMjAlM0QlMjAlMjJxdHlwZSUyMg==",highlighted:`MAX_ROWS = <span class="hljs-number">15000</span>
DOCUMENT = <span class="hljs-string">&quot;Answer&quot;</span>
TOPIC = <span class="hljs-string">&quot;qtype&quot;</span>`,wrap:!1}}),F=new h({props:{code:"JTIzJTIwQmVjYXVzZSUyMGl0JTIwaXMlMjBqdXN0JTIwYSUyMHNhbXBsZSUyMHdlJTIwc2VsZWN0JTIwYSUyMHNtYWxsJTIwcG9ydGlvbiUyMG9mJTIwTmV3cy4lMEFzdWJzZXRfZGF0YSUyMCUzRCUyMGRhdGEuaGVhZChNQVhfUk9XUyk=",highlighted:`<span class="hljs-comment"># Because it is just a sample we select a small portion of News.</span>
subset_data = data.head(MAX_ROWS)`,wrap:!1}}),q=new u({props:{title:"导入并配置向量数据库",local:"导入并配置向量数据库",headingTag:"h1"}}),D=new h({props:{code:"aW1wb3J0JTIwY2hyb21hZGI=",highlighted:'<span class="hljs-keyword">import</span> chromadb',wrap:!1}}),O=new h({props:{code:"Y2hyb21hX2NsaWVudCUyMCUzRCUyMGNocm9tYWRiLlBlcnNpc3RlbnRDbGllbnQocGF0aCUzRCUyMiUyRnBhdGglMkZ0byUyRnBlcnNpc3QlMkZkaXJlY3RvcnklMjIp",highlighted:'chroma_client = chromadb.PersistentClient(path=<span class="hljs-string">&quot;/path/to/persist/directory&quot;</span>)',wrap:!1}}),ee=new u({props:{title:"填充和查询 ChromaDB 数据库",local:"填充和查询-chromadb-数据库",headingTag:"h1"}}),le=new h({props:{code:"Y29sbGVjdGlvbl9uYW1lJTIwJTNEJTIwJTIybmV3c19jb2xsZWN0aW9uJTIyJTBBaWYlMjBsZW4oY2hyb21hX2NsaWVudC5saXN0X2NvbGxlY3Rpb25zKCkpJTIwJTNFJTIwMCUyMGFuZCUyMGNvbGxlY3Rpb25fbmFtZSUyMGluJTIwJTVCY2hyb21hX2NsaWVudC5saXN0X2NvbGxlY3Rpb25zKCklNUIwJTVELm5hbWUlNUQlM0ElMEElMjAlMjAlMjAlMjBjaHJvbWFfY2xpZW50LmRlbGV0ZV9jb2xsZWN0aW9uKG5hbWUlM0Rjb2xsZWN0aW9uX25hbWUpJTBBJTBBY29sbGVjdGlvbiUyMCUzRCUyMGNocm9tYV9jbGllbnQuY3JlYXRlX2NvbGxlY3Rpb24obmFtZSUzRGNvbGxlY3Rpb25fbmFtZSk=",highlighted:`collection_name = <span class="hljs-string">&quot;news_collection&quot;</span>
<span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(chroma_client.list_collections()) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> collection_name <span class="hljs-keyword">in</span> [chroma_client.list_collections()[<span class="hljs-number">0</span>].name]:
    chroma_client.delete_collection(name=collection_name)

collection = chroma_client.create_collection(name=collection_name)`,wrap:!1}}),ae=new h({props:{code:"Y29sbGVjdGlvbi5hZGQoJTBBJTIwJTIwJTIwJTIwZG9jdW1lbnRzJTNEc3Vic2V0X2RhdGElNUJET0NVTUVOVCU1RC50b2xpc3QoKSUyQyUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhcyUzRCU1QiU3QlRPUElDJTNBJTIwdG9waWMlN0QlMjBmb3IlMjB0b3BpYyUyMGluJTIwc3Vic2V0X2RhdGElNUJUT1BJQyU1RC50b2xpc3QoKSU1RCUyQyUwQSUyMCUyMCUyMCUyMGlkcyUzRCU1QmYlMjJpZCU3QnglN0QlMjIlMjBmb3IlMjB4JTIwaW4lMjByYW5nZShNQVhfUk9XUyklNUQlMkMlMEEp",highlighted:`collection.add(
    documents=subset_data[DOCUMENT].tolist(),
    metadatas=[{TOPIC: topic} <span class="hljs-keyword">for</span> topic <span class="hljs-keyword">in</span> subset_data[TOPIC].tolist()],
    ids=[<span class="hljs-string">f&quot;id<span class="hljs-subst">{x}</span>&quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(MAX_ROWS)],
)`,wrap:!1}}),oe=new h({props:{code:"ZGVmJTIwcXVlcnlfZGF0YWJhc2UocXVlcnlfdGV4dCUyQyUyMG5fcmVzdWx0cyUzRDEwKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBjb2xsZWN0aW9uLnF1ZXJ5KHF1ZXJ5X3RleHRzJTNEcXVlcnlfdGV4dCUyQyUyMG5fcmVzdWx0cyUzRG5fcmVzdWx0cyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXN1bHRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">query_database</span>(<span class="hljs-params">query_text, n_results=<span class="hljs-number">10</span></span>):
    results = collection.query(query_texts=query_text, n_results=n_results)
    <span class="hljs-keyword">return</span> results`,wrap:!1}}),re=new u({props:{title:"创建语义缓存系统",local:"创建语义缓存系统",headingTag:"h2"}}),we=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGZhaXNzLWNwdSUzRCUzRDEuOC4w",highlighted:'!pip install -q faiss-cpu==<span class="hljs-number">1.8</span><span class="hljs-number">.0</span>',wrap:!1}}),he=new h({props:{code:"aW1wb3J0JTIwZmFpc3MlMEFmcm9tJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwU2VudGVuY2VUcmFuc2Zvcm1lciUwQWltcG9ydCUyMHRpbWUlMEFpbXBvcnQlMjBqc29u",highlighted:`<span class="hljs-keyword">import</span> faiss
<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> json`,wrap:!1}}),de=new h({props:{code:"ZGVmJTIwaW5pdF9jYWNoZSgpJTNBJTBBJTIwJTIwJTIwJTIwaW5kZXglMjAlM0QlMjBmYWlzcy5JbmRleEZsYXRMMig3NjgpJTBBJTIwJTIwJTIwJTIwaWYlMjBpbmRleC5pc190cmFpbmVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIySW5kZXglMjB0cmFpbmVkJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEluaXRpYWxpemUlMjBTZW50ZW5jZSUyMFRyYW5zZm9ybWVyJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBlbmNvZGVyJTIwJTNEJTIwU2VudGVuY2VUcmFuc2Zvcm1lciglMjJhbGwtbXBuZXQtYmFzZS12MiUyMiklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbmRleCUyQyUyMGVuY29kZXI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">init_cache</span>():
    index = faiss.IndexFlatL2(<span class="hljs-number">768</span>)
    <span class="hljs-keyword">if</span> index.is_trained:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Index trained&quot;</span>)

    <span class="hljs-comment"># Initialize Sentence Transformer model</span>
    encoder = SentenceTransformer(<span class="hljs-string">&quot;all-mpnet-base-v2&quot;</span>)

    <span class="hljs-keyword">return</span> index, encoder`,wrap:!1}}),be=new h({props:{code:"ZGVmJTIwcmV0cmlldmVfY2FjaGUoanNvbl9maWxlKSUzQSUwQSUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBvcGVuKGpzb25fZmlsZSUyQyUyMCUyMnIlMjIpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FjaGUlMjAlM0QlMjBqc29uLmxvYWQoZmlsZSklMEElMjAlMjAlMjAlMjBleGNlcHQlMjBGaWxlTm90Rm91bmRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhY2hlJTIwJTNEJTIwJTdCJTIycXVlc3Rpb25zJTIyJTNBJTIwJTVCJTVEJTJDJTIwJTIyZW1iZWRkaW5ncyUyMiUzQSUyMCU1QiU1RCUyQyUyMCUyMmFuc3dlcnMlMjIlM0ElMjAlNUIlNUQlMkMlMjAlMjJyZXNwb25zZV90ZXh0JTIyJTNBJTIwJTVCJTVEJTdEJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwY2FjaGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">retrieve_cache</span>(<span class="hljs-params">json_file</span>):
    <span class="hljs-keyword">try</span>:
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(json_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> file:
            cache = json.load(file)
    <span class="hljs-keyword">except</span> FileNotFoundError:
        cache = {<span class="hljs-string">&quot;questions&quot;</span>: [], <span class="hljs-string">&quot;embeddings&quot;</span>: [], <span class="hljs-string">&quot;answers&quot;</span>: [], <span class="hljs-string">&quot;response_text&quot;</span>: []}

    <span class="hljs-keyword">return</span> cache`,wrap:!1}}),ge=new h({props:{code:"ZGVmJTIwc3RvcmVfY2FjaGUoanNvbl9maWxlJTJDJTIwY2FjaGUpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oanNvbl9maWxlJTJDJTIwJTIydyUyMiklMjBhcyUyMGZpbGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBqc29uLmR1bXAoY2FjaGUlMkMlMjBmaWxlKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">store_cache</span>(<span class="hljs-params">json_file, cache</span>):
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(json_file, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> file:
        json.dump(cache, file)`,wrap:!1}}),Ae=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">semantic_cache</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, json_file=<span class="hljs-string">&quot;cache_file.json&quot;</span>, thresold=<span class="hljs-number">0.35</span></span>):
        <span class="hljs-comment"># Initialize Faiss index with Euclidean distance</span>
        self.index, self.encoder = init_cache()

        <span class="hljs-comment"># Set Euclidean distance threshold</span>
        <span class="hljs-comment"># a distance of 0 means identicals sentences</span>
        <span class="hljs-comment"># We only return from cache sentences under this thresold</span>
        self.euclidean_threshold = thresold

        self.json_file = json_file
        self.cache = retrieve_cache(self.json_file)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">ask</span>(<span class="hljs-params">self, question: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-comment"># Method to retrieve an answer from the cache or generate a new one</span>
        start_time = time.time()
        <span class="hljs-keyword">try</span>:
            <span class="hljs-comment"># First we obtain the embeddings corresponding to the user question</span>
            embedding = self.encoder.encode([question])

            <span class="hljs-comment"># Search for the nearest neighbor in the index</span>
            self.index.nprobe = <span class="hljs-number">8</span>
            D, I = self.index.search(embedding, <span class="hljs-number">1</span>)

            <span class="hljs-keyword">if</span> D[<span class="hljs-number">0</span>] &gt;= <span class="hljs-number">0</span>:
                <span class="hljs-keyword">if</span> I[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>] &gt;= <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>] &lt;= self.euclidean_threshold:
                    row_id = <span class="hljs-built_in">int</span>(I[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>])

                    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Answer recovered from Cache. &quot;</span>)
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]:<span class="hljs-number">.3</span>f}</span> smaller than <span class="hljs-subst">{self.euclidean_threshold}</span>&quot;</span>)
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Found cache in row: <span class="hljs-subst">{row_id}</span> with score <span class="hljs-subst">{D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]:<span class="hljs-number">.3</span>f}</span>&quot;</span>)
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;response_text: &quot;</span> + self.cache[<span class="hljs-string">&quot;response_text&quot;</span>][row_id])

                    end_time = time.time()
                    elapsed_time = end_time - start_time
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time taken: <span class="hljs-subst">{elapsed_time:<span class="hljs-number">.3</span>f}</span> seconds&quot;</span>)
                    <span class="hljs-keyword">return</span> self.cache[<span class="hljs-string">&quot;response_text&quot;</span>][row_id]

            <span class="hljs-comment"># Handle the case when there are not enough results</span>
            <span class="hljs-comment"># or Euclidean distance is not met, asking to chromaDB.</span>
            answer = query_database([question], <span class="hljs-number">1</span>)
            response_text = answer[<span class="hljs-string">&quot;documents&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]

            self.cache[<span class="hljs-string">&quot;questions&quot;</span>].append(question)
            self.cache[<span class="hljs-string">&quot;embeddings&quot;</span>].append(embedding[<span class="hljs-number">0</span>].tolist())
            self.cache[<span class="hljs-string">&quot;answers&quot;</span>].append(answer)
            self.cache[<span class="hljs-string">&quot;response_text&quot;</span>].append(response_text)

            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Answer recovered from ChromaDB. &quot;</span>)
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;response_text: <span class="hljs-subst">{response_text}</span>&quot;</span>)

            self.index.add(embedding)
            store_cache(self.json_file, self.cache)
            end_time = time.time()
            elapsed_time = end_time - start_time
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time taken: <span class="hljs-subst">{elapsed_time:<span class="hljs-number">.3</span>f}</span> seconds&quot;</span>)

            <span class="hljs-keyword">return</span> response_text
        <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
            <span class="hljs-keyword">raise</span> RuntimeError(<span class="hljs-string">f&quot;Error during &#x27;ask&#x27; method: <span class="hljs-subst">{e}</span>&quot;</span>)`,wrap:!1}}),Be=new u({props:{title:"测试 semantic_cache 类。",local:"测试-semanticcache-类",headingTag:"h3"}}),Ze=new h({props:{code:"JTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMGNhY2hlLiUwQWNhY2hlJTIwJTNEJTIwc2VtYW50aWNfY2FjaGUoJTIyNGNhY2hlLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache = semantic_cache(<span class="hljs-string">&quot;4cache.json&quot;</span>)`,wrap:!1}}),_e=new h({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJIb3clMjBkbyUyMHZhY2NpbmVzJTIwd29yayUzRiUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;How do vaccines work?&quot;</span>)',wrap:!1}}),Se=new h({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJFeHBsYWluJTIwYnJpZWZseSUyMHdoYXQlMjBpcyUyMGElMjBTeWRlbmhhbSUyMGNob3JlYSUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;Explain briefly what is a Sydenham chorea&quot;</span>)',wrap:!1}}),Ye=new h({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJCcmllZmx5JTIwZXhwbGFpbiUyMG1lJTIwd2hhdCUyMGlzJTIwYSUyMFN5ZGVuaGFtJTIwY2hvcmVhLiUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;Briefly explain me what is a Sydenham chorea.&quot;</span>)',wrap:!1}}),qe=new h({props:{code:"cXVlc3Rpb25fZGVmJTIwJTNEJTIwJTIyV3JpdGUlMjBpbiUyMDIwJTIwd29yZHMlMjB3aGF0JTIwaXMlMjBhJTIwU3lkZW5oYW0lMjBjaG9yZWEuJTIyJTBBcmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayhxdWVzdGlvbl9kZWYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>question_def = <span class="hljs-string">&quot;Write in 20 words what is a Sydenham chorea.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(question_def)`,wrap:!1}}),De=new u({props:{title:"加载模型并创建提示",local:"加载模型并创建提示",headingTag:"h1"}}),tt=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0b3JjaA==",highlighted:"!pip install torch",wrap:!1}}),lt=new h({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwY3VkYSUyQyUyMHRvcmNoJTBBJTBBJTIzJTIwSW4lMjBhJTIwTUFDJTIwU2lsaWNvbiUyMHRoZSUyMGRldmljZSUyMG11c3QlMjBiZSUyMCdtcHMnJTBBJTIzJTIwZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCdtcHMnKSUyMCUyM3RvJTIwdXNlJTIwd2l0aCUyME1BQyUyMFNpbGljb24lMEFkZXZpY2UlMjAlM0QlMjBmJTIyY3VkYSUzQSU3QmN1ZGEuY3VycmVudF9kZXZpY2UoKSU3RCUyMiUyMGlmJTIwY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjI=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> cuda, torch

<span class="hljs-comment"># In a MAC Silicon the device must be &#x27;mps&#x27;</span>
<span class="hljs-comment"># device = torch.device(&#x27;mps&#x27;) #to use with MAC Silicon</span>
device = <span class="hljs-string">f&quot;cuda:<span class="hljs-subst">{cuda.current_device()}</span>&quot;</span> <span class="hljs-keyword">if</span> cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>`,wrap:!1}}),st=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmItaXQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;cuda&quot;</span>, torch_dtype=torch.bfloat16)`,wrap:!1}}),nt=new u({props:{title:"创建扩展提示",local:"创建扩展提示",headingTag:"h2"}}),Mt=new h({props:{code:"cHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwZiUyMlJlbGV2YW50JTIwY29udGV4dCUzQSUyMCU3QnJlc3VsdHMlN0QlNUNuJTVDbiUyMFRoZSUyMHVzZXIncyUyMHF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb25fZGVmJTdEJTIyJTBBcHJvbXB0X3RlbXBsYXRl",highlighted:`prompt_template = <span class="hljs-string">f&quot;Relevant context: <span class="hljs-subst">{results}</span>\\n\\n The user&#x27;s question: <span class="hljs-subst">{question_def}</span>&quot;</span>
prompt_template`,wrap:!1}}),ot=new h({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdF90ZW1wbGF0ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:'input_ids = tokenizer(prompt_template, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),mt=new h({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**input_ids, max_new_tokens=<span class="hljs-number">256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),yt=new u({props:{title:"结论",local:"结论",headingTag:"h1"}}),Jt=new ta({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/semantic_cache_chroma_vector_database.md"}}),{c(){j=i("meta"),dt=n(),Tt=i("p"),Ct=n(),o(J.$$.fragment),bt=n(),o(U.$$.fragment),It=n(),T=i("p"),T.innerHTML=Gs,gt=n(),f=i("p"),f.innerHTML=xs,$t=n(),d=i("p"),d.textContent=As,vt=n(),C=i("p"),C.textContent=Bs,Gt=n(),b=i("p"),b.innerHTML=Zs,xt=n(),I=i("p"),I.textContent=ks,At=n(),Ut=i("img"),Bt=n(),g=i("p"),g.textContent=Ns,Zt=n(),$=i("p"),$.textContent=Ws,kt=n(),v=i("p"),v.textContent=Rs,_t=n(),G=i("p"),G.textContent=Ss,Nt=n(),x=i("ul"),x.innerHTML=Vs,Wt=n(),A=i("p"),A.textContent=zs,Rt=n(),B=i("p"),B.textContent=Es,St=n(),Z=i("p"),Z.textContent=Qs,Vt=n(),k=i("p"),k.textContent=Ys,zt=n(),o(_.$$.fragment),Et=n(),N=i("p"),N.textContent=Hs,Qt=n(),W=i("ul"),W.innerHTML=Xs,Yt=n(),o(R.$$.fragment),Ht=n(),o(S.$$.fragment),Xt=n(),o(V.$$.fragment),Ft=n(),z=i("p"),z.innerHTML=Fs,qt=n(),o(E.$$.fragment),Lt=n(),o(Q.$$.fragment),Pt=n(),Y=i("p"),Y.innerHTML=qs,Dt=n(),o(H.$$.fragment),Kt=n(),o(X.$$.fragment),Ot=n(),o(F.$$.fragment),el=n(),o(q.$$.fragment),tl=n(),L=i("p"),L.textContent=Ls,ll=n(),P=i("p"),P.textContent=Ps,sl=n(),o(D.$$.fragment),nl=n(),K=i("p"),K.textContent=Ds,al=n(),o(O.$$.fragment),il=n(),o(ee.$$.fragment),pl=n(),te=i("p"),te.innerHTML=Ks,Ml=n(),o(le.$$.fragment),ol=n(),se=i("p"),se.innerHTML=Os,rl=n(),ne=i("ul"),ne.innerHTML=en,ml=n(),o(ae.$$.fragment),cl=n(),ie=i("p"),ie.textContent=tn,yl=n(),pe=i("p"),pe.textContent=ln,wl=n(),Me=i("p"),Me.textContent=sn,hl=n(),o(oe.$$.fragment),ul=n(),o(re.$$.fragment),jl=n(),me=i("p"),me.textContent=nn,Jl=n(),ce=i("p"),ce.innerHTML=an,Ul=n(),ye=i("p"),ye.textContent=pn,Tl=n(),o(we.$$.fragment),fl=n(),o(he.$$.fragment),dl=n(),ue=i("p"),ue.innerHTML=Mn,Cl=n(),je=i("p"),je.textContent=on,bl=n(),Je=i("p"),Je.textContent=rn,Il=n(),Ue=i("p"),Ue.textContent=mn,gl=n(),Te=i("ul"),Te.innerHTML=cn,$l=n(),fe=i("p"),fe.innerHTML=yn,vl=n(),o(de.$$.fragment),Gl=n(),Ce=i("p"),Ce.innerHTML=wn,xl=n(),o(be.$$.fragment),Al=n(),Ie=i("p"),Ie.innerHTML=hn,Bl=n(),o(ge.$$.fragment),Zl=n(),$e=i("p"),$e.innerHTML=un,kl=n(),ve=i("p"),ve.innerHTML=jn,_l=n(),Ge=i("p"),Ge.innerHTML=Jn,Nl=n(),xe=i("p"),xe.textContent=Un,Wl=n(),o(Ae.$$.fragment),Rl=n(),o(Be.$$.fragment),Sl=n(),o(Ze.$$.fragment),Vl=n(),ke=i("pre"),ke.textContent=Tn,zl=n(),o(_e.$$.fragment),El=n(),Ne=i("pre"),Ne.textContent=fn,Ql=n(),We=i("p"),We.textContent=dn,Yl=n(),Re=i("p"),Re.textContent=Cn,Hl=n(),o(Se.$$.fragment),Xl=n(),Ve=i("pre"),Ve.textContent=bn,Fl=n(),ze=i("p"),ze.textContent=In,ql=n(),Ee=i("p"),Ee.textContent=gn,Ll=n(),Qe=i("p"),Qe.textContent=$n,Pl=n(),o(Ye.$$.fragment),Dl=n(),He=i("pre"),He.textContent=vn,Kl=n(),Xe=i("p"),Xe.textContent=Gn,Ol=n(),Fe=i("p"),Fe.textContent=xn,es=n(),o(qe.$$.fragment),ts=n(),Le=i("pre"),Le.textContent=An,ls=n(),Pe=i("p"),Pe.textContent=Bn,ss=n(),o(De.$$.fragment),ns=n(),Ke=i("p"),Ke.innerHTML=Zn,as=n(),Oe=i("p"),Oe.textContent=kn,is=n(),et=i("ul"),et.innerHTML=_n,ps=n(),o(tt.$$.fragment),Ms=n(),o(lt.$$.fragment),os=n(),o(st.$$.fragment),rs=n(),o(nt.$$.fragment),ms=n(),at=i("p"),at.textContent=Nn,cs=n(),it=i("p"),it.innerHTML=Wn,ys=n(),pt=i("p"),pt.textContent=Rn,ws=n(),o(Mt.$$.fragment),hs=n(),o(ot.$$.fragment),us=n(),rt=i("p"),rt.textContent=Sn,js=n(),o(mt.$$.fragment),Js=n(),ct=i("pre"),ct.innerHTML=Vn,Us=n(),o(yt.$$.fragment),Ts=n(),wt=i("p"),wt.textContent=zn,fs=n(),ht=i("p"),ht.textContent=En,ds=n(),ut=i("p"),ut.textContent=Qn,Cs=n(),jt=i("p"),jt.textContent=Yn,bs=n(),o(Jt.$$.fragment),Is=n(),ft=i("p"),this.h()},l(e){const t=Kn("svelte-u9bgzb",document.head);j=p(t,"META",{name:!0,content:!0}),t.forEach(l),dt=a(e),Tt=p(e,"P",{}),Hn(Tt).forEach(l),Ct=a(e),r(J.$$.fragment,e),bt=a(e),r(U.$$.fragment,e),It=a(e),T=p(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1n7exb5"&&(T.innerHTML=Gs),gt=a(e),f=p(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-15k4z8c"&&(f.innerHTML=xs),$t=a(e),d=p(e,"P",{"data-svelte-h":!0}),M(d)!=="svelte-11ylz4o"&&(d.textContent=As),vt=a(e),C=p(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1vn5l8g"&&(C.textContent=Bs),Gt=a(e),b=p(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-8hnfwk"&&(b.innerHTML=Zs),xt=a(e),I=p(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-4u23b6"&&(I.textContent=ks),At=a(e),Ut=p(e,"IMG",{src:!0}),Bt=a(e),g=p(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1wky8l7"&&(g.textContent=Ns),Zt=a(e),$=p(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-ksvfjs"&&($.textContent=Ws),kt=a(e),v=p(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1bvpahe"&&(v.textContent=Rs),_t=a(e),G=p(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-cnzi62"&&(G.textContent=Ss),Nt=a(e),x=p(e,"UL",{"data-svelte-h":!0}),M(x)!=="svelte-1q79ppw"&&(x.innerHTML=Vs),Wt=a(e),A=p(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-qhu07g"&&(A.textContent=zs),Rt=a(e),B=p(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1s0b30d"&&(B.textContent=Es),St=a(e),Z=p(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1a7f729"&&(Z.textContent=Qs),Vt=a(e),k=p(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-63npyl"&&(k.textContent=Ys),zt=a(e),r(_.$$.fragment,e),Et=a(e),N=p(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-18s02xb"&&(N.textContent=Hs),Qt=a(e),W=p(e,"UL",{"data-svelte-h":!0}),M(W)!=="svelte-34uoq3"&&(W.innerHTML=Xs),Yt=a(e),r(R.$$.fragment,e),Ht=a(e),r(S.$$.fragment,e),Xt=a(e),r(V.$$.fragment,e),Ft=a(e),z=p(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1c1opdv"&&(z.innerHTML=Fs),qt=a(e),r(E.$$.fragment,e),Lt=a(e),r(Q.$$.fragment,e),Pt=a(e),Y=p(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-b0o92q"&&(Y.innerHTML=qs),Dt=a(e),r(H.$$.fragment,e),Kt=a(e),r(X.$$.fragment,e),Ot=a(e),r(F.$$.fragment,e),el=a(e),r(q.$$.fragment,e),tl=a(e),L=p(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-6lfamd"&&(L.textContent=Ls),ll=a(e),P=p(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-2qjbun"&&(P.textContent=Ps),sl=a(e),r(D.$$.fragment,e),nl=a(e),K=p(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-pc5ggj"&&(K.textContent=Ds),al=a(e),r(O.$$.fragment,e),il=a(e),r(ee.$$.fragment,e),pl=a(e),te=p(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-1pqmzje"&&(te.innerHTML=Ks),Ml=a(e),r(le.$$.fragment,e),ol=a(e),se=p(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-n6pyi0"&&(se.innerHTML=Os),rl=a(e),ne=p(e,"UL",{"data-svelte-h":!0}),M(ne)!=="svelte-f476s0"&&(ne.innerHTML=en),ml=a(e),r(ae.$$.fragment,e),cl=a(e),ie=p(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-f5w6vv"&&(ie.textContent=tn),yl=a(e),pe=p(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-6hegus"&&(pe.textContent=ln),wl=a(e),Me=p(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-1xxeku5"&&(Me.textContent=sn),hl=a(e),r(oe.$$.fragment,e),ul=a(e),r(re.$$.fragment,e),jl=a(e),me=p(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-vyp9pe"&&(me.textContent=nn),Jl=a(e),ce=p(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-133mpmn"&&(ce.innerHTML=an),Ul=a(e),ye=p(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-vjkekr"&&(ye.textContent=pn),Tl=a(e),r(we.$$.fragment,e),fl=a(e),r(he.$$.fragment,e),dl=a(e),ue=p(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-88z3a4"&&(ue.innerHTML=Mn),Cl=a(e),je=p(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-66g8xe"&&(je.textContent=on),bl=a(e),Je=p(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-2rbogm"&&(Je.textContent=rn),Il=a(e),Ue=p(e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-1gan433"&&(Ue.textContent=mn),gl=a(e),Te=p(e,"UL",{"data-svelte-h":!0}),M(Te)!=="svelte-232whh"&&(Te.innerHTML=cn),$l=a(e),fe=p(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-xlte47"&&(fe.innerHTML=yn),vl=a(e),r(de.$$.fragment,e),Gl=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-1qns4ys"&&(Ce.innerHTML=wn),xl=a(e),r(be.$$.fragment,e),Al=a(e),Ie=p(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-ii3wze"&&(Ie.innerHTML=hn),Bl=a(e),r(ge.$$.fragment,e),Zl=a(e),$e=p(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-6zu4rg"&&($e.innerHTML=un),kl=a(e),ve=p(e,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-yy8io3"&&(ve.innerHTML=jn),_l=a(e),Ge=p(e,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-y34k66"&&(Ge.innerHTML=Jn),Nl=a(e),xe=p(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-1k2r2gp"&&(xe.textContent=Un),Wl=a(e),r(Ae.$$.fragment,e),Rl=a(e),r(Be.$$.fragment,e),Sl=a(e),r(Ze.$$.fragment,e),Vl=a(e),ke=p(e,"PRE",{"data-svelte-h":!0}),M(ke)!=="svelte-mqrnyt"&&(ke.textContent=Tn),zl=a(e),r(_e.$$.fragment,e),El=a(e),Ne=p(e,"PRE",{"data-svelte-h":!0}),M(Ne)!=="svelte-ick26y"&&(Ne.textContent=fn),Ql=a(e),We=p(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-a70hjy"&&(We.textContent=dn),Yl=a(e),Re=p(e,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-1emk5jb"&&(Re.textContent=Cn),Hl=a(e),r(Se.$$.fragment,e),Xl=a(e),Ve=p(e,"PRE",{"data-svelte-h":!0}),M(Ve)!=="svelte-we3tc3"&&(Ve.textContent=bn),Fl=a(e),ze=p(e,"P",{"data-svelte-h":!0}),M(ze)!=="svelte-1mgix7t"&&(ze.textContent=In),ql=a(e),Ee=p(e,"P",{"data-svelte-h":!0}),M(Ee)!=="svelte-1nkae7r"&&(Ee.textContent=gn),Ll=a(e),Qe=p(e,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-nyaibc"&&(Qe.textContent=$n),Pl=a(e),r(Ye.$$.fragment,e),Dl=a(e),He=p(e,"PRE",{"data-svelte-h":!0}),M(He)!=="svelte-zuw07a"&&(He.textContent=vn),Kl=a(e),Xe=p(e,"P",{"data-svelte-h":!0}),M(Xe)!=="svelte-thqcpr"&&(Xe.textContent=Gn),Ol=a(e),Fe=p(e,"P",{"data-svelte-h":!0}),M(Fe)!=="svelte-bcpyax"&&(Fe.textContent=xn),es=a(e),r(qe.$$.fragment,e),ts=a(e),Le=p(e,"PRE",{"data-svelte-h":!0}),M(Le)!=="svelte-158wm6z"&&(Le.textContent=An),ls=a(e),Pe=p(e,"P",{"data-svelte-h":!0}),M(Pe)!=="svelte-1jotmqd"&&(Pe.textContent=Bn),ss=a(e),r(De.$$.fragment,e),ns=a(e),Ke=p(e,"P",{"data-svelte-h":!0}),M(Ke)!=="svelte-q2oo54"&&(Ke.innerHTML=Zn),as=a(e),Oe=p(e,"P",{"data-svelte-h":!0}),M(Oe)!=="svelte-1px6e14"&&(Oe.textContent=kn),is=a(e),et=p(e,"UL",{"data-svelte-h":!0}),M(et)!=="svelte-14usp90"&&(et.innerHTML=_n),ps=a(e),r(tt.$$.fragment,e),Ms=a(e),r(lt.$$.fragment,e),os=a(e),r(st.$$.fragment,e),rs=a(e),r(nt.$$.fragment,e),ms=a(e),at=p(e,"P",{"data-svelte-h":!0}),M(at)!=="svelte-slfzj7"&&(at.textContent=Nn),cs=a(e),it=p(e,"P",{"data-svelte-h":!0}),M(it)!=="svelte-s2tyom"&&(it.innerHTML=Wn),ys=a(e),pt=p(e,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-sbz1iz"&&(pt.textContent=Rn),ws=a(e),r(Mt.$$.fragment,e),hs=a(e),r(ot.$$.fragment,e),us=a(e),rt=p(e,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-11xe0uy"&&(rt.textContent=Sn),js=a(e),r(mt.$$.fragment,e),Js=a(e),ct=p(e,"PRE",{"data-svelte-h":!0}),M(ct)!=="svelte-1uv406t"&&(ct.innerHTML=Vn),Us=a(e),r(yt.$$.fragment,e),Ts=a(e),wt=p(e,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-1vnm5v0"&&(wt.textContent=zn),fs=a(e),ht=p(e,"P",{"data-svelte-h":!0}),M(ht)!=="svelte-1hncnz4"&&(ht.textContent=En),ds=a(e),ut=p(e,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-13sbx3i"&&(ut.textContent=Qn),Cs=a(e),jt=p(e,"P",{"data-svelte-h":!0}),M(jt)!=="svelte-1qp3wc5"&&(jt.textContent=Yn),bs=a(e),r(Jt.$$.fragment,e),Is=a(e),ft=p(e,"P",{}),Hn(ft).forEach(l),this.h()},h(){$s(j,"name","hf:doc:metadata"),$s(j,"content",sa),Fn(Ut.src,_s="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/semantic_cache.jpg")||$s(Ut,"src",_s)},m(e,t){On(document.head,j),s(e,dt,t),s(e,Tt,t),s(e,Ct,t),m(J,e,t),s(e,bt,t),m(U,e,t),s(e,It,t),s(e,T,t),s(e,gt,t),s(e,f,t),s(e,$t,t),s(e,d,t),s(e,vt,t),s(e,C,t),s(e,Gt,t),s(e,b,t),s(e,xt,t),s(e,I,t),s(e,At,t),s(e,Ut,t),s(e,Bt,t),s(e,g,t),s(e,Zt,t),s(e,$,t),s(e,kt,t),s(e,v,t),s(e,_t,t),s(e,G,t),s(e,Nt,t),s(e,x,t),s(e,Wt,t),s(e,A,t),s(e,Rt,t),s(e,B,t),s(e,St,t),s(e,Z,t),s(e,Vt,t),s(e,k,t),s(e,zt,t),m(_,e,t),s(e,Et,t),s(e,N,t),s(e,Qt,t),s(e,W,t),s(e,Yt,t),m(R,e,t),s(e,Ht,t),m(S,e,t),s(e,Xt,t),m(V,e,t),s(e,Ft,t),s(e,z,t),s(e,qt,t),m(E,e,t),s(e,Lt,t),m(Q,e,t),s(e,Pt,t),s(e,Y,t),s(e,Dt,t),m(H,e,t),s(e,Kt,t),m(X,e,t),s(e,Ot,t),m(F,e,t),s(e,el,t),m(q,e,t),s(e,tl,t),s(e,L,t),s(e,ll,t),s(e,P,t),s(e,sl,t),m(D,e,t),s(e,nl,t),s(e,K,t),s(e,al,t),m(O,e,t),s(e,il,t),m(ee,e,t),s(e,pl,t),s(e,te,t),s(e,Ml,t),m(le,e,t),s(e,ol,t),s(e,se,t),s(e,rl,t),s(e,ne,t),s(e,ml,t),m(ae,e,t),s(e,cl,t),s(e,ie,t),s(e,yl,t),s(e,pe,t),s(e,wl,t),s(e,Me,t),s(e,hl,t),m(oe,e,t),s(e,ul,t),m(re,e,t),s(e,jl,t),s(e,me,t),s(e,Jl,t),s(e,ce,t),s(e,Ul,t),s(e,ye,t),s(e,Tl,t),m(we,e,t),s(e,fl,t),m(he,e,t),s(e,dl,t),s(e,ue,t),s(e,Cl,t),s(e,je,t),s(e,bl,t),s(e,Je,t),s(e,Il,t),s(e,Ue,t),s(e,gl,t),s(e,Te,t),s(e,$l,t),s(e,fe,t),s(e,vl,t),m(de,e,t),s(e,Gl,t),s(e,Ce,t),s(e,xl,t),m(be,e,t),s(e,Al,t),s(e,Ie,t),s(e,Bl,t),m(ge,e,t),s(e,Zl,t),s(e,$e,t),s(e,kl,t),s(e,ve,t),s(e,_l,t),s(e,Ge,t),s(e,Nl,t),s(e,xe,t),s(e,Wl,t),m(Ae,e,t),s(e,Rl,t),m(Be,e,t),s(e,Sl,t),m(Ze,e,t),s(e,Vl,t),s(e,ke,t),s(e,zl,t),m(_e,e,t),s(e,El,t),s(e,Ne,t),s(e,Ql,t),s(e,We,t),s(e,Yl,t),s(e,Re,t),s(e,Hl,t),m(Se,e,t),s(e,Xl,t),s(e,Ve,t),s(e,Fl,t),s(e,ze,t),s(e,ql,t),s(e,Ee,t),s(e,Ll,t),s(e,Qe,t),s(e,Pl,t),m(Ye,e,t),s(e,Dl,t),s(e,He,t),s(e,Kl,t),s(e,Xe,t),s(e,Ol,t),s(e,Fe,t),s(e,es,t),m(qe,e,t),s(e,ts,t),s(e,Le,t),s(e,ls,t),s(e,Pe,t),s(e,ss,t),m(De,e,t),s(e,ns,t),s(e,Ke,t),s(e,as,t),s(e,Oe,t),s(e,is,t),s(e,et,t),s(e,ps,t),m(tt,e,t),s(e,Ms,t),m(lt,e,t),s(e,os,t),m(st,e,t),s(e,rs,t),m(nt,e,t),s(e,ms,t),s(e,at,t),s(e,cs,t),s(e,it,t),s(e,ys,t),s(e,pt,t),s(e,ws,t),m(Mt,e,t),s(e,hs,t),m(ot,e,t),s(e,us,t),s(e,rt,t),s(e,js,t),m(mt,e,t),s(e,Js,t),s(e,ct,t),s(e,Us,t),m(yt,e,t),s(e,Ts,t),s(e,wt,t),s(e,fs,t),s(e,ht,t),s(e,ds,t),s(e,ut,t),s(e,Cs,t),s(e,jt,t),s(e,bs,t),m(Jt,e,t),s(e,Is,t),s(e,ft,t),gs=!0},p:qn,i(e){gs||(c(J.$$.fragment,e),c(U.$$.fragment,e),c(_.$$.fragment,e),c(R.$$.fragment,e),c(S.$$.fragment,e),c(V.$$.fragment,e),c(E.$$.fragment,e),c(Q.$$.fragment,e),c(H.$$.fragment,e),c(X.$$.fragment,e),c(F.$$.fragment,e),c(q.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(we.$$.fragment,e),c(he.$$.fragment,e),c(de.$$.fragment,e),c(be.$$.fragment,e),c(ge.$$.fragment,e),c(Ae.$$.fragment,e),c(Be.$$.fragment,e),c(Ze.$$.fragment,e),c(_e.$$.fragment,e),c(Se.$$.fragment,e),c(Ye.$$.fragment,e),c(qe.$$.fragment,e),c(De.$$.fragment,e),c(tt.$$.fragment,e),c(lt.$$.fragment,e),c(st.$$.fragment,e),c(nt.$$.fragment,e),c(Mt.$$.fragment,e),c(ot.$$.fragment,e),c(mt.$$.fragment,e),c(yt.$$.fragment,e),c(Jt.$$.fragment,e),gs=!0)},o(e){y(J.$$.fragment,e),y(U.$$.fragment,e),y(_.$$.fragment,e),y(R.$$.fragment,e),y(S.$$.fragment,e),y(V.$$.fragment,e),y(E.$$.fragment,e),y(Q.$$.fragment,e),y(H.$$.fragment,e),y(X.$$.fragment,e),y(F.$$.fragment,e),y(q.$$.fragment,e),y(D.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(re.$$.fragment,e),y(we.$$.fragment,e),y(he.$$.fragment,e),y(de.$$.fragment,e),y(be.$$.fragment,e),y(ge.$$.fragment,e),y(Ae.$$.fragment,e),y(Be.$$.fragment,e),y(Ze.$$.fragment,e),y(_e.$$.fragment,e),y(Se.$$.fragment,e),y(Ye.$$.fragment,e),y(qe.$$.fragment,e),y(De.$$.fragment,e),y(tt.$$.fragment,e),y(lt.$$.fragment,e),y(st.$$.fragment,e),y(nt.$$.fragment,e),y(Mt.$$.fragment,e),y(ot.$$.fragment,e),y(mt.$$.fragment,e),y(yt.$$.fragment,e),y(Jt.$$.fragment,e),gs=!1},d(e){e&&(l(dt),l(Tt),l(Ct),l(bt),l(It),l(T),l(gt),l(f),l($t),l(d),l(vt),l(C),l(Gt),l(b),l(xt),l(I),l(At),l(Ut),l(Bt),l(g),l(Zt),l($),l(kt),l(v),l(_t),l(G),l(Nt),l(x),l(Wt),l(A),l(Rt),l(B),l(St),l(Z),l(Vt),l(k),l(zt),l(Et),l(N),l(Qt),l(W),l(Yt),l(Ht),l(Xt),l(Ft),l(z),l(qt),l(Lt),l(Pt),l(Y),l(Dt),l(Kt),l(Ot),l(el),l(tl),l(L),l(ll),l(P),l(sl),l(nl),l(K),l(al),l(il),l(pl),l(te),l(Ml),l(ol),l(se),l(rl),l(ne),l(ml),l(cl),l(ie),l(yl),l(pe),l(wl),l(Me),l(hl),l(ul),l(jl),l(me),l(Jl),l(ce),l(Ul),l(ye),l(Tl),l(fl),l(dl),l(ue),l(Cl),l(je),l(bl),l(Je),l(Il),l(Ue),l(gl),l(Te),l($l),l(fe),l(vl),l(Gl),l(Ce),l(xl),l(Al),l(Ie),l(Bl),l(Zl),l($e),l(kl),l(ve),l(_l),l(Ge),l(Nl),l(xe),l(Wl),l(Rl),l(Sl),l(Vl),l(ke),l(zl),l(El),l(Ne),l(Ql),l(We),l(Yl),l(Re),l(Hl),l(Xl),l(Ve),l(Fl),l(ze),l(ql),l(Ee),l(Ll),l(Qe),l(Pl),l(Dl),l(He),l(Kl),l(Xe),l(Ol),l(Fe),l(es),l(ts),l(Le),l(ls),l(Pe),l(ss),l(ns),l(Ke),l(as),l(Oe),l(is),l(et),l(ps),l(Ms),l(os),l(rs),l(ms),l(at),l(cs),l(it),l(ys),l(pt),l(ws),l(hs),l(us),l(rt),l(js),l(Js),l(ct),l(Us),l(Ts),l(wt),l(fs),l(ht),l(ds),l(ut),l(Cs),l(jt),l(bs),l(Is),l(ft)),l(j),w(J,e),w(U,e),w(_,e),w(R,e),w(S,e),w(V,e),w(E,e),w(Q,e),w(H,e),w(X,e),w(F,e),w(q,e),w(D,e),w(O,e),w(ee,e),w(le,e),w(ae,e),w(oe,e),w(re,e),w(we,e),w(he,e),w(de,e),w(be,e),w(ge,e),w(Ae,e),w(Be,e),w(Ze,e),w(_e,e),w(Se,e),w(Ye,e),w(qe,e),w(De,e),w(tt,e),w(lt,e),w(st,e),w(nt,e),w(Mt,e),w(ot,e),w(mt,e),w(yt,e),w(Jt,e)}}}const sa='{"title":"通过引入语义缓存到 FAISS 中以增强 RAG 系统的性能","local":"通过引入语义缓存到-faiss-中以增强-rag-系统的性能","sections":[],"depth":1}';function na(vs){return Ln(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oa extends Pn{constructor(j){super(),Dn(this,j,na,la,Xn,{})}}export{oa as component};
