import{s as ce,n as ye,o as re}from"../chunks/scheduler.65852ee5.js";import{S as me,i as he,g as p,s as a,r as M,A as Je,h as o,f as e,c as n,j as gs,u as c,x as i,k as Is,y as je,a as t,v as y,d as r,t as m,w as h}from"../chunks/index.aa74147d.js";import{D as Te,C as J}from"../chunks/DocNotebookDropdown.1a7e6a42.js";import{H as j,E as ue}from"../chunks/getInferenceSnippets.796600e5.js";function de(_l){let T,fs,ws,Bs,u,Cs,d,Zs,U,vl='<em>作者: <a href="https://huggingface.co/andrewrreed" rel="nofollow">Andrew Reed</a></em>',Gs,w,Rl="这个 notebook 展示了如何轻松地从 OpenAI 模型过渡到 Open LLMs，而无需重构任何现有代码。",Ws,b,kl='<a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">文本生成推理（TGI）</a>现在提供了一个<a href="https://huggingface.co/blog/tgi-messages-api" rel="nofollow">消息 API</a>，使其与 OpenAI 的聊天完成 API 的直接兼容。这意味着任何使用 OpenAI 的模型（通过 OpenAI 客户端库或像 LangChain 或 LlamaIndex 这样的第三方工具）的现有脚本都可以直接替换为使用运行在 TGI 端点上的任何开源 LLM！',_s,g,Al="这允许你快速测试并受益于开源模型提供的众多优势。例如：",vs,I,El="<li><p>对模型和数据的完全控制和透明度</p></li> <li><p>不再担心速率限制</p></li> <li><p>能够根据你的具体需求完全定制系统</p></li>",Rs,f,Nl="在这个 notebook 中，我们将向你展示具体流程：",ks,B,Vl='<li><a href="#section_1">使用 TGI 创建推理端点来部署模型</a></li> <li><a href="#section_2">使用 OpenAI 客户端库查询推理端点</a></li> <li><a href="#section_3">将端点与 LangChain 和 LlamaIndex 工作流程集成</a></li>',As,C,Xl="<strong>让我们开始吧！</strong>",Es,Z,Ns,G,xl="首先，我们需要安装依赖项和设置一个 HF API 密钥。",Vs,W,Xs,_,xs,us,Qs,v,$s,R,Ql='一开始，让我们使用 TGI 将<a href="https://huggingface.co/NousResearch/Nous-Hermes-2-Mixtral-8x7B-DPO" rel="nofollow">Nous-Hermes-2-Mixtral-8x7B-DPO</a>，一个微调的 Mixtral 模型，部署到推理端点。',Ss,k,$l='我们只需通过 UI 的<a href="https://ui.endpoints.huggingface.co/new?vendor=aws&amp;repository=NousResearch%2FNous-Hermes-2-Mixtral-8x7B-DPO&amp;tgi_max_total_tokens=32000&amp;tgi=true&amp;tgi_max_input_length=1024&amp;task=text-generation&amp;instance_size=2xlarge&amp;tgi_max_batch_prefill_tokens=2048&amp;tgi_max_batch_total_tokens=1024000&amp;no_suggested_compute=true&amp;accelerator=gpu&amp;region=us-east-1" rel="nofollow">几次点击</a>，就可以部署模型，或者利用 <code>huggingface_hub</code> Python 库以编程方式创建和管理推理端点。',Fs,A,Sl='在这里，我们将使用 Hub 库，通过指定端点名称和模型仓库，以及 <code>text-generation</code> 任务。在这个例子中，我们使用 <code>protected</code> 类型，因此访问部署的模型将需要一个有效的 Hugging Face token。我们还需要配置硬件要求，如供应商、地区、加速器、实例类型和大小。你可以使用<a href="https://api.endpoints.huggingface.cloud/#get-/v2/provider" rel="nofollow">this API call</a>查看可用的资源选项列表，并在目录中<a href="https://ui.endpoints.huggingface.co/catalog" rel="nofollow">这里</a>查看为选定模型推荐配置。',Ys,E,Hs,N,Fl=`running
`,qs,V,Yl="部署启动需要几分钟时间。我们可以使用 <code>.wait()</code> 工具来阻塞运行线程，直到端点达到最终的“运行”状态。一旦运行，我们可以在 UI 播放器中确认其状态并试用：",Ls,X,Hl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/messages-api/endpoint-overview.png" alt="IE UI Overview"/>',zs,x,ql="太好了，现在我们有一个可用的端点！",Ps,Q,Ll='<em>注意：使用 <code>huggingface_hub</code> 部署时，默认情况下，在15分钟空闲时间后，你的端点会自动缩放到零，以在非活动期间优化成本。查看<a href="https://huggingface.co/docs/huggingface_hub/guides/inference_endpoints" rel="nofollow">Hub Python 库文档</a>以了解可用于管理端点生命周期的所有功能。</em>',Os,ds,Ds,$,Ks,S,zl="如上所述，由于我们的模型托管在 TGI 上，现在支持消息 API，这意味着我们可以直接使用熟悉的 OpenAI 客户端库来查询它。",sl,F,ll,Y,Pl='下面的例子展示了如何使用<a href="https://github.com/openai/openai-python" rel="nofollow">OpenAI Python 库</a>进行这种转换。只需将 <code>&lt;ENDPOINT_URL&gt;</code> 替换为你的端点 URL（确保包含 <code>v1/</code> 后缀），并将 <code>&lt;HF_API_KEY&gt;</code> 字段填充为有效的 Hugging Face 用户 token。<code>&lt;ENDPOINT_URL&gt;</code> 可以从推理端点的 UI 中获取，或者从我们上面使用 <code>endpoint.url</code> 创建的端点对象中获取。',el,H,Ol="然后我们可以像往常一样使用客户端，传递一个消息列表以从我们的推理端点流式传输响应。",tl,q,al,L,Dl=`Open-source software is important due to a number of reasons, including:

1. Collaboration: The collaborative nature of open-source software allows developers from around the world to work together, share their ideas and improve the code. This often results in faster progress and better software.

2. Transparency: With open-source software, the code is publicly available, making it easy to see exactly how the software functions, and allowing users to determine if there are any security vulnerabilities.

3. Customization: Being able to access the code also allows users to customize the software to better suit their needs. This makes open-source software incredibly versatile, as users can tweak it to suit their specific use case.

4. Quality: Open-source software is often developed by large communities of dedicated developers, who work together to improve the software. This results in a higher level of quality than might be found in proprietary software.

5. Cost: Open-source software is often provided free of charge, which makes it accessible to a wider range of users. This can be especially important for organizations with limited budgets for software.

6. Shared Benefit: By sharing the code of open-source software, everyone can benefit from the hard work of the developers. This contributes to the overall advancement of technology, as users and developers work together to improve and build upon the software.

In summary, open-source software provides a collaborative platform that leads to high-quality, customizable, and transparent software, all available at little or no cost, benefiting both individuals and the technology community as a whole.<|im_end|>
`,nl,z,Kl='在幕后，TGI 的消息 API 自动使用其<a href="https://huggingface.co/docs/transformers/chat_templating" rel="nofollow">聊天模板</a>将消息列表转换为模型所需的指令格式。',pl,P,se="<em>注意：某些 OpenAI 功能，如函数调用，与 TGI 不兼容。目前，消息 API 支持以下 chat completion 参数：<code>stream</code>、<code>max_new_tokens</code>、<code>frequency_penalty</code>、<code>logprobs</code>、<code>seed</code>、<code>temperature</code> 和 <code>top_p</code>.</em>",ol,O,il,D,le='这里是与上面相同的流式示例，但是使用了<a href="https://github.com/openai/openai-node" rel="nofollow">OpenAI Javascript/Typescript 库</a>。',Ml,K,cl,Us,yl,ss,rl,ls,ee="现在，让我们看看如何将这个新创建的端点与像 LangChain 和 LlamaIndex 这样的流行 RAG 框架一起使用。",ml,es,hl,ts,te='要在 <a href="https://python.langchain.com/docs/get_started/introduction" rel="nofollow">LangChain</a> 中使用，只需创建一个 <code>ChatOpenAI</code> 的实例，并按如下方式传递你的 <code>&lt;ENDPOINT_URL&gt;</code> 和 <code>&lt;HF_API_TOKEN&gt;</code>：',Jl,as,jl,ns,ae="我们能够直接利用与 OpenAI 模型相同的 <code>ChatOpenAI</code> 类。这使得所有之前的代码只需更改一行代码，就能与我们的端点一起工作。",Tl,ps,ne="现在，让我们在简单的 RAG 流水线中使用我们的 Mixtral 模型，来回答一个关于 HF 博客内容的问题。",ul,os,dl,is,Ul,Ms,pe='类似地，你也可以在 <a href="https://www.llamaindex.ai/" rel="nofollow">LlamaIndex</a> 中使用 TGI 端点。我们将使用 <code>OpenAILike</code> 类，并通过配置一些额外的参数（即 <code>is_local</code>、<code>is_function_calling_model</code>、<code>is_chat_model</code>、<code>context_window</code>）来实例化它。',wl,cs,oe="<em>注意：上下文窗口参数应与之前为端点的 <code>MAX_TOTAL_TOKENS</code> 设置的值相匹配。</em>",bl,ys,gl,rs,ie="现在我们可以使用它在类似的 RAG 流水线中。请记住，之前在推理端点选择的 <code>MAX_INPUT_LENGTH</code> 将直接影响模型可以处理的检索到的数据块（<code>similarity_top_k</code>）的数量。",Il,ms,fl,hs,Bl,Js,Me="完成端点使用后，你可以暂停或删除它。这一步可以通过 UI 完成，或者像下面这样以编程方式完成。",Cl,js,Zl,Ts,Gl,bs,Wl;return u=new Te({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/tgi_messages_api_demo.ipynb"}]}}),d=new j({props:{title:"使用 TGI 的消息 API 从 OpenAI 迁移到 Open LLMs",local:"使用-tgi-的消息-api-从-openai-迁移到-open-llms",headingTag:"h1"}}),Z=new j({props:{title:"初始化设置",local:"初始化设置",headingTag:"h2"}}),W=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtcSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGxhbmdjaGFpbiUyMGxhbmdjaGFpbi1jb21tdW5pdHklMjBsYW5nY2hhaW5odWIlMjBsYW5nY2hhaW4tb3BlbmFpJTIwbGxhbWEtaW5kZXglMjBjaHJvbWFkYiUyMGJzNCUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMHRvcmNo",highlighted:"!pip install --upgrade -q huggingface_hub langchain langchain-community langchainhub langchain-openai llama-index chromadb bs4 sentence_transformers torch",wrap:!1}}),_=new J({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBnZXRwYXNzJTBBJTBBJTIzJTIwZW50ZXIlMjBBUEklMjBrZXklMEFvcy5lbnZpcm9uJTVCJTIySFVHR0lOR0ZBQ0VIVUJfQVBJX1RPS0VOJTIyJTVEJTIwJTNEJTIwSEZfQVBJX0tFWSUyMCUzRCUyMGdldHBhc3MuZ2V0cGFzcygp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> getpass

<span class="hljs-comment"># enter API key</span>
os.environ[<span class="hljs-string">&quot;HUGGINGFACEHUB_API_TOKEN&quot;</span>] = HF_API_KEY = getpass.getpass()`,wrap:!1}}),v=new j({props:{title:"1. 创建一个推理端点",local:"1-创建一个推理端点",headingTag:"h2"}}),E=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybm91cy1oZXJtZXMtMi1taXh0cmFsLTh4N2ItZGVtbyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJOb3VzUmVzZWFyY2glMkZOb3VzLUhlcm1lcy0yLU1peHRyYWwtOHg3Qi1EUE8lMjIlMkMlMEElMjAlMjAlMjAlMjBmcmFtZXdvcmslM0QlMjJweXRvcmNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yJTNEJTIyZ3B1JTIyJTJDJTBBJTIwJTIwJTIwJTIwdmVuZG9yJTNEJTIyYXdzJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVnaW9uJTNEJTIydXMtZWFzdC0xJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnByb3RlY3RlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX3R5cGUlM0QlMjJwNGRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMjJ4bGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21faW1hZ2UlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZWFsdGhfcm91dGUlMjIlM0ElMjAlMjIlMkZoZWFsdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfSU5QVVRfTEVOR1RIJTIyJTNBJTIwJTIyNDA5NiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1BWF9CQVRDSF9QUkVGSUxMX1RPS0VOUyUyMiUzQSUyMCUyMjQwOTYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMzIwMDAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTAyNDAwMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0FzaGEtMTczNDU0MCUyMiUyQyUyMCUyMCUyMyUyMG11c3QlMjBiZSUyMCUzRSUzRCUyMDEuNC4wJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBKSUwQSUwQWVuZHBvaW50LndhaXQoKSUwQXByaW50KGVuZHBvaW50LnN0YXR1cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;nous-hermes-2-mixtral-8x7b-demo&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;NousResearch/Nous-Hermes-2-Mixtral-8x7B-DPO&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;p4de&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;2xlarge&quot;</span>,
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;env&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;4096&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;4096&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;32000&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1024000&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>,
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:sha-1734540&quot;</span>,  <span class="hljs-comment"># must be &gt;= 1.4.0</span>
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(endpoint.status)`,wrap:!1}}),$=new j({props:{title:"2. 使用 OpenAI 客户端库查询推理端点",local:"2-使用-openai-客户端库查询推理端点",headingTag:"h2"}}),F=new j({props:{title:"使用 Python 客户端",local:"使用-python-客户端",headingTag:"h3"}}),q=new J({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQUJBU0VfVVJMJTIwJTNEJTIwZW5kcG9pbnQudXJsJTBBJTBBJTIzJTIwaW5pdCUyMHRoZSUyMGNsaWVudCUyMGJ1dCUyMHBvaW50JTIwaXQlMjB0byUyMFRHSSUwQWNsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRG9zLnBhdGguam9pbihCQVNFX1VSTCUyQyUyMCUyMnYxJTJGJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RIRl9BUElfS0VZJTJDJTBBKSUwQWNoYXRfY29tcGxldGlvbiUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMnRnaSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaHklMjBpcyUyMG9wZW4tc291cmNlJTIwc29mdHdhcmUlMjBpbXBvcnRhbnQlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDUwMCUyQyUwQSklMEElMEElMjMlMjBpdGVyYXRlJTIwYW5kJTIwcHJpbnQlMjBzdHJlYW0lMEFmb3IlMjBtZXNzYWdlJTIwaW4lMjBjaGF0X2NvbXBsZXRpb24lM0ElMEElMjAlMjAlMjAlMjBwcmludChtZXNzYWdlLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMkMlMjBlbmQlM0QlMjIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-meta">&gt;&gt;&gt; </span>BASE_URL = endpoint.url

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># init the client but point it to TGI</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = OpenAI(
<span class="hljs-meta">... </span>    base_url=os.path.join(BASE_URL, <span class="hljs-string">&quot;v1/&quot;</span>),
<span class="hljs-meta">... </span>    api_key=HF_API_KEY,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>chat_completion = client.chat.completions.create(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;tgi&quot;</span>,
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Why is open-source software important?&quot;</span>},
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    stream=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># iterate and print stream</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> chat_completion:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(message.choices[<span class="hljs-number">0</span>].delta.content, end=<span class="hljs-string">&quot;&quot;</span>)`,wrap:!1}}),O=new j({props:{title:"使用 JavaScript 客户端",local:"使用-javascript-客户端",headingTag:"h3"}}),K=new J({props:{code:"aW1wb3J0JTIwT3BlbkFJJTIwZnJvbSUyMCUyMm9wZW5haSUyMiUzQiUwQSUwQWNvbnN0JTIwb3BlbmFpJTIwJTNEJTIwbmV3JTIwT3BlbkFJKCU3QiUwQSUyMCUyMGJhc2VVUkwlM0ElMjAlMjIlM0NFTkRQT0lOVF9VUkwlM0UlMjIlMjAlMkIlMjAlMjIlMkZ2MSUyRiUyMiUyQyUyMCUyRiUyRiUyMHJlcGxhY2UlMjB3aXRoJTIweW91ciUyMGVuZHBvaW50JTIwdXJsJTBBJTIwJTIwYXBpS2V5JTNBJTIwJTIyJTNDSEZfQVBJX1RPS0VOJTNFJTIyJTJDJTIwJTJGJTJGJTIwcmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwdG9rZW4lMEElN0QpJTNCJTBBJTBBYXN5bmMlMjBmdW5jdGlvbiUyMG1haW4oKSUyMCU3QiUwQSUyMCUyMGNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwYXdhaXQlMjBvcGVuYWkuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTdCJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0ElMjAlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMHJvbGUlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjBjb250ZW50JTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwcm9sZSUzQSUyMCUyMnVzZXIlMjIlMkMlMjBjb250ZW50JTNBJTIwJTIyV2h5JTIwaXMlMjBvcGVuLXNvdXJjZSUyMHNvZnR3YXJlJTIwaW1wb3J0YW50JTNGJTIyJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0ElMjA1MDAlMkMlMEElMjAlMjAlN0QpJTNCJTBBJTIwJTIwZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwc3RyZWFtKSUyMCU3QiUwQSUyMCUyMCUyMCUyMHByb2Nlc3Muc3Rkb3V0LndyaXRlKGNodW5rLmNob2ljZXMlNUIwJTVEJTNGLmRlbHRhJTNGLmNvbnRlbnQlMjAlN0MlN0MlMjAlMjIlMjIpJTNCJTBBJTIwJTIwJTdEJTBBJTdEJTBBJTBBbWFpbigpJTNC",highlighted:`<span class="hljs-keyword">import</span> <span class="hljs-title class_">OpenAI</span> <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;openai&quot;</span>;

<span class="hljs-keyword">const</span> openai = <span class="hljs-keyword">new</span> <span class="hljs-title class_">OpenAI</span>({
  <span class="hljs-attr">baseURL</span>: <span class="hljs-string">&quot;&lt;ENDPOINT_URL&gt;&quot;</span> + <span class="hljs-string">&quot;/v1/&quot;</span>, <span class="hljs-comment">// replace with your endpoint url</span>
  <span class="hljs-attr">apiKey</span>: <span class="hljs-string">&quot;&lt;HF_API_TOKEN&gt;&quot;</span>, <span class="hljs-comment">// replace with your token</span>
});

<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">main</span>(<span class="hljs-params"></span>) {
  <span class="hljs-keyword">const</span> stream = <span class="hljs-keyword">await</span> openai.<span class="hljs-property">chat</span>.<span class="hljs-property">completions</span>.<span class="hljs-title function_">create</span>({
    <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;tgi&quot;</span>,
    <span class="hljs-attr">messages</span>: [
      { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
      { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Why is open-source software important?&quot;</span> },
    ],
    <span class="hljs-attr">stream</span>: <span class="hljs-literal">true</span>,
    <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">500</span>,
  });
  <span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> stream) {
    process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>]?.<span class="hljs-property">delta</span>?.<span class="hljs-property">content</span> || <span class="hljs-string">&quot;&quot;</span>);
  }
}

<span class="hljs-title function_">main</span>();`,wrap:!1}}),ss=new j({props:{title:"3. 与 LangChain 和 LlamaIndex 集成",local:"3-与-langchain-和-llamaindex-集成",headingTag:"h2"}}),es=new j({props:{title:"如何与 LangChain 一起使用",local:"如何与-langchain-一起使用",headingTag:"h3"}}),as=new J({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9vcGVuYWklMjBpbXBvcnQlMjBDaGF0T3BlbkFJJTBBJTBBbGxtJTIwJTNEJTIwQ2hhdE9wZW5BSSglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3BlbmFpX2FwaV9rZXklM0RIRl9BUElfS0VZJTJDJTBBJTIwJTIwJTIwJTIwb3BlbmFpX2FwaV9iYXNlJTNEb3MucGF0aC5qb2luKEJBU0VfVVJMJTJDJTIwJTIydjElMkYlMjIpJTJDJTBBKSUwQWxsbS5pbnZva2UoJTIyV2h5JTIwaXMlMjBvcGVuLXNvdXJjZSUyMHNvZnR3YXJlJTIwaW1wb3J0YW50JTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI

llm = ChatOpenAI(
    model_name=<span class="hljs-string">&quot;tgi&quot;</span>,
    openai_api_key=HF_API_KEY,
    openai_api_base=os.path.join(BASE_URL, <span class="hljs-string">&quot;v1/&quot;</span>),
)
llm.invoke(<span class="hljs-string">&quot;Why is open-source software important?&quot;</span>)`,wrap:!1}}),os=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain <span class="hljs-keyword">import</span> hub
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain_community.document_loaders <span class="hljs-keyword">import</span> WebBaseLoader
<span class="hljs-keyword">from</span> langchain_community.vectorstores <span class="hljs-keyword">import</span> Chroma
<span class="hljs-keyword">from</span> langchain_core.output_parsers <span class="hljs-keyword">import</span> StrOutputParser
<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnablePassthrough
<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnableParallel
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

<span class="hljs-comment"># Load, chunk and index the contents of the blog</span>
loader = WebBaseLoader(
    web_paths=(<span class="hljs-string">&quot;https://huggingface.co/blog/open-source-llms-as-agents&quot;</span>,),
)
docs = loader.load()

<span class="hljs-comment"># declare an HF embedding model</span>
hf_embeddings = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;BAAI/bge-large-en-v1.5&quot;</span>)

text_splitter = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">512</span>, chunk_overlap=<span class="hljs-number">200</span>)
splits = text_splitter.split_documents(docs)
vectorstore = Chroma.from_documents(documents=splits, embedding=hf_embeddings)

<span class="hljs-comment"># Retrieve and generate using the relevant snippets of the blog</span>
retriever = vectorstore.as_retriever()
prompt = hub.pull(<span class="hljs-string">&quot;rlm/rag-prompt&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_docs</span>(<span class="hljs-params">docs</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join(doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs)


rag_chain_from_docs = (
    RunnablePassthrough.assign(context=(<span class="hljs-keyword">lambda</span> x: format_docs(x[<span class="hljs-string">&quot;context&quot;</span>]))) | prompt | llm | StrOutputParser()
)

rag_chain_with_source = RunnableParallel({<span class="hljs-string">&quot;context&quot;</span>: retriever, <span class="hljs-string">&quot;question&quot;</span>: RunnablePassthrough()}).assign(
    answer=rag_chain_from_docs
)

rag_chain_with_source.invoke(<span class="hljs-string">&quot;According to this article which open-source model is the best for an agent behaviour?&quot;</span>)`,wrap:!1}}),is=new j({props:{title:"如何与 LlamaIndex 一起使用",local:"如何与-llamaindex-一起使用",headingTag:"h3"}}),ys=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMlMjBpbXBvcnQlMjBPcGVuQUlMaWtlJTBBJTBBbGxtJTIwJTNEJTIwT3BlbkFJTGlrZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMnRnaSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RIRl9BUElfS0VZJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2Jhc2UlM0RCQVNFX1VSTCUyMCUyQiUyMCUyMiUyRnYxJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXNfY2hhdF9tb2RlbCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBpc19sb2NhbCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwaXNfZnVuY3Rpb25fY2FsbGluZ19tb2RlbCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dF93aW5kb3clM0Q0MDk2JTJDJTBBKSUwQSUwQWxsbS5jb21wbGV0ZSglMjJXaHklMjBpcyUyMG9wZW4tc291cmNlJTIwc29mdHdhcmUlMjBpbXBvcnRhbnQlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms <span class="hljs-keyword">import</span> OpenAILike

llm = OpenAILike(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    api_key=HF_API_KEY,
    api_base=BASE_URL + <span class="hljs-string">&quot;/v1/&quot;</span>,
    is_chat_model=<span class="hljs-literal">True</span>,
    is_local=<span class="hljs-literal">False</span>,
    is_function_calling_model=<span class="hljs-literal">False</span>,
    context_window=<span class="hljs-number">4096</span>,
)

llm.complete(<span class="hljs-string">&quot;Why is open-source software important?&quot;</span>)`,wrap:!1}}),ms=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4JTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMFNlcnZpY2VDb250ZXh0JTJDJTBBJTIwJTIwJTIwJTIwVmVjdG9yU3RvcmVJbmRleCUyQyUwQSklMEFmcm9tJTIwbGxhbWFfaW5kZXglMjBpbXBvcnQlMjBkb3dubG9hZF9sb2FkZXIlMEFmcm9tJTIwbGxhbWFfaW5kZXguZW1iZWRkaW5ncyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5nJTBBZnJvbSUyMGxsYW1hX2luZGV4LnF1ZXJ5X2VuZ2luZSUyMGltcG9ydCUyMENpdGF0aW9uUXVlcnlFbmdpbmUlMEElMEElMEFTaW1wbGVXZWJQYWdlUmVhZGVyJTIwJTNEJTIwZG93bmxvYWRfbG9hZGVyKCUyMlNpbXBsZVdlYlBhZ2VSZWFkZXIlMjIpJTBBJTBBZG9jdW1lbnRzJTIwJTNEJTIwU2ltcGxlV2ViUGFnZVJlYWRlcihodG1sX3RvX3RleHQlM0RUcnVlKS5sb2FkX2RhdGEoJTBBJTIwJTIwJTIwJTIwJTVCJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmJsb2clMkZvcGVuLXNvdXJjZS1sbG1zLWFzLWFnZW50cyUyMiU1RCUwQSklMEElMEElMjMlMjBMb2FkJTIwZW1iZWRkaW5nJTIwbW9kZWwlMEFlbWJlZF9tb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLWxhcmdlLWVuLXYxLjUlMjIpJTBBJTBBJTIzJTIwUGFzcyUyMExMTSUyMHRvJTIwcGlwZWxpbmUlMEFzZXJ2aWNlX2NvbnRleHQlMjAlM0QlMjBTZXJ2aWNlQ29udGV4dC5mcm9tX2RlZmF1bHRzKGVtYmVkX21vZGVsJTNEZW1iZWRfbW9kZWwlMkMlMjBsbG0lM0RsbG0pJTBBaW5kZXglMjAlM0QlMjBWZWN0b3JTdG9yZUluZGV4LmZyb21fZG9jdW1lbnRzKGRvY3VtZW50cyUyQyUyMHNlcnZpY2VfY29udGV4dCUzRHNlcnZpY2VfY29udGV4dCUyQyUyMHNob3dfcHJvZ3Jlc3MlM0RUcnVlKSUwQSUwQSUyMyUyMFF1ZXJ5JTIwdGhlJTIwaW5kZXglMEFxdWVyeV9lbmdpbmUlMjAlM0QlMjBDaXRhdGlvblF1ZXJ5RW5naW5lLmZyb21fYXJncyglMEElMjAlMjAlMjAlMjBpbmRleCUyQyUwQSUyMCUyMCUyMCUyMHNpbWlsYXJpdHlfdG9wX2slM0QyJTJDJTBBKSUwQXJlc3BvbnNlJTIwJTNEJTIwcXVlcnlfZW5naW5lLnF1ZXJ5KCUyMkFjY29yZGluZyUyMHRvJTIwdGhpcyUyMGFydGljbGUlMjB3aGljaCUyMG9wZW4tc291cmNlJTIwbW9kZWwlMjBpcyUyMHRoZSUyMGJlc3QlMjBmb3IlMjBhbiUyMGFnZW50JTIwYmVoYXZpb3VyJTNGJTIyKSUwQSUwQXJlc3BvbnNlLnJlc3BvbnNl",highlighted:`<span class="hljs-keyword">from</span> llama_index <span class="hljs-keyword">import</span> (
    ServiceContext,
    VectorStoreIndex,
)
<span class="hljs-keyword">from</span> llama_index <span class="hljs-keyword">import</span> download_loader
<span class="hljs-keyword">from</span> llama_index.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbedding
<span class="hljs-keyword">from</span> llama_index.query_engine <span class="hljs-keyword">import</span> CitationQueryEngine


SimpleWebPageReader = download_loader(<span class="hljs-string">&quot;SimpleWebPageReader&quot;</span>)

documents = SimpleWebPageReader(html_to_text=<span class="hljs-literal">True</span>).load_data(
    [<span class="hljs-string">&quot;https://huggingface.co/blog/open-source-llms-as-agents&quot;</span>]
)

<span class="hljs-comment"># Load embedding model</span>
embed_model = HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-large-en-v1.5&quot;</span>)

<span class="hljs-comment"># Pass LLM to pipeline</span>
service_context = ServiceContext.from_defaults(embed_model=embed_model, llm=llm)
index = VectorStoreIndex.from_documents(documents, service_context=service_context, show_progress=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Query the index</span>
query_engine = CitationQueryEngine.from_args(
    index,
    similarity_top_k=<span class="hljs-number">2</span>,
)
response = query_engine.query(<span class="hljs-string">&quot;According to this article which open-source model is the best for an agent behaviour?&quot;</span>)

response.response`,wrap:!1}}),hs=new j({props:{title:"总结",local:"总结",headingTag:"h2"}}),js=new J({props:{code:"JTIzJTIwcGF1c2UlMjBvdXIlMjBydW5uaW5nJTIwZW5kcG9pbnQlMEFlbmRwb2ludC5wYXVzZSgpJTBBJTBBJTIzJTIwb3B0aW9uYWxseSUyMGRlbGV0ZSUwQSUyMyUyMGVuZHBvaW50LmRlbGV0ZSgp",highlighted:`<span class="hljs-comment"># pause our running endpoint</span>
endpoint.pause()

<span class="hljs-comment"># optionally delete</span>
<span class="hljs-comment"># endpoint.delete()</span>`,wrap:!1}}),Ts=new ue({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/tgi_messages_api_demo.md"}}),{c(){T=p("meta"),fs=a(),ws=p("p"),Bs=a(),M(u.$$.fragment),Cs=a(),M(d.$$.fragment),Zs=a(),U=p("p"),U.innerHTML=vl,Gs=a(),w=p("p"),w.textContent=Rl,Ws=a(),b=p("p"),b.innerHTML=kl,_s=a(),g=p("p"),g.textContent=Al,vs=a(),I=p("ul"),I.innerHTML=El,Rs=a(),f=p("p"),f.textContent=Nl,ks=a(),B=p("ol"),B.innerHTML=Vl,As=a(),C=p("p"),C.innerHTML=Xl,Es=a(),M(Z.$$.fragment),Ns=a(),G=p("p"),G.textContent=xl,Vs=a(),M(W.$$.fragment),Xs=a(),M(_.$$.fragment),xs=a(),us=p("a"),Qs=a(),M(v.$$.fragment),$s=a(),R=p("p"),R.innerHTML=Ql,Ss=a(),k=p("p"),k.innerHTML=$l,Fs=a(),A=p("p"),A.innerHTML=Sl,Ys=a(),M(E.$$.fragment),Hs=a(),N=p("pre"),N.textContent=Fl,qs=a(),V=p("p"),V.innerHTML=Yl,Ls=a(),X=p("p"),X.innerHTML=Hl,zs=a(),x=p("p"),x.textContent=ql,Ps=a(),Q=p("p"),Q.innerHTML=Ll,Os=a(),ds=p("a"),Ds=a(),M($.$$.fragment),Ks=a(),S=p("p"),S.textContent=zl,sl=a(),M(F.$$.fragment),ll=a(),Y=p("p"),Y.innerHTML=Pl,el=a(),H=p("p"),H.textContent=Ol,tl=a(),M(q.$$.fragment),al=a(),L=p("pre"),L.textContent=Dl,nl=a(),z=p("p"),z.innerHTML=Kl,pl=a(),P=p("p"),P.innerHTML=se,ol=a(),M(O.$$.fragment),il=a(),D=p("p"),D.innerHTML=le,Ml=a(),M(K.$$.fragment),cl=a(),Us=p("a"),yl=a(),M(ss.$$.fragment),rl=a(),ls=p("p"),ls.textContent=ee,ml=a(),M(es.$$.fragment),hl=a(),ts=p("p"),ts.innerHTML=te,Jl=a(),M(as.$$.fragment),jl=a(),ns=p("p"),ns.innerHTML=ae,Tl=a(),ps=p("p"),ps.textContent=ne,ul=a(),M(os.$$.fragment),dl=a(),M(is.$$.fragment),Ul=a(),Ms=p("p"),Ms.innerHTML=pe,wl=a(),cs=p("p"),cs.innerHTML=oe,bl=a(),M(ys.$$.fragment),gl=a(),rs=p("p"),rs.innerHTML=ie,Il=a(),M(ms.$$.fragment),fl=a(),M(hs.$$.fragment),Bl=a(),Js=p("p"),Js.textContent=Me,Cl=a(),M(js.$$.fragment),Zl=a(),M(Ts.$$.fragment),Gl=a(),bs=p("p"),this.h()},l(s){const l=Je("svelte-u9bgzb",document.head);T=o(l,"META",{name:!0,content:!0}),l.forEach(e),fs=n(s),ws=o(s,"P",{}),gs(ws).forEach(e),Bs=n(s),c(u.$$.fragment,s),Cs=n(s),c(d.$$.fragment,s),Zs=n(s),U=o(s,"P",{"data-svelte-h":!0}),i(U)!=="svelte-gj6lv3"&&(U.innerHTML=vl),Gs=n(s),w=o(s,"P",{"data-svelte-h":!0}),i(w)!=="svelte-gvqzpn"&&(w.textContent=Rl),Ws=n(s),b=o(s,"P",{"data-svelte-h":!0}),i(b)!=="svelte-tx3r7i"&&(b.innerHTML=kl),_s=n(s),g=o(s,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1m0fhjl"&&(g.textContent=Al),vs=n(s),I=o(s,"UL",{"data-svelte-h":!0}),i(I)!=="svelte-9taer4"&&(I.innerHTML=El),Rs=n(s),f=o(s,"P",{"data-svelte-h":!0}),i(f)!=="svelte-wrnr8s"&&(f.textContent=Nl),ks=n(s),B=o(s,"OL",{"data-svelte-h":!0}),i(B)!=="svelte-7jcplu"&&(B.innerHTML=Vl),As=n(s),C=o(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1g5cpqq"&&(C.innerHTML=Xl),Es=n(s),c(Z.$$.fragment,s),Ns=n(s),G=o(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-dpvmsr"&&(G.textContent=xl),Vs=n(s),c(W.$$.fragment,s),Xs=n(s),c(_.$$.fragment,s),xs=n(s),us=o(s,"A",{id:!0}),gs(us).forEach(e),Qs=n(s),c(v.$$.fragment,s),$s=n(s),R=o(s,"P",{"data-svelte-h":!0}),i(R)!=="svelte-hqnmm4"&&(R.innerHTML=Ql),Ss=n(s),k=o(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-11y3s3v"&&(k.innerHTML=$l),Fs=n(s),A=o(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-11oqr2t"&&(A.innerHTML=Sl),Ys=n(s),c(E.$$.fragment,s),Hs=n(s),N=o(s,"PRE",{"data-svelte-h":!0}),i(N)!=="svelte-105t8kl"&&(N.textContent=Fl),qs=n(s),V=o(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-btosjl"&&(V.innerHTML=Yl),Ls=n(s),X=o(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-8mpmx4"&&(X.innerHTML=Hl),zs=n(s),x=o(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-wekg0z"&&(x.textContent=ql),Ps=n(s),Q=o(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-8b7wws"&&(Q.innerHTML=Ll),Os=n(s),ds=o(s,"A",{id:!0}),gs(ds).forEach(e),Ds=n(s),c($.$$.fragment,s),Ks=n(s),S=o(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1b0mawc"&&(S.textContent=zl),sl=n(s),c(F.$$.fragment,s),ll=n(s),Y=o(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-jfegsc"&&(Y.innerHTML=Pl),el=n(s),H=o(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-fn3u1g"&&(H.textContent=Ol),tl=n(s),c(q.$$.fragment,s),al=n(s),L=o(s,"PRE",{"data-svelte-h":!0}),i(L)!=="svelte-1gevisn"&&(L.textContent=Dl),nl=n(s),z=o(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-10twgq8"&&(z.innerHTML=Kl),pl=n(s),P=o(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-14nrlto"&&(P.innerHTML=se),ol=n(s),c(O.$$.fragment,s),il=n(s),D=o(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1if4f8u"&&(D.innerHTML=le),Ml=n(s),c(K.$$.fragment,s),cl=n(s),Us=o(s,"A",{id:!0}),gs(Us).forEach(e),yl=n(s),c(ss.$$.fragment,s),rl=n(s),ls=o(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-15wg5yj"&&(ls.textContent=ee),ml=n(s),c(es.$$.fragment,s),hl=n(s),ts=o(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-1pjk2if"&&(ts.innerHTML=te),Jl=n(s),c(as.$$.fragment,s),jl=n(s),ns=o(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-1mgsk2v"&&(ns.innerHTML=ae),Tl=n(s),ps=o(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-1u6vict"&&(ps.textContent=ne),ul=n(s),c(os.$$.fragment,s),dl=n(s),c(is.$$.fragment,s),Ul=n(s),Ms=o(s,"P",{"data-svelte-h":!0}),i(Ms)!=="svelte-1s6qa1c"&&(Ms.innerHTML=pe),wl=n(s),cs=o(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-1auj9mh"&&(cs.innerHTML=oe),bl=n(s),c(ys.$$.fragment,s),gl=n(s),rs=o(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-e01zk6"&&(rs.innerHTML=ie),Il=n(s),c(ms.$$.fragment,s),fl=n(s),c(hs.$$.fragment,s),Bl=n(s),Js=o(s,"P",{"data-svelte-h":!0}),i(Js)!=="svelte-exd6y8"&&(Js.textContent=Me),Cl=n(s),c(js.$$.fragment,s),Zl=n(s),c(Ts.$$.fragment,s),Gl=n(s),bs=o(s,"P",{}),gs(bs).forEach(e),this.h()},h(){Is(T,"name","hf:doc:metadata"),Is(T,"content",Ue),Is(us,"id","section_1"),Is(ds,"id","section_2"),Is(Us,"id","section_3")},m(s,l){je(document.head,T),t(s,fs,l),t(s,ws,l),t(s,Bs,l),y(u,s,l),t(s,Cs,l),y(d,s,l),t(s,Zs,l),t(s,U,l),t(s,Gs,l),t(s,w,l),t(s,Ws,l),t(s,b,l),t(s,_s,l),t(s,g,l),t(s,vs,l),t(s,I,l),t(s,Rs,l),t(s,f,l),t(s,ks,l),t(s,B,l),t(s,As,l),t(s,C,l),t(s,Es,l),y(Z,s,l),t(s,Ns,l),t(s,G,l),t(s,Vs,l),y(W,s,l),t(s,Xs,l),y(_,s,l),t(s,xs,l),t(s,us,l),t(s,Qs,l),y(v,s,l),t(s,$s,l),t(s,R,l),t(s,Ss,l),t(s,k,l),t(s,Fs,l),t(s,A,l),t(s,Ys,l),y(E,s,l),t(s,Hs,l),t(s,N,l),t(s,qs,l),t(s,V,l),t(s,Ls,l),t(s,X,l),t(s,zs,l),t(s,x,l),t(s,Ps,l),t(s,Q,l),t(s,Os,l),t(s,ds,l),t(s,Ds,l),y($,s,l),t(s,Ks,l),t(s,S,l),t(s,sl,l),y(F,s,l),t(s,ll,l),t(s,Y,l),t(s,el,l),t(s,H,l),t(s,tl,l),y(q,s,l),t(s,al,l),t(s,L,l),t(s,nl,l),t(s,z,l),t(s,pl,l),t(s,P,l),t(s,ol,l),y(O,s,l),t(s,il,l),t(s,D,l),t(s,Ml,l),y(K,s,l),t(s,cl,l),t(s,Us,l),t(s,yl,l),y(ss,s,l),t(s,rl,l),t(s,ls,l),t(s,ml,l),y(es,s,l),t(s,hl,l),t(s,ts,l),t(s,Jl,l),y(as,s,l),t(s,jl,l),t(s,ns,l),t(s,Tl,l),t(s,ps,l),t(s,ul,l),y(os,s,l),t(s,dl,l),y(is,s,l),t(s,Ul,l),t(s,Ms,l),t(s,wl,l),t(s,cs,l),t(s,bl,l),y(ys,s,l),t(s,gl,l),t(s,rs,l),t(s,Il,l),y(ms,s,l),t(s,fl,l),y(hs,s,l),t(s,Bl,l),t(s,Js,l),t(s,Cl,l),y(js,s,l),t(s,Zl,l),y(Ts,s,l),t(s,Gl,l),t(s,bs,l),Wl=!0},p:ye,i(s){Wl||(r(u.$$.fragment,s),r(d.$$.fragment,s),r(Z.$$.fragment,s),r(W.$$.fragment,s),r(_.$$.fragment,s),r(v.$$.fragment,s),r(E.$$.fragment,s),r($.$$.fragment,s),r(F.$$.fragment,s),r(q.$$.fragment,s),r(O.$$.fragment,s),r(K.$$.fragment,s),r(ss.$$.fragment,s),r(es.$$.fragment,s),r(as.$$.fragment,s),r(os.$$.fragment,s),r(is.$$.fragment,s),r(ys.$$.fragment,s),r(ms.$$.fragment,s),r(hs.$$.fragment,s),r(js.$$.fragment,s),r(Ts.$$.fragment,s),Wl=!0)},o(s){m(u.$$.fragment,s),m(d.$$.fragment,s),m(Z.$$.fragment,s),m(W.$$.fragment,s),m(_.$$.fragment,s),m(v.$$.fragment,s),m(E.$$.fragment,s),m($.$$.fragment,s),m(F.$$.fragment,s),m(q.$$.fragment,s),m(O.$$.fragment,s),m(K.$$.fragment,s),m(ss.$$.fragment,s),m(es.$$.fragment,s),m(as.$$.fragment,s),m(os.$$.fragment,s),m(is.$$.fragment,s),m(ys.$$.fragment,s),m(ms.$$.fragment,s),m(hs.$$.fragment,s),m(js.$$.fragment,s),m(Ts.$$.fragment,s),Wl=!1},d(s){s&&(e(fs),e(ws),e(Bs),e(Cs),e(Zs),e(U),e(Gs),e(w),e(Ws),e(b),e(_s),e(g),e(vs),e(I),e(Rs),e(f),e(ks),e(B),e(As),e(C),e(Es),e(Ns),e(G),e(Vs),e(Xs),e(xs),e(us),e(Qs),e($s),e(R),e(Ss),e(k),e(Fs),e(A),e(Ys),e(Hs),e(N),e(qs),e(V),e(Ls),e(X),e(zs),e(x),e(Ps),e(Q),e(Os),e(ds),e(Ds),e(Ks),e(S),e(sl),e(ll),e(Y),e(el),e(H),e(tl),e(al),e(L),e(nl),e(z),e(pl),e(P),e(ol),e(il),e(D),e(Ml),e(cl),e(Us),e(yl),e(rl),e(ls),e(ml),e(hl),e(ts),e(Jl),e(jl),e(ns),e(Tl),e(ps),e(ul),e(dl),e(Ul),e(Ms),e(wl),e(cs),e(bl),e(gl),e(rs),e(Il),e(fl),e(Bl),e(Js),e(Cl),e(Zl),e(Gl),e(bs)),e(T),h(u,s),h(d,s),h(Z,s),h(W,s),h(_,s),h(v,s),h(E,s),h($,s),h(F,s),h(q,s),h(O,s),h(K,s),h(ss,s),h(es,s),h(as,s),h(os,s),h(is,s),h(ys,s),h(ms,s),h(hs,s),h(js,s),h(Ts,s)}}}const Ue='{"title":"使用 TGI 的消息 API 从 OpenAI 迁移到 Open LLMs","local":"使用-tgi-的消息-api-从-openai-迁移到-open-llms","sections":[{"title":"初始化设置","local":"初始化设置","sections":[],"depth":2},{"title":"1. 创建一个推理端点","local":"1-创建一个推理端点","sections":[],"depth":2},{"title":"2. 使用 OpenAI 客户端库查询推理端点","local":"2-使用-openai-客户端库查询推理端点","sections":[{"title":"使用 Python 客户端","local":"使用-python-客户端","sections":[],"depth":3},{"title":"使用 JavaScript 客户端","local":"使用-javascript-客户端","sections":[],"depth":3}],"depth":2},{"title":"3. 与 LangChain 和 LlamaIndex 集成","local":"3-与-langchain-和-llamaindex-集成","sections":[{"title":"如何与 LangChain 一起使用","local":"如何与-langchain-一起使用","sections":[],"depth":3},{"title":"如何与 LlamaIndex 一起使用","local":"如何与-llamaindex-一起使用","sections":[],"depth":3}],"depth":2},{"title":"总结","local":"总结","sections":[],"depth":2}],"depth":1}';function we(_l){return re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Be extends me{constructor(T){super(),he(this,T,we,de,ce,{})}}export{Be as component};
