import{s as hl,o as wl,n as A}from"../chunks/scheduler.182ea377.js";import{S as Jl,i as Ul,g as M,s as i,r as d,A as Tl,h as u,f as l,c as o,j as fl,u as y,x as m,k as dl,y as bl,a as s,v as h,d as w,t as J,w as U}from"../chunks/index.abf12888.js";import{T as vt}from"../chunks/Tip.230e2334.js";import{C as j}from"../chunks/CodeBlock.57fe6e13.js";import{H as We}from"../chunks/Heading.16916d63.js";import{H as yl,a as Nt}from"../chunks/HfOption.fc88c804.js";function _l(_){let a,p='🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.';return{c(){a=M("p"),a.innerHTML=p},l(n){a=u(n,"P",{"data-svelte-h":!0}),m(a)!=="svelte-1qbiqsn"&&(a.innerHTML=p)},m(n,c){s(n,a,c)},p:A,d(n){n&&l(a)}}}function jl(_){let a,p='The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/custom_diffusion/train_custom_diffusion.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.';return{c(){a=M("p"),a.innerHTML=p},l(n){a=u(n,"P",{"data-svelte-h":!0}),m(a)!=="svelte-lc7164"&&(a.innerHTML=p)},m(n,c){s(n,a,c)},p:A,d(n){n&&l(a)}}}function Cl(_){let a,p='A lot of the code in the Custom Diffusion training script is similar to the <a href="dreambooth#training-script">DreamBooth</a> script. This guide instead focuses on the code that is relevant to Custom Diffusion.';return{c(){a=M("p"),a.innerHTML=p},l(n){a=u(n,"P",{"data-svelte-h":!0}),m(a)!=="svelte-17hnobu"&&(a.innerHTML=p)},m(n,c){s(n,a,c)},p:A,d(n){n&&l(a)}}}function gl(_){let a,p="If you’re training on human faces, the Custom Diffusion team has found the following parameters to work well:",n,c,r="<li><code>--learning_rate=5e-6</code></li> <li><code>--max_train_steps</code> can be anywhere between 1000 and 2000</li> <li><code>--freeze_model=crossattn</code></li> <li>use at least 15-20 images to train with</li>";return{c(){a=M("p"),a.textContent=p,n=i(),c=M("ul"),c.innerHTML=r},l(f){a=u(f,"P",{"data-svelte-h":!0}),m(a)!=="svelte-1nab0gg"&&(a.textContent=p),n=o(f),c=u(f,"UL",{"data-svelte-h":!0}),m(c)!=="svelte-1a7julv"&&(c.innerHTML=r)},m(f,b){s(f,a,b),s(f,n,b),s(f,c,b)},p:A,d(f){f&&(l(a),l(n),l(c))}}}function $l(_){let a,p;return a=new j({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aC10by1zYXZlLW1vZGVsJTIyJTBBZXhwb3J0JTIwSU5TVEFOQ0VfRElSJTNEJTIyLiUyRmRhdGElMkZjYXQlMjIlMEElMEFhY2NlbGVyYXRlJTIwbGF1bmNoJTIwdHJhaW5fY3VzdG9tX2RpZmZ1c2lvbi5weSUyMCU1QyUwQSUyMCUyMC0tcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0QlMjRNT0RFTF9OQU1FJTIwJTIwJTVDJTBBJTIwJTIwLS1pbnN0YW5jZV9kYXRhX2RpciUzRCUyNElOU1RBTkNFX0RJUiUyMCU1QyUwQSUyMCUyMC0tb3V0cHV0X2RpciUzRCUyNE9VVFBVVF9ESVIlMjAlNUMlMEElMjAlMjAtLWNsYXNzX2RhdGFfZGlyJTNELiUyRnJlYWxfcmVnJTJGc2FtcGxlc19jYXQlMkYlMjAlNUMlMEElMjAlMjAtLXdpdGhfcHJpb3JfcHJlc2VydmF0aW9uJTIwJTVDJTBBJTIwJTIwLS1yZWFsX3ByaW9yJTIwJTVDJTBBJTIwJTIwLS1wcmlvcl9sb3NzX3dlaWdodCUzRDEuMCUyMCU1QyUwQSUyMCUyMC0tY2xhc3NfcHJvbXB0JTNEJTIyY2F0JTIyJTIwJTVDJTBBJTIwJTIwLS1udW1fY2xhc3NfaW1hZ2VzJTNEMjAwJTIwJTVDJTBBJTIwJTIwLS1pbnN0YW5jZV9wcm9tcHQlM0QlMjJwaG90byUyMG9mJTIwYSUyMCUzQ25ldzElM0UlMjBjYXQlMjIlMjAlMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAlMjAlNUMlMEElMjAlMjAtLXRyYWluX2JhdGNoX3NpemUlM0QyJTIwJTIwJTVDJTBBJTIwJTIwLS1sZWFybmluZ19yYXRlJTNEMWUtNSUyMCUyMCU1QyUwQSUyMCUyMC0tbHJfd2FybXVwX3N0ZXBzJTNEMCUyMCU1QyUwQSUyMCUyMC0tbWF4X3RyYWluX3N0ZXBzJTNEMjUwJTIwJTVDJTBBJTIwJTIwLS1zY2FsZV9sciUyMCU1QyUwQSUyMCUyMC0taGZsaXAlMjAlMjAlNUMlMEElMjAlMjAtLW1vZGlmaWVyX3Rva2VuJTIwJTIyJTNDbmV3MSUzRSUyMiUyMCU1QyUwQSUyMCUyMC0tdmFsaWRhdGlvbl9wcm9tcHQlM0QlMjIlM0NuZXcxJTNFJTIwY2F0JTIwc2l0dGluZyUyMGluJTIwYSUyMGJ1Y2tldCUyMiUyMCU1QyUwQSUyMCUyMC0tcmVwb3J0X3RvJTNEJTIyd2FuZGIlMjIlMjAlNUMlMEElMjAlMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path-to-save-model&quot;</span>
<span class="hljs-built_in">export</span> INSTANCE_DIR=<span class="hljs-string">&quot;./data/cat&quot;</span>

accelerate launch train_custom_diffusion.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span>  \\
  --instance_data_dir=<span class="hljs-variable">$INSTANCE_DIR</span> \\
  --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
  --class_data_dir=./real_reg/samples_cat/ \\
  --with_prior_preservation \\
  --real_prior \\
  --prior_loss_weight=1.0 \\
  --class_prompt=<span class="hljs-string">&quot;cat&quot;</span> \\
  --num_class_images=200 \\
  --instance_prompt=<span class="hljs-string">&quot;photo of a &lt;new1&gt; cat&quot;</span>  \\
  --resolution=512  \\
  --train_batch_size=2  \\
  --learning_rate=1e-5  \\
  --lr_warmup_steps=0 \\
  --max_train_steps=250 \\
  --scale_lr \\
  --hflip  \\
  --modifier_token <span class="hljs-string">&quot;&lt;new1&gt;&quot;</span> \\
  --validation_prompt=<span class="hljs-string">&quot;&lt;new1&gt; cat sitting in a bucket&quot;</span> \\
  --report_to=<span class="hljs-string">&quot;wandb&quot;</span> \\
  --push_to_hub`,wrap:!1}}),{c(){d(a.$$.fragment)},l(n){y(a.$$.fragment,n)},m(n,c){h(a,n,c),p=!0},p:A,i(n){p||(w(a.$$.fragment,n),p=!0)},o(n){J(a.$$.fragment,n),p=!1},d(n){U(a,n)}}}function Il(_){let a,p='Custom Diffusion can also learn multiple concepts if you provide a <a href="https://github.com/adobe-research/custom-diffusion/blob/main/assets/concept_list.json" rel="nofollow">JSON</a> file with some details about each concept it should learn.',n,c,r="Run clip-retrieval to collect some real images to use for regularization:",f,b,g,$,X="Then you can launch the script:",k,I,Z;return b=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMGNsaXAtcmV0cmlldmFsJTBBcHl0aG9uJTIwcmV0cmlldmUucHklMjAtLWNsYXNzX3Byb21wdCUyMCU3QiU3RCUyMC0tY2xhc3NfZGF0YV9kaXIlMjAlN0IlN0QlMjAtLW51bV9jbGFzc19pbWFnZXMlMjAyMDA=",highlighted:`pip install clip-retrieval
python retrieve.py --class_prompt {} --class_data_dir {} --num_class_images 200`,wrap:!1}}),I=new j({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aC10by1zYXZlLW1vZGVsJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2N1c3RvbV9kaWZmdXNpb24ucHklMjAlNUMlMEElMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCUyMCU1QyUwQSUyMCUyMC0tb3V0cHV0X2RpciUzRCUyNE9VVFBVVF9ESVIlMjAlNUMlMEElMjAlMjAtLWNvbmNlcHRzX2xpc3QlM0QuJTJGY29uY2VwdF9saXN0Lmpzb24lMjAlNUMlMEElMjAlMjAtLXdpdGhfcHJpb3JfcHJlc2VydmF0aW9uJTIwJTVDJTBBJTIwJTIwLS1yZWFsX3ByaW9yJTIwJTVDJTBBJTIwJTIwLS1wcmlvcl9sb3NzX3dlaWdodCUzRDEuMCUyMCU1QyUwQSUyMCUyMC0tcmVzb2x1dGlvbiUzRDUxMiUyMCUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDIlMjAlMjAlNUMlMEElMjAlMjAtLWxlYXJuaW5nX3JhdGUlM0QxZS01JTIwJTIwJTVDJTBBJTIwJTIwLS1scl93YXJtdXBfc3RlcHMlM0QwJTIwJTVDJTBBJTIwJTIwLS1tYXhfdHJhaW5fc3RlcHMlM0Q1MDAlMjAlNUMlMEElMjAlMjAtLW51bV9jbGFzc19pbWFnZXMlM0QyMDAlMjAlNUMlMEElMjAlMjAtLXNjYWxlX2xyJTIwJTVDJTBBJTIwJTIwLS1oZmxpcCUyMCUyMCU1QyUwQSUyMCUyMC0tbW9kaWZpZXJfdG9rZW4lMjAlMjIlM0NuZXcxJTNFJTJCJTNDbmV3MiUzRSUyMiUyMCU1QyUwQSUyMCUyMC0tcHVzaF90b19odWI=",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path-to-save-model&quot;</span>

accelerate launch train_custom_diffusion.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span>  \\
  --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
  --concepts_list=./concept_list.json \\
  --with_prior_preservation \\
  --real_prior \\
  --prior_loss_weight=1.0 \\
  --resolution=512  \\
  --train_batch_size=2  \\
  --learning_rate=1e-5  \\
  --lr_warmup_steps=0 \\
  --max_train_steps=500 \\
  --num_class_images=200 \\
  --scale_lr \\
  --hflip  \\
  --modifier_token <span class="hljs-string">&quot;&lt;new1&gt;+&lt;new2&gt;&quot;</span> \\
  --push_to_hub`,wrap:!1}}),{c(){a=M("p"),a.innerHTML=p,n=i(),c=M("p"),c.textContent=r,f=i(),d(b.$$.fragment),g=i(),$=M("p"),$.textContent=X,k=i(),d(I.$$.fragment)},l(T){a=u(T,"P",{"data-svelte-h":!0}),m(a)!=="svelte-dc1va4"&&(a.innerHTML=p),n=o(T),c=u(T,"P",{"data-svelte-h":!0}),m(c)!=="svelte-wqrprq"&&(c.textContent=r),f=o(T),y(b.$$.fragment,T),g=o(T),$=u(T,"P",{"data-svelte-h":!0}),m($)!=="svelte-1etdm7l"&&($.textContent=X),k=o(T),y(I.$$.fragment,T)},m(T,C){s(T,a,C),s(T,n,C),s(T,c,C),s(T,f,C),h(b,T,C),s(T,g,C),s(T,$,C),s(T,k,C),h(I,T,C),Z=!0},p:A,i(T){Z||(w(b.$$.fragment,T),w(I.$$.fragment,T),Z=!0)},o(T){J(b.$$.fragment,T),J(I.$$.fragment,T),Z=!1},d(T){T&&(l(a),l(n),l(c),l(f),l(g),l($),l(k)),U(b,T),U(I,T)}}}function Zl(_){let a,p,n,c;return a=new Nt({props:{id:"training-inference",option:"single concept",$$slots:{default:[$l]},$$scope:{ctx:_}}}),n=new Nt({props:{id:"training-inference",option:"multiple concepts",$$slots:{default:[Il]},$$scope:{ctx:_}}}),{c(){d(a.$$.fragment),p=i(),d(n.$$.fragment)},l(r){y(a.$$.fragment,r),p=o(r),y(n.$$.fragment,r)},m(r,f){h(a,r,f),s(r,p,f),h(n,r,f),c=!0},p(r,f){const b={};f&2&&(b.$$scope={dirty:f,ctx:r}),a.$set(b);const g={};f&2&&(g.$$scope={dirty:f,ctx:r}),n.$set(g)},i(r){c||(w(a.$$.fragment,r),w(n.$$.fragment,r),c=!0)},o(r){J(a.$$.fragment,r),J(n.$$.fragment,r),c=!1},d(r){r&&l(p),U(a,r),U(n,r)}}}function Xl(_){let a,p;return a=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLnVuZXQubG9hZF9hdHRuX3Byb2NzKCUyMnBhdGgtdG8tc2F2ZS1tb2RlbCUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIycHl0b3JjaF9jdXN0b21fZGlmZnVzaW9uX3dlaWdodHMuYmluJTIyKSUwQXBpcGVsaW5lLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIycGF0aC10by1zYXZlLW1vZGVsJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjIlM0NuZXcxJTNFLmJpbiUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMiUzQ25ldzElM0UlMjBjYXQlMjBzaXR0aW5nJTIwaW4lMjBhJTIwYnVja2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENi4wJTJDJTBBJTIwJTIwJTIwJTIwZXRhJTNEMS4wJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.unet.load_attn_procs(<span class="hljs-string">&quot;path-to-save-model&quot;</span>, weight_name=<span class="hljs-string">&quot;pytorch_custom_diffusion_weights.bin&quot;</span>)
pipeline.load_textual_inversion(<span class="hljs-string">&quot;path-to-save-model&quot;</span>, weight_name=<span class="hljs-string">&quot;&lt;new1&gt;.bin&quot;</span>)

image = pipeline(
    <span class="hljs-string">&quot;&lt;new1&gt; cat sitting in a bucket&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    guidance_scale=<span class="hljs-number">6.0</span>,
    eta=<span class="hljs-number">1.0</span>,
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){d(a.$$.fragment)},l(n){y(a.$$.fragment,n)},m(n,c){h(a,n,c),p=!0},p:A,i(n){p||(w(a.$$.fragment,n),p=!0)},o(n){J(a.$$.fragment,n),p=!1},d(n){U(a,n)}}}function Wl(_){let a,p;return a=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLnJlcG9jYXJkJTIwaW1wb3J0JTIwUmVwb0NhcmQlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzYXlha3BhdWwlMkZjdXN0b20tZGlmZnVzaW9uLWNhdC13b29kZW4tcG90JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLnVuZXQubG9hZF9hdHRuX3Byb2NzKG1vZGVsX2lkJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJweXRvcmNoX2N1c3RvbV9kaWZmdXNpb25fd2VpZ2h0cy5iaW4lMjIpJTBBcGlwZWxpbmUubG9hZF90ZXh0dWFsX2ludmVyc2lvbihtb2RlbF9pZCUyQyUyMHdlaWdodF9uYW1lJTNEJTIyJTNDbmV3MSUzRS5iaW4lMjIpJTBBcGlwZWxpbmUubG9hZF90ZXh0dWFsX2ludmVyc2lvbihtb2RlbF9pZCUyQyUyMHdlaWdodF9uYW1lJTNEJTIyJTNDbmV3MiUzRS5iaW4lMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjJ0aGUlMjAlM0NuZXcxJTNFJTIwY2F0JTIwc2N1bHB0dXJlJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMCUzQ25ldzIlM0UlMjB3b29kZW4lMjBwb3QlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q2LjAlMkMlMEElMjAlMjAlMjAlMjBldGElM0QxLjAlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMm11bHRpLXN1YmplY3QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> RepoCard
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;sayakpaul/custom-diffusion-cat-wooden-pot&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.unet.load_attn_procs(model_id, weight_name=<span class="hljs-string">&quot;pytorch_custom_diffusion_weights.bin&quot;</span>)
pipeline.load_textual_inversion(model_id, weight_name=<span class="hljs-string">&quot;&lt;new1&gt;.bin&quot;</span>)
pipeline.load_textual_inversion(model_id, weight_name=<span class="hljs-string">&quot;&lt;new2&gt;.bin&quot;</span>)

image = pipeline(
    <span class="hljs-string">&quot;the &lt;new1&gt; cat sculpture in the style of a &lt;new2&gt; wooden pot&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    guidance_scale=<span class="hljs-number">6.0</span>,
    eta=<span class="hljs-number">1.0</span>,
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;multi-subject.png&quot;</span>)`,wrap:!1}}),{c(){d(a.$$.fragment)},l(n){y(a.$$.fragment,n)},m(n,c){h(a,n,c),p=!0},p:A,i(n){p||(w(a.$$.fragment,n),p=!0)},o(n){J(a.$$.fragment,n),p=!1},d(n){U(a,n)}}}function vl(_){let a,p,n,c;return a=new Nt({props:{id:"training-inference",option:"single concept",$$slots:{default:[Xl]},$$scope:{ctx:_}}}),n=new Nt({props:{id:"training-inference",option:"multiple concepts",$$slots:{default:[Wl]},$$scope:{ctx:_}}}),{c(){d(a.$$.fragment),p=i(),d(n.$$.fragment)},l(r){y(a.$$.fragment,r),p=o(r),y(n.$$.fragment,r)},m(r,f){h(a,r,f),s(r,p,f),h(n,r,f),c=!0},p(r,f){const b={};f&2&&(b.$$scope={dirty:f,ctx:r}),a.$set(b);const g={};f&2&&(g.$$scope={dirty:f,ctx:r}),n.$set(g)},i(r){c||(w(a.$$.fragment,r),w(n.$$.fragment,r),c=!0)},o(r){J(a.$$.fragment,r),J(n.$$.fragment,r),c=!1},d(r){r&&l(p),U(a,r),U(n,r)}}}function Nl(_){let a,p,n,c,r,f,b,g='<a href="https://huggingface.co/papers/2212.04488" rel="nofollow">Custom Diffusion</a> is a training technique for personalizing image generation models. Like Textual Inversion, DreamBooth, and LoRA, Custom Diffusion only requires a few (~4-5) example images. This technique works by only training weights in the cross-attention layers, and it uses a special word to represent the newly learned concept. Custom Diffusion is unique because it can also learn multiple concepts at the same time.',$,X,k="If you’re training on a GPU with limited vRAM, you should try enabling xFormers with <code>--enable_xformers_memory_efficient_attention</code> for faster training with lower vRAM requirements (16GB). To save even more memory, add <code>--set_grads_to_none</code> in the training argument to set the gradients to <code>None</code> instead of zero (this option can cause some issues, so if you experience any, try removing this parameter).",I,Z,T='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/custom_diffusion/train_custom_diffusion.py" rel="nofollow">train_custom_diffusion.py</a> script to help you become more familiar with it, and how you can adapt it for your own use-case.',C,B,Vt="Before running the script, make sure you install the library from source:",Ne,z,Ve,x,Gt="Navigate to the example folder with the training script and install the required dependencies:",Ge,E,Re,W,Ae,Y,Rt="Initialize an 🤗 Accelerate environment:",ke,Q,Be,H,At="To setup a default 🤗 Accelerate environment without choosing any configurations:",ze,L,xe,S,kt="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",Ee,F,Ye,q,Bt='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',Qe,v,He,D,Le,P,zt='The training script contains all the parameters to help you customize your training run. These are found in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/custom_diffusion/train_custom_diffusion.py#L319" rel="nofollow"><code>parse_args()</code></a> function. The function comes with default values, but you can also set your own values in the training command if you’d like.',Se,K,xt="For example, to change the resolution of the input image:",Fe,O,qe,ee,Et='Many of the basic parameters are described in the <a href="dreambooth#script-parameters">DreamBooth</a> training guide, so this guide focuses on the parameters unique to Custom Diffusion:',De,te,Yt="<li><code>--freeze_model</code>: freezes the key and value parameters in the cross-attention layer; the default is <code>crossattn_kv</code>, but you can set it to <code>crossattn</code> to train all the parameters in the cross-attention layer</li> <li><code>--concepts_list</code>: to learn multiple concepts, provide a path to a JSON file containing the concepts</li> <li><code>--modifier_token</code>: a special word used to represent the learned concept</li> <li><code>--initializer_token</code>: a special word used to initialize the embeddings of the <code>modifier_token</code></li>",Pe,le,Ke,se,Qt="Prior preservation loss is a method that uses a model’s own generated samples to help it learn how to generate more diverse images. Because these generated sample images belong to the same class as the images you provided, they help the model retain what it has learned about the class and how it can use what it already knows about the class to make new compositions.",Oe,ae,Ht='Many of the parameters for prior preservation loss are described in the <a href="dreambooth#prior-preservation-loss">DreamBooth</a> training guide.',et,ne,tt,ie,Lt="Custom Diffusion includes training the target images with a small set of real images to prevent overfitting. As you can imagine, this can be easy to do when you’re only training on a few images! Download 200 real images with <code>clip_retrieval</code>. The <code>class_prompt</code> should be the same category as the target images. These images are stored in <code>class_data_dir</code>.",lt,oe,st,re,St="To enable regularization, add the following parameters:",at,pe,Ft="<li><code>--with_prior_preservation</code>: whether to use prior preservation loss</li> <li><code>--prior_loss_weight</code>: controls the influence of the prior preservation loss on the model</li> <li><code>--real_prior</code>: whether to use a small set of real images to prevent overfitting</li>",nt,ce,it,Me,ot,N,rt,ue,qt="The Custom Diffusion training script has two dataset classes:",pt,me,Dt='<li><a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/custom_diffusion/train_custom_diffusion.py#L165" rel="nofollow"><code>CustomDiffusionDataset</code></a>: preprocesses the images, class images, and prompts for training</li> <li><a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/custom_diffusion/train_custom_diffusion.py#L148" rel="nofollow"><code>PromptDataset</code></a>: prepares the prompts for generating class images</li>',ct,fe,Pt='Next, the <code>modifier_token</code> is <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/custom_diffusion/train_custom_diffusion.py#L811" rel="nofollow">added to the tokenizer</a>, converted to token ids, and the token embeddings are resized to account for the new <code>modifier_token</code>. Then the <code>modifier_token</code> embeddings are initialized with the embeddings of the <code>initializer_token</code>. All parameters in the text encoder are frozen, except for the token embeddings since this is what the model is trying to learn to associate with the concepts.',Mt,de,ut,ye,Kt='Now you’ll need to add the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/custom_diffusion/train_custom_diffusion.py#L911C3-L911C3" rel="nofollow">Custom Diffusion weights</a> to the attention layers. This is a really important step for getting the shape and size of the attention weights correct, and for setting the appropriate number of attention processors in each UNet block.',mt,he,ft,we,Ot='The <a href="https://github.com/huggingface/diffusers/blob/84cd9e8d01adb47f046b1ee449fc76a0c32dc4e2/examples/custom_diffusion/train_custom_diffusion.py#L982" rel="nofollow">optimizer</a> is initialized to update the cross-attention layer parameters:',dt,Je,yt,Ue,el='In the <a href="https://github.com/huggingface/diffusers/blob/84cd9e8d01adb47f046b1ee449fc76a0c32dc4e2/examples/custom_diffusion/train_custom_diffusion.py#L1048" rel="nofollow">training loop</a>, it is important to only update the embeddings for the concept you’re trying to learn. This means setting the gradients of all the other token embeddings to zero:',ht,Te,wt,be,Jt,_e,tl="Once you’ve made all your changes or you’re okay with the default configuration, you’re ready to launch the training script! 🚀",Ut,je,ll='In this guide, you’ll download and use these example <a href="https://www.cs.cmu.edu/~custom-diffusion/assets/data.zip" rel="nofollow">cat images</a>. You can also create and use your own dataset if you want (see the <a href="create_dataset">Create a dataset for training</a> guide).',Tt,Ce,sl="Set the environment variable <code>MODEL_NAME</code> to a model id on the Hub or a path to a local model, <code>INSTANCE_DIR</code>  to the path where you just downloaded the cat images to, and <code>OUTPUT_DIR</code> to where you want to save the model. You’ll use <code>&lt;new1&gt;</code> as the special word to tie the newly learned embeddings to. The script creates and saves model checkpoints and a pytorch_custom_diffusion_weights.bin file to your repository.",bt,ge,al="To monitor training progress with Weights and Biases, add the <code>--report_to=wandb</code> parameter to the training command and specify a validation prompt with <code>--validation_prompt</code>. This is useful for debugging and saving intermediate results.",_t,V,jt,G,Ct,$e,nl="Once training is finished, you can use your new Custom Diffusion model for inference.",gt,R,$t,Ie,It,Ze,il="Congratulations on training a model with Custom Diffusion! 🎉 To learn more:",Zt,Xe,ol='<li>Read the <a href="https://www.cs.cmu.edu/~custom-diffusion/" rel="nofollow">Multi-Concept Customization of Text-to-Image Diffusion</a> blog post to learn more details about the experimental results from the Custom Diffusion team.</li>',Xt,ve,Wt;return r=new We({props:{title:"Custom Diffusion",local:"custom-diffusion",headingTag:"h1"}}),z=new j({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),E=new j({props:{code:"Y2QlMjBleGFtcGxlcyUyRmN1c3RvbV9kaWZmdXNpb24lMEFwaXAlMjBpbnN0YWxsJTIwLXIlMjByZXF1aXJlbWVudHMudHh0JTBBcGlwJTIwaW5zdGFsbCUyMGNsaXAtcmV0cmlldmFs",highlighted:`<span class="hljs-built_in">cd</span> examples/custom_diffusion
pip install -r requirements.txt
pip install clip-retrieval`,wrap:!1}}),W=new vt({props:{$$slots:{default:[_l]},$$scope:{ctx:_}}}),Q=new j({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),L=new j({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),F=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),v=new vt({props:{$$slots:{default:[jl]},$$scope:{ctx:_}}}),D=new We({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),O=new j({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2N1c3RvbV9kaWZmdXNpb24ucHklMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0QyNTY=",highlighted:`accelerate launch train_custom_diffusion.py \\
  --resolution=256`,wrap:!1}}),le=new We({props:{title:"Prior preservation loss",local:"prior-preservation-loss",headingTag:"h3"}}),ne=new We({props:{title:"Regularization",local:"regularization",headingTag:"h3"}}),oe=new j({props:{code:"cHl0aG9uJTIwcmV0cmlldmUucHklMjAtLWNsYXNzX3Byb21wdCUyMGNhdCUyMC0tY2xhc3NfZGF0YV9kaXIlMjByZWFsX3JlZyUyRnNhbXBsZXNfY2F0JTIwLS1udW1fY2xhc3NfaW1hZ2VzJTIwMjAw",highlighted:'python retrieve.py --class_prompt <span class="hljs-built_in">cat</span> --class_data_dir real_reg/samples_cat --num_class_images 200',wrap:!1}}),ce=new j({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2N1c3RvbV9kaWZmdXNpb24ucHklMjAlNUMlMEElMjAlMjAtLXdpdGhfcHJpb3JfcHJlc2VydmF0aW9uJTIwJTVDJTBBJTIwJTIwLS1wcmlvcl9sb3NzX3dlaWdodCUzRDEuMCUyMCU1QyUwQSUyMCUyMC0tY2xhc3NfZGF0YV9kaXIlM0QlMjIuJTJGcmVhbF9yZWclMkZzYW1wbGVzX2NhdCUyMiUyMCU1QyUwQSUyMCUyMC0tY2xhc3NfcHJvbXB0JTNEJTIyY2F0JTIyJTIwJTVDJTBBJTIwJTIwLS1yZWFsX3ByaW9yJTNEVHJ1ZSUyMCU1Qw==",highlighted:`accelerate launch train_custom_diffusion.py \\
  --with_prior_preservation \\
  --prior_loss_weight=1.0 \\
  --class_data_dir=<span class="hljs-string">&quot;./real_reg/samples_cat&quot;</span> \\
  --class_prompt=<span class="hljs-string">&quot;cat&quot;</span> \\
  --real_prior=True \\`,wrap:!1}}),Me=new We({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),N=new vt({props:{$$slots:{default:[Cl]},$$scope:{ctx:_}}}),de=new j({props:{code:"cGFyYW1zX3RvX2ZyZWV6ZSUyMCUzRCUyMGl0ZXJ0b29scy5jaGFpbiglMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIudGV4dF9tb2RlbC5lbmNvZGVyLnBhcmFtZXRlcnMoKSUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlci50ZXh0X21vZGVsLmZpbmFsX2xheWVyX25vcm0ucGFyYW1ldGVycygpJTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyLnRleHRfbW9kZWwuZW1iZWRkaW5ncy5wb3NpdGlvbl9lbWJlZGRpbmcucGFyYW1ldGVycygpJTJDJTBBKSUwQWZyZWV6ZV9wYXJhbXMocGFyYW1zX3RvX2ZyZWV6ZSk=",highlighted:`params_to_freeze = itertools.chain(
    text_encoder.text_model.encoder.parameters(),
    text_encoder.text_model.final_layer_norm.parameters(),
    text_encoder.text_model.embeddings.position_embedding.parameters(),
)
freeze_params(params_to_freeze)`,wrap:!1}}),he=new j({props:{code:"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",highlighted:`st = unet.state_dict()
<span class="hljs-keyword">for</span> name, _ <span class="hljs-keyword">in</span> unet.attn_processors.items():
    cross_attention_dim = <span class="hljs-literal">None</span> <span class="hljs-keyword">if</span> name.endswith(<span class="hljs-string">&quot;attn1.processor&quot;</span>) <span class="hljs-keyword">else</span> unet.config.cross_attention_dim
    <span class="hljs-keyword">if</span> name.startswith(<span class="hljs-string">&quot;mid_block&quot;</span>):
        hidden_size = unet.config.block_out_channels[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">elif</span> name.startswith(<span class="hljs-string">&quot;up_blocks&quot;</span>):
        block_id = <span class="hljs-built_in">int</span>(name[<span class="hljs-built_in">len</span>(<span class="hljs-string">&quot;up_blocks.&quot;</span>)])
        hidden_size = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">reversed</span>(unet.config.block_out_channels))[block_id]
    <span class="hljs-keyword">elif</span> name.startswith(<span class="hljs-string">&quot;down_blocks&quot;</span>):
        block_id = <span class="hljs-built_in">int</span>(name[<span class="hljs-built_in">len</span>(<span class="hljs-string">&quot;down_blocks.&quot;</span>)])
        hidden_size = unet.config.block_out_channels[block_id]
    layer_name = name.split(<span class="hljs-string">&quot;.processor&quot;</span>)[<span class="hljs-number">0</span>]
    weights = {
        <span class="hljs-string">&quot;to_k_custom_diffusion.weight&quot;</span>: st[layer_name + <span class="hljs-string">&quot;.to_k.weight&quot;</span>],
        <span class="hljs-string">&quot;to_v_custom_diffusion.weight&quot;</span>: st[layer_name + <span class="hljs-string">&quot;.to_v.weight&quot;</span>],
    }
    <span class="hljs-keyword">if</span> train_q_out:
        weights[<span class="hljs-string">&quot;to_q_custom_diffusion.weight&quot;</span>] = st[layer_name + <span class="hljs-string">&quot;.to_q.weight&quot;</span>]
        weights[<span class="hljs-string">&quot;to_out_custom_diffusion.0.weight&quot;</span>] = st[layer_name + <span class="hljs-string">&quot;.to_out.0.weight&quot;</span>]
        weights[<span class="hljs-string">&quot;to_out_custom_diffusion.0.bias&quot;</span>] = st[layer_name + <span class="hljs-string">&quot;.to_out.0.bias&quot;</span>]
    <span class="hljs-keyword">if</span> cross_attention_dim <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        custom_diffusion_attn_procs[name] = attention_class(
            train_kv=train_kv,
            train_q_out=train_q_out,
            hidden_size=hidden_size,
            cross_attention_dim=cross_attention_dim,
        ).to(unet.device)
        custom_diffusion_attn_procs[name].load_state_dict(weights)
    <span class="hljs-keyword">else</span>:
        custom_diffusion_attn_procs[name] = attention_class(
            train_kv=<span class="hljs-literal">False</span>,
            train_q_out=<span class="hljs-literal">False</span>,
            hidden_size=hidden_size,
            cross_attention_dim=cross_attention_dim,
        )
<span class="hljs-keyword">del</span> st
unet.set_attn_processor(custom_diffusion_attn_procs)
custom_diffusion_layers = AttnProcsLayers(unet.attn_processors)`,wrap:!1}}),Je=new j({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwb3B0aW1pemVyX2NsYXNzKCUwQSUyMCUyMCUyMCUyMGl0ZXJ0b29scy5jaGFpbih0ZXh0X2VuY29kZXIuZ2V0X2lucHV0X2VtYmVkZGluZ3MoKS5wYXJhbWV0ZXJzKCklMkMlMjBjdXN0b21fZGlmZnVzaW9uX2xheWVycy5wYXJhbWV0ZXJzKCkpJTBBJTIwJTIwJTIwJTIwaWYlMjBhcmdzLm1vZGlmaWVyX3Rva2VuJTIwaXMlMjBub3QlMjBOb25lJTBBJTIwJTIwJTIwJTIwZWxzZSUyMGN1c3RvbV9kaWZmdXNpb25fbGF5ZXJzLnBhcmFtZXRlcnMoKSUyQyUwQSUyMCUyMCUyMCUyMGxyJTNEYXJncy5sZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwYmV0YXMlM0QoYXJncy5hZGFtX2JldGExJTJDJTIwYXJncy5hZGFtX2JldGEyKSUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9kZWNheSUzRGFyZ3MuYWRhbV93ZWlnaHRfZGVjYXklMkMlMEElMjAlMjAlMjAlMjBlcHMlM0RhcmdzLmFkYW1fZXBzaWxvbiUyQyUwQSk=",highlighted:`optimizer = optimizer_class(
    itertools.chain(text_encoder.get_input_embeddings().parameters(), custom_diffusion_layers.parameters())
    <span class="hljs-keyword">if</span> args.modifier_token <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>
    <span class="hljs-keyword">else</span> custom_diffusion_layers.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),Te=new j({props:{code:"aWYlMjBhcmdzLm1vZGlmaWVyX3Rva2VuJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBhY2NlbGVyYXRvci5udW1fcHJvY2Vzc2VzJTIwJTNFJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyYWRzX3RleHRfZW5jb2RlciUyMCUzRCUyMHRleHRfZW5jb2Rlci5tb2R1bGUuZ2V0X2lucHV0X2VtYmVkZGluZ3MoKS53ZWlnaHQuZ3JhZCUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBncmFkc190ZXh0X2VuY29kZXIlMjAlM0QlMjB0ZXh0X2VuY29kZXIuZ2V0X2lucHV0X2VtYmVkZGluZ3MoKS53ZWlnaHQuZ3JhZCUwQSUyMCUyMCUyMCUyMGluZGV4X2dyYWRzX3RvX3plcm8lMjAlM0QlMjB0b3JjaC5hcmFuZ2UobGVuKHRva2VuaXplcikpJTIwISUzRCUyMG1vZGlmaWVyX3Rva2VuX2lkJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihtb2RpZmllcl90b2tlbl9pZCU1QjElM0ElNUQpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluZGV4X2dyYWRzX3RvX3plcm8lMjAlM0QlMjBpbmRleF9ncmFkc190b196ZXJvJTIwJTI2JTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLmFyYW5nZShsZW4odG9rZW5pemVyKSklMjAhJTNEJTIwbW9kaWZpZXJfdG9rZW5faWQlNUJpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGdyYWRzX3RleHRfZW5jb2Rlci5kYXRhJTVCaW5kZXhfZ3JhZHNfdG9femVybyUyQyUyMCUzQSU1RCUyMCUzRCUyMGdyYWRzX3RleHRfZW5jb2Rlci5kYXRhJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5kZXhfZ3JhZHNfdG9femVybyUyQyUyMCUzQSUwQSUyMCUyMCUyMCUyMCU1RC5maWxsXygwKQ==",highlighted:`<span class="hljs-keyword">if</span> args.modifier_token <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> accelerator.num_processes &gt; <span class="hljs-number">1</span>:
        grads_text_encoder = text_encoder.module.get_input_embeddings().weight.grad
    <span class="hljs-keyword">else</span>:
        grads_text_encoder = text_encoder.get_input_embeddings().weight.grad
    index_grads_to_zero = torch.arange(<span class="hljs-built_in">len</span>(tokenizer)) != modifier_token_id[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(modifier_token_id[<span class="hljs-number">1</span>:])):
        index_grads_to_zero = index_grads_to_zero &amp; (
            torch.arange(<span class="hljs-built_in">len</span>(tokenizer)) != modifier_token_id[i]
        )
    grads_text_encoder.data[index_grads_to_zero, :] = grads_text_encoder.data[
        index_grads_to_zero, :
    ].fill_(<span class="hljs-number">0</span>)`,wrap:!1}}),be=new We({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),V=new vt({props:{$$slots:{default:[gl]},$$scope:{ctx:_}}}),G=new yl({props:{id:"training-inference",options:["single concept","multiple concepts"],$$slots:{default:[Zl]},$$scope:{ctx:_}}}),R=new yl({props:{id:"training-inference",options:["single concept","multiple concepts"],$$slots:{default:[vl]},$$scope:{ctx:_}}}),Ie=new We({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){a=M("meta"),p=i(),n=M("p"),c=i(),d(r.$$.fragment),f=i(),b=M("p"),b.innerHTML=g,$=i(),X=M("p"),X.innerHTML=k,I=i(),Z=M("p"),Z.innerHTML=T,C=i(),B=M("p"),B.textContent=Vt,Ne=i(),d(z.$$.fragment),Ve=i(),x=M("p"),x.textContent=Gt,Ge=i(),d(E.$$.fragment),Re=i(),d(W.$$.fragment),Ae=i(),Y=M("p"),Y.textContent=Rt,ke=i(),d(Q.$$.fragment),Be=i(),H=M("p"),H.textContent=At,ze=i(),d(L.$$.fragment),xe=i(),S=M("p"),S.textContent=kt,Ee=i(),d(F.$$.fragment),Ye=i(),q=M("p"),q.innerHTML=Bt,Qe=i(),d(v.$$.fragment),He=i(),d(D.$$.fragment),Le=i(),P=M("p"),P.innerHTML=zt,Se=i(),K=M("p"),K.textContent=xt,Fe=i(),d(O.$$.fragment),qe=i(),ee=M("p"),ee.innerHTML=Et,De=i(),te=M("ul"),te.innerHTML=Yt,Pe=i(),d(le.$$.fragment),Ke=i(),se=M("p"),se.textContent=Qt,Oe=i(),ae=M("p"),ae.innerHTML=Ht,et=i(),d(ne.$$.fragment),tt=i(),ie=M("p"),ie.innerHTML=Lt,lt=i(),d(oe.$$.fragment),st=i(),re=M("p"),re.textContent=St,at=i(),pe=M("ul"),pe.innerHTML=Ft,nt=i(),d(ce.$$.fragment),it=i(),d(Me.$$.fragment),ot=i(),d(N.$$.fragment),rt=i(),ue=M("p"),ue.textContent=qt,pt=i(),me=M("ul"),me.innerHTML=Dt,ct=i(),fe=M("p"),fe.innerHTML=Pt,Mt=i(),d(de.$$.fragment),ut=i(),ye=M("p"),ye.innerHTML=Kt,mt=i(),d(he.$$.fragment),ft=i(),we=M("p"),we.innerHTML=Ot,dt=i(),d(Je.$$.fragment),yt=i(),Ue=M("p"),Ue.innerHTML=el,ht=i(),d(Te.$$.fragment),wt=i(),d(be.$$.fragment),Jt=i(),_e=M("p"),_e.textContent=tl,Ut=i(),je=M("p"),je.innerHTML=ll,Tt=i(),Ce=M("p"),Ce.innerHTML=sl,bt=i(),ge=M("p"),ge.innerHTML=al,_t=i(),d(V.$$.fragment),jt=i(),d(G.$$.fragment),Ct=i(),$e=M("p"),$e.textContent=nl,gt=i(),d(R.$$.fragment),$t=i(),d(Ie.$$.fragment),It=i(),Ze=M("p"),Ze.textContent=il,Zt=i(),Xe=M("ul"),Xe.innerHTML=ol,Xt=i(),ve=M("p"),this.h()},l(e){const t=Tl("svelte-u9bgzb",document.head);a=u(t,"META",{name:!0,content:!0}),t.forEach(l),p=o(e),n=u(e,"P",{}),fl(n).forEach(l),c=o(e),y(r.$$.fragment,e),f=o(e),b=u(e,"P",{"data-svelte-h":!0}),m(b)!=="svelte-zoobzt"&&(b.innerHTML=g),$=o(e),X=u(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1pc1nnz"&&(X.innerHTML=k),I=o(e),Z=u(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-u5h0jz"&&(Z.innerHTML=T),C=o(e),B=u(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-l7dm2q"&&(B.textContent=Vt),Ne=o(e),y(z.$$.fragment,e),Ve=o(e),x=u(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1nnn36i"&&(x.textContent=Gt),Ge=o(e),y(E.$$.fragment,e),Re=o(e),y(W.$$.fragment,e),Ae=o(e),Y=u(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-60q53m"&&(Y.textContent=Rt),ke=o(e),y(Q.$$.fragment,e),Be=o(e),H=u(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-di6juu"&&(H.textContent=At),ze=o(e),y(L.$$.fragment,e),xe=o(e),S=u(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-tsz4qp"&&(S.textContent=kt),Ee=o(e),y(F.$$.fragment,e),Ye=o(e),q=u(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1fkfdql"&&(q.innerHTML=Bt),Qe=o(e),y(v.$$.fragment,e),He=o(e),y(D.$$.fragment,e),Le=o(e),P=u(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1t7lm99"&&(P.innerHTML=zt),Se=o(e),K=u(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-or9ig"&&(K.textContent=xt),Fe=o(e),y(O.$$.fragment,e),qe=o(e),ee=u(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-j5tc3k"&&(ee.innerHTML=Et),De=o(e),te=u(e,"UL",{"data-svelte-h":!0}),m(te)!=="svelte-11ngzwo"&&(te.innerHTML=Yt),Pe=o(e),y(le.$$.fragment,e),Ke=o(e),se=u(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-1oc83h6"&&(se.textContent=Qt),Oe=o(e),ae=u(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1mpzp5"&&(ae.innerHTML=Ht),et=o(e),y(ne.$$.fragment,e),tt=o(e),ie=u(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-13fgxpn"&&(ie.innerHTML=Lt),lt=o(e),y(oe.$$.fragment,e),st=o(e),re=u(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-hwsu6x"&&(re.textContent=St),at=o(e),pe=u(e,"UL",{"data-svelte-h":!0}),m(pe)!=="svelte-6jy6u"&&(pe.innerHTML=Ft),nt=o(e),y(ce.$$.fragment,e),it=o(e),y(Me.$$.fragment,e),ot=o(e),y(N.$$.fragment,e),rt=o(e),ue=u(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-1owi8ao"&&(ue.textContent=qt),pt=o(e),me=u(e,"UL",{"data-svelte-h":!0}),m(me)!=="svelte-1fby5zy"&&(me.innerHTML=Dt),ct=o(e),fe=u(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1jto000"&&(fe.innerHTML=Pt),Mt=o(e),y(de.$$.fragment,e),ut=o(e),ye=u(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-12higtg"&&(ye.innerHTML=Kt),mt=o(e),y(he.$$.fragment,e),ft=o(e),we=u(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-bhf9v4"&&(we.innerHTML=Ot),dt=o(e),y(Je.$$.fragment,e),yt=o(e),Ue=u(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-dnomct"&&(Ue.innerHTML=el),ht=o(e),y(Te.$$.fragment,e),wt=o(e),y(be.$$.fragment,e),Jt=o(e),_e=u(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-9dei1q"&&(_e.textContent=tl),Ut=o(e),je=u(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-mn6swm"&&(je.innerHTML=ll),Tt=o(e),Ce=u(e,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1o5n4y1"&&(Ce.innerHTML=sl),bt=o(e),ge=u(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-gvoz0n"&&(ge.innerHTML=al),_t=o(e),y(V.$$.fragment,e),jt=o(e),y(G.$$.fragment,e),Ct=o(e),$e=u(e,"P",{"data-svelte-h":!0}),m($e)!=="svelte-1mw1g2x"&&($e.textContent=nl),gt=o(e),y(R.$$.fragment,e),$t=o(e),y(Ie.$$.fragment,e),It=o(e),Ze=u(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-nq8p2g"&&(Ze.textContent=il),Zt=o(e),Xe=u(e,"UL",{"data-svelte-h":!0}),m(Xe)!=="svelte-1u8bbml"&&(Xe.innerHTML=ol),Xt=o(e),ve=u(e,"P",{}),fl(ve).forEach(l),this.h()},h(){dl(a,"name","hf:doc:metadata"),dl(a,"content",Vl)},m(e,t){bl(document.head,a),s(e,p,t),s(e,n,t),s(e,c,t),h(r,e,t),s(e,f,t),s(e,b,t),s(e,$,t),s(e,X,t),s(e,I,t),s(e,Z,t),s(e,C,t),s(e,B,t),s(e,Ne,t),h(z,e,t),s(e,Ve,t),s(e,x,t),s(e,Ge,t),h(E,e,t),s(e,Re,t),h(W,e,t),s(e,Ae,t),s(e,Y,t),s(e,ke,t),h(Q,e,t),s(e,Be,t),s(e,H,t),s(e,ze,t),h(L,e,t),s(e,xe,t),s(e,S,t),s(e,Ee,t),h(F,e,t),s(e,Ye,t),s(e,q,t),s(e,Qe,t),h(v,e,t),s(e,He,t),h(D,e,t),s(e,Le,t),s(e,P,t),s(e,Se,t),s(e,K,t),s(e,Fe,t),h(O,e,t),s(e,qe,t),s(e,ee,t),s(e,De,t),s(e,te,t),s(e,Pe,t),h(le,e,t),s(e,Ke,t),s(e,se,t),s(e,Oe,t),s(e,ae,t),s(e,et,t),h(ne,e,t),s(e,tt,t),s(e,ie,t),s(e,lt,t),h(oe,e,t),s(e,st,t),s(e,re,t),s(e,at,t),s(e,pe,t),s(e,nt,t),h(ce,e,t),s(e,it,t),h(Me,e,t),s(e,ot,t),h(N,e,t),s(e,rt,t),s(e,ue,t),s(e,pt,t),s(e,me,t),s(e,ct,t),s(e,fe,t),s(e,Mt,t),h(de,e,t),s(e,ut,t),s(e,ye,t),s(e,mt,t),h(he,e,t),s(e,ft,t),s(e,we,t),s(e,dt,t),h(Je,e,t),s(e,yt,t),s(e,Ue,t),s(e,ht,t),h(Te,e,t),s(e,wt,t),h(be,e,t),s(e,Jt,t),s(e,_e,t),s(e,Ut,t),s(e,je,t),s(e,Tt,t),s(e,Ce,t),s(e,bt,t),s(e,ge,t),s(e,_t,t),h(V,e,t),s(e,jt,t),h(G,e,t),s(e,Ct,t),s(e,$e,t),s(e,gt,t),h(R,e,t),s(e,$t,t),h(Ie,e,t),s(e,It,t),s(e,Ze,t),s(e,Zt,t),s(e,Xe,t),s(e,Xt,t),s(e,ve,t),Wt=!0},p(e,[t]){const rl={};t&2&&(rl.$$scope={dirty:t,ctx:e}),W.$set(rl);const pl={};t&2&&(pl.$$scope={dirty:t,ctx:e}),v.$set(pl);const cl={};t&2&&(cl.$$scope={dirty:t,ctx:e}),N.$set(cl);const Ml={};t&2&&(Ml.$$scope={dirty:t,ctx:e}),V.$set(Ml);const ul={};t&2&&(ul.$$scope={dirty:t,ctx:e}),G.$set(ul);const ml={};t&2&&(ml.$$scope={dirty:t,ctx:e}),R.$set(ml)},i(e){Wt||(w(r.$$.fragment,e),w(z.$$.fragment,e),w(E.$$.fragment,e),w(W.$$.fragment,e),w(Q.$$.fragment,e),w(L.$$.fragment,e),w(F.$$.fragment,e),w(v.$$.fragment,e),w(D.$$.fragment,e),w(O.$$.fragment,e),w(le.$$.fragment,e),w(ne.$$.fragment,e),w(oe.$$.fragment,e),w(ce.$$.fragment,e),w(Me.$$.fragment,e),w(N.$$.fragment,e),w(de.$$.fragment,e),w(he.$$.fragment,e),w(Je.$$.fragment,e),w(Te.$$.fragment,e),w(be.$$.fragment,e),w(V.$$.fragment,e),w(G.$$.fragment,e),w(R.$$.fragment,e),w(Ie.$$.fragment,e),Wt=!0)},o(e){J(r.$$.fragment,e),J(z.$$.fragment,e),J(E.$$.fragment,e),J(W.$$.fragment,e),J(Q.$$.fragment,e),J(L.$$.fragment,e),J(F.$$.fragment,e),J(v.$$.fragment,e),J(D.$$.fragment,e),J(O.$$.fragment,e),J(le.$$.fragment,e),J(ne.$$.fragment,e),J(oe.$$.fragment,e),J(ce.$$.fragment,e),J(Me.$$.fragment,e),J(N.$$.fragment,e),J(de.$$.fragment,e),J(he.$$.fragment,e),J(Je.$$.fragment,e),J(Te.$$.fragment,e),J(be.$$.fragment,e),J(V.$$.fragment,e),J(G.$$.fragment,e),J(R.$$.fragment,e),J(Ie.$$.fragment,e),Wt=!1},d(e){e&&(l(p),l(n),l(c),l(f),l(b),l($),l(X),l(I),l(Z),l(C),l(B),l(Ne),l(Ve),l(x),l(Ge),l(Re),l(Ae),l(Y),l(ke),l(Be),l(H),l(ze),l(xe),l(S),l(Ee),l(Ye),l(q),l(Qe),l(He),l(Le),l(P),l(Se),l(K),l(Fe),l(qe),l(ee),l(De),l(te),l(Pe),l(Ke),l(se),l(Oe),l(ae),l(et),l(tt),l(ie),l(lt),l(st),l(re),l(at),l(pe),l(nt),l(it),l(ot),l(rt),l(ue),l(pt),l(me),l(ct),l(fe),l(Mt),l(ut),l(ye),l(mt),l(ft),l(we),l(dt),l(yt),l(Ue),l(ht),l(wt),l(Jt),l(_e),l(Ut),l(je),l(Tt),l(Ce),l(bt),l(ge),l(_t),l(jt),l(Ct),l($e),l(gt),l($t),l(It),l(Ze),l(Zt),l(Xe),l(Xt),l(ve)),l(a),U(r,e),U(z,e),U(E,e),U(W,e),U(Q,e),U(L,e),U(F,e),U(v,e),U(D,e),U(O,e),U(le,e),U(ne,e),U(oe,e),U(ce,e),U(Me,e),U(N,e),U(de,e),U(he,e),U(Je,e),U(Te,e),U(be,e),U(V,e),U(G,e),U(R,e),U(Ie,e)}}}const Vl='{"title":"Custom Diffusion","local":"custom-diffusion","sections":[{"title":"Script parameters","local":"script-parameters","sections":[{"title":"Prior preservation loss","local":"prior-preservation-loss","sections":[],"depth":3},{"title":"Regularization","local":"regularization","sections":[],"depth":3}],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Gl(_){return wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class El extends Jl{constructor(a){super(),Ul(this,a,Gl,Nl,hl,{})}}export{El as component};
