import{s as $e,n as Ie,o as Xe}from"../chunks/scheduler.182ea377.js";import{S as Ge,i as Qe,g as i,s as n,r as p,A as Se,h as o,f as l,c as a,j as ke,u as r,x as M,k as ye,y as Be,a as s,v as c,d as u,t as m,w as d}from"../chunks/index.abf12888.js";import{C as b}from"../chunks/CodeBlock.57fe6e13.js";import{D as Re}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as be}from"../chunks/Heading.16916d63.js";function Ne(we){let f,L,Y,D,w,A,h,H,U,he='The <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> supports textual inversion, a technique that enables a model like Stable Diffusion to learn a new concept from just a few sample images. This gives you more control over the generated images and allows you to tailor the model towards specific concepts. You can get started quickly with a collection of community created concepts in the <a href="https://huggingface.co/spaces/sd-concepts-library/stable-diffusion-conceptualizer" rel="nofollow">Stable Diffusion Conceptualizer</a>.',V,g,Ue='This guide will show you how to run inference with textual inversion using a pre-learned concept from the Stable Diffusion Conceptualizer. If you’re interested in teaching a model new concepts with textual inversion, take a look at the <a href="../training/text_inversion">Textual Inversion</a> training guide.',F,J,ge="Import the necessary libraries:",q,T,E,j,P,_,Je='Pick a Stable Diffusion checkpoint and a pre-learned concept from the <a href="https://huggingface.co/spaces/sd-concepts-library/stable-diffusion-conceptualizer" rel="nofollow">Stable Diffusion Conceptualizer</a>:',K,C,O,Z,Te="Now you can load a pipeline, and pass the pre-learned concept to it:",ee,x,te,v,je="Create a prompt with the pre-learned concept by using the special placeholder token <code>&lt;cat-toy&gt;</code>, and choose the number of samples and rows of images you’d like to generate:",le,W,se,k,_e="Then run the pipeline (feel free to adjust the parameters like <code>num_inference_steps</code> and <code>guidance_scale</code> to see how they affect image quality), save the generated images and visualize them with the helper function you created at the beginning:",ne,$,ae,y,Ce='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/textual_inversion_inference.png"/>',ie,I,oe,X,Ze="Stable Diffusion XL (SDXL) can also use textual inversion vectors for inference. In contrast to Stable Diffusion 1 and 2, SDXL has two text encoders so you’ll need two textual inversion embeddings - one for each text encoder model.",pe,G,xe="Let’s download the SDXL textual inversion embeddings and have a closer look at it’s structure:",re,Q,Me,S,ce,B,ve=`There are two tensors, <code>&quot;clip_g&quot;</code> and <code>&quot;clip_l&quot;</code>.
<code>&quot;clip_g&quot;</code> corresponds to the bigger text encoder in SDXL and refers to
<code>pipe.text_encoder_2</code> and <code>&quot;clip_l&quot;</code> refers to <code>pipe.text_encoder</code>.`,ue,R,We=`Now you can load each tensor separately by passing them along with the correct text encoder and tokenizer
to <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.load_textual_inversion">load_textual_inversion()</a>:`,me,N,de,z,fe;return w=new be({props:{title:"Textual inversion",local:"textual-inversion",headingTag:"h1"}}),h=new Re({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/textual_inversion_inference.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/textual_inversion_inference.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/textual_inversion_inference.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/textual_inversion_inference.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/textual_inversion_inference.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/textual_inversion_inference.ipynb"}]}}),T=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlk",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid`,wrap:!1}}),j=new be({props:{title:"Stable Diffusion 1 and 2",local:"stable-diffusion-1-and-2",headingTag:"h2"}}),C=new b({props:{code:"cHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXJlcG9faWRfZW1iZWRzJTIwJTNEJTIwJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjI=",highlighted:`pretrained_model_name_or_path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
repo_id_embeds = <span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>`,wrap:!1}}),x=new b({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXBpcGVsaW5lLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24ocmVwb19pZF9lbWJlZHMp",highlighted:`pipeline = StableDiffusionPipeline.from_pretrained(
    pretrained_model_name_or_path, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.load_textual_inversion(repo_id_embeds)`,wrap:!1}}),W=new b({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMGdyYWZpdHRpJTIwaW4lMjBhJTIwZmF2ZWxhJTIwd2FsbCUyMHdpdGglMjBhJTIwJTNDY2F0LXRveSUzRSUyMG9uJTIwaXQlMjIlMEElMEFudW1fc2FtcGxlc19wZXJfcm93JTIwJTNEJTIwMiUwQW51bV9yb3dzJTIwJTNEJTIwMg==",highlighted:`prompt = <span class="hljs-string">&quot;a grafitti in a favela wall with a &lt;cat-toy&gt; on it&quot;</span>

num_samples_per_row = <span class="hljs-number">2</span>
num_rows = <span class="hljs-number">2</span>`,wrap:!1}}),$=new b({props:{code:"YWxsX2ltYWdlcyUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKG51bV9yb3dzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9zYW1wbGVzX3Blcl9yb3clMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSkuaW1hZ2VzJTBBJTIwJTIwJTIwJTIwYWxsX2ltYWdlcy5leHRlbmQoaW1hZ2VzKSUwQSUwQWdyaWQlMjAlM0QlMjBtYWtlX2ltYWdlX2dyaWQoYWxsX2ltYWdlcyUyQyUyMG51bV9yb3dzJTJDJTIwbnVtX3NhbXBsZXNfcGVyX3JvdyklMEFncmlk",highlighted:`all_images = []
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_rows):
    images = pipeline(prompt, num_images_per_prompt=num_samples_per_row, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">7.5</span>).images
    all_images.extend(images)

grid = make_image_grid(all_images, num_rows, num_samples_per_row)
grid`,wrap:!1}}),I=new be({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),Q=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWZyb20lMjBzYWZldGVuc29ycy50b3JjaCUyMGltcG9ydCUyMGxvYWRfZmlsZSUwQSUwQWZpbGUlMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTIyZG4xMTglMkZ1bmFlc3RoZXRpY1hMJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJ1bmFlc3RoZXRpY1hMdjMxLnNhZmV0ZW5zb3JzJTIyKSUwQXN0YXRlX2RpY3QlMjAlM0QlMjBsb2FkX2ZpbGUoZmlsZSklMEFzdGF0ZV9kaWN0",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-keyword">from</span> safetensors.torch <span class="hljs-keyword">import</span> load_file

file = hf_hub_download(<span class="hljs-string">&quot;dn118/unaestheticXL&quot;</span>, filename=<span class="hljs-string">&quot;unaestheticXLv31.safetensors&quot;</span>)
state_dict = load_file(file)
state_dict`,wrap:!1}}),S=new b({props:{code:"JTdCJ2NsaXBfZyclM0ElMjB0ZW5zb3IoJTVCJTVCJTIwMC4wMDc3JTJDJTIwLTAuMDExMiUyQyUyMCUyMDAuMDA2NSUyQyUyMCUyMC4uLiUyQyUyMCUyMDAuMDE5NSUyQyUyMCUyMDAuMDE1OSUyQyUyMCUyMDAuMDI3NSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qi0wLjAxNzAlMkMlMjAlMjAwLjAyMTMlMkMlMjAlMjAwLjAxNDMlMkMlMjAlMjAuLi4lMkMlMjAtMC4wMzAyJTJDJTIwLTAuMDI0MCUyQyUyMC0wLjAzNjIlNUQlNUQlMkMlMEElMjAnY2xpcF9sJyUzQSUyMHRlbnNvciglNUIlNUIlMjAwLjAwMjMlMkMlMjAlMjAwLjAxOTIlMkMlMjAlMjAwLjAyMTMlMkMlMjAlMjAuLi4lMkMlMjAtMC4wMzg1JTJDJTIwJTIwMC4wMDQ4JTJDJTIwLTAuMDAxMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMDAuMDQ3NSUyQyUyMC0wLjA1MDglMkMlMjAtMC4wMTQ1JTJDJTIwJTIwLi4uJTJDJTIwJTIwMC4wMDcwJTJDJTIwLTAuMDA4OSUyQyUyMC0wLjAxNjMlNUQlNUQlMkM=",highlighted:`{<span class="hljs-string">&#x27;clip_g&#x27;</span>: tensor(<span class="hljs-string">[[ 0.0077, -0.0112,  0.0065,  ...,  0.0195,  0.0159,  0.0275],
         ...,
         [-0.0170,  0.0213,  0.0143,  ..., -0.0302, -0.0240, -0.0362]]</span>,
 <span class="hljs-string">&#x27;clip_l&#x27;</span>: tensor(<span class="hljs-string">[[ 0.0023,  0.0192,  0.0213,  ..., -0.0385,  0.0048, -0.0011],
         ...,
         [ 0.0475, -0.0508, -0.0145,  ...,  0.0070, -0.0089, -0.0163]]</span>,`,wrap:!1}}),N=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZS5sb2FkX3RleHR1YWxfaW52ZXJzaW9uKHN0YXRlX2RpY3QlNUIlMjJjbGlwX2clMjIlNUQlMkMlMjB0b2tlbiUzRCUyMnVuYWVzdGhldGljWEx2MzElMjIlMkMlMjB0ZXh0X2VuY29kZXIlM0RwaXBlLnRleHRfZW5jb2Rlcl8yJTJDJTIwdG9rZW5pemVyJTNEcGlwZS50b2tlbml6ZXJfMiklMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oc3RhdGVfZGljdCU1QiUyMmNsaXBfbCUyMiU1RCUyQyUyMHRva2VuJTNEJTIydW5hZXN0aGV0aWNYTHYzMSUyMiUyQyUyMHRleHRfZW5jb2RlciUzRHBpcGUudGV4dF9lbmNvZGVyJTJDJTIwdG9rZW5pemVyJTNEcGlwZS50b2tlbml6ZXIpJTBBJTBBJTIzJTIwdGhlJTIwZW1iZWRkaW5nJTIwc2hvdWxkJTIwYmUlMjB1c2VkJTIwYXMlMjBhJTIwbmVnYXRpdmUlMjBlbWJlZGRpbmclMkMlMjBzbyUyMHdlJTIwcGFzcyUyMGl0JTIwYXMlMjBhJTIwbmVnYXRpdmUlMjBwcm9tcHQlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoKS5tYW51YWxfc2VlZCgzMyklMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTIyYSUyMHdvbWFuJTIwc3RhbmRpbmclMjBpbiUyMGZyb250JTIwb2YlMjBhJTIwbW91bnRhaW4lMjIlMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJ1bmFlc3RoZXRpY1hMdjMxJTIyJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipe = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(state_dict[<span class="hljs-string">&quot;clip_g&quot;</span>], token=<span class="hljs-string">&quot;unaestheticXLv31&quot;</span>, text_encoder=pipe.text_encoder_2, tokenizer=pipe.tokenizer_2)
pipe.load_textual_inversion(state_dict[<span class="hljs-string">&quot;clip_l&quot;</span>], token=<span class="hljs-string">&quot;unaestheticXLv31&quot;</span>, text_encoder=pipe.text_encoder, tokenizer=pipe.tokenizer)

<span class="hljs-comment"># the embedding should be used as a negative embedding, so we pass it as a negative prompt</span>
generator = torch.Generator().manual_seed(<span class="hljs-number">33</span>)
image = pipe(<span class="hljs-string">&quot;a woman standing in front of a mountain&quot;</span>, negative_prompt=<span class="hljs-string">&quot;unaestheticXLv31&quot;</span>, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){f=i("meta"),L=n(),Y=i("p"),D=n(),p(w.$$.fragment),A=n(),p(h.$$.fragment),H=n(),U=i("p"),U.innerHTML=he,V=n(),g=i("p"),g.innerHTML=Ue,F=n(),J=i("p"),J.textContent=ge,q=n(),p(T.$$.fragment),E=n(),p(j.$$.fragment),P=n(),_=i("p"),_.innerHTML=Je,K=n(),p(C.$$.fragment),O=n(),Z=i("p"),Z.textContent=Te,ee=n(),p(x.$$.fragment),te=n(),v=i("p"),v.innerHTML=je,le=n(),p(W.$$.fragment),se=n(),k=i("p"),k.innerHTML=_e,ne=n(),p($.$$.fragment),ae=n(),y=i("div"),y.innerHTML=Ce,ie=n(),p(I.$$.fragment),oe=n(),X=i("p"),X.textContent=Ze,pe=n(),G=i("p"),G.textContent=xe,re=n(),p(Q.$$.fragment),Me=n(),p(S.$$.fragment),ce=n(),B=i("p"),B.innerHTML=ve,ue=n(),R=i("p"),R.innerHTML=We,me=n(),p(N.$$.fragment),de=n(),z=i("p"),this.h()},l(e){const t=Se("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(l),L=a(e),Y=o(e,"P",{}),ke(Y).forEach(l),D=a(e),r(w.$$.fragment,e),A=a(e),r(h.$$.fragment,e),H=a(e),U=o(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-27k82r"&&(U.innerHTML=he),V=a(e),g=o(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-wtuhr5"&&(g.innerHTML=Ue),F=a(e),J=o(e,"P",{"data-svelte-h":!0}),M(J)!=="svelte-15b8z8w"&&(J.textContent=ge),q=a(e),r(T.$$.fragment,e),E=a(e),r(j.$$.fragment,e),P=a(e),_=o(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-18oj2l"&&(_.innerHTML=Je),K=a(e),r(C.$$.fragment,e),O=a(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1k989tw"&&(Z.textContent=Te),ee=a(e),r(x.$$.fragment,e),te=a(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-f7pooj"&&(v.innerHTML=je),le=a(e),r(W.$$.fragment,e),se=a(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1wcuuju"&&(k.innerHTML=_e),ne=a(e),r($.$$.fragment,e),ae=a(e),y=o(e,"DIV",{class:!0,"data-svelte-h":!0}),M(y)!=="svelte-1r5zq0s"&&(y.innerHTML=Ce),ie=a(e),r(I.$$.fragment,e),oe=a(e),X=o(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1lq8seo"&&(X.textContent=Ze),pe=a(e),G=o(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-l1ypvx"&&(G.textContent=xe),re=a(e),r(Q.$$.fragment,e),Me=a(e),r(S.$$.fragment,e),ce=a(e),B=o(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-lzfnxp"&&(B.innerHTML=ve),ue=a(e),R=o(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-6qi7u5"&&(R.innerHTML=We),me=a(e),r(N.$$.fragment,e),de=a(e),z=o(e,"P",{}),ke(z).forEach(l),this.h()},h(){ye(f,"name","hf:doc:metadata"),ye(f,"content",Ye),ye(y,"class","flex justify-center")},m(e,t){Be(document.head,f),s(e,L,t),s(e,Y,t),s(e,D,t),c(w,e,t),s(e,A,t),c(h,e,t),s(e,H,t),s(e,U,t),s(e,V,t),s(e,g,t),s(e,F,t),s(e,J,t),s(e,q,t),c(T,e,t),s(e,E,t),c(j,e,t),s(e,P,t),s(e,_,t),s(e,K,t),c(C,e,t),s(e,O,t),s(e,Z,t),s(e,ee,t),c(x,e,t),s(e,te,t),s(e,v,t),s(e,le,t),c(W,e,t),s(e,se,t),s(e,k,t),s(e,ne,t),c($,e,t),s(e,ae,t),s(e,y,t),s(e,ie,t),c(I,e,t),s(e,oe,t),s(e,X,t),s(e,pe,t),s(e,G,t),s(e,re,t),c(Q,e,t),s(e,Me,t),c(S,e,t),s(e,ce,t),s(e,B,t),s(e,ue,t),s(e,R,t),s(e,me,t),c(N,e,t),s(e,de,t),s(e,z,t),fe=!0},p:Ie,i(e){fe||(u(w.$$.fragment,e),u(h.$$.fragment,e),u(T.$$.fragment,e),u(j.$$.fragment,e),u(C.$$.fragment,e),u(x.$$.fragment,e),u(W.$$.fragment,e),u($.$$.fragment,e),u(I.$$.fragment,e),u(Q.$$.fragment,e),u(S.$$.fragment,e),u(N.$$.fragment,e),fe=!0)},o(e){m(w.$$.fragment,e),m(h.$$.fragment,e),m(T.$$.fragment,e),m(j.$$.fragment,e),m(C.$$.fragment,e),m(x.$$.fragment,e),m(W.$$.fragment,e),m($.$$.fragment,e),m(I.$$.fragment,e),m(Q.$$.fragment,e),m(S.$$.fragment,e),m(N.$$.fragment,e),fe=!1},d(e){e&&(l(L),l(Y),l(D),l(A),l(H),l(U),l(V),l(g),l(F),l(J),l(q),l(E),l(P),l(_),l(K),l(O),l(Z),l(ee),l(te),l(v),l(le),l(se),l(k),l(ne),l(ae),l(y),l(ie),l(oe),l(X),l(pe),l(G),l(re),l(Me),l(ce),l(B),l(ue),l(R),l(me),l(de),l(z)),l(f),d(w,e),d(h,e),d(T,e),d(j,e),d(C,e),d(x,e),d(W,e),d($,e),d(I,e),d(Q,e),d(S,e),d(N,e)}}}const Ye='{"title":"Textual inversion","local":"textual-inversion","sections":[{"title":"Stable Diffusion 1 and 2","local":"stable-diffusion-1-and-2","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2}],"depth":1}';function ze(we){return Xe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fe extends Ge{constructor(f){super(),Qe(this,f,ze,Ne,$e,{})}}export{Fe as component};
