import{s as An,o as qn,n as X}from"../chunks/scheduler.182ea377.js";import{S as On,i as Kn,g as d,s,r as g,A as ea,h as p,f as l,c as o,j as $,u as h,x as u,k as J,y as a,a as f,v as _,d as b,t as w,w as y}from"../chunks/index.abf12888.js";import{T as Jt}from"../chunks/Tip.230e2334.js";import{D as j}from"../chunks/Docstring.93f6f462.js";import{C as dt}from"../chunks/CodeBlock.57fe6e13.js";import{E as lt}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as rt}from"../chunks/Heading.16916d63.js";function ta(T){let n,I='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',r,i,m='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){n=d("p"),n.innerHTML=I,r=s(),i=d("p"),i.innerHTML=m},l(t){n=p(t,"P",{"data-svelte-h":!0}),u(n)!=="svelte-1j961ct"&&(n.innerHTML=I),r=o(t),i=p(t,"P",{"data-svelte-h":!0}),u(i)!=="svelte-z4pn9c"&&(i.innerHTML=m)},m(t,v){f(t,n,v),f(t,r,v),f(t,i,v)},p:X,d(t){t&&(l(n),l(r),l(i))}}}function na(T){let n,I="Examples:",r,i,m;return i=new dt({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBQSUwuSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBbWFza19pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKG1hc2tfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLWlucGFpbnRpbmclMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInpaintPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
<span class="hljs-meta">... </span>    response = requests.get(url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=d("p"),n.textContent=I,r=s(),g(i.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),u(n)!=="svelte-kvfsh7"&&(n.textContent=I),r=o(t),h(i.$$.fragment,t)},m(t,v){f(t,n,v),f(t,r,v),_(i,t,v),m=!0},p:X,i(t){m||(b(i.$$.fragment,t),m=!0)},o(t){w(i.$$.fragment,t),m=!1},d(t){t&&(l(n),l(r)),y(i,t)}}}function aa(T){let n,I=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=d("p"),n.innerHTML=I},l(r){n=p(r,"P",{"data-svelte-h":!0}),u(n)!=="svelte-ackzsn"&&(n.innerHTML=I)},m(r,i){f(r,n,i)},p:X,d(r){r&&l(n)}}}function sa(T){let n,I="Examples:",r,i,m;return i=new dt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=d("p"),n.textContent=I,r=s(),g(i.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),u(n)!=="svelte-kvfsh7"&&(n.textContent=I),r=o(t),h(i.$$.fragment,t)},m(t,v){f(t,n,v),f(t,r,v),_(i,t,v),m=!0},p:X,i(t){m||(b(i.$$.fragment,t),m=!0)},o(t){w(i.$$.fragment,t),m=!1},d(t){t&&(l(n),l(r)),y(i,t)}}}function oa(T){let n,I=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=d("p"),n.textContent=I},l(r){n=p(r,"P",{"data-svelte-h":!0}),u(n)!=="svelte-17p1lpg"&&(n.textContent=I)},m(r,i){f(r,n,i)},p:X,d(r){r&&l(n)}}}function ia(T){let n,I="Examples:",r,i,m;return i=new dt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=d("p"),n.textContent=I,r=s(),g(i.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),u(n)!=="svelte-kvfsh7"&&(n.textContent=I),r=o(t),h(i.$$.fragment,t)},m(t,v){f(t,n,v),f(t,r,v),_(i,t,v),m=!0},p:X,i(t){m||(b(i.$$.fragment,t),m=!0)},o(t){w(i.$$.fragment,t),m=!1},d(t){t&&(l(n),l(r)),y(i,t)}}}function la(T){let n,I="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",r,i,m;return i=new dt({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){n=d("p"),n.textContent=I,r=s(),g(i.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),u(n)!=="svelte-1gc783q"&&(n.textContent=I),r=o(t),h(i.$$.fragment,t)},m(t,v){f(t,n,v),f(t,r,v),_(i,t,v),m=!0},p:X,i(t){m||(b(i.$$.fragment,t),m=!0)},o(t){w(i.$$.fragment,t),m=!1},d(t){t&&(l(n),l(r)),y(i,t)}}}function ra(T){let n,I="locally:",r,i,m;return i=new dt({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){n=d("p"),n.textContent=I,r=s(),g(i.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),u(n)!=="svelte-4c75kq"&&(n.textContent=I),r=o(t),h(i.$$.fragment,t)},m(t,v){f(t,n,v),f(t,r,v),_(i,t,v),m=!0},p:X,i(t){m||(b(i.$$.fragment,t),m=!0)},o(t){w(i.$$.fragment,t),m=!1},d(t){t&&(l(n),l(r)),y(i,t)}}}function da(T){let n,I="🧪 This is an experimental feature!";return{c(){n=d("p"),n.textContent=I},l(r){n=p(r,"P",{"data-svelte-h":!0}),u(n)!=="svelte-15q3ih4"&&(n.textContent=I)},m(r,i){f(r,n,i)},p:X,d(r){r&&l(n)}}}function pa(T){let n,I="Examples:",r,i,m;return i=new dt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionInpaintPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
<span class="hljs-meta">... </span>    response = requests.get(url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxStableDiffusionInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;xvjiarui/stable-diffusion-2-inpainting&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">50</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>num_samples = jax.device_count()
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = num_samples * [prompt]
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = num_samples * [init_image]
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = num_samples * [mask_image]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids, processed_masked_images, processed_masks = pipeline.prepare_inputs(
<span class="hljs-meta">... </span>    prompt, init_image, mask_image
<span class="hljs-meta">... </span>)
<span class="hljs-comment"># shard inputs and rng</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>params = replicate(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.split(prng_seed, jax.device_count())
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = shard(prompt_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_masked_images = shard(processed_masked_images)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_masks = shard(processed_masks)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline(
<span class="hljs-meta">... </span>    prompt_ids, processed_masks, processed_masked_images, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))`,wrap:!1}}),{c(){n=d("p"),n.textContent=I,r=s(),g(i.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),u(n)!=="svelte-kvfsh7"&&(n.textContent=I),r=o(t),h(i.$$.fragment,t)},m(t,v){f(t,n,v),f(t,r,v),_(i,t,v),m=!0},p:X,i(t){m||(b(i.$$.fragment,t),m=!0)},o(t){w(i.$$.fragment,t),m=!1},d(t){t&&(l(n),l(r)),y(i,t)}}}function ca(T){let n,I,r,i,m,t,v,xn="The Stable Diffusion model can also be applied to inpainting which lets you edit specific parts of an image by providing a mask and a text prompt using Stable Diffusion.",ct,le,ft,re,In=`It is recommended to use this pipeline with checkpoints that have been specifically fine-tuned for inpainting, such
as <a href="https://huggingface.co/runwayml/stable-diffusion-inpainting" rel="nofollow">runwayml/stable-diffusion-inpainting</a>. Default
text-to-image Stable Diffusion checkpoints, such as
<a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> are also compatible but they might be less performant.`,mt,R,ut,de,gt,x,pe,kt,De,Mn="Pipeline for text-guided image inpainting using Stable Diffusion.",St,Ze,Tn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,jt,We,$n="The pipeline also inherits the following loading methods:",Pt,Ce,Jn='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',Ut,N,ce,Dt,Fe,kn="The call function to the pipeline for generation.",Zt,E,Wt,Z,fe,Ct,Ge,Sn=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Ft,Y,Gt,H,Nt,Q,me,Bt,Ne,jn=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Lt,W,ue,Xt,Be,Pn=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,zt,A,Vt,q,Rt,O,ge,Et,Le,Un='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Yt,k,he,Ht,Xe,Dn=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Qt,ze,Zn="Example:",At,K,qt,Ve,Wn=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Ot,ee,Kt,S,_e,en,Re,Cn=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,tn,Ee,Fn="All kwargs are forwarded to <code>self.lora_state_dict</code>.",nn,Ye,Gn='See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',an,He,Nn=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,sn,Qe,Bn=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,on,te,be,ln,Ae,Ln="Save the LoRA parameters corresponding to the UNet and text encoder.",rn,ne,we,dn,qe,Xn="Encodes the prompt into text encoder hidden states.",pn,ae,ye,cn,Oe,zn='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',ht,ve,_t,z,xe,fn,Ke,Vn="Output class for Stable Diffusion pipelines.",bt,Ie,wt,P,Me,mn,et,Rn="Flax-based pipeline for text-guided image inpainting using Stable Diffusion.",un,se,gn,tt,En=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,hn,B,Te,_n,nt,Yn="Function invoked when calling the pipeline for generation.",bn,oe,yt,$e,vt,C,Je,wn,at,Hn="Output class for Flax-based Stable Diffusion pipelines.",yn,ie,ke,vn,st,Qn="“Returns a new object replacing the specified fields with new values.",xt,pt,It;return m=new rt({props:{title:"Inpainting",local:"inpainting",headingTag:"h1"}}),le=new rt({props:{title:"Tips",local:"tips",headingTag:"h2"}}),R=new Jt({props:{$$slots:{default:[ta]},$$scope:{ctx:T}}}),de=new rt({props:{title:"StableDiffusionInpaintPipeline",local:"diffusers.StableDiffusionInpaintPipeline",headingTag:"h2"}}),pe=new j({props:{name:"class diffusers.StableDiffusionInpaintPipeline",anchor:"diffusers.StableDiffusionInpaintPipeline",parameters:[{name:"vae",val:": Union"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.vae",description:`<strong>vae</strong> ([<code>AutoencoderKL</code>, <code>AsymmetricAutoencoderKL</code>]) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionInpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionInpaintPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionInpaintPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L221"}}),ce=new j({props:{name:"__call__",anchor:"diffusers.StableDiffusionInpaintPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"mask_image",val:": Union = None"},{name:"masked_image_latents",val:": FloatTensor = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"padding_mask_crop",val:": Optional = None"},{name:"strength",val:": float = 1.0"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": int = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be inpainted (which parts of the image to
be masked out with <code>mask_image</code> and repainted according to <code>prompt</code>). For both numpy array and pytorch
tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list or tensors, the
expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a list of arrays, the
expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image latents as <code>image</code>, but
if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L969",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),E=new lt({props:{anchor:"diffusers.StableDiffusionInpaintPipeline.__call__.example",$$slots:{default:[na]},$$scope:{ctx:T}}}),fe=new j({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionInpaintPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1614"}}),Y=new Jt({props:{warning:!0,$$slots:{default:[aa]},$$scope:{ctx:T}}}),H=new lt({props:{anchor:"diffusers.StableDiffusionInpaintPipeline.enable_attention_slicing.example",$$slots:{default:[sa]},$$scope:{ctx:T}}}),me=new j({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionInpaintPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1654"}}),ue=new j({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionInpaintPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1553"}}),A=new Jt({props:{warning:!0,$$slots:{default:[oa]},$$scope:{ctx:T}}}),q=new lt({props:{anchor:"diffusers.StableDiffusionInpaintPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ia]},$$scope:{ctx:T}}}),ge=new j({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionInpaintPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1588"}}),he=new j({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L266"}}),K=new lt({props:{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.example",$$slots:{default:[la]},$$scope:{ctx:T}}}),ee=new lt({props:{anchor:"diffusers.StableDiffusionInpaintPipeline.load_textual_inversion.example-2",$$slots:{default:[ra]},$$scope:{ctx:T}}}),_e=new j({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionInpaintPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": Union"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionInpaintPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L82"}}),be=new j({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionInpaintPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": Union"},{name:"unet_lora_layers",val:": Dict = None"},{name:"text_encoder_lora_layers",val:": Dict = None"},{name:"transformer_lora_layers",val:": Dict = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionInpaintPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionInpaintPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionInpaintPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionInpaintPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionInpaintPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L734"}}),we=new j({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionInpaintPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L401"}}),ye=new j({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionInpaintPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInpaintPipeline.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.StableDiffusionInpaintPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.StableDiffusionInpaintPipeline.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L912",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),ve=new rt({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),xe=new j({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),Ie=new rt({props:{title:"FlaxStableDiffusionInpaintPipeline",local:"diffusers.FlaxStableDiffusionInpaintPipeline",headingTag:"h2"}}),Me=new j({props:{name:"class diffusers.FlaxStableDiffusionInpaintPipeline",anchor:"diffusers.FlaxStableDiffusionInpaintPipeline",parameters:[{name:"vae",val:": FlaxAutoencoderKL"},{name:"text_encoder",val:": FlaxCLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": FlaxUNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"safety_checker",val:": FlaxStableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.FlaxAutoencoderKL">FlaxAutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPTextModel" rel="nofollow">FlaxCLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.FlaxUNet2DConditionModel">FlaxUNet2DConditionModel</a>) &#x2014;
A <code>FlaxUNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<code>FlaxDDIMScheduler</code>, <code>FlaxLMSDiscreteScheduler</code>, <code>FlaxPNDMScheduler</code>, or
<code>FlaxDPMSolverMultistepScheduler</code>.`,name:"scheduler"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>FlaxStableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion_inpaint.py#L102"}}),se=new Jt({props:{warning:!0,$$slots:{default:[da]},$$scope:{ctx:T}}}),Te=new j({props:{name:"__call__",anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__",parameters:[{name:"prompt_ids",val:": Array"},{name:"mask",val:": Array"},{name:"masked_image",val:": Array"},{name:"params",val:": Union"},{name:"prng_seed",val:": Array"},{name:"num_inference_steps",val:": int = 50"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"guidance_scale",val:": Union = 7.5"},{name:"latents",val:": Array = None"},{name:"neg_prompt_ids",val:": Array = None"},{name:"return_dict",val:": bool = True"},{name:"jit",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>jnp.ndarray</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
array is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.jit",description:`<strong>jit</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to run <code>pmap</code> versions of the generation and safety scoring functions.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This argument exists because <code>__call__</code> is not yet end-to-end pmap-able. It will be removed in a
future release.</p>

					</div>`,name:"jit"},{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput">FlaxStableDiffusionPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion_inpaint.py#L394",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated images
and the second element is a list of <code>bool</code>s indicating whether the corresponding generated image
contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),oe=new lt({props:{anchor:"diffusers.FlaxStableDiffusionInpaintPipeline.__call__.example",$$slots:{default:[pa]},$$scope:{ctx:T}}}),$e=new rt({props:{title:"FlaxStableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",headingTag:"h2"}}),Je=new j({props:{name:"class diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",parameters:[{name:"images",val:": ndarray"},{name:"nsfw_content_detected",val:": List"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
Denoised images of array shape of <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content
or <code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L31"}}),ke=new j({props:{name:"replace",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/flax/struct.py#L111"}}),{c(){n=d("meta"),I=s(),r=d("p"),i=s(),g(m.$$.fragment),t=s(),v=d("p"),v.textContent=xn,ct=s(),g(le.$$.fragment),ft=s(),re=d("p"),re.innerHTML=In,mt=s(),g(R.$$.fragment),ut=s(),g(de.$$.fragment),gt=s(),x=d("div"),g(pe.$$.fragment),kt=s(),De=d("p"),De.textContent=Mn,St=s(),Ze=d("p"),Ze.innerHTML=Tn,jt=s(),We=d("p"),We.textContent=$n,Pt=s(),Ce=d("ul"),Ce.innerHTML=Jn,Ut=s(),N=d("div"),g(ce.$$.fragment),Dt=s(),Fe=d("p"),Fe.textContent=kn,Zt=s(),g(E.$$.fragment),Wt=s(),Z=d("div"),g(fe.$$.fragment),Ct=s(),Ge=d("p"),Ge.textContent=Sn,Ft=s(),g(Y.$$.fragment),Gt=s(),g(H.$$.fragment),Nt=s(),Q=d("div"),g(me.$$.fragment),Bt=s(),Ne=d("p"),Ne.innerHTML=jn,Lt=s(),W=d("div"),g(ue.$$.fragment),Xt=s(),Be=d("p"),Be.innerHTML=Pn,zt=s(),g(A.$$.fragment),Vt=s(),g(q.$$.fragment),Rt=s(),O=d("div"),g(ge.$$.fragment),Et=s(),Le=d("p"),Le.innerHTML=Un,Yt=s(),k=d("div"),g(he.$$.fragment),Ht=s(),Xe=d("p"),Xe.innerHTML=Dn,Qt=s(),ze=d("p"),ze.textContent=Zn,At=s(),g(K.$$.fragment),qt=s(),Ve=d("p"),Ve.innerHTML=Wn,Ot=s(),g(ee.$$.fragment),Kt=s(),S=d("div"),g(_e.$$.fragment),en=s(),Re=d("p"),Re.innerHTML=Cn,tn=s(),Ee=d("p"),Ee.innerHTML=Fn,nn=s(),Ye=d("p"),Ye.innerHTML=Gn,an=s(),He=d("p"),He.innerHTML=Nn,sn=s(),Qe=d("p"),Qe.innerHTML=Bn,on=s(),te=d("div"),g(be.$$.fragment),ln=s(),Ae=d("p"),Ae.textContent=Ln,rn=s(),ne=d("div"),g(we.$$.fragment),dn=s(),qe=d("p"),qe.textContent=Xn,pn=s(),ae=d("div"),g(ye.$$.fragment),cn=s(),Oe=d("p"),Oe.innerHTML=zn,ht=s(),g(ve.$$.fragment),_t=s(),z=d("div"),g(xe.$$.fragment),fn=s(),Ke=d("p"),Ke.textContent=Vn,bt=s(),g(Ie.$$.fragment),wt=s(),P=d("div"),g(Me.$$.fragment),mn=s(),et=d("p"),et.textContent=Rn,un=s(),g(se.$$.fragment),gn=s(),tt=d("p"),tt.innerHTML=En,hn=s(),B=d("div"),g(Te.$$.fragment),_n=s(),nt=d("p"),nt.textContent=Yn,bn=s(),g(oe.$$.fragment),yt=s(),g($e.$$.fragment),vt=s(),C=d("div"),g(Je.$$.fragment),wn=s(),at=d("p"),at.textContent=Hn,yn=s(),ie=d("div"),g(ke.$$.fragment),vn=s(),st=d("p"),st.textContent=Qn,xt=s(),pt=d("p"),this.h()},l(e){const c=ea("svelte-u9bgzb",document.head);n=p(c,"META",{name:!0,content:!0}),c.forEach(l),I=o(e),r=p(e,"P",{}),$(r).forEach(l),i=o(e),h(m.$$.fragment,e),t=o(e),v=p(e,"P",{"data-svelte-h":!0}),u(v)!=="svelte-duffv7"&&(v.textContent=xn),ct=o(e),h(le.$$.fragment,e),ft=o(e),re=p(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-92b9uj"&&(re.innerHTML=In),mt=o(e),h(R.$$.fragment,e),ut=o(e),h(de.$$.fragment,e),gt=o(e),x=p(e,"DIV",{class:!0});var M=$(x);h(pe.$$.fragment,M),kt=o(M),De=p(M,"P",{"data-svelte-h":!0}),u(De)!=="svelte-80nqwb"&&(De.textContent=Mn),St=o(M),Ze=p(M,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-496sm0"&&(Ze.innerHTML=Tn),jt=o(M),We=p(M,"P",{"data-svelte-h":!0}),u(We)!=="svelte-14s6m4u"&&(We.textContent=$n),Pt=o(M),Ce=p(M,"UL",{"data-svelte-h":!0}),u(Ce)!=="svelte-14gz7a6"&&(Ce.innerHTML=Jn),Ut=o(M),N=p(M,"DIV",{class:!0});var V=$(N);h(ce.$$.fragment,V),Dt=o(V),Fe=p(V,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-50j04k"&&(Fe.textContent=kn),Zt=o(V),h(E.$$.fragment,V),V.forEach(l),Wt=o(M),Z=p(M,"DIV",{class:!0});var F=$(Z);h(fe.$$.fragment,F),Ct=o(F),Ge=p(F,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-10jaql7"&&(Ge.textContent=Sn),Ft=o(F),h(Y.$$.fragment,F),Gt=o(F),h(H.$$.fragment,F),F.forEach(l),Nt=o(M),Q=p(M,"DIV",{class:!0});var Se=$(Q);h(me.$$.fragment,Se),Bt=o(Se),Ne=p(Se,"P",{"data-svelte-h":!0}),u(Ne)!=="svelte-1lh0nh5"&&(Ne.innerHTML=jn),Se.forEach(l),Lt=o(M),W=p(M,"DIV",{class:!0});var G=$(W);h(ue.$$.fragment,G),Xt=o(G),Be=p(G,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-e03q3e"&&(Be.innerHTML=Pn),zt=o(G),h(A.$$.fragment,G),Vt=o(G),h(q.$$.fragment,G),G.forEach(l),Rt=o(M),O=p(M,"DIV",{class:!0});var je=$(O);h(ge.$$.fragment,je),Et=o(je),Le=p(je,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-1vfte1e"&&(Le.innerHTML=Un),je.forEach(l),Yt=o(M),k=p(M,"DIV",{class:!0});var U=$(k);h(he.$$.fragment,U),Ht=o(U),Xe=p(U,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-1lv88wo"&&(Xe.innerHTML=Dn),Qt=o(U),ze=p(U,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-11lpom8"&&(ze.textContent=Zn),At=o(U),h(K.$$.fragment,U),qt=o(U),Ve=p(U,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-15d7mv5"&&(Ve.innerHTML=Wn),Ot=o(U),h(ee.$$.fragment,U),U.forEach(l),Kt=o(M),S=p(M,"DIV",{class:!0});var D=$(S);h(_e.$$.fragment,D),en=o(D),Re=p(D,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-vs7s0z"&&(Re.innerHTML=Cn),tn=o(D),Ee=p(D,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-15b960v"&&(Ee.innerHTML=Fn),nn=o(D),Ye=p(D,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-12uyc98"&&(Ye.innerHTML=Gn),an=o(D),He=p(D,"P",{"data-svelte-h":!0}),u(He)!=="svelte-1q3yzk7"&&(He.innerHTML=Nn),sn=o(D),Qe=p(D,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-10xxjud"&&(Qe.innerHTML=Bn),D.forEach(l),on=o(M),te=p(M,"DIV",{class:!0});var Pe=$(te);h(be.$$.fragment,Pe),ln=o(Pe),Ae=p(Pe,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-1ufq5ot"&&(Ae.textContent=Ln),Pe.forEach(l),rn=o(M),ne=p(M,"DIV",{class:!0});var Ue=$(ne);h(we.$$.fragment,Ue),dn=o(Ue),qe=p(Ue,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-16q0ax1"&&(qe.textContent=Xn),Ue.forEach(l),pn=o(M),ae=p(M,"DIV",{class:!0});var Mt=$(ae);h(ye.$$.fragment,Mt),cn=o(Mt),Oe=p(Mt,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-vo59ec"&&(Oe.innerHTML=zn),Mt.forEach(l),M.forEach(l),ht=o(e),h(ve.$$.fragment,e),_t=o(e),z=p(e,"DIV",{class:!0});var Tt=$(z);h(xe.$$.fragment,Tt),fn=o(Tt),Ke=p(Tt,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-1qpjiuf"&&(Ke.textContent=Vn),Tt.forEach(l),bt=o(e),h(Ie.$$.fragment,e),wt=o(e),P=p(e,"DIV",{class:!0});var L=$(P);h(Me.$$.fragment,L),mn=o(L),et=p(L,"P",{"data-svelte-h":!0}),u(et)!=="svelte-1ieif9y"&&(et.textContent=Rn),un=o(L),h(se.$$.fragment,L),gn=o(L),tt=p(L,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-knddhk"&&(tt.innerHTML=En),hn=o(L),B=p(L,"DIV",{class:!0});var ot=$(B);h(Te.$$.fragment,ot),_n=o(ot),nt=p(ot,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-v78lg8"&&(nt.textContent=Yn),bn=o(ot),h(oe.$$.fragment,ot),ot.forEach(l),L.forEach(l),yt=o(e),h($e.$$.fragment,e),vt=o(e),C=p(e,"DIV",{class:!0});var it=$(C);h(Je.$$.fragment,it),wn=o(it),at=p(it,"P",{"data-svelte-h":!0}),u(at)!=="svelte-wzv2jc"&&(at.textContent=Hn),yn=o(it),ie=p(it,"DIV",{class:!0});var $t=$(ie);h(ke.$$.fragment,$t),vn=o($t),st=p($t,"P",{"data-svelte-h":!0}),u(st)!=="svelte-5ihtpa"&&(st.textContent=Qn),$t.forEach(l),it.forEach(l),xt=o(e),pt=p(e,"P",{}),$(pt).forEach(l),this.h()},h(){J(n,"name","hf:doc:metadata"),J(n,"content",fa),J(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){a(document.head,n),f(e,I,c),f(e,r,c),f(e,i,c),_(m,e,c),f(e,t,c),f(e,v,c),f(e,ct,c),_(le,e,c),f(e,ft,c),f(e,re,c),f(e,mt,c),_(R,e,c),f(e,ut,c),_(de,e,c),f(e,gt,c),f(e,x,c),_(pe,x,null),a(x,kt),a(x,De),a(x,St),a(x,Ze),a(x,jt),a(x,We),a(x,Pt),a(x,Ce),a(x,Ut),a(x,N),_(ce,N,null),a(N,Dt),a(N,Fe),a(N,Zt),_(E,N,null),a(x,Wt),a(x,Z),_(fe,Z,null),a(Z,Ct),a(Z,Ge),a(Z,Ft),_(Y,Z,null),a(Z,Gt),_(H,Z,null),a(x,Nt),a(x,Q),_(me,Q,null),a(Q,Bt),a(Q,Ne),a(x,Lt),a(x,W),_(ue,W,null),a(W,Xt),a(W,Be),a(W,zt),_(A,W,null),a(W,Vt),_(q,W,null),a(x,Rt),a(x,O),_(ge,O,null),a(O,Et),a(O,Le),a(x,Yt),a(x,k),_(he,k,null),a(k,Ht),a(k,Xe),a(k,Qt),a(k,ze),a(k,At),_(K,k,null),a(k,qt),a(k,Ve),a(k,Ot),_(ee,k,null),a(x,Kt),a(x,S),_(_e,S,null),a(S,en),a(S,Re),a(S,tn),a(S,Ee),a(S,nn),a(S,Ye),a(S,an),a(S,He),a(S,sn),a(S,Qe),a(x,on),a(x,te),_(be,te,null),a(te,ln),a(te,Ae),a(x,rn),a(x,ne),_(we,ne,null),a(ne,dn),a(ne,qe),a(x,pn),a(x,ae),_(ye,ae,null),a(ae,cn),a(ae,Oe),f(e,ht,c),_(ve,e,c),f(e,_t,c),f(e,z,c),_(xe,z,null),a(z,fn),a(z,Ke),f(e,bt,c),_(Ie,e,c),f(e,wt,c),f(e,P,c),_(Me,P,null),a(P,mn),a(P,et),a(P,un),_(se,P,null),a(P,gn),a(P,tt),a(P,hn),a(P,B),_(Te,B,null),a(B,_n),a(B,nt),a(B,bn),_(oe,B,null),f(e,yt,c),_($e,e,c),f(e,vt,c),f(e,C,c),_(Je,C,null),a(C,wn),a(C,at),a(C,yn),a(C,ie),_(ke,ie,null),a(ie,vn),a(ie,st),f(e,xt,c),f(e,pt,c),It=!0},p(e,[c]){const M={};c&2&&(M.$$scope={dirty:c,ctx:e}),R.$set(M);const V={};c&2&&(V.$$scope={dirty:c,ctx:e}),E.$set(V);const F={};c&2&&(F.$$scope={dirty:c,ctx:e}),Y.$set(F);const Se={};c&2&&(Se.$$scope={dirty:c,ctx:e}),H.$set(Se);const G={};c&2&&(G.$$scope={dirty:c,ctx:e}),A.$set(G);const je={};c&2&&(je.$$scope={dirty:c,ctx:e}),q.$set(je);const U={};c&2&&(U.$$scope={dirty:c,ctx:e}),K.$set(U);const D={};c&2&&(D.$$scope={dirty:c,ctx:e}),ee.$set(D);const Pe={};c&2&&(Pe.$$scope={dirty:c,ctx:e}),se.$set(Pe);const Ue={};c&2&&(Ue.$$scope={dirty:c,ctx:e}),oe.$set(Ue)},i(e){It||(b(m.$$.fragment,e),b(le.$$.fragment,e),b(R.$$.fragment,e),b(de.$$.fragment,e),b(pe.$$.fragment,e),b(ce.$$.fragment,e),b(E.$$.fragment,e),b(fe.$$.fragment,e),b(Y.$$.fragment,e),b(H.$$.fragment,e),b(me.$$.fragment,e),b(ue.$$.fragment,e),b(A.$$.fragment,e),b(q.$$.fragment,e),b(ge.$$.fragment,e),b(he.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(_e.$$.fragment,e),b(be.$$.fragment,e),b(we.$$.fragment,e),b(ye.$$.fragment,e),b(ve.$$.fragment,e),b(xe.$$.fragment,e),b(Ie.$$.fragment,e),b(Me.$$.fragment,e),b(se.$$.fragment,e),b(Te.$$.fragment,e),b(oe.$$.fragment,e),b($e.$$.fragment,e),b(Je.$$.fragment,e),b(ke.$$.fragment,e),It=!0)},o(e){w(m.$$.fragment,e),w(le.$$.fragment,e),w(R.$$.fragment,e),w(de.$$.fragment,e),w(pe.$$.fragment,e),w(ce.$$.fragment,e),w(E.$$.fragment,e),w(fe.$$.fragment,e),w(Y.$$.fragment,e),w(H.$$.fragment,e),w(me.$$.fragment,e),w(ue.$$.fragment,e),w(A.$$.fragment,e),w(q.$$.fragment,e),w(ge.$$.fragment,e),w(he.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(_e.$$.fragment,e),w(be.$$.fragment,e),w(we.$$.fragment,e),w(ye.$$.fragment,e),w(ve.$$.fragment,e),w(xe.$$.fragment,e),w(Ie.$$.fragment,e),w(Me.$$.fragment,e),w(se.$$.fragment,e),w(Te.$$.fragment,e),w(oe.$$.fragment,e),w($e.$$.fragment,e),w(Je.$$.fragment,e),w(ke.$$.fragment,e),It=!1},d(e){e&&(l(I),l(r),l(i),l(t),l(v),l(ct),l(ft),l(re),l(mt),l(ut),l(gt),l(x),l(ht),l(_t),l(z),l(bt),l(wt),l(P),l(yt),l(vt),l(C),l(xt),l(pt)),l(n),y(m,e),y(le,e),y(R,e),y(de,e),y(pe),y(ce),y(E),y(fe),y(Y),y(H),y(me),y(ue),y(A),y(q),y(ge),y(he),y(K),y(ee),y(_e),y(be),y(we),y(ye),y(ve,e),y(xe),y(Ie,e),y(Me),y(se),y(Te),y(oe),y($e,e),y(Je),y(ke)}}}const fa='{"title":"Inpainting","local":"inpainting","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"StableDiffusionInpaintPipeline","local":"diffusers.StableDiffusionInpaintPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2},{"title":"FlaxStableDiffusionInpaintPipeline","local":"diffusers.FlaxStableDiffusionInpaintPipeline","sections":[],"depth":2},{"title":"FlaxStableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function ma(T){return qn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class va extends On{constructor(n){super(),Kn(this,n,ma,ca,An,{})}}export{va as component};
