import{s as pt,o as ct,n as me}from"../chunks/scheduler.182ea377.js";import{S as dt,i as ft,g as c,s as l,r as _,A as ut,h as d,f as o,c as r,j as Z,u as y,x as U,k as C,y as a,a as g,v as w,d as $,t as v,w as T}from"../chunks/index.abf12888.js";import{T as Ye}from"../chunks/Tip.230e2334.js";import{D as F}from"../chunks/Docstring.93f6f462.js";import{C as Qe}from"../chunks/CodeBlock.57fe6e13.js";import{E as He}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as qe}from"../chunks/Heading.16916d63.js";function mt(J){let n,b='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',i,s,u='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){n=c("p"),n.innerHTML=b,i=l(),s=c("p"),s.innerHTML=u},l(t){n=d(t,"P",{"data-svelte-h":!0}),U(n)!=="svelte-1j961ct"&&(n.innerHTML=b),i=r(t),s=d(t,"P",{"data-svelte-h":!0}),U(s)!=="svelte-z4pn9c"&&(s.innerHTML=u)},m(t,h){g(t,n,h),g(t,i,h),g(t,s,h)},p:me,d(t){t&&(o(n),o(i),o(s))}}}function gt(J){let n,b="Examples:",i,s,u;return s=new Qe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkxhdGVudFVwc2NhbGVQaXBlbGluZSUyQyUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnNkLXgyLWxhdGVudC11cHNjYWxlciUyMiUwQXVwc2NhbGVyJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uTGF0ZW50VXBzY2FsZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEF1cHNjYWxlci50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjBoaWdoJTIwcmVzb2x1dGlvbiUyQyUyMHVucmVhbCUyMGVuZ2luZSUyQyUyMHVsdHJhJTIwcmVhbGlzdGljJTIyJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoMzMpJTBBJTBBbG93X3Jlc19sYXRlbnRzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIpLmltYWdlcyUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGVsaW5lLmRlY29kZV9sYXRlbnRzKGxvd19yZXNfbGF0ZW50cyklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lLm51bXB5X3RvX3BpbChpbWFnZSklNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjIuLiUyRmltYWdlcyUyRmExLnBuZyUyMiklMEElMEF1cHNjYWxlZF9pbWFnZSUyMCUzRCUyMHVwc2NhbGVyKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEbG93X3Jlc19sYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBdXBzY2FsZWRfaW1hZ2Uuc2F2ZSglMjIuLiUyRmltYWdlcyUyRmEyLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionLatentUpscalePipeline, StableDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch


<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/sd-x2-latent-upscaler&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaler = StableDiffusionLatentUpscalePipeline.from_pretrained(model_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaler.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut high resolution, unreal engine, ultra realistic&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">33</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_latents = pipeline(prompt, generator=generator, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    image = pipeline.decode_latents(low_res_latents)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipeline.numpy_to_pil(image)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;../images/a1.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image = upscaler(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    image=low_res_latents,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image.save(<span class="hljs-string">&quot;../images/a2.png&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=b,i=l(),_(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),U(n)!=="svelte-kvfsh7"&&(n.textContent=b),i=r(t),y(s.$$.fragment,t)},m(t,h){g(t,n,h),g(t,i,h),w(s,t,h),u=!0},p:me,i(t){u||($(s.$$.fragment,t),u=!0)},o(t){v(s.$$.fragment,t),u=!1},d(t){t&&(o(n),o(i)),T(s,t)}}}function ht(J){let n,b=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=c("p"),n.innerHTML=b},l(i){n=d(i,"P",{"data-svelte-h":!0}),U(n)!=="svelte-ackzsn"&&(n.innerHTML=b)},m(i,s){g(i,n,s)},p:me,d(i){i&&o(n)}}}function bt(J){let n,b="Examples:",i,s,u;return s=new Qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=c("p"),n.textContent=b,i=l(),_(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),U(n)!=="svelte-kvfsh7"&&(n.textContent=b),i=r(t),y(s.$$.fragment,t)},m(t,h){g(t,n,h),g(t,i,h),w(s,t,h),u=!0},p:me,i(t){u||($(s.$$.fragment,t),u=!0)},o(t){v(s.$$.fragment,t),u=!1},d(t){t&&(o(n),o(i)),T(s,t)}}}function _t(J){let n,b=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=c("p"),n.textContent=b},l(i){n=d(i,"P",{"data-svelte-h":!0}),U(n)!=="svelte-17p1lpg"&&(n.textContent=b)},m(i,s){g(i,n,s)},p:me,d(i){i&&o(n)}}}function yt(J){let n,b="Examples:",i,s,u;return s=new Qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=b,i=l(),_(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),U(n)!=="svelte-kvfsh7"&&(n.textContent=b),i=r(t),y(s.$$.fragment,t)},m(t,h){g(t,n,h),g(t,i,h),w(s,t,h),u=!0},p:me,i(t){u||($(s.$$.fragment,t),u=!0)},o(t){v(s.$$.fragment,t),u=!1},d(t){t&&(o(n),o(i)),T(s,t)}}}function wt(J){let n,b,i,s,u,t,h,Ae='The Stable Diffusion latent upscaler model was created by <a href="https://github.com/crowsonkb/k-diffusion" rel="nofollow">Katherine Crowson</a> in collaboration with <a href="https://stability.ai/" rel="nofollow">Stability AI</a>. It is used to enhance the output image resolution by a factor of 2 (see this demo <a href="https://colab.research.google.com/drive/1o1qYJcFeywzCIdkfKJy7cTpgZTCM2EI4" rel="nofollow">notebook</a> for a demonstration of the original implementation).',he,S,be,N,_e,f,z,Je,se,Oe="Pipeline for upscaling Stable Diffusion output image resolution by a factor of 2.",xe,ae,Ke=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Me,ie,et="The pipeline also inherits the following loading methods:",je,oe,tt='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',Ie,D,Y,De,le,nt="The call function to the pipeline for generation.",Ze,G,Ce,W,H,Le,re,st=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to GPU only when their specific submodule has its <code>forward</code>
method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,Pe,x,q,Se,pe,at=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Ge,k,We,V,ke,B,Q,Ve,ce,it=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Be,M,A,Ee,de,ot=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Re,E,Xe,R,Fe,X,O,Ne,fe,lt='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',ye,K,we,L,ee,ze,ue,rt="Output class for Stable Diffusion pipelines.",$e,ge,ve;return u=new qe({props:{title:"Latent upscaler",local:"latent-upscaler",headingTag:"h1"}}),S=new Ye({props:{$$slots:{default:[mt]},$$scope:{ctx:J}}}),N=new qe({props:{title:"StableDiffusionLatentUpscalePipeline",local:"diffusers.StableDiffusionLatentUpscalePipeline",headingTag:"h2"}}),z=new F({props:{name:"class diffusers.StableDiffusionLatentUpscalePipeline",anchor:"diffusers.StableDiffusionLatentUpscalePipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": EulerDiscreteScheduler"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L63"}}),Y=new F({props:{name:"__call__",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union = None"},{name:"num_inference_steps",val:": int = 75"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": Union = None"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide image upscaling.`,name:"prompt"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be upscaled. If it&#x2019;s a tensor, it can be either a
latent output from a Stable Diffusion model or an image tensor in the range <code>[-1, 1]</code>. It is considered
a <code>latent</code> if <code>image.shape[1]</code> is <code>4</code>; otherwise, it is considered to be an image representation and
encoded using this pipeline&#x2019;s <code>vae</code> encoder.`,name:"image"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L261",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),G=new He({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.example",$$slots:{default:[gt]},$$scope:{ctx:J}}}),H=new F({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1037"}}),q=new F({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1614"}}),k=new Ye({props:{warning:!0,$$slots:{default:[ht]},$$scope:{ctx:J}}}),V=new He({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing.example",$$slots:{default:[bt]},$$scope:{ctx:J}}}),Q=new F({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1654"}}),A=new F({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1553"}}),E=new Ye({props:{warning:!0,$$slots:{default:[_t]},$$scope:{ctx:J}}}),R=new He({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[yt]},$$scope:{ctx:J}}}),O=new F({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1588"}}),K=new qe({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),ee=new F({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),{c(){n=c("meta"),b=l(),i=c("p"),s=l(),_(u.$$.fragment),t=l(),h=c("p"),h.innerHTML=Ae,he=l(),_(S.$$.fragment),be=l(),_(N.$$.fragment),_e=l(),f=c("div"),_(z.$$.fragment),Je=l(),se=c("p"),se.textContent=Oe,xe=l(),ae=c("p"),ae.innerHTML=Ke,Me=l(),ie=c("p"),ie.textContent=et,je=l(),oe=c("ul"),oe.innerHTML=tt,Ie=l(),D=c("div"),_(Y.$$.fragment),De=l(),le=c("p"),le.textContent=nt,Ze=l(),_(G.$$.fragment),Ce=l(),W=c("div"),_(H.$$.fragment),Le=l(),re=c("p"),re.innerHTML=st,Pe=l(),x=c("div"),_(q.$$.fragment),Se=l(),pe=c("p"),pe.textContent=at,Ge=l(),_(k.$$.fragment),We=l(),_(V.$$.fragment),ke=l(),B=c("div"),_(Q.$$.fragment),Ve=l(),ce=c("p"),ce.innerHTML=it,Be=l(),M=c("div"),_(A.$$.fragment),Ee=l(),de=c("p"),de.innerHTML=ot,Re=l(),_(E.$$.fragment),Xe=l(),_(R.$$.fragment),Fe=l(),X=c("div"),_(O.$$.fragment),Ne=l(),fe=c("p"),fe.innerHTML=lt,ye=l(),_(K.$$.fragment),we=l(),L=c("div"),_(ee.$$.fragment),ze=l(),ue=c("p"),ue.textContent=rt,$e=l(),ge=c("p"),this.h()},l(e){const p=ut("svelte-u9bgzb",document.head);n=d(p,"META",{name:!0,content:!0}),p.forEach(o),b=r(e),i=d(e,"P",{}),Z(i).forEach(o),s=r(e),y(u.$$.fragment,e),t=r(e),h=d(e,"P",{"data-svelte-h":!0}),U(h)!=="svelte-1gpdp46"&&(h.innerHTML=Ae),he=r(e),y(S.$$.fragment,e),be=r(e),y(N.$$.fragment,e),_e=r(e),f=d(e,"DIV",{class:!0});var m=Z(f);y(z.$$.fragment,m),Je=r(m),se=d(m,"P",{"data-svelte-h":!0}),U(se)!=="svelte-s74qtl"&&(se.textContent=Oe),xe=r(m),ae=d(m,"P",{"data-svelte-h":!0}),U(ae)!=="svelte-496sm0"&&(ae.innerHTML=Ke),Me=r(m),ie=d(m,"P",{"data-svelte-h":!0}),U(ie)!=="svelte-14s6m4u"&&(ie.textContent=et),je=r(m),oe=d(m,"UL",{"data-svelte-h":!0}),U(oe)!=="svelte-1hpayfe"&&(oe.innerHTML=tt),Ie=r(m),D=d(m,"DIV",{class:!0});var P=Z(D);y(Y.$$.fragment,P),De=r(P),le=d(P,"P",{"data-svelte-h":!0}),U(le)!=="svelte-50j04k"&&(le.textContent=nt),Ze=r(P),y(G.$$.fragment,P),P.forEach(o),Ce=r(m),W=d(m,"DIV",{class:!0});var te=Z(W);y(H.$$.fragment,te),Le=r(te),re=d(te,"P",{"data-svelte-h":!0}),U(re)!=="svelte-n1oyuv"&&(re.innerHTML=st),te.forEach(o),Pe=r(m),x=d(m,"DIV",{class:!0});var j=Z(x);y(q.$$.fragment,j),Se=r(j),pe=d(j,"P",{"data-svelte-h":!0}),U(pe)!=="svelte-10jaql7"&&(pe.textContent=at),Ge=r(j),y(k.$$.fragment,j),We=r(j),y(V.$$.fragment,j),j.forEach(o),ke=r(m),B=d(m,"DIV",{class:!0});var ne=Z(B);y(Q.$$.fragment,ne),Ve=r(ne),ce=d(ne,"P",{"data-svelte-h":!0}),U(ce)!=="svelte-1lh0nh5"&&(ce.innerHTML=it),ne.forEach(o),Be=r(m),M=d(m,"DIV",{class:!0});var I=Z(M);y(A.$$.fragment,I),Ee=r(I),de=d(I,"P",{"data-svelte-h":!0}),U(de)!=="svelte-e03q3e"&&(de.innerHTML=ot),Re=r(I),y(E.$$.fragment,I),Xe=r(I),y(R.$$.fragment,I),I.forEach(o),Fe=r(m),X=d(m,"DIV",{class:!0});var Te=Z(X);y(O.$$.fragment,Te),Ne=r(Te),fe=d(Te,"P",{"data-svelte-h":!0}),U(fe)!=="svelte-1vfte1e"&&(fe.innerHTML=lt),Te.forEach(o),m.forEach(o),ye=r(e),y(K.$$.fragment,e),we=r(e),L=d(e,"DIV",{class:!0});var Ue=Z(L);y(ee.$$.fragment,Ue),ze=r(Ue),ue=d(Ue,"P",{"data-svelte-h":!0}),U(ue)!=="svelte-1qpjiuf"&&(ue.textContent=rt),Ue.forEach(o),$e=r(e),ge=d(e,"P",{}),Z(ge).forEach(o),this.h()},h(){C(n,"name","hf:doc:metadata"),C(n,"content",$t),C(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){a(document.head,n),g(e,b,p),g(e,i,p),g(e,s,p),w(u,e,p),g(e,t,p),g(e,h,p),g(e,he,p),w(S,e,p),g(e,be,p),w(N,e,p),g(e,_e,p),g(e,f,p),w(z,f,null),a(f,Je),a(f,se),a(f,xe),a(f,ae),a(f,Me),a(f,ie),a(f,je),a(f,oe),a(f,Ie),a(f,D),w(Y,D,null),a(D,De),a(D,le),a(D,Ze),w(G,D,null),a(f,Ce),a(f,W),w(H,W,null),a(W,Le),a(W,re),a(f,Pe),a(f,x),w(q,x,null),a(x,Se),a(x,pe),a(x,Ge),w(k,x,null),a(x,We),w(V,x,null),a(f,ke),a(f,B),w(Q,B,null),a(B,Ve),a(B,ce),a(f,Be),a(f,M),w(A,M,null),a(M,Ee),a(M,de),a(M,Re),w(E,M,null),a(M,Xe),w(R,M,null),a(f,Fe),a(f,X),w(O,X,null),a(X,Ne),a(X,fe),g(e,ye,p),w(K,e,p),g(e,we,p),g(e,L,p),w(ee,L,null),a(L,ze),a(L,ue),g(e,$e,p),g(e,ge,p),ve=!0},p(e,[p]){const m={};p&2&&(m.$$scope={dirty:p,ctx:e}),S.$set(m);const P={};p&2&&(P.$$scope={dirty:p,ctx:e}),G.$set(P);const te={};p&2&&(te.$$scope={dirty:p,ctx:e}),k.$set(te);const j={};p&2&&(j.$$scope={dirty:p,ctx:e}),V.$set(j);const ne={};p&2&&(ne.$$scope={dirty:p,ctx:e}),E.$set(ne);const I={};p&2&&(I.$$scope={dirty:p,ctx:e}),R.$set(I)},i(e){ve||($(u.$$.fragment,e),$(S.$$.fragment,e),$(N.$$.fragment,e),$(z.$$.fragment,e),$(Y.$$.fragment,e),$(G.$$.fragment,e),$(H.$$.fragment,e),$(q.$$.fragment,e),$(k.$$.fragment,e),$(V.$$.fragment,e),$(Q.$$.fragment,e),$(A.$$.fragment,e),$(E.$$.fragment,e),$(R.$$.fragment,e),$(O.$$.fragment,e),$(K.$$.fragment,e),$(ee.$$.fragment,e),ve=!0)},o(e){v(u.$$.fragment,e),v(S.$$.fragment,e),v(N.$$.fragment,e),v(z.$$.fragment,e),v(Y.$$.fragment,e),v(G.$$.fragment,e),v(H.$$.fragment,e),v(q.$$.fragment,e),v(k.$$.fragment,e),v(V.$$.fragment,e),v(Q.$$.fragment,e),v(A.$$.fragment,e),v(E.$$.fragment,e),v(R.$$.fragment,e),v(O.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),ve=!1},d(e){e&&(o(b),o(i),o(s),o(t),o(h),o(he),o(be),o(_e),o(f),o(ye),o(we),o(L),o($e),o(ge)),o(n),T(u,e),T(S,e),T(N,e),T(z),T(Y),T(G),T(H),T(q),T(k),T(V),T(Q),T(A),T(E),T(R),T(O),T(K,e),T(ee)}}}const $t='{"title":"Latent upscaler","local":"latent-upscaler","sections":[{"title":"StableDiffusionLatentUpscalePipeline","local":"diffusers.StableDiffusionLatentUpscalePipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function vt(J){return ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends dt{constructor(n){super(),ft(this,n,vt,wt,pt,{})}}export{Dt as component};
