import{s as Ct,n as $t,o as Zt}from"../chunks/scheduler.85c25b89.js";import{S as Wt,i as xt,g as p,s as l,r as i,A as Bt,h as m,f as e,c as n,j as Ut,u as o,x as g,k as It,y as Nt,a,v as c,d as r,t as h,w as M}from"../chunks/index.c9837788.js";import{C as V}from"../chunks/CodeBlock.e573519b.js";import{H as _,E as kt}from"../chunks/index.4c8f21db.js";function Gt(Mt){let d,A,R,Y,J,z,y,gt='An <strong>ECA ResNet</strong> is a variant on a <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that utilises an <a href="https://paperswithcode.com/method/efficient-channel-attention" rel="nofollow">Efficient Channel Attention module</a>. Efficient Channel Attention is an architectural unit based on <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> that reduces model complexity without dimensionality reduction.',H,w,F,j,dt="To load a pretrained model:",S,u,L,T,Jt="To load and preprocess the image:",D,f,q,b,yt="To get the model predictions:",P,U,K,I,wt="To get the top-5 predictions class names:",O,C,tt,$,jt="Replace the model name with the variant you want to use, e.g. <code>ecaresnet101d</code>. You can find the IDs in the model summaries at the top of this page.",st,Z,ut='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',et,W,at,x,Tt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",lt,B,nt,N,ft=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,pt,k,mt,G,bt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',it,E,ot,Q,ct,v,rt,X,ht;return J=new _({props:{title:"ECA-ResNet",local:"eca-resnet",headingTag:"h1"}}),w=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2VjYXJlc25ldDEwMWQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ecaresnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZWNhcmVzbmV0MTAxZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ecaresnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),k=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new V({props:{code:"JTQwbWlzYyU3QndhbmcyMDIwZWNhbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JFQ0EtTmV0JTNBJTIwRWZmaWNpZW50JTIwQ2hhbm5lbCUyMEF0dGVudGlvbiUyMGZvciUyMERlZXAlMjBDb252b2x1dGlvbmFsJTIwTmV1cmFsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JRaWxvbmclMjBXYW5nJTIwYW5kJTIwQmFuZ2d1JTIwV3UlMjBhbmQlMjBQZW5nZmVpJTIwWmh1JTIwYW5kJTIwUGVpaHVhJTIwTGklMjBhbmQlMjBXYW5nbWVuZyUyMFp1byUyMGFuZCUyMFFpbmdodWElMjBIdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTkxMC4wMzE1MSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{wang2020ecanet,
      title={ECA-Net: Efficient Channel Attention for Deep Convolutional Neural Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Qilong Wang and Banggu Wu and Pengfei Zhu and Peihua Li and Wangmeng Zuo and Qinghua Hu}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1910.03151}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),v=new kt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/ecaresnet.mdx"}}),{c(){d=p("meta"),A=l(),R=p("p"),Y=l(),i(J.$$.fragment),z=l(),y=p("p"),y.innerHTML=gt,H=l(),i(w.$$.fragment),F=l(),j=p("p"),j.textContent=dt,S=l(),i(u.$$.fragment),L=l(),T=p("p"),T.textContent=Jt,D=l(),i(f.$$.fragment),q=l(),b=p("p"),b.textContent=yt,P=l(),i(U.$$.fragment),K=l(),I=p("p"),I.textContent=wt,O=l(),i(C.$$.fragment),tt=l(),$=p("p"),$.innerHTML=jt,st=l(),Z=p("p"),Z.innerHTML=ut,et=l(),i(W.$$.fragment),at=l(),x=p("p"),x.textContent=Tt,lt=l(),i(B.$$.fragment),nt=l(),N=p("p"),N.innerHTML=ft,pt=l(),i(k.$$.fragment),mt=l(),G=p("p"),G.innerHTML=bt,it=l(),i(E.$$.fragment),ot=l(),i(Q.$$.fragment),ct=l(),i(v.$$.fragment),rt=l(),X=p("p"),this.h()},l(t){const s=Bt("svelte-u9bgzb",document.head);d=m(s,"META",{name:!0,content:!0}),s.forEach(e),A=n(t),R=m(t,"P",{}),Ut(R).forEach(e),Y=n(t),o(J.$$.fragment,t),z=n(t),y=m(t,"P",{"data-svelte-h":!0}),g(y)!=="svelte-1ly2dl5"&&(y.innerHTML=gt),H=n(t),o(w.$$.fragment,t),F=n(t),j=m(t,"P",{"data-svelte-h":!0}),g(j)!=="svelte-18ywhxh"&&(j.textContent=dt),S=n(t),o(u.$$.fragment,t),L=n(t),T=m(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1c2ipa8"&&(T.textContent=Jt),D=n(t),o(f.$$.fragment,t),q=n(t),b=m(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1n9qsq1"&&(b.textContent=yt),P=n(t),o(U.$$.fragment,t),K=n(t),I=m(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-19cnvx1"&&(I.textContent=wt),O=n(t),o(C.$$.fragment,t),tt=n(t),$=m(t,"P",{"data-svelte-h":!0}),g($)!=="svelte-r0xl90"&&($.innerHTML=jt),st=n(t),Z=m(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=ut),et=n(t),o(W.$$.fragment,t),at=n(t),x=m(t,"P",{"data-svelte-h":!0}),g(x)!=="svelte-9sr7nh"&&(x.textContent=Tt),lt=n(t),o(B.$$.fragment,t),nt=n(t),N=m(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1kguc51"&&(N.innerHTML=ft),pt=n(t),o(k.$$.fragment,t),mt=n(t),G=m(t,"P",{"data-svelte-h":!0}),g(G)!=="svelte-xtxxu6"&&(G.innerHTML=bt),it=n(t),o(E.$$.fragment,t),ot=n(t),o(Q.$$.fragment,t),ct=n(t),o(v.$$.fragment,t),rt=n(t),X=m(t,"P",{}),Ut(X).forEach(e),this.h()},h(){It(d,"name","hf:doc:metadata"),It(d,"content",Et)},m(t,s){Nt(document.head,d),a(t,A,s),a(t,R,s),a(t,Y,s),c(J,t,s),a(t,z,s),a(t,y,s),a(t,H,s),c(w,t,s),a(t,F,s),a(t,j,s),a(t,S,s),c(u,t,s),a(t,L,s),a(t,T,s),a(t,D,s),c(f,t,s),a(t,q,s),a(t,b,s),a(t,P,s),c(U,t,s),a(t,K,s),a(t,I,s),a(t,O,s),c(C,t,s),a(t,tt,s),a(t,$,s),a(t,st,s),a(t,Z,s),a(t,et,s),c(W,t,s),a(t,at,s),a(t,x,s),a(t,lt,s),c(B,t,s),a(t,nt,s),a(t,N,s),a(t,pt,s),c(k,t,s),a(t,mt,s),a(t,G,s),a(t,it,s),c(E,t,s),a(t,ot,s),c(Q,t,s),a(t,ct,s),c(v,t,s),a(t,rt,s),a(t,X,s),ht=!0},p:$t,i(t){ht||(r(J.$$.fragment,t),r(w.$$.fragment,t),r(u.$$.fragment,t),r(f.$$.fragment,t),r(U.$$.fragment,t),r(C.$$.fragment,t),r(W.$$.fragment,t),r(B.$$.fragment,t),r(k.$$.fragment,t),r(E.$$.fragment,t),r(Q.$$.fragment,t),r(v.$$.fragment,t),ht=!0)},o(t){h(J.$$.fragment,t),h(w.$$.fragment,t),h(u.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h(C.$$.fragment,t),h(W.$$.fragment,t),h(B.$$.fragment,t),h(k.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),h(v.$$.fragment,t),ht=!1},d(t){t&&(e(A),e(R),e(Y),e(z),e(y),e(H),e(F),e(j),e(S),e(L),e(T),e(D),e(q),e(b),e(P),e(K),e(I),e(O),e(tt),e($),e(st),e(Z),e(et),e(at),e(x),e(lt),e(nt),e(N),e(pt),e(mt),e(G),e(it),e(ot),e(ct),e(rt),e(X)),e(d),M(J,t),M(w,t),M(u,t),M(f,t),M(U,t),M(C,t),M(W,t),M(B,t),M(k,t),M(E,t),M(Q,t),M(v,t)}}}const Et='{"title":"ECA-ResNet","local":"eca-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qt(Mt){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends Wt{constructor(d){super(),xt(this,d,Qt,Gt,Ct,{})}}export{_t as component};
