import{s as Mn,o as wn,n as Lt}from"../chunks/scheduler.6062bdaf.js";import{S as bn,i as Tn,g as o,s,r,A as _n,h as i,f as a,c as n,j as Yt,u as c,x as p,k as es,y as _,a as l,v as h,d as u,t as d,w as m}from"../chunks/index.4bca734e.js";import{T as St}from"../chunks/Tip.b9ac1f03.js";import{C as y}from"../chunks/CodeBlock.fa01571c.js";import{H as w}from"../chunks/Heading.723dceba.js";function jn(T){let f,M=`Background jobs are queued when using <code>run_as_future=True</code>. This means that you are guaranteed that the jobs will be
executed in the correct order.`;return{c(){f=o("p"),f.innerHTML=M},l(g){f=i(g,"P",{"data-svelte-h":!0}),p(f)!=="svelte-wv2oxh"&&(f.innerHTML=M)},m(g,b){l(g,f,b)},p:Lt,d(g){g&&a(f)}}}function Jn(T){let f,M=`<code>multi_commits</code> is still an experimental feature. Its API and behavior is subject to change in the future without prior
notice.`;return{c(){f=o("p"),f.innerHTML=M},l(g){f=i(g,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1hgg4xz"&&(f.innerHTML=M)},m(g,b){l(g,f,b)},p:Lt,d(g){g&&a(f)}}}function Un(T){let f,M=`For more examples of custom schedulers, check out our <a href="https://huggingface.co/spaces/Wauplin/space_to_dataset_saver" rel="nofollow">demo Space</a>
containing different implementations depending on your use cases.`;return{c(){f=o("p"),f.innerHTML=M},l(g){f=i(g,"P",{"data-svelte-h":!0}),p(f)!=="svelte-ndh47j"&&(f.innerHTML=M)},m(g,b){l(g,f,b)},p:Lt,d(g){g&&a(f)}}}function vn(T){let f,M=`This is a power-user method. Directly using <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>, <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> or <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> instead of handling
the low-level logic of pre-uploading files is the way to go in the vast majority of cases. The main caveat of
<a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.preupload_lfs_files">preupload_lfs_files()</a> is that until the commit is actually made, the upload files are not accessible on the repo on
the Hub. If you have a question, feel free to ping us on our Discord or in a GitHub issue.`;return{c(){f=o("p"),f.innerHTML=M},l(g){f=i(g,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1m95o0c"&&(f.innerHTML=M)},m(g,b){l(g,f,b)},p:Lt,d(g){g&&a(f)}}}function In(T){let f,M=`Although <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/repository#huggingface_hub.Repository">Repository</a> is not formally deprecated, we recommend using the HTTP-based methods described above instead.
For more details about this recommendation, please have a look at <a href="../concepts/git_vs_http">this guide</a> explaining the
core differences between HTTP-based and Git-based approaches.`;return{c(){f=o("p"),f.innerHTML=M},l(g){f=i(g,"P",{"data-svelte-h":!0}),p(f)!=="svelte-oexg5l"&&(f.innerHTML=M)},m(g,b){l(g,f,b)},p:Lt,d(g){g&&a(f)}}}function $n(T){let f,M,g,b,G,Vt,H,ts="Sharing your files and work is an important aspect of the Hub. The <code>huggingface_hub</code> offers several options for uploading your files to the Hub. You can use these functions independently or integrate them into your library, making it more convenient for your users to interact with the Hub. This guide will show you how to push files:",Ft,B,as='<li>without using Git.</li> <li>that are very large with <a href="https://git-lfs.github.com/" rel="nofollow">Git LFS</a>.</li> <li>with the <code>commit</code> context manager.</li> <li>with the <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/repository#huggingface_hub.Repository.push_to_hub">push_to_hub()</a> function.</li>',Nt,X,ls="Whenever you want to upload files to the Hub, you need to log in to your Hugging Face account:",Et,U,W,Xt,ss="Log in to your Hugging Face account with the following command:",zl,x,Pl,j,Wt,ns='Alternatively, you can programmatically login using <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/login#huggingface_hub.login">login()</a> in a notebook or a script:',Dl,R,Kl,xt,os=`If ran in a Jupyter or Colaboratory notebook, <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/login#huggingface_hub.login">login()</a> will launch a widget from
which you can enter your Hugging Face access token. Otherwise, a message will be
prompted in the terminal.`,Ol,Rt,is=`It is also possible to login programmatically without the widget by directly passing
the token to <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/login#huggingface_hub.login">login()</a>. If you do so, be careful when sharing your notebook. It is
best practice to load the token from a secure vault instead of saving it in plain in
your Colaboratory notebook.`,qt,A,Qt,Y,ps='Once you’ve created a repository with <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>, you can upload a file to your repository using <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>.',zt,S,rs="Specify the path of the file to upload, where you want to upload the file to in the repository, and the name of the repository you want to add the file to. Depending on your repository type, you can optionally set the repository type as a <code>dataset</code>, <code>model</code>, or <code>space</code>.",Pt,L,Dt,V,Kt,F,cs=`Use the <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> function to upload a local folder to an existing repository. Specify the path of the local folder
to upload, where you want to upload the folder to in the repository, and the name of the repository you want to add the
folder to. Depending on your repository type, you can optionally set the repository type as a <code>dataset</code>, <code>model</code>, or <code>space</code>.`,Ot,N,ea,E,hs=`Use the <code>allow_patterns</code> and <code>ignore_patterns</code> arguments to specify which files to upload. These parameters accept either a single pattern or a list of patterns.
Patterns are Standard Wildcards (globbing patterns) as documented <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">here</a>.
If both <code>allow_patterns</code> and <code>ignore_patterns</code> are provided, both constraints apply. By default, all files from the folder are uploaded.`,ta,q,us=`Any <code>.git/</code> folder present in any subdirectory will be ignored. However, please be aware that the <code>.gitignore</code> file is not taken into account.
This means you must use <code>allow_patterns</code> and <code>ignore_patterns</code> to specify which files to upload instead.`,aa,Q,la,z,ds=`You can also use the <code>delete_patterns</code> argument to specify files you want to delete from the repo in the same commit.
This can prove useful if you want to clean a remote folder before pushing files in it and you don’t know which files
already exists.`,sa,P,ms=`The example below uploads the local <code>./logs</code> folder to the remote <code>/experiment/logs/</code> folder. Only txt files are uploaded
but before that, all previous logs on the repo on deleted. All of this in a single commit.`,na,D,oa,K,ia,O,fs=`You can use the <code>huggingface-cli upload</code> command from the terminal to directly upload files to the Hub. Internally
it uses the same <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> helpers described above.`,pa,ee,gs="You can either upload a single file or an entire folder:",ra,te,ca,ae,ys=`<code>local_path</code> and <code>path_in_repo</code> are optional and can be implicitly inferred. If <code>local_path</code> is not set, the tool will
check if a local folder or file has the same name as the <code>repo_id</code>. If that’s the case, its content will be uploaded.
Otherwise, an exception is raised asking the user to explicitly set <code>local_path</code>. In any case, if <code>path_in_repo</code> is not
set, files are uploaded at the root of the repo.`,ha,le,ua,se,Ms=`By default, the token saved locally (using <code>huggingface-cli login</code>) will be used. If you want to authenticate explicitly,
use the <code>--token</code> option:`,da,ne,ma,oe,ws=`When uploading a folder, you can use the <code>--include</code> and <code>--exclude</code> arguments to filter the files to upload. You can
also use <code>--delete</code> to delete existing files on the Hub.`,fa,ie,ga,pe,bs='Finally, you can also schedule a job that will upload your files regularly (see <a href="#scheduled-uploads">scheduled uploads</a>).',ya,re,Ma,ce,wa,he,Ts=`In most cases, you won’t need more than <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> to upload your files to the Hub.
However, <code>huggingface_hub</code> has more advanced features to make things easier. Let’s have a look at them!`,ba,ue,Ta,de,_s=`In some cases, you want to push data without blocking your main thread. This is particularly useful to upload logs and
artifacts while continuing a training. To do so, you can use the <code>run_as_future</code> argument in both <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and
<a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>. This will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow"><code>concurrent.futures.Future</code></a>
object that you can use to check the status of the upload.`,_a,me,ja,v,Ja,fe,js=`Even though background jobs are mostly useful to upload data/create commits, you can queue any method you like using
<a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.run_as_future">run_as_future()</a>. For instance, you can use it to create a repo and then upload data to it in the background. The
built-in <code>run_as_future</code> argument in upload methods is just an alias around it.`,Ua,ge,va,ye,Ia,Me,Js=`<a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> makes it easy to upload an entire folder to the Hub. However, for large folders (thousands of files or
hundreds of GB), it can still be challenging. If you have a folder with a lot of files, you might want to upload
it in several commits. If you experience an error or a connection issue during the upload, you would not have to resume
the process from the beginning.`,$a,we,Us=`To upload a folder in multiple commits, just pass <code>multi_commits=True</code> as argument. Under the hood, <code>huggingface_hub</code>
will list the files to upload/delete and split them in several commits. The “strategy” (i.e. how to split the commits)
is based on the number and size of the files to upload. A PR is open on the Hub to push all the commits. Once the PR is
ready, the commits are squashed into a single commit. If the process is interrupted before completing, you can rerun
your script to resume the upload. The created PR will be automatically detected and the upload will resume from where
it stopped. It is recommended to pass <code>multi_commits_verbose=True</code> to get a better understanding of the upload and its
progress.`,ka,be,vs=`The example below will upload the checkpoints folder to a dataset in multiple commits. A PR will be created on the Hub
and merged automatically once the upload is complete. If you prefer the PR to stay open and review it manually, you can
pass <code>create_pr=True</code>.`,Ca,Te,Za,_e,Is=`If you want a better control on the upload strategy (i.e. the commits that are created), you can have a look at the
low-level <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.plan_multi_commits">plan_multi_commits()</a> and <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_commits_on_pr">create_commits_on_pr()</a> methods.`,Ga,I,Ha,je,Ba,Je,$s=`The Hugging Face Hub makes it easy to save and version data. However, there are some limitations when updating the same file thousands of times. For instance, you might want to save logs of a training process or user
feedback on a deployed Space. In these cases, uploading the data as a dataset on the Hub makes sense, but it can be hard to do properly. The main reason is that you don’t want to version every update of your data because it’ll make the git repository unusable. The <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a> class offers a solution to this problem.`,Xa,Ue,ks=`The idea is to run a background job that regularly pushes a local folder to the Hub. Let’s assume you have a
Gradio Space that takes as input some text and generates two translations of it. Then, the user can select their preferred translation. For each run, you want to save the input, output, and user preference to analyze the results. This is a
perfect use case for <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a>; you want to save data to the Hub (potentially millions of user feedback), but
you don’t <em>need</em> to save in real-time each user’s input. Instead, you can save the data locally in a JSON file and
upload it every 10 minutes. For example:`,Wa,ve,xa,Ie,Cs=`And that’s it! User input/outputs and feedback will be available as a dataset on the Hub. By using a unique JSON file name, you are guaranteed you won’t overwrite data from a previous run or data from another
Spaces/replicas pushing concurrently to the same repository.`,Ra,$e,Zs='For more details about the <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a>, here is what you need to know:',Aa,ke,Gs=`<li><strong>append-only:</strong>
It is assumed that you will only add content to the folder. You must only append data to existing files or create
new files. Deleting or overwriting a file might corrupt your repository.</li> <li><strong>git history</strong>:
The scheduler will commit the folder every <code>every</code> minutes. To avoid polluting the git repository too much, it is
recommended to set a minimal value of 5 minutes. Besides, the scheduler is designed to avoid empty commits. If no
new content is detected in the folder, the scheduled commit is dropped.</li> <li><strong>errors:</strong>
The scheduler run as background thread. It is started when you instantiate the class and never stops. In particular,
if an error occurs during the upload (example: connection issue), the scheduler will silently ignore it and retry
at the next scheduled commit.</li> <li><strong>thread-safety:</strong>
In most cases it is safe to assume that you can write to a file without having to worry about a lock file. The
scheduler will not crash or be corrupted if you write content to the folder while it’s uploading. In practice,
<em>it is possible</em> that concurrency issues happen for heavy-loaded apps. In this case, we advice to use the
<code>scheduler.lock</code> lock to ensure thread-safety. The lock is blocked only when the scheduler scans the folder for
changes, not when it uploads data. You can safely assume that it will not affect the user experience on your Space.</li>`,Ya,Ce,Sa,Ze,Hs=`Persisting data from a Space to a Dataset on the Hub is the main use case for <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a>. Depending on the use
case, you might want to structure your data differently. The structure has to be robust to concurrent users and
restarts which often implies generating UUIDs. Besides robustness, you should upload data in a format readable by the 🤗 Datasets library for later reuse. We created a <a href="https://huggingface.co/spaces/Wauplin/space_to_dataset_saver" rel="nofollow">Space</a>
that demonstrates how to save several different data formats (you may need to adapt it for your own specific needs).`,La,Ge,Va,He,Bs=`<a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a> assumes your data is append-only and should be uploading “as is”. However, you
might want to customize the way data is uploaded. You can do that by creating a class inheriting from <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a>
and overwrite the <code>push_to_hub</code> method (feel free to overwrite it any way you want). You are guaranteed it will
be called every <code>every</code> minutes in a background thread. You don’t have to worry about concurrency and errors but you
must be careful about other aspects, such as pushing empty commits or duplicated data.`,Fa,Be,Xs=`In the (simplified) example below, we overwrite <code>push_to_hub</code> to zip all PNG files in a single archive to avoid
overloading the repo on the Hub:`,Na,Xe,Ea,We,Ws='When you overwrite <code>push_to_hub</code>, you have access to the attributes of <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a> and especially:',qa,xe,xs='<li><a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> client: <code>api</code></li> <li>Folder parameters: <code>folder_path</code> and <code>path_in_repo</code></li> <li>Repo parameters: <code>repo_id</code>, <code>repo_type</code>, <code>revision</code></li> <li>The thread lock: <code>lock</code></li>',Qa,$,za,Re,Pa,Ae,Rs=`The <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> functions are high-level APIs that are generally convenient to use. We recommend
trying these functions first if you don’t need to work at a lower level. However, if you want to work at a commit-level,
you can use the <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> function directly.`,Da,Ye,As='There are three types of operations supported by <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>:',Ka,Se,Ys='<li><p><a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a> uploads a file to the Hub. If the file already exists, the file contents are overwritten. This operation accepts two arguments:</p> <ul><li><code>path_in_repo</code>: the repository path to upload a file to.</li> <li><code>path_or_fileobj</code>: either a path to a file on your filesystem or a file-like object. This is the content of the file to upload to the Hub.</li></ul></li> <li><p><a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.CommitOperationDelete">CommitOperationDelete</a> removes a file or a folder from a repository. This operation accepts <code>path_in_repo</code> as an argument.</p></li> <li><p><a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.CommitOperationCopy">CommitOperationCopy</a> copies a file within a repository. This operation accepts three arguments:</p> <ul><li><code>src_path_in_repo</code>: the repository path of the file to copy.</li> <li><code>path_in_repo</code>: the repository path where the file should be copied.</li> <li><code>src_revision</code>: optional - the revision of the file to copy if your want to copy a file from a different branch/revision.</li></ul></li>',Oa,Le,Ss="For example, if you want to upload two files and delete a file in a Hub repository:",el,Ve,Ls="<li>Use the appropriate <code>CommitOperation</code> to add or delete a file and to delete a folder:</li>",tl,Fe,al,k,Vs='<li>Pass your operations to <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>:</li>',ll,Ne,sl,Ee,Fs='In addition to <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>, the following functions also use <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> under the hood:',nl,qe,Ns='<li><a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.delete_file">delete_file()</a> deletes a single file from a repository on the Hub.</li> <li><a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.delete_folder">delete_folder()</a> deletes an entire folder from a repository on the Hub.</li> <li><a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/cards#huggingface_hub.metadata_update">metadata_update()</a> updates a repository’s metadata.</li>',ol,Qe,Es='For more detailed information, take a look at the <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> reference.',il,ze,pl,Pe,qs=`In some cases, you might want to upload huge files to S3 <strong>before</strong> making the commit call. For example, if you are
committing a dataset in several shards that are generated in-memory, you would need to upload the shards one by one
to avoid an out-of-memory issue. A solution is to upload each shard as a separate commit on the repo. While being
perfectly valid, this solution has the drawback of potentially messing the git history by generating tens of commits.
To overcome this issue, you can upload your files one by one to S3 and then create a single commit at the end. This
is possible using <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.preupload_lfs_files">preupload_lfs_files()</a> in combination with <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>.`,rl,C,cl,De,Qs="Here is a simple example illustrating how to pre-upload files:",hl,Ke,ul,Oe,zs=`First, we create the <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a> objects one by one. In a real-world example, those would contain the
generated shards. Each file is uploaded before generating the next one. During the <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.preupload_lfs_files">preupload_lfs_files()</a> step, <strong>the
<code>CommitOperationAdd</code> object is mutated</strong>. You should only use it to pass it directly to <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>. The main
update of the object is that <strong>the binary content is removed</strong> from it, meaning that it will be garbage-collected if
you don’t store another reference to it. This is expected as we don’t want to keep in memory the content that is
already uploaded. Finally we create the commit by passing all the operations to <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>. You can pass
additional operations (add, delete or copy) that have not been processed yet and they will be handled correctly.`,dl,et,ml,tt,Ps=`There are some limitations to be aware of when dealing with a large amount of data in your repo. Given the time it takes to stream the data,
getting an upload/push to fail at the end of the process or encountering a degraded experience, be it on hf.co or when working locally, can be very annoying.`,fl,at,Ds='Check out our <a href="https://huggingface.co/docs/hub/repositories-recommendations" rel="nofollow">Repository limitations and recommendations</a> guide for best practices on how to structure your repositories on the Hub. Next, let’s move on with some practical tips to make your upload process as smooth as possible.',gl,lt,Ks=`<li><strong>Start small</strong>: We recommend starting with a small amount of data to test your upload script. It’s easier to iterate
on a script when failing takes only a little time.</li> <li><strong>Expect failures</strong>: Streaming large amounts of data is challenging. You don’t know what can happen, but it’s always
best to consider that something will fail at least once -no matter if it’s due to your machine, your connection, or our
servers. For example, if you plan to upload a large number of files, it’s best to keep track locally of which files you
already uploaded before uploading the next batch. You are ensured that an LFS file that is already committed will never
be re-uploaded twice but checking it client-side can still save some time.</li> <li><strong>Use <code>hf_transfer</code></strong>: this is a Rust-based <a href="https://github.com/huggingface/hf_transfer" rel="nofollow">library</a> meant to speed up
uploads on machines with very high bandwidth. To use it, you must install it (<code>pip install hf_transfer</code>) and enable it
by setting <code>HF_HUB_ENABLE_HF_TRANSFER=1</code> as an environment variable. You can then use <code>huggingface_hub</code> normally.
Disclaimer: this is a power user tool. It is tested and production-ready but lacks user-friendly features like progress
bars or advanced error handling. For more details, please refer to this <a href="https://huggingface.co/docs/huggingface_hub/hf_transfer" rel="nofollow">section</a>.</li>`,yl,st,Ml,nt,Os=`All the methods described above use the Hub’s API to upload files. This is the recommended way to upload files to the Hub.
However, we also provide <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/repository#huggingface_hub.Repository">Repository</a>, a wrapper around the git tool to manage a local repository.`,wl,Z,bl,ot,en="Git LFS automatically handles files larger than 10MB. But for very large files (>5GB), you need to install a custom transfer agent for Git LFS:",Tl,it,_l,pt,tn="You should install this for each repository that has a very large file. Once installed, you’ll be able to push files larger than 5GB.",jl,rt,Jl,ct,an="The <code>commit</code> context manager handles four of the most common Git commands: pull, add, commit, and push. <code>git-lfs</code> automatically tracks any file larger than 10MB. In the following example, the <code>commit</code> context manager:",Ul,ht,ln="<li>Pulls from the <code>text-files</code> repository.</li> <li>Adds a change made to <code>file.txt</code>.</li> <li>Commits the change.</li> <li>Pushes the change to the <code>text-files</code> repository.</li>",vl,ut,Il,dt,sn="Here is another example of how to use the <code>commit</code> context manager to save and upload a file to a repository:",$l,mt,kl,ft,nn="Set <code>blocking=False</code> if you would like to push your commits asynchronously. Non-blocking behavior is helpful when you want to continue running your script while your commits are being pushed.",Cl,gt,Zl,yt,on="You can check the status of your push with the <code>command_queue</code> method:",Gl,Mt,Hl,wt,pn="Refer to the table below for the possible statuses:",Bl,bt,rn="<thead><tr><th>Status</th> <th>Description</th></tr></thead> <tbody><tr><td>-1</td> <td>The push is ongoing.</td></tr> <tr><td>0</td> <td>The push has completed successfully.</td></tr> <tr><td>Non-zero</td> <td>An error has occurred.</td></tr></tbody>",Xl,Tt,cn="When <code>blocking=False</code>, commands are tracked, and your script will only exit when all pushes are completed, even if other errors occur in your script. Some additional useful commands for checking the status of a push include:",Wl,_t,xl,jt,Rl,Jt,hn='The <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/repository#huggingface_hub.Repository">Repository</a> class has a <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/repository#huggingface_hub.Repository.push_to_hub">push_to_hub()</a> function to add files, make a commit, and push them to a repository. Unlike the <code>commit</code> context manager, you’ll need to pull from a repository first before calling <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/repository#huggingface_hub.Repository.push_to_hub">push_to_hub()</a>.',Al,Ut,un="For example, if you’ve already cloned a repository from the Hub, then you can initialize the <code>repo</code> from the local directory:",Yl,vt,Sl,It,dn='Update your local clone with <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/repository#huggingface_hub.Repository.git_pull">git_pull()</a> and then push your file to the Hub:',Ll,$t,Vl,kt,mn='However, if you aren’t ready to push a file yet, you can use <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/repository#huggingface_hub.Repository.git_add">git_add()</a> and <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/repository#huggingface_hub.Repository.git_commit">git_commit()</a> to only add and commit your file:',Fl,Ct,Nl,Zt,fn='When you’re ready, push the file to your repository with <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/repository#huggingface_hub.Repository.git_push">git_push()</a>:',El,Gt,ql,At,Ql;return G=new w({props:{title:"Upload files to the Hub",local:"upload-files-to-the-hub",headingTag:"h1"}}),x=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4lMEElMjMlMjBvciUyMHVzaW5nJTIwYW4lMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTBBaHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4lMjAtLXRva2VuJTIwJTI0SFVHR0lOR0ZBQ0VfVE9LRU4=",highlighted:`huggingface-cli login
<span class="hljs-comment"># or using an environment variable</span>
huggingface-cli login --token <span class="hljs-variable">$HUGGINGFACE_TOKEN</span>`,wrap:!1}}),R=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
<span class="hljs-meta">&gt;&gt;&gt; </span>login()`,wrap:!1}}),A=new w({props:{title:"Upload a file",local:"upload-a-file",headingTag:"h2"}}),L=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS51cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0QlMjIlMkZwYXRoJTJGdG8lMkZsb2NhbCUyRmZvbGRlciUyRlJFQURNRS5tZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMlJFQURNRS5tZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRnRlc3QtZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">&quot;/path/to/local/folder/README.md&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;README.md&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/test-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),V=new w({props:{title:"Upload a folder",local:"upload-a-folder",headingTag:"h2"}}),N=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS51cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEJTIyJTJGcGF0aCUyRnRvJTJGbG9jYWwlMkZzcGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRm15LWNvb2wtc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX3R5cGUlM0QlMjJzcGFjZSUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Upload all the content from the local folder to your remote Space.</span>
<span class="hljs-comment"># By default, files are uploaded at the root of the repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;/path/to/local/space&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-cool-space&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Q=new y({props:{code:"YXBpLnVwbG9hZF9mb2xkZXIoJTBBJTIwJTIwJTIwJTIwZm9sZGVyX3BhdGglM0QlMjIlMkZwYXRoJTJGdG8lMkZsb2NhbCUyRmZvbGRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMm15LWRhdGFzZXQlMkZ0cmFpbiUyMiUyQyUyMCUyMyUyMFVwbG9hZCUyMHRvJTIwYSUyMHNwZWNpZmljJTIwZm9sZGVyJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGdGVzdC1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMGlnbm9yZV9wYXR0ZXJucyUzRCUyMioqJTJGbG9ncyUyRioudHh0JTIyJTJDJTIwJTIzJTIwSWdub3JlJTIwYWxsJTIwdGV4dCUyMGxvZ3MlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;/path/to/local/folder&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;my-dataset/train&quot;</span>, <span class="hljs-comment"># Upload to a specific folder</span>
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/test-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>    ignore_patterns=<span class="hljs-string">&quot;**/logs/*.txt&quot;</span>, <span class="hljs-comment"># Ignore all text logs</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),D=new y({props:{code:"YXBpLnVwbG9hZF9mb2xkZXIoJTBBJTIwJTIwJTIwJTIwZm9sZGVyX3BhdGglM0QlMjIlMkZwYXRoJTJGdG8lMkZsb2NhbCUyRmZvbGRlciUyRmxvZ3MlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZ0cmFpbmVkLW1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIyZXhwZXJpbWVudCUyRmxvZ3MlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19wYXR0ZXJucyUzRCUyMioudHh0JTIyJTJDJTIwJTIzJTIwVXBsb2FkJTIwYWxsJTIwbG9jYWwlMjB0ZXh0JTIwZmlsZXMlMEElMjAlMjAlMjAlMjBkZWxldGVfcGF0dGVybnMlM0QlMjIqLnR4dCUyMiUyQyUyMCUyMyUyMERlbGV0ZSUyMGFsbCUyMHJlbW90ZSUyMHRleHQlMjBmaWxlcyUyMGJlZm9yZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;/path/to/local/folder/logs&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/trained-model&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;experiment/logs/&quot;</span>,
<span class="hljs-meta">... </span>    allow_patterns=<span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-comment"># Upload all local text files</span>
<span class="hljs-meta">... </span>    delete_patterns=<span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-comment"># Delete all remote text files before</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),K=new w({props:{title:"Upload from the CLI",local:"upload-from-the-cli",headingTag:"h2"}}),te=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwdXBsb2FkJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWwlMjAuJTJGbW9kZWxzJTJGbW9kZWwuc2FmZXRlbnNvcnMlMjBtb2RlbC5zYWZldGVuc29ycyUwQSUwQWh1Z2dpbmdmYWNlLWNsaSUyMHVwbG9hZCUyMFdhdXBsaW4lMkZteS1jb29sLW1vZGVsJTIwLiUyRm1vZGVscyUyMC4=",highlighted:`<span class="hljs-comment"># Usage:  huggingface-cli upload [repo_id] [local_path] [path_in_repo]</span>
&gt;&gt;&gt; huggingface-cli upload Wauplin/my-cool-model ./models/model.safetensors model.safetensors
https://huggingface.co/Wauplin/my-cool-model/blob/main/model.safetensors

&gt;&gt;&gt; huggingface-cli upload Wauplin/my-cool-model ./models .
https://huggingface.co/Wauplin/my-cool-model/tree/main`,wrap:!1}}),le=new y({props:{code:"JTIzJTIwVXBsb2FkJTIwZmlsZSUyMGF0JTIwcm9vdCUwQWh1Z2dpbmdmYWNlLWNsaSUyMHVwbG9hZCUyMG15LWNvb2wtbW9kZWwlMjBtb2RlbC5zYWZldGVuc29ycyUwQSUwQSUyMyUyMFVwbG9hZCUyMGRpcmVjdG9yeSUyMGF0JTIwcm9vdCUwQWh1Z2dpbmdmYWNlLWNsaSUyMHVwbG9hZCUyMG15LWNvb2wtbW9kZWwlMjAuJTJGbW9kZWxzJTBBJTBBJTIzJTIwVXBsb2FkJTIwJTYwbXktY29vbC1tb2RlbCUyRiU2MCUyMGRpcmVjdG9yeSUyMGlmJTIwaXQlMjBleGlzdCUyQyUyMHJhaXNlJTIwb3RoZXJ3aXNlJTBBaHVnZ2luZ2ZhY2UtY2xpJTIwdXBsb2FkJTIwbXktY29vbC1tb2RlbA==",highlighted:`<span class="hljs-comment"># Upload file at root</span>
huggingface-cli upload my-cool-model model.safetensors

<span class="hljs-comment"># Upload directory at root</span>
huggingface-cli upload my-cool-model ./models

<span class="hljs-comment"># Upload \`my-cool-model/\` directory if it exist, raise otherwise</span>
huggingface-cli upload my-cool-model`,wrap:!1}}),ne=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwdXBsb2FkJTIwbXktY29vbC1tb2RlbCUyMC0tdG9rZW4lM0RoZl8qKioq",highlighted:"huggingface-cli upload my-cool-model --token=hf_****",wrap:!1}}),ie=new y({props:{code:"JTIzJTIwU3luYyUyMGxvY2FsJTIwU3BhY2UlMjB3aXRoJTIwSHViJTIwKHVwbG9hZCUyMG5ldyUyMGZpbGVzJTIwZXhjZXB0JTIwZnJvbSUyMGxvZ3MlMkYlMkMlMjBkZWxldGUlMjByZW1vdmVkJTIwZmlsZXMpJTBBaHVnZ2luZ2ZhY2UtY2xpJTIwdXBsb2FkJTIwV2F1cGxpbiUyRnNwYWNlLWV4YW1wbGUlMjAtLXJlcG8tdHlwZSUzRHNwYWNlJTIwLS1leGNsdWRlJTNEJTIyJTJGbG9ncyUyRiolMjIlMjAtLWRlbGV0ZSUzRCUyMiolMjIlMjAtLWNvbW1pdC1tZXNzYWdlJTNEJTIyU3luYyUyMGxvY2FsJTIwU3BhY2UlMjB3aXRoJTIwSHViJTIy",highlighted:`<span class="hljs-comment"># Sync local Space with Hub (upload new files except from logs/, delete removed files)</span>
huggingface-cli upload Wauplin/space-example --repo-type=space --exclude=<span class="hljs-string">&quot;/logs/*&quot;</span> --delete=<span class="hljs-string">&quot;*&quot;</span> --commit-message=<span class="hljs-string">&quot;Sync local Space with Hub&quot;</span>`,wrap:!1}}),re=new y({props:{code:"JTIzJTIwVXBsb2FkJTIwbmV3JTIwbG9ncyUyMGV2ZXJ5JTIwMTAlMjBtaW51dGVzJTBBaHVnZ2luZ2ZhY2UtY2xpJTIwdXBsb2FkJTIwdHJhaW5pbmctbW9kZWwlMjBsb2dzJTJGJTIwLS1ldmVyeSUzRDEw",highlighted:`<span class="hljs-comment"># Upload new logs every 10 minutes</span>
huggingface-cli upload training-model logs/ --every=10`,wrap:!1}}),ce=new w({props:{title:"Advanced features",local:"advanced-features",headingTag:"h2"}}),ue=new w({props:{title:"Non-blocking uploads",local:"non-blocking-uploads",headingTag:"h3"}}),me=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWZ1dHVyZSUyMCUzRCUyMGFwaS51cGxvYWRfZm9sZGVyKCUyMCUyMyUyMFVwbG9hZCUyMGluJTIwdGhlJTIwYmFja2dyb3VuZCUyMChub24tYmxvY2tpbmclMjBhY3Rpb24pJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGbXktbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmNoZWNrcG9pbnRzLTAwMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJ1bl9hc19mdXR1cmUlM0RUcnVlJTJDJTBBKSUwQWZ1dHVyZSUwQWZ1dHVyZS5kb25lKCklMEFmdXR1cmUucmVzdWx0KCklMjAlMjMlMjBXYWl0JTIwZm9yJTIwdGhlJTIwdXBsb2FkJTIwdG8lMjBjb21wbGV0ZSUyMChibG9ja2luZyUyMGFjdGlvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>future = api.upload_folder( <span class="hljs-comment"># Upload in the background (non-blocking action)</span>
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;checkpoints-001&quot;</span>,
<span class="hljs-meta">... </span>    run_as_future=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>future
Future(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>future.done()
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>future.result() <span class="hljs-comment"># Wait for the upload to complete (blocking action)</span>
...`,wrap:!1}}),v=new St({props:{$$slots:{default:[jn]},$$scope:{ctx:T}}}),ge=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5ydW5fYXNfZnV0dXJlKGFwaS5jcmVhdGVfcmVwbyUyQyUyMCUyMnVzZXJuYW1lJTJGbXktbW9kZWwlMjIlMkMlMjBleGlzdHNfb2slM0RUcnVlKSUwQWFwaS51cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMmZpbGUudHh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEYiUyMmZpbGUlMjBjb250ZW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwcnVuX2FzX2Z1dHVyZSUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.run_as_future(api.create_repo, <span class="hljs-string">&quot;username/my-model&quot;</span>, exists_ok=<span class="hljs-literal">True</span>)
Future(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;file.txt&quot;</span>,
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">b&quot;file content&quot;</span>,
<span class="hljs-meta">... </span>    run_as_future=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
Future(...)`,wrap:!1}}),ye=new w({props:{title:"Upload a folder by chunks",local:"upload-a-folder-by-chunks",headingTag:"h3"}}),Te=new y({props:{code:"dXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMG11bHRpX2NvbW1pdHMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbXVsdGlfY29tbWl0c192ZXJib3NlJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>    multi_commits=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    multi_commits_verbose=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),I=new St({props:{warning:!0,$$slots:{default:[Jn]},$$scope:{ctx:T}}}),je=new w({props:{title:"Scheduled uploads",local:"scheduled-uploads",headingTag:"h3"}}),ve=new y({props:{code:"aW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMHV1aWQlMEFmcm9tJTIwcGF0aGxpYiUyMGltcG9ydCUyMFBhdGglMEFpbXBvcnQlMjBncmFkaW8lMjBhcyUyMGdyJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdFNjaGVkdWxlciUwQSUwQWZlZWRiYWNrX2ZpbGUlMjAlM0QlMjBQYXRoKCUyMnVzZXJfZmVlZGJhY2slMkYlMjIpJTIwJTJGJTIwZiUyMmRhdGFfJTdCdXVpZC51dWlkNCgpJTdELmpzb24lMjIlMEFmZWVkYmFja19mb2xkZXIlMjAlM0QlMjBmZWVkYmFja19maWxlLnBhcmVudCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMENvbW1pdFNjaGVkdWxlciglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIycmVwb3J0LXRyYW5zbGF0aW9uLWZlZWRiYWNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEZmVlZGJhY2tfZm9sZGVyJTJDJTBBJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIyZGF0YSUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2ZXJ5JTNEMTAlMkMlMEEpJTBBJTBBZGVmJTIwc2F2ZV9mZWVkYmFjayhpbnB1dF90ZXh0JTNBc3RyJTJDJTIwb3V0cHV0XzElM0ElMjBzdHIlMkMlMjBvdXRwdXRfMiUzQXN0ciUyQyUyMHVzZXJfY2hvaWNlJTNBJTIwaW50KSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwQXBwZW5kJTIwaW5wdXQlMkZvdXRwdXRzJTIwYW5kJTIwdXNlciUyMGZlZWRiYWNrJTIwdG8lMjBhJTIwSlNPTiUyMExpbmVzJTIwZmlsZSUyMHVzaW5nJTIwYSUyMHRocmVhZCUyMGxvY2slMjB0byUyMGF2b2lkJTIwY29uY3VycmVudCUyMHdyaXRlcyUyMGZyb20lMjBkaWZmZXJlbnQlMjB1c2Vycy4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwc2NoZWR1bGVyLmxvY2slM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aXRoJTIwZmVlZGJhY2tfZmlsZS5vcGVuKCUyMmElMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShqc29uLmR1bXBzKCU3QiUyMmlucHV0JTIyJTNBJTIwaW5wdXRfdGV4dCUyQyUyMCUyMm91dHB1dF8xJTIyJTNBJTIwb3V0cHV0XzElMkMlMjAlMjJvdXRwdXRfMiUyMiUzQSUyMG91dHB1dF8yJTJDJTIwJTIydXNlcl9jaG9pY2UlMjIlM0ElMjB1c2VyX2Nob2ljZSU3RCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZSglMjIlNUNuJTIyKSUwQSUwQXdpdGglMjBnci5CbG9ja3MoKSUyMGFzJTIwZGVtbyUzQSUwQSUyMCUyMCUyMCUyMC4uLiUyMCUyMyUyMGRlZmluZSUyMEdyYWRpbyUyMGRlbW8lMjAlMkIlMjB1c2UlMjAlNjBzYXZlX2ZlZWRiYWNrJTYwJTBBZGVtby5sYXVuY2goKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> uuid
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitScheduler

<span class="hljs-comment"># Define the file where to save the data. Use UUID to make sure not to overwrite existing data from a previous run.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>feedback_file = Path(<span class="hljs-string">&quot;user_feedback/&quot;</span>) / <span class="hljs-string">f&quot;data_<span class="hljs-subst">{uuid.uuid4()}</span>.json&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>feedback_folder = feedback_file.parent

<span class="hljs-comment"># Schedule regular uploads. Remote repo and local folder are created if they don&#x27;t already exist.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = CommitScheduler(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;report-translation-feedback&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>    folder_path=feedback_folder,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;data&quot;</span>,
<span class="hljs-meta">... </span>    every=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Define the function that will be called when the user submits its feedback (to be called in Gradio)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">save_feedback</span>(<span class="hljs-params">input_text:<span class="hljs-built_in">str</span>, output_1: <span class="hljs-built_in">str</span>, output_2:<span class="hljs-built_in">str</span>, user_choice: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Append input/outputs and user feedback to a JSON Lines file using a thread lock to avoid concurrent writes from different users.
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> scheduler.lock:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">with</span> feedback_file.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>            f.write(json.dumps({<span class="hljs-string">&quot;input&quot;</span>: input_text, <span class="hljs-string">&quot;output_1&quot;</span>: output_1, <span class="hljs-string">&quot;output_2&quot;</span>: output_2, <span class="hljs-string">&quot;user_choice&quot;</span>: user_choice}))
<span class="hljs-meta">... </span>            f.write(<span class="hljs-string">&quot;\\n&quot;</span>)

<span class="hljs-comment"># Start Gradio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
<span class="hljs-meta">&gt;&gt;&gt; </span>    ... <span class="hljs-comment"># define Gradio demo + use \`save_feedback\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>demo.launch()`,wrap:!1}}),Ce=new w({props:{title:"Space persistence demo",local:"space-persistence-demo",headingTag:"h4"}}),Ge=new w({props:{title:"Custom uploads",local:"custom-uploads",headingTag:"h4"}}),Xe=new y({props:{code:"Y2xhc3MlMjBaaXBTY2hlZHVsZXIoQ29tbWl0U2NoZWR1bGVyKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHB1c2hfdG9faHViKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwMS4lMjBMaXN0JTIwUE5HJTIwZmlsZXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwbmdfZmlsZXMlMjAlM0QlMjBsaXN0KHNlbGYuZm9sZGVyX3BhdGguZ2xvYiglMjIqLnBuZyUyMikpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4ocG5nX2ZpbGVzKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBOb25lJTIwJTIwJTIzJTIwcmV0dXJuJTIwZWFybHklMjBpZiUyMG5vdGhpbmclMjB0byUyMGNvbW1pdCUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMDIuJTIwWmlwJTIwcG5nJTIwZmlsZXMlMjBpbiUyMGElMjBzaW5nbGUlMjBhcmNoaXZlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMHRlbXBmaWxlLlRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBkaXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlX3BhdGglMjAlM0QlMjBQYXRoKHRtcGRpciklMjAlMkYlMjAlMjJ0cmFpbi56aXAlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aXRoJTIwemlwZmlsZS5aaXBGaWxlKGFyY2hpdmVfcGF0aCUyQyUyMCUyMnclMjIlMkMlMjB6aXBmaWxlLlpJUF9ERUZMQVRFRCklMjBhcyUyMHppcCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHBuZ19maWxlJTIwaW4lMjBwbmdfZmlsZXMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB6aXAud3JpdGUoZmlsZW5hbWUlM0RwbmdfZmlsZSUyQyUyMGFyY25hbWUlM0RwbmdfZmlsZS5uYW1lKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMDMuJTIwVXBsb2FkJTIwYXJjaGl2ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYXBpLnVwbG9hZF9maWxlKC4uLiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGFyY2hpdmVfcGF0aCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjA0LiUyMERlbGV0ZSUyMGxvY2FsJTIwcG5nJTIwZmlsZXMlMjB0byUyMGF2b2lkJTIwcmUtdXBsb2FkaW5nJTIwdGhlbSUyMGxhdGVyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwcG5nX2ZpbGUlMjBpbiUyMHBuZ19maWxlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBuZ19maWxlLnVubGluaygp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ZipScheduler</span>(<span class="hljs-title class_ inherited__">CommitScheduler</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">self</span>):
        <span class="hljs-comment"># 1. List PNG files</span>
          png_files = <span class="hljs-built_in">list</span>(self.folder_path.glob(<span class="hljs-string">&quot;*.png&quot;</span>))
          <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(png_files) == <span class="hljs-number">0</span>:
              <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>  <span class="hljs-comment"># return early if nothing to commit</span>

        <span class="hljs-comment"># 2. Zip png files in a single archive</span>
        <span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
            archive_path = Path(tmpdir) / <span class="hljs-string">&quot;train.zip&quot;</span>
            <span class="hljs-keyword">with</span> zipfile.ZipFile(archive_path, <span class="hljs-string">&quot;w&quot;</span>, zipfile.ZIP_DEFLATED) <span class="hljs-keyword">as</span> <span class="hljs-built_in">zip</span>:
                <span class="hljs-keyword">for</span> png_file <span class="hljs-keyword">in</span> png_files:
                    <span class="hljs-built_in">zip</span>.write(filename=png_file, arcname=png_file.name)

            <span class="hljs-comment"># 3. Upload archive</span>
            self.api.upload_file(..., path_or_fileobj=archive_path)

        <span class="hljs-comment"># 4. Delete local png files to avoid re-uploading them later</span>
        <span class="hljs-keyword">for</span> png_file <span class="hljs-keyword">in</span> png_files:
            png_file.unlink()`,wrap:!1}}),$=new St({props:{$$slots:{default:[Un]},$$scope:{ctx:T}}}),Re=new w({props:{title:"create_commit",local:"createcommit",headingTag:"h3"}}),Fe=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwQ29tbWl0T3BlcmF0aW9uQWRkJTJDJTIwQ29tbWl0T3BlcmF0aW9uRGVsZXRlJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQW9wZXJhdGlvbnMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBDb21taXRPcGVyYXRpb25BZGQocGF0aF9pbl9yZXBvJTNEJTIyTElDRU5TRS5tZCUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRCUyMn4lMkZyZXBvJTJGTElDRU5TRS5tZCUyMiklMkMlMEElMjAlMjAlMjAlMjBDb21taXRPcGVyYXRpb25BZGQocGF0aF9pbl9yZXBvJTNEJTIyd2VpZ2h0cy5oNSUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRCUyMn4lMkZyZXBvJTJGd2VpZ2h0cy1maW5hbC5oNSUyMiklMkMlMEElMjAlMjAlMjAlMjBDb21taXRPcGVyYXRpb25EZWxldGUocGF0aF9pbl9yZXBvJTNEJTIyb2xkLXdlaWdodHMuaDUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwQ29tbWl0T3BlcmF0aW9uRGVsZXRlKHBhdGhfaW5fcmVwbyUzRCUyMmxvZ3MlMkYlMjIpJTJDJTBBJTIwJTIwJTIwJTIwQ29tbWl0T3BlcmF0aW9uQ29weShzcmNfcGF0aF9pbl9yZXBvJTNEJTIyaW1hZ2UucG5nJTIyJTJDJTIwcGF0aF9pbl9yZXBvJTNEJTIyZHVwbGljYXRlX2ltYWdlLnBuZyUyMiklMkMlMEElNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, CommitOperationAdd, CommitOperationDelete
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>operations = [
<span class="hljs-meta">... </span>    CommitOperationAdd(path_in_repo=<span class="hljs-string">&quot;LICENSE.md&quot;</span>, path_or_fileobj=<span class="hljs-string">&quot;~/repo/LICENSE.md&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationAdd(path_in_repo=<span class="hljs-string">&quot;weights.h5&quot;</span>, path_or_fileobj=<span class="hljs-string">&quot;~/repo/weights-final.h5&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationDelete(path_in_repo=<span class="hljs-string">&quot;old-weights.h5&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationDelete(path_in_repo=<span class="hljs-string">&quot;logs/&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationCopy(src_path_in_repo=<span class="hljs-string">&quot;image.png&quot;</span>, path_in_repo=<span class="hljs-string">&quot;duplicate_image.png&quot;</span>),
<span class="hljs-meta">... </span>]`,wrap:!1}}),Ne=new y({props:{code:"YXBpLmNyZWF0ZV9jb21taXQoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGdGVzdC1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wZXJhdGlvbnMlM0RvcGVyYXRpb25zJTJDJTBBJTIwJTIwJTIwJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJVcGxvYWQlMjBteSUyMG1vZGVsJTIwd2VpZ2h0cyUyMGFuZCUyMGxpY2Vuc2UlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_commit(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;lysandre/test-model&quot;</span>,
<span class="hljs-meta">... </span>    operations=operations,
<span class="hljs-meta">... </span>    commit_message=<span class="hljs-string">&quot;Upload my model weights and license&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ze=new w({props:{title:"Preupload LFS files before commit",local:"preupload-lfs-files-before-commit",headingTag:"h3"}}),C=new St({props:{warning:!0,$$slots:{default:[vn]},$$scope:{ctx:T}}}),Ke=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdE9wZXJhdGlvbkFkZCUyQyUyMHByZXVwbG9hZF9sZnNfZmlsZXMlMkMlMjBjcmVhdGVfY29tbWl0JTJDJTIwY3JlYXRlX3JlcG8lMEElMEFyZXBvX2lkJTIwJTNEJTIwY3JlYXRlX3JlcG8oJTIydGVzdF9wcmV1cGxvYWQlMjIpLnJlcG9faWQlMEElMEFvcGVyYXRpb25zJTIwJTNEJTIwJTVCJTVEJTIwJTIzJTIwTGlzdCUyMG9mJTIwYWxsJTIwJTYwQ29tbWl0T3BlcmF0aW9uQWRkJTYwJTIwb2JqZWN0cyUyMHRoYXQlMjB3aWxsJTIwYmUlMjBnZW5lcmF0ZWQlMEFmb3IlMjBpJTIwaW4lMjByYW5nZSg1KSUzQSUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlMjAlM0QlMjAuLi4lMjAlMjMlMjBnZW5lcmF0ZSUyMGJpbmFyeSUyMGNvbnRlbnQlMEElMjAlMjAlMjAlMjBhZGRpdGlvbiUyMCUzRCUyMENvbW1pdE9wZXJhdGlvbkFkZChwYXRoX2luX3JlcG8lM0RmJTIyc2hhcmRfJTdCaSU3RF9vZl81LmJpbiUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGNvbnRlbnQpJTBBJTIwJTIwJTIwJTIwcHJldXBsb2FkX2xmc19maWxlcyhyZXBvX2lkJTJDJTIwYWRkaXRpb25zJTNEJTVCYWRkaXRpb24lNUQpJTBBJTIwJTIwJTIwJTIwb3BlcmF0aW9ucy5hcHBlbmQoYWRkaXRpb24pJTBBJTBBJTIzJTIwQ3JlYXRlJTIwY29tbWl0JTBBY3JlYXRlX2NvbW1pdChyZXBvX2lkJTJDJTIwb3BlcmF0aW9ucyUzRG9wZXJhdGlvbnMlMkMlMjBjb21taXRfbWVzc2FnZSUzRCUyMkNvbW1pdCUyMGFsbCUyMHNoYXJkcyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitOperationAdd, preupload_lfs_files, create_commit, create_repo

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = create_repo(<span class="hljs-string">&quot;test_preupload&quot;</span>).repo_id

<span class="hljs-meta">&gt;&gt;&gt; </span>operations = [] <span class="hljs-comment"># List of all \`CommitOperationAdd\` objects that will be generated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
<span class="hljs-meta">... </span>    content = ... <span class="hljs-comment"># generate binary content</span>
<span class="hljs-meta">... </span>    addition = CommitOperationAdd(path_in_repo=<span class="hljs-string">f&quot;shard_<span class="hljs-subst">{i}</span>_of_5.bin&quot;</span>, path_or_fileobj=content)
<span class="hljs-meta">... </span>    preupload_lfs_files(repo_id, additions=[addition])
<span class="hljs-meta">... </span>    operations.append(addition)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create commit</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_commit(repo_id, operations=operations, commit_message=<span class="hljs-string">&quot;Commit all shards&quot;</span>)`,wrap:!1}}),et=new w({props:{title:"Tips and tricks for large uploads",local:"tips-and-tricks-for-large-uploads",headingTag:"h2"}}),st=new w({props:{title:"(legacy) Upload files with Git LFS",local:"legacy-upload-files-with-git-lfs",headingTag:"h2"}}),Z=new St({props:{warning:!0,$$slots:{default:[In]},$$scope:{ctx:T}}}),it=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbGZzLWVuYWJsZS1sYXJnZWZpbGVz",highlighted:"huggingface-cli lfs-enable-largefiles",wrap:!1}}),rt=new w({props:{title:"commit context manager",local:"commit-context-manager",headingTag:"h3"}}),ut=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEF3aXRoJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJ0ZXh0LWZpbGVzJTIyJTJDJTIwY2xvbmVfZnJvbSUzRCUyMiUzQ3VzZXIlM0UlMkZ0ZXh0LWZpbGVzJTIyKS5jb21taXQoY29tbWl0X21lc3NhZ2UlM0QlMjJNeSUyMGZpcnN0JTIwZmlsZSUyMCUzQSklMjIpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oJTIyZmlsZS50eHQlMjIlMkMlMjAlMjJ3JTJCJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYud3JpdGUoanNvbi5kdW1wcyglN0IlMjJoZXklMjIlM0ElMjA4JTdEKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(local_dir=<span class="hljs-string">&quot;text-files&quot;</span>, clone_from=<span class="hljs-string">&quot;&lt;user&gt;/text-files&quot;</span>).commit(commit_message=<span class="hljs-string">&quot;My first file :)&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;file.txt&quot;</span>, <span class="hljs-string">&quot;w+&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(json.dumps({<span class="hljs-string">&quot;hey&quot;</span>: <span class="hljs-number">8</span>}))`,wrap:!1}}),mt=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFtb2RlbCUyMCUzRCUyMHRvcmNoLm5uLlRyYW5zZm9ybWVyKCklMEF3aXRoJTIwUmVwb3NpdG9yeSglMjJ0b3JjaC1tb2RlbCUyMiUyQyUyMGNsb25lX2Zyb20lM0QlMjIlM0N1c2VyJTNFJTJGdG9yY2gtbW9kZWwlMjIlMkMlMjB0b2tlbiUzRFRydWUpLmNvbW1pdChjb21taXRfbWVzc2FnZSUzRCUyMk15JTIwY29vbCUyMG1vZGVsJTIwJTNBKSUyMiklM0ElMEElMjAlMjAlMjAlMjB0b3JjaC5zYXZlKG1vZGVsLnN0YXRlX2RpY3QoKSUyQyUyMCUyMm1vZGVsLnB0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span>model = torch.nn.Transformer()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(<span class="hljs-string">&quot;torch-model&quot;</span>, clone_from=<span class="hljs-string">&quot;&lt;user&gt;/torch-model&quot;</span>, token=<span class="hljs-literal">True</span>).commit(commit_message=<span class="hljs-string">&quot;My cool model :)&quot;</span>):
<span class="hljs-meta">... </span>    torch.save(model.state_dict(), <span class="hljs-string">&quot;model.pt&quot;</span>)`,wrap:!1}}),gt=new y({props:{code:"d2l0aCUyMHJlcG8uY29tbWl0KGNvbW1pdF9tZXNzYWdlJTNEJTIyTXklMjBjb29sJTIwbW9kZWwlMjAlM0EpJTIyJTJDJTIwYmxvY2tpbmclM0RGYWxzZSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> repo.commit(commit_message=<span class="hljs-string">&quot;My cool model :)&quot;</span>, blocking=<span class="hljs-literal">False</span>)',wrap:!1}}),Mt=new y({props:{code:"bGFzdF9jb21tYW5kJTIwJTNEJTIwcmVwby5jb21tYW5kX3F1ZXVlJTVCLTElNUQlMEFsYXN0X2NvbW1hbmQuc3RhdHVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>last_command = repo.command_queue[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>last_command.status`,wrap:!1}}),_t=new y({props:{code:"bGFzdF9jb21tYW5kLnN0ZGVyciUwQSUwQWxhc3RfY29tbWFuZC5pc19kb25lJTBBJTBBbGFzdF9jb21tYW5kLmZhaWxlZA==",highlighted:`<span class="hljs-comment"># Inspect an error.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_command.stderr

<span class="hljs-comment"># Check whether a push is completed or ongoing.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_command.is_done

<span class="hljs-comment"># Check whether a push command has errored.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_command.failed`,wrap:!1}}),jt=new w({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),vt=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJwYXRoJTJGdG8lMkZsb2NhbCUyRnJlcG8lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;path/to/local/repo&quot;</span>)`,wrap:!1}}),$t=new y({props:{code:"cmVwby5naXRfcHVsbCgpJTBBcmVwby5wdXNoX3RvX2h1Yihjb21taXRfbWVzc2FnZSUzRCUyMkNvbW1pdCUyMG15LWF3ZXNvbWUtZmlsZSUyMHRvJTIwdGhlJTIwSHViJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_pull()
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.push_to_hub(commit_message=<span class="hljs-string">&quot;Commit my-awesome-file to the Hub&quot;</span>)`,wrap:!1}}),Ct=new y({props:{code:"cmVwby5naXRfYWRkKCUyMnBhdGglMkZ0byUyRmZpbGUlMjIpJTBBcmVwby5naXRfY29tbWl0KGNvbW1pdF9tZXNzYWdlJTNEJTIyYWRkJTIwbXklMjBmaXJzdCUyMG1vZGVsJTIwY29uZmlnJTIwZmlsZSUyMCUzQSklMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_add(<span class="hljs-string">&quot;path/to/file&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_commit(commit_message=<span class="hljs-string">&quot;add my first model config file :)&quot;</span>)`,wrap:!1}}),Gt=new y({props:{code:"cmVwby5naXRfcHVzaCgp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_push()',wrap:!1}}),{c(){f=o("meta"),M=s(),g=o("p"),b=s(),r(G.$$.fragment),Vt=s(),H=o("p"),H.innerHTML=ts,Ft=s(),B=o("ul"),B.innerHTML=as,Nt=s(),X=o("p"),X.textContent=ls,Et=s(),U=o("ul"),W=o("li"),Xt=o("p"),Xt.textContent=ss,zl=s(),r(x.$$.fragment),Pl=s(),j=o("li"),Wt=o("p"),Wt.innerHTML=ns,Dl=s(),r(R.$$.fragment),Kl=s(),xt=o("p"),xt.innerHTML=os,Ol=s(),Rt=o("p"),Rt.innerHTML=is,qt=s(),r(A.$$.fragment),Qt=s(),Y=o("p"),Y.innerHTML=ps,zt=s(),S=o("p"),S.innerHTML=rs,Pt=s(),r(L.$$.fragment),Dt=s(),r(V.$$.fragment),Kt=s(),F=o("p"),F.innerHTML=cs,Ot=s(),r(N.$$.fragment),ea=s(),E=o("p"),E.innerHTML=hs,ta=s(),q=o("p"),q.innerHTML=us,aa=s(),r(Q.$$.fragment),la=s(),z=o("p"),z.innerHTML=ds,sa=s(),P=o("p"),P.innerHTML=ms,na=s(),r(D.$$.fragment),oa=s(),r(K.$$.fragment),ia=s(),O=o("p"),O.innerHTML=fs,pa=s(),ee=o("p"),ee.textContent=gs,ra=s(),r(te.$$.fragment),ca=s(),ae=o("p"),ae.innerHTML=ys,ha=s(),r(le.$$.fragment),ua=s(),se=o("p"),se.innerHTML=Ms,da=s(),r(ne.$$.fragment),ma=s(),oe=o("p"),oe.innerHTML=ws,fa=s(),r(ie.$$.fragment),ga=s(),pe=o("p"),pe.innerHTML=bs,ya=s(),r(re.$$.fragment),Ma=s(),r(ce.$$.fragment),wa=s(),he=o("p"),he.innerHTML=Ts,ba=s(),r(ue.$$.fragment),Ta=s(),de=o("p"),de.innerHTML=_s,_a=s(),r(me.$$.fragment),ja=s(),r(v.$$.fragment),Ja=s(),fe=o("p"),fe.innerHTML=js,Ua=s(),r(ge.$$.fragment),va=s(),r(ye.$$.fragment),Ia=s(),Me=o("p"),Me.innerHTML=Js,$a=s(),we=o("p"),we.innerHTML=Us,ka=s(),be=o("p"),be.innerHTML=vs,Ca=s(),r(Te.$$.fragment),Za=s(),_e=o("p"),_e.innerHTML=Is,Ga=s(),r(I.$$.fragment),Ha=s(),r(je.$$.fragment),Ba=s(),Je=o("p"),Je.innerHTML=$s,Xa=s(),Ue=o("p"),Ue.innerHTML=ks,Wa=s(),r(ve.$$.fragment),xa=s(),Ie=o("p"),Ie.textContent=Cs,Ra=s(),$e=o("p"),$e.innerHTML=Zs,Aa=s(),ke=o("ul"),ke.innerHTML=Gs,Ya=s(),r(Ce.$$.fragment),Sa=s(),Ze=o("p"),Ze.innerHTML=Hs,La=s(),r(Ge.$$.fragment),Va=s(),He=o("p"),He.innerHTML=Bs,Fa=s(),Be=o("p"),Be.innerHTML=Xs,Na=s(),r(Xe.$$.fragment),Ea=s(),We=o("p"),We.innerHTML=Ws,qa=s(),xe=o("ul"),xe.innerHTML=xs,Qa=s(),r($.$$.fragment),za=s(),r(Re.$$.fragment),Pa=s(),Ae=o("p"),Ae.innerHTML=Rs,Da=s(),Ye=o("p"),Ye.innerHTML=As,Ka=s(),Se=o("ul"),Se.innerHTML=Ys,Oa=s(),Le=o("p"),Le.textContent=Ss,el=s(),Ve=o("ol"),Ve.innerHTML=Ls,tl=s(),r(Fe.$$.fragment),al=s(),k=o("ol"),k.innerHTML=Vs,ll=s(),r(Ne.$$.fragment),sl=s(),Ee=o("p"),Ee.innerHTML=Fs,nl=s(),qe=o("ul"),qe.innerHTML=Ns,ol=s(),Qe=o("p"),Qe.innerHTML=Es,il=s(),r(ze.$$.fragment),pl=s(),Pe=o("p"),Pe.innerHTML=qs,rl=s(),r(C.$$.fragment),cl=s(),De=o("p"),De.textContent=Qs,hl=s(),r(Ke.$$.fragment),ul=s(),Oe=o("p"),Oe.innerHTML=zs,dl=s(),r(et.$$.fragment),ml=s(),tt=o("p"),tt.textContent=Ps,fl=s(),at=o("p"),at.innerHTML=Ds,gl=s(),lt=o("ul"),lt.innerHTML=Ks,yl=s(),r(st.$$.fragment),Ml=s(),nt=o("p"),nt.innerHTML=Os,wl=s(),r(Z.$$.fragment),bl=s(),ot=o("p"),ot.textContent=en,Tl=s(),r(it.$$.fragment),_l=s(),pt=o("p"),pt.textContent=tn,jl=s(),r(rt.$$.fragment),Jl=s(),ct=o("p"),ct.innerHTML=an,Ul=s(),ht=o("ol"),ht.innerHTML=ln,vl=s(),r(ut.$$.fragment),Il=s(),dt=o("p"),dt.innerHTML=sn,$l=s(),r(mt.$$.fragment),kl=s(),ft=o("p"),ft.innerHTML=nn,Cl=s(),r(gt.$$.fragment),Zl=s(),yt=o("p"),yt.innerHTML=on,Gl=s(),r(Mt.$$.fragment),Hl=s(),wt=o("p"),wt.textContent=pn,Bl=s(),bt=o("table"),bt.innerHTML=rn,Xl=s(),Tt=o("p"),Tt.innerHTML=cn,Wl=s(),r(_t.$$.fragment),xl=s(),r(jt.$$.fragment),Rl=s(),Jt=o("p"),Jt.innerHTML=hn,Al=s(),Ut=o("p"),Ut.innerHTML=un,Yl=s(),r(vt.$$.fragment),Sl=s(),It=o("p"),It.innerHTML=dn,Ll=s(),r($t.$$.fragment),Vl=s(),kt=o("p"),kt.innerHTML=mn,Fl=s(),r(Ct.$$.fragment),Nl=s(),Zt=o("p"),Zt.innerHTML=fn,El=s(),r(Gt.$$.fragment),ql=s(),At=o("p"),this.h()},l(e){const t=_n("svelte-u9bgzb",document.head);f=i(t,"META",{name:!0,content:!0}),t.forEach(a),M=n(e),g=i(e,"P",{}),Yt(g).forEach(a),b=n(e),c(G.$$.fragment,e),Vt=n(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-uu6wb2"&&(H.innerHTML=ts),Ft=n(e),B=i(e,"UL",{"data-svelte-h":!0}),p(B)!=="svelte-zq3wq3"&&(B.innerHTML=as),Nt=n(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-dy1t5h"&&(X.textContent=ls),Et=n(e),U=i(e,"UL",{});var Ht=Yt(U);W=i(Ht,"LI",{});var Bt=Yt(W);Xt=i(Bt,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-w1rpkl"&&(Xt.textContent=ss),zl=n(Bt),c(x.$$.fragment,Bt),Bt.forEach(a),Pl=n(Ht),j=i(Ht,"LI",{});var J=Yt(j);Wt=i(J,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-jzmt6o"&&(Wt.innerHTML=ns),Dl=n(J),c(R.$$.fragment,J),Kl=n(J),xt=i(J,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-mlk5ww"&&(xt.innerHTML=os),Ol=n(J),Rt=i(J,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-1965v0z"&&(Rt.innerHTML=is),J.forEach(a),Ht.forEach(a),qt=n(e),c(A.$$.fragment,e),Qt=n(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-gafng"&&(Y.innerHTML=ps),zt=n(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-weizha"&&(S.innerHTML=rs),Pt=n(e),c(L.$$.fragment,e),Dt=n(e),c(V.$$.fragment,e),Kt=n(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-9g9cws"&&(F.innerHTML=cs),Ot=n(e),c(N.$$.fragment,e),ea=n(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-sl7ozz"&&(E.innerHTML=hs),ta=n(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1hekay4"&&(q.innerHTML=us),aa=n(e),c(Q.$$.fragment,e),la=n(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1jdk3x1"&&(z.innerHTML=ds),sa=n(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-j2fnkr"&&(P.innerHTML=ms),na=n(e),c(D.$$.fragment,e),oa=n(e),c(K.$$.fragment,e),ia=n(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1c5u2uq"&&(O.innerHTML=fs),pa=n(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-sxpkdv"&&(ee.textContent=gs),ra=n(e),c(te.$$.fragment,e),ca=n(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1whpdih"&&(ae.innerHTML=ys),ha=n(e),c(le.$$.fragment,e),ua=n(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1ivwxb5"&&(se.innerHTML=Ms),da=n(e),c(ne.$$.fragment,e),ma=n(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-bukuzr"&&(oe.innerHTML=ws),fa=n(e),c(ie.$$.fragment,e),ga=n(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1pmffdy"&&(pe.innerHTML=bs),ya=n(e),c(re.$$.fragment,e),Ma=n(e),c(ce.$$.fragment,e),wa=n(e),he=i(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1eh6vuu"&&(he.innerHTML=Ts),ba=n(e),c(ue.$$.fragment,e),Ta=n(e),de=i(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-12xlnwq"&&(de.innerHTML=_s),_a=n(e),c(me.$$.fragment,e),ja=n(e),c(v.$$.fragment,e),Ja=n(e),fe=i(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-18hxmvp"&&(fe.innerHTML=js),Ua=n(e),c(ge.$$.fragment,e),va=n(e),c(ye.$$.fragment,e),Ia=n(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-n63bhr"&&(Me.innerHTML=Js),$a=n(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-pwsrx3"&&(we.innerHTML=Us),ka=n(e),be=i(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1kfhv6q"&&(be.innerHTML=vs),Ca=n(e),c(Te.$$.fragment,e),Za=n(e),_e=i(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-wnb4h6"&&(_e.innerHTML=Is),Ga=n(e),c(I.$$.fragment,e),Ha=n(e),c(je.$$.fragment,e),Ba=n(e),Je=i(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1g5gvvd"&&(Je.innerHTML=$s),Xa=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-10035c7"&&(Ue.innerHTML=ks),Wa=n(e),c(ve.$$.fragment,e),xa=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-bk7nho"&&(Ie.textContent=Cs),Ra=n(e),$e=i(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-18bvupw"&&($e.innerHTML=Zs),Aa=n(e),ke=i(e,"UL",{"data-svelte-h":!0}),p(ke)!=="svelte-1md1dub"&&(ke.innerHTML=Gs),Ya=n(e),c(Ce.$$.fragment,e),Sa=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1ub89y9"&&(Ze.innerHTML=Hs),La=n(e),c(Ge.$$.fragment,e),Va=n(e),He=i(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-1obrhwt"&&(He.innerHTML=Bs),Fa=n(e),Be=i(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-2fhb7l"&&(Be.innerHTML=Xs),Na=n(e),c(Xe.$$.fragment,e),Ea=n(e),We=i(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-100vo7j"&&(We.innerHTML=Ws),qa=n(e),xe=i(e,"UL",{"data-svelte-h":!0}),p(xe)!=="svelte-1wyrp0b"&&(xe.innerHTML=xs),Qa=n(e),c($.$$.fragment,e),za=n(e),c(Re.$$.fragment,e),Pa=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1uqssbt"&&(Ae.innerHTML=Rs),Da=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-12dju9t"&&(Ye.innerHTML=As),Ka=n(e),Se=i(e,"UL",{"data-svelte-h":!0}),p(Se)!=="svelte-1kj7min"&&(Se.innerHTML=Ys),Oa=n(e),Le=i(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-12aa4hm"&&(Le.textContent=Ss),el=n(e),Ve=i(e,"OL",{"data-svelte-h":!0}),p(Ve)!=="svelte-fvcpkg"&&(Ve.innerHTML=Ls),tl=n(e),c(Fe.$$.fragment,e),al=n(e),k=i(e,"OL",{start:!0,"data-svelte-h":!0}),p(k)!=="svelte-1jvhtvb"&&(k.innerHTML=Vs),ll=n(e),c(Ne.$$.fragment,e),sl=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-3lewdt"&&(Ee.innerHTML=Fs),nl=n(e),qe=i(e,"UL",{"data-svelte-h":!0}),p(qe)!=="svelte-1n0pi5w"&&(qe.innerHTML=Ns),ol=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-l2cfaf"&&(Qe.innerHTML=Es),il=n(e),c(ze.$$.fragment,e),pl=n(e),Pe=i(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-o31mxp"&&(Pe.innerHTML=qs),rl=n(e),c(C.$$.fragment,e),cl=n(e),De=i(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1mshy2g"&&(De.textContent=Qs),hl=n(e),c(Ke.$$.fragment,e),ul=n(e),Oe=i(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-1ea43lq"&&(Oe.innerHTML=zs),dl=n(e),c(et.$$.fragment,e),ml=n(e),tt=i(e,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-xzslhr"&&(tt.textContent=Ps),fl=n(e),at=i(e,"P",{"data-svelte-h":!0}),p(at)!=="svelte-r0dbxq"&&(at.innerHTML=Ds),gl=n(e),lt=i(e,"UL",{"data-svelte-h":!0}),p(lt)!=="svelte-1ue9jfa"&&(lt.innerHTML=Ks),yl=n(e),c(st.$$.fragment,e),Ml=n(e),nt=i(e,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-1l7xz4x"&&(nt.innerHTML=Os),wl=n(e),c(Z.$$.fragment,e),bl=n(e),ot=i(e,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-ckpv1u"&&(ot.textContent=en),Tl=n(e),c(it.$$.fragment,e),_l=n(e),pt=i(e,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-1su1bae"&&(pt.textContent=tn),jl=n(e),c(rt.$$.fragment,e),Jl=n(e),ct=i(e,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-1euyrt0"&&(ct.innerHTML=an),Ul=n(e),ht=i(e,"OL",{"data-svelte-h":!0}),p(ht)!=="svelte-jfle7b"&&(ht.innerHTML=ln),vl=n(e),c(ut.$$.fragment,e),Il=n(e),dt=i(e,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-1pjnw9q"&&(dt.innerHTML=sn),$l=n(e),c(mt.$$.fragment,e),kl=n(e),ft=i(e,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-1t3cobo"&&(ft.innerHTML=nn),Cl=n(e),c(gt.$$.fragment,e),Zl=n(e),yt=i(e,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-147hmo"&&(yt.innerHTML=on),Gl=n(e),c(Mt.$$.fragment,e),Hl=n(e),wt=i(e,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-i7szos"&&(wt.textContent=pn),Bl=n(e),bt=i(e,"TABLE",{"data-svelte-h":!0}),p(bt)!=="svelte-13yxo7x"&&(bt.innerHTML=rn),Xl=n(e),Tt=i(e,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-1j9orlr"&&(Tt.innerHTML=cn),Wl=n(e),c(_t.$$.fragment,e),xl=n(e),c(jt.$$.fragment,e),Rl=n(e),Jt=i(e,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-4iekp7"&&(Jt.innerHTML=hn),Al=n(e),Ut=i(e,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-ou5qb0"&&(Ut.innerHTML=un),Yl=n(e),c(vt.$$.fragment,e),Sl=n(e),It=i(e,"P",{"data-svelte-h":!0}),p(It)!=="svelte-1d5ve8v"&&(It.innerHTML=dn),Ll=n(e),c($t.$$.fragment,e),Vl=n(e),kt=i(e,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-1d06k48"&&(kt.innerHTML=mn),Fl=n(e),c(Ct.$$.fragment,e),Nl=n(e),Zt=i(e,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-1uc2wz2"&&(Zt.innerHTML=fn),El=n(e),c(Gt.$$.fragment,e),ql=n(e),At=i(e,"P",{}),Yt(At).forEach(a),this.h()},h(){es(f,"name","hf:doc:metadata"),es(f,"content",kn),es(k,"start","2")},m(e,t){_(document.head,f),l(e,M,t),l(e,g,t),l(e,b,t),h(G,e,t),l(e,Vt,t),l(e,H,t),l(e,Ft,t),l(e,B,t),l(e,Nt,t),l(e,X,t),l(e,Et,t),l(e,U,t),_(U,W),_(W,Xt),_(W,zl),h(x,W,null),_(U,Pl),_(U,j),_(j,Wt),_(j,Dl),h(R,j,null),_(j,Kl),_(j,xt),_(j,Ol),_(j,Rt),l(e,qt,t),h(A,e,t),l(e,Qt,t),l(e,Y,t),l(e,zt,t),l(e,S,t),l(e,Pt,t),h(L,e,t),l(e,Dt,t),h(V,e,t),l(e,Kt,t),l(e,F,t),l(e,Ot,t),h(N,e,t),l(e,ea,t),l(e,E,t),l(e,ta,t),l(e,q,t),l(e,aa,t),h(Q,e,t),l(e,la,t),l(e,z,t),l(e,sa,t),l(e,P,t),l(e,na,t),h(D,e,t),l(e,oa,t),h(K,e,t),l(e,ia,t),l(e,O,t),l(e,pa,t),l(e,ee,t),l(e,ra,t),h(te,e,t),l(e,ca,t),l(e,ae,t),l(e,ha,t),h(le,e,t),l(e,ua,t),l(e,se,t),l(e,da,t),h(ne,e,t),l(e,ma,t),l(e,oe,t),l(e,fa,t),h(ie,e,t),l(e,ga,t),l(e,pe,t),l(e,ya,t),h(re,e,t),l(e,Ma,t),h(ce,e,t),l(e,wa,t),l(e,he,t),l(e,ba,t),h(ue,e,t),l(e,Ta,t),l(e,de,t),l(e,_a,t),h(me,e,t),l(e,ja,t),h(v,e,t),l(e,Ja,t),l(e,fe,t),l(e,Ua,t),h(ge,e,t),l(e,va,t),h(ye,e,t),l(e,Ia,t),l(e,Me,t),l(e,$a,t),l(e,we,t),l(e,ka,t),l(e,be,t),l(e,Ca,t),h(Te,e,t),l(e,Za,t),l(e,_e,t),l(e,Ga,t),h(I,e,t),l(e,Ha,t),h(je,e,t),l(e,Ba,t),l(e,Je,t),l(e,Xa,t),l(e,Ue,t),l(e,Wa,t),h(ve,e,t),l(e,xa,t),l(e,Ie,t),l(e,Ra,t),l(e,$e,t),l(e,Aa,t),l(e,ke,t),l(e,Ya,t),h(Ce,e,t),l(e,Sa,t),l(e,Ze,t),l(e,La,t),h(Ge,e,t),l(e,Va,t),l(e,He,t),l(e,Fa,t),l(e,Be,t),l(e,Na,t),h(Xe,e,t),l(e,Ea,t),l(e,We,t),l(e,qa,t),l(e,xe,t),l(e,Qa,t),h($,e,t),l(e,za,t),h(Re,e,t),l(e,Pa,t),l(e,Ae,t),l(e,Da,t),l(e,Ye,t),l(e,Ka,t),l(e,Se,t),l(e,Oa,t),l(e,Le,t),l(e,el,t),l(e,Ve,t),l(e,tl,t),h(Fe,e,t),l(e,al,t),l(e,k,t),l(e,ll,t),h(Ne,e,t),l(e,sl,t),l(e,Ee,t),l(e,nl,t),l(e,qe,t),l(e,ol,t),l(e,Qe,t),l(e,il,t),h(ze,e,t),l(e,pl,t),l(e,Pe,t),l(e,rl,t),h(C,e,t),l(e,cl,t),l(e,De,t),l(e,hl,t),h(Ke,e,t),l(e,ul,t),l(e,Oe,t),l(e,dl,t),h(et,e,t),l(e,ml,t),l(e,tt,t),l(e,fl,t),l(e,at,t),l(e,gl,t),l(e,lt,t),l(e,yl,t),h(st,e,t),l(e,Ml,t),l(e,nt,t),l(e,wl,t),h(Z,e,t),l(e,bl,t),l(e,ot,t),l(e,Tl,t),h(it,e,t),l(e,_l,t),l(e,pt,t),l(e,jl,t),h(rt,e,t),l(e,Jl,t),l(e,ct,t),l(e,Ul,t),l(e,ht,t),l(e,vl,t),h(ut,e,t),l(e,Il,t),l(e,dt,t),l(e,$l,t),h(mt,e,t),l(e,kl,t),l(e,ft,t),l(e,Cl,t),h(gt,e,t),l(e,Zl,t),l(e,yt,t),l(e,Gl,t),h(Mt,e,t),l(e,Hl,t),l(e,wt,t),l(e,Bl,t),l(e,bt,t),l(e,Xl,t),l(e,Tt,t),l(e,Wl,t),h(_t,e,t),l(e,xl,t),h(jt,e,t),l(e,Rl,t),l(e,Jt,t),l(e,Al,t),l(e,Ut,t),l(e,Yl,t),h(vt,e,t),l(e,Sl,t),l(e,It,t),l(e,Ll,t),h($t,e,t),l(e,Vl,t),l(e,kt,t),l(e,Fl,t),h(Ct,e,t),l(e,Nl,t),l(e,Zt,t),l(e,El,t),h(Gt,e,t),l(e,ql,t),l(e,At,t),Ql=!0},p(e,[t]){const Ht={};t&2&&(Ht.$$scope={dirty:t,ctx:e}),v.$set(Ht);const Bt={};t&2&&(Bt.$$scope={dirty:t,ctx:e}),I.$set(Bt);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),$.$set(J);const gn={};t&2&&(gn.$$scope={dirty:t,ctx:e}),C.$set(gn);const yn={};t&2&&(yn.$$scope={dirty:t,ctx:e}),Z.$set(yn)},i(e){Ql||(u(G.$$.fragment,e),u(x.$$.fragment,e),u(R.$$.fragment,e),u(A.$$.fragment,e),u(L.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(Q.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(me.$$.fragment,e),u(v.$$.fragment,e),u(ge.$$.fragment,e),u(ye.$$.fragment,e),u(Te.$$.fragment,e),u(I.$$.fragment,e),u(je.$$.fragment,e),u(ve.$$.fragment,e),u(Ce.$$.fragment,e),u(Ge.$$.fragment,e),u(Xe.$$.fragment,e),u($.$$.fragment,e),u(Re.$$.fragment,e),u(Fe.$$.fragment,e),u(Ne.$$.fragment,e),u(ze.$$.fragment,e),u(C.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(st.$$.fragment,e),u(Z.$$.fragment,e),u(it.$$.fragment,e),u(rt.$$.fragment,e),u(ut.$$.fragment,e),u(mt.$$.fragment,e),u(gt.$$.fragment,e),u(Mt.$$.fragment,e),u(_t.$$.fragment,e),u(jt.$$.fragment,e),u(vt.$$.fragment,e),u($t.$$.fragment,e),u(Ct.$$.fragment,e),u(Gt.$$.fragment,e),Ql=!0)},o(e){d(G.$$.fragment,e),d(x.$$.fragment,e),d(R.$$.fragment,e),d(A.$$.fragment,e),d(L.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(Q.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(me.$$.fragment,e),d(v.$$.fragment,e),d(ge.$$.fragment,e),d(ye.$$.fragment,e),d(Te.$$.fragment,e),d(I.$$.fragment,e),d(je.$$.fragment,e),d(ve.$$.fragment,e),d(Ce.$$.fragment,e),d(Ge.$$.fragment,e),d(Xe.$$.fragment,e),d($.$$.fragment,e),d(Re.$$.fragment,e),d(Fe.$$.fragment,e),d(Ne.$$.fragment,e),d(ze.$$.fragment,e),d(C.$$.fragment,e),d(Ke.$$.fragment,e),d(et.$$.fragment,e),d(st.$$.fragment,e),d(Z.$$.fragment,e),d(it.$$.fragment,e),d(rt.$$.fragment,e),d(ut.$$.fragment,e),d(mt.$$.fragment,e),d(gt.$$.fragment,e),d(Mt.$$.fragment,e),d(_t.$$.fragment,e),d(jt.$$.fragment,e),d(vt.$$.fragment,e),d($t.$$.fragment,e),d(Ct.$$.fragment,e),d(Gt.$$.fragment,e),Ql=!1},d(e){e&&(a(M),a(g),a(b),a(Vt),a(H),a(Ft),a(B),a(Nt),a(X),a(Et),a(U),a(qt),a(Qt),a(Y),a(zt),a(S),a(Pt),a(Dt),a(Kt),a(F),a(Ot),a(ea),a(E),a(ta),a(q),a(aa),a(la),a(z),a(sa),a(P),a(na),a(oa),a(ia),a(O),a(pa),a(ee),a(ra),a(ca),a(ae),a(ha),a(ua),a(se),a(da),a(ma),a(oe),a(fa),a(ga),a(pe),a(ya),a(Ma),a(wa),a(he),a(ba),a(Ta),a(de),a(_a),a(ja),a(Ja),a(fe),a(Ua),a(va),a(Ia),a(Me),a($a),a(we),a(ka),a(be),a(Ca),a(Za),a(_e),a(Ga),a(Ha),a(Ba),a(Je),a(Xa),a(Ue),a(Wa),a(xa),a(Ie),a(Ra),a($e),a(Aa),a(ke),a(Ya),a(Sa),a(Ze),a(La),a(Va),a(He),a(Fa),a(Be),a(Na),a(Ea),a(We),a(qa),a(xe),a(Qa),a(za),a(Pa),a(Ae),a(Da),a(Ye),a(Ka),a(Se),a(Oa),a(Le),a(el),a(Ve),a(tl),a(al),a(k),a(ll),a(sl),a(Ee),a(nl),a(qe),a(ol),a(Qe),a(il),a(pl),a(Pe),a(rl),a(cl),a(De),a(hl),a(ul),a(Oe),a(dl),a(ml),a(tt),a(fl),a(at),a(gl),a(lt),a(yl),a(Ml),a(nt),a(wl),a(bl),a(ot),a(Tl),a(_l),a(pt),a(jl),a(Jl),a(ct),a(Ul),a(ht),a(vl),a(Il),a(dt),a($l),a(kl),a(ft),a(Cl),a(Zl),a(yt),a(Gl),a(Hl),a(wt),a(Bl),a(bt),a(Xl),a(Tt),a(Wl),a(xl),a(Rl),a(Jt),a(Al),a(Ut),a(Yl),a(Sl),a(It),a(Ll),a(Vl),a(kt),a(Fl),a(Nl),a(Zt),a(El),a(ql),a(At)),a(f),m(G,e),m(x),m(R),m(A,e),m(L,e),m(V,e),m(N,e),m(Q,e),m(D,e),m(K,e),m(te,e),m(le,e),m(ne,e),m(ie,e),m(re,e),m(ce,e),m(ue,e),m(me,e),m(v,e),m(ge,e),m(ye,e),m(Te,e),m(I,e),m(je,e),m(ve,e),m(Ce,e),m(Ge,e),m(Xe,e),m($,e),m(Re,e),m(Fe,e),m(Ne,e),m(ze,e),m(C,e),m(Ke,e),m(et,e),m(st,e),m(Z,e),m(it,e),m(rt,e),m(ut,e),m(mt,e),m(gt,e),m(Mt,e),m(_t,e),m(jt,e),m(vt,e),m($t,e),m(Ct,e),m(Gt,e)}}}const kn='{"title":"Upload files to the Hub","local":"upload-files-to-the-hub","sections":[{"title":"Upload a file","local":"upload-a-file","sections":[],"depth":2},{"title":"Upload a folder","local":"upload-a-folder","sections":[],"depth":2},{"title":"Upload from the CLI","local":"upload-from-the-cli","sections":[],"depth":2},{"title":"Advanced features","local":"advanced-features","sections":[{"title":"Non-blocking uploads","local":"non-blocking-uploads","sections":[],"depth":3},{"title":"Upload a folder by chunks","local":"upload-a-folder-by-chunks","sections":[],"depth":3},{"title":"Scheduled uploads","local":"scheduled-uploads","sections":[{"title":"Space persistence demo","local":"space-persistence-demo","sections":[],"depth":4},{"title":"Custom uploads","local":"custom-uploads","sections":[],"depth":4}],"depth":3},{"title":"create_commit","local":"createcommit","sections":[],"depth":3},{"title":"Preupload LFS files before commit","local":"preupload-lfs-files-before-commit","sections":[],"depth":3}],"depth":2},{"title":"Tips and tricks for large uploads","local":"tips-and-tricks-for-large-uploads","sections":[],"depth":2},{"title":"(legacy) Upload files with Git LFS","local":"legacy-upload-files-with-git-lfs","sections":[{"title":"commit context manager","local":"commit-context-manager","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3}],"depth":2}],"depth":1}';function Cn(T){return wn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wn extends bn{constructor(f){super(),Tn(this,f,Cn,$n,Mn,{})}}export{Wn as component};
