import{s as Ft,o as Pt,n as St}from"../chunks/scheduler.6062bdaf.js";import{S as Dt,i as Kt,g as i,s as a,r as m,A as Ot,h as o,f as l,c as n,j as At,u as d,x as c,k as ft,y as el,a as s,v as g,d as r,t as h,w as u}from"../chunks/index.4bca734e.js";import{T as Et}from"../chunks/Tip.b9ac1f03.js";import{C as b}from"../chunks/CodeBlock.fa01571c.js";import{H as j}from"../chunks/Heading.723dceba.js";function tl(be){let p,M='When listing collections, the item list per collection is truncated to 4 items maximum. To retrieve all items from a collection, you must use <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/hf_api#huggingface_hub.HfApi.get_collection">get_collection()</a>.';return{c(){p=i("p"),p.innerHTML=M},l(f){p=o(f,"P",{"data-svelte-h":!0}),c(p)!=="svelte-wrnlvp"&&(p.innerHTML=M)},m(f,y){s(f,p,y)},p:St,d(f){f&&l(p)}}}function ll(be){let p,M="This is a non-revertible action. A deleted collection cannot be restored.";return{c(){p=i("p"),p.textContent=M},l(f){p=o(f,"P",{"data-svelte-h":!0}),c(p)!=="svelte-1k7dttx"&&(p.textContent=M)},m(f,y){s(f,p,y)},p:St,d(f){f&&l(p)}}}function sl(be){let p,M,f,y,$,je,G,bt='A collection is a group of related items on the Hub (models, datasets, Spaces, papers) that are organized together on the same page. Collections are useful for creating your own portfolio, bookmarking content in categories, or presenting a curated list of items you want to share. Check out this <a href="https://huggingface.co/docs/hub/collections" rel="nofollow">guide</a> to understand in more detail what collections are and how they look on the Hub.',ye,w,Mt="You can directly manage collections in the browser, but in this guide, we will focus on how to manage it programmatically.",_e,T,ve,x,jt='Use <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/hf_api#huggingface_hub.HfApi.get_collection">get_collection()</a> to fetch your collections or any public ones. You must have the collection’s <em>slug</em> to retrieve a collection. A slug is an identifier for a collection based on the title and a unique ID. You can find the slug in the URL of the collection page.',Ue,_,yt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hfh_collection_slug.png"/>',$e,Z,_t="Let’s fetch the collection with, <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>:",Ge,k,we,C,vt='The <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/collections#huggingface_hub.Collection">Collection</a> object returned by <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/hf_api#huggingface_hub.HfApi.get_collection">get_collection()</a> contains:',Te,J,Ut='<li>high-level metadata: <code>slug</code>, <code>owner</code>, <code>title</code>, <code>description</code>, etc.</li> <li>a list of <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/collections#huggingface_hub.CollectionItem">CollectionItem</a> objects; each item represents a model, a dataset, a Space, or a paper.</li>',xe,W,$t="All collection items are guaranteed to have:",Ze,Y,Gt='<li>a unique <code>item_object_id</code>: this is the id of the collection item in the database</li> <li>an <code>item_id</code>: this is the id on the Hub of the underlying item (model, dataset, Space, paper); it is not necessarily unique, and only the <code>item_id</code>/<code>item_type</code> pair is unique</li> <li>an <code>item_type</code>: model, dataset, Space, paper</li> <li>the <code>position</code> of the item in the collection, which can be updated to reorganize your collection (see <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/hf_api#huggingface_hub.HfApi.update_collection_item">update_collection_item()</a> below)</li>',ke,N,wt="A <code>note</code> can also be attached to the item. This is useful to add additional information about the item (a comment, a link to a blog post, etc.). The attribute still has a <code>None</code> value if an item doesn’t have a note.",Ce,R,Tt="In addition to these base attributes, returned items can have additional attributes depending on their type: <code>author</code>, <code>private</code>, <code>lastModified</code>, <code>gated</code>, <code>title</code>, <code>likes</code>, <code>upvotes</code>, etc. None of these attributes are guaranteed to be returned.",Je,H,We,V,xt='We can also retrieve collections using <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/hf_api#huggingface_hub.HfApi.list_collections">list_collections()</a>. Collections can be filtered using some parameters. Let’s list all the collections from the user <a href="https://huggingface.co/teknium" rel="nofollow"><code>teknium</code></a>.',Ye,q,Ne,X,Zt="This returns an iterable of <code>Collection</code> objects. We can iterate over them to print, for example, the number of upvotes for each collection.",Re,L,He,v,Ve,B,kt='It is possible to do more advanced filtering. Let’s get all collections containing the model <a href="https://huggingface.co/TheBloke/OpenHermes-2.5-Mistral-7B-GGUF" rel="nofollow">TheBloke/OpenHermes-2.5-Mistral-7B-GGUF</a>, sorted by trending, and limit the count to 5.',qe,I,Xe,Q,Ct="Parameter <code>sort</code> must be one of  <code>&quot;last_modified&quot;</code>,  <code>&quot;trending&quot;</code> or <code>&quot;upvotes&quot;</code>. Parameter <code>item</code> accepts any particular item. For example:",Le,z,Jt="<li><code>&quot;models/teknium/OpenHermes-2.5-Mistral-7B&quot;</code></li> <li><code>&quot;spaces/julien-c/open-gpt-rhyming-robot&quot;</code></li> <li><code>&quot;datasets/squad&quot;</code></li> <li><code>&quot;papers/2311.12983&quot;</code></li>",Be,A,Wt='For more details, please check out <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/hf_api#huggingface_hub.HfApi.list_collections">list_collections()</a> reference.',Ie,E,Qe,S,Yt='Now that we know how to get a <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/collections#huggingface_hub.Collection">Collection</a>, let’s create our own! Use <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/hf_api#huggingface_hub.HfApi.create_collection">create_collection()</a> with a title and description. To create a collection on an organization page, pass <code>namespace=&quot;my-cool-org&quot;</code> when creating the collection. Finally, you can also create private collections by passing <code>private=True</code>.',ze,F,Ae,P,Nt='It will return a <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/collections#huggingface_hub.Collection">Collection</a> object with the high-level metadata (title, description, owner, etc.) and an empty list of items. You will now be able to refer to this collection using it’s <code>slug</code>.',Ee,D,Se,K,Fe,O,Rt='Now that we have a <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/collections#huggingface_hub.Collection">Collection</a>, we want to add items to it and organize them.',Pe,ee,De,te,Ht='Items have to be added one by one using <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/hf_api#huggingface_hub.HfApi.add_collection_item">add_collection_item()</a>. You only need to know the <code>collection_slug</code>, <code>item_id</code> and <code>item_type</code>. Optionally, you can also add a <code>note</code> to the item (500 characters maximum).',Ke,le,Oe,se,Vt="If an item already exists in a collection (same <code>item_id</code>/<code>item_type</code> pair), an HTTP 409 error will be raised. You can choose to ignore this error by setting <code>exists_ok=True</code>.",et,ae,tt,ne,qt='You can modify an existing item to add or modify the note attached to it using <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/hf_api#huggingface_hub.HfApi.update_collection_item">update_collection_item()</a>. Let’s reuse the example above:',lt,ie,st,oe,at,ce,Xt='Items in a collection are ordered. The order is determined by the <code>position</code> attribute of each item. By default, items are ordered by appending new items at the end of the collection. You can update the order using <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/hf_api#huggingface_hub.HfApi.update_collection_item">update_collection_item()</a> the same way you would add a note.',nt,pe,Lt="Let’s reuse our example above:",it,me,ot,de,ct,ge,Bt='Finally, you can also remove an item using <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/hf_api#huggingface_hub.HfApi.delete_collection_item">delete_collection_item()</a>.',pt,re,mt,he,dt,ue,It='A collection can be deleted using <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/hf_api#huggingface_hub.HfApi.delete_collection">delete_collection()</a>.',gt,U,rt,fe,ht,Me,ut;return $=new j({props:{title:"Collections",local:"collections",headingTag:"h1"}}),T=new j({props:{title:"Fetch a collection",local:"fetch-a-collection",headingTag:"h2"}}),k=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGdldF9jb2xsZWN0aW9uKCUyMlRoZUJsb2tlJTJGcmVjZW50LW1vZGVscy02NGY5YTU1YmIzMTE1YjRmNTEzZWMwMjYlMjIpJTBBY29sbGVjdGlvbiUwQWNvbGxlY3Rpb24uaXRlbXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection
Collection(
  slug=<span class="hljs-string">&#x27;TheBloke/recent-models-64f9a55bb3115b4f513ec026&#x27;</span>,
  title=<span class="hljs-string">&#x27;Recent models&#x27;</span>,
  owner=<span class="hljs-string">&#x27;TheBloke&#x27;</span>,
  items=[...],
  last_updated=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">10</span>, <span class="hljs-number">2</span>, <span class="hljs-number">22</span>, <span class="hljs-number">56</span>, <span class="hljs-number">48</span>, <span class="hljs-number">632000</span>, tzinfo=datetime.timezone.utc),
  position=<span class="hljs-number">1</span>,
  private=<span class="hljs-literal">False</span>,
  theme=<span class="hljs-string">&#x27;green&#x27;</span>,
  upvotes=<span class="hljs-number">90</span>,
  description=<span class="hljs-string">&quot;Models I&#x27;ve recently quantized. Please note that currently this list has to be updated manually, and therefore is not guaranteed to be up-to-date.&quot;</span>
)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.items[<span class="hljs-number">0</span>]
CollectionItem(
  item_object_id=<span class="hljs-string">&#x27;651446103cd773a050bf64c2&#x27;</span>,
  item_id=<span class="hljs-string">&#x27;TheBloke/U-Amethyst-20B-AWQ&#x27;</span>,
  item_type=<span class="hljs-string">&#x27;model&#x27;</span>,
  position=<span class="hljs-number">88</span>, 
  note=<span class="hljs-literal">None</span>
)`,wrap:!1}}),H=new j({props:{title:"List collections",local:"list-collections",headingTag:"h2"}}),q=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfY29sbGVjdGlvbnMlMEElMEFjb2xsZWN0aW9ucyUyMCUzRCUyMGxpc3RfY29sbGVjdGlvbnMob3duZXIlM0QlMjJ0ZWtuaXVtJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_collections

<span class="hljs-meta">&gt;&gt;&gt; </span>collections = list_collections(owner=<span class="hljs-string">&quot;teknium&quot;</span>)`,wrap:!1}}),L=new b({props:{code:"Zm9yJTIwY29sbGVjdGlvbiUyMGluJTIwY29sbGVjdGlvbnMlM0ElMEElMjAlMjBwcmludCglMjJOdW1iZXIlMjBvZiUyMHVwdm90ZXMlM0ElMjIlMkMlMjBjb2xsZWN0aW9uLnVwdm90ZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> collection <span class="hljs-keyword">in</span> collections:
<span class="hljs-meta">... </span>  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Number of upvotes:&quot;</span>, collection.upvotes)
Number of upvotes: <span class="hljs-number">1</span>
Number of upvotes: <span class="hljs-number">5</span>`,wrap:!1}}),v=new Et({props:{warning:!0,$$slots:{default:[tl]},$$scope:{ctx:be}}}),I=new b({props:{code:"Y29sbGVjdGlvbnMlMjAlM0QlMjBsaXN0X2NvbGxlY3Rpb25zKGl0ZW0lM0QlMjJtb2RlbHMlMkZUaGVCbG9rZSUyRk9wZW5IZXJtZXMtMi41LU1pc3RyYWwtN0ItR0dVRiUyMiUyQyUyMHNvcnQlM0QlMjJ0cmVuZGluZyUyMiUyQyUyMGxpbWl0JTNENSklM0ElMEFmb3IlMjBjb2xsZWN0aW9uJTIwaW4lMjBjb2xsZWN0aW9ucyUzQSUwQSUyMCUyMHByaW50KGNvbGxlY3Rpb24uc2x1Zyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>collections = list_collections(item=<span class="hljs-string">&quot;models/TheBloke/OpenHermes-2.5-Mistral-7B-GGUF&quot;</span>, sort=<span class="hljs-string">&quot;trending&quot;</span>, limit=<span class="hljs-number">5</span>):
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> collection <span class="hljs-keyword">in</span> collections:
<span class="hljs-meta">... </span>  <span class="hljs-built_in">print</span>(collection.slug)
teknium/quantized-models-6544690bb978e0b0f7328748
AmeerH/function-calling-65560a2565d7a6ef568527af
PostArchitekt/7bz-65479bb8c194936469697d8c
gnomealone/need-to-test-652007226c6ce4cdacf9c233
Crataco/favorite-7b-models-651944072b4fffcb41f8b568`,wrap:!1}}),E=new j({props:{title:"Create a new collection",local:"create-a-new-collection",headingTag:"h2"}}),F=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9jb2xsZWN0aW9uJTBBJTBBY29sbGVjdGlvbiUyMCUzRCUyMGNyZWF0ZV9jb2xsZWN0aW9uKCUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySUNDViUyMDIwMjMlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlBvcnRmb2xpbyUyMG9mJTIwbW9kZWxzJTJDJTIwcGFwZXJzJTIwYW5kJTIwZGVtb3MlMjBJJTIwcHJlc2VudGVkJTIwYXQlMjBJQ0NWJTIwMjAyMyUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_collection

<span class="hljs-meta">&gt;&gt;&gt; </span>collection = create_collection(
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;ICCV 2023&quot;</span>,
<span class="hljs-meta">... </span>    description=<span class="hljs-string">&quot;Portfolio of models, papers and demos I presented at ICCV 2023&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),D=new b({props:{code:"Y29sbGVjdGlvbi5zbHVnJTBBY29sbGVjdGlvbi50aXRsZSUwQWNvbGxlY3Rpb24ub3duZXIlMEFjb2xsZWN0aW9uLnVybA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>collection.slug
<span class="hljs-string">&#x27;owner/iccv-2023-15e23b46cb98efca45&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.title
<span class="hljs-string">&quot;ICCV 2023&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.owner
<span class="hljs-string">&quot;username&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.url
<span class="hljs-string">&#x27;https://huggingface.co/collections/owner/iccv-2023-15e23b46cb98efca45&#x27;</span>`,wrap:!1}}),K=new j({props:{title:"Manage items in a collection",local:"manage-items-in-a-collection",headingTag:"h2"}}),ee=new j({props:{title:"Add items",local:"add-items",headingTag:"h3"}}),le=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9jb2xsZWN0aW9uJTJDJTIwYWRkX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb24lMjAlM0QlMjBjcmVhdGVfY29sbGVjdGlvbih0aXRsZSUzRCUyMk9TJTIwV2VlayUyMEhpZ2hsaWdodHMlMjAtJTIwU2VwdCUyMDE4JTIwLSUyMDI0JTIyJTJDJTIwbmFtZXNwYWNlJTNEJTIyb3NhbnNldmllcm8lMjIpJTBBY29sbGVjdGlvbi5zbHVnJTBBJTBBYWRkX2NvbGxlY3Rpb25faXRlbShjb2xsZWN0aW9uLnNsdWclMkMlMjBpdGVtX2lkJTNEJTIyY29xdWklMkZ4dHRzJTIyJTJDJTIwaXRlbV90eXBlJTNEJTIyc3BhY2UlMjIpJTBBYWRkX2NvbGxlY3Rpb25faXRlbSglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uLnNsdWclMkMlMEElMjAlMjAlMjAlMjBpdGVtX2lkJTNEJTIyd2FycC1haSUyRnd1ZXJzdGNoZW4lMjIlMkMlMEElMjAlMjAlMjAlMjBpdGVtX3R5cGUlM0QlMjJtb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5vdGUlM0QlMjJXJUMzJUJDcnN0Y2hlbiUyMGlzJTIwYSUyMG5ldyUyMGZhc3QlMjBhbmQlMjBlZmZpY2llbnQlMjBoaWdoJTIwcmVzb2x1dGlvbiUyMHRleHQtdG8taW1hZ2UlMjBhcmNoaXRlY3R1cmUlMjBhbmQlMjBtb2RlbCUyMiUwQSklMEFhZGRfY29sbGVjdGlvbl9pdGVtKGNvbGxlY3Rpb24uc2x1ZyUyQyUyMGl0ZW1faWQlM0QlMjJsbXN5cyUyRmxtc3lzLWNoYXQtMW0lMjIlMkMlMjBpdGVtX3R5cGUlM0QlMjJkYXRhc2V0JTIyKSUwQWFkZF9jb2xsZWN0aW9uX2l0ZW0oY29sbGVjdGlvbi5zbHVnJTJDJTIwaXRlbV9pZCUzRCUyMndhcnAtYWklMkZ3dWVyc3RjaGVuJTIyJTJDJTIwaXRlbV90eXBlJTNEJTIyc3BhY2UlMjIpJTIwJTIzJTIwc2FtZSUyMGl0ZW1faWQlMkMlMjBkaWZmZXJlbnQlMjBpdGVtX3R5cGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_collection, add_collection_item

<span class="hljs-meta">&gt;&gt;&gt; </span>collection = create_collection(title=<span class="hljs-string">&quot;OS Week Highlights - Sept 18 - 24&quot;</span>, namespace=<span class="hljs-string">&quot;osanseviero&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.slug
<span class="hljs-string">&quot;osanseviero/os-week-highlights-sept-18-24-650bfed7f795a59f491afb80&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>add_collection_item(collection.slug, item_id=<span class="hljs-string">&quot;coqui/xtts&quot;</span>, item_type=<span class="hljs-string">&quot;space&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>add_collection_item(
<span class="hljs-meta">... </span>    collection.slug,
<span class="hljs-meta">... </span>    item_id=<span class="hljs-string">&quot;warp-ai/wuerstchen&quot;</span>,
<span class="hljs-meta">... </span>    item_type=<span class="hljs-string">&quot;model&quot;</span>,
<span class="hljs-meta">... </span>    note=<span class="hljs-string">&quot;Würstchen is a new fast and efficient high resolution text-to-image architecture and model&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>add_collection_item(collection.slug, item_id=<span class="hljs-string">&quot;lmsys/lmsys-chat-1m&quot;</span>, item_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>add_collection_item(collection.slug, item_id=<span class="hljs-string">&quot;warp-ai/wuerstchen&quot;</span>, item_type=<span class="hljs-string">&quot;space&quot;</span>) <span class="hljs-comment"># same item_id, different item_type</span>`,wrap:!1}}),ae=new j({props:{title:"Add a note to an existing item",local:"add-a-note-to-an-existing-item",headingTag:"h3"}}),ie=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwdXBkYXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb25fc2x1ZyUyMCUzRCUyMCUyMm9zYW5zZXZpZXJvJTJGb3Mtd2Vlay1oaWdobGlnaHRzLXNlcHQtMTgtMjQtNjUwYmZlZDdmNzk1YTU5ZjQ5MWFmYjgwJTIyJTBBY29sbGVjdGlvbiUyMCUzRCUyMGdldF9jb2xsZWN0aW9uKGNvbGxlY3Rpb25fc2x1ZyklMEElMEF1cGRhdGVfY29sbGVjdGlvbl9pdGVtKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRGNvbGxlY3Rpb25fc2x1ZyUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1QjIlNUQuaXRlbV9vYmplY3RfaWQlMkMlMEElMjAlMjAlMjAlMjBub3RlJTNEJTIyVGhpcyUyMGRhdGFzZXQlMjBjb250YWlucyUyMG9uZSUyMG1pbGxpb24lMjByZWFsLXdvcmxkJTIwY29udmVyc2F0aW9ucyUyMHdpdGglMjAyNSUyMHN0YXRlLW9mLXRoZS1hcnQlMjBMTE1zLiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, update_collection_item

<span class="hljs-comment"># Fetch collection with newly added items</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection_slug = <span class="hljs-string">&quot;osanseviero/os-week-highlights-sept-18-24-650bfed7f795a59f491afb80&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(collection_slug)

<span class="hljs-comment"># Add note the \`lmsys-chat-1m\` dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>update_collection_item(
<span class="hljs-meta">... </span>    collection_slug=collection_slug,
<span class="hljs-meta">... </span>    item_object_id=collection.items[<span class="hljs-number">2</span>].item_object_id,
<span class="hljs-meta">... </span>    note=<span class="hljs-string">&quot;This dataset contains one million real-world conversations with 25 state-of-the-art LLMs.&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),oe=new j({props:{title:"Reorder items",local:"reorder-items",headingTag:"h3"}}),me=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwdXBkYXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb25fc2x1ZyUyMCUzRCUyMCUyMm9zYW5zZXZpZXJvJTJGb3Mtd2Vlay1oaWdobGlnaHRzLXNlcHQtMTgtMjQtNjUwYmZlZDdmNzk1YTU5ZjQ5MWFmYjgwJTIyJTBBY29sbGVjdGlvbiUyMCUzRCUyMGdldF9jb2xsZWN0aW9uKGNvbGxlY3Rpb25fc2x1ZyklMEElMEF1cGRhdGVfY29sbGVjdGlvbl9pdGVtKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRGNvbGxlY3Rpb25fc2x1ZyUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1QjMlNUQuaXRlbV9vYmplY3RfaWQlMkMlMEElMjAlMjAlMjAlMjBwb3NpdGlvbiUzRDIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, update_collection_item

<span class="hljs-comment"># Fetch collection</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection_slug = <span class="hljs-string">&quot;osanseviero/os-week-highlights-sept-18-24-650bfed7f795a59f491afb80&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(collection_slug)

<span class="hljs-comment"># Reorder to place the two \`Wuerstchen\` items together</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>update_collection_item(
<span class="hljs-meta">... </span>    collection_slug=collection_slug,
<span class="hljs-meta">... </span>    item_object_id=collection.items[<span class="hljs-number">3</span>].item_object_id,
<span class="hljs-meta">... </span>    position=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),de=new j({props:{title:"Remove items",local:"remove-items",headingTag:"h3"}}),re=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwdXBkYXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb25fc2x1ZyUyMCUzRCUyMCUyMm9zYW5zZXZpZXJvJTJGb3Mtd2Vlay1oaWdobGlnaHRzLXNlcHQtMTgtMjQtNjUwYmZlZDdmNzk1YTU5ZjQ5MWFmYjgwJTIyJTBBY29sbGVjdGlvbiUyMCUzRCUyMGdldF9jb2xsZWN0aW9uKGNvbGxlY3Rpb25fc2x1ZyklMEElMEFkZWxldGVfY29sbGVjdGlvbl9pdGVtKGNvbGxlY3Rpb25fc2x1ZyUzRGNvbGxlY3Rpb25fc2x1ZyUyQyUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1QjAlNUQuaXRlbV9vYmplY3RfaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, update_collection_item

<span class="hljs-comment"># Fetch collection</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection_slug = <span class="hljs-string">&quot;osanseviero/os-week-highlights-sept-18-24-650bfed7f795a59f491afb80&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(collection_slug)

<span class="hljs-comment"># Remove \`coqui/xtts\` Space from the list</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>delete_collection_item(collection_slug=collection_slug, item_object_id=collection.items[<span class="hljs-number">0</span>].item_object_id)`,wrap:!1}}),he=new j({props:{title:"Delete collection",local:"delete-collection",headingTag:"h2"}}),U=new Et({props:{warning:!0,$$slots:{default:[ll]},$$scope:{ctx:be}}}),fe=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGRlbGV0ZV9jb2xsZWN0aW9uKCUyMnVzZXJuYW1lJTJGdXNlbGVzcy1jb2xsZWN0aW9uLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUyMG1pc3Npbmdfb2slM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = delete_collection(<span class="hljs-string">&quot;username/useless-collection-64f9a55bb3115b4f513ec026&quot;</span>, missing_ok=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){p=i("meta"),M=a(),f=i("p"),y=a(),m($.$$.fragment),je=a(),G=i("p"),G.innerHTML=bt,ye=a(),w=i("p"),w.textContent=Mt,_e=a(),m(T.$$.fragment),ve=a(),x=i("p"),x.innerHTML=jt,Ue=a(),_=i("div"),_.innerHTML=yt,$e=a(),Z=i("p"),Z.innerHTML=_t,Ge=a(),m(k.$$.fragment),we=a(),C=i("p"),C.innerHTML=vt,Te=a(),J=i("ul"),J.innerHTML=Ut,xe=a(),W=i("p"),W.textContent=$t,Ze=a(),Y=i("ul"),Y.innerHTML=Gt,ke=a(),N=i("p"),N.innerHTML=wt,Ce=a(),R=i("p"),R.innerHTML=Tt,Je=a(),m(H.$$.fragment),We=a(),V=i("p"),V.innerHTML=xt,Ye=a(),m(q.$$.fragment),Ne=a(),X=i("p"),X.innerHTML=Zt,Re=a(),m(L.$$.fragment),He=a(),m(v.$$.fragment),Ve=a(),B=i("p"),B.innerHTML=kt,qe=a(),m(I.$$.fragment),Xe=a(),Q=i("p"),Q.innerHTML=Ct,Le=a(),z=i("ul"),z.innerHTML=Jt,Be=a(),A=i("p"),A.innerHTML=Wt,Ie=a(),m(E.$$.fragment),Qe=a(),S=i("p"),S.innerHTML=Yt,ze=a(),m(F.$$.fragment),Ae=a(),P=i("p"),P.innerHTML=Nt,Ee=a(),m(D.$$.fragment),Se=a(),m(K.$$.fragment),Fe=a(),O=i("p"),O.innerHTML=Rt,Pe=a(),m(ee.$$.fragment),De=a(),te=i("p"),te.innerHTML=Ht,Ke=a(),m(le.$$.fragment),Oe=a(),se=i("p"),se.innerHTML=Vt,et=a(),m(ae.$$.fragment),tt=a(),ne=i("p"),ne.innerHTML=qt,lt=a(),m(ie.$$.fragment),st=a(),m(oe.$$.fragment),at=a(),ce=i("p"),ce.innerHTML=Xt,nt=a(),pe=i("p"),pe.textContent=Lt,it=a(),m(me.$$.fragment),ot=a(),m(de.$$.fragment),ct=a(),ge=i("p"),ge.innerHTML=Bt,pt=a(),m(re.$$.fragment),mt=a(),m(he.$$.fragment),dt=a(),ue=i("p"),ue.innerHTML=It,gt=a(),m(U.$$.fragment),rt=a(),m(fe.$$.fragment),ht=a(),Me=i("p"),this.h()},l(e){const t=Ot("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),M=n(e),f=o(e,"P",{}),At(f).forEach(l),y=n(e),d($.$$.fragment,e),je=n(e),G=o(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1d0qk1y"&&(G.innerHTML=bt),ye=n(e),w=o(e,"P",{"data-svelte-h":!0}),c(w)!=="svelte-17hzqgp"&&(w.textContent=Mt),_e=n(e),d(T.$$.fragment,e),ve=n(e),x=o(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1acq6u1"&&(x.innerHTML=jt),Ue=n(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),c(_)!=="svelte-1jx0yaw"&&(_.innerHTML=yt),$e=n(e),Z=o(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-xc9ft8"&&(Z.innerHTML=_t),Ge=n(e),d(k.$$.fragment,e),we=n(e),C=o(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-16a2xr8"&&(C.innerHTML=vt),Te=n(e),J=o(e,"UL",{"data-svelte-h":!0}),c(J)!=="svelte-gyw1rr"&&(J.innerHTML=Ut),xe=n(e),W=o(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1nrz3rc"&&(W.textContent=$t),Ze=n(e),Y=o(e,"UL",{"data-svelte-h":!0}),c(Y)!=="svelte-1no7vnw"&&(Y.innerHTML=Gt),ke=n(e),N=o(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-yexhpv"&&(N.innerHTML=wt),Ce=n(e),R=o(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1ih3le2"&&(R.innerHTML=Tt),Je=n(e),d(H.$$.fragment,e),We=n(e),V=o(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-5v93jh"&&(V.innerHTML=xt),Ye=n(e),d(q.$$.fragment,e),Ne=n(e),X=o(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-4v5som"&&(X.innerHTML=Zt),Re=n(e),d(L.$$.fragment,e),He=n(e),d(v.$$.fragment,e),Ve=n(e),B=o(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1kzgk7s"&&(B.innerHTML=kt),qe=n(e),d(I.$$.fragment,e),Xe=n(e),Q=o(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-jv0r4p"&&(Q.innerHTML=Ct),Le=n(e),z=o(e,"UL",{"data-svelte-h":!0}),c(z)!=="svelte-jnqrtk"&&(z.innerHTML=Jt),Be=n(e),A=o(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-jhtc2v"&&(A.innerHTML=Wt),Ie=n(e),d(E.$$.fragment,e),Qe=n(e),S=o(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-yo1lfh"&&(S.innerHTML=Yt),ze=n(e),d(F.$$.fragment,e),Ae=n(e),P=o(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-hio4ya"&&(P.innerHTML=Nt),Ee=n(e),d(D.$$.fragment,e),Se=n(e),d(K.$$.fragment,e),Fe=n(e),O=o(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-5795xb"&&(O.innerHTML=Rt),Pe=n(e),d(ee.$$.fragment,e),De=n(e),te=o(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-mwpbu9"&&(te.innerHTML=Ht),Ke=n(e),d(le.$$.fragment,e),Oe=n(e),se=o(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-k9xloo"&&(se.innerHTML=Vt),et=n(e),d(ae.$$.fragment,e),tt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-sm05xd"&&(ne.innerHTML=qt),lt=n(e),d(ie.$$.fragment,e),st=n(e),d(oe.$$.fragment,e),at=n(e),ce=o(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-1c2l5jq"&&(ce.innerHTML=Xt),nt=n(e),pe=o(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-jrb2lu"&&(pe.textContent=Lt),it=n(e),d(me.$$.fragment,e),ot=n(e),d(de.$$.fragment,e),ct=n(e),ge=o(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-zgn1v7"&&(ge.innerHTML=Bt),pt=n(e),d(re.$$.fragment,e),mt=n(e),d(he.$$.fragment,e),dt=n(e),ue=o(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-qfd3rv"&&(ue.innerHTML=It),gt=n(e),d(U.$$.fragment,e),rt=n(e),d(fe.$$.fragment,e),ht=n(e),Me=o(e,"P",{}),At(Me).forEach(l),this.h()},h(){ft(p,"name","hf:doc:metadata"),ft(p,"content",al),ft(_,"class","flex justify-center")},m(e,t){el(document.head,p),s(e,M,t),s(e,f,t),s(e,y,t),g($,e,t),s(e,je,t),s(e,G,t),s(e,ye,t),s(e,w,t),s(e,_e,t),g(T,e,t),s(e,ve,t),s(e,x,t),s(e,Ue,t),s(e,_,t),s(e,$e,t),s(e,Z,t),s(e,Ge,t),g(k,e,t),s(e,we,t),s(e,C,t),s(e,Te,t),s(e,J,t),s(e,xe,t),s(e,W,t),s(e,Ze,t),s(e,Y,t),s(e,ke,t),s(e,N,t),s(e,Ce,t),s(e,R,t),s(e,Je,t),g(H,e,t),s(e,We,t),s(e,V,t),s(e,Ye,t),g(q,e,t),s(e,Ne,t),s(e,X,t),s(e,Re,t),g(L,e,t),s(e,He,t),g(v,e,t),s(e,Ve,t),s(e,B,t),s(e,qe,t),g(I,e,t),s(e,Xe,t),s(e,Q,t),s(e,Le,t),s(e,z,t),s(e,Be,t),s(e,A,t),s(e,Ie,t),g(E,e,t),s(e,Qe,t),s(e,S,t),s(e,ze,t),g(F,e,t),s(e,Ae,t),s(e,P,t),s(e,Ee,t),g(D,e,t),s(e,Se,t),g(K,e,t),s(e,Fe,t),s(e,O,t),s(e,Pe,t),g(ee,e,t),s(e,De,t),s(e,te,t),s(e,Ke,t),g(le,e,t),s(e,Oe,t),s(e,se,t),s(e,et,t),g(ae,e,t),s(e,tt,t),s(e,ne,t),s(e,lt,t),g(ie,e,t),s(e,st,t),g(oe,e,t),s(e,at,t),s(e,ce,t),s(e,nt,t),s(e,pe,t),s(e,it,t),g(me,e,t),s(e,ot,t),g(de,e,t),s(e,ct,t),s(e,ge,t),s(e,pt,t),g(re,e,t),s(e,mt,t),g(he,e,t),s(e,dt,t),s(e,ue,t),s(e,gt,t),g(U,e,t),s(e,rt,t),g(fe,e,t),s(e,ht,t),s(e,Me,t),ut=!0},p(e,[t]){const Qt={};t&2&&(Qt.$$scope={dirty:t,ctx:e}),v.$set(Qt);const zt={};t&2&&(zt.$$scope={dirty:t,ctx:e}),U.$set(zt)},i(e){ut||(r($.$$.fragment,e),r(T.$$.fragment,e),r(k.$$.fragment,e),r(H.$$.fragment,e),r(q.$$.fragment,e),r(L.$$.fragment,e),r(v.$$.fragment,e),r(I.$$.fragment,e),r(E.$$.fragment,e),r(F.$$.fragment,e),r(D.$$.fragment,e),r(K.$$.fragment,e),r(ee.$$.fragment,e),r(le.$$.fragment,e),r(ae.$$.fragment,e),r(ie.$$.fragment,e),r(oe.$$.fragment,e),r(me.$$.fragment,e),r(de.$$.fragment,e),r(re.$$.fragment,e),r(he.$$.fragment,e),r(U.$$.fragment,e),r(fe.$$.fragment,e),ut=!0)},o(e){h($.$$.fragment,e),h(T.$$.fragment,e),h(k.$$.fragment,e),h(H.$$.fragment,e),h(q.$$.fragment,e),h(L.$$.fragment,e),h(v.$$.fragment,e),h(I.$$.fragment,e),h(E.$$.fragment,e),h(F.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(me.$$.fragment,e),h(de.$$.fragment,e),h(re.$$.fragment,e),h(he.$$.fragment,e),h(U.$$.fragment,e),h(fe.$$.fragment,e),ut=!1},d(e){e&&(l(M),l(f),l(y),l(je),l(G),l(ye),l(w),l(_e),l(ve),l(x),l(Ue),l(_),l($e),l(Z),l(Ge),l(we),l(C),l(Te),l(J),l(xe),l(W),l(Ze),l(Y),l(ke),l(N),l(Ce),l(R),l(Je),l(We),l(V),l(Ye),l(Ne),l(X),l(Re),l(He),l(Ve),l(B),l(qe),l(Xe),l(Q),l(Le),l(z),l(Be),l(A),l(Ie),l(Qe),l(S),l(ze),l(Ae),l(P),l(Ee),l(Se),l(Fe),l(O),l(Pe),l(De),l(te),l(Ke),l(Oe),l(se),l(et),l(tt),l(ne),l(lt),l(st),l(at),l(ce),l(nt),l(pe),l(it),l(ot),l(ct),l(ge),l(pt),l(mt),l(dt),l(ue),l(gt),l(rt),l(ht),l(Me)),l(p),u($,e),u(T,e),u(k,e),u(H,e),u(q,e),u(L,e),u(v,e),u(I,e),u(E,e),u(F,e),u(D,e),u(K,e),u(ee,e),u(le,e),u(ae,e),u(ie,e),u(oe,e),u(me,e),u(de,e),u(re,e),u(he,e),u(U,e),u(fe,e)}}}const al='{"title":"Collections","local":"collections","sections":[{"title":"Fetch a collection","local":"fetch-a-collection","sections":[],"depth":2},{"title":"List collections","local":"list-collections","sections":[],"depth":2},{"title":"Create a new collection","local":"create-a-new-collection","sections":[],"depth":2},{"title":"Manage items in a collection","local":"manage-items-in-a-collection","sections":[{"title":"Add items","local":"add-items","sections":[],"depth":3},{"title":"Add a note to an existing item","local":"add-a-note-to-an-existing-item","sections":[],"depth":3},{"title":"Reorder items","local":"reorder-items","sections":[],"depth":3},{"title":"Remove items","local":"remove-items","sections":[],"depth":3}],"depth":2},{"title":"Delete collection","local":"delete-collection","sections":[],"depth":2}],"depth":1}';function nl(be){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends Dt{constructor(p){super(),Kt(this,p,nl,sl,Ft,{})}}export{dl as component};
