import{s as Et,n as Qt,o as Gt}from"../chunks/scheduler.85c25b89.js";import{S as _t,i as At,g as i,s as a,r as o,A as Yt,h as p,f as s,c as n,j as Wt,u as c,x as m,k as Rt,y as Xt,a as l,v as r,d as M,t as h,w as y}from"../chunks/index.c9bcf812.js";import{C as Y}from"../chunks/CodeBlock.94efc595.js";import{H}from"../chunks/Heading.3c6e5b17.js";function Vt(Tt){let J,z,X,S,w,F,d,gt="<strong>EfficientNet</strong> is a convolutional neural network architecture and scaling method that uniformly scales all dimensions of depth/width/resolution using a <em>compound coefficient</em>. Unlike conventional practice that arbitrary scales  these factors, the EfficientNet scaling method uniformly scales network width, depth, and resolution with a set of fixed scaling coefficients. For example, if we want to use $2^N$ times more computational resources, then we can simply increase the network depth by $\\alpha ^ N$,  width by $\\beta ^ N$, and image size by $\\gamma ^ N$, where $\\alpha, \\beta, \\gamma$ are constant coefficients determined by a small grid search on the original small model. EfficientNet uses a compound coefficient $\\phi$ to uniformly scales network width, depth, and resolution in a  principled way.",L,j,ft="The compound scaling method is justified by the intuition that if the input image is bigger, then the network needs more layers to increase the receptive field and more channels to capture more fine-grained patterns on the bigger image.",D,T,ut='The base EfficientNet-B0 network is based on the inverted bottleneck residual blocks of <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetV2</a>, in addition to squeeze-and-excitation blocks.',P,g,bt='This collection of models amends EfficientNet by adding <a href="https://paperswithcode.com/method/condconv" rel="nofollow">CondConv</a> convolutions.',q,f,Ut='The weights from this model were ported from <a href="https://github.com/tensorflow/tpu" rel="nofollow">Tensorflow/TPU</a>.',K,u,O,b,Ct="To load a pretrained model:",tt,U,et,C,It="To load and preprocess the image:",st,I,lt,k,kt="To get the model predictions:",at,$,nt,N,$t="To get the top-5 predictions class names:",it,x,pt,B,Nt="Replace the model name with the variant you want to use, e.g. <code>tf_efficientnet_cc_b0_4e</code>. You can find the IDs in the model summaries at the top of this page.",mt,Z,xt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ot,v,ct,W,Bt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",rt,R,Mt,E,Zt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ht,Q,yt,G,vt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Jt,_,wt,A,dt,V,jt;return w=new H({props:{title:"(Tensorflow) EfficientNet CondConv",local:"tensorflow-efficientnet-condconv",headingTag:"h1"}}),u=new H({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),U=new Y({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX2VmZmljaWVudG5ldF9jY19iMF80ZSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_cc_b0_4e&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),I=new Y({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),x=new Y({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),v=new H({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),R=new Y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfZWZmaWNpZW50bmV0X2NjX2IwXzRlJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_cc_b0_4e&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),Q=new H({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),_=new H({props:{title:"Citation",local:"citation",headingTag:"h2"}}),A=new Y({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZhYnMtMTkwNC0wNDk3MSUyQyUwQSUyMCUyMGF1dGhvciUyMCUyMCUyMCUyMCUzRCUyMCU3QkJyYW5kb24lMjBZYW5nJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwR2FicmllbCUyMEJlbmRlciUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFF1b2MlMjBWLiUyMExlJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwSmlxdWFuJTIwTmdpYW0lN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QlNvZnQlMjBDb25kaXRpb25hbCUyMENvbXB1dGF0aW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxOTA0LjA0OTcxJTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTklN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTkwNC4wNDk3MSU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE5MDQuMDQ5NzElN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JUaHUlMkMlMjAyNSUyMEFwciUyMDIwMTklMjAxMyUzQTU1JTNBMDElMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRmFicy0xOTA0LTA0OTcxLmJpYiU3RCUyQyUwQSUyMCUyMGJpYnNvdXJjZSUyMCUzRCUyMCU3QmRibHAlMjBjb21wdXRlciUyMHNjaWVuY2UlMjBiaWJsaW9ncmFwaHklMkMlMjBodHRwcyUzQSUyRiUyRmRibHAub3JnJTdEJTBBJTdE",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>abs-<span class="hljs-number">1904</span>-<span class="hljs-number">04971</span>,
  author    = {Brandon Yang and
               Gabriel Bender and
               Quoc V. Le and
               Jiquan Ngiam},
  title     = {Soft Conditional Computation},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1904.04971</span>},
  year      = {<span class="hljs-number">2019</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1904.04971</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1904.04971</span>},
  timestamp = {Thu, <span class="hljs-number">25</span> Apr <span class="hljs-number">2019</span> <span class="hljs-number">13</span>:<span class="hljs-number">55</span>:<span class="hljs-number">01</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>abs-<span class="hljs-number">1904</span>-<span class="hljs-number">04971</span>.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),{c(){J=i("meta"),z=a(),X=i("p"),S=a(),o(w.$$.fragment),F=a(),d=i("p"),d.innerHTML=gt,L=a(),j=i("p"),j.textContent=ft,D=a(),T=i("p"),T.innerHTML=ut,P=a(),g=i("p"),g.innerHTML=bt,q=a(),f=i("p"),f.innerHTML=Ut,K=a(),o(u.$$.fragment),O=a(),b=i("p"),b.textContent=Ct,tt=a(),o(U.$$.fragment),et=a(),C=i("p"),C.textContent=It,st=a(),o(I.$$.fragment),lt=a(),k=i("p"),k.textContent=kt,at=a(),o($.$$.fragment),nt=a(),N=i("p"),N.textContent=$t,it=a(),o(x.$$.fragment),pt=a(),B=i("p"),B.innerHTML=Nt,mt=a(),Z=i("p"),Z.innerHTML=xt,ot=a(),o(v.$$.fragment),ct=a(),W=i("p"),W.textContent=Bt,rt=a(),o(R.$$.fragment),Mt=a(),E=i("p"),E.innerHTML=Zt,ht=a(),o(Q.$$.fragment),yt=a(),G=i("p"),G.innerHTML=vt,Jt=a(),o(_.$$.fragment),wt=a(),o(A.$$.fragment),dt=a(),V=i("p"),this.h()},l(t){const e=Yt("svelte-u9bgzb",document.head);J=p(e,"META",{name:!0,content:!0}),e.forEach(s),z=n(t),X=p(t,"P",{}),Wt(X).forEach(s),S=n(t),c(w.$$.fragment,t),F=n(t),d=p(t,"P",{"data-svelte-h":!0}),m(d)!=="svelte-1bwkfja"&&(d.innerHTML=gt),L=n(t),j=p(t,"P",{"data-svelte-h":!0}),m(j)!=="svelte-5z334a"&&(j.textContent=ft),D=n(t),T=p(t,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1lb2xzv"&&(T.innerHTML=ut),P=n(t),g=p(t,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1gcdgqy"&&(g.innerHTML=bt),q=n(t),f=p(t,"P",{"data-svelte-h":!0}),m(f)!=="svelte-k8hpf1"&&(f.innerHTML=Ut),K=n(t),c(u.$$.fragment,t),O=n(t),b=p(t,"P",{"data-svelte-h":!0}),m(b)!=="svelte-18ywhxh"&&(b.textContent=Ct),tt=n(t),c(U.$$.fragment,t),et=n(t),C=p(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1c2ipa8"&&(C.textContent=It),st=n(t),c(I.$$.fragment,t),lt=n(t),k=p(t,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1n9qsq1"&&(k.textContent=kt),at=n(t),c($.$$.fragment,t),nt=n(t),N=p(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-19cnvx1"&&(N.textContent=$t),it=n(t),c(x.$$.fragment,t),pt=n(t),B=p(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1ez17et"&&(B.innerHTML=Nt),mt=n(t),Z=p(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=xt),ot=n(t),c(v.$$.fragment,t),ct=n(t),W=p(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-9sr7nh"&&(W.textContent=Bt),rt=n(t),c(R.$$.fragment,t),Mt=n(t),E=p(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1kguc51"&&(E.innerHTML=Zt),ht=n(t),c(Q.$$.fragment,t),yt=n(t),G=p(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n0coha"&&(G.innerHTML=vt),Jt=n(t),c(_.$$.fragment,t),wt=n(t),c(A.$$.fragment,t),dt=n(t),V=p(t,"P",{}),Wt(V).forEach(s),this.h()},h(){Rt(J,"name","hf:doc:metadata"),Rt(J,"content",Ht)},m(t,e){Xt(document.head,J),l(t,z,e),l(t,X,e),l(t,S,e),r(w,t,e),l(t,F,e),l(t,d,e),l(t,L,e),l(t,j,e),l(t,D,e),l(t,T,e),l(t,P,e),l(t,g,e),l(t,q,e),l(t,f,e),l(t,K,e),r(u,t,e),l(t,O,e),l(t,b,e),l(t,tt,e),r(U,t,e),l(t,et,e),l(t,C,e),l(t,st,e),r(I,t,e),l(t,lt,e),l(t,k,e),l(t,at,e),r($,t,e),l(t,nt,e),l(t,N,e),l(t,it,e),r(x,t,e),l(t,pt,e),l(t,B,e),l(t,mt,e),l(t,Z,e),l(t,ot,e),r(v,t,e),l(t,ct,e),l(t,W,e),l(t,rt,e),r(R,t,e),l(t,Mt,e),l(t,E,e),l(t,ht,e),r(Q,t,e),l(t,yt,e),l(t,G,e),l(t,Jt,e),r(_,t,e),l(t,wt,e),r(A,t,e),l(t,dt,e),l(t,V,e),jt=!0},p:Qt,i(t){jt||(M(w.$$.fragment,t),M(u.$$.fragment,t),M(U.$$.fragment,t),M(I.$$.fragment,t),M($.$$.fragment,t),M(x.$$.fragment,t),M(v.$$.fragment,t),M(R.$$.fragment,t),M(Q.$$.fragment,t),M(_.$$.fragment,t),M(A.$$.fragment,t),jt=!0)},o(t){h(w.$$.fragment,t),h(u.$$.fragment,t),h(U.$$.fragment,t),h(I.$$.fragment,t),h($.$$.fragment,t),h(x.$$.fragment,t),h(v.$$.fragment,t),h(R.$$.fragment,t),h(Q.$$.fragment,t),h(_.$$.fragment,t),h(A.$$.fragment,t),jt=!1},d(t){t&&(s(z),s(X),s(S),s(F),s(d),s(L),s(j),s(D),s(T),s(P),s(g),s(q),s(f),s(K),s(O),s(b),s(tt),s(et),s(C),s(st),s(lt),s(k),s(at),s(nt),s(N),s(it),s(pt),s(B),s(mt),s(Z),s(ot),s(ct),s(W),s(rt),s(Mt),s(E),s(ht),s(yt),s(G),s(Jt),s(wt),s(dt),s(V)),s(J),y(w,t),y(u,t),y(U,t),y(I,t),y($,t),y(x,t),y(v,t),y(R,t),y(Q,t),y(_,t),y(A,t)}}}const Ht='{"title":"(Tensorflow) EfficientNet CondConv","local":"tensorflow-efficientnet-condconv","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function zt(Tt){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pt extends _t{constructor(J){super(),At(this,J,zt,Vt,Et,{})}}export{Pt as component};
