import{s as Ml,n as cl,o as ul}from"../chunks/scheduler.9991993c.js";import{S as fl,i as dl,g as o,s as n,r as i,A as wl,h as p,f as t,c as a,j as il,u as m,x as r,k as ml,y as yl,a as s,v as M,d as c,t as u,w as f}from"../chunks/index.7fc9a5e7.js";import{C as w}from"../chunks/CodeBlock.e11cba92.js";import{D as Tl}from"../chunks/DocNotebookDropdown.145e5ada.js";import{H as le}from"../chunks/Heading.e3de321f.js";function bl(Ee){let d,te,O,se,y,ne,T,ae,b,Le='加速线性代数，也称为XLA，是一个用于加速TensorFlow模型运行时间的编译器。从<a href="https://www.tensorflow.org/xla" rel="nofollow">官方文档</a>中可以看到：',oe,h,Qe="XLA（加速线性代数）是一种针对线性代数的特定领域编译器，可以在可能不需要更改源代码的情况下加速TensorFlow模型。",pe,J,He='在TensorFlow中使用XLA非常简单——它包含在<code>tensorflow</code>库中，并且可以使用任何图创建函数中的<code>jit_compile</code>参数来触发，例如<a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow"><code>tf.function</code></a>。在使用Keras方法如<code>fit()</code>和<code>predict()</code>时，只需将<code>jit_compile</code>参数传递给<code>model.compile()</code>即可启用XLA。然而，XLA不仅限于这些方法 - 它还可以用于加速任何任意的<code>tf.function</code>。',re,j,Ne='在🤗 Transformers中，几个TensorFlow方法已经被重写为与XLA兼容，包括<a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>、<a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>和<a href="https://huggingface.co/docs/transformers/model_doc/opt" rel="nofollow">OPT</a>等文本生成模型，以及<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>等语音处理模型。',ie,U,Ae="虽然确切的加速倍数很大程度上取决于模型，但对于🤗 Transformers中的TensorFlow文本生成模型，我们注意到速度提高了约100倍。本文档将解释如何在这些模型上使用XLA获得最大的性能。如果您有兴趣了解更多关于基准测试和我们在XLA集成背后的设计哲学的信息，我们还将提供额外的资源链接。",me,g,Me,Z,Ye="让我们考虑以下TensorFlow 中的模型：",ce,_,ue,k,qe="上述模型接受维度为 <code>(10,)</code> 的输入。我们可以像下面这样使用模型进行前向传播：",fe,X,de,G,Se="为了使用 XLA 编译的函数运行前向传播，我们需要执行以下操作：",we,B,ye,I,Pe="<code>model</code>的默认<code>call()</code>函数用于编译XLA图。但如果你想将其他模型函数编译成XLA，也是可以的，如下所示：",Te,R,be,W,he,$,Ke="要在🤗 Transformers中启用XLA加速生成，您需要安装最新版本的<code>transformers</code>。您可以通过运行以下命令来安装它：",Je,C,je,x,De="然后您可以运行以下代码：",Ue,v,ge,F,Oe="正如您所注意到的，在<code>generate()</code>上启用XLA只需要一行代码。其余部分代码保持不变。然而，上面的代码片段中有一些与XLA相关的注意事项。您需要了解这些注意事项，以充分利用XLA可能带来的性能提升。我们将在下面的部分讨论这些内容。",Ze,V,_e,z,el='当您首次执行启用XLA的函数（如上面的<code>xla_generate()</code>）时，它将在内部尝试推断计算图，这是一个耗时的过程。这个过程被称为<a href="https://www.tensorflow.org/guide/intro_to_graphs#when_is_a_function_tracing" rel="nofollow">“tracing”</a>。',ke,E,ll="您可能会注意到生成时间并不快。连续调用<code>xla_generate()</code>（或任何其他启用了XLA的函数）不需要再次推断计算图，只要函数的输入与最初构建计算图时的形状相匹配。对于具有固定输入形状的模态（例如图像），这不是问题，但如果您正在处理具有可变输入形状的模态（例如文本），则必须注意。",Xe,L,tl="为了确保<code>xla_generate()</code>始终使用相同的输入形状，您可以在调用<code>tokenizer</code>时指定<code>padding</code>参数。",Ge,Q,Be,H,sl="通过这种方式，您可以确保<code>xla_generate()</code>的输入始终具有它跟踪的形状，从而加速生成时间。您可以使用以下代码来验证这一点：",Ie,N,Re,A,nl="在Tesla T4 GPU上，您可以期望如下的输出：",We,Y,$e,q,al="第一次调用<code>xla_generate()</code>会因为<code>tracing</code>而耗时，但后续的调用会快得多。请注意，任何时候对生成选项的更改都会触发重新<code>tracing</code>，从而导致生成时间减慢。",Ce,S,ol="在本文档中，我们没有涵盖🤗 Transformers提供的所有文本生成选项。我们鼓励您阅读文档以了解高级用例。",xe,P,ve,K,pl="以下是一些附加资源，如果您想深入了解在🤗 Transformers和其他库下使用XLA：",Fe,D,rl='<li><p><a href="https://colab.research.google.com/github/huggingface/blog/blob/main/notebooks/91_tf_xla_generate.ipynb" rel="nofollow">这个Colab Notebook</a> 提供了一个互动演示，让您可以尝试使用XLA兼容的编码器-解码器（例如<a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>）和仅解码器（例如<a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>）文本生成模型。</p></li> <li><p><a href="https://huggingface.co/blog/tf-xla-generate" rel="nofollow">这篇博客文章</a> 提供了XLA兼容模型的比较基准概述，以及关于在TensorFlow中使用XLA的友好介绍。</p></li> <li><p><a href="https://blog.tensorflow.org/2022/11/how-hugging-face-improved-text-generation-performance-with-xla.html" rel="nofollow">这篇博客文章</a> 讨论了我们在🤗 Transformers中为TensorFlow模型添加XLA支持的设计理念。</p></li> <li><p>推荐用于更多学习XLA和TensorFlow图的资源：</p> <ul><li><a href="https://www.tensorflow.org/xla" rel="nofollow">XLA：面向机器学习的优化编译器</a></li> <li><a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow">图和tf.function简介</a></li> <li><a href="https://www.tensorflow.org/guide/function" rel="nofollow">使用tf.function获得更好的性能</a></li></ul></li>',Ve,ee,ze;return y=new le({props:{title:"用于 TensorFlow 模型的 XLA 集成",local:"用于-tensorflow-模型的-xla-集成",headingTag:"h1"}}),T=new Tl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/tf_xla.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/tf_xla.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/tf_xla.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/tf_xla.ipynb"}]}}),g=new le({props:{title:"使用 XLA 运行 TensorFlow 函数",local:"使用-xla-运行-tensorflow-函数",headingTag:"h2"}}),_=new w({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFtb2RlbCUyMCUzRCUyMHRmLmtlcmFzLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTVCdGYua2VyYXMubGF5ZXJzLkRlbnNlKDEwJTJDJTIwaW5wdXRfc2hhcGUlM0QoMTAlMkMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTIwdGYua2VyYXMubGF5ZXJzLkRlbnNlKDUlMkMlMjBhY3RpdmF0aW9uJTNEJTIyc29mdG1heCUyMiklNUQlMEEp",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

model = tf.keras.Sequential(
    [tf.keras.layers.Dense(<span class="hljs-number">10</span>, input_shape=(<span class="hljs-number">10</span>,), activation=<span class="hljs-string">&quot;relu&quot;</span>), tf.keras.layers.Dense(<span class="hljs-number">5</span>, activation=<span class="hljs-string">&quot;softmax&quot;</span>)]
)`,wrap:!1}}),X=new w({props:{code:"JTIzJTIwR2VuZXJhdGUlMjByYW5kb20lMjBpbnB1dHMlMjBmb3IlMjB0aGUlMjBtb2RlbC4lMEFiYXRjaF9zaXplJTIwJTNEJTIwMTYlMEFpbnB1dF92ZWN0b3JfZGltJTIwJTNEJTIwMTAlMEFyYW5kb21faW5wdXRzJTIwJTNEJTIwdGYucmFuZG9tLm5vcm1hbCgoYmF0Y2hfc2l6ZSUyQyUyMGlucHV0X3ZlY3Rvcl9kaW0pKSUwQSUwQSUyMyUyMFJ1biUyMGElMjBmb3J3YXJkJTIwcGFzcy4lMEFfJTIwJTNEJTIwbW9kZWwocmFuZG9tX2lucHV0cyk=",highlighted:`<span class="hljs-comment"># Generate random inputs for the model.</span>
batch_size = <span class="hljs-number">16</span>
input_vector_dim = <span class="hljs-number">10</span>
random_inputs = tf.random.normal((batch_size, input_vector_dim))

<span class="hljs-comment"># Run a forward pass.</span>
_ = model(random_inputs)`,wrap:!1}}),B=new w({props:{code:"eGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBXyUyMCUzRCUyMHhsYV9mbihyYW5kb21faW5wdXRzKQ==",highlighted:`xla_fn = tf.function(model, jit_compile=<span class="hljs-literal">True</span>)
_ = xla_fn(random_inputs)`,wrap:!1}}),R=new w({props:{code:"bXlfeGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwubXlfeGxhX2ZuJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKQ==",highlighted:'my_xla_fn = tf.function(model.my_xla_fn, jit_compile=<span class="hljs-literal">True</span>)',wrap:!1}}),W=new le({props:{title:"在🤗 Transformers库中使用XLA运行TensorFlow文本生成模型",local:"在-transformers库中使用xla运行tensorflow文本生成模型",headingTag:"h2"}}),C=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMC0tdXBncmFkZQ==",highlighted:"pip install transformers --upgrade",wrap:!1}}),v=new w({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBXaWxsJTIwZXJyb3IlMjBpZiUyMHRoZSUyMG1pbmltYWwlMjB2ZXJzaW9uJTIwb2YlMjBUcmFuc2Zvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZC4lMEFmcm9tJTIwdHJhbnNmb3JtZXJzLnV0aWxzJTIwaW1wb3J0JTIwY2hlY2tfbWluX3ZlcnNpb24lMEElMEFjaGVja19taW5fdmVyc2lvbiglMjI0LjIxLjAlMjIpJTBBJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dF9zdHJpbmclMjAlM0QlMjAlNUIlMjJUZW5zb3JGbG93JTIwaXMlMjIlNUQlMEElMEElMjMlMjBPbmUlMjBsaW5lJTIwdG8lMjBjcmVhdGUlMjBhbiUyMFhMQSUyMGdlbmVyYXRpb24lMjBmdW5jdGlvbiUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQXRva2VuaXplZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplcihpbnB1dF9zdHJpbmclMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQWdlbmVyYXRlZF90b2tlbnMlMjAlM0QlMjB4bGFfZ2VuZXJhdGUoKip0b2tlbml6ZWRfaW5wdXQlMkMlMjBudW1fYmVhbXMlM0QyKSUwQSUwQWRlY29kZWRfdGV4dCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChmJTIyR2VuZXJhdGVkJTIwLS0lMjAlN0JkZWNvZGVkX3RleHQlN0QlMjIpJTBBJTIzJTIwR2VuZXJhdGVkJTIwLS0lMjBUZW5zb3JGbG93JTIwaXMlMjBhbiUyMG9wZW4tc291cmNlJTJDJTIwb3Blbi1zb3VyY2UlMkMlMjBkaXN0cmlidXRlZC1zb3VyY2UlMjBhcHBsaWNhdGlvbiUyMCUyMyUyMGZyYW1ld29yayUyMGZvciUyMHRoZQ==",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

<span class="hljs-comment"># Will error if the minimal version of Transformers is not installed.</span>
<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> check_min_version

check_min_version(<span class="hljs-string">&quot;4.21.0&quot;</span>)


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

<span class="hljs-comment"># One line to create an XLA generation function</span>
xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

tokenized_input = tokenizer(input_string, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)

decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)
<span class="hljs-comment"># Generated -- TensorFlow is an open-source, open-source, distributed-source application # framework for the</span>`,wrap:!1}}),V=new le({props:{title:"需要关注的注意事项",local:"需要关注的注意事项",headingTag:"h2"}}),Q=new w({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiUyQyUyMHBhZF90b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQWlucHV0X3N0cmluZyUyMCUzRCUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiU1RCUwQSUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQSUyMyUyMEhlcmUlMkMlMjB3ZSUyMGNhbGwlMjB0aGUlMjB0b2tlbml6ZXIlMjB3aXRoJTIwcGFkZGluZyUyMG9wdGlvbnMuJTBBdG9rZW5pemVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cmluZyUyQyUyMHBhZF90b19tdWx0aXBsZV9vZiUzRDglMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBZGVjb2RlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjAtLSUyMCU3QmRlY29kZWRfdGV4dCU3RCUyMik=",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Here, we call the tokenizer with padding options.</span>
tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)`,wrap:!1}}),N=new w({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEElMEF4bGFfZ2VuZXJhdGUlMjAlM0QlMjB0Zi5mdW5jdGlvbihtb2RlbC5nZW5lcmF0ZSUyQyUyMGppdF9jb21waWxlJTNEVHJ1ZSklMEElMEFmb3IlMjBpbnB1dF9zdHJpbmclMjBpbiUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiUyQyUyMCUyMlRlbnNvckZsb3clMjBpcyUyMGElMjIlMkMlMjAlMjJURkxpdGUlMjBpcyUyMGElMjIlNUQlM0ElMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfc3RyaW5nJTJDJTIwcGFkX3RvX211bHRpcGxlX29mJTNEOCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMjAlMjAlMjAlMjBzdGFydCUyMCUzRCUyMHRpbWUudGltZV9ucygpJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBJTIwJTIwJTIwJTIwZW5kJTIwJTNEJTIwdGltZS50aW1lX25zKCklMEElMjAlMjAlMjAlMjBwcmludChmJTIyRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwJTdCKGVuZCUyMC0lMjBzdGFydCklMjAlMkYlMjAxZTYlM0EuMWYlN0QlMjBtcyU1Q24lMjIp",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">for</span> input_string <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;TensorFlow is&quot;</span>, <span class="hljs-string">&quot;TensorFlow is a&quot;</span>, <span class="hljs-string">&quot;TFLite is a&quot;</span>]:
    tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
    start = time.time_ns()
    generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
    end = time.time_ns()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Execution time -- <span class="hljs-subst">{(end - start) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span> ms\\n&quot;</span>)`,wrap:!1}}),Y=new w({props:{code:"RXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwMzA4MTkuNiUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzkuMCUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzguOSUyMG1z",highlighted:`Execution time -- 30819.6 ms

Execution time -- 79.0 ms

Execution time -- 78.9 ms`,wrap:!1}}),P=new le({props:{title:"附加资源",local:"附加资源",headingTag:"h2"}}),{c(){d=o("meta"),te=n(),O=o("p"),se=n(),i(y.$$.fragment),ne=n(),i(T.$$.fragment),ae=n(),b=o("p"),b.innerHTML=Le,oe=n(),h=o("p"),h.textContent=Qe,pe=n(),J=o("p"),J.innerHTML=He,re=n(),j=o("p"),j.innerHTML=Ne,ie=n(),U=o("p"),U.textContent=Ae,me=n(),i(g.$$.fragment),Me=n(),Z=o("p"),Z.textContent=Ye,ce=n(),i(_.$$.fragment),ue=n(),k=o("p"),k.innerHTML=qe,fe=n(),i(X.$$.fragment),de=n(),G=o("p"),G.textContent=Se,we=n(),i(B.$$.fragment),ye=n(),I=o("p"),I.innerHTML=Pe,Te=n(),i(R.$$.fragment),be=n(),i(W.$$.fragment),he=n(),$=o("p"),$.innerHTML=Ke,Je=n(),i(C.$$.fragment),je=n(),x=o("p"),x.textContent=De,Ue=n(),i(v.$$.fragment),ge=n(),F=o("p"),F.innerHTML=Oe,Ze=n(),i(V.$$.fragment),_e=n(),z=o("p"),z.innerHTML=el,ke=n(),E=o("p"),E.innerHTML=ll,Xe=n(),L=o("p"),L.innerHTML=tl,Ge=n(),i(Q.$$.fragment),Be=n(),H=o("p"),H.innerHTML=sl,Ie=n(),i(N.$$.fragment),Re=n(),A=o("p"),A.textContent=nl,We=n(),i(Y.$$.fragment),$e=n(),q=o("p"),q.innerHTML=al,Ce=n(),S=o("p"),S.textContent=ol,xe=n(),i(P.$$.fragment),ve=n(),K=o("p"),K.textContent=pl,Fe=n(),D=o("ul"),D.innerHTML=rl,Ve=n(),ee=o("p"),this.h()},l(e){const l=wl("svelte-u9bgzb",document.head);d=p(l,"META",{name:!0,content:!0}),l.forEach(t),te=a(e),O=p(e,"P",{}),il(O).forEach(t),se=a(e),m(y.$$.fragment,e),ne=a(e),m(T.$$.fragment,e),ae=a(e),b=p(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1ab31dt"&&(b.innerHTML=Le),oe=a(e),h=p(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1pvm1ip"&&(h.textContent=Qe),pe=a(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-r8rbc5"&&(J.innerHTML=He),re=a(e),j=p(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-p7rlbq"&&(j.innerHTML=Ne),ie=a(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1xuz7ym"&&(U.textContent=Ae),me=a(e),m(g.$$.fragment,e),Me=a(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1vn6z9m"&&(Z.textContent=Ye),ce=a(e),m(_.$$.fragment,e),ue=a(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-edbqcr"&&(k.innerHTML=qe),fe=a(e),m(X.$$.fragment,e),de=a(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1567hs3"&&(G.textContent=Se),we=a(e),m(B.$$.fragment,e),ye=a(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1d2xanc"&&(I.innerHTML=Pe),Te=a(e),m(R.$$.fragment,e),be=a(e),m(W.$$.fragment,e),he=a(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1jrv2bf"&&($.innerHTML=Ke),Je=a(e),m(C.$$.fragment,e),je=a(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1xbae7q"&&(x.textContent=De),Ue=a(e),m(v.$$.fragment,e),ge=a(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-k1gawp"&&(F.innerHTML=Oe),Ze=a(e),m(V.$$.fragment,e),_e=a(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1ccko4b"&&(z.innerHTML=el),ke=a(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1eerun3"&&(E.innerHTML=ll),Xe=a(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-nx5jow"&&(L.innerHTML=tl),Ge=a(e),m(Q.$$.fragment,e),Be=a(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-a0s1z1"&&(H.innerHTML=sl),Ie=a(e),m(N.$$.fragment,e),Re=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-15o96gl"&&(A.textContent=nl),We=a(e),m(Y.$$.fragment,e),$e=a(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-ctf36t"&&(q.innerHTML=al),Ce=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1qb1iwp"&&(S.textContent=ol),xe=a(e),m(P.$$.fragment,e),ve=a(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-nhayyz"&&(K.textContent=pl),Fe=a(e),D=p(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-11ijxsh"&&(D.innerHTML=rl),Ve=a(e),ee=p(e,"P",{}),il(ee).forEach(t),this.h()},h(){ml(d,"name","hf:doc:metadata"),ml(d,"content",hl)},m(e,l){yl(document.head,d),s(e,te,l),s(e,O,l),s(e,se,l),M(y,e,l),s(e,ne,l),M(T,e,l),s(e,ae,l),s(e,b,l),s(e,oe,l),s(e,h,l),s(e,pe,l),s(e,J,l),s(e,re,l),s(e,j,l),s(e,ie,l),s(e,U,l),s(e,me,l),M(g,e,l),s(e,Me,l),s(e,Z,l),s(e,ce,l),M(_,e,l),s(e,ue,l),s(e,k,l),s(e,fe,l),M(X,e,l),s(e,de,l),s(e,G,l),s(e,we,l),M(B,e,l),s(e,ye,l),s(e,I,l),s(e,Te,l),M(R,e,l),s(e,be,l),M(W,e,l),s(e,he,l),s(e,$,l),s(e,Je,l),M(C,e,l),s(e,je,l),s(e,x,l),s(e,Ue,l),M(v,e,l),s(e,ge,l),s(e,F,l),s(e,Ze,l),M(V,e,l),s(e,_e,l),s(e,z,l),s(e,ke,l),s(e,E,l),s(e,Xe,l),s(e,L,l),s(e,Ge,l),M(Q,e,l),s(e,Be,l),s(e,H,l),s(e,Ie,l),M(N,e,l),s(e,Re,l),s(e,A,l),s(e,We,l),M(Y,e,l),s(e,$e,l),s(e,q,l),s(e,Ce,l),s(e,S,l),s(e,xe,l),M(P,e,l),s(e,ve,l),s(e,K,l),s(e,Fe,l),s(e,D,l),s(e,Ve,l),s(e,ee,l),ze=!0},p:cl,i(e){ze||(c(y.$$.fragment,e),c(T.$$.fragment,e),c(g.$$.fragment,e),c(_.$$.fragment,e),c(X.$$.fragment,e),c(B.$$.fragment,e),c(R.$$.fragment,e),c(W.$$.fragment,e),c(C.$$.fragment,e),c(v.$$.fragment,e),c(V.$$.fragment,e),c(Q.$$.fragment,e),c(N.$$.fragment,e),c(Y.$$.fragment,e),c(P.$$.fragment,e),ze=!0)},o(e){u(y.$$.fragment,e),u(T.$$.fragment,e),u(g.$$.fragment,e),u(_.$$.fragment,e),u(X.$$.fragment,e),u(B.$$.fragment,e),u(R.$$.fragment,e),u(W.$$.fragment,e),u(C.$$.fragment,e),u(v.$$.fragment,e),u(V.$$.fragment,e),u(Q.$$.fragment,e),u(N.$$.fragment,e),u(Y.$$.fragment,e),u(P.$$.fragment,e),ze=!1},d(e){e&&(t(te),t(O),t(se),t(ne),t(ae),t(b),t(oe),t(h),t(pe),t(J),t(re),t(j),t(ie),t(U),t(me),t(Me),t(Z),t(ce),t(ue),t(k),t(fe),t(de),t(G),t(we),t(ye),t(I),t(Te),t(be),t(he),t($),t(Je),t(je),t(x),t(Ue),t(ge),t(F),t(Ze),t(_e),t(z),t(ke),t(E),t(Xe),t(L),t(Ge),t(Be),t(H),t(Ie),t(Re),t(A),t(We),t($e),t(q),t(Ce),t(S),t(xe),t(ve),t(K),t(Fe),t(D),t(Ve),t(ee)),t(d),f(y,e),f(T,e),f(g,e),f(_,e),f(X,e),f(B,e),f(R,e),f(W,e),f(C,e),f(v,e),f(V,e),f(Q,e),f(N,e),f(Y,e),f(P,e)}}}const hl='{"title":"用于 TensorFlow 模型的 XLA 集成","local":"用于-tensorflow-模型的-xla-集成","sections":[{"title":"使用 XLA 运行 TensorFlow 函数","local":"使用-xla-运行-tensorflow-函数","sections":[],"depth":2},{"title":"在🤗 Transformers库中使用XLA运行TensorFlow文本生成模型","local":"在-transformers库中使用xla运行tensorflow文本生成模型","sections":[],"depth":2},{"title":"需要关注的注意事项","local":"需要关注的注意事项","sections":[],"depth":2},{"title":"附加资源","local":"附加资源","sections":[],"depth":2}],"depth":1}';function Jl(Ee){return ul(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kl extends fl{constructor(d){super(),dl(this,d,Jl,bl,Ml,{})}}export{kl as component};
