import{s as Ut,f as Ct,n as kt,o as xt}from"../chunks/scheduler.85c25b89.js";import{S as Pt,i as Ft,g as i,s as l,r as s,A as Jt,h as r,f as a,c as o,j as ce,u as m,x as p,k as w,y as le,a as n,v as c,d,t as h,w as f}from"../chunks/index.c142fe32.js";import{D as Xt}from"../chunks/Docstring.e6639b56.js";import{C as de}from"../chunks/CodeBlock.a5e95a57.js";import{H as u,E as Nt}from"../chunks/EditOnGithub.a592e7aa.js";function jt(lt){let v,he,me,fe,y,ue,T,ge,M,ot='Exploratory Preference Optimization (XPO) was proposed in the paper <a href="https://huggingface.co/papers/2405.21046" rel="nofollow">Exploratory Preference Optimization: Harnessing Implicit Q*-Approximation for Sample-Efficient RLHF</a> by Tengyang Xie, Dylan J. Foster, Akshay Krishnamurthy, <a href="https://huggingface.co/corbyrosset" rel="nofollow">Corby Rosset</a>, <a href="https://huggingface.co/AhmedAwadallah" rel="nofollow">Ahmed Awadallah</a>, and Alexander Rakhlin. It is a simple online preference tuning method based on the DPO loss together with a reward model (RM). XPO augments the DPO objective with an exploration bonus allowing the method to explore outside the support of the intitial model and human feedback data.',_e,$,it="The abstract from the paper is the following:",ve,O,rt="<p>Reinforcement learning from human feedback (RLHF) has emerged as a central tool for language model alignment. We consider online exploration in RLHF, which exploits interactive access to human or AI feedback by deliberately encouraging the model to produce diverse, maximally informative responses. By allowing RLHF to confidently stray from the pre-trained model, online exploration offers the possibility of novel, potentially super-human capabilities, but its full potential as a paradigm for language model training has yet to be realized, owing to computational and statistical bottlenecks in directly adapting existing reinforcement learning techniques. We propose a new algorithm for online exploration in RLHF, Exploratory Preference Optimization (XPO), which is simple and practical — a one-line change to (online) Direct Preference Optimization (DPO; Rafailov et al., 2023) — yet enjoys the strongest known provable guarantees and promising empirical performance. XPO augments the DPO objective with a novel and principled exploration bonus, empowering the algorithm to explore outside the support of the initial model and human feedback data. In theory, we show that XPO is provably sample-efficient and converges to a near-optimal language model policy under natural exploration conditions, irrespective of whether the initial model has good coverage. Our analysis, which builds on the observation that DPO implicitly performs a form of Q*-approximation (or, Bellman error minimization), combines previously disparate techniques from language modeling and theoretical reinforcement learning in a serendipitous fashion through the perspective of KL-regularized Markov decision processes. Empirically, we find that XPO is more sample-efficient than non-exploratory DPO variants in a preliminary evaluation.</p>",be,X,st='This post-training method was contributed by <a href="https://huggingface.co/kashif" rel="nofollow">Kashif Rasul</a>,  <a href="https://huggingface.co/qgallouedec" rel="nofollow">Quentin Gallouédec</a> and <a href="https://huggingface.co/lewtun" rel="nofollow">Lewis Tunstall</a>.',we,U,ye,C,mt='This example demonstrates how to train a model using the XPO method. We use the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen 0.5B model</a> as the base model and the <a href="https://huggingface.co/trl-lib/Qwen2-0.5B-Reward" rel="nofollow">Qwen 0.5B reward model</a> as the reward model. We use the prompts from the <a href="https://huggingface.co/datasets/openbmb/UltraFeedback" rel="nofollow">UltraFeedback dataset</a>. You can view the prompts in the dataset here:',Te,_,pt,Me,k,ct="Below is the script to train the model:",$e,x,Oe,P,dt="Execute the script using the following command:",Xe,F,Ue,J,Ce,N,ht='XPO requires a <a href="dataset_format#preference">prompt-only dataset</a>. The <a href="/docs/trl/v0.11.4/en/xpo_trainer#trl.XPOTrainer">XPOTrainer</a> supports both <a href="dataset_format#conversational-dataset-format">conversational</a> and <a href="dataset_format#standard-dataset-format">standard</a> dataset format. When provided with a conversational dataset, the trainer will automatically apply the chat template to the dataset.',ke,j,xe,L,Pe,R,ft="Make sure that the SFT model and reward model use the <em>same</em> chat template. Otherwise, you may find the model completions are scored incorrectly during training.",Fe,W,Je,I,ut='We can want the model to generate completion within a given length. During the learning, the model will generate completion up to the maximum completion length specified in the <code>max_new_tokens</code> argument of <a href="/docs/trl/v0.11.4/en/xpo_trainer#trl.XPOConfig">XPOConfig</a>. I you want to penalize for not generating an EOS token before the maximum completion length, you can use the <code>missing_eos_penalty</code> argument of <a href="/docs/trl/v0.11.4/en/xpo_trainer#trl.XPOConfig">XPOConfig</a>:',Ne,Z,je,Q,Le,z,gt='To better understand your model’s behavior during training, you can log sample completions periodically using the <a href="/docs/trl/v0.11.4/en/callbacks#trl.LogCompletionsCallback">LogCompletionsCallback</a>.',Re,H,We,E,_t="This callback logs the model’s generated completions directly to Weights & Biases.",Ie,V,vt='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/wandb_completions.png" alt="Logged Completions"/>',Ze,A,Qe,B,bt='We provide an example script to train a model using the XPO method. The script is available in <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/nash_md.py" rel="nofollow"><code>examples/scripts/nash_md.py</code></a>',ze,G,wt='To test the XPO script with the <a href="https://huggingface.co/EleutherAI/pythia-14m" rel="nofollow">Pythia 14M model</a> on the TL;DR summarization task, run the following command:',He,D,Ee,Y,Ve,q,yt="The logged metrics are as follows:",Ae,S,Tt='<li><code>loss/xpo</code>: The mean xpo part of the full loss.</li> <li><code>loss/dpo</code>: The mean dpo part of the full loss.</li> <li><code>objective/kl</code>: The mean KL divergence between the model and reference data.</li> <li><code>objective/entropy</code>: The mean entropy of the model and reference data.</li> <li><code>objective/model_scores</code>: The mean scores (according to the reward model) of the model completions.</li> <li><code>objective/ref_scores</code>: The mean scores (according to the reward model) of the reference completions.</li> <li><code>objective/scores_margin</code>: The mean score margin (according to the external reward model) between the chosen and rejected completions.</li> <li><code>rewards/chosen</code>: The mean reward (according to XPO’s DPO implicit reward model) of the chosen completions.</li> <li><code>rewards/rejected</code>: The mean reward (according to XPO’s DPO implicit reward model) of the rejected completions.</li> <li><code>rewards/accuracies</code>: The accuracies of the XPO’s implicit reward model.</li> <li><code>rewards/margins</code>: The mean reward margin (according to online DPO’s implicit reward model) between the chosen and rejected completions.</li> <li><code>logps/chosen</code>: The mean log probabilities of the chosen completions.</li> <li><code>logps/rejected</code>: The mean log probabilities of the rejected completions.</li> <li><code>val/model_contain_eos_token</code>: The amount of times the model’s output contains the eos token.</li> <li><code>val/ref_contain_eos_token</code>: The amount of times the reference’s output contains the eos token.</li> <li><code>alpha</code>: The weight of the XPO loss term. Typically fixed, but can be made dynamic by passing a list to <a href="/docs/trl/v0.11.4/en/xpo_trainer#trl.XPOConfig">XPOConfig</a>.</li> <li><code>beta</code>: The parameter that controls the weight of the loss term representing the deviation from the reference model. Typically fixed, but can be made dynamic by passing a list to <a href="/docs/trl/v0.11.4/en/xpo_trainer#trl.XPOConfig">XPOConfig</a>.</li>',Be,K,Ge,b,ee,tt,oe,Mt='Initialize XPOTrainer as a subclass of <a href="/docs/trl/v0.11.4/en/online_dpo_trainer#trl.OnlineDPOConfig">OnlineDPOConfig</a>.',De,te,Ye,g,ae,at,ie,$t='Configuration class for the <a href="/docs/trl/v0.11.4/en/xpo_trainer#trl.XPOTrainer">XPOTrainer</a>.',nt,re,Ot='Subclass of <a href="/docs/trl/v0.11.4/en/online_dpo_trainer#trl.OnlineDPOConfig">OnlineDPOConfig</a> we can use all its arguments and add the following:',qe,ne,Se,pe,Ke;return y=new u({props:{title:"XPO Trainer",local:"xpo-trainer",headingTag:"h1"}}),T=new u({props:{title:"Overview",local:"overview",headingTag:"h2"}}),U=new u({props:{title:"Quick start",local:"quick-start",headingTag:"h2"}}),x=new de({props:{code:"JTIzJTIwdHJhaW5feHBvLnB5JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFhQT0NvbmZpZyUyQyUyMFhQT1RyYWluZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQXJld2FyZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnRybC1saWIlMkZRd2VuMi0wLjVCLVJld2FyZCUyMiUyQyUyMG51bV9sYWJlbHMlM0QxKSUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydHJsLWxpYiUyRnVsdHJhZmVlZGJhY2stcHJvbXB0JTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEFhcmdzJTIwJTNEJTIwWFBPQ29uZmlnKG91dHB1dF9kaXIlM0QlMjJuYXNoLW1kLXF3ZW4yJTIyJTJDJTIwbG9nZ2luZ19zdGVwcyUzRDEwKSUwQXRyYWluZXIlMjAlM0QlMjBYUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjByZXdhcmRfbW9kZWwlM0RyZXdhcmRfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-comment"># train_xpo.py</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> XPOConfig, XPOTrainer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoModelForSequenceClassification, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
reward_model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;trl-lib/Qwen2-0.5B-Reward&quot;</span>, num_labels=<span class="hljs-number">1</span>)
train_dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback-prompt&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

args = XPOConfig(output_dir=<span class="hljs-string">&quot;nash-md-qwen2&quot;</span>, logging_steps=<span class="hljs-number">10</span>)
trainer = XPOTrainer(
    model=model,
    reward_model=reward_model,
    args=args,
    tokenizer=tokenizer,
    train_dataset=train_dataset,
)
trainer.train()`,wrap:!1}}),F=new de({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX3hwby5weQ==",highlighted:"accelerate launch train_xpo.py",wrap:!1}}),J=new u({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),j=new u({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),L=new u({props:{title:"⚠️ Use the same chat template",local:"-use-the-same-chat-template",headingTag:"h3"}}),W=new u({props:{title:"Encourage EOS token generation",local:"encourage-eos-token-generation",headingTag:"h3"}}),Z=new de({props:{code:"YXJncyUyMCUzRCUyMFhQT0NvbmZpZyguLi4lMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCUyQyUyMG1pc3NpbmdfZW9zX3BlbmFsdHklM0QxLjAp",highlighted:'args = XPOConfig(..., max_new_tokens=<span class="hljs-number">128</span>, missing_eos_penalty=<span class="hljs-number">1.0</span>)',wrap:!1}}),Q=new u({props:{title:"Logging Completions",local:"logging-completions",headingTag:"h3"}}),H=new de({props:{code:"dHJhaW5lciUyMCUzRCUyMFhQT1RyYWluZXIoLi4uJTJDJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0KSUwQWNvbXBsZXRpb25zX2NhbGxiYWNrJTIwJTNEJTIwTG9nQ29tcGxldGlvbnNDYWxsYmFjayh0cmFpbmVyJTJDJTIwbnVtX3Byb21wdHMlM0Q4KSUwQXRyYWluZXIuYWRkX2NhbGxiYWNrKGNvbXBsZXRpb25zX2NhbGxiYWNrKQ==",highlighted:`trainer = XPOTrainer(..., eval_dataset=eval_dataset)
completions_callback = LogCompletionsCallback(trainer, num_prompts=<span class="hljs-number">8</span>)
trainer.add_callback(completions_callback)`,wrap:!1}}),A=new u({props:{title:"Example script",local:"example-script",headingTag:"h2"}}),D=new de({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGeHBvLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBFbGV1dGhlckFJJTJGcHl0aGlhLTE0bSUyMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmV3YXJkX21vZGVsX3BhdGglMjBFbGV1dGhlckFJJTJGcHl0aGlhLTE0bSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTIwdHJsLWxpYiUyRnRsZHIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWxlYXJuaW5nX3JhdGUlMjA1LjBlLTclMjAlNUMlMEElMjAlMjAlMjAlMjAtLW91dHB1dF9kaXIlMjBweXRoaWEtMTRtLXRsZHIteHBvJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjA0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAzMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9uZXdfdG9rZW5zJTIwNjQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXdhcm11cF9yYXRpbyUyMDAuMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWlzc2luZ19lb3NfcGVuYWx0eSUyMDEuMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcHVzaF90b19odWI=",highlighted:`python examples/scripts/xpo.py \\
    --model_name_or_path EleutherAI/pythia-14m  \\
    --reward_model_path EleutherAI/pythia-14m \\
    --dataset_name trl-lib/tldr \\
    --learning_rate 5.0e-7 \\
    --output_dir pythia-14m-tldr-xpo \\
    --per_device_train_batch_size 4 \\
    --gradient_accumulation_steps 32 \\
    --num_train_epochs 3 \\
    --max_new_tokens 64 \\
    --warmup_ratio 0.1 \\
    --missing_eos_penalty 1.0 \\
    --push_to_hub`,wrap:!1}}),Y=new u({props:{title:"Logged metrics",local:"logged-metrics",headingTag:"h2"}}),K=new u({props:{title:"XPOTrainer",local:"trl.XPOTrainer",headingTag:"h2"}}),ee=new Xt({props:{name:"class trl.XPOTrainer",anchor:"trl.XPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"reward_model",val:": Optional = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Union = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.XPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForCausalLM</code>.`,name:"model"},{anchor:"trl.XPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.XPOTrainer.reward_model",description:`<strong>reward_model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The reward model to score completions with, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"reward_model"},{anchor:"trl.XPOTrainer.judge",description:`<strong>judge</strong> (<code>BasePairwiseJudge</code>) &#x2014;
The judge to use for pairwise comparison of model completions.`,name:"judge"},{anchor:"trl.XPOTrainer.args",description:`<strong>args</strong> (<code>XPOConfig</code>) &#x2014;
The XPO config arguments to use for training.`,name:"args"},{anchor:"trl.XPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.XPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.XPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.XPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.XPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>) &#x2014;
The peft config to use for training.`,name:"peft_config"},{anchor:"trl.XPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.XPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.XPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.XPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"}],source:"https://github.com/huggingface/trl/blob/v0.11.4/trl/trainer/xpo_trainer.py#L36"}}),te=new u({props:{title:"XPOConfig",local:"trl.XPOConfig",headingTag:"h2"}}),ae=new Xt({props:{name:"class trl.XPOConfig",anchor:"trl.XPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-07"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": List = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"reward_model_path",val:": Optional = None"},{name:"max_new_tokens",val:": int = 64"},{name:"temperature",val:": float = 0.9"},{name:"missing_eos_penalty",val:": Optional = None"},{name:"beta",val:": List = <factory>"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"dataset_num_proc",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"alpha",val:": List = <factory>"}],parametersDescription:[{anchor:"trl.XPOConfig.alpha",description:`<strong>alpha</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>1e-5</code>) &#x2014;
Weight of the XPO loss term. If a list of floats is provided then the alpha is selected for each new epoch and the last alpha is used for the rest of the epochs.`,name:"alpha"}],source:"https://github.com/huggingface/trl/blob/v0.11.4/trl/trainer/xpo_config.py#L21"}}),ne=new Nt({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/xpo_trainer.mdx"}}),{c(){v=i("meta"),he=l(),me=i("p"),fe=l(),s(y.$$.fragment),ue=l(),s(T.$$.fragment),ge=l(),M=i("p"),M.innerHTML=ot,_e=l(),$=i("p"),$.textContent=it,ve=l(),O=i("blockquote"),O.innerHTML=rt,be=l(),X=i("p"),X.innerHTML=st,we=l(),s(U.$$.fragment),ye=l(),C=i("p"),C.innerHTML=mt,Te=l(),_=i("iframe"),Me=l(),k=i("p"),k.textContent=ct,$e=l(),s(x.$$.fragment),Oe=l(),P=i("p"),P.textContent=dt,Xe=l(),s(F.$$.fragment),Ue=l(),s(J.$$.fragment),Ce=l(),N=i("p"),N.innerHTML=ht,ke=l(),s(j.$$.fragment),xe=l(),s(L.$$.fragment),Pe=l(),R=i("p"),R.innerHTML=ft,Fe=l(),s(W.$$.fragment),Je=l(),I=i("p"),I.innerHTML=ut,Ne=l(),s(Z.$$.fragment),je=l(),s(Q.$$.fragment),Le=l(),z=i("p"),z.innerHTML=gt,Re=l(),s(H.$$.fragment),We=l(),E=i("p"),E.textContent=_t,Ie=l(),V=i("p"),V.innerHTML=vt,Ze=l(),s(A.$$.fragment),Qe=l(),B=i("p"),B.innerHTML=bt,ze=l(),G=i("p"),G.innerHTML=wt,He=l(),s(D.$$.fragment),Ee=l(),s(Y.$$.fragment),Ve=l(),q=i("p"),q.textContent=yt,Ae=l(),S=i("ul"),S.innerHTML=Tt,Be=l(),s(K.$$.fragment),Ge=l(),b=i("div"),s(ee.$$.fragment),tt=l(),oe=i("p"),oe.innerHTML=Mt,De=l(),s(te.$$.fragment),Ye=l(),g=i("div"),s(ae.$$.fragment),at=l(),ie=i("p"),ie.innerHTML=$t,nt=l(),re=i("p"),re.innerHTML=Ot,qe=l(),s(ne.$$.fragment),Se=l(),pe=i("p"),this.h()},l(e){const t=Jt("svelte-u9bgzb",document.head);v=r(t,"META",{name:!0,content:!0}),t.forEach(a),he=o(e),me=r(e,"P",{}),ce(me).forEach(a),fe=o(e),m(y.$$.fragment,e),ue=o(e),m(T.$$.fragment,e),ge=o(e),M=r(e,"P",{"data-svelte-h":!0}),p(M)!=="svelte-1ctfp61"&&(M.innerHTML=ot),_e=o(e),$=r(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-vfdo9a"&&($.textContent=it),ve=o(e),O=r(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(O)!=="svelte-18iyjd5"&&(O.innerHTML=rt),be=o(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-88h8d3"&&(X.innerHTML=st),we=o(e),m(U.$$.fragment,e),ye=o(e),C=r(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-d3uuyp"&&(C.innerHTML=mt),Te=o(e),_=r(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),ce(_).forEach(a),Me=o(e),k=r(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-uqytq6"&&(k.textContent=ct),$e=o(e),m(x.$$.fragment,e),Oe=o(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-15hino8"&&(P.textContent=dt),Xe=o(e),m(F.$$.fragment,e),Ue=o(e),m(J.$$.fragment,e),Ce=o(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1ez7dwq"&&(N.innerHTML=ht),ke=o(e),m(j.$$.fragment,e),xe=o(e),m(L.$$.fragment,e),Pe=o(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1kgiyxw"&&(R.innerHTML=ft),Fe=o(e),m(W.$$.fragment,e),Je=o(e),I=r(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1sl754k"&&(I.innerHTML=ut),Ne=o(e),m(Z.$$.fragment,e),je=o(e),m(Q.$$.fragment,e),Le=o(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-6qkmdp"&&(z.innerHTML=gt),Re=o(e),m(H.$$.fragment,e),We=o(e),E=r(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1hvqa3l"&&(E.textContent=_t),Ie=o(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-azj40q"&&(V.innerHTML=vt),Ze=o(e),m(A.$$.fragment,e),Qe=o(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-zqxkkv"&&(B.innerHTML=bt),ze=o(e),G=r(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-t09m5o"&&(G.innerHTML=wt),He=o(e),m(D.$$.fragment,e),Ee=o(e),m(Y.$$.fragment,e),Ve=o(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1rzdw7s"&&(q.textContent=yt),Ae=o(e),S=r(e,"UL",{"data-svelte-h":!0}),p(S)!=="svelte-11oypsi"&&(S.innerHTML=Tt),Be=o(e),m(K.$$.fragment,e),Ge=o(e),b=r(e,"DIV",{class:!0});var et=ce(b);m(ee.$$.fragment,et),tt=o(et),oe=r(et,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1khwiqe"&&(oe.innerHTML=Mt),et.forEach(a),De=o(e),m(te.$$.fragment,e),Ye=o(e),g=r(e,"DIV",{class:!0});var se=ce(g);m(ae.$$.fragment,se),at=o(se),ie=r(se,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1kt7zko"&&(ie.innerHTML=$t),nt=o(se),re=r(se,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1ycinxj"&&(re.innerHTML=Ot),se.forEach(a),qe=o(e),m(ne.$$.fragment,e),Se=o(e),pe=r(e,"P",{}),ce(pe).forEach(a),this.h()},h(){w(v,"name","hf:doc:metadata"),w(v,"content",Lt),Ct(_.src,pt="https://huggingface.co/datasets/trl-lib/ultrafeedback-prompt/embed/viewer/default/train?row=0")||w(_,"src",pt),w(_,"frameborder","0"),w(_,"width","100%"),w(_,"height","560px"),w(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){le(document.head,v),n(e,he,t),n(e,me,t),n(e,fe,t),c(y,e,t),n(e,ue,t),c(T,e,t),n(e,ge,t),n(e,M,t),n(e,_e,t),n(e,$,t),n(e,ve,t),n(e,O,t),n(e,be,t),n(e,X,t),n(e,we,t),c(U,e,t),n(e,ye,t),n(e,C,t),n(e,Te,t),n(e,_,t),n(e,Me,t),n(e,k,t),n(e,$e,t),c(x,e,t),n(e,Oe,t),n(e,P,t),n(e,Xe,t),c(F,e,t),n(e,Ue,t),c(J,e,t),n(e,Ce,t),n(e,N,t),n(e,ke,t),c(j,e,t),n(e,xe,t),c(L,e,t),n(e,Pe,t),n(e,R,t),n(e,Fe,t),c(W,e,t),n(e,Je,t),n(e,I,t),n(e,Ne,t),c(Z,e,t),n(e,je,t),c(Q,e,t),n(e,Le,t),n(e,z,t),n(e,Re,t),c(H,e,t),n(e,We,t),n(e,E,t),n(e,Ie,t),n(e,V,t),n(e,Ze,t),c(A,e,t),n(e,Qe,t),n(e,B,t),n(e,ze,t),n(e,G,t),n(e,He,t),c(D,e,t),n(e,Ee,t),c(Y,e,t),n(e,Ve,t),n(e,q,t),n(e,Ae,t),n(e,S,t),n(e,Be,t),c(K,e,t),n(e,Ge,t),n(e,b,t),c(ee,b,null),le(b,tt),le(b,oe),n(e,De,t),c(te,e,t),n(e,Ye,t),n(e,g,t),c(ae,g,null),le(g,at),le(g,ie),le(g,nt),le(g,re),n(e,qe,t),c(ne,e,t),n(e,Se,t),n(e,pe,t),Ke=!0},p:kt,i(e){Ke||(d(y.$$.fragment,e),d(T.$$.fragment,e),d(U.$$.fragment,e),d(x.$$.fragment,e),d(F.$$.fragment,e),d(J.$$.fragment,e),d(j.$$.fragment,e),d(L.$$.fragment,e),d(W.$$.fragment,e),d(Z.$$.fragment,e),d(Q.$$.fragment,e),d(H.$$.fragment,e),d(A.$$.fragment,e),d(D.$$.fragment,e),d(Y.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),Ke=!0)},o(e){h(y.$$.fragment,e),h(T.$$.fragment,e),h(U.$$.fragment,e),h(x.$$.fragment,e),h(F.$$.fragment,e),h(J.$$.fragment,e),h(j.$$.fragment,e),h(L.$$.fragment,e),h(W.$$.fragment,e),h(Z.$$.fragment,e),h(Q.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(D.$$.fragment,e),h(Y.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),Ke=!1},d(e){e&&(a(he),a(me),a(fe),a(ue),a(ge),a(M),a(_e),a($),a(ve),a(O),a(be),a(X),a(we),a(ye),a(C),a(Te),a(_),a(Me),a(k),a($e),a(Oe),a(P),a(Xe),a(Ue),a(Ce),a(N),a(ke),a(xe),a(Pe),a(R),a(Fe),a(Je),a(I),a(Ne),a(je),a(Le),a(z),a(Re),a(We),a(E),a(Ie),a(V),a(Ze),a(Qe),a(B),a(ze),a(G),a(He),a(Ee),a(Ve),a(q),a(Ae),a(S),a(Be),a(Ge),a(b),a(De),a(Ye),a(g),a(qe),a(Se),a(pe)),a(v),f(y,e),f(T,e),f(U,e),f(x,e),f(F,e),f(J,e),f(j,e),f(L,e),f(W,e),f(Z,e),f(Q,e),f(H,e),f(A,e),f(D,e),f(Y,e),f(K,e),f(ee),f(te,e),f(ae),f(ne,e)}}}const Lt='{"title":"XPO Trainer","local":"xpo-trainer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Quick start","local":"quick-start","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"⚠️ Use the same chat template","local":"-use-the-same-chat-template","sections":[],"depth":3},{"title":"Encourage EOS token generation","local":"encourage-eos-token-generation","sections":[],"depth":3},{"title":"Logging Completions","local":"logging-completions","sections":[],"depth":3}],"depth":2},{"title":"Example script","local":"example-script","sections":[],"depth":2},{"title":"Logged metrics","local":"logged-metrics","sections":[],"depth":2},{"title":"XPOTrainer","local":"trl.XPOTrainer","sections":[],"depth":2},{"title":"XPOConfig","local":"trl.XPOConfig","sections":[],"depth":2}],"depth":1}';function Rt(lt){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends Pt{constructor(v){super(),Ft(this,v,Rt,jt,Ut,{})}}export{Ht as component};
