import{s as st,o as tt,n as lt}from"../chunks/scheduler.ca8a8f1f.js";import{S as et,i as at,g as M,s as a,r as o,A as nt,h as p,f as t,c as n,j as Ps,u as i,x as j,k as Ks,y as Mt,a as e,v as J,d as r,t as y,w as T}from"../chunks/index.ace09054.js";import{T as Os}from"../chunks/Tip.16e0d3ad.js";import{C as u}from"../chunks/CodeBlock.da34cb7d.js";import{H as hl}from"../chunks/Heading.bda300ec.js";function pt(ml){let c,U='💡 Read <a href="https://arxiv.org/abs/2106.09685" rel="nofollow">LoRA: Low-Rank Adaptation of Large Language Models</a> to learn more about LoRA.';return{c(){c=M("p"),c.innerHTML=U},l(w){c=p(w,"P",{"data-svelte-h":!0}),j(c)!=="svelte-kt6e6m"&&(c.innerHTML=U)},m(w,I){e(w,c,I)},p:lt,d(w){w&&t(c)}}}function ot(ml){let c,U="💡 The weight matrix is scaled by <code>lora_alpha/r</code>, and a higher <code>lora_alpha</code> value assigns more weight to the LoRA activations. For performance, we recommend setting <code>bias</code> to <code>None</code> first, and then <code>lora_only</code>, before trying <code>all</code>.";return{c(){c=M("p"),c.innerHTML=U},l(w){c=p(w,"P",{"data-svelte-h":!0}),j(c)!=="svelte-wrjzuj"&&(c.innerHTML=U)},m(w,I){e(w,c,I)},p:lt,d(w){w&&t(c)}}}function it(ml){let c,U,w,I,d,bl,b,fs="Low-Rank Adaptation (LoRA) is a reparametrization method that aims to reduce the number of trainable parameters with low-rank representations. The weight matrix is broken down into low-rank matrices that are trained and updated. All the pretrained model parameters remain frozen. After training, the low-rank matrices are added back to the original weights. This makes it more efficient to store and train a LoRA model because there are significantly fewer parameters.",fl,h,Cl,f,Cs='This guide will show you how to train a <a href="https://huggingface.co/roberta-large" rel="nofollow"><code>roberta-large</code></a> model with LoRA on the <a href="https://huggingface.co/datasets/tner/bionlp2004" rel="nofollow">BioNLP2004</a> dataset for token classification.',gl,C,gs="Before you begin, make sure you have all the necessary libraries installed:",kl,g,Al,k,Bl,A,ks="Let’s start by importing all the necessary libraries you’ll need:",ql,B,As="<li>🤗 Transformers for loading the base <code>roberta-large</code> model and tokenizer, and handling the training loop</li> <li>🤗 Datasets for loading and preparing the <code>bionlp2004</code> dataset for training</li> <li>🤗 Evaluate for evaluating the model’s performance</li> <li>🤗 PEFT for setting up the LoRA configuration and creating the PEFT model</li>",Zl,q,Wl,Z,$l,W,Bs='The <a href="https://huggingface.co/datasets/tner/bionlp2004" rel="nofollow">BioNLP2004</a> dataset includes tokens and tags for biological structures like DNA, RNA and proteins. Load the dataset:',Ql,$,_l,Q,qs='The <code>tags</code> values are defined in the label ids <a href="https://huggingface.co/datasets/tner/bionlp2004#label-id" rel="nofollow">dictionary</a>. The letter that prefixes each label indicates the token position: <code>B</code> is for the first token of an entity, <code>I</code> is for a token inside the entity, and <code>0</code> is for a token that is not part of an entity.',El,_,Rl,E,Zs='Then load the <a href="https://huggingface.co/spaces/evaluate-metric/seqeval" rel="nofollow"><code>seqeval</code></a> framework which includes several metrics - precision, accuracy, F1, and recall - for evaluating sequence labeling tasks.',vl,R,Vl,v,Ws="Now you can write an evaluation function to compute the metrics from the model predictions and labels, and return the precision, recall, F1, and accuracy scores:",Nl,V,Gl,N,Xl,G,$s="Initialize a tokenizer and make sure you set <code>is_split_into_words=True</code> because the text sequence has already been split into words. However, this doesn’t mean it is tokenized yet (even though it may look like it!), and you’ll need to further tokenize the words into subwords.",Sl,X,zl,S,Qs="You’ll also need to write a function to:",Yl,z,_s='<li>Map each token to their respective word with the <a href="https://huggingface.co/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.BatchEncoding.word_ids" rel="nofollow">word_ids</a> method.</li> <li>Ignore the special tokens by setting them to <code>-100</code>.</li> <li>Label the first token of a given entity.</li>',Fl,Y,xl,F,Es='Use <a href="https://huggingface.co/docs/datasets/v2.15.0/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> to apply the <code>tokenize_and_align_labels</code> function to the dataset:',Hl,x,Dl,H,Rs="Finally, create a data collator to pad the examples to the longest length in a batch:",Ll,D,Pl,L,Kl,P,vs='Now you’re ready to create a <a href="/docs/peft/v0.7.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>. Start by loading the base <code>roberta-large</code> model, the number of expected labels, and the <code>id2label</code> and <code>label2id</code> dictionaries:',Ol,K,ls,O,Vs='Define the <a href="/docs/peft/v0.7.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with:',ss,ll,Ns="<li><code>task_type</code>, token classification (<code>TaskType.TOKEN_CLS</code>)</li> <li><code>r</code>, the dimension of the low-rank matrices</li> <li><code>lora_alpha</code>, scaling factor for the weight matrices</li> <li><code>lora_dropout</code>, dropout probability of the LoRA layers</li> <li><code>bias</code>, set to <code>all</code> to train all bias parameters</li>",ts,m,es,sl,as,tl,Gs='Pass the base model and <code>peft_config</code> to the <code>get_peft_model()</code> function to create a <a href="/docs/peft/v0.7.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>. You can check out how much more efficient training the <a href="/docs/peft/v0.7.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> is compared to fully training the base model by printing out the trainable parameters:',ns,el,Ms,al,Xs='From the 🤗 Transformers library, create a <a href="https://huggingface.co/docs/transformers/v4.35.2/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> class and specify where you want to save the model to, the training hyperparameters, how to evaluate the model, and when to save the checkpoints:',ps,nl,os,Ml,Ss='Pass the model, <code>TrainingArguments</code>, datasets, tokenizer, data collator and evaluation function to the <a href="https://huggingface.co/docs/transformers/v4.35.2/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class. The <code>Trainer</code> handles the training loop for you, and when you’re ready, call <a href="https://huggingface.co/docs/transformers/v4.35.2/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a> to begin!',is,pl,Js,ol,rs,il,zs="Once training is complete, you can store and share your model on the Hub if you’d like. Log in to your Hugging Face account and enter your token when prompted:",ys,Jl,Ts,rl,Ys='Upload the model to a specific model repository on the Hub with the <a href="https://huggingface.co/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method:',js,yl,cs,Tl,us,jl,Fs="To use your model for inference, load the configuration and model:",ws,cl,Us,ul,xs="Get some text to tokenize:",Is,wl,hs,Ul,Hs="Pass the inputs to the model, and print out the model prediction for each token:",ms,Il,ds,dl,bs;return d=new hl({props:{title:"LoRA for token classification",local:"lora-for-token-classification",headingTag:"h1"}}),h=new Os({props:{$$slots:{default:[pt]},$$scope:{ctx:ml}}}),g=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHBlZnQlMjB0cmFuc2Zvcm1lcnMlMjBkYXRhc2V0cyUyMGV2YWx1YXRlJTIwc2VxZXZhbA==",highlighted:"!pip install -q peft transformers datasets evaluate seqeval",wrap:!1}}),k=new hl({props:{title:"Setup",local:"setup",headingTag:"h2"}}),q=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwQXV0b1Rva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMERhdGFDb2xsYXRvckZvclRva2VuQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUwQSUyMCUyMCUyMCUyMFRyYWluZXIlMkMlMEEpJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9jb25maWclMkMlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTJDJTIwVGFza1R5cGUlMEFpbXBvcnQlMjBldmFsdWF0ZSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfY2hlY2twb2ludCUyMCUzRCUyMCUyMnJvYmVydGEtbGFyZ2UlMjIlMEFsciUyMCUzRCUyMDFlLTMlMEFiYXRjaF9zaXplJTIwJTNEJTIwMTYlMEFudW1fZXBvY2hzJTIwJTNEJTIwMTA=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoModelForTokenClassification,
    AutoTokenizer,
    DataCollatorForTokenClassification,
    TrainingArguments,
    Trainer,
)
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_config, PeftModel, PeftConfig, get_peft_model, LoraConfig, TaskType
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_checkpoint = <span class="hljs-string">&quot;roberta-large&quot;</span>
lr = <span class="hljs-number">1e-3</span>
batch_size = <span class="hljs-number">16</span>
num_epochs = <span class="hljs-number">10</span>`,wrap:!1}}),Z=new hl({props:{title:"Load dataset and metric",local:"load-dataset-and-metric",headingTag:"h2"}}),$=new u({props:{code:"YmlvbmxwJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnRuZXIlMkZiaW9ubHAyMDA0JTIyKSUwQWJpb25scCU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RCUwQSU3QiUwQSUyMCUyMCUyMCUyMCUyMnRva2VucyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNpbmNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySFVWRUNzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVsZWFzZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdXBlcm94aWRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYW5pb25zJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXNwb25zZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyVE5GJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTJDJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYW5kJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySDJPMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluZHVjZXMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJWQ0FNLTElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMkMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQRFRDJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWF5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmFkaWNhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNjYXZlbmdlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi4lMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ0YWdzJTIyJTNBJTIwJTVCMCUyQyUyMDclMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDMlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlNUQlMkMlMEElN0Q=",highlighted:`bionlp = load_dataset(<span class="hljs-string">&quot;tner/bionlp2004&quot;</span>)
bionlp[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{
    <span class="hljs-string">&quot;tokens&quot;</span>: [
        <span class="hljs-string">&quot;Since&quot;</span>,
        <span class="hljs-string">&quot;HUVECs&quot;</span>,
        <span class="hljs-string">&quot;released&quot;</span>,
        <span class="hljs-string">&quot;superoxide&quot;</span>,
        <span class="hljs-string">&quot;anions&quot;</span>,
        <span class="hljs-string">&quot;in&quot;</span>,
        <span class="hljs-string">&quot;response&quot;</span>,
        <span class="hljs-string">&quot;to&quot;</span>,
        <span class="hljs-string">&quot;TNF&quot;</span>,
        <span class="hljs-string">&quot;,&quot;</span>,
        <span class="hljs-string">&quot;and&quot;</span>,
        <span class="hljs-string">&quot;H2O2&quot;</span>,
        <span class="hljs-string">&quot;induces&quot;</span>,
        <span class="hljs-string">&quot;VCAM-1&quot;</span>,
        <span class="hljs-string">&quot;,&quot;</span>,
        <span class="hljs-string">&quot;PDTC&quot;</span>,
        <span class="hljs-string">&quot;may&quot;</span>,
        <span class="hljs-string">&quot;act&quot;</span>,
        <span class="hljs-string">&quot;as&quot;</span>,
        <span class="hljs-string">&quot;a&quot;</span>,
        <span class="hljs-string">&quot;radical&quot;</span>,
        <span class="hljs-string">&quot;scavenger&quot;</span>,
        <span class="hljs-string">&quot;.&quot;</span>,
    ],
    <span class="hljs-string">&quot;tags&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">7</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
}`,wrap:!1}}),_=new u({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyTyUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJCLUROQSUyMiUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAlMjJJLUROQSUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJCLXByb3RlaW4lMjIlM0ElMjAzJTJDJTBBJTIwJTIwJTIwJTIwJTIySS1wcm90ZWluJTIyJTNBJTIwNCUyQyUwQSUyMCUyMCUyMCUyMCUyMkItY2VsbF90eXBlJTIyJTNBJTIwNSUyQyUwQSUyMCUyMCUyMCUyMCUyMkktY2VsbF90eXBlJTIyJTNBJTIwNiUyQyUwQSUyMCUyMCUyMCUyMCUyMkItY2VsbF9saW5lJTIyJTNBJTIwNyUyQyUwQSUyMCUyMCUyMCUyMCUyMkktY2VsbF9saW5lJTIyJTNBJTIwOCUyQyUwQSUyMCUyMCUyMCUyMCUyMkItUk5BJTIyJTNBJTIwOSUyQyUwQSUyMCUyMCUyMCUyMCUyMkktUk5BJTIyJTNBJTIwMTAlMkMlMEElN0Q=",highlighted:`{
    <span class="hljs-string">&quot;O&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;B-DNA&quot;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;I-DNA&quot;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&quot;B-protein&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;I-protein&quot;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&quot;B-cell_type&quot;</span>: <span class="hljs-number">5</span>,
    <span class="hljs-string">&quot;I-cell_type&quot;</span>: <span class="hljs-number">6</span>,
    <span class="hljs-string">&quot;B-cell_line&quot;</span>: <span class="hljs-number">7</span>,
    <span class="hljs-string">&quot;I-cell_line&quot;</span>: <span class="hljs-number">8</span>,
    <span class="hljs-string">&quot;B-RNA&quot;</span>: <span class="hljs-number">9</span>,
    <span class="hljs-string">&quot;I-RNA&quot;</span>: <span class="hljs-number">10</span>,
}`,wrap:!1}}),R=new u({props:{code:"c2VxZXZhbCUyMCUzRCUyMGV2YWx1YXRlLmxvYWQoJTIyc2VxZXZhbCUyMik=",highlighted:'seqeval = evaluate.load(<span class="hljs-string">&quot;seqeval&quot;</span>)',wrap:!1}}),V=new u({props:{code:"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",highlighted:`label_list = [
    <span class="hljs-string">&quot;O&quot;</span>,
    <span class="hljs-string">&quot;B-DNA&quot;</span>,
    <span class="hljs-string">&quot;I-DNA&quot;</span>,
    <span class="hljs-string">&quot;B-protein&quot;</span>,
    <span class="hljs-string">&quot;I-protein&quot;</span>,
    <span class="hljs-string">&quot;B-cell_type&quot;</span>,
    <span class="hljs-string">&quot;I-cell_type&quot;</span>,
    <span class="hljs-string">&quot;B-cell_line&quot;</span>,
    <span class="hljs-string">&quot;I-cell_line&quot;</span>,
    <span class="hljs-string">&quot;B-RNA&quot;</span>,
    <span class="hljs-string">&quot;I-RNA&quot;</span>,
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">p</span>):
    predictions, labels = p
    predictions = np.argmax(predictions, axis=<span class="hljs-number">2</span>)

    true_predictions = [
        [label_list[p] <span class="hljs-keyword">for</span> (p, l) <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(prediction, label) <span class="hljs-keyword">if</span> l != -<span class="hljs-number">100</span>]
        <span class="hljs-keyword">for</span> prediction, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(predictions, labels)
    ]
    true_labels = [
        [label_list[l] <span class="hljs-keyword">for</span> (p, l) <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(prediction, label) <span class="hljs-keyword">if</span> l != -<span class="hljs-number">100</span>]
        <span class="hljs-keyword">for</span> prediction, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(predictions, labels)
    ]

    results = seqeval.compute(predictions=true_predictions, references=true_labels)
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;precision&quot;</span>: results[<span class="hljs-string">&quot;overall_precision&quot;</span>],
        <span class="hljs-string">&quot;recall&quot;</span>: results[<span class="hljs-string">&quot;overall_recall&quot;</span>],
        <span class="hljs-string">&quot;f1&quot;</span>: results[<span class="hljs-string">&quot;overall_f1&quot;</span>],
        <span class="hljs-string">&quot;accuracy&quot;</span>: results[<span class="hljs-string">&quot;overall_accuracy&quot;</span>],
    }`,wrap:!1}}),N=new hl({props:{title:"Preprocess dataset",local:"preprocess-dataset",headingTag:"h2"}}),X=new u({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfY2hlY2twb2ludCUyQyUyMGFkZF9wcmVmaXhfc3BhY2UlM0RUcnVlKQ==",highlighted:'tokenizer = AutoTokenizer.from_pretrained(model_checkpoint, add_prefix_space=<span class="hljs-literal">True</span>)',wrap:!1}}),Y=new u({props:{code:"ZGVmJTIwdG9rZW5pemVfYW5kX2FsaWduX2xhYmVscyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGV4YW1wbGVzJTVCJTIydG9rZW5zJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjBpc19zcGxpdF9pbnRvX3dvcmRzJTNEVHJ1ZSklMEElMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBpJTJDJTIwbGFiZWwlMjBpbiUyMGVudW1lcmF0ZShleGFtcGxlcyU1QmYlMjJ0YWdzJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdvcmRfaWRzJTIwJTNEJTIwdG9rZW5pemVkX2lucHV0cy53b3JkX2lkcyhiYXRjaF9pbmRleCUzRGkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJldmlvdXNfd29yZF9pZHglMjAlM0QlMjBOb25lJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxfaWRzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwd29yZF9pZHglMjBpbiUyMHdvcmRfaWRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjB3b3JkX2lkeCUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVsX2lkcy5hcHBlbmQoLTEwMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbGlmJTIwd29yZF9pZHglMjAhJTNEJTIwcHJldmlvdXNfd29yZF9pZHglM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbF9pZHMuYXBwZW5kKGxhYmVsJTVCd29yZF9pZHglNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVsX2lkcy5hcHBlbmQoLTEwMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmV2aW91c193b3JkX2lkeCUyMCUzRCUyMHdvcmRfaWR4JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzLmFwcGVuZChsYWJlbF9pZHMpJTBBJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2lucHV0cyU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGxhYmVscyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplZF9pbnB1dHM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_and_align_labels</span>(<span class="hljs-params">examples</span>):
    tokenized_inputs = tokenizer(examples[<span class="hljs-string">&quot;tokens&quot;</span>], truncation=<span class="hljs-literal">True</span>, is_split_into_words=<span class="hljs-literal">True</span>)

    labels = []
    <span class="hljs-keyword">for</span> i, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(examples[<span class="hljs-string">f&quot;tags&quot;</span>]):
        word_ids = tokenized_inputs.word_ids(batch_index=i)
        previous_word_idx = <span class="hljs-literal">None</span>
        label_ids = []
        <span class="hljs-keyword">for</span> word_idx <span class="hljs-keyword">in</span> word_ids:
            <span class="hljs-keyword">if</span> word_idx <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
                label_ids.append(-<span class="hljs-number">100</span>)
            <span class="hljs-keyword">elif</span> word_idx != previous_word_idx:
                label_ids.append(label[word_idx])
            <span class="hljs-keyword">else</span>:
                label_ids.append(-<span class="hljs-number">100</span>)
            previous_word_idx = word_idx
        labels.append(label_ids)

    tokenized_inputs[<span class="hljs-string">&quot;labels&quot;</span>] = labels
    <span class="hljs-keyword">return</span> tokenized_inputs`,wrap:!1}}),x=new u({props:{code:"dG9rZW5pemVkX2Jpb25scCUyMCUzRCUyMGJpb25scC5tYXAodG9rZW5pemVfYW5kX2FsaWduX2xhYmVscyUyQyUyMGJhdGNoZWQlM0RUcnVlKQ==",highlighted:'tokenized_bionlp = bionlp.<span class="hljs-built_in">map</span>(tokenize_and_align_labels, batched=<span class="hljs-literal">True</span>)',wrap:!1}}),D=new u({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvclRva2VuQ2xhc3NpZmljYXRpb24odG9rZW5pemVyJTNEdG9rZW5pemVyKQ==",highlighted:"data_collator = DataCollatorForTokenClassification(tokenizer=tokenizer)",wrap:!1}}),L=new hl({props:{title:"Train",local:"train",headingTag:"h2"}}),K=new u({props:{code:"aWQybGFiZWwlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAwJTNBJTIwJTIyTyUyMiUyQyUwQSUyMCUyMCUyMCUyMDElM0ElMjAlMjJCLUROQSUyMiUyQyUwQSUyMCUyMCUyMCUyMDIlM0ElMjAlMjJJLUROQSUyMiUyQyUwQSUyMCUyMCUyMCUyMDMlM0ElMjAlMjJCLXByb3RlaW4lMjIlMkMlMEElMjAlMjAlMjAlMjA0JTNBJTIwJTIySS1wcm90ZWluJTIyJTJDJTBBJTIwJTIwJTIwJTIwNSUzQSUyMCUyMkItY2VsbF90eXBlJTIyJTJDJTBBJTIwJTIwJTIwJTIwNiUzQSUyMCUyMkktY2VsbF90eXBlJTIyJTJDJTBBJTIwJTIwJTIwJTIwNyUzQSUyMCUyMkItY2VsbF9saW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwOCUzQSUyMCUyMkktY2VsbF9saW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwOSUzQSUyMCUyMkItUk5BJTIyJTJDJTBBJTIwJTIwJTIwJTIwMTAlM0ElMjAlMjJJLVJOQSUyMiUyQyUwQSU3RCUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyTyUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJCLUROQSUyMiUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAlMjJJLUROQSUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJCLXByb3RlaW4lMjIlM0ElMjAzJTJDJTBBJTIwJTIwJTIwJTIwJTIySS1wcm90ZWluJTIyJTNBJTIwNCUyQyUwQSUyMCUyMCUyMCUyMCUyMkItY2VsbF90eXBlJTIyJTNBJTIwNSUyQyUwQSUyMCUyMCUyMCUyMCUyMkktY2VsbF90eXBlJTIyJTNBJTIwNiUyQyUwQSUyMCUyMCUyMCUyMCUyMkItY2VsbF9saW5lJTIyJTNBJTIwNyUyQyUwQSUyMCUyMCUyMCUyMCUyMkktY2VsbF9saW5lJTIyJTNBJTIwOCUyQyUwQSUyMCUyMCUyMCUyMCUyMkItUk5BJTIyJTNBJTIwOSUyQyUwQSUyMCUyMCUyMCUyMCUyMkktUk5BJTIyJTNBJTIwMTAlMkMlMEElN0QlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2NoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMTElMkMlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUwQSk=",highlighted:`id2label = {
    <span class="hljs-number">0</span>: <span class="hljs-string">&quot;O&quot;</span>,
    <span class="hljs-number">1</span>: <span class="hljs-string">&quot;B-DNA&quot;</span>,
    <span class="hljs-number">2</span>: <span class="hljs-string">&quot;I-DNA&quot;</span>,
    <span class="hljs-number">3</span>: <span class="hljs-string">&quot;B-protein&quot;</span>,
    <span class="hljs-number">4</span>: <span class="hljs-string">&quot;I-protein&quot;</span>,
    <span class="hljs-number">5</span>: <span class="hljs-string">&quot;B-cell_type&quot;</span>,
    <span class="hljs-number">6</span>: <span class="hljs-string">&quot;I-cell_type&quot;</span>,
    <span class="hljs-number">7</span>: <span class="hljs-string">&quot;B-cell_line&quot;</span>,
    <span class="hljs-number">8</span>: <span class="hljs-string">&quot;I-cell_line&quot;</span>,
    <span class="hljs-number">9</span>: <span class="hljs-string">&quot;B-RNA&quot;</span>,
    <span class="hljs-number">10</span>: <span class="hljs-string">&quot;I-RNA&quot;</span>,
}
label2id = {
    <span class="hljs-string">&quot;O&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;B-DNA&quot;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;I-DNA&quot;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&quot;B-protein&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;I-protein&quot;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&quot;B-cell_type&quot;</span>: <span class="hljs-number">5</span>,
    <span class="hljs-string">&quot;I-cell_type&quot;</span>: <span class="hljs-number">6</span>,
    <span class="hljs-string">&quot;B-cell_line&quot;</span>: <span class="hljs-number">7</span>,
    <span class="hljs-string">&quot;I-cell_line&quot;</span>: <span class="hljs-number">8</span>,
    <span class="hljs-string">&quot;B-RNA&quot;</span>: <span class="hljs-number">9</span>,
    <span class="hljs-string">&quot;I-RNA&quot;</span>: <span class="hljs-number">10</span>,
}

model = AutoModelForTokenClassification.from_pretrained(
    model_checkpoint, num_labels=<span class="hljs-number">11</span>, id2label=id2label, label2id=label2id
)`,wrap:!1}}),m=new Os({props:{$$slots:{default:[ot]},$$scope:{ctx:ml}}}),sl=new u({props:{code:"cGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRFRhc2tUeXBlLlRPS0VOX0NMUyUyQyUyMGluZmVyZW5jZV9tb2RlJTNERmFsc2UlMkMlMjByJTNEMTYlMkMlMjBsb3JhX2FscGhhJTNEMTYlMkMlMjBsb3JhX2Ryb3BvdXQlM0QwLjElMkMlMjBiaWFzJTNEJTIyYWxsJTIyJTBBKQ==",highlighted:`peft_config = LoraConfig(
    task_type=TaskType.TOKEN_CLS, inference_mode=<span class="hljs-literal">False</span>, r=<span class="hljs-number">16</span>, lora_alpha=<span class="hljs-number">16</span>, lora_dropout=<span class="hljs-number">0.1</span>, bias=<span class="hljs-string">&quot;all&quot;</span>
)`,wrap:!1}}),el=new u({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMHBlZnRfY29uZmlnKSUwQW1vZGVsLnByaW50X3RyYWluYWJsZV9wYXJhbWV0ZXJzKCklMEElMjJ0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjAxODU1NDk5JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwMzU1ODk0MjgzJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMC41MjEzNjI0MDY5MzcwMDYxJTIy",highlighted:`model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 1855499 || all params: 355894283 || trainable%: 0.5213624069370061&quot;</span>`,wrap:!1}}),nl=new u({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJyb2JlcnRhLWxhcmdlLWxvcmEtdG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEbHIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRG51bV9lcG9jaHMlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRfZGVjYXklM0QwLjAxJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbl9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzRFRydWUlMkMlMEEp",highlighted:`training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;roberta-large-lora-token-classification&quot;</span>,
    learning_rate=lr,
    per_device_train_batch_size=batch_size,
    per_device_eval_batch_size=batch_size,
    num_train_epochs=num_epochs,
    weight_decay=<span class="hljs-number">0.01</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),pl=new u({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRva2VuaXplZF9iaW9ubHAlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHRva2VuaXplZF9iaW9ubHAlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`trainer = Trainer(
    model=model,
    args=training_args,
    train_dataset=tokenized_bionlp[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_bionlp[<span class="hljs-string">&quot;validation&quot;</span>],
    tokenizer=tokenizer,
    data_collator=data_collator,
    compute_metrics=compute_metrics,
)

trainer.train()`,wrap:!1}}),ol=new hl({props:{title:"Share model",local:"share-model",headingTag:"h2"}}),Jl=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),yl=new u({props:{code:"bW9kZWwucHVzaF90b19odWIoJTIyeW91ci1uYW1lJTJGcm9iZXJ0YS1sYXJnZS1sb3JhLXRva2VuLWNsYXNzaWZpY2F0aW9uJTIyKQ==",highlighted:'model.push_to_hub(<span class="hljs-string">&quot;your-name/roberta-large-lora-token-classification&quot;</span>)',wrap:!1}}),Tl=new hl({props:{title:"Inference",local:"inference",headingTag:"h2"}}),cl=new u({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMnN0ZXZobGl1JTJGcm9iZXJ0YS1sYXJnZS1sb3JhLXRva2VuLWNsYXNzaWZpY2F0aW9uJTIyJTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQocGVmdF9tb2RlbF9pZCklMEFpbmZlcmVuY2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBjb25maWcuYmFzZV9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjBudW1fbGFiZWxzJTNEMTElMkMlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUwQSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjb25maWcuYmFzZV9tb2RlbF9uYW1lX29yX3BhdGgpJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGluZmVyZW5jZV9tb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQp",highlighted:`peft_model_id = <span class="hljs-string">&quot;stevhliu/roberta-large-lora-token-classification&quot;</span>
config = PeftConfig.from_pretrained(peft_model_id)
inference_model = AutoModelForTokenClassification.from_pretrained(
    config.base_model_name_or_path, num_labels=<span class="hljs-number">11</span>, id2label=id2label, label2id=label2id
)
tokenizer = AutoTokenizer.from_pretrained(config.base_model_name_or_path)
model = PeftModel.from_pretrained(inference_model, peft_model_id)`,wrap:!1}}),wl=new u({props:{code:"dGV4dCUyMCUzRCUyMCUyMlRoZSUyMGFjdGl2YXRpb24lMjBvZiUyMElMLTIlMjBnZW5lJTIwZXhwcmVzc2lvbiUyMGFuZCUyME5GLWthcHBhJTIwQiUyMHRocm91Z2glMjBDRDI4JTIwcmVxdWlyZXMlMjByZWFjdGl2ZSUyMG94eWdlbiUyMHByb2R1Y3Rpb24lMjBieSUyMDUtbGlwb3h5Z2VuYXNlLiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`text = <span class="hljs-string">&quot;The activation of IL-2 gene expression and NF-kappa B through CD28 requires reactive oxygen production by 5-lipoxygenase.&quot;</span>
inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),Il=new u({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEF0b2tlbnMlMjAlM0QlMjBpbnB1dHMudG9rZW5zKCklMEFwcmVkaWN0aW9ucyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QyKSUwQSUwQWZvciUyMHRva2VuJTJDJTIwcHJlZGljdGlvbiUyMGluJTIwemlwKHRva2VucyUyQyUyMHByZWRpY3Rpb25zJTVCMCU1RC5udW1weSgpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCh0b2tlbiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3Rpb24lNUQpKSUwQSglMjIlM0NzJTNFJTIyJTJDJTIwJTIyTyUyMiklMEEoJTIyVGhlJTIyJTJDJTIwJTIyTyUyMiklMEEoJTIyJUM0JUEwYWN0aXZhdGlvbiUyMiUyQyUyMCUyMk8lMjIpJTBBKCUyMiVDNCVBMG9mJTIyJTJDJTIwJTIyTyUyMiklMEEoJTIyJUM0JUEwSUwlMjIlMkMlMjAlMjJCLUROQSUyMiklMEEoJTIyLSUyMiUyQyUyMCUyMk8lMjIpJTBBKCUyMjIlMjIlMkMlMjAlMjJJLUROQSUyMiklMEEoJTIyJUM0JUEwZ2VuZSUyMiUyQyUyMCUyMk8lMjIpJTBBKCUyMiVDNCVBMGV4cHJlc3Npb24lMjIlMkMlMjAlMjJPJTIyKSUwQSglMjIlQzQlQTBhbmQlMjIlMkMlMjAlMjJPJTIyKSUwQSglMjIlQzQlQTBORiUyMiUyQyUyMCUyMkItcHJvdGVpbiUyMiklMEEoJTIyLSUyMiUyQyUyMCUyMk8lMjIpJTBBKCUyMmslMjIlMkMlMjAlMjJJLXByb3RlaW4lMjIpJTBBKCUyMmFwcGElMjIlMkMlMjAlMjJJLXByb3RlaW4lMjIpJTBBKCUyMiVDNCVBMEIlMjIlMkMlMjAlMjJJLXByb3RlaW4lMjIpJTBBKCUyMiVDNCVBMHRocm91Z2glMjIlMkMlMjAlMjJPJTIyKSUwQSglMjIlQzQlQTBDRCUyMiUyQyUyMCUyMkItcHJvdGVpbiUyMiklMEEoJTIyMjglMjIlMkMlMjAlMjJJLXByb3RlaW4lMjIpJTBBKCUyMiVDNCVBMHJlcXVpcmVzJTIyJTJDJTIwJTIyTyUyMiklMEEoJTIyJUM0JUEwcmVhY3RpdmUlMjIlMkMlMjAlMjJPJTIyKSUwQSglMjIlQzQlQTBveHlnZW4lMjIlMkMlMjAlMjJPJTIyKSUwQSglMjIlQzQlQTBwcm9kdWN0aW9uJTIyJTJDJTIwJTIyTyUyMiklMEEoJTIyJUM0JUEwYnklMjIlMkMlMjAlMjJPJTIyKSUwQSglMjIlQzQlQTA1JTIyJTJDJTIwJTIyQi1wcm90ZWluJTIyKSUwQSglMjItJTIyJTJDJTIwJTIyTyUyMiklMEEoJTIybGlwJTIyJTJDJTIwJTIySS1wcm90ZWluJTIyKSUwQSglMjJveHklMjIlMkMlMjAlMjJJLXByb3RlaW4lMjIpJTBBKCUyMmdlbiUyMiUyQyUyMCUyMkktcHJvdGVpbiUyMiklMEEoJTIyYXNlJTIyJTJDJTIwJTIySS1wcm90ZWluJTIyKSUwQSglMjIuJTIyJTJDJTIwJTIyTyUyMiklMEEoJTIyJTNDJTJGcyUzRSUyMiUyQyUyMCUyMk8lMjIp",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    logits = model(**inputs).logits

tokens = inputs.tokens()
predictions = torch.argmax(logits, dim=<span class="hljs-number">2</span>)

<span class="hljs-keyword">for</span> token, prediction <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(tokens, predictions[<span class="hljs-number">0</span>].numpy()):
    <span class="hljs-built_in">print</span>((token, model.config.id2label[prediction]))
(<span class="hljs-string">&quot;&lt;s&gt;&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;The&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;Ġactivation&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;Ġof&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;ĠIL&quot;</span>, <span class="hljs-string">&quot;B-DNA&quot;</span>)
(<span class="hljs-string">&quot;-&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;2&quot;</span>, <span class="hljs-string">&quot;I-DNA&quot;</span>)
(<span class="hljs-string">&quot;Ġgene&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;Ġexpression&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;Ġand&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;ĠNF&quot;</span>, <span class="hljs-string">&quot;B-protein&quot;</span>)
(<span class="hljs-string">&quot;-&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;k&quot;</span>, <span class="hljs-string">&quot;I-protein&quot;</span>)
(<span class="hljs-string">&quot;appa&quot;</span>, <span class="hljs-string">&quot;I-protein&quot;</span>)
(<span class="hljs-string">&quot;ĠB&quot;</span>, <span class="hljs-string">&quot;I-protein&quot;</span>)
(<span class="hljs-string">&quot;Ġthrough&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;ĠCD&quot;</span>, <span class="hljs-string">&quot;B-protein&quot;</span>)
(<span class="hljs-string">&quot;28&quot;</span>, <span class="hljs-string">&quot;I-protein&quot;</span>)
(<span class="hljs-string">&quot;Ġrequires&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;Ġreactive&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;Ġoxygen&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;Ġproduction&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;Ġby&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;Ġ5&quot;</span>, <span class="hljs-string">&quot;B-protein&quot;</span>)
(<span class="hljs-string">&quot;-&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;lip&quot;</span>, <span class="hljs-string">&quot;I-protein&quot;</span>)
(<span class="hljs-string">&quot;oxy&quot;</span>, <span class="hljs-string">&quot;I-protein&quot;</span>)
(<span class="hljs-string">&quot;gen&quot;</span>, <span class="hljs-string">&quot;I-protein&quot;</span>)
(<span class="hljs-string">&quot;ase&quot;</span>, <span class="hljs-string">&quot;I-protein&quot;</span>)
(<span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)
(<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>, <span class="hljs-string">&quot;O&quot;</span>)`,wrap:!1}}),{c(){c=M("meta"),U=a(),w=M("p"),I=a(),o(d.$$.fragment),bl=a(),b=M("p"),b.textContent=fs,fl=a(),o(h.$$.fragment),Cl=a(),f=M("p"),f.innerHTML=Cs,gl=a(),C=M("p"),C.textContent=gs,kl=a(),o(g.$$.fragment),Al=a(),o(k.$$.fragment),Bl=a(),A=M("p"),A.textContent=ks,ql=a(),B=M("ul"),B.innerHTML=As,Zl=a(),o(q.$$.fragment),Wl=a(),o(Z.$$.fragment),$l=a(),W=M("p"),W.innerHTML=Bs,Ql=a(),o($.$$.fragment),_l=a(),Q=M("p"),Q.innerHTML=qs,El=a(),o(_.$$.fragment),Rl=a(),E=M("p"),E.innerHTML=Zs,vl=a(),o(R.$$.fragment),Vl=a(),v=M("p"),v.textContent=Ws,Nl=a(),o(V.$$.fragment),Gl=a(),o(N.$$.fragment),Xl=a(),G=M("p"),G.innerHTML=$s,Sl=a(),o(X.$$.fragment),zl=a(),S=M("p"),S.textContent=Qs,Yl=a(),z=M("ol"),z.innerHTML=_s,Fl=a(),o(Y.$$.fragment),xl=a(),F=M("p"),F.innerHTML=Es,Hl=a(),o(x.$$.fragment),Dl=a(),H=M("p"),H.textContent=Rs,Ll=a(),o(D.$$.fragment),Pl=a(),o(L.$$.fragment),Kl=a(),P=M("p"),P.innerHTML=vs,Ol=a(),o(K.$$.fragment),ls=a(),O=M("p"),O.innerHTML=Vs,ss=a(),ll=M("ul"),ll.innerHTML=Ns,ts=a(),o(m.$$.fragment),es=a(),o(sl.$$.fragment),as=a(),tl=M("p"),tl.innerHTML=Gs,ns=a(),o(el.$$.fragment),Ms=a(),al=M("p"),al.innerHTML=Xs,ps=a(),o(nl.$$.fragment),os=a(),Ml=M("p"),Ml.innerHTML=Ss,is=a(),o(pl.$$.fragment),Js=a(),o(ol.$$.fragment),rs=a(),il=M("p"),il.textContent=zs,ys=a(),o(Jl.$$.fragment),Ts=a(),rl=M("p"),rl.innerHTML=Ys,js=a(),o(yl.$$.fragment),cs=a(),o(Tl.$$.fragment),us=a(),jl=M("p"),jl.textContent=Fs,ws=a(),o(cl.$$.fragment),Us=a(),ul=M("p"),ul.textContent=xs,Is=a(),o(wl.$$.fragment),hs=a(),Ul=M("p"),Ul.textContent=Hs,ms=a(),o(Il.$$.fragment),ds=a(),dl=M("p"),this.h()},l(l){const s=nt("svelte-u9bgzb",document.head);c=p(s,"META",{name:!0,content:!0}),s.forEach(t),U=n(l),w=p(l,"P",{}),Ps(w).forEach(t),I=n(l),i(d.$$.fragment,l),bl=n(l),b=p(l,"P",{"data-svelte-h":!0}),j(b)!=="svelte-353m1i"&&(b.textContent=fs),fl=n(l),i(h.$$.fragment,l),Cl=n(l),f=p(l,"P",{"data-svelte-h":!0}),j(f)!=="svelte-1hsuxns"&&(f.innerHTML=Cs),gl=n(l),C=p(l,"P",{"data-svelte-h":!0}),j(C)!=="svelte-1c9nexd"&&(C.textContent=gs),kl=n(l),i(g.$$.fragment,l),Al=n(l),i(k.$$.fragment,l),Bl=n(l),A=p(l,"P",{"data-svelte-h":!0}),j(A)!=="svelte-1quxkd3"&&(A.textContent=ks),ql=n(l),B=p(l,"UL",{"data-svelte-h":!0}),j(B)!=="svelte-1vdqu50"&&(B.innerHTML=As),Zl=n(l),i(q.$$.fragment,l),Wl=n(l),i(Z.$$.fragment,l),$l=n(l),W=p(l,"P",{"data-svelte-h":!0}),j(W)!=="svelte-1qbccnw"&&(W.innerHTML=Bs),Ql=n(l),i($.$$.fragment,l),_l=n(l),Q=p(l,"P",{"data-svelte-h":!0}),j(Q)!=="svelte-1i5fqx3"&&(Q.innerHTML=qs),El=n(l),i(_.$$.fragment,l),Rl=n(l),E=p(l,"P",{"data-svelte-h":!0}),j(E)!=="svelte-1sgw51e"&&(E.innerHTML=Zs),vl=n(l),i(R.$$.fragment,l),Vl=n(l),v=p(l,"P",{"data-svelte-h":!0}),j(v)!=="svelte-96unc4"&&(v.textContent=Ws),Nl=n(l),i(V.$$.fragment,l),Gl=n(l),i(N.$$.fragment,l),Xl=n(l),G=p(l,"P",{"data-svelte-h":!0}),j(G)!=="svelte-7igb10"&&(G.innerHTML=$s),Sl=n(l),i(X.$$.fragment,l),zl=n(l),S=p(l,"P",{"data-svelte-h":!0}),j(S)!=="svelte-12p7a1j"&&(S.textContent=Qs),Yl=n(l),z=p(l,"OL",{"data-svelte-h":!0}),j(z)!=="svelte-1cw2sn2"&&(z.innerHTML=_s),Fl=n(l),i(Y.$$.fragment,l),xl=n(l),F=p(l,"P",{"data-svelte-h":!0}),j(F)!=="svelte-15zme2u"&&(F.innerHTML=Es),Hl=n(l),i(x.$$.fragment,l),Dl=n(l),H=p(l,"P",{"data-svelte-h":!0}),j(H)!=="svelte-yafogm"&&(H.textContent=Rs),Ll=n(l),i(D.$$.fragment,l),Pl=n(l),i(L.$$.fragment,l),Kl=n(l),P=p(l,"P",{"data-svelte-h":!0}),j(P)!=="svelte-1ga0jr5"&&(P.innerHTML=vs),Ol=n(l),i(K.$$.fragment,l),ls=n(l),O=p(l,"P",{"data-svelte-h":!0}),j(O)!=="svelte-1l2vmo3"&&(O.innerHTML=Vs),ss=n(l),ll=p(l,"UL",{"data-svelte-h":!0}),j(ll)!=="svelte-y18ek6"&&(ll.innerHTML=Ns),ts=n(l),i(m.$$.fragment,l),es=n(l),i(sl.$$.fragment,l),as=n(l),tl=p(l,"P",{"data-svelte-h":!0}),j(tl)!=="svelte-1gthxgd"&&(tl.innerHTML=Gs),ns=n(l),i(el.$$.fragment,l),Ms=n(l),al=p(l,"P",{"data-svelte-h":!0}),j(al)!=="svelte-1tvvv6p"&&(al.innerHTML=Xs),ps=n(l),i(nl.$$.fragment,l),os=n(l),Ml=p(l,"P",{"data-svelte-h":!0}),j(Ml)!=="svelte-9qto35"&&(Ml.innerHTML=Ss),is=n(l),i(pl.$$.fragment,l),Js=n(l),i(ol.$$.fragment,l),rs=n(l),il=p(l,"P",{"data-svelte-h":!0}),j(il)!=="svelte-1vig879"&&(il.textContent=zs),ys=n(l),i(Jl.$$.fragment,l),Ts=n(l),rl=p(l,"P",{"data-svelte-h":!0}),j(rl)!=="svelte-1ut6zwc"&&(rl.innerHTML=Ys),js=n(l),i(yl.$$.fragment,l),cs=n(l),i(Tl.$$.fragment,l),us=n(l),jl=p(l,"P",{"data-svelte-h":!0}),j(jl)!=="svelte-1aj5h8f"&&(jl.textContent=Fs),ws=n(l),i(cl.$$.fragment,l),Us=n(l),ul=p(l,"P",{"data-svelte-h":!0}),j(ul)!=="svelte-4ied6n"&&(ul.textContent=xs),Is=n(l),i(wl.$$.fragment,l),hs=n(l),Ul=p(l,"P",{"data-svelte-h":!0}),j(Ul)!=="svelte-179hhpe"&&(Ul.textContent=Hs),ms=n(l),i(Il.$$.fragment,l),ds=n(l),dl=p(l,"P",{}),Ps(dl).forEach(t),this.h()},h(){Ks(c,"name","hf:doc:metadata"),Ks(c,"content",Jt)},m(l,s){Mt(document.head,c),e(l,U,s),e(l,w,s),e(l,I,s),J(d,l,s),e(l,bl,s),e(l,b,s),e(l,fl,s),J(h,l,s),e(l,Cl,s),e(l,f,s),e(l,gl,s),e(l,C,s),e(l,kl,s),J(g,l,s),e(l,Al,s),J(k,l,s),e(l,Bl,s),e(l,A,s),e(l,ql,s),e(l,B,s),e(l,Zl,s),J(q,l,s),e(l,Wl,s),J(Z,l,s),e(l,$l,s),e(l,W,s),e(l,Ql,s),J($,l,s),e(l,_l,s),e(l,Q,s),e(l,El,s),J(_,l,s),e(l,Rl,s),e(l,E,s),e(l,vl,s),J(R,l,s),e(l,Vl,s),e(l,v,s),e(l,Nl,s),J(V,l,s),e(l,Gl,s),J(N,l,s),e(l,Xl,s),e(l,G,s),e(l,Sl,s),J(X,l,s),e(l,zl,s),e(l,S,s),e(l,Yl,s),e(l,z,s),e(l,Fl,s),J(Y,l,s),e(l,xl,s),e(l,F,s),e(l,Hl,s),J(x,l,s),e(l,Dl,s),e(l,H,s),e(l,Ll,s),J(D,l,s),e(l,Pl,s),J(L,l,s),e(l,Kl,s),e(l,P,s),e(l,Ol,s),J(K,l,s),e(l,ls,s),e(l,O,s),e(l,ss,s),e(l,ll,s),e(l,ts,s),J(m,l,s),e(l,es,s),J(sl,l,s),e(l,as,s),e(l,tl,s),e(l,ns,s),J(el,l,s),e(l,Ms,s),e(l,al,s),e(l,ps,s),J(nl,l,s),e(l,os,s),e(l,Ml,s),e(l,is,s),J(pl,l,s),e(l,Js,s),J(ol,l,s),e(l,rs,s),e(l,il,s),e(l,ys,s),J(Jl,l,s),e(l,Ts,s),e(l,rl,s),e(l,js,s),J(yl,l,s),e(l,cs,s),J(Tl,l,s),e(l,us,s),e(l,jl,s),e(l,ws,s),J(cl,l,s),e(l,Us,s),e(l,ul,s),e(l,Is,s),J(wl,l,s),e(l,hs,s),e(l,Ul,s),e(l,ms,s),J(Il,l,s),e(l,ds,s),e(l,dl,s),bs=!0},p(l,[s]){const Ds={};s&2&&(Ds.$$scope={dirty:s,ctx:l}),h.$set(Ds);const Ls={};s&2&&(Ls.$$scope={dirty:s,ctx:l}),m.$set(Ls)},i(l){bs||(r(d.$$.fragment,l),r(h.$$.fragment,l),r(g.$$.fragment,l),r(k.$$.fragment,l),r(q.$$.fragment,l),r(Z.$$.fragment,l),r($.$$.fragment,l),r(_.$$.fragment,l),r(R.$$.fragment,l),r(V.$$.fragment,l),r(N.$$.fragment,l),r(X.$$.fragment,l),r(Y.$$.fragment,l),r(x.$$.fragment,l),r(D.$$.fragment,l),r(L.$$.fragment,l),r(K.$$.fragment,l),r(m.$$.fragment,l),r(sl.$$.fragment,l),r(el.$$.fragment,l),r(nl.$$.fragment,l),r(pl.$$.fragment,l),r(ol.$$.fragment,l),r(Jl.$$.fragment,l),r(yl.$$.fragment,l),r(Tl.$$.fragment,l),r(cl.$$.fragment,l),r(wl.$$.fragment,l),r(Il.$$.fragment,l),bs=!0)},o(l){y(d.$$.fragment,l),y(h.$$.fragment,l),y(g.$$.fragment,l),y(k.$$.fragment,l),y(q.$$.fragment,l),y(Z.$$.fragment,l),y($.$$.fragment,l),y(_.$$.fragment,l),y(R.$$.fragment,l),y(V.$$.fragment,l),y(N.$$.fragment,l),y(X.$$.fragment,l),y(Y.$$.fragment,l),y(x.$$.fragment,l),y(D.$$.fragment,l),y(L.$$.fragment,l),y(K.$$.fragment,l),y(m.$$.fragment,l),y(sl.$$.fragment,l),y(el.$$.fragment,l),y(nl.$$.fragment,l),y(pl.$$.fragment,l),y(ol.$$.fragment,l),y(Jl.$$.fragment,l),y(yl.$$.fragment,l),y(Tl.$$.fragment,l),y(cl.$$.fragment,l),y(wl.$$.fragment,l),y(Il.$$.fragment,l),bs=!1},d(l){l&&(t(U),t(w),t(I),t(bl),t(b),t(fl),t(Cl),t(f),t(gl),t(C),t(kl),t(Al),t(Bl),t(A),t(ql),t(B),t(Zl),t(Wl),t($l),t(W),t(Ql),t(_l),t(Q),t(El),t(Rl),t(E),t(vl),t(Vl),t(v),t(Nl),t(Gl),t(Xl),t(G),t(Sl),t(zl),t(S),t(Yl),t(z),t(Fl),t(xl),t(F),t(Hl),t(Dl),t(H),t(Ll),t(Pl),t(Kl),t(P),t(Ol),t(ls),t(O),t(ss),t(ll),t(ts),t(es),t(as),t(tl),t(ns),t(Ms),t(al),t(ps),t(os),t(Ml),t(is),t(Js),t(rs),t(il),t(ys),t(Ts),t(rl),t(js),t(cs),t(us),t(jl),t(ws),t(Us),t(ul),t(Is),t(hs),t(Ul),t(ms),t(ds),t(dl)),t(c),T(d,l),T(h,l),T(g,l),T(k,l),T(q,l),T(Z,l),T($,l),T(_,l),T(R,l),T(V,l),T(N,l),T(X,l),T(Y,l),T(x,l),T(D,l),T(L,l),T(K,l),T(m,l),T(sl,l),T(el,l),T(nl,l),T(pl,l),T(ol,l),T(Jl,l),T(yl,l),T(Tl,l),T(cl,l),T(wl,l),T(Il,l)}}}const Jt='{"title":"LoRA for token classification","local":"lora-for-token-classification","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Load dataset and metric","local":"load-dataset-and-metric","sections":[],"depth":2},{"title":"Preprocess dataset","local":"preprocess-dataset","sections":[],"depth":2},{"title":"Train","local":"train","sections":[],"depth":2},{"title":"Share model","local":"share-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function rt(ml){return tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wt extends et{constructor(c){super(),at(this,c,rt,it,st,{})}}export{wt as component};
