import{s as ga,n as Ma,o as ba}from"../chunks/scheduler.f7e1785c.js";import{S as wa,i as Ta,g as i,s as l,r,A as ja,h as o,f as s,c as n,j as ya,u as h,x as p,k as Ae,y as xa,a,v as c,d,t as u,w as m}from"../chunks/index.9f8f0838.js";import{C as f}from"../chunks/CodeBlock.b3510e34.js";import{H as g}from"../chunks/Heading.6643a2f7.js";function va(Ms){let y,Ee,Ge,Re,j,Fe,x,bs=`The Hugging Face Hub is home to over 500 pre-trained models for audio classification. In this section, we’ll go through
some of the most common audio classification tasks and suggest appropriate pre-trained models for each. Using the <code>pipeline()</code>
class, switching between models and tasks is straightforward - once you know how to use <code>pipeline()</code> for one model, you’ll
be able to use it for any model on the Hub no code changes! This makes experimenting with the <code>pipeline()</code> class extremely
fast, allowing you to quickly select the best pre-trained model for your needs.`,Be,v,ws=`Before we jump into the various audio classification problems, let’s quickly recap the transformer architectures typically
used. The standard audio classification architecture is motivated by the nature of the task; we want to transform a sequence
of audio inputs (i.e. our input audio array) into a single class label prediction. Encoder-only models first map the input
audio sequence into a sequence of hidden-state representations by passing the inputs through a transformer block. The
sequence of hidden-state representations is then mapped to a class label output by taking the mean over the hidden-states,
and passing the resulting vector through a linear classification layer. Hence, there is a preference for <em>encoder-only</em>
models for audio classification.`,Pe,U,Ts=`Decoder-only models introduce unnecessary complexity to the task, since they assume that the outputs can also be a <em>sequence</em>
of predictions (rather than a single class label prediction), and so generate multiple outputs. Therefore, they have slower
inference speed and tend not to be used. Encoder-decoder models are largely omitted for the same reason. These architecture
choices are analogous to those in NLP, where encoder-only models such as <a href="https://huggingface.co/blog/bert-101" rel="nofollow">BERT</a>
are favoured for sequence classification tasks, and decoder-only models such as GPT reserved for sequence generation tasks.`,Ve,J,js=`Now that we’ve recapped the standard transformer architecture for audio classification, let’s jump into the different
subsets of audio classification and cover the most popular models!`,Xe,C,Oe,$,xs=`At the time of writing, the latest updates required for audio classification pipeline are only on the <code>main</code> version of
the 🤗 Transformers repository, rather than the latest PyPi version. To make sure we have these updates locally, we’ll
install Transformers from the <code>main</code> branch with the following command:`,Ke,k,et,I,tt,N,vs=`Keyword spotting (KWS) is the task of identifying a keyword in a spoken utterance. The set of possible keywords forms the
set of predicted class labels. Hence, to use a pre-trained keyword spotting model, you should ensure that your keywords
match those that the model was pre-trained on. Below, we’ll introduce two datasets and models for keyword spotting.`,st,W,at,H,Us=`Let’s go ahead and use the same <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a> dataset that you have explored
in the previous unit. If you recall, MINDS-14 contains recordings of people asking an e-banking system questions in several
languages and dialects, and has the <code>intent_class</code> for each recording. We can classify the recordings by intent of the call.`,lt,L,nt,_,Js=`We’ll load the checkpoint <a href="https://huggingface.co/anton-l/xtreme_s_xlsr_300m_minds14" rel="nofollow"><code>&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</code></a>,
which is an XLS-R model fine-tuned on MINDS-14 for approximately 50 epochs. It achieves 90% accuracy over all languages
from MINDS-14 on the evaluation set.`,it,q,ot,Z,Cs="Finally, we can pass a sample to the classification pipeline to make a prediction:",pt,z,rt,Q,$s="<strong>Output:</strong>",ht,S,ct,Y,ks=`Great! We’ve identified that the intent of the call was paying a bill, with probability 96%. You can imagine this kind of
keyword spotting system being used as the first stage of an automated call centre, where we want to categorise incoming
customer calls based on their query and offer them contextualised support accordingly.`,dt,A,ut,G,Is=`Speech Commands is a dataset of spoken words designed to evaluate audio classification models on simple command words.
The dataset consists of 15 classes of keywords, a class for silence, and an unknown class to include the false positive.
The 15 keywords are single words that would typically be used in on-device settings to control basic tasks or launch
other processes.`,mt,D,Ns=`A similar model is running continuously on your mobile phone. Here, instead of having single command words, we have
‘wake words’ specific to your device, such as “Hey Google” or “Hey Siri”. When the audio classification model detects
these wake words, it triggers your phone to start listening to the microphone and transcribe your speech using a speech
recognition model.`,ft,E,Ws=`The audio classification model is much smaller and lighter than the speech recognition model, often only several millions
of parameters compared to several hundred millions for speech recognition. Thus, it can be run continuously on your device
without draining your battery! Only when the wake word is detected is the larger speech recognition model launched, and
afterwards it is shut down again. We’ll cover transformer models for speech recognition in the next Unit, so by the end
of the course you should have the tools you need to build your own voice activated assistant!`,yt,R,Hs=`As with any dataset on the Hugging Face Hub, we can get a feel for the kind of audio data it has present without downloading
or committing it memory. After heading to the <a href="https://huggingface.co/datasets/speech_commands" rel="nofollow">Speech Commands’ dataset card</a>
on the Hub, we can use the Dataset Viewer to scroll through the first 100 samples of the dataset, listening to the audio
files and checking any other metadata information:`,gt,M,Ls='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/speech_commands.png" alt="Diagram of datasets viewer."/>',Mt,F,_s=`The Dataset Preview is a brilliant way of experiencing audio datasets before committing to using them. You can pick any
dataset on the Hub, scroll through the samples and listen to the audio for the different subsets and splits, gauging whether
it’s the right dataset for your needs. Once you’ve selected a dataset, it’s trivial to load the data so that you can start
using it.`,bt,B,qs="Let’s do exactly that and load a sample of the Speech Commands dataset using streaming mode:",wt,P,Tt,V,Zs=`We’ll load an official <a href="https://huggingface.co/docs/transformers/model_doc/audio-spectrogram-transformer" rel="nofollow">Audio Spectrogram Transformer</a>
checkpoint fine-tuned on the Speech Commands dataset, under the namespace <a href="https://huggingface.co/MIT/ast-finetuned-speech-commands-v2" rel="nofollow"><code>&quot;MIT/ast-finetuned-speech-commands-v2&quot;</code></a>:`,jt,X,xt,O,zs="<strong>Output:</strong>",vt,K,Ut,ee,Qs=`Cool! Looks like the example contains the word “backward” with high probability. We can take a listen to the sample
and verify this is correct:`,Jt,te,Ct,se,Ss=`Now, you might be wondering how we’ve selected these pre-trained models to show you in these audio classification examples.
The truth is, finding pre-trained models for your dataset and task is very straightforward! The first thing we need to do
is head to the Hugging Face Hub and click on the “Models” tab: <a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>`,$t,ae,Ys="This is going to bring up all the models on the Hugging Face Hub, sorted by downloads in the past 30 days:",kt,b,As='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/all_models.png"/>',It,le,Gs=`You’ll notice on the left-hand side that we have a selection of tabs that we can select to filter models by task, library,
dataset, etc. Scroll down and select the task “Audio Classification” from the list of audio tasks:`,Nt,w,Ds='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_audio_classification.png"/>',Wt,ne,Es=`We’re now presented with the sub-set of 500+ audio classification models on the Hub. To further refine this selection, we
can filter models by dataset. Click on the tab “Datasets”, and in the search box type “speech_commands”. As you begin typing,
you’ll see the selection for <code>speech_commands</code> appear underneath the search tab. You can click this button to filter all
audio classification models to those fine-tuned on the Speech Commands dataset:`,Ht,T,Rs='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_speech_commands.png"/>',Lt,ie,Fs=`Great! We see that we have 6 pre-trained models available to us for this specific dataset and task. You’ll recognise the
first of these models as the Audio Spectrogram Transformer checkpoint that we used in the previous example. This process
of filtering models on the Hub is exactly how we went about selecting the checkpoint to show you!`,_t,oe,qt,pe,Bs=`Language identification (LID) is the task of identifying the language spoken in an audio sample from a list of candidate
languages. LID can form an important part in many speech pipelines. For example, given an audio sample in an unknown language,
an LID model can be used to categorise the language(s) spoken in the audio sample, and then select an appropriate speech
recognition model trained on that language to transcribe the audio.`,Zt,re,zt,he,Ps=`FLEURS (Few-shot Learning Evaluation of Universal Representations of Speech) is a dataset for evaluating speech recognition
systems in 102 languages, including many that are classified as ‘low-resource’. Take a look at the FLEURS dataset
card on the Hub and explore the different languages that are present: <a href="https://huggingface.co/datasets/google/fleurs" rel="nofollow">google/fleurs</a>.
Can you find your native tongue here? If not, what’s the most closely related language?`,Qt,ce,Vs="Let’s load up a sample from the validation split of the FLEURS dataset using streaming mode:",St,de,Yt,ue,Xs=`Great! Now we can load our audio classification model. For this, we’ll use a version of <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper</a>
fine-tuned on the FLEURS dataset, which is currently the most performant LID model on the Hub:`,At,me,Gt,fe,Os="We can then pass the audio through our classifier and generate a prediction:",Dt,ye,Et,ge,Ks="<strong>Output:</strong>",Rt,Me,Ft,be,ea=`We can see that the model predicted the audio was in Afrikaans with extremely high probability (near 1). The FLEURS dataset
contains audio data from a wide range of languages - we can see that possible class labels include Northern-Sotho, Icelandic,
Danish and Cantonese Chinese amongst others. You can find the full list of languages on the dataset card here: <a href="https://huggingface.co/datasets/google/fleurs" rel="nofollow">google/fleurs</a>.`,Bt,we,ta="Over to you! What other checkpoints can you find for FLEURS LID on the Hub? What transformer models are they using under-the-hood?",Pt,Te,Vt,je,sa=`In the traditional paradigm for audio classification, the model predicts a class label from a <em>pre-defined</em> set of
possible classes. This poses a barrier to using pre-trained models for audio classification, since the label set of the
pre-trained model must match that of the downstream task. For the previous example of LID, the model must predict one of
the 102 langauge classes on which it was trained. If the downstream task actually requires 110 languages, the model would
not be able to predict 8 of the 110 languages, and so would require re-training to achieve full coverage. This limits the
effectiveness of transfer learning for audio classification tasks.`,Xt,xe,aa=`Zero-shot audio classification is a method for taking a pre-trained audio classification model trained on a set of labelled
examples and enabling it to be able to classify new examples from previously unseen classes. Let’s take a look at how we
can achieve this!`,Ot,ve,la=`Currently, 🤗 Transformers supports one kind of model for zero-shot audio classification: the <a href="https://huggingface.co/docs/transformers/model_doc/clap" rel="nofollow">CLAP model</a>.
CLAP is a transformer-based model that takes both audio and text as inputs, and computes the <em>similarity</em> between the two.
If we pass a text input that strongly correlates with an audio input, we’ll get a high similarity score. Conversely, passing
a text input that is completely unrelated to the audio input will return a low similarity.`,Kt,Ue,na=`We can use this similarity prediction for zero-shot audio classification by passing one audio input to the model and
multiple candidate labels. The model will return a similarity score for each of the candidate labels, and we can pick the
one that has the highest score as our prediction.`,es,Je,ia=`Let’s take an example where we use one audio input from the <a href="https://huggingface.co/datasets/ashraq/esc50" rel="nofollow">Environmental Speech Challenge (ESC)</a>
dataset:`,ts,Ce,ss,$e,oa=`We then define our candidate labels, which form the set of possible classification labels. The model will return a
classification probability for each of the labels we define. This means we need to know <em>a-priori</em> the set of possible
labels in our classification problem, such that the correct label is contained within the set and is thus assigned a
valid probability score. Note that we can either pass the full set of labels to the model, or a hand-selected subset
that we believe contains the correct label. Passing the full set of labels is going to be more exhaustive, but comes
at the expense of lower classification accuracy since the classification space is larger (provided the correct label is
our chosen subset of labels):`,as,ke,ls,Ie,pa="We can run both through the model to find the candidate label that is <em>most similar</em> to the audio input:",ns,Ne,is,We,ra="<strong>Output:</strong>",os,He,ps,Le,ha=`Alright! The model seems pretty confident we have the sound of a dog - it predicts it with 99.96% probability, so we’ll
take that as our prediction. Let’s confirm whether we were right by listening to the audio sample (don’t turn up your
volume too high or else you might get a jump!):`,rs,_e,hs,qe,ca=`Perfect! We have the sound of a dog barking 🐕, which aligns with the model’s prediction. Have a play with different audio
samples and different candidate labels - can you define a set of labels that give good generalisation across the ESC
dataset? Hint: think about where you could find information on the possible sounds in ESC and construct your labels accordingly!`,cs,Ze,da=`You might be wondering why we don’t use the zero-shot audio classification pipeline for <strong>all</strong> audio classification tasks?
It seems as though we can make predictions for any audio classification problem by defining appropriate class labels <em>a-priori</em>,
thus bypassing the constraint that our classification task needs to match the labels that the model was pre-trained on.
This comes down to the nature of the CLAP model used in the zero-shot pipeline: CLAP is pre-trained on <em>generic</em> audio
classification data, similar to the environmental sounds in the ESC dataset, rather than specifically speech data, like
we had in the LID task. If you gave it speech in English and speech in Spanish, CLAP would know that both examples were
speech data 🗣️ But it wouldn’t be able to differentiate between the languages in the same way a dedicated LID model is
able to.`,ds,ze,us,Qe,ua=`We’ve covered a number of different audio classification tasks and presented the most relevant datasets and models that
you can download from the Hugging Face Hub and use in just several lines of code using the <code>pipeline()</code> class. These tasks
included keyword spotting, language identification and zero-shot audio classification.`,ms,Se,ma=`But what if we want to do something <strong>new</strong>? We’ve worked extensively on speech processing tasks, but this is only one
aspect of audio classification. Another popular field of audio processing involves <strong>music</strong>. While music has inherently
different features to speech, many of the same principles that we’ve learnt about already can be applied to music.`,fs,Ye,fa=`In the following section, we’ll go through a step-by-step guide on how you can fine-tune a transformer model with 🤗
Transformers on the task of music classification. By the end of it, you’ll have a fine-tuned checkpoint that you can plug
into the <code>pipeline()</code> class, enabling you to classify songs in exactly the same way that we’ve classified speech here!`,ys,De,gs;return j=new g({props:{title:"Pre-trained models and datasets for audio classification",local:"pre-trained-models-and-datasets-for-audio-classification",headingTag:"h1"}}),C=new g({props:{title:"🤗 Transformers Installation",local:"-transformers-installation",headingTag:"h2"}}),k=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJz",highlighted:'pip install git+https:<span class="hljs-regexp">//gi</span>thub.com<span class="hljs-regexp">/huggingface/</span>transformers',wrap:!1}}),I=new g({props:{title:"Keyword Spotting",local:"keyword-spotting",headingTag:"h2"}}),W=new g({props:{title:"Minds-14",local:"minds-14",headingTag:"h3"}}),L=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),q=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJhbnRvbi1sJTJGeHRyZW1lX3NfeGxzcl8zMDBtX21pbmRzMTQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>,
    model=<span class="hljs-string">&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</span>,
)`,wrap:!1}}),z=new f({props:{code:"Y2xhc3NpZmllcihtaW5kcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCk=",highlighted:'classifier(minds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>])',wrap:!1}}),S=new f({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjk2MzE1MjUyNzgwOTE0MzElMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMnBheV9iaWxsJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAyODE5Njk4MzAzOTM3OTEyJTJDJTIwJTIybGFiZWwlMjIlM0ElMjAlMjJmcmVlemUlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAzMjc4NzQ5Mjk2NDQxNjc0MiUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2FyZF9pc3N1ZXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAxOTQxNDQ0NTg1MDk5ODE2MyUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyYWJyb2FkJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAwMDgzNzg2OTM2MDExMTY1MzglMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMmhpZ2hfdmFsdWVfcGF5bWVudCUyMiU3RCUyQyUwQSU1RA==",highlighted:`[
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.9631525278091431</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;pay_bill&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.02819698303937912</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;freeze&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0032787492964416742</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;card_issues&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0019414445850998163</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;abroad&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0008378693601116538</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;high_value_payment&quot;</span>},
]`,wrap:!1}}),A=new g({props:{title:"Speech Commands",local:"speech-commands",headingTag:"h3"}}),P=new f({props:{code:"c3BlZWNoX2NvbW1hbmRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMnNwZWVjaF9jb21tYW5kcyUyMiUyQyUyMCUyMnYwLjAyJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUwQSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoc3BlZWNoX2NvbW1hbmRzKSk=",highlighted:`speech_commands = load_dataset(
    <span class="hljs-string">&quot;speech_commands&quot;</span>, <span class="hljs-string">&quot;v0.02&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(speech_commands))`,wrap:!1}}),X=new f({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJNSVQlMkZhc3QtZmluZXR1bmVkLXNwZWVjaC1jb21tYW5kcy12MiUyMiUwQSklMEFjbGFzc2lmaWVyKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVELmNvcHkoKSk=",highlighted:`classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;MIT/ast-finetuned-speech-commands-v2&quot;</span>
)
classifier(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())`,wrap:!1}}),K=new f({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTg5MjcxMTYzOTQwNCUyQyUyMCdsYWJlbCclM0ElMjAnYmFja3dhcmQnJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDEuNzUwNDg4ODc3NDA1NTg3MWUtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ2hhcHB5JyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA2LjcwMzA0MDE4NTEyOTc5NGUtMDclMkMlMjAnbGFiZWwnJTNBJTIwJ2ZvbGxvdyclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwNS44MDU4ODQ0ODQyODg5ODFlLTA3JTJDJTIwJ2xhYmVsJyUzQSUyMCdzdG9wJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA1LjYxNDU0NjY5NDIzMjU1OGUtMDclMkMlMjAnbGFiZWwnJTNBJTIwJ3VwJyU3RCU1RA==",highlighted:`[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9999892711639404</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;backward</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">1.7504888774055871</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;happy</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">6.703040185129794</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;follow</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">5.805884484288981</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;stop</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">5.614546694232558</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;up</span>&#x27;}]`,wrap:!1}}),te=new f({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJhdGUlM0RzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`from <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">IPython</span>.</span></span>display import Audio

<span class="hljs-constructor">Audio(<span class="hljs-params">sample</span>[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], <span class="hljs-params">rate</span>=<span class="hljs-params">sample</span>[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])</span>`,wrap:!1}}),oe=new g({props:{title:"Language Identification",local:"language-identification",headingTag:"h2"}}),re=new g({props:{title:"FLEURS",local:"fleurs",headingTag:"h3"}}),de=new f({props:{code:"ZmxldXJzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmdvb2dsZSUyRmZsZXVycyUyMiUyQyUyMCUyMmFsbCUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBc2FtcGxlJTIwJTNEJTIwbmV4dChpdGVyKGZsZXVycykp",highlighted:`fleurs = load_dataset(<span class="hljs-string">&quot;google/fleurs&quot;</span>, <span class="hljs-string">&quot;all&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(fleurs))`,wrap:!1}}),me=new f({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJzYW5jaGl0LWdhbmRoaSUyRndoaXNwZXItbWVkaXVtLWZsZXVycy1sYW5nLWlkJTIyJTBBKQ==",highlighted:`classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;sanchit-gandhi/whisper-medium-fleurs-lang-id&quot;</span>
)`,wrap:!1}}),ye=new f({props:{code:"Y2xhc3NpZmllcihzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCk=",highlighted:'classifier(sample[<span class="hljs-string">&quot;audio&quot;</span>])',wrap:!1}}),Me=new f({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTMzMDA0Mzc5MjcyNSUyQyUyMCdsYWJlbCclM0ElMjAnQWZyaWthYW5zJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA3LjA5MzAyMzY2ODg1ODIyM2UtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ05vcnRoZXJuLVNvdGhvJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA0LjI2OTE0OTQ4NTQ4MDczOWUtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ0ljZWxhbmRpYyclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwMy4yNjYxMTQxNjMxMjUxNjY3ZS0wNiUyQyUyMCdsYWJlbCclM0ElMjAnRGFuaXNoJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjAzLjI1ODA3MjQxMDk3MjA5MDRlLTA2JTJDJTIwJ2xhYmVsJyUzQSUyMCdDYW50b25lc2UlMjBDaGluZXNlJyU3RCU1RA==",highlighted:`[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9999330043792725</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Afrikaans</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">7.093023668858223</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Northern-Sotho</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">4.269149485480739</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Icelandic</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">3.2661141631251667</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Danish</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">3.2580724109720904</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Cantonese</span> Chinese&#x27;}]`,wrap:!1}}),Te=new g({props:{title:"Zero-Shot Audio Classification",local:"zero-shot-audio-classification",headingTag:"h2"}}),Ce=new f({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhc2hyYXElMkZlc2M1MCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWF1ZGlvX3NhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSklNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVE",highlighted:`dataset = load_dataset(<span class="hljs-string">&quot;ashraq/esc50&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
audio_sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]`,wrap:!1}}),ke=new f({props:{code:"Y2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMlNvdW5kJTIwb2YlMjBhJTIwZG9nJTIyJTJDJTIwJTIyU291bmQlMjBvZiUyMHZhY3V1bSUyMGNsZWFuZXIlMjIlNUQ=",highlighted:'candidate_labels = [<span class="hljs-string">&quot;Sound of a dog&quot;</span>, <span class="hljs-string">&quot;Sound of vacuum cleaner&quot;</span>]',wrap:!1}}),Ne=new f({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ6ZXJvLXNob3QtYXVkaW8tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmxhaW9uJTJGY2xhcC1odHNhdC11bmZ1c2VkJTIyJTBBKSUwQWNsYXNzaWZpZXIoYXVkaW9fc2FtcGxlJTJDJTIwY2FuZGlkYXRlX2xhYmVscyUzRGNhbmRpZGF0ZV9sYWJlbHMp",highlighted:`classifier = pipeline(
    task=<span class="hljs-string">&quot;zero-shot-audio-classification&quot;</span>, model=<span class="hljs-string">&quot;laion/clap-htsat-unfused&quot;</span>
)
classifier(audio_sample, candidate_labels=candidate_labels)`,wrap:!1}}),He=new f({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5NzI0MjA5MzA4NjI0MyUyQyUyMCdsYWJlbCclM0ElMjAnU291bmQlMjBvZiUyMGElMjBkb2cnJTdEJTJDJTIwJTdCJ3Njb3JlJyUzQSUyMDAuMDAwMjc1ODMyMzk3MTY0Nzc2OSUyQyUyMCdsYWJlbCclM0ElMjAnU291bmQlMjBvZiUyMHZhY3V1bSUyMGNsZWFuZXInJTdEJTVE",highlighted:'[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9997242093086243</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Sound</span> of a dog&#x27;}, {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.0002758323971647769</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Sound</span> of vacuum cleaner&#x27;}]',wrap:!1}}),_e=new f({props:{code:"QXVkaW8oYXVkaW9fc2FtcGxlJTJDJTIwcmF0ZSUzRDE2MDAwKQ==",highlighted:'Audio(audio_sample, rate=<span class="hljs-number">16000</span>)',wrap:!1}}),ze=new g({props:{title:"What next?",local:"what-next",headingTag:"h2"}}),{c(){y=i("meta"),Ee=l(),Ge=i("p"),Re=l(),r(j.$$.fragment),Fe=l(),x=i("p"),x.innerHTML=bs,Be=l(),v=i("p"),v.innerHTML=ws,Pe=l(),U=i("p"),U.innerHTML=Ts,Ve=l(),J=i("p"),J.textContent=js,Xe=l(),r(C.$$.fragment),Oe=l(),$=i("p"),$.innerHTML=xs,Ke=l(),r(k.$$.fragment),et=l(),r(I.$$.fragment),tt=l(),N=i("p"),N.textContent=vs,st=l(),r(W.$$.fragment),at=l(),H=i("p"),H.innerHTML=Us,lt=l(),r(L.$$.fragment),nt=l(),_=i("p"),_.innerHTML=Js,it=l(),r(q.$$.fragment),ot=l(),Z=i("p"),Z.textContent=Cs,pt=l(),r(z.$$.fragment),rt=l(),Q=i("p"),Q.innerHTML=$s,ht=l(),r(S.$$.fragment),ct=l(),Y=i("p"),Y.textContent=ks,dt=l(),r(A.$$.fragment),ut=l(),G=i("p"),G.textContent=Is,mt=l(),D=i("p"),D.textContent=Ns,ft=l(),E=i("p"),E.textContent=Ws,yt=l(),R=i("p"),R.innerHTML=Hs,gt=l(),M=i("div"),M.innerHTML=Ls,Mt=l(),F=i("p"),F.textContent=_s,bt=l(),B=i("p"),B.textContent=qs,wt=l(),r(P.$$.fragment),Tt=l(),V=i("p"),V.innerHTML=Zs,jt=l(),r(X.$$.fragment),xt=l(),O=i("p"),O.innerHTML=zs,vt=l(),r(K.$$.fragment),Ut=l(),ee=i("p"),ee.textContent=Qs,Jt=l(),r(te.$$.fragment),Ct=l(),se=i("p"),se.innerHTML=Ss,$t=l(),ae=i("p"),ae.textContent=Ys,kt=l(),b=i("div"),b.innerHTML=As,It=l(),le=i("p"),le.textContent=Gs,Nt=l(),w=i("div"),w.innerHTML=Ds,Wt=l(),ne=i("p"),ne.innerHTML=Es,Ht=l(),T=i("div"),T.innerHTML=Rs,Lt=l(),ie=i("p"),ie.textContent=Fs,_t=l(),r(oe.$$.fragment),qt=l(),pe=i("p"),pe.textContent=Bs,Zt=l(),r(re.$$.fragment),zt=l(),he=i("p"),he.innerHTML=Ps,Qt=l(),ce=i("p"),ce.textContent=Vs,St=l(),r(de.$$.fragment),Yt=l(),ue=i("p"),ue.innerHTML=Xs,At=l(),r(me.$$.fragment),Gt=l(),fe=i("p"),fe.textContent=Os,Dt=l(),r(ye.$$.fragment),Et=l(),ge=i("p"),ge.innerHTML=Ks,Rt=l(),r(Me.$$.fragment),Ft=l(),be=i("p"),be.innerHTML=ea,Bt=l(),we=i("p"),we.textContent=ta,Pt=l(),r(Te.$$.fragment),Vt=l(),je=i("p"),je.innerHTML=sa,Xt=l(),xe=i("p"),xe.textContent=aa,Ot=l(),ve=i("p"),ve.innerHTML=la,Kt=l(),Ue=i("p"),Ue.textContent=na,es=l(),Je=i("p"),Je.innerHTML=ia,ts=l(),r(Ce.$$.fragment),ss=l(),$e=i("p"),$e.innerHTML=oa,as=l(),r(ke.$$.fragment),ls=l(),Ie=i("p"),Ie.innerHTML=pa,ns=l(),r(Ne.$$.fragment),is=l(),We=i("p"),We.innerHTML=ra,os=l(),r(He.$$.fragment),ps=l(),Le=i("p"),Le.textContent=ha,rs=l(),r(_e.$$.fragment),hs=l(),qe=i("p"),qe.textContent=ca,cs=l(),Ze=i("p"),Ze.innerHTML=da,ds=l(),r(ze.$$.fragment),us=l(),Qe=i("p"),Qe.innerHTML=ua,ms=l(),Se=i("p"),Se.innerHTML=ma,fs=l(),Ye=i("p"),Ye.innerHTML=fa,ys=l(),De=i("p"),this.h()},l(e){const t=ja("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(s),Ee=n(e),Ge=o(e,"P",{}),ya(Ge).forEach(s),Re=n(e),h(j.$$.fragment,e),Fe=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1sx6iox"&&(x.innerHTML=bs),Be=n(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1fbyaxi"&&(v.innerHTML=ws),Pe=n(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1webo38"&&(U.innerHTML=Ts),Ve=n(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-rwwaij"&&(J.textContent=js),Xe=n(e),h(C.$$.fragment,e),Oe=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1tugr7p"&&($.innerHTML=xs),Ke=n(e),h(k.$$.fragment,e),et=n(e),h(I.$$.fragment,e),tt=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-18ejjqs"&&(N.textContent=vs),st=n(e),h(W.$$.fragment,e),at=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1jsn8wa"&&(H.innerHTML=Us),lt=n(e),h(L.$$.fragment,e),nt=n(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1c1mr12"&&(_.innerHTML=Js),it=n(e),h(q.$$.fragment,e),ot=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1xz16k"&&(Z.textContent=Cs),pt=n(e),h(z.$$.fragment,e),rt=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1mvdyro"&&(Q.innerHTML=$s),ht=n(e),h(S.$$.fragment,e),ct=n(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-k1rlzh"&&(Y.textContent=ks),dt=n(e),h(A.$$.fragment,e),ut=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-11rdezd"&&(G.textContent=Is),mt=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1o56zbf"&&(D.textContent=Ns),ft=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-ts3or1"&&(E.textContent=Ws),yt=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-fipl47"&&(R.innerHTML=Hs),gt=n(e),M=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(M)!=="svelte-sk0ezl"&&(M.innerHTML=Ls),Mt=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-yyvm6u"&&(F.textContent=_s),bt=n(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-p686we"&&(B.textContent=qs),wt=n(e),h(P.$$.fragment,e),Tt=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-hz24qn"&&(V.innerHTML=Zs),jt=n(e),h(X.$$.fragment,e),xt=n(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1mvdyro"&&(O.innerHTML=zs),vt=n(e),h(K.$$.fragment,e),Ut=n(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-kbnmt8"&&(ee.textContent=Qs),Jt=n(e),h(te.$$.fragment,e),Ct=n(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-7botfj"&&(se.innerHTML=Ss),$t=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-csh5dy"&&(ae.textContent=Ys),kt=n(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-bqfzrn"&&(b.innerHTML=As),It=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-6zblrj"&&(le.textContent=Gs),Nt=n(e),w=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-1t2za6k"&&(w.innerHTML=Ds),Wt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-7t6r33"&&(ne.innerHTML=Es),Ht=n(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-1sstogo"&&(T.innerHTML=Rs),Lt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1jgbk0j"&&(ie.textContent=Fs),_t=n(e),h(oe.$$.fragment,e),qt=n(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-5rskgo"&&(pe.textContent=Bs),Zt=n(e),h(re.$$.fragment,e),zt=n(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1n5euwf"&&(he.innerHTML=Ps),Qt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-a6zngd"&&(ce.textContent=Vs),St=n(e),h(de.$$.fragment,e),Yt=n(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1g1l39x"&&(ue.innerHTML=Xs),At=n(e),h(me.$$.fragment,e),Gt=n(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1fons3v"&&(fe.textContent=Os),Dt=n(e),h(ye.$$.fragment,e),Et=n(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1mvdyro"&&(ge.innerHTML=Ks),Rt=n(e),h(Me.$$.fragment,e),Ft=n(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1044ak6"&&(be.innerHTML=ea),Bt=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-857vsk"&&(we.textContent=ta),Pt=n(e),h(Te.$$.fragment,e),Vt=n(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1wf33gz"&&(je.innerHTML=sa),Xt=n(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1bub4i"&&(xe.textContent=aa),Ot=n(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-xv3v8"&&(ve.innerHTML=la),Kt=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-yr149b"&&(Ue.textContent=na),es=n(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1osll5p"&&(Je.innerHTML=ia),ts=n(e),h(Ce.$$.fragment,e),ss=n(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-18w9coi"&&($e.innerHTML=oa),as=n(e),h(ke.$$.fragment,e),ls=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-163k6s1"&&(Ie.innerHTML=pa),ns=n(e),h(Ne.$$.fragment,e),is=n(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1mvdyro"&&(We.innerHTML=ra),os=n(e),h(He.$$.fragment,e),ps=n(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1slv1zu"&&(Le.textContent=ha),rs=n(e),h(_e.$$.fragment,e),hs=n(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-125h3os"&&(qe.textContent=ca),cs=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-elwwua"&&(Ze.innerHTML=da),ds=n(e),h(ze.$$.fragment,e),us=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-1b8ovtt"&&(Qe.innerHTML=ua),ms=n(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1dkp3zb"&&(Se.innerHTML=ma),fs=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-nfuday"&&(Ye.innerHTML=fa),ys=n(e),De=o(e,"P",{}),ya(De).forEach(s),this.h()},h(){Ae(y,"name","hf:doc:metadata"),Ae(y,"content",Ua),Ae(M,"class","flex justify-center"),Ae(b,"class","flex justify-center"),Ae(w,"class","flex justify-center"),Ae(T,"class","flex justify-center")},m(e,t){xa(document.head,y),a(e,Ee,t),a(e,Ge,t),a(e,Re,t),c(j,e,t),a(e,Fe,t),a(e,x,t),a(e,Be,t),a(e,v,t),a(e,Pe,t),a(e,U,t),a(e,Ve,t),a(e,J,t),a(e,Xe,t),c(C,e,t),a(e,Oe,t),a(e,$,t),a(e,Ke,t),c(k,e,t),a(e,et,t),c(I,e,t),a(e,tt,t),a(e,N,t),a(e,st,t),c(W,e,t),a(e,at,t),a(e,H,t),a(e,lt,t),c(L,e,t),a(e,nt,t),a(e,_,t),a(e,it,t),c(q,e,t),a(e,ot,t),a(e,Z,t),a(e,pt,t),c(z,e,t),a(e,rt,t),a(e,Q,t),a(e,ht,t),c(S,e,t),a(e,ct,t),a(e,Y,t),a(e,dt,t),c(A,e,t),a(e,ut,t),a(e,G,t),a(e,mt,t),a(e,D,t),a(e,ft,t),a(e,E,t),a(e,yt,t),a(e,R,t),a(e,gt,t),a(e,M,t),a(e,Mt,t),a(e,F,t),a(e,bt,t),a(e,B,t),a(e,wt,t),c(P,e,t),a(e,Tt,t),a(e,V,t),a(e,jt,t),c(X,e,t),a(e,xt,t),a(e,O,t),a(e,vt,t),c(K,e,t),a(e,Ut,t),a(e,ee,t),a(e,Jt,t),c(te,e,t),a(e,Ct,t),a(e,se,t),a(e,$t,t),a(e,ae,t),a(e,kt,t),a(e,b,t),a(e,It,t),a(e,le,t),a(e,Nt,t),a(e,w,t),a(e,Wt,t),a(e,ne,t),a(e,Ht,t),a(e,T,t),a(e,Lt,t),a(e,ie,t),a(e,_t,t),c(oe,e,t),a(e,qt,t),a(e,pe,t),a(e,Zt,t),c(re,e,t),a(e,zt,t),a(e,he,t),a(e,Qt,t),a(e,ce,t),a(e,St,t),c(de,e,t),a(e,Yt,t),a(e,ue,t),a(e,At,t),c(me,e,t),a(e,Gt,t),a(e,fe,t),a(e,Dt,t),c(ye,e,t),a(e,Et,t),a(e,ge,t),a(e,Rt,t),c(Me,e,t),a(e,Ft,t),a(e,be,t),a(e,Bt,t),a(e,we,t),a(e,Pt,t),c(Te,e,t),a(e,Vt,t),a(e,je,t),a(e,Xt,t),a(e,xe,t),a(e,Ot,t),a(e,ve,t),a(e,Kt,t),a(e,Ue,t),a(e,es,t),a(e,Je,t),a(e,ts,t),c(Ce,e,t),a(e,ss,t),a(e,$e,t),a(e,as,t),c(ke,e,t),a(e,ls,t),a(e,Ie,t),a(e,ns,t),c(Ne,e,t),a(e,is,t),a(e,We,t),a(e,os,t),c(He,e,t),a(e,ps,t),a(e,Le,t),a(e,rs,t),c(_e,e,t),a(e,hs,t),a(e,qe,t),a(e,cs,t),a(e,Ze,t),a(e,ds,t),c(ze,e,t),a(e,us,t),a(e,Qe,t),a(e,ms,t),a(e,Se,t),a(e,fs,t),a(e,Ye,t),a(e,ys,t),a(e,De,t),gs=!0},p:Ma,i(e){gs||(d(j.$$.fragment,e),d(C.$$.fragment,e),d(k.$$.fragment,e),d(I.$$.fragment,e),d(W.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(z.$$.fragment,e),d(S.$$.fragment,e),d(A.$$.fragment,e),d(P.$$.fragment,e),d(X.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(de.$$.fragment,e),d(me.$$.fragment,e),d(ye.$$.fragment,e),d(Me.$$.fragment,e),d(Te.$$.fragment,e),d(Ce.$$.fragment,e),d(ke.$$.fragment,e),d(Ne.$$.fragment,e),d(He.$$.fragment,e),d(_e.$$.fragment,e),d(ze.$$.fragment,e),gs=!0)},o(e){u(j.$$.fragment,e),u(C.$$.fragment,e),u(k.$$.fragment,e),u(I.$$.fragment,e),u(W.$$.fragment,e),u(L.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(S.$$.fragment,e),u(A.$$.fragment,e),u(P.$$.fragment,e),u(X.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(ye.$$.fragment,e),u(Me.$$.fragment,e),u(Te.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),u(Ne.$$.fragment,e),u(He.$$.fragment,e),u(_e.$$.fragment,e),u(ze.$$.fragment,e),gs=!1},d(e){e&&(s(Ee),s(Ge),s(Re),s(Fe),s(x),s(Be),s(v),s(Pe),s(U),s(Ve),s(J),s(Xe),s(Oe),s($),s(Ke),s(et),s(tt),s(N),s(st),s(at),s(H),s(lt),s(nt),s(_),s(it),s(ot),s(Z),s(pt),s(rt),s(Q),s(ht),s(ct),s(Y),s(dt),s(ut),s(G),s(mt),s(D),s(ft),s(E),s(yt),s(R),s(gt),s(M),s(Mt),s(F),s(bt),s(B),s(wt),s(Tt),s(V),s(jt),s(xt),s(O),s(vt),s(Ut),s(ee),s(Jt),s(Ct),s(se),s($t),s(ae),s(kt),s(b),s(It),s(le),s(Nt),s(w),s(Wt),s(ne),s(Ht),s(T),s(Lt),s(ie),s(_t),s(qt),s(pe),s(Zt),s(zt),s(he),s(Qt),s(ce),s(St),s(Yt),s(ue),s(At),s(Gt),s(fe),s(Dt),s(Et),s(ge),s(Rt),s(Ft),s(be),s(Bt),s(we),s(Pt),s(Vt),s(je),s(Xt),s(xe),s(Ot),s(ve),s(Kt),s(Ue),s(es),s(Je),s(ts),s(ss),s($e),s(as),s(ls),s(Ie),s(ns),s(is),s(We),s(os),s(ps),s(Le),s(rs),s(hs),s(qe),s(cs),s(Ze),s(ds),s(us),s(Qe),s(ms),s(Se),s(fs),s(Ye),s(ys),s(De)),s(y),m(j,e),m(C,e),m(k,e),m(I,e),m(W,e),m(L,e),m(q,e),m(z,e),m(S,e),m(A,e),m(P,e),m(X,e),m(K,e),m(te,e),m(oe,e),m(re,e),m(de,e),m(me,e),m(ye,e),m(Me,e),m(Te,e),m(Ce,e),m(ke,e),m(Ne,e),m(He,e),m(_e,e),m(ze,e)}}}const Ua='{"title":"Pre-trained models and datasets for audio classification","local":"pre-trained-models-and-datasets-for-audio-classification","sections":[{"title":"🤗 Transformers Installation","local":"-transformers-installation","sections":[],"depth":2},{"title":"Keyword Spotting","local":"keyword-spotting","sections":[{"title":"Minds-14","local":"minds-14","sections":[],"depth":3},{"title":"Speech Commands","local":"speech-commands","sections":[],"depth":3}],"depth":2},{"title":"Language Identification","local":"language-identification","sections":[{"title":"FLEURS","local":"fleurs","sections":[],"depth":3}],"depth":2},{"title":"Zero-Shot Audio Classification","local":"zero-shot-audio-classification","sections":[],"depth":2},{"title":"What next?","local":"what-next","sections":[],"depth":2}],"depth":1}';function Ja(Ms){return ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Na extends wa{constructor(y){super(),Ta(this,y,Ja,va,ga,{})}}export{Na as component};
