import{s as Zs,f as bl,n as Rs,o as Ss}from"../chunks/scheduler.37c15a92.js";import{S as zs,i as Ys,g as o,s as n,r as p,A as Qs,h as a,f as l,c as i,j as vl,u as r,x as M,k as y,y as gl,a as s,v as w,d as u,t as T,w as c}from"../chunks/index.2bf4358c.js";import{C as m}from"../chunks/CodeBlock.4f5fc1ad.js";import{H as Qt}from"../chunks/Heading.8ada512a.js";import{E as Xs}from"../chunks/EditOnGithub.9958bcdc.js";function Vs(Bl){let J,Nt,Vt,Pt,j,Ft,d,xl,Dt,I,_l="One crucial aspect of AI Agents is their ability to take <strong>actions</strong>. As we saw, this happens through the use of <strong>Tools</strong>.",Kt,U,Hl="In this section, we’ll learn what Tools are, how to design them effectively, and how to integrate them into your Agent via the System Message.",Ot,f,Gl="By giving your Agent the right Tools—and clearly describing how those Tools work—you can dramatically increase what your AI can accomplish. Let’s dive in!",te,C,ee,b,Ll="A <strong>Tool is a function given to the LLM</strong>. This function should fulfill a <strong>clear objective</strong>.",le,A,Wl="Here are some commonly used tools in AI agents:",se,v,$l="<thead><tr><th>Tool</th> <th>Description</th></tr></thead> <tbody><tr><td>Web Search</td> <td>Allows the agent to fetch up-to-date information from the internet.</td></tr> <tr><td>Image Generation</td> <td>Creates images based on text descriptions.</td></tr> <tr><td>Retrieval</td> <td>Retrieves information from an external source.</td></tr> <tr><td>API Interface</td> <td>Interacts with an external API (GitHub, YouTube, Spotify, etc.).</td></tr></tbody>",ne,g,kl="Those are only examples, as you can in fact create a tool for any use case!",ie,B,El="A good tool should be something that <strong>complements the power of an LLM</strong>.",oe,x,Zl="For instance, if you need to perform arithmetic, giving a <strong>calculator tool</strong> to your LLM will provide better results than relying on the native capabilities of the model.",ae,_,Rl="Furthermore, <strong>LLMs predict the completion of a prompt based on their training data</strong>, which means that their internal knowledge only includes events prior to their training. Therefore, if your agent needs up-to-date data you must provide it through some tool.",Me,H,Sl="For instance, if you ask an LLM directly (without a search tool) for today’s weather, the LLM will potentially hallucinate random weather.",pe,G,zl,re,L,Yl="<li><p>A Tool should contain:</p> <ul><li>A <strong>textual description of what the function does</strong>.</li> <li>A <em>Callable</em> (something to perform an action).</li> <li><em>Arguments</em> with typings.</li> <li>(Optional) Outputs with typings.</li></ul></li>",we,W,ue,$,Ql="LLMs, as we saw, can only receive text inputs and generate text outputs. They have no way to call tools on their own. What we mean when we talk about <em>providing tools to an Agent</em>, is that we <strong>teach</strong> the LLM about the existence of tools, and ask the model to generate text that will invoke tools when it needs to. For example, if we provide a tool to check the weather at a location from the Internet, and then ask the LLM about the weather in Paris, the LLM will recognize that question as a relevant opportunity to use the “weather” tool we taught it about. The LLM will generate <em>text</em>, in the form of code, to invoke that tool. It is the responsibility of the <strong>Agent</strong> to parse the LLM’s output, recognize that a tool call is required, and invoke the tool on the LLM’s behalf. The output from the tool will then be sent back to the LLM, which will compose its final response for the user.",Te,k,Xl="The output from a tool call is another type of message in the conversation. Tool calling steps are typically not shown to the user: the Agent retrieves the conversation, calls the tool(s), gets the outputs, adds them as a new conversation message, and sends the updated conversation to the LLM again. From the user’s point of view, it’s like the LLM had used the tool, but in fact it was our application code (the <strong>Agent</strong>) who did it.",ce,E,Vl="We’ll talk a lot more about this process in future sessions.",ye,Z,Je,R,ql="The complete answer may seem overwhelming, but we essentially use the system prompt to provide textual descriptions of available tools to the model:",me,S,Nl,he,z,Pl="For this to work, we have to be very precise and accurate about:",je,Y,Fl="<li><strong>What the tool does</strong></li> <li><strong>What exact inputs it expects</strong></li>",de,Q,Dl="This is the reason why tool descriptions are usually provided using expressive but precise structures, such as computer languages or JSON. It’s not <em>necessary</em> to do it like that, any precise and coherent format would work.",Ie,X,Kl="If this seems too theoretical, let’s understand it through a concrete example.",Ue,V,Ol="We will implement a simplified <strong>calculator</strong> tool that will just multiply two integers. This could be our Python implementation:",fe,q,Ce,N,ts="So our tool is called <code>calculator</code>, it <strong>multiplies two integers</strong>, and it requires the following inputs:",be,P,es="<li><strong><code>a</code></strong> (<em>int</em>): An integer.</li> <li><strong><code>b</code></strong> (<em>int</em>): An integer.</li>",Ae,F,ls="The output of the tool is another integer number that we can describe like this:",ve,D,ss="<li>(<em>int</em>): The product of <code>a</code> and <code>b</code>.</li>",ge,K,ns="All of these details are important. Let’s put them together in a text string that describes our tool for the LLM to understand.",Be,O,xe,tt,is="<p><strong>Reminder:</strong> This textual description is <em>what we want the LLM to know about the tool</em>.</p>",_e,et,os="When we pass the previous string as part of the input to the LLM, the model will recognize it as a tool, and will know what it needs to pass as inputs and what to expect from the output.",He,lt,as="If we want to provide additional tools, we must be consistent and always use the same format. This process can be fragile, and we might accidentally overlook some details.",Ge,st,Ms="Is there a better way?",Le,nt,We,it,ps="Our tool was written in Python, and the implementation already provides everything we need:",$e,ot,rs="<li>A descriptive name of what it does: <code>calculator</code></li> <li>A longer description, provided by the function’s docstring comment: <code>Multiply two integers.</code></li> <li>The inputs and their type: the function clearly expects two <code>int</code>s.</li> <li>The type of the output.</li>",ke,at,ws="There’s a reason people use programming languages: they are expressive, concise, and precise.",Ee,Mt,us="We could provide the Python source code as the <em>specification</em> of the tool for the LLM, but the way the tool is implemented does not matter. All that matters is its name, what it does, the inputs it expects and the output it provides.",Ze,pt,Ts="We will leverage Python’s introspection features to leverage the source code and build a tool description automatically for us. All we need is that the tool implementation uses type hints, docstrings, and sensible function names. We will write some code to extract the relevant portions from the source code.",Re,rt,cs="After we are done, we’ll only need to use a Python decorator to indicate that the <code>calculator</code> function is a tool:",Se,wt,ze,ut,ys="Note the <code>@tool</code> decorator before the function definition.",Ye,Tt,Js="With the implementation we’ll see next, we will be able to retrieve the following text automatically from the source code via the <code>to_string()</code> function provided by the decorator:",Qe,ct,Xe,yt,ms="As you can see, it’s the same thing we wrote manually before!",Ve,Jt,qe,mt,hs="We create a generic <code>Tool</code> class that we can reuse whenever we need to use a tool.",Ne,ht,js="<p><strong>Disclaimer:</strong> This example implementation is fictional but closely resembles real implementations in most libraries.</p>",Pe,jt,Fe,dt,ds="It may seem complicated, but if we go slowly through it we can see what it does. We define a <strong><code>Tool</code></strong> class that includes:",De,It,Is="<li><strong><code>name</code></strong> (<em>str</em>): The name of the tool.</li> <li><strong><code>description</code></strong> (<em>str</em>): A brief description of what the tool does.</li> <li><strong><code>function</code></strong> (<em>callable</em>): The function the tool executes.</li> <li><strong><code>arguments</code></strong> (<em>list</em>): The expected input parameters.</li> <li><strong><code>outputs</code></strong> (<em>str</em> or <em>list</em>): The expected outputs of the tool.</li> <li><strong><code>__call__()</code></strong>: Calls the function when the tool instance is invoked.</li> <li><strong><code>to_string()</code></strong>: Converts the tool’s attributes into a textual representation.</li>",Ke,Ut,Us="We could create a Tool with this class using code like the following:",Oe,ft,tl,Ct,fs="But we can also use Python’s <code>inspect</code> module to retrieve all the information for us! This is what the <code>@tool</code> decorator does.",el,bt,Cs="<p>If you are interested, you can disclose the following section to look at the decorator implementation.</p>",ll,h,Xt,bs="decorator code",Al,At,sl,vt,As="Just to reiterate, with this decorator in place we can implement our tool like this:",nl,gt,il,Bt,vs="And we can use the <code>Tool</code>’s <code>to_string</code> method to automatically retrieve a text suitable to be used as a tool description for an LLM:",ol,xt,al,_t,gs="The description is <strong>injected</strong> in the system prompt. Taking the example with which we started this section, here is how it would look like after replacing the <code>tools_description</code>:",Ml,Ht,Bs,pl,Gt,xs='In the <a href="actions">Actions</a> section, we will learn more about how an Agent can <strong>Call</strong> this tool we just created.',rl,Lt,wl,Wt,_s=`Model Context Protocol (MCP) is an <strong>open protocol</strong> that standardizes how applications <strong>provide tools to LLMs</strong>.
MCP provides:`,ul,$t,Hs="<li>A growing list of pre-built integrations that your LLM can directly plug into</li> <li>The flexibility to switch between LLM providers and vendors</li> <li>Best practices for securing your data within your infrastructure</li>",Tl,kt,Gs="This means that <strong>any framework implementing MCP can leverage tools defined within the protocol</strong>, eliminating the need to reimplement the same tool interface for each framework.",cl,yl,Jl,Et,Ls="Tools play a crucial role in enhancing the capabilities of AI agents.",ml,Zt,Ws="To summarize, we learned:",hl,Rt,$s="<li><p><em>What Tools Are</em>: Functions that give LLMs extra capabilities, such as performing calculations or accessing external data.</p></li> <li><p><em>How to Define a Tool</em>: By providing a clear textual description, inputs, outputs, and a callable function.</p></li> <li><p><em>Why Tools Are Essential</em>: They enable Agents to overcome the limitations of static model training, handle real-time tasks, and perform specialized actions.</p></li>",jl,St,ks='Now, we can move on to the <a href="agent-steps-and-structure">Agent Workflow</a> where you’ll see how an Agent observes, thinks, and acts. This <strong>brings together everything we’ve covered so far</strong> and sets the stage for creating your own fully functional AI Agent.',dl,zt,Es="But first, it’s time for another short quiz!",Il,Yt,Ul,qt,fl;return j=new Qt({props:{title:"What are Tools?",local:"what-are-tools",headingTag:"h1"}}),C=new Qt({props:{title:"What are AI Tools?",local:"what-are-ai-tools",headingTag:"h2"}}),W=new Qt({props:{title:"How do tools work?",local:"how-do-tools-work",headingTag:"h2"}}),Z=new Qt({props:{title:"How do we give tools to an LLM?",local:"how-do-we-give-tools-to-an-llm",headingTag:"h2"}}),q=new m({props:{code:"ZGVmJTIwY2FsY3VsYXRvcihhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyTXVsdGlwbHklMjB0d28lMjBpbnRlZ2Vycy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwKiUyMGI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b`,wrap:!1}}),O=new m({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),nt=new Qt({props:{title:"Auto-formatting Tool sections",local:"auto-formatting-tool-sections",headingTag:"h3"}}),wt=new m({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),ct=new m({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),Jt=new Qt({props:{title:"Generic Tool implementation",local:"generic-tool-implementation",headingTag:"h3"}}),jt=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    A class representing a reusable piece of code (Tool).

    Attributes:
        name (str): Name of the tool.
        description (str): A textual description of what the tool does.
        func (callable): The function this tool wraps.
        arguments (list): A list of argument.
        outputs (str or list): The return type(s) of the wrapped function.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self,
                 name: <span class="hljs-built_in">str</span>,
                 description: <span class="hljs-built_in">str</span>,
                 func: <span class="hljs-built_in">callable</span>,
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return a string representation of the tool,
        including its name, description, arguments, and outputs.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])

        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Tool Name: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Description: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Arguments: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Outputs: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Invoke the underlying function (callable) with provided arguments.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),ft=new m({props:{code:"Y2FsY3VsYXRvcl90b29sJTIwJTNEJTIwVG9vbCglMEElMjAlMjAlMjAlMjAlMjJjYWxjdWxhdG9yJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbmFtZSUwQSUyMCUyMCUyMCUyMCUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZGVzY3JpcHRpb24lMEElMjAlMjAlMjAlMjBjYWxjdWxhdG9yJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZnVuY3Rpb24lMjB0byUyMGNhbGwlMEElMjAlMjAlMjAlMjAlNUIoJTIyYSUyMiUyQyUyMCUyMmludCUyMiklMkMlMjAoJTIyYiUyMiUyQyUyMCUyMmludCUyMiklNUQlMkMlMjAlMjAlMjAlMjMlMjBpbnB1dHMlMjAobmFtZXMlMjBhbmQlMjB0eXBlcyklMEElMjAlMjAlMjAlMjAlMjJpbnQlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBvdXRwdXQlMEEp",highlighted:`calculator_tool = Tool(
    <span class="hljs-string">&quot;calculator&quot;</span>,                   <span class="hljs-comment"># name</span>
    <span class="hljs-string">&quot;Multiply two integers.&quot;</span>,       <span class="hljs-comment"># description</span>
    calculator,                     <span class="hljs-comment"># function to call</span>
    [(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>), (<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>)],   <span class="hljs-comment"># inputs (names and types)</span>
    <span class="hljs-string">&quot;int&quot;</span>,                          <span class="hljs-comment"># output</span>
)`,wrap:!1}}),At=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A decorator that creates a Tool instance from the given function.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Get the function signature</span>
    signature = inspect.signature(func)

    <span class="hljs-comment"># Extract (param_name, param_annotation) pairs for inputs</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>)
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))

    <span class="hljs-comment"># Determine the return annotation</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;No return annotation&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>)
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )

    <span class="hljs-comment"># Use the function&#x27;s docstring as the description (default if None)</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No description provided.&quot;</span>

    <span class="hljs-comment"># The function name becomes the Tool name</span>
    name = func.__name__

    <span class="hljs-comment"># Return a new Tool instance</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name,
        description=description,
        func=func,
        arguments=arguments,
        outputs=outputs
    )`,wrap:!1}}),gt=new m({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),xt=new m({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),Lt=new Qt({props:{title:"Model Context Protocol (MCP): a unified tool interface",local:"model-context-protocol-mcp-a-unified-tool-interface",headingTag:"h3"}}),Yt=new Xs({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tools.mdx"}}),{c(){J=o("meta"),Nt=n(),Vt=o("p"),Pt=n(),p(j.$$.fragment),Ft=n(),d=o("img"),Dt=n(),I=o("p"),I.innerHTML=_l,Kt=n(),U=o("p"),U.textContent=Hl,Ot=n(),f=o("p"),f.textContent=Gl,te=n(),p(C.$$.fragment),ee=n(),b=o("p"),b.innerHTML=Ll,le=n(),A=o("p"),A.textContent=Wl,se=n(),v=o("table"),v.innerHTML=$l,ne=n(),g=o("p"),g.textContent=kl,ie=n(),B=o("p"),B.innerHTML=El,oe=n(),x=o("p"),x.innerHTML=Zl,ae=n(),_=o("p"),_.innerHTML=Rl,Me=n(),H=o("p"),H.textContent=Sl,pe=n(),G=o("img"),re=n(),L=o("ul"),L.innerHTML=Yl,we=n(),p(W.$$.fragment),ue=n(),$=o("p"),$.innerHTML=Ql,Te=n(),k=o("p"),k.innerHTML=Xl,ce=n(),E=o("p"),E.textContent=Vl,ye=n(),p(Z.$$.fragment),Je=n(),R=o("p"),R.textContent=ql,me=n(),S=o("img"),he=n(),z=o("p"),z.textContent=Pl,je=n(),Y=o("ol"),Y.innerHTML=Fl,de=n(),Q=o("p"),Q.innerHTML=Dl,Ie=n(),X=o("p"),X.textContent=Kl,Ue=n(),V=o("p"),V.innerHTML=Ol,fe=n(),p(q.$$.fragment),Ce=n(),N=o("p"),N.innerHTML=ts,be=n(),P=o("ul"),P.innerHTML=es,Ae=n(),F=o("p"),F.textContent=ls,ve=n(),D=o("ul"),D.innerHTML=ss,ge=n(),K=o("p"),K.textContent=ns,Be=n(),p(O.$$.fragment),xe=n(),tt=o("blockquote"),tt.innerHTML=is,_e=n(),et=o("p"),et.textContent=os,He=n(),lt=o("p"),lt.textContent=as,Ge=n(),st=o("p"),st.textContent=Ms,Le=n(),p(nt.$$.fragment),We=n(),it=o("p"),it.textContent=ps,$e=n(),ot=o("ul"),ot.innerHTML=rs,ke=n(),at=o("p"),at.textContent=ws,Ee=n(),Mt=o("p"),Mt.innerHTML=us,Ze=n(),pt=o("p"),pt.textContent=Ts,Re=n(),rt=o("p"),rt.innerHTML=cs,Se=n(),p(wt.$$.fragment),ze=n(),ut=o("p"),ut.innerHTML=ys,Ye=n(),Tt=o("p"),Tt.innerHTML=Js,Qe=n(),p(ct.$$.fragment),Xe=n(),yt=o("p"),yt.textContent=ms,Ve=n(),p(Jt.$$.fragment),qe=n(),mt=o("p"),mt.innerHTML=hs,Ne=n(),ht=o("blockquote"),ht.innerHTML=js,Pe=n(),p(jt.$$.fragment),Fe=n(),dt=o("p"),dt.innerHTML=ds,De=n(),It=o("ul"),It.innerHTML=Is,Ke=n(),Ut=o("p"),Ut.textContent=Us,Oe=n(),p(ft.$$.fragment),tl=n(),Ct=o("p"),Ct.innerHTML=fs,el=n(),bt=o("blockquote"),bt.innerHTML=Cs,ll=n(),h=o("details"),Xt=o("summary"),Xt.textContent=bs,Al=n(),p(At.$$.fragment),sl=n(),vt=o("p"),vt.textContent=As,nl=n(),p(gt.$$.fragment),il=n(),Bt=o("p"),Bt.innerHTML=vs,ol=n(),p(xt.$$.fragment),al=n(),_t=o("p"),_t.innerHTML=gs,Ml=n(),Ht=o("img"),pl=n(),Gt=o("p"),Gt.innerHTML=xs,rl=n(),p(Lt.$$.fragment),wl=n(),Wt=o("p"),Wt.innerHTML=_s,ul=n(),$t=o("ul"),$t.innerHTML=Hs,Tl=n(),kt=o("p"),kt.innerHTML=Gs,cl=n(),yl=o("hr"),Jl=n(),Et=o("p"),Et.textContent=Ls,ml=n(),Zt=o("p"),Zt.textContent=Ws,hl=n(),Rt=o("ul"),Rt.innerHTML=$s,jl=n(),St=o("p"),St.innerHTML=ks,dl=n(),zt=o("p"),zt.textContent=Es,Il=n(),p(Yt.$$.fragment),Ul=n(),qt=o("p"),this.h()},l(t){const e=Qs("svelte-u9bgzb",document.head);J=a(e,"META",{name:!0,content:!0}),e.forEach(l),Nt=i(t),Vt=a(t,"P",{}),vl(Vt).forEach(l),Pt=i(t),r(j.$$.fragment,t),Ft=i(t),d=a(t,"IMG",{src:!0,alt:!0}),Dt=i(t),I=a(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-12q0l6c"&&(I.innerHTML=_l),Kt=i(t),U=a(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-vccz0n"&&(U.textContent=Hl),Ot=i(t),f=a(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-g748wk"&&(f.textContent=Gl),te=i(t),r(C.$$.fragment,t),ee=i(t),b=a(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-d0memu"&&(b.innerHTML=Ll),le=i(t),A=a(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1bnicmb"&&(A.textContent=Wl),se=i(t),v=a(t,"TABLE",{"data-svelte-h":!0}),M(v)!=="svelte-1r7ovsn"&&(v.innerHTML=$l),ne=i(t),g=a(t,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1fuccdy"&&(g.textContent=kl),ie=i(t),B=a(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-178hc7g"&&(B.innerHTML=El),oe=i(t),x=a(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1redoxr"&&(x.innerHTML=Zl),ae=i(t),_=a(t,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1v1ck09"&&(_.innerHTML=Rl),Me=i(t),H=a(t,"P",{"data-svelte-h":!0}),M(H)!=="svelte-mz2far"&&(H.textContent=Sl),pe=i(t),G=a(t,"IMG",{src:!0,alt:!0}),re=i(t),L=a(t,"UL",{"data-svelte-h":!0}),M(L)!=="svelte-gj3em1"&&(L.innerHTML=Yl),we=i(t),r(W.$$.fragment,t),ue=i(t),$=a(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-bf3q0z"&&($.innerHTML=Ql),Te=i(t),k=a(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-19cyzqu"&&(k.innerHTML=Xl),ce=i(t),E=a(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1gym7on"&&(E.textContent=Vl),ye=i(t),r(Z.$$.fragment,t),Je=i(t),R=a(t,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1m76tol"&&(R.textContent=ql),me=i(t),S=a(t,"IMG",{src:!0,alt:!0}),he=i(t),z=a(t,"P",{"data-svelte-h":!0}),M(z)!=="svelte-e466s4"&&(z.textContent=Pl),je=i(t),Y=a(t,"OL",{"data-svelte-h":!0}),M(Y)!=="svelte-12vrnnv"&&(Y.innerHTML=Fl),de=i(t),Q=a(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1lxlzbg"&&(Q.innerHTML=Dl),Ie=i(t),X=a(t,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1p033lp"&&(X.textContent=Kl),Ue=i(t),V=a(t,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1if40sb"&&(V.innerHTML=Ol),fe=i(t),r(q.$$.fragment,t),Ce=i(t),N=a(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-somofk"&&(N.innerHTML=ts),be=i(t),P=a(t,"UL",{"data-svelte-h":!0}),M(P)!=="svelte-1qi2vj"&&(P.innerHTML=es),Ae=i(t),F=a(t,"P",{"data-svelte-h":!0}),M(F)!=="svelte-z90coj"&&(F.textContent=ls),ve=i(t),D=a(t,"UL",{"data-svelte-h":!0}),M(D)!=="svelte-1rd1o27"&&(D.innerHTML=ss),ge=i(t),K=a(t,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1gl47rm"&&(K.textContent=ns),Be=i(t),r(O.$$.fragment,t),xe=i(t),tt=a(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(tt)!=="svelte-jn5onw"&&(tt.innerHTML=is),_e=i(t),et=a(t,"P",{"data-svelte-h":!0}),M(et)!=="svelte-dd2uu2"&&(et.textContent=os),He=i(t),lt=a(t,"P",{"data-svelte-h":!0}),M(lt)!=="svelte-1ec16zo"&&(lt.textContent=as),Ge=i(t),st=a(t,"P",{"data-svelte-h":!0}),M(st)!=="svelte-xhigt1"&&(st.textContent=Ms),Le=i(t),r(nt.$$.fragment,t),We=i(t),it=a(t,"P",{"data-svelte-h":!0}),M(it)!=="svelte-xwh6nk"&&(it.textContent=ps),$e=i(t),ot=a(t,"UL",{"data-svelte-h":!0}),M(ot)!=="svelte-1mufwba"&&(ot.innerHTML=rs),ke=i(t),at=a(t,"P",{"data-svelte-h":!0}),M(at)!=="svelte-6ogn9l"&&(at.textContent=ws),Ee=i(t),Mt=a(t,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-2908e6"&&(Mt.innerHTML=us),Ze=i(t),pt=a(t,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-1nshzlk"&&(pt.textContent=Ts),Re=i(t),rt=a(t,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-1iag2er"&&(rt.innerHTML=cs),Se=i(t),r(wt.$$.fragment,t),ze=i(t),ut=a(t,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-1xfdhk0"&&(ut.innerHTML=ys),Ye=i(t),Tt=a(t,"P",{"data-svelte-h":!0}),M(Tt)!=="svelte-hj3bkt"&&(Tt.innerHTML=Js),Qe=i(t),r(ct.$$.fragment,t),Xe=i(t),yt=a(t,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-ah55dy"&&(yt.textContent=ms),Ve=i(t),r(Jt.$$.fragment,t),qe=i(t),mt=a(t,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-1g4lbet"&&(mt.innerHTML=hs),Ne=i(t),ht=a(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(ht)!=="svelte-17jlnyo"&&(ht.innerHTML=js),Pe=i(t),r(jt.$$.fragment,t),Fe=i(t),dt=a(t,"P",{"data-svelte-h":!0}),M(dt)!=="svelte-1m24zfs"&&(dt.innerHTML=ds),De=i(t),It=a(t,"UL",{"data-svelte-h":!0}),M(It)!=="svelte-1aoag7f"&&(It.innerHTML=Is),Ke=i(t),Ut=a(t,"P",{"data-svelte-h":!0}),M(Ut)!=="svelte-9jg0w0"&&(Ut.textContent=Us),Oe=i(t),r(ft.$$.fragment,t),tl=i(t),Ct=a(t,"P",{"data-svelte-h":!0}),M(Ct)!=="svelte-imjo5d"&&(Ct.innerHTML=fs),el=i(t),bt=a(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(bt)!=="svelte-5gslq7"&&(bt.innerHTML=Cs),ll=i(t),h=a(t,"DETAILS",{});var Cl=vl(h);Xt=a(Cl,"SUMMARY",{"data-svelte-h":!0}),M(Xt)!=="svelte-14wmf42"&&(Xt.textContent=bs),Al=i(Cl),r(At.$$.fragment,Cl),Cl.forEach(l),sl=i(t),vt=a(t,"P",{"data-svelte-h":!0}),M(vt)!=="svelte-1pxgdsn"&&(vt.textContent=As),nl=i(t),r(gt.$$.fragment,t),il=i(t),Bt=a(t,"P",{"data-svelte-h":!0}),M(Bt)!=="svelte-oh725x"&&(Bt.innerHTML=vs),ol=i(t),r(xt.$$.fragment,t),al=i(t),_t=a(t,"P",{"data-svelte-h":!0}),M(_t)!=="svelte-1gsasw4"&&(_t.innerHTML=gs),Ml=i(t),Ht=a(t,"IMG",{src:!0,alt:!0}),pl=i(t),Gt=a(t,"P",{"data-svelte-h":!0}),M(Gt)!=="svelte-14h2jbz"&&(Gt.innerHTML=xs),rl=i(t),r(Lt.$$.fragment,t),wl=i(t),Wt=a(t,"P",{"data-svelte-h":!0}),M(Wt)!=="svelte-123mz07"&&(Wt.innerHTML=_s),ul=i(t),$t=a(t,"UL",{"data-svelte-h":!0}),M($t)!=="svelte-jdb0o1"&&($t.innerHTML=Hs),Tl=i(t),kt=a(t,"P",{"data-svelte-h":!0}),M(kt)!=="svelte-v0j64b"&&(kt.innerHTML=Gs),cl=i(t),yl=a(t,"HR",{}),Jl=i(t),Et=a(t,"P",{"data-svelte-h":!0}),M(Et)!=="svelte-yaz9vn"&&(Et.textContent=Ls),ml=i(t),Zt=a(t,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-1mncb1b"&&(Zt.textContent=Ws),hl=i(t),Rt=a(t,"UL",{"data-svelte-h":!0}),M(Rt)!=="svelte-1lbaznq"&&(Rt.innerHTML=$s),jl=i(t),St=a(t,"P",{"data-svelte-h":!0}),M(St)!=="svelte-16mxhlc"&&(St.innerHTML=ks),dl=i(t),zt=a(t,"P",{"data-svelte-h":!0}),M(zt)!=="svelte-1w2njod"&&(zt.textContent=Es),Il=i(t),r(Yt.$$.fragment,t),Ul=i(t),qt=a(t,"P",{}),vl(qt).forEach(l),this.h()},h(){y(J,"name","hf:doc:metadata"),y(J,"content",qs),bl(d.src,xl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||y(d,"src",xl),y(d,"alt","Unit 1 planning"),bl(G.src,zl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||y(G,"src",zl),y(G,"alt","Weather"),bl(S.src,Nl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||y(S,"src",Nl),y(S,"alt","System prompt for tools"),bl(Ht.src,Bs="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||y(Ht,"src",Bs),y(Ht,"alt","System prompt for tools")},m(t,e){gl(document.head,J),s(t,Nt,e),s(t,Vt,e),s(t,Pt,e),w(j,t,e),s(t,Ft,e),s(t,d,e),s(t,Dt,e),s(t,I,e),s(t,Kt,e),s(t,U,e),s(t,Ot,e),s(t,f,e),s(t,te,e),w(C,t,e),s(t,ee,e),s(t,b,e),s(t,le,e),s(t,A,e),s(t,se,e),s(t,v,e),s(t,ne,e),s(t,g,e),s(t,ie,e),s(t,B,e),s(t,oe,e),s(t,x,e),s(t,ae,e),s(t,_,e),s(t,Me,e),s(t,H,e),s(t,pe,e),s(t,G,e),s(t,re,e),s(t,L,e),s(t,we,e),w(W,t,e),s(t,ue,e),s(t,$,e),s(t,Te,e),s(t,k,e),s(t,ce,e),s(t,E,e),s(t,ye,e),w(Z,t,e),s(t,Je,e),s(t,R,e),s(t,me,e),s(t,S,e),s(t,he,e),s(t,z,e),s(t,je,e),s(t,Y,e),s(t,de,e),s(t,Q,e),s(t,Ie,e),s(t,X,e),s(t,Ue,e),s(t,V,e),s(t,fe,e),w(q,t,e),s(t,Ce,e),s(t,N,e),s(t,be,e),s(t,P,e),s(t,Ae,e),s(t,F,e),s(t,ve,e),s(t,D,e),s(t,ge,e),s(t,K,e),s(t,Be,e),w(O,t,e),s(t,xe,e),s(t,tt,e),s(t,_e,e),s(t,et,e),s(t,He,e),s(t,lt,e),s(t,Ge,e),s(t,st,e),s(t,Le,e),w(nt,t,e),s(t,We,e),s(t,it,e),s(t,$e,e),s(t,ot,e),s(t,ke,e),s(t,at,e),s(t,Ee,e),s(t,Mt,e),s(t,Ze,e),s(t,pt,e),s(t,Re,e),s(t,rt,e),s(t,Se,e),w(wt,t,e),s(t,ze,e),s(t,ut,e),s(t,Ye,e),s(t,Tt,e),s(t,Qe,e),w(ct,t,e),s(t,Xe,e),s(t,yt,e),s(t,Ve,e),w(Jt,t,e),s(t,qe,e),s(t,mt,e),s(t,Ne,e),s(t,ht,e),s(t,Pe,e),w(jt,t,e),s(t,Fe,e),s(t,dt,e),s(t,De,e),s(t,It,e),s(t,Ke,e),s(t,Ut,e),s(t,Oe,e),w(ft,t,e),s(t,tl,e),s(t,Ct,e),s(t,el,e),s(t,bt,e),s(t,ll,e),s(t,h,e),gl(h,Xt),gl(h,Al),w(At,h,null),s(t,sl,e),s(t,vt,e),s(t,nl,e),w(gt,t,e),s(t,il,e),s(t,Bt,e),s(t,ol,e),w(xt,t,e),s(t,al,e),s(t,_t,e),s(t,Ml,e),s(t,Ht,e),s(t,pl,e),s(t,Gt,e),s(t,rl,e),w(Lt,t,e),s(t,wl,e),s(t,Wt,e),s(t,ul,e),s(t,$t,e),s(t,Tl,e),s(t,kt,e),s(t,cl,e),s(t,yl,e),s(t,Jl,e),s(t,Et,e),s(t,ml,e),s(t,Zt,e),s(t,hl,e),s(t,Rt,e),s(t,jl,e),s(t,St,e),s(t,dl,e),s(t,zt,e),s(t,Il,e),w(Yt,t,e),s(t,Ul,e),s(t,qt,e),fl=!0},p:Rs,i(t){fl||(u(j.$$.fragment,t),u(C.$$.fragment,t),u(W.$$.fragment,t),u(Z.$$.fragment,t),u(q.$$.fragment,t),u(O.$$.fragment,t),u(nt.$$.fragment,t),u(wt.$$.fragment,t),u(ct.$$.fragment,t),u(Jt.$$.fragment,t),u(jt.$$.fragment,t),u(ft.$$.fragment,t),u(At.$$.fragment,t),u(gt.$$.fragment,t),u(xt.$$.fragment,t),u(Lt.$$.fragment,t),u(Yt.$$.fragment,t),fl=!0)},o(t){T(j.$$.fragment,t),T(C.$$.fragment,t),T(W.$$.fragment,t),T(Z.$$.fragment,t),T(q.$$.fragment,t),T(O.$$.fragment,t),T(nt.$$.fragment,t),T(wt.$$.fragment,t),T(ct.$$.fragment,t),T(Jt.$$.fragment,t),T(jt.$$.fragment,t),T(ft.$$.fragment,t),T(At.$$.fragment,t),T(gt.$$.fragment,t),T(xt.$$.fragment,t),T(Lt.$$.fragment,t),T(Yt.$$.fragment,t),fl=!1},d(t){t&&(l(Nt),l(Vt),l(Pt),l(Ft),l(d),l(Dt),l(I),l(Kt),l(U),l(Ot),l(f),l(te),l(ee),l(b),l(le),l(A),l(se),l(v),l(ne),l(g),l(ie),l(B),l(oe),l(x),l(ae),l(_),l(Me),l(H),l(pe),l(G),l(re),l(L),l(we),l(ue),l($),l(Te),l(k),l(ce),l(E),l(ye),l(Je),l(R),l(me),l(S),l(he),l(z),l(je),l(Y),l(de),l(Q),l(Ie),l(X),l(Ue),l(V),l(fe),l(Ce),l(N),l(be),l(P),l(Ae),l(F),l(ve),l(D),l(ge),l(K),l(Be),l(xe),l(tt),l(_e),l(et),l(He),l(lt),l(Ge),l(st),l(Le),l(We),l(it),l($e),l(ot),l(ke),l(at),l(Ee),l(Mt),l(Ze),l(pt),l(Re),l(rt),l(Se),l(ze),l(ut),l(Ye),l(Tt),l(Qe),l(Xe),l(yt),l(Ve),l(qe),l(mt),l(Ne),l(ht),l(Pe),l(Fe),l(dt),l(De),l(It),l(Ke),l(Ut),l(Oe),l(tl),l(Ct),l(el),l(bt),l(ll),l(h),l(sl),l(vt),l(nl),l(il),l(Bt),l(ol),l(al),l(_t),l(Ml),l(Ht),l(pl),l(Gt),l(rl),l(wl),l(Wt),l(ul),l($t),l(Tl),l(kt),l(cl),l(yl),l(Jl),l(Et),l(ml),l(Zt),l(hl),l(Rt),l(jl),l(St),l(dl),l(zt),l(Il),l(Ul),l(qt)),l(J),c(j,t),c(C,t),c(W,t),c(Z,t),c(q,t),c(O,t),c(nt,t),c(wt,t),c(ct,t),c(Jt,t),c(jt,t),c(ft,t),c(At),c(gt,t),c(xt,t),c(Lt,t),c(Yt,t)}}}const qs='{"title":"What are Tools?","local":"what-are-tools","sections":[{"title":"What are AI Tools?","local":"what-are-ai-tools","sections":[],"depth":2},{"title":"How do tools work?","local":"how-do-tools-work","sections":[],"depth":2},{"title":"How do we give tools to an LLM?","local":"how-do-we-give-tools-to-an-llm","sections":[{"title":"Auto-formatting Tool sections","local":"auto-formatting-tool-sections","sections":[],"depth":3},{"title":"Generic Tool implementation","local":"generic-tool-implementation","sections":[],"depth":3},{"title":"Model Context Protocol (MCP): a unified tool interface","local":"model-context-protocol-mcp-a-unified-tool-interface","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ns(Bl){return Ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tn extends zs{constructor(J){super(),Ys(this,J,Ns,Vs,Zs,{})}}export{tn as component};
