import{s as bn,o as fn,n as gn}from"../chunks/scheduler.37c15a92.js";import{S as jn,i as In,g as i,s as n,r as p,A as Cn,h as o,f as l,c as a,j as dn,u as M,x as r,k as is,y as vn,a as s,v as u,d as y,t as c,w as m,m as Un,n as hn}from"../chunks/index.2bf4358c.js";import{T as Zn}from"../chunks/Tip.363c041f.js";import{C as U}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Bn}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{H as T}from"../chunks/Heading.8ada512a.js";import{E as kn}from"../chunks/EditOnGithub.9958bcdc.js";function Vn(me){let w,d,b="this notebook",h;return{c(){w=Un("You can follow the code in "),d=i("a"),d.textContent=b,h=Un(" that you can run using Google Colab."),this.h()},l(J){w=hn(J,"You can follow the code in "),d=o(J,"A",{href:!0,target:!0,"data-svelte-h":!0}),r(d)!=="svelte-obo0nn"&&(d.textContent=b),h=hn(J," that you can run using Google Colab."),this.h()},h(){is(d,"href","https://huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents-notebook.ipynb"),is(d,"target","_blank")},m(J,f){s(J,w,f),s(J,d,f),s(J,h,f)},p:gn,d(J){J&&(l(w),l(d),l(h))}}}function Wn(me){let w,d,b,h,J,f,j,Te,g,Je,I,os="In this notebook, we will learn how to <strong>monitor the internal steps (traces) of our AI agent</strong> and <strong>evaluate its performance</strong> using open-source observability tools.",we,C,rs="The ability to observe and evaluate an agent’s behavior is essential for:",de,v,ps="<li>Debugging issues when tasks fail or produce suboptimal results</li> <li>Monitoring costs and performance in real-time</li> <li>Improving reliability and safety through continuous feedback</li>",Ue,Z,he,B,Ms="Before running this notebook, please be sure you have:",be,k,us='🔲 📚  <strong>Studied</strong> <a href="https://huggingface.co/learn/agents-course/unit1/introduction" rel="nofollow">Introduction to Agents</a>',fe,V,ys='🔲 📚  <strong>Studied</strong> <a href="https://huggingface.co/learn/agents-course/unit2/smolagents/introduction" rel="nofollow">The smolagents framework</a>',ge,W,je,G,cs="We will need a few libraries that allow us to run, monitor, and evaluate our agents:",Ie,R,Ce,$,ve,H,ms='In this notebook, we will use <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> as our observability tool, but you can use <strong>any other OpenTelemetry-compatible service</strong>. The code below shows how to set environment variables for Langfuse (or any OTel endpoint) and how to instrument your smolagent.',Ze,x,Ts='<strong>Note:</strong> If you are using LlamaIndex or LangGraph, you can find documentation on instrumenting them <a href="https://langfuse.com/docs/integrations/llama-index/workflows" rel="nofollow">here</a> and <a href="https://langfuse.com/docs/integrations/langchain/example-python-langgraph" rel="nofollow">here</a>.',Be,N,Js="First, let’s configure the right environment variable for setting up the connection to the Langfuse OpenTelemetry endpoint.",ke,E,Ve,Q,ws="We also need to configure or Hugging Face token for inference calls.",We,S,Ge,_,ds="Next, we can set up the a tracer-provider for our configured OpenTelemetry.",Re,X,$e,F,He,Y,Us="Here is a simple CodeAgent from smolagents that calculates <code>1+1</code>. We run it to confirm that the instrumentation is working correctly. If everything is set up correctly, you will see logs/spans in your observability dashboard.",xe,L,Ne,A,hs='Check your <a href="https://cloud.langfuse.com/traces" rel="nofollow">Langfuse Traces Dashboard</a> (or your chosen observability tool) to confirm that the spans and logs have been recorded.',Ee,z,bs="Example screenshot from Langfuse:",Qe,q,fs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/first-example-trace.png" alt="Example trace in Langfuse"/>',Se,P,gs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1b94d6888258e0998329cdb72a371155?timestamp=2025-03-10T11%3A59%3A41.743Z" rel="nofollow">Link to the trace</a></em>',_e,D,Xe,K,js="Now that you have confirmed your instrumentation works, let’s try a more complex query so we can see how advanced metrics (token usage, latency, costs, etc.) are tracked.",Fe,O,Ye,tt,Le,et,Is="Most observability tools record a <strong>trace</strong> that contains <strong>spans</strong>, which represent each step of your agent’s logic. Here, the trace contains the overall agent run and sub-spans for:",Ae,lt,Cs="<li>The tool calls (DuckDuckGoSearchTool)</li> <li>The LLM calls (HfApiModel)</li>",ze,st,vs="You can inspect these to see precisely where time is spent, how many tokens are used, and so on:",qe,nt,Zs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/trace-tree.png" alt="Trace tree in Langfuse"/>',Pe,at,Bs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',De,it,Ke,ot,ks="In the previous section, we learned about the difference between online and offline evaluation. Now, we will see how to monitor your agent in production and evaluate it live.",Oe,rt,tl,pt,Vs="<li><strong>Costs</strong> — The smolagents instrumentation captures token usage, which you can transform into approximate costs by assigning a price per token.</li> <li><strong>Latency</strong> — Observe the time it takes to complete each step, or the entire run.</li> <li><strong>User Feedback</strong> — Users can provide direct feedback (thumbs up/down) to help refine or correct the agent.</li> <li><strong>LLM-as-a-Judge</strong> — Use a separate LLM to evaluate your agent’s output in near real-time (e.g., checking for toxicity or correctness).</li>",el,Mt,Ws="Below, we show examples of these metrics.",ll,ut,sl,yt,Gs="Below is a screenshot showing usage for <code>Qwen2.5-Coder-32B-Instruct</code> calls. This is useful to see costly steps and optimize your agent.",nl,ct,Rs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-costs.png" alt="Costs"/>',al,mt,$s='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',il,Tt,ol,Jt,Hs="We can also see how long it took to complete each step. In the example below, the entire conversation took 32 seconds, which you can break down by step. This helps you identify bottlenecks and optimize your agent.",rl,wt,xs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-latency.png" alt="Latency"/>',pl,dt,Ns='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',Ml,Ut,ul,ht,Es="You may also pass additional attributes—such as user IDs, session IDs, or tags—by setting them on the spans. For example, smolagents instrumentation uses OpenTelemetry to attach attributes like <code>langfuse.user.id</code> or custom tags.",yl,bt,cl,ft,Qs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-attributes.png" alt="Enhancing agent runs with additional metrics"/>',ml,gt,Tl,jt,Ss='If your agent is embedded into a user interface, you can record direct user feedback (like a thumbs-up/down in a chat UI). Below is an example using <a href="https://gradio.app/" rel="nofollow">Gradio</a> to embed a chat with a simple feedback mechanism.',Jl,It,_s="In the code snippet below, when a user sends a chat message, we capture the OpenTelemetry trace ID. If the user likes/dislikes the last answer, we attach a score to the trace.",wl,Ct,dl,vt,Xs="User feedback is then captured in your observability tool:",Ul,Zt,Fs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/user-feedback-gradio.png" alt="User feedback is being captured in Langfuse"/>',hl,Bt,bl,kt,Ys="LLM-as-a-Judge is another way to automatically evaluate your agent’s output. You can set up a separate LLM call to gauge the output’s correctness, toxicity, style, or any other criteria you care about.",fl,Vt,Ls="<strong>Workflow</strong>:",gl,Wt,As="<li>You define an <strong>Evaluation Template</strong>, e.g., “Check if the text is toxic.”</li> <li>Each time your agent generates output, you pass that output to your “judge” LLM with the template.</li> <li>The judge LLM responds with a rating or label that you log to your observability tool.</li>",jl,Gt,zs="Example from Langfuse:",Il,Rt,qs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator-template.png" alt="LLM-as-a-Judge Evaluation Template"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator.png" alt="LLM-as-a-Judge Evaluator"/>',Cl,$t,vl,Ht,Ps="You can see that the answer of this example is judged as “not toxic”.",Zl,xt,Ds='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/llm-as-a-judge-score.png" alt="LLM-as-a-Judge Evaluation Score"/>',Bl,Nt,kl,Et,Ks="All of these metrics can be visualized together in dashboards. This enables you to quickly see how your agent performs across many sessions and helps you to track quality metrics over time.",Vl,Qt,Os='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/langfuse-dashboard.png" alt="Observability metrics overview"/>',Wl,St,Gl,_t,tn="Online evaluation is essential for live feedback, but you also need <strong>offline evaluation</strong>—systematic checks before or during development. This helps maintain quality and reliability before rolling changes into production.",Rl,Xt,$l,Ft,en="In offline evaluation, you typically:",Hl,Yt,ln="<li>Have a benchmark dataset (with prompt and expected output pairs)</li> <li>Run your agent on that dataset</li> <li>Compare outputs to the expected results or use an additional scoring mechanism</li>",xl,Lt,sn='Below, we demonstrate this approach with the <a href="https://huggingface.co/datasets/gsm8k" rel="nofollow">GSM8K dataset</a>, which contains math questions and solutions.',Nl,At,El,zt,nn="Next, we create a dataset entity in Langfuse to track the runs. Then, we add each item from the dataset to the system. (If you’re not using Langfuse, you might simply store these in your own database or local file for analysis.)",Ql,qt,Sl,Pt,_l,Dt,an='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/example-dataset.png" alt="Dataset items in Langfuse"/>',Xl,Kt,Fl,Ot,on="We define a helper function <code>run_smolagent()</code> that:",Yl,te,rn="<li>Starts an OpenTelemetry span</li> <li>Runs our agent on the prompt</li> <li>Records the trace ID in Langfuse</li>",Ll,ee,pn="Then, we loop over each dataset item, run the agent, and link the trace to the dataset item. We can also attach a quick evaluation score if desired.",Al,le,zl,se,ql,ne,Mn="You can repeat this process with different:",Pl,ae,un="<li>Models (OpenAI GPT, local LLM, etc.)</li> <li>Tools (search vs. no search)</li> <li>Prompts (different system messages)</li>",Dl,ie,yn="Then compare them side-by-side in your observability tool:",Kl,oe,cn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset_runs.png" alt="Dataset run overview"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset-run-comparison.png" alt="Dataset run comparison"/>',Ol,re,ts,pe,mn="In this notebook, we covered how to:",es,Me,Tn="<li><strong>Set up Observability</strong> using smolagents + OpenTelemetry exporters</li> <li><strong>Check Instrumentation</strong> by running a simple agent</li> <li><strong>Capture Detailed Metrics</strong> (cost, latency, etc.) through an observability tools</li> <li><strong>Collect User Feedback</strong> via a Gradio interface</li> <li><strong>Use LLM-as-a-Judge</strong> to automatically evaluate outputs</li> <li><strong>Perform Offline Evaluation</strong> with a benchmark dataset</li>",ls,ue,Jn="🤗 Happy coding!",ss,ye,ns,ce,as;return J=new Bn({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/agents-course/blob/main/notebooks/bonus-unit2/monitoring-and-evaluating-agents.ipynb"}]}}),j=new T({props:{title:"Bonus Unit 2: Observability and Evaluation of Agents",local:"bonus-unit-2-observability-and-evaluation-of-agents",headingTag:"h1"}}),g=new Zn({props:{$$slots:{default:[Vn]},$$scope:{ctx:me}}}),Z=new T({props:{title:"Exercise Prerequisites 🏗️",local:"exercise-prerequisites-",headingTag:"h2"}}),W=new T({props:{title:"Step 0: Install the Required Libraries",local:"step-0-install-the-required-libraries",headingTag:"h2"}}),R=new U({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCdGVsZW1ldHJ5JTVEJyUwQSUyNXBpcCUyMGluc3RhbGwlMjBvcGVudGVsZW1ldHJ5LXNkayUyMG9wZW50ZWxlbWV0cnktZXhwb3J0ZXItb3RscCUyMG9wZW5pbmZlcmVuY2UtaW5zdHJ1bWVudGF0aW9uLXNtb2xhZ2VudHMlMEElMjVwaXAlMjBpbnN0YWxsJTIwbGFuZ2Z1c2UlMjBkYXRhc2V0cyUyMCdzbW9sYWdlbnRzJTVCZ3JhZGlvJTVEJw==",highlighted:`%pip install <span class="hljs-string">&#x27;smolagents[telemetry]&#x27;</span>
%pip install opentelemetry-sdk opentelemetry-exporter-otlp openinference-instrumentation-smolagents
%pip install langfuse datasets <span class="hljs-string">&#x27;smolagents[gradio]&#x27;</span>`,wrap:!1}}),$=new T({props:{title:"Step 1: Instrument Your Agent",local:"step-1-instrument-your-agent",headingTag:"h2"}}),E=new U({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBiYXNlNjQlMEElMEElMjMlMjBHZXQlMjB5b3VyJTIwb3duJTIwa2V5cyUyMGZyb20lMjBodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUwQUxBTkdGVVNFX1BVQkxJQ19LRVklMjAlM0QlMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMjAlMEFMQU5HRlVTRV9TRUNSRVRfS0VZJTIwJTNEJTIwJTIyc2stbGYtLi4uJTIyJTIwJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjBMQU5HRlVTRV9QVUJMSUNfS0VZJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1NFQ1JFVF9LRVklMjIlNUQlMjAlM0QlMjBMQU5HRlVTRV9TRUNSRVRfS0VZJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX0hPU1QlMjIlNUQlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUyMiUyMCUyMCUyMyUyMCVGMCU5RiU4NyVBQSVGMCU5RiU4NyVCQSUyMEVVJTIwcmVnaW9uJTIwZXhhbXBsZSUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBVUyUyMHJlZ2lvbiUyMGV4YW1wbGUlMEElMEFMQU5HRlVTRV9BVVRIJTIwJTNEJTIwYmFzZTY0LmI2NGVuY29kZSglMEElMjAlMjAlMjAlMjBmJTIyJTdCTEFOR0ZVU0VfUFVCTElDX0tFWSU3RCUzQSU3QkxBTkdGVVNFX1NFQ1JFVF9LRVklN0QlMjIuZW5jb2RlKCklMEEpLmRlY29kZSgpJTBBJTBBb3MuZW52aXJvbiU1QiUyMk9URUxfRVhQT1JURVJfT1RMUF9FTkRQT0lOVCUyMiU1RCUyMCUzRCUyMG9zLmVudmlyb24uZ2V0KCUyMkxBTkdGVVNFX0hPU1QlMjIpJTIwJTJCJTIwJTIyJTJGYXBpJTJGcHVibGljJTJGb3RlbCUyMiUwQW9zLmVudmlyb24lNUIlMjJPVEVMX0VYUE9SVEVSX09UTFBfSEVBREVSUyUyMiU1RCUyMCUzRCUyMGYlMjJBdXRob3JpemF0aW9uJTNEQmFzaWMlMjAlN0JMQU5HRlVTRV9BVVRIJTdEJTIy",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> base64

<span class="hljs-comment"># Get your own keys from https://cloud.langfuse.com</span>
LANGFUSE_PUBLIC_KEY = = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
LANGFUSE_SECRET_KEY = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = LANGFUSE_PUBLIC_KEY
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = LANGFUSE_SECRET_KEY
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span>  <span class="hljs-comment"># 🇪🇺 EU region example</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot;  # 🇺🇸 US region example</span>

LANGFUSE_AUTH = base64.b64encode(
    <span class="hljs-string">f&quot;<span class="hljs-subst">{LANGFUSE_PUBLIC_KEY}</span>:<span class="hljs-subst">{LANGFUSE_SECRET_KEY}</span>&quot;</span>.encode()
).decode()

os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_ENDPOINT&quot;</span>] = os.environ.get(<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>) + <span class="hljs-string">&quot;/api/public/otel&quot;</span>
os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_HEADERS&quot;</span>] = <span class="hljs-string">f&quot;Authorization=Basic <span class="hljs-subst">{LANGFUSE_AUTH}</span>&quot;</span>`,wrap:!1}}),S=new U({props:{code:"JTIzJTIwU2V0JTIweW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYW5kJTIwb3RoZXIlMjB0b2tlbnMlMkZzZWNyZXRzJTIwYXMlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTBBb3MuZW52aXJvbiU1QiUyMkhGX1RPS0VOJTIyJTVEJTIwJTNEJTIwJTIyaGZfLi4uJTIyJTIw",highlighted:`<span class="hljs-comment"># Set your Hugging Face and other tokens/secrets as environment variable</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span> `,wrap:!1}}),X=new U({props:{code:"ZnJvbSUyMG9wZW50ZWxlbWV0cnkuc2RrLnRyYWNlJTIwaW1wb3J0JTIwVHJhY2VyUHJvdmlkZXIlMEFmcm9tJTIwb3BlbmluZmVyZW5jZS5pbnN0cnVtZW50YXRpb24uc21vbGFnZW50cyUyMGltcG9ydCUyMFNtb2xhZ2VudHNJbnN0cnVtZW50b3IlMEFmcm9tJTIwb3BlbnRlbGVtZXRyeS5leHBvcnRlci5vdGxwLnByb3RvLmh0dHAudHJhY2VfZXhwb3J0ZXIlMjBpbXBvcnQlMjBPVExQU3BhbkV4cG9ydGVyJTBBZnJvbSUyMG9wZW50ZWxlbWV0cnkuc2RrLnRyYWNlLmV4cG9ydCUyMGltcG9ydCUyMFNpbXBsZVNwYW5Qcm9jZXNzb3IlMEElMjAlMEElMjMlMjBDcmVhdGUlMjBhJTIwVHJhY2VyUHJvdmlkZXIlMjBmb3IlMjBPcGVuVGVsZW1ldHJ5JTBBdHJhY2VfcHJvdmlkZXIlMjAlM0QlMjBUcmFjZXJQcm92aWRlcigpJTBBJTBBJTIzJTIwQWRkJTIwYSUyMFNpbXBsZVNwYW5Qcm9jZXNzb3IlMjB3aXRoJTIwdGhlJTIwT1RMUFNwYW5FeHBvcnRlciUyMHRvJTIwc2VuZCUyMHRyYWNlcyUwQXRyYWNlX3Byb3ZpZGVyLmFkZF9zcGFuX3Byb2Nlc3NvcihTaW1wbGVTcGFuUHJvY2Vzc29yKE9UTFBTcGFuRXhwb3J0ZXIoKSkpJTBBJTBBJTIzJTIwU2V0JTIwdGhlJTIwZ2xvYmFsJTIwZGVmYXVsdCUyMHRyYWNlciUyMHByb3ZpZGVyJTBBZnJvbSUyMG9wZW50ZWxlbWV0cnklMjBpbXBvcnQlMjB0cmFjZSUwQXRyYWNlLnNldF90cmFjZXJfcHJvdmlkZXIodHJhY2VfcHJvdmlkZXIpJTBBdHJhY2VyJTIwJTNEJTIwdHJhY2UuZ2V0X3RyYWNlcihfX25hbWVfXyklMEElMEElMjMlMjBJbnN0cnVtZW50JTIwc21vbGFnZW50cyUyMHdpdGglMjB0aGUlMjBjb25maWd1cmVkJTIwcHJvdmlkZXIlMEFTbW9sYWdlbnRzSW5zdHJ1bWVudG9yKCkuaW5zdHJ1bWVudCh0cmFjZXJfcHJvdmlkZXIlM0R0cmFjZV9wcm92aWRlcik=",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.sdk.trace <span class="hljs-keyword">import</span> TracerProvider
<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor
<span class="hljs-keyword">from</span> opentelemetry.exporter.otlp.proto.http.trace_exporter <span class="hljs-keyword">import</span> OTLPSpanExporter
<span class="hljs-keyword">from</span> opentelemetry.sdk.trace.export <span class="hljs-keyword">import</span> SimpleSpanProcessor
 
<span class="hljs-comment"># Create a TracerProvider for OpenTelemetry</span>
trace_provider = TracerProvider()

<span class="hljs-comment"># Add a SimpleSpanProcessor with the OTLPSpanExporter to send traces</span>
trace_provider.add_span_processor(SimpleSpanProcessor(OTLPSpanExporter()))

<span class="hljs-comment"># Set the global default tracer provider</span>
<span class="hljs-keyword">from</span> opentelemetry <span class="hljs-keyword">import</span> trace
trace.set_tracer_provider(trace_provider)
tracer = trace.get_tracer(__name__)

<span class="hljs-comment"># Instrument smolagents with the configured provider</span>
SmolagentsInstrumentor().instrument(tracer_provider=trace_provider)`,wrap:!1}}),F=new T({props:{title:"Step 2: Test Your Instrumentation",local:"step-2-test-your-instrumentation",headingTag:"h2"}}),L=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTJDJTIwQ29kZUFnZW50JTBBJTBBJTIzJTIwQ3JlYXRlJTIwYSUyMHNpbXBsZSUyMGFnZW50JTIwdG8lMjB0ZXN0JTIwaW5zdHJ1bWVudGF0aW9uJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREhmQXBpTW9kZWwoKSUwQSklMEElMEFhZ2VudC5ydW4oJTIyMSUyQjElM0QlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel, CodeAgent

<span class="hljs-comment"># Create a simple agent to test instrumentation</span>
agent = CodeAgent(
    tools=[],
    model=HfApiModel()
)

agent.run(<span class="hljs-string">&quot;1+1=&quot;</span>)`,wrap:!1}}),D=new T({props:{title:"Step 3: Observe and Evaluate a More Complex Agent",local:"step-3-observe-and-evaluate-a-more-complex-agent",headingTag:"h2"}}),O=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBIZkFwaU1vZGVsKSUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2woKSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzREhmQXBpTW9kZWwoKSklMEElMEFhZ2VudC5ydW4oJTIySG93JTIwbWFueSUyMFJ1YmlrJ3MlMjBDdWJlcyUyMGNvdWxkJTIweW91JTIwZml0JTIwaW5zaWRlJTIwdGhlJTIwTm90cmUlMjBEYW1lJTIwQ2F0aGVkcmFsJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, HfApiModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=HfApiModel())

agent.run(<span class="hljs-string">&quot;How many Rubik&#x27;s Cubes could you fit inside the Notre Dame Cathedral?&quot;</span>)`,wrap:!1}}),tt=new T({props:{title:"Trace Structure",local:"trace-structure",headingTag:"h3"}}),it=new T({props:{title:"Online Evaluation",local:"online-evaluation",headingTag:"h2"}}),rt=new T({props:{title:"Common Metrics to Track in Production",local:"common-metrics-to-track-in-production",headingTag:"h3"}}),ut=new T({props:{title:"1. Costs",local:"1-costs",headingTag:"h4"}}),Tt=new T({props:{title:"2. Latency",local:"2-latency",headingTag:"h4"}}),Ut=new T({props:{title:"3. Additional Attributes",local:"3-additional-attributes",headingTag:"h4"}}),bt=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBIZkFwaU1vZGVsKSUwQWZyb20lMjBvcGVudGVsZW1ldHJ5JTIwaW1wb3J0JTIwdHJhY2UlMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RIZkFwaU1vZGVsKCklMEEpJTBBJTBBd2l0aCUyMHRyYWNlci5zdGFydF9hc19jdXJyZW50X3NwYW4oJTIyU21vbGFnZW50LVRyYWNlJTIyKSUyMGFzJTIwc3BhbiUzQSUwQSUyMCUyMCUyMCUyMHNwYW4uc2V0X2F0dHJpYnV0ZSglMjJsYW5nZnVzZS51c2VyLmlkJTIyJTJDJTIwJTIyc21vbGFnZW50LXVzZXItMTIzJTIyKSUwQSUyMCUyMCUyMCUyMHNwYW4uc2V0X2F0dHJpYnV0ZSglMjJsYW5nZnVzZS5zZXNzaW9uLmlkJTIyJTJDJTIwJTIyc21vbGFnZW50LXNlc3Npb24tMTIzNDU2Nzg5JTIyKSUwQSUyMCUyMCUyMCUyMHNwYW4uc2V0X2F0dHJpYnV0ZSglMjJsYW5nZnVzZS50YWdzJTIyJTJDJTIwJTVCJTIyY2l0eS1xdWVzdGlvbiUyMiUyQyUyMCUyMnRlc3RpbmctYWdlbnRzJTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMGFnZW50LnJ1biglMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBHZXJtYW55JTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, HfApiModel)
<span class="hljs-keyword">from</span> opentelemetry <span class="hljs-keyword">import</span> trace

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(
    tools=[search_tool],
    model=HfApiModel()
)

<span class="hljs-keyword">with</span> tracer.start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
    span.set_attribute(<span class="hljs-string">&quot;langfuse.user.id&quot;</span>, <span class="hljs-string">&quot;smolagent-user-123&quot;</span>)
    span.set_attribute(<span class="hljs-string">&quot;langfuse.session.id&quot;</span>, <span class="hljs-string">&quot;smolagent-session-123456789&quot;</span>)
    span.set_attribute(<span class="hljs-string">&quot;langfuse.tags&quot;</span>, [<span class="hljs-string">&quot;city-question&quot;</span>, <span class="hljs-string">&quot;testing-agents&quot;</span>])

    agent.run(<span class="hljs-string">&quot;What is the capital of Germany?&quot;</span>)`,wrap:!1}}),gt=new T({props:{title:"4. User Feedback",local:"4-user-feedback",headingTag:"h4"}}),Ct=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, HfApiModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> Langfuse

langfuse = Langfuse()
model = HfApiModel()
agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)

formatted_trace_id = <span class="hljs-literal">None</span>  <span class="hljs-comment"># We&#x27;ll store the current trace_id globally for demonstration</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">respond</span>(<span class="hljs-params">prompt, history</span>):
    <span class="hljs-keyword">with</span> trace.get_tracer(__name__).start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
        output = agent.run(prompt)

        current_span = trace.get_current_span()
        span_context = current_span.get_span_context()
        trace_id = span_context.trace_id
        <span class="hljs-keyword">global</span> formatted_trace_id
        formatted_trace_id = <span class="hljs-built_in">str</span>(format_trace_id(trace_id))
        langfuse.trace(<span class="hljs-built_in">id</span>=formatted_trace_id, <span class="hljs-built_in">input</span>=prompt, output=output)

    history.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-built_in">str</span>(output)})
    <span class="hljs-keyword">return</span> history

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_like</span>(<span class="hljs-params">data: gr.LikeData</span>):
    <span class="hljs-comment"># For demonstration, we map user feedback to a 1 (like) or 0 (dislike)</span>
    <span class="hljs-keyword">if</span> data.liked:
        langfuse.score(
            value=<span class="hljs-number">1</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=formatted_trace_id
        )
    <span class="hljs-keyword">else</span>:
        langfuse.score(
            value=<span class="hljs-number">0</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=formatted_trace_id
        )

<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    chatbot = gr.Chatbot(label=<span class="hljs-string">&quot;Chat&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>)
    prompt_box = gr.Textbox(placeholder=<span class="hljs-string">&quot;Type your message...&quot;</span>, label=<span class="hljs-string">&quot;Your message&quot;</span>)

    <span class="hljs-comment"># When the user presses &#x27;Enter&#x27; on the prompt, we run &#x27;respond&#x27;</span>
    prompt_box.submit(
        fn=respond,
        inputs=[prompt_box, chatbot],
        outputs=chatbot
    )

    <span class="hljs-comment"># When the user clicks a &#x27;like&#x27; button on a message, we run &#x27;handle_like&#x27;</span>
    chatbot.like(handle_like, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>)

demo.launch()
`,wrap:!1}}),Bt=new T({props:{title:"5. LLM-as-a-Judge",local:"5-llm-as-a-judge",headingTag:"h4"}}),$t=new U({props:{code:"JTIzJTIwRXhhbXBsZSUzQSUyMENoZWNraW5nJTIwaWYlMjB0aGUlMjBhZ2VudCVFMiU4MCU5OXMlMjBvdXRwdXQlMjBpcyUyMHRveGljJTIwb3IlMjBub3QuJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBIZkFwaU1vZGVsKSUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2woKSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzREhmQXBpTW9kZWwoKSklMEElMEFhZ2VudC5ydW4oJTIyQ2FuJTIwZWF0aW5nJTIwY2Fycm90cyUyMGltcHJvdmUlMjB5b3VyJTIwdmlzaW9uJTNGJTIyKQ==",highlighted:`<span class="hljs-comment"># Example: Checking if the agent’s output is toxic or not.</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, HfApiModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=HfApiModel())

agent.run(<span class="hljs-string">&quot;Can eating carrots improve your vision?&quot;</span>)`,wrap:!1}}),Nt=new T({props:{title:"6. Observability Metrics Overview",local:"6-observability-metrics-overview",headingTag:"h4"}}),St=new T({props:{title:"Offline Evaluation",local:"offline-evaluation",headingTag:"h2"}}),Xt=new T({props:{title:"Dataset Evaluation",local:"dataset-evaluation",headingTag:"h3"}}),At=new U({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMEZldGNoJTIwR1NNOEslMjBmcm9tJTIwSHVnZ2luZyUyMEZhY2UlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm9wZW5haSUyRmdzbThrJTIyJTJDJTIwJ21haW4nJTJDJTIwc3BsaXQlM0QndHJhaW4nKSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGRhdGFzZXQpJTBBcHJpbnQoJTIyRmlyc3QlMjBmZXclMjByb3dzJTIwb2YlMjBHU004SyUyMGRhdGFzZXQlM0ElMjIpJTBBcHJpbnQoZGYuaGVhZCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Fetch GSM8K from Hugging Face</span>
dataset = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&#x27;main&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)
df = pd.DataFrame(dataset)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;First few rows of GSM8K dataset:&quot;</span>)
<span class="hljs-built_in">print</span>(df.head())`,wrap:!1}}),qt=new U({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwTGFuZ2Z1c2UlMEFsYW5nZnVzZSUyMCUzRCUyMExhbmdmdXNlKCklMEElMEFsYW5nZnVzZV9kYXRhc2V0X25hbWUlMjAlM0QlMjAlMjJnc204a19kYXRhc2V0X2h1Z2dpbmdmYWNlJTIyJTBBJTBBJTIzJTIwQ3JlYXRlJTIwYSUyMGRhdGFzZXQlMjBpbiUyMExhbmdmdXNlJTBBbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRGxhbmdmdXNlX2RhdGFzZXRfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyR1NNOEslMjBiZW5jaG1hcmslMjBkYXRhc2V0JTIwdXBsb2FkZWQlMjBmcm9tJTIwSHVnZ2luZ2ZhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRhdGUlMjIlM0ElMjAlMjIyMDI1LTAzLTEwJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmJlbmNobWFyayUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> Langfuse
langfuse = Langfuse()

langfuse_dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>

<span class="hljs-comment"># Create a dataset in Langfuse</span>
langfuse.create_dataset(
    name=langfuse_dataset_name,
    description=<span class="hljs-string">&quot;GSM8K benchmark dataset uploaded from Huggingface&quot;</span>,
    metadata={
        <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2025-03-10&quot;</span>, 
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;benchmark&quot;</span>
    }
)`,wrap:!1}}),Pt=new U({props:{code:"Zm9yJTIwaWR4JTJDJTIwcm93JTIwaW4lMjBkZi5pdGVycm93cygpJTNBJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXRfaXRlbSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X25hbWUlM0RsYW5nZnVzZV9kYXRhc2V0X25hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJxdWVzdGlvbiUyMiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4cGVjdGVkX291dHB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJhbnN3ZXIlMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZV9pbmRleCUyMiUzQSUyMGlkeCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpZiUyMGlkeCUyMCUzRSUzRCUyMDklM0ElMjAlMjMlMjBVcGxvYWQlMjBvbmx5JTIwdGhlJTIwZmlyc3QlMjAxMCUyMGl0ZW1zJTIwZm9yJTIwZGVtb25zdHJhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> idx, row <span class="hljs-keyword">in</span> df.iterrows():
    langfuse.create_dataset_item(
        dataset_name=langfuse_dataset_name,
        <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;question&quot;</span>]},
        expected_output={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;answer&quot;</span>]},
        metadata={<span class="hljs-string">&quot;source_index&quot;</span>: idx}
    )
    <span class="hljs-keyword">if</span> idx &gt;= <span class="hljs-number">9</span>: <span class="hljs-comment"># Upload only the first 10 items for demonstration</span>
        <span class="hljs-keyword">break</span>`,wrap:!1}}),Kt=new T({props:{title:"Running the Agent on the Dataset",local:"running-the-agent-on-the-dataset",headingTag:"h4"}}),le=new U({props:{code:"ZnJvbSUyMG9wZW50ZWxlbWV0cnkudHJhY2UlMjBpbXBvcnQlMjBmb3JtYXRfdHJhY2VfaWQlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMChDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTJDJTIwTGl0ZUxMTU1vZGVsKSUwQSUwQSUyMyUyMEV4YW1wbGUlM0ElMjB1c2luZyUyMEhmQXBpTW9kZWwlMjBvciUyMExpdGVMTE1Nb2RlbCUyMHRvJTIwYWNjZXNzJTIwb3BlbmFpJTJDJTIwYW50aHJvcGljJTJDJTIwZ2VtaW5pJTJDJTIwZXRjLiUyMG1vZGVscyUzQSUwQW1vZGVsJTIwJTNEJTIwSGZBcGlNb2RlbCgpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlJTBBKSUwQSUwQWRlZiUyMHJ1bl9zbW9sYWdlbnQocXVlc3Rpb24pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRyYWNlci5zdGFydF9hc19jdXJyZW50X3NwYW4oJTIyU21vbGFnZW50LVRyYWNlJTIyKSUyMGFzJTIwc3BhbiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwYW4uc2V0X2F0dHJpYnV0ZSglMjJsYW5nZnVzZS50YWclMjIlMkMlMjAlMjJkYXRhc2V0LXJ1biUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBhZ2VudC5ydW4ocXVlc3Rpb24pJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3VycmVudF9zcGFuJTIwJTNEJTIwdHJhY2UuZ2V0X2N1cnJlbnRfc3BhbigpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3Bhbl9jb250ZXh0JTIwJTNEJTIwY3VycmVudF9zcGFuLmdldF9zcGFuX2NvbnRleHQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYWNlX2lkJTIwJTNEJTIwc3Bhbl9jb250ZXh0LnRyYWNlX2lkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9ybWF0dGVkX3RyYWNlX2lkJTIwJTNEJTIwZm9ybWF0X3RyYWNlX2lkKHRyYWNlX2lkKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhbmdmdXNlX3RyYWNlJTIwJTNEJTIwbGFuZ2Z1c2UudHJhY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWQlM0Rmb3JtYXR0ZWRfdHJhY2VfaWQlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRHF1ZXN0aW9uJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTNEb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxhbmdmdXNlX3RyYWNlJTJDJTIwb3V0cHV0",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, HfApiModel, LiteLLMModel)

<span class="hljs-comment"># Example: using HfApiModel or LiteLLMModel to access openai, anthropic, gemini, etc. models:</span>
model = HfApiModel()

agent = CodeAgent(
    tools=[],
    model=model,
    add_base_tools=<span class="hljs-literal">True</span>
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_smolagent</span>(<span class="hljs-params">question</span>):
    <span class="hljs-keyword">with</span> tracer.start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
        span.set_attribute(<span class="hljs-string">&quot;langfuse.tag&quot;</span>, <span class="hljs-string">&quot;dataset-run&quot;</span>)
        output = agent.run(question)

        current_span = trace.get_current_span()
        span_context = current_span.get_span_context()
        trace_id = span_context.trace_id
        formatted_trace_id = format_trace_id(trace_id)

        langfuse_trace = langfuse.trace(
            <span class="hljs-built_in">id</span>=formatted_trace_id, 
            <span class="hljs-built_in">input</span>=question, 
            output=output
        )
    <span class="hljs-keyword">return</span> langfuse_trace, output`,wrap:!1}}),se=new U({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxhbmdmdXNlLmdldF9kYXRhc2V0KGxhbmdmdXNlX2RhdGFzZXRfbmFtZSklMEElMEElMjMlMjBSdW4lMjBvdXIlMjBhZ2VudCUyMGFnYWluc3QlMjBlYWNoJTIwZGF0YXNldCUyMGl0ZW0lMjAobGltaXRlZCUyMHRvJTIwZmlyc3QlMjAxMCUyMGFib3ZlKSUwQWZvciUyMGl0ZW0lMjBpbiUyMGRhdGFzZXQuaXRlbXMlM0ElMEElMjAlMjAlMjAlMjBsYW5nZnVzZV90cmFjZSUyQyUyMG91dHB1dCUyMCUzRCUyMHJ1bl9zbW9sYWdlbnQoaXRlbS5pbnB1dCU1QiUyMnRleHQlMjIlNUQpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwTGluayUyMHRoZSUyMHRyYWNlJTIwdG8lMjB0aGUlMjBkYXRhc2V0JTIwaXRlbSUyMGZvciUyMGFuYWx5c2lzJTBBJTIwJTIwJTIwJTIwaXRlbS5saW5rKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhbmdmdXNlX3RyYWNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcnVuX25hbWUlM0QlMjJzbW9sYWdlbnQtbm90ZWJvb2stcnVuLTAxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcnVuX21ldGFkYXRhJTNEJTdCJTIwJTIybW9kZWwlMjIlM0ElMjBtb2RlbC5tb2RlbF9pZCUyMCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBPcHRpb25hbGx5JTJDJTIwc3RvcmUlMjBhJTIwcXVpY2slMjBldmFsdWF0aW9uJTIwc2NvcmUlMjBmb3IlMjBkZW1vbnN0cmF0aW9uJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2VfdHJhY2Uuc2NvcmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFtZSUzRCUyMiUzQ2V4YW1wbGVfZXZhbCUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlJTNEMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbW1lbnQlM0QlMjJUaGlzJTIwaXMlMjBhJTIwY29tbWVudCUyMiUwQSUyMCUyMCUyMCUyMCklMEElMEElMjMlMjBGbHVzaCUyMGRhdGElMjB0byUyMGVuc3VyZSUyMGFsbCUyMHRlbGVtZXRyeSUyMGlzJTIwc2VudCUwQWxhbmdmdXNlLmZsdXNoKCk=",highlighted:`dataset = langfuse.get_dataset(langfuse_dataset_name)

<span class="hljs-comment"># Run our agent against each dataset item (limited to first 10 above)</span>
<span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset.items:
    langfuse_trace, output = run_smolagent(item.<span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;text&quot;</span>])

    <span class="hljs-comment"># Link the trace to the dataset item for analysis</span>
    item.link(
        langfuse_trace,
        run_name=<span class="hljs-string">&quot;smolagent-notebook-run-01&quot;</span>,
        run_metadata={ <span class="hljs-string">&quot;model&quot;</span>: model.model_id }
    )

    <span class="hljs-comment"># Optionally, store a quick evaluation score for demonstration</span>
    langfuse_trace.score(
        name=<span class="hljs-string">&quot;&lt;example_eval&gt;&quot;</span>,
        value=<span class="hljs-number">1</span>,
        comment=<span class="hljs-string">&quot;This is a comment&quot;</span>
    )

<span class="hljs-comment"># Flush data to ensure all telemetry is sent</span>
langfuse.flush()`,wrap:!1}}),re=new T({props:{title:"Final Thoughts",local:"final-thoughts",headingTag:"h2"}}),ye=new kn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/bonus-unit2/monitoring-and-evaluating-agents-notebook.mdx"}}),{c(){w=i("meta"),d=n(),b=i("p"),h=n(),p(J.$$.fragment),f=n(),p(j.$$.fragment),Te=n(),p(g.$$.fragment),Je=n(),I=i("p"),I.innerHTML=os,we=n(),C=i("p"),C.textContent=rs,de=n(),v=i("ul"),v.innerHTML=ps,Ue=n(),p(Z.$$.fragment),he=n(),B=i("p"),B.textContent=Ms,be=n(),k=i("p"),k.innerHTML=us,fe=n(),V=i("p"),V.innerHTML=ys,ge=n(),p(W.$$.fragment),je=n(),G=i("p"),G.textContent=cs,Ie=n(),p(R.$$.fragment),Ce=n(),p($.$$.fragment),ve=n(),H=i("p"),H.innerHTML=ms,Ze=n(),x=i("p"),x.innerHTML=Ts,Be=n(),N=i("p"),N.textContent=Js,ke=n(),p(E.$$.fragment),Ve=n(),Q=i("p"),Q.textContent=ws,We=n(),p(S.$$.fragment),Ge=n(),_=i("p"),_.textContent=ds,Re=n(),p(X.$$.fragment),$e=n(),p(F.$$.fragment),He=n(),Y=i("p"),Y.innerHTML=Us,xe=n(),p(L.$$.fragment),Ne=n(),A=i("p"),A.innerHTML=hs,Ee=n(),z=i("p"),z.textContent=bs,Qe=n(),q=i("p"),q.innerHTML=fs,Se=n(),P=i("p"),P.innerHTML=gs,_e=n(),p(D.$$.fragment),Xe=n(),K=i("p"),K.textContent=js,Fe=n(),p(O.$$.fragment),Ye=n(),p(tt.$$.fragment),Le=n(),et=i("p"),et.innerHTML=Is,Ae=n(),lt=i("ul"),lt.innerHTML=Cs,ze=n(),st=i("p"),st.textContent=vs,qe=n(),nt=i("p"),nt.innerHTML=Zs,Pe=n(),at=i("p"),at.innerHTML=Bs,De=n(),p(it.$$.fragment),Ke=n(),ot=i("p"),ot.textContent=ks,Oe=n(),p(rt.$$.fragment),tl=n(),pt=i("ol"),pt.innerHTML=Vs,el=n(),Mt=i("p"),Mt.textContent=Ws,ll=n(),p(ut.$$.fragment),sl=n(),yt=i("p"),yt.innerHTML=Gs,nl=n(),ct=i("p"),ct.innerHTML=Rs,al=n(),mt=i("p"),mt.innerHTML=$s,il=n(),p(Tt.$$.fragment),ol=n(),Jt=i("p"),Jt.textContent=Hs,rl=n(),wt=i("p"),wt.innerHTML=xs,pl=n(),dt=i("p"),dt.innerHTML=Ns,Ml=n(),p(Ut.$$.fragment),ul=n(),ht=i("p"),ht.innerHTML=Es,yl=n(),p(bt.$$.fragment),cl=n(),ft=i("p"),ft.innerHTML=Qs,ml=n(),p(gt.$$.fragment),Tl=n(),jt=i("p"),jt.innerHTML=Ss,Jl=n(),It=i("p"),It.textContent=_s,wl=n(),p(Ct.$$.fragment),dl=n(),vt=i("p"),vt.textContent=Xs,Ul=n(),Zt=i("p"),Zt.innerHTML=Fs,hl=n(),p(Bt.$$.fragment),bl=n(),kt=i("p"),kt.textContent=Ys,fl=n(),Vt=i("p"),Vt.innerHTML=Ls,gl=n(),Wt=i("ol"),Wt.innerHTML=As,jl=n(),Gt=i("p"),Gt.textContent=zs,Il=n(),Rt=i("p"),Rt.innerHTML=qs,Cl=n(),p($t.$$.fragment),vl=n(),Ht=i("p"),Ht.textContent=Ps,Zl=n(),xt=i("p"),xt.innerHTML=Ds,Bl=n(),p(Nt.$$.fragment),kl=n(),Et=i("p"),Et.textContent=Ks,Vl=n(),Qt=i("p"),Qt.innerHTML=Os,Wl=n(),p(St.$$.fragment),Gl=n(),_t=i("p"),_t.innerHTML=tn,Rl=n(),p(Xt.$$.fragment),$l=n(),Ft=i("p"),Ft.textContent=en,Hl=n(),Yt=i("ol"),Yt.innerHTML=ln,xl=n(),Lt=i("p"),Lt.innerHTML=sn,Nl=n(),p(At.$$.fragment),El=n(),zt=i("p"),zt.textContent=nn,Ql=n(),p(qt.$$.fragment),Sl=n(),p(Pt.$$.fragment),_l=n(),Dt=i("p"),Dt.innerHTML=an,Xl=n(),p(Kt.$$.fragment),Fl=n(),Ot=i("p"),Ot.innerHTML=on,Yl=n(),te=i("ol"),te.innerHTML=rn,Ll=n(),ee=i("p"),ee.textContent=pn,Al=n(),p(le.$$.fragment),zl=n(),p(se.$$.fragment),ql=n(),ne=i("p"),ne.textContent=Mn,Pl=n(),ae=i("ul"),ae.innerHTML=un,Dl=n(),ie=i("p"),ie.textContent=yn,Kl=n(),oe=i("p"),oe.innerHTML=cn,Ol=n(),p(re.$$.fragment),ts=n(),pe=i("p"),pe.textContent=mn,es=n(),Me=i("ol"),Me.innerHTML=Tn,ls=n(),ue=i("p"),ue.textContent=Jn,ss=n(),p(ye.$$.fragment),ns=n(),ce=i("p"),this.h()},l(t){const e=Cn("svelte-u9bgzb",document.head);w=o(e,"META",{name:!0,content:!0}),e.forEach(l),d=a(t),b=o(t,"P",{}),dn(b).forEach(l),h=a(t),M(J.$$.fragment,t),f=a(t),M(j.$$.fragment,t),Te=a(t),M(g.$$.fragment,t),Je=a(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1hjcrzt"&&(I.innerHTML=os),we=a(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-foopw1"&&(C.textContent=rs),de=a(t),v=o(t,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-owrpod"&&(v.innerHTML=ps),Ue=a(t),M(Z.$$.fragment,t),he=a(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-5cu48y"&&(B.textContent=Ms),be=a(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-tid2rn"&&(k.innerHTML=us),fe=a(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-11ima5v"&&(V.innerHTML=ys),ge=a(t),M(W.$$.fragment,t),je=a(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-13k1zsa"&&(G.textContent=cs),Ie=a(t),M(R.$$.fragment,t),Ce=a(t),M($.$$.fragment,t),ve=a(t),H=o(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1om0xhg"&&(H.innerHTML=ms),Ze=a(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-10zlua1"&&(x.innerHTML=Ts),Be=a(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-xs952x"&&(N.textContent=Js),ke=a(t),M(E.$$.fragment,t),Ve=a(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1oewplf"&&(Q.textContent=ws),We=a(t),M(S.$$.fragment,t),Ge=a(t),_=o(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-fyh0fv"&&(_.textContent=ds),Re=a(t),M(X.$$.fragment,t),$e=a(t),M(F.$$.fragment,t),He=a(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-18gebex"&&(Y.innerHTML=Us),xe=a(t),M(L.$$.fragment,t),Ne=a(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1emzg84"&&(A.innerHTML=hs),Ee=a(t),z=o(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-17kovw7"&&(z.textContent=bs),Qe=a(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1cb993n"&&(q.innerHTML=fs),Se=a(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-3d3s8c"&&(P.innerHTML=gs),_e=a(t),M(D.$$.fragment,t),Xe=a(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-vj8duz"&&(K.textContent=js),Fe=a(t),M(O.$$.fragment,t),Ye=a(t),M(tt.$$.fragment,t),Le=a(t),et=o(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-11qm5kf"&&(et.innerHTML=Is),Ae=a(t),lt=o(t,"UL",{"data-svelte-h":!0}),r(lt)!=="svelte-9r87yg"&&(lt.innerHTML=Cs),ze=a(t),st=o(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-5g8r1i"&&(st.textContent=vs),qe=a(t),nt=o(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-yhkq5w"&&(nt.innerHTML=Zs),Pe=a(t),at=o(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-19v4344"&&(at.innerHTML=Bs),De=a(t),M(it.$$.fragment,t),Ke=a(t),ot=o(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1m3q9s4"&&(ot.textContent=ks),Oe=a(t),M(rt.$$.fragment,t),tl=a(t),pt=o(t,"OL",{"data-svelte-h":!0}),r(pt)!=="svelte-it9cbz"&&(pt.innerHTML=Vs),el=a(t),Mt=o(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1gkbldi"&&(Mt.textContent=Ws),ll=a(t),M(ut.$$.fragment,t),sl=a(t),yt=o(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-zy3zhh"&&(yt.innerHTML=Gs),nl=a(t),ct=o(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-dard47"&&(ct.innerHTML=Rs),al=a(t),mt=o(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-19v4344"&&(mt.innerHTML=$s),il=a(t),M(Tt.$$.fragment,t),ol=a(t),Jt=o(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-v1au4h"&&(Jt.textContent=Hs),rl=a(t),wt=o(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-1org4pj"&&(wt.innerHTML=xs),pl=a(t),dt=o(t,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-19v4344"&&(dt.innerHTML=Ns),Ml=a(t),M(Ut.$$.fragment,t),ul=a(t),ht=o(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-17m5rhs"&&(ht.innerHTML=Es),yl=a(t),M(bt.$$.fragment,t),cl=a(t),ft=o(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1gx91hu"&&(ft.innerHTML=Qs),ml=a(t),M(gt.$$.fragment,t),Tl=a(t),jt=o(t,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1t6vqwk"&&(jt.innerHTML=Ss),Jl=a(t),It=o(t,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1y4hb4w"&&(It.textContent=_s),wl=a(t),M(Ct.$$.fragment,t),dl=a(t),vt=o(t,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-qczj9m"&&(vt.textContent=Xs),Ul=a(t),Zt=o(t,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-e6ive4"&&(Zt.innerHTML=Fs),hl=a(t),M(Bt.$$.fragment,t),bl=a(t),kt=o(t,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-1guzmu1"&&(kt.textContent=Ys),fl=a(t),Vt=o(t,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-13jor3c"&&(Vt.innerHTML=Ls),gl=a(t),Wt=o(t,"OL",{"data-svelte-h":!0}),r(Wt)!=="svelte-8y9f4i"&&(Wt.innerHTML=As),jl=a(t),Gt=o(t,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-6rieqh"&&(Gt.textContent=zs),Il=a(t),Rt=o(t,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-1uar592"&&(Rt.innerHTML=qs),Cl=a(t),M($t.$$.fragment,t),vl=a(t),Ht=o(t,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-3xsjjj"&&(Ht.textContent=Ps),Zl=a(t),xt=o(t,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-zj9pt2"&&(xt.innerHTML=Ds),Bl=a(t),M(Nt.$$.fragment,t),kl=a(t),Et=o(t,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-1053it2"&&(Et.textContent=Ks),Vl=a(t),Qt=o(t,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-1jemoxg"&&(Qt.innerHTML=Os),Wl=a(t),M(St.$$.fragment,t),Gl=a(t),_t=o(t,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-12emzh2"&&(_t.innerHTML=tn),Rl=a(t),M(Xt.$$.fragment,t),$l=a(t),Ft=o(t,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-nxef74"&&(Ft.textContent=en),Hl=a(t),Yt=o(t,"OL",{"data-svelte-h":!0}),r(Yt)!=="svelte-1ys56q5"&&(Yt.innerHTML=ln),xl=a(t),Lt=o(t,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-o23tl"&&(Lt.innerHTML=sn),Nl=a(t),M(At.$$.fragment,t),El=a(t),zt=o(t,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-14neeab"&&(zt.textContent=nn),Ql=a(t),M(qt.$$.fragment,t),Sl=a(t),M(Pt.$$.fragment,t),_l=a(t),Dt=o(t,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-giwu4e"&&(Dt.innerHTML=an),Xl=a(t),M(Kt.$$.fragment,t),Fl=a(t),Ot=o(t,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-y12uij"&&(Ot.innerHTML=on),Yl=a(t),te=o(t,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-m65a60"&&(te.innerHTML=rn),Ll=a(t),ee=o(t,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1ew78oh"&&(ee.textContent=pn),Al=a(t),M(le.$$.fragment,t),zl=a(t),M(se.$$.fragment,t),ql=a(t),ne=o(t,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1ebq4ig"&&(ne.textContent=Mn),Pl=a(t),ae=o(t,"UL",{"data-svelte-h":!0}),r(ae)!=="svelte-1lunl6l"&&(ae.innerHTML=un),Dl=a(t),ie=o(t,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-gt2dc"&&(ie.textContent=yn),Kl=a(t),oe=o(t,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-ukc2vx"&&(oe.innerHTML=cn),Ol=a(t),M(re.$$.fragment,t),ts=a(t),pe=o(t,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1xbvrw5"&&(pe.textContent=mn),es=a(t),Me=o(t,"OL",{"data-svelte-h":!0}),r(Me)!=="svelte-1u9pd9c"&&(Me.innerHTML=Tn),ls=a(t),ue=o(t,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-3bxv5s"&&(ue.textContent=Jn),ss=a(t),M(ye.$$.fragment,t),ns=a(t),ce=o(t,"P",{}),dn(ce).forEach(l),this.h()},h(){is(w,"name","hf:doc:metadata"),is(w,"content",Gn)},m(t,e){vn(document.head,w),s(t,d,e),s(t,b,e),s(t,h,e),u(J,t,e),s(t,f,e),u(j,t,e),s(t,Te,e),u(g,t,e),s(t,Je,e),s(t,I,e),s(t,we,e),s(t,C,e),s(t,de,e),s(t,v,e),s(t,Ue,e),u(Z,t,e),s(t,he,e),s(t,B,e),s(t,be,e),s(t,k,e),s(t,fe,e),s(t,V,e),s(t,ge,e),u(W,t,e),s(t,je,e),s(t,G,e),s(t,Ie,e),u(R,t,e),s(t,Ce,e),u($,t,e),s(t,ve,e),s(t,H,e),s(t,Ze,e),s(t,x,e),s(t,Be,e),s(t,N,e),s(t,ke,e),u(E,t,e),s(t,Ve,e),s(t,Q,e),s(t,We,e),u(S,t,e),s(t,Ge,e),s(t,_,e),s(t,Re,e),u(X,t,e),s(t,$e,e),u(F,t,e),s(t,He,e),s(t,Y,e),s(t,xe,e),u(L,t,e),s(t,Ne,e),s(t,A,e),s(t,Ee,e),s(t,z,e),s(t,Qe,e),s(t,q,e),s(t,Se,e),s(t,P,e),s(t,_e,e),u(D,t,e),s(t,Xe,e),s(t,K,e),s(t,Fe,e),u(O,t,e),s(t,Ye,e),u(tt,t,e),s(t,Le,e),s(t,et,e),s(t,Ae,e),s(t,lt,e),s(t,ze,e),s(t,st,e),s(t,qe,e),s(t,nt,e),s(t,Pe,e),s(t,at,e),s(t,De,e),u(it,t,e),s(t,Ke,e),s(t,ot,e),s(t,Oe,e),u(rt,t,e),s(t,tl,e),s(t,pt,e),s(t,el,e),s(t,Mt,e),s(t,ll,e),u(ut,t,e),s(t,sl,e),s(t,yt,e),s(t,nl,e),s(t,ct,e),s(t,al,e),s(t,mt,e),s(t,il,e),u(Tt,t,e),s(t,ol,e),s(t,Jt,e),s(t,rl,e),s(t,wt,e),s(t,pl,e),s(t,dt,e),s(t,Ml,e),u(Ut,t,e),s(t,ul,e),s(t,ht,e),s(t,yl,e),u(bt,t,e),s(t,cl,e),s(t,ft,e),s(t,ml,e),u(gt,t,e),s(t,Tl,e),s(t,jt,e),s(t,Jl,e),s(t,It,e),s(t,wl,e),u(Ct,t,e),s(t,dl,e),s(t,vt,e),s(t,Ul,e),s(t,Zt,e),s(t,hl,e),u(Bt,t,e),s(t,bl,e),s(t,kt,e),s(t,fl,e),s(t,Vt,e),s(t,gl,e),s(t,Wt,e),s(t,jl,e),s(t,Gt,e),s(t,Il,e),s(t,Rt,e),s(t,Cl,e),u($t,t,e),s(t,vl,e),s(t,Ht,e),s(t,Zl,e),s(t,xt,e),s(t,Bl,e),u(Nt,t,e),s(t,kl,e),s(t,Et,e),s(t,Vl,e),s(t,Qt,e),s(t,Wl,e),u(St,t,e),s(t,Gl,e),s(t,_t,e),s(t,Rl,e),u(Xt,t,e),s(t,$l,e),s(t,Ft,e),s(t,Hl,e),s(t,Yt,e),s(t,xl,e),s(t,Lt,e),s(t,Nl,e),u(At,t,e),s(t,El,e),s(t,zt,e),s(t,Ql,e),u(qt,t,e),s(t,Sl,e),u(Pt,t,e),s(t,_l,e),s(t,Dt,e),s(t,Xl,e),u(Kt,t,e),s(t,Fl,e),s(t,Ot,e),s(t,Yl,e),s(t,te,e),s(t,Ll,e),s(t,ee,e),s(t,Al,e),u(le,t,e),s(t,zl,e),u(se,t,e),s(t,ql,e),s(t,ne,e),s(t,Pl,e),s(t,ae,e),s(t,Dl,e),s(t,ie,e),s(t,Kl,e),s(t,oe,e),s(t,Ol,e),u(re,t,e),s(t,ts,e),s(t,pe,e),s(t,es,e),s(t,Me,e),s(t,ls,e),s(t,ue,e),s(t,ss,e),u(ye,t,e),s(t,ns,e),s(t,ce,e),as=!0},p(t,[e]){const wn={};e&2&&(wn.$$scope={dirty:e,ctx:t}),g.$set(wn)},i(t){as||(y(J.$$.fragment,t),y(j.$$.fragment,t),y(g.$$.fragment,t),y(Z.$$.fragment,t),y(W.$$.fragment,t),y(R.$$.fragment,t),y($.$$.fragment,t),y(E.$$.fragment,t),y(S.$$.fragment,t),y(X.$$.fragment,t),y(F.$$.fragment,t),y(L.$$.fragment,t),y(D.$$.fragment,t),y(O.$$.fragment,t),y(tt.$$.fragment,t),y(it.$$.fragment,t),y(rt.$$.fragment,t),y(ut.$$.fragment,t),y(Tt.$$.fragment,t),y(Ut.$$.fragment,t),y(bt.$$.fragment,t),y(gt.$$.fragment,t),y(Ct.$$.fragment,t),y(Bt.$$.fragment,t),y($t.$$.fragment,t),y(Nt.$$.fragment,t),y(St.$$.fragment,t),y(Xt.$$.fragment,t),y(At.$$.fragment,t),y(qt.$$.fragment,t),y(Pt.$$.fragment,t),y(Kt.$$.fragment,t),y(le.$$.fragment,t),y(se.$$.fragment,t),y(re.$$.fragment,t),y(ye.$$.fragment,t),as=!0)},o(t){c(J.$$.fragment,t),c(j.$$.fragment,t),c(g.$$.fragment,t),c(Z.$$.fragment,t),c(W.$$.fragment,t),c(R.$$.fragment,t),c($.$$.fragment,t),c(E.$$.fragment,t),c(S.$$.fragment,t),c(X.$$.fragment,t),c(F.$$.fragment,t),c(L.$$.fragment,t),c(D.$$.fragment,t),c(O.$$.fragment,t),c(tt.$$.fragment,t),c(it.$$.fragment,t),c(rt.$$.fragment,t),c(ut.$$.fragment,t),c(Tt.$$.fragment,t),c(Ut.$$.fragment,t),c(bt.$$.fragment,t),c(gt.$$.fragment,t),c(Ct.$$.fragment,t),c(Bt.$$.fragment,t),c($t.$$.fragment,t),c(Nt.$$.fragment,t),c(St.$$.fragment,t),c(Xt.$$.fragment,t),c(At.$$.fragment,t),c(qt.$$.fragment,t),c(Pt.$$.fragment,t),c(Kt.$$.fragment,t),c(le.$$.fragment,t),c(se.$$.fragment,t),c(re.$$.fragment,t),c(ye.$$.fragment,t),as=!1},d(t){t&&(l(d),l(b),l(h),l(f),l(Te),l(Je),l(I),l(we),l(C),l(de),l(v),l(Ue),l(he),l(B),l(be),l(k),l(fe),l(V),l(ge),l(je),l(G),l(Ie),l(Ce),l(ve),l(H),l(Ze),l(x),l(Be),l(N),l(ke),l(Ve),l(Q),l(We),l(Ge),l(_),l(Re),l($e),l(He),l(Y),l(xe),l(Ne),l(A),l(Ee),l(z),l(Qe),l(q),l(Se),l(P),l(_e),l(Xe),l(K),l(Fe),l(Ye),l(Le),l(et),l(Ae),l(lt),l(ze),l(st),l(qe),l(nt),l(Pe),l(at),l(De),l(Ke),l(ot),l(Oe),l(tl),l(pt),l(el),l(Mt),l(ll),l(sl),l(yt),l(nl),l(ct),l(al),l(mt),l(il),l(ol),l(Jt),l(rl),l(wt),l(pl),l(dt),l(Ml),l(ul),l(ht),l(yl),l(cl),l(ft),l(ml),l(Tl),l(jt),l(Jl),l(It),l(wl),l(dl),l(vt),l(Ul),l(Zt),l(hl),l(bl),l(kt),l(fl),l(Vt),l(gl),l(Wt),l(jl),l(Gt),l(Il),l(Rt),l(Cl),l(vl),l(Ht),l(Zl),l(xt),l(Bl),l(kl),l(Et),l(Vl),l(Qt),l(Wl),l(Gl),l(_t),l(Rl),l($l),l(Ft),l(Hl),l(Yt),l(xl),l(Lt),l(Nl),l(El),l(zt),l(Ql),l(Sl),l(_l),l(Dt),l(Xl),l(Fl),l(Ot),l(Yl),l(te),l(Ll),l(ee),l(Al),l(zl),l(ql),l(ne),l(Pl),l(ae),l(Dl),l(ie),l(Kl),l(oe),l(Ol),l(ts),l(pe),l(es),l(Me),l(ls),l(ue),l(ss),l(ns),l(ce)),l(w),m(J,t),m(j,t),m(g,t),m(Z,t),m(W,t),m(R,t),m($,t),m(E,t),m(S,t),m(X,t),m(F,t),m(L,t),m(D,t),m(O,t),m(tt,t),m(it,t),m(rt,t),m(ut,t),m(Tt,t),m(Ut,t),m(bt,t),m(gt,t),m(Ct,t),m(Bt,t),m($t,t),m(Nt,t),m(St,t),m(Xt,t),m(At,t),m(qt,t),m(Pt,t),m(Kt,t),m(le,t),m(se,t),m(re,t),m(ye,t)}}}const Gn='{"title":"Bonus Unit 2: Observability and Evaluation of Agents","local":"bonus-unit-2-observability-and-evaluation-of-agents","sections":[{"title":"Exercise Prerequisites 🏗️","local":"exercise-prerequisites-","sections":[],"depth":2},{"title":"Step 0: Install the Required Libraries","local":"step-0-install-the-required-libraries","sections":[],"depth":2},{"title":"Step 1: Instrument Your Agent","local":"step-1-instrument-your-agent","sections":[],"depth":2},{"title":"Step 2: Test Your Instrumentation","local":"step-2-test-your-instrumentation","sections":[],"depth":2},{"title":"Step 3: Observe and Evaluate a More Complex Agent","local":"step-3-observe-and-evaluate-a-more-complex-agent","sections":[{"title":"Trace Structure","local":"trace-structure","sections":[],"depth":3}],"depth":2},{"title":"Online Evaluation","local":"online-evaluation","sections":[{"title":"Common Metrics to Track in Production","local":"common-metrics-to-track-in-production","sections":[{"title":"1. Costs","local":"1-costs","sections":[],"depth":4},{"title":"2. Latency","local":"2-latency","sections":[],"depth":4},{"title":"3. Additional Attributes","local":"3-additional-attributes","sections":[],"depth":4},{"title":"4. User Feedback","local":"4-user-feedback","sections":[],"depth":4},{"title":"5. LLM-as-a-Judge","local":"5-llm-as-a-judge","sections":[],"depth":4},{"title":"6. Observability Metrics Overview","local":"6-observability-metrics-overview","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Offline Evaluation","local":"offline-evaluation","sections":[{"title":"Dataset Evaluation","local":"dataset-evaluation","sections":[{"title":"Running the Agent on the Dataset","local":"running-the-agent-on-the-dataset","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Final Thoughts","local":"final-thoughts","sections":[],"depth":2}],"depth":1}';function Rn(me){return fn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _n extends jn{constructor(w){super(),In(this,w,Rn,Wn,bn,{})}}export{_n as component};
