import{s as Ls,n as Ds,o as Ks}from"../chunks/scheduler.7bc62968.js";import{S as Ps,i as Os,g as J,s as t,r as p,A as sl,h,f as a,c as e,j as _s,x as r,u as i,k as Es,y as ll,a as n,v as c,d as M,t as o,w as y}from"../chunks/index.66556066.js";import{C as m}from"../chunks/CodeBlock.a759539a.js";import{H as j,E as al}from"../chunks/EditOnGithub.46ca76a5.js";function nl(Rs){let U,O,K,ss,T,Vs='<br/> <picture><source media="(prefers-color-scheme: dark)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-dark.svg"/> <source media="(prefers-color-scheme: light)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg"/> <img alt="huggingface javascript library logo" src="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg" width="376" height="59" style="max-width: 100%;"/></picture> <br/> <br/>',ls,u,as,w,ns,d,Ys="This is a collection of JS libraries to interact with the Hugging Face API, with TS types included.",ts,g,$s='<li><a href="inference/README">@huggingface/inference</a>: Use HF Inference API (serverless), Inference Endpoints (dedicated) and all supported Inference Providers to make calls to 100,000+ Machine Learning models</li> <li><a href="hub/README">@huggingface/hub</a>: Interact with huggingface.co to create or delete repos and commit / download files</li> <li><a href="agents/README">@huggingface/agents</a>: Interact with HF models through a natural language interface</li> <li><a href="gguf/README">@huggingface/gguf</a>: A GGUF parser that works on remotely hosted files.</li> <li><a href="dduf/README">@huggingface/dduf</a>: Similar package for DDUF (DDUF Diffusers Unified Format)</li> <li><a href="tasks/README">@huggingface/tasks</a>: The definition files and source-of-truth for the Hub’s main primitives like pipeline tasks, model libraries, etc.</li> <li><a href="jinja/README">@huggingface/jinja</a>: A minimalistic JS implementation of the Jinja templating engine, to be used for ML chat templates.</li> <li><a href="space-header/README">@huggingface/space-header</a>: Use the Space <code>mini_header</code> outside Hugging Face</li> <li><a href="ollama-utils/README">@huggingface/ollama-utils</a>: Various utilities for maintaining Ollama compatibility with models on the Hugging Face Hub.</li>',es,b,vs="We use modern features to avoid polyfills and dependencies, so the libraries will only work on modern browsers / Node.js >= 18 / Bun / Deno.",ps,I,Xs="The libraries are still very young, please help us by opening issues!",is,f,cs,B,Ms,G,Fs="To install via NPM, you can download the libraries as needed:",os,Z,ys,C,Hs="Then import the libraries in your code:",Js,Q,hs,W,rs,N,qs='You can run our packages with vanilla JS, without any bundler, by using a CDN or static hosting. Using <a href="https://hacks.mozilla.org/2018/03/es-modules-a-cartoon-deep-dive/" rel="nofollow">ES modules</a>, i.e. <code>&lt;script type=&quot;module&quot;&gt;</code>, you can import the libraries in your code:',js,k,ms,S,Us,E,Ts,R,us,V,xs='Get your HF access token in your <a href="https://huggingface.co/settings/tokens" rel="nofollow">account settings</a>.',ws,Y,ds,$,gs,v,bs,X,Is,F,fs,H,Bs,q,zs="There are more features of course, check each library’s README!",Gs,x,Zs,z,Cs,A,Qs,_,Ws,L,As="This will generate ESM and CJS javascript files in <code>packages/*/dist</code>, eg <code>packages/inference/dist/index.mjs</code>.",Ns,D,ks,P,Ss;return u=new m({props:{code:"JTJGJTJGJTIwUHJvZ3JhbW1hdGljYWxseSUyMGludGVyYWN0JTIwd2l0aCUyMHRoZSUyMEh1YiUwQSUwQWF3YWl0JTIwY3JlYXRlUmVwbyglN0IlMEElMjAlMjByZXBvJTNBJTIwJTdCJTIwdHlwZSUzQSUyMCUyMm1vZGVsJTIyJTJDJTIwbmFtZSUzQSUyMCUyMm15LXVzZXIlMkZubHAtbW9kZWwlMjIlMjAlN0QlMkMlMEElMjAlMjBhY2Nlc3NUb2tlbiUzQSUyMEhGX1RPS0VOJTBBJTdEKSUzQiUwQSUwQWF3YWl0JTIwdXBsb2FkRmlsZSglN0IlMEElMjAlMjByZXBvJTNBJTIwJTIybXktdXNlciUyRm5scC1tb2RlbCUyMiUyQyUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMkMlMEElMjAlMjAlMkYlMkYlMjBDYW4lMjB3b3JrJTIwd2l0aCUyMG5hdGl2ZSUyMEZpbGUlMjBpbiUyMGJyb3dzZXJzJTBBJTIwJTIwZmlsZSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhdGglM0ElMjAlMjJweXRvcmNoX21vZGVsLmJpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlM0ElMjBuZXclMjBCbG9iKC4uLiklMEElMjAlMjAlN0QlMEElN0QpJTNCJTBBJTBBJTJGJTJGJTIwVXNlJTIwSEYlMjBJbmZlcmVuY2UlMjBBUEklMkMlMjBvciUyMGV4dGVybmFsJTIwSW5mZXJlbmNlJTIwUHJvdmlkZXJzISUwQSUwQWF3YWl0JTIwaW5mZXJlbmNlLmNoYXRDb21wbGV0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMHByb3ZpZGVyJTNBJTIwJTIyc2FtYmFub3ZhJTIyJTJDJTIwJTJGJTJGJTIwb3IlMjB0b2dldGhlciUyQyUyMGZhbC1haSUyQyUyMHJlcGxpY2F0ZSUyQyUyMGNvaGVyZSUyMCVFMiU4MCVBNiUwQSUyMCUyMG1lc3NhZ2VzJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwcm9sZSUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBjb250ZW50JTNBJTIwJTIySGVsbG8lMkMlMjBuaWNlJTIwdG8lMjBtZWV0JTIweW91ISUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMG1heF90b2tlbnMlM0ElMjA1MTIlMkMlMEElMjAlMjB0ZW1wZXJhdHVyZSUzQSUyMDAuNSUyQyUwQSU3RCklM0IlMEElMEFhd2FpdCUyMGluZmVyZW5jZS50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMHByb3ZpZGVyJTNBJTIwJTIycmVwbGljYXRlJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTIyYSUyMHBpY3R1cmUlMjBvZiUyMGElMjBncmVlbiUyMGJpcmQlMjIlMkMlMEElN0QpJTNCJTBBJTBBJTJGJTJGJTIwYW5kJTIwbXVjaCUyMG1vcmUlRTIlODAlQTY=",highlighted:`<span class="hljs-comment">// Programmatically interact with the Hub</span>

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span> },
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...)
  }
});

<span class="hljs-comment">// Use HF Inference API, or external Inference Providers!</span>

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;sambanova&quot;</span>, <span class="hljs-comment">// or together, fal-ai, replicate, cohere …</span>
  <span class="hljs-attr">messages</span>: [
    {
      <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span>,
    },
  ],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.5</span>,
});

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;replicate&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;a picture of a green bird&quot;</span>,
});

<span class="hljs-comment">// and much more…</span>`,wrap:!1}}),w=new j({props:{title:"Hugging Face JS libraries",local:"hugging-face-js-libraries",headingTag:"h1"}}),f=new j({props:{title:"Installation",local:"installation",headingTag:"h2"}}),B=new j({props:{title:"From NPM",local:"from-npm",headingTag:"h3"}}),Z=new m({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRz",highlighted:`npm install @huggingface/inference
npm install @huggingface/hub
npm install @huggingface/agents`,wrap:!1}}),Q=new m({props:{code:"aW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTIyJTNCJTBBaW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQWltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNCJTBBaW1wb3J0JTIwdHlwZSUyMCU3QiUyMFJlcG9JZCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQg==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;
<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoId</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;`,wrap:!1}}),W=new j({props:{title:"From CDN or Static hosting",local:"from-cdn-or-static-hosting",headingTag:"h3"}}),k=new m({props:{code:"JTNDc2NyaXB0JTIwdHlwZSUzRCUyMm1vZHVsZSUyMiUzRSUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMEluZmVyZW5jZUNsaWVudCUyMCU3RCUyMGZyb20lMjAnaHR0cHMlM0ElMkYlMkZjZG4uanNkZWxpdnIubmV0JTJGbnBtJTJGJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlNDAzLjYuMiUyRiUyQmVzbSclM0IlMEElMjAlMjAlMjAlMjBpbXBvcnQlMjAlN0IlMjBjcmVhdGVSZXBvJTJDJTIwY29tbWl0JTJDJTIwZGVsZXRlUmVwbyUyQyUyMGxpc3RGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjJodHRwcyUzQSUyRiUyRmNkbi5qc2RlbGl2ci5uZXQlMkZucG0lMkYlNDBodWdnaW5nZmFjZSUyRmh1YiU0MDEuMS4yJTJGJTJCZXNtJTIyJTNCJTBBJTNDJTJGc2NyaXB0JTNF",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;module&quot;</span>&gt;</span><span class="language-javascript">
    <span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;https://cdn.jsdelivr.net/npm/@huggingface/inference@3.6.2/+esm&#x27;</span>;
    <span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/@huggingface/hub@1.1.2/+esm&quot;</span>;
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>`,wrap:!1}}),S=new j({props:{title:"Deno",local:"deno",headingTag:"h3"}}),E=new m({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlMEFpbXBvcnQlMjAlN0IlMjBIZkFnZW50JTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZhZ2VudHMlMjIlM0IlMEElMEFpbXBvcnQlMjAlN0IlMjBjcmVhdGVSZXBvJTJDJTIwY29tbWl0JTJDJTIwZGVsZXRlUmVwbyUyQyUyMGxpc3RGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjJodHRwcyUzQSUyRiUyRmVzbS5zaCUyRiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTBBJTJGJTJGJTIwb3IlMjBucG0lM0ElMEFpbXBvcnQlMjAlN0IlMjBJbmZlcmVuY2VDbGllbnQlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlMEFpbXBvcnQlMjAlN0IlMjBIZkFnZW50JTIwJTdEJTIwZnJvbSUyMCUyMm5wbSUzQSU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJTIyJTNCJTBBJTBBaW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMGNvbW1pdCUyQyUyMGRlbGV0ZVJlcG8lMkMlMjBsaXN0RmlsZXMlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjI=",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/agents&quot;</span>;

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/agents&quot;</span>;

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),R=new j({props:{title:"Usage examples",local:"usage-examples",headingTag:"h2"}}),Y=new j({props:{title:"@huggingface/inference examples",local:"huggingfaceinference-examples",headingTag:"h3"}}),$=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> inference = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

<span class="hljs-comment">// Chat completion API</span>
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>
});
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>);

<span class="hljs-comment">// Streaming chat completion API</span>
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> inference.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>);
}

<span class="hljs-comment">/// Using a third-party provider:</span>
<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;sambanova&quot;</span>, <span class="hljs-comment">// or together, fal-ai, replicate, cohere …</span>
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;a picture of a green bird&quot;</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;fal-ai&quot;</span>,
})



<span class="hljs-comment">// You can also omit &quot;model&quot; to use the recommended model for the task</span>
<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;My name is Wolfgang and I live in Amsterdam&quot;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&quot;en&quot;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&quot;fr&quot;</span>,
  },
});

<span class="hljs-comment">// pass multimodal files or URLs as inputs</span>
<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://picsum.photos/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
})

<span class="hljs-comment">// Using your own dedicated inference endpoint: https://hf.co/docs/inference-endpoints/</span>
<span class="hljs-keyword">const</span> gpt2 = inference.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({ <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span> });

<span class="hljs-comment">// Chat Completion</span>
<span class="hljs-keyword">const</span> llamaEndpoint = inference.<span class="hljs-title function_">endpoint</span>(
  <span class="hljs-string">&quot;https://router.huggingface.co/hf-inference/models/meta-llama/Llama-3.1-8B-Instruct&quot;</span>
);
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> llamaEndpoint.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
});
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>);`,wrap:!1}}),v=new j({props:{title:"@huggingface/hub examples",local:"huggingfacehub-examples",headingTag:"h3"}}),X=new m({props:{code:"aW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMHVwbG9hZEZpbGUlMkMlMjBkZWxldGVGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwSEZfVE9LRU4lMjAlM0QlMjAlMjJoZl8uLi4lMjIlM0IlMEElMEFhd2FpdCUyMGNyZWF0ZVJlcG8oJTdCJTBBJTIwJTIwcmVwbyUzQSUyMCUyMm15LXVzZXIlMkZubHAtbW9kZWwlMjIlMkMlMjAlMkYlMkYlMjBvciUyMCU3QiUyMHR5cGUlM0ElMjAlMjJtb2RlbCUyMiUyQyUyMG5hbWUlM0ElMjAlMjJteS11c2VyJTJGbmxwLXRlc3QlMjIlMjAlN0QlMkMlMEElMjAlMjBhY2Nlc3NUb2tlbiUzQSUyMEhGX1RPS0VOJTBBJTdEKSUzQiUwQSUwQWF3YWl0JTIwdXBsb2FkRmlsZSglN0IlMEElMjAlMjByZXBvJTNBJTIwJTIybXktdXNlciUyRm5scC1tb2RlbCUyMiUyQyUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMkMlMEElMjAlMjAlMkYlMkYlMjBDYW4lMjB3b3JrJTIwd2l0aCUyMG5hdGl2ZSUyMEZpbGUlMjBpbiUyMGJyb3dzZXJzJTBBJTIwJTIwZmlsZSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhdGglM0ElMjAlMjJweXRvcmNoX21vZGVsLmJpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlM0ElMjBuZXclMjBCbG9iKC4uLiklMEElMjAlMjAlN0QlMEElN0QpJTNCJTBBJTBBYXdhaXQlMjBkZWxldGVGaWxlcyglN0IlMEElMjAlMjByZXBvJTNBJTIwJTdCJTIwdHlwZSUzQSUyMCUyMnNwYWNlJTIyJTJDJTIwbmFtZSUzQSUyMCUyMm15LXVzZXIlMkZteS1zcGFjZSUyMiUyMCU3RCUyQyUyMCUyRiUyRiUyMG9yJTIwJTIyc3BhY2VzJTJGbXktdXNlciUyRm15LXNwYWNlJTIyJTBBJTIwJTIwYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiUyQyUwQSUyMCUyMHBhdGhzJTNBJTIwJTVCJTIyUkVBRE1FLm1kJTIyJTJDJTIwJTIyLmdpdGF0dHJpYnV0ZXMlMjIlNUQlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFile, deleteFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>, <span class="hljs-comment">// or { type: &quot;model&quot;, name: &quot;my-user/nlp-test&quot; },</span>
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...)
  }
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFiles</span>({
  <span class="hljs-attr">repo</span>: { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;space&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/my-space&quot;</span> }, <span class="hljs-comment">// or &quot;spaces/my-user/my-space&quot;</span>
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-attr">paths</span>: [<span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-string">&quot;.gitattributes&quot;</span>]
});`,wrap:!1}}),F=new j({props:{title:"@huggingface/agents example",local:"huggingfaceagents-example",headingTag:"h3"}}),H=new m({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyQyUyMExMTUZyb21IdWIlMkMlMjBkZWZhdWx0VG9vbHMlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJyUzQiUwQSUwQWNvbnN0JTIwSEZfVE9LRU4lMjAlM0QlMjAlMjJoZl8uLi4lMjIlM0IlMEElMEFjb25zdCUyMGFnZW50JTIwJTNEJTIwbmV3JTIwSGZBZ2VudCglMEElMjAlMjBIRl9UT0tFTiUyQyUwQSUyMCUyMExMTUZyb21IdWIoSEZfVE9LRU4pJTJDJTBBJTIwJTIwJTVCLi4uZGVmYXVsdFRvb2xzJTVEJTBBKSUzQiUwQSUwQSUwQSUyRiUyRiUyMHlvdSUyMGNhbiUyMGdlbmVyYXRlJTIwdGhlJTIwY29kZSUyQyUyMGluc3BlY3QlMjBpdCUyMGFuZCUyMHRoZW4lMjBydW4lMjBpdCUwQWNvbnN0JTIwY29kZSUyMCUzRCUyMGF3YWl0JTIwYWdlbnQuZ2VuZXJhdGVDb2RlKCUyMkRyYXclMjBhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGNhdCUyMHdlYXJpbmclMjBhJTIwdG9wJTIwaGF0LiUyMFRoZW4lMjBjYXB0aW9uJTIwdGhlJTIwcGljdHVyZSUyMGFuZCUyMHJlYWQlMjBpdCUyMG91dCUyMGxvdWQuJTIyKSUzQiUwQWNvbnNvbGUubG9nKGNvZGUpJTNCJTBBY29uc3QlMjBtZXNzYWdlcyUyMCUzRCUyMGF3YWl0JTIwYWdlbnQuZXZhbHVhdGVDb2RlKGNvZGUpJTBBY29uc29sZS5sb2cobWVzc2FnZXMpJTNCJTIwJTJGJTJGJTIwY29udGFpbnMlMjB0aGUlMjBkYXRhJTBBJTBBJTJGJTJGJTIwb3IlMjB5b3UlMjBjYW4lMjBydW4lMjB0aGUlMjBjb2RlJTIwZGlyZWN0bHklMkMlMjBob3dldmVyJTIweW91JTIwY2FuJ3QlMjBjaGVjayUyMHRoYXQlMjB0aGUlMjBjb2RlJTIwaXMlMjBzYWZlJTIwdG8lMjBleGVjdXRlJTIwdGhpcyUyMHdheSUyQyUyMHVzZSUyMGF0JTIweW91ciUyMG93biUyMHJpc2suJTBBY29uc3QlMjBtZXNzYWdlcyUyMCUzRCUyMGF3YWl0JTIwYWdlbnQucnVuKCUyMkRyYXclMjBhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGNhdCUyMHdlYXJpbmclMjBhJTIwdG9wJTIwaGF0LiUyMFRoZW4lMjBjYXB0aW9uJTIwdGhlJTIwcGljdHVyZSUyMGFuZCUyMHJlYWQlMjBpdCUyMG91dCUyMGxvdWQuJTIyKSUwQWNvbnNvbGUubG9nKG1lc3NhZ2VzKSUzQg==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span>, <span class="hljs-title class_">LLMFromHub</span>, defaultTools } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/agents&#x27;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(
  <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-title class_">LLMFromHub</span>(<span class="hljs-variable constant_">HF_TOKEN</span>),
  [...defaultTools]
);


<span class="hljs-comment">// you can generate the code, inspect it and then run it</span>
<span class="hljs-keyword">const</span> code = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">generateCode</span>(<span class="hljs-string">&quot;Draw a picture of a cat wearing a top hat. Then caption the picture and read it out loud.&quot;</span>);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(code);
<span class="hljs-keyword">const</span> messages = <span class="hljs-keyword">await</span> agent.evaluateCode(code)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(messages); <span class="hljs-comment">// contains the data</span>

<span class="hljs-comment">// or you can run the code directly, however you can&#x27;t check that the code is safe to execute this way, use at your own risk.</span>
<span class="hljs-keyword">const</span> messages = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">run</span>(<span class="hljs-string">&quot;Draw a picture of a cat wearing a top hat. Then caption the picture and read it out loud.&quot;</span>)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(messages);`,wrap:!1}}),x=new j({props:{title:"Formatting & testing",local:"formatting--testing",headingTag:"h2"}}),z=new m({props:{code:"c3VkbyUyMGNvcmVwYWNrJTIwZW5hYmxlJTBBcG5wbSUyMGluc3RhbGwlMEElMEFwbnBtJTIwLXIlMjBmb3JtYXQlM0FjaGVjayUwQXBucG0lMjAtciUyMGxpbnQlM0FjaGVjayUwQXBucG0lMjAtciUyMHRlc3Q=",highlighted:`sudo corepack enable
pnpm install

pnpm -r format:check
pnpm -r lint:check
pnpm -r test`,wrap:!1}}),A=new j({props:{title:"Building",local:"building",headingTag:"h2"}}),_=new m({props:{code:"cG5wbSUyMC1yJTIwYnVpbGQ=",highlighted:'<span class="hljs-attribute">pnpm -r build</span>',wrap:!1}}),D=new al({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/index.md"}}),{c(){U=J("meta"),O=t(),K=J("p"),ss=t(),T=J("p"),T.innerHTML=Vs,ls=t(),p(u.$$.fragment),as=t(),p(w.$$.fragment),ns=t(),d=J("p"),d.textContent=Ys,ts=t(),g=J("ul"),g.innerHTML=$s,es=t(),b=J("p"),b.textContent=vs,ps=t(),I=J("p"),I.textContent=Xs,is=t(),p(f.$$.fragment),cs=t(),p(B.$$.fragment),Ms=t(),G=J("p"),G.textContent=Fs,os=t(),p(Z.$$.fragment),ys=t(),C=J("p"),C.textContent=Hs,Js=t(),p(Q.$$.fragment),hs=t(),p(W.$$.fragment),rs=t(),N=J("p"),N.innerHTML=qs,js=t(),p(k.$$.fragment),ms=t(),p(S.$$.fragment),Us=t(),p(E.$$.fragment),Ts=t(),p(R.$$.fragment),us=t(),V=J("p"),V.innerHTML=xs,ws=t(),p(Y.$$.fragment),ds=t(),p($.$$.fragment),gs=t(),p(v.$$.fragment),bs=t(),p(X.$$.fragment),Is=t(),p(F.$$.fragment),fs=t(),p(H.$$.fragment),Bs=t(),q=J("p"),q.textContent=zs,Gs=t(),p(x.$$.fragment),Zs=t(),p(z.$$.fragment),Cs=t(),p(A.$$.fragment),Qs=t(),p(_.$$.fragment),Ws=t(),L=J("p"),L.innerHTML=As,Ns=t(),p(D.$$.fragment),ks=t(),P=J("p"),this.h()},l(s){const l=sl("svelte-u9bgzb",document.head);U=h(l,"META",{name:!0,content:!0}),l.forEach(a),O=e(s),K=h(s,"P",{}),_s(K).forEach(a),ss=e(s),T=h(s,"P",{align:!0,"data-svelte-h":!0}),r(T)!=="svelte-9rngw"&&(T.innerHTML=Vs),ls=e(s),i(u.$$.fragment,s),as=e(s),i(w.$$.fragment,s),ns=e(s),d=h(s,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1eufct4"&&(d.textContent=Ys),ts=e(s),g=h(s,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-1x3ho6d"&&(g.innerHTML=$s),es=e(s),b=h(s,"P",{"data-svelte-h":!0}),r(b)!=="svelte-5pb56g"&&(b.textContent=vs),ps=e(s),I=h(s,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1vx14v7"&&(I.textContent=Xs),is=e(s),i(f.$$.fragment,s),cs=e(s),i(B.$$.fragment,s),Ms=e(s),G=h(s,"P",{"data-svelte-h":!0}),r(G)!=="svelte-18mxf19"&&(G.textContent=Fs),os=e(s),i(Z.$$.fragment,s),ys=e(s),C=h(s,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1fdwpsr"&&(C.textContent=Hs),Js=e(s),i(Q.$$.fragment,s),hs=e(s),i(W.$$.fragment,s),rs=e(s),N=h(s,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1td2f08"&&(N.innerHTML=qs),js=e(s),i(k.$$.fragment,s),ms=e(s),i(S.$$.fragment,s),Us=e(s),i(E.$$.fragment,s),Ts=e(s),i(R.$$.fragment,s),us=e(s),V=h(s,"P",{"data-svelte-h":!0}),r(V)!=="svelte-mx6w21"&&(V.innerHTML=xs),ws=e(s),i(Y.$$.fragment,s),ds=e(s),i($.$$.fragment,s),gs=e(s),i(v.$$.fragment,s),bs=e(s),i(X.$$.fragment,s),Is=e(s),i(F.$$.fragment,s),fs=e(s),i(H.$$.fragment,s),Bs=e(s),q=h(s,"P",{"data-svelte-h":!0}),r(q)!=="svelte-16qnxzd"&&(q.textContent=zs),Gs=e(s),i(x.$$.fragment,s),Zs=e(s),i(z.$$.fragment,s),Cs=e(s),i(A.$$.fragment,s),Qs=e(s),i(_.$$.fragment,s),Ws=e(s),L=h(s,"P",{"data-svelte-h":!0}),r(L)!=="svelte-ymfi8c"&&(L.innerHTML=As),Ns=e(s),i(D.$$.fragment,s),ks=e(s),P=h(s,"P",{}),_s(P).forEach(a),this.h()},h(){Es(U,"name","hf:doc:metadata"),Es(U,"content",tl),Es(T,"align","center")},m(s,l){ll(document.head,U),n(s,O,l),n(s,K,l),n(s,ss,l),n(s,T,l),n(s,ls,l),c(u,s,l),n(s,as,l),c(w,s,l),n(s,ns,l),n(s,d,l),n(s,ts,l),n(s,g,l),n(s,es,l),n(s,b,l),n(s,ps,l),n(s,I,l),n(s,is,l),c(f,s,l),n(s,cs,l),c(B,s,l),n(s,Ms,l),n(s,G,l),n(s,os,l),c(Z,s,l),n(s,ys,l),n(s,C,l),n(s,Js,l),c(Q,s,l),n(s,hs,l),c(W,s,l),n(s,rs,l),n(s,N,l),n(s,js,l),c(k,s,l),n(s,ms,l),c(S,s,l),n(s,Us,l),c(E,s,l),n(s,Ts,l),c(R,s,l),n(s,us,l),n(s,V,l),n(s,ws,l),c(Y,s,l),n(s,ds,l),c($,s,l),n(s,gs,l),c(v,s,l),n(s,bs,l),c(X,s,l),n(s,Is,l),c(F,s,l),n(s,fs,l),c(H,s,l),n(s,Bs,l),n(s,q,l),n(s,Gs,l),c(x,s,l),n(s,Zs,l),c(z,s,l),n(s,Cs,l),c(A,s,l),n(s,Qs,l),c(_,s,l),n(s,Ws,l),n(s,L,l),n(s,Ns,l),c(D,s,l),n(s,ks,l),n(s,P,l),Ss=!0},p:Ds,i(s){Ss||(M(u.$$.fragment,s),M(w.$$.fragment,s),M(f.$$.fragment,s),M(B.$$.fragment,s),M(Z.$$.fragment,s),M(Q.$$.fragment,s),M(W.$$.fragment,s),M(k.$$.fragment,s),M(S.$$.fragment,s),M(E.$$.fragment,s),M(R.$$.fragment,s),M(Y.$$.fragment,s),M($.$$.fragment,s),M(v.$$.fragment,s),M(X.$$.fragment,s),M(F.$$.fragment,s),M(H.$$.fragment,s),M(x.$$.fragment,s),M(z.$$.fragment,s),M(A.$$.fragment,s),M(_.$$.fragment,s),M(D.$$.fragment,s),Ss=!0)},o(s){o(u.$$.fragment,s),o(w.$$.fragment,s),o(f.$$.fragment,s),o(B.$$.fragment,s),o(Z.$$.fragment,s),o(Q.$$.fragment,s),o(W.$$.fragment,s),o(k.$$.fragment,s),o(S.$$.fragment,s),o(E.$$.fragment,s),o(R.$$.fragment,s),o(Y.$$.fragment,s),o($.$$.fragment,s),o(v.$$.fragment,s),o(X.$$.fragment,s),o(F.$$.fragment,s),o(H.$$.fragment,s),o(x.$$.fragment,s),o(z.$$.fragment,s),o(A.$$.fragment,s),o(_.$$.fragment,s),o(D.$$.fragment,s),Ss=!1},d(s){s&&(a(O),a(K),a(ss),a(T),a(ls),a(as),a(ns),a(d),a(ts),a(g),a(es),a(b),a(ps),a(I),a(is),a(cs),a(Ms),a(G),a(os),a(ys),a(C),a(Js),a(hs),a(rs),a(N),a(js),a(ms),a(Us),a(Ts),a(us),a(V),a(ws),a(ds),a(gs),a(bs),a(Is),a(fs),a(Bs),a(q),a(Gs),a(Zs),a(Cs),a(Qs),a(Ws),a(L),a(Ns),a(ks),a(P)),a(U),y(u,s),y(w,s),y(f,s),y(B,s),y(Z,s),y(Q,s),y(W,s),y(k,s),y(S,s),y(E,s),y(R,s),y(Y,s),y($,s),y(v,s),y(X,s),y(F,s),y(H,s),y(x,s),y(z,s),y(A,s),y(_,s),y(D,s)}}}const tl='{"title":"Hugging Face JS libraries","local":"hugging-face-js-libraries","sections":[{"title":"Installation","local":"installation","sections":[{"title":"From NPM","local":"from-npm","sections":[],"depth":3},{"title":"From CDN or Static hosting","local":"from-cdn-or-static-hosting","sections":[],"depth":3},{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage examples","local":"usage-examples","sections":[{"title":"@huggingface/inference examples","local":"huggingfaceinference-examples","sections":[],"depth":3},{"title":"@huggingface/hub examples","local":"huggingfacehub-examples","sections":[],"depth":3},{"title":"@huggingface/agents example","local":"huggingfaceagents-example","sections":[],"depth":3}],"depth":2},{"title":"Formatting & testing","local":"formatting--testing","sections":[],"depth":2},{"title":"Building","local":"building","sections":[],"depth":2}],"depth":1}';function el(Rs){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Ps{constructor(U){super(),Os(this,U,el,nl,Ls,{})}}export{ol as component};
