import{s as we,o as fe,n as Ce}from"../chunks/scheduler.01eeda35.js";import{S as ge,i as Ie,g as p,s as a,r as c,A as be,h as i,f as e,c as n,j as de,u as M,x as o,k as Je,y as $e,a as l,v as m,d as r,t as u,w as h}from"../chunks/index.6dd51b66.js";import{T as xe}from"../chunks/Tip.de9bae2b.js";import{C as y}from"../chunks/CodeBlock.864da1b0.js";import{H as U,E as Ae}from"../chunks/EditOnGithub.7faefd25.js";function Ne(Nt){let j,J="Formatting such as whitespace and special tokens are model-specific. Make sure everything exactly matches the format a model was trained with.";return{c(){j=p("p"),j.textContent=J},l(T){j=i(T,"P",{"data-svelte-h":!0}),o(j)!=="svelte-huyrok"&&(j.textContent=J)},m(T,xt){l(T,j,xt)},p:Ce,d(T){T&&e(j)}}}function ve(Nt){let j,J,T,xt,w,vt,f,Vs='A chat template is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja</a> template stored in the tokenizers <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizer.chat_template" rel="nofollow">chat_template</a> attribute. Jinja is a templating language that allows you to write Python-like code and syntax. A chat template performs the following three roles.',Qt,C,Bs='<li>Print the role enclosed in <code>&lt;|</code> and <code>|&gt;</code> (<code>&lt;|user|&gt;</code>, <code>&lt;|assistant|&gt;</code>, etc.).</li> <li>Print the message followed by an end-of-sequence (<code>EOS</code>) token.</li> <li>Print the assistant token if <a href="./chat_templating#add_generation_prompt">add_generation_prompt=True</a> so the model generates an assistant response.</li>',kt,g,Gs="An example template is shown below.",St,I,_t,b,zs="The template can be customized to handle more complex use cases. This guide will show you how to add and edit templates and includes template writing tips.",qt,$,Rt,x,Ws="Create a template by writing a Jinja template and then setting it as the chat template in the tokenizer. For example, the template below adds <code>[ASST]</code> and <code>[/ASST]</code> tags to the assistant messages.",Et,A,Zt,N,Ls='Set the template in the tokenizer, and the next time you use <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, the new template is used.',Vt,v,Bt,Q,Hs='The template is saved in the <code>tokenizer_config.json</code> file. Upload it to the Hub with <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> so you can reuse it later and make sure everyone is using the right template for your model.',Gt,k,zt,S,Wt,_,Ps='The easiest way to start writing Jinja templates is to refer to existing templates. Use <code>print(tokenizer.chat_template)</code> on any chat model to see what template it’s using. Try starting with simple models that don’t call any tools or support RAG. Finally, take a look at the <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#synopsis" rel="nofollow">Jinja documentation</a> for more details about formatting and syntax.',Lt,q,Xs="This section curates some best practices for writing clean and efficient Jinja templates.",Ht,R,Pt,E,Ys="Jinja prints any whitespace before or after a block of text. This can be an issue for chat templates because whitespace usage should be intentional. Add <code>-</code> to strip any whitespace before a block.",Xt,Z,Yt,V,Fs="The incorrect whitespace usage example below may introduce a newline and indentation in the output.",Ft,B,Dt,G,Ot,z,Ds='There are five special variables available inside a template. You can pass virtually any additional arguments to <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> and it will be available inside the template as a variable. However, you should try to keep the number of variables to the five below to make it easier for users to use the chat model without writing custom code to handle model-specific arguments.',Kt,W,Os="<li><code>messages</code> contains the chat history as a list of message dicts.</li> <li><code>tools</code> contains a list of tools in JSON schema format.</li> <li><code>documents</code> contains a list of documents with the format <code>{&quot;title&quot;: Title, &quot;contents&quot;: &quot;Contents&quot;}</code> (designed for RAG models).</li> <li><code>add_generation_prompt</code> is a boolean that determines whether to add an assistant header at the end of the conversation.</li> <li><code>bos_token</code> and <code>eos_token</code> are special tokens extracted from a tokenizers <code>special_tokens_map</code>.</li>",ts,L,ss,H,Ks="There are two callable functions available inside a template.",es,P,te='<li><code>raise_exception(msg)</code> raises a <code>TemplateException</code>. This is useful for debugging or warning users about incorrect template usage.</li> <li><code>strftime_now(format_str)</code> retrieves the current date and time in a specific format which could be useful to include in system messages. It is equivalent to <a href="https://docs.python.org/3/library/datetime.html#datetime.datetime.now" rel="nofollow">datetime.now().strftime(format_str)</a> in Python.</li>',ls,X,as,Y,se='Jinja is implemented in multiple languages and they generally have the same syntax. Writing a template in Python allows you to use Python methods such as <a href="https://docs.python.org/3/library/stdtypes.html#str.lower" rel="nofollow">lower</a> on strings or <a href="https://docs.python.org/3/library/stdtypes.html#dict.items" rel="nofollow">items</a> on dicts. But this won’t work if the template is used in a non-Python implementation, for example, when deploying with Javascript or Rust.',ns,F,ee="Make the changes below to ensure compatibility across all Jinja implementations.",ps,D,le='<li>Replace Python methods with Jinja filters. For example, replace <code>string.lower()</code> with <code>string|lower</code> or <code>dict.items()</code> with <code>dict|dictitems</code>. Most of the changes follow the same pattern except <code>string.strip()</code>, which is replaced with <code>string|trim</code>. Refer to the list of <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#builtin-filters" rel="nofollow">built-in filters</a> for a complete list of filters.</li> <li>Replace <code>True</code>, <code>False</code>, and <code>None</code> (these are Python specific) with <code>true</code>, <code>false</code>, and <code>none</code> respectively.</li> <li>Directly rendering a dict or list may return different results in other implementations. For example, string entries may change from single-quote to double-quote. To avoid this, add the <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#jinja-filters.tojson" rel="nofollow">tojson</a> filter to maintain consistency.</li>',is,O,os,K,ae='Newer models or models with features like <a href="./chat_extras#tools">tool-calling</a> and <a href="./chat_extras#retrieval-augmented-generation-rag">RAG</a> require larger templates that can be longer than 100 lines. It may be easier to write larger templates in a separate file. The line numbers in the separate file corresponds exactly to the line numbers in template parsing or execution errors, making it easier to debug any potential issues.',cs,tt,ne="Write the template in a separate file and extract it to the chat template.",Ms,st,ms,et,pe="You could also load an edited template back into the tokenizer.",rs,lt,us,at,hs,nt,ie="There isn’t a specific format for writing templates for tools but it is best to follow the standard API. This ensures the template is widely accessible across models without requiring users to write custom code to use tools with your model.",js,d,ys,pt,oe="The following section lists elements of the standard API for writing templates for tools.",Us,it,Ts,ot,ce="Transformers chat template methods allow a user to pass tools as Python functions or a JSON schema. When functions are passed, a JSON schema is automatically generated and passed to the template. The <code>tools</code> variable in a template always takes a list of JSON schemas.",ds,ct,Me='The specific tokens and tool descriptions should match the ones your model was trained with. Your model doesn’t need to understand the JSON schema input because your template can translate the JSON schema into your models format. For example, <a href="./model_doc/cohere">Command-R</a> was trained with tools defined with Python function headers, but the Command-R tool template accepts JSON schemas. The template internally converts types and renders the input tools as Python headers.',Js,Mt,ws,mt,me="An example for handling tool definitions in a chat template is shown below. The specific tokens and tool descriptions should be changed to match the ones a model was trained with.",fs,rt,Cs,ut,gs,ht,re="Tool calls, if present, is a list with the <code>&quot;assistant”</code> role. This is always a list even though most tool-calling models only support single tool calls, which means the list usually only contains a single element.",Is,jt,bs,yt,ue="A common pattern for handling tool calls is shown below.",$s,Ut,xs,Tt,As,dt,he="Tool responses are a message dict with the <code>role</code>, <code>name</code> (name of the function) and <code>content</code> (result of the tool call) keys.",Ns,Jt,vs,wt,je="Not all the keys need to be used in the tool response. For example, if a model doesn’t expect the function name to be included in the tool response, then you can just include the <code>role</code> and <code>content</code>.",Qs,ft,ks,Ct,Ss,gt,ye='Add a chat template by setting the <code>chat_template</code> attribute in the tokenizer and testing it with <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>. If it works as expected, then you can upload it to the Hub with with <a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>.',_s,It,Ue='Even if you’re not the model owner, it is still helpful to add a template for a model with an empty chat template or a model that is using a default class template. Open a <a href="https://hf.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> on the model repository to add the template.',qs,bt,Rs,$t,Es,At,Zs;return w=new U({props:{title:"Template writing",local:"template-writing",headingTag:"h1"}}),I=new y({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0MnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCU3QyUzRSU1Q24nJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGlmJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0Nhc3Npc3RhbnQlN0MlM0UlNUNuJyUyMCU3RCU3RCUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{- &#x27;&lt;|&#x27; + message[&#x27;role&#x27;] + |&gt;\\n&#x27; }}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{- message[&#x27;content&#x27;] + eos_token }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">if</span></span> add_generation_prompt %}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{- &#x27;&lt;|assistant|&gt;\\n&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span>`,wrap:!1}}),$=new U({props:{title:"Create a template",local:"create-a-template",headingTag:"h2"}}),A=new y({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTNDU1lTJTNFJTNFJTVDJTVDbiclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclNUJBU1NUJTVEJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJTVCJTJGQVNTVCU1RCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">if</span></span> message[&#x27;role&#x27;] == &#x27;user&#x27; %}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{- bos_token + &#x27;[INST] &#x27; + message[&#x27;content&#x27;].strip() + &#x27; [/INST]&#x27; }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">elif</span></span> message[&#x27;role&#x27;] == &#x27;system&#x27; %}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{- &#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27; + message[&#x27;content&#x27;].strip() + &#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27; }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">elif</span></span> message[&#x27;role&#x27;] == &#x27;assistant&#x27; %}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{- &#x27;[ASST] &#x27;  + message[&#x27;content&#x27;] + &#x27; [/ASST]&#x27; + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),v=new y({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGU=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>`,wrap:!1}}),k=new y({props:{code:"dG9rZW5pemVyLnB1c2hfdG9faHViKCUyMm1vZGVsX25hbWUlMjIp",highlighted:'tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)',wrap:!1}}),S=new U({props:{title:"Template writing tips",local:"template-writing-tips",headingTag:"h2"}}),R=new U({props:{title:"Trimming whitespace",local:"trimming-whitespace",headingTag:"h3"}}),Z=new y({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{- message[&#x27;role&#x27;] + message[&#x27;content&#x27;] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),B=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0IlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[&#x27;role&#x27;] + message[&#x27;content&#x27;] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),G=new U({props:{title:"Special variables",local:"special-variables",headingTag:"h3"}}),L=new U({props:{title:"Callable functions",local:"callable-functions",headingTag:"h3"}}),X=new U({props:{title:"Compatibility with non-Python Jinja",local:"compatibility-with-non-python-jinja",headingTag:"h3"}}),O=new U({props:{title:"Big templates",local:"big-templates",headingTag:"h3"}}),st=new y({props:{code:"b3BlbiglMjJ0ZW1wbGF0ZS5qaW5qYSUyMiUyQyUyMCUyMnclMjIpLndyaXRlKHRva2VuaXplci5jaGF0X3RlbXBsYXRlKQ==",highlighted:'<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>).write(tokenizer.chat_template)',wrap:!1}}),lt=new y({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjBvcGVuKCUyMnRlbXBsYXRlLmppbmphJTIyKS5yZWFkKCk=",highlighted:'tokenizer.chat_template = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>).read()',wrap:!1}}),at=new U({props:{title:"Templates for tools",local:"templates-for-tools",headingTag:"h2"}}),d=new xe({props:{warning:!0,$$slots:{default:[Ne]},$$scope:{ctx:Nt}}}),it=new U({props:{title:"Tool definitions",local:"tool-definitions",headingTag:"h3"}}),Mt=new y({props:{code:"JTdCJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTBBJTIwJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIybnVtYmVyJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm51bWJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwc2Vjb25kJTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcXVpcmVkJTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span> 
  <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A function that multiplies two numbers&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span> 
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The first number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
        <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The second number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;a&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),rt=new y({props:{code:"JTdCJTI1LSUyMGlmJTIwdG9vbHMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZm9yJTIwdG9vbCUyMGluJTIwdG9vbHMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQ3Rvb2wlM0UnJTIwJTJCJTIwdG9vbCU1QidmdW5jdGlvbiclNUQlNUInbmFtZSclNUQlMjAlMkIlMjAnJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjUtJTIwZm9yJTIwYXJndW1lbnQlMjBpbiUyMHRvb2wlNUInZnVuY3Rpb24nJTVEJTVCJ3BhcmFtZXRlcnMnJTVEJTVCJ3Byb3BlcnRpZXMnJTVEJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMGFyZ3VtZW50JTIwJTJCJTIwJyUzQSUyMCclMjAlMkIlMjB0b29sJTVCJ2Z1bmN0aW9uJyU1RCU1QidwYXJhbWV0ZXJzJyU1RCU1Qidwcm9wZXJ0aWVzJyU1RCU1QmFyZ3VtZW50JTVEJTVCJ2Rlc2NyaXB0aW9uJyU1RCUyMCUyQiUyMCclNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbmRmb3IlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyU1Q24lM0MlMkZ0b29sJTNFJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`{%- <span class="hljs-keyword">if</span> tools %}
    {%- <span class="hljs-keyword">for</span> tool <span class="hljs-keyword">in</span> tools %}
        {{- <span class="hljs-string">&#x27;&lt;tool&gt;&#x27;</span> + tool[<span class="hljs-string">&#x27;function&#x27;</span>][<span class="hljs-string">&#x27;name&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> }}
        {%- <span class="hljs-keyword">for</span> argument <span class="hljs-keyword">in</span> tool[<span class="hljs-string">&#x27;function&#x27;</span>][<span class="hljs-string">&#x27;parameters&#x27;</span>][<span class="hljs-string">&#x27;properties&#x27;</span>] %}
            {{- argument + <span class="hljs-string">&#x27;: &#x27;</span> + tool[<span class="hljs-string">&#x27;function&#x27;</span>][<span class="hljs-string">&#x27;parameters&#x27;</span>][<span class="hljs-string">&#x27;properties&#x27;</span>][argument][<span class="hljs-string">&#x27;description&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> }}
        {%- endfor %}
        {{- <span class="hljs-string">&#x27;\\n&lt;/tool&gt;&#x27;</span> }}
    {%- endif %}
{%- endif %}`,wrap:!1}}),ut=new U({props:{title:"Tool calls",local:"tool-calls",headingTag:"h3"}}),jt=new y({props:{code:"JTdCJTBBJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUwQSUyMCUyMCUyMnRvb2xfY2FsbHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZnVuY3Rpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmdW5jdGlvbiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJtdWx0aXBseSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFyZ3VtZW50cyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYiUyMiUzQSUyMDYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tool_calls&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;arguments&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">6</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ut=new y({props:{code:"JTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwYW5kJTIwJ3Rvb2xfY2FsbHMnJTIwaW4lMjBtZXNzYWdlJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGZvciUyMHRvb2xfY2FsbCUyMGluJTIwbWVzc2FnZSU1Qid0b29sX2NhbGxzJyU1RCUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDdG9vbF9jYWxsJTNFJyUyMCUyQiUyMHRvb2xfY2FsbCU1QidmdW5jdGlvbiclNUQlNUInbmFtZSclNUQlMjAlMkIlMjAnJTVDbiclMjAlMkIlMjB0b29sX2NhbGwlNUInZnVuY3Rpb24nJTVEJTVCJ2FyZ3VtZW50cyclNUQlN0N0b2pzb24lMjAlMkIlMjAnJTVDbiUzQyUyRnRvb2xfY2FsbCUzRSclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> and <span class="hljs-string">&#x27;tool_calls&#x27;</span> <span class="hljs-keyword">in</span> message %}
    {%- <span class="hljs-keyword">for</span> tool_call <span class="hljs-keyword">in</span> message[<span class="hljs-string">&#x27;tool_calls&#x27;</span>] %}
            {{- <span class="hljs-string">&#x27;&lt;tool_call&gt;&#x27;</span> + tool_call[<span class="hljs-string">&#x27;function&#x27;</span>][<span class="hljs-string">&#x27;name&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + tool_call[<span class="hljs-string">&#x27;function&#x27;</span>][<span class="hljs-string">&#x27;arguments&#x27;</span>]|tojson + <span class="hljs-string">&#x27;\\n&lt;/tool_call&gt;&#x27;</span> }}
        {%- endif %}
    {%- endfor %}
{%- endif %}`,wrap:!1}}),Tt=new U({props:{title:"Tool responses",local:"tool-responses",headingTag:"h3"}}),Jt=new y({props:{code:"JTdCJTBBJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnRvb2wlMjIlMkMlMEElMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMEElMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyMzAlMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tool&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;30&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ft=new y({props:{code:"JTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd0b29sJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAlMjIlM0N0b29sX3Jlc3VsdCUzRSUyMiUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAlMjIlM0MlMkZ0b29sX3Jlc3VsdCUzRSUyMiUyMCU3RCU3RCUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`{%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;tool&#x27;</span> %}
    {{- <span class="hljs-string">&quot;&lt;tool_result&gt;&quot;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&quot;&lt;/tool_result&gt;&quot;</span> }}
{%- endif %}`,wrap:!1}}),Ct=new U({props:{title:"Contribute",local:"contribute",headingTag:"h2"}}),bt=new y({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjB0ZW1wbGF0ZSUwQXRva2VuaXplci5wdXNoX3RvX2h1YiglMjJtb2RlbF9uYW1lJTIyKQ==",highlighted:`tokenizer.chat_template = template
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)`,wrap:!1}}),$t=new Ae({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/chat_templating_writing.md"}}),{c(){j=p("meta"),J=a(),T=p("p"),xt=a(),c(w.$$.fragment),vt=a(),f=p("p"),f.innerHTML=Vs,Qt=a(),C=p("ol"),C.innerHTML=Bs,kt=a(),g=p("p"),g.textContent=Gs,St=a(),c(I.$$.fragment),_t=a(),b=p("p"),b.textContent=zs,qt=a(),c($.$$.fragment),Rt=a(),x=p("p"),x.innerHTML=Ws,Et=a(),c(A.$$.fragment),Zt=a(),N=p("p"),N.innerHTML=Ls,Vt=a(),c(v.$$.fragment),Bt=a(),Q=p("p"),Q.innerHTML=Hs,Gt=a(),c(k.$$.fragment),zt=a(),c(S.$$.fragment),Wt=a(),_=p("p"),_.innerHTML=Ps,Lt=a(),q=p("p"),q.textContent=Xs,Ht=a(),c(R.$$.fragment),Pt=a(),E=p("p"),E.innerHTML=Ys,Xt=a(),c(Z.$$.fragment),Yt=a(),V=p("p"),V.textContent=Fs,Ft=a(),c(B.$$.fragment),Dt=a(),c(G.$$.fragment),Ot=a(),z=p("p"),z.innerHTML=Ds,Kt=a(),W=p("ul"),W.innerHTML=Os,ts=a(),c(L.$$.fragment),ss=a(),H=p("p"),H.textContent=Ks,es=a(),P=p("ul"),P.innerHTML=te,ls=a(),c(X.$$.fragment),as=a(),Y=p("p"),Y.innerHTML=se,ns=a(),F=p("p"),F.textContent=ee,ps=a(),D=p("ul"),D.innerHTML=le,is=a(),c(O.$$.fragment),os=a(),K=p("p"),K.innerHTML=ae,cs=a(),tt=p("p"),tt.textContent=ne,Ms=a(),c(st.$$.fragment),ms=a(),et=p("p"),et.textContent=pe,rs=a(),c(lt.$$.fragment),us=a(),c(at.$$.fragment),hs=a(),nt=p("p"),nt.textContent=ie,js=a(),c(d.$$.fragment),ys=a(),pt=p("p"),pt.textContent=oe,Us=a(),c(it.$$.fragment),Ts=a(),ot=p("p"),ot.innerHTML=ce,ds=a(),ct=p("p"),ct.innerHTML=Me,Js=a(),c(Mt.$$.fragment),ws=a(),mt=p("p"),mt.textContent=me,fs=a(),c(rt.$$.fragment),Cs=a(),c(ut.$$.fragment),gs=a(),ht=p("p"),ht.innerHTML=re,Is=a(),c(jt.$$.fragment),bs=a(),yt=p("p"),yt.textContent=ue,$s=a(),c(Ut.$$.fragment),xs=a(),c(Tt.$$.fragment),As=a(),dt=p("p"),dt.innerHTML=he,Ns=a(),c(Jt.$$.fragment),vs=a(),wt=p("p"),wt.innerHTML=je,Qs=a(),c(ft.$$.fragment),ks=a(),c(Ct.$$.fragment),Ss=a(),gt=p("p"),gt.innerHTML=ye,_s=a(),It=p("p"),It.innerHTML=Ue,qs=a(),c(bt.$$.fragment),Rs=a(),c($t.$$.fragment),Es=a(),At=p("p"),this.h()},l(t){const s=be("svelte-u9bgzb",document.head);j=i(s,"META",{name:!0,content:!0}),s.forEach(e),J=n(t),T=i(t,"P",{}),de(T).forEach(e),xt=n(t),M(w.$$.fragment,t),vt=n(t),f=i(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-wxa086"&&(f.innerHTML=Vs),Qt=n(t),C=i(t,"OL",{"data-svelte-h":!0}),o(C)!=="svelte-ugf7x7"&&(C.innerHTML=Bs),kt=n(t),g=i(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1lt0zz3"&&(g.textContent=Gs),St=n(t),M(I.$$.fragment,t),_t=n(t),b=i(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-u4a2fx"&&(b.textContent=zs),qt=n(t),M($.$$.fragment,t),Rt=n(t),x=i(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-e9to2q"&&(x.innerHTML=Ws),Et=n(t),M(A.$$.fragment,t),Zt=n(t),N=i(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-t3bbck"&&(N.innerHTML=Ls),Vt=n(t),M(v.$$.fragment,t),Bt=n(t),Q=i(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-vttp9o"&&(Q.innerHTML=Hs),Gt=n(t),M(k.$$.fragment,t),zt=n(t),M(S.$$.fragment,t),Wt=n(t),_=i(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-kemzad"&&(_.innerHTML=Ps),Lt=n(t),q=i(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1g7sqdn"&&(q.textContent=Xs),Ht=n(t),M(R.$$.fragment,t),Pt=n(t),E=i(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1rfovfh"&&(E.innerHTML=Ys),Xt=n(t),M(Z.$$.fragment,t),Yt=n(t),V=i(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-146ct25"&&(V.textContent=Fs),Ft=n(t),M(B.$$.fragment,t),Dt=n(t),M(G.$$.fragment,t),Ot=n(t),z=i(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1ga7z6n"&&(z.innerHTML=Ds),Kt=n(t),W=i(t,"UL",{"data-svelte-h":!0}),o(W)!=="svelte-zdcmrk"&&(W.innerHTML=Os),ts=n(t),M(L.$$.fragment,t),ss=n(t),H=i(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1wbd88z"&&(H.textContent=Ks),es=n(t),P=i(t,"UL",{"data-svelte-h":!0}),o(P)!=="svelte-la1bbo"&&(P.innerHTML=te),ls=n(t),M(X.$$.fragment,t),as=n(t),Y=i(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-nnw30h"&&(Y.innerHTML=se),ns=n(t),F=i(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1x844aj"&&(F.textContent=ee),ps=n(t),D=i(t,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-1ojiu3"&&(D.innerHTML=le),is=n(t),M(O.$$.fragment,t),os=n(t),K=i(t,"P",{"data-svelte-h":!0}),o(K)!=="svelte-wmcpvm"&&(K.innerHTML=ae),cs=n(t),tt=i(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-bxms70"&&(tt.textContent=ne),Ms=n(t),M(st.$$.fragment,t),ms=n(t),et=i(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-dhgo9w"&&(et.textContent=pe),rs=n(t),M(lt.$$.fragment,t),us=n(t),M(at.$$.fragment,t),hs=n(t),nt=i(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1blfzk9"&&(nt.textContent=ie),js=n(t),M(d.$$.fragment,t),ys=n(t),pt=i(t,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-zoi63y"&&(pt.textContent=oe),Us=n(t),M(it.$$.fragment,t),Ts=n(t),ot=i(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-ocxx5w"&&(ot.innerHTML=ce),ds=n(t),ct=i(t,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-16syazs"&&(ct.innerHTML=Me),Js=n(t),M(Mt.$$.fragment,t),ws=n(t),mt=i(t,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-42smau"&&(mt.textContent=me),fs=n(t),M(rt.$$.fragment,t),Cs=n(t),M(ut.$$.fragment,t),gs=n(t),ht=i(t,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-cosrg7"&&(ht.innerHTML=re),Is=n(t),M(jt.$$.fragment,t),bs=n(t),yt=i(t,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-nps69"&&(yt.textContent=ue),$s=n(t),M(Ut.$$.fragment,t),xs=n(t),M(Tt.$$.fragment,t),As=n(t),dt=i(t,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-1f7ykrl"&&(dt.innerHTML=he),Ns=n(t),M(Jt.$$.fragment,t),vs=n(t),wt=i(t,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-rjza7e"&&(wt.innerHTML=je),Qs=n(t),M(ft.$$.fragment,t),ks=n(t),M(Ct.$$.fragment,t),Ss=n(t),gt=i(t,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1ykquel"&&(gt.innerHTML=ye),_s=n(t),It=i(t,"P",{"data-svelte-h":!0}),o(It)!=="svelte-1ct0ksq"&&(It.innerHTML=Ue),qs=n(t),M(bt.$$.fragment,t),Rs=n(t),M($t.$$.fragment,t),Es=n(t),At=i(t,"P",{}),de(At).forEach(e),this.h()},h(){Je(j,"name","hf:doc:metadata"),Je(j,"content",Qe)},m(t,s){$e(document.head,j),l(t,J,s),l(t,T,s),l(t,xt,s),m(w,t,s),l(t,vt,s),l(t,f,s),l(t,Qt,s),l(t,C,s),l(t,kt,s),l(t,g,s),l(t,St,s),m(I,t,s),l(t,_t,s),l(t,b,s),l(t,qt,s),m($,t,s),l(t,Rt,s),l(t,x,s),l(t,Et,s),m(A,t,s),l(t,Zt,s),l(t,N,s),l(t,Vt,s),m(v,t,s),l(t,Bt,s),l(t,Q,s),l(t,Gt,s),m(k,t,s),l(t,zt,s),m(S,t,s),l(t,Wt,s),l(t,_,s),l(t,Lt,s),l(t,q,s),l(t,Ht,s),m(R,t,s),l(t,Pt,s),l(t,E,s),l(t,Xt,s),m(Z,t,s),l(t,Yt,s),l(t,V,s),l(t,Ft,s),m(B,t,s),l(t,Dt,s),m(G,t,s),l(t,Ot,s),l(t,z,s),l(t,Kt,s),l(t,W,s),l(t,ts,s),m(L,t,s),l(t,ss,s),l(t,H,s),l(t,es,s),l(t,P,s),l(t,ls,s),m(X,t,s),l(t,as,s),l(t,Y,s),l(t,ns,s),l(t,F,s),l(t,ps,s),l(t,D,s),l(t,is,s),m(O,t,s),l(t,os,s),l(t,K,s),l(t,cs,s),l(t,tt,s),l(t,Ms,s),m(st,t,s),l(t,ms,s),l(t,et,s),l(t,rs,s),m(lt,t,s),l(t,us,s),m(at,t,s),l(t,hs,s),l(t,nt,s),l(t,js,s),m(d,t,s),l(t,ys,s),l(t,pt,s),l(t,Us,s),m(it,t,s),l(t,Ts,s),l(t,ot,s),l(t,ds,s),l(t,ct,s),l(t,Js,s),m(Mt,t,s),l(t,ws,s),l(t,mt,s),l(t,fs,s),m(rt,t,s),l(t,Cs,s),m(ut,t,s),l(t,gs,s),l(t,ht,s),l(t,Is,s),m(jt,t,s),l(t,bs,s),l(t,yt,s),l(t,$s,s),m(Ut,t,s),l(t,xs,s),m(Tt,t,s),l(t,As,s),l(t,dt,s),l(t,Ns,s),m(Jt,t,s),l(t,vs,s),l(t,wt,s),l(t,Qs,s),m(ft,t,s),l(t,ks,s),m(Ct,t,s),l(t,Ss,s),l(t,gt,s),l(t,_s,s),l(t,It,s),l(t,qs,s),m(bt,t,s),l(t,Rs,s),m($t,t,s),l(t,Es,s),l(t,At,s),Zs=!0},p(t,[s]){const Te={};s&2&&(Te.$$scope={dirty:s,ctx:t}),d.$set(Te)},i(t){Zs||(r(w.$$.fragment,t),r(I.$$.fragment,t),r($.$$.fragment,t),r(A.$$.fragment,t),r(v.$$.fragment,t),r(k.$$.fragment,t),r(S.$$.fragment,t),r(R.$$.fragment,t),r(Z.$$.fragment,t),r(B.$$.fragment,t),r(G.$$.fragment,t),r(L.$$.fragment,t),r(X.$$.fragment,t),r(O.$$.fragment,t),r(st.$$.fragment,t),r(lt.$$.fragment,t),r(at.$$.fragment,t),r(d.$$.fragment,t),r(it.$$.fragment,t),r(Mt.$$.fragment,t),r(rt.$$.fragment,t),r(ut.$$.fragment,t),r(jt.$$.fragment,t),r(Ut.$$.fragment,t),r(Tt.$$.fragment,t),r(Jt.$$.fragment,t),r(ft.$$.fragment,t),r(Ct.$$.fragment,t),r(bt.$$.fragment,t),r($t.$$.fragment,t),Zs=!0)},o(t){u(w.$$.fragment,t),u(I.$$.fragment,t),u($.$$.fragment,t),u(A.$$.fragment,t),u(v.$$.fragment,t),u(k.$$.fragment,t),u(S.$$.fragment,t),u(R.$$.fragment,t),u(Z.$$.fragment,t),u(B.$$.fragment,t),u(G.$$.fragment,t),u(L.$$.fragment,t),u(X.$$.fragment,t),u(O.$$.fragment,t),u(st.$$.fragment,t),u(lt.$$.fragment,t),u(at.$$.fragment,t),u(d.$$.fragment,t),u(it.$$.fragment,t),u(Mt.$$.fragment,t),u(rt.$$.fragment,t),u(ut.$$.fragment,t),u(jt.$$.fragment,t),u(Ut.$$.fragment,t),u(Tt.$$.fragment,t),u(Jt.$$.fragment,t),u(ft.$$.fragment,t),u(Ct.$$.fragment,t),u(bt.$$.fragment,t),u($t.$$.fragment,t),Zs=!1},d(t){t&&(e(J),e(T),e(xt),e(vt),e(f),e(Qt),e(C),e(kt),e(g),e(St),e(_t),e(b),e(qt),e(Rt),e(x),e(Et),e(Zt),e(N),e(Vt),e(Bt),e(Q),e(Gt),e(zt),e(Wt),e(_),e(Lt),e(q),e(Ht),e(Pt),e(E),e(Xt),e(Yt),e(V),e(Ft),e(Dt),e(Ot),e(z),e(Kt),e(W),e(ts),e(ss),e(H),e(es),e(P),e(ls),e(as),e(Y),e(ns),e(F),e(ps),e(D),e(is),e(os),e(K),e(cs),e(tt),e(Ms),e(ms),e(et),e(rs),e(us),e(hs),e(nt),e(js),e(ys),e(pt),e(Us),e(Ts),e(ot),e(ds),e(ct),e(Js),e(ws),e(mt),e(fs),e(Cs),e(gs),e(ht),e(Is),e(bs),e(yt),e($s),e(xs),e(As),e(dt),e(Ns),e(vs),e(wt),e(Qs),e(ks),e(Ss),e(gt),e(_s),e(It),e(qs),e(Rs),e(Es),e(At)),e(j),h(w,t),h(I,t),h($,t),h(A,t),h(v,t),h(k,t),h(S,t),h(R,t),h(Z,t),h(B,t),h(G,t),h(L,t),h(X,t),h(O,t),h(st,t),h(lt,t),h(at,t),h(d,t),h(it,t),h(Mt,t),h(rt,t),h(ut,t),h(jt,t),h(Ut,t),h(Tt,t),h(Jt,t),h(ft,t),h(Ct,t),h(bt,t),h($t,t)}}}const Qe='{"title":"Template writing","local":"template-writing","sections":[{"title":"Create a template","local":"create-a-template","sections":[],"depth":2},{"title":"Template writing tips","local":"template-writing-tips","sections":[{"title":"Trimming whitespace","local":"trimming-whitespace","sections":[],"depth":3},{"title":"Special variables","local":"special-variables","sections":[],"depth":3},{"title":"Callable functions","local":"callable-functions","sections":[],"depth":3},{"title":"Compatibility with non-Python Jinja","local":"compatibility-with-non-python-jinja","sections":[],"depth":3},{"title":"Big templates","local":"big-templates","sections":[],"depth":3}],"depth":2},{"title":"Templates for tools","local":"templates-for-tools","sections":[{"title":"Tool definitions","local":"tool-definitions","sections":[],"depth":3},{"title":"Tool calls","local":"tool-calls","sections":[],"depth":3},{"title":"Tool responses","local":"tool-responses","sections":[],"depth":3}],"depth":2},{"title":"Contribute","local":"contribute","sections":[],"depth":2}],"depth":1}';function ke(Nt){return fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends ge{constructor(j){super(),Ie(this,j,ke,ve,we,{})}}export{Ze as component};
