import{s as yn,A as Mn,o as Tn,n as O}from"../chunks/scheduler.01eeda35.js";import{S as jn,i as xn,g as m,s as a,r as h,A as Jn,h as p,f as n,c as r,j as x,u as g,x as y,k as j,y as i,a as d,v as u,d as f,t as _,w as b}from"../chunks/index.6dd51b66.js";import{T as Ue}from"../chunks/Tip.de9bae2b.js";import{D as J}from"../chunks/Docstring.76e6b3cf.js";import{C as S}from"../chunks/CodeBlock.864da1b0.js";import{E as te}from"../chunks/ExampleCodeBlock.6a36fb6b.js";import{H as V,E as $n}from"../chunks/EditOnGithub.7faefd25.js";function On(T){let t,w=`The architecture of OWLv2 is identical to <a href="owlvit">OWL-ViT</a>, however the object detection head now also includes an objectness classifier, which predicts the (query-agnostic) likelihood that a predicted box contains an object (as opposed to background). The objectness score can be used to rank or filter predictions independently of text queries.
Usage of OWLv2 is identical to <a href="owlvit">OWL-ViT</a> with a new, updated image processor (<a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a>).`;return{c(){t=m("p"),t.innerHTML=w},l(l){t=p(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-ydk29n"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:O,d(l){l&&n(t)}}}function In(T){let t,w="Example:",l,c,v;return c=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME93bHYyVGV4dENvbmZpZyUyQyUyME93bHYyVGV4dE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME93bHYyVGV4dE1vZGVsJTIwd2l0aCUyMGdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBPd2x2MlRleHRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBPd2x2MlRleHRDb25maWclMjBmcm9tJTIwdGhlJTIwZ29vZ2xlJTJGb3dsdjItYmFzZS1wYXRjaDE2JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBPd2x2MlRleHRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Owlv2TextConfig, Owlv2TextModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2TextModel with google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Owlv2TextConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2TextConfig from the google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2TextModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=m("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=w),l=r(o),g(c.$$.fragment,o)},m(o,M){d(o,t,M),d(o,l,M),u(c,o,M),v=!0},p:O,i(o){v||(f(c.$$.fragment,o),v=!0)},o(o){_(c.$$.fragment,o),v=!1},d(o){o&&(n(t),n(l)),b(c,o)}}}function zn(T){let t,w="Example:",l,c,v;return c=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME93bHYyVmlzaW9uQ29uZmlnJTJDJTIwT3dsdjJWaXNpb25Nb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBPd2x2MlZpc2lvbk1vZGVsJTIwd2l0aCUyMGdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBPd2x2MlZpc2lvbkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME93bHYyVmlzaW9uTW9kZWwlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME93bHYyVmlzaW9uTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Owlv2VisionConfig, Owlv2VisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2VisionModel with google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Owlv2VisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2VisionModel model from the google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2VisionModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=m("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=w),l=r(o),g(c.$$.fragment,o)},m(o,M){d(o,t,M),d(o,l,M),u(c,o,M),v=!0},p:O,i(o){v||(f(c.$$.fragment,o),v=!0)},o(o){_(c.$$.fragment,o),v=!1},d(o){o&&(n(t),n(l)),b(c,o)}}}function Un(T){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=w},l(l){t=p(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:O,d(l){l&&n(t)}}}function kn(T){let t,w="Examples:",l,c,v;return c=new S({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME93bHYyTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyME93bHYyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNi1lbnNlbWJsZSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYtZW5zZW1ibGUlMjIpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEJTVCJTVCJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIyJTJDJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwZG9nJTIyJTVEJTVEJTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHNfcGVyX2ltYWdlJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHNfcGVyX2ltYWdlJTIwJTIwJTIzJTIwdGhpcyUyMGlzJTIwdGhlJTIwaW1hZ2UtdGV4dCUyMHNpbWlsYXJpdHklMjBzY29yZSUwQXByb2JzJTIwJTNEJTIwbG9naXRzX3Blcl9pbWFnZS5zb2Z0bWF4KGRpbSUzRDEpJTIwJTIwJTIzJTIwd2UlMjBjYW4lMjB0YWtlJTIwdGhlJTIwc29mdG1heCUyMHRvJTIwZ2V0JTIwdGhlJTIwbGFiZWwlMjBwcm9iYWJpbGl0aWVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2Model

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2Model.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=[[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]], images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits_per_image.softmax(dim=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){t=m("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(o),g(c.$$.fragment,o)},m(o,M){d(o,t,M),d(o,l,M),u(c,o,M),v=!0},p:O,i(o){v||(f(c.$$.fragment,o),v=!0)},o(o){_(c.$$.fragment,o),v=!1},d(o){o&&(n(t),n(l)),b(c,o)}}}function Cn(T){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=w},l(l){t=p(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:O,d(l){l&&n(t)}}}function Wn(T){let t,w="Examples:",l,c,v;return c=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBPd2x2Mk1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBPd2x2Mk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYtZW5zZW1ibGUlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGb3dsdjItYmFzZS1wYXRjaDE2LWVuc2VtYmxlJTIyKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTVCJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIyJTJDJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwZG9nJTIyJTVEJTJDJTIwJTVCJTIycGhvdG8lMjBvZiUyMGElMjBhc3RyYW5hdXQlMjIlNUQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQXRleHRfZmVhdHVyZXMlMjAlM0QlMjBtb2RlbC5nZXRfdGV4dF9mZWF0dXJlcygqKmlucHV0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2Model

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2Model.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], [<span class="hljs-string">&quot;photo of a astranaut&quot;</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_features = model.get_text_features(**inputs)`,wrap:!1}}),{c(){t=m("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(o),g(c.$$.fragment,o)},m(o,M){d(o,t,M),d(o,l,M),u(c,o,M),v=!0},p:O,i(o){v||(f(c.$$.fragment,o),v=!0)},o(o){_(c.$$.fragment,o),v=!1},d(o){o&&(n(t),n(l)),b(c,o)}}}function Zn(T){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=w},l(l){t=p(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:O,d(l){l&&n(t)}}}function Nn(T){let t,w="Examples:",l,c,v;return c=new S({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME93bHYyTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyME93bHYyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNi1lbnNlbWJsZSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYtZW5zZW1ibGUlMjIpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW1hZ2VfZmVhdHVyZXMlMjAlM0QlMjBtb2RlbC5nZXRfaW1hZ2VfZmVhdHVyZXMoKippbnB1dHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2Model

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2Model.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_features = model.get_image_features(**inputs)`,wrap:!1}}),{c(){t=m("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(o),g(c.$$.fragment,o)},m(o,M){d(o,t,M),d(o,l,M),u(c,o,M),v=!0},p:O,i(o){v||(f(c.$$.fragment,o),v=!0)},o(o){_(c.$$.fragment,o),v=!1},d(o){o&&(n(t),n(l)),b(c,o)}}}function Vn(T){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=w},l(l){t=p(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:O,d(l){l&&n(t)}}}function Bn(T){let t,w="Examples:",l,c,v;return c=new S({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBPd2x2MlRleHRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3dsdjJUZXh0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYlMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMkMlMjAlNUIlMjJwaG90byUyMG9mJTIwYSUyMGFzdHJhbmF1dCUyMiU1RCU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlZF9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQlMjAlMjAlMjMlMjBwb29sZWQlMjAoRU9TJTIwdG9rZW4pJTIwc3RhdGVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2TextModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2TextModel.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], [<span class="hljs-string">&quot;photo of a astranaut&quot;</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled (EOS token) states</span>`,wrap:!1}}),{c(){t=m("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(o),g(c.$$.fragment,o)},m(o,M){d(o,t,M),d(o,l,M),u(c,o,M),v=!0},p:O,i(o){v||(f(c.$$.fragment,o),v=!0)},o(o){_(c.$$.fragment,o),v=!1},d(o){o&&(n(t),n(l)),b(c,o)}}}function Rn(T){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=w},l(l){t=p(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:O,d(l){l&&n(t)}}}function Hn(T){let t,w="Examples:",l,c,v;return c=new S({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME93bHYyVmlzaW9uTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyME93bHYyVmlzaW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYlMjIpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlZF9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQlMjAlMjAlMjMlMjBwb29sZWQlMjBDTFMlMjBzdGF0ZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2VisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2VisionModel.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled CLS states</span>`,wrap:!1}}),{c(){t=m("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(o),g(c.$$.fragment,o)},m(o,M){d(o,t,M),d(o,l,M),u(c,o,M),v=!0},p:O,i(o){v||(f(c.$$.fragment,o),v=!0)},o(o){_(c.$$.fragment,o),v=!1},d(o){o&&(n(t),n(l)),b(c,o)}}}function Fn(T){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=w},l(l){t=p(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:O,d(l){l&&n(t)}}}function Pn(T){let t,w="Examples:",l,c,v;return c=new S({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Owlv2Processor, Owlv2ForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Owlv2Processor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2ForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_labels = [[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_labels, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Target image sizes (height, width) to rescale box predictions [batch_size, 2]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([(image.height, image.width)])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_grounded_object_detection(
<span class="hljs-meta">... </span>    outputs=outputs, target_sizes=target_sizes, threshold=<span class="hljs-number">0.1</span>, text_labels=text_labels
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Retrieve predictions for the first image for the corresponding text queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = results[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes, scores, text_labels = result[<span class="hljs-string">&quot;boxes&quot;</span>], result[<span class="hljs-string">&quot;scores&quot;</span>], result[<span class="hljs-string">&quot;text_labels&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, text_label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, text_labels):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected <span class="hljs-subst">{text_label}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.614</span> at location [<span class="hljs-number">341.67</span>, <span class="hljs-number">23.39</span>, <span class="hljs-number">642.32</span>, <span class="hljs-number">371.35</span>]
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.665</span> at location [<span class="hljs-number">6.75</span>, <span class="hljs-number">51.96</span>, <span class="hljs-number">326.62</span>, <span class="hljs-number">473.13</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(o),g(c.$$.fragment,o)},m(o,M){d(o,t,M),d(o,l,M),u(c,o,M),v=!0},p:O,i(o){v||(f(c.$$.fragment,o),v=!0)},o(o){_(c.$$.fragment,o),v=!1},d(o){o&&(n(t),n(l)),b(c,o)}}}function Ln(T){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=w},l(l){t=p(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:O,d(l){l&&n(t)}}}function qn(T){let t,w="Examples:",l,c,v;return c=new S({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2ForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2ForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>query_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000001675.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query_image = Image.<span class="hljs-built_in">open</span>(requests.get(query_url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, query_images=query_image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model.image_guided_detection(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.Tensor([image.size[::-<span class="hljs-number">1</span>]])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_image_guided_detection(
<span class="hljs-meta">... </span>    outputs=outputs, threshold=<span class="hljs-number">0.9</span>, nms_threshold=<span class="hljs-number">0.3</span>, target_sizes=target_sizes
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>i = <span class="hljs-number">0</span>  <span class="hljs-comment"># Retrieve predictions for the first image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes, scores = results[i][<span class="hljs-string">&quot;boxes&quot;</span>], results[i][<span class="hljs-string">&quot;scores&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected similar object with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.938</span> at location [<span class="hljs-number">327.31</span>, <span class="hljs-number">54.94</span>, <span class="hljs-number">547.39</span>, <span class="hljs-number">268.06</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.959</span> at location [<span class="hljs-number">5.78</span>, <span class="hljs-number">360.65</span>, <span class="hljs-number">619.12</span>, <span class="hljs-number">366.39</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.902</span> at location [<span class="hljs-number">2.85</span>, <span class="hljs-number">360.01</span>, <span class="hljs-number">627.63</span>, <span class="hljs-number">380.8</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.985</span> at location [<span class="hljs-number">176.98</span>, -<span class="hljs-number">29.45</span>, <span class="hljs-number">672.69</span>, <span class="hljs-number">182.83</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">1.0</span> at location [<span class="hljs-number">6.53</span>, <span class="hljs-number">14.35</span>, <span class="hljs-number">624.87</span>, <span class="hljs-number">470.82</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.998</span> at location [<span class="hljs-number">579.98</span>, <span class="hljs-number">29.14</span>, <span class="hljs-number">615.49</span>, <span class="hljs-number">489.05</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.985</span> at location [<span class="hljs-number">206.15</span>, <span class="hljs-number">10.53</span>, <span class="hljs-number">247.74</span>, <span class="hljs-number">466.01</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.947</span> at location [<span class="hljs-number">18.62</span>, <span class="hljs-number">429.72</span>, <span class="hljs-number">646.5</span>, <span class="hljs-number">457.72</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.996</span> at location [<span class="hljs-number">523.88</span>, <span class="hljs-number">20.69</span>, <span class="hljs-number">586.84</span>, <span class="hljs-number">483.18</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.998</span> at location [<span class="hljs-number">3.39</span>, <span class="hljs-number">360.59</span>, <span class="hljs-number">617.29</span>, <span class="hljs-number">499.21</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.969</span> at location [<span class="hljs-number">4.47</span>, <span class="hljs-number">449.05</span>, <span class="hljs-number">614.5</span>, <span class="hljs-number">474.76</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.966</span> at location [<span class="hljs-number">31.44</span>, <span class="hljs-number">463.65</span>, <span class="hljs-number">654.66</span>, <span class="hljs-number">471.07</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.924</span> at location [<span class="hljs-number">30.93</span>, <span class="hljs-number">468.07</span>, <span class="hljs-number">635.35</span>, <span class="hljs-number">475.39</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(o),g(c.$$.fragment,o)},m(o,M){d(o,t,M),d(o,l,M),u(c,o,M),v=!0},p:O,i(o){v||(f(c.$$.fragment,o),v=!0)},o(o){_(c.$$.fragment,o),v=!1},d(o){o&&(n(t),n(l)),b(c,o)}}}function Gn(T){let t,w,l,c,v,o,M,Hs='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',so,ke,no,Ce,Fs='OWLv2 was proposed in <a href="https://arxiv.org/abs/2306.09683" rel="nofollow">Scaling Open-Vocabulary Object Detection</a> by Matthias Minderer, Alexey Gritsenko, Neil Houlsby. OWLv2 scales up <a href="owlvit">OWL-ViT</a> using self-training, which uses an existing detector to generate pseudo-box annotations on image-text pairs. This results in large gains over the previous state-of-the-art for zero-shot object detection.',ao,We,Ps="The abstract from the paper is the following:",ro,Ze,Ls="<em>Open-vocabulary object detection has benefited greatly from pretrained vision-language models, but is still limited by the amount of available detection training data. While detection training data can be expanded by using Web image-text pairs as weak supervision, this has not been done at scales comparable to image-level pretraining. Here, we scale up detection data with self-training, which uses an existing detector to generate pseudo-box annotations on image-text pairs. Major challenges in scaling self-training are the choice of label space, pseudo-annotation filtering, and training efficiency. We present the OWLv2 model and OWL-ST self-training recipe, which address these challenges. OWLv2 surpasses the performance of previous state-of-the-art open-vocabulary detectors already at comparable training scales (~10M examples). However, with OWL-ST, we can scale to over 1B examples, yielding further large improvement: With an L/14 architecture, OWL-ST improves AP on LVIS rare classes, for which the model has seen no human box annotations, from 31.2% to 44.6% (43% relative improvement). OWL-ST unlocks Web-scale training for open-world localization, similar to what has been seen for image classification and language modelling.</em>",lo,oe,qs,io,Ne,Gs='OWLv2 high-level overview. Taken from the <a href="https://arxiv.org/abs/2306.09683">original paper</a>.',co,Ve,Xs=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/google-research/scenic/tree/main/scenic/projects/owl_vit" rel="nofollow">here</a>.`,mo,Be,po,Re,Ds='OWLv2 is, just like its predecessor <a href="owlvit">OWL-ViT</a>, a zero-shot text-conditioned object detection model. OWL-ViT uses <a href="clip">CLIP</a> as its multi-modal backbone, with a ViT-like Transformer to get visual features and a causal language model to get the text features. To use CLIP for detection, OWL-ViT removes the final token pooling layer of the vision model and attaches a lightweight classification and box head to each transformer output token. Open-vocabulary classification is enabled by replacing the fixed classification layer weights with the class-name embeddings obtained from the text model. The authors first train CLIP from scratch and fine-tune it end-to-end with the classification and box heads on standard detection datasets using a bipartite matching loss. One or multiple text queries per image can be used to perform zero-shot text-conditioned object detection.',ho,He,Es='<a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> can be used to resize (or rescale) and normalize images for the model and <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> is used to encode the text. <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Processor">Owlv2Processor</a> wraps <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> into a single instance to both encode the text and prepare the images. The following example shows how to perform object detection using <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Processor">Owlv2Processor</a> and <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a>.',go,Fe,uo,Pe,fo,Le,Ys='<li>A demo notebook on using OWLv2 for zero- and one-shot (image-guided) object detection can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/OWLv2" rel="nofollow">here</a>.</li> <li><a href="../tasks/zero_shot_object_detection">Zero-shot object detection task guide</a></li>',_o,se,bo,qe,wo,k,Ge,Ho,Ut,Qs=`<a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a> is the configuration class to store the configuration of an <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a>. It is used to
instantiate an OWLv2 model according to the specified arguments, defining the text model and vision model
configs. Instantiating a configuration with the defaults will yield a similar configuration to that of the OWLv2
<a href="https://huggingface.co/google/owlv2-base-patch16" rel="nofollow">google/owlv2-base-patch16</a> architecture.`,Fo,kt,As=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Po,ne,Xe,Lo,Ct,Ss=`Instantiate a <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a> (or a derived class) from owlv2 text model configuration and owlv2 vision
model configuration.`,vo,De,yo,C,Ee,qo,Wt,Ks=`This is the configuration class to store the configuration of an <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel">Owlv2TextModel</a>. It is used to instantiate an
Owlv2 text encoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Owlv2
<a href="https://huggingface.co/google/owlv2-base-patch16" rel="nofollow">google/owlv2-base-patch16</a> architecture.`,Go,Zt,en=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Xo,ae,Mo,Ye,To,W,Qe,Do,Nt,tn=`This is the configuration class to store the configuration of an <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel">Owlv2VisionModel</a>. It is used to instantiate
an OWLv2 image encoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the OWLv2
<a href="https://huggingface.co/google/owlv2-base-patch16" rel="nofollow">google/owlv2-base-patch16</a> architecture.`,Eo,Vt,on=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Yo,re,jo,Ae,xo,I,Se,Qo,Bt,sn="Constructs an OWLv2 image processor.",Ao,le,Ke,So,Rt,nn="Preprocess an image or batch of images.",Ko,ie,et,es,Ht,an=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format.`,ts,ce,tt,os,Ft,rn=`Converts the output of <a href="/docs/transformers/main/en/model_doc/owlvit#transformers.OwlViTForObjectDetection.image_guided_detection">OwlViTForObjectDetection.image_guided_detection()</a> into the format expected by the COCO
api.`,Jo,ot,$o,z,st,ss,Pt,ln=`Constructs an Owlv2 processor which wraps <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a>/<a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> into
a single processor that interits both the image processor and tokenizer functionalities. See the
<a href="/docs/transformers/main/en/model_doc/owlvit#transformers.OwlViTProcessor.__call__"><strong>call</strong>()</a> and <code>decode()</code> for more information.`,ns,de,nt,as,Lt,cn=`Main method to prepare for the model one or several text(s) and image(s). This method forwards the <code>text</code> and
<code>kwargs</code> arguments to CLIPTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a> if <code>text</code> is not <code>None</code> to encode:
the text. To prepare the image(s), this method forwards the <code>images</code> and <code>kwrags</code> arguments to
CLIPImageProcessor’s <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltFeatureExtractor.__call__"><strong>call</strong>()</a> if <code>images</code> is not <code>None</code>. Please refer to the docstring
of the above two methods for more information.`,rs,me,at,ls,qt,dn=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format.`,is,pe,rt,cs,Gt,mn=`Converts the output of <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection.image_guided_detection">Owlv2ForObjectDetection.image_guided_detection()</a> into the format expected by the COCO
api.`,Oo,lt,Io,$,it,ds,Xt,pn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ms,Dt,hn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ps,B,ct,hs,Et,gn='The <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> forward method, overrides the <code>__call__</code> special method.',gs,he,us,ge,fs,R,dt,_s,Yt,un='The <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> forward method, overrides the <code>__call__</code> special method.',bs,ue,ws,fe,vs,H,mt,ys,Qt,fn='The <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> forward method, overrides the <code>__call__</code> special method.',Ms,_e,Ts,be,zo,pt,Uo,K,ht,js,F,gt,xs,At,_n='The <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel">Owlv2TextModel</a> forward method, overrides the <code>__call__</code> special method.',Js,we,$s,ve,ko,ut,Co,ee,ft,Os,P,_t,Is,St,bn='The <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel">Owlv2VisionModel</a> forward method, overrides the <code>__call__</code> special method.',zs,ye,Us,Me,Wo,bt,Zo,G,wt,ks,L,vt,Cs,Kt,wn='The <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',Ws,Te,Zs,je,Ns,q,yt,Vs,eo,vn='The <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',Bs,xe,Rs,Je,No,Mt,Vo,oo,Bo;return v=new V({props:{title:"OWLv2",local:"owlv2",headingTag:"h1"}}),ke=new V({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Be=new V({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),Fe=new S({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Owlv2Processor, Owlv2ForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Owlv2Processor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2ForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_labels = [[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_labels, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Target image sizes (height, width) to rescale box predictions [batch_size, 2]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([(image.height, image.width)])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_grounded_object_detection(
<span class="hljs-meta">... </span>    outputs=outputs, target_sizes=target_sizes, threshold=<span class="hljs-number">0.1</span>, text_labels=text_labels
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Retrieve predictions for the first image for the corresponding text queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = results[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes, scores, text_labels = result[<span class="hljs-string">&quot;boxes&quot;</span>], result[<span class="hljs-string">&quot;scores&quot;</span>], result[<span class="hljs-string">&quot;text_labels&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, text_label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, text_labels):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected <span class="hljs-subst">{text_label}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.614</span> at location [<span class="hljs-number">341.67</span>, <span class="hljs-number">23.39</span>, <span class="hljs-number">642.32</span>, <span class="hljs-number">371.35</span>]
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.665</span> at location [<span class="hljs-number">6.75</span>, <span class="hljs-number">51.96</span>, <span class="hljs-number">326.62</span>, <span class="hljs-number">473.13</span>]`,wrap:!1}}),Pe=new V({props:{title:"Resources",local:"resources",headingTag:"h2"}}),se=new Ue({props:{$$slots:{default:[On]},$$scope:{ctx:T}}}),qe=new V({props:{title:"Owlv2Config",local:"transformers.Owlv2Config",headingTag:"h2"}}),Ge=new J({props:{name:"class transformers.Owlv2Config",anchor:"transformers.Owlv2Config",parameters:[{name:"text_config",val:" = None"},{name:"vision_config",val:" = None"},{name:"projection_dim",val:" = 512"},{name:"logit_scale_init_value",val:" = 2.6592"},{name:"return_dict",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2Config.text_config",description:`<strong>text_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextConfig">Owlv2TextConfig</a>.`,name:"text_config"},{anchor:"transformers.Owlv2Config.vision_config",description:`<strong>vision_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionConfig">Owlv2VisionConfig</a>.`,name:"vision_config"},{anchor:"transformers.Owlv2Config.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of text and vision projection layers.`,name:"projection_dim"},{anchor:"transformers.Owlv2Config.logit_scale_init_value",description:`<strong>logit_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 2.6592) &#x2014;
The initial value of the <em>logit_scale</em> parameter. Default is used as per the original OWLv2
implementation.`,name:"logit_scale_init_value"},{anchor:"transformers.Owlv2Config.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return a dictionary. If <code>False</code>, returns a tuple.`,name:"return_dict"},{anchor:"transformers.Owlv2Config.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/configuration_owlv2.py#L217"}}),Xe=new J({props:{name:"from_text_vision_configs",anchor:"transformers.Owlv2Config.from_text_vision_configs",parameters:[{name:"text_config",val:": typing.Dict"},{name:"vision_config",val:": typing.Dict"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/configuration_owlv2.py#L273",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Config"
>Owlv2Config</a></p>
`}}),De=new V({props:{title:"Owlv2TextConfig",local:"transformers.Owlv2TextConfig",headingTag:"h2"}}),Ee=new J({props:{name:"class transformers.Owlv2TextConfig",anchor:"transformers.Owlv2TextConfig",parameters:[{name:"vocab_size",val:" = 49408"},{name:"hidden_size",val:" = 512"},{name:"intermediate_size",val:" = 2048"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 8"},{name:"max_position_embeddings",val:" = 16"},{name:"hidden_act",val:" = 'quick_gelu'"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 1.0"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 49406"},{name:"eos_token_id",val:" = 49407"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2TextConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49408) &#x2014;
Vocabulary size of the OWLv2 text model. Defines the number of different tokens that can be represented
by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel">Owlv2TextModel</a>.`,name:"vocab_size"},{anchor:"transformers.Owlv2TextConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.Owlv2TextConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.Owlv2TextConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Owlv2TextConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Owlv2TextConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.Owlv2TextConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Owlv2TextConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.Owlv2TextConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Owlv2TextConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Owlv2TextConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.Owlv2TextConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The id of the padding token in the input sequences.`,name:"pad_token_id"},{anchor:"transformers.Owlv2TextConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 49406) &#x2014;
The id of the beginning-of-sequence token in the input sequences.`,name:"bos_token_id"},{anchor:"transformers.Owlv2TextConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 49407) &#x2014;
The id of the end-of-sequence token in the input sequences.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/configuration_owlv2.py#L31"}}),ae=new te({props:{anchor:"transformers.Owlv2TextConfig.example",$$slots:{default:[In]},$$scope:{ctx:T}}}),Ye=new V({props:{title:"Owlv2VisionConfig",local:"transformers.Owlv2VisionConfig",headingTag:"h2"}}),Qe=new J({props:{name:"class transformers.Owlv2VisionConfig",anchor:"transformers.Owlv2VisionConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"intermediate_size",val:" = 3072"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"num_channels",val:" = 3"},{name:"image_size",val:" = 768"},{name:"patch_size",val:" = 16"},{name:"hidden_act",val:" = 'quick_gelu'"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 1.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2VisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.Owlv2VisionConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.Owlv2VisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Owlv2VisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Owlv2VisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input images.`,name:"num_channels"},{anchor:"transformers.Owlv2VisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.Owlv2VisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.Owlv2VisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Owlv2VisionConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.Owlv2VisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Owlv2VisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Owlv2VisionConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/configuration_owlv2.py#L128"}}),re=new te({props:{anchor:"transformers.Owlv2VisionConfig.example",$$slots:{default:[zn]},$$scope:{ctx:T}}}),Ae=new V({props:{title:"Owlv2ImageProcessor",local:"transformers.Owlv2ImageProcessor",headingTag:"h2"}}),Se=new J({props:{name:"class transformers.Owlv2ImageProcessor",anchor:"transformers.Owlv2ImageProcessor",parameters:[{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_pad",val:": bool = True"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overriden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.Owlv2ImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overriden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.Owlv2ImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to a square with gray pixels on the bottom and the right. Can be overriden by
<code>do_pad</code> in the <code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.Owlv2ImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overriden
by <code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.Owlv2ImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 960, &quot;width&quot;: 960}</code>):
Size to resize the image to. Can be overriden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.Owlv2ImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling method to use if resizing the image. Can be overriden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.Owlv2ImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.Owlv2ImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>OPENAI_CLIP_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.Owlv2ImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>OPENAI_CLIP_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/image_processing_owlv2.py#L211"}}),Ke=new J({props:{name:"preprocess",anchor:"transformers.Owlv2ImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_pad",val:": bool = None"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image to a square with gray pixels on the bottom and the right.`,name:"do_pad"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size to resize the image to.`,name:"size"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/image_processing_owlv2.py#L368"}}),et=new J({props:{name:"post_process_object_detection",anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:": Owlv2ObjectDetectionOutput"},{name:"threshold",val:": float = 0.1"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple], NoneType] = None"}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>Owlv2ObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/image_processing_owlv2.py#L503",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the following keys:</p>
<ul>
<li>“scores”: The confidence scores for each predicted box on the image.</li>
<li>“labels”: Indexes of the classes predicted by the model on the image.</li>
<li>“boxes”: Image bounding boxes in (top_left_x, top_left_y, bottom_right_x, bottom_right_y) format.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),tt=new J({props:{name:"post_process_image_guided_detection",anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:" = 0.0"},{name:"nms_threshold",val:" = 0.3"},{name:"target_sizes",val:" = None"}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.outputs",description:`<strong>outputs</strong> (<code>OwlViTImageGuidedObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Minimum confidence threshold to use to filter out predicted boxes.`,name:"threshold"},{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.nms_threshold",description:`<strong>nms_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
IoU threshold for non-maximum suppression of overlapping boxes.`,name:"nms_threshold"},{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Tensor of shape (batch_size, 2) where each entry is the (height, width) of the corresponding image in
the batch. If set, predicted normalized bounding boxes are rescaled to the target sizes. If left to
None, predictions will not be unnormalized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/image_processing_owlv2.py#L557",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model. All labels are set to None as
<code>OwlViTForObjectDetection.image_guided_detection</code> perform one-shot object detection.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ot=new V({props:{title:"Owlv2Processor",local:"transformers.Owlv2Processor",headingTag:"h2"}}),st=new J({props:{name:"class transformers.Owlv2Processor",anchor:"transformers.Owlv2Processor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2Processor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.Owlv2Processor.tokenizer",description:`<strong>tokenizer</strong> ([<code>CLIPTokenizer</code>, <code>CLIPTokenizerFast</code>]) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/processing_owlv2.py#L58"}}),nt=new J({props:{name:"__call__",anchor:"transformers.Owlv2Processor.__call__",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor'], NoneType] = None"},{name:"text",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]]] = None"},{name:"*args",val:""},{name:"audio",val:" = None"},{name:"videos",val:" = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.owlv2.processing_owlv2.Owlv2ProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.Owlv2Processor.__call__.images",description:"<strong>images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;",name:"images"},{anchor:"transformers.Owlv2Processor.__call__.List[torch.Tensor])",description:`<strong><code>List[torch.Tensor]</code>)</strong> &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. Both channels-first and channels-last formats are supported.`,name:"List[torch.Tensor])"},{anchor:"transformers.Owlv2Processor.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.Owlv2Processor.__call__.query_images",description:`<strong>query_images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The query image to be prepared, one query image is expected per target image to be queried. Each image
can be a PIL image, NumPy array or PyTorch tensor. In case of a NumPy array/PyTorch tensor, each image
should be of shape (C, H, W), where C is a number of channels, H and W are image height and width.`,name:"query_images"},{anchor:"transformers.Owlv2Processor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/processing_owlv2.py#L81",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — List of token ids to be fed to a model. Returned when <code>text</code> is not <code>None</code>.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code> and if <code>text</code> is not
<code>None</code>).</li>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model. Returned when <code>images</code> is not <code>None</code>.</li>
<li><strong>query_pixel_values</strong> — Pixel values of the query images to be fed to a model. Returned when <code>query_images</code> is not <code>None</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),at=new J({props:{name:"post_process_grounded_object_detection",anchor:"transformers.Owlv2Processor.post_process_grounded_object_detection",parameters:[{name:"outputs",val:": Owlv2ObjectDetectionOutput"},{name:"threshold",val:": float = 0.1"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple], NoneType] = None"},{name:"text_labels",val:": typing.Optional[typing.List[typing.List[str]]] = None"}],parametersDescription:[{anchor:"transformers.Owlv2Processor.post_process_grounded_object_detection.outputs",description:`<strong>outputs</strong> (<code>Owlv2ObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Owlv2Processor.post_process_grounded_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.Owlv2Processor.post_process_grounded_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.Owlv2Processor.post_process_grounded_object_detection.text_labels",description:`<strong>text_labels</strong> (<code>List[List[str]]</code>, <em>optional</em>) &#x2014;
List of lists of text labels for each image in the batch. If unset, &#x201C;text_labels&#x201D; in output will be
set to <code>None</code>.`,name:"text_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/processing_owlv2.py#L221",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the following keys:</p>
<ul>
<li>“scores”: The confidence scores for each predicted box on the image.</li>
<li>“labels”: Indexes of the classes predicted by the model on the image.</li>
<li>“boxes”: Image bounding boxes in (top_left_x, top_left_y, bottom_right_x, bottom_right_y) format.</li>
<li>“text_labels”: The text labels for each predicted bounding box on the image.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),rt=new J({props:{name:"post_process_image_guided_detection",anchor:"transformers.Owlv2Processor.post_process_image_guided_detection",parameters:[{name:"outputs",val:": Owlv2ImageGuidedObjectDetectionOutput"},{name:"threshold",val:": float = 0.0"},{name:"nms_threshold",val:": float = 0.3"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple], NoneType] = None"}],parametersDescription:[{anchor:"transformers.Owlv2Processor.post_process_image_guided_detection.outputs",description:`<strong>outputs</strong> (<code>Owlv2ImageGuidedObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Owlv2Processor.post_process_image_guided_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Minimum confidence threshold to use to filter out predicted boxes.`,name:"threshold"},{anchor:"transformers.Owlv2Processor.post_process_image_guided_detection.nms_threshold",description:`<strong>nms_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
IoU threshold for non-maximum suppression of overlapping boxes.`,name:"nms_threshold"},{anchor:"transformers.Owlv2Processor.post_process_image_guided_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Tensor of shape (batch_size, 2) where each entry is the (height, width) of the corresponding image in
the batch. If set, predicted normalized bounding boxes are rescaled to the target sizes. If left to
None, predictions will not be unnormalized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/processing_owlv2.py#L270",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the following keys:</p>
<ul>
<li>“scores”: The confidence scores for each predicted box on the image.</li>
<li>“boxes”: Image bounding boxes in (top_left_x, top_left_y, bottom_right_x, bottom_right_y) format.</li>
<li>“labels”: Set to <code>None</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),lt=new V({props:{title:"Owlv2Model",local:"transformers.Owlv2Model",headingTag:"h2"}}),it=new J({props:{name:"class transformers.Owlv2Model",anchor:"transformers.Owlv2Model",parameters:[{name:"config",val:": Owlv2Config"}],parametersDescription:[{anchor:"transformers.Owlv2Model.config",description:`<strong>config</strong> (<code>Owvl2Config</code>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L1066"}}),ct=new J({props:{name:"forward",anchor:"transformers.Owlv2Model.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"return_loss",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_base_image_embeds",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>`,name:"input_ids"},{anchor:"transformers.Owlv2Model.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Owlv2Model.forward.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.Owlv2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2Model.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.Owlv2Model.forward.return_base_image_embeds",description:`<strong>return_base_image_embeds</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the base image embeddings.`,name:"return_base_image_embeds"},{anchor:"transformers.Owlv2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L1185",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.owlv2.modeling_owlv2.Owlv2Output</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2Config'&gt;</code>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image</strong> (<code>torch.FloatTensor</code> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text</strong> (<code>torch.FloatTensor</code> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_max_text_queries, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of
<a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
<li><strong>text_model_output</strong> (Tuple<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.owlv2.modeling_owlv2.Owlv2Output</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),he=new Ue({props:{$$slots:{default:[Un]},$$scope:{ctx:T}}}),ge=new te({props:{anchor:"transformers.Owlv2Model.forward.example",$$slots:{default:[kn]},$$scope:{ctx:T}}}),dt=new J({props:{name:"get_text_features",anchor:"transformers.Owlv2Model.get_text_features",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2Model.get_text_features.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_max_text_queries, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>`,name:"input_ids"},{anchor:"transformers.Owlv2Model.get_text_features.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_max_text_queries, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Owlv2Model.get_text_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2Model.get_text_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2Model.get_text_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L1103",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The text embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>text_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),ue=new Ue({props:{$$slots:{default:[Cn]},$$scope:{ctx:T}}}),fe=new te({props:{anchor:"transformers.Owlv2Model.get_text_features.example",$$slots:{default:[Wn]},$$scope:{ctx:T}}}),mt=new J({props:{name:"get_image_features",anchor:"transformers.Owlv2Model.get_image_features",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2Model.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2Model.get_image_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2Model.get_image_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2Model.get_image_features.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.Owlv2Model.get_image_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L1138",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The image embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),_e=new Ue({props:{$$slots:{default:[Zn]},$$scope:{ctx:T}}}),be=new te({props:{anchor:"transformers.Owlv2Model.get_image_features.example",$$slots:{default:[Nn]},$$scope:{ctx:T}}}),pt=new V({props:{title:"Owlv2TextModel",local:"transformers.Owlv2TextModel",headingTag:"h2"}}),ht=new J({props:{name:"class transformers.Owlv2TextModel",anchor:"transformers.Owlv2TextModel",parameters:[{name:"config",val:": Owlv2TextConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L901"}}),gt=new J({props:{name:"forward",anchor:"transformers.Owlv2TextModel.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2TextModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_max_text_queries, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>`,name:"input_ids"},{anchor:"transformers.Owlv2TextModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_max_text_queries, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Owlv2TextModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2TextModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2TextModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L916",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2TextConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),we=new Ue({props:{$$slots:{default:[Vn]},$$scope:{ctx:T}}}),ve=new te({props:{anchor:"transformers.Owlv2TextModel.forward.example",$$slots:{default:[Bn]},$$scope:{ctx:T}}}),ut=new V({props:{title:"Owlv2VisionModel",local:"transformers.Owlv2VisionModel",headingTag:"h2"}}),ft=new J({props:{name:"class transformers.Owlv2VisionModel",anchor:"transformers.Owlv2VisionModel",parameters:[{name:"config",val:": Owlv2VisionConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L1014"}}),_t=new J({props:{name:"forward",anchor:"transformers.Owlv2VisionModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2VisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2VisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2VisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2VisionModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.Owlv2VisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L1027",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2VisionConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ye=new Ue({props:{$$slots:{default:[Rn]},$$scope:{ctx:T}}}),Me=new te({props:{anchor:"transformers.Owlv2VisionModel.forward.example",$$slots:{default:[Hn]},$$scope:{ctx:T}}}),bt=new V({props:{title:"Owlv2ForObjectDetection",local:"transformers.Owlv2ForObjectDetection",headingTag:"h2"}}),wt=new J({props:{name:"class transformers.Owlv2ForObjectDetection",anchor:"transformers.Owlv2ForObjectDetection",parameters:[{name:"config",val:": Owlv2Config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L1346"}}),vt=new J({props:{name:"forward",anchor:"transformers.Owlv2ForObjectDetection.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"pixel_values",val:": FloatTensor"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2ForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2ForObjectDetection.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_max_text_queries, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>.`,name:"input_ids"},{anchor:"transformers.Owlv2ForObjectDetection.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_max_text_queries, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Owlv2ForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the last hidden state. See <code>text_model_last_hidden_state</code> and
<code>vision_model_last_hidden_state</code> under returned tensors for more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2ForObjectDetection.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.Owlv2ForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L1732",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.owlv2.modeling_owlv2.Owlv2ObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2Config'&gt;</code>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, num_queries)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>objectness_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 1)</code>) — The objectness logits of all image patches. OWL-ViT represents images as a set of image patches where the
total number of patches is (image_size / patch_size)**2.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor.post_process_object_detection"
>post_process_object_detection()</a> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>text_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_max_text_queries, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size, patch_size, output_dim</code>) — Pooled output of <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>. OWLv2 represents images as a set of image patches and computes image
embeddings for each patch.</li>
<li><strong>class_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, hidden_size)</code>) — Class embeddings of all image patches. OWLv2 represents images as a set of image patches where the total
number of patches is (image_size / patch_size)**2.</li>
<li><strong>text_model_output</strong> (Tuple<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.owlv2.modeling_owlv2.Owlv2ObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Te=new Ue({props:{$$slots:{default:[Fn]},$$scope:{ctx:T}}}),je=new te({props:{anchor:"transformers.Owlv2ForObjectDetection.forward.example",$$slots:{default:[Pn]},$$scope:{ctx:T}}}),yt=new J({props:{name:"image_guided_detection",anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"query_pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.query_pixel_values",description:`<strong>query_pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values of query image(s) to be detected. Pass in one query image per target image.`,name:"query_pixel_values"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L1614",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.owlv2.modeling_owlv2.Owlv2ImageGuidedObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2Config'&gt;</code>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, num_queries)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>target_pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual target image in the batch
(disregarding possible padding). You can use <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor.post_process_object_detection"
>post_process_object_detection()</a> to
retrieve the unnormalized bounding boxes.</li>
<li><strong>query_pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual query image in the batch
(disregarding possible padding). You can use <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor.post_process_object_detection"
>post_process_object_detection()</a> to
retrieve the unnormalized bounding boxes.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size, patch_size, output_dim</code>) — Pooled output of <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>. OWLv2 represents images as a set of image patches and computes
image embeddings for each patch.</li>
<li><strong>query_image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size, patch_size, output_dim</code>) — Pooled output of <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>. OWLv2 represents images as a set of image patches and computes
image embeddings for each patch.</li>
<li><strong>class_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, hidden_size)</code>) — Class embeddings of all image patches. OWLv2 represents images as a set of image patches where the total
number of patches is (image_size / patch_size)**2.</li>
<li><strong>text_model_output</strong> (Tuple<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.owlv2.modeling_owlv2.Owlv2ImageGuidedObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),xe=new Ue({props:{$$slots:{default:[Ln]},$$scope:{ctx:T}}}),Je=new te({props:{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.example",$$slots:{default:[qn]},$$scope:{ctx:T}}}),Mt=new $n({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/owlv2.md"}}),{c(){t=m("meta"),w=a(),l=m("p"),c=a(),h(v.$$.fragment),o=a(),M=m("div"),M.innerHTML=Hs,so=a(),h(ke.$$.fragment),no=a(),Ce=m("p"),Ce.innerHTML=Fs,ao=a(),We=m("p"),We.textContent=Ps,ro=a(),Ze=m("p"),Ze.innerHTML=Ls,lo=a(),oe=m("img"),io=a(),Ne=m("small"),Ne.innerHTML=Gs,co=a(),Ve=m("p"),Ve.innerHTML=Xs,mo=a(),h(Be.$$.fragment),po=a(),Re=m("p"),Re.innerHTML=Ds,ho=a(),He=m("p"),He.innerHTML=Es,go=a(),h(Fe.$$.fragment),uo=a(),h(Pe.$$.fragment),fo=a(),Le=m("ul"),Le.innerHTML=Ys,_o=a(),h(se.$$.fragment),bo=a(),h(qe.$$.fragment),wo=a(),k=m("div"),h(Ge.$$.fragment),Ho=a(),Ut=m("p"),Ut.innerHTML=Qs,Fo=a(),kt=m("p"),kt.innerHTML=As,Po=a(),ne=m("div"),h(Xe.$$.fragment),Lo=a(),Ct=m("p"),Ct.innerHTML=Ss,vo=a(),h(De.$$.fragment),yo=a(),C=m("div"),h(Ee.$$.fragment),qo=a(),Wt=m("p"),Wt.innerHTML=Ks,Go=a(),Zt=m("p"),Zt.innerHTML=en,Xo=a(),h(ae.$$.fragment),Mo=a(),h(Ye.$$.fragment),To=a(),W=m("div"),h(Qe.$$.fragment),Do=a(),Nt=m("p"),Nt.innerHTML=tn,Eo=a(),Vt=m("p"),Vt.innerHTML=on,Yo=a(),h(re.$$.fragment),jo=a(),h(Ae.$$.fragment),xo=a(),I=m("div"),h(Se.$$.fragment),Qo=a(),Bt=m("p"),Bt.textContent=sn,Ao=a(),le=m("div"),h(Ke.$$.fragment),So=a(),Rt=m("p"),Rt.textContent=nn,Ko=a(),ie=m("div"),h(et.$$.fragment),es=a(),Ht=m("p"),Ht.innerHTML=an,ts=a(),ce=m("div"),h(tt.$$.fragment),os=a(),Ft=m("p"),Ft.innerHTML=rn,Jo=a(),h(ot.$$.fragment),$o=a(),z=m("div"),h(st.$$.fragment),ss=a(),Pt=m("p"),Pt.innerHTML=ln,ns=a(),de=m("div"),h(nt.$$.fragment),as=a(),Lt=m("p"),Lt.innerHTML=cn,rs=a(),me=m("div"),h(at.$$.fragment),ls=a(),qt=m("p"),qt.innerHTML=dn,is=a(),pe=m("div"),h(rt.$$.fragment),cs=a(),Gt=m("p"),Gt.innerHTML=mn,Oo=a(),h(lt.$$.fragment),Io=a(),$=m("div"),h(it.$$.fragment),ds=a(),Xt=m("p"),Xt.innerHTML=pn,ms=a(),Dt=m("p"),Dt.innerHTML=hn,ps=a(),B=m("div"),h(ct.$$.fragment),hs=a(),Et=m("p"),Et.innerHTML=gn,gs=a(),h(he.$$.fragment),us=a(),h(ge.$$.fragment),fs=a(),R=m("div"),h(dt.$$.fragment),_s=a(),Yt=m("p"),Yt.innerHTML=un,bs=a(),h(ue.$$.fragment),ws=a(),h(fe.$$.fragment),vs=a(),H=m("div"),h(mt.$$.fragment),ys=a(),Qt=m("p"),Qt.innerHTML=fn,Ms=a(),h(_e.$$.fragment),Ts=a(),h(be.$$.fragment),zo=a(),h(pt.$$.fragment),Uo=a(),K=m("div"),h(ht.$$.fragment),js=a(),F=m("div"),h(gt.$$.fragment),xs=a(),At=m("p"),At.innerHTML=_n,Js=a(),h(we.$$.fragment),$s=a(),h(ve.$$.fragment),ko=a(),h(ut.$$.fragment),Co=a(),ee=m("div"),h(ft.$$.fragment),Os=a(),P=m("div"),h(_t.$$.fragment),Is=a(),St=m("p"),St.innerHTML=bn,zs=a(),h(ye.$$.fragment),Us=a(),h(Me.$$.fragment),Wo=a(),h(bt.$$.fragment),Zo=a(),G=m("div"),h(wt.$$.fragment),ks=a(),L=m("div"),h(vt.$$.fragment),Cs=a(),Kt=m("p"),Kt.innerHTML=wn,Ws=a(),h(Te.$$.fragment),Zs=a(),h(je.$$.fragment),Ns=a(),q=m("div"),h(yt.$$.fragment),Vs=a(),eo=m("p"),eo.innerHTML=vn,Bs=a(),h(xe.$$.fragment),Rs=a(),h(Je.$$.fragment),No=a(),h(Mt.$$.fragment),Vo=a(),oo=m("p"),this.h()},l(e){const s=Jn("svelte-u9bgzb",document.head);t=p(s,"META",{name:!0,content:!0}),s.forEach(n),w=r(e),l=p(e,"P",{}),x(l).forEach(n),c=r(e),g(v.$$.fragment,e),o=r(e),M=p(e,"DIV",{class:!0,"data-svelte-h":!0}),y(M)!=="svelte-13t8s2t"&&(M.innerHTML=Hs),so=r(e),g(ke.$$.fragment,e),no=r(e),Ce=p(e,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-1jjmdbl"&&(Ce.innerHTML=Fs),ao=r(e),We=p(e,"P",{"data-svelte-h":!0}),y(We)!=="svelte-vfdo9a"&&(We.textContent=Ps),ro=r(e),Ze=p(e,"P",{"data-svelte-h":!0}),y(Ze)!=="svelte-17v2uvw"&&(Ze.innerHTML=Ls),lo=r(e),oe=p(e,"IMG",{src:!0,alt:!0,width:!0}),io=r(e),Ne=p(e,"SMALL",{"data-svelte-h":!0}),y(Ne)!=="svelte-a4adom"&&(Ne.innerHTML=Gs),co=r(e),Ve=p(e,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-h0sl6k"&&(Ve.innerHTML=Xs),mo=r(e),g(Be.$$.fragment,e),po=r(e),Re=p(e,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-44ncwu"&&(Re.innerHTML=Ds),ho=r(e),He=p(e,"P",{"data-svelte-h":!0}),y(He)!=="svelte-2hrjcv"&&(He.innerHTML=Es),go=r(e),g(Fe.$$.fragment,e),uo=r(e),g(Pe.$$.fragment,e),fo=r(e),Le=p(e,"UL",{"data-svelte-h":!0}),y(Le)!=="svelte-yomnb6"&&(Le.innerHTML=Ys),_o=r(e),g(se.$$.fragment,e),bo=r(e),g(qe.$$.fragment,e),wo=r(e),k=p(e,"DIV",{class:!0});var X=x(k);g(Ge.$$.fragment,X),Ho=r(X),Ut=p(X,"P",{"data-svelte-h":!0}),y(Ut)!=="svelte-1eeue6z"&&(Ut.innerHTML=Qs),Fo=r(X),kt=p(X,"P",{"data-svelte-h":!0}),y(kt)!=="svelte-o55m63"&&(kt.innerHTML=As),Po=r(X),ne=p(X,"DIV",{class:!0});var Tt=x(ne);g(Xe.$$.fragment,Tt),Lo=r(Tt),Ct=p(Tt,"P",{"data-svelte-h":!0}),y(Ct)!=="svelte-1e3bs5y"&&(Ct.innerHTML=Ss),Tt.forEach(n),X.forEach(n),vo=r(e),g(De.$$.fragment,e),yo=r(e),C=p(e,"DIV",{class:!0});var D=x(C);g(Ee.$$.fragment,D),qo=r(D),Wt=p(D,"P",{"data-svelte-h":!0}),y(Wt)!=="svelte-1qnmyr9"&&(Wt.innerHTML=Ks),Go=r(D),Zt=p(D,"P",{"data-svelte-h":!0}),y(Zt)!=="svelte-o55m63"&&(Zt.innerHTML=en),Xo=r(D),g(ae.$$.fragment,D),D.forEach(n),Mo=r(e),g(Ye.$$.fragment,e),To=r(e),W=p(e,"DIV",{class:!0});var E=x(W);g(Qe.$$.fragment,E),Do=r(E),Nt=p(E,"P",{"data-svelte-h":!0}),y(Nt)!=="svelte-1ww21ml"&&(Nt.innerHTML=tn),Eo=r(E),Vt=p(E,"P",{"data-svelte-h":!0}),y(Vt)!=="svelte-o55m63"&&(Vt.innerHTML=on),Yo=r(E),g(re.$$.fragment,E),E.forEach(n),jo=r(e),g(Ae.$$.fragment,e),xo=r(e),I=p(e,"DIV",{class:!0});var Z=x(I);g(Se.$$.fragment,Z),Qo=r(Z),Bt=p(Z,"P",{"data-svelte-h":!0}),y(Bt)!=="svelte-dzqrng"&&(Bt.textContent=sn),Ao=r(Z),le=p(Z,"DIV",{class:!0});var jt=x(le);g(Ke.$$.fragment,jt),So=r(jt),Rt=p(jt,"P",{"data-svelte-h":!0}),y(Rt)!=="svelte-1x3yxsa"&&(Rt.textContent=nn),jt.forEach(n),Ko=r(Z),ie=p(Z,"DIV",{class:!0});var xt=x(ie);g(et.$$.fragment,xt),es=r(xt),Ht=p(xt,"P",{"data-svelte-h":!0}),y(Ht)!=="svelte-1dvjhkg"&&(Ht.innerHTML=an),xt.forEach(n),ts=r(Z),ce=p(Z,"DIV",{class:!0});var Jt=x(ce);g(tt.$$.fragment,Jt),os=r(Jt),Ft=p(Jt,"P",{"data-svelte-h":!0}),y(Ft)!=="svelte-dhbo7w"&&(Ft.innerHTML=rn),Jt.forEach(n),Z.forEach(n),Jo=r(e),g(ot.$$.fragment,e),$o=r(e),z=p(e,"DIV",{class:!0});var N=x(z);g(st.$$.fragment,N),ss=r(N),Pt=p(N,"P",{"data-svelte-h":!0}),y(Pt)!=="svelte-1ojuptc"&&(Pt.innerHTML=ln),ns=r(N),de=p(N,"DIV",{class:!0});var $t=x(de);g(nt.$$.fragment,$t),as=r($t),Lt=p($t,"P",{"data-svelte-h":!0}),y(Lt)!=="svelte-1dazhfm"&&(Lt.innerHTML=cn),$t.forEach(n),rs=r(N),me=p(N,"DIV",{class:!0});var Ot=x(me);g(at.$$.fragment,Ot),ls=r(Ot),qt=p(Ot,"P",{"data-svelte-h":!0}),y(qt)!=="svelte-1dvjhkg"&&(qt.innerHTML=dn),Ot.forEach(n),is=r(N),pe=p(N,"DIV",{class:!0});var It=x(pe);g(rt.$$.fragment,It),cs=r(It),Gt=p(It,"P",{"data-svelte-h":!0}),y(Gt)!=="svelte-galzft"&&(Gt.innerHTML=mn),It.forEach(n),N.forEach(n),Oo=r(e),g(lt.$$.fragment,e),Io=r(e),$=p(e,"DIV",{class:!0});var U=x($);g(it.$$.fragment,U),ds=r(U),Xt=p(U,"P",{"data-svelte-h":!0}),y(Xt)!=="svelte-6pahdo"&&(Xt.innerHTML=pn),ms=r(U),Dt=p(U,"P",{"data-svelte-h":!0}),y(Dt)!=="svelte-hswkmf"&&(Dt.innerHTML=hn),ps=r(U),B=p(U,"DIV",{class:!0});var Y=x(B);g(ct.$$.fragment,Y),hs=r(Y),Et=p(Y,"P",{"data-svelte-h":!0}),y(Et)!=="svelte-1snknjv"&&(Et.innerHTML=gn),gs=r(Y),g(he.$$.fragment,Y),us=r(Y),g(ge.$$.fragment,Y),Y.forEach(n),fs=r(U),R=p(U,"DIV",{class:!0});var Q=x(R);g(dt.$$.fragment,Q),_s=r(Q),Yt=p(Q,"P",{"data-svelte-h":!0}),y(Yt)!=="svelte-1snknjv"&&(Yt.innerHTML=un),bs=r(Q),g(ue.$$.fragment,Q),ws=r(Q),g(fe.$$.fragment,Q),Q.forEach(n),vs=r(U),H=p(U,"DIV",{class:!0});var A=x(H);g(mt.$$.fragment,A),ys=r(A),Qt=p(A,"P",{"data-svelte-h":!0}),y(Qt)!=="svelte-1snknjv"&&(Qt.innerHTML=fn),Ms=r(A),g(_e.$$.fragment,A),Ts=r(A),g(be.$$.fragment,A),A.forEach(n),U.forEach(n),zo=r(e),g(pt.$$.fragment,e),Uo=r(e),K=p(e,"DIV",{class:!0});var zt=x(K);g(ht.$$.fragment,zt),js=r(zt),F=p(zt,"DIV",{class:!0});var $e=x(F);g(gt.$$.fragment,$e),xs=r($e),At=p($e,"P",{"data-svelte-h":!0}),y(At)!=="svelte-1ncxtmd"&&(At.innerHTML=_n),Js=r($e),g(we.$$.fragment,$e),$s=r($e),g(ve.$$.fragment,$e),$e.forEach(n),zt.forEach(n),ko=r(e),g(ut.$$.fragment,e),Co=r(e),ee=p(e,"DIV",{class:!0});var Ro=x(ee);g(ft.$$.fragment,Ro),Os=r(Ro),P=p(Ro,"DIV",{class:!0});var Oe=x(P);g(_t.$$.fragment,Oe),Is=r(Oe),St=p(Oe,"P",{"data-svelte-h":!0}),y(St)!=="svelte-svi6u7"&&(St.innerHTML=bn),zs=r(Oe),g(ye.$$.fragment,Oe),Us=r(Oe),g(Me.$$.fragment,Oe),Oe.forEach(n),Ro.forEach(n),Wo=r(e),g(bt.$$.fragment,e),Zo=r(e),G=p(e,"DIV",{class:!0});var to=x(G);g(wt.$$.fragment,to),ks=r(to),L=p(to,"DIV",{class:!0});var Ie=x(L);g(vt.$$.fragment,Ie),Cs=r(Ie),Kt=p(Ie,"P",{"data-svelte-h":!0}),y(Kt)!=="svelte-453pb5"&&(Kt.innerHTML=wn),Ws=r(Ie),g(Te.$$.fragment,Ie),Zs=r(Ie),g(je.$$.fragment,Ie),Ie.forEach(n),Ns=r(to),q=p(to,"DIV",{class:!0});var ze=x(q);g(yt.$$.fragment,ze),Vs=r(ze),eo=p(ze,"P",{"data-svelte-h":!0}),y(eo)!=="svelte-453pb5"&&(eo.innerHTML=vn),Bs=r(ze),g(xe.$$.fragment,ze),Rs=r(ze),g(Je.$$.fragment,ze),ze.forEach(n),to.forEach(n),No=r(e),g(Mt.$$.fragment,e),Vo=r(e),oo=p(e,"P",{}),x(oo).forEach(n),this.h()},h(){j(t,"name","hf:doc:metadata"),j(t,"content",Xn),j(M,"class","flex flex-wrap space-x-1"),Mn(oe.src,qs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/owlv2_overview.png")||j(oe,"src",qs),j(oe,"alt","drawing"),j(oe,"width","600"),j(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){i(document.head,t),d(e,w,s),d(e,l,s),d(e,c,s),u(v,e,s),d(e,o,s),d(e,M,s),d(e,so,s),u(ke,e,s),d(e,no,s),d(e,Ce,s),d(e,ao,s),d(e,We,s),d(e,ro,s),d(e,Ze,s),d(e,lo,s),d(e,oe,s),d(e,io,s),d(e,Ne,s),d(e,co,s),d(e,Ve,s),d(e,mo,s),u(Be,e,s),d(e,po,s),d(e,Re,s),d(e,ho,s),d(e,He,s),d(e,go,s),u(Fe,e,s),d(e,uo,s),u(Pe,e,s),d(e,fo,s),d(e,Le,s),d(e,_o,s),u(se,e,s),d(e,bo,s),u(qe,e,s),d(e,wo,s),d(e,k,s),u(Ge,k,null),i(k,Ho),i(k,Ut),i(k,Fo),i(k,kt),i(k,Po),i(k,ne),u(Xe,ne,null),i(ne,Lo),i(ne,Ct),d(e,vo,s),u(De,e,s),d(e,yo,s),d(e,C,s),u(Ee,C,null),i(C,qo),i(C,Wt),i(C,Go),i(C,Zt),i(C,Xo),u(ae,C,null),d(e,Mo,s),u(Ye,e,s),d(e,To,s),d(e,W,s),u(Qe,W,null),i(W,Do),i(W,Nt),i(W,Eo),i(W,Vt),i(W,Yo),u(re,W,null),d(e,jo,s),u(Ae,e,s),d(e,xo,s),d(e,I,s),u(Se,I,null),i(I,Qo),i(I,Bt),i(I,Ao),i(I,le),u(Ke,le,null),i(le,So),i(le,Rt),i(I,Ko),i(I,ie),u(et,ie,null),i(ie,es),i(ie,Ht),i(I,ts),i(I,ce),u(tt,ce,null),i(ce,os),i(ce,Ft),d(e,Jo,s),u(ot,e,s),d(e,$o,s),d(e,z,s),u(st,z,null),i(z,ss),i(z,Pt),i(z,ns),i(z,de),u(nt,de,null),i(de,as),i(de,Lt),i(z,rs),i(z,me),u(at,me,null),i(me,ls),i(me,qt),i(z,is),i(z,pe),u(rt,pe,null),i(pe,cs),i(pe,Gt),d(e,Oo,s),u(lt,e,s),d(e,Io,s),d(e,$,s),u(it,$,null),i($,ds),i($,Xt),i($,ms),i($,Dt),i($,ps),i($,B),u(ct,B,null),i(B,hs),i(B,Et),i(B,gs),u(he,B,null),i(B,us),u(ge,B,null),i($,fs),i($,R),u(dt,R,null),i(R,_s),i(R,Yt),i(R,bs),u(ue,R,null),i(R,ws),u(fe,R,null),i($,vs),i($,H),u(mt,H,null),i(H,ys),i(H,Qt),i(H,Ms),u(_e,H,null),i(H,Ts),u(be,H,null),d(e,zo,s),u(pt,e,s),d(e,Uo,s),d(e,K,s),u(ht,K,null),i(K,js),i(K,F),u(gt,F,null),i(F,xs),i(F,At),i(F,Js),u(we,F,null),i(F,$s),u(ve,F,null),d(e,ko,s),u(ut,e,s),d(e,Co,s),d(e,ee,s),u(ft,ee,null),i(ee,Os),i(ee,P),u(_t,P,null),i(P,Is),i(P,St),i(P,zs),u(ye,P,null),i(P,Us),u(Me,P,null),d(e,Wo,s),u(bt,e,s),d(e,Zo,s),d(e,G,s),u(wt,G,null),i(G,ks),i(G,L),u(vt,L,null),i(L,Cs),i(L,Kt),i(L,Ws),u(Te,L,null),i(L,Zs),u(je,L,null),i(G,Ns),i(G,q),u(yt,q,null),i(q,Vs),i(q,eo),i(q,Bs),u(xe,q,null),i(q,Rs),u(Je,q,null),d(e,No,s),u(Mt,e,s),d(e,Vo,s),d(e,oo,s),Bo=!0},p(e,[s]){const X={};s&2&&(X.$$scope={dirty:s,ctx:e}),se.$set(X);const Tt={};s&2&&(Tt.$$scope={dirty:s,ctx:e}),ae.$set(Tt);const D={};s&2&&(D.$$scope={dirty:s,ctx:e}),re.$set(D);const E={};s&2&&(E.$$scope={dirty:s,ctx:e}),he.$set(E);const Z={};s&2&&(Z.$$scope={dirty:s,ctx:e}),ge.$set(Z);const jt={};s&2&&(jt.$$scope={dirty:s,ctx:e}),ue.$set(jt);const xt={};s&2&&(xt.$$scope={dirty:s,ctx:e}),fe.$set(xt);const Jt={};s&2&&(Jt.$$scope={dirty:s,ctx:e}),_e.$set(Jt);const N={};s&2&&(N.$$scope={dirty:s,ctx:e}),be.$set(N);const $t={};s&2&&($t.$$scope={dirty:s,ctx:e}),we.$set($t);const Ot={};s&2&&(Ot.$$scope={dirty:s,ctx:e}),ve.$set(Ot);const It={};s&2&&(It.$$scope={dirty:s,ctx:e}),ye.$set(It);const U={};s&2&&(U.$$scope={dirty:s,ctx:e}),Me.$set(U);const Y={};s&2&&(Y.$$scope={dirty:s,ctx:e}),Te.$set(Y);const Q={};s&2&&(Q.$$scope={dirty:s,ctx:e}),je.$set(Q);const A={};s&2&&(A.$$scope={dirty:s,ctx:e}),xe.$set(A);const zt={};s&2&&(zt.$$scope={dirty:s,ctx:e}),Je.$set(zt)},i(e){Bo||(f(v.$$.fragment,e),f(ke.$$.fragment,e),f(Be.$$.fragment,e),f(Fe.$$.fragment,e),f(Pe.$$.fragment,e),f(se.$$.fragment,e),f(qe.$$.fragment,e),f(Ge.$$.fragment,e),f(Xe.$$.fragment,e),f(De.$$.fragment,e),f(Ee.$$.fragment,e),f(ae.$$.fragment,e),f(Ye.$$.fragment,e),f(Qe.$$.fragment,e),f(re.$$.fragment,e),f(Ae.$$.fragment,e),f(Se.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(ot.$$.fragment,e),f(st.$$.fragment,e),f(nt.$$.fragment,e),f(at.$$.fragment,e),f(rt.$$.fragment,e),f(lt.$$.fragment,e),f(it.$$.fragment,e),f(ct.$$.fragment,e),f(he.$$.fragment,e),f(ge.$$.fragment,e),f(dt.$$.fragment,e),f(ue.$$.fragment,e),f(fe.$$.fragment,e),f(mt.$$.fragment,e),f(_e.$$.fragment,e),f(be.$$.fragment,e),f(pt.$$.fragment,e),f(ht.$$.fragment,e),f(gt.$$.fragment,e),f(we.$$.fragment,e),f(ve.$$.fragment,e),f(ut.$$.fragment,e),f(ft.$$.fragment,e),f(_t.$$.fragment,e),f(ye.$$.fragment,e),f(Me.$$.fragment,e),f(bt.$$.fragment,e),f(wt.$$.fragment,e),f(vt.$$.fragment,e),f(Te.$$.fragment,e),f(je.$$.fragment,e),f(yt.$$.fragment,e),f(xe.$$.fragment,e),f(Je.$$.fragment,e),f(Mt.$$.fragment,e),Bo=!0)},o(e){_(v.$$.fragment,e),_(ke.$$.fragment,e),_(Be.$$.fragment,e),_(Fe.$$.fragment,e),_(Pe.$$.fragment,e),_(se.$$.fragment,e),_(qe.$$.fragment,e),_(Ge.$$.fragment,e),_(Xe.$$.fragment,e),_(De.$$.fragment,e),_(Ee.$$.fragment,e),_(ae.$$.fragment,e),_(Ye.$$.fragment,e),_(Qe.$$.fragment,e),_(re.$$.fragment,e),_(Ae.$$.fragment,e),_(Se.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(ot.$$.fragment,e),_(st.$$.fragment,e),_(nt.$$.fragment,e),_(at.$$.fragment,e),_(rt.$$.fragment,e),_(lt.$$.fragment,e),_(it.$$.fragment,e),_(ct.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(dt.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(mt.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(pt.$$.fragment,e),_(ht.$$.fragment,e),_(gt.$$.fragment,e),_(we.$$.fragment,e),_(ve.$$.fragment,e),_(ut.$$.fragment,e),_(ft.$$.fragment,e),_(_t.$$.fragment,e),_(ye.$$.fragment,e),_(Me.$$.fragment,e),_(bt.$$.fragment,e),_(wt.$$.fragment,e),_(vt.$$.fragment,e),_(Te.$$.fragment,e),_(je.$$.fragment,e),_(yt.$$.fragment,e),_(xe.$$.fragment,e),_(Je.$$.fragment,e),_(Mt.$$.fragment,e),Bo=!1},d(e){e&&(n(w),n(l),n(c),n(o),n(M),n(so),n(no),n(Ce),n(ao),n(We),n(ro),n(Ze),n(lo),n(oe),n(io),n(Ne),n(co),n(Ve),n(mo),n(po),n(Re),n(ho),n(He),n(go),n(uo),n(fo),n(Le),n(_o),n(bo),n(wo),n(k),n(vo),n(yo),n(C),n(Mo),n(To),n(W),n(jo),n(xo),n(I),n(Jo),n($o),n(z),n(Oo),n(Io),n($),n(zo),n(Uo),n(K),n(ko),n(Co),n(ee),n(Wo),n(Zo),n(G),n(No),n(Vo),n(oo)),n(t),b(v,e),b(ke,e),b(Be,e),b(Fe,e),b(Pe,e),b(se,e),b(qe,e),b(Ge),b(Xe),b(De,e),b(Ee),b(ae),b(Ye,e),b(Qe),b(re),b(Ae,e),b(Se),b(Ke),b(et),b(tt),b(ot,e),b(st),b(nt),b(at),b(rt),b(lt,e),b(it),b(ct),b(he),b(ge),b(dt),b(ue),b(fe),b(mt),b(_e),b(be),b(pt,e),b(ht),b(gt),b(we),b(ve),b(ut,e),b(ft),b(_t),b(ye),b(Me),b(bt,e),b(wt),b(vt),b(Te),b(je),b(yt),b(xe),b(Je),b(Mt,e)}}}const Xn='{"title":"OWLv2","local":"owlv2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Owlv2Config","local":"transformers.Owlv2Config","sections":[],"depth":2},{"title":"Owlv2TextConfig","local":"transformers.Owlv2TextConfig","sections":[],"depth":2},{"title":"Owlv2VisionConfig","local":"transformers.Owlv2VisionConfig","sections":[],"depth":2},{"title":"Owlv2ImageProcessor","local":"transformers.Owlv2ImageProcessor","sections":[],"depth":2},{"title":"Owlv2Processor","local":"transformers.Owlv2Processor","sections":[],"depth":2},{"title":"Owlv2Model","local":"transformers.Owlv2Model","sections":[],"depth":2},{"title":"Owlv2TextModel","local":"transformers.Owlv2TextModel","sections":[],"depth":2},{"title":"Owlv2VisionModel","local":"transformers.Owlv2VisionModel","sections":[],"depth":2},{"title":"Owlv2ForObjectDetection","local":"transformers.Owlv2ForObjectDetection","sections":[],"depth":2}],"depth":1}';function Dn(T){return Tn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ta extends jn{constructor(t){super(),xn(this,t,Dn,Gn,yn,{})}}export{ta as component};
