import{s as Zs,n as Ns,o as Bs}from"../chunks/scheduler.7da89386.js";import{S as Qs,i as Es,g as i,s as n,r as u,A as Ws,h,f as l,c as p,j as gs,u as e,x as y,k as _s,y as ks,a as t,v as M,d as c,t as o,w as j}from"../chunks/index.20910acc.js";import{C as Ts}from"../chunks/CodeBlock.143bd81e.js";import{H as T,E as Gs}from"../chunks/getInferenceSnippets.2a9a9a3e.js";function Xs(Us){let J,R,v,Y,U,F,r,V,w,rs=`Lighteval will automatically save results and evaluation details in the
directory set with the <code>--output-dir</code> option. The results will be saved in
<code>{output_dir}/results/{model_name}/results_{timestamp}.json</code>. <a href="#example-of-a-result-file">Here is an
example of a result file</a>. The output path can be
any <a href="https://filesystem-spec.readthedocs.io/en/latest/index.html" rel="nofollow">fsspec</a>
compliant path (local, s3, hf hub, gdrive, ftp, etc).`,x,d,ws=`To save the details of the evaluation, you can use the <code>--save-details</code>
option. The details will be saved in a parquet file
<code>{output_dir}/details/{model_name}/{timestamp}/details_{task}_{timestamp}.parquet</code>.`,H,I,ds=`If you want results to be saved in a custom path, you can set the <code>results-path-template</code> option.
This allows you to set a string template for the path. The template need to contain the following
variables: <code>output_dir</code>, <code>model_name</code>, <code>org</code>. For example
<code>{output_dir}/{org}_{model}</code>. The template will be used to create the path for the results file.`,D,m,L,C,Is=`You can push the results and evaluation details to the HuggingFace hub. To do
so, you need to set the <code>--push-to-hub</code> as well as the <code>--results-org</code>
option. The results will be saved in a dataset with the name at
<code>{results_org}/{model_org}/{model_name}</code>. To push the details, you need to set
the <code>--save-details</code> option.
The dataset created will be private by default, you can make it public by
setting the <code>--public-run</code> option.`,P,q,O,A,ms=`You can push the results to Tensorboard by setting <code>--push-to-tensorboard</code>.
This will create a Tensorboard dashboard in a HF org set with the <code>--results-org</code>
option.`,K,f,ss,b,Cs=`You can push the results to WandB by setting <code>--wandb</code>. This will init a WandB
run and log the results.`,as,g,qs="Wandb args need to be set in your env variables.",ls,_,ts,Z,As='You can find a list of variable in the <a href="https://docs.wandb.ai/guides/track/environment-variables/" rel="nofollow">wandb documentation</a>.',ns,N,ps,B,us,Q,es,E,Ms,W,cs,k,fs="The detail file contains the following columns:",os,G,bs="<li><code>choices</code>: The choices presented to the model in the case of mutlichoice tasks.</li> <li><code>gold</code>: The gold answer.</li> <li><code>gold_index</code>: The index of the gold answer in the choices list.</li> <li><code>cont_tokens</code>: The continuation tokens.</li> <li><code>example</code>: The input in text form.</li> <li><code>full_prompt</code>: The full prompt, that will be inputed to the model.</li> <li><code>input_tokens</code>: The tokens of the full prompt.</li> <li><code>instruction</code>: The instruction given to the model.</li> <li><code>metrics</code>: The metrics computed for the example.</li> <li><code>num_asked_few_shots</code>: The number of few shots asked to the model.</li> <li><code>num_effective_few_shots</code>: The number of effective few shots.</li> <li><code>padded</code>: Whether the input was padded.</li> <li><code>pred_logits</code>: The logits of the model.</li> <li><code>predictions</code>: The predictions of the model.</li> <li><code>specifics</code>: The specifics of the task.</li> <li><code>truncated</code>: Whether the input was truncated.</li>",js,X,is,z,hs,$,ys,S,Js;return U=new T({props:{title:"Saving and reading results",local:"saving-and-reading-results",headingTag:"h1"}}),r=new T({props:{title:"Saving results locally",local:"saving-results-locally",headingTag:"h2"}}),m=new T({props:{title:"Pushing results to the HuggingFace hub",local:"pushing-results-to-the-huggingface-hub",headingTag:"h2"}}),q=new T({props:{title:"Pushing results to Tensorboard",local:"pushing-results-to-tensorboard",headingTag:"h2"}}),f=new T({props:{title:"Pushing results to WandB",local:"pushing-results-to-wandb",headingTag:"h2"}}),_=new Ts({props:{code:"ZXhwb3J0JTIwV0FOREJfUFJPSkVDVCUzRCUyMmxpZ2h0ZXZhbCUyMg==",highlighted:'<span class="hljs-built_in">export</span> <span class="hljs-attribute">WANDB_PROJECT</span>=<span class="hljs-string">&quot;lighteval&quot;</span>',wrap:!1}}),N=new T({props:{title:"How to load and investigate details",local:"how-to-load-and-investigate-details",headingTag:"h2"}}),B=new T({props:{title:"Load from local detail files",local:"load-from-local-detail-files",headingTag:"h3"}}),Q=new Ts({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwb3MlMEElMEFvdXRwdXRfZGlyJTIwJTNEJTIwJTIyZXZhbHNfZG9jJTIyJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiUwQXRpbWVzdGFtcCUyMCUzRCUyMCUyMmxhdGVzdCUyMiUwQXRhc2slMjAlM0QlMjAlMjJsaWdodGV2YWwlN0Nnc204ayU3QzAlMjIlMEElMEFpZiUyMHRpbWVzdGFtcCUyMCUzRCUzRCUyMCUyMmxhdGVzdCUyMiUzQSUwQSUyMCUyMCUyMCUyMHBhdGglMjAlM0QlMjBmJTIyJTdCb3V0cHV0X2RpciU3RCUyRmRldGFpbHMlMkYlN0Jtb2RlbF9vcmclN0QlMkYlN0Jtb2RlbF9uYW1lJTdEJTJGKiUyRiUyMiUwQSUyMCUyMCUyMCUyMHRpbWVzdGFtcHMlMjAlM0QlMjBnbG9iLmdsb2IocGF0aCklMEElMjAlMjAlMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjBzb3J0ZWQodGltZXN0YW1wcyklNUItMSU1RC5zcGxpdCglMjIlMkYlMjIpJTVCLTIlNUQlMEElMjAlMjAlMjAlMjBwcmludChmJTIyTGF0ZXN0JTIwdGltZXN0YW1wJTNBJTIwJTdCdGltZXN0YW1wJTdEJTIyKSUwQSUwQWRldGFpbHNfcGF0aCUyMCUzRCUyMGYlMjIlN0JvdXRwdXRfZGlyJTdEJTJGZGV0YWlscyUyRiU3Qm1vZGVsX25hbWUlN0QlMkYlN0J0aW1lc3RhbXAlN0QlMkZkZXRhaWxzXyU3QnRhc2slN0RfJTdCdGltZXN0YW1wJTdELnBhcnF1ZXQlMjIlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwZGV0YWlscyUwQWRldGFpbHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIycGFycXVldCUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkZXRhaWxzX3BhdGglMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQWZvciUyMGRldGFpbCUyMGluJTIwZGV0YWlscyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRldGFpbCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> os

output_dir = <span class="hljs-string">&quot;evals_doc&quot;</span>
model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
timestamp = <span class="hljs-string">&quot;latest&quot;</span>
task = <span class="hljs-string">&quot;lighteval|gsm8k|0&quot;</span>

<span class="hljs-keyword">if</span> timestamp == <span class="hljs-string">&quot;latest&quot;</span>:
    path = <span class="hljs-string">f&quot;<span class="hljs-subst">{output_dir}</span>/details/<span class="hljs-subst">{model_org}</span>/<span class="hljs-subst">{model_name}</span>/*/&quot;</span>
    timestamps = glob.glob(path)
    timestamp = <span class="hljs-built_in">sorted</span>(timestamps)[-<span class="hljs-number">1</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">2</span>]
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Latest timestamp: <span class="hljs-subst">{timestamp}</span>&quot;</span>)

details_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{output_dir}</span>/details/<span class="hljs-subst">{model_name}</span>/<span class="hljs-subst">{timestamp}</span>/details_<span class="hljs-subst">{task}</span>_<span class="hljs-subst">{timestamp}</span>.parquet&quot;</span>

<span class="hljs-comment"># Load the details</span>
details = load_dataset(<span class="hljs-string">&quot;parquet&quot;</span>, data_files=details_path, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-keyword">for</span> detail <span class="hljs-keyword">in</span> details:
    <span class="hljs-built_in">print</span>(detail)`,wrap:!1}}),E=new T({props:{title:"Load from the HuggingFace hub",local:"load-from-the-huggingface-hub",headingTag:"h3"}}),W=new Ts({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcmVzdWx0c19vcmclMjAlM0QlMjAlMjJTYXlsb3JUd2lmdCUyMiUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEFzYW5pdGl6ZWRfbW9kZWxfbmFtZSUyMCUzRCUyMG1vZGVsX25hbWUucmVwbGFjZSglMjIlMkYlMjIlMkMlMjAlMjJfXyUyMiklMEF0YXNrJTIwJTNEJTIwJTIybGlnaHRldmFsJTdDZ3NtOGslN0MwJTIyJTBBcHVibGljX3J1biUyMCUzRCUyMEZhbHNlJTBBJTBBZGF0YXNldF9wYXRoJTIwJTNEJTIwZiUyMiU3QnJlc3VsdHNfb3JnJTdEJTJGZGV0YWlsc18lN0JzYW5pdGl6ZWRfbW9kZWxfbmFtZSU3RCU3QidfcHJpdmF0ZSclMjBpZiUyMG5vdCUyMHB1YmxpY19ydW4lMjBlbHNlJTIwJyclN0QlMjIlMEFkZXRhaWxzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KGRhdGFzZXRfcGF0aCUyQyUyMHRhc2sucmVwbGFjZSglMjIlN0MlMjIlMkMlMjAlMjJfJTIyKSUyQyUyMHNwbGl0JTNEJTIybGF0ZXN0JTIyKSUwQSUwQWZvciUyMGRldGFpbCUyMGluJTIwZGV0YWlscyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRldGFpbCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

results_org = <span class="hljs-string">&quot;SaylorTwift&quot;</span>
model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
sanitized_model_name = model_name.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;__&quot;</span>)
task = <span class="hljs-string">&quot;lighteval|gsm8k|0&quot;</span>
public_run = <span class="hljs-literal">False</span>

dataset_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{results_org}</span>/details_<span class="hljs-subst">{sanitized_model_name}</span><span class="hljs-subst">{<span class="hljs-string">&#x27;_private&#x27;</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> public_run <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;&#x27;</span>}</span>&quot;</span>
details = load_dataset(dataset_path, task.replace(<span class="hljs-string">&quot;|&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>), split=<span class="hljs-string">&quot;latest&quot;</span>)

<span class="hljs-keyword">for</span> detail <span class="hljs-keyword">in</span> details:
    <span class="hljs-built_in">print</span>(detail)`,wrap:!1}}),X=new T({props:{title:"Example of a result file",local:"example-of-a-result-file",headingTag:"h2"}}),z=new Ts({props:{code:"JTdCJTBBJTIwJTIwJTIyY29uZmlnX2dlbmVyYWwlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJsaWdodGV2YWxfc2hhJTIyJTNBJTIwJTIyMjAzMDQ1YTg0MzFiYzliNzcyNDVjOTk5OGUwNWZjNTQ1MDllYTA3ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm51bV9mZXdzaG90X3NlZWRzJTIyJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCUyMm92ZXJyaWRlX2JhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3NhbXBsZXMlMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIyam9iX2lkJTIyJTNBJTIwJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3RhcnRfdGltZSUyMiUzQSUyMDYyMDk3OS44NzkzMjAxNjYlMkMlMEElMjAlMjAlMjAlMjAlMjJlbmRfdGltZSUyMiUzQSUyMDYyMTAwNC42MzIxMDgwNDElMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3RhbF9ldmFsdWF0aW9uX3RpbWVfc2Vjb25kZXMlMjIlM0ElMjAlMjIyNC43NTI3ODc4NzUwMTE1NjMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJtb2RlbF9uYW1lJTIyJTNBJTIwJTIyZ3B0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm1vZGVsX3NoYSUyMiUzQSUyMCUyMjYwN2EzMGQ3ODNkZmE2NjNjYWYzOWUwNjYzMzcyMWM4ZDRjZmNkN2UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJtb2RlbF9kdHlwZSUyMiUzQSUyMG51bGwlMkMlMEElMjAlMjAlMjAlMjAlMjJtb2RlbF9zaXplJTIyJTNBJTIwJTIyNDc2LjIlMjBNQiUyMiUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMnJlc3VsdHMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJsaWdodGV2YWwlN0Nnc204ayU3QzAlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJxZW0lMjIlM0ElMjAwLjAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJxZW1fc3RkZXJyJTIyJTNBJTIwMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIybWFqJTQwOCUyMiUzQSUyMDAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm1haiU0MDhfc3RkZXJyJTIyJTNBJTIwMC4wJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYWxsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycWVtJTIyJTNBJTIwMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycWVtX3N0ZGVyciUyMiUzQSUyMDAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm1haiU0MDglMjIlM0ElMjAwLjAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJtYWolNDA4X3N0ZGVyciUyMiUzQSUyMDAuMCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMnZlcnNpb25zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIybGlnaHRldmFsJTdDZ3NtOGslN0MwJTIyJTNBJTIwMCUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMmNvbmZpZ190YXNrcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmxpZ2h0ZXZhbCU3Q2dzbThrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdzbThrJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvbXB0X2Z1bmN0aW9uJTIyJTNBJTIwJTIyZ3NtOGslMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJoZl9yZXBvJTIyJTNBJTIwJTIyZ3NtOGslMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJoZl9zdWJzZXQlMjIlM0ElMjAlMjJtYWluJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljX25hbWUlMjIlM0ElMjAlMjJxZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoaWdoZXJfaXNfYmV0dGVyJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNhdGVnb3J5JTIyJTNBJTIwJTIyMyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVzZV9jYXNlJTIyJTNBJTIwJTIyNSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNhbXBsZV9sZXZlbF9mbiUyMiUzQSUyMCUyMmNvbXB1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb3JwdXNfbGV2ZWxfZm4lMjIlM0ElMjAlMjJtZWFuJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljX25hbWUlMjIlM0ElMjAlMjJtYWolNDA4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGlnaGVyX2lzX2JldHRlciUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYXRlZ29yeSUyMiUzQSUyMCUyMjUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfY2FzZSUyMiUzQSUyMCUyMjUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzYW1wbGVfbGV2ZWxfZm4lMjIlM0ElMjAlMjJjb21wdXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29ycHVzX2xldmVsX2ZuJTIyJTNBJTIwJTIybWVhbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmhmX2F2YWlsX3NwbGl0cyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYWluJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGVzdCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmV2YWx1YXRpb25fc3BsaXRzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGVzdCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmZld19zaG90c19zcGxpdCUyMiUzQSUyMG51bGwlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmZXdfc2hvdHNfc2VsZWN0JTIyJTNBJTIwJTIycmFuZG9tX3NhbXBsaW5nX2Zyb21fdHJhaW4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJnZW5lcmF0aW9uX3NpemUlMjIlM0ElMjAyNTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJnZW5lcmF0aW9uX2dyYW1tYXIlMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RvcF9zZXF1ZW5jZSUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlF1ZXN0aW9uJTNEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIybnVtX3NhbXBsZXMlMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3VpdGUlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsaWdodGV2YWwlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJvcmlnaW5hbF9udW1fZG9jcyUyMiUzQSUyMDEzMTklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJlZmZlY3RpdmVfbnVtX2RvY3MlMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHJ1c3RfZGF0YXNldCUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJtdXN0X3JlbW92ZV9kdXBsaWNhdGVfZG9jcyUyMiUzQSUyMG51bGwlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ2ZXJzaW9uJTIyJTNBJTIwMCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMnN1bW1hcnlfdGFza3MlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJsaWdodGV2YWwlN0Nnc204ayU3QzAlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJoYXNoZXMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoYXNoX2V4YW1wbGVzJTIyJTNBJTIwJTIyODUxN2Q1YmY3ZTg4MDA4NiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhhc2hfZnVsbF9wcm9tcHRzJTIyJTNBJTIwJTIyODUxN2Q1YmY3ZTg4MDA4NiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhhc2hfaW5wdXRfdG9rZW5zJTIyJTNBJTIwJTIyMjk5MTZlN2FmZTVjYjUxZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhhc2hfY29udF90b2tlbnMlMjIlM0ElMjAlMjIzN2Y5MWNlMjNlZjZkNDM1JTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHJ1bmNhdGVkJTIyJTNBJTIwMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5vbl90cnVuY2F0ZWQlMjIlM0ElMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFkZGVkJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5vbl9wYWRkZWQlMjIlM0ElMjAyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWZmZWN0aXZlX2Zld19zaG90cyUyMiUzQSUyMDAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm51bV90cnVuY2F0ZWRfZmV3X3Nob3RzJTIyJTNBJTIwMCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMnN1bW1hcnlfZ2VuZXJhbCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmhhc2hlcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmhhc2hfZXhhbXBsZXMlMjIlM0ElMjAlMjI1ZjM4M2MzOTVmMDEwOTZlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGFzaF9mdWxsX3Byb21wdHMlMjIlM0ElMjAlMjI1ZjM4M2MzOTVmMDEwOTZlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGFzaF9pbnB1dF90b2tlbnMlMjIlM0ElMjAlMjJhYzkzM2ZlYjE0Zjk2ZDdiJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGFzaF9jb250X3Rva2VucyUyMiUzQSUyMCUyMjlkMDNmYjI2ZjhkYTcyNzclMjIlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cnVuY2F0ZWQlMjIlM0ElMjAyJTJDJTBBJTIwJTIwJTIwJTIwJTIybm9uX3RydW5jYXRlZCUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJwYWRkZWQlMjIlM0ElMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIybm9uX3BhZGRlZCUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1fdHJ1bmNhdGVkX2Zld19zaG90cyUyMiUzQSUyMDAlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;config_general&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval_sha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;203045a8431bc9b77245c9998e05fc54509ea07f&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_fewshot_seeds&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;override_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;max_samples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;job_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;start_time&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">620979.879320166</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;end_time&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">621004.632108041</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;total_evaluation_time_secondes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;24.752787875011563&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gpt2&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_sha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;607a30d783dfa663caf39e06633721c8d4cfcd7e&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_dtype&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;476.2 MB&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;results&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;qem&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;qem_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;all&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;qem&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;qem_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;versions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;config_tasks&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;prompt_function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_repo&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_subset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;main&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;metric&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;metric_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;qem&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;higher_is_better&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;category&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;3&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;use_case&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;sample_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;compute&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;corpus_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mean&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;metric_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;maj@8&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;higher_is_better&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;category&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;use_case&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;sample_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;compute&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;corpus_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mean&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_avail_splits&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;train&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-string">&quot;test&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;evaluation_splits&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;test&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;few_shots_split&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;few_shots_select&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;random_sampling_from_train&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;generation_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">256</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;generation_grammar&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;stop_sequence&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;Question=&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;num_samples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;suite&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;lighteval&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;original_num_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1319</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;effective_num_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;trust_dataset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;must_remove_duplicate_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;summary_tasks&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;hashes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;hash_examples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;8517d5bf7e880086&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_full_prompts&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;8517d5bf7e880086&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_input_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;29916e7afe5cb51d&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_cont_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;37f91ce23ef6d435&quot;</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;truncated&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;non_truncated&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;non_padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;effective_few_shots&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;num_truncated_few_shots&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;summary_general&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;hashes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;hash_examples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5f383c395f01096e&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_full_prompts&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5f383c395f01096e&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_input_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;ac933feb14f96d7b&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_cont_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;9d03fb26f8da7277&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;truncated&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;non_truncated&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;non_padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_truncated_few_shots&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),$=new Gs({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/saving-and-reading-results.mdx"}}),{c(){J=i("meta"),R=n(),v=i("p"),Y=n(),u(U.$$.fragment),F=n(),u(r.$$.fragment),V=n(),w=i("p"),w.innerHTML=rs,x=n(),d=i("p"),d.innerHTML=ws,H=n(),I=i("p"),I.innerHTML=ds,D=n(),u(m.$$.fragment),L=n(),C=i("p"),C.innerHTML=Is,P=n(),u(q.$$.fragment),O=n(),A=i("p"),A.innerHTML=ms,K=n(),u(f.$$.fragment),ss=n(),b=i("p"),b.innerHTML=Cs,as=n(),g=i("p"),g.textContent=qs,ls=n(),u(_.$$.fragment),ts=n(),Z=i("p"),Z.innerHTML=As,ns=n(),u(N.$$.fragment),ps=n(),u(B.$$.fragment),us=n(),u(Q.$$.fragment),es=n(),u(E.$$.fragment),Ms=n(),u(W.$$.fragment),cs=n(),k=i("p"),k.textContent=fs,os=n(),G=i("ul"),G.innerHTML=bs,js=n(),u(X.$$.fragment),is=n(),u(z.$$.fragment),hs=n(),u($.$$.fragment),ys=n(),S=i("p"),this.h()},l(s){const a=Ws("svelte-u9bgzb",document.head);J=h(a,"META",{name:!0,content:!0}),a.forEach(l),R=p(s),v=h(s,"P",{}),gs(v).forEach(l),Y=p(s),e(U.$$.fragment,s),F=p(s),e(r.$$.fragment,s),V=p(s),w=h(s,"P",{"data-svelte-h":!0}),y(w)!=="svelte-15vw0ij"&&(w.innerHTML=rs),x=p(s),d=h(s,"P",{"data-svelte-h":!0}),y(d)!=="svelte-8c212v"&&(d.innerHTML=ws),H=p(s),I=h(s,"P",{"data-svelte-h":!0}),y(I)!=="svelte-1kiwdut"&&(I.innerHTML=ds),D=p(s),e(m.$$.fragment,s),L=p(s),C=h(s,"P",{"data-svelte-h":!0}),y(C)!=="svelte-sznccd"&&(C.innerHTML=Is),P=p(s),e(q.$$.fragment,s),O=p(s),A=h(s,"P",{"data-svelte-h":!0}),y(A)!=="svelte-1cbg3hm"&&(A.innerHTML=ms),K=p(s),e(f.$$.fragment,s),ss=p(s),b=h(s,"P",{"data-svelte-h":!0}),y(b)!=="svelte-q3l9c9"&&(b.innerHTML=Cs),as=p(s),g=h(s,"P",{"data-svelte-h":!0}),y(g)!=="svelte-lvtunn"&&(g.textContent=qs),ls=p(s),e(_.$$.fragment,s),ts=p(s),Z=h(s,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-somvse"&&(Z.innerHTML=As),ns=p(s),e(N.$$.fragment,s),ps=p(s),e(B.$$.fragment,s),us=p(s),e(Q.$$.fragment,s),es=p(s),e(E.$$.fragment,s),Ms=p(s),e(W.$$.fragment,s),cs=p(s),k=h(s,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1w33ibm"&&(k.textContent=fs),os=p(s),G=h(s,"UL",{"data-svelte-h":!0}),y(G)!=="svelte-6ruscb"&&(G.innerHTML=bs),js=p(s),e(X.$$.fragment,s),is=p(s),e(z.$$.fragment,s),hs=p(s),e($.$$.fragment,s),ys=p(s),S=h(s,"P",{}),gs(S).forEach(l),this.h()},h(){_s(J,"name","hf:doc:metadata"),_s(J,"content",zs)},m(s,a){ks(document.head,J),t(s,R,a),t(s,v,a),t(s,Y,a),M(U,s,a),t(s,F,a),M(r,s,a),t(s,V,a),t(s,w,a),t(s,x,a),t(s,d,a),t(s,H,a),t(s,I,a),t(s,D,a),M(m,s,a),t(s,L,a),t(s,C,a),t(s,P,a),M(q,s,a),t(s,O,a),t(s,A,a),t(s,K,a),M(f,s,a),t(s,ss,a),t(s,b,a),t(s,as,a),t(s,g,a),t(s,ls,a),M(_,s,a),t(s,ts,a),t(s,Z,a),t(s,ns,a),M(N,s,a),t(s,ps,a),M(B,s,a),t(s,us,a),M(Q,s,a),t(s,es,a),M(E,s,a),t(s,Ms,a),M(W,s,a),t(s,cs,a),t(s,k,a),t(s,os,a),t(s,G,a),t(s,js,a),M(X,s,a),t(s,is,a),M(z,s,a),t(s,hs,a),M($,s,a),t(s,ys,a),t(s,S,a),Js=!0},p:Ns,i(s){Js||(c(U.$$.fragment,s),c(r.$$.fragment,s),c(m.$$.fragment,s),c(q.$$.fragment,s),c(f.$$.fragment,s),c(_.$$.fragment,s),c(N.$$.fragment,s),c(B.$$.fragment,s),c(Q.$$.fragment,s),c(E.$$.fragment,s),c(W.$$.fragment,s),c(X.$$.fragment,s),c(z.$$.fragment,s),c($.$$.fragment,s),Js=!0)},o(s){o(U.$$.fragment,s),o(r.$$.fragment,s),o(m.$$.fragment,s),o(q.$$.fragment,s),o(f.$$.fragment,s),o(_.$$.fragment,s),o(N.$$.fragment,s),o(B.$$.fragment,s),o(Q.$$.fragment,s),o(E.$$.fragment,s),o(W.$$.fragment,s),o(X.$$.fragment,s),o(z.$$.fragment,s),o($.$$.fragment,s),Js=!1},d(s){s&&(l(R),l(v),l(Y),l(F),l(V),l(w),l(x),l(d),l(H),l(I),l(D),l(L),l(C),l(P),l(O),l(A),l(K),l(ss),l(b),l(as),l(g),l(ls),l(ts),l(Z),l(ns),l(ps),l(us),l(es),l(Ms),l(cs),l(k),l(os),l(G),l(js),l(is),l(hs),l(ys),l(S)),l(J),j(U,s),j(r,s),j(m,s),j(q,s),j(f,s),j(_,s),j(N,s),j(B,s),j(Q,s),j(E,s),j(W,s),j(X,s),j(z,s),j($,s)}}}const zs='{"title":"Saving and reading results","local":"saving-and-reading-results","sections":[{"title":"Saving results locally","local":"saving-results-locally","sections":[],"depth":2},{"title":"Pushing results to the HuggingFace hub","local":"pushing-results-to-the-huggingface-hub","sections":[],"depth":2},{"title":"Pushing results to Tensorboard","local":"pushing-results-to-tensorboard","sections":[],"depth":2},{"title":"Pushing results to WandB","local":"pushing-results-to-wandb","sections":[],"depth":2},{"title":"How to load and investigate details","local":"how-to-load-and-investigate-details","sections":[{"title":"Load from local detail files","local":"load-from-local-detail-files","sections":[],"depth":3},{"title":"Load from the HuggingFace hub","local":"load-from-the-huggingface-hub","sections":[],"depth":3}],"depth":2},{"title":"Example of a result file","local":"example-of-a-result-file","sections":[],"depth":2}],"depth":1}';function $s(Us){return Bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fs extends Qs{constructor(J){super(),Es(this,J,$s,Xs,Zs,{})}}export{Fs as component};
