import{s as it,n as pt,o as mt}from"../chunks/scheduler.9bc65507.js";import{S as ct,i as ut,g as o,s as n,r as p,A as ft,h as r,f as l,c as a,j as ot,u as m,x as i,k as rt,y as dt,a as s,v as c,d as u,t as f,w as d}from"../chunks/index.707bf1b6.js";import{C as T}from"../chunks/CodeBlock.54a9f38d.js";import{D as Mt}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as ee}from"../chunks/Heading.342b1fa6.js";function Tt(Be){let M,te,K,le,w,se,y,ne,J,ze='加速線形代数（Accelerated Linear Algebra）、通称XLAは、TensorFlowモデルのランタイムを高速化するためのコンパイラです。<a href="https://www.tensorflow.org/xla" rel="nofollow">公式ドキュメント</a>によれば、XLA（Accelerated Linear Algebra）は線形代数のためのドメイン固有のコンパイラで、TensorFlowモデルを潜在的にソースコードの変更なしで高速化できます。',ae,b,Le='TensorFlowでXLAを使用するのは簡単です。XLAは<code>tensorflow</code>ライブラリ内にパッケージ化されており、<a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow"><code>tf.function</code></a>などのグラフを作成する関数内で<code>jit_compile</code>引数を使用してトリガーできます。<code>fit()</code>や<code>predict()</code>などのKerasメソッドを使用する場合、<code>model.compile()</code>に<code>jit_compile</code>引数を渡すだけでXLAを有効にできます。ただし、XLAはこれらのメソッドに限定されているわけではありません。任意の<code>tf.function</code>を高速化するためにも使用できます。',oe,h,Ee='🤗 Transformers内のいくつかのTensorFlowメソッドは、XLAと互換性があるように書き直されています。これには、<a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>、<a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>、<a href="https://huggingface.co/docs/transformers/model_doc/opt" rel="nofollow">OPT</a>などのテキスト生成モデルや、<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>などの音声処理モデルも含まれます。',re,g,Ye="速度向上の具体的な量はモデルに非常に依存しますが、🤗 Transformers内のTensorFlowテキスト生成モデルでは、約100倍の速度向上を確認しています。このドキュメントでは、これらのモデルにXLAを使用して最大のパフォーマンスを得る方法を説明します。また、ベンチマークとXLA統合のデザイン哲学について詳しく学びたい場合の追加リソースへのリンクも提供します。",ie,U,pe,j,He="以下のTensorFlowモデルを考えてみましょう：",me,Z,ce,_,Ne="上記のモデルは、次元が<code>(10, )</code>の入力を受け入れます。このモデルをフォワードパスで実行するには、次のようにします：",ue,X,fe,k,Ae="XLAでコンパイルされた関数を使用してフォワードパスを実行するには、以下のようにします：",de,G,Me,R,Qe="<code>model</code>のデフォルトの <code>call()</code> 関数はXLAグラフをコンパイルするために使用されます。ただし、XLAにコンパイルしたい他のモデル関数がある場合、それも可能です。以下はその方法です：",Te,I,we,W,ye,V,qe="🤗 Transformers内でXLAでの高速化された生成を有効にするには、最新バージョンの<code>transformers</code>がインストールされている必要があります。次のコマンドを実行してインストールできます：",Je,F,be,$,Se="次に、次のコードを実行できます：",he,x,ge,C,Pe="<code>generate()</code>でXLAを有効にするのは、たった一行のコードです。コードの残り部分は変更されていません。ただし、XLA固有のいくつかの注意点が上記のコードスニペットにあります。これらに注意する必要があり、XLAがもたらす速度向上を実現するためにそれらを把握することが重要です。次のセクションでこれらについて詳しく説明します。",Ue,v,je,B,De='XLAを有効にした関数（上記の<code>xla_generate()</code>など）を初めて実行すると、内部で計算グラフを推論しようとしますが、これは時間がかかります。このプロセスは<a href="https://www.tensorflow.org/guide/intro_to_graphs#when_is_a_function_tracing" rel="nofollow">“トレーシング”（tracing）</a>として知られています。',Ze,z,Ke="生成時間が高速ではないことに気付くかもしれません。<code>xla_generate()</code>（または他のXLA対応関数）の連続呼び出しでは、関数への入力が最初に計算グラフが構築されたときと同じ形状に従っている場合、計算グラフを推論する必要はありません。これは、入力形状が固定されているモダリティ（例：画像）には問題ありませんが、変数の入力形状モダリティ（例：テキスト）を扱う場合には注意が必要です。",_e,L,Oe="<code>xla_generate()</code>が常に同じ入力形状で動作するようにするには、トークナイザを呼び出す際に<code>padding</code>引数を指定できます。",Xe,E,ke,Y,et="これにより、<code>xla_generate()</code>への入力が常にトレースされた形状の入力を受け取ることを確認し、生成時間の高速化を実現できます。以下のコードでこれを確認できます：",Ge,H,Re,N,tt="Tesla T4 GPUを使用すると、次のような出力が期待されます：",Ie,A,We,Q,lt="最初の<code>xla_generate()</code>呼び出しはトレーシングのために時間がかかりますが、連続する呼び出しは桁違いに高速です。生成オプションのいかなる変更も、再トレーシングを引き起こし、生成時間の遅延を引き起こすことに注意してください。",Ve,q,st="このドキュメントでは、🤗 Transformersが提供するテキスト生成オプションをすべて網羅していません。高度なユースケースについてはドキュメンテーションを参照することをお勧めします。",Fe,S,$e,P,nt="ここでは、🤗 Transformersと一般的なXLAについてさらに詳しく学びたい場合のいくつかの追加リソースを提供します。",xe,D,at='<li><a href="https://colab.research.google.com/github/huggingface/blog/blob/main/notebooks/91_tf_xla_generate.ipynb" rel="nofollow">このColab Notebook</a>では、XLA対応のエンコーダーデコーダー（<a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>など）およびデコーダー専用（<a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>など）テキスト生成モデルを試すための対話型デモが提供されています。</li> <li><a href="https://huggingface.co/blog/tf-xla-generate" rel="nofollow">このブログ記事</a>では、XLA対応モデルの比較ベンチマークの概要と、TensorFlowでのXLAについての友好的な紹介が提供されています。</li> <li><a href="https://blog.tensorflow.org/2022/11/how-hugging-face-improved-text-generation-performance-with-xla.html" rel="nofollow">このブログ記事</a>では、🤗 TransformersのTensorFlowモデルにXLAサポートを追加する際の設計哲学について説明しています。</li> <li>一般的なXLAとTensorFlowグラフについて詳しく学ぶためのおすすめの投稿：<ul><li><a href="https://www.tensorflow.org/xla" rel="nofollow">XLA: 機械学習用の最適化コンパイラ</a></li> <li><a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow">グラフと<code>tf.function</code>の紹介</a></li> <li><a href="https://www.tensorflow.org/guide/function" rel="nofollow"><code>tf.function</code>を使用したパフォーマンス向上</a></li></ul></li>',Ce,O,ve;return w=new ee({props:{title:"XLA Integration for TensorFlow Models",local:"xla-integration-for-tensorflow-models",headingTag:"h1"}}),y=new Mt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tf_xla.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/tf_xla.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tf_xla.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/tf_xla.ipynb"}]}}),U=new ee({props:{title:"Running TF functions with XLA",local:"running-tf-functions-with-xla",headingTag:"h2"}}),Z=new T({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFtb2RlbCUyMCUzRCUyMHRmLmtlcmFzLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTVCdGYua2VyYXMubGF5ZXJzLkRlbnNlKDEwJTJDJTIwaW5wdXRfc2hhcGUlM0QoMTAlMkMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTIwdGYua2VyYXMubGF5ZXJzLkRlbnNlKDUlMkMlMjBhY3RpdmF0aW9uJTNEJTIyc29mdG1heCUyMiklNUQlMEEp",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

model = tf.keras.Sequential(
    [tf.keras.layers.Dense(<span class="hljs-number">10</span>, input_shape=(<span class="hljs-number">10</span>,), activation=<span class="hljs-string">&quot;relu&quot;</span>), tf.keras.layers.Dense(<span class="hljs-number">5</span>, activation=<span class="hljs-string">&quot;softmax&quot;</span>)]
)`,wrap:!1}}),X=new T({props:{code:"JTIzJTIwR2VuZXJhdGUlMjByYW5kb20lMjBpbnB1dHMlMjBmb3IlMjB0aGUlMjBtb2RlbC4lMEFiYXRjaF9zaXplJTIwJTNEJTIwMTYlMEFpbnB1dF92ZWN0b3JfZGltJTIwJTNEJTIwMTAlMEFyYW5kb21faW5wdXRzJTIwJTNEJTIwdGYucmFuZG9tLm5vcm1hbCgoYmF0Y2hfc2l6ZSUyQyUyMGlucHV0X3ZlY3Rvcl9kaW0pKSUwQSUwQSUyMyUyMFJ1biUyMGElMjBmb3J3YXJkJTIwcGFzcy4lMEFfJTIwJTNEJTIwbW9kZWwocmFuZG9tX2lucHV0cyk=",highlighted:`<span class="hljs-comment"># Generate random inputs for the model.</span>
batch_size = <span class="hljs-number">16</span>
input_vector_dim = <span class="hljs-number">10</span>
random_inputs = tf.random.normal((batch_size, input_vector_dim))

<span class="hljs-comment"># Run a forward pass.</span>
_ = model(random_inputs)`,wrap:!1}}),G=new T({props:{code:"eGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBXyUyMCUzRCUyMHhsYV9mbihyYW5kb21faW5wdXRzKQ==",highlighted:`xla_fn = tf.function(model, jit_compile=<span class="hljs-literal">True</span>)
_ = xla_fn(random_inputs)`,wrap:!1}}),I=new T({props:{code:"bXlfeGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwubXlfeGxhX2ZuJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKQ==",highlighted:'my_xla_fn = tf.function(model.my_xla_fn, jit_compile=<span class="hljs-literal">True</span>)',wrap:!1}}),W=new ee({props:{title:"Running a TF text generation model with XLA from 🤗 Transformers",local:"running-a-tf-text-generation-model-with-xla-from--transformers",headingTag:"h2"}}),F=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMC0tdXBncmFkZQ==",highlighted:"pip install transformers --upgrade",wrap:!1}}),x=new T({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBXaWxsJTIwZXJyb3IlMjBpZiUyMHRoZSUyMG1pbmltYWwlMjB2ZXJzaW9uJTIwb2YlMjBUcmFuc2Zvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZC4lMEFmcm9tJTIwdHJhbnNmb3JtZXJzLnV0aWxzJTIwaW1wb3J0JTIwY2hlY2tfbWluX3ZlcnNpb24lMEElMEFjaGVja19taW5fdmVyc2lvbiglMjI0LjIxLjAlMjIpJTBBJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0X3N0cmluZyUyMCUzRCUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiU1RCUwQSUwQSUyMyUyME9uZSUyMGxpbmUlMjB0byUyMGNyZWF0ZSUyMGFuJTIwWExBJTIwZ2VuZXJhdGlvbiUyMGZ1bmN0aW9uJTBBeGxhX2dlbmVyYXRlJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwuZ2VuZXJhdGUlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBJTBBdG9rZW5pemVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cmluZyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBJTBBZGVjb2RlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjAtLSUyMCU3QmRlY29kZWRfdGV4dCU3RCUyMiklMEElMjMlMjBHZW5lcmF0ZWQlMjAtLSUyMFRlbnNvckZsb3clMjBpcyUyMGFuJTIwb3Blbi1zb3VyY2UlMkMlMjBvcGVuLXNvdXJjZSUyQyUyMGRpc3RyaWJ1dGVkLXNvdXJjZSUyMGFwcGxpY2F0aW9uJTIwJTIzJTIwZnJhbWV3b3JrJTIwZm9yJTIwdGhl",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

<span class="hljs-comment"># Will error if the minimal version of Transformers is not installed.</span>
<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> check_min_version

check_min_version(<span class="hljs-string">&quot;4.21.0&quot;</span>)


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

<span class="hljs-comment"># One line to create an XLA generation function</span>
xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

tokenized_input = tokenizer(input_string, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)

decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)
<span class="hljs-comment"># Generated -- TensorFlow is an open-source, open-source, distributed-source application # framework for the</span>`,wrap:!1}}),v=new ee({props:{title:"Gotchas to be aware of",local:"gotchas-to-be-aware-of",headingTag:"h2"}}),E=new T({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBaW5wdXRfc3RyaW5nJTIwJTNEJTIwJTVCJTIyVGVuc29yRmxvdyUyMGlzJTIyJTVEJTBBJTBBeGxhX2dlbmVyYXRlJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwuZ2VuZXJhdGUlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBJTBBJTIzJTIwSGVyZSUyQyUyMHdlJTIwY2FsbCUyMHRoZSUyMHRva2VuaXplciUyMHdpdGglMjBwYWRkaW5nJTIwb3B0aW9ucy4lMEF0b2tlbml6ZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfc3RyaW5nJTJDJTIwcGFkX3RvX211bHRpcGxlX29mJTNEOCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMEFnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIweGxhX2dlbmVyYXRlKCoqdG9rZW5pemVkX2lucHV0JTJDJTIwbnVtX2JlYW1zJTNEMiklMEFkZWNvZGVkX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZiUyMkdlbmVyYXRlZCUyMC0tJTIwJTdCZGVjb2RlZF90ZXh0JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Here, we call the tokenizer with padding options.</span>
tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)`,wrap:!1}}),H=new T({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQSUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQWZvciUyMGlucHV0X3N0cmluZyUyMGluJTIwJTVCJTIyVGVuc29yRmxvdyUyMGlzJTIyJTJDJTIwJTIyVGVuc29yRmxvdyUyMGlzJTIwYSUyMiUyQyUyMCUyMlRGTGl0ZSUyMGlzJTIwYSUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplcihpbnB1dF9zdHJpbmclMkMlMjBwYWRfdG9fbXVsdGlwbGVfb2YlM0Q4JTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQSUyMCUyMCUyMCUyMHN0YXJ0JTIwJTNEJTIwdGltZS50aW1lX25zKCklMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIweGxhX2dlbmVyYXRlKCoqdG9rZW5pemVkX2lucHV0JTJDJTIwbnVtX2JlYW1zJTNEMiklMEElMjAlMjAlMjAlMjBlbmQlMjAlM0QlMjB0aW1lLnRpbWVfbnMoKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJFeGVjdXRpb24lMjB0aW1lJTIwLS0lMjAlN0IoZW5kJTIwLSUyMHN0YXJ0KSUyMCUyRiUyMDFlNiUzQS4xZiU3RCUyMG1zJTVDbiUyMik=",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">for</span> input_string <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;TensorFlow is&quot;</span>, <span class="hljs-string">&quot;TensorFlow is a&quot;</span>, <span class="hljs-string">&quot;TFLite is a&quot;</span>]:
    tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
    start = time.time_ns()
    generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
    end = time.time_ns()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Execution time -- <span class="hljs-subst">{(end - start) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span> ms\\n&quot;</span>)`,wrap:!1}}),A=new T({props:{code:"RXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwMzA4MTkuNiUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzkuMCUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzguOSUyMG1z",highlighted:`Execution time -- 30819.6 ms

Execution time -- 79.0 ms

Execution time -- 78.9 ms`,wrap:!1}}),S=new ee({props:{title:"Additional Resources",local:"additional-resources",headingTag:"h2"}}),{c(){M=o("meta"),te=n(),K=o("p"),le=n(),p(w.$$.fragment),se=n(),p(y.$$.fragment),ne=n(),J=o("p"),J.innerHTML=ze,ae=n(),b=o("p"),b.innerHTML=Le,oe=n(),h=o("p"),h.innerHTML=Ee,re=n(),g=o("p"),g.textContent=Ye,ie=n(),p(U.$$.fragment),pe=n(),j=o("p"),j.textContent=He,me=n(),p(Z.$$.fragment),ce=n(),_=o("p"),_.innerHTML=Ne,ue=n(),p(X.$$.fragment),fe=n(),k=o("p"),k.textContent=Ae,de=n(),p(G.$$.fragment),Me=n(),R=o("p"),R.innerHTML=Qe,Te=n(),p(I.$$.fragment),we=n(),p(W.$$.fragment),ye=n(),V=o("p"),V.innerHTML=qe,Je=n(),p(F.$$.fragment),be=n(),$=o("p"),$.textContent=Se,he=n(),p(x.$$.fragment),ge=n(),C=o("p"),C.innerHTML=Pe,Ue=n(),p(v.$$.fragment),je=n(),B=o("p"),B.innerHTML=De,Ze=n(),z=o("p"),z.innerHTML=Ke,_e=n(),L=o("p"),L.innerHTML=Oe,Xe=n(),p(E.$$.fragment),ke=n(),Y=o("p"),Y.innerHTML=et,Ge=n(),p(H.$$.fragment),Re=n(),N=o("p"),N.textContent=tt,Ie=n(),p(A.$$.fragment),We=n(),Q=o("p"),Q.innerHTML=lt,Ve=n(),q=o("p"),q.textContent=st,Fe=n(),p(S.$$.fragment),$e=n(),P=o("p"),P.textContent=nt,xe=n(),D=o("ul"),D.innerHTML=at,Ce=n(),O=o("p"),this.h()},l(e){const t=ft("svelte-u9bgzb",document.head);M=r(t,"META",{name:!0,content:!0}),t.forEach(l),te=a(e),K=r(e,"P",{}),ot(K).forEach(l),le=a(e),m(w.$$.fragment,e),se=a(e),m(y.$$.fragment,e),ne=a(e),J=r(e,"P",{"data-svelte-h":!0}),i(J)!=="svelte-zzdk25"&&(J.innerHTML=ze),ae=a(e),b=r(e,"P",{"data-svelte-h":!0}),i(b)!=="svelte-17c4ps"&&(b.innerHTML=Le),oe=a(e),h=r(e,"P",{"data-svelte-h":!0}),i(h)!=="svelte-jmz72m"&&(h.innerHTML=Ee),re=a(e),g=r(e,"P",{"data-svelte-h":!0}),i(g)!=="svelte-163nszz"&&(g.textContent=Ye),ie=a(e),m(U.$$.fragment,e),pe=a(e),j=r(e,"P",{"data-svelte-h":!0}),i(j)!=="svelte-i2jpr9"&&(j.textContent=He),me=a(e),m(Z.$$.fragment,e),ce=a(e),_=r(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-xhjq9d"&&(_.innerHTML=Ne),ue=a(e),m(X.$$.fragment,e),fe=a(e),k=r(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1xlk5bx"&&(k.textContent=Ae),de=a(e),m(G.$$.fragment,e),Me=a(e),R=r(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-bfwqnu"&&(R.innerHTML=Qe),Te=a(e),m(I.$$.fragment,e),we=a(e),m(W.$$.fragment,e),ye=a(e),V=r(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1rj7w64"&&(V.innerHTML=qe),Je=a(e),m(F.$$.fragment,e),be=a(e),$=r(e,"P",{"data-svelte-h":!0}),i($)!=="svelte-kzcg3w"&&($.textContent=Se),he=a(e),m(x.$$.fragment,e),ge=a(e),C=r(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1gq39rt"&&(C.innerHTML=Pe),Ue=a(e),m(v.$$.fragment,e),je=a(e),B=r(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1u18xwm"&&(B.innerHTML=De),Ze=a(e),z=r(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-vj7dap"&&(z.innerHTML=Ke),_e=a(e),L=r(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-10cmu1q"&&(L.innerHTML=Oe),Xe=a(e),m(E.$$.fragment,e),ke=a(e),Y=r(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-q4vr22"&&(Y.innerHTML=et),Ge=a(e),m(H.$$.fragment,e),Re=a(e),N=r(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1pv1wyj"&&(N.textContent=tt),Ie=a(e),m(A.$$.fragment,e),We=a(e),Q=r(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1ja7r83"&&(Q.innerHTML=lt),Ve=a(e),q=r(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-xpg5d5"&&(q.textContent=st),Fe=a(e),m(S.$$.fragment,e),$e=a(e),P=r(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-ctf09q"&&(P.textContent=nt),xe=a(e),D=r(e,"UL",{"data-svelte-h":!0}),i(D)!=="svelte-ycl3uy"&&(D.innerHTML=at),Ce=a(e),O=r(e,"P",{}),ot(O).forEach(l),this.h()},h(){rt(M,"name","hf:doc:metadata"),rt(M,"content",wt)},m(e,t){dt(document.head,M),s(e,te,t),s(e,K,t),s(e,le,t),c(w,e,t),s(e,se,t),c(y,e,t),s(e,ne,t),s(e,J,t),s(e,ae,t),s(e,b,t),s(e,oe,t),s(e,h,t),s(e,re,t),s(e,g,t),s(e,ie,t),c(U,e,t),s(e,pe,t),s(e,j,t),s(e,me,t),c(Z,e,t),s(e,ce,t),s(e,_,t),s(e,ue,t),c(X,e,t),s(e,fe,t),s(e,k,t),s(e,de,t),c(G,e,t),s(e,Me,t),s(e,R,t),s(e,Te,t),c(I,e,t),s(e,we,t),c(W,e,t),s(e,ye,t),s(e,V,t),s(e,Je,t),c(F,e,t),s(e,be,t),s(e,$,t),s(e,he,t),c(x,e,t),s(e,ge,t),s(e,C,t),s(e,Ue,t),c(v,e,t),s(e,je,t),s(e,B,t),s(e,Ze,t),s(e,z,t),s(e,_e,t),s(e,L,t),s(e,Xe,t),c(E,e,t),s(e,ke,t),s(e,Y,t),s(e,Ge,t),c(H,e,t),s(e,Re,t),s(e,N,t),s(e,Ie,t),c(A,e,t),s(e,We,t),s(e,Q,t),s(e,Ve,t),s(e,q,t),s(e,Fe,t),c(S,e,t),s(e,$e,t),s(e,P,t),s(e,xe,t),s(e,D,t),s(e,Ce,t),s(e,O,t),ve=!0},p:pt,i(e){ve||(u(w.$$.fragment,e),u(y.$$.fragment,e),u(U.$$.fragment,e),u(Z.$$.fragment,e),u(X.$$.fragment,e),u(G.$$.fragment,e),u(I.$$.fragment,e),u(W.$$.fragment,e),u(F.$$.fragment,e),u(x.$$.fragment,e),u(v.$$.fragment,e),u(E.$$.fragment,e),u(H.$$.fragment,e),u(A.$$.fragment,e),u(S.$$.fragment,e),ve=!0)},o(e){f(w.$$.fragment,e),f(y.$$.fragment,e),f(U.$$.fragment,e),f(Z.$$.fragment,e),f(X.$$.fragment,e),f(G.$$.fragment,e),f(I.$$.fragment,e),f(W.$$.fragment,e),f(F.$$.fragment,e),f(x.$$.fragment,e),f(v.$$.fragment,e),f(E.$$.fragment,e),f(H.$$.fragment,e),f(A.$$.fragment,e),f(S.$$.fragment,e),ve=!1},d(e){e&&(l(te),l(K),l(le),l(se),l(ne),l(J),l(ae),l(b),l(oe),l(h),l(re),l(g),l(ie),l(pe),l(j),l(me),l(ce),l(_),l(ue),l(fe),l(k),l(de),l(Me),l(R),l(Te),l(we),l(ye),l(V),l(Je),l(be),l($),l(he),l(ge),l(C),l(Ue),l(je),l(B),l(Ze),l(z),l(_e),l(L),l(Xe),l(ke),l(Y),l(Ge),l(Re),l(N),l(Ie),l(We),l(Q),l(Ve),l(q),l(Fe),l($e),l(P),l(xe),l(D),l(Ce),l(O)),l(M),d(w,e),d(y,e),d(U,e),d(Z,e),d(X,e),d(G,e),d(I,e),d(W,e),d(F,e),d(x,e),d(v,e),d(E,e),d(H,e),d(A,e),d(S,e)}}}const wt='{"title":"XLA Integration for TensorFlow Models","local":"xla-integration-for-tensorflow-models","sections":[{"title":"Running TF functions with XLA","local":"running-tf-functions-with-xla","sections":[],"depth":2},{"title":"Running a TF text generation model with XLA from 🤗 Transformers","local":"running-a-tf-text-generation-model-with-xla-from--transformers","sections":[],"depth":2},{"title":"Gotchas to be aware of","local":"gotchas-to-be-aware-of","sections":[],"depth":2},{"title":"Additional Resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function yt(Be){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends ct{constructor(M){super(),ut(this,M,yt,Tt,it,{})}}export{jt as component};
