import{s as ns,n as ms,o as fs}from"../chunks/scheduler.b108d059.js";import{S as ps,i as hs,g as o,s as d,r as m,A as cs,h as i,f as l,c as a,j as n,u as f,x as s,k as u,y as Ts,a as r,v as p,d as h,t as c,w as T}from"../chunks/index.008de539.js";import{H as y,E as ys}from"../chunks/EditOnGithub.d1c48e3d.js";function vs($o){let v,Tl,hl,yl,_,vl,F,_l,b,Po="Helper module for mathematical processing.",Fl,x,Ao=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,bl,$,Co='<li><a href="#module_utils/maths">utils/maths</a><ul><li><em>static</em><ul><li><a href="#module_utils/maths.interpolate_data"><code>.interpolate_data(input)</code></a></li> <li><a href="#module_utils/maths.permute_data"><code>.permute_data(array, dims, axes)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.softmax"><code>.softmax(arr)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/maths.log_softmax"><code>.log_softmax(arr)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/maths.dot"><code>.dot(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.getTopItems"><code>.getTopItems(items, [top_k])</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.cos_sim"><code>.cos_sim(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.magnitude"><code>.magnitude(arr)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.min"><code>.min(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.max"><code>.max(arr)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.medianFilter"><code>.medianFilter(data, windowSize)</code></a></li> <li><a href="#module_utils/maths.round"><code>.round(num, decimals)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.bankers_round"><code>.bankers_round(x)</code></a> ⇒ <code>number</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li> <li><a href="#module_utils/maths..NP2FFT">~NP2FFT</a><ul><li><a href="#new_module_utils/maths..NP2FFT_new"><code>new NP2FFT(fft_length)</code></a></li></ul></li> <li><a href="#module_utils/maths..AnyTypedArray"><code>~AnyTypedArray</code></a> : <code>Int8Array</code> | <code>Uint8Array</code> | <code>Uint8ClampedArray</code> | <code>Int16Array</code> | <code>Uint16Array</code> | <code>Int32Array</code> | <code>Uint32Array</code> | <code>Float32Array</code> | <code>Float64Array</code></li></ul></li></ul></li>',xl,$l,Pl,P,Al,A,Cl,C,Ho='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',Hl,H,Lo="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>TypedArray</code></td></tr></tbody>",Ll,Ml,wl,L,gl,M,El,w,Mo="Helper method to permute a <code>AnyTypedArray</code> directly",Rl,g,wo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - The permuted array and the new shape.',zl,E,go="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>array</td><td><code>T</code></td> </tr><tr><td>dims</td><td><code>Array.&lt;number&gt;</code></td> </tr><tr><td>axes</td><td><code>Array.&lt;number&gt;</code></td></tr></tbody>",kl,Kl,Ol,R,jl,z,Bl,k,Eo="Compute the softmax of an array of numbers.",Dl,K,Ro='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>T</code> - The softmax array.',Il,O,zo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>T</code></td><td><p>The array of numbers to compute the softmax of.</p></td></tr></tbody>",Ul,ql,Nl,j,Sl,B,Gl,D,ko="Calculates the logarithm of the softmax function for the input array.",Jl,I,Ko='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>T</code> - The resulting log_softmax array.',Ql,U,Oo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>T</code></td><td><p>The input array to calculate the log_softmax function for.</p></td></tr></tbody>",Vl,Wl,Xl,q,Yl,N,Zl,S,jo="Calculates the dot product of two arrays.",tr,G,Bo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The dot product of arr1 and arr2.',er,J,Do="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",lr,rr,dr,Q,ar,V,or,W,Io="Get the top k items from an iterable, sorted by descending order",ir,X,Uo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - The top k items, sorted by descending order',sr,Y,qo="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>items</td><td><code>Array&lt;any&gt;</code> | <code>TypedArray</code></td><td></td><td><p>The items to be sorted</p></td> </tr><tr><td>[top_k]</td><td><code>number</code> | <code>null</code></td><td><code>0</code></td><td><p>The number of top items to return (default: 0 = return all)</p></td></tr></tbody>",ur,nr,mr,Z,fr,tt,pr,et,No="Computes the cosine similarity between two arrays.",hr,lt,So='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The cosine similarity between the two arrays.',cr,rt,Go="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",Tr,yr,vr,dt,_r,at,Fr,ot,Jo="Calculates the magnitude of a given array.",br,it,Qo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The magnitude of the array.',xr,st,Vo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The array to calculate the magnitude of.</p></td></tr></tbody>",$r,Pr,Ar,ut,Cr,nt,Hr,mt,Wo="Returns the value and index of the minimum element in an array.",Lr,ft,Xo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - the value and index of the minimum element, of the form: [valueOfMin, indexOfMin]<br/> <strong>Throws</strong>:',Mr,pt,Yo="<li><code>Error</code> If array is empty.</li>",wr,ht,Zo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>TypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",gr,Er,Rr,ct,zr,Tt,kr,yt,ti="Returns the value and index of the maximum element in an array.",Kr,vt,ei='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - the value and index of the maximum element, of the form: [valueOfMax, indexOfMax]<br/> <strong>Throws</strong>:',Or,_t,li="<li><code>Error</code> If array is empty.</li>",jr,Ft,ri="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>AnyTypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",Br,Dr,Ir,bt,Ur,xt,qr,$t,di="Performs median filter on the provided data. Padding is done by mirroring the data.",Nr,Pt,ai='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',Sr,At,oi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>AnyTypedArray</code></td><td><p>The input array</p></td> </tr><tr><td>windowSize</td><td><code>number</code></td><td><p>The window size</p></td></tr></tbody>",Gr,Jr,Qr,Ct,Vr,Ht,Wr,Lt,ii="Helper function to round a number to a given number of decimals",Xr,Mt,si='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The rounded number',Yr,wt,ui="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>num</td><td><code>number</code></td><td><p>The number to round</p></td> </tr><tr><td>decimals</td><td><code>number</code></td><td><p>The number of decimals</p></td></tr></tbody>",Zr,td,ed,gt,ld,Et,rd,Rt,ni=`Helper function to round a number to the nearest integer, with ties rounded to the nearest even number.
Also known as “bankers’ rounding”. This is the default rounding mode in python. For example:
1.5 rounds to 2 and 2.5 rounds to 2.`,dd,zt,mi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The rounded number',ad,kt,fi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>number</code></td><td><p>The number to round</p></td></tr></tbody>",od,id,sd,Kt,ud,Ot,nd,jt,pi="Implementation of Radix-4 FFT.",md,Bt,hi=`P2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are a power of two in length.
Code adapted from <a href="https://www.npmjs.com/package/fft.js" rel="nofollow">https://www.npmjs.com/package/fft.js</a>`,fd,Dt,ci='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',pd,It,Ti='<li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li>',hd,cd,Td,Ut,yd,qt,vd,Nt,yi="<strong>Throws</strong>:",_d,St,vi="<li><code>Error</code> FFT size must be a power of two larger than 1.</li>",Fd,Gt,_i="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>number</code></td><td><p>The size of the input array. Must be a power of two larger than 1.</p></td></tr></tbody>",bd,xd,$d,Jt,Pd,Qt,Ad,Vt,Fi="Create a complex number array with size <code>2 * size</code>",Cd,Wt,bi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - A complex number array with size <code>2 * size</code>',Hd,Ld,Md,Xt,wd,Yt,gd,Zt,xi="Converts a complex number representation stored in a Float64Array to an array of real numbers.",Ed,te,$i='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - An array of real numbers representing the input complex number representation.',Rd,ee,Pi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>complex</td><td><code>Float64Array</code></td><td><p>The complex number representation to be converted.</p></td> </tr><tr><td>[storage]</td><td><code>Array.&lt;number&gt;</code></td><td><p>An optional array to store the result in.</p></td></tr></tbody>",zd,kd,Kd,le,Od,re,jd,de,Ai="Convert a real-valued input array to a complex-valued output array.",Bd,ae,Ci='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The complex-valued output array.',Dd,oe,Hi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Float64Array</code></td><td><p>The real-valued input array.</p></td> </tr><tr><td>[storage]</td><td><code>Float64Array</code></td><td><p>Optional buffer to store the output array.</p></td></tr></tbody>",Id,Ud,qd,ie,Nd,se,Sd,ue,Li="Performs a Fast Fourier Transform (FFT) on the given input data and stores the result in the output buffer.",Gd,ne,Mi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',Jd,me,wi="<li><code>Error</code> Input and output buffers must be different.</li>",Qd,fe,gi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer to store the result.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",Vd,Wd,Xd,pe,Yd,he,Zd,ce,Ei=`Performs a real-valued forward FFT on the given input buffer and stores the result in the given output buffer.
The input buffer must contain real values only, while the output buffer will contain complex values. The input and
output buffers must be different.`,ta,Te,Ri='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',ea,ye,zi="<li><code>Error</code> If the input and output buffers are the same.</li>",la,ve,ki="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer containing real values.</p></td></tr></tbody>",ra,da,aa,_e,oa,Fe,ia,be,Ki=`Performs an inverse FFT transformation on the given <code>data</code> array, and stores the result in <code>out</code>.
The <code>out</code> array must be a different buffer than the <code>data</code> array. The <code>out</code> array will contain the
result of the transformation. The <code>data</code> array will not be modified.`,sa,xe,Oi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',ua,$e,ji="<li><code>Error</code> If `out` and `data` refer to the same buffer.</li>",na,Pe,Bi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",ma,fa,pa,Ae,ha,Ce,ca,He,Di="Performs a radix-4 implementation of a discrete Fourier transform on a given set of data.",Ta,Le,Ii='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',ya,Me,Ui="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>A scaling factor to apply to the transform.</p></td></tr></tbody>",va,_a,Fa,we,ba,ge,xa,Ee,qi="Performs a radix-2 implementation of a discrete Fourier transform on a given set of data.",$a,Re,Ni='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Pa,ze,Si="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset at which to write the output data.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset at which to begin reading the input data.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for indexing the input data.</p></td></tr></tbody>",Aa,Ca,Ha,ke,La,Ke,Ma,Oe,Gi="Performs radix-4 transformation on input data of length 8",wa,je,Ji='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',ga,Be,Qi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input data array of length 8</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output data array of length 8</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>Index of output array to start writing from</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>Index of input array to start reading from</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>Step size between elements in input array</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>Scaling factor for inverse transform</p></td></tr></tbody>",Ea,Ra,za,De,ka,Ie,Ka,Ue,Vi="Real input radix-4 implementation",Oa,qe,Wi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',ja,Ne,Xi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output array for the transformed data</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input array of real data to be transformed</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The scale factor used to normalize the inverse transform</p></td></tr></tbody>",Ba,Da,Ia,Se,Ua,Ge,qa,Je,Yi="Performs a single real input radix-2 transformation on the provided data",Na,Qe,Zi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Sa,Ve,ts="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The output offset</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The input offset</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step</p></td></tr></tbody>",Ga,Ja,Qa,We,Va,Xe,Wa,Ye,es=`Computes a single real-valued transform using radix-4 algorithm.
This method is only called for len=8.`,Xa,Ze,ls='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Ya,tl,rs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset into the output array.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset into the input array.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for the input array.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The value of inverse.</p></td></tr></tbody>",Za,to,eo,el,lo,ll,ro,rl,ds=`NP2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are not a power of two in length. In such cases, the chirp-z transform is used.`,ao,dl,as='For more information, see: <a href="https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156" rel="nofollow">https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156</a>',oo,al,os='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',io,so,uo,ol,no,il,mo,sl,is="Constructs a new NP2FFT object.",fo,ul,ss="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>fft_length</td><td><code>number</code></td><td><p>The length of the FFT</p></td></tr></tbody>",po,ho,co,nl,To,ml,yo,fl,us='<strong>Kind</strong>: inner typedef of <a href="#module_utils/maths"><code>utils/maths</code></a>',vo,_o,Fo,pl,bo,cl,xo;return F=new y({props:{title:"utils/maths",local:"utilsmaths",headingTag:"h1"}}),A=new y({props:{title:"utils/maths.interpolate_data(input)",local:"utilsmathsinterpolatedatainput",headingTag:"h2"}}),M=new y({props:{title:"utils/maths.permute_data(array, dims, axes) ⇒ <code> * </code>",local:"utilsmathspermutedataarray-dims-axes--code--code",headingTag:"h2"}}),z=new y({props:{title:"utils/maths.softmax(arr) ⇒ <code> T </code>",local:"utilsmathssoftmaxarr--code-t-code",headingTag:"h2"}}),B=new y({props:{title:"utils/maths.log_softmax(arr) ⇒ <code> T </code>",local:"utilsmathslogsoftmaxarr--code-t-code",headingTag:"h2"}}),N=new y({props:{title:"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathsdotarr1-arr2--code-number-code",headingTag:"h2"}}),V=new y({props:{title:"utils/maths.getTopItems(items, [top_k]) ⇒ <code> * </code>",local:"utilsmathsgettopitemsitems-topk--code--code",headingTag:"h2"}}),tt=new y({props:{title:"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathscossimarr1-arr2--code-number-code",headingTag:"h2"}}),at=new y({props:{title:"utils/maths.magnitude(arr) ⇒ <code> number </code>",local:"utilsmathsmagnitudearr--code-number-code",headingTag:"h2"}}),nt=new y({props:{title:"utils/maths.min(arr) ⇒ <code> Array. < number > </code>",local:"utilsmathsminarr--code-array--number--code",headingTag:"h2"}}),Tt=new y({props:{title:"utils/maths.max(arr) ⇒ <code> * </code>",local:"utilsmathsmaxarr--code--code",headingTag:"h2"}}),xt=new y({props:{title:"utils/maths.medianFilter(data, windowSize)",local:"utilsmathsmedianfilterdata-windowsize",headingTag:"h2"}}),Ht=new y({props:{title:"utils/maths.round(num, decimals) ⇒ <code> number </code>",local:"utilsmathsroundnum-decimals--code-number-code",headingTag:"h2"}}),Et=new y({props:{title:"utils/maths.bankers_round(x) ⇒ <code> number </code>",local:"utilsmathsbankersroundx--code-number-code",headingTag:"h2"}}),Ot=new y({props:{title:"utils/maths~P2FFT",local:"utilsmathsp2fft",headingTag:"h2"}}),qt=new y({props:{title:"new P2FFT(size)",local:"new-p2fftsize",headingTag:"h3"}}),Qt=new y({props:{title:"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>",local:"p2fftcreatecomplexarray--code-float64array-code",headingTag:"h3"}}),Yt=new y({props:{title:"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>",local:"p2fftfromcomplexarraycomplex-storage--code-array--number--code",headingTag:"h3"}}),re=new y({props:{title:"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>",local:"p2ffttocomplexarrayinput-storage--code-float64array-code",headingTag:"h3"}}),se=new y({props:{title:"p2FFT.transform(out, data) ⇒ <code> void </code>",local:"p2ffttransformout-data--code-void-code",headingTag:"h3"}}),he=new y({props:{title:"p2FFT.realTransform(out, data)",local:"p2fftrealtransformout-data",headingTag:"h3"}}),Fe=new y({props:{title:"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>",local:"p2fftinversetransformout-data--code-void-code",headingTag:"h3"}}),Ce=new y({props:{title:"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>",local:"p2ffttransform4out-data-inv--code-void-code",headingTag:"h3"}}),ge=new y({props:{title:"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsingletransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),Ke=new y({props:{title:"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>",local:"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code",headingTag:"h3"}}),Ie=new y({props:{title:"p2FFT._realTransform4(out, data, inv)",local:"p2fftrealtransform4out-data-inv",headingTag:"h3"}}),Ge=new y({props:{title:"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),Xe=new y({props:{title:"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)",local:"p2fftsinglerealtransform4data-out-outoff-off-step-inv",headingTag:"h3"}}),ll=new y({props:{title:"utils/maths~NP2FFT",local:"utilsmathsnp2fft",headingTag:"h2"}}),il=new y({props:{title:"new NP2FFT(fft_length)",local:"new-np2fftfftlength",headingTag:"h3"}}),ml=new y({props:{title:"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>",local:"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code",headingTag:"h2"}}),pl=new ys({props:{source:"https://github.com/xenova/transformers.js/blob/v2.17.2/docs/source/api/utils/maths.md"}}),{c(){v=o("meta"),Tl=d(),hl=o("p"),yl=d(),_=o("a"),vl=d(),m(F.$$.fragment),_l=d(),b=o("p"),b.textContent=Po,Fl=d(),x=o("p"),x.textContent=Ao,bl=d(),$=o("ul"),$.innerHTML=Co,xl=d(),$l=o("hr"),Pl=d(),P=o("a"),Al=d(),m(A.$$.fragment),Cl=d(),C=o("p"),C.innerHTML=Ho,Hl=d(),H=o("table"),H.innerHTML=Lo,Ll=d(),Ml=o("hr"),wl=d(),L=o("a"),gl=d(),m(M.$$.fragment),El=d(),w=o("p"),w.innerHTML=Mo,Rl=d(),g=o("p"),g.innerHTML=wo,zl=d(),E=o("table"),E.innerHTML=go,kl=d(),Kl=o("hr"),Ol=d(),R=o("a"),jl=d(),m(z.$$.fragment),Bl=d(),k=o("p"),k.textContent=Eo,Dl=d(),K=o("p"),K.innerHTML=Ro,Il=d(),O=o("table"),O.innerHTML=zo,Ul=d(),ql=o("hr"),Nl=d(),j=o("a"),Sl=d(),m(B.$$.fragment),Gl=d(),D=o("p"),D.textContent=ko,Jl=d(),I=o("p"),I.innerHTML=Ko,Ql=d(),U=o("table"),U.innerHTML=Oo,Vl=d(),Wl=o("hr"),Xl=d(),q=o("a"),Yl=d(),m(N.$$.fragment),Zl=d(),S=o("p"),S.textContent=jo,tr=d(),G=o("p"),G.innerHTML=Bo,er=d(),J=o("table"),J.innerHTML=Do,lr=d(),rr=o("hr"),dr=d(),Q=o("a"),ar=d(),m(V.$$.fragment),or=d(),W=o("p"),W.textContent=Io,ir=d(),X=o("p"),X.innerHTML=Uo,sr=d(),Y=o("table"),Y.innerHTML=qo,ur=d(),nr=o("hr"),mr=d(),Z=o("a"),fr=d(),m(tt.$$.fragment),pr=d(),et=o("p"),et.textContent=No,hr=d(),lt=o("p"),lt.innerHTML=So,cr=d(),rt=o("table"),rt.innerHTML=Go,Tr=d(),yr=o("hr"),vr=d(),dt=o("a"),_r=d(),m(at.$$.fragment),Fr=d(),ot=o("p"),ot.textContent=Jo,br=d(),it=o("p"),it.innerHTML=Qo,xr=d(),st=o("table"),st.innerHTML=Vo,$r=d(),Pr=o("hr"),Ar=d(),ut=o("a"),Cr=d(),m(nt.$$.fragment),Hr=d(),mt=o("p"),mt.textContent=Wo,Lr=d(),ft=o("p"),ft.innerHTML=Xo,Mr=d(),pt=o("ul"),pt.innerHTML=Yo,wr=d(),ht=o("table"),ht.innerHTML=Zo,gr=d(),Er=o("hr"),Rr=d(),ct=o("a"),zr=d(),m(Tt.$$.fragment),kr=d(),yt=o("p"),yt.textContent=ti,Kr=d(),vt=o("p"),vt.innerHTML=ei,Or=d(),_t=o("ul"),_t.innerHTML=li,jr=d(),Ft=o("table"),Ft.innerHTML=ri,Br=d(),Dr=o("hr"),Ir=d(),bt=o("a"),Ur=d(),m(xt.$$.fragment),qr=d(),$t=o("p"),$t.textContent=di,Nr=d(),Pt=o("p"),Pt.innerHTML=ai,Sr=d(),At=o("table"),At.innerHTML=oi,Gr=d(),Jr=o("hr"),Qr=d(),Ct=o("a"),Vr=d(),m(Ht.$$.fragment),Wr=d(),Lt=o("p"),Lt.textContent=ii,Xr=d(),Mt=o("p"),Mt.innerHTML=si,Yr=d(),wt=o("table"),wt.innerHTML=ui,Zr=d(),td=o("hr"),ed=d(),gt=o("a"),ld=d(),m(Et.$$.fragment),rd=d(),Rt=o("p"),Rt.textContent=ni,dd=d(),zt=o("p"),zt.innerHTML=mi,ad=d(),kt=o("table"),kt.innerHTML=fi,od=d(),id=o("hr"),sd=d(),Kt=o("a"),ud=d(),m(Ot.$$.fragment),nd=d(),jt=o("p"),jt.textContent=pi,md=d(),Bt=o("p"),Bt.innerHTML=hi,fd=d(),Dt=o("p"),Dt.innerHTML=ci,pd=d(),It=o("ul"),It.innerHTML=Ti,hd=d(),cd=o("hr"),Td=d(),Ut=o("a"),yd=d(),m(qt.$$.fragment),vd=d(),Nt=o("p"),Nt.innerHTML=yi,_d=d(),St=o("ul"),St.innerHTML=vi,Fd=d(),Gt=o("table"),Gt.innerHTML=_i,bd=d(),xd=o("hr"),$d=d(),Jt=o("a"),Pd=d(),m(Qt.$$.fragment),Ad=d(),Vt=o("p"),Vt.innerHTML=Fi,Cd=d(),Wt=o("p"),Wt.innerHTML=bi,Hd=d(),Ld=o("hr"),Md=d(),Xt=o("a"),wd=d(),m(Yt.$$.fragment),gd=d(),Zt=o("p"),Zt.textContent=xi,Ed=d(),te=o("p"),te.innerHTML=$i,Rd=d(),ee=o("table"),ee.innerHTML=Pi,zd=d(),kd=o("hr"),Kd=d(),le=o("a"),Od=d(),m(re.$$.fragment),jd=d(),de=o("p"),de.textContent=Ai,Bd=d(),ae=o("p"),ae.innerHTML=Ci,Dd=d(),oe=o("table"),oe.innerHTML=Hi,Id=d(),Ud=o("hr"),qd=d(),ie=o("a"),Nd=d(),m(se.$$.fragment),Sd=d(),ue=o("p"),ue.textContent=Li,Gd=d(),ne=o("p"),ne.innerHTML=Mi,Jd=d(),me=o("ul"),me.innerHTML=wi,Qd=d(),fe=o("table"),fe.innerHTML=gi,Vd=d(),Wd=o("hr"),Xd=d(),pe=o("a"),Yd=d(),m(he.$$.fragment),Zd=d(),ce=o("p"),ce.textContent=Ei,ta=d(),Te=o("p"),Te.innerHTML=Ri,ea=d(),ye=o("ul"),ye.innerHTML=zi,la=d(),ve=o("table"),ve.innerHTML=ki,ra=d(),da=o("hr"),aa=d(),_e=o("a"),oa=d(),m(Fe.$$.fragment),ia=d(),be=o("p"),be.innerHTML=Ki,sa=d(),xe=o("p"),xe.innerHTML=Oi,ua=d(),$e=o("ul"),$e.innerHTML=ji,na=d(),Pe=o("table"),Pe.innerHTML=Bi,ma=d(),fa=o("hr"),pa=d(),Ae=o("a"),ha=d(),m(Ce.$$.fragment),ca=d(),He=o("p"),He.textContent=Di,Ta=d(),Le=o("p"),Le.innerHTML=Ii,ya=d(),Me=o("table"),Me.innerHTML=Ui,va=d(),_a=o("hr"),Fa=d(),we=o("a"),ba=d(),m(ge.$$.fragment),xa=d(),Ee=o("p"),Ee.textContent=qi,$a=d(),Re=o("p"),Re.innerHTML=Ni,Pa=d(),ze=o("table"),ze.innerHTML=Si,Aa=d(),Ca=o("hr"),Ha=d(),ke=o("a"),La=d(),m(Ke.$$.fragment),Ma=d(),Oe=o("p"),Oe.textContent=Gi,wa=d(),je=o("p"),je.innerHTML=Ji,ga=d(),Be=o("table"),Be.innerHTML=Qi,Ea=d(),Ra=o("hr"),za=d(),De=o("a"),ka=d(),m(Ie.$$.fragment),Ka=d(),Ue=o("p"),Ue.textContent=Vi,Oa=d(),qe=o("p"),qe.innerHTML=Wi,ja=d(),Ne=o("table"),Ne.innerHTML=Xi,Ba=d(),Da=o("hr"),Ia=d(),Se=o("a"),Ua=d(),m(Ge.$$.fragment),qa=d(),Je=o("p"),Je.textContent=Yi,Na=d(),Qe=o("p"),Qe.innerHTML=Zi,Sa=d(),Ve=o("table"),Ve.innerHTML=ts,Ga=d(),Ja=o("hr"),Qa=d(),We=o("a"),Va=d(),m(Xe.$$.fragment),Wa=d(),Ye=o("p"),Ye.textContent=es,Xa=d(),Ze=o("p"),Ze.innerHTML=ls,Ya=d(),tl=o("table"),tl.innerHTML=rs,Za=d(),to=o("hr"),eo=d(),el=o("a"),lo=d(),m(ll.$$.fragment),ro=d(),rl=o("p"),rl.textContent=ds,ao=d(),dl=o("p"),dl.innerHTML=as,oo=d(),al=o("p"),al.innerHTML=os,io=d(),so=o("hr"),uo=d(),ol=o("a"),no=d(),m(il.$$.fragment),mo=d(),sl=o("p"),sl.textContent=is,fo=d(),ul=o("table"),ul.innerHTML=ss,po=d(),ho=o("hr"),co=d(),nl=o("a"),To=d(),m(ml.$$.fragment),yo=d(),fl=o("p"),fl.innerHTML=us,vo=d(),_o=o("hr"),Fo=d(),m(pl.$$.fragment),bo=d(),cl=o("p"),this.h()},l(t){const e=cs("svelte-u9bgzb",document.head);v=i(e,"META",{name:!0,content:!0}),e.forEach(l),Tl=a(t),hl=i(t,"P",{}),n(hl).forEach(l),yl=a(t),_=i(t,"A",{id:!0,class:!0}),n(_).forEach(l),vl=a(t),f(F.$$.fragment,t),_l=a(t),b=i(t,"P",{"data-svelte-h":!0}),s(b)!=="svelte-1d3zgi"&&(b.textContent=Po),Fl=a(t),x=i(t,"P",{"data-svelte-h":!0}),s(x)!=="svelte-il3kl8"&&(x.textContent=Ao),bl=a(t),$=i(t,"UL",{"data-svelte-h":!0}),s($)!=="svelte-1ee40ld"&&($.innerHTML=Co),xl=a(t),$l=i(t,"HR",{}),Pl=a(t),P=i(t,"A",{id:!0,class:!0}),n(P).forEach(l),Al=a(t),f(A.$$.fragment,t),Cl=a(t),C=i(t,"P",{"data-svelte-h":!0}),s(C)!=="svelte-z8esp"&&(C.innerHTML=Ho),Hl=a(t),H=i(t,"TABLE",{"data-svelte-h":!0}),s(H)!=="svelte-13raiaj"&&(H.innerHTML=Lo),Ll=a(t),Ml=i(t,"HR",{}),wl=a(t),L=i(t,"A",{id:!0,class:!0}),n(L).forEach(l),gl=a(t),f(M.$$.fragment,t),El=a(t),w=i(t,"P",{"data-svelte-h":!0}),s(w)!=="svelte-1b1asvx"&&(w.innerHTML=Mo),Rl=a(t),g=i(t,"P",{"data-svelte-h":!0}),s(g)!=="svelte-pth1sg"&&(g.innerHTML=wo),zl=a(t),E=i(t,"TABLE",{"data-svelte-h":!0}),s(E)!=="svelte-18fxup5"&&(E.innerHTML=go),kl=a(t),Kl=i(t,"HR",{}),Ol=a(t),R=i(t,"A",{id:!0,class:!0}),n(R).forEach(l),jl=a(t),f(z.$$.fragment,t),Bl=a(t),k=i(t,"P",{"data-svelte-h":!0}),s(k)!=="svelte-1liv70i"&&(k.textContent=Eo),Dl=a(t),K=i(t,"P",{"data-svelte-h":!0}),s(K)!=="svelte-xvvopf"&&(K.innerHTML=Ro),Il=a(t),O=i(t,"TABLE",{"data-svelte-h":!0}),s(O)!=="svelte-adoxzf"&&(O.innerHTML=zo),Ul=a(t),ql=i(t,"HR",{}),Nl=a(t),j=i(t,"A",{id:!0,class:!0}),n(j).forEach(l),Sl=a(t),f(B.$$.fragment,t),Gl=a(t),D=i(t,"P",{"data-svelte-h":!0}),s(D)!=="svelte-5479oq"&&(D.textContent=ko),Jl=a(t),I=i(t,"P",{"data-svelte-h":!0}),s(I)!=="svelte-m9boyl"&&(I.innerHTML=Ko),Ql=a(t),U=i(t,"TABLE",{"data-svelte-h":!0}),s(U)!=="svelte-5wetzk"&&(U.innerHTML=Oo),Vl=a(t),Wl=i(t,"HR",{}),Xl=a(t),q=i(t,"A",{id:!0,class:!0}),n(q).forEach(l),Yl=a(t),f(N.$$.fragment,t),Zl=a(t),S=i(t,"P",{"data-svelte-h":!0}),s(S)!=="svelte-1kaf4lx"&&(S.textContent=jo),tr=a(t),G=i(t,"P",{"data-svelte-h":!0}),s(G)!=="svelte-gudhvq"&&(G.innerHTML=Bo),er=a(t),J=i(t,"TABLE",{"data-svelte-h":!0}),s(J)!=="svelte-nyqk4k"&&(J.innerHTML=Do),lr=a(t),rr=i(t,"HR",{}),dr=a(t),Q=i(t,"A",{id:!0,class:!0}),n(Q).forEach(l),ar=a(t),f(V.$$.fragment,t),or=a(t),W=i(t,"P",{"data-svelte-h":!0}),s(W)!=="svelte-s7mgi8"&&(W.textContent=Io),ir=a(t),X=i(t,"P",{"data-svelte-h":!0}),s(X)!=="svelte-5oll1y"&&(X.innerHTML=Uo),sr=a(t),Y=i(t,"TABLE",{"data-svelte-h":!0}),s(Y)!=="svelte-n1lt7"&&(Y.innerHTML=qo),ur=a(t),nr=i(t,"HR",{}),mr=a(t),Z=i(t,"A",{id:!0,class:!0}),n(Z).forEach(l),fr=a(t),f(tt.$$.fragment,t),pr=a(t),et=i(t,"P",{"data-svelte-h":!0}),s(et)!=="svelte-6quqqj"&&(et.textContent=No),hr=a(t),lt=i(t,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-1y45k06"&&(lt.innerHTML=So),cr=a(t),rt=i(t,"TABLE",{"data-svelte-h":!0}),s(rt)!=="svelte-nyqk4k"&&(rt.innerHTML=Go),Tr=a(t),yr=i(t,"HR",{}),vr=a(t),dt=i(t,"A",{id:!0,class:!0}),n(dt).forEach(l),_r=a(t),f(at.$$.fragment,t),Fr=a(t),ot=i(t,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-132v21g"&&(ot.textContent=Jo),br=a(t),it=i(t,"P",{"data-svelte-h":!0}),s(it)!=="svelte-odriss"&&(it.innerHTML=Qo),xr=a(t),st=i(t,"TABLE",{"data-svelte-h":!0}),s(st)!=="svelte-nbo00i"&&(st.innerHTML=Vo),$r=a(t),Pr=i(t,"HR",{}),Ar=a(t),ut=i(t,"A",{id:!0,class:!0}),n(ut).forEach(l),Cr=a(t),f(nt.$$.fragment,t),Hr=a(t),mt=i(t,"P",{"data-svelte-h":!0}),s(mt)!=="svelte-67h0u1"&&(mt.textContent=Wo),Lr=a(t),ft=i(t,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-cs0f6n"&&(ft.innerHTML=Xo),Mr=a(t),pt=i(t,"UL",{"data-svelte-h":!0}),s(pt)!=="svelte-jusv8t"&&(pt.innerHTML=Yo),wr=a(t),ht=i(t,"TABLE",{"data-svelte-h":!0}),s(ht)!=="svelte-mtkj0x"&&(ht.innerHTML=Zo),gr=a(t),Er=i(t,"HR",{}),Rr=a(t),ct=i(t,"A",{id:!0,class:!0}),n(ct).forEach(l),zr=a(t),f(Tt.$$.fragment,t),kr=a(t),yt=i(t,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-9vv4b"&&(yt.textContent=ti),Kr=a(t),vt=i(t,"P",{"data-svelte-h":!0}),s(vt)!=="svelte-1ixuuwb"&&(vt.innerHTML=ei),Or=a(t),_t=i(t,"UL",{"data-svelte-h":!0}),s(_t)!=="svelte-jusv8t"&&(_t.innerHTML=li),jr=a(t),Ft=i(t,"TABLE",{"data-svelte-h":!0}),s(Ft)!=="svelte-oriydz"&&(Ft.innerHTML=ri),Br=a(t),Dr=i(t,"HR",{}),Ir=a(t),bt=i(t,"A",{id:!0,class:!0}),n(bt).forEach(l),Ur=a(t),f(xt.$$.fragment,t),qr=a(t),$t=i(t,"P",{"data-svelte-h":!0}),s($t)!=="svelte-xb1vdd"&&($t.textContent=di),Nr=a(t),Pt=i(t,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-z8esp"&&(Pt.innerHTML=ai),Sr=a(t),At=i(t,"TABLE",{"data-svelte-h":!0}),s(At)!=="svelte-pk7ooi"&&(At.innerHTML=oi),Gr=a(t),Jr=i(t,"HR",{}),Qr=a(t),Ct=i(t,"A",{id:!0,class:!0}),n(Ct).forEach(l),Vr=a(t),f(Ht.$$.fragment,t),Wr=a(t),Lt=i(t,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-11aka64"&&(Lt.textContent=ii),Xr=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-jttckh"&&(Mt.innerHTML=si),Yr=a(t),wt=i(t,"TABLE",{"data-svelte-h":!0}),s(wt)!=="svelte-c6gnt1"&&(wt.innerHTML=ui),Zr=a(t),td=i(t,"HR",{}),ed=a(t),gt=i(t,"A",{id:!0,class:!0}),n(gt).forEach(l),ld=a(t),f(Et.$$.fragment,t),rd=a(t),Rt=i(t,"P",{"data-svelte-h":!0}),s(Rt)!=="svelte-1xjiy33"&&(Rt.textContent=ni),dd=a(t),zt=i(t,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-jttckh"&&(zt.innerHTML=mi),ad=a(t),kt=i(t,"TABLE",{"data-svelte-h":!0}),s(kt)!=="svelte-1uj9e15"&&(kt.innerHTML=fi),od=a(t),id=i(t,"HR",{}),sd=a(t),Kt=i(t,"A",{id:!0,class:!0}),n(Kt).forEach(l),ud=a(t),f(Ot.$$.fragment,t),nd=a(t),jt=i(t,"P",{"data-svelte-h":!0}),s(jt)!=="svelte-16m1u76"&&(jt.textContent=pi),md=a(t),Bt=i(t,"P",{"data-svelte-h":!0}),s(Bt)!=="svelte-698ey0"&&(Bt.innerHTML=hi),fd=a(t),Dt=i(t,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-tjke50"&&(Dt.innerHTML=ci),pd=a(t),It=i(t,"UL",{"data-svelte-h":!0}),s(It)!=="svelte-19h6qj3"&&(It.innerHTML=Ti),hd=a(t),cd=i(t,"HR",{}),Td=a(t),Ut=i(t,"A",{id:!0,class:!0}),n(Ut).forEach(l),yd=a(t),f(qt.$$.fragment,t),vd=a(t),Nt=i(t,"P",{"data-svelte-h":!0}),s(Nt)!=="svelte-1fz4yns"&&(Nt.innerHTML=yi),_d=a(t),St=i(t,"UL",{"data-svelte-h":!0}),s(St)!=="svelte-ph0ovr"&&(St.innerHTML=vi),Fd=a(t),Gt=i(t,"TABLE",{"data-svelte-h":!0}),s(Gt)!=="svelte-a5vdxc"&&(Gt.innerHTML=_i),bd=a(t),xd=i(t,"HR",{}),$d=a(t),Jt=i(t,"A",{id:!0,class:!0}),n(Jt).forEach(l),Pd=a(t),f(Qt.$$.fragment,t),Ad=a(t),Vt=i(t,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-1rrw4ya"&&(Vt.innerHTML=Fi),Cd=a(t),Wt=i(t,"P",{"data-svelte-h":!0}),s(Wt)!=="svelte-1gdnoew"&&(Wt.innerHTML=bi),Hd=a(t),Ld=i(t,"HR",{}),Md=a(t),Xt=i(t,"A",{id:!0,class:!0}),n(Xt).forEach(l),wd=a(t),f(Yt.$$.fragment,t),gd=a(t),Zt=i(t,"P",{"data-svelte-h":!0}),s(Zt)!=="svelte-1693r4v"&&(Zt.textContent=xi),Ed=a(t),te=i(t,"P",{"data-svelte-h":!0}),s(te)!=="svelte-33y4ax"&&(te.innerHTML=$i),Rd=a(t),ee=i(t,"TABLE",{"data-svelte-h":!0}),s(ee)!=="svelte-1td0xj2"&&(ee.innerHTML=Pi),zd=a(t),kd=i(t,"HR",{}),Kd=a(t),le=i(t,"A",{id:!0,class:!0}),n(le).forEach(l),Od=a(t),f(re.$$.fragment,t),jd=a(t),de=i(t,"P",{"data-svelte-h":!0}),s(de)!=="svelte-rsnsrd"&&(de.textContent=Ai),Bd=a(t),ae=i(t,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-1xayhm7"&&(ae.innerHTML=Ci),Dd=a(t),oe=i(t,"TABLE",{"data-svelte-h":!0}),s(oe)!=="svelte-1up5toh"&&(oe.innerHTML=Hi),Id=a(t),Ud=i(t,"HR",{}),qd=a(t),ie=i(t,"A",{id:!0,class:!0}),n(ie).forEach(l),Nd=a(t),f(se.$$.fragment,t),Sd=a(t),ue=i(t,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-846pp1"&&(ue.textContent=Li),Gd=a(t),ne=i(t,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-1t2xajz"&&(ne.innerHTML=Mi),Jd=a(t),me=i(t,"UL",{"data-svelte-h":!0}),s(me)!=="svelte-173tqd8"&&(me.innerHTML=wi),Qd=a(t),fe=i(t,"TABLE",{"data-svelte-h":!0}),s(fe)!=="svelte-1buvx7j"&&(fe.innerHTML=gi),Vd=a(t),Wd=i(t,"HR",{}),Xd=a(t),pe=i(t,"A",{id:!0,class:!0}),n(pe).forEach(l),Yd=a(t),f(he.$$.fragment,t),Zd=a(t),ce=i(t,"P",{"data-svelte-h":!0}),s(ce)!=="svelte-ozshoc"&&(ce.textContent=Ei),ta=a(t),Te=i(t,"P",{"data-svelte-h":!0}),s(Te)!=="svelte-1t2xajz"&&(Te.innerHTML=Ri),ea=a(t),ye=i(t,"UL",{"data-svelte-h":!0}),s(ye)!=="svelte-1ap3720"&&(ye.innerHTML=zi),la=a(t),ve=i(t,"TABLE",{"data-svelte-h":!0}),s(ve)!=="svelte-lghmn6"&&(ve.innerHTML=ki),ra=a(t),da=i(t,"HR",{}),aa=a(t),_e=i(t,"A",{id:!0,class:!0}),n(_e).forEach(l),oa=a(t),f(Fe.$$.fragment,t),ia=a(t),be=i(t,"P",{"data-svelte-h":!0}),s(be)!=="svelte-ijignt"&&(be.innerHTML=Ki),sa=a(t),xe=i(t,"P",{"data-svelte-h":!0}),s(xe)!=="svelte-1t2xajz"&&(xe.innerHTML=Oi),ua=a(t),$e=i(t,"UL",{"data-svelte-h":!0}),s($e)!=="svelte-1bp21xg"&&($e.innerHTML=ji),na=a(t),Pe=i(t,"TABLE",{"data-svelte-h":!0}),s(Pe)!=="svelte-edt5vq"&&(Pe.innerHTML=Bi),ma=a(t),fa=i(t,"HR",{}),pa=a(t),Ae=i(t,"A",{id:!0,class:!0}),n(Ae).forEach(l),ha=a(t),f(Ce.$$.fragment,t),ca=a(t),He=i(t,"P",{"data-svelte-h":!0}),s(He)!=="svelte-3r4wxn"&&(He.textContent=Di),Ta=a(t),Le=i(t,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-1dkdszr"&&(Le.innerHTML=Ii),ya=a(t),Me=i(t,"TABLE",{"data-svelte-h":!0}),s(Me)!=="svelte-15z8087"&&(Me.innerHTML=Ui),va=a(t),_a=i(t,"HR",{}),Fa=a(t),we=i(t,"A",{id:!0,class:!0}),n(we).forEach(l),ba=a(t),f(ge.$$.fragment,t),xa=a(t),Ee=i(t,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-1jz5wqp"&&(Ee.textContent=qi),$a=a(t),Re=i(t,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-1dkdszr"&&(Re.innerHTML=Ni),Pa=a(t),ze=i(t,"TABLE",{"data-svelte-h":!0}),s(ze)!=="svelte-fx5ob"&&(ze.innerHTML=Si),Aa=a(t),Ca=i(t,"HR",{}),Ha=a(t),ke=i(t,"A",{id:!0,class:!0}),n(ke).forEach(l),La=a(t),f(Ke.$$.fragment,t),Ma=a(t),Oe=i(t,"P",{"data-svelte-h":!0}),s(Oe)!=="svelte-1baynqa"&&(Oe.textContent=Gi),wa=a(t),je=i(t,"P",{"data-svelte-h":!0}),s(je)!=="svelte-1dkdszr"&&(je.innerHTML=Ji),ga=a(t),Be=i(t,"TABLE",{"data-svelte-h":!0}),s(Be)!=="svelte-szv30n"&&(Be.innerHTML=Qi),Ea=a(t),Ra=i(t,"HR",{}),za=a(t),De=i(t,"A",{id:!0,class:!0}),n(De).forEach(l),ka=a(t),f(Ie.$$.fragment,t),Ka=a(t),Ue=i(t,"P",{"data-svelte-h":!0}),s(Ue)!=="svelte-1gll44b"&&(Ue.textContent=Vi),Oa=a(t),qe=i(t,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-1dkdszr"&&(qe.innerHTML=Wi),ja=a(t),Ne=i(t,"TABLE",{"data-svelte-h":!0}),s(Ne)!=="svelte-159qhrx"&&(Ne.innerHTML=Xi),Ba=a(t),Da=i(t,"HR",{}),Ia=a(t),Se=i(t,"A",{id:!0,class:!0}),n(Se).forEach(l),Ua=a(t),f(Ge.$$.fragment,t),qa=a(t),Je=i(t,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-1upf1p8"&&(Je.textContent=Yi),Na=a(t),Qe=i(t,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-1dkdszr"&&(Qe.innerHTML=Zi),Sa=a(t),Ve=i(t,"TABLE",{"data-svelte-h":!0}),s(Ve)!=="svelte-18nciet"&&(Ve.innerHTML=ts),Ga=a(t),Ja=i(t,"HR",{}),Qa=a(t),We=i(t,"A",{id:!0,class:!0}),n(We).forEach(l),Va=a(t),f(Xe.$$.fragment,t),Wa=a(t),Ye=i(t,"P",{"data-svelte-h":!0}),s(Ye)!=="svelte-8fqhv2"&&(Ye.textContent=es),Xa=a(t),Ze=i(t,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-1dkdszr"&&(Ze.innerHTML=ls),Ya=a(t),tl=i(t,"TABLE",{"data-svelte-h":!0}),s(tl)!=="svelte-pf887e"&&(tl.innerHTML=rs),Za=a(t),to=i(t,"HR",{}),eo=a(t),el=i(t,"A",{id:!0,class:!0}),n(el).forEach(l),lo=a(t),f(ll.$$.fragment,t),ro=a(t),rl=i(t,"P",{"data-svelte-h":!0}),s(rl)!=="svelte-yw51a0"&&(rl.textContent=ds),ao=a(t),dl=i(t,"P",{"data-svelte-h":!0}),s(dl)!=="svelte-1gw6hta"&&(dl.innerHTML=as),oo=a(t),al=i(t,"P",{"data-svelte-h":!0}),s(al)!=="svelte-tjke50"&&(al.innerHTML=os),io=a(t),so=i(t,"HR",{}),uo=a(t),ol=i(t,"A",{id:!0,class:!0}),n(ol).forEach(l),no=a(t),f(il.$$.fragment,t),mo=a(t),sl=i(t,"P",{"data-svelte-h":!0}),s(sl)!=="svelte-lvoqsi"&&(sl.textContent=is),fo=a(t),ul=i(t,"TABLE",{"data-svelte-h":!0}),s(ul)!=="svelte-1gtay08"&&(ul.innerHTML=ss),po=a(t),ho=i(t,"HR",{}),co=a(t),nl=i(t,"A",{id:!0,class:!0}),n(nl).forEach(l),To=a(t),f(ml.$$.fragment,t),yo=a(t),fl=i(t,"P",{"data-svelte-h":!0}),s(fl)!=="svelte-9rr3v5"&&(fl.innerHTML=us),vo=a(t),_o=i(t,"HR",{}),Fo=a(t),f(pl.$$.fragment,t),bo=a(t),cl=i(t,"P",{}),n(cl).forEach(l),this.h()},h(){u(v,"name","hf:doc:metadata"),u(v,"content",_s),u(_,"id","module_utils/maths"),u(_,"class","group"),u(P,"id","module_utils/maths.interpolate_data"),u(P,"class","group"),u(L,"id","module_utils/maths.permute_data"),u(L,"class","group"),u(R,"id","module_utils/maths.softmax"),u(R,"class","group"),u(j,"id","module_utils/maths.log_softmax"),u(j,"class","group"),u(q,"id","module_utils/maths.dot"),u(q,"class","group"),u(Q,"id","module_utils/maths.getTopItems"),u(Q,"class","group"),u(Z,"id","module_utils/maths.cos_sim"),u(Z,"class","group"),u(dt,"id","module_utils/maths.magnitude"),u(dt,"class","group"),u(ut,"id","module_utils/maths.min"),u(ut,"class","group"),u(ct,"id","module_utils/maths.max"),u(ct,"class","group"),u(bt,"id","module_utils/maths.medianFilter"),u(bt,"class","group"),u(Ct,"id","module_utils/maths.round"),u(Ct,"class","group"),u(gt,"id","module_utils/maths.bankers_round"),u(gt,"class","group"),u(Kt,"id","module_utils/maths..P2FFT"),u(Kt,"class","group"),u(Ut,"id","new_module_utils/maths..P2FFT_new"),u(Ut,"class","group"),u(Jt,"id","module_utils/maths..P2FFT+createComplexArray"),u(Jt,"class","group"),u(Xt,"id","module_utils/maths..P2FFT+fromComplexArray"),u(Xt,"class","group"),u(le,"id","module_utils/maths..P2FFT+toComplexArray"),u(le,"class","group"),u(ie,"id","module_utils/maths..P2FFT+transform"),u(ie,"class","group"),u(pe,"id","module_utils/maths..P2FFT+realTransform"),u(pe,"class","group"),u(_e,"id","module_utils/maths..P2FFT+inverseTransform"),u(_e,"class","group"),u(Ae,"id","module_utils/maths..P2FFT+_transform4"),u(Ae,"class","group"),u(we,"id","module_utils/maths..P2FFT+_singleTransform2"),u(we,"class","group"),u(ke,"id","module_utils/maths..P2FFT+_singleTransform4"),u(ke,"class","group"),u(De,"id","module_utils/maths..P2FFT+_realTransform4"),u(De,"class","group"),u(Se,"id","module_utils/maths..P2FFT+_singleRealTransform2"),u(Se,"class","group"),u(We,"id","module_utils/maths..P2FFT+_singleRealTransform4"),u(We,"class","group"),u(el,"id","module_utils/maths..NP2FFT"),u(el,"class","group"),u(ol,"id","new_module_utils/maths..NP2FFT_new"),u(ol,"class","group"),u(nl,"id","module_utils/maths..AnyTypedArray"),u(nl,"class","group")},m(t,e){Ts(document.head,v),r(t,Tl,e),r(t,hl,e),r(t,yl,e),r(t,_,e),r(t,vl,e),p(F,t,e),r(t,_l,e),r(t,b,e),r(t,Fl,e),r(t,x,e),r(t,bl,e),r(t,$,e),r(t,xl,e),r(t,$l,e),r(t,Pl,e),r(t,P,e),r(t,Al,e),p(A,t,e),r(t,Cl,e),r(t,C,e),r(t,Hl,e),r(t,H,e),r(t,Ll,e),r(t,Ml,e),r(t,wl,e),r(t,L,e),r(t,gl,e),p(M,t,e),r(t,El,e),r(t,w,e),r(t,Rl,e),r(t,g,e),r(t,zl,e),r(t,E,e),r(t,kl,e),r(t,Kl,e),r(t,Ol,e),r(t,R,e),r(t,jl,e),p(z,t,e),r(t,Bl,e),r(t,k,e),r(t,Dl,e),r(t,K,e),r(t,Il,e),r(t,O,e),r(t,Ul,e),r(t,ql,e),r(t,Nl,e),r(t,j,e),r(t,Sl,e),p(B,t,e),r(t,Gl,e),r(t,D,e),r(t,Jl,e),r(t,I,e),r(t,Ql,e),r(t,U,e),r(t,Vl,e),r(t,Wl,e),r(t,Xl,e),r(t,q,e),r(t,Yl,e),p(N,t,e),r(t,Zl,e),r(t,S,e),r(t,tr,e),r(t,G,e),r(t,er,e),r(t,J,e),r(t,lr,e),r(t,rr,e),r(t,dr,e),r(t,Q,e),r(t,ar,e),p(V,t,e),r(t,or,e),r(t,W,e),r(t,ir,e),r(t,X,e),r(t,sr,e),r(t,Y,e),r(t,ur,e),r(t,nr,e),r(t,mr,e),r(t,Z,e),r(t,fr,e),p(tt,t,e),r(t,pr,e),r(t,et,e),r(t,hr,e),r(t,lt,e),r(t,cr,e),r(t,rt,e),r(t,Tr,e),r(t,yr,e),r(t,vr,e),r(t,dt,e),r(t,_r,e),p(at,t,e),r(t,Fr,e),r(t,ot,e),r(t,br,e),r(t,it,e),r(t,xr,e),r(t,st,e),r(t,$r,e),r(t,Pr,e),r(t,Ar,e),r(t,ut,e),r(t,Cr,e),p(nt,t,e),r(t,Hr,e),r(t,mt,e),r(t,Lr,e),r(t,ft,e),r(t,Mr,e),r(t,pt,e),r(t,wr,e),r(t,ht,e),r(t,gr,e),r(t,Er,e),r(t,Rr,e),r(t,ct,e),r(t,zr,e),p(Tt,t,e),r(t,kr,e),r(t,yt,e),r(t,Kr,e),r(t,vt,e),r(t,Or,e),r(t,_t,e),r(t,jr,e),r(t,Ft,e),r(t,Br,e),r(t,Dr,e),r(t,Ir,e),r(t,bt,e),r(t,Ur,e),p(xt,t,e),r(t,qr,e),r(t,$t,e),r(t,Nr,e),r(t,Pt,e),r(t,Sr,e),r(t,At,e),r(t,Gr,e),r(t,Jr,e),r(t,Qr,e),r(t,Ct,e),r(t,Vr,e),p(Ht,t,e),r(t,Wr,e),r(t,Lt,e),r(t,Xr,e),r(t,Mt,e),r(t,Yr,e),r(t,wt,e),r(t,Zr,e),r(t,td,e),r(t,ed,e),r(t,gt,e),r(t,ld,e),p(Et,t,e),r(t,rd,e),r(t,Rt,e),r(t,dd,e),r(t,zt,e),r(t,ad,e),r(t,kt,e),r(t,od,e),r(t,id,e),r(t,sd,e),r(t,Kt,e),r(t,ud,e),p(Ot,t,e),r(t,nd,e),r(t,jt,e),r(t,md,e),r(t,Bt,e),r(t,fd,e),r(t,Dt,e),r(t,pd,e),r(t,It,e),r(t,hd,e),r(t,cd,e),r(t,Td,e),r(t,Ut,e),r(t,yd,e),p(qt,t,e),r(t,vd,e),r(t,Nt,e),r(t,_d,e),r(t,St,e),r(t,Fd,e),r(t,Gt,e),r(t,bd,e),r(t,xd,e),r(t,$d,e),r(t,Jt,e),r(t,Pd,e),p(Qt,t,e),r(t,Ad,e),r(t,Vt,e),r(t,Cd,e),r(t,Wt,e),r(t,Hd,e),r(t,Ld,e),r(t,Md,e),r(t,Xt,e),r(t,wd,e),p(Yt,t,e),r(t,gd,e),r(t,Zt,e),r(t,Ed,e),r(t,te,e),r(t,Rd,e),r(t,ee,e),r(t,zd,e),r(t,kd,e),r(t,Kd,e),r(t,le,e),r(t,Od,e),p(re,t,e),r(t,jd,e),r(t,de,e),r(t,Bd,e),r(t,ae,e),r(t,Dd,e),r(t,oe,e),r(t,Id,e),r(t,Ud,e),r(t,qd,e),r(t,ie,e),r(t,Nd,e),p(se,t,e),r(t,Sd,e),r(t,ue,e),r(t,Gd,e),r(t,ne,e),r(t,Jd,e),r(t,me,e),r(t,Qd,e),r(t,fe,e),r(t,Vd,e),r(t,Wd,e),r(t,Xd,e),r(t,pe,e),r(t,Yd,e),p(he,t,e),r(t,Zd,e),r(t,ce,e),r(t,ta,e),r(t,Te,e),r(t,ea,e),r(t,ye,e),r(t,la,e),r(t,ve,e),r(t,ra,e),r(t,da,e),r(t,aa,e),r(t,_e,e),r(t,oa,e),p(Fe,t,e),r(t,ia,e),r(t,be,e),r(t,sa,e),r(t,xe,e),r(t,ua,e),r(t,$e,e),r(t,na,e),r(t,Pe,e),r(t,ma,e),r(t,fa,e),r(t,pa,e),r(t,Ae,e),r(t,ha,e),p(Ce,t,e),r(t,ca,e),r(t,He,e),r(t,Ta,e),r(t,Le,e),r(t,ya,e),r(t,Me,e),r(t,va,e),r(t,_a,e),r(t,Fa,e),r(t,we,e),r(t,ba,e),p(ge,t,e),r(t,xa,e),r(t,Ee,e),r(t,$a,e),r(t,Re,e),r(t,Pa,e),r(t,ze,e),r(t,Aa,e),r(t,Ca,e),r(t,Ha,e),r(t,ke,e),r(t,La,e),p(Ke,t,e),r(t,Ma,e),r(t,Oe,e),r(t,wa,e),r(t,je,e),r(t,ga,e),r(t,Be,e),r(t,Ea,e),r(t,Ra,e),r(t,za,e),r(t,De,e),r(t,ka,e),p(Ie,t,e),r(t,Ka,e),r(t,Ue,e),r(t,Oa,e),r(t,qe,e),r(t,ja,e),r(t,Ne,e),r(t,Ba,e),r(t,Da,e),r(t,Ia,e),r(t,Se,e),r(t,Ua,e),p(Ge,t,e),r(t,qa,e),r(t,Je,e),r(t,Na,e),r(t,Qe,e),r(t,Sa,e),r(t,Ve,e),r(t,Ga,e),r(t,Ja,e),r(t,Qa,e),r(t,We,e),r(t,Va,e),p(Xe,t,e),r(t,Wa,e),r(t,Ye,e),r(t,Xa,e),r(t,Ze,e),r(t,Ya,e),r(t,tl,e),r(t,Za,e),r(t,to,e),r(t,eo,e),r(t,el,e),r(t,lo,e),p(ll,t,e),r(t,ro,e),r(t,rl,e),r(t,ao,e),r(t,dl,e),r(t,oo,e),r(t,al,e),r(t,io,e),r(t,so,e),r(t,uo,e),r(t,ol,e),r(t,no,e),p(il,t,e),r(t,mo,e),r(t,sl,e),r(t,fo,e),r(t,ul,e),r(t,po,e),r(t,ho,e),r(t,co,e),r(t,nl,e),r(t,To,e),p(ml,t,e),r(t,yo,e),r(t,fl,e),r(t,vo,e),r(t,_o,e),r(t,Fo,e),p(pl,t,e),r(t,bo,e),r(t,cl,e),xo=!0},p:ms,i(t){xo||(h(F.$$.fragment,t),h(A.$$.fragment,t),h(M.$$.fragment,t),h(z.$$.fragment,t),h(B.$$.fragment,t),h(N.$$.fragment,t),h(V.$$.fragment,t),h(tt.$$.fragment,t),h(at.$$.fragment,t),h(nt.$$.fragment,t),h(Tt.$$.fragment,t),h(xt.$$.fragment,t),h(Ht.$$.fragment,t),h(Et.$$.fragment,t),h(Ot.$$.fragment,t),h(qt.$$.fragment,t),h(Qt.$$.fragment,t),h(Yt.$$.fragment,t),h(re.$$.fragment,t),h(se.$$.fragment,t),h(he.$$.fragment,t),h(Fe.$$.fragment,t),h(Ce.$$.fragment,t),h(ge.$$.fragment,t),h(Ke.$$.fragment,t),h(Ie.$$.fragment,t),h(Ge.$$.fragment,t),h(Xe.$$.fragment,t),h(ll.$$.fragment,t),h(il.$$.fragment,t),h(ml.$$.fragment,t),h(pl.$$.fragment,t),xo=!0)},o(t){c(F.$$.fragment,t),c(A.$$.fragment,t),c(M.$$.fragment,t),c(z.$$.fragment,t),c(B.$$.fragment,t),c(N.$$.fragment,t),c(V.$$.fragment,t),c(tt.$$.fragment,t),c(at.$$.fragment,t),c(nt.$$.fragment,t),c(Tt.$$.fragment,t),c(xt.$$.fragment,t),c(Ht.$$.fragment,t),c(Et.$$.fragment,t),c(Ot.$$.fragment,t),c(qt.$$.fragment,t),c(Qt.$$.fragment,t),c(Yt.$$.fragment,t),c(re.$$.fragment,t),c(se.$$.fragment,t),c(he.$$.fragment,t),c(Fe.$$.fragment,t),c(Ce.$$.fragment,t),c(ge.$$.fragment,t),c(Ke.$$.fragment,t),c(Ie.$$.fragment,t),c(Ge.$$.fragment,t),c(Xe.$$.fragment,t),c(ll.$$.fragment,t),c(il.$$.fragment,t),c(ml.$$.fragment,t),c(pl.$$.fragment,t),xo=!1},d(t){t&&(l(Tl),l(hl),l(yl),l(_),l(vl),l(_l),l(b),l(Fl),l(x),l(bl),l($),l(xl),l($l),l(Pl),l(P),l(Al),l(Cl),l(C),l(Hl),l(H),l(Ll),l(Ml),l(wl),l(L),l(gl),l(El),l(w),l(Rl),l(g),l(zl),l(E),l(kl),l(Kl),l(Ol),l(R),l(jl),l(Bl),l(k),l(Dl),l(K),l(Il),l(O),l(Ul),l(ql),l(Nl),l(j),l(Sl),l(Gl),l(D),l(Jl),l(I),l(Ql),l(U),l(Vl),l(Wl),l(Xl),l(q),l(Yl),l(Zl),l(S),l(tr),l(G),l(er),l(J),l(lr),l(rr),l(dr),l(Q),l(ar),l(or),l(W),l(ir),l(X),l(sr),l(Y),l(ur),l(nr),l(mr),l(Z),l(fr),l(pr),l(et),l(hr),l(lt),l(cr),l(rt),l(Tr),l(yr),l(vr),l(dt),l(_r),l(Fr),l(ot),l(br),l(it),l(xr),l(st),l($r),l(Pr),l(Ar),l(ut),l(Cr),l(Hr),l(mt),l(Lr),l(ft),l(Mr),l(pt),l(wr),l(ht),l(gr),l(Er),l(Rr),l(ct),l(zr),l(kr),l(yt),l(Kr),l(vt),l(Or),l(_t),l(jr),l(Ft),l(Br),l(Dr),l(Ir),l(bt),l(Ur),l(qr),l($t),l(Nr),l(Pt),l(Sr),l(At),l(Gr),l(Jr),l(Qr),l(Ct),l(Vr),l(Wr),l(Lt),l(Xr),l(Mt),l(Yr),l(wt),l(Zr),l(td),l(ed),l(gt),l(ld),l(rd),l(Rt),l(dd),l(zt),l(ad),l(kt),l(od),l(id),l(sd),l(Kt),l(ud),l(nd),l(jt),l(md),l(Bt),l(fd),l(Dt),l(pd),l(It),l(hd),l(cd),l(Td),l(Ut),l(yd),l(vd),l(Nt),l(_d),l(St),l(Fd),l(Gt),l(bd),l(xd),l($d),l(Jt),l(Pd),l(Ad),l(Vt),l(Cd),l(Wt),l(Hd),l(Ld),l(Md),l(Xt),l(wd),l(gd),l(Zt),l(Ed),l(te),l(Rd),l(ee),l(zd),l(kd),l(Kd),l(le),l(Od),l(jd),l(de),l(Bd),l(ae),l(Dd),l(oe),l(Id),l(Ud),l(qd),l(ie),l(Nd),l(Sd),l(ue),l(Gd),l(ne),l(Jd),l(me),l(Qd),l(fe),l(Vd),l(Wd),l(Xd),l(pe),l(Yd),l(Zd),l(ce),l(ta),l(Te),l(ea),l(ye),l(la),l(ve),l(ra),l(da),l(aa),l(_e),l(oa),l(ia),l(be),l(sa),l(xe),l(ua),l($e),l(na),l(Pe),l(ma),l(fa),l(pa),l(Ae),l(ha),l(ca),l(He),l(Ta),l(Le),l(ya),l(Me),l(va),l(_a),l(Fa),l(we),l(ba),l(xa),l(Ee),l($a),l(Re),l(Pa),l(ze),l(Aa),l(Ca),l(Ha),l(ke),l(La),l(Ma),l(Oe),l(wa),l(je),l(ga),l(Be),l(Ea),l(Ra),l(za),l(De),l(ka),l(Ka),l(Ue),l(Oa),l(qe),l(ja),l(Ne),l(Ba),l(Da),l(Ia),l(Se),l(Ua),l(qa),l(Je),l(Na),l(Qe),l(Sa),l(Ve),l(Ga),l(Ja),l(Qa),l(We),l(Va),l(Wa),l(Ye),l(Xa),l(Ze),l(Ya),l(tl),l(Za),l(to),l(eo),l(el),l(lo),l(ro),l(rl),l(ao),l(dl),l(oo),l(al),l(io),l(so),l(uo),l(ol),l(no),l(mo),l(sl),l(fo),l(ul),l(po),l(ho),l(co),l(nl),l(To),l(yo),l(fl),l(vo),l(_o),l(Fo),l(bo),l(cl)),l(v),T(F,t),T(A,t),T(M,t),T(z,t),T(B,t),T(N,t),T(V,t),T(tt,t),T(at,t),T(nt,t),T(Tt,t),T(xt,t),T(Ht,t),T(Et,t),T(Ot,t),T(qt,t),T(Qt,t),T(Yt,t),T(re,t),T(se,t),T(he,t),T(Fe,t),T(Ce,t),T(ge,t),T(Ke,t),T(Ie,t),T(Ge,t),T(Xe,t),T(ll,t),T(il,t),T(ml,t),T(pl,t)}}}const _s='{"title":"utils/maths","local":"utilsmaths","sections":[{"title":"utils/maths.interpolate_data(input)","local":"utilsmathsinterpolatedatainput","sections":[],"depth":2},{"title":"utils/maths.permute_data(array, dims, axes) ⇒ <code> * </code>","local":"utilsmathspermutedataarray-dims-axes--code--code","sections":[],"depth":2},{"title":"utils/maths.softmax(arr) ⇒ <code> T </code>","local":"utilsmathssoftmaxarr--code-t-code","sections":[],"depth":2},{"title":"utils/maths.log_softmax(arr) ⇒ <code> T </code>","local":"utilsmathslogsoftmaxarr--code-t-code","sections":[],"depth":2},{"title":"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathsdotarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.getTopItems(items, [top_k]) ⇒ <code> * </code>","local":"utilsmathsgettopitemsitems-topk--code--code","sections":[],"depth":2},{"title":"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathscossimarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.magnitude(arr) ⇒ <code> number </code>","local":"utilsmathsmagnitudearr--code-number-code","sections":[],"depth":2},{"title":"utils/maths.min(arr) ⇒ <code> Array. < number > </code>","local":"utilsmathsminarr--code-array--number--code","sections":[],"depth":2},{"title":"utils/maths.max(arr) ⇒ <code> * </code>","local":"utilsmathsmaxarr--code--code","sections":[],"depth":2},{"title":"utils/maths.medianFilter(data, windowSize)","local":"utilsmathsmedianfilterdata-windowsize","sections":[],"depth":2},{"title":"utils/maths.round(num, decimals) ⇒ <code> number </code>","local":"utilsmathsroundnum-decimals--code-number-code","sections":[],"depth":2},{"title":"utils/maths.bankers_round(x) ⇒ <code> number </code>","local":"utilsmathsbankersroundx--code-number-code","sections":[],"depth":2},{"title":"utils/maths~P2FFT","local":"utilsmathsp2fft","sections":[{"title":"new P2FFT(size)","local":"new-p2fftsize","sections":[],"depth":3},{"title":"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>","local":"p2fftcreatecomplexarray--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>","local":"p2fftfromcomplexarraycomplex-storage--code-array--number--code","sections":[],"depth":3},{"title":"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>","local":"p2ffttocomplexarrayinput-storage--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.transform(out, data) ⇒ <code> void </code>","local":"p2ffttransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT.realTransform(out, data)","local":"p2fftrealtransformout-data","sections":[],"depth":3},{"title":"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>","local":"p2fftinversetransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>","local":"p2ffttransform4out-data-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsingletransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>","local":"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._realTransform4(out, data, inv)","local":"p2fftrealtransform4out-data-inv","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)","local":"p2fftsinglerealtransform4data-out-outoff-off-step-inv","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~NP2FFT","local":"utilsmathsnp2fft","sections":[{"title":"new NP2FFT(fft_length)","local":"new-np2fftfftlength","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>","local":"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code","sections":[],"depth":2}],"depth":1}';function Fs($o){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ps extends ps{constructor(v){super(),hs(this,v,Fs,vs,ns,{})}}export{Ps as component};
