import{s as ei,f as ti,n as ii,o as li}from"../chunks/scheduler.7bc62968.js";import{S as ni,i as si,g as a,s as n,r as u,A as ai,h as o,f as i,c as s,j as wt,u as g,x as r,k as c,y as oi,a as l,v as f,d as m,t as h,w as p}from"../chunks/index.66556066.js";import{H as y,g as ri}from"../chunks/Heading.8f17e89c.js";import{C as pe}from"../chunks/CodeBlock.a759539a.js";function ui(vt){let w,we,de,ve,L,$e,C,$t="This beginner-friendly guide will help you get the basic skills you need to create and manage your repository on the Hub. Each section builds on the previous one, so feel free to choose where to start!",be,U,Te,I,bt="This document shows how to handle repositories through the web interface as well as through the terminal. There are no requirements if working with the UI. If you want to work with the terminal, please follow these installation instructions.",Me,j,Tt='If you do not have <code>git</code> available as a CLI command yet, you will need to <a href="https://git-scm.com/downloads" rel="nofollow">install Git</a> for your platform. You will also need to <a href="https://git-lfs.github.com/" rel="nofollow">install Git LFS</a>, which will be used to handle large files such as images and model weights.',ke,Z,Mt='To be able to push your code to the Hub, you’ll need to authenticate somehow. The easiest way to do this is by installing the <a href="https://huggingface.co/docs/huggingface_hub/index" rel="nofollow"><code>huggingface_hub</code> CLI</a> and running the login command:',_e,P,xe,S,kt="<strong>The content in the Getting Started section of this document is also available as a video!</strong>",He,d,_t,Le,J,Ce,W,xt="Using the Hub’s web interface you can easily create repositories, add files (even large ones!), explore models, visualize diffs, and much more. There are three kinds of repositories on the Hub, and in this guide you’ll be creating a <strong>model repository</strong> for demonstration purposes. For information on creating and managing models, datasets, and Spaces, refer to their respective documentation.",Ue,z,Ht='<li>To create a new repository, visit <a href="http://huggingface.co/new" rel="nofollow">huggingface.co/new</a>:</li>',Ie,v,Lt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/new_repo.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/new_repo-dark.png"/>',je,$,Ct='<li><p>Specify the owner of the repository: this can be either you or any of the organizations you’re affiliated with.</p></li> <li><p>Enter your model’s name. This will also be the name of the repository.</p></li> <li><p>Specify whether you want your model to be public or private.</p></li> <li><p>Specify the license. You can leave the <em>License</em> field blank for now. To learn about licenses, visit the <a href="repositories-licenses"><strong>Licenses</strong></a> documentation.</p></li>',Ze,G,Ut="After creating your model repository, you should see a page like this:",Pe,b,It='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/empty_repo.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/empty_repo-dark.png"/>',Se,Y,jt='Note that the Hub prompts you to create a <em>Model Card</em>, which you can learn about in the <a href="./model-cards"><strong>Model Cards documentation</strong></a>. Including a Model Card in your model repo is best practice, but since we’re only making a test repo at the moment we can skip this.',Je,q,We,F,Zt="To add files to your repository via the web UI, start by selecting the <strong>Files</strong> tab, navigating to the desired directory, and then clicking <strong>Add file</strong>. You’ll be given the option to create a new file or upload a file directly from your computer.",ze,T,Pt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repositories-add_file.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repositories-add_file-dark.png"/>',Ge,V,Ye,B,St='Choosing to create a new file will take you to the following editor screen, where you can choose a name for your file, add content, and save your file with a message that summarizes your changes. Instead of directly committing the new file to your repo’s <code>main</code> branch, you can select <code>Open as a pull request</code> to create a <a href="./repositories-pull-requests-discussions">Pull Request</a>.',qe,M,Jt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repositories-create_file.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repositories-create_file-dark.png"/>',Fe,R,Ve,N,Wt="If you choose <em>Upload file</em> you’ll be able to choose a local file to upload, along with a message summarizing your changes to the repo.",Be,k,zt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repositories-upload_file.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repositories-upload_file-dark.png"/>',Re,A,Gt='As with creating new files, you can select <code>Open as a pull request</code> to create a <a href="./repositories-pull-requests-discussions">Pull Request</a> instead of adding your changes directly to the <code>main</code> branch of your repo.',Ne,D,Ae,X,De,Q,Yt="Downloading repositories to your local machine is called <em>cloning</em>. You can use the following commands to load your repo and navigate to it:",Xe,E,Qe,O,qt="You can clone over SSH with the following command:",Ee,K,Oe,ee,Ft='You’ll need to add your SSH public key to <a href="https://huggingface.co/settings/keys" rel="nofollow">your user settings</a> to push changes or access private repositories.',Ke,te,et,ie,Vt="Now’s the time, you can add any files you want to the repository! 🔥",tt,le,Bt="Do you have files larger than 10MB? Those files should be tracked with <code>git-lfs</code>, which you can initialize with:",it,ne,lt,se,Rt="Note that if your files are larger than <strong>5GB</strong> you’ll also need to run:",nt,ae,st,oe,Nt="When you use Hugging Face to create a repository, Hugging Face automatically provides a list of common file extensions for common Machine Learning large files in the <code>.gitattributes</code> file, which <code>git-lfs</code> uses to efficiently track changes to your large files. However, you might need to add new extensions if your file types are not already handled. You can do so with <code>git lfs track &quot;*.your_extension&quot;</code>.",at,re,ot,ue,At="You can use Git to save new files and any changes to already existing files as a bundle of changes called a <em>commit</em>, which can be thought of as a “revision” to your project. To create a commit, you have to <code>add</code> the files to let Git know that we’re planning on saving the changes and then <code>commit</code> those changes. In order to sync the new commit with the Hugging Face Hub, you then <code>push</code> the commit to the Hub.",rt,ge,ut,ce,Dt="And you’re done! You can check your repository on Hugging Face with all the recently added files. For example, in the screenshot below the user added a number of files. Note that some files in this example have a size of <code>1.04 GB</code>, so the repo uses Git LFS to track it.",gt,_,Xt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repo_with_files.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repo_with_files-dark.png"/>',ct,fe,ft,me,Qt="Every time you go through the <code>add</code>-<code>commit</code>-<code>push</code> cycle, the repo will keep track of every change you’ve made to your files. The UI allows you to explore the model files and commits and to see the difference (also known as <em>diff</em>) introduced by each commit. To see the history, you can click on the <strong>History: X commits</strong> link.",mt,x,Et='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repo_history.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repo_history-dark.png"/>',ht,he,Ot="You can click on an individual commit to see what changes that commit introduced:",pt,H,Kt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/explore_history.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/explore_history-dark.gif"/>',dt,ye,yt;return L=new y({props:{title:"Getting Started with Repositories",local:"getting-started-with-repositories",headingTag:"h1"}}),U=new y({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),P=new pe({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwaHVnZ2luZ2ZhY2VfaHViJTBBaHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:`python -m pip install huggingface_hub
huggingface-cli login`,wrap:!1}}),J=new y({props:{title:"Creating a repository",local:"creating-a-repository",headingTag:"h2"}}),q=new y({props:{title:"Adding files to a repository (Web UI)",local:"adding-files-to-a-repository-web-ui",headingTag:"h2"}}),V=new y({props:{title:"Creating a new file",local:"creating-a-new-file",headingTag:"h3"}}),R=new y({props:{title:"Uploading a file",local:"uploading-a-file",headingTag:"h3"}}),D=new y({props:{title:"Adding files to a repository (terminal)",local:"terminal",headingTag:"h2"}}),X=new y({props:{title:"Cloning repositories",local:"cloning-repositories",headingTag:"h3"}}),E=new pe({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGJTNDeW91ci11c2VybmFtZSUzRSUyRiUzQ3lvdXItbW9kZWwtbmFtZSUzRSUwQWNkJTIwJTNDeW91ci1tb2RlbC1uYW1lJTNF",highlighted:`git <span class="hljs-built_in">clone</span> https://huggingface.co/&lt;your-username&gt;/&lt;your-model-name&gt;
<span class="hljs-built_in">cd</span> &lt;your-model-name&gt;`,wrap:!1}}),K=new pe({props:{code:"Z2l0JTIwY2xvbmUlMjBnaXQlNDBoZi5jbyUzQSUzQ3lvdXItdXNlcm5hbWUlM0UlMkYlM0N5b3VyLW1vZGVsLW5hbWUlM0UlMEFjZCUyMCUzQ3lvdXItbW9kZWwtbmFtZSUzRQ==",highlighted:`git <span class="hljs-built_in">clone</span> git@hf.co:&lt;your-username&gt;/&lt;your-model-name&gt;
<span class="hljs-built_in">cd</span> &lt;your-model-name&gt;`,wrap:!1}}),te=new y({props:{title:"Set up",local:"set-up",headingTag:"h3"}}),ne=new pe({props:{code:"Z2l0JTIwbGZzJTIwaW5zdGFsbA==",highlighted:"git lfs install",wrap:!1}}),ae=new pe({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbGZzLWVuYWJsZS1sYXJnZWZpbGVzJTIwLg==",highlighted:"huggingface-cli lfs-enable-largefiles .",wrap:!1}}),re=new y({props:{title:"Pushing files",local:"pushing-files",headingTag:"h3"}}),ge=new pe({props:{code:"JTIzJTIwQ3JlYXRlJTIwYW55JTIwZmlsZXMlMjB5b3UlMjBsaWtlISUyMFRoZW4uLi4lMEFnaXQlMjBhZGQlMjAuJTBBZ2l0JTIwY29tbWl0JTIwLW0lMjAlMjJGaXJzdCUyMG1vZGVsJTIwdmVyc2lvbiUyMiUyMCUyMCUyMyUyMFlvdSUyMGNhbiUyMGNob29zZSUyMGFueSUyMGRlc2NyaXB0aXZlJTIwbWVzc2FnZSUwQWdpdCUyMHB1c2g=",highlighted:`<span class="hljs-comment"># Create any files you like! Then...</span>
git add .
git commit -m <span class="hljs-string">&quot;First model version&quot;</span>  <span class="hljs-comment"># You can choose any descriptive message</span>
git push`,wrap:!1}}),fe=new y({props:{title:"Viewing a repo’s history",local:"viewing-a-repos-history",headingTag:"h2"}}),{c(){w=a("meta"),we=n(),de=a("p"),ve=n(),u(L.$$.fragment),$e=n(),C=a("p"),C.textContent=$t,be=n(),u(U.$$.fragment),Te=n(),I=a("p"),I.textContent=bt,Me=n(),j=a("p"),j.innerHTML=Tt,ke=n(),Z=a("p"),Z.innerHTML=Mt,_e=n(),u(P.$$.fragment),xe=n(),S=a("p"),S.innerHTML=kt,He=n(),d=a("iframe"),Le=n(),u(J.$$.fragment),Ce=n(),W=a("p"),W.innerHTML=xt,Ue=n(),z=a("ol"),z.innerHTML=Ht,Ie=n(),v=a("div"),v.innerHTML=Lt,je=n(),$=a("ol"),$.innerHTML=Ct,Ze=n(),G=a("p"),G.textContent=Ut,Pe=n(),b=a("div"),b.innerHTML=It,Se=n(),Y=a("p"),Y.innerHTML=jt,Je=n(),u(q.$$.fragment),We=n(),F=a("p"),F.innerHTML=Zt,ze=n(),T=a("div"),T.innerHTML=Pt,Ge=n(),u(V.$$.fragment),Ye=n(),B=a("p"),B.innerHTML=St,qe=n(),M=a("div"),M.innerHTML=Jt,Fe=n(),u(R.$$.fragment),Ve=n(),N=a("p"),N.innerHTML=Wt,Be=n(),k=a("div"),k.innerHTML=zt,Re=n(),A=a("p"),A.innerHTML=Gt,Ne=n(),u(D.$$.fragment),Ae=n(),u(X.$$.fragment),De=n(),Q=a("p"),Q.innerHTML=Yt,Xe=n(),u(E.$$.fragment),Qe=n(),O=a("p"),O.textContent=qt,Ee=n(),u(K.$$.fragment),Oe=n(),ee=a("p"),ee.innerHTML=Ft,Ke=n(),u(te.$$.fragment),et=n(),ie=a("p"),ie.textContent=Vt,tt=n(),le=a("p"),le.innerHTML=Bt,it=n(),u(ne.$$.fragment),lt=n(),se=a("p"),se.innerHTML=Rt,nt=n(),u(ae.$$.fragment),st=n(),oe=a("p"),oe.innerHTML=Nt,at=n(),u(re.$$.fragment),ot=n(),ue=a("p"),ue.innerHTML=At,rt=n(),u(ge.$$.fragment),ut=n(),ce=a("p"),ce.innerHTML=Dt,gt=n(),_=a("div"),_.innerHTML=Xt,ct=n(),u(fe.$$.fragment),ft=n(),me=a("p"),me.innerHTML=Qt,mt=n(),x=a("div"),x.innerHTML=Et,ht=n(),he=a("p"),he.textContent=Ot,pt=n(),H=a("div"),H.innerHTML=Kt,dt=n(),ye=a("p"),this.h()},l(e){const t=ai("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(i),we=s(e),de=o(e,"P",{}),wt(de).forEach(i),ve=s(e),g(L.$$.fragment,e),$e=s(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-18jeh08"&&(C.textContent=$t),be=s(e),g(U.$$.fragment,e),Te=s(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-jplm0f"&&(I.textContent=bt),Me=s(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-10onan1"&&(j.innerHTML=Tt),ke=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-10qq2kp"&&(Z.innerHTML=Mt),_e=s(e),g(P.$$.fragment,e),xe=s(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-m84aem"&&(S.innerHTML=kt),He=s(e),d=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),wt(d).forEach(i),Le=s(e),g(J.$$.fragment,e),Ce=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-9jw57k"&&(W.innerHTML=xt),Ue=s(e),z=o(e,"OL",{"data-svelte-h":!0}),r(z)!=="svelte-i0pqxh"&&(z.innerHTML=Ht),Ie=s(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-1329z6f"&&(v.innerHTML=Lt),je=s(e),$=o(e,"OL",{start:!0,"data-svelte-h":!0}),r($)!=="svelte-cmgrh3"&&($.innerHTML=Ct),Ze=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1glo7k3"&&(G.textContent=Ut),Pe=s(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-fylt99"&&(b.innerHTML=It),Se=s(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-5qfa79"&&(Y.innerHTML=jt),Je=s(e),g(q.$$.fragment,e),We=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-gg40nn"&&(F.innerHTML=Zt),ze=s(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-11fhgwf"&&(T.innerHTML=Pt),Ge=s(e),g(V.$$.fragment,e),Ye=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-klvs3g"&&(B.innerHTML=St),qe=s(e),M=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-1odm04p"&&(M.innerHTML=Jt),Fe=s(e),g(R.$$.fragment,e),Ve=s(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1pm9h7b"&&(N.innerHTML=Wt),Be=s(e),k=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(k)!=="svelte-1nct7w7"&&(k.innerHTML=zt),Re=s(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1m95obm"&&(A.innerHTML=Gt),Ne=s(e),g(D.$$.fragment,e),Ae=s(e),g(X.$$.fragment,e),De=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1q61s0k"&&(Q.innerHTML=Yt),Xe=s(e),g(E.$$.fragment,e),Qe=s(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-16y8plz"&&(O.textContent=qt),Ee=s(e),g(K.$$.fragment,e),Oe=s(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1wkndq8"&&(ee.innerHTML=Ft),Ke=s(e),g(te.$$.fragment,e),et=s(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-k823yx"&&(ie.textContent=Vt),tt=s(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-dwlaxn"&&(le.innerHTML=Bt),it=s(e),g(ne.$$.fragment,e),lt=s(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-155akwu"&&(se.innerHTML=Rt),nt=s(e),g(ae.$$.fragment,e),st=s(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-z9ipj4"&&(oe.innerHTML=Nt),at=s(e),g(re.$$.fragment,e),ot=s(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1xl5niv"&&(ue.innerHTML=At),rt=s(e),g(ge.$$.fragment,e),ut=s(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1jhxrbp"&&(ce.innerHTML=Dt),gt=s(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(_)!=="svelte-1vobd2z"&&(_.innerHTML=Xt),ct=s(e),g(fe.$$.fragment,e),ft=s(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-5ygnhh"&&(me.innerHTML=Qt),mt=s(e),x=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-19wszbb"&&(x.innerHTML=Et),ht=s(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1ww1ljh"&&(he.textContent=Ot),pt=s(e),H=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(H)!=="svelte-cdui6d"&&(H.innerHTML=Kt),dt=s(e),ye=o(e,"P",{}),wt(ye).forEach(i),this.h()},h(){c(w,"name","hf:doc:metadata"),c(w,"content",gi),c(d,"width","560"),c(d,"height","315"),ti(d.src,_t="https://www.youtube-nocookie.com/embed/rkCly_cbMBk")||c(d,"src",_t),c(d,"title","Managing a repo"),c(d,"frameborder","0"),c(d,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),d.allowFullscreen="",c(v,"class","flex justify-center"),c($,"start","2"),c(b,"class","flex justify-center"),c(T,"class","flex justify-center"),c(M,"class","flex justify-center"),c(k,"class","flex justify-center"),c(_,"class","flex justify-center"),c(x,"class","flex justify-center"),c(H,"class","flex justify-center")},m(e,t){oi(document.head,w),l(e,we,t),l(e,de,t),l(e,ve,t),f(L,e,t),l(e,$e,t),l(e,C,t),l(e,be,t),f(U,e,t),l(e,Te,t),l(e,I,t),l(e,Me,t),l(e,j,t),l(e,ke,t),l(e,Z,t),l(e,_e,t),f(P,e,t),l(e,xe,t),l(e,S,t),l(e,He,t),l(e,d,t),l(e,Le,t),f(J,e,t),l(e,Ce,t),l(e,W,t),l(e,Ue,t),l(e,z,t),l(e,Ie,t),l(e,v,t),l(e,je,t),l(e,$,t),l(e,Ze,t),l(e,G,t),l(e,Pe,t),l(e,b,t),l(e,Se,t),l(e,Y,t),l(e,Je,t),f(q,e,t),l(e,We,t),l(e,F,t),l(e,ze,t),l(e,T,t),l(e,Ge,t),f(V,e,t),l(e,Ye,t),l(e,B,t),l(e,qe,t),l(e,M,t),l(e,Fe,t),f(R,e,t),l(e,Ve,t),l(e,N,t),l(e,Be,t),l(e,k,t),l(e,Re,t),l(e,A,t),l(e,Ne,t),f(D,e,t),l(e,Ae,t),f(X,e,t),l(e,De,t),l(e,Q,t),l(e,Xe,t),f(E,e,t),l(e,Qe,t),l(e,O,t),l(e,Ee,t),f(K,e,t),l(e,Oe,t),l(e,ee,t),l(e,Ke,t),f(te,e,t),l(e,et,t),l(e,ie,t),l(e,tt,t),l(e,le,t),l(e,it,t),f(ne,e,t),l(e,lt,t),l(e,se,t),l(e,nt,t),f(ae,e,t),l(e,st,t),l(e,oe,t),l(e,at,t),f(re,e,t),l(e,ot,t),l(e,ue,t),l(e,rt,t),f(ge,e,t),l(e,ut,t),l(e,ce,t),l(e,gt,t),l(e,_,t),l(e,ct,t),f(fe,e,t),l(e,ft,t),l(e,me,t),l(e,mt,t),l(e,x,t),l(e,ht,t),l(e,he,t),l(e,pt,t),l(e,H,t),l(e,dt,t),l(e,ye,t),yt=!0},p:ii,i(e){yt||(m(L.$$.fragment,e),m(U.$$.fragment,e),m(P.$$.fragment,e),m(J.$$.fragment,e),m(q.$$.fragment,e),m(V.$$.fragment,e),m(R.$$.fragment,e),m(D.$$.fragment,e),m(X.$$.fragment,e),m(E.$$.fragment,e),m(K.$$.fragment,e),m(te.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(re.$$.fragment,e),m(ge.$$.fragment,e),m(fe.$$.fragment,e),yt=!0)},o(e){h(L.$$.fragment,e),h(U.$$.fragment,e),h(P.$$.fragment,e),h(J.$$.fragment,e),h(q.$$.fragment,e),h(V.$$.fragment,e),h(R.$$.fragment,e),h(D.$$.fragment,e),h(X.$$.fragment,e),h(E.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(ge.$$.fragment,e),h(fe.$$.fragment,e),yt=!1},d(e){e&&(i(we),i(de),i(ve),i($e),i(C),i(be),i(Te),i(I),i(Me),i(j),i(ke),i(Z),i(_e),i(xe),i(S),i(He),i(d),i(Le),i(Ce),i(W),i(Ue),i(z),i(Ie),i(v),i(je),i($),i(Ze),i(G),i(Pe),i(b),i(Se),i(Y),i(Je),i(We),i(F),i(ze),i(T),i(Ge),i(Ye),i(B),i(qe),i(M),i(Fe),i(Ve),i(N),i(Be),i(k),i(Re),i(A),i(Ne),i(Ae),i(De),i(Q),i(Xe),i(Qe),i(O),i(Ee),i(Oe),i(ee),i(Ke),i(et),i(ie),i(tt),i(le),i(it),i(lt),i(se),i(nt),i(st),i(oe),i(at),i(ot),i(ue),i(rt),i(ut),i(ce),i(gt),i(_),i(ct),i(ft),i(me),i(mt),i(x),i(ht),i(he),i(pt),i(H),i(dt),i(ye)),i(w),p(L,e),p(U,e),p(P,e),p(J,e),p(q,e),p(V,e),p(R,e),p(D,e),p(X,e),p(E,e),p(K,e),p(te,e),p(ne,e),p(ae,e),p(re,e),p(ge,e),p(fe,e)}}}const gi='{"title":"Getting Started with Repositories","local":"getting-started-with-repositories","sections":[{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Creating a repository","local":"creating-a-repository","sections":[],"depth":2},{"title":"Adding files to a repository (Web UI)","local":"adding-files-to-a-repository-web-ui","sections":[{"title":"Creating a new file","local":"creating-a-new-file","sections":[],"depth":3},{"title":"Uploading a file","local":"uploading-a-file","sections":[],"depth":3}],"depth":2},{"title":"Adding files to a repository (terminal)","local":"terminal","sections":[{"title":"Cloning repositories","local":"cloning-repositories","sections":[],"depth":3},{"title":"Set up","local":"set-up","sections":[],"depth":3},{"title":"Pushing files","local":"pushing-files","sections":[],"depth":3}],"depth":2},{"title":"Viewing a repo’s history","local":"viewing-a-repos-history","sections":[],"depth":2}],"depth":1}';function ci(vt){return li(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ri}),[]}class di extends ni{constructor(w){super(),si(this,w,ci,ui,ei,{})}}export{di as component};
