On Mar. 21, the American Medical Association (AMA), along with dozens of other industry leaders, delivered an open letter to the Centers for Medicare and Medicaid (CMS), asking for an Administrative Burden category for exemptions to MACRA penalties.
The letter stated that current reporting programs are inadequate to keep up with the quality reporting requirements of MACRA and the 21st Century Cures Act. The signers of the letter believe that the administrative burdens of the newly implemented requirements are too overwhelming to fully comply with by Mar. 31, 2018.
What are these organizations asking for?
The letter specifically addresses meaningful use (MU), the physician quality reporting system (PQRS) and value-based payment modifiers (VM). In 2017, organizations need to provide a minimum amount of reporting data in order to avoid negative payment adjustments in 2019. To qualify for positive payment adjustments, organizations must meet specific reporting goals as laid out by CMS.
“Oct. 2, 2017 is the deadline for starting to collect data.”
Currently, organizations have until Oct. 2, 2017 to begin sending data to CMS. Reports must cover at least 90 days. Failing to submit the minimum amount of data by the 2018 deadline may result in a negative payment adjustment.
“Consequently, we urge the Administration to take a series of steps to address these same challenges in MU, PQRS and VM prior to their replacement by MACRA and minimize the penalties assessed for physicians who tried to participate in these programs,” stated the letter.
Physicians lacking the necessary reporting systems struggle to produce reports that meet CMS standards, increasing the risk of future penalties.
CMS has yet to formally respond to the request for an Administrative Burden exemption.
How can organizations make reporting improvements today?
Unfortunately, organizations cannot wait long for a response. Time is rapidly ticking down to the Oct. 2 deadline for beginning the reporting process. Waiting for an exemption that may never come will only drive up risk. Organizations with thin profit margins cannot face that kind of risk, which means it’s time to start developing a plan of action.
Investing in reporting solutions today could help organizations avoid Medicare penalties in the future. The formula is simple:
Improve your reporting platform today, protect – and possibly augment – your revenue in 2019.
If you’re worried about future penalties, the easiest step to take is to find an affordable way to submit the bare minimum reporting data in 2017. According to CMS, providing 90 days of data for a single quality measure or improvement activity is enough to avoid penalties and may even garner a positive adjustment.
Example: Care transition documentation practice improvements
One of the many improvement activities organizations may submit data for is improving documentation of care transition. This activity requires MIPS-qualified providers to document how they carried out a patient-centered action plan for the first 30 days following a discharge. These activities may include phone calls, home visits and providing patients information.
Organizations with customized technology solutions can complete this task easily by pulling data from a patient engagement system into a report they would then forward to CMS. Doing so not only helps organizations avoid penalties, but also improves patient engagement.
Even if CMS implements the Administrative Burden, the exemption wouldn’t stop penalization – it would only push penalties back further. The best solution is to invest in reporting solutions today so that you can get the highest positive payment adjustment in the future. By 2022, organizations stand to gain up to a 9 percent increase in payment adjustments from CMS.