.
They understand that they must plan both for a long life and for the non-medical health care needs that are likely to arise as they age. In my work with advisors who have decided to bring LTC insurance into their practices, I hear a variety of reasons for adding the competency. The last advisor I worked with chose this time specifically because it’s an election year. We agreed that the imperative for people to plan will be heightened. The candidates will effectively do our marketing for us, as they talk about the lack of sustainability of the current Medicare, Medicaid and Social Security infrastructure.
The climate of fiscal concern combined with unprecedented numbers of people approaching retirement brings tremendous opportunity. To help you explore whether to add LTCI to your core products, let’s explore some long-term care news and review the basics of designing a great policy.
Why LTCI could take off
In October 2011, Health and Human Services Secretary Kathleen Sebelius announced the Obama administration was pulling the plug on health care reform’s Community Living Assistance Services and Supports Act (CLASS).
CLASS was meant to provide employed Americans a long-term care insurance-like program. The program required no medical exam or health questions, and the law demanded that CLASS be fiscally self-sustaining (not relying on taxpayer money) and actuarially sound for a 75-year time period.
Many in the insurance industry doubted the ability of the program to meet all these requirements, and the Obama administration finally came to the same conclusion. The abandonment of CLASS’ program implementation offers a poignant reminder to the public and to members of the insurance, health care and financial industries alike: it is crucial for consumers to be in the driver’s seat of their own long-term care planning, to not wait to plan, hoping for a government program.
Another significant development in 2011 was the tremendous expansion of partnership states. A partnership policy is designed to allow policyholders to receive Medicaid long-term care benefits once their LTCI policies are exhausted, while retaining assets that would otherwise need to be spent down. Although partnership is not a new concept, it was only available in a handful of states until two years ago. Now, 38 states have partnership policies available for sale.
The federal government has, for many years, offered tax incentives on the purchase of qualified LTCI policies. In addition, most states offer incentives for purchasers of long-term care insurance.
For premiums paid by an individual, deductibility is determined by combining premium payments (subject to age-based limits) with unreimbursed medical expenses. If the total exceeds 7.5% of the taxpayer’s adjusted gross income, the premium may be deductible for taxpayers who itemize. The following chart displays age-based limits on long-term care insurance deductibility:
Companies may deduct long-term care insurance payments made for employees, their spouses and dependents. There is no requirement that the insurance be provided on a non-discriminatory basis, and the deduction is not limited to the age-based numbers shown in the chart.
The increasing cost of care
As motivating as tax incentives can be, it’s rarely the motivating factor for someone to purchase a policy. Often, the motivation is something a bit more personal, such as the impact a need for long-term care would have on a consumer’s retirement finances and legacy planning. People who have witnessed a friend or family member who needed extended care are predisposed to purchasing insurance. They have witnessed firsthand the surprise when someone realizes that none of their traditional insurances covers long-term care. While no one enjoys a surprise bill of any sort, for many, the ultimate, unwanted financial surprise is the cost of long-term care.
Since Medicare does sometimes pay for long-term care in the right situation, many people still mistakenly think that Medicare will take care of their future long-term care needs, no matter the circumstance or duration. Medicare has a limited skilled care (nursing home) benefit under certain conditions (100 days of care at a maximum) and a skilled care home care benefit under still different conditions (limited to medically necessary, non-daily visits that follow a hospital stay only). What most do not realize is that the vast majority of long-term care is not skilled, medically necessary care, but custodial care — meaning nonmedical care. Medicare, Medicare supplements and health insurance are not designed to cover nonmedical care. Long-term care insurance is the only insurance designed to cover the costs of nonmedical care.
And these costs are high. The 2011 Genworth Cost of Care Survey examined the cost data on long-term care for every state. On the national level, the 2011 median hourly rate for a licensed home health aide was $19 ($152 for an eight-hour shift). The national median cost of an assisted living facility unit (one bedroom, single occupancy) was $3,261 per month. The national median rate for a private room in a nursing home was $193 per day (or $5,790 a month). Imagine how quickly this will eat through the average consumer’s retirement fund. The risk is, arguably, one that most Americans cannot afford without insurance.
In his book “Fooled by Randomness,” risk engineering professor and financial guru Nassim Nicholas Taleb writes, “It is not how likely an event is that matters…it is the magnitude of the outcome that counts.” Most Americans buckle their seatbelts, just in case. They purchase fire insurance for their homes. They get an annual physical with their doctor. They are willing to endure minor inconveniences and expenses because they believe the magnitude of the risk in not taking action just doesn’t make sense. It’s time long-term care planning received the same diligence. Luckily, it’s easy for an agent to either begin to design and sell LTCI or to partner with an LTCI specialist.
The past few years have been exciting in the field of long-term care insurance. If you are not yet bringing up long-term care planning to your clients, 2012 is the perfect time to change that!
By Denise Jaehnke, CEPP, CLTC
From the February 01, 2012 issue of Life Insurance Selling
Denise Jaehnke, CEPP, CLTC, is president of Extended Personal Service Ltd