By Nash Swamy
Hedge funds have long been the envy of the investment industry, with complex and precisely executed trading strategies. While access to this group of funds remains with a select few, often institutional mandates or high net worth individuals, their presence is always felt and known by the average investor. But how have hedge funds been performing? The average investor often hears about the success of these rarefied funds, in the hope of being able to achieve similar returns. This year’s Canadian Hedge Funds Awards night, produced by Alternative IQ and sponsored in part by Fundata, is coming up on Oct. 16. So in this article I’ll lift the veil of mystery just a bit, and take a look at what made some of last year’s award-winners tick.
Hedge funds are an essential tool for diversification of an investment portfolio, especially when markets are volatile and move in zig-zag patterns. You might have noticed a recent spate of articles with the general theme of “the return of volatility.” While this is one signal of market behavior, it can also be a call for investors to consider hedge funds and alternative strategies.
The ratio of advancers-to-decliners in the past few years has been high, in essence testing the competence of hedge fund managers who consistently pursue long-short strategies. When the market is continually moving up, long-short strategies can be challenging. A fund might post high returns on its long positions, but these returns are cannibalized by the relatively low or even negative returns from short positions. This is possible in the market we have grown used to, where there is no volatility and markets continued to move in only one direction, up.
As we look forward to this year’s CHFA Awards, it might be useful to look back at the past performance of some of Canada’s premier hedge funds in 2017. Listed in the table and graph below are selected hedge funds that were showcased for their 1-year return track record in their respective categories.
The slope of return over risk is analyzed to categorize performance to yield one unit return for every unit of risk an investor accepts. Picton Mahoney manager Philip Mesman has been able to use his investment mandate to achieve alpha leading to a slope greater than 1 for its investors, being the top-performing fund amongst its peers.
Shown in the table and graph below are a select few hedge funds that were showcased for the 5-year return track record in their respective categories.
Note the Barometer Global Macro Pool is included for its exceptional performance in both 1-year and 5-year categories.
Notable here is that the CC&L mandate uses an internal team dedicated to analyzing 12,000 stocks across developed and emerging equity markets daily on various quantitative factors.
Donville Kent Capital Ideas Fund posted an impressive 12.79% return with an annualized standard deviation of 7.63%. The fund equates to a slope of 1.68, being the top-performing fund among its peers in the 5-year category.
I spoke recently with Jesse Gamble, a portfolio manager at a Toronto-based hedge fund Donville Kent Asset Management, to find out what factors enabled the Donville Kent Capital Ideas Fund to rank among the best hedge funds in Canada:
“What makes a good company is return on equity. We believe in the theory of reinvestment and compound returns,” said Gamble. “What creates a high ROE business is stable and improving margins at the company level. These companies offer an attractive risk-to-reward ratio as a byproduct of selecting excellent companies, hence effectively managing risk,” he added.
According to Gamble, “While ROE is such a key metric, most managers simply look at profit and not ROE. Gauging the stability of ROE is incredibly important here at DKAM where we boil down the components and perform a DuPont analysis to see where the accretion and dilution in growth is coming from. We also take it one step further by looking at long-term contracts, margins, if the company has high barriers to entry, and what type of market in which it operates.
In addition to crunching the numbers, DKAM also focuses on corporate management. “We like to know that the management of these superstar companies speak our language,” says Gamble. “We need to know that management knows and understands the company and industry,” he added.
Gamble concludes that this type of in-depth research “will help facilitate management to effectively deploy capital to offer high returns for shareholders. This is how we continue to excel in the hedge fund space and offer great returns to our investors.”
Achieving high risk-adjusted returns is challenging in an extremely competitive hedge fund universe. But with strong quantitative and qualitative analysis, as well as looking beyond profitability and attractive top and bottom numbers, you may be able to invest in something worth multiple times what the market has priced for such companies.