The United States, France and Britain called a meeting of the United Nations Security Council on Thursday to press for “immediate action” to secure the delivery of humanitarian aid to besieged areas of Syria. The supposedly heartfelt humanitarian concerns of the three imperialist powers that are currently bombing Syria came amid a concerted propaganda campaign over alleged starvation in the southwestern Syrian town of Madaya.
Originating with Al Jazeera, the news agency controlled by the Qatari monarchy, a key source of financial and arms support for the Al Qaeda-linked militias that have ravaged much of Syria, the invocation of Madaya as proof of the supposed inhumanity of the Syrian government of President Bashar al-Assad has been taken up by much of the world media. The New York Times published a front-page report Friday on conditions in the town, based on accounts that the newspaper said “could not be independently confirmed.”
There is no reason to doubt that conditions are desperate in Madaya, as they are in much of Syria after more than four years of a sectarian civil war fomented and provisioned by US imperialism and its regional allies, including Saudi Arabia, Turkey and Qatar. As many as 4.5 million Syrians are in areas that have been cut off from the rest of the country by the battle lines.
If Madaya is the focus of international attention, however, it is because it is encircled by Syrian government forces along with their allies from the Lebanese Hezbollah militia. The town sits at a strategic juncture near the Lebanese border and less than 25 miles from the capital, Damascus.
In the international furor being whipped up over conditions in Madaya, including through the use of photographs of starving people taken elsewhere, little attention is given to the fact that the town is largely controlled by the al-Nusra Front, Al Qaeda’s Syrian affiliate, and Ahrar al-Sham, a similar Salafist jihadi militia.
While conditions of hunger in the town are routinely attributed to the government siege, residents have reported that food supplies have been monopolized by the Al Qaeda-linked groups, which sell them at extortionate prices to finance their operations. On October 18, the International Committee of the Red Cross delivered two months’ worth of food supplies to Madaya, with the government doing nothing to impede humanitarian access to the town. That many are facing hunger is largely attributable to the looting of the aid shipment by US-backed “rebels.”
While the imperialist powers and their media accomplices are directing all eyes to Madaya, they have wholly ignored equally if not more desperate conditions in the predominantly Shia towns of Kefraya and al-Foua in the northwestern province of Idlib, which have been under attack by the US-backed “rebels” since 2011 and under a total siege since March of last year. Starved of supplies and under constant attack, the town has seen 1,700 civilian residents killed.
The indifference of the imperialist powers to hunger and suffering among populations under siege by their proxy forces demonstrates that the invocation of starvation is just one more bid to promote a war for regime change as some kind of humanitarian intervention.
Today marks the 25th anniversary of the launching of the first Gulf War against Iraq in 1991. Then, as now, phony pretexts were floated by the US government and echoed and amplified by the corporate media to justify a predatory war for control of the Middle East and its strategic oil resources. In this regard, little has changed over the course of a quarter century of uninterrupted American militarism in the region.
In 1991, it should be recalled, the public was told of marauding Iraqi troops snatching Kuwaiti babies out of incubators and leaving them to die in order to ship the devices back to Iraq. A tearful volunteer nurse was brought to Capitol Hill to testify on this atrocity, which seemed to echo World War I propaganda about German soldiers using Belgian babies for bayonet practice.
Only well after the US invasion was it revealed that the “nurse” was, in fact, the daughter of the Kuwaiti ambassador to the US and a member of the oil sheikdom’s royal family, and that the incubator story was a propaganda hoax from start to finish.
In the years that followed, the US imposed draconian sanctions upon Iraq that led to real starvation and unchecked disease. According to some estimates, the sanctions led to the deaths of as many as 500,000 Iraqi children due to a lack of food, medicine and uncontaminated water resulting from the imperialist blockade. Confronted with this appalling death toll in a 1996 television interview, Madeleine Albright, who was then the US ambassador to the UN and soon to be secretary of state, responded, “We think the price is worth it.”
This is the same government now shedding crocodile tears over the alleged use of hunger as a weapon by the Syrian government.
Since then, the United States has annihilated over a million people in the invasion and occupation of Iraq, killed tens of thousands more in the US-NATO war to overthrow Libya’s Muammar Gaddafi, and orchestrated the war in Syria that has left an estimated 260,000 dead and displaced half of the country’s population. These interventions have thrown all three countries and their social infrastructures into a state of collapse.
The recklessness and brutality of the US ruling oligarchy’s militarist attempts to impose its hegemony over the Middle East and the entire planet go hand-in-hand with its destructive role within the US itself, smashing up the country’s industrial base, destroying the jobs and living standards of the working class, and funneling the bulk of the nation’s wealth to a handful of financial parasites.
Neither the escalation of the war for regime change in Syria, nor, for that matter, the toppling of Assad will extricate American capitalism from its insoluble crisis. The unending eruption of American militarism will produce only more death and destruction, intensifying the crisis both at home and abroad and bringing humanity ever closer to a global conflagration.