If you want to get funded, don’t ask for “even a dollar.”
So you’ve got the next big indie game idea and all you need is a little bit of startup capital to get things going. Like so many other entrepreneurs, artists, and dreamers, you set up a Kickstarter page to raise the necessary funds.
But despite the undeniable brilliance of your idea (seriously, it’s just so amazing!) the crowdfunding campaign fails. What possibly could have gone wrong?
According to a new study from the Georgia Institute of Technology, it may have been the words you used in your pitch. Researchers have created a list of phrases and words that appear to be the keys to understanding Kickstarter success.
It may not seem like a big deal, but the difference between a phrase like “pledged” and “has pledged” can have major ramifications when it comes to the success of crowdfunding campaigns. In many cases, it come down to basic principles of persuasion, according to Eric Gilbert, a faculty member at Georgia Tech’s School of Interactive Computing.
“Our research revealed that the phrases used in successful Kickstarter campaigns exhibited general persuasion principles,” Gilbert said. “For example, those campaigns that follow the concept of reciprocity–that is, offer a gift in return for a pledge–and the perceptions of social participation and authority, generated the greatest amount of funding.”
Gilbert and his research partner Tanushree Mitra examined 45,000 crowdfunded projects, analyzing 9 million phrases while controlling for 59 other variables known to influence Kickstarter success. Not only did language make a difference, it was one of the biggest factors contributing to success or failure. The researchers found that 58.56 percent of the variance in successful funding was related to word choice.
So what kind of language should you use on Kickstarter? There are several guidelines to keep in mind, said Gilbert and Mitra. The idea that donors will be justly rewarded for their contributions is essential. Thus phrases like “mention your,” “pledgers will,” and “all supporters,” were found to strongly correlate with successful campaigns. On the flipside, phrases like “volunteers to,” “need one,” and “provide us” have all been linked to unsuccessful campaigns.
The study also finds that successful campaigns employ language that fosters a sense of scarcity, which is known create the perception of value. That’s how researchers account for the success of terms like “given the chance.”
The researchers also found that social influence can play a significant role. People are more likely to donate when there is a perception that others in an identified social group are doing the same.
“[S]ocial identity theory posits that people identify themselves with a group when they perceive they have attributes in common,” the researchers write in a paper detailing their findings. “These perceptions can then influence later decisions and choices.”
So it comes as no surprise that phrases like “two friends” and “as people” are linked with prosperous fundraising efforts. Even a term like “the Brooklyn”—which is found among the top terms correlating with success—can tap into the strong identity associated with that borough of New York City.
But what about the terms associated with failed campaigns? They tend to sound desperate, the researchers found. The old saying that “everybody likes a winner” is true. Lucrative fundraising campaigns often use language that makes it sound like the project will definitely succeed. Unsuccessful fundraising efforts on the other hand often use phrases like “need one” and “even a dollar,” which can come off like grovelling.
“These phrases highlight the interesting ways in which raw (computer mediated communications) text can expose real world social behaviors,” the authors of the study conclude.
Here’s the full list of phrases most closely associated with crowdfunding success and failure:
This is not the first time academic researchers have taken an interest in Kickstarter. Many have taken on the challenge of figuring out the probability of a campaign’s success. Last year, Swiss researchers claimed to have devised a method for determining whether a Kickstarter campaign will reach its ultimate goal after less than four hours on the site.
H/T Motherboard | Photo by 401(K) 2012/Flickr
Pure, uncut internet. Straight to your inbox.
