Sometimes, you need someone else to help with your state or federal taxes. When that happens, you’ll need to fill out a power of attorney form to give them the authority to access your records, tax information, and to act on your behalf.
While there are specialized forms that are just for taxes, there are also plenty of cases where you can use a general power of attorney form, or a state-specific tax power of attorney form to do the same thing.
These power of attorney forms are different from Federal IRS Form 2848, which is a specialized federal form for tax representatives. Form 2848 is usually the more powerful option, and a few states only use form 2848. This article is going to focus on the alternatives, but if you’re looking for form 2848, we’ve covered it as well. Or, if you want to read about power of attorney in general, click here.
There are lots of reasons you might want to use a state tax power of attorney. State power of attorney for taxes lets the person you designate access tax documents and may even allow them to file taxes on your behalf.
We’ll go more into what kinds of authority a POA will grant in a moment, though.
Tax POAs are relatively common, so don’t worry if you realize you need one. They can be helpful for anyone who knows that they will be very busy during tax season, especially if they might be out of the country on business or holiday.
It’s also useful if you have any upcoming medical procedures that might make it more difficult to fill out your tax forms. It’s important to consider if you have an upcoming surgery or are undergoing long-term treatments that can interfere with day-to-day life like cancer treatment.
It’s also common to use a state tax POA if you’re hiring someone else to take care of your taxes. Some tax professionals will ask for a POA or form 2848 before handling your tax information as an extra layer of protection for both of you.
You can also potentially use a tax power of attorney to bring in a tax professional to help if your taxes are audited, or if you have to negotiate terms of repayment on back taxes. Having a professional on your side can make the whole process much easier, and can help you find the relevant documents to get the best possible deal.
You may also want to consider a tax power of attorney if you’re dealing with multiple kinds of taxes, like taxes on your income and taxes on a recent inheritance. Anytime your taxes are more complicated than usual, it can be helpful to bring in a tax professional or qualified lawyer to help you fill out the forms and make sure you’re receiving the best possible return.
There are also several other forms that you may fill out in addition to your POA, but since generalized POA forms are more customizable than other options, you can add a lot of those powers and authorizations on the main form.
However, it’s important to make sure you check your state’s law about tax POA. Some states primarily use federal form 2848, while other states will have their own specialized kinds of tax POA or limitations on the kinds of power that can be granted with a tax POA.
One of the main advantages of using a POA form is that you can customize the kinds of authority you’re granting. You can also potentially use one POA for more than just tax purposes if you would like to make someone your agent or attorney-in-fact for other circumstances as well.
Like the specific form needed to be used, you’ll also need to check with your state’s laws to see if they require a tax-specific POA or if you can include other powers on the same form.
Depending on the state, you may be able to designate a wide range of tax powers, including but not limited to:
All of these powers are subject to local legislation though, so you may not be able to grant all of these powers if your state prohibits it.
With a general POA form, you can also customize what powers you are granting. For instance, your tax professional might not want some of the powers we’ve listed depending on what their professional policies are.
Or you can authorize someone to access your tax record and other tax information but not authorize them to sign or file your return on your behalf. That way they can help you prepare your taxes but can’t file them until you are available to look over the return and sign.
In some cases, you might need two different forms for your federal and state taxes, especially if your state is using a state-specific form instead of form 2848 or a generalized POA. Even if you can use the same forms for both sets of taxes you may have to customize the powers you are granting so that your agent can work on both sets of taxes.
That’s because your federal and state tax records are generally kept separate, and you’ll file them separately as well. Your state may also have a different set of regulations than federal tax regulations and will almost certainly have different tax breaks.
Having a tax professional on your side can help you determine what federal tax bracket you are under, as well as your state tax bracket unless you live in a state with a flat income tax.
No matter what your circumstances, having a tax POA authorized agent on your side can make tax season a lot less stressful.