Wisconsin’s Central Sands provides a great diversity of food crops. It is one of our country’s most important vegetable production areas, and also one of our most diverse. Our farmers do grow USDA program crops like field corn and soybeans, but the Central Sands acreage is overwhelmed by a broad mixture of vegetables and specialty crops. We grow potatoes of all kinds—russets for baking and fries, reds and yellows for salads and many other purposes (yes baking too), round whites for chips, even sweet potatoes are grown in the Central Sands. Sweet corn, green beans, peas, carrots, peppers, cucumbers and beets dot the landscape. Most of our vegetable crops are bound for processing plants (canned and frozen) within Wisconsin then distributed across the US and to other countries around the globe. Fresh vegetables are also available to you at local farmer markets and grocery stores. We are working on expanding this area of production as the market calls for them. This crop diversity provides consumers everything from crunchy pickles and spicy relish, cranberry sauces and juices to fresh table potatoes for every meal event, locally grown in Central Wisconsin. Did you know that Wisconsin is also the nation’s largest supplier of cranberries?
This diverse collection of crops combine to make the Central Sands one of the top vegetable and specialty crop production areas in the US and a key component in the nation’s food security. This variety of crops also creates a complicated production scheme on the farm. Each crop has specific needs and presents unique production and marketing challenges. It would be easier to grow just one type of crop. However, through research and education, farmers have learned that the very differences that make growing such a diverse mixture of crops challenging, also creates advantages. Each crop has its own set of pests and unique nutrient needs, and if crops are grown continuously, without a rotation program, pests specific to that crop, quickly build to high levels and nutrients diminish. Through research, farmers have learned to use crop differences to pit pest against pest by rotating crops on their land each growing season. This crop rotation, changing pest hosts, makes survival of the pest more difficult while benefiting crops by building up soil nutrients. Some plants use a lot of nutrients, while others add them, or make them available for crop use. This crop rotation plan of growing different crop types in different locations is an essential component in long term sustainability. There are many examples where crop rotations prevent pest buildup, and each crop can provide positive benefits to the crops that follow it:
- Alfalfa provides nitrogen to potatoes.
- Dairy manure and crop residues build organic matter and soil health.
- Corn reduces nightshade weeds for potatoes.
- Potatoes reduce root rots in peas and green beans
- Cover crops reduce nematodes for potatoes.
Any single advantage gained from crop rotation may not be vital, but together they combine to establish a sustainable, naturally-based foundation that keeps pests at manageable levels, maintains soil health and structures as well as nutrient availability, which helps secure a safe, reliable supply of high quality produce at affordable prices. Take a drive through this diverse agricultural landscape and know that it’s not only beautiful, but also essential to the security of our nation’s food supply.
Duane W. Maatz, Executive Director WPVGA