Premature ovarian failure (POF) is when a woman's ovaries stop working before she is 40., though many health care providers suggest taking hormones until age 50. According to the International Premature Ovarian Failure Association, between 1 and 4% of women suffer from POF – equivalent to between 250,000 and 1 million women in the USA alone.
A group of researchers have been able to restore ovarian function to rats suffering from POF, which may lead to treating women with POF in the future. The researchers, led byprofessor Osama Azmy of the National Research Center in Cairo, used embryonic rat stem cells (Mesenchymal stem cells - MSCs) to restore ovary function in the experimental rats. Mesenchyme, or mesenchymal connective tissue, is a type of loose connective tissue, located within the embryo . Cells derived from the mesenchyme are capable of developing into a variety of tissues.
They studied 60 mature female rats. The rats were divided into 4 groups. The first group (group 1) was the control group, which was given no treatment. The rest of the rats, groups 2-4, were given a chemical to induce ovarian failure with 15 rats in each group.
Group 2 had ovarian failure, but then was treated with MSC injections. Male Stem cells were used, so that the exact location of the stem cells could subsequently be detected by looking for the presence of a Y chromosome. Group 3 had ovarian failure, and was injected with a saline solution. Group 4 had ovarian failure and was not treated.
The researchers also monitored the levels of FSH (follicle-Stimulating Hormone) and 17β estradiol, to see if hormone levels of the treated rats returned to normal.
Within 2 weeks, the rats in the experimental group had regained fully-functioning ovaries. After 8 weeks, the hormone levels of the rats in the treated group (group 2) were the same as those rats which did not have ovarian failure (group 1). The researchers were able to detect the presence of the MSCs in the ovaries of the rats by confirming the local presence of a Y chromosome.
About the results, Azmy said, “This work shows that Mesenchymal Stem Cells can restore ovarian function..”
This work is presented at IFFS 2010, which is the World Congress on Fertility and Sterility, Munich 12-16 September.
ABSTRACT
"Stem cells restored ovarian function and folliculogenesis in rats following induced Ovarian failure", Azmy O.M., Taha T.F., Ali A., Atta H.
Introduction: Premature ovarian failure (POF) is a heterogenous syndrome affecting 1% of women below the age of 40 years and 0.1% before 30 years. Infertility is a major problem that affects these women and currently no treatment is available that effectively increases fertility. Mesenchymal stem cells (MSCs) represent a promising tool for new clinical concepts in supporting cellular therapy.
Aim: The aim of this experimental animal study was to explore the therapeutic potency of MSC transplantation for chemotherapy-induced ovarian damage in rats.
Materials and methods: This was a prospective case control experimental animal study. Sixty mature female rats were studied. Fifteen rats served as a control group (group I). 45 rats were injected by intraperitoneal cyclophosphamide (CTX). The study group was subdivided into 3 equal groups (group II, III and IV). Rats of group II were injected intravenously by male MSC, while group III by saline and group IV did not receive any injections. The rats were followed up for eight weeks by daily vaginal smear and biweekly E2 and FSH levels to monitor the ovarian activity. PCR was done to look for sry gene expression and Y chromosome incorporation into the ovarian tissues. Two rats were sacrificed every 2 weeks for histopathological examination for the ovarian tissues.
Results: Ovarian failure was achieved in the study group by two weeks. The hypoestrogenic and hypergonadotropic state was reversed in the group that received MSC injection by the eighth week. There was no statistical difference between group 1 and 2 after 8 weeks of follow up as regards the mean serum FSH (3.60 ± 0.08 mIU/ mL vs. 5.38 ± 0.31 mIU/mL; P=0.1, respectively) and E2 levels (69.71±1.26 vs. 53.5±0.93 pg/mL, P=0.2; respectively) . Also, cytological and Histopathological examinations showed resurrection of ovarian folliculogenesis and corpus luteum formation in group II and such changes were
not observed in the other groups. The (sry) gene expression of the Y chromosome was detected within the ovarian tissues in group II.
Conclusions: stem cells have the power of recovering ovarian function both in its hormonal and follicular development abilities. Our work has proved that this principle is achieved mainly by incorporation of stem cells into the ovarian structure and not merely by the paracrine effect.
Mesenchymal Stem Cells Shown To Restore Non-Functioning Ovaries
By News Staff | September 15th 2010 02:03 PM | 2 comments | Print | E-mail | Track Comments
Two women, one with premature ovarian failure and one with perimenopause had fetal stem cell transplantation done peripherally. After 18 weeks, neither showed signs of ovarian recovery or renewed fertility.
Anonymous (not verified) | 11/30/11 | 00:19 AM
- Link