The group exhibition “The Racing Will Continue, The Dancing Will Stay,” curated by Leo Li Chen and presented by Guangdong Times Museum, took China’s reform and post-reform era as its starting point. Showcasing works that delve into this period of societal transformations, which saw the rapid development of China’s entertainment industry, athletics, and urban infrastructure, the show investigated how individuals navigated the balancing act between their own identities and that of collective society amid such shifts.
The center of the gallery accommodated works that explore theatricality. New Neighbour (2019), Li Ran’s newly commissioned installation, is an open, two-level stage, replete with inbuilt staircases and props such as a mop, trashcan, and coat. In the absence of performers, Li invites viewers to take the stage and act out his script. Adapted from He Jiping’s 1984 drama Good Fortune Building, Li’s play includes a series of domestic conflicts that occur within a building in Hong Kong. While He’s script argues that the city’s adoption of capitalism led to alienation and inequality among its people, Li investigates the differences between individuals, and the frustrations that the households in this building share. He allows participants to embody the perspectives of different characters, and thus closely consider the dynamics of capitalist societies. Another immersive work was Yao Qingmei’s three-channel video installation Molt (Body Inspection) (2017). In the left projection, a female dancer performs a striptease, while a security officer—symbolizing censorship—enacts robotic movements as part of what is meant to be a “security check” on the right. The screen in the middle shows a choir—similar to the chorus in Greek plays—solemnly singing the line “Big Brother is watching you.” During a pause, the performers across all three screens stare at the audience, creating a sealed, panoptic environment where the viewer is scrutinized by the collective.
The body was further foregrounded in works concerned with sports. Clustered in one section of the gallery, these artworks probe how individuals wrestle against uniformity. Xin Yunpeng’s two-channel video installation documents a group of secondary school students practicing boxing during an annual military training camp, while Gao Lei highlights the vulnerability of the body by fashioning parallel bars used in gymnastics—often a part of military exercises—out of the nylon material that is used to make prosthetic limbs, in G-350 (2013). Both works reflect on how an individual’s body can be disciplined for a specific function through repeated training. In the same section, Wang Bo’s installation shifted the focus to the internal struggle of an athlete. The Orbit (2019) recreates the Los Angeles hotel room that the professional tennis player Hu Na was staying in while competing for the 1982 Federation Cup. During the tournament, Hu decided to leave the national team and seek political asylum in the United States. Wang’s installation delineates how Hu’s freedom was gained through her departure from the orbit of the collective, at the cost of her never being able to return home.
The displays at the gallery’s opposite end examined how individuals have made personal spaces for themselves within the nation’s landscapes. Chen Wei’s An Advertisement About the Future (2019) depicts the clichéd slogan “Building Your Future,” seen in numerous real-estate advertisements. The installation was juxtaposed with Chen’s “S” (2018), a photo of a spiral staircase in a partially deconstructed Beijing building. The decrepit scene is a reminder of how property developers fail to fulfil people’s expectations of a better life, and instead build lies and illusions. Also commenting on failed promises for the future are South Ho Siu Nam’s photos of Hong Kong’s 2014 Umbrella Movement, when peaceful protests for universal suffrage were ignored by the city’s governors. Depicting helmets, water bottles, and rolls of tissues on the street, but no people, the images convey the insignificance of individuals within the fabric of society.
Through explorations of body and space, and how they collide and interact with each other, “The Racing Will Continue, The Dancing Will Stay” evinced the responses of individuals to the collective ethos of a transformative time..