By Kizito Sikuka
With clear agricultural policies such as access to inputs including seeds and fertiliser, as well as credit facilities and extension services, smallholder farmers have the capacity to increase production, as has been the case in China.
Agriculture has been identified by Africa as a priority development area in the China-Africa strategic partnership.
The agricultural sector is regarded as an engine for socio-economic development in most African countries.
According to the African Union (AU), agriculture accounts for about one-third of the continent's Gross Domestic Product (GDP), and more than two-thirds of its citizens rely directly on the sector for their livelihood.
Cognisant of the important role of agriculture in the development agenda, Africa is redoubling its efforts to invest more in the sector and boost production.
However, the task of transforming agriculture is generally not an easy one. Similar to the struggle for independence, the agricultural drive also requires much more efforts from within Africa as well as outside, particularly from those that have successfully transformed their agricultural sector.
One country that has managed to record impressive progress in the agricultural sector is China. Other notable countries in this regard include Argentine, Brazil, India and Tanzania.
From struggling to feed its growing population, China now ranks among the leaders in worldwide farm output, although accounting for less than 10 percent of arable land worldwide.
On the other hand, Africa continues to experience some challenges in improving its agricultural sector, yet the continent is endowed with fertile soils, a favourable climate and affluent water basin.
So what are the lessons and opportunities for development between China and Africa as the latter has clearly demonstrated to the rest of the world that socio-economic development is possible through agricultural development.
One opportunity lies in knowledge and technology transfer and sharing, which is explicitly outlined in the Forum on China-Africa Co-operation (Focac) launched in 2000 and in each three-year plan ever since, where the two sides have agreed to work together in boosting agricultural production in Africa and ensuring food security for its citizens.
For example, China pledged to train agricultural technicians and management personnel as well as build agricultural technology demonstration centres in Africa, and had done so in many countries.
This commitment is based on the fact that China has achieved an impressive agricultural growth from investment in agriculture research including the development of high-yielding, well-adapted lowland seed varieties, as well as appropriate fertiliser application, and farming machinery to boost production.
In this regard, Africa should upscale the use of research in agriculture and not rely on cultivating more land and mobilising a larger labour force to increase production.
So far, at least 15 agricultural technology demonstration centres built by China are operational in African countries, in Benin, Cameroon, Democratic Republic of Congo, Ethiopia, Liberia, Madagascar, Malawi, Mozambique, United Republic of Tanzania, Togo, Sudan, Uganda, Rwanda, Zambia and Zimbabwe. Five more centres are expected to be built in countries such as Mali.
The agricultural technology demonstration centre in Zimbabwe has trained more than 3 000 farmers since it started operations in 2012.
Another important area for China-Africa co-operation in the agricultural sector is infrastructure development, particularly irrigation, transport network and storage facilities.
Noting that the country had limited land for agriculture, China embarked on a massive drive to ensure that it maximises the little land it had for greater output by embracing the use of irrigation.
This is in contrast with Africa where less than 10 percent of the arable land is under irrigation yet the continent is home to more than half of the world's arable land.
As a result of the irrigation drive, China is able to conduct its farming activities all year around. It will be critical for Africa to also embrace and heavily invest in irrigation development, and not heavily rely on climatic conditions, because lower precipitation would mean lower yield.
Africa has the capacity to increase its irrigation uptake as the continent is hugely endowed with watercourses such as the seven major river systems of Congo, Limpopo, Niger, Nile, Orange, Senegal and Zambezi.
Investment in road and rail upgrades will ensure that agricultural produce moves smoothly from one place to another, while establishment of more storage facilities will allow farmers to store their harvest for use in poor seasons.
According to the UN Food and Agriculture Organisation post-harvest crop losses are estimated to be as high as 40 percent in Africa, so storage is a challenge to be resolved.
In addition to infrastructure development, agricultural co-operation between China and Africa should target smallholder farmers, who are the majority.
With clear agricultural policies such as access to inputs including seeds and fertiliser, as well as credit facilities and extension services, smallholder farmers have the capacity to increase production, as has been the case in China.
Access to extension services is also critical for planning purposes, especially when farmers want to diversify into new crops or livestock.
Another important lesson from Chinese agricultural development is that China was aware that agricultural policy implementations come at a cost.
Therefore, they were patient with their policies noting that agricultural development should first be aimed at achieving food security before achieving socio-economic development.
As a result, agricultural development was an incremental learning process, meaning that any policy was first implemented on a smaller scale, and only when it was successful was it then replicated in other areas as opposed to implementing unproven methods on a larger scale.
Furthermore, significant agricultural reforms in China were deeply rooted in fully implementing all agreed policies, and the task for African countries is to transform its initiatives into actual implementation.
These initiatives include the African Union's Comprehensive Africa Agriculture Development Programme (CAADP), which encourages countries to reach a higher path of economic growth through agriculture-led development by allocating at least 10 percent of their national budgets to the agricultural sector each year.
This article from the Southern African Research and Documentation Centre (SARDC) through its Institute for China-Africa Studies in Southern Africa, is part of a series exploring the dimensions of China Africa relations in advance of the Focac Summit to be held in Johannesburg in early December.