You design and build a workholding fixture. Then you install it on the machine, load the new program, and set up the tooling. Soon you are making parts to print and all finishes look great.
With confidence, you hand the job over to the production team. Then things turn ugly. The machine that you just handed over crashed and crashed hard. What happened? After a little investigating you come to the conclusion that one of the bigger drills was dull and pushed the part out of the fixture. Although your fixture developed plenty of clamping pressure, you overestimated the security of the workholding. When drills start to lose their edge the forces can increase by more than 100 percent.
The fixtures were built precisely, and all part locating surfaces were ground to a nice smooth finish. This is good for precision, but terrible for gripping. Oily coolant doesn't help either. What to do?
Rob Freyvogel, president of Frey Research (Renfrew, Pennsylvania) suggests that surface micro keying will solve the problem. "It occurs when the clamping surface actually penetrates the part surface with many small peaks," he says. "We are not talking about a serrated gripper, as many times the unsightly tooling marks would make them impractical. We are talking about adding a thin, consistent, textured layer of carbide ranging from 40 to 320 emery equivalent."
The process of adding carbide to the surface is referred to as Carbinite coating. Carbinite is a carbide alloy coating which is metallurgically bonded to tooling using a process called electrofusion. The primary function of Carbinite is to increase or decrease the coefficient of friction between tool and workpiece with a secondary benefit of wear reduction.
One test showed that vise jaws coated with an 80 emery grit carbide withstood approximately twice the force to move a 7075 aluminum block being held with the same force in standard ground jaws. In another test, Chick Workholding Solutions (Warrendale, Pennsylvania) found that it took over three times the force to move a piece of 7075 aluminum extrusion in Carbinite coated jaws versus standard ground jaws.
There are a number of advantages to using Carbinite coated grippers. The coatings are very reasonable in cost and can be applied and reapplied (without stripping the prior layer) to existing tooling or features. It can be applied to all steels including stainless, 6061 and 7075 aluminum.
Even better, Carbinite coating increases tool life and increases tool performance. It allows higher feed rates due to more secure workholding. Or, increased friction allows work to be held with less clamping pressure.
This example shows how this capability can work: Gaff International (Mexico City) had a fixture built to hold many 5.75- by 2-inch diameter workpieces made from 1018 steel stock. Large flats were to be milled onto both ends of the pins before drilling 0.656-inch diameter mounting holes. The challenge presented to Carlos Bertrand of Chaparral Machinery was to supply a complete manufacturing solution that would be cost effective in an environment where labor was relatively inexpensive.
The system was designed to use a Fadal 4020 vertical machining center fit with a Midaco pallet changer. Fixtures were to hold as many parts as possible to reduce tool changes and avoid having the spindle cut too much air. To keep the spindle running, part change time had to be minimal, as machining time per pallet would be only about 30 minutes. Parts had to be held very securely as the full horsepower of the spindle would be used to cut the flats on the pins.
Initial layouts showed that each pallet could hold 30 parts. A simple profiled fixture with a profiled strap clamp that would straddle two parts seemed to be the obvious choice in fixture design. The anticipated problem was that under the heavy load of milling the flats, the parts would spin in the fixture.
The solution was to apply Carbinite coating to the fixture base with a four-pad arrangement. The application of Carbinite created raised, textured pads that increased the coefficient of friction and provided the security that was needed to guard against the problem of workpiece slippage. This fixture was design with only one 5/8-11 screw holding down a pair of the 2-inch diameter bars.
The project was a resounding success with all parties involved pleased with the results. To this day, there have been no problems with the parts moving in the fixture, even when the inserts in the 2-inch cutter get dull. Holding bars this way would never have been practical without the Carbinite pads.