The Road More Traveled: Patent Attorneys Head to Delaware
Jan. 29, 2018
San Francisco-based patent attorney Richard Hung never found an easy way to travel to eastern Texas to litigate patent cases.
But like hundreds of patent attorneys across the U.S., he had to. The U.S. District Court for the Eastern District of Texas was once the most popular venue for patent infringement lawsuits in the country.
A partner at Morrison & Foerster, LLP and co-chair of the firm’s Intellectual Property Litigation Group, Hung would spend at least six hours hopping through airports to the regional business hub in Shreveport, La., then drive west on I-20 for 35 miles. Once, when a return flight from Shreveport was canceled, he was forced to drive more than 200 miles to Houston to fly home.
Things may be getting easier since the U.S. Supreme Court’s May 2017 decision in TC Heartland LLC v. Kraft Foods Grp. Brands LLC.
“Instead of traveling to east Texas, we’re traveling to Delaware,” Hung said. “It’s a little more geographically convenient.”
The shift to filing patent infringement cases in the U.S. District Court for the District of Delaware instead of in Texas isn’t without consequences, though. Patent infringement cases in Delaware are said to be backlogging, and there are potential delay times to trial.
In Delaware, Cases Surge
The TC Heartland decision, which held that a domestic corporation “resides” only in its state of incorporation, upended nearly 30 years of precedent in patent law and dramatically restricted where patent cases may be litigated. Previously, the rules for where a patent infringement lawsuit could be filed made it easy to select the east Texas court, which had a reputation for being a friendly venue for patent owners.
The result: patent infringement complaints filed in east Texas have dropped by nearly 50 percent since the Supreme Court ruled. Those filed in Delaware’s federal court, where two-thirds of the Fortune 500 are incorporated, have surged.
But law firms were ready for the shift, patent attorneys at the nation’s top firms told Bloomberg Law. Many firms already had Delaware offices or well-established relationships with local counsel, and patent attorneys were already used to teaming up on cases and flying all over the country.
Christian Mammen, a partner and patent litigator in the San Francisco office of Hogan Lovells, says that patent litigation is “a national practice.”
However, legal recruiters at Major, Lindsey and Africa (MLA) said that while there hasn’t been an increased demand for patent litigators in Delaware itself, there has been an uptick in demand in nearby cities.
Darin R. Morgan, managing partner of the firm’s Philadelphia office and a partner in Washington, D.C., has seen some increased demand for patent litigation positions in D.C. and Philadelphia over the past six months, he told Bloomberg Law, but “nothing in Delaware.”
We Were Ready
Texas-based law firm Baker Botts LLP has been gearing up for something like TC Heartland for at least a decade, according to Bart Showalter, chair of the firm’s 180-lawyer Intellectual Property Department he runs out of Dallas.
Patent holding companies swarmed into east Texas with patent complaints ten years ago, but the frenzy began to slow about five years later, and in the past two or three years, the profitability of such cases has waned, Showalter said.
In response to the changes, Baker Botts over time expanded its IP practices, opening offices in Palo Alto, Calif., San Francisco, New York, and Washington to serve Delaware and the International Trade Commission (ITC).
“TC Heartland, to us, was kind of inevitable,” Showalter told Bloomberg Law. “We had already, way before TC Heartland, placed bets on the West Coast, the East Coast, and the ITC.”
Need for Speed
The biggest impact of TC Heartland, attorneys said, lies in strategic discussions around venue, as more and more plaintiffs go to Delaware.
There are growing concerns about a possible backlog in the Delaware court. Delaware averaged about 46 new patent complaints per month before the TC Heartland ruling. Afterward, Delaware’s per-month average jumped to about 78.
“The potential delay in time to trial is certainly part of the discussion” when deciding where to bring a case, Morrison & Foerster’s Hung said. “Plaintiffs typically want a faster trial.”
TC Heartland might also push a few more cases to the International Trade Commission (ITC) or the U.S. Patent and Trademark Office’s Patent Trial and Appeal Board (PTAB), said Andrew Thomases, intellectual property litigation partner and co-chair for Ropes & Gray LLP.
The ITC process is very fast, and one reason some people filed cases in the Eastern District of Texas is that it was known for speed, Thomases said. “So if Texas is not available, you might think about going to the ITC if you want a quick result or want to pressure a party to settle,” he said.
More Motions, Discovery
Compared to the Eastern District of Texas, patent cases filed in Delaware will generally have a higher chance of being resolved on motions or through settlement, said Blaine H. Evanson, a litigation partner at Gibson, Dunn & Crutcher in Los Angeles and Orange County, Calif.
However, some cases filed in Delaware or California could become more costly, as judges there are more likely to allow for more extended discovery, Evanson said.
Still, the overall burdens on attorneys, defendants, witnesses, and other parties will likely be reduced, since Delaware and California are generally more convenient venues than the Eastern District of Texas, Evanson said.
“Flying lawyers and witnesses from all over the country to Marshall, Texas is a burden on almost everyone.”
To contact the reporter on this story: Leslie A. Pappas in Philadelphia at lpappas@bloomberglaw.com
To contact the editor responsible for this story: Mike Wilczek at mwilczek@bloomberglaw.com