X-rays probe the origins of hotspot volcanoes
Researchers in France have added a new twist to one of the most controversial debates in geophysics – how "hotspot" volcanoes such as the Hawaiian Islands are formed. By probing hot, pressurized rock samples with intense X-rays, they have shown that molten rock deep within the Earth's mantle should be buoyant. This finding, the researchers say, supports the much-debated hypothesis that hotspot volcanoes are created by deep plumes of rock rising almost 3000 km to the Earth's surface.
In geology, "hotspots" are regions of high volcanic activity that are not located at a tectonic plate boundary and are thought to be fed by underlying mantle that is anomalously hot compared with the mantle elsewhere. Hot plumes originating from the boundary between the Earth's outer core and lower mantle were first proposed in 1971 to explain volcanic regions that do not fit the theory of plate tectonics. The Hawaiian volcano chain, for instance, is located far from any plate boundaries, and so it has been suggested that it forms as the Pacific plate moves over a hotspot that is fed by a deep-seated mantle plume. Similar plumes have been proposed to explain volcanic activity in places as diverse as Iceland, Siberia and India's Deccan Plateau.
Many predictions of the mantle-plume hypothesis, however, remain unconfirmed, prompting some geophysicists to develop an alternative model. The "plate hypothesis" involves much shallower processes such as internal deformations within tectonic plates that would allow magma to leak upwards from the upper mantle. Over the past decade, this model has attracted a dedicated army of supporters, creating a schism that today divides the geophysics community.
Hell on Earth
Now, a team of researchers led by Denis Andrault, a mineral physicist at Blaise Pascal University in Clermont-Ferrand, France, has tested one of the key requirements of the plume hypothesis: that molten rock at the core–mantle boundary should be buoyant enough to move upwards. To investigate this, the researchers set about recreating the hellish conditions found 2900 km below the Earth's surface.
At the European Synchrotron Radiation Facility in Grenoble, tiny specks of rock nearly 10 times thinner than a human hair were compressed between the tips of two conical diamonds, subjecting the samples to immense pressures of up to 120 gigapascals. Then, infrared lasers heated the samples to temperatures as high as 4000 °C. "All of our observations show that the melting of the rocks follows the same laws of physics and chemistry as the melting of much larger samples," says Andrault, "so the results can be confidently transferred from the micron scale up to the kilometre scale."
Next, the samples were mapped and probed using a high-pressure X-ray beam. By analysing the X-ray diffraction patterns and fluorescence spectra, the researchers determined the chemical compositions of the regions where the rock had melted or remained solid. This allowed them to calculate the distribution of iron between the solid and liquid phases – crucial for determining the buoyancy of the molten rock.
Sink or swim?
Andrault and colleagues discovered that the molten rock contained about twice as much iron as the solid rock. Combining this result with the liquid's expected silica content, the researchers concluded that the melt would be buoyant."“If there was a lot more iron in the liquid, as suggested in previous work, then the density of the molten rock would be significantly higher and the magma would sink towards the core–mantle boundary," says Andrault. "This is not the case."
Instead, Andrault proposes that the buoyant rock moves towards the Earth's surface – an idea that tallies with the mantle-plume hypothesis. "The melt could penetrate through the mantle by at least two different mechanisms," says Andrault. "One is related to the size of the liquid pond: if it is big enough, gravitational forces will finally succeed in moving the liquid upwards. Another mechanism involves the dissolution of mantle material at one end of the liquid drop and recrystallization at the other end, resulting in a progression of the liquid."
Plumes versus plates
But not everyone is convinced. "The melt may be more buoyant than previously thought," says Gillian Foulger of Durham University in the UK. "But melts don't just zoom up like water in a plumbing pipe. They're reabsorbed, they mix with other melts, they're trapped, and they have to get through the transition zone." Furthermore, she adds, the mantle-plume hypothesis involves solid materials, not liquids, convecting towards the surface.
Andrault admits that the fate of the liquid during its travel upwards is uncertain. "Still," he says, "even if the liquid did crystallize, its composition and temperature would be very different from the mantle, and the material would likely be buoyant thanks to its relatively high silica content."
So how might the "plumes versus plates" debate be resolved? Foulger believes that scientists need to test the predictions of the plume hypothesis at the Earth's surface, looking for the geochemical signatures of lavas that have risen from the deep. Others believe that the answer lies in using large arrays of high-resolution, ocean-bottom seismometers to search for evidence of these ascending plumes. Either way, the debate is likely to rumble on for some time yet.
The research is described in Nature.
About the author
James Lloyd is a UK-based science writer
Origins of hotspots and volcanoes.