Are You Selling Your People Short?
Change the way you view employees' talents, and you'll better appreciate their value
Does your organization focus too intensely on employees' weaknesses -- or worse, use belittling terms to speak about their strengths?
In the corporate world, managers routinely subject employees to performance reviews that emphasize their "areas for improvement," not their talents. The problem with this approach is that by focusing on weaknesses, organizations fail to capitalize on their employees' strengths.
To inspire exceptional performance, organizations must reverse this lens so they can better see, understand, and more effectively deploy every individual's innate drives and abilities. This means focusing on each employee's natural and unique ways of thinking, feeling, and behaving: his or her talents.
When organizations begin to emphasize talents -- and adopt a positive language to identify them, such as the 34 talent themes measured by the Clifton StrengthsFinder -- they transform conversations, relationships, and most importantly, performance, all for the better. Rather than denigrating a hard-charging employee by labeling her as "impatient," we can understand that she has powerful talents in the Activator theme. Instead of mocking Juan as a "schmoozer" or a "phony," we can recognize his talents in Winning Others Over (the Woo theme). Is Sally "bossy"? Or does she simply possess exceptional Command talents?
Terms such as "impatient," "phony," or "bossy" are what we'd call "barrier labels." They are barriers to understanding -- and to developing and celebrating -- what people naturally do best. Juan's Woo talents or Sally's Command may be untapped assets for your company. Juan very well could be your next sales star, and Sally might be management material. But are barrier labels preventing you from seeing and tapping their potential?
Try to understand barrier labels through your own experience. Jot down one of your top talent themes, or write down words or phrases that others sometimes use to compliment you, such as "He's so inspiring" or "She's a great source of information." Now, think about barrier labels that people have used to give a negative connotation to the same qualities, such as "He has his head in the clouds" or "She's such a bookworm." You'll probably find that many of your greatest talents are often negatively labeled -- and those labels don't help you make the most of your talents, do they?
The "workaholic"
Jerry, a participant in a recent strengths development program for salespeople, is a very talented Achiever. But he explained that he was also burdened with a barrier label: "workaholic." Indeed, Jerry said that even his wife, Anne, often used that negative term to describe him, especially when she felt that he wasn't spending enough time with her or their two children.
With this label in place, the only solution either of them could imagine was for Jerry to spend less time at work, which can be very difficult for an Achiever. For Jerry, less time in the office would mean fewer opportunities to accomplish things. That would make him miserable, and eventually, he would go back to working long hours. But that would, in turn, make his family miserable. Obviously, this solution was no solution.
At home after the workshop, Jerry sat down with Anne to talk about this problem. As Jerry described how his Achiever talents naturally make him think, feel, and behave, Anne experienced a revelation: Jerry's Achiever talents represent not only an exceptional ability to achieve, but also a need to achieve. He is internally driven to do more and accomplish more, and he invariably feels fulfilled by those achievements. Jerry's talents are an undeniable part of him. They cannot be "turned off"; they pull him toward opportunities to achieve.
Enlightened by this discovery, Jerry and Anne forged a plan. Jerry would now look for opportunities to achieve at home. How? For starters, two nights a week, he would help get the kids bathed and ready for bed -- no small achievement. And each week, the couple would make a list of at least three family activities for the weekend, such as bike rides or trips to the grocery store. Jerry's assignment was to make these activities happen. This arrangement was perfect for him; checking off the items on his family's "to do" list gave him a real sense of achievement as a father and a husband.
Jerry has applied an additional tactic. By starting his day an hour earlier and answering crucial e-mails before the family gets up, many mornings he can have breakfast with them. And now that Anne sees Jerry's Achiever talents as an asset, she is much more understanding and flexible and more interested in Jerry's work. She no longer sees him as a "workaholic." Instead, she sees him as an Achiever -- both at home and at work.
It's no coincidence that Jerry reports being more productive and engaged at work. With the balance between home and work restored, he now sees a long-term future with his company, and he no longer feels pangs of guilt when he has to work extra-long days.
The "gossip"
Claire is another example. During a management program, she realized she had been dealing with a barrier label. Claire's manager, Sue, had long ago labeled her the "group gossip." It was a running joke at the office, and Claire had fun with it as well. Then the group took the Clifton StrengthsFinder and discovered each of their top five talent themes. For Claire, Communication is number one.
When Sue learned about Claire's top theme, she said, "Now I understand why you are always talking with others -- and more importantly, I see how I can use that to help all of us stay connected." After their discussion, Sue started briefing Claire every Monday on key messages that needed to be shared with the group. Both Claire and Sue love this arrangement, and the team is more informed than ever.
Looking beyond barrier labels allows managers to tap a vast amount of underused potential in their employees. So the next time you place a barrier label on an employee -- or on yourself -- ask yourself a couple of important questions: "What is really driving that behavior?" and "How could that behavior be used in a positive way?" That is the first step to inspiring greater performance.